(function() { var define = undefined; return (function outer(modules, cache, entry) {
  if (Bokeh != null) {
    for (var name in modules) {
      Bokeh.require.modules[name] = modules[name];
    }

    for (var i = 0; i < entry.length; i++) {
      var plugin = Bokeh.require(entry[0]);
      Bokeh.Models.register_models(plugin.models);

      for (var name in plugin) {
        if (name !== "models") {
          Bokeh[name] = plugin[name];
        }
      }
    }
  } else {
    throw new Error("Cannot find Bokeh. You have to load it prior to loading plugins.");
  }
})
({"models/widgets/abstract_button":[function(require,module,exports){
"use strict";
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var p = require("../../core/properties");
var build_views_1 = require("../../core/build_views");
var widget_1 = require("./widget");
var button_template_1 = require("./button_template");
exports.AbstractButtonView = (function (superClass) {
    extend(AbstractButtonView, superClass);
    function AbstractButtonView() {
        return AbstractButtonView.__super__.constructor.apply(this, arguments);
    }
    AbstractButtonView.prototype.events = {
        "click": "change_input"
    };
    AbstractButtonView.prototype.template = button_template_1.default;
    AbstractButtonView.prototype.initialize = function (options) {
        AbstractButtonView.__super__.initialize.call(this, options);
        this.icon_views = {};
        this.listenTo(this.model, 'change', this.render);
        return this.render();
    };
    AbstractButtonView.prototype.render = function () {
        var $button, html, icon, key, ref, val;
        AbstractButtonView.__super__.render.call(this);
        icon = this.model.icon;
        if (icon != null) {
            build_views_1.build_views(this.icon_views, [icon]);
            ref = this.icon_views;
            for (key in ref) {
                if (!hasProp.call(ref, key))
                    continue;
                val = ref[key];
                val.$el.detach();
            }
        }
        this.$el.empty();
        html = this.template(this.model.attributes);
        this.$el.append(html);
        $button = this.$el.find('button');
        if (icon != null) {
            $button.prepend("&nbsp;");
            $button.prepend(this.icon_views[icon.id].$el);
        }
        $button.prop("disabled", this.model.disabled);
        return this;
    };
    AbstractButtonView.prototype.change_input = function () {
        var ref;
        return (ref = this.model.callback) != null ? ref.execute(this.model) : void 0;
    };
    return AbstractButtonView;
})(widget_1.WidgetView);
exports.AbstractButton = (function (superClass) {
    extend(AbstractButton, superClass);
    function AbstractButton() {
        return AbstractButton.__super__.constructor.apply(this, arguments);
    }
    AbstractButton.prototype.type = "AbstractButton";
    AbstractButton.prototype.default_view = exports.AbstractButtonView;
    AbstractButton.define({
        callback: [p.Instance],
        label: [p.String, "Button"],
        icon: [p.Instance],
        button_type: [p.String, "default"]
    });
    return AbstractButton;
})(widget_1.Widget);

},{"../../core/build_views":"core/build_views","../../core/properties":"core/properties","./button_template":"models/widgets/button_template","./widget":"models/widgets/widget"}],"models/widgets/abstract_icon":[function(require,module,exports){
"use strict";
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var widget_1 = require("./widget");
exports.AbstractIcon = (function (superClass) {
    extend(AbstractIcon, superClass);
    function AbstractIcon() {
        return AbstractIcon.__super__.constructor.apply(this, arguments);
    }
    AbstractIcon.prototype.type = "AbstractIcon";
    return AbstractIcon;
})(widget_1.Widget);

},{"./widget":"models/widgets/widget"}],"models/widgets/autocomplete_input":[function(require,module,exports){
"use strict";
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
require("jquery-ui/autocomplete");
var text_input_1 = require("./text_input");
var p = require("../../core/properties");
exports.AutocompleteInputView = (function (superClass) {
    extend(AutocompleteInputView, superClass);
    function AutocompleteInputView() {
        return AutocompleteInputView.__super__.constructor.apply(this, arguments);
    }
    AutocompleteInputView.prototype.render = function () {
        var $input;
        AutocompleteInputView.__super__.render.call(this);
        $input = this.$el.find("input");
        $input.autocomplete({
            source: this.model.completions
        });
        $input.autocomplete("widget").addClass("bk-autocomplete-input");
        return this;
    };
    return AutocompleteInputView;
})(text_input_1.TextInputView);
exports.AutocompleteInput = (function (superClass) {
    extend(AutocompleteInput, superClass);
    function AutocompleteInput() {
        return AutocompleteInput.__super__.constructor.apply(this, arguments);
    }
    AutocompleteInput.prototype.type = "AutocompleteInput";
    AutocompleteInput.prototype.default_view = exports.AutocompleteInputView;
    AutocompleteInput.define({
        completions: [p.Array, []]
    });
    return AutocompleteInput;
})(text_input_1.TextInput);

},{"../../core/properties":"core/properties","./text_input":"models/widgets/text_input","jquery-ui/autocomplete":"jquery-ui/autocomplete"}],"models/widgets/button":[function(require,module,exports){
"use strict";
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var p = require("../../core/properties");
var abstract_button_1 = require("./abstract_button");
exports.ButtonView = (function (superClass) {
    extend(ButtonView, superClass);
    function ButtonView() {
        return ButtonView.__super__.constructor.apply(this, arguments);
    }
    ButtonView.prototype.change_input = function () {
        this.model.clicks = this.model.clicks + 1;
        return ButtonView.__super__.change_input.call(this);
    };
    return ButtonView;
})(abstract_button_1.AbstractButtonView);
exports.Button = (function (superClass) {
    extend(Button, superClass);
    function Button() {
        return Button.__super__.constructor.apply(this, arguments);
    }
    Button.prototype.type = "Button";
    Button.prototype.default_view = exports.ButtonView;
    Button.define({
        clicks: [p.Number, 0]
    });
    return Button;
})(abstract_button_1.AbstractButton);

},{"../../core/properties":"core/properties","./abstract_button":"models/widgets/abstract_button"}],"models/widgets/button_group_template":[function(require,module,exports){
"use strict";
var DOM = require("../../core/util/dom");
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = function () {
    return DOM.createElement("div", { class: "bk-bs-btn-group", "data-bk-bs-toggle": "buttons" });
};

},{"../../core/util/dom":"core/util/dom"}],"models/widgets/button_template":[function(require,module,exports){
"use strict";
var DOM = require("../../core/util/dom");
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = function (props) {
    return (DOM.createElement("button", { type: "button", class: "bk-bs-btn bk-bs-btn-" + props.button_type }, props.label));
};

},{"../../core/util/dom":"core/util/dom"}],"models/widgets/cell_editors":[function(require,module,exports){
"use strict";
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var _ = require("underscore");
var $ = require("jquery");
require("jquery-ui/autocomplete");
require("jquery-ui/spinner");
var p = require("../../core/properties");
var bokeh_view_1 = require("../../core/bokeh_view");
var model_1 = require("../../model");
exports.CellEditorView = (function (superClass) {
    extend(CellEditorView, superClass);
    function CellEditorView() {
        return CellEditorView.__super__.constructor.apply(this, arguments);
    }
    CellEditorView.prototype.tagName = "div";
    CellEditorView.prototype.className = "bk-cell-editor";
    CellEditorView.prototype.input = null;
    CellEditorView.prototype.emptyValue = null;
    CellEditorView.prototype.defaultValue = null;
    CellEditorView.prototype.initialize = function (args) {
        this.args = args;
        this.model = this.args.column.editor;
        CellEditorView.__super__.initialize.call(this);
        return this.render();
    };
    CellEditorView.prototype.render = function () {
        CellEditorView.__super__.render.call(this);
        this.$el.appendTo(this.args.container);
        this.$input = $(this.input);
        this.$el.append(this.$input);
        this.renderEditor();
        this.disableNavigation();
        return this;
    };
    CellEditorView.prototype.renderEditor = function () { };
    CellEditorView.prototype.disableNavigation = function () {
        return this.$input.keydown((function (_this) {
            return function (event) {
                var stop;
                stop = function () {
                    return event.stopImmediatePropagation();
                };
                switch (event.keyCode) {
                    case $.ui.keyCode.LEFT:
                        return stop();
                    case $.ui.keyCode.RIGHT:
                        return stop();
                    case $.ui.keyCode.UP:
                        return stop();
                    case $.ui.keyCode.DOWN:
                        return stop();
                    case $.ui.keyCode.PAGE_UP:
                        return stop();
                    case $.ui.keyCode.PAGE_DOWN:
                        return stop();
                }
            };
        })(this));
    };
    CellEditorView.prototype.destroy = function () {
        return this.remove();
    };
    CellEditorView.prototype.focus = function () {
        return this.$input.focus();
    };
    CellEditorView.prototype.show = function () { };
    CellEditorView.prototype.hide = function () { };
    CellEditorView.prototype.position = function () { };
    CellEditorView.prototype.getValue = function () {
        return this.$input.val();
    };
    CellEditorView.prototype.setValue = function (val) {
        return this.$input.val(val);
    };
    CellEditorView.prototype.serializeValue = function () {
        return this.getValue();
    };
    CellEditorView.prototype.isValueChanged = function () {
        return !(this.getValue() === "" && (this.defaultValue == null)) && (this.getValue() !== this.defaultValue);
    };
    CellEditorView.prototype.applyValue = function (item, state) {
        return this.args.grid.getData().setField(item.index, this.args.column.field, state);
    };
    CellEditorView.prototype.loadValue = function (item) {
        var value;
        value = item[this.args.column.field];
        this.defaultValue = value != null ? value : this.emptyValue;
        return this.setValue(this.defaultValue);
    };
    CellEditorView.prototype.validateValue = function (value) {
        var result;
        if (this.args.column.validator) {
            result = this.args.column.validator(value);
            if (!result.valid) {
                return result;
            }
        }
        return {
            valid: true,
            msg: null
        };
    };
    CellEditorView.prototype.validate = function () {
        return this.validateValue(this.getValue());
    };
    return CellEditorView;
})(bokeh_view_1.BokehView);
exports.CellEditor = (function (superClass) {
    extend(CellEditor, superClass);
    function CellEditor() {
        return CellEditor.__super__.constructor.apply(this, arguments);
    }
    CellEditor.prototype.type = "CellEditor";
    CellEditor.prototype.default_view = exports.CellEditorView;
    return CellEditor;
})(model_1.Model);
exports.StringEditorView = (function (superClass) {
    extend(StringEditorView, superClass);
    function StringEditorView() {
        return StringEditorView.__super__.constructor.apply(this, arguments);
    }
    StringEditorView.prototype.emptyValue = "";
    StringEditorView.prototype.input = '<input type="text" />';
    StringEditorView.prototype.renderEditor = function () {
        var completions;
        completions = this.model.completions;
        if (!_.isEmpty(completions)) {
            this.$input.autocomplete({
                source: completions
            });
            this.$input.autocomplete("widget").addClass("bk-cell-editor-completion");
        }
        return this.$input.focus().select();
    };
    StringEditorView.prototype.loadValue = function (item) {
        StringEditorView.__super__.loadValue.call(this, item);
        this.$input[0].defaultValue = this.defaultValue;
        return this.$input.select();
    };
    return StringEditorView;
})(exports.CellEditorView);
exports.StringEditor = (function (superClass) {
    extend(StringEditor, superClass);
    function StringEditor() {
        return StringEditor.__super__.constructor.apply(this, arguments);
    }
    StringEditor.prototype.type = 'StringEditor';
    StringEditor.prototype.default_view = exports.StringEditorView;
    StringEditor.define({
        completions: [p.Array, []]
    });
    return StringEditor;
})(exports.CellEditor);
exports.TextEditorView = (function (superClass) {
    extend(TextEditorView, superClass);
    function TextEditorView() {
        return TextEditorView.__super__.constructor.apply(this, arguments);
    }
    return TextEditorView;
})(exports.CellEditorView);
exports.TextEditor = (function (superClass) {
    extend(TextEditor, superClass);
    function TextEditor() {
        return TextEditor.__super__.constructor.apply(this, arguments);
    }
    TextEditor.prototype.type = 'TextEditor';
    TextEditor.prototype.default_view = exports.TextEditorView;
    return TextEditor;
})(exports.CellEditor);
exports.SelectEditorView = (function (superClass) {
    extend(SelectEditorView, superClass);
    function SelectEditorView() {
        return SelectEditorView.__super__.constructor.apply(this, arguments);
    }
    SelectEditorView.prototype.input = '<select />';
    SelectEditorView.prototype.renderEditor = function () {
        var i, len, option, ref;
        ref = this.model.options;
        for (i = 0, len = ref.length; i < len; i++) {
            option = ref[i];
            this.$input.append($('<option>').attr({
                value: option
            }).text(option));
        }
        return this.focus();
    };
    SelectEditorView.prototype.loadValue = function (item) {
        SelectEditorView.__super__.loadValue.call(this, item);
        return this.$input.select();
    };
    return SelectEditorView;
})(exports.CellEditorView);
exports.SelectEditor = (function (superClass) {
    extend(SelectEditor, superClass);
    function SelectEditor() {
        return SelectEditor.__super__.constructor.apply(this, arguments);
    }
    SelectEditor.prototype.type = 'SelectEditor';
    SelectEditor.prototype.default_view = exports.SelectEditorView;
    SelectEditor.define({
        options: [p.Array, []]
    });
    return SelectEditor;
})(exports.CellEditor);
exports.PercentEditorView = (function (superClass) {
    extend(PercentEditorView, superClass);
    function PercentEditorView() {
        return PercentEditorView.__super__.constructor.apply(this, arguments);
    }
    return PercentEditorView;
})(exports.CellEditorView);
exports.PercentEditor = (function (superClass) {
    extend(PercentEditor, superClass);
    function PercentEditor() {
        return PercentEditor.__super__.constructor.apply(this, arguments);
    }
    PercentEditor.prototype.type = 'PercentEditor';
    PercentEditor.prototype.default_view = exports.PercentEditorView;
    return PercentEditor;
})(exports.CellEditor);
exports.CheckboxEditorView = (function (superClass) {
    extend(CheckboxEditorView, superClass);
    function CheckboxEditorView() {
        return CheckboxEditorView.__super__.constructor.apply(this, arguments);
    }
    CheckboxEditorView.prototype.input = '<input type="checkbox" value="true" />';
    CheckboxEditorView.prototype.renderEditor = function () {
        return this.focus();
    };
    CheckboxEditorView.prototype.loadValue = function (item) {
        this.defaultValue = !!item[this.args.column.field];
        return this.$input.prop('checked', this.defaultValue);
    };
    CheckboxEditorView.prototype.serializeValue = function () {
        return this.$input.prop('checked');
    };
    return CheckboxEditorView;
})(exports.CellEditorView);
exports.CheckboxEditor = (function (superClass) {
    extend(CheckboxEditor, superClass);
    function CheckboxEditor() {
        return CheckboxEditor.__super__.constructor.apply(this, arguments);
    }
    CheckboxEditor.prototype.type = 'CheckboxEditor';
    CheckboxEditor.prototype.default_view = exports.CheckboxEditorView;
    return CheckboxEditor;
})(exports.CellEditor);
exports.IntEditorView = (function (superClass) {
    extend(IntEditorView, superClass);
    function IntEditorView() {
        return IntEditorView.__super__.constructor.apply(this, arguments);
    }
    IntEditorView.prototype.input = '<input type="text" />';
    IntEditorView.prototype.renderEditor = function () {
        this.$input.spinner({
            step: this.model.step
        });
        return this.$input.focus().select();
    };
    IntEditorView.prototype.remove = function () {
        this.$input.spinner("destroy");
        return IntEditorView.__super__.remove.call(this);
    };
    IntEditorView.prototype.serializeValue = function () {
        return parseInt(this.getValue(), 10) || 0;
    };
    IntEditorView.prototype.loadValue = function (item) {
        IntEditorView.__super__.loadValue.call(this, item);
        this.$input[0].defaultValue = this.defaultValue;
        return this.$input.select();
    };
    IntEditorView.prototype.validateValue = function (value) {
        if (isNaN(value)) {
            return {
                valid: false,
                msg: "Please enter a valid integer"
            };
        }
        else {
            return IntEditorView.__super__.validateValue.call(this, value);
        }
    };
    return IntEditorView;
})(exports.CellEditorView);
exports.IntEditor = (function (superClass) {
    extend(IntEditor, superClass);
    function IntEditor() {
        return IntEditor.__super__.constructor.apply(this, arguments);
    }
    IntEditor.prototype.type = 'IntEditor';
    IntEditor.prototype.default_view = exports.IntEditorView;
    IntEditor.define({
        step: [p.Number, 1]
    });
    return IntEditor;
})(exports.CellEditor);
exports.NumberEditorView = (function (superClass) {
    extend(NumberEditorView, superClass);
    function NumberEditorView() {
        return NumberEditorView.__super__.constructor.apply(this, arguments);
    }
    NumberEditorView.prototype.input = '<input type="text" />';
    NumberEditorView.prototype.renderEditor = function () {
        this.$input.spinner({
            step: this.model.step
        });
        return this.$input.focus().select();
    };
    NumberEditorView.prototype.remove = function () {
        this.$input.spinner("destroy");
        return NumberEditorView.__super__.remove.call(this);
    };
    NumberEditorView.prototype.serializeValue = function () {
        return parseFloat(this.getValue()) || 0.0;
    };
    NumberEditorView.prototype.loadValue = function (item) {
        NumberEditorView.__super__.loadValue.call(this, item);
        this.$input[0].defaultValue = this.defaultValue;
        return this.$input.select();
    };
    NumberEditorView.prototype.validateValue = function (value) {
        if (isNaN(value)) {
            return {
                valid: false,
                msg: "Please enter a valid number"
            };
        }
        else {
            return NumberEditorView.__super__.validateValue.call(this, value);
        }
    };
    return NumberEditorView;
})(exports.CellEditorView);
exports.NumberEditor = (function (superClass) {
    extend(NumberEditor, superClass);
    function NumberEditor() {
        return NumberEditor.__super__.constructor.apply(this, arguments);
    }
    NumberEditor.prototype.type = 'NumberEditor';
    NumberEditor.prototype.default_view = exports.NumberEditorView;
    NumberEditor.define({
        step: [p.Number, 0.01]
    });
    return NumberEditor;
})(exports.CellEditor);
exports.TimeEditorView = (function (superClass) {
    extend(TimeEditorView, superClass);
    function TimeEditorView() {
        return TimeEditorView.__super__.constructor.apply(this, arguments);
    }
    return TimeEditorView;
})(exports.CellEditorView);
exports.TimeEditor = (function (superClass) {
    extend(TimeEditor, superClass);
    function TimeEditor() {
        return TimeEditor.__super__.constructor.apply(this, arguments);
    }
    TimeEditor.prototype.type = 'TimeEditor';
    TimeEditor.prototype.default_view = exports.TimeEditorView;
    return TimeEditor;
})(exports.CellEditor);
exports.DateEditorView = (function (superClass) {
    extend(DateEditorView, superClass);
    function DateEditorView() {
        return DateEditorView.__super__.constructor.apply(this, arguments);
    }
    DateEditorView.prototype.emptyValue = new window.Date();
    DateEditorView.prototype.input = '<input type="text" />';
    DateEditorView.prototype.renderEditor = function () {
        this.calendarOpen = false;
        this.$input.datepicker({
            showOn: "button",
            buttonImageOnly: true,
            beforeShow: (function (_this) {
                return function () {
                    return _this.calendarOpen = true;
                };
            })(this),
            onClose: (function (_this) {
                return function () {
                    return _this.calendarOpen = false;
                };
            })(this)
        });
        this.$input.siblings(".bk-ui-datepicker-trigger").css({
            "vertical-align": "middle"
        });
        this.$input.width(this.$input.width() - (14 + 2 * 4 + 4));
        return this.$input.focus().select();
    };
    DateEditorView.prototype.destroy = function () {
        $.datepicker.dpDiv.stop(true, true);
        this.$input.datepicker("hide");
        this.$input.datepicker("destroy");
        return DateEditorView.__super__.destroy.call(this);
    };
    DateEditorView.prototype.show = function () {
        if (this.calendarOpen) {
            $.datepicker.dpDiv.stop(true, true).show();
        }
        return DateEditorView.__super__.show.call(this);
    };
    DateEditorView.prototype.hide = function () {
        if (this.calendarOpen) {
            $.datepicker.dpDiv.stop(true, true).hide();
        }
        return DateEditorView.__super__.hide.call(this);
    };
    DateEditorView.prototype.position = function (position) {
        if (this.calendarOpen) {
            $.datepicker.dpDiv.css({
                top: position.top + 30,
                left: position.left
            });
        }
        return DateEditorView.__super__.position.call(this);
    };
    DateEditorView.prototype.getValue = function () {
        return this.$input.datepicker("getDate").getTime();
    };
    DateEditorView.prototype.setValue = function (val) {
        return this.$input.datepicker("setDate", new window.Date(val));
    };
    return DateEditorView;
})(exports.CellEditorView);
exports.DateEditor = (function (superClass) {
    extend(DateEditor, superClass);
    function DateEditor() {
        return DateEditor.__super__.constructor.apply(this, arguments);
    }
    DateEditor.prototype.type = 'DateEditor';
    DateEditor.prototype.default_view = exports.DateEditorView;
    return DateEditor;
})(exports.CellEditor);

},{"../../core/bokeh_view":"core/bokeh_view","../../core/properties":"core/properties","../../model":"model","jquery":"jquery","jquery-ui/autocomplete":"jquery-ui/autocomplete","jquery-ui/spinner":"jquery-ui/spinner","underscore":"underscore"}],"models/widgets/cell_formatters":[function(require,module,exports){
"use strict";
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var _ = require("underscore");
var $ = require("jquery");
var Numbro = require("numbro");
var p = require("../../core/properties");
var model_1 = require("../../model");
exports.CellFormatter = (function (superClass) {
    extend(CellFormatter, superClass);
    function CellFormatter() {
        return CellFormatter.__super__.constructor.apply(this, arguments);
    }
    CellFormatter.prototype.doFormat = function (row, cell, value, columnDef, dataContext) {
        if (value === null) {
            return "";
        }
        else {
            return (value + "").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
        }
    };
    return CellFormatter;
})(model_1.Model);
exports.StringFormatter = (function (superClass) {
    extend(StringFormatter, superClass);
    function StringFormatter() {
        return StringFormatter.__super__.constructor.apply(this, arguments);
    }
    StringFormatter.prototype.type = 'StringFormatter';
    StringFormatter.define({
        font_style: [p.FontStyle, "normal"],
        text_align: [p.TextAlign, "left"],
        text_color: [p.Color]
    });
    StringFormatter.prototype.doFormat = function (row, cell, value, columnDef, dataContext) {
        var font_style, text, text_align, text_color;
        text = StringFormatter.__super__.doFormat.call(this, row, cell, value, columnDef, dataContext);
        font_style = this.font_style;
        text_align = this.text_align;
        text_color = this.text_color;
        if ((font_style != null) || (text_align != null) || (text_color != null)) {
            text = $("<span>" + text + "</span>");
            switch (font_style) {
                case "bold":
                    text = text.css("font-weight", "bold");
                    break;
                case "italic":
                    text = text.css("font-style", "italic");
            }
            if (text_align != null) {
                text = text.css("text-align", text_align);
            }
            if (text_color != null) {
                text = text.css("color", text_color);
            }
            text = text.prop('outerHTML');
        }
        return text;
    };
    return StringFormatter;
})(exports.CellFormatter);
exports.NumberFormatter = (function (superClass) {
    extend(NumberFormatter, superClass);
    function NumberFormatter() {
        return NumberFormatter.__super__.constructor.apply(this, arguments);
    }
    NumberFormatter.prototype.type = 'NumberFormatter';
    NumberFormatter.define({
        format: [p.String, '0,0'],
        language: [p.String, 'en'],
        rounding: [p.String, 'round']
    });
    NumberFormatter.prototype.doFormat = function (row, cell, value, columnDef, dataContext) {
        var format, language, rounding;
        format = this.format;
        language = this.language;
        rounding = (function () {
            switch (this.rounding) {
                case "round":
                case "nearest":
                    return Math.round;
                case "floor":
                case "rounddown":
                    return Math.floor;
                case "ceil":
                case "roundup":
                    return Math.ceil;
            }
        }).call(this);
        value = Numbro.format(value, format, language, rounding);
        return NumberFormatter.__super__.doFormat.call(this, row, cell, value, columnDef, dataContext);
    };
    return NumberFormatter;
})(exports.StringFormatter);
exports.BooleanFormatter = (function (superClass) {
    extend(BooleanFormatter, superClass);
    function BooleanFormatter() {
        return BooleanFormatter.__super__.constructor.apply(this, arguments);
    }
    BooleanFormatter.prototype.type = 'BooleanFormatter';
    BooleanFormatter.define({
        icon: [p.String, 'check']
    });
    BooleanFormatter.prototype.doFormat = function (row, cell, value, columnDef, dataContext) {
        if (!!value) {
            return $('<i>').addClass(this.icon).html();
        }
        else {
            return "";
        }
    };
    return BooleanFormatter;
})(exports.CellFormatter);
exports.DateFormatter = (function (superClass) {
    extend(DateFormatter, superClass);
    function DateFormatter() {
        return DateFormatter.__super__.constructor.apply(this, arguments);
    }
    DateFormatter.prototype.type = 'DateFormatter';
    DateFormatter.define({
        format: [p.String, 'yy M d']
    });
    DateFormatter.prototype.getFormat = function () {
        var format, name;
        format = this.format;
        name = (function () {
            switch (format) {
                case "ATOM":
                case "W3C":
                case "RFC-3339":
                case "ISO-8601":
                    return "ISO-8601";
                case "COOKIE":
                    return "COOKIE";
                case "RFC-850":
                    return "RFC-850";
                case "RFC-1036":
                    return "RFC-1036";
                case "RFC-1123":
                    return "RFC-1123";
                case "RFC-2822":
                    return "RFC-2822";
                case "RSS":
                case "RFC-822":
                    return "RFC-822";
                case "TICKS":
                    return "TICKS";
                case "TIMESTAMP":
                    return "TIMESTAMP";
                default:
                    return null;
            }
        })();
        if (name != null) {
            return $.datepicker[name];
        }
        else {
            return format;
        }
    };
    DateFormatter.prototype.doFormat = function (row, cell, value, columnDef, dataContext) {
        var date;
        value = _.isString(value) ? parseInt(value, 10) : value;
        date = $.datepicker.formatDate(this.getFormat(), new Date(value));
        return DateFormatter.__super__.doFormat.call(this, row, cell, date, columnDef, dataContext);
    };
    return DateFormatter;
})(exports.CellFormatter);
exports.HTMLTemplateFormatter = (function (superClass) {
    extend(HTMLTemplateFormatter, superClass);
    function HTMLTemplateFormatter() {
        return HTMLTemplateFormatter.__super__.constructor.apply(this, arguments);
    }
    HTMLTemplateFormatter.prototype.type = 'HTMLTemplateFormatter';
    HTMLTemplateFormatter.define({
        template: [p.String, '<%= value %>']
    });
    HTMLTemplateFormatter.prototype.doFormat = function (row, cell, value, columnDef, dataContext) {
        var compiled_template, template;
        template = this.template;
        if (value === null) {
            return "";
        }
        else {
            dataContext = _.extend({}, dataContext, {
                value: value
            });
            compiled_template = _.template(template);
            return compiled_template(dataContext);
        }
    };
    return HTMLTemplateFormatter;
})(exports.CellFormatter);

},{"../../core/properties":"core/properties","../../model":"model","jquery":"jquery","numbro":"numbro","underscore":"underscore"}],"models/widgets/checkbox_button_group":[function(require,module,exports){
"use strict";
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty, indexOf = [].indexOf || function (item) { for (var i = 0, l = this.length; i < l; i++) {
    if (i in this && this[i] === item)
        return i;
} return -1; };
var $ = require("jquery");
require("bootstrap/button");
var widget_1 = require("./widget");
var p = require("../../core/properties");
var button_group_template_1 = require("./button_group_template");
exports.CheckboxButtonGroupView = (function (superClass) {
    extend(CheckboxButtonGroupView, superClass);
    function CheckboxButtonGroupView() {
        return CheckboxButtonGroupView.__super__.constructor.apply(this, arguments);
    }
    CheckboxButtonGroupView.prototype.events = {
        "change input": "change_input"
    };
    CheckboxButtonGroupView.prototype.template = button_group_template_1.default;
    CheckboxButtonGroupView.prototype.initialize = function (options) {
        CheckboxButtonGroupView.__super__.initialize.call(this, options);
        this.render();
        return this.listenTo(this.model, 'change', this.render);
    };
    CheckboxButtonGroupView.prototype.render = function () {
        var $input, $label, active, html, i, j, label, len, ref;
        CheckboxButtonGroupView.__super__.render.call(this);
        this.$el.empty();
        html = this.template();
        this.$el.append(html);
        active = this.model.active;
        ref = this.model.labels;
        for (i = j = 0, len = ref.length; j < len; i = ++j) {
            label = ref[i];
            $input = $('<input type="checkbox">').attr({
                value: "" + i
            });
            if (indexOf.call(active, i) >= 0) {
                $input.prop("checked", true);
            }
            $label = $('<label class="bk-bs-btn"></label>');
            $label.text(label).prepend($input);
            $label.addClass("bk-bs-btn-" + this.model.button_type);
            if (indexOf.call(active, i) >= 0) {
                $label.addClass("bk-bs-active");
            }
            this.$el.find('.bk-bs-btn-group').append($label);
        }
        return this;
    };
    CheckboxButtonGroupView.prototype.change_input = function () {
        var active, checkbox, i, ref;
        active = (function () {
            var j, len, ref, results;
            ref = this.$el.find("input");
            results = [];
            for (i = j = 0, len = ref.length; j < len; i = ++j) {
                checkbox = ref[i];
                if (checkbox.checked) {
                    results.push(i);
                }
            }
            return results;
        }).call(this);
        this.model.active = active;
        return (ref = this.model.callback) != null ? ref.execute(this.model) : void 0;
    };
    return CheckboxButtonGroupView;
})(widget_1.WidgetView);
exports.CheckboxButtonGroup = (function (superClass) {
    extend(CheckboxButtonGroup, superClass);
    function CheckboxButtonGroup() {
        return CheckboxButtonGroup.__super__.constructor.apply(this, arguments);
    }
    CheckboxButtonGroup.prototype.type = "CheckboxButtonGroup";
    CheckboxButtonGroup.prototype.default_view = exports.CheckboxButtonGroupView;
    CheckboxButtonGroup.define({
        active: [p.Array, []],
        labels: [p.Array, []],
        button_type: [p.String, "default"],
        callback: [p.Instance]
    });
    return CheckboxButtonGroup;
})(widget_1.Widget);

},{"../../core/properties":"core/properties","./button_group_template":"models/widgets/button_group_template","./widget":"models/widgets/widget","bootstrap/button":"bootstrap/button","jquery":"jquery"}],"models/widgets/checkbox_group":[function(require,module,exports){
"use strict";
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty, indexOf = [].indexOf || function (item) { for (var i = 0, l = this.length; i < l; i++) {
    if (i in this && this[i] === item)
        return i;
} return -1; };
var $ = require("jquery");
var widget_1 = require("./widget");
var p = require("../../core/properties");
exports.CheckboxGroupView = (function (superClass) {
    extend(CheckboxGroupView, superClass);
    function CheckboxGroupView() {
        return CheckboxGroupView.__super__.constructor.apply(this, arguments);
    }
    CheckboxGroupView.prototype.events = {
        "change input": "change_input"
    };
    CheckboxGroupView.prototype.initialize = function (options) {
        CheckboxGroupView.__super__.initialize.call(this, options);
        this.render();
        return this.listenTo(this.model, 'change', this.render);
    };
    CheckboxGroupView.prototype.render = function () {
        var $div, $input, $label, active, i, j, label, len, ref;
        CheckboxGroupView.__super__.render.call(this);
        this.$el.empty();
        active = this.model.active;
        ref = this.model.labels;
        for (i = j = 0, len = ref.length; j < len; i = ++j) {
            label = ref[i];
            $input = $('<input type="checkbox">').attr({
                value: "" + i
            });
            if (this.model.disabled) {
                $input.prop("disabled", true);
            }
            if (indexOf.call(active, i) >= 0) {
                $input.prop("checked", true);
            }
            $label = $('<label></label>').text(label).prepend($input);
            if (this.model.inline) {
                $label.addClass("bk-bs-checkbox-inline");
                this.$el.append($label);
            }
            else {
                $div = $('<div class="bk-bs-checkbox"></div>').append($label);
                this.$el.append($div);
            }
        }
        return this;
    };
    CheckboxGroupView.prototype.change_input = function () {
        var active, checkbox, i, ref;
        active = (function () {
            var j, len, ref, results;
            ref = this.$el.find("input");
            results = [];
            for (i = j = 0, len = ref.length; j < len; i = ++j) {
                checkbox = ref[i];
                if (checkbox.checked) {
                    results.push(i);
                }
            }
            return results;
        }).call(this);
        this.model.active = active;
        return (ref = this.model.callback) != null ? ref.execute(this.model) : void 0;
    };
    return CheckboxGroupView;
})(widget_1.WidgetView);
exports.CheckboxGroup = (function (superClass) {
    extend(CheckboxGroup, superClass);
    function CheckboxGroup() {
        return CheckboxGroup.__super__.constructor.apply(this, arguments);
    }
    CheckboxGroup.prototype.type = "CheckboxGroup";
    CheckboxGroup.prototype.default_view = exports.CheckboxGroupView;
    CheckboxGroup.define({
        active: [p.Array, []],
        labels: [p.Array, []],
        inline: [p.Bool, false],
        callback: [p.Instance]
    });
    return CheckboxGroup;
})(widget_1.Widget);

},{"../../core/properties":"core/properties","./widget":"models/widgets/widget","jquery":"jquery"}],"models/widgets/data_table":[function(require,module,exports){
"use strict";
var wait_for_element, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var _ = require("underscore");
var $ = require("jquery");
require("jquery-ui/sortable");
var SlickGrid = require("slick_grid/slick.grid");
var RowSelectionModel = require("slick_grid/plugins/slick.rowselectionmodel");
var CheckboxSelectColumn = require("slick_grid/plugins/slick.checkboxselectcolumn");
var hittest = require("../../core/hittest");
var p = require("../../core/properties");
var table_widget_1 = require("./table_widget");
var widget_1 = require("./widget");
wait_for_element = function (el, fn) {
    var handler, interval;
    handler = (function (_this) {
        return function () {
            if ($.contains(document.documentElement, el)) {
                clearInterval(interval);
                return fn();
            }
        };
    })(this);
    return interval = setInterval(handler, 50);
};
exports.DataProvider = (function () {
    function DataProvider(source1) {
        var j, ref, results;
        this.source = source1;
        this.data = this.source.data;
        this.fields = _.keys(this.data);
        if (!_.contains(this.fields, "index")) {
            this.data["index"] = (function () {
                results = [];
                for (var j = 0, ref = this.getLength(); 0 <= ref ? j < ref : j > ref; 0 <= ref ? j++ : j--) {
                    results.push(j);
                }
                return results;
            }).apply(this);
            this.fields.push("index");
        }
    }
    DataProvider.prototype.getLength = function () {
        return this.source.get_length();
    };
    DataProvider.prototype.getItem = function (offset) {
        var field, item, j, len, ref;
        item = {};
        ref = this.fields;
        for (j = 0, len = ref.length; j < len; j++) {
            field = ref[j];
            item[field] = this.data[field][offset];
        }
        return item;
    };
    DataProvider.prototype._setItem = function (offset, item) {
        var field, value;
        for (field in item) {
            value = item[field];
            this.data[field][offset] = value;
        }
    };
    DataProvider.prototype.setItem = function (offset, item) {
        this._setItem(offset, item);
        return this.updateSource();
    };
    DataProvider.prototype.getField = function (index, field) {
        var offset;
        offset = this.data["index"].indexOf(index);
        return this.data[field][offset];
    };
    DataProvider.prototype._setField = function (index, field, value) {
        var offset;
        offset = this.data["index"].indexOf(index);
        this.data[field][offset] = value;
    };
    DataProvider.prototype.setField = function (index, field, value) {
        this._setField(index, field, value);
        return this.updateSource();
    };
    DataProvider.prototype.updateSource = function () {
        return this.source.trigger("change:data", this, this.source.attributes['data']);
    };
    DataProvider.prototype.getItemMetadata = function (index) {
        return null;
    };
    DataProvider.prototype.getRecords = function () {
        var i;
        return (function () {
            var j, ref, results;
            results = [];
            for (i = j = 0, ref = this.getLength(); 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
                results.push(this.getItem(i));
            }
            return results;
        }).call(this);
    };
    DataProvider.prototype.sort = function (columns) {
        var cols, column, i, j, len, record, records;
        cols = (function () {
            var j, len, results;
            results = [];
            for (j = 0, len = columns.length; j < len; j++) {
                column = columns[j];
                results.push([column.sortCol.field, column.sortAsc ? 1 : -1]);
            }
            return results;
        })();
        if (_.isEmpty(cols)) {
            cols = [["index", 1]];
        }
        records = this.getRecords();
        records.sort(function (record1, record2) {
            var field, j, len, ref, result, sign, value1, value2;
            for (j = 0, len = cols.length; j < len; j++) {
                ref = cols[j], field = ref[0], sign = ref[1];
                value1 = record1[field];
                value2 = record2[field];
                result = value1 === value2 ? 0 : value1 > value2 ? sign : -sign;
                if (result !== 0) {
                    return result;
                }
            }
            return 0;
        });
        for (i = j = 0, len = records.length; j < len; i = ++j) {
            record = records[i];
            this._setItem(i, record);
        }
        return this.updateSource();
    };
    return DataProvider;
})();
exports.DataTableView = (function (superClass) {
    extend(DataTableView, superClass);
    function DataTableView() {
        return DataTableView.__super__.constructor.apply(this, arguments);
    }
    DataTableView.prototype.className = "bk-data-table";
    DataTableView.prototype.initialize = function (options) {
        var source;
        DataTableView.__super__.initialize.call(this, options);
        wait_for_element(this.el, (function (_this) {
            return function () {
                return _this.render();
            };
        })(this));
        this.listenTo(this.model, 'change', (function (_this) {
            return function () {
                return _this.render();
            };
        })(this));
        source = this.model.source;
        this.listenTo(source, 'change:data', (function (_this) {
            return function () {
                return _this.updateGrid();
            };
        })(this));
        return this.listenTo(source, 'change:selected', (function (_this) {
            return function () {
                return _this.updateSelection();
            };
        })(this));
    };
    DataTableView.prototype.updateGrid = function () {
        this.data.constructor(this.model.source);
        this.grid.invalidate();
        this.grid.render();
        this.model.source.data = this.model.source.data;
        return this.model.source.trigger('change');
    };
    DataTableView.prototype.updateSelection = function () {
        var cur_grid_range, indices, min_index, selected;
        selected = this.model.source.selected;
        indices = selected['1d'].indices;
        this.grid.setSelectedRows(indices);
        cur_grid_range = this.grid.getViewport();
        if (this.model.scroll_to_selection && !_.any(indices, function (i) {
            return (cur_grid_range.top <= i && i <= cur_grid_range.bottom);
        })) {
            min_index = Math.max(0, Math.min.apply(null, indices) - 1);
            return this.grid.scrollRowToTop(min_index);
        }
    };
    DataTableView.prototype.newIndexColumn = function () {
        return {
            id: _.uniqueId(),
            name: "#",
            field: "index",
            width: 40,
            behavior: "select",
            cannotTriggerInsert: true,
            resizable: false,
            selectable: false,
            sortable: true,
            cssClass: "bk-cell-index"
        };
    };
    DataTableView.prototype.render = function () {
        var checkboxSelector, column, columns, height, options, width;
        columns = (function () {
            var j, len, ref, results;
            ref = this.model.columns;
            results = [];
            for (j = 0, len = ref.length; j < len; j++) {
                column = ref[j];
                results.push(column.toColumn());
            }
            return results;
        }).call(this);
        if (this.model.selectable === "checkbox") {
            checkboxSelector = new CheckboxSelectColumn({
                cssClass: "bk-cell-select"
            });
            columns.unshift(checkboxSelector.getColumnDefinition());
        }
        if (this.model.row_headers && (this.model.source.get_column("index") != null)) {
            columns.unshift(this.newIndexColumn());
        }
        width = this.model.width;
        height = this.model.height;
        options = {
            enableCellNavigation: this.model.selectable !== false,
            enableColumnReorder: true,
            forceFitColumns: this.model.fit_columns,
            autoHeight: height === "auto",
            multiColumnSort: this.model.sortable,
            editable: this.model.editable,
            autoEdit: false
        };
        if (width != null) {
            this.$el.css({
                width: this.model.width + "px"
            });
        }
        else {
            this.$el.css({
                width: this.model.default_width + "px"
            });
        }
        if ((height != null) && height !== "auto") {
            this.$el.css({
                height: this.model.height + "px"
            });
        }
        this.data = new exports.DataProvider(this.model.source);
        this.grid = new SlickGrid(this.el, this.data, columns, options);
        this.grid.onSort.subscribe((function (_this) {
            return function (event, args) {
                columns = args.sortCols;
                _this.data.sort(columns);
                _this.grid.invalidate();
                return _this.grid.render();
            };
        })(this));
        if (this.model.selectable !== false) {
            this.grid.setSelectionModel(new RowSelectionModel({
                selectActiveRow: checkboxSelector == null
            }));
            if (checkboxSelector != null) {
                this.grid.registerPlugin(checkboxSelector);
            }
            this.grid.onSelectedRowsChanged.subscribe((function (_this) {
                return function (event, args) {
                    var selected;
                    selected = hittest.create_hit_test_result();
                    selected['1d'].indices = args.rows;
                    return _this.model.source.selected = selected;
                };
            })(this));
        }
        return this;
    };
    return DataTableView;
})(widget_1.WidgetView);
exports.DataTable = (function (superClass) {
    extend(DataTable, superClass);
    function DataTable() {
        return DataTable.__super__.constructor.apply(this, arguments);
    }
    DataTable.prototype.type = 'DataTable';
    DataTable.prototype.default_view = exports.DataTableView;
    DataTable.define({
        columns: [p.Array, []],
        fit_columns: [p.Bool, true],
        sortable: [p.Bool, true],
        editable: [p.Bool, false],
        selectable: [p.Bool, true],
        row_headers: [p.Bool, true],
        scroll_to_selection: [p.Bool, true]
    });
    DataTable.override({
        height: 400
    });
    DataTable.internal({
        default_width: [p.Number, 600]
    });
    return DataTable;
})(table_widget_1.TableWidget);

},{"../../core/hittest":"core/hittest","../../core/properties":"core/properties","./table_widget":"models/widgets/table_widget","./widget":"models/widgets/widget","jquery":"jquery","jquery-ui/sortable":"jquery-ui/sortable","slick_grid/plugins/slick.checkboxselectcolumn":"slick_grid/plugins/slick.checkboxselectcolumn","slick_grid/plugins/slick.rowselectionmodel":"slick_grid/plugins/slick.rowselectionmodel","slick_grid/slick.grid":"slick_grid/slick.grid","underscore":"underscore"}],"models/widgets/date_picker":[function(require,module,exports){
"use strict";
var bind = function (fn, me) { return function () { return fn.apply(me, arguments); }; }, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var $ = require("jquery");
require("jquery-ui/datepicker");
var p = require("../../core/properties");
var input_widget_1 = require("./input_widget");
exports.DatePickerView = (function (superClass) {
    extend(DatePickerView, superClass);
    function DatePickerView() {
        this.onSelect = bind(this.onSelect, this);
        return DatePickerView.__super__.constructor.apply(this, arguments);
    }
    DatePickerView.prototype.initialize = function (options) {
        DatePickerView.__super__.initialize.call(this, options);
        this.label = $('<label>').text(this.model.title);
        this.input = $('<input type="text">');
        this.datepicker = this.input.datepicker({
            defaultDate: new Date(this.model.value),
            minDate: this.model.min_date != null ? new Date(this.model.min_date) : null,
            maxDate: this.model.max_date != null ? new Date(this.model.max_date) : null,
            onSelect: this.onSelect
        });
        return this.$el.append([this.label, this.input]);
    };
    DatePickerView.prototype.onSelect = function (dateText, ui) {
        var d, ref;
        d = new Date(dateText);
        this.model.value = d.toString();
        return (ref = this.model.callback) != null ? ref.execute(this.model) : void 0;
    };
    return DatePickerView;
})(input_widget_1.InputWidgetView);
exports.DatePicker = (function (superClass) {
    extend(DatePicker, superClass);
    function DatePicker() {
        return DatePicker.__super__.constructor.apply(this, arguments);
    }
    DatePicker.prototype.type = "DatePicker";
    DatePicker.prototype.default_view = exports.DatePickerView;
    DatePicker.define({
        value: [p.Any, Date.now()],
        min_date: [p.Any],
        max_date: [p.Any]
    });
    return DatePicker;
})(input_widget_1.InputWidget);

},{"../../core/properties":"core/properties","./input_widget":"models/widgets/input_widget","jquery":"jquery","jquery-ui/datepicker":"jquery-ui/datepicker"}],"models/widgets/date_range_slider":[function(require,module,exports){
"use strict";
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var _ = require("underscore");
require("jqrangeslider/jQDateRangeSlider");
var p = require("../../core/properties");
var input_widget_1 = require("./input_widget");
exports.DateRangeSliderView = (function (superClass) {
    extend(DateRangeSliderView, superClass);
    function DateRangeSliderView() {
        return DateRangeSliderView.__super__.constructor.apply(this, arguments);
    }
    DateRangeSliderView.prototype.initialize = function (options) {
        DateRangeSliderView.__super__.initialize.call(this, options);
        this.render();
        return this.listenTo(this.model, 'change', (function (_this) {
            return function () {
                return _this.render;
            };
        })(this));
    };
    DateRangeSliderView.prototype.render = function () {
        var bounds_max, bounds_min, range_max, range_min, ref, ref1, ref2, value_max, value_min;
        DateRangeSliderView.__super__.render.call(this);
        this.$el.empty();
        ref = this.model.value, value_min = ref[0], value_max = ref[1];
        ref1 = this.model.range, range_min = ref1[0], range_max = ref1[1];
        ref2 = this.model.bounds, bounds_min = ref2[0], bounds_max = ref2[1];
        this.$el.dateRangeSlider({
            defaultValues: {
                min: new Date(value_min),
                max: new Date(value_max)
            },
            bounds: {
                min: new Date(bounds_min),
                max: new Date(bounds_max)
            },
            range: {
                min: _.isObject(range_min) ? range_min : false,
                max: _.isObject(range_max) ? range_max : false
            },
            step: this.model.step || {},
            enabled: this.model.enabled,
            arrows: this.model.arrows,
            valueLabels: this.model.value_labels,
            wheelMode: this.model.wheel_mode
        });
        this.$el.on("userValuesChanged", (function (_this) {
            return function (event, data) {
                var ref3;
                _this.model.value = [data.values.min, data.values.max];
                return (ref3 = _this.model.callback) != null ? ref3.execute(_this.model) : void 0;
            };
        })(this));
        return this;
    };
    return DateRangeSliderView;
})(input_widget_1.InputWidgetView);
exports.DateRangeSlider = (function (superClass) {
    extend(DateRangeSlider, superClass);
    function DateRangeSlider() {
        return DateRangeSlider.__super__.constructor.apply(this, arguments);
    }
    DateRangeSlider.prototype.type = "DateRangeSlider";
    DateRangeSlider.prototype.default_view = exports.DateRangeSliderView;
    DateRangeSlider.define({
        value: [p.Any],
        range: [p.Any],
        bounds: [p.Any],
        step: [p.Any, {}],
        enabled: [p.Bool, true],
        arrows: [p.Bool, true],
        value_labels: [p.String, "show"],
        wheel_mode: [p.Any]
    });
    return DateRangeSlider;
})(input_widget_1.InputWidget);

},{"../../core/properties":"core/properties","./input_widget":"models/widgets/input_widget","jqrangeslider/jQDateRangeSlider":"jqrangeslider/jQDateRangeSlider","underscore":"underscore"}],"models/widgets/div":[function(require,module,exports){
"use strict";
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var $ = require("jquery");
var markup_1 = require("./markup");
var p = require("../../core/properties");
exports.DivView = (function (superClass) {
    extend(DivView, superClass);
    function DivView() {
        return DivView.__super__.constructor.apply(this, arguments);
    }
    DivView.prototype.render = function () {
        var $content;
        DivView.__super__.render.call(this);
        if (this.model.render_as_text === true) {
            $content = $('<div></div>').text(this.model.text);
        }
        else {
            $content = $('<div></div>').html(this.model.text);
        }
        this.$el.find('.bk-markup').append($content);
        return this;
    };
    return DivView;
})(markup_1.MarkupView);
exports.Div = (function (superClass) {
    extend(Div, superClass);
    function Div() {
        return Div.__super__.constructor.apply(this, arguments);
    }
    Div.prototype.type = "Div";
    Div.prototype.default_view = exports.DivView;
    Div.define({
        render_as_text: [p.Bool, false]
    });
    return Div;
})(markup_1.Markup);

},{"../../core/properties":"core/properties","./markup":"models/widgets/markup","jquery":"jquery"}],"models/widgets/dropdown":[function(require,module,exports){
"use strict";
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var $ = require("jquery");
require("bootstrap/dropdown");
var p = require("../../core/properties");
var abstract_button_1 = require("./abstract_button");
var dropdown_template_1 = require("./dropdown_template");
exports.DropdownView = (function (superClass) {
    extend(DropdownView, superClass);
    function DropdownView() {
        return DropdownView.__super__.constructor.apply(this, arguments);
    }
    DropdownView.prototype.template = dropdown_template_1.default;
    DropdownView.prototype.render = function () {
        var $a, $item, i, item, items, label, len, ref, that, value;
        DropdownView.__super__.render.call(this);
        items = [];
        ref = this.model.menu;
        for (i = 0, len = ref.length; i < len; i++) {
            item = ref[i];
            $item = item != null ? ((label = item[0], value = item[1], item), $a = $("<a data-value='" + value + "'>" + label + "</a>"), that = this, $a.click(function (e) {
                return that.set_value($(this).data('value'));
            }), $('<li></li>').append($a)) : $('<li class="bk-bs-divider"></li>');
            items.push($item);
        }
        this.$el.find('.bk-bs-dropdown-menu').append(items);
        this.$el.find('button').val(this.model.default_value);
        this.$el.find('button').dropdown();
        return this;
    };
    DropdownView.prototype.set_value = function (value) {
        this.model.value = value;
        return this.$el.find('button').val(value);
    };
    return DropdownView;
})(abstract_button_1.AbstractButtonView);
exports.Dropdown = (function (superClass) {
    extend(Dropdown, superClass);
    function Dropdown() {
        return Dropdown.__super__.constructor.apply(this, arguments);
    }
    Dropdown.prototype.type = "Dropdown";
    Dropdown.prototype.default_view = exports.DropdownView;
    Dropdown.define({
        value: [p.String],
        default_value: [p.String],
        menu: [p.Array, []]
    });
    Dropdown.override({
        label: "Dropdown"
    });
    return Dropdown;
})(abstract_button_1.AbstractButton);

},{"../../core/properties":"core/properties","./abstract_button":"models/widgets/abstract_button","./dropdown_template":"models/widgets/dropdown_template","bootstrap/dropdown":"bootstrap/dropdown","jquery":"jquery"}],"models/widgets/dropdown_template":[function(require,module,exports){
"use strict";
var DOM = require("../../core/util/dom");
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = function (props) {
    var classes = ["bk-bs-btn", "bk-bs-btn-" + props.button_type, "bk-bs-dropdown-toggle", "bk-bs-dropdown-btn"];
    return (DOM.createElement("fragment", null,
        DOM.createElement("button", { type: "button", class: classes, "data-bk-bs-toggle": "dropdown" },
            props.label,
            " ",
            DOM.createElement("span", { class: "bk-bs-caret" })),
        DOM.createElement("ul", { class: "bk-bs-dropdown-menu" })));
};

},{"../../core/util/dom":"core/util/dom"}],"models/widgets/index":[function(require,module,exports){
"use strict";
function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
__export(require("./cell_editors"));
__export(require("./cell_formatters"));
var abstract_button_1 = require("./abstract_button");
exports.AbstractButton = abstract_button_1.AbstractButton;
var abstract_icon_1 = require("./abstract_icon");
exports.AbstractIcon = abstract_icon_1.AbstractIcon;
var table_widget_1 = require("./table_widget");
exports.TableWidget = table_widget_1.TableWidget;
var markup_1 = require("./markup");
exports.Markup = markup_1.Markup;
var widget_1 = require("./widget");
exports.Widget = widget_1.Widget;
var input_widget_1 = require("./input_widget");
exports.InputWidget = input_widget_1.InputWidget;
var table_column_1 = require("./table_column");
exports.TableColumn = table_column_1.TableColumn;
var data_table_1 = require("./data_table");
exports.DataTable = data_table_1.DataTable;
var paragraph_1 = require("./paragraph");
exports.Paragraph = paragraph_1.Paragraph;
var div_1 = require("./div");
exports.Div = div_1.Div;
var text_input_1 = require("./text_input");
exports.TextInput = text_input_1.TextInput;
var autocomplete_input_1 = require("./autocomplete_input");
exports.AutocompleteInput = autocomplete_input_1.AutocompleteInput;
var pretext_1 = require("./pretext");
exports.PreText = pretext_1.PreText;
var selectbox_1 = require("./selectbox");
exports.Select = selectbox_1.Select;
var slider_1 = require("./slider");
exports.Slider = slider_1.Slider;
var range_slider_1 = require("./range_slider");
exports.RangeSlider = range_slider_1.RangeSlider;
var multiselect_1 = require("./multiselect");
exports.MultiSelect = multiselect_1.MultiSelect;
var date_range_slider_1 = require("./date_range_slider");
exports.DateRangeSlider = date_range_slider_1.DateRangeSlider;
var date_picker_1 = require("./date_picker");
exports.DatePicker = date_picker_1.DatePicker;
var panel_1 = require("./panel");
exports.Panel = panel_1.Panel;
var tabs_1 = require("./tabs");
exports.Tabs = tabs_1.Tabs;
var button_1 = require("./button");
exports.Button = button_1.Button;
var toggle_1 = require("./toggle");
exports.Toggle = toggle_1.Toggle;
var dropdown_1 = require("./dropdown");
exports.Dropdown = dropdown_1.Dropdown;
var checkbox_group_1 = require("./checkbox_group");
exports.CheckboxGroup = checkbox_group_1.CheckboxGroup;
var radio_group_1 = require("./radio_group");
exports.RadioGroup = radio_group_1.RadioGroup;
var checkbox_button_group_1 = require("./checkbox_button_group");
exports.CheckboxButtonGroup = checkbox_button_group_1.CheckboxButtonGroup;
var radio_button_group_1 = require("./radio_button_group");
exports.RadioButtonGroup = radio_button_group_1.RadioButtonGroup;

},{"./abstract_button":"models/widgets/abstract_button","./abstract_icon":"models/widgets/abstract_icon","./autocomplete_input":"models/widgets/autocomplete_input","./button":"models/widgets/button","./cell_editors":"models/widgets/cell_editors","./cell_formatters":"models/widgets/cell_formatters","./checkbox_button_group":"models/widgets/checkbox_button_group","./checkbox_group":"models/widgets/checkbox_group","./data_table":"models/widgets/data_table","./date_picker":"models/widgets/date_picker","./date_range_slider":"models/widgets/date_range_slider","./div":"models/widgets/div","./dropdown":"models/widgets/dropdown","./input_widget":"models/widgets/input_widget","./markup":"models/widgets/markup","./multiselect":"models/widgets/multiselect","./panel":"models/widgets/panel","./paragraph":"models/widgets/paragraph","./pretext":"models/widgets/pretext","./radio_button_group":"models/widgets/radio_button_group","./radio_group":"models/widgets/radio_group","./range_slider":"models/widgets/range_slider","./selectbox":"models/widgets/selectbox","./slider":"models/widgets/slider","./table_column":"models/widgets/table_column","./table_widget":"models/widgets/table_widget","./tabs":"models/widgets/tabs","./text_input":"models/widgets/text_input","./toggle":"models/widgets/toggle","./widget":"models/widgets/widget"}],"models/widgets/input_widget":[function(require,module,exports){
"use strict";
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var widget_1 = require("./widget");
var p = require("../../core/properties");
exports.InputWidgetView = (function (superClass) {
    extend(InputWidgetView, superClass);
    function InputWidgetView() {
        return InputWidgetView.__super__.constructor.apply(this, arguments);
    }
    InputWidgetView.prototype.render = function () {
        InputWidgetView.__super__.render.call(this);
        return this.$el.find('input').prop("disabled", this.model.disabled);
    };
    InputWidgetView.prototype.change_input = function () {
        var ref;
        return (ref = this.model.callback) != null ? ref.execute(this.model) : void 0;
    };
    return InputWidgetView;
})(widget_1.WidgetView);
exports.InputWidget = (function (superClass) {
    extend(InputWidget, superClass);
    function InputWidget() {
        return InputWidget.__super__.constructor.apply(this, arguments);
    }
    InputWidget.prototype.type = "InputWidget";
    InputWidget.prototype.default_view = exports.InputWidgetView;
    InputWidget.define({
        callback: [p.Instance],
        title: [p.String, '']
    });
    return InputWidget;
})(widget_1.Widget);

},{"../../core/properties":"core/properties","./widget":"models/widgets/widget"}],"models/widgets/main":[function(require,module,exports){
"use strict";
var Widgets = require("./index");
exports.models = Widgets;

},{"./index":"models/widgets/index"}],"models/widgets/markup":[function(require,module,exports){
"use strict";
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var p = require("../../core/properties");
var widget_1 = require("./widget");
var markup_template_1 = require("./markup_template");
exports.MarkupView = (function (superClass) {
    extend(MarkupView, superClass);
    function MarkupView() {
        return MarkupView.__super__.constructor.apply(this, arguments);
    }
    MarkupView.prototype.template = markup_template_1.default;
    MarkupView.prototype.initialize = function (options) {
        MarkupView.__super__.initialize.call(this, options);
        this.render();
        return this.listenTo(this.model, 'change', this.render);
    };
    MarkupView.prototype.render = function () {
        MarkupView.__super__.render.call(this);
        this.$el.empty();
        this.$el.html(this.template());
        if (this.model.height) {
            this.$el.height(this.model.height);
        }
        if (this.model.width) {
            return this.$el.width(this.model.width);
        }
    };
    return MarkupView;
})(widget_1.WidgetView);
exports.Markup = (function (superClass) {
    extend(Markup, superClass);
    function Markup() {
        return Markup.__super__.constructor.apply(this, arguments);
    }
    Markup.prototype.type = "Markup";
    Markup.prototype.initialize = function (options) {
        return Markup.__super__.initialize.call(this, options);
    };
    Markup.define({
        text: [p.String, '']
    });
    return Markup;
})(widget_1.Widget);

},{"../../core/properties":"core/properties","./markup_template":"models/widgets/markup_template","./widget":"models/widgets/widget"}],"models/widgets/markup_template":[function(require,module,exports){
"use strict";
var DOM = require("../../core/util/dom");
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = function () {
    return DOM.createElement("div", { class: "bk-markup" });
};

},{"../../core/util/dom":"core/util/dom"}],"models/widgets/multiselect":[function(require,module,exports){
"use strict";
var bind = function (fn, me) { return function () { return fn.apply(me, arguments); }; }, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var p = require("../../core/properties");
var input_widget_1 = require("./input_widget");
var multiselecttemplate_1 = require("./multiselecttemplate");
exports.MultiSelectView = (function (superClass) {
    extend(MultiSelectView, superClass);
    function MultiSelectView() {
        this.render_selection = bind(this.render_selection, this);
        return MultiSelectView.__super__.constructor.apply(this, arguments);
    }
    MultiSelectView.prototype.tagName = "div";
    MultiSelectView.prototype.template = multiselecttemplate_1.default;
    MultiSelectView.prototype.events = {
        "change select": "change_input"
    };
    MultiSelectView.prototype.initialize = function (options) {
        MultiSelectView.__super__.initialize.call(this, options);
        this.render();
        this.listenTo(this.model, 'change:value', this.render_selection);
        this.listenTo(this.model, 'change:options', this.render);
        this.listenTo(this.model, 'change:name', this.render);
        this.listenTo(this.model, 'change:title', this.render);
        return this.listenTo(this.model, 'change:size', this.render);
    };
    MultiSelectView.prototype.render = function () {
        var html;
        MultiSelectView.__super__.render.call(this);
        this.$el.empty();
        html = this.template(this.model.attributes);
        this.$el.html(html);
        this.render_selection();
        return this;
    };
    MultiSelectView.prototype.render_selection = function () {
        var i, len, ref, values, x;
        values = {};
        ref = this.model.value;
        for (i = 0, len = ref.length; i < len; i++) {
            x = ref[i];
            values[x] = true;
        }
        this.$el.find('option').each((function (_this) {
            return function (el) {
                el = _this.$el.find(el);
                if (values[el.attr('value')]) {
                    return el.attr('selected', 'selected');
                }
            };
        })(this));
        return this.$el.find('select').attr('size', this.model.size);
    };
    MultiSelectView.prototype.change_input = function () {
        var is_focused, value;
        is_focused = this.$el.find('select:focus').size();
        value = this.$el.find('select').val();
        if (value) {
            this.model.value = value;
        }
        else {
            this.model.value = [];
        }
        MultiSelectView.__super__.change_input.call(this);
        if (is_focused) {
            return this.$el.find('select').focus();
        }
    };
    return MultiSelectView;
})(input_widget_1.InputWidgetView);
exports.MultiSelect = (function (superClass) {
    extend(MultiSelect, superClass);
    function MultiSelect() {
        return MultiSelect.__super__.constructor.apply(this, arguments);
    }
    MultiSelect.prototype.type = "MultiSelect";
    MultiSelect.prototype.default_view = exports.MultiSelectView;
    MultiSelect.define({
        value: [p.Array, []],
        options: [p.Array, []],
        size: [p.Number, 4]
    });
    return MultiSelect;
})(input_widget_1.InputWidget);

},{"../../core/properties":"core/properties","./input_widget":"models/widgets/input_widget","./multiselecttemplate":"models/widgets/multiselecttemplate"}],"models/widgets/multiselecttemplate":[function(require,module,exports){
"use strict";
var _ = require("underscore");
var DOM = require("../../core/util/dom");
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = function (props) {
    return (DOM.createElement("fragment", null,
        DOM.createElement("label", { for: props.id },
            " ",
            props.title,
            " "),
        DOM.createElement("select", { multiple: true, class: "bk-widget-form-input", id: props.id, name: props.name }, props.options.map(function (option) {
            var value, label;
            if (_.isString(option)) {
                value = label = option;
            }
            else {
                value = option[0], label = option[1];
            }
            var selected = props.value.indexOf(value) > -1;
            return DOM.createElement("option", { selected: selected, value: value }, label);
        }))));
};

},{"../../core/util/dom":"core/util/dom","underscore":"underscore"}],"models/widgets/panel":[function(require,module,exports){
"use strict";
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var p = require("../../core/properties");
var widget_1 = require("./widget");
exports.PanelView = (function (superClass) {
    extend(PanelView, superClass);
    function PanelView() {
        return PanelView.__super__.constructor.apply(this, arguments);
    }
    PanelView.prototype.render = function () {
        PanelView.__super__.render.call(this);
        this.$el.empty();
        return this;
    };
    return PanelView;
})(widget_1.WidgetView);
exports.Panel = (function (superClass) {
    extend(Panel, superClass);
    function Panel() {
        return Panel.__super__.constructor.apply(this, arguments);
    }
    Panel.prototype.type = "Panel";
    Panel.prototype.default_view = exports.PanelView;
    Panel.define({
        title: [p.String, ""],
        child: [p.Instance],
        closable: [p.Bool, false]
    });
    return Panel;
})(widget_1.Widget);

},{"../../core/properties":"core/properties","./widget":"models/widgets/widget"}],"models/widgets/paragraph":[function(require,module,exports){
"use strict";
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var $ = require("jquery");
var markup_1 = require("./markup");
exports.ParagraphView = (function (superClass) {
    extend(ParagraphView, superClass);
    function ParagraphView() {
        return ParagraphView.__super__.constructor.apply(this, arguments);
    }
    ParagraphView.prototype.render = function () {
        var $para;
        ParagraphView.__super__.render.call(this);
        $para = $('<p style="margin: 0;"></p>').text(this.model.text);
        return this.$el.find('.bk-markup').append($para);
    };
    return ParagraphView;
})(markup_1.MarkupView);
exports.Paragraph = (function (superClass) {
    extend(Paragraph, superClass);
    function Paragraph() {
        return Paragraph.__super__.constructor.apply(this, arguments);
    }
    Paragraph.prototype.type = "Paragraph";
    Paragraph.prototype.default_view = exports.ParagraphView;
    return Paragraph;
})(markup_1.Markup);

},{"./markup":"models/widgets/markup","jquery":"jquery"}],"models/widgets/pretext":[function(require,module,exports){
"use strict";
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var $ = require("jquery");
var markup_1 = require("./markup");
exports.PreTextView = (function (superClass) {
    extend(PreTextView, superClass);
    function PreTextView() {
        return PreTextView.__super__.constructor.apply(this, arguments);
    }
    PreTextView.prototype.render = function () {
        var $pre;
        PreTextView.__super__.render.call(this);
        $pre = $('<pre style="overflow: auto"></pre>').text(this.model.text);
        return this.$el.find('.bk-markup').append($pre);
    };
    return PreTextView;
})(markup_1.MarkupView);
exports.PreText = (function (superClass) {
    extend(PreText, superClass);
    function PreText() {
        return PreText.__super__.constructor.apply(this, arguments);
    }
    PreText.prototype.type = "PreText";
    PreText.prototype.default_view = exports.PreTextView;
    return PreText;
})(markup_1.Markup);

},{"./markup":"models/widgets/markup","jquery":"jquery"}],"models/widgets/radio_button_group":[function(require,module,exports){
"use strict";
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var _ = require("underscore");
var $ = require("jquery");
require("bootstrap/button");
var p = require("../../core/properties");
var widget_1 = require("./widget");
var button_group_template_1 = require("./button_group_template");
exports.RadioButtonGroupView = (function (superClass) {
    extend(RadioButtonGroupView, superClass);
    function RadioButtonGroupView() {
        return RadioButtonGroupView.__super__.constructor.apply(this, arguments);
    }
    RadioButtonGroupView.prototype.events = {
        "change input": "change_input"
    };
    RadioButtonGroupView.prototype.template = button_group_template_1.default;
    RadioButtonGroupView.prototype.initialize = function (options) {
        RadioButtonGroupView.__super__.initialize.call(this, options);
        this.render();
        return this.listenTo(this.model, 'change', this.render);
    };
    RadioButtonGroupView.prototype.render = function () {
        var $input, $label, active, html, i, j, label, len, name, ref;
        RadioButtonGroupView.__super__.render.call(this);
        this.$el.empty();
        html = this.template();
        this.$el.append(html);
        name = _.uniqueId("RadioButtonGroup");
        active = this.model.active;
        ref = this.model.labels;
        for (i = j = 0, len = ref.length; j < len; i = ++j) {
            label = ref[i];
            $input = $('<input type="radio">').attr({
                name: name,
                value: "" + i
            });
            if (i === active) {
                $input.prop("checked", true);
            }
            $label = $('<label class="bk-bs-btn"></label>');
            $label.text(label).prepend($input);
            $label.addClass("bk-bs-btn-" + this.model.button_type);
            if (i === active) {
                $label.addClass("bk-bs-active");
            }
            this.$el.find('.bk-bs-btn-group').append($label);
        }
        return this;
    };
    RadioButtonGroupView.prototype.change_input = function () {
        var active, i, radio, ref;
        active = (function () {
            var j, len, ref, results;
            ref = this.$el.find("input");
            results = [];
            for (i = j = 0, len = ref.length; j < len; i = ++j) {
                radio = ref[i];
                if (radio.checked) {
                    results.push(i);
                }
            }
            return results;
        }).call(this);
        this.model.active = active[0];
        return (ref = this.model.callback) != null ? ref.execute(this.model) : void 0;
    };
    return RadioButtonGroupView;
})(widget_1.WidgetView);
exports.RadioButtonGroup = (function (superClass) {
    extend(RadioButtonGroup, superClass);
    function RadioButtonGroup() {
        return RadioButtonGroup.__super__.constructor.apply(this, arguments);
    }
    RadioButtonGroup.prototype.type = "RadioButtonGroup";
    RadioButtonGroup.prototype.default_view = exports.RadioButtonGroupView;
    RadioButtonGroup.define({
        active: [p.Any, null],
        labels: [p.Array, []],
        button_type: [p.String, "default"],
        callback: [p.Instance]
    });
    return RadioButtonGroup;
})(widget_1.Widget);

},{"../../core/properties":"core/properties","./button_group_template":"models/widgets/button_group_template","./widget":"models/widgets/widget","bootstrap/button":"bootstrap/button","jquery":"jquery","underscore":"underscore"}],"models/widgets/radio_group":[function(require,module,exports){
"use strict";
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var _ = require("underscore");
var $ = require("jquery");
var p = require("../../core/properties");
var widget_1 = require("./widget");
exports.RadioGroupView = (function (superClass) {
    extend(RadioGroupView, superClass);
    function RadioGroupView() {
        return RadioGroupView.__super__.constructor.apply(this, arguments);
    }
    RadioGroupView.prototype.tagName = "div";
    RadioGroupView.prototype.events = {
        "change input": "change_input"
    };
    RadioGroupView.prototype.initialize = function (options) {
        RadioGroupView.__super__.initialize.call(this, options);
        this.render();
        return this.listenTo(this.model, 'change', this.render);
    };
    RadioGroupView.prototype.render = function () {
        var $div, $input, $label, active, i, j, label, len, name, ref;
        RadioGroupView.__super__.render.call(this);
        this.$el.empty();
        name = _.uniqueId("RadioGroup");
        active = this.model.active;
        ref = this.model.labels;
        for (i = j = 0, len = ref.length; j < len; i = ++j) {
            label = ref[i];
            $input = $('<input type="radio">').attr({
                name: name,
                value: "" + i
            });
            if (this.model.disabled) {
                $input.prop("disabled", true);
            }
            if (i === active) {
                $input.prop("checked", true);
            }
            $label = $('<label></label>').text(label).prepend($input);
            if (this.model.inline) {
                $label.addClass("bk-bs-radio-inline");
                this.$el.append($label);
            }
            else {
                $div = $('<div class="bk-bs-radio"></div>').append($label);
                this.$el.append($div);
            }
        }
        return this;
    };
    RadioGroupView.prototype.change_input = function () {
        var active, i, radio, ref;
        active = (function () {
            var j, len, ref, results;
            ref = this.$el.find("input");
            results = [];
            for (i = j = 0, len = ref.length; j < len; i = ++j) {
                radio = ref[i];
                if (radio.checked) {
                    results.push(i);
                }
            }
            return results;
        }).call(this);
        this.model.active = active[0];
        return (ref = this.model.callback) != null ? ref.execute(this.model) : void 0;
    };
    return RadioGroupView;
})(widget_1.WidgetView);
exports.RadioGroup = (function (superClass) {
    extend(RadioGroup, superClass);
    function RadioGroup() {
        return RadioGroup.__super__.constructor.apply(this, arguments);
    }
    RadioGroup.prototype.type = "RadioGroup";
    RadioGroup.prototype.default_view = exports.RadioGroupView;
    RadioGroup.define({
        active: [p.Any, null],
        labels: [p.Array, []],
        inline: [p.Bool, false],
        callback: [p.Instance]
    });
    return RadioGroup;
})(widget_1.Widget);

},{"../../core/properties":"core/properties","./widget":"models/widgets/widget","jquery":"jquery","underscore":"underscore"}],"models/widgets/range_slider":[function(require,module,exports){
"use strict";
var bind = function (fn, me) { return function () { return fn.apply(me, arguments); }; }, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var _ = require("underscore");
require("jquery-ui/slider");
var logging_1 = require("../../core/logging");
var p = require("../../core/properties");
var input_widget_1 = require("./input_widget");
var slidertemplate_1 = require("./slidertemplate");
exports.RangeSliderView = (function (superClass) {
    extend(RangeSliderView, superClass);
    function RangeSliderView() {
        this.slide = bind(this.slide, this);
        this.slidestop = bind(this.slidestop, this);
        return RangeSliderView.__super__.constructor.apply(this, arguments);
    }
    RangeSliderView.prototype.tagName = "div";
    RangeSliderView.prototype.template = slidertemplate_1.default;
    RangeSliderView.prototype.initialize = function (options) {
        var html;
        RangeSliderView.__super__.initialize.call(this, options);
        this.listenTo(this.model, 'change', this.render);
        this.$el.empty();
        html = this.template(this.model.attributes);
        this.$el.html(html);
        this.callbackWrapper = null;
        if (this.model.callback_policy === 'continuous') {
            this.callbackWrapper = function () {
                var ref;
                return (ref = this.model.callback) != null ? ref.execute(this.model) : void 0;
            };
        }
        if (this.model.callback_policy === 'throttle' && this.model.callback) {
            this.callbackWrapper = _.throttle(function () {
                var ref;
                return (ref = this.model.callback) != null ? ref.execute(this.model) : void 0;
            }, this.model.callback_throttle);
        }
        return this.render();
    };
    RangeSliderView.prototype.render = function () {
        var bk_handle, max, min, opts, step;
        RangeSliderView.__super__.render.call(this);
        max = this.model.end;
        min = this.model.start;
        step = this.model.step || ((max - min) / 50);
        logging_1.logger.debug("range-slider render: min, max, step = (" + min + ", " + max + ", " + step + ")");
        opts = {
            range: true,
            orientation: this.model.orientation,
            animate: "fast",
            values: this.model.range,
            min: min,
            max: max,
            step: step,
            stop: this.slidestop,
            slide: this.slide
        };
        this.$el.find('.slider').slider(opts);
        if (this.model.title != null) {
            this.$el.find("#" + this.model.id).val(this.$el.find('.slider').slider('values').join(' - '));
        }
        this.$el.find('.bk-slider-parent').height(this.model.height);
        bk_handle = this.$el.find('.bk-ui-slider-handle');
        if (bk_handle.length === 2) {
            bk_handle[0].style.left = this.$el.find('.ui-slider-handle')[0].style.left;
            bk_handle[1].style.left = this.$el.find('.ui-slider-handle')[1].style.left;
        }
        return this;
    };
    RangeSliderView.prototype.slidestop = function (event, ui) {
        var ref;
        if (this.model.callback_policy === 'mouseup' || this.model.callback_policy === 'throttle') {
            return (ref = this.model.callback) != null ? ref.execute(this.model) : void 0;
        }
    };
    RangeSliderView.prototype.slide = function (event, ui) {
        var values, values_str;
        values = ui.values;
        values_str = values.join(' - ');
        logging_1.logger.debug("range-slide value = " + values_str);
        if (this.model.title != null) {
            this.$el.find("#" + this.model.id).val(values_str);
        }
        this.model.range = values;
        if (this.callbackWrapper) {
            return this.callbackWrapper();
        }
    };
    return RangeSliderView;
})(input_widget_1.InputWidgetView);
exports.RangeSlider = (function (superClass) {
    extend(RangeSlider, superClass);
    function RangeSlider() {
        return RangeSlider.__super__.constructor.apply(this, arguments);
    }
    RangeSlider.prototype.type = "RangeSlider";
    RangeSlider.prototype.default_view = exports.RangeSliderView;
    RangeSlider.define({
        range: [p.Any, [0.1, 0.9]],
        start: [p.Number, 0],
        end: [p.Number, 1],
        step: [p.Number, 0.1],
        orientation: [p.Orientation, "horizontal"],
        callback_throttle: [p.Number, 200],
        callback_policy: [p.String, "throttle"]
    });
    return RangeSlider;
})(input_widget_1.InputWidget);

},{"../../core/logging":"core/logging","../../core/properties":"core/properties","./input_widget":"models/widgets/input_widget","./slidertemplate":"models/widgets/slidertemplate","jquery-ui/slider":"jquery-ui/slider","underscore":"underscore"}],"models/widgets/selectbox":[function(require,module,exports){
"use strict";
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var logging_1 = require("../../core/logging");
var p = require("../../core/properties");
var input_widget_1 = require("./input_widget");
var selecttemplate_1 = require("./selecttemplate");
exports.SelectView = (function (superClass) {
    extend(SelectView, superClass);
    function SelectView() {
        return SelectView.__super__.constructor.apply(this, arguments);
    }
    SelectView.prototype.template = selecttemplate_1.default;
    SelectView.prototype.events = {
        "change select": "change_input"
    };
    SelectView.prototype.initialize = function (options) {
        SelectView.__super__.initialize.call(this, options);
        this.render();
        return this.listenTo(this.model, 'change', this.render);
    };
    SelectView.prototype.render = function () {
        var html;
        SelectView.__super__.render.call(this);
        this.$el.empty();
        html = this.template(this.model.attributes);
        this.$el.html(html);
        return this;
    };
    SelectView.prototype.change_input = function () {
        var value;
        value = this.$el.find('select').val();
        logging_1.logger.debug("selectbox: value = " + value);
        this.model.value = value;
        return SelectView.__super__.change_input.call(this);
    };
    return SelectView;
})(input_widget_1.InputWidgetView);
exports.Select = (function (superClass) {
    extend(Select, superClass);
    function Select() {
        return Select.__super__.constructor.apply(this, arguments);
    }
    Select.prototype.type = "Select";
    Select.prototype.default_view = exports.SelectView;
    Select.define({
        value: [p.String, ''],
        options: [p.Any, []]
    });
    return Select;
})(input_widget_1.InputWidget);

},{"../../core/logging":"core/logging","../../core/properties":"core/properties","./input_widget":"models/widgets/input_widget","./selecttemplate":"models/widgets/selecttemplate"}],"models/widgets/selecttemplate":[function(require,module,exports){
"use strict";
var _ = require("underscore");
var DOM = require("../../core/util/dom");
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = function (props) {
    return (DOM.createElement("fragment", null,
        DOM.createElement("label", { for: props.id },
            " ",
            props.title,
            " "),
        DOM.createElement("select", { class: "bk-widget-form-input", id: props.id, name: props.name }, props.options.map(function (option) {
            var value, label;
            if (_.isString(option)) {
                value = label = option;
            }
            else {
                value = option[0], label = option[1];
            }
            var selected = props.value == value;
            return DOM.createElement("option", { selected: selected, value: value }, label);
        }))));
};

},{"../../core/util/dom":"core/util/dom","underscore":"underscore"}],"models/widgets/slider":[function(require,module,exports){
"use strict";
var bind = function (fn, me) { return function () { return fn.apply(me, arguments); }; }, extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var _ = require("underscore");
require("jquery-ui/slider");
var logging_1 = require("../../core/logging");
var p = require("../../core/properties");
var input_widget_1 = require("./input_widget");
var slidertemplate_1 = require("./slidertemplate");
exports.SliderView = (function (superClass) {
    extend(SliderView, superClass);
    function SliderView() {
        this.slide = bind(this.slide, this);
        this.slidestop = bind(this.slidestop, this);
        return SliderView.__super__.constructor.apply(this, arguments);
    }
    SliderView.prototype.tagName = "div";
    SliderView.prototype.template = slidertemplate_1.default;
    SliderView.prototype.initialize = function (options) {
        var html;
        SliderView.__super__.initialize.call(this, options);
        this.listenTo(this.model, 'change', this.render);
        this.$el.empty();
        html = this.template(this.model.attributes);
        this.$el.html(html);
        this.callbackWrapper = null;
        if (this.model.callback_policy === 'continuous') {
            this.callbackWrapper = function () {
                var ref;
                return (ref = this.model.callback) != null ? ref.execute(this.model) : void 0;
            };
        }
        if (this.model.callback_policy === 'throttle' && this.model.callback) {
            this.callbackWrapper = _.throttle(function () {
                var ref;
                return (ref = this.model.callback) != null ? ref.execute(this.model) : void 0;
            }, this.model.callback_throttle);
        }
        return this.render();
    };
    SliderView.prototype.render = function () {
        var max, min, opts, step;
        SliderView.__super__.render.call(this);
        max = this.model.end;
        min = this.model.start;
        step = this.model.step || ((max - min) / 50);
        logging_1.logger.debug("slider render: min, max, step = (" + min + ", " + max + ", " + step + ")");
        opts = {
            orientation: this.model.orientation,
            animate: "fast",
            value: this.model.value,
            min: min,
            max: max,
            step: step,
            stop: this.slidestop,
            slide: this.slide
        };
        this.$el.find('.slider').slider(opts);
        if (this.model.title != null) {
            this.$el.find("#" + this.model.id).val(this.$el.find('.slider').slider('value'));
        }
        this.$el.find('.bk-slider-parent').height(this.model.height);
        return this;
    };
    SliderView.prototype.slidestop = function (event, ui) {
        var ref;
        if (this.model.callback_policy === 'mouseup' || this.model.callback_policy === 'throttle') {
            return (ref = this.model.callback) != null ? ref.execute(this.model) : void 0;
        }
    };
    SliderView.prototype.slide = function (event, ui) {
        var value;
        value = ui.value;
        logging_1.logger.debug("slide value = " + value);
        if (this.model.title != null) {
            this.$el.find("#" + this.model.id).val(ui.value);
        }
        this.model.value = value;
        if (this.callbackWrapper) {
            return this.callbackWrapper();
        }
    };
    return SliderView;
})(input_widget_1.InputWidgetView);
exports.Slider = (function (superClass) {
    extend(Slider, superClass);
    function Slider() {
        return Slider.__super__.constructor.apply(this, arguments);
    }
    Slider.prototype.type = "Slider";
    Slider.prototype.default_view = exports.SliderView;
    Slider.define({
        value: [p.Number, 0.5],
        start: [p.Number, 0],
        end: [p.Number, 1],
        step: [p.Number, 0.1],
        orientation: [p.Orientation, "horizontal"],
        callback_throttle: [p.Number, 200],
        callback_policy: [p.String, "throttle"]
    });
    return Slider;
})(input_widget_1.InputWidget);

},{"../../core/logging":"core/logging","../../core/properties":"core/properties","./input_widget":"models/widgets/input_widget","./slidertemplate":"models/widgets/slidertemplate","jquery-ui/slider":"jquery-ui/slider","underscore":"underscore"}],"models/widgets/slidertemplate":[function(require,module,exports){
"use strict";
var DOM = require("../../core/util/dom");
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = function (props) {
    var title, value;
    if (props.title != null) {
        if (props.title.length != 0) {
            title = DOM.createElement("label", { for: props.id },
                " ",
                props.title,
                ": ");
        }
        value = DOM.createElement("input", { type: "text", id: props.id, readonly: true });
    }
    return (DOM.createElement("div", { class: "bk-slider-parent" },
        title,
        value,
        DOM.createElement("div", { class: "bk-slider-" + props.orientation },
            DOM.createElement("div", { class: "slider", id: props.id }))));
};

},{"../../core/util/dom":"core/util/dom"}],"models/widgets/table_column":[function(require,module,exports){
"use strict";
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var _ = require("underscore");
var cell_formatters_1 = require("./cell_formatters");
var cell_editors_1 = require("./cell_editors");
var p = require("../../core/properties");
var model_1 = require("../../model");
exports.TableColumn = (function (superClass) {
    extend(TableColumn, superClass);
    function TableColumn() {
        return TableColumn.__super__.constructor.apply(this, arguments);
    }
    TableColumn.prototype.type = 'TableColumn';
    TableColumn.prototype.default_view = null;
    TableColumn.define({
        field: [p.String],
        title: [p.String],
        width: [p.Number, 300],
        formatter: [
            p.Instance, function () {
                return new cell_formatters_1.StringFormatter();
            }
        ],
        editor: [
            p.Instance, function () {
                return new cell_editors_1.StringEditor();
            }
        ],
        sortable: [p.Bool, true],
        default_sort: [p.String, "ascending"]
    });
    TableColumn.prototype.toColumn = function () {
        var ref;
        return {
            id: _.uniqueId(),
            field: this.field,
            name: this.title,
            width: this.width,
            formatter: (ref = this.formatter) != null ? ref.doFormat.bind(this.formatter) : void 0,
            editor: this.editor,
            sortable: this.sortable,
            defaultSortAsc: this.default_sort === "ascending"
        };
    };
    return TableColumn;
})(model_1.Model);

},{"../../core/properties":"core/properties","../../model":"model","./cell_editors":"models/widgets/cell_editors","./cell_formatters":"models/widgets/cell_formatters","underscore":"underscore"}],"models/widgets/table_widget":[function(require,module,exports){
"use strict";
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var widget_1 = require("./widget");
var p = require("../../core/properties");
exports.TableWidget = (function (superClass) {
    extend(TableWidget, superClass);
    function TableWidget() {
        return TableWidget.__super__.constructor.apply(this, arguments);
    }
    TableWidget.prototype.type = "TableWidget";
    TableWidget.define({
        source: [p.Instance]
    });
    return TableWidget;
})(widget_1.Widget);

},{"../../core/properties":"core/properties","./widget":"models/widgets/widget"}],"models/widgets/tabs":[function(require,module,exports){
"use strict";
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var _ = require("underscore");
var $ = require("jquery");
require("bootstrap/tab");
var p = require("../../core/properties");
var tabs_template_1 = require("./tabs_template");
var widget_1 = require("./widget");
exports.TabsView = (function (superClass) {
    extend(TabsView, superClass);
    function TabsView() {
        return TabsView.__super__.constructor.apply(this, arguments);
    }
    TabsView.prototype.render = function () {
        var $panels, active, child, children, html, i, key, len, panel, ref, ref1, ref2, tabs, that, val;
        TabsView.__super__.render.call(this);
        ref = this.child_views;
        for (key in ref) {
            if (!hasProp.call(ref, key))
                continue;
            val = ref[key];
            val.$el.detach();
        }
        this.$el.empty();
        tabs = this.model.tabs;
        active = this.model.active;
        children = this.model.children;
        html = $(tabs_template_1.default({
            tabs: tabs,
            active_tab_id: tabs[active].id
        }));
        that = this;
        html.find(".bk-bs-nav a").click(function (event) {
            var panelId, panelIdx, ref1;
            event.preventDefault();
            $(this).tab('show');
            panelId = $(this).attr('href').replace('#tab-', '');
            tabs = that.model.tabs;
            panelIdx = _.findIndex(tabs, function (panel) {
                return panel.id === panelId;
            });
            that.model.active = panelIdx;
            return (ref1 = that.model.callback) != null ? ref1.execute(that.model) : void 0;
        });
        $panels = html.find(".bk-bs-tab-pane");
        ref1 = _.zip(children, $panels);
        for (i = 0, len = ref1.length; i < len; i++) {
            ref2 = ref1[i], child = ref2[0], panel = ref2[1];
            $(panel).html(this.child_views[child.id].$el);
        }
        this.$el.append(html);
        return this;
    };
    return TabsView;
})(widget_1.WidgetView);
exports.Tabs = (function (superClass) {
    extend(Tabs, superClass);
    function Tabs() {
        return Tabs.__super__.constructor.apply(this, arguments);
    }
    Tabs.prototype.type = "Tabs";
    Tabs.prototype.default_view = exports.TabsView;
    Tabs.define({
        tabs: [p.Array, []],
        active: [p.Number, 0],
        callback: [p.Instance]
    });
    Tabs.getters({
        children: function () {
            var i, len, ref, results, tab;
            ref = this.tabs;
            results = [];
            for (i = 0, len = ref.length; i < len; i++) {
                tab = ref[i];
                results.push(tab.child);
            }
            return results;
        }
    });
    Tabs.prototype.get_layoutable_children = function () {
        return this.children;
    };
    Tabs.prototype.get_edit_variables = function () {
        var child, edit_variables, i, len, ref;
        edit_variables = Tabs.__super__.get_edit_variables.call(this);
        ref = this.get_layoutable_children();
        for (i = 0, len = ref.length; i < len; i++) {
            child = ref[i];
            edit_variables = edit_variables.concat(child.get_edit_variables());
        }
        return edit_variables;
    };
    Tabs.prototype.get_constraints = function () {
        var child, constraints, i, len, ref;
        constraints = Tabs.__super__.get_constraints.call(this);
        ref = this.get_layoutable_children();
        for (i = 0, len = ref.length; i < len; i++) {
            child = ref[i];
            constraints = constraints.concat(child.get_constraints());
        }
        return constraints;
    };
    return Tabs;
})(widget_1.Widget);

},{"../../core/properties":"core/properties","./tabs_template":"models/widgets/tabs_template","./widget":"models/widgets/widget","bootstrap/tab":"bootstrap/tab","jquery":"jquery","underscore":"underscore"}],"models/widgets/tabs_template":[function(require,module,exports){
"use strict";
var DOM = require("../../core/util/dom");
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = function (props) {
    var active = function (tab) { return tab.id === props.active_tab_id ? "bk-bs-active" : null; };
    return (DOM.createElement("fragment", null,
        DOM.createElement("ul", { class: "bk-bs-nav bk-bs-nav-tabs" }, props.tabs.map(function (tab) {
            return DOM.createElement("li", { class: active(tab) },
                DOM.createElement("a", { href: "#tab-" + tab.id }, tab.title));
        })),
        DOM.createElement("div", { class: "bk-bs-tab-content" }, props.tabs.map(function (tab) { return DOM.createElement("div", { class: ["bk-bs-tab-pane", active(tab)], id: "tab-" + tab.id }); }))));
};

},{"../../core/util/dom":"core/util/dom"}],"models/widgets/text_input":[function(require,module,exports){
"use strict";
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var logging_1 = require("../../core/logging");
var p = require("../../core/properties");
var input_widget_1 = require("./input_widget");
var text_input_template_1 = require("./text_input_template");
exports.TextInputView = (function (superClass) {
    extend(TextInputView, superClass);
    function TextInputView() {
        return TextInputView.__super__.constructor.apply(this, arguments);
    }
    TextInputView.prototype.tagName = "div";
    TextInputView.prototype.className = "bk-widget-form-group";
    TextInputView.prototype.template = text_input_template_1.default;
    TextInputView.prototype.events = {
        "change input": "change_input"
    };
    TextInputView.prototype.initialize = function (options) {
        TextInputView.__super__.initialize.call(this, options);
        this.render();
        return this.listenTo(this.model, 'change', this.render);
    };
    TextInputView.prototype.render = function () {
        TextInputView.__super__.render.call(this);
        this.$el.html(this.template(this.model.attributes));
        if (this.model.height) {
            this.$el.find('input').height(this.model.height - 35);
        }
        return this;
    };
    TextInputView.prototype.change_input = function () {
        var value;
        value = this.$el.find('input').val();
        logging_1.logger.debug("widget/text_input: value = " + value);
        this.model.value = value;
        return TextInputView.__super__.change_input.call(this);
    };
    return TextInputView;
})(input_widget_1.InputWidgetView);
exports.TextInput = (function (superClass) {
    extend(TextInput, superClass);
    function TextInput() {
        return TextInput.__super__.constructor.apply(this, arguments);
    }
    TextInput.prototype.type = "TextInput";
    TextInput.prototype.default_view = exports.TextInputView;
    TextInput.define({
        value: [p.String, ""],
        placeholder: [p.String, ""]
    });
    return TextInput;
})(input_widget_1.InputWidget);

},{"../../core/logging":"core/logging","../../core/properties":"core/properties","./input_widget":"models/widgets/input_widget","./text_input_template":"models/widgets/text_input_template"}],"models/widgets/text_input_template":[function(require,module,exports){
"use strict";
var DOM = require("../../core/util/dom");
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = function (props) {
    return (DOM.createElement("fragment", null,
        DOM.createElement("label", { for: props.id },
            " ",
            props.title,
            " "),
        DOM.createElement("input", { class: "bk-widget-form-input", type: "text", id: props.id, name: props.name, value: props.value, placeholder: props.placeholder })));
};

},{"../../core/util/dom":"core/util/dom"}],"models/widgets/toggle":[function(require,module,exports){
"use strict";
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var p = require("../../core/properties");
var abstract_button_1 = require("./abstract_button");
exports.ToggleView = (function (superClass) {
    extend(ToggleView, superClass);
    function ToggleView() {
        return ToggleView.__super__.constructor.apply(this, arguments);
    }
    ToggleView.prototype.render = function () {
        ToggleView.__super__.render.call(this);
        if (this.model.active) {
            this.$el.find('button').addClass("bk-bs-active");
        }
        else {
            this.$el.find('button').removeClass("bk-bs-active");
        }
        return this;
    };
    ToggleView.prototype.change_input = function () {
        ToggleView.__super__.change_input.call(this);
        return this.model.active = !this.model.active;
    };
    return ToggleView;
})(abstract_button_1.AbstractButtonView);
exports.Toggle = (function (superClass) {
    extend(Toggle, superClass);
    function Toggle() {
        return Toggle.__super__.constructor.apply(this, arguments);
    }
    Toggle.prototype.type = "Toggle";
    Toggle.prototype.default_view = exports.ToggleView;
    Toggle.define({
        active: [p.Bool, false]
    });
    Toggle.override({
        label: "Toggle"
    });
    return Toggle;
})(abstract_button_1.AbstractButton);

},{"../../core/properties":"core/properties","./abstract_button":"models/widgets/abstract_button"}],"models/widgets/widget":[function(require,module,exports){
"use strict";
var extend = function (child, parent) { for (var key in parent) {
    if (hasProp.call(parent, key))
        child[key] = parent[key];
} function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; }, hasProp = {}.hasOwnProperty;
var layout_dom_1 = require("../layouts/layout_dom");
exports.WidgetView = (function (superClass) {
    extend(WidgetView, superClass);
    function WidgetView() {
        return WidgetView.__super__.constructor.apply(this, arguments);
    }
    WidgetView.prototype.className = "bk-widget";
    WidgetView.prototype.render = function () {
        if (this.model.height) {
            this.$el.height(this.model.height);
        }
        if (this.model.width) {
            return this.$el.width(this.model.width);
        }
    };
    return WidgetView;
})(layout_dom_1.LayoutDOMView);
exports.Widget = (function (superClass) {
    extend(Widget, superClass);
    function Widget() {
        return Widget.__super__.constructor.apply(this, arguments);
    }
    Widget.prototype.type = "Widget";
    Widget.prototype.default_view = exports.WidgetView;
    return Widget;
})(layout_dom_1.LayoutDOM);

},{"../layouts/layout_dom":"models/layouts/layout_dom"}],"jquery-ui/autocomplete":[function(require,module,exports){
var jQuery = require('jquery');
require('./core');
require('./widget');
require('./position');
require('./menu');

/*!
 * jQuery UI Autocomplete 1.10.4
 * http://jqueryui.com
 *
 * Copyright 2014 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/autocomplete/
 *
 * Depends:
 *	jquery.ui.core.js
 *	jquery.ui.widget.js
 *	jquery.ui.position.js
 *	jquery.ui.menu.js
 */
(function( $, undefined ) {

$.widget( "ui.autocomplete", {
	version: "1.10.4",
	defaultElement: "<input>",
	options: {
		appendTo: null,
		autoFocus: false,
		delay: 300,
		minLength: 1,
		position: {
			my: "left top",
			at: "left bottom",
			collision: "none"
		},
		source: null,

		// callbacks
		change: null,
		close: null,
		focus: null,
		open: null,
		response: null,
		search: null,
		select: null
	},

	requestIndex: 0,
	pending: 0,

	_create: function() {
		// Some browsers only repeat keydown events, not keypress events,
		// so we use the suppressKeyPress flag to determine if we've already
		// handled the keydown event. #7269
		// Unfortunately the code for & in keypress is the same as the up arrow,
		// so we use the suppressKeyPressRepeat flag to avoid handling keypress
		// events when we know the keydown event was used to modify the
		// search term. #7799
		var suppressKeyPress, suppressKeyPressRepeat, suppressInput,
			nodeName = this.element[0].nodeName.toLowerCase(),
			isTextarea = nodeName === "textarea",
			isInput = nodeName === "input";

		this.isMultiLine =
			// Textareas are always multi-line
			isTextarea ? true :
			// Inputs are always single-line, even if inside a contentEditable element
			// IE also treats inputs as contentEditable
			isInput ? false :
			// All other element types are determined by whether or not they're contentEditable
			this.element.prop( "isContentEditable" );

		this.valueMethod = this.element[ isTextarea || isInput ? "val" : "text" ];
		this.isNewMenu = true;

		this.element
			.addClass( "ui-autocomplete-input" )
			.attr( "autocomplete", "off" );

		this._on( this.element, {
			keydown: function( event ) {
				if ( this.element.prop( "readOnly" ) ) {
					suppressKeyPress = true;
					suppressInput = true;
					suppressKeyPressRepeat = true;
					return;
				}

				suppressKeyPress = false;
				suppressInput = false;
				suppressKeyPressRepeat = false;
				var keyCode = $.ui.keyCode;
				switch( event.keyCode ) {
				case keyCode.PAGE_UP:
					suppressKeyPress = true;
					this._move( "previousPage", event );
					break;
				case keyCode.PAGE_DOWN:
					suppressKeyPress = true;
					this._move( "nextPage", event );
					break;
				case keyCode.UP:
					suppressKeyPress = true;
					this._keyEvent( "previous", event );
					break;
				case keyCode.DOWN:
					suppressKeyPress = true;
					this._keyEvent( "next", event );
					break;
				case keyCode.ENTER:
				case keyCode.NUMPAD_ENTER:
					// when menu is open and has focus
					if ( this.menu.active ) {
						// #6055 - Opera still allows the keypress to occur
						// which causes forms to submit
						suppressKeyPress = true;
						event.preventDefault();
						this.menu.select( event );
					}
					break;
				case keyCode.TAB:
					if ( this.menu.active ) {
						this.menu.select( event );
					}
					break;
				case keyCode.ESCAPE:
					if ( this.menu.element.is( ":visible" ) ) {
						this._value( this.term );
						this.close( event );
						// Different browsers have different default behavior for escape
						// Single press can mean undo or clear
						// Double press in IE means clear the whole form
						event.preventDefault();
					}
					break;
				default:
					suppressKeyPressRepeat = true;
					// search timeout should be triggered before the input value is changed
					this._searchTimeout( event );
					break;
				}
			},
			keypress: function( event ) {
				if ( suppressKeyPress ) {
					suppressKeyPress = false;
					if ( !this.isMultiLine || this.menu.element.is( ":visible" ) ) {
						event.preventDefault();
					}
					return;
				}
				if ( suppressKeyPressRepeat ) {
					return;
				}

				// replicate some key handlers to allow them to repeat in Firefox and Opera
				var keyCode = $.ui.keyCode;
				switch( event.keyCode ) {
				case keyCode.PAGE_UP:
					this._move( "previousPage", event );
					break;
				case keyCode.PAGE_DOWN:
					this._move( "nextPage", event );
					break;
				case keyCode.UP:
					this._keyEvent( "previous", event );
					break;
				case keyCode.DOWN:
					this._keyEvent( "next", event );
					break;
				}
			},
			input: function( event ) {
				if ( suppressInput ) {
					suppressInput = false;
					event.preventDefault();
					return;
				}
				this._searchTimeout( event );
			},
			focus: function() {
				this.selectedItem = null;
				this.previous = this._value();
			},
			blur: function( event ) {
				if ( this.cancelBlur ) {
					delete this.cancelBlur;
					return;
				}

				clearTimeout( this.searching );
				this.close( event );
				this._change( event );
			}
		});

		this._initSource();
		this.menu = $( "<ul>" )
			.addClass( "ui-autocomplete ui-front" )
			.appendTo( this._appendTo() )
			.menu({
				// disable ARIA support, the live region takes care of that
				role: null
			})
			.hide()
			.data( "ui-menu" );

		this._on( this.menu.element, {
			mousedown: function( event ) {
				// prevent moving focus out of the text field
				event.preventDefault();

				// IE doesn't prevent moving focus even with event.preventDefault()
				// so we set a flag to know when we should ignore the blur event
				this.cancelBlur = true;
				this._delay(function() {
					delete this.cancelBlur;
				});

				// clicking on the scrollbar causes focus to shift to the body
				// but we can't detect a mouseup or a click immediately afterward
				// so we have to track the next mousedown and close the menu if
				// the user clicks somewhere outside of the autocomplete
				var menuElement = this.menu.element[ 0 ];
				if ( !$( event.target ).closest( ".ui-menu-item" ).length ) {
					this._delay(function() {
						var that = this;
						this.document.one( "mousedown", function( event ) {
							if ( event.target !== that.element[ 0 ] &&
									event.target !== menuElement &&
									!$.contains( menuElement, event.target ) ) {
								that.close();
							}
						});
					});
				}
			},
			menufocus: function( event, ui ) {
				// support: Firefox
				// Prevent accidental activation of menu items in Firefox (#7024 #9118)
				if ( this.isNewMenu ) {
					this.isNewMenu = false;
					if ( event.originalEvent && /^mouse/.test( event.originalEvent.type ) ) {
						this.menu.blur();

						this.document.one( "mousemove", function() {
							$( event.target ).trigger( event.originalEvent );
						});

						return;
					}
				}

				var item = ui.item.data( "ui-autocomplete-item" );
				if ( false !== this._trigger( "focus", event, { item: item } ) ) {
					// use value to match what will end up in the input, if it was a key event
					if ( event.originalEvent && /^key/.test( event.originalEvent.type ) ) {
						this._value( item.value );
					}
				} else {
					// Normally the input is populated with the item's value as the
					// menu is navigated, causing screen readers to notice a change and
					// announce the item. Since the focus event was canceled, this doesn't
					// happen, so we update the live region so that screen readers can
					// still notice the change and announce it.
					this.liveRegion.text( item.value );
				}
			},
			menuselect: function( event, ui ) {
				var item = ui.item.data( "ui-autocomplete-item" ),
					previous = this.previous;

				// only trigger when focus was lost (click on menu)
				if ( this.element[0] !== this.document[0].activeElement ) {
					this.element.focus();
					this.previous = previous;
					// #6109 - IE triggers two focus events and the second
					// is asynchronous, so we need to reset the previous
					// term synchronously and asynchronously :-(
					this._delay(function() {
						this.previous = previous;
						this.selectedItem = item;
					});
				}

				if ( false !== this._trigger( "select", event, { item: item } ) ) {
					this._value( item.value );
				}
				// reset the term after the select event
				// this allows custom select handling to work properly
				this.term = this._value();

				this.close( event );
				this.selectedItem = item;
			}
		});

		this.liveRegion = $( "<span>", {
				role: "status",
				"aria-live": "polite"
			})
			.addClass( "ui-helper-hidden-accessible" )
			.insertBefore( this.element );

		// turning off autocomplete prevents the browser from remembering the
		// value when navigating through history, so we re-enable autocomplete
		// if the page is unloaded before the widget is destroyed. #7790
		this._on( this.window, {
			beforeunload: function() {
				this.element.removeAttr( "autocomplete" );
			}
		});
	},

	_destroy: function() {
		clearTimeout( this.searching );
		this.element
			.removeClass( "ui-autocomplete-input" )
			.removeAttr( "autocomplete" );
		this.menu.element.remove();
		this.liveRegion.remove();
	},

	_setOption: function( key, value ) {
		this._super( key, value );
		if ( key === "source" ) {
			this._initSource();
		}
		if ( key === "appendTo" ) {
			this.menu.element.appendTo( this._appendTo() );
		}
		if ( key === "disabled" && value && this.xhr ) {
			this.xhr.abort();
		}
	},

	_appendTo: function() {
		var element = this.options.appendTo;

		if ( element ) {
			element = element.jquery || element.nodeType ?
				$( element ) :
				this.document.find( element ).eq( 0 );
		}

		if ( !element ) {
			element = this.element.closest( ".ui-front" );
		}

		if ( !element.length ) {
			element = this.document[0].body;
		}

		return element;
	},

	_initSource: function() {
		var array, url,
			that = this;
		if ( $.isArray(this.options.source) ) {
			array = this.options.source;
			this.source = function( request, response ) {
				response( $.ui.autocomplete.filter( array, request.term ) );
			};
		} else if ( typeof this.options.source === "string" ) {
			url = this.options.source;
			this.source = function( request, response ) {
				if ( that.xhr ) {
					that.xhr.abort();
				}
				that.xhr = $.ajax({
					url: url,
					data: request,
					dataType: "json",
					success: function( data ) {
						response( data );
					},
					error: function() {
						response( [] );
					}
				});
			};
		} else {
			this.source = this.options.source;
		}
	},

	_searchTimeout: function( event ) {
		clearTimeout( this.searching );
		this.searching = this._delay(function() {
			// only search if the value has changed
			if ( this.term !== this._value() ) {
				this.selectedItem = null;
				this.search( null, event );
			}
		}, this.options.delay );
	},

	search: function( value, event ) {
		value = value != null ? value : this._value();

		// always save the actual value, not the one passed as an argument
		this.term = this._value();

		if ( value.length < this.options.minLength ) {
			return this.close( event );
		}

		if ( this._trigger( "search", event ) === false ) {
			return;
		}

		return this._search( value );
	},

	_search: function( value ) {
		this.pending++;
		this.element.addClass( "ui-autocomplete-loading" );
		this.cancelSearch = false;

		this.source( { term: value }, this._response() );
	},

	_response: function() {
		var index = ++this.requestIndex;

		return $.proxy(function( content ) {
			if ( index === this.requestIndex ) {
				this.__response( content );
			}

			this.pending--;
			if ( !this.pending ) {
				this.element.removeClass( "ui-autocomplete-loading" );
			}
		}, this );
	},

	__response: function( content ) {
		if ( content ) {
			content = this._normalize( content );
		}
		this._trigger( "response", null, { content: content } );
		if ( !this.options.disabled && content && content.length && !this.cancelSearch ) {
			this._suggest( content );
			this._trigger( "open" );
		} else {
			// use ._close() instead of .close() so we don't cancel future searches
			this._close();
		}
	},

	close: function( event ) {
		this.cancelSearch = true;
		this._close( event );
	},

	_close: function( event ) {
		if ( this.menu.element.is( ":visible" ) ) {
			this.menu.element.hide();
			this.menu.blur();
			this.isNewMenu = true;
			this._trigger( "close", event );
		}
	},

	_change: function( event ) {
		if ( this.previous !== this._value() ) {
			this._trigger( "change", event, { item: this.selectedItem } );
		}
	},

	_normalize: function( items ) {
		// assume all items have the right format when the first item is complete
		if ( items.length && items[0].label && items[0].value ) {
			return items;
		}
		return $.map( items, function( item ) {
			if ( typeof item === "string" ) {
				return {
					label: item,
					value: item
				};
			}
			return $.extend({
				label: item.label || item.value,
				value: item.value || item.label
			}, item );
		});
	},

	_suggest: function( items ) {
		var ul = this.menu.element.empty();
		this._renderMenu( ul, items );
		this.isNewMenu = true;
		this.menu.refresh();

		// size and position menu
		ul.show();
		this._resizeMenu();
		ul.position( $.extend({
			of: this.element
		}, this.options.position ));

		if ( this.options.autoFocus ) {
			this.menu.next();
		}
	},

	_resizeMenu: function() {
		var ul = this.menu.element;
		ul.outerWidth( Math.max(
			// Firefox wraps long text (possibly a rounding bug)
			// so we add 1px to avoid the wrapping (#7513)
			ul.width( "" ).outerWidth() + 1,
			this.element.outerWidth()
		) );
	},

	_renderMenu: function( ul, items ) {
		var that = this;
		$.each( items, function( index, item ) {
			that._renderItemData( ul, item );
		});
	},

	_renderItemData: function( ul, item ) {
		return this._renderItem( ul, item ).data( "ui-autocomplete-item", item );
	},

	_renderItem: function( ul, item ) {
		return $( "<li>" )
			.append( $( "<a>" ).text( item.label ) )
			.appendTo( ul );
	},

	_move: function( direction, event ) {
		if ( !this.menu.element.is( ":visible" ) ) {
			this.search( null, event );
			return;
		}
		if ( this.menu.isFirstItem() && /^previous/.test( direction ) ||
				this.menu.isLastItem() && /^next/.test( direction ) ) {
			this._value( this.term );
			this.menu.blur();
			return;
		}
		this.menu[ direction ]( event );
	},

	widget: function() {
		return this.menu.element;
	},

	_value: function() {
		return this.valueMethod.apply( this.element, arguments );
	},

	_keyEvent: function( keyEvent, event ) {
		if ( !this.isMultiLine || this.menu.element.is( ":visible" ) ) {
			this._move( keyEvent, event );

			// prevents moving cursor to beginning/end of the text field in some browsers
			event.preventDefault();
		}
	}
});

$.extend( $.ui.autocomplete, {
	escapeRegex: function( value ) {
		return value.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g, "\\$&");
	},
	filter: function(array, term) {
		var matcher = new RegExp( $.ui.autocomplete.escapeRegex(term), "i" );
		return $.grep( array, function(value) {
			return matcher.test( value.label || value.value || value );
		});
	}
});


// live region extension, adding a `messages` option
// NOTE: This is an experimental API. We are still investigating
// a full solution for string manipulation and internationalization.
$.widget( "ui.autocomplete", $.ui.autocomplete, {
	options: {
		messages: {
			noResults: "No search results.",
			results: function( amount ) {
				return amount + ( amount > 1 ? " results are" : " result is" ) +
					" available, use up and down arrow keys to navigate.";
			}
		}
	},

	__response: function( content ) {
		var message;
		this._superApply( arguments );
		if ( this.options.disabled || this.cancelSearch ) {
			return;
		}
		if ( content && content.length ) {
			message = this.options.messages.results( content.length );
		} else {
			message = this.options.messages.noResults;
		}
		this.liveRegion.text( message );
	}
});

}( jQuery ));

},{"./core":"jquery-ui/core","./menu":"jquery-ui/menu","./position":"jquery-ui/position","./widget":"jquery-ui/widget","jquery":"jquery"}],"jquery-ui/button":[function(require,module,exports){
var jQuery = require('jquery');
require('./core');
require('./widget');

/*!
 * jQuery UI Button 1.10.4
 * http://jqueryui.com
 *
 * Copyright 2014 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/button/
 *
 * Depends:
 *	jquery.ui.core.js
 *	jquery.ui.widget.js
 */
(function( $, undefined ) {

var lastActive,
	baseClasses = "ui-button ui-widget ui-state-default ui-corner-all",
	typeClasses = "ui-button-icons-only ui-button-icon-only ui-button-text-icons ui-button-text-icon-primary ui-button-text-icon-secondary ui-button-text-only",
	formResetHandler = function() {
		var form = $( this );
		setTimeout(function() {
			form.find( ":ui-button" ).button( "refresh" );
		}, 1 );
	},
	radioGroup = function( radio ) {
		var name = radio.name,
			form = radio.form,
			radios = $( [] );
		if ( name ) {
			name = name.replace( /'/g, "\\'" );
			if ( form ) {
				radios = $( form ).find( "[name='" + name + "']" );
			} else {
				radios = $( "[name='" + name + "']", radio.ownerDocument )
					.filter(function() {
						return !this.form;
					});
			}
		}
		return radios;
	};

$.widget( "ui.button", {
	version: "1.10.4",
	defaultElement: "<button>",
	options: {
		disabled: null,
		text: true,
		label: null,
		icons: {
			primary: null,
			secondary: null
		}
	},
	_create: function() {
		this.element.closest( "form" )
			.unbind( "reset" + this.eventNamespace )
			.bind( "reset" + this.eventNamespace, formResetHandler );

		if ( typeof this.options.disabled !== "boolean" ) {
			this.options.disabled = !!this.element.prop( "disabled" );
		} else {
			this.element.prop( "disabled", this.options.disabled );
		}

		this._determineButtonType();
		this.hasTitle = !!this.buttonElement.attr( "title" );

		var that = this,
			options = this.options,
			toggleButton = this.type === "checkbox" || this.type === "radio",
			activeClass = !toggleButton ? "ui-state-active" : "";

		if ( options.label === null ) {
			options.label = (this.type === "input" ? this.buttonElement.val() : this.buttonElement.html());
		}

		this._hoverable( this.buttonElement );

		this.buttonElement
			.addClass( baseClasses )
			.attr( "role", "button" )
			.bind( "mouseenter" + this.eventNamespace, function() {
				if ( options.disabled ) {
					return;
				}
				if ( this === lastActive ) {
					$( this ).addClass( "ui-state-active" );
				}
			})
			.bind( "mouseleave" + this.eventNamespace, function() {
				if ( options.disabled ) {
					return;
				}
				$( this ).removeClass( activeClass );
			})
			.bind( "click" + this.eventNamespace, function( event ) {
				if ( options.disabled ) {
					event.preventDefault();
					event.stopImmediatePropagation();
				}
			});

		// Can't use _focusable() because the element that receives focus
		// and the element that gets the ui-state-focus class are different
		this._on({
			focus: function() {
				this.buttonElement.addClass( "ui-state-focus" );
			},
			blur: function() {
				this.buttonElement.removeClass( "ui-state-focus" );
			}
		});

		if ( toggleButton ) {
			this.element.bind( "change" + this.eventNamespace, function() {
				that.refresh();
			});
		}

		if ( this.type === "checkbox" ) {
			this.buttonElement.bind( "click" + this.eventNamespace, function() {
				if ( options.disabled ) {
					return false;
				}
			});
		} else if ( this.type === "radio" ) {
			this.buttonElement.bind( "click" + this.eventNamespace, function() {
				if ( options.disabled ) {
					return false;
				}
				$( this ).addClass( "ui-state-active" );
				that.buttonElement.attr( "aria-pressed", "true" );

				var radio = that.element[ 0 ];
				radioGroup( radio )
					.not( radio )
					.map(function() {
						return $( this ).button( "widget" )[ 0 ];
					})
					.removeClass( "ui-state-active" )
					.attr( "aria-pressed", "false" );
			});
		} else {
			this.buttonElement
				.bind( "mousedown" + this.eventNamespace, function() {
					if ( options.disabled ) {
						return false;
					}
					$( this ).addClass( "ui-state-active" );
					lastActive = this;
					that.document.one( "mouseup", function() {
						lastActive = null;
					});
				})
				.bind( "mouseup" + this.eventNamespace, function() {
					if ( options.disabled ) {
						return false;
					}
					$( this ).removeClass( "ui-state-active" );
				})
				.bind( "keydown" + this.eventNamespace, function(event) {
					if ( options.disabled ) {
						return false;
					}
					if ( event.keyCode === $.ui.keyCode.SPACE || event.keyCode === $.ui.keyCode.ENTER ) {
						$( this ).addClass( "ui-state-active" );
					}
				})
				// see #8559, we bind to blur here in case the button element loses
				// focus between keydown and keyup, it would be left in an "active" state
				.bind( "keyup" + this.eventNamespace + " blur" + this.eventNamespace, function() {
					$( this ).removeClass( "ui-state-active" );
				});

			if ( this.buttonElement.is("a") ) {
				this.buttonElement.keyup(function(event) {
					if ( event.keyCode === $.ui.keyCode.SPACE ) {
						// TODO pass through original event correctly (just as 2nd argument doesn't work)
						$( this ).click();
					}
				});
			}
		}

		// TODO: pull out $.Widget's handling for the disabled option into
		// $.Widget.prototype._setOptionDisabled so it's easy to proxy and can
		// be overridden by individual plugins
		this._setOption( "disabled", options.disabled );
		this._resetButton();
	},

	_determineButtonType: function() {
		var ancestor, labelSelector, checked;

		if ( this.element.is("[type=checkbox]") ) {
			this.type = "checkbox";
		} else if ( this.element.is("[type=radio]") ) {
			this.type = "radio";
		} else if ( this.element.is("input") ) {
			this.type = "input";
		} else {
			this.type = "button";
		}

		if ( this.type === "checkbox" || this.type === "radio" ) {
			// we don't search against the document in case the element
			// is disconnected from the DOM
			ancestor = this.element.parents().last();
			labelSelector = "label[for='" + this.element.attr("id") + "']";
			this.buttonElement = ancestor.find( labelSelector );
			if ( !this.buttonElement.length ) {
				ancestor = ancestor.length ? ancestor.siblings() : this.element.siblings();
				this.buttonElement = ancestor.filter( labelSelector );
				if ( !this.buttonElement.length ) {
					this.buttonElement = ancestor.find( labelSelector );
				}
			}
			this.element.addClass( "ui-helper-hidden-accessible" );

			checked = this.element.is( ":checked" );
			if ( checked ) {
				this.buttonElement.addClass( "ui-state-active" );
			}
			this.buttonElement.prop( "aria-pressed", checked );
		} else {
			this.buttonElement = this.element;
		}
	},

	widget: function() {
		return this.buttonElement;
	},

	_destroy: function() {
		this.element
			.removeClass( "ui-helper-hidden-accessible" );
		this.buttonElement
			.removeClass( baseClasses + " ui-state-active " + typeClasses )
			.removeAttr( "role" )
			.removeAttr( "aria-pressed" )
			.html( this.buttonElement.find(".ui-button-text").html() );

		if ( !this.hasTitle ) {
			this.buttonElement.removeAttr( "title" );
		}
	},

	_setOption: function( key, value ) {
		this._super( key, value );
		if ( key === "disabled" ) {
			this.element.prop( "disabled", !!value );
			if ( value ) {
				this.buttonElement.removeClass( "ui-state-focus" );
			}
			return;
		}
		this._resetButton();
	},

	refresh: function() {
		//See #8237 & #8828
		var isDisabled = this.element.is( "input, button" ) ? this.element.is( ":disabled" ) : this.element.hasClass( "ui-button-disabled" );

		if ( isDisabled !== this.options.disabled ) {
			this._setOption( "disabled", isDisabled );
		}
		if ( this.type === "radio" ) {
			radioGroup( this.element[0] ).each(function() {
				if ( $( this ).is( ":checked" ) ) {
					$( this ).button( "widget" )
						.addClass( "ui-state-active" )
						.attr( "aria-pressed", "true" );
				} else {
					$( this ).button( "widget" )
						.removeClass( "ui-state-active" )
						.attr( "aria-pressed", "false" );
				}
			});
		} else if ( this.type === "checkbox" ) {
			if ( this.element.is( ":checked" ) ) {
				this.buttonElement
					.addClass( "ui-state-active" )
					.attr( "aria-pressed", "true" );
			} else {
				this.buttonElement
					.removeClass( "ui-state-active" )
					.attr( "aria-pressed", "false" );
			}
		}
	},

	_resetButton: function() {
		if ( this.type === "input" ) {
			if ( this.options.label ) {
				this.element.val( this.options.label );
			}
			return;
		}
		var buttonElement = this.buttonElement.removeClass( typeClasses ),
			buttonText = $( "<span></span>", this.document[0] )
				.addClass( "ui-button-text" )
				.html( this.options.label )
				.appendTo( buttonElement.empty() )
				.text(),
			icons = this.options.icons,
			multipleIcons = icons.primary && icons.secondary,
			buttonClasses = [];

		if ( icons.primary || icons.secondary ) {
			if ( this.options.text ) {
				buttonClasses.push( "ui-button-text-icon" + ( multipleIcons ? "s" : ( icons.primary ? "-primary" : "-secondary" ) ) );
			}

			if ( icons.primary ) {
				buttonElement.prepend( "<span class='ui-button-icon-primary ui-icon " + icons.primary + "'></span>" );
			}

			if ( icons.secondary ) {
				buttonElement.append( "<span class='ui-button-icon-secondary ui-icon " + icons.secondary + "'></span>" );
			}

			if ( !this.options.text ) {
				buttonClasses.push( multipleIcons ? "ui-button-icons-only" : "ui-button-icon-only" );

				if ( !this.hasTitle ) {
					buttonElement.attr( "title", $.trim( buttonText ) );
				}
			}
		} else {
			buttonClasses.push( "ui-button-text-only" );
		}
		buttonElement.addClass( buttonClasses.join( " " ) );
	}
});

$.widget( "ui.buttonset", {
	version: "1.10.4",
	options: {
		items: "button, input[type=button], input[type=submit], input[type=reset], input[type=checkbox], input[type=radio], a, :data(ui-button)"
	},

	_create: function() {
		this.element.addClass( "ui-buttonset" );
	},

	_init: function() {
		this.refresh();
	},

	_setOption: function( key, value ) {
		if ( key === "disabled" ) {
			this.buttons.button( "option", key, value );
		}

		this._super( key, value );
	},

	refresh: function() {
		var rtl = this.element.css( "direction" ) === "rtl";

		this.buttons = this.element.find( this.options.items )
			.filter( ":ui-button" )
				.button( "refresh" )
			.end()
			.not( ":ui-button" )
				.button()
			.end()
			.map(function() {
				return $( this ).button( "widget" )[ 0 ];
			})
				.removeClass( "ui-corner-all ui-corner-left ui-corner-right" )
				.filter( ":first" )
					.addClass( rtl ? "ui-corner-right" : "ui-corner-left" )
				.end()
				.filter( ":last" )
					.addClass( rtl ? "ui-corner-left" : "ui-corner-right" )
				.end()
			.end();
	},

	_destroy: function() {
		this.element.removeClass( "ui-buttonset" );
		this.buttons
			.map(function() {
				return $( this ).button( "widget" )[ 0 ];
			})
				.removeClass( "ui-corner-left ui-corner-right" )
			.end()
			.button( "destroy" );
	}
});

}( jQuery ) );

},{"./core":"jquery-ui/core","./widget":"jquery-ui/widget","jquery":"jquery"}],"jquery-ui/core":[function(require,module,exports){
var jQuery = require('jquery');

/*!
 * jQuery UI Core 1.10.4
 * http://jqueryui.com
 *
 * Copyright 2014 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/category/ui-core/
 */
(function( $, undefined ) {

var uuid = 0,
	runiqueId = /^ui-id-\d+$/;

// $.ui might exist from components with no dependencies, e.g., $.ui.position
$.ui = $.ui || {};

$.extend( $.ui, {
	version: "1.10.4",

	keyCode: {
		BACKSPACE: 8,
		COMMA: 188,
		DELETE: 46,
		DOWN: 40,
		END: 35,
		ENTER: 13,
		ESCAPE: 27,
		HOME: 36,
		LEFT: 37,
		NUMPAD_ADD: 107,
		NUMPAD_DECIMAL: 110,
		NUMPAD_DIVIDE: 111,
		NUMPAD_ENTER: 108,
		NUMPAD_MULTIPLY: 106,
		NUMPAD_SUBTRACT: 109,
		PAGE_DOWN: 34,
		PAGE_UP: 33,
		PERIOD: 190,
		RIGHT: 39,
		SPACE: 32,
		TAB: 9,
		UP: 38
	}
});

// plugins
$.fn.extend({
	focus: (function( orig ) {
		return function( delay, fn ) {
			return typeof delay === "number" ?
				this.each(function() {
					var elem = this;
					setTimeout(function() {
						$( elem ).focus();
						if ( fn ) {
							fn.call( elem );
						}
					}, delay );
				}) :
				orig.apply( this, arguments );
		};
	})( $.fn.focus ),

	scrollParent: function() {
		var scrollParent;
		if (($.ui.ie && (/(static|relative)/).test(this.css("position"))) || (/absolute/).test(this.css("position"))) {
			scrollParent = this.parents().filter(function() {
				return (/(relative|absolute|fixed)/).test($.css(this,"position")) && (/(auto|scroll)/).test($.css(this,"overflow")+$.css(this,"overflow-y")+$.css(this,"overflow-x"));
			}).eq(0);
		} else {
			scrollParent = this.parents().filter(function() {
				return (/(auto|scroll)/).test($.css(this,"overflow")+$.css(this,"overflow-y")+$.css(this,"overflow-x"));
			}).eq(0);
		}

		return (/fixed/).test(this.css("position")) || !scrollParent.length ? $(document) : scrollParent;
	},

	zIndex: function( zIndex ) {
		if ( zIndex !== undefined ) {
			return this.css( "zIndex", zIndex );
		}

		if ( this.length ) {
			var elem = $( this[ 0 ] ), position, value;
			while ( elem.length && elem[ 0 ] !== document ) {
				// Ignore z-index if position is set to a value where z-index is ignored by the browser
				// This makes behavior of this function consistent across browsers
				// WebKit always returns auto if the element is positioned
				position = elem.css( "position" );
				if ( position === "absolute" || position === "relative" || position === "fixed" ) {
					// IE returns 0 when zIndex is not specified
					// other browsers return a string
					// we ignore the case of nested elements with an explicit value of 0
					// <div style="z-index: -10;"><div style="z-index: 0;"></div></div>
					value = parseInt( elem.css( "zIndex" ), 10 );
					if ( !isNaN( value ) && value !== 0 ) {
						return value;
					}
				}
				elem = elem.parent();
			}
		}

		return 0;
	},

	uniqueId: function() {
		return this.each(function() {
			if ( !this.id ) {
				this.id = "ui-id-" + (++uuid);
			}
		});
	},

	removeUniqueId: function() {
		return this.each(function() {
			if ( runiqueId.test( this.id ) ) {
				$( this ).removeAttr( "id" );
			}
		});
	}
});

// selectors
function focusable( element, isTabIndexNotNaN ) {
	var map, mapName, img,
		nodeName = element.nodeName.toLowerCase();
	if ( "area" === nodeName ) {
		map = element.parentNode;
		mapName = map.name;
		if ( !element.href || !mapName || map.nodeName.toLowerCase() !== "map" ) {
			return false;
		}
		img = $( "img[usemap=#" + mapName + "]" )[0];
		return !!img && visible( img );
	}
	return ( /input|select|textarea|button|object/.test( nodeName ) ?
		!element.disabled :
		"a" === nodeName ?
			element.href || isTabIndexNotNaN :
			isTabIndexNotNaN) &&
		// the element and all of its ancestors must be visible
		visible( element );
}

function visible( element ) {
	return $.expr.filters.visible( element ) &&
		!$( element ).parents().addBack().filter(function() {
			return $.css( this, "visibility" ) === "hidden";
		}).length;
}

$.extend( $.expr[ ":" ], {
	data: $.expr.createPseudo ?
		$.expr.createPseudo(function( dataName ) {
			return function( elem ) {
				return !!$.data( elem, dataName );
			};
		}) :
		// support: jQuery <1.8
		function( elem, i, match ) {
			return !!$.data( elem, match[ 3 ] );
		},

	focusable: function( element ) {
		return focusable( element, !isNaN( $.attr( element, "tabindex" ) ) );
	},

	tabbable: function( element ) {
		var tabIndex = $.attr( element, "tabindex" ),
			isTabIndexNaN = isNaN( tabIndex );
		return ( isTabIndexNaN || tabIndex >= 0 ) && focusable( element, !isTabIndexNaN );
	}
});

// support: jQuery <1.8
if ( !$( "<a>" ).outerWidth( 1 ).jquery ) {
	$.each( [ "Width", "Height" ], function( i, name ) {
		var side = name === "Width" ? [ "Left", "Right" ] : [ "Top", "Bottom" ],
			type = name.toLowerCase(),
			orig = {
				innerWidth: $.fn.innerWidth,
				innerHeight: $.fn.innerHeight,
				outerWidth: $.fn.outerWidth,
				outerHeight: $.fn.outerHeight
			};

		function reduce( elem, size, border, margin ) {
			$.each( side, function() {
				size -= parseFloat( $.css( elem, "padding" + this ) ) || 0;
				if ( border ) {
					size -= parseFloat( $.css( elem, "border" + this + "Width" ) ) || 0;
				}
				if ( margin ) {
					size -= parseFloat( $.css( elem, "margin" + this ) ) || 0;
				}
			});
			return size;
		}

		$.fn[ "inner" + name ] = function( size ) {
			if ( size === undefined ) {
				return orig[ "inner" + name ].call( this );
			}

			return this.each(function() {
				$( this ).css( type, reduce( this, size ) + "px" );
			});
		};

		$.fn[ "outer" + name] = function( size, margin ) {
			if ( typeof size !== "number" ) {
				return orig[ "outer" + name ].call( this, size );
			}

			return this.each(function() {
				$( this).css( type, reduce( this, size, true, margin ) + "px" );
			});
		};
	});
}

// support: jQuery <1.8
if ( !$.fn.addBack ) {
	$.fn.addBack = function( selector ) {
		return this.add( selector == null ?
			this.prevObject : this.prevObject.filter( selector )
		);
	};
}

// support: jQuery 1.6.1, 1.6.2 (http://bugs.jquery.com/ticket/9413)
if ( $( "<a>" ).data( "a-b", "a" ).removeData( "a-b" ).data( "a-b" ) ) {
	$.fn.removeData = (function( removeData ) {
		return function( key ) {
			if ( arguments.length ) {
				return removeData.call( this, $.camelCase( key ) );
			} else {
				return removeData.call( this );
			}
		};
	})( $.fn.removeData );
}





// deprecated
$.ui.ie = !!/msie [\w.]+/.exec( navigator.userAgent.toLowerCase() );

$.support.selectstart = "onselectstart" in document.createElement( "div" );
$.fn.extend({
	disableSelection: function() {
		return this.bind( ( $.support.selectstart ? "selectstart" : "mousedown" ) +
			".ui-disableSelection", function( event ) {
				event.preventDefault();
			});
	},

	enableSelection: function() {
		return this.unbind( ".ui-disableSelection" );
	}
});

$.extend( $.ui, {
	// $.ui.plugin is deprecated. Use $.widget() extensions instead.
	plugin: {
		add: function( module, option, set ) {
			var i,
				proto = $.ui[ module ].prototype;
			for ( i in set ) {
				proto.plugins[ i ] = proto.plugins[ i ] || [];
				proto.plugins[ i ].push( [ option, set[ i ] ] );
			}
		},
		call: function( instance, name, args ) {
			var i,
				set = instance.plugins[ name ];
			if ( !set || !instance.element[ 0 ].parentNode || instance.element[ 0 ].parentNode.nodeType === 11 ) {
				return;
			}

			for ( i = 0; i < set.length; i++ ) {
				if ( instance.options[ set[ i ][ 0 ] ] ) {
					set[ i ][ 1 ].apply( instance.element, args );
				}
			}
		}
	},

	// only used by resizable
	hasScroll: function( el, a ) {

		//If overflow is hidden, the element might have extra content, but the user wants to hide it
		if ( $( el ).css( "overflow" ) === "hidden") {
			return false;
		}

		var scroll = ( a && a === "left" ) ? "scrollLeft" : "scrollTop",
			has = false;

		if ( el[ scroll ] > 0 ) {
			return true;
		}

		// TODO: determine which cases actually cause this to happen
		// if the element doesn't have the scroll set, see if it's possible to
		// set the scroll
		el[ scroll ] = 1;
		has = ( el[ scroll ] > 0 );
		el[ scroll ] = 0;
		return has;
	}
});

})( jQuery );

},{"jquery":"jquery"}],"jquery-ui/datepicker":[function(require,module,exports){
var jQuery = require('jquery');
require('./core');

/*!
 * jQuery UI Datepicker 1.10.4
 * http://jqueryui.com
 *
 * Copyright 2014 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/datepicker/
 *
 * Depends:
 *	jquery.ui.core.js
 */
(function( $, undefined ) {

$.extend($.ui, { datepicker: { version: "1.10.4" } });

var PROP_NAME = "datepicker",
	instActive;

/* Date picker manager.
   Use the singleton instance of this class, $.datepicker, to interact with the date picker.
   Settings for (groups of) date pickers are maintained in an instance object,
   allowing multiple different settings on the same page. */

function Datepicker() {
	this._curInst = null; // The current instance in use
	this._keyEvent = false; // If the last event was a key event
	this._disabledInputs = []; // List of date picker inputs that have been disabled
	this._datepickerShowing = false; // True if the popup picker is showing , false if not
	this._inDialog = false; // True if showing within a "dialog", false if not
	this._mainDivId = "ui-datepicker-div"; // The ID of the main datepicker division
	this._inlineClass = "ui-datepicker-inline"; // The name of the inline marker class
	this._appendClass = "ui-datepicker-append"; // The name of the append marker class
	this._triggerClass = "ui-datepicker-trigger"; // The name of the trigger marker class
	this._dialogClass = "ui-datepicker-dialog"; // The name of the dialog marker class
	this._disableClass = "ui-datepicker-disabled"; // The name of the disabled covering marker class
	this._unselectableClass = "ui-datepicker-unselectable"; // The name of the unselectable cell marker class
	this._currentClass = "ui-datepicker-current-day"; // The name of the current day marker class
	this._dayOverClass = "ui-datepicker-days-cell-over"; // The name of the day hover marker class
	this.regional = []; // Available regional settings, indexed by language code
	this.regional[""] = { // Default regional settings
		closeText: "Done", // Display text for close link
		prevText: "Prev", // Display text for previous month link
		nextText: "Next", // Display text for next month link
		currentText: "Today", // Display text for current month link
		monthNames: ["January","February","March","April","May","June",
			"July","August","September","October","November","December"], // Names of months for drop-down and formatting
		monthNamesShort: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"], // For formatting
		dayNames: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"], // For formatting
		dayNamesShort: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"], // For formatting
		dayNamesMin: ["Su","Mo","Tu","We","Th","Fr","Sa"], // Column headings for days starting at Sunday
		weekHeader: "Wk", // Column header for week of the year
		dateFormat: "mm/dd/yy", // See format options on parseDate
		firstDay: 0, // The first day of the week, Sun = 0, Mon = 1, ...
		isRTL: false, // True if right-to-left language, false if left-to-right
		showMonthAfterYear: false, // True if the year select precedes month, false for month then year
		yearSuffix: "" // Additional text to append to the year in the month headers
	};
	this._defaults = { // Global defaults for all the date picker instances
		showOn: "focus", // "focus" for popup on focus,
			// "button" for trigger button, or "both" for either
		showAnim: "fadeIn", // Name of jQuery animation for popup
		showOptions: {}, // Options for enhanced animations
		defaultDate: null, // Used when field is blank: actual date,
			// +/-number for offset from today, null for today
		appendText: "", // Display text following the input box, e.g. showing the format
		buttonText: "...", // Text for trigger button
		buttonImage: "", // URL for trigger button image
		buttonImageOnly: false, // True if the image appears alone, false if it appears on a button
		hideIfNoPrevNext: false, // True to hide next/previous month links
			// if not applicable, false to just disable them
		navigationAsDateFormat: false, // True if date formatting applied to prev/today/next links
		gotoCurrent: false, // True if today link goes back to current selection instead
		changeMonth: false, // True if month can be selected directly, false if only prev/next
		changeYear: false, // True if year can be selected directly, false if only prev/next
		yearRange: "c-10:c+10", // Range of years to display in drop-down,
			// either relative to today's year (-nn:+nn), relative to currently displayed year
			// (c-nn:c+nn), absolute (nnnn:nnnn), or a combination of the above (nnnn:-n)
		showOtherMonths: false, // True to show dates in other months, false to leave blank
		selectOtherMonths: false, // True to allow selection of dates in other months, false for unselectable
		showWeek: false, // True to show week of the year, false to not show it
		calculateWeek: this.iso8601Week, // How to calculate the week of the year,
			// takes a Date and returns the number of the week for it
		shortYearCutoff: "+10", // Short year values < this are in the current century,
			// > this are in the previous century,
			// string value starting with "+" for current year + value
		minDate: null, // The earliest selectable date, or null for no limit
		maxDate: null, // The latest selectable date, or null for no limit
		duration: "fast", // Duration of display/closure
		beforeShowDay: null, // Function that takes a date and returns an array with
			// [0] = true if selectable, false if not, [1] = custom CSS class name(s) or "",
			// [2] = cell title (optional), e.g. $.datepicker.noWeekends
		beforeShow: null, // Function that takes an input field and
			// returns a set of custom settings for the date picker
		onSelect: null, // Define a callback function when a date is selected
		onChangeMonthYear: null, // Define a callback function when the month or year is changed
		onClose: null, // Define a callback function when the datepicker is closed
		numberOfMonths: 1, // Number of months to show at a time
		showCurrentAtPos: 0, // The position in multipe months at which to show the current month (starting at 0)
		stepMonths: 1, // Number of months to step back/forward
		stepBigMonths: 12, // Number of months to step back/forward for the big links
		altField: "", // Selector for an alternate field to store selected dates into
		altFormat: "", // The date format to use for the alternate field
		constrainInput: true, // The input is constrained by the current date format
		showButtonPanel: false, // True to show button panel, false to not show it
		autoSize: false, // True to size the input for the date format, false to leave as is
		disabled: false // The initial disabled state
	};
	$.extend(this._defaults, this.regional[""]);
	this.dpDiv = bindHover($("<div id='" + this._mainDivId + "' class='ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>"));
}

$.extend(Datepicker.prototype, {
	/* Class name added to elements to indicate already configured with a date picker. */
	markerClassName: "hasDatepicker",

	//Keep track of the maximum number of rows displayed (see #7043)
	maxRows: 4,

	// TODO rename to "widget" when switching to widget factory
	_widgetDatepicker: function() {
		return this.dpDiv;
	},

	/* Override the default settings for all instances of the date picker.
	 * @param  settings  object - the new settings to use as defaults (anonymous object)
	 * @return the manager object
	 */
	setDefaults: function(settings) {
		extendRemove(this._defaults, settings || {});
		return this;
	},

	/* Attach the date picker to a jQuery selection.
	 * @param  target	element - the target input field or division or span
	 * @param  settings  object - the new settings to use for this date picker instance (anonymous)
	 */
	_attachDatepicker: function(target, settings) {
		var nodeName, inline, inst;
		nodeName = target.nodeName.toLowerCase();
		inline = (nodeName === "div" || nodeName === "span");
		if (!target.id) {
			this.uuid += 1;
			target.id = "dp" + this.uuid;
		}
		inst = this._newInst($(target), inline);
		inst.settings = $.extend({}, settings || {});
		if (nodeName === "input") {
			this._connectDatepicker(target, inst);
		} else if (inline) {
			this._inlineDatepicker(target, inst);
		}
	},

	/* Create a new instance object. */
	_newInst: function(target, inline) {
		var id = target[0].id.replace(/([^A-Za-z0-9_\-])/g, "\\\\$1"); // escape jQuery meta chars
		return {id: id, input: target, // associated target
			selectedDay: 0, selectedMonth: 0, selectedYear: 0, // current selection
			drawMonth: 0, drawYear: 0, // month being drawn
			inline: inline, // is datepicker inline or not
			dpDiv: (!inline ? this.dpDiv : // presentation div
			bindHover($("<div class='" + this._inlineClass + " ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>")))};
	},

	/* Attach the date picker to an input field. */
	_connectDatepicker: function(target, inst) {
		var input = $(target);
		inst.append = $([]);
		inst.trigger = $([]);
		if (input.hasClass(this.markerClassName)) {
			return;
		}
		this._attachments(input, inst);
		input.addClass(this.markerClassName).keydown(this._doKeyDown).
			keypress(this._doKeyPress).keyup(this._doKeyUp);
		this._autoSize(inst);
		$.data(target, PROP_NAME, inst);
		//If disabled option is true, disable the datepicker once it has been attached to the input (see ticket #5665)
		if( inst.settings.disabled ) {
			this._disableDatepicker( target );
		}
	},

	/* Make attachments based on settings. */
	_attachments: function(input, inst) {
		var showOn, buttonText, buttonImage,
			appendText = this._get(inst, "appendText"),
			isRTL = this._get(inst, "isRTL");

		if (inst.append) {
			inst.append.remove();
		}
		if (appendText) {
			inst.append = $("<span class='" + this._appendClass + "'>" + appendText + "</span>");
			input[isRTL ? "before" : "after"](inst.append);
		}

		input.unbind("focus", this._showDatepicker);

		if (inst.trigger) {
			inst.trigger.remove();
		}

		showOn = this._get(inst, "showOn");
		if (showOn === "focus" || showOn === "both") { // pop-up date picker when in the marked field
			input.focus(this._showDatepicker);
		}
		if (showOn === "button" || showOn === "both") { // pop-up date picker when button clicked
			buttonText = this._get(inst, "buttonText");
			buttonImage = this._get(inst, "buttonImage");
			inst.trigger = $(this._get(inst, "buttonImageOnly") ?
				$("<img/>").addClass(this._triggerClass).
					attr({ src: buttonImage, alt: buttonText, title: buttonText }) :
				$("<button type='button'></button>").addClass(this._triggerClass).
					html(!buttonImage ? buttonText : $("<img/>").attr(
					{ src:buttonImage, alt:buttonText, title:buttonText })));
			input[isRTL ? "before" : "after"](inst.trigger);
			inst.trigger.click(function() {
				if ($.datepicker._datepickerShowing && $.datepicker._lastInput === input[0]) {
					$.datepicker._hideDatepicker();
				} else if ($.datepicker._datepickerShowing && $.datepicker._lastInput !== input[0]) {
					$.datepicker._hideDatepicker();
					$.datepicker._showDatepicker(input[0]);
				} else {
					$.datepicker._showDatepicker(input[0]);
				}
				return false;
			});
		}
	},

	/* Apply the maximum length for the date format. */
	_autoSize: function(inst) {
		if (this._get(inst, "autoSize") && !inst.inline) {
			var findMax, max, maxI, i,
				date = new Date(2009, 12 - 1, 20), // Ensure double digits
				dateFormat = this._get(inst, "dateFormat");

			if (dateFormat.match(/[DM]/)) {
				findMax = function(names) {
					max = 0;
					maxI = 0;
					for (i = 0; i < names.length; i++) {
						if (names[i].length > max) {
							max = names[i].length;
							maxI = i;
						}
					}
					return maxI;
				};
				date.setMonth(findMax(this._get(inst, (dateFormat.match(/MM/) ?
					"monthNames" : "monthNamesShort"))));
				date.setDate(findMax(this._get(inst, (dateFormat.match(/DD/) ?
					"dayNames" : "dayNamesShort"))) + 20 - date.getDay());
			}
			inst.input.attr("size", this._formatDate(inst, date).length);
		}
	},

	/* Attach an inline date picker to a div. */
	_inlineDatepicker: function(target, inst) {
		var divSpan = $(target);
		if (divSpan.hasClass(this.markerClassName)) {
			return;
		}
		divSpan.addClass(this.markerClassName).append(inst.dpDiv);
		$.data(target, PROP_NAME, inst);
		this._setDate(inst, this._getDefaultDate(inst), true);
		this._updateDatepicker(inst);
		this._updateAlternate(inst);
		//If disabled option is true, disable the datepicker before showing it (see ticket #5665)
		if( inst.settings.disabled ) {
			this._disableDatepicker( target );
		}
		// Set display:block in place of inst.dpDiv.show() which won't work on disconnected elements
		// http://bugs.jqueryui.com/ticket/7552 - A Datepicker created on a detached div has zero height
		inst.dpDiv.css( "display", "block" );
	},

	/* Pop-up the date picker in a "dialog" box.
	 * @param  input element - ignored
	 * @param  date	string or Date - the initial date to display
	 * @param  onSelect  function - the function to call when a date is selected
	 * @param  settings  object - update the dialog date picker instance's settings (anonymous object)
	 * @param  pos int[2] - coordinates for the dialog's position within the screen or
	 *					event - with x/y coordinates or
	 *					leave empty for default (screen centre)
	 * @return the manager object
	 */
	_dialogDatepicker: function(input, date, onSelect, settings, pos) {
		var id, browserWidth, browserHeight, scrollX, scrollY,
			inst = this._dialogInst; // internal instance

		if (!inst) {
			this.uuid += 1;
			id = "dp" + this.uuid;
			this._dialogInput = $("<input type='text' id='" + id +
				"' style='position: absolute; top: -100px; width: 0px;'/>");
			this._dialogInput.keydown(this._doKeyDown);
			$("body").append(this._dialogInput);
			inst = this._dialogInst = this._newInst(this._dialogInput, false);
			inst.settings = {};
			$.data(this._dialogInput[0], PROP_NAME, inst);
		}
		extendRemove(inst.settings, settings || {});
		date = (date && date.constructor === Date ? this._formatDate(inst, date) : date);
		this._dialogInput.val(date);

		this._pos = (pos ? (pos.length ? pos : [pos.pageX, pos.pageY]) : null);
		if (!this._pos) {
			browserWidth = document.documentElement.clientWidth;
			browserHeight = document.documentElement.clientHeight;
			scrollX = document.documentElement.scrollLeft || document.body.scrollLeft;
			scrollY = document.documentElement.scrollTop || document.body.scrollTop;
			this._pos = // should use actual width/height below
				[(browserWidth / 2) - 100 + scrollX, (browserHeight / 2) - 150 + scrollY];
		}

		// move input on screen for focus, but hidden behind dialog
		this._dialogInput.css("left", (this._pos[0] + 20) + "px").css("top", this._pos[1] + "px");
		inst.settings.onSelect = onSelect;
		this._inDialog = true;
		this.dpDiv.addClass(this._dialogClass);
		this._showDatepicker(this._dialogInput[0]);
		if ($.blockUI) {
			$.blockUI(this.dpDiv);
		}
		$.data(this._dialogInput[0], PROP_NAME, inst);
		return this;
	},

	/* Detach a datepicker from its control.
	 * @param  target	element - the target input field or division or span
	 */
	_destroyDatepicker: function(target) {
		var nodeName,
			$target = $(target),
			inst = $.data(target, PROP_NAME);

		if (!$target.hasClass(this.markerClassName)) {
			return;
		}

		nodeName = target.nodeName.toLowerCase();
		$.removeData(target, PROP_NAME);
		if (nodeName === "input") {
			inst.append.remove();
			inst.trigger.remove();
			$target.removeClass(this.markerClassName).
				unbind("focus", this._showDatepicker).
				unbind("keydown", this._doKeyDown).
				unbind("keypress", this._doKeyPress).
				unbind("keyup", this._doKeyUp);
		} else if (nodeName === "div" || nodeName === "span") {
			$target.removeClass(this.markerClassName).empty();
		}
	},

	/* Enable the date picker to a jQuery selection.
	 * @param  target	element - the target input field or division or span
	 */
	_enableDatepicker: function(target) {
		var nodeName, inline,
			$target = $(target),
			inst = $.data(target, PROP_NAME);

		if (!$target.hasClass(this.markerClassName)) {
			return;
		}

		nodeName = target.nodeName.toLowerCase();
		if (nodeName === "input") {
			target.disabled = false;
			inst.trigger.filter("button").
				each(function() { this.disabled = false; }).end().
				filter("img").css({opacity: "1.0", cursor: ""});
		} else if (nodeName === "div" || nodeName === "span") {
			inline = $target.children("." + this._inlineClass);
			inline.children().removeClass("ui-state-disabled");
			inline.find("select.ui-datepicker-month, select.ui-datepicker-year").
				prop("disabled", false);
		}
		this._disabledInputs = $.map(this._disabledInputs,
			function(value) { return (value === target ? null : value); }); // delete entry
	},

	/* Disable the date picker to a jQuery selection.
	 * @param  target	element - the target input field or division or span
	 */
	_disableDatepicker: function(target) {
		var nodeName, inline,
			$target = $(target),
			inst = $.data(target, PROP_NAME);

		if (!$target.hasClass(this.markerClassName)) {
			return;
		}

		nodeName = target.nodeName.toLowerCase();
		if (nodeName === "input") {
			target.disabled = true;
			inst.trigger.filter("button").
				each(function() { this.disabled = true; }).end().
				filter("img").css({opacity: "0.5", cursor: "default"});
		} else if (nodeName === "div" || nodeName === "span") {
			inline = $target.children("." + this._inlineClass);
			inline.children().addClass("ui-state-disabled");
			inline.find("select.ui-datepicker-month, select.ui-datepicker-year").
				prop("disabled", true);
		}
		this._disabledInputs = $.map(this._disabledInputs,
			function(value) { return (value === target ? null : value); }); // delete entry
		this._disabledInputs[this._disabledInputs.length] = target;
	},

	/* Is the first field in a jQuery collection disabled as a datepicker?
	 * @param  target	element - the target input field or division or span
	 * @return boolean - true if disabled, false if enabled
	 */
	_isDisabledDatepicker: function(target) {
		if (!target) {
			return false;
		}
		for (var i = 0; i < this._disabledInputs.length; i++) {
			if (this._disabledInputs[i] === target) {
				return true;
			}
		}
		return false;
	},

	/* Retrieve the instance data for the target control.
	 * @param  target  element - the target input field or division or span
	 * @return  object - the associated instance data
	 * @throws  error if a jQuery problem getting data
	 */
	_getInst: function(target) {
		try {
			return $.data(target, PROP_NAME);
		}
		catch (err) {
			throw "Missing instance data for this datepicker";
		}
	},

	/* Update or retrieve the settings for a date picker attached to an input field or division.
	 * @param  target  element - the target input field or division or span
	 * @param  name	object - the new settings to update or
	 *				string - the name of the setting to change or retrieve,
	 *				when retrieving also "all" for all instance settings or
	 *				"defaults" for all global defaults
	 * @param  value   any - the new value for the setting
	 *				(omit if above is an object or to retrieve a value)
	 */
	_optionDatepicker: function(target, name, value) {
		var settings, date, minDate, maxDate,
			inst = this._getInst(target);

		if (arguments.length === 2 && typeof name === "string") {
			return (name === "defaults" ? $.extend({}, $.datepicker._defaults) :
				(inst ? (name === "all" ? $.extend({}, inst.settings) :
				this._get(inst, name)) : null));
		}

		settings = name || {};
		if (typeof name === "string") {
			settings = {};
			settings[name] = value;
		}

		if (inst) {
			if (this._curInst === inst) {
				this._hideDatepicker();
			}

			date = this._getDateDatepicker(target, true);
			minDate = this._getMinMaxDate(inst, "min");
			maxDate = this._getMinMaxDate(inst, "max");
			extendRemove(inst.settings, settings);
			// reformat the old minDate/maxDate values if dateFormat changes and a new minDate/maxDate isn't provided
			if (minDate !== null && settings.dateFormat !== undefined && settings.minDate === undefined) {
				inst.settings.minDate = this._formatDate(inst, minDate);
			}
			if (maxDate !== null && settings.dateFormat !== undefined && settings.maxDate === undefined) {
				inst.settings.maxDate = this._formatDate(inst, maxDate);
			}
			if ( "disabled" in settings ) {
				if ( settings.disabled ) {
					this._disableDatepicker(target);
				} else {
					this._enableDatepicker(target);
				}
			}
			this._attachments($(target), inst);
			this._autoSize(inst);
			this._setDate(inst, date);
			this._updateAlternate(inst);
			this._updateDatepicker(inst);
		}
	},

	// change method deprecated
	_changeDatepicker: function(target, name, value) {
		this._optionDatepicker(target, name, value);
	},

	/* Redraw the date picker attached to an input field or division.
	 * @param  target  element - the target input field or division or span
	 */
	_refreshDatepicker: function(target) {
		var inst = this._getInst(target);
		if (inst) {
			this._updateDatepicker(inst);
		}
	},

	/* Set the dates for a jQuery selection.
	 * @param  target element - the target input field or division or span
	 * @param  date	Date - the new date
	 */
	_setDateDatepicker: function(target, date) {
		var inst = this._getInst(target);
		if (inst) {
			this._setDate(inst, date);
			this._updateDatepicker(inst);
			this._updateAlternate(inst);
		}
	},

	/* Get the date(s) for the first entry in a jQuery selection.
	 * @param  target element - the target input field or division or span
	 * @param  noDefault boolean - true if no default date is to be used
	 * @return Date - the current date
	 */
	_getDateDatepicker: function(target, noDefault) {
		var inst = this._getInst(target);
		if (inst && !inst.inline) {
			this._setDateFromField(inst, noDefault);
		}
		return (inst ? this._getDate(inst) : null);
	},

	/* Handle keystrokes. */
	_doKeyDown: function(event) {
		var onSelect, dateStr, sel,
			inst = $.datepicker._getInst(event.target),
			handled = true,
			isRTL = inst.dpDiv.is(".ui-datepicker-rtl");

		inst._keyEvent = true;
		if ($.datepicker._datepickerShowing) {
			switch (event.keyCode) {
				case 9: $.datepicker._hideDatepicker();
						handled = false;
						break; // hide on tab out
				case 13: sel = $("td." + $.datepicker._dayOverClass + ":not(." +
									$.datepicker._currentClass + ")", inst.dpDiv);
						if (sel[0]) {
							$.datepicker._selectDay(event.target, inst.selectedMonth, inst.selectedYear, sel[0]);
						}

						onSelect = $.datepicker._get(inst, "onSelect");
						if (onSelect) {
							dateStr = $.datepicker._formatDate(inst);

							// trigger custom callback
							onSelect.apply((inst.input ? inst.input[0] : null), [dateStr, inst]);
						} else {
							$.datepicker._hideDatepicker();
						}

						return false; // don't submit the form
				case 27: $.datepicker._hideDatepicker();
						break; // hide on escape
				case 33: $.datepicker._adjustDate(event.target, (event.ctrlKey ?
							-$.datepicker._get(inst, "stepBigMonths") :
							-$.datepicker._get(inst, "stepMonths")), "M");
						break; // previous month/year on page up/+ ctrl
				case 34: $.datepicker._adjustDate(event.target, (event.ctrlKey ?
							+$.datepicker._get(inst, "stepBigMonths") :
							+$.datepicker._get(inst, "stepMonths")), "M");
						break; // next month/year on page down/+ ctrl
				case 35: if (event.ctrlKey || event.metaKey) {
							$.datepicker._clearDate(event.target);
						}
						handled = event.ctrlKey || event.metaKey;
						break; // clear on ctrl or command +end
				case 36: if (event.ctrlKey || event.metaKey) {
							$.datepicker._gotoToday(event.target);
						}
						handled = event.ctrlKey || event.metaKey;
						break; // current on ctrl or command +home
				case 37: if (event.ctrlKey || event.metaKey) {
							$.datepicker._adjustDate(event.target, (isRTL ? +1 : -1), "D");
						}
						handled = event.ctrlKey || event.metaKey;
						// -1 day on ctrl or command +left
						if (event.originalEvent.altKey) {
							$.datepicker._adjustDate(event.target, (event.ctrlKey ?
								-$.datepicker._get(inst, "stepBigMonths") :
								-$.datepicker._get(inst, "stepMonths")), "M");
						}
						// next month/year on alt +left on Mac
						break;
				case 38: if (event.ctrlKey || event.metaKey) {
							$.datepicker._adjustDate(event.target, -7, "D");
						}
						handled = event.ctrlKey || event.metaKey;
						break; // -1 week on ctrl or command +up
				case 39: if (event.ctrlKey || event.metaKey) {
							$.datepicker._adjustDate(event.target, (isRTL ? -1 : +1), "D");
						}
						handled = event.ctrlKey || event.metaKey;
						// +1 day on ctrl or command +right
						if (event.originalEvent.altKey) {
							$.datepicker._adjustDate(event.target, (event.ctrlKey ?
								+$.datepicker._get(inst, "stepBigMonths") :
								+$.datepicker._get(inst, "stepMonths")), "M");
						}
						// next month/year on alt +right
						break;
				case 40: if (event.ctrlKey || event.metaKey) {
							$.datepicker._adjustDate(event.target, +7, "D");
						}
						handled = event.ctrlKey || event.metaKey;
						break; // +1 week on ctrl or command +down
				default: handled = false;
			}
		} else if (event.keyCode === 36 && event.ctrlKey) { // display the date picker on ctrl+home
			$.datepicker._showDatepicker(this);
		} else {
			handled = false;
		}

		if (handled) {
			event.preventDefault();
			event.stopPropagation();
		}
	},

	/* Filter entered characters - based on date format. */
	_doKeyPress: function(event) {
		var chars, chr,
			inst = $.datepicker._getInst(event.target);

		if ($.datepicker._get(inst, "constrainInput")) {
			chars = $.datepicker._possibleChars($.datepicker._get(inst, "dateFormat"));
			chr = String.fromCharCode(event.charCode == null ? event.keyCode : event.charCode);
			return event.ctrlKey || event.metaKey || (chr < " " || !chars || chars.indexOf(chr) > -1);
		}
	},

	/* Synchronise manual entry and field/alternate field. */
	_doKeyUp: function(event) {
		var date,
			inst = $.datepicker._getInst(event.target);

		if (inst.input.val() !== inst.lastVal) {
			try {
				date = $.datepicker.parseDate($.datepicker._get(inst, "dateFormat"),
					(inst.input ? inst.input.val() : null),
					$.datepicker._getFormatConfig(inst));

				if (date) { // only if valid
					$.datepicker._setDateFromField(inst);
					$.datepicker._updateAlternate(inst);
					$.datepicker._updateDatepicker(inst);
				}
			}
			catch (err) {
			}
		}
		return true;
	},

	/* Pop-up the date picker for a given input field.
	 * If false returned from beforeShow event handler do not show.
	 * @param  input  element - the input field attached to the date picker or
	 *					event - if triggered by focus
	 */
	_showDatepicker: function(input) {
		input = input.target || input;
		if (input.nodeName.toLowerCase() !== "input") { // find from button/image trigger
			input = $("input", input.parentNode)[0];
		}

		if ($.datepicker._isDisabledDatepicker(input) || $.datepicker._lastInput === input) { // already here
			return;
		}

		var inst, beforeShow, beforeShowSettings, isFixed,
			offset, showAnim, duration;

		inst = $.datepicker._getInst(input);
		if ($.datepicker._curInst && $.datepicker._curInst !== inst) {
			$.datepicker._curInst.dpDiv.stop(true, true);
			if ( inst && $.datepicker._datepickerShowing ) {
				$.datepicker._hideDatepicker( $.datepicker._curInst.input[0] );
			}
		}

		beforeShow = $.datepicker._get(inst, "beforeShow");
		beforeShowSettings = beforeShow ? beforeShow.apply(input, [input, inst]) : {};
		if(beforeShowSettings === false){
			return;
		}
		extendRemove(inst.settings, beforeShowSettings);

		inst.lastVal = null;
		$.datepicker._lastInput = input;
		$.datepicker._setDateFromField(inst);

		if ($.datepicker._inDialog) { // hide cursor
			input.value = "";
		}
		if (!$.datepicker._pos) { // position below input
			$.datepicker._pos = $.datepicker._findPos(input);
			$.datepicker._pos[1] += input.offsetHeight; // add the height
		}

		isFixed = false;
		$(input).parents().each(function() {
			isFixed |= $(this).css("position") === "fixed";
			return !isFixed;
		});

		offset = {left: $.datepicker._pos[0], top: $.datepicker._pos[1]};
		$.datepicker._pos = null;
		//to avoid flashes on Firefox
		inst.dpDiv.empty();
		// determine sizing offscreen
		inst.dpDiv.css({position: "absolute", display: "block", top: "-1000px"});
		$.datepicker._updateDatepicker(inst);
		// fix width for dynamic number of date pickers
		// and adjust position before showing
		offset = $.datepicker._checkOffset(inst, offset, isFixed);
		inst.dpDiv.css({position: ($.datepicker._inDialog && $.blockUI ?
			"static" : (isFixed ? "fixed" : "absolute")), display: "none",
			left: offset.left + "px", top: offset.top + "px"});

		if (!inst.inline) {
			showAnim = $.datepicker._get(inst, "showAnim");
			duration = $.datepicker._get(inst, "duration");
			inst.dpDiv.zIndex($(input).zIndex()+1);
			$.datepicker._datepickerShowing = true;

			if ( $.effects && $.effects.effect[ showAnim ] ) {
				inst.dpDiv.show(showAnim, $.datepicker._get(inst, "showOptions"), duration);
			} else {
				inst.dpDiv[showAnim || "show"](showAnim ? duration : null);
			}

			if ( $.datepicker._shouldFocusInput( inst ) ) {
				inst.input.focus();
			}

			$.datepicker._curInst = inst;
		}
	},

	/* Generate the date picker content. */
	_updateDatepicker: function(inst) {
		this.maxRows = 4; //Reset the max number of rows being displayed (see #7043)
		instActive = inst; // for delegate hover events
		inst.dpDiv.empty().append(this._generateHTML(inst));
		this._attachHandlers(inst);
		inst.dpDiv.find("." + this._dayOverClass + " a").mouseover();

		var origyearshtml,
			numMonths = this._getNumberOfMonths(inst),
			cols = numMonths[1],
			width = 17;

		inst.dpDiv.removeClass("ui-datepicker-multi-2 ui-datepicker-multi-3 ui-datepicker-multi-4").width("");
		if (cols > 1) {
			inst.dpDiv.addClass("ui-datepicker-multi-" + cols).css("width", (width * cols) + "em");
		}
		inst.dpDiv[(numMonths[0] !== 1 || numMonths[1] !== 1 ? "add" : "remove") +
			"Class"]("ui-datepicker-multi");
		inst.dpDiv[(this._get(inst, "isRTL") ? "add" : "remove") +
			"Class"]("ui-datepicker-rtl");

		if (inst === $.datepicker._curInst && $.datepicker._datepickerShowing && $.datepicker._shouldFocusInput( inst ) ) {
			inst.input.focus();
		}

		// deffered render of the years select (to avoid flashes on Firefox)
		if( inst.yearshtml ){
			origyearshtml = inst.yearshtml;
			setTimeout(function(){
				//assure that inst.yearshtml didn't change.
				if( origyearshtml === inst.yearshtml && inst.yearshtml ){
					inst.dpDiv.find("select.ui-datepicker-year:first").replaceWith(inst.yearshtml);
				}
				origyearshtml = inst.yearshtml = null;
			}, 0);
		}
	},

	// #6694 - don't focus the input if it's already focused
	// this breaks the change event in IE
	// Support: IE and jQuery <1.9
	_shouldFocusInput: function( inst ) {
		return inst.input && inst.input.is( ":visible" ) && !inst.input.is( ":disabled" ) && !inst.input.is( ":focus" );
	},

	/* Check positioning to remain on screen. */
	_checkOffset: function(inst, offset, isFixed) {
		var dpWidth = inst.dpDiv.outerWidth(),
			dpHeight = inst.dpDiv.outerHeight(),
			inputWidth = inst.input ? inst.input.outerWidth() : 0,
			inputHeight = inst.input ? inst.input.outerHeight() : 0,
			viewWidth = document.documentElement.clientWidth + (isFixed ? 0 : $(document).scrollLeft()),
			viewHeight = document.documentElement.clientHeight + (isFixed ? 0 : $(document).scrollTop());

		offset.left -= (this._get(inst, "isRTL") ? (dpWidth - inputWidth) : 0);
		offset.left -= (isFixed && offset.left === inst.input.offset().left) ? $(document).scrollLeft() : 0;
		offset.top -= (isFixed && offset.top === (inst.input.offset().top + inputHeight)) ? $(document).scrollTop() : 0;

		// now check if datepicker is showing outside window viewport - move to a better place if so.
		offset.left -= Math.min(offset.left, (offset.left + dpWidth > viewWidth && viewWidth > dpWidth) ?
			Math.abs(offset.left + dpWidth - viewWidth) : 0);
		offset.top -= Math.min(offset.top, (offset.top + dpHeight > viewHeight && viewHeight > dpHeight) ?
			Math.abs(dpHeight + inputHeight) : 0);

		return offset;
	},

	/* Find an object's position on the screen. */
	_findPos: function(obj) {
		var position,
			inst = this._getInst(obj),
			isRTL = this._get(inst, "isRTL");

		while (obj && (obj.type === "hidden" || obj.nodeType !== 1 || $.expr.filters.hidden(obj))) {
			obj = obj[isRTL ? "previousSibling" : "nextSibling"];
		}

		position = $(obj).offset();
		return [position.left, position.top];
	},

	/* Hide the date picker from view.
	 * @param  input  element - the input field attached to the date picker
	 */
	_hideDatepicker: function(input) {
		var showAnim, duration, postProcess, onClose,
			inst = this._curInst;

		if (!inst || (input && inst !== $.data(input, PROP_NAME))) {
			return;
		}

		if (this._datepickerShowing) {
			showAnim = this._get(inst, "showAnim");
			duration = this._get(inst, "duration");
			postProcess = function() {
				$.datepicker._tidyDialog(inst);
			};

			// DEPRECATED: after BC for 1.8.x $.effects[ showAnim ] is not needed
			if ( $.effects && ( $.effects.effect[ showAnim ] || $.effects[ showAnim ] ) ) {
				inst.dpDiv.hide(showAnim, $.datepicker._get(inst, "showOptions"), duration, postProcess);
			} else {
				inst.dpDiv[(showAnim === "slideDown" ? "slideUp" :
					(showAnim === "fadeIn" ? "fadeOut" : "hide"))]((showAnim ? duration : null), postProcess);
			}

			if (!showAnim) {
				postProcess();
			}
			this._datepickerShowing = false;

			onClose = this._get(inst, "onClose");
			if (onClose) {
				onClose.apply((inst.input ? inst.input[0] : null), [(inst.input ? inst.input.val() : ""), inst]);
			}

			this._lastInput = null;
			if (this._inDialog) {
				this._dialogInput.css({ position: "absolute", left: "0", top: "-100px" });
				if ($.blockUI) {
					$.unblockUI();
					$("body").append(this.dpDiv);
				}
			}
			this._inDialog = false;
		}
	},

	/* Tidy up after a dialog display. */
	_tidyDialog: function(inst) {
		inst.dpDiv.removeClass(this._dialogClass).unbind(".ui-datepicker-calendar");
	},

	/* Close date picker if clicked elsewhere. */
	_checkExternalClick: function(event) {
		if (!$.datepicker._curInst) {
			return;
		}

		var $target = $(event.target),
			inst = $.datepicker._getInst($target[0]);

		if ( ( ( $target[0].id !== $.datepicker._mainDivId &&
				$target.parents("#" + $.datepicker._mainDivId).length === 0 &&
				!$target.hasClass($.datepicker.markerClassName) &&
				!$target.closest("." + $.datepicker._triggerClass).length &&
				$.datepicker._datepickerShowing && !($.datepicker._inDialog && $.blockUI) ) ) ||
			( $target.hasClass($.datepicker.markerClassName) && $.datepicker._curInst !== inst ) ) {
				$.datepicker._hideDatepicker();
		}
	},

	/* Adjust one of the date sub-fields. */
	_adjustDate: function(id, offset, period) {
		var target = $(id),
			inst = this._getInst(target[0]);

		if (this._isDisabledDatepicker(target[0])) {
			return;
		}
		this._adjustInstDate(inst, offset +
			(period === "M" ? this._get(inst, "showCurrentAtPos") : 0), // undo positioning
			period);
		this._updateDatepicker(inst);
	},

	/* Action for current link. */
	_gotoToday: function(id) {
		var date,
			target = $(id),
			inst = this._getInst(target[0]);

		if (this._get(inst, "gotoCurrent") && inst.currentDay) {
			inst.selectedDay = inst.currentDay;
			inst.drawMonth = inst.selectedMonth = inst.currentMonth;
			inst.drawYear = inst.selectedYear = inst.currentYear;
		} else {
			date = new Date();
			inst.selectedDay = date.getDate();
			inst.drawMonth = inst.selectedMonth = date.getMonth();
			inst.drawYear = inst.selectedYear = date.getFullYear();
		}
		this._notifyChange(inst);
		this._adjustDate(target);
	},

	/* Action for selecting a new month/year. */
	_selectMonthYear: function(id, select, period) {
		var target = $(id),
			inst = this._getInst(target[0]);

		inst["selected" + (period === "M" ? "Month" : "Year")] =
		inst["draw" + (period === "M" ? "Month" : "Year")] =
			parseInt(select.options[select.selectedIndex].value,10);

		this._notifyChange(inst);
		this._adjustDate(target);
	},

	/* Action for selecting a day. */
	_selectDay: function(id, month, year, td) {
		var inst,
			target = $(id);

		if ($(td).hasClass(this._unselectableClass) || this._isDisabledDatepicker(target[0])) {
			return;
		}

		inst = this._getInst(target[0]);
		inst.selectedDay = inst.currentDay = $("a", td).html();
		inst.selectedMonth = inst.currentMonth = month;
		inst.selectedYear = inst.currentYear = year;
		this._selectDate(id, this._formatDate(inst,
			inst.currentDay, inst.currentMonth, inst.currentYear));
	},

	/* Erase the input field and hide the date picker. */
	_clearDate: function(id) {
		var target = $(id);
		this._selectDate(target, "");
	},

	/* Update the input field with the selected date. */
	_selectDate: function(id, dateStr) {
		var onSelect,
			target = $(id),
			inst = this._getInst(target[0]);

		dateStr = (dateStr != null ? dateStr : this._formatDate(inst));
		if (inst.input) {
			inst.input.val(dateStr);
		}
		this._updateAlternate(inst);

		onSelect = this._get(inst, "onSelect");
		if (onSelect) {
			onSelect.apply((inst.input ? inst.input[0] : null), [dateStr, inst]);  // trigger custom callback
		} else if (inst.input) {
			inst.input.trigger("change"); // fire the change event
		}

		if (inst.inline){
			this._updateDatepicker(inst);
		} else {
			this._hideDatepicker();
			this._lastInput = inst.input[0];
			if (typeof(inst.input[0]) !== "object") {
				inst.input.focus(); // restore focus
			}
			this._lastInput = null;
		}
	},

	/* Update any alternate field to synchronise with the main field. */
	_updateAlternate: function(inst) {
		var altFormat, date, dateStr,
			altField = this._get(inst, "altField");

		if (altField) { // update alternate field too
			altFormat = this._get(inst, "altFormat") || this._get(inst, "dateFormat");
			date = this._getDate(inst);
			dateStr = this.formatDate(altFormat, date, this._getFormatConfig(inst));
			$(altField).each(function() { $(this).val(dateStr); });
		}
	},

	/* Set as beforeShowDay function to prevent selection of weekends.
	 * @param  date  Date - the date to customise
	 * @return [boolean, string] - is this date selectable?, what is its CSS class?
	 */
	noWeekends: function(date) {
		var day = date.getDay();
		return [(day > 0 && day < 6), ""];
	},

	/* Set as calculateWeek to determine the week of the year based on the ISO 8601 definition.
	 * @param  date  Date - the date to get the week for
	 * @return  number - the number of the week within the year that contains this date
	 */
	iso8601Week: function(date) {
		var time,
			checkDate = new Date(date.getTime());

		// Find Thursday of this week starting on Monday
		checkDate.setDate(checkDate.getDate() + 4 - (checkDate.getDay() || 7));

		time = checkDate.getTime();
		checkDate.setMonth(0); // Compare with Jan 1
		checkDate.setDate(1);
		return Math.floor(Math.round((time - checkDate) / 86400000) / 7) + 1;
	},

	/* Parse a string value into a date object.
	 * See formatDate below for the possible formats.
	 *
	 * @param  format string - the expected format of the date
	 * @param  value string - the date in the above format
	 * @param  settings Object - attributes include:
	 *					shortYearCutoff  number - the cutoff year for determining the century (optional)
	 *					dayNamesShort	string[7] - abbreviated names of the days from Sunday (optional)
	 *					dayNames		string[7] - names of the days from Sunday (optional)
	 *					monthNamesShort string[12] - abbreviated names of the months (optional)
	 *					monthNames		string[12] - names of the months (optional)
	 * @return  Date - the extracted date value or null if value is blank
	 */
	parseDate: function (format, value, settings) {
		if (format == null || value == null) {
			throw "Invalid arguments";
		}

		value = (typeof value === "object" ? value.toString() : value + "");
		if (value === "") {
			return null;
		}

		var iFormat, dim, extra,
			iValue = 0,
			shortYearCutoffTemp = (settings ? settings.shortYearCutoff : null) || this._defaults.shortYearCutoff,
			shortYearCutoff = (typeof shortYearCutoffTemp !== "string" ? shortYearCutoffTemp :
				new Date().getFullYear() % 100 + parseInt(shortYearCutoffTemp, 10)),
			dayNamesShort = (settings ? settings.dayNamesShort : null) || this._defaults.dayNamesShort,
			dayNames = (settings ? settings.dayNames : null) || this._defaults.dayNames,
			monthNamesShort = (settings ? settings.monthNamesShort : null) || this._defaults.monthNamesShort,
			monthNames = (settings ? settings.monthNames : null) || this._defaults.monthNames,
			year = -1,
			month = -1,
			day = -1,
			doy = -1,
			literal = false,
			date,
			// Check whether a format character is doubled
			lookAhead = function(match) {
				var matches = (iFormat + 1 < format.length && format.charAt(iFormat + 1) === match);
				if (matches) {
					iFormat++;
				}
				return matches;
			},
			// Extract a number from the string value
			getNumber = function(match) {
				var isDoubled = lookAhead(match),
					size = (match === "@" ? 14 : (match === "!" ? 20 :
					(match === "y" && isDoubled ? 4 : (match === "o" ? 3 : 2)))),
					digits = new RegExp("^\\d{1," + size + "}"),
					num = value.substring(iValue).match(digits);
				if (!num) {
					throw "Missing number at position " + iValue;
				}
				iValue += num[0].length;
				return parseInt(num[0], 10);
			},
			// Extract a name from the string value and convert to an index
			getName = function(match, shortNames, longNames) {
				var index = -1,
					names = $.map(lookAhead(match) ? longNames : shortNames, function (v, k) {
						return [ [k, v] ];
					}).sort(function (a, b) {
						return -(a[1].length - b[1].length);
					});

				$.each(names, function (i, pair) {
					var name = pair[1];
					if (value.substr(iValue, name.length).toLowerCase() === name.toLowerCase()) {
						index = pair[0];
						iValue += name.length;
						return false;
					}
				});
				if (index !== -1) {
					return index + 1;
				} else {
					throw "Unknown name at position " + iValue;
				}
			},
			// Confirm that a literal character matches the string value
			checkLiteral = function() {
				if (value.charAt(iValue) !== format.charAt(iFormat)) {
					throw "Unexpected literal at position " + iValue;
				}
				iValue++;
			};

		for (iFormat = 0; iFormat < format.length; iFormat++) {
			if (literal) {
				if (format.charAt(iFormat) === "'" && !lookAhead("'")) {
					literal = false;
				} else {
					checkLiteral();
				}
			} else {
				switch (format.charAt(iFormat)) {
					case "d":
						day = getNumber("d");
						break;
					case "D":
						getName("D", dayNamesShort, dayNames);
						break;
					case "o":
						doy = getNumber("o");
						break;
					case "m":
						month = getNumber("m");
						break;
					case "M":
						month = getName("M", monthNamesShort, monthNames);
						break;
					case "y":
						year = getNumber("y");
						break;
					case "@":
						date = new Date(getNumber("@"));
						year = date.getFullYear();
						month = date.getMonth() + 1;
						day = date.getDate();
						break;
					case "!":
						date = new Date((getNumber("!") - this._ticksTo1970) / 10000);
						year = date.getFullYear();
						month = date.getMonth() + 1;
						day = date.getDate();
						break;
					case "'":
						if (lookAhead("'")){
							checkLiteral();
						} else {
							literal = true;
						}
						break;
					default:
						checkLiteral();
				}
			}
		}

		if (iValue < value.length){
			extra = value.substr(iValue);
			if (!/^\s+/.test(extra)) {
				throw "Extra/unparsed characters found in date: " + extra;
			}
		}

		if (year === -1) {
			year = new Date().getFullYear();
		} else if (year < 100) {
			year += new Date().getFullYear() - new Date().getFullYear() % 100 +
				(year <= shortYearCutoff ? 0 : -100);
		}

		if (doy > -1) {
			month = 1;
			day = doy;
			do {
				dim = this._getDaysInMonth(year, month - 1);
				if (day <= dim) {
					break;
				}
				month++;
				day -= dim;
			} while (true);
		}

		date = this._daylightSavingAdjust(new Date(year, month - 1, day));
		if (date.getFullYear() !== year || date.getMonth() + 1 !== month || date.getDate() !== day) {
			throw "Invalid date"; // E.g. 31/02/00
		}
		return date;
	},

	/* Standard date formats. */
	ATOM: "yy-mm-dd", // RFC 3339 (ISO 8601)
	COOKIE: "D, dd M yy",
	ISO_8601: "yy-mm-dd",
	RFC_822: "D, d M y",
	RFC_850: "DD, dd-M-y",
	RFC_1036: "D, d M y",
	RFC_1123: "D, d M yy",
	RFC_2822: "D, d M yy",
	RSS: "D, d M y", // RFC 822
	TICKS: "!",
	TIMESTAMP: "@",
	W3C: "yy-mm-dd", // ISO 8601

	_ticksTo1970: (((1970 - 1) * 365 + Math.floor(1970 / 4) - Math.floor(1970 / 100) +
		Math.floor(1970 / 400)) * 24 * 60 * 60 * 10000000),

	/* Format a date object into a string value.
	 * The format can be combinations of the following:
	 * d  - day of month (no leading zero)
	 * dd - day of month (two digit)
	 * o  - day of year (no leading zeros)
	 * oo - day of year (three digit)
	 * D  - day name short
	 * DD - day name long
	 * m  - month of year (no leading zero)
	 * mm - month of year (two digit)
	 * M  - month name short
	 * MM - month name long
	 * y  - year (two digit)
	 * yy - year (four digit)
	 * @ - Unix timestamp (ms since 01/01/1970)
	 * ! - Windows ticks (100ns since 01/01/0001)
	 * "..." - literal text
	 * '' - single quote
	 *
	 * @param  format string - the desired format of the date
	 * @param  date Date - the date value to format
	 * @param  settings Object - attributes include:
	 *					dayNamesShort	string[7] - abbreviated names of the days from Sunday (optional)
	 *					dayNames		string[7] - names of the days from Sunday (optional)
	 *					monthNamesShort string[12] - abbreviated names of the months (optional)
	 *					monthNames		string[12] - names of the months (optional)
	 * @return  string - the date in the above format
	 */
	formatDate: function (format, date, settings) {
		if (!date) {
			return "";
		}

		var iFormat,
			dayNamesShort = (settings ? settings.dayNamesShort : null) || this._defaults.dayNamesShort,
			dayNames = (settings ? settings.dayNames : null) || this._defaults.dayNames,
			monthNamesShort = (settings ? settings.monthNamesShort : null) || this._defaults.monthNamesShort,
			monthNames = (settings ? settings.monthNames : null) || this._defaults.monthNames,
			// Check whether a format character is doubled
			lookAhead = function(match) {
				var matches = (iFormat + 1 < format.length && format.charAt(iFormat + 1) === match);
				if (matches) {
					iFormat++;
				}
				return matches;
			},
			// Format a number, with leading zero if necessary
			formatNumber = function(match, value, len) {
				var num = "" + value;
				if (lookAhead(match)) {
					while (num.length < len) {
						num = "0" + num;
					}
				}
				return num;
			},
			// Format a name, short or long as requested
			formatName = function(match, value, shortNames, longNames) {
				return (lookAhead(match) ? longNames[value] : shortNames[value]);
			},
			output = "",
			literal = false;

		if (date) {
			for (iFormat = 0; iFormat < format.length; iFormat++) {
				if (literal) {
					if (format.charAt(iFormat) === "'" && !lookAhead("'")) {
						literal = false;
					} else {
						output += format.charAt(iFormat);
					}
				} else {
					switch (format.charAt(iFormat)) {
						case "d":
							output += formatNumber("d", date.getDate(), 2);
							break;
						case "D":
							output += formatName("D", date.getDay(), dayNamesShort, dayNames);
							break;
						case "o":
							output += formatNumber("o",
								Math.round((new Date(date.getFullYear(), date.getMonth(), date.getDate()).getTime() - new Date(date.getFullYear(), 0, 0).getTime()) / 86400000), 3);
							break;
						case "m":
							output += formatNumber("m", date.getMonth() + 1, 2);
							break;
						case "M":
							output += formatName("M", date.getMonth(), monthNamesShort, monthNames);
							break;
						case "y":
							output += (lookAhead("y") ? date.getFullYear() :
								(date.getYear() % 100 < 10 ? "0" : "") + date.getYear() % 100);
							break;
						case "@":
							output += date.getTime();
							break;
						case "!":
							output += date.getTime() * 10000 + this._ticksTo1970;
							break;
						case "'":
							if (lookAhead("'")) {
								output += "'";
							} else {
								literal = true;
							}
							break;
						default:
							output += format.charAt(iFormat);
					}
				}
			}
		}
		return output;
	},

	/* Extract all possible characters from the date format. */
	_possibleChars: function (format) {
		var iFormat,
			chars = "",
			literal = false,
			// Check whether a format character is doubled
			lookAhead = function(match) {
				var matches = (iFormat + 1 < format.length && format.charAt(iFormat + 1) === match);
				if (matches) {
					iFormat++;
				}
				return matches;
			};

		for (iFormat = 0; iFormat < format.length; iFormat++) {
			if (literal) {
				if (format.charAt(iFormat) === "'" && !lookAhead("'")) {
					literal = false;
				} else {
					chars += format.charAt(iFormat);
				}
			} else {
				switch (format.charAt(iFormat)) {
					case "d": case "m": case "y": case "@":
						chars += "0123456789";
						break;
					case "D": case "M":
						return null; // Accept anything
					case "'":
						if (lookAhead("'")) {
							chars += "'";
						} else {
							literal = true;
						}
						break;
					default:
						chars += format.charAt(iFormat);
				}
			}
		}
		return chars;
	},

	/* Get a setting value, defaulting if necessary. */
	_get: function(inst, name) {
		return inst.settings[name] !== undefined ?
			inst.settings[name] : this._defaults[name];
	},

	/* Parse existing date and initialise date picker. */
	_setDateFromField: function(inst, noDefault) {
		if (inst.input.val() === inst.lastVal) {
			return;
		}

		var dateFormat = this._get(inst, "dateFormat"),
			dates = inst.lastVal = inst.input ? inst.input.val() : null,
			defaultDate = this._getDefaultDate(inst),
			date = defaultDate,
			settings = this._getFormatConfig(inst);

		try {
			date = this.parseDate(dateFormat, dates, settings) || defaultDate;
		} catch (event) {
			dates = (noDefault ? "" : dates);
		}
		inst.selectedDay = date.getDate();
		inst.drawMonth = inst.selectedMonth = date.getMonth();
		inst.drawYear = inst.selectedYear = date.getFullYear();
		inst.currentDay = (dates ? date.getDate() : 0);
		inst.currentMonth = (dates ? date.getMonth() : 0);
		inst.currentYear = (dates ? date.getFullYear() : 0);
		this._adjustInstDate(inst);
	},

	/* Retrieve the default date shown on opening. */
	_getDefaultDate: function(inst) {
		return this._restrictMinMax(inst,
			this._determineDate(inst, this._get(inst, "defaultDate"), new Date()));
	},

	/* A date may be specified as an exact value or a relative one. */
	_determineDate: function(inst, date, defaultDate) {
		var offsetNumeric = function(offset) {
				var date = new Date();
				date.setDate(date.getDate() + offset);
				return date;
			},
			offsetString = function(offset) {
				try {
					return $.datepicker.parseDate($.datepicker._get(inst, "dateFormat"),
						offset, $.datepicker._getFormatConfig(inst));
				}
				catch (e) {
					// Ignore
				}

				var date = (offset.toLowerCase().match(/^c/) ?
					$.datepicker._getDate(inst) : null) || new Date(),
					year = date.getFullYear(),
					month = date.getMonth(),
					day = date.getDate(),
					pattern = /([+\-]?[0-9]+)\s*(d|D|w|W|m|M|y|Y)?/g,
					matches = pattern.exec(offset);

				while (matches) {
					switch (matches[2] || "d") {
						case "d" : case "D" :
							day += parseInt(matches[1],10); break;
						case "w" : case "W" :
							day += parseInt(matches[1],10) * 7; break;
						case "m" : case "M" :
							month += parseInt(matches[1],10);
							day = Math.min(day, $.datepicker._getDaysInMonth(year, month));
							break;
						case "y": case "Y" :
							year += parseInt(matches[1],10);
							day = Math.min(day, $.datepicker._getDaysInMonth(year, month));
							break;
					}
					matches = pattern.exec(offset);
				}
				return new Date(year, month, day);
			},
			newDate = (date == null || date === "" ? defaultDate : (typeof date === "string" ? offsetString(date) :
				(typeof date === "number" ? (isNaN(date) ? defaultDate : offsetNumeric(date)) : new Date(date.getTime()))));

		newDate = (newDate && newDate.toString() === "Invalid Date" ? defaultDate : newDate);
		if (newDate) {
			newDate.setHours(0);
			newDate.setMinutes(0);
			newDate.setSeconds(0);
			newDate.setMilliseconds(0);
		}
		return this._daylightSavingAdjust(newDate);
	},

	/* Handle switch to/from daylight saving.
	 * Hours may be non-zero on daylight saving cut-over:
	 * > 12 when midnight changeover, but then cannot generate
	 * midnight datetime, so jump to 1AM, otherwise reset.
	 * @param  date  (Date) the date to check
	 * @return  (Date) the corrected date
	 */
	_daylightSavingAdjust: function(date) {
		if (!date) {
			return null;
		}
		date.setHours(date.getHours() > 12 ? date.getHours() + 2 : 0);
		return date;
	},

	/* Set the date(s) directly. */
	_setDate: function(inst, date, noChange) {
		var clear = !date,
			origMonth = inst.selectedMonth,
			origYear = inst.selectedYear,
			newDate = this._restrictMinMax(inst, this._determineDate(inst, date, new Date()));

		inst.selectedDay = inst.currentDay = newDate.getDate();
		inst.drawMonth = inst.selectedMonth = inst.currentMonth = newDate.getMonth();
		inst.drawYear = inst.selectedYear = inst.currentYear = newDate.getFullYear();
		if ((origMonth !== inst.selectedMonth || origYear !== inst.selectedYear) && !noChange) {
			this._notifyChange(inst);
		}
		this._adjustInstDate(inst);
		if (inst.input) {
			inst.input.val(clear ? "" : this._formatDate(inst));
		}
	},

	/* Retrieve the date(s) directly. */
	_getDate: function(inst) {
		var startDate = (!inst.currentYear || (inst.input && inst.input.val() === "") ? null :
			this._daylightSavingAdjust(new Date(
			inst.currentYear, inst.currentMonth, inst.currentDay)));
			return startDate;
	},

	/* Attach the onxxx handlers.  These are declared statically so
	 * they work with static code transformers like Caja.
	 */
	_attachHandlers: function(inst) {
		var stepMonths = this._get(inst, "stepMonths"),
			id = "#" + inst.id.replace( /\\\\/g, "\\" );
		inst.dpDiv.find("[data-handler]").map(function () {
			var handler = {
				prev: function () {
					$.datepicker._adjustDate(id, -stepMonths, "M");
				},
				next: function () {
					$.datepicker._adjustDate(id, +stepMonths, "M");
				},
				hide: function () {
					$.datepicker._hideDatepicker();
				},
				today: function () {
					$.datepicker._gotoToday(id);
				},
				selectDay: function () {
					$.datepicker._selectDay(id, +this.getAttribute("data-month"), +this.getAttribute("data-year"), this);
					return false;
				},
				selectMonth: function () {
					$.datepicker._selectMonthYear(id, this, "M");
					return false;
				},
				selectYear: function () {
					$.datepicker._selectMonthYear(id, this, "Y");
					return false;
				}
			};
			$(this).bind(this.getAttribute("data-event"), handler[this.getAttribute("data-handler")]);
		});
	},

	/* Generate the HTML for the current state of the date picker. */
	_generateHTML: function(inst) {
		var maxDraw, prevText, prev, nextText, next, currentText, gotoDate,
			controls, buttonPanel, firstDay, showWeek, dayNames, dayNamesMin,
			monthNames, monthNamesShort, beforeShowDay, showOtherMonths,
			selectOtherMonths, defaultDate, html, dow, row, group, col, selectedDate,
			cornerClass, calender, thead, day, daysInMonth, leadDays, curRows, numRows,
			printDate, dRow, tbody, daySettings, otherMonth, unselectable,
			tempDate = new Date(),
			today = this._daylightSavingAdjust(
				new Date(tempDate.getFullYear(), tempDate.getMonth(), tempDate.getDate())), // clear time
			isRTL = this._get(inst, "isRTL"),
			showButtonPanel = this._get(inst, "showButtonPanel"),
			hideIfNoPrevNext = this._get(inst, "hideIfNoPrevNext"),
			navigationAsDateFormat = this._get(inst, "navigationAsDateFormat"),
			numMonths = this._getNumberOfMonths(inst),
			showCurrentAtPos = this._get(inst, "showCurrentAtPos"),
			stepMonths = this._get(inst, "stepMonths"),
			isMultiMonth = (numMonths[0] !== 1 || numMonths[1] !== 1),
			currentDate = this._daylightSavingAdjust((!inst.currentDay ? new Date(9999, 9, 9) :
				new Date(inst.currentYear, inst.currentMonth, inst.currentDay))),
			minDate = this._getMinMaxDate(inst, "min"),
			maxDate = this._getMinMaxDate(inst, "max"),
			drawMonth = inst.drawMonth - showCurrentAtPos,
			drawYear = inst.drawYear;

		if (drawMonth < 0) {
			drawMonth += 12;
			drawYear--;
		}
		if (maxDate) {
			maxDraw = this._daylightSavingAdjust(new Date(maxDate.getFullYear(),
				maxDate.getMonth() - (numMonths[0] * numMonths[1]) + 1, maxDate.getDate()));
			maxDraw = (minDate && maxDraw < minDate ? minDate : maxDraw);
			while (this._daylightSavingAdjust(new Date(drawYear, drawMonth, 1)) > maxDraw) {
				drawMonth--;
				if (drawMonth < 0) {
					drawMonth = 11;
					drawYear--;
				}
			}
		}
		inst.drawMonth = drawMonth;
		inst.drawYear = drawYear;

		prevText = this._get(inst, "prevText");
		prevText = (!navigationAsDateFormat ? prevText : this.formatDate(prevText,
			this._daylightSavingAdjust(new Date(drawYear, drawMonth - stepMonths, 1)),
			this._getFormatConfig(inst)));

		prev = (this._canAdjustMonth(inst, -1, drawYear, drawMonth) ?
			"<a class='ui-datepicker-prev ui-corner-all' data-handler='prev' data-event='click'" +
			" title='" + prevText + "'><span class='ui-icon ui-icon-circle-triangle-" + ( isRTL ? "e" : "w") + "'>" + prevText + "</span></a>" :
			(hideIfNoPrevNext ? "" : "<a class='ui-datepicker-prev ui-corner-all ui-state-disabled' title='"+ prevText +"'><span class='ui-icon ui-icon-circle-triangle-" + ( isRTL ? "e" : "w") + "'>" + prevText + "</span></a>"));

		nextText = this._get(inst, "nextText");
		nextText = (!navigationAsDateFormat ? nextText : this.formatDate(nextText,
			this._daylightSavingAdjust(new Date(drawYear, drawMonth + stepMonths, 1)),
			this._getFormatConfig(inst)));

		next = (this._canAdjustMonth(inst, +1, drawYear, drawMonth) ?
			"<a class='ui-datepicker-next ui-corner-all' data-handler='next' data-event='click'" +
			" title='" + nextText + "'><span class='ui-icon ui-icon-circle-triangle-" + ( isRTL ? "w" : "e") + "'>" + nextText + "</span></a>" :
			(hideIfNoPrevNext ? "" : "<a class='ui-datepicker-next ui-corner-all ui-state-disabled' title='"+ nextText + "'><span class='ui-icon ui-icon-circle-triangle-" + ( isRTL ? "w" : "e") + "'>" + nextText + "</span></a>"));

		currentText = this._get(inst, "currentText");
		gotoDate = (this._get(inst, "gotoCurrent") && inst.currentDay ? currentDate : today);
		currentText = (!navigationAsDateFormat ? currentText :
			this.formatDate(currentText, gotoDate, this._getFormatConfig(inst)));

		controls = (!inst.inline ? "<button type='button' class='ui-datepicker-close ui-state-default ui-priority-primary ui-corner-all' data-handler='hide' data-event='click'>" +
			this._get(inst, "closeText") + "</button>" : "");

		buttonPanel = (showButtonPanel) ? "<div class='ui-datepicker-buttonpane ui-widget-content'>" + (isRTL ? controls : "") +
			(this._isInRange(inst, gotoDate) ? "<button type='button' class='ui-datepicker-current ui-state-default ui-priority-secondary ui-corner-all' data-handler='today' data-event='click'" +
			">" + currentText + "</button>" : "") + (isRTL ? "" : controls) + "</div>" : "";

		firstDay = parseInt(this._get(inst, "firstDay"),10);
		firstDay = (isNaN(firstDay) ? 0 : firstDay);

		showWeek = this._get(inst, "showWeek");
		dayNames = this._get(inst, "dayNames");
		dayNamesMin = this._get(inst, "dayNamesMin");
		monthNames = this._get(inst, "monthNames");
		monthNamesShort = this._get(inst, "monthNamesShort");
		beforeShowDay = this._get(inst, "beforeShowDay");
		showOtherMonths = this._get(inst, "showOtherMonths");
		selectOtherMonths = this._get(inst, "selectOtherMonths");
		defaultDate = this._getDefaultDate(inst);
		html = "";
		dow;
		for (row = 0; row < numMonths[0]; row++) {
			group = "";
			this.maxRows = 4;
			for (col = 0; col < numMonths[1]; col++) {
				selectedDate = this._daylightSavingAdjust(new Date(drawYear, drawMonth, inst.selectedDay));
				cornerClass = " ui-corner-all";
				calender = "";
				if (isMultiMonth) {
					calender += "<div class='ui-datepicker-group";
					if (numMonths[1] > 1) {
						switch (col) {
							case 0: calender += " ui-datepicker-group-first";
								cornerClass = " ui-corner-" + (isRTL ? "right" : "left"); break;
							case numMonths[1]-1: calender += " ui-datepicker-group-last";
								cornerClass = " ui-corner-" + (isRTL ? "left" : "right"); break;
							default: calender += " ui-datepicker-group-middle"; cornerClass = ""; break;
						}
					}
					calender += "'>";
				}
				calender += "<div class='ui-datepicker-header ui-widget-header ui-helper-clearfix" + cornerClass + "'>" +
					(/all|left/.test(cornerClass) && row === 0 ? (isRTL ? next : prev) : "") +
					(/all|right/.test(cornerClass) && row === 0 ? (isRTL ? prev : next) : "") +
					this._generateMonthYearHeader(inst, drawMonth, drawYear, minDate, maxDate,
					row > 0 || col > 0, monthNames, monthNamesShort) + // draw month headers
					"</div><table class='ui-datepicker-calendar'><thead>" +
					"<tr>";
				thead = (showWeek ? "<th class='ui-datepicker-week-col'>" + this._get(inst, "weekHeader") + "</th>" : "");
				for (dow = 0; dow < 7; dow++) { // days of the week
					day = (dow + firstDay) % 7;
					thead += "<th" + ((dow + firstDay + 6) % 7 >= 5 ? " class='ui-datepicker-week-end'" : "") + ">" +
						"<span title='" + dayNames[day] + "'>" + dayNamesMin[day] + "</span></th>";
				}
				calender += thead + "</tr></thead><tbody>";
				daysInMonth = this._getDaysInMonth(drawYear, drawMonth);
				if (drawYear === inst.selectedYear && drawMonth === inst.selectedMonth) {
					inst.selectedDay = Math.min(inst.selectedDay, daysInMonth);
				}
				leadDays = (this._getFirstDayOfMonth(drawYear, drawMonth) - firstDay + 7) % 7;
				curRows = Math.ceil((leadDays + daysInMonth) / 7); // calculate the number of rows to generate
				numRows = (isMultiMonth ? this.maxRows > curRows ? this.maxRows : curRows : curRows); //If multiple months, use the higher number of rows (see #7043)
				this.maxRows = numRows;
				printDate = this._daylightSavingAdjust(new Date(drawYear, drawMonth, 1 - leadDays));
				for (dRow = 0; dRow < numRows; dRow++) { // create date picker rows
					calender += "<tr>";
					tbody = (!showWeek ? "" : "<td class='ui-datepicker-week-col'>" +
						this._get(inst, "calculateWeek")(printDate) + "</td>");
					for (dow = 0; dow < 7; dow++) { // create date picker days
						daySettings = (beforeShowDay ?
							beforeShowDay.apply((inst.input ? inst.input[0] : null), [printDate]) : [true, ""]);
						otherMonth = (printDate.getMonth() !== drawMonth);
						unselectable = (otherMonth && !selectOtherMonths) || !daySettings[0] ||
							(minDate && printDate < minDate) || (maxDate && printDate > maxDate);
						tbody += "<td class='" +
							((dow + firstDay + 6) % 7 >= 5 ? " ui-datepicker-week-end" : "") + // highlight weekends
							(otherMonth ? " ui-datepicker-other-month" : "") + // highlight days from other months
							((printDate.getTime() === selectedDate.getTime() && drawMonth === inst.selectedMonth && inst._keyEvent) || // user pressed key
							(defaultDate.getTime() === printDate.getTime() && defaultDate.getTime() === selectedDate.getTime()) ?
							// or defaultDate is current printedDate and defaultDate is selectedDate
							" " + this._dayOverClass : "") + // highlight selected day
							(unselectable ? " " + this._unselectableClass + " ui-state-disabled": "") +  // highlight unselectable days
							(otherMonth && !showOtherMonths ? "" : " " + daySettings[1] + // highlight custom dates
							(printDate.getTime() === currentDate.getTime() ? " " + this._currentClass : "") + // highlight selected day
							(printDate.getTime() === today.getTime() ? " ui-datepicker-today" : "")) + "'" + // highlight today (if different)
							((!otherMonth || showOtherMonths) && daySettings[2] ? " title='" + daySettings[2].replace(/'/g, "&#39;") + "'" : "") + // cell title
							(unselectable ? "" : " data-handler='selectDay' data-event='click' data-month='" + printDate.getMonth() + "' data-year='" + printDate.getFullYear() + "'") + ">" + // actions
							(otherMonth && !showOtherMonths ? "&#xa0;" : // display for other months
							(unselectable ? "<span class='ui-state-default'>" + printDate.getDate() + "</span>" : "<a class='ui-state-default" +
							(printDate.getTime() === today.getTime() ? " ui-state-highlight" : "") +
							(printDate.getTime() === currentDate.getTime() ? " ui-state-active" : "") + // highlight selected day
							(otherMonth ? " ui-priority-secondary" : "") + // distinguish dates from other months
							"' href='#'>" + printDate.getDate() + "</a>")) + "</td>"; // display selectable date
						printDate.setDate(printDate.getDate() + 1);
						printDate = this._daylightSavingAdjust(printDate);
					}
					calender += tbody + "</tr>";
				}
				drawMonth++;
				if (drawMonth > 11) {
					drawMonth = 0;
					drawYear++;
				}
				calender += "</tbody></table>" + (isMultiMonth ? "</div>" +
							((numMonths[0] > 0 && col === numMonths[1]-1) ? "<div class='ui-datepicker-row-break'></div>" : "") : "");
				group += calender;
			}
			html += group;
		}
		html += buttonPanel;
		inst._keyEvent = false;
		return html;
	},

	/* Generate the month and year header. */
	_generateMonthYearHeader: function(inst, drawMonth, drawYear, minDate, maxDate,
			secondary, monthNames, monthNamesShort) {

		var inMinYear, inMaxYear, month, years, thisYear, determineYear, year, endYear,
			changeMonth = this._get(inst, "changeMonth"),
			changeYear = this._get(inst, "changeYear"),
			showMonthAfterYear = this._get(inst, "showMonthAfterYear"),
			html = "<div class='ui-datepicker-title'>",
			monthHtml = "";

		// month selection
		if (secondary || !changeMonth) {
			monthHtml += "<span class='ui-datepicker-month'>" + monthNames[drawMonth] + "</span>";
		} else {
			inMinYear = (minDate && minDate.getFullYear() === drawYear);
			inMaxYear = (maxDate && maxDate.getFullYear() === drawYear);
			monthHtml += "<select class='ui-datepicker-month' data-handler='selectMonth' data-event='change'>";
			for ( month = 0; month < 12; month++) {
				if ((!inMinYear || month >= minDate.getMonth()) && (!inMaxYear || month <= maxDate.getMonth())) {
					monthHtml += "<option value='" + month + "'" +
						(month === drawMonth ? " selected='selected'" : "") +
						">" + monthNamesShort[month] + "</option>";
				}
			}
			monthHtml += "</select>";
		}

		if (!showMonthAfterYear) {
			html += monthHtml + (secondary || !(changeMonth && changeYear) ? "&#xa0;" : "");
		}

		// year selection
		if ( !inst.yearshtml ) {
			inst.yearshtml = "";
			if (secondary || !changeYear) {
				html += "<span class='ui-datepicker-year'>" + drawYear + "</span>";
			} else {
				// determine range of years to display
				years = this._get(inst, "yearRange").split(":");
				thisYear = new Date().getFullYear();
				determineYear = function(value) {
					var year = (value.match(/c[+\-].*/) ? drawYear + parseInt(value.substring(1), 10) :
						(value.match(/[+\-].*/) ? thisYear + parseInt(value, 10) :
						parseInt(value, 10)));
					return (isNaN(year) ? thisYear : year);
				};
				year = determineYear(years[0]);
				endYear = Math.max(year, determineYear(years[1] || ""));
				year = (minDate ? Math.max(year, minDate.getFullYear()) : year);
				endYear = (maxDate ? Math.min(endYear, maxDate.getFullYear()) : endYear);
				inst.yearshtml += "<select class='ui-datepicker-year' data-handler='selectYear' data-event='change'>";
				for (; year <= endYear; year++) {
					inst.yearshtml += "<option value='" + year + "'" +
						(year === drawYear ? " selected='selected'" : "") +
						">" + year + "</option>";
				}
				inst.yearshtml += "</select>";

				html += inst.yearshtml;
				inst.yearshtml = null;
			}
		}

		html += this._get(inst, "yearSuffix");
		if (showMonthAfterYear) {
			html += (secondary || !(changeMonth && changeYear) ? "&#xa0;" : "") + monthHtml;
		}
		html += "</div>"; // Close datepicker_header
		return html;
	},

	/* Adjust one of the date sub-fields. */
	_adjustInstDate: function(inst, offset, period) {
		var year = inst.drawYear + (period === "Y" ? offset : 0),
			month = inst.drawMonth + (period === "M" ? offset : 0),
			day = Math.min(inst.selectedDay, this._getDaysInMonth(year, month)) + (period === "D" ? offset : 0),
			date = this._restrictMinMax(inst, this._daylightSavingAdjust(new Date(year, month, day)));

		inst.selectedDay = date.getDate();
		inst.drawMonth = inst.selectedMonth = date.getMonth();
		inst.drawYear = inst.selectedYear = date.getFullYear();
		if (period === "M" || period === "Y") {
			this._notifyChange(inst);
		}
	},

	/* Ensure a date is within any min/max bounds. */
	_restrictMinMax: function(inst, date) {
		var minDate = this._getMinMaxDate(inst, "min"),
			maxDate = this._getMinMaxDate(inst, "max"),
			newDate = (minDate && date < minDate ? minDate : date);
		return (maxDate && newDate > maxDate ? maxDate : newDate);
	},

	/* Notify change of month/year. */
	_notifyChange: function(inst) {
		var onChange = this._get(inst, "onChangeMonthYear");
		if (onChange) {
			onChange.apply((inst.input ? inst.input[0] : null),
				[inst.selectedYear, inst.selectedMonth + 1, inst]);
		}
	},

	/* Determine the number of months to show. */
	_getNumberOfMonths: function(inst) {
		var numMonths = this._get(inst, "numberOfMonths");
		return (numMonths == null ? [1, 1] : (typeof numMonths === "number" ? [1, numMonths] : numMonths));
	},

	/* Determine the current maximum date - ensure no time components are set. */
	_getMinMaxDate: function(inst, minMax) {
		return this._determineDate(inst, this._get(inst, minMax + "Date"), null);
	},

	/* Find the number of days in a given month. */
	_getDaysInMonth: function(year, month) {
		return 32 - this._daylightSavingAdjust(new Date(year, month, 32)).getDate();
	},

	/* Find the day of the week of the first of a month. */
	_getFirstDayOfMonth: function(year, month) {
		return new Date(year, month, 1).getDay();
	},

	/* Determines if we should allow a "next/prev" month display change. */
	_canAdjustMonth: function(inst, offset, curYear, curMonth) {
		var numMonths = this._getNumberOfMonths(inst),
			date = this._daylightSavingAdjust(new Date(curYear,
			curMonth + (offset < 0 ? offset : numMonths[0] * numMonths[1]), 1));

		if (offset < 0) {
			date.setDate(this._getDaysInMonth(date.getFullYear(), date.getMonth()));
		}
		return this._isInRange(inst, date);
	},

	/* Is the given date in the accepted range? */
	_isInRange: function(inst, date) {
		var yearSplit, currentYear,
			minDate = this._getMinMaxDate(inst, "min"),
			maxDate = this._getMinMaxDate(inst, "max"),
			minYear = null,
			maxYear = null,
			years = this._get(inst, "yearRange");
			if (years){
				yearSplit = years.split(":");
				currentYear = new Date().getFullYear();
				minYear = parseInt(yearSplit[0], 10);
				maxYear = parseInt(yearSplit[1], 10);
				if ( yearSplit[0].match(/[+\-].*/) ) {
					minYear += currentYear;
				}
				if ( yearSplit[1].match(/[+\-].*/) ) {
					maxYear += currentYear;
				}
			}

		return ((!minDate || date.getTime() >= minDate.getTime()) &&
			(!maxDate || date.getTime() <= maxDate.getTime()) &&
			(!minYear || date.getFullYear() >= minYear) &&
			(!maxYear || date.getFullYear() <= maxYear));
	},

	/* Provide the configuration settings for formatting/parsing. */
	_getFormatConfig: function(inst) {
		var shortYearCutoff = this._get(inst, "shortYearCutoff");
		shortYearCutoff = (typeof shortYearCutoff !== "string" ? shortYearCutoff :
			new Date().getFullYear() % 100 + parseInt(shortYearCutoff, 10));
		return {shortYearCutoff: shortYearCutoff,
			dayNamesShort: this._get(inst, "dayNamesShort"), dayNames: this._get(inst, "dayNames"),
			monthNamesShort: this._get(inst, "monthNamesShort"), monthNames: this._get(inst, "monthNames")};
	},

	/* Format the given date for display. */
	_formatDate: function(inst, day, month, year) {
		if (!day) {
			inst.currentDay = inst.selectedDay;
			inst.currentMonth = inst.selectedMonth;
			inst.currentYear = inst.selectedYear;
		}
		var date = (day ? (typeof day === "object" ? day :
			this._daylightSavingAdjust(new Date(year, month, day))) :
			this._daylightSavingAdjust(new Date(inst.currentYear, inst.currentMonth, inst.currentDay)));
		return this.formatDate(this._get(inst, "dateFormat"), date, this._getFormatConfig(inst));
	}
});

/*
 * Bind hover events for datepicker elements.
 * Done via delegate so the binding only occurs once in the lifetime of the parent div.
 * Global instActive, set by _updateDatepicker allows the handlers to find their way back to the active picker.
 */
function bindHover(dpDiv) {
	var selector = "button, .ui-datepicker-prev, .ui-datepicker-next, .ui-datepicker-calendar td a";
	return dpDiv.delegate(selector, "mouseout", function() {
			$(this).removeClass("ui-state-hover");
			if (this.className.indexOf("ui-datepicker-prev") !== -1) {
				$(this).removeClass("ui-datepicker-prev-hover");
			}
			if (this.className.indexOf("ui-datepicker-next") !== -1) {
				$(this).removeClass("ui-datepicker-next-hover");
			}
		})
		.delegate(selector, "mouseover", function(){
			if (!$.datepicker._isDisabledDatepicker( instActive.inline ? dpDiv.parent()[0] : instActive.input[0])) {
				$(this).parents(".ui-datepicker-calendar").find("a").removeClass("ui-state-hover");
				$(this).addClass("ui-state-hover");
				if (this.className.indexOf("ui-datepicker-prev") !== -1) {
					$(this).addClass("ui-datepicker-prev-hover");
				}
				if (this.className.indexOf("ui-datepicker-next") !== -1) {
					$(this).addClass("ui-datepicker-next-hover");
				}
			}
		});
}

/* jQuery extend now ignores nulls! */
function extendRemove(target, props) {
	$.extend(target, props);
	for (var name in props) {
		if (props[name] == null) {
			target[name] = props[name];
		}
	}
	return target;
}

/* Invoke the datepicker functionality.
   @param  options  string - a command, optionally followed by additional parameters or
					Object - settings for attaching new datepicker functionality
   @return  jQuery object */
$.fn.datepicker = function(options){

	/* Verify an empty collection wasn't passed - Fixes #6976 */
	if ( !this.length ) {
		return this;
	}

	/* Initialise the date picker. */
	if (!$.datepicker.initialized) {
		$(document).mousedown($.datepicker._checkExternalClick);
		$.datepicker.initialized = true;
	}

	/* Append datepicker main container to body if not exist. */
	if ($("#"+$.datepicker._mainDivId).length === 0) {
		$("body").append($.datepicker.dpDiv);
	}

	var otherArgs = Array.prototype.slice.call(arguments, 1);
	if (typeof options === "string" && (options === "isDisabled" || options === "getDate" || options === "widget")) {
		return $.datepicker["_" + options + "Datepicker"].
			apply($.datepicker, [this[0]].concat(otherArgs));
	}
	if (options === "option" && arguments.length === 2 && typeof arguments[1] === "string") {
		return $.datepicker["_" + options + "Datepicker"].
			apply($.datepicker, [this[0]].concat(otherArgs));
	}
	return this.each(function() {
		typeof options === "string" ?
			$.datepicker["_" + options + "Datepicker"].
				apply($.datepicker, [this].concat(otherArgs)) :
			$.datepicker._attachDatepicker(this, options);
	});
};

$.datepicker = new Datepicker(); // singleton instance
$.datepicker.initialized = false;
$.datepicker.uuid = new Date().getTime();
$.datepicker.version = "1.10.4";

})(jQuery);

},{"./core":"jquery-ui/core","jquery":"jquery"}],"jquery-ui/menu":[function(require,module,exports){
var jQuery = require('jquery');
require('./core');
require('./widget');
require('./position');

/*!
 * jQuery UI Menu 1.10.4
 * http://jqueryui.com
 *
 * Copyright 2014 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/menu/
 *
 * Depends:
 *	jquery.ui.core.js
 *	jquery.ui.widget.js
 *	jquery.ui.position.js
 */
(function( $, undefined ) {

$.widget( "ui.menu", {
	version: "1.10.4",
	defaultElement: "<ul>",
	delay: 300,
	options: {
		icons: {
			submenu: "ui-icon-carat-1-e"
		},
		menus: "ul",
		position: {
			my: "left top",
			at: "right top"
		},
		role: "menu",

		// callbacks
		blur: null,
		focus: null,
		select: null
	},

	_create: function() {
		this.activeMenu = this.element;
		// flag used to prevent firing of the click handler
		// as the event bubbles up through nested menus
		this.mouseHandled = false;
		this.element
			.uniqueId()
			.addClass( "ui-menu ui-widget ui-widget-content ui-corner-all" )
			.toggleClass( "ui-menu-icons", !!this.element.find( ".ui-icon" ).length )
			.attr({
				role: this.options.role,
				tabIndex: 0
			})
			// need to catch all clicks on disabled menu
			// not possible through _on
			.bind( "click" + this.eventNamespace, $.proxy(function( event ) {
				if ( this.options.disabled ) {
					event.preventDefault();
				}
			}, this ));

		if ( this.options.disabled ) {
			this.element
				.addClass( "ui-state-disabled" )
				.attr( "aria-disabled", "true" );
		}

		this._on({
			// Prevent focus from sticking to links inside menu after clicking
			// them (focus should always stay on UL during navigation).
			"mousedown .ui-menu-item > a": function( event ) {
				event.preventDefault();
			},
			"click .ui-state-disabled > a": function( event ) {
				event.preventDefault();
			},
			"click .ui-menu-item:has(a)": function( event ) {
				var target = $( event.target ).closest( ".ui-menu-item" );
				if ( !this.mouseHandled && target.not( ".ui-state-disabled" ).length ) {
					this.select( event );

					// Only set the mouseHandled flag if the event will bubble, see #9469.
					if ( !event.isPropagationStopped() ) {
						this.mouseHandled = true;
					}

					// Open submenu on click
					if ( target.has( ".ui-menu" ).length ) {
						this.expand( event );
					} else if ( !this.element.is( ":focus" ) && $( this.document[ 0 ].activeElement ).closest( ".ui-menu" ).length ) {

						// Redirect focus to the menu
						this.element.trigger( "focus", [ true ] );

						// If the active item is on the top level, let it stay active.
						// Otherwise, blur the active item since it is no longer visible.
						if ( this.active && this.active.parents( ".ui-menu" ).length === 1 ) {
							clearTimeout( this.timer );
						}
					}
				}
			},
			"mouseenter .ui-menu-item": function( event ) {
				var target = $( event.currentTarget );
				// Remove ui-state-active class from siblings of the newly focused menu item
				// to avoid a jump caused by adjacent elements both having a class with a border
				target.siblings().children( ".ui-state-active" ).removeClass( "ui-state-active" );
				this.focus( event, target );
			},
			mouseleave: "collapseAll",
			"mouseleave .ui-menu": "collapseAll",
			focus: function( event, keepActiveItem ) {
				// If there's already an active item, keep it active
				// If not, activate the first item
				var item = this.active || this.element.children( ".ui-menu-item" ).eq( 0 );

				if ( !keepActiveItem ) {
					this.focus( event, item );
				}
			},
			blur: function( event ) {
				this._delay(function() {
					if ( !$.contains( this.element[0], this.document[0].activeElement ) ) {
						this.collapseAll( event );
					}
				});
			},
			keydown: "_keydown"
		});

		this.refresh();

		// Clicks outside of a menu collapse any open menus
		this._on( this.document, {
			click: function( event ) {
				if ( !$( event.target ).closest( ".ui-menu" ).length ) {
					this.collapseAll( event );
				}

				// Reset the mouseHandled flag
				this.mouseHandled = false;
			}
		});
	},

	_destroy: function() {
		// Destroy (sub)menus
		this.element
			.removeAttr( "aria-activedescendant" )
			.find( ".ui-menu" ).addBack()
				.removeClass( "ui-menu ui-widget ui-widget-content ui-corner-all ui-menu-icons" )
				.removeAttr( "role" )
				.removeAttr( "tabIndex" )
				.removeAttr( "aria-labelledby" )
				.removeAttr( "aria-expanded" )
				.removeAttr( "aria-hidden" )
				.removeAttr( "aria-disabled" )
				.removeUniqueId()
				.show();

		// Destroy menu items
		this.element.find( ".ui-menu-item" )
			.removeClass( "ui-menu-item" )
			.removeAttr( "role" )
			.removeAttr( "aria-disabled" )
			.children( "a" )
				.removeUniqueId()
				.removeClass( "ui-corner-all ui-state-hover" )
				.removeAttr( "tabIndex" )
				.removeAttr( "role" )
				.removeAttr( "aria-haspopup" )
				.children().each( function() {
					var elem = $( this );
					if ( elem.data( "ui-menu-submenu-carat" ) ) {
						elem.remove();
					}
				});

		// Destroy menu dividers
		this.element.find( ".ui-menu-divider" ).removeClass( "ui-menu-divider ui-widget-content" );
	},

	_keydown: function( event ) {
		var match, prev, character, skip, regex,
			preventDefault = true;

		function escape( value ) {
			return value.replace( /[\-\[\]{}()*+?.,\\\^$|#\s]/g, "\\$&" );
		}

		switch ( event.keyCode ) {
		case $.ui.keyCode.PAGE_UP:
			this.previousPage( event );
			break;
		case $.ui.keyCode.PAGE_DOWN:
			this.nextPage( event );
			break;
		case $.ui.keyCode.HOME:
			this._move( "first", "first", event );
			break;
		case $.ui.keyCode.END:
			this._move( "last", "last", event );
			break;
		case $.ui.keyCode.UP:
			this.previous( event );
			break;
		case $.ui.keyCode.DOWN:
			this.next( event );
			break;
		case $.ui.keyCode.LEFT:
			this.collapse( event );
			break;
		case $.ui.keyCode.RIGHT:
			if ( this.active && !this.active.is( ".ui-state-disabled" ) ) {
				this.expand( event );
			}
			break;
		case $.ui.keyCode.ENTER:
		case $.ui.keyCode.SPACE:
			this._activate( event );
			break;
		case $.ui.keyCode.ESCAPE:
			this.collapse( event );
			break;
		default:
			preventDefault = false;
			prev = this.previousFilter || "";
			character = String.fromCharCode( event.keyCode );
			skip = false;

			clearTimeout( this.filterTimer );

			if ( character === prev ) {
				skip = true;
			} else {
				character = prev + character;
			}

			regex = new RegExp( "^" + escape( character ), "i" );
			match = this.activeMenu.children( ".ui-menu-item" ).filter(function() {
				return regex.test( $( this ).children( "a" ).text() );
			});
			match = skip && match.index( this.active.next() ) !== -1 ?
				this.active.nextAll( ".ui-menu-item" ) :
				match;

			// If no matches on the current filter, reset to the last character pressed
			// to move down the menu to the first item that starts with that character
			if ( !match.length ) {
				character = String.fromCharCode( event.keyCode );
				regex = new RegExp( "^" + escape( character ), "i" );
				match = this.activeMenu.children( ".ui-menu-item" ).filter(function() {
					return regex.test( $( this ).children( "a" ).text() );
				});
			}

			if ( match.length ) {
				this.focus( event, match );
				if ( match.length > 1 ) {
					this.previousFilter = character;
					this.filterTimer = this._delay(function() {
						delete this.previousFilter;
					}, 1000 );
				} else {
					delete this.previousFilter;
				}
			} else {
				delete this.previousFilter;
			}
		}

		if ( preventDefault ) {
			event.preventDefault();
		}
	},

	_activate: function( event ) {
		if ( !this.active.is( ".ui-state-disabled" ) ) {
			if ( this.active.children( "a[aria-haspopup='true']" ).length ) {
				this.expand( event );
			} else {
				this.select( event );
			}
		}
	},

	refresh: function() {
		var menus,
			icon = this.options.icons.submenu,
			submenus = this.element.find( this.options.menus );

		this.element.toggleClass( "ui-menu-icons", !!this.element.find( ".ui-icon" ).length );

		// Initialize nested menus
		submenus.filter( ":not(.ui-menu)" )
			.addClass( "ui-menu ui-widget ui-widget-content ui-corner-all" )
			.hide()
			.attr({
				role: this.options.role,
				"aria-hidden": "true",
				"aria-expanded": "false"
			})
			.each(function() {
				var menu = $( this ),
					item = menu.prev( "a" ),
					submenuCarat = $( "<span>" )
						.addClass( "ui-menu-icon ui-icon " + icon )
						.data( "ui-menu-submenu-carat", true );

				item
					.attr( "aria-haspopup", "true" )
					.prepend( submenuCarat );
				menu.attr( "aria-labelledby", item.attr( "id" ) );
			});

		menus = submenus.add( this.element );

		// Don't refresh list items that are already adapted
		menus.children( ":not(.ui-menu-item):has(a)" )
			.addClass( "ui-menu-item" )
			.attr( "role", "presentation" )
			.children( "a" )
				.uniqueId()
				.addClass( "ui-corner-all" )
				.attr({
					tabIndex: -1,
					role: this._itemRole()
				});

		// Initialize unlinked menu-items containing spaces and/or dashes only as dividers
		menus.children( ":not(.ui-menu-item)" ).each(function() {
			var item = $( this );
			// hyphen, em dash, en dash
			if ( !/[^\-\u2014\u2013\s]/.test( item.text() ) ) {
				item.addClass( "ui-widget-content ui-menu-divider" );
			}
		});

		// Add aria-disabled attribute to any disabled menu item
		menus.children( ".ui-state-disabled" ).attr( "aria-disabled", "true" );

		// If the active item has been removed, blur the menu
		if ( this.active && !$.contains( this.element[ 0 ], this.active[ 0 ] ) ) {
			this.blur();
		}
	},

	_itemRole: function() {
		return {
			menu: "menuitem",
			listbox: "option"
		}[ this.options.role ];
	},

	_setOption: function( key, value ) {
		if ( key === "icons" ) {
			this.element.find( ".ui-menu-icon" )
				.removeClass( this.options.icons.submenu )
				.addClass( value.submenu );
		}
		this._super( key, value );
	},

	focus: function( event, item ) {
		var nested, focused;
		this.blur( event, event && event.type === "focus" );

		this._scrollIntoView( item );

		this.active = item.first();
		focused = this.active.children( "a" ).addClass( "ui-state-focus" );
		// Only update aria-activedescendant if there's a role
		// otherwise we assume focus is managed elsewhere
		if ( this.options.role ) {
			this.element.attr( "aria-activedescendant", focused.attr( "id" ) );
		}

		// Highlight active parent menu item, if any
		this.active
			.parent()
			.closest( ".ui-menu-item" )
			.children( "a:first" )
			.addClass( "ui-state-active" );

		if ( event && event.type === "keydown" ) {
			this._close();
		} else {
			this.timer = this._delay(function() {
				this._close();
			}, this.delay );
		}

		nested = item.children( ".ui-menu" );
		if ( nested.length && event && ( /^mouse/.test( event.type ) ) ) {
			this._startOpening(nested);
		}
		this.activeMenu = item.parent();

		this._trigger( "focus", event, { item: item } );
	},

	_scrollIntoView: function( item ) {
		var borderTop, paddingTop, offset, scroll, elementHeight, itemHeight;
		if ( this._hasScroll() ) {
			borderTop = parseFloat( $.css( this.activeMenu[0], "borderTopWidth" ) ) || 0;
			paddingTop = parseFloat( $.css( this.activeMenu[0], "paddingTop" ) ) || 0;
			offset = item.offset().top - this.activeMenu.offset().top - borderTop - paddingTop;
			scroll = this.activeMenu.scrollTop();
			elementHeight = this.activeMenu.height();
			itemHeight = item.height();

			if ( offset < 0 ) {
				this.activeMenu.scrollTop( scroll + offset );
			} else if ( offset + itemHeight > elementHeight ) {
				this.activeMenu.scrollTop( scroll + offset - elementHeight + itemHeight );
			}
		}
	},

	blur: function( event, fromFocus ) {
		if ( !fromFocus ) {
			clearTimeout( this.timer );
		}

		if ( !this.active ) {
			return;
		}

		this.active.children( "a" ).removeClass( "ui-state-focus" );
		this.active = null;

		this._trigger( "blur", event, { item: this.active } );
	},

	_startOpening: function( submenu ) {
		clearTimeout( this.timer );

		// Don't open if already open fixes a Firefox bug that caused a .5 pixel
		// shift in the submenu position when mousing over the carat icon
		if ( submenu.attr( "aria-hidden" ) !== "true" ) {
			return;
		}

		this.timer = this._delay(function() {
			this._close();
			this._open( submenu );
		}, this.delay );
	},

	_open: function( submenu ) {
		var position = $.extend({
			of: this.active
		}, this.options.position );

		clearTimeout( this.timer );
		this.element.find( ".ui-menu" ).not( submenu.parents( ".ui-menu" ) )
			.hide()
			.attr( "aria-hidden", "true" );

		submenu
			.show()
			.removeAttr( "aria-hidden" )
			.attr( "aria-expanded", "true" )
			.position( position );
	},

	collapseAll: function( event, all ) {
		clearTimeout( this.timer );
		this.timer = this._delay(function() {
			// If we were passed an event, look for the submenu that contains the event
			var currentMenu = all ? this.element :
				$( event && event.target ).closest( this.element.find( ".ui-menu" ) );

			// If we found no valid submenu ancestor, use the main menu to close all sub menus anyway
			if ( !currentMenu.length ) {
				currentMenu = this.element;
			}

			this._close( currentMenu );

			this.blur( event );
			this.activeMenu = currentMenu;
		}, this.delay );
	},

	// With no arguments, closes the currently active menu - if nothing is active
	// it closes all menus.  If passed an argument, it will search for menus BELOW
	_close: function( startMenu ) {
		if ( !startMenu ) {
			startMenu = this.active ? this.active.parent() : this.element;
		}

		startMenu
			.find( ".ui-menu" )
				.hide()
				.attr( "aria-hidden", "true" )
				.attr( "aria-expanded", "false" )
			.end()
			.find( "a.ui-state-active" )
				.removeClass( "ui-state-active" );
	},

	collapse: function( event ) {
		var newItem = this.active &&
			this.active.parent().closest( ".ui-menu-item", this.element );
		if ( newItem && newItem.length ) {
			this._close();
			this.focus( event, newItem );
		}
	},

	expand: function( event ) {
		var newItem = this.active &&
			this.active
				.children( ".ui-menu " )
				.children( ".ui-menu-item" )
				.first();

		if ( newItem && newItem.length ) {
			this._open( newItem.parent() );

			// Delay so Firefox will not hide activedescendant change in expanding submenu from AT
			this._delay(function() {
				this.focus( event, newItem );
			});
		}
	},

	next: function( event ) {
		this._move( "next", "first", event );
	},

	previous: function( event ) {
		this._move( "prev", "last", event );
	},

	isFirstItem: function() {
		return this.active && !this.active.prevAll( ".ui-menu-item" ).length;
	},

	isLastItem: function() {
		return this.active && !this.active.nextAll( ".ui-menu-item" ).length;
	},

	_move: function( direction, filter, event ) {
		var next;
		if ( this.active ) {
			if ( direction === "first" || direction === "last" ) {
				next = this.active
					[ direction === "first" ? "prevAll" : "nextAll" ]( ".ui-menu-item" )
					.eq( -1 );
			} else {
				next = this.active
					[ direction + "All" ]( ".ui-menu-item" )
					.eq( 0 );
			}
		}
		if ( !next || !next.length || !this.active ) {
			next = this.activeMenu.children( ".ui-menu-item" )[ filter ]();
		}

		this.focus( event, next );
	},

	nextPage: function( event ) {
		var item, base, height;

		if ( !this.active ) {
			this.next( event );
			return;
		}
		if ( this.isLastItem() ) {
			return;
		}
		if ( this._hasScroll() ) {
			base = this.active.offset().top;
			height = this.element.height();
			this.active.nextAll( ".ui-menu-item" ).each(function() {
				item = $( this );
				return item.offset().top - base - height < 0;
			});

			this.focus( event, item );
		} else {
			this.focus( event, this.activeMenu.children( ".ui-menu-item" )
				[ !this.active ? "first" : "last" ]() );
		}
	},

	previousPage: function( event ) {
		var item, base, height;
		if ( !this.active ) {
			this.next( event );
			return;
		}
		if ( this.isFirstItem() ) {
			return;
		}
		if ( this._hasScroll() ) {
			base = this.active.offset().top;
			height = this.element.height();
			this.active.prevAll( ".ui-menu-item" ).each(function() {
				item = $( this );
				return item.offset().top - base + height > 0;
			});

			this.focus( event, item );
		} else {
			this.focus( event, this.activeMenu.children( ".ui-menu-item" ).first() );
		}
	},

	_hasScroll: function() {
		return this.element.outerHeight() < this.element.prop( "scrollHeight" );
	},

	select: function( event ) {
		// TODO: It should never be possible to not have an active item at this
		// point, but the tests don't trigger mouseenter before click.
		this.active = this.active || $( event.target ).closest( ".ui-menu-item" );
		var ui = { item: this.active };
		if ( !this.active.has( ".ui-menu" ).length ) {
			this.collapseAll( event, true );
		}
		this._trigger( "select", event, ui );
	}
});

}( jQuery ));

},{"./core":"jquery-ui/core","./position":"jquery-ui/position","./widget":"jquery-ui/widget","jquery":"jquery"}],"jquery-ui/mouse":[function(require,module,exports){
var jQuery = require('jquery');
require('./widget');

/*!
 * jQuery UI Mouse 1.10.4
 * http://jqueryui.com
 *
 * Copyright 2014 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/mouse/
 *
 * Depends:
 *	jquery.ui.widget.js
 */
(function( $, undefined ) {

var mouseHandled = false;
$( document ).mouseup( function() {
	mouseHandled = false;
});

$.widget("ui.mouse", {
	version: "1.10.4",
	options: {
		cancel: "input,textarea,button,select,option",
		distance: 1,
		delay: 0
	},
	_mouseInit: function() {
		var that = this;

		this.element
			.bind("mousedown."+this.widgetName, function(event) {
				return that._mouseDown(event);
			})
			.bind("click."+this.widgetName, function(event) {
				if (true === $.data(event.target, that.widgetName + ".preventClickEvent")) {
					$.removeData(event.target, that.widgetName + ".preventClickEvent");
					event.stopImmediatePropagation();
					return false;
				}
			});

		this.started = false;
	},

	// TODO: make sure destroying one instance of mouse doesn't mess with
	// other instances of mouse
	_mouseDestroy: function() {
		this.element.unbind("."+this.widgetName);
		if ( this._mouseMoveDelegate ) {
			$(document)
				.unbind("mousemove."+this.widgetName, this._mouseMoveDelegate)
				.unbind("mouseup."+this.widgetName, this._mouseUpDelegate);
		}
	},

	_mouseDown: function(event) {
		// don't let more than one widget handle mouseStart
		if( mouseHandled ) { return; }

		// we may have missed mouseup (out of window)
		(this._mouseStarted && this._mouseUp(event));

		this._mouseDownEvent = event;

		var that = this,
			btnIsLeft = (event.which === 1),
			// event.target.nodeName works around a bug in IE 8 with
			// disabled inputs (#7620)
			elIsCancel = (typeof this.options.cancel === "string" && event.target.nodeName ? $(event.target).closest(this.options.cancel).length : false);
		if (!btnIsLeft || elIsCancel || !this._mouseCapture(event)) {
			return true;
		}

		this.mouseDelayMet = !this.options.delay;
		if (!this.mouseDelayMet) {
			this._mouseDelayTimer = setTimeout(function() {
				that.mouseDelayMet = true;
			}, this.options.delay);
		}

		if (this._mouseDistanceMet(event) && this._mouseDelayMet(event)) {
			this._mouseStarted = (this._mouseStart(event) !== false);
			if (!this._mouseStarted) {
				event.preventDefault();
				return true;
			}
		}

		// Click event may never have fired (Gecko & Opera)
		if (true === $.data(event.target, this.widgetName + ".preventClickEvent")) {
			$.removeData(event.target, this.widgetName + ".preventClickEvent");
		}

		// these delegates are required to keep context
		this._mouseMoveDelegate = function(event) {
			return that._mouseMove(event);
		};
		this._mouseUpDelegate = function(event) {
			return that._mouseUp(event);
		};
		$(document)
			.bind("mousemove."+this.widgetName, this._mouseMoveDelegate)
			.bind("mouseup."+this.widgetName, this._mouseUpDelegate);

		event.preventDefault();

		mouseHandled = true;
		return true;
	},

	_mouseMove: function(event) {
		// IE mouseup check - mouseup happened when mouse was out of window
		if ($.ui.ie && ( !document.documentMode || document.documentMode < 9 ) && !event.button) {
			return this._mouseUp(event);
		}

		if (this._mouseStarted) {
			this._mouseDrag(event);
			return event.preventDefault();
		}

		if (this._mouseDistanceMet(event) && this._mouseDelayMet(event)) {
			this._mouseStarted =
				(this._mouseStart(this._mouseDownEvent, event) !== false);
			(this._mouseStarted ? this._mouseDrag(event) : this._mouseUp(event));
		}

		return !this._mouseStarted;
	},

	_mouseUp: function(event) {
		$(document)
			.unbind("mousemove."+this.widgetName, this._mouseMoveDelegate)
			.unbind("mouseup."+this.widgetName, this._mouseUpDelegate);

		if (this._mouseStarted) {
			this._mouseStarted = false;

			if (event.target === this._mouseDownEvent.target) {
				$.data(event.target, this.widgetName + ".preventClickEvent", true);
			}

			this._mouseStop(event);
		}

		return false;
	},

	_mouseDistanceMet: function(event) {
		return (Math.max(
				Math.abs(this._mouseDownEvent.pageX - event.pageX),
				Math.abs(this._mouseDownEvent.pageY - event.pageY)
			) >= this.options.distance
		);
	},

	_mouseDelayMet: function(/* event */) {
		return this.mouseDelayMet;
	},

	// These are placeholder methods, to be overriden by extending plugin
	_mouseStart: function(/* event */) {},
	_mouseDrag: function(/* event */) {},
	_mouseStop: function(/* event */) {},
	_mouseCapture: function(/* event */) { return true; }
});

})(jQuery);

},{"./widget":"jquery-ui/widget","jquery":"jquery"}],"jquery-ui/position":[function(require,module,exports){
var jQuery = require('jquery');

/*!
 * jQuery UI Position 1.10.4
 * http://jqueryui.com
 *
 * Copyright 2014 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/position/
 */
(function( $, undefined ) {

$.ui = $.ui || {};

var cachedScrollbarWidth,
	max = Math.max,
	abs = Math.abs,
	round = Math.round,
	rhorizontal = /left|center|right/,
	rvertical = /top|center|bottom/,
	roffset = /[\+\-]\d+(\.[\d]+)?%?/,
	rposition = /^\w+/,
	rpercent = /%$/,
	_position = $.fn.position;

function getOffsets( offsets, width, height ) {
	return [
		parseFloat( offsets[ 0 ] ) * ( rpercent.test( offsets[ 0 ] ) ? width / 100 : 1 ),
		parseFloat( offsets[ 1 ] ) * ( rpercent.test( offsets[ 1 ] ) ? height / 100 : 1 )
	];
}

function parseCss( element, property ) {
	return parseInt( $.css( element, property ), 10 ) || 0;
}

function getDimensions( elem ) {
	var raw = elem[0];
	if ( raw.nodeType === 9 ) {
		return {
			width: elem.width(),
			height: elem.height(),
			offset: { top: 0, left: 0 }
		};
	}
	if ( $.isWindow( raw ) ) {
		return {
			width: elem.width(),
			height: elem.height(),
			offset: { top: elem.scrollTop(), left: elem.scrollLeft() }
		};
	}
	if ( raw.preventDefault ) {
		return {
			width: 0,
			height: 0,
			offset: { top: raw.pageY, left: raw.pageX }
		};
	}
	return {
		width: elem.outerWidth(),
		height: elem.outerHeight(),
		offset: elem.offset()
	};
}

$.position = {
	scrollbarWidth: function() {
		if ( cachedScrollbarWidth !== undefined ) {
			return cachedScrollbarWidth;
		}
		var w1, w2,
			div = $( "<div style='display:block;position:absolute;width:50px;height:50px;overflow:hidden;'><div style='height:100px;width:auto;'></div></div>" ),
			innerDiv = div.children()[0];

		$( "body" ).append( div );
		w1 = innerDiv.offsetWidth;
		div.css( "overflow", "scroll" );

		w2 = innerDiv.offsetWidth;

		if ( w1 === w2 ) {
			w2 = div[0].clientWidth;
		}

		div.remove();

		return (cachedScrollbarWidth = w1 - w2);
	},
	getScrollInfo: function( within ) {
		var overflowX = within.isWindow || within.isDocument ? "" :
				within.element.css( "overflow-x" ),
			overflowY = within.isWindow || within.isDocument ? "" :
				within.element.css( "overflow-y" ),
			hasOverflowX = overflowX === "scroll" ||
				( overflowX === "auto" && within.width < within.element[0].scrollWidth ),
			hasOverflowY = overflowY === "scroll" ||
				( overflowY === "auto" && within.height < within.element[0].scrollHeight );
		return {
			width: hasOverflowY ? $.position.scrollbarWidth() : 0,
			height: hasOverflowX ? $.position.scrollbarWidth() : 0
		};
	},
	getWithinInfo: function( element ) {
		var withinElement = $( element || window ),
			isWindow = $.isWindow( withinElement[0] ),
			isDocument = !!withinElement[ 0 ] && withinElement[ 0 ].nodeType === 9;
		return {
			element: withinElement,
			isWindow: isWindow,
			isDocument: isDocument,
			offset: withinElement.offset() || { left: 0, top: 0 },
			scrollLeft: withinElement.scrollLeft(),
			scrollTop: withinElement.scrollTop(),
			width: isWindow ? withinElement.width() : withinElement.outerWidth(),
			height: isWindow ? withinElement.height() : withinElement.outerHeight()
		};
	}
};

$.fn.position = function( options ) {
	if ( !options || !options.of ) {
		return _position.apply( this, arguments );
	}

	// make a copy, we don't want to modify arguments
	options = $.extend( {}, options );

	var atOffset, targetWidth, targetHeight, targetOffset, basePosition, dimensions,
		target = $( options.of ),
		within = $.position.getWithinInfo( options.within ),
		scrollInfo = $.position.getScrollInfo( within ),
		collision = ( options.collision || "flip" ).split( " " ),
		offsets = {};

	dimensions = getDimensions( target );
	if ( target[0].preventDefault ) {
		// force left top to allow flipping
		options.at = "left top";
	}
	targetWidth = dimensions.width;
	targetHeight = dimensions.height;
	targetOffset = dimensions.offset;
	// clone to reuse original targetOffset later
	basePosition = $.extend( {}, targetOffset );

	// force my and at to have valid horizontal and vertical positions
	// if a value is missing or invalid, it will be converted to center
	$.each( [ "my", "at" ], function() {
		var pos = ( options[ this ] || "" ).split( " " ),
			horizontalOffset,
			verticalOffset;

		if ( pos.length === 1) {
			pos = rhorizontal.test( pos[ 0 ] ) ?
				pos.concat( [ "center" ] ) :
				rvertical.test( pos[ 0 ] ) ?
					[ "center" ].concat( pos ) :
					[ "center", "center" ];
		}
		pos[ 0 ] = rhorizontal.test( pos[ 0 ] ) ? pos[ 0 ] : "center";
		pos[ 1 ] = rvertical.test( pos[ 1 ] ) ? pos[ 1 ] : "center";

		// calculate offsets
		horizontalOffset = roffset.exec( pos[ 0 ] );
		verticalOffset = roffset.exec( pos[ 1 ] );
		offsets[ this ] = [
			horizontalOffset ? horizontalOffset[ 0 ] : 0,
			verticalOffset ? verticalOffset[ 0 ] : 0
		];

		// reduce to just the positions without the offsets
		options[ this ] = [
			rposition.exec( pos[ 0 ] )[ 0 ],
			rposition.exec( pos[ 1 ] )[ 0 ]
		];
	});

	// normalize collision option
	if ( collision.length === 1 ) {
		collision[ 1 ] = collision[ 0 ];
	}

	if ( options.at[ 0 ] === "right" ) {
		basePosition.left += targetWidth;
	} else if ( options.at[ 0 ] === "center" ) {
		basePosition.left += targetWidth / 2;
	}

	if ( options.at[ 1 ] === "bottom" ) {
		basePosition.top += targetHeight;
	} else if ( options.at[ 1 ] === "center" ) {
		basePosition.top += targetHeight / 2;
	}

	atOffset = getOffsets( offsets.at, targetWidth, targetHeight );
	basePosition.left += atOffset[ 0 ];
	basePosition.top += atOffset[ 1 ];

	return this.each(function() {
		var collisionPosition, using,
			elem = $( this ),
			elemWidth = elem.outerWidth(),
			elemHeight = elem.outerHeight(),
			marginLeft = parseCss( this, "marginLeft" ),
			marginTop = parseCss( this, "marginTop" ),
			collisionWidth = elemWidth + marginLeft + parseCss( this, "marginRight" ) + scrollInfo.width,
			collisionHeight = elemHeight + marginTop + parseCss( this, "marginBottom" ) + scrollInfo.height,
			position = $.extend( {}, basePosition ),
			myOffset = getOffsets( offsets.my, elem.outerWidth(), elem.outerHeight() );

		if ( options.my[ 0 ] === "right" ) {
			position.left -= elemWidth;
		} else if ( options.my[ 0 ] === "center" ) {
			position.left -= elemWidth / 2;
		}

		if ( options.my[ 1 ] === "bottom" ) {
			position.top -= elemHeight;
		} else if ( options.my[ 1 ] === "center" ) {
			position.top -= elemHeight / 2;
		}

		position.left += myOffset[ 0 ];
		position.top += myOffset[ 1 ];

		// if the browser doesn't support fractions, then round for consistent results
		if ( !$.support.offsetFractions ) {
			position.left = round( position.left );
			position.top = round( position.top );
		}

		collisionPosition = {
			marginLeft: marginLeft,
			marginTop: marginTop
		};

		$.each( [ "left", "top" ], function( i, dir ) {
			if ( $.ui.position[ collision[ i ] ] ) {
				$.ui.position[ collision[ i ] ][ dir ]( position, {
					targetWidth: targetWidth,
					targetHeight: targetHeight,
					elemWidth: elemWidth,
					elemHeight: elemHeight,
					collisionPosition: collisionPosition,
					collisionWidth: collisionWidth,
					collisionHeight: collisionHeight,
					offset: [ atOffset[ 0 ] + myOffset[ 0 ], atOffset [ 1 ] + myOffset[ 1 ] ],
					my: options.my,
					at: options.at,
					within: within,
					elem : elem
				});
			}
		});

		if ( options.using ) {
			// adds feedback as second argument to using callback, if present
			using = function( props ) {
				var left = targetOffset.left - position.left,
					right = left + targetWidth - elemWidth,
					top = targetOffset.top - position.top,
					bottom = top + targetHeight - elemHeight,
					feedback = {
						target: {
							element: target,
							left: targetOffset.left,
							top: targetOffset.top,
							width: targetWidth,
							height: targetHeight
						},
						element: {
							element: elem,
							left: position.left,
							top: position.top,
							width: elemWidth,
							height: elemHeight
						},
						horizontal: right < 0 ? "left" : left > 0 ? "right" : "center",
						vertical: bottom < 0 ? "top" : top > 0 ? "bottom" : "middle"
					};
				if ( targetWidth < elemWidth && abs( left + right ) < targetWidth ) {
					feedback.horizontal = "center";
				}
				if ( targetHeight < elemHeight && abs( top + bottom ) < targetHeight ) {
					feedback.vertical = "middle";
				}
				if ( max( abs( left ), abs( right ) ) > max( abs( top ), abs( bottom ) ) ) {
					feedback.important = "horizontal";
				} else {
					feedback.important = "vertical";
				}
				options.using.call( this, props, feedback );
			};
		}

		elem.offset( $.extend( position, { using: using } ) );
	});
};

$.ui.position = {
	fit: {
		left: function( position, data ) {
			var within = data.within,
				withinOffset = within.isWindow ? within.scrollLeft : within.offset.left,
				outerWidth = within.width,
				collisionPosLeft = position.left - data.collisionPosition.marginLeft,
				overLeft = withinOffset - collisionPosLeft,
				overRight = collisionPosLeft + data.collisionWidth - outerWidth - withinOffset,
				newOverRight;

			// element is wider than within
			if ( data.collisionWidth > outerWidth ) {
				// element is initially over the left side of within
				if ( overLeft > 0 && overRight <= 0 ) {
					newOverRight = position.left + overLeft + data.collisionWidth - outerWidth - withinOffset;
					position.left += overLeft - newOverRight;
				// element is initially over right side of within
				} else if ( overRight > 0 && overLeft <= 0 ) {
					position.left = withinOffset;
				// element is initially over both left and right sides of within
				} else {
					if ( overLeft > overRight ) {
						position.left = withinOffset + outerWidth - data.collisionWidth;
					} else {
						position.left = withinOffset;
					}
				}
			// too far left -> align with left edge
			} else if ( overLeft > 0 ) {
				position.left += overLeft;
			// too far right -> align with right edge
			} else if ( overRight > 0 ) {
				position.left -= overRight;
			// adjust based on position and margin
			} else {
				position.left = max( position.left - collisionPosLeft, position.left );
			}
		},
		top: function( position, data ) {
			var within = data.within,
				withinOffset = within.isWindow ? within.scrollTop : within.offset.top,
				outerHeight = data.within.height,
				collisionPosTop = position.top - data.collisionPosition.marginTop,
				overTop = withinOffset - collisionPosTop,
				overBottom = collisionPosTop + data.collisionHeight - outerHeight - withinOffset,
				newOverBottom;

			// element is taller than within
			if ( data.collisionHeight > outerHeight ) {
				// element is initially over the top of within
				if ( overTop > 0 && overBottom <= 0 ) {
					newOverBottom = position.top + overTop + data.collisionHeight - outerHeight - withinOffset;
					position.top += overTop - newOverBottom;
				// element is initially over bottom of within
				} else if ( overBottom > 0 && overTop <= 0 ) {
					position.top = withinOffset;
				// element is initially over both top and bottom of within
				} else {
					if ( overTop > overBottom ) {
						position.top = withinOffset + outerHeight - data.collisionHeight;
					} else {
						position.top = withinOffset;
					}
				}
			// too far up -> align with top
			} else if ( overTop > 0 ) {
				position.top += overTop;
			// too far down -> align with bottom edge
			} else if ( overBottom > 0 ) {
				position.top -= overBottom;
			// adjust based on position and margin
			} else {
				position.top = max( position.top - collisionPosTop, position.top );
			}
		}
	},
	flip: {
		left: function( position, data ) {
			var within = data.within,
				withinOffset = within.offset.left + within.scrollLeft,
				outerWidth = within.width,
				offsetLeft = within.isWindow ? within.scrollLeft : within.offset.left,
				collisionPosLeft = position.left - data.collisionPosition.marginLeft,
				overLeft = collisionPosLeft - offsetLeft,
				overRight = collisionPosLeft + data.collisionWidth - outerWidth - offsetLeft,
				myOffset = data.my[ 0 ] === "left" ?
					-data.elemWidth :
					data.my[ 0 ] === "right" ?
						data.elemWidth :
						0,
				atOffset = data.at[ 0 ] === "left" ?
					data.targetWidth :
					data.at[ 0 ] === "right" ?
						-data.targetWidth :
						0,
				offset = -2 * data.offset[ 0 ],
				newOverRight,
				newOverLeft;

			if ( overLeft < 0 ) {
				newOverRight = position.left + myOffset + atOffset + offset + data.collisionWidth - outerWidth - withinOffset;
				if ( newOverRight < 0 || newOverRight < abs( overLeft ) ) {
					position.left += myOffset + atOffset + offset;
				}
			}
			else if ( overRight > 0 ) {
				newOverLeft = position.left - data.collisionPosition.marginLeft + myOffset + atOffset + offset - offsetLeft;
				if ( newOverLeft > 0 || abs( newOverLeft ) < overRight ) {
					position.left += myOffset + atOffset + offset;
				}
			}
		},
		top: function( position, data ) {
			var within = data.within,
				withinOffset = within.offset.top + within.scrollTop,
				outerHeight = within.height,
				offsetTop = within.isWindow ? within.scrollTop : within.offset.top,
				collisionPosTop = position.top - data.collisionPosition.marginTop,
				overTop = collisionPosTop - offsetTop,
				overBottom = collisionPosTop + data.collisionHeight - outerHeight - offsetTop,
				top = data.my[ 1 ] === "top",
				myOffset = top ?
					-data.elemHeight :
					data.my[ 1 ] === "bottom" ?
						data.elemHeight :
						0,
				atOffset = data.at[ 1 ] === "top" ?
					data.targetHeight :
					data.at[ 1 ] === "bottom" ?
						-data.targetHeight :
						0,
				offset = -2 * data.offset[ 1 ],
				newOverTop,
				newOverBottom;
			if ( overTop < 0 ) {
				newOverBottom = position.top + myOffset + atOffset + offset + data.collisionHeight - outerHeight - withinOffset;
				if ( ( position.top + myOffset + atOffset + offset) > overTop && ( newOverBottom < 0 || newOverBottom < abs( overTop ) ) ) {
					position.top += myOffset + atOffset + offset;
				}
			}
			else if ( overBottom > 0 ) {
				newOverTop = position.top - data.collisionPosition.marginTop + myOffset + atOffset + offset - offsetTop;
				if ( ( position.top + myOffset + atOffset + offset) > overBottom && ( newOverTop > 0 || abs( newOverTop ) < overBottom ) ) {
					position.top += myOffset + atOffset + offset;
				}
			}
		}
	},
	flipfit: {
		left: function() {
			$.ui.position.flip.left.apply( this, arguments );
			$.ui.position.fit.left.apply( this, arguments );
		},
		top: function() {
			$.ui.position.flip.top.apply( this, arguments );
			$.ui.position.fit.top.apply( this, arguments );
		}
	}
};

// fraction support test
(function () {
	var testElement, testElementParent, testElementStyle, offsetLeft, i,
		body = document.getElementsByTagName( "body" )[ 0 ],
		div = document.createElement( "div" );

	//Create a "fake body" for testing based on method used in jQuery.support
	testElement = document.createElement( body ? "div" : "body" );
	testElementStyle = {
		visibility: "hidden",
		width: 0,
		height: 0,
		border: 0,
		margin: 0,
		background: "none"
	};
	if ( body ) {
		$.extend( testElementStyle, {
			position: "absolute",
			left: "-1000px",
			top: "-1000px"
		});
	}
	for ( i in testElementStyle ) {
		testElement.style[ i ] = testElementStyle[ i ];
	}
	testElement.appendChild( div );
	testElementParent = body || document.documentElement;
	testElementParent.insertBefore( testElement, testElementParent.firstChild );

	div.style.cssText = "position: absolute; left: 10.7432222px;";

	offsetLeft = $( div ).offset().left;
	$.support.offsetFractions = offsetLeft > 10 && offsetLeft < 11;

	testElement.innerHTML = "";
	testElementParent.removeChild( testElement );
})();

}( jQuery ) );

},{"jquery":"jquery"}],"jquery-ui/slider":[function(require,module,exports){
var jQuery = require('jquery');
require('./core');
require('./mouse');
require('./widget');

/*!
 * jQuery UI Slider 1.10.4
 * http://jqueryui.com
 *
 * Copyright 2014 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/slider/
 *
 * Depends:
 *	jquery.ui.core.js
 *	jquery.ui.mouse.js
 *	jquery.ui.widget.js
 */
(function( $, undefined ) {

// number of pages in a slider
// (how many times can you page up/down to go through the whole range)
var numPages = 5;

$.widget( "ui.slider", $.ui.mouse, {
	version: "1.10.4",
	widgetEventPrefix: "slide",

	options: {
		animate: false,
		distance: 0,
		max: 100,
		min: 0,
		orientation: "horizontal",
		range: false,
		step: 1,
		value: 0,
		values: null,

		// callbacks
		change: null,
		slide: null,
		start: null,
		stop: null
	},

	_create: function() {
		this._keySliding = false;
		this._mouseSliding = false;
		this._animateOff = true;
		this._handleIndex = null;
		this._detectOrientation();
		this._mouseInit();

		this.element
			.addClass( "ui-slider" +
				" ui-slider-" + this.orientation +
				" ui-widget" +
				" ui-widget-content" +
				" ui-corner-all");

		this._refresh();
		this._setOption( "disabled", this.options.disabled );

		this._animateOff = false;
	},

	_refresh: function() {
		this._createRange();
		this._createHandles();
		this._setupEvents();
		this._refreshValue();
	},

	_createHandles: function() {
		var i, handleCount,
			options = this.options,
			existingHandles = this.element.find( ".ui-slider-handle" ).addClass( "ui-state-default ui-corner-all" ),
			handle = "<a class='ui-slider-handle ui-state-default ui-corner-all' href='#'></a>",
			handles = [];

		handleCount = ( options.values && options.values.length ) || 1;

		if ( existingHandles.length > handleCount ) {
			existingHandles.slice( handleCount ).remove();
			existingHandles = existingHandles.slice( 0, handleCount );
		}

		for ( i = existingHandles.length; i < handleCount; i++ ) {
			handles.push( handle );
		}

		this.handles = existingHandles.add( $( handles.join( "" ) ).appendTo( this.element ) );

		this.handle = this.handles.eq( 0 );

		this.handles.each(function( i ) {
			$( this ).data( "ui-slider-handle-index", i );
		});
	},

	_createRange: function() {
		var options = this.options,
			classes = "";

		if ( options.range ) {
			if ( options.range === true ) {
				if ( !options.values ) {
					options.values = [ this._valueMin(), this._valueMin() ];
				} else if ( options.values.length && options.values.length !== 2 ) {
					options.values = [ options.values[0], options.values[0] ];
				} else if ( $.isArray( options.values ) ) {
					options.values = options.values.slice(0);
				}
			}

			if ( !this.range || !this.range.length ) {
				this.range = $( "<div></div>" )
					.appendTo( this.element );

				classes = "ui-slider-range" +
				// note: this isn't the most fittingly semantic framework class for this element,
				// but worked best visually with a variety of themes
				" ui-widget-header ui-corner-all";
			} else {
				this.range.removeClass( "ui-slider-range-min ui-slider-range-max" )
					// Handle range switching from true to min/max
					.css({
						"left": "",
						"bottom": ""
					});
			}

			this.range.addClass( classes +
				( ( options.range === "min" || options.range === "max" ) ? " ui-slider-range-" + options.range : "" ) );
		} else {
			if ( this.range ) {
				this.range.remove();
			}
			this.range = null;
		}
	},

	_setupEvents: function() {
		var elements = this.handles.add( this.range ).filter( "a" );
		this._off( elements );
		this._on( elements, this._handleEvents );
		this._hoverable( elements );
		this._focusable( elements );
	},

	_destroy: function() {
		this.handles.remove();
		if ( this.range ) {
			this.range.remove();
		}

		this.element
			.removeClass( "ui-slider" +
				" ui-slider-horizontal" +
				" ui-slider-vertical" +
				" ui-widget" +
				" ui-widget-content" +
				" ui-corner-all" );

		this._mouseDestroy();
	},

	_mouseCapture: function( event ) {
		var position, normValue, distance, closestHandle, index, allowed, offset, mouseOverHandle,
			that = this,
			o = this.options;

		if ( o.disabled ) {
			return false;
		}

		this.elementSize = {
			width: this.element.outerWidth(),
			height: this.element.outerHeight()
		};
		this.elementOffset = this.element.offset();

		position = { x: event.pageX, y: event.pageY };
		normValue = this._normValueFromMouse( position );
		distance = this._valueMax() - this._valueMin() + 1;
		this.handles.each(function( i ) {
			var thisDistance = Math.abs( normValue - that.values(i) );
			if (( distance > thisDistance ) ||
				( distance === thisDistance &&
					(i === that._lastChangedValue || that.values(i) === o.min ))) {
				distance = thisDistance;
				closestHandle = $( this );
				index = i;
			}
		});

		allowed = this._start( event, index );
		if ( allowed === false ) {
			return false;
		}
		this._mouseSliding = true;

		this._handleIndex = index;

		closestHandle
			.addClass( "ui-state-active" )
			.focus();

		offset = closestHandle.offset();
		mouseOverHandle = !$( event.target ).parents().addBack().is( ".ui-slider-handle" );
		this._clickOffset = mouseOverHandle ? { left: 0, top: 0 } : {
			left: event.pageX - offset.left - ( closestHandle.width() / 2 ),
			top: event.pageY - offset.top -
				( closestHandle.height() / 2 ) -
				( parseInt( closestHandle.css("borderTopWidth"), 10 ) || 0 ) -
				( parseInt( closestHandle.css("borderBottomWidth"), 10 ) || 0) +
				( parseInt( closestHandle.css("marginTop"), 10 ) || 0)
		};

		if ( !this.handles.hasClass( "ui-state-hover" ) ) {
			this._slide( event, index, normValue );
		}
		this._animateOff = true;
		return true;
	},

	_mouseStart: function() {
		return true;
	},

	_mouseDrag: function( event ) {
		var position = { x: event.pageX, y: event.pageY },
			normValue = this._normValueFromMouse( position );

		this._slide( event, this._handleIndex, normValue );

		return false;
	},

	_mouseStop: function( event ) {
		this.handles.removeClass( "ui-state-active" );
		this._mouseSliding = false;

		this._stop( event, this._handleIndex );
		this._change( event, this._handleIndex );

		this._handleIndex = null;
		this._clickOffset = null;
		this._animateOff = false;

		return false;
	},

	_detectOrientation: function() {
		this.orientation = ( this.options.orientation === "vertical" ) ? "vertical" : "horizontal";
	},

	_normValueFromMouse: function( position ) {
		var pixelTotal,
			pixelMouse,
			percentMouse,
			valueTotal,
			valueMouse;

		if ( this.orientation === "horizontal" ) {
			pixelTotal = this.elementSize.width;
			pixelMouse = position.x - this.elementOffset.left - ( this._clickOffset ? this._clickOffset.left : 0 );
		} else {
			pixelTotal = this.elementSize.height;
			pixelMouse = position.y - this.elementOffset.top - ( this._clickOffset ? this._clickOffset.top : 0 );
		}

		percentMouse = ( pixelMouse / pixelTotal );
		if ( percentMouse > 1 ) {
			percentMouse = 1;
		}
		if ( percentMouse < 0 ) {
			percentMouse = 0;
		}
		if ( this.orientation === "vertical" ) {
			percentMouse = 1 - percentMouse;
		}

		valueTotal = this._valueMax() - this._valueMin();
		valueMouse = this._valueMin() + percentMouse * valueTotal;

		return this._trimAlignValue( valueMouse );
	},

	_start: function( event, index ) {
		var uiHash = {
			handle: this.handles[ index ],
			value: this.value()
		};
		if ( this.options.values && this.options.values.length ) {
			uiHash.value = this.values( index );
			uiHash.values = this.values();
		}
		return this._trigger( "start", event, uiHash );
	},

	_slide: function( event, index, newVal ) {
		var otherVal,
			newValues,
			allowed;

		if ( this.options.values && this.options.values.length ) {
			otherVal = this.values( index ? 0 : 1 );

			if ( ( this.options.values.length === 2 && this.options.range === true ) &&
					( ( index === 0 && newVal > otherVal) || ( index === 1 && newVal < otherVal ) )
				) {
				newVal = otherVal;
			}

			if ( newVal !== this.values( index ) ) {
				newValues = this.values();
				newValues[ index ] = newVal;
				// A slide can be canceled by returning false from the slide callback
				allowed = this._trigger( "slide", event, {
					handle: this.handles[ index ],
					value: newVal,
					values: newValues
				} );
				otherVal = this.values( index ? 0 : 1 );
				if ( allowed !== false ) {
					this.values( index, newVal );
				}
			}
		} else {
			if ( newVal !== this.value() ) {
				// A slide can be canceled by returning false from the slide callback
				allowed = this._trigger( "slide", event, {
					handle: this.handles[ index ],
					value: newVal
				} );
				if ( allowed !== false ) {
					this.value( newVal );
				}
			}
		}
	},

	_stop: function( event, index ) {
		var uiHash = {
			handle: this.handles[ index ],
			value: this.value()
		};
		if ( this.options.values && this.options.values.length ) {
			uiHash.value = this.values( index );
			uiHash.values = this.values();
		}

		this._trigger( "stop", event, uiHash );
	},

	_change: function( event, index ) {
		if ( !this._keySliding && !this._mouseSliding ) {
			var uiHash = {
				handle: this.handles[ index ],
				value: this.value()
			};
			if ( this.options.values && this.options.values.length ) {
				uiHash.value = this.values( index );
				uiHash.values = this.values();
			}

			//store the last changed value index for reference when handles overlap
			this._lastChangedValue = index;

			this._trigger( "change", event, uiHash );
		}
	},

	value: function( newValue ) {
		if ( arguments.length ) {
			this.options.value = this._trimAlignValue( newValue );
			this._refreshValue();
			this._change( null, 0 );
			return;
		}

		return this._value();
	},

	values: function( index, newValue ) {
		var vals,
			newValues,
			i;

		if ( arguments.length > 1 ) {
			this.options.values[ index ] = this._trimAlignValue( newValue );
			this._refreshValue();
			this._change( null, index );
			return;
		}

		if ( arguments.length ) {
			if ( $.isArray( arguments[ 0 ] ) ) {
				vals = this.options.values;
				newValues = arguments[ 0 ];
				for ( i = 0; i < vals.length; i += 1 ) {
					vals[ i ] = this._trimAlignValue( newValues[ i ] );
					this._change( null, i );
				}
				this._refreshValue();
			} else {
				if ( this.options.values && this.options.values.length ) {
					return this._values( index );
				} else {
					return this.value();
				}
			}
		} else {
			return this._values();
		}
	},

	_setOption: function( key, value ) {
		var i,
			valsLength = 0;

		if ( key === "range" && this.options.range === true ) {
			if ( value === "min" ) {
				this.options.value = this._values( 0 );
				this.options.values = null;
			} else if ( value === "max" ) {
				this.options.value = this._values( this.options.values.length-1 );
				this.options.values = null;
			}
		}

		if ( $.isArray( this.options.values ) ) {
			valsLength = this.options.values.length;
		}

		$.Widget.prototype._setOption.apply( this, arguments );

		switch ( key ) {
			case "orientation":
				this._detectOrientation();
				this.element
					.removeClass( "ui-slider-horizontal ui-slider-vertical" )
					.addClass( "ui-slider-" + this.orientation );
				this._refreshValue();
				break;
			case "value":
				this._animateOff = true;
				this._refreshValue();
				this._change( null, 0 );
				this._animateOff = false;
				break;
			case "values":
				this._animateOff = true;
				this._refreshValue();
				for ( i = 0; i < valsLength; i += 1 ) {
					this._change( null, i );
				}
				this._animateOff = false;
				break;
			case "min":
			case "max":
				this._animateOff = true;
				this._refreshValue();
				this._animateOff = false;
				break;
			case "range":
				this._animateOff = true;
				this._refresh();
				this._animateOff = false;
				break;
		}
	},

	//internal value getter
	// _value() returns value trimmed by min and max, aligned by step
	_value: function() {
		var val = this.options.value;
		val = this._trimAlignValue( val );

		return val;
	},

	//internal values getter
	// _values() returns array of values trimmed by min and max, aligned by step
	// _values( index ) returns single value trimmed by min and max, aligned by step
	_values: function( index ) {
		var val,
			vals,
			i;

		if ( arguments.length ) {
			val = this.options.values[ index ];
			val = this._trimAlignValue( val );

			return val;
		} else if ( this.options.values && this.options.values.length ) {
			// .slice() creates a copy of the array
			// this copy gets trimmed by min and max and then returned
			vals = this.options.values.slice();
			for ( i = 0; i < vals.length; i+= 1) {
				vals[ i ] = this._trimAlignValue( vals[ i ] );
			}

			return vals;
		} else {
			return [];
		}
	},

	// returns the step-aligned value that val is closest to, between (inclusive) min and max
	_trimAlignValue: function( val ) {
		if ( val <= this._valueMin() ) {
			return this._valueMin();
		}
		if ( val >= this._valueMax() ) {
			return this._valueMax();
		}
		var step = ( this.options.step > 0 ) ? this.options.step : 1,
			valModStep = (val - this._valueMin()) % step,
			alignValue = val - valModStep;

		if ( Math.abs(valModStep) * 2 >= step ) {
			alignValue += ( valModStep > 0 ) ? step : ( -step );
		}

		// Since JavaScript has problems with large floats, round
		// the final value to 5 digits after the decimal point (see #4124)
		return parseFloat( alignValue.toFixed(5) );
	},

	_valueMin: function() {
		return this.options.min;
	},

	_valueMax: function() {
		return this.options.max;
	},

	_refreshValue: function() {
		var lastValPercent, valPercent, value, valueMin, valueMax,
			oRange = this.options.range,
			o = this.options,
			that = this,
			animate = ( !this._animateOff ) ? o.animate : false,
			_set = {};

		if ( this.options.values && this.options.values.length ) {
			this.handles.each(function( i ) {
				valPercent = ( that.values(i) - that._valueMin() ) / ( that._valueMax() - that._valueMin() ) * 100;
				_set[ that.orientation === "horizontal" ? "left" : "bottom" ] = valPercent + "%";
				$( this ).stop( 1, 1 )[ animate ? "animate" : "css" ]( _set, o.animate );
				if ( that.options.range === true ) {
					if ( that.orientation === "horizontal" ) {
						if ( i === 0 ) {
							that.range.stop( 1, 1 )[ animate ? "animate" : "css" ]( { left: valPercent + "%" }, o.animate );
						}
						if ( i === 1 ) {
							that.range[ animate ? "animate" : "css" ]( { width: ( valPercent - lastValPercent ) + "%" }, { queue: false, duration: o.animate } );
						}
					} else {
						if ( i === 0 ) {
							that.range.stop( 1, 1 )[ animate ? "animate" : "css" ]( { bottom: ( valPercent ) + "%" }, o.animate );
						}
						if ( i === 1 ) {
							that.range[ animate ? "animate" : "css" ]( { height: ( valPercent - lastValPercent ) + "%" }, { queue: false, duration: o.animate } );
						}
					}
				}
				lastValPercent = valPercent;
			});
		} else {
			value = this.value();
			valueMin = this._valueMin();
			valueMax = this._valueMax();
			valPercent = ( valueMax !== valueMin ) ?
					( value - valueMin ) / ( valueMax - valueMin ) * 100 :
					0;
			_set[ this.orientation === "horizontal" ? "left" : "bottom" ] = valPercent + "%";
			this.handle.stop( 1, 1 )[ animate ? "animate" : "css" ]( _set, o.animate );

			if ( oRange === "min" && this.orientation === "horizontal" ) {
				this.range.stop( 1, 1 )[ animate ? "animate" : "css" ]( { width: valPercent + "%" }, o.animate );
			}
			if ( oRange === "max" && this.orientation === "horizontal" ) {
				this.range[ animate ? "animate" : "css" ]( { width: ( 100 - valPercent ) + "%" }, { queue: false, duration: o.animate } );
			}
			if ( oRange === "min" && this.orientation === "vertical" ) {
				this.range.stop( 1, 1 )[ animate ? "animate" : "css" ]( { height: valPercent + "%" }, o.animate );
			}
			if ( oRange === "max" && this.orientation === "vertical" ) {
				this.range[ animate ? "animate" : "css" ]( { height: ( 100 - valPercent ) + "%" }, { queue: false, duration: o.animate } );
			}
		}
	},

	_handleEvents: {
		keydown: function( event ) {
			var allowed, curVal, newVal, step,
				index = $( event.target ).data( "ui-slider-handle-index" );

			switch ( event.keyCode ) {
				case $.ui.keyCode.HOME:
				case $.ui.keyCode.END:
				case $.ui.keyCode.PAGE_UP:
				case $.ui.keyCode.PAGE_DOWN:
				case $.ui.keyCode.UP:
				case $.ui.keyCode.RIGHT:
				case $.ui.keyCode.DOWN:
				case $.ui.keyCode.LEFT:
					event.preventDefault();
					if ( !this._keySliding ) {
						this._keySliding = true;
						$( event.target ).addClass( "ui-state-active" );
						allowed = this._start( event, index );
						if ( allowed === false ) {
							return;
						}
					}
					break;
			}

			step = this.options.step;
			if ( this.options.values && this.options.values.length ) {
				curVal = newVal = this.values( index );
			} else {
				curVal = newVal = this.value();
			}

			switch ( event.keyCode ) {
				case $.ui.keyCode.HOME:
					newVal = this._valueMin();
					break;
				case $.ui.keyCode.END:
					newVal = this._valueMax();
					break;
				case $.ui.keyCode.PAGE_UP:
					newVal = this._trimAlignValue( curVal + ( (this._valueMax() - this._valueMin()) / numPages ) );
					break;
				case $.ui.keyCode.PAGE_DOWN:
					newVal = this._trimAlignValue( curVal - ( (this._valueMax() - this._valueMin()) / numPages ) );
					break;
				case $.ui.keyCode.UP:
				case $.ui.keyCode.RIGHT:
					if ( curVal === this._valueMax() ) {
						return;
					}
					newVal = this._trimAlignValue( curVal + step );
					break;
				case $.ui.keyCode.DOWN:
				case $.ui.keyCode.LEFT:
					if ( curVal === this._valueMin() ) {
						return;
					}
					newVal = this._trimAlignValue( curVal - step );
					break;
			}

			this._slide( event, index, newVal );
		},
		click: function( event ) {
			event.preventDefault();
		},
		keyup: function( event ) {
			var index = $( event.target ).data( "ui-slider-handle-index" );

			if ( this._keySliding ) {
				this._keySliding = false;
				this._stop( event, index );
				this._change( event, index );
				$( event.target ).removeClass( "ui-state-active" );
			}
		}
	}

});

}(jQuery));

},{"./core":"jquery-ui/core","./mouse":"jquery-ui/mouse","./widget":"jquery-ui/widget","jquery":"jquery"}],"jquery-ui/sortable":[function(require,module,exports){
var jQuery = require('jquery');
require('./core');
require('./mouse');
require('./widget');

/*!
 * jQuery UI Sortable 1.10.4
 * http://jqueryui.com
 *
 * Copyright 2014 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/sortable/
 *
 * Depends:
 *	jquery.ui.core.js
 *	jquery.ui.mouse.js
 *	jquery.ui.widget.js
 */
(function( $, undefined ) {

function isOverAxis( x, reference, size ) {
	return ( x > reference ) && ( x < ( reference + size ) );
}

function isFloating(item) {
	return (/left|right/).test(item.css("float")) || (/inline|table-cell/).test(item.css("display"));
}

$.widget("ui.sortable", $.ui.mouse, {
	version: "1.10.4",
	widgetEventPrefix: "sort",
	ready: false,
	options: {
		appendTo: "parent",
		axis: false,
		connectWith: false,
		containment: false,
		cursor: "auto",
		cursorAt: false,
		dropOnEmpty: true,
		forcePlaceholderSize: false,
		forceHelperSize: false,
		grid: false,
		handle: false,
		helper: "original",
		items: "> *",
		opacity: false,
		placeholder: false,
		revert: false,
		scroll: true,
		scrollSensitivity: 20,
		scrollSpeed: 20,
		scope: "default",
		tolerance: "intersect",
		zIndex: 1000,

		// callbacks
		activate: null,
		beforeStop: null,
		change: null,
		deactivate: null,
		out: null,
		over: null,
		receive: null,
		remove: null,
		sort: null,
		start: null,
		stop: null,
		update: null
	},
	_create: function() {

		var o = this.options;
		this.containerCache = {};
		this.element.addClass("ui-sortable");

		//Get the items
		this.refresh();

		//Let's determine if the items are being displayed horizontally
		this.floating = this.items.length ? o.axis === "x" || isFloating(this.items[0].item) : false;

		//Let's determine the parent's offset
		this.offset = this.element.offset();

		//Initialize mouse events for interaction
		this._mouseInit();

		//We're ready to go
		this.ready = true;

	},

	_destroy: function() {
		this.element
			.removeClass("ui-sortable ui-sortable-disabled");
		this._mouseDestroy();

		for ( var i = this.items.length - 1; i >= 0; i-- ) {
			this.items[i].item.removeData(this.widgetName + "-item");
		}

		return this;
	},

	_setOption: function(key, value){
		if ( key === "disabled" ) {
			this.options[ key ] = value;

			this.widget().toggleClass( "ui-sortable-disabled", !!value );
		} else {
			// Don't call widget base _setOption for disable as it adds ui-state-disabled class
			$.Widget.prototype._setOption.apply(this, arguments);
		}
	},

	_mouseCapture: function(event, overrideHandle) {
		var currentItem = null,
			validHandle = false,
			that = this;

		if (this.reverting) {
			return false;
		}

		if(this.options.disabled || this.options.type === "static") {
			return false;
		}

		//We have to refresh the items data once first
		this._refreshItems(event);

		//Find out if the clicked node (or one of its parents) is a actual item in this.items
		$(event.target).parents().each(function() {
			if($.data(this, that.widgetName + "-item") === that) {
				currentItem = $(this);
				return false;
			}
		});
		if($.data(event.target, that.widgetName + "-item") === that) {
			currentItem = $(event.target);
		}

		if(!currentItem) {
			return false;
		}
		if(this.options.handle && !overrideHandle) {
			$(this.options.handle, currentItem).find("*").addBack().each(function() {
				if(this === event.target) {
					validHandle = true;
				}
			});
			if(!validHandle) {
				return false;
			}
		}

		this.currentItem = currentItem;
		this._removeCurrentsFromItems();
		return true;

	},

	_mouseStart: function(event, overrideHandle, noActivation) {

		var i, body,
			o = this.options;

		this.currentContainer = this;

		//We only need to call refreshPositions, because the refreshItems call has been moved to mouseCapture
		this.refreshPositions();

		//Create and append the visible helper
		this.helper = this._createHelper(event);

		//Cache the helper size
		this._cacheHelperProportions();

		/*
		 * - Position generation -
		 * This block generates everything position related - it's the core of draggables.
		 */

		//Cache the margins of the original element
		this._cacheMargins();

		//Get the next scrolling parent
		this.scrollParent = this.helper.scrollParent();

		//The element's absolute position on the page minus margins
		this.offset = this.currentItem.offset();
		this.offset = {
			top: this.offset.top - this.margins.top,
			left: this.offset.left - this.margins.left
		};

		$.extend(this.offset, {
			click: { //Where the click happened, relative to the element
				left: event.pageX - this.offset.left,
				top: event.pageY - this.offset.top
			},
			parent: this._getParentOffset(),
			relative: this._getRelativeOffset() //This is a relative to absolute position minus the actual position calculation - only used for relative positioned helper
		});

		// Only after we got the offset, we can change the helper's position to absolute
		// TODO: Still need to figure out a way to make relative sorting possible
		this.helper.css("position", "absolute");
		this.cssPosition = this.helper.css("position");

		//Generate the original position
		this.originalPosition = this._generatePosition(event);
		this.originalPageX = event.pageX;
		this.originalPageY = event.pageY;

		//Adjust the mouse offset relative to the helper if "cursorAt" is supplied
		(o.cursorAt && this._adjustOffsetFromHelper(o.cursorAt));

		//Cache the former DOM position
		this.domPosition = { prev: this.currentItem.prev()[0], parent: this.currentItem.parent()[0] };

		//If the helper is not the original, hide the original so it's not playing any role during the drag, won't cause anything bad this way
		if(this.helper[0] !== this.currentItem[0]) {
			this.currentItem.hide();
		}

		//Create the placeholder
		this._createPlaceholder();

		//Set a containment if given in the options
		if(o.containment) {
			this._setContainment();
		}

		if( o.cursor && o.cursor !== "auto" ) { // cursor option
			body = this.document.find( "body" );

			// support: IE
			this.storedCursor = body.css( "cursor" );
			body.css( "cursor", o.cursor );

			this.storedStylesheet = $( "<style>*{ cursor: "+o.cursor+" !important; }</style>" ).appendTo( body );
		}

		if(o.opacity) { // opacity option
			if (this.helper.css("opacity")) {
				this._storedOpacity = this.helper.css("opacity");
			}
			this.helper.css("opacity", o.opacity);
		}

		if(o.zIndex) { // zIndex option
			if (this.helper.css("zIndex")) {
				this._storedZIndex = this.helper.css("zIndex");
			}
			this.helper.css("zIndex", o.zIndex);
		}

		//Prepare scrolling
		if(this.scrollParent[0] !== document && this.scrollParent[0].tagName !== "HTML") {
			this.overflowOffset = this.scrollParent.offset();
		}

		//Call callbacks
		this._trigger("start", event, this._uiHash());

		//Recache the helper size
		if(!this._preserveHelperProportions) {
			this._cacheHelperProportions();
		}


		//Post "activate" events to possible containers
		if( !noActivation ) {
			for ( i = this.containers.length - 1; i >= 0; i-- ) {
				this.containers[ i ]._trigger( "activate", event, this._uiHash( this ) );
			}
		}

		//Prepare possible droppables
		if($.ui.ddmanager) {
			$.ui.ddmanager.current = this;
		}

		if ($.ui.ddmanager && !o.dropBehaviour) {
			$.ui.ddmanager.prepareOffsets(this, event);
		}

		this.dragging = true;

		this.helper.addClass("ui-sortable-helper");
		this._mouseDrag(event); //Execute the drag once - this causes the helper not to be visible before getting its correct position
		return true;

	},

	_mouseDrag: function(event) {
		var i, item, itemElement, intersection,
			o = this.options,
			scrolled = false;

		//Compute the helpers position
		this.position = this._generatePosition(event);
		this.positionAbs = this._convertPositionTo("absolute");

		if (!this.lastPositionAbs) {
			this.lastPositionAbs = this.positionAbs;
		}

		//Do scrolling
		if(this.options.scroll) {
			if(this.scrollParent[0] !== document && this.scrollParent[0].tagName !== "HTML") {

				if((this.overflowOffset.top + this.scrollParent[0].offsetHeight) - event.pageY < o.scrollSensitivity) {
					this.scrollParent[0].scrollTop = scrolled = this.scrollParent[0].scrollTop + o.scrollSpeed;
				} else if(event.pageY - this.overflowOffset.top < o.scrollSensitivity) {
					this.scrollParent[0].scrollTop = scrolled = this.scrollParent[0].scrollTop - o.scrollSpeed;
				}

				if((this.overflowOffset.left + this.scrollParent[0].offsetWidth) - event.pageX < o.scrollSensitivity) {
					this.scrollParent[0].scrollLeft = scrolled = this.scrollParent[0].scrollLeft + o.scrollSpeed;
				} else if(event.pageX - this.overflowOffset.left < o.scrollSensitivity) {
					this.scrollParent[0].scrollLeft = scrolled = this.scrollParent[0].scrollLeft - o.scrollSpeed;
				}

			} else {

				if(event.pageY - $(document).scrollTop() < o.scrollSensitivity) {
					scrolled = $(document).scrollTop($(document).scrollTop() - o.scrollSpeed);
				} else if($(window).height() - (event.pageY - $(document).scrollTop()) < o.scrollSensitivity) {
					scrolled = $(document).scrollTop($(document).scrollTop() + o.scrollSpeed);
				}

				if(event.pageX - $(document).scrollLeft() < o.scrollSensitivity) {
					scrolled = $(document).scrollLeft($(document).scrollLeft() - o.scrollSpeed);
				} else if($(window).width() - (event.pageX - $(document).scrollLeft()) < o.scrollSensitivity) {
					scrolled = $(document).scrollLeft($(document).scrollLeft() + o.scrollSpeed);
				}

			}

			if(scrolled !== false && $.ui.ddmanager && !o.dropBehaviour) {
				$.ui.ddmanager.prepareOffsets(this, event);
			}
		}

		//Regenerate the absolute position used for position checks
		this.positionAbs = this._convertPositionTo("absolute");

		//Set the helper position
		if(!this.options.axis || this.options.axis !== "y") {
			this.helper[0].style.left = this.position.left+"px";
		}
		if(!this.options.axis || this.options.axis !== "x") {
			this.helper[0].style.top = this.position.top+"px";
		}

		//Rearrange
		for (i = this.items.length - 1; i >= 0; i--) {

			//Cache variables and intersection, continue if no intersection
			item = this.items[i];
			itemElement = item.item[0];
			intersection = this._intersectsWithPointer(item);
			if (!intersection) {
				continue;
			}

			// Only put the placeholder inside the current Container, skip all
			// items from other containers. This works because when moving
			// an item from one container to another the
			// currentContainer is switched before the placeholder is moved.
			//
			// Without this, moving items in "sub-sortables" can cause
			// the placeholder to jitter beetween the outer and inner container.
			if (item.instance !== this.currentContainer) {
				continue;
			}

			// cannot intersect with itself
			// no useless actions that have been done before
			// no action if the item moved is the parent of the item checked
			if (itemElement !== this.currentItem[0] &&
				this.placeholder[intersection === 1 ? "next" : "prev"]()[0] !== itemElement &&
				!$.contains(this.placeholder[0], itemElement) &&
				(this.options.type === "semi-dynamic" ? !$.contains(this.element[0], itemElement) : true)
			) {

				this.direction = intersection === 1 ? "down" : "up";

				if (this.options.tolerance === "pointer" || this._intersectsWithSides(item)) {
					this._rearrange(event, item);
				} else {
					break;
				}

				this._trigger("change", event, this._uiHash());
				break;
			}
		}

		//Post events to containers
		this._contactContainers(event);

		//Interconnect with droppables
		if($.ui.ddmanager) {
			$.ui.ddmanager.drag(this, event);
		}

		//Call callbacks
		this._trigger("sort", event, this._uiHash());

		this.lastPositionAbs = this.positionAbs;
		return false;

	},

	_mouseStop: function(event, noPropagation) {

		if(!event) {
			return;
		}

		//If we are using droppables, inform the manager about the drop
		if ($.ui.ddmanager && !this.options.dropBehaviour) {
			$.ui.ddmanager.drop(this, event);
		}

		if(this.options.revert) {
			var that = this,
				cur = this.placeholder.offset(),
				axis = this.options.axis,
				animation = {};

			if ( !axis || axis === "x" ) {
				animation.left = cur.left - this.offset.parent.left - this.margins.left + (this.offsetParent[0] === document.body ? 0 : this.offsetParent[0].scrollLeft);
			}
			if ( !axis || axis === "y" ) {
				animation.top = cur.top - this.offset.parent.top - this.margins.top + (this.offsetParent[0] === document.body ? 0 : this.offsetParent[0].scrollTop);
			}
			this.reverting = true;
			$(this.helper).animate( animation, parseInt(this.options.revert, 10) || 500, function() {
				that._clear(event);
			});
		} else {
			this._clear(event, noPropagation);
		}

		return false;

	},

	cancel: function() {

		if(this.dragging) {

			this._mouseUp({ target: null });

			if(this.options.helper === "original") {
				this.currentItem.css(this._storedCSS).removeClass("ui-sortable-helper");
			} else {
				this.currentItem.show();
			}

			//Post deactivating events to containers
			for (var i = this.containers.length - 1; i >= 0; i--){
				this.containers[i]._trigger("deactivate", null, this._uiHash(this));
				if(this.containers[i].containerCache.over) {
					this.containers[i]._trigger("out", null, this._uiHash(this));
					this.containers[i].containerCache.over = 0;
				}
			}

		}

		if (this.placeholder) {
			//$(this.placeholder[0]).remove(); would have been the jQuery way - unfortunately, it unbinds ALL events from the original node!
			if(this.placeholder[0].parentNode) {
				this.placeholder[0].parentNode.removeChild(this.placeholder[0]);
			}
			if(this.options.helper !== "original" && this.helper && this.helper[0].parentNode) {
				this.helper.remove();
			}

			$.extend(this, {
				helper: null,
				dragging: false,
				reverting: false,
				_noFinalSort: null
			});

			if(this.domPosition.prev) {
				$(this.domPosition.prev).after(this.currentItem);
			} else {
				$(this.domPosition.parent).prepend(this.currentItem);
			}
		}

		return this;

	},

	serialize: function(o) {

		var items = this._getItemsAsjQuery(o && o.connected),
			str = [];
		o = o || {};

		$(items).each(function() {
			var res = ($(o.item || this).attr(o.attribute || "id") || "").match(o.expression || (/(.+)[\-=_](.+)/));
			if (res) {
				str.push((o.key || res[1]+"[]")+"="+(o.key && o.expression ? res[1] : res[2]));
			}
		});

		if(!str.length && o.key) {
			str.push(o.key + "=");
		}

		return str.join("&");

	},

	toArray: function(o) {

		var items = this._getItemsAsjQuery(o && o.connected),
			ret = [];

		o = o || {};

		items.each(function() { ret.push($(o.item || this).attr(o.attribute || "id") || ""); });
		return ret;

	},

	/* Be careful with the following core functions */
	_intersectsWith: function(item) {

		var x1 = this.positionAbs.left,
			x2 = x1 + this.helperProportions.width,
			y1 = this.positionAbs.top,
			y2 = y1 + this.helperProportions.height,
			l = item.left,
			r = l + item.width,
			t = item.top,
			b = t + item.height,
			dyClick = this.offset.click.top,
			dxClick = this.offset.click.left,
			isOverElementHeight = ( this.options.axis === "x" ) || ( ( y1 + dyClick ) > t && ( y1 + dyClick ) < b ),
			isOverElementWidth = ( this.options.axis === "y" ) || ( ( x1 + dxClick ) > l && ( x1 + dxClick ) < r ),
			isOverElement = isOverElementHeight && isOverElementWidth;

		if ( this.options.tolerance === "pointer" ||
			this.options.forcePointerForContainers ||
			(this.options.tolerance !== "pointer" && this.helperProportions[this.floating ? "width" : "height"] > item[this.floating ? "width" : "height"])
		) {
			return isOverElement;
		} else {

			return (l < x1 + (this.helperProportions.width / 2) && // Right Half
				x2 - (this.helperProportions.width / 2) < r && // Left Half
				t < y1 + (this.helperProportions.height / 2) && // Bottom Half
				y2 - (this.helperProportions.height / 2) < b ); // Top Half

		}
	},

	_intersectsWithPointer: function(item) {

		var isOverElementHeight = (this.options.axis === "x") || isOverAxis(this.positionAbs.top + this.offset.click.top, item.top, item.height),
			isOverElementWidth = (this.options.axis === "y") || isOverAxis(this.positionAbs.left + this.offset.click.left, item.left, item.width),
			isOverElement = isOverElementHeight && isOverElementWidth,
			verticalDirection = this._getDragVerticalDirection(),
			horizontalDirection = this._getDragHorizontalDirection();

		if (!isOverElement) {
			return false;
		}

		return this.floating ?
			( ((horizontalDirection && horizontalDirection === "right") || verticalDirection === "down") ? 2 : 1 )
			: ( verticalDirection && (verticalDirection === "down" ? 2 : 1) );

	},

	_intersectsWithSides: function(item) {

		var isOverBottomHalf = isOverAxis(this.positionAbs.top + this.offset.click.top, item.top + (item.height/2), item.height),
			isOverRightHalf = isOverAxis(this.positionAbs.left + this.offset.click.left, item.left + (item.width/2), item.width),
			verticalDirection = this._getDragVerticalDirection(),
			horizontalDirection = this._getDragHorizontalDirection();

		if (this.floating && horizontalDirection) {
			return ((horizontalDirection === "right" && isOverRightHalf) || (horizontalDirection === "left" && !isOverRightHalf));
		} else {
			return verticalDirection && ((verticalDirection === "down" && isOverBottomHalf) || (verticalDirection === "up" && !isOverBottomHalf));
		}

	},

	_getDragVerticalDirection: function() {
		var delta = this.positionAbs.top - this.lastPositionAbs.top;
		return delta !== 0 && (delta > 0 ? "down" : "up");
	},

	_getDragHorizontalDirection: function() {
		var delta = this.positionAbs.left - this.lastPositionAbs.left;
		return delta !== 0 && (delta > 0 ? "right" : "left");
	},

	refresh: function(event) {
		this._refreshItems(event);
		this.refreshPositions();
		return this;
	},

	_connectWith: function() {
		var options = this.options;
		return options.connectWith.constructor === String ? [options.connectWith] : options.connectWith;
	},

	_getItemsAsjQuery: function(connected) {

		var i, j, cur, inst,
			items = [],
			queries = [],
			connectWith = this._connectWith();

		if(connectWith && connected) {
			for (i = connectWith.length - 1; i >= 0; i--){
				cur = $(connectWith[i]);
				for ( j = cur.length - 1; j >= 0; j--){
					inst = $.data(cur[j], this.widgetFullName);
					if(inst && inst !== this && !inst.options.disabled) {
						queries.push([$.isFunction(inst.options.items) ? inst.options.items.call(inst.element) : $(inst.options.items, inst.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"), inst]);
					}
				}
			}
		}

		queries.push([$.isFunction(this.options.items) ? this.options.items.call(this.element, null, { options: this.options, item: this.currentItem }) : $(this.options.items, this.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"), this]);

		function addItems() {
			items.push( this );
		}
		for (i = queries.length - 1; i >= 0; i--){
			queries[i][0].each( addItems );
		}

		return $(items);

	},

	_removeCurrentsFromItems: function() {

		var list = this.currentItem.find(":data(" + this.widgetName + "-item)");

		this.items = $.grep(this.items, function (item) {
			for (var j=0; j < list.length; j++) {
				if(list[j] === item.item[0]) {
					return false;
				}
			}
			return true;
		});

	},

	_refreshItems: function(event) {

		this.items = [];
		this.containers = [this];

		var i, j, cur, inst, targetData, _queries, item, queriesLength,
			items = this.items,
			queries = [[$.isFunction(this.options.items) ? this.options.items.call(this.element[0], event, { item: this.currentItem }) : $(this.options.items, this.element), this]],
			connectWith = this._connectWith();

		if(connectWith && this.ready) { //Shouldn't be run the first time through due to massive slow-down
			for (i = connectWith.length - 1; i >= 0; i--){
				cur = $(connectWith[i]);
				for (j = cur.length - 1; j >= 0; j--){
					inst = $.data(cur[j], this.widgetFullName);
					if(inst && inst !== this && !inst.options.disabled) {
						queries.push([$.isFunction(inst.options.items) ? inst.options.items.call(inst.element[0], event, { item: this.currentItem }) : $(inst.options.items, inst.element), inst]);
						this.containers.push(inst);
					}
				}
			}
		}

		for (i = queries.length - 1; i >= 0; i--) {
			targetData = queries[i][1];
			_queries = queries[i][0];

			for (j=0, queriesLength = _queries.length; j < queriesLength; j++) {
				item = $(_queries[j]);

				item.data(this.widgetName + "-item", targetData); // Data for target checking (mouse manager)

				items.push({
					item: item,
					instance: targetData,
					width: 0, height: 0,
					left: 0, top: 0
				});
			}
		}

	},

	refreshPositions: function(fast) {

		//This has to be redone because due to the item being moved out/into the offsetParent, the offsetParent's position will change
		if(this.offsetParent && this.helper) {
			this.offset.parent = this._getParentOffset();
		}

		var i, item, t, p;

		for (i = this.items.length - 1; i >= 0; i--){
			item = this.items[i];

			//We ignore calculating positions of all connected containers when we're not over them
			if(item.instance !== this.currentContainer && this.currentContainer && item.item[0] !== this.currentItem[0]) {
				continue;
			}

			t = this.options.toleranceElement ? $(this.options.toleranceElement, item.item) : item.item;

			if (!fast) {
				item.width = t.outerWidth();
				item.height = t.outerHeight();
			}

			p = t.offset();
			item.left = p.left;
			item.top = p.top;
		}

		if(this.options.custom && this.options.custom.refreshContainers) {
			this.options.custom.refreshContainers.call(this);
		} else {
			for (i = this.containers.length - 1; i >= 0; i--){
				p = this.containers[i].element.offset();
				this.containers[i].containerCache.left = p.left;
				this.containers[i].containerCache.top = p.top;
				this.containers[i].containerCache.width	= this.containers[i].element.outerWidth();
				this.containers[i].containerCache.height = this.containers[i].element.outerHeight();
			}
		}

		return this;
	},

	_createPlaceholder: function(that) {
		that = that || this;
		var className,
			o = that.options;

		if(!o.placeholder || o.placeholder.constructor === String) {
			className = o.placeholder;
			o.placeholder = {
				element: function() {

					var nodeName = that.currentItem[0].nodeName.toLowerCase(),
						element = $( "<" + nodeName + ">", that.document[0] )
							.addClass(className || that.currentItem[0].className+" ui-sortable-placeholder")
							.removeClass("ui-sortable-helper");

					if ( nodeName === "tr" ) {
						that.currentItem.children().each(function() {
							$( "<td>&#160;</td>", that.document[0] )
								.attr( "colspan", $( this ).attr( "colspan" ) || 1 )
								.appendTo( element );
						});
					} else if ( nodeName === "img" ) {
						element.attr( "src", that.currentItem.attr( "src" ) );
					}

					if ( !className ) {
						element.css( "visibility", "hidden" );
					}

					return element;
				},
				update: function(container, p) {

					// 1. If a className is set as 'placeholder option, we don't force sizes - the class is responsible for that
					// 2. The option 'forcePlaceholderSize can be enabled to force it even if a class name is specified
					if(className && !o.forcePlaceholderSize) {
						return;
					}

					//If the element doesn't have a actual height by itself (without styles coming from a stylesheet), it receives the inline height from the dragged item
					if(!p.height()) { p.height(that.currentItem.innerHeight() - parseInt(that.currentItem.css("paddingTop")||0, 10) - parseInt(that.currentItem.css("paddingBottom")||0, 10)); }
					if(!p.width()) { p.width(that.currentItem.innerWidth() - parseInt(that.currentItem.css("paddingLeft")||0, 10) - parseInt(that.currentItem.css("paddingRight")||0, 10)); }
				}
			};
		}

		//Create the placeholder
		that.placeholder = $(o.placeholder.element.call(that.element, that.currentItem));

		//Append it after the actual current item
		that.currentItem.after(that.placeholder);

		//Update the size of the placeholder (TODO: Logic to fuzzy, see line 316/317)
		o.placeholder.update(that, that.placeholder);

	},

	_contactContainers: function(event) {
		var i, j, dist, itemWithLeastDistance, posProperty, sizeProperty, base, cur, nearBottom, floating,
			innermostContainer = null,
			innermostIndex = null;

		// get innermost container that intersects with item
		for (i = this.containers.length - 1; i >= 0; i--) {

			// never consider a container that's located within the item itself
			if($.contains(this.currentItem[0], this.containers[i].element[0])) {
				continue;
			}

			if(this._intersectsWith(this.containers[i].containerCache)) {

				// if we've already found a container and it's more "inner" than this, then continue
				if(innermostContainer && $.contains(this.containers[i].element[0], innermostContainer.element[0])) {
					continue;
				}

				innermostContainer = this.containers[i];
				innermostIndex = i;

			} else {
				// container doesn't intersect. trigger "out" event if necessary
				if(this.containers[i].containerCache.over) {
					this.containers[i]._trigger("out", event, this._uiHash(this));
					this.containers[i].containerCache.over = 0;
				}
			}

		}

		// if no intersecting containers found, return
		if(!innermostContainer) {
			return;
		}

		// move the item into the container if it's not there already
		if(this.containers.length === 1) {
			if (!this.containers[innermostIndex].containerCache.over) {
				this.containers[innermostIndex]._trigger("over", event, this._uiHash(this));
				this.containers[innermostIndex].containerCache.over = 1;
			}
		} else {

			//When entering a new container, we will find the item with the least distance and append our item near it
			dist = 10000;
			itemWithLeastDistance = null;
			floating = innermostContainer.floating || isFloating(this.currentItem);
			posProperty = floating ? "left" : "top";
			sizeProperty = floating ? "width" : "height";
			base = this.positionAbs[posProperty] + this.offset.click[posProperty];
			for (j = this.items.length - 1; j >= 0; j--) {
				if(!$.contains(this.containers[innermostIndex].element[0], this.items[j].item[0])) {
					continue;
				}
				if(this.items[j].item[0] === this.currentItem[0]) {
					continue;
				}
				if (floating && !isOverAxis(this.positionAbs.top + this.offset.click.top, this.items[j].top, this.items[j].height)) {
					continue;
				}
				cur = this.items[j].item.offset()[posProperty];
				nearBottom = false;
				if(Math.abs(cur - base) > Math.abs(cur + this.items[j][sizeProperty] - base)){
					nearBottom = true;
					cur += this.items[j][sizeProperty];
				}

				if(Math.abs(cur - base) < dist) {
					dist = Math.abs(cur - base); itemWithLeastDistance = this.items[j];
					this.direction = nearBottom ? "up": "down";
				}
			}

			//Check if dropOnEmpty is enabled
			if(!itemWithLeastDistance && !this.options.dropOnEmpty) {
				return;
			}

			if(this.currentContainer === this.containers[innermostIndex]) {
				return;
			}

			itemWithLeastDistance ? this._rearrange(event, itemWithLeastDistance, null, true) : this._rearrange(event, null, this.containers[innermostIndex].element, true);
			this._trigger("change", event, this._uiHash());
			this.containers[innermostIndex]._trigger("change", event, this._uiHash(this));
			this.currentContainer = this.containers[innermostIndex];

			//Update the placeholder
			this.options.placeholder.update(this.currentContainer, this.placeholder);

			this.containers[innermostIndex]._trigger("over", event, this._uiHash(this));
			this.containers[innermostIndex].containerCache.over = 1;
		}


	},

	_createHelper: function(event) {

		var o = this.options,
			helper = $.isFunction(o.helper) ? $(o.helper.apply(this.element[0], [event, this.currentItem])) : (o.helper === "clone" ? this.currentItem.clone() : this.currentItem);

		//Add the helper to the DOM if that didn't happen already
		if(!helper.parents("body").length) {
			$(o.appendTo !== "parent" ? o.appendTo : this.currentItem[0].parentNode)[0].appendChild(helper[0]);
		}

		if(helper[0] === this.currentItem[0]) {
			this._storedCSS = { width: this.currentItem[0].style.width, height: this.currentItem[0].style.height, position: this.currentItem.css("position"), top: this.currentItem.css("top"), left: this.currentItem.css("left") };
		}

		if(!helper[0].style.width || o.forceHelperSize) {
			helper.width(this.currentItem.width());
		}
		if(!helper[0].style.height || o.forceHelperSize) {
			helper.height(this.currentItem.height());
		}

		return helper;

	},

	_adjustOffsetFromHelper: function(obj) {
		if (typeof obj === "string") {
			obj = obj.split(" ");
		}
		if ($.isArray(obj)) {
			obj = {left: +obj[0], top: +obj[1] || 0};
		}
		if ("left" in obj) {
			this.offset.click.left = obj.left + this.margins.left;
		}
		if ("right" in obj) {
			this.offset.click.left = this.helperProportions.width - obj.right + this.margins.left;
		}
		if ("top" in obj) {
			this.offset.click.top = obj.top + this.margins.top;
		}
		if ("bottom" in obj) {
			this.offset.click.top = this.helperProportions.height - obj.bottom + this.margins.top;
		}
	},

	_getParentOffset: function() {


		//Get the offsetParent and cache its position
		this.offsetParent = this.helper.offsetParent();
		var po = this.offsetParent.offset();

		// This is a special case where we need to modify a offset calculated on start, since the following happened:
		// 1. The position of the helper is absolute, so it's position is calculated based on the next positioned parent
		// 2. The actual offset parent is a child of the scroll parent, and the scroll parent isn't the document, which means that
		//    the scroll is included in the initial calculation of the offset of the parent, and never recalculated upon drag
		if(this.cssPosition === "absolute" && this.scrollParent[0] !== document && $.contains(this.scrollParent[0], this.offsetParent[0])) {
			po.left += this.scrollParent.scrollLeft();
			po.top += this.scrollParent.scrollTop();
		}

		// This needs to be actually done for all browsers, since pageX/pageY includes this information
		// with an ugly IE fix
		if( this.offsetParent[0] === document.body || (this.offsetParent[0].tagName && this.offsetParent[0].tagName.toLowerCase() === "html" && $.ui.ie)) {
			po = { top: 0, left: 0 };
		}

		return {
			top: po.top + (parseInt(this.offsetParent.css("borderTopWidth"),10) || 0),
			left: po.left + (parseInt(this.offsetParent.css("borderLeftWidth"),10) || 0)
		};

	},

	_getRelativeOffset: function() {

		if(this.cssPosition === "relative") {
			var p = this.currentItem.position();
			return {
				top: p.top - (parseInt(this.helper.css("top"),10) || 0) + this.scrollParent.scrollTop(),
				left: p.left - (parseInt(this.helper.css("left"),10) || 0) + this.scrollParent.scrollLeft()
			};
		} else {
			return { top: 0, left: 0 };
		}

	},

	_cacheMargins: function() {
		this.margins = {
			left: (parseInt(this.currentItem.css("marginLeft"),10) || 0),
			top: (parseInt(this.currentItem.css("marginTop"),10) || 0)
		};
	},

	_cacheHelperProportions: function() {
		this.helperProportions = {
			width: this.helper.outerWidth(),
			height: this.helper.outerHeight()
		};
	},

	_setContainment: function() {

		var ce, co, over,
			o = this.options;
		if(o.containment === "parent") {
			o.containment = this.helper[0].parentNode;
		}
		if(o.containment === "document" || o.containment === "window") {
			this.containment = [
				0 - this.offset.relative.left - this.offset.parent.left,
				0 - this.offset.relative.top - this.offset.parent.top,
				$(o.containment === "document" ? document : window).width() - this.helperProportions.width - this.margins.left,
				($(o.containment === "document" ? document : window).height() || document.body.parentNode.scrollHeight) - this.helperProportions.height - this.margins.top
			];
		}

		if(!(/^(document|window|parent)$/).test(o.containment)) {
			ce = $(o.containment)[0];
			co = $(o.containment).offset();
			over = ($(ce).css("overflow") !== "hidden");

			this.containment = [
				co.left + (parseInt($(ce).css("borderLeftWidth"),10) || 0) + (parseInt($(ce).css("paddingLeft"),10) || 0) - this.margins.left,
				co.top + (parseInt($(ce).css("borderTopWidth"),10) || 0) + (parseInt($(ce).css("paddingTop"),10) || 0) - this.margins.top,
				co.left+(over ? Math.max(ce.scrollWidth,ce.offsetWidth) : ce.offsetWidth) - (parseInt($(ce).css("borderLeftWidth"),10) || 0) - (parseInt($(ce).css("paddingRight"),10) || 0) - this.helperProportions.width - this.margins.left,
				co.top+(over ? Math.max(ce.scrollHeight,ce.offsetHeight) : ce.offsetHeight) - (parseInt($(ce).css("borderTopWidth"),10) || 0) - (parseInt($(ce).css("paddingBottom"),10) || 0) - this.helperProportions.height - this.margins.top
			];
		}

	},

	_convertPositionTo: function(d, pos) {

		if(!pos) {
			pos = this.position;
		}
		var mod = d === "absolute" ? 1 : -1,
			scroll = this.cssPosition === "absolute" && !(this.scrollParent[0] !== document && $.contains(this.scrollParent[0], this.offsetParent[0])) ? this.offsetParent : this.scrollParent,
			scrollIsRootNode = (/(html|body)/i).test(scroll[0].tagName);

		return {
			top: (
				pos.top	+																// The absolute mouse position
				this.offset.relative.top * mod +										// Only for relative positioned nodes: Relative offset from element to offset parent
				this.offset.parent.top * mod -											// The offsetParent's offset without borders (offset + border)
				( ( this.cssPosition === "fixed" ? -this.scrollParent.scrollTop() : ( scrollIsRootNode ? 0 : scroll.scrollTop() ) ) * mod)
			),
			left: (
				pos.left +																// The absolute mouse position
				this.offset.relative.left * mod +										// Only for relative positioned nodes: Relative offset from element to offset parent
				this.offset.parent.left * mod	-										// The offsetParent's offset without borders (offset + border)
				( ( this.cssPosition === "fixed" ? -this.scrollParent.scrollLeft() : scrollIsRootNode ? 0 : scroll.scrollLeft() ) * mod)
			)
		};

	},

	_generatePosition: function(event) {

		var top, left,
			o = this.options,
			pageX = event.pageX,
			pageY = event.pageY,
			scroll = this.cssPosition === "absolute" && !(this.scrollParent[0] !== document && $.contains(this.scrollParent[0], this.offsetParent[0])) ? this.offsetParent : this.scrollParent, scrollIsRootNode = (/(html|body)/i).test(scroll[0].tagName);

		// This is another very weird special case that only happens for relative elements:
		// 1. If the css position is relative
		// 2. and the scroll parent is the document or similar to the offset parent
		// we have to refresh the relative offset during the scroll so there are no jumps
		if(this.cssPosition === "relative" && !(this.scrollParent[0] !== document && this.scrollParent[0] !== this.offsetParent[0])) {
			this.offset.relative = this._getRelativeOffset();
		}

		/*
		 * - Position constraining -
		 * Constrain the position to a mix of grid, containment.
		 */

		if(this.originalPosition) { //If we are not dragging yet, we won't check for options

			if(this.containment) {
				if(event.pageX - this.offset.click.left < this.containment[0]) {
					pageX = this.containment[0] + this.offset.click.left;
				}
				if(event.pageY - this.offset.click.top < this.containment[1]) {
					pageY = this.containment[1] + this.offset.click.top;
				}
				if(event.pageX - this.offset.click.left > this.containment[2]) {
					pageX = this.containment[2] + this.offset.click.left;
				}
				if(event.pageY - this.offset.click.top > this.containment[3]) {
					pageY = this.containment[3] + this.offset.click.top;
				}
			}

			if(o.grid) {
				top = this.originalPageY + Math.round((pageY - this.originalPageY) / o.grid[1]) * o.grid[1];
				pageY = this.containment ? ( (top - this.offset.click.top >= this.containment[1] && top - this.offset.click.top <= this.containment[3]) ? top : ((top - this.offset.click.top >= this.containment[1]) ? top - o.grid[1] : top + o.grid[1])) : top;

				left = this.originalPageX + Math.round((pageX - this.originalPageX) / o.grid[0]) * o.grid[0];
				pageX = this.containment ? ( (left - this.offset.click.left >= this.containment[0] && left - this.offset.click.left <= this.containment[2]) ? left : ((left - this.offset.click.left >= this.containment[0]) ? left - o.grid[0] : left + o.grid[0])) : left;
			}

		}

		return {
			top: (
				pageY -																// The absolute mouse position
				this.offset.click.top -													// Click offset (relative to the element)
				this.offset.relative.top	-											// Only for relative positioned nodes: Relative offset from element to offset parent
				this.offset.parent.top +												// The offsetParent's offset without borders (offset + border)
				( ( this.cssPosition === "fixed" ? -this.scrollParent.scrollTop() : ( scrollIsRootNode ? 0 : scroll.scrollTop() ) ))
			),
			left: (
				pageX -																// The absolute mouse position
				this.offset.click.left -												// Click offset (relative to the element)
				this.offset.relative.left	-											// Only for relative positioned nodes: Relative offset from element to offset parent
				this.offset.parent.left +												// The offsetParent's offset without borders (offset + border)
				( ( this.cssPosition === "fixed" ? -this.scrollParent.scrollLeft() : scrollIsRootNode ? 0 : scroll.scrollLeft() ))
			)
		};

	},

	_rearrange: function(event, i, a, hardRefresh) {

		a ? a[0].appendChild(this.placeholder[0]) : i.item[0].parentNode.insertBefore(this.placeholder[0], (this.direction === "down" ? i.item[0] : i.item[0].nextSibling));

		//Various things done here to improve the performance:
		// 1. we create a setTimeout, that calls refreshPositions
		// 2. on the instance, we have a counter variable, that get's higher after every append
		// 3. on the local scope, we copy the counter variable, and check in the timeout, if it's still the same
		// 4. this lets only the last addition to the timeout stack through
		this.counter = this.counter ? ++this.counter : 1;
		var counter = this.counter;

		this._delay(function() {
			if(counter === this.counter) {
				this.refreshPositions(!hardRefresh); //Precompute after each DOM insertion, NOT on mousemove
			}
		});

	},

	_clear: function(event, noPropagation) {

		this.reverting = false;
		// We delay all events that have to be triggered to after the point where the placeholder has been removed and
		// everything else normalized again
		var i,
			delayedTriggers = [];

		// We first have to update the dom position of the actual currentItem
		// Note: don't do it if the current item is already removed (by a user), or it gets reappended (see #4088)
		if(!this._noFinalSort && this.currentItem.parent().length) {
			this.placeholder.before(this.currentItem);
		}
		this._noFinalSort = null;

		if(this.helper[0] === this.currentItem[0]) {
			for(i in this._storedCSS) {
				if(this._storedCSS[i] === "auto" || this._storedCSS[i] === "static") {
					this._storedCSS[i] = "";
				}
			}
			this.currentItem.css(this._storedCSS).removeClass("ui-sortable-helper");
		} else {
			this.currentItem.show();
		}

		if(this.fromOutside && !noPropagation) {
			delayedTriggers.push(function(event) { this._trigger("receive", event, this._uiHash(this.fromOutside)); });
		}
		if((this.fromOutside || this.domPosition.prev !== this.currentItem.prev().not(".ui-sortable-helper")[0] || this.domPosition.parent !== this.currentItem.parent()[0]) && !noPropagation) {
			delayedTriggers.push(function(event) { this._trigger("update", event, this._uiHash()); }); //Trigger update callback if the DOM position has changed
		}

		// Check if the items Container has Changed and trigger appropriate
		// events.
		if (this !== this.currentContainer) {
			if(!noPropagation) {
				delayedTriggers.push(function(event) { this._trigger("remove", event, this._uiHash()); });
				delayedTriggers.push((function(c) { return function(event) { c._trigger("receive", event, this._uiHash(this)); };  }).call(this, this.currentContainer));
				delayedTriggers.push((function(c) { return function(event) { c._trigger("update", event, this._uiHash(this));  }; }).call(this, this.currentContainer));
			}
		}


		//Post events to containers
		function delayEvent( type, instance, container ) {
			return function( event ) {
				container._trigger( type, event, instance._uiHash( instance ) );
			};
		}
		for (i = this.containers.length - 1; i >= 0; i--){
			if (!noPropagation) {
				delayedTriggers.push( delayEvent( "deactivate", this, this.containers[ i ] ) );
			}
			if(this.containers[i].containerCache.over) {
				delayedTriggers.push( delayEvent( "out", this, this.containers[ i ] ) );
				this.containers[i].containerCache.over = 0;
			}
		}

		//Do what was originally in plugins
		if ( this.storedCursor ) {
			this.document.find( "body" ).css( "cursor", this.storedCursor );
			this.storedStylesheet.remove();
		}
		if(this._storedOpacity) {
			this.helper.css("opacity", this._storedOpacity);
		}
		if(this._storedZIndex) {
			this.helper.css("zIndex", this._storedZIndex === "auto" ? "" : this._storedZIndex);
		}

		this.dragging = false;
		if(this.cancelHelperRemoval) {
			if(!noPropagation) {
				this._trigger("beforeStop", event, this._uiHash());
				for (i=0; i < delayedTriggers.length; i++) {
					delayedTriggers[i].call(this, event);
				} //Trigger all delayed events
				this._trigger("stop", event, this._uiHash());
			}

			this.fromOutside = false;
			return false;
		}

		if(!noPropagation) {
			this._trigger("beforeStop", event, this._uiHash());
		}

		//$(this.placeholder[0]).remove(); would have been the jQuery way - unfortunately, it unbinds ALL events from the original node!
		this.placeholder[0].parentNode.removeChild(this.placeholder[0]);

		if(this.helper[0] !== this.currentItem[0]) {
			this.helper.remove();
		}
		this.helper = null;

		if(!noPropagation) {
			for (i=0; i < delayedTriggers.length; i++) {
				delayedTriggers[i].call(this, event);
			} //Trigger all delayed events
			this._trigger("stop", event, this._uiHash());
		}

		this.fromOutside = false;
		return true;

	},

	_trigger: function() {
		if ($.Widget.prototype._trigger.apply(this, arguments) === false) {
			this.cancel();
		}
	},

	_uiHash: function(_inst) {
		var inst = _inst || this;
		return {
			helper: inst.helper,
			placeholder: inst.placeholder || $([]),
			position: inst.position,
			originalPosition: inst.originalPosition,
			offset: inst.positionAbs,
			item: inst.currentItem,
			sender: _inst ? _inst.element : null
		};
	}

});

})(jQuery);

},{"./core":"jquery-ui/core","./mouse":"jquery-ui/mouse","./widget":"jquery-ui/widget","jquery":"jquery"}],"jquery-ui/spinner":[function(require,module,exports){
var jQuery = require('jquery');
require('./core');
require('./widget');
require('./button');

/*!
 * jQuery UI Spinner 1.10.4
 * http://jqueryui.com
 *
 * Copyright 2014 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/spinner/
 *
 * Depends:
 *  jquery.ui.core.js
 *  jquery.ui.widget.js
 *  jquery.ui.button.js
 */
(function( $ ) {

function modifier( fn ) {
	return function() {
		var previous = this.element.val();
		fn.apply( this, arguments );
		this._refresh();
		if ( previous !== this.element.val() ) {
			this._trigger( "change" );
		}
	};
}

$.widget( "ui.spinner", {
	version: "1.10.4",
	defaultElement: "<input>",
	widgetEventPrefix: "spin",
	options: {
		culture: null,
		icons: {
			down: "ui-icon-triangle-1-s",
			up: "ui-icon-triangle-1-n"
		},
		incremental: true,
		max: null,
		min: null,
		numberFormat: null,
		page: 10,
		step: 1,

		change: null,
		spin: null,
		start: null,
		stop: null
	},

	_create: function() {
		// handle string values that need to be parsed
		this._setOption( "max", this.options.max );
		this._setOption( "min", this.options.min );
		this._setOption( "step", this.options.step );

		// Only format if there is a value, prevents the field from being marked
		// as invalid in Firefox, see #9573.
		if ( this.value() !== "" ) {
			// Format the value, but don't constrain.
			this._value( this.element.val(), true );
		}

		this._draw();
		this._on( this._events );
		this._refresh();

		// turning off autocomplete prevents the browser from remembering the
		// value when navigating through history, so we re-enable autocomplete
		// if the page is unloaded before the widget is destroyed. #7790
		this._on( this.window, {
			beforeunload: function() {
				this.element.removeAttr( "autocomplete" );
			}
		});
	},

	_getCreateOptions: function() {
		var options = {},
			element = this.element;

		$.each( [ "min", "max", "step" ], function( i, option ) {
			var value = element.attr( option );
			if ( value !== undefined && value.length ) {
				options[ option ] = value;
			}
		});

		return options;
	},

	_events: {
		keydown: function( event ) {
			if ( this._start( event ) && this._keydown( event ) ) {
				event.preventDefault();
			}
		},
		keyup: "_stop",
		focus: function() {
			this.previous = this.element.val();
		},
		blur: function( event ) {
			if ( this.cancelBlur ) {
				delete this.cancelBlur;
				return;
			}

			this._stop();
			this._refresh();
			if ( this.previous !== this.element.val() ) {
				this._trigger( "change", event );
			}
		},
		mousewheel: function( event, delta ) {
			if ( !delta ) {
				return;
			}
			if ( !this.spinning && !this._start( event ) ) {
				return false;
			}

			this._spin( (delta > 0 ? 1 : -1) * this.options.step, event );
			clearTimeout( this.mousewheelTimer );
			this.mousewheelTimer = this._delay(function() {
				if ( this.spinning ) {
					this._stop( event );
				}
			}, 100 );
			event.preventDefault();
		},
		"mousedown .ui-spinner-button": function( event ) {
			var previous;

			// We never want the buttons to have focus; whenever the user is
			// interacting with the spinner, the focus should be on the input.
			// If the input is focused then this.previous is properly set from
			// when the input first received focus. If the input is not focused
			// then we need to set this.previous based on the value before spinning.
			previous = this.element[0] === this.document[0].activeElement ?
				this.previous : this.element.val();
			function checkFocus() {
				var isActive = this.element[0] === this.document[0].activeElement;
				if ( !isActive ) {
					this.element.focus();
					this.previous = previous;
					// support: IE
					// IE sets focus asynchronously, so we need to check if focus
					// moved off of the input because the user clicked on the button.
					this._delay(function() {
						this.previous = previous;
					});
				}
			}

			// ensure focus is on (or stays on) the text field
			event.preventDefault();
			checkFocus.call( this );

			// support: IE
			// IE doesn't prevent moving focus even with event.preventDefault()
			// so we set a flag to know when we should ignore the blur event
			// and check (again) if focus moved off of the input.
			this.cancelBlur = true;
			this._delay(function() {
				delete this.cancelBlur;
				checkFocus.call( this );
			});

			if ( this._start( event ) === false ) {
				return;
			}

			this._repeat( null, $( event.currentTarget ).hasClass( "ui-spinner-up" ) ? 1 : -1, event );
		},
		"mouseup .ui-spinner-button": "_stop",
		"mouseenter .ui-spinner-button": function( event ) {
			// button will add ui-state-active if mouse was down while mouseleave and kept down
			if ( !$( event.currentTarget ).hasClass( "ui-state-active" ) ) {
				return;
			}

			if ( this._start( event ) === false ) {
				return false;
			}
			this._repeat( null, $( event.currentTarget ).hasClass( "ui-spinner-up" ) ? 1 : -1, event );
		},
		// TODO: do we really want to consider this a stop?
		// shouldn't we just stop the repeater and wait until mouseup before
		// we trigger the stop event?
		"mouseleave .ui-spinner-button": "_stop"
	},

	_draw: function() {
		var uiSpinner = this.uiSpinner = this.element
			.addClass( "ui-spinner-input" )
			.attr( "autocomplete", "off" )
			.wrap( this._uiSpinnerHtml() )
			.parent()
				// add buttons
				.append( this._buttonHtml() );

		this.element.attr( "role", "spinbutton" );

		// button bindings
		this.buttons = uiSpinner.find( ".ui-spinner-button" )
			.attr( "tabIndex", -1 )
			.button()
			.removeClass( "ui-corner-all" );

		// IE 6 doesn't understand height: 50% for the buttons
		// unless the wrapper has an explicit height
		if ( this.buttons.height() > Math.ceil( uiSpinner.height() * 0.5 ) &&
				uiSpinner.height() > 0 ) {
			uiSpinner.height( uiSpinner.height() );
		}

		// disable spinner if element was already disabled
		if ( this.options.disabled ) {
			this.disable();
		}
	},

	_keydown: function( event ) {
		var options = this.options,
			keyCode = $.ui.keyCode;

		switch ( event.keyCode ) {
		case keyCode.UP:
			this._repeat( null, 1, event );
			return true;
		case keyCode.DOWN:
			this._repeat( null, -1, event );
			return true;
		case keyCode.PAGE_UP:
			this._repeat( null, options.page, event );
			return true;
		case keyCode.PAGE_DOWN:
			this._repeat( null, -options.page, event );
			return true;
		}

		return false;
	},

	_uiSpinnerHtml: function() {
		return "<span class='ui-spinner ui-widget ui-widget-content ui-corner-all'></span>";
	},

	_buttonHtml: function() {
		return "" +
			"<a class='ui-spinner-button ui-spinner-up ui-corner-tr'>" +
				"<span class='ui-icon " + this.options.icons.up + "'>&#9650;</span>" +
			"</a>" +
			"<a class='ui-spinner-button ui-spinner-down ui-corner-br'>" +
				"<span class='ui-icon " + this.options.icons.down + "'>&#9660;</span>" +
			"</a>";
	},

	_start: function( event ) {
		if ( !this.spinning && this._trigger( "start", event ) === false ) {
			return false;
		}

		if ( !this.counter ) {
			this.counter = 1;
		}
		this.spinning = true;
		return true;
	},

	_repeat: function( i, steps, event ) {
		i = i || 500;

		clearTimeout( this.timer );
		this.timer = this._delay(function() {
			this._repeat( 40, steps, event );
		}, i );

		this._spin( steps * this.options.step, event );
	},

	_spin: function( step, event ) {
		var value = this.value() || 0;

		if ( !this.counter ) {
			this.counter = 1;
		}

		value = this._adjustValue( value + step * this._increment( this.counter ) );

		if ( !this.spinning || this._trigger( "spin", event, { value: value } ) !== false) {
			this._value( value );
			this.counter++;
		}
	},

	_increment: function( i ) {
		var incremental = this.options.incremental;

		if ( incremental ) {
			return $.isFunction( incremental ) ?
				incremental( i ) :
				Math.floor( i*i*i/50000 - i*i/500 + 17*i/200 + 1 );
		}

		return 1;
	},

	_precision: function() {
		var precision = this._precisionOf( this.options.step );
		if ( this.options.min !== null ) {
			precision = Math.max( precision, this._precisionOf( this.options.min ) );
		}
		return precision;
	},

	_precisionOf: function( num ) {
		var str = num.toString(),
			decimal = str.indexOf( "." );
		return decimal === -1 ? 0 : str.length - decimal - 1;
	},

	_adjustValue: function( value ) {
		var base, aboveMin,
			options = this.options;

		// make sure we're at a valid step
		// - find out where we are relative to the base (min or 0)
		base = options.min !== null ? options.min : 0;
		aboveMin = value - base;
		// - round to the nearest step
		aboveMin = Math.round(aboveMin / options.step) * options.step;
		// - rounding is based on 0, so adjust back to our base
		value = base + aboveMin;

		// fix precision from bad JS floating point math
		value = parseFloat( value.toFixed( this._precision() ) );

		// clamp the value
		if ( options.max !== null && value > options.max) {
			return options.max;
		}
		if ( options.min !== null && value < options.min ) {
			return options.min;
		}

		return value;
	},

	_stop: function( event ) {
		if ( !this.spinning ) {
			return;
		}

		clearTimeout( this.timer );
		clearTimeout( this.mousewheelTimer );
		this.counter = 0;
		this.spinning = false;
		this._trigger( "stop", event );
	},

	_setOption: function( key, value ) {
		if ( key === "culture" || key === "numberFormat" ) {
			var prevValue = this._parse( this.element.val() );
			this.options[ key ] = value;
			this.element.val( this._format( prevValue ) );
			return;
		}

		if ( key === "max" || key === "min" || key === "step" ) {
			if ( typeof value === "string" ) {
				value = this._parse( value );
			}
		}
		if ( key === "icons" ) {
			this.buttons.first().find( ".ui-icon" )
				.removeClass( this.options.icons.up )
				.addClass( value.up );
			this.buttons.last().find( ".ui-icon" )
				.removeClass( this.options.icons.down )
				.addClass( value.down );
		}

		this._super( key, value );

		if ( key === "disabled" ) {
			if ( value ) {
				this.element.prop( "disabled", true );
				this.buttons.button( "disable" );
			} else {
				this.element.prop( "disabled", false );
				this.buttons.button( "enable" );
			}
		}
	},

	_setOptions: modifier(function( options ) {
		this._super( options );
		this._value( this.element.val() );
	}),

	_parse: function( val ) {
		if ( typeof val === "string" && val !== "" ) {
			val = window.Globalize && this.options.numberFormat ?
				Globalize.parseFloat( val, 10, this.options.culture ) : +val;
		}
		return val === "" || isNaN( val ) ? null : val;
	},

	_format: function( value ) {
		if ( value === "" ) {
			return "";
		}
		return window.Globalize && this.options.numberFormat ?
			Globalize.format( value, this.options.numberFormat, this.options.culture ) :
			value;
	},

	_refresh: function() {
		this.element.attr({
			"aria-valuemin": this.options.min,
			"aria-valuemax": this.options.max,
			// TODO: what should we do with values that can't be parsed?
			"aria-valuenow": this._parse( this.element.val() )
		});
	},

	// update the value without triggering change
	_value: function( value, allowAny ) {
		var parsed;
		if ( value !== "" ) {
			parsed = this._parse( value );
			if ( parsed !== null ) {
				if ( !allowAny ) {
					parsed = this._adjustValue( parsed );
				}
				value = this._format( parsed );
			}
		}
		this.element.val( value );
		this._refresh();
	},

	_destroy: function() {
		this.element
			.removeClass( "ui-spinner-input" )
			.prop( "disabled", false )
			.removeAttr( "autocomplete" )
			.removeAttr( "role" )
			.removeAttr( "aria-valuemin" )
			.removeAttr( "aria-valuemax" )
			.removeAttr( "aria-valuenow" );
		this.uiSpinner.replaceWith( this.element );
	},

	stepUp: modifier(function( steps ) {
		this._stepUp( steps );
	}),
	_stepUp: function( steps ) {
		if ( this._start() ) {
			this._spin( (steps || 1) * this.options.step );
			this._stop();
		}
	},

	stepDown: modifier(function( steps ) {
		this._stepDown( steps );
	}),
	_stepDown: function( steps ) {
		if ( this._start() ) {
			this._spin( (steps || 1) * -this.options.step );
			this._stop();
		}
	},

	pageUp: modifier(function( pages ) {
		this._stepUp( (pages || 1) * this.options.page );
	}),

	pageDown: modifier(function( pages ) {
		this._stepDown( (pages || 1) * this.options.page );
	}),

	value: function( newVal ) {
		if ( !arguments.length ) {
			return this._parse( this.element.val() );
		}
		modifier( this._value ).call( this, newVal );
	},

	widget: function() {
		return this.uiSpinner;
	}
});

}( jQuery ) );

},{"./button":"jquery-ui/button","./core":"jquery-ui/core","./widget":"jquery-ui/widget","jquery":"jquery"}],"jquery-ui/widget":[function(require,module,exports){
var jQuery = require('jquery');

/*!
 * jQuery UI Widget 1.10.4
 * http://jqueryui.com
 *
 * Copyright 2014 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/jQuery.widget/
 */
(function( $, undefined ) {

var uuid = 0,
	slice = Array.prototype.slice,
	_cleanData = $.cleanData;
$.cleanData = function( elems ) {
	for ( var i = 0, elem; (elem = elems[i]) != null; i++ ) {
		try {
			$( elem ).triggerHandler( "remove" );
		// http://bugs.jquery.com/ticket/8235
		} catch( e ) {}
	}
	_cleanData( elems );
};

$.widget = function( name, base, prototype ) {
	var fullName, existingConstructor, constructor, basePrototype,
		// proxiedPrototype allows the provided prototype to remain unmodified
		// so that it can be used as a mixin for multiple widgets (#8876)
		proxiedPrototype = {},
		namespace = name.split( "." )[ 0 ];

	name = name.split( "." )[ 1 ];
	fullName = namespace + "-" + name;

	if ( !prototype ) {
		prototype = base;
		base = $.Widget;
	}

	// create selector for plugin
	$.expr[ ":" ][ fullName.toLowerCase() ] = function( elem ) {
		return !!$.data( elem, fullName );
	};

	$[ namespace ] = $[ namespace ] || {};
	existingConstructor = $[ namespace ][ name ];
	constructor = $[ namespace ][ name ] = function( options, element ) {
		// allow instantiation without "new" keyword
		if ( !this._createWidget ) {
			return new constructor( options, element );
		}

		// allow instantiation without initializing for simple inheritance
		// must use "new" keyword (the code above always passes args)
		if ( arguments.length ) {
			this._createWidget( options, element );
		}
	};
	// extend with the existing constructor to carry over any static properties
	$.extend( constructor, existingConstructor, {
		version: prototype.version,
		// copy the object used to create the prototype in case we need to
		// redefine the widget later
		_proto: $.extend( {}, prototype ),
		// track widgets that inherit from this widget in case this widget is
		// redefined after a widget inherits from it
		_childConstructors: []
	});

	basePrototype = new base();
	// we need to make the options hash a property directly on the new instance
	// otherwise we'll modify the options hash on the prototype that we're
	// inheriting from
	basePrototype.options = $.widget.extend( {}, basePrototype.options );
	$.each( prototype, function( prop, value ) {
		if ( !$.isFunction( value ) ) {
			proxiedPrototype[ prop ] = value;
			return;
		}
		proxiedPrototype[ prop ] = (function() {
			var _super = function() {
					return base.prototype[ prop ].apply( this, arguments );
				},
				_superApply = function( args ) {
					return base.prototype[ prop ].apply( this, args );
				};
			return function() {
				var __super = this._super,
					__superApply = this._superApply,
					returnValue;

				this._super = _super;
				this._superApply = _superApply;

				returnValue = value.apply( this, arguments );

				this._super = __super;
				this._superApply = __superApply;

				return returnValue;
			};
		})();
	});
	constructor.prototype = $.widget.extend( basePrototype, {
		// TODO: remove support for widgetEventPrefix
		// always use the name + a colon as the prefix, e.g., draggable:start
		// don't prefix for widgets that aren't DOM-based
		widgetEventPrefix: existingConstructor ? (basePrototype.widgetEventPrefix || name) : name
	}, proxiedPrototype, {
		constructor: constructor,
		namespace: namespace,
		widgetName: name,
		widgetFullName: fullName
	});

	// If this widget is being redefined then we need to find all widgets that
	// are inheriting from it and redefine all of them so that they inherit from
	// the new version of this widget. We're essentially trying to replace one
	// level in the prototype chain.
	if ( existingConstructor ) {
		$.each( existingConstructor._childConstructors, function( i, child ) {
			var childPrototype = child.prototype;

			// redefine the child widget using the same prototype that was
			// originally used, but inherit from the new version of the base
			$.widget( childPrototype.namespace + "." + childPrototype.widgetName, constructor, child._proto );
		});
		// remove the list of existing child constructors from the old constructor
		// so the old child constructors can be garbage collected
		delete existingConstructor._childConstructors;
	} else {
		base._childConstructors.push( constructor );
	}

	$.widget.bridge( name, constructor );
};

$.widget.extend = function( target ) {
	var input = slice.call( arguments, 1 ),
		inputIndex = 0,
		inputLength = input.length,
		key,
		value;
	for ( ; inputIndex < inputLength; inputIndex++ ) {
		for ( key in input[ inputIndex ] ) {
			value = input[ inputIndex ][ key ];
			if ( input[ inputIndex ].hasOwnProperty( key ) && value !== undefined ) {
				// Clone objects
				if ( $.isPlainObject( value ) ) {
					target[ key ] = $.isPlainObject( target[ key ] ) ?
						$.widget.extend( {}, target[ key ], value ) :
						// Don't extend strings, arrays, etc. with objects
						$.widget.extend( {}, value );
				// Copy everything else by reference
				} else {
					target[ key ] = value;
				}
			}
		}
	}
	return target;
};

$.widget.bridge = function( name, object ) {
	var fullName = object.prototype.widgetFullName || name;
	$.fn[ name ] = function( options ) {
		var isMethodCall = typeof options === "string",
			args = slice.call( arguments, 1 ),
			returnValue = this;

		// allow multiple hashes to be passed on init
		options = !isMethodCall && args.length ?
			$.widget.extend.apply( null, [ options ].concat(args) ) :
			options;

		if ( isMethodCall ) {
			this.each(function() {
				var methodValue,
					instance = $.data( this, fullName );
				if ( !instance ) {
					return $.error( "cannot call methods on " + name + " prior to initialization; " +
						"attempted to call method '" + options + "'" );
				}
				if ( !$.isFunction( instance[options] ) || options.charAt( 0 ) === "_" ) {
					return $.error( "no such method '" + options + "' for " + name + " widget instance" );
				}
				methodValue = instance[ options ].apply( instance, args );
				if ( methodValue !== instance && methodValue !== undefined ) {
					returnValue = methodValue && methodValue.jquery ?
						returnValue.pushStack( methodValue.get() ) :
						methodValue;
					return false;
				}
			});
		} else {
			this.each(function() {
				var instance = $.data( this, fullName );
				if ( instance ) {
					instance.option( options || {} )._init();
				} else {
					$.data( this, fullName, new object( options, this ) );
				}
			});
		}

		return returnValue;
	};
};

$.Widget = function( /* options, element */ ) {};
$.Widget._childConstructors = [];

$.Widget.prototype = {
	widgetName: "widget",
	widgetEventPrefix: "",
	defaultElement: "<div>",
	options: {
		disabled: false,

		// callbacks
		create: null
	},
	_createWidget: function( options, element ) {
		element = $( element || this.defaultElement || this )[ 0 ];
		this.element = $( element );
		this.uuid = uuid++;
		this.eventNamespace = "." + this.widgetName + this.uuid;
		this.options = $.widget.extend( {},
			this.options,
			this._getCreateOptions(),
			options );

		this.bindings = $();
		this.hoverable = $();
		this.focusable = $();

		if ( element !== this ) {
			$.data( element, this.widgetFullName, this );
			this._on( true, this.element, {
				remove: function( event ) {
					if ( event.target === element ) {
						this.destroy();
					}
				}
			});
			this.document = $( element.style ?
				// element within the document
				element.ownerDocument :
				// element is window or document
				element.document || element );
			this.window = $( this.document[0].defaultView || this.document[0].parentWindow );
		}

		this._create();
		this._trigger( "create", null, this._getCreateEventData() );
		this._init();
	},
	_getCreateOptions: $.noop,
	_getCreateEventData: $.noop,
	_create: $.noop,
	_init: $.noop,

	destroy: function() {
		this._destroy();
		// we can probably remove the unbind calls in 2.0
		// all event bindings should go through this._on()
		this.element
			.unbind( this.eventNamespace )
			// 1.9 BC for #7810
			// TODO remove dual storage
			.removeData( this.widgetName )
			.removeData( this.widgetFullName )
			// support: jquery <1.6.3
			// http://bugs.jquery.com/ticket/9413
			.removeData( $.camelCase( this.widgetFullName ) );
		this.widget()
			.unbind( this.eventNamespace )
			.removeAttr( "aria-disabled" )
			.removeClass(
				this.widgetFullName + "-disabled " +
				"ui-state-disabled" );

		// clean up events and states
		this.bindings.unbind( this.eventNamespace );
		this.hoverable.removeClass( "ui-state-hover" );
		this.focusable.removeClass( "ui-state-focus" );
	},
	_destroy: $.noop,

	widget: function() {
		return this.element;
	},

	option: function( key, value ) {
		var options = key,
			parts,
			curOption,
			i;

		if ( arguments.length === 0 ) {
			// don't return a reference to the internal hash
			return $.widget.extend( {}, this.options );
		}

		if ( typeof key === "string" ) {
			// handle nested keys, e.g., "foo.bar" => { foo: { bar: ___ } }
			options = {};
			parts = key.split( "." );
			key = parts.shift();
			if ( parts.length ) {
				curOption = options[ key ] = $.widget.extend( {}, this.options[ key ] );
				for ( i = 0; i < parts.length - 1; i++ ) {
					curOption[ parts[ i ] ] = curOption[ parts[ i ] ] || {};
					curOption = curOption[ parts[ i ] ];
				}
				key = parts.pop();
				if ( arguments.length === 1 ) {
					return curOption[ key ] === undefined ? null : curOption[ key ];
				}
				curOption[ key ] = value;
			} else {
				if ( arguments.length === 1 ) {
					return this.options[ key ] === undefined ? null : this.options[ key ];
				}
				options[ key ] = value;
			}
		}

		this._setOptions( options );

		return this;
	},
	_setOptions: function( options ) {
		var key;

		for ( key in options ) {
			this._setOption( key, options[ key ] );
		}

		return this;
	},
	_setOption: function( key, value ) {
		this.options[ key ] = value;

		if ( key === "disabled" ) {
			this.widget()
				.toggleClass( this.widgetFullName + "-disabled ui-state-disabled", !!value )
				.attr( "aria-disabled", value );
			this.hoverable.removeClass( "ui-state-hover" );
			this.focusable.removeClass( "ui-state-focus" );
		}

		return this;
	},

	enable: function() {
		return this._setOption( "disabled", false );
	},
	disable: function() {
		return this._setOption( "disabled", true );
	},

	_on: function( suppressDisabledCheck, element, handlers ) {
		var delegateElement,
			instance = this;

		// no suppressDisabledCheck flag, shuffle arguments
		if ( typeof suppressDisabledCheck !== "boolean" ) {
			handlers = element;
			element = suppressDisabledCheck;
			suppressDisabledCheck = false;
		}

		// no element argument, shuffle and use this.element
		if ( !handlers ) {
			handlers = element;
			element = this.element;
			delegateElement = this.widget();
		} else {
			// accept selectors, DOM elements
			element = delegateElement = $( element );
			this.bindings = this.bindings.add( element );
		}

		$.each( handlers, function( event, handler ) {
			function handlerProxy() {
				// allow widgets to customize the disabled handling
				// - disabled as an array instead of boolean
				// - disabled class as method for disabling individual parts
				if ( !suppressDisabledCheck &&
						( instance.options.disabled === true ||
							$( this ).hasClass( "ui-state-disabled" ) ) ) {
					return;
				}
				return ( typeof handler === "string" ? instance[ handler ] : handler )
					.apply( instance, arguments );
			}

			// copy the guid so direct unbinding works
			if ( typeof handler !== "string" ) {
				handlerProxy.guid = handler.guid =
					handler.guid || handlerProxy.guid || $.guid++;
			}

			var match = event.match( /^(\w+)\s*(.*)$/ ),
				eventName = match[1] + instance.eventNamespace,
				selector = match[2];
			if ( selector ) {
				delegateElement.delegate( selector, eventName, handlerProxy );
			} else {
				element.bind( eventName, handlerProxy );
			}
		});
	},

	_off: function( element, eventName ) {
		eventName = (eventName || "").split( " " ).join( this.eventNamespace + " " ) + this.eventNamespace;
		element.unbind( eventName ).undelegate( eventName );
	},

	_delay: function( handler, delay ) {
		function handlerProxy() {
			return ( typeof handler === "string" ? instance[ handler ] : handler )
				.apply( instance, arguments );
		}
		var instance = this;
		return setTimeout( handlerProxy, delay || 0 );
	},

	_hoverable: function( element ) {
		this.hoverable = this.hoverable.add( element );
		this._on( element, {
			mouseenter: function( event ) {
				$( event.currentTarget ).addClass( "ui-state-hover" );
			},
			mouseleave: function( event ) {
				$( event.currentTarget ).removeClass( "ui-state-hover" );
			}
		});
	},

	_focusable: function( element ) {
		this.focusable = this.focusable.add( element );
		this._on( element, {
			focusin: function( event ) {
				$( event.currentTarget ).addClass( "ui-state-focus" );
			},
			focusout: function( event ) {
				$( event.currentTarget ).removeClass( "ui-state-focus" );
			}
		});
	},

	_trigger: function( type, event, data ) {
		var prop, orig,
			callback = this.options[ type ];

		data = data || {};
		event = $.Event( event );
		event.type = ( type === this.widgetEventPrefix ?
			type :
			this.widgetEventPrefix + type ).toLowerCase();
		// the original event may come from any element
		// so we need to reset the target on the new event
		event.target = this.element[ 0 ];

		// copy original event properties over to the new event
		orig = event.originalEvent;
		if ( orig ) {
			for ( prop in orig ) {
				if ( !( prop in event ) ) {
					event[ prop ] = orig[ prop ];
				}
			}
		}

		this.element.trigger( event, data );
		return !( $.isFunction( callback ) &&
			callback.apply( this.element[0], [ event ].concat( data ) ) === false ||
			event.isDefaultPrevented() );
	}
};

$.each( { show: "fadeIn", hide: "fadeOut" }, function( method, defaultEffect ) {
	$.Widget.prototype[ "_" + method ] = function( element, options, callback ) {
		if ( typeof options === "string" ) {
			options = { effect: options };
		}
		var hasOptions,
			effectName = !options ?
				method :
				options === true || typeof options === "number" ?
					defaultEffect :
					options.effect || defaultEffect;
		options = options || {};
		if ( typeof options === "number" ) {
			options = { duration: options };
		}
		hasOptions = !$.isEmptyObject( options );
		options.complete = callback;
		if ( options.delay ) {
			element.delay( options.delay );
		}
		if ( hasOptions && $.effects && $.effects.effect[ effectName ] ) {
			element[ method ]( options );
		} else if ( effectName !== method && element[ effectName ] ) {
			element[ effectName ]( options.duration, options.easing, callback );
		} else {
			element.queue(function( next ) {
				$( this )[ method ]();
				if ( callback ) {
					callback.call( element[ 0 ] );
				}
				next();
			});
		}
	};
});

})( jQuery );

},{"jquery":"jquery"}],"bootstrap/button":[function(require,module,exports){
var $ = require("jquery");
/* ========================================================================
* Bootstrap: button.js v3.1.1
* http://getbootstrap.com/javascript/#buttons
* ========================================================================
* Copyright 2011-2014 Twitter, Inc.
* Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
* ======================================================================== */

'use strict';

// BUTTON PUBLIC CLASS DEFINITION
// ==============================

var Button = function (element, options) {
  this.$element  = $(element)
  this.options   = $.extend({}, Button.DEFAULTS, options)
  this.isLoading = false
}

Button.DEFAULTS = {
  loadingText: 'loading...'
}

Button.prototype.setState = function (state) {
  var d    = 'bk-bs-disabled'
  var $el  = this.$element
  var val  = $el.is('input') ? 'val' : 'html'
  var data = $el.data()

  state = state + 'Text'

  if (!data.resetText) $el.data('resetText', $el[val]())

  $el[val](data[state] || this.options[state])

  // push to event loop to allow forms to submit
  setTimeout($.proxy(function () {
    if (state == 'loadingText') {
      this.isLoading = true
      $el.addClass(d).attr(d, d)
    } else if (this.isLoading) {
      this.isLoading = false
      $el.removeClass(d).removeAttr(d)
    }
  }, this), 0)
}

Button.prototype.toggle = function () {
  var changed = true
  var $parent = this.$element.closest('[data-bk-bs-toggle="buttons"]')

  if ($parent.length) {
    var $input = this.$element.find('input')
    if ($input.prop('type') == 'radio') {
      if ($input.prop('checked') && this.$element.hasClass('bk-bs-active')) changed = false
      else $parent.find('.bk-bs-active').removeClass('bk-bs-active')
    }
    if (changed) $input.prop('checked', !this.$element.hasClass('bk-bs-active')).trigger('change')
  }

  if (changed) this.$element.toggleClass('bk-bs-active')
}


// BUTTON PLUGIN DEFINITION
// ========================

var old = $.fn.button

$.fn.button = function (option) {
  return this.each(function () {
    var $this   = $(this)
    var data    = $this.data('bk-bs.button')
    var options = typeof option == 'object' && option

    if (!data) $this.data('bk-bs.button', (data = new Button(this, options)))

    if (option == 'toggle') data.toggle()
    else if (option) data.setState(option)
  })
}

$.fn.button.Constructor = Button


// BUTTON NO CONFLICT
// ==================

$.fn.button.noConflict = function () {
  $.fn.button = old
  return this
}


// BUTTON DATA-API
// ===============

$(document).on('click.bk-bs.button.data-api', '[data-bk-bs-toggle^=button]', function (e) {
  var $btn = $(e.target)
  if (!$btn.hasClass('bk-bs-btn')) $btn = $btn.closest('.bk-bs-btn')
  $btn.button('toggle')
  e.preventDefault()
})

},{"jquery":"jquery"}],"bootstrap/dropdown":[function(require,module,exports){
var $ = require("jquery");

/* ========================================================================
 * Bootstrap: dropdown.js v3.1.1
 * http://getbootstrap.com/javascript/#dropdowns
 * ========================================================================
 * Copyright 2011-2014 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */

'use strict';

// DROPDOWN CLASS DEFINITION
// =========================

var backdrop = '.bk-bs-dropdown-backdrop'
var toggle   = '[data-bk-bs-toggle=dropdown]'
var Dropdown = function (element) {
  $(element).on('click.bk-bs.dropdown', this.toggle)
}

Dropdown.prototype.toggle = function (e) {
  var $this = $(this)

  if ($this.is('.bk-bs-disabled, :disabled')) return

  var $parent  = getParent($this)
  var isActive = $parent.hasClass('bk-bs-open')

  clearMenus()

  if (!isActive) {
    if ('ontouchstart' in document.documentElement && !$parent.closest('.bk-bs-navbar-nav').length) {
      // if mobile we use a backdrop because click events don't delegate
      $('<div class="bk-bs-dropdown-backdrop"/>').insertAfter($(this)).on('click', clearMenus)
    }

    var relatedTarget = { relatedTarget: this }
    $parent.trigger(e = $.Event('show.bk-bs.dropdown', relatedTarget))

    if (e.isDefaultPrevented()) return

    $parent
      .toggleClass('bk-bs-open')
      .trigger('shown.bk-bs.dropdown', relatedTarget)

    $this.focus()
  }

  return false
}

Dropdown.prototype.keydown = function (e) {
  if (!/(38|40|27)/.test(e.keyCode)) return

  var $this = $(this)

  e.preventDefault()
  e.stopPropagation()

  if ($this.is('.bk-bs-disabled, :disabled')) return

  var $parent  = getParent($this)
  var isActive = $parent.hasClass('bk-bs-open')

  if (!isActive || (isActive && e.keyCode == 27)) {
    if (e.which == 27) $parent.find(toggle).focus()
    return $this.click()
  }

  var desc = ' li:not(.bk-bs-divider):visible a'
  var $items = $parent.find('[role=menu]' + desc + ', [role=listbox]' + desc)

  if (!$items.length) return

  var index = $items.index($items.filter(':focus'))

  if (e.keyCode == 38 && index > 0)                 index--                        // up
  if (e.keyCode == 40 && index < $items.length - 1) index++                        // down
  if (!~index)                                      index = 0

  $items.eq(index).focus()
}

function clearMenus(e) {
  $(backdrop).remove()
  $(toggle).each(function () {
    var $parent = getParent($(this))
    var relatedTarget = { relatedTarget: this }
    if (!$parent.hasClass('bk-bs-open')) return
    $parent.trigger(e = $.Event('hide.bk-bs.dropdown', relatedTarget))
    if (e.isDefaultPrevented()) return
    $parent.removeClass('bk-bs-open').trigger('hidden.bk-bs.dropdown', relatedTarget)
  })
}

function getParent($this) {
  var selector = $this.attr('data-bk-bs-target')

  if (!selector) {
    selector = $this.attr('href')
    selector = selector && /#[A-Za-z]/.test(selector) && selector.replace(/.*(?=#[^\s]*$)/, '') //strip for ie7
  }

  var $parent = selector && $(selector)

  return $parent && $parent.length ? $parent : $this.parent()
}


// DROPDOWN PLUGIN DEFINITION
// ==========================

var old = $.fn.dropdown

$.fn.dropdown = function (option) {
  return this.each(function () {
    var $this = $(this)
    var data  = $this.data('bk-bs.dropdown')

    if (!data) $this.data('bk-bs.dropdown', (data = new Dropdown(this)))
    if (typeof option == 'string') data[option].call($this)
  })
}

$.fn.dropdown.Constructor = Dropdown


// DROPDOWN NO CONFLICT
// ====================

$.fn.dropdown.noConflict = function () {
  $.fn.dropdown = old
  return this
}


// APPLY TO STANDARD DROPDOWN ELEMENTS
// ===================================

$(document)
  .on('click.bk-bs.dropdown.data-api', clearMenus)
  .on('click.bk-bs.dropdown.data-api', '.bk-bs-dropdown form', function (e) { e.stopPropagation() })
  .on('click.bk-bs.dropdown.data-api', toggle, Dropdown.prototype.toggle)
  .on('keydown.bk-bs.dropdown.data-api', toggle + ', [role=menu], [role=listbox]', Dropdown.prototype.keydown)

},{"jquery":"jquery"}],"bootstrap/tab":[function(require,module,exports){
var $ = require("jquery");
/* ========================================================================
 * Bootstrap: tab.js v3.1.1
 * http://getbootstrap.com/javascript/#tabs
 * ========================================================================
 * Copyright 2011-2014 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */

'use strict';

// TAB CLASS DEFINITION
// ====================

var Tab = function (element) {
  this.element = $(element)
}

Tab.prototype.show = function () {
  var $this    = this.element
  var $ul      = $this.closest('ul:not(.bk-bs-dropdown-menu)')
  var selector = $this.data('bk-bs-target')

  if (!selector) {
    selector = $this.attr('href')
    selector = selector && selector.replace(/.*(?=#[^\s]*$)/, '') //strip for ie7
  }

  if ($this.parent('li').hasClass('bk-bs-active')) return

  var previous = $ul.find('.bk-bs-active:last a')[0]
  var e        = $.Event('show.bk-bs.tab', {
    relatedTarget: previous
  })

  $this.trigger(e)

  if (e.isDefaultPrevented()) return

  var $target = $(selector)

  this.activate($this.parent('li'), $ul)
  this.activate($target, $target.parent(), function () {
    $this.trigger({
      type: 'shown.bk-bs.tab',
      relatedTarget: previous
    })
  })
}

Tab.prototype.activate = function (element, container, callback) {
  var $active    = container.find('> .bk-bs-active')
  var transition = callback
    && $.support.transition
    && $active.hasClass('bk-bs-fade')

  function next() {
    $active
      .removeClass('bk-bs-active')
      .find('> .bk-bs-dropdown-menu > .bk-bs-active')
      .removeClass('bk-bs-active')

    element.addClass('bk-bs-active')

    if (transition) {
      element[0].offsetWidth // reflow for transition
      element.addClass('bk-bs-in')
    } else {
      element.removeClass('bk-bs-fade')
    }

    if (element.parent('.bk-bs-dropdown-menu')) {
      element.closest('li.bk-bs-dropdown').addClass('bk-bs-active')
    }

    callback && callback()
  }

  transition ?
    $active
      .one($.support.transition.end, next)
      .emulateTransitionEnd(150) :
    next()

  $active.removeClass('bk-bs-in')
}


// TAB PLUGIN DEFINITION
// =====================

var old = $.fn.tab

$.fn.tab = function ( option ) {
  return this.each(function () {
    var $this = $(this)
    var data  = $this.data('bk-bs.tab')

    if (!data) $this.data('bk-bs.tab', (data = new Tab(this)))
    if (typeof option == 'string') data[option]()
  })
}

$.fn.tab.Constructor = Tab


// TAB NO CONFLICT
// ===============

$.fn.tab.noConflict = function () {
  $.fn.tab = old
  return this
}


// TAB DATA-API
// ============

$(document).on('click.bk-bs.tab.data-api', '[data-bk-bs-toggle="tab"], [data-bk-bs-toggle="pill"]', function (e) {
  e.preventDefault()
  $(this).tab('show')
})

},{"jquery":"jquery"}],"jqrangeslider/jQDateRangeSlider":[function(require,module,exports){
/**
 * jQRangeSlider
 * A javascript slider selector that supports dates
 *
 * Copyright (C) Guillaume Gautreau 2012
 * Dual licensed under the MIT or GPL Version 2 licenses.
 *
 */

var $ = require("jquery");
require("./jQRangeSlider");
"use strict";

module.exports = $.widget("ui.dateRangeSlider", $.ui.rangeSlider, {
	options: {
		bounds: {min: new Date(2010,0,1).valueOf(), max: new Date(2012,0,1).valueOf()},
		defaultValues: {min: new Date(2010,1,11).valueOf(), max: new Date(2011,1,11).valueOf()}
	},

	_create: function(){
		$.ui.rangeSlider.prototype._create.apply(this);

		this.element.addClass("bk-ui-dateRangeSlider");
	},

	destroy: function(){
		this.element.removeClass("bk-ui-dateRangeSlider");
		$.ui.rangeSlider.prototype.destroy.apply(this);
	},

	_setDefaultValues: function(){
		this._values = {
			min: this.options.defaultValues.min.valueOf(),
			max: this.options.defaultValues.max.valueOf()
		};
	},

	_setRulerParameters: function(){
		this.ruler.ruler({
			min: new Date(this.options.bounds.min),
			max: new Date(this.options.bounds.max),
			scales: this.options.scales
		});
	},

	_setOption: function(key, value){
		if ((key === "defaultValues" || key === "bounds") && typeof value !== "undefined" && value !== null && this._isValidDate(value.min) && this._isValidDate(value.max)){
			$.ui.rangeSlider.prototype._setOption.apply(this, [key, {min:value.min.valueOf(), max:value.max.valueOf()}]);
		}else{
			$.ui.rangeSlider.prototype._setOption.apply(this, this._toArray(arguments));
		}
	},

	_handleType: function(){
		return "dateRangeSliderHandle";
	},

	option: function(key){
		if (key === "bounds" || key === "defaultValues"){
			var result = $.ui.rangeSlider.prototype.option.apply(this, arguments);

			return {min:new Date(result.min), max:new Date(result.max)};
		}

		return $.ui.rangeSlider.prototype.option.apply(this, this._toArray(arguments));
	},

	_defaultFormatter: function(value){
		var month = value.getMonth() + 1,
			day = value.getDate();

		return "" + value.getFullYear() + "-" + (month < 10 ? "0" + month : month) + "-" + (day < 10 ? "0" + day : day);
	},

	_getFormatter: function(){
		var formatter = this.options.formatter;

		if (this.options.formatter === false || this.options.formatter === null){
			formatter = this._defaultFormatter;
		}

		return (function(formatter){
			return function(value){
				return formatter(new Date(value));
			}
		}(formatter));
	},

	values: function(min, max){
		var values = null;

		if (this._isValidDate(min) && this._isValidDate(max))
		{
			values = $.ui.rangeSlider.prototype.values.apply(this, [min.valueOf(), max.valueOf()]);
		}else{
			values = $.ui.rangeSlider.prototype.values.apply(this, this._toArray(arguments));
		}

		return {min: new Date(values.min), max: new Date(values.max)};
	},

	min: function(min){
		if (this._isValidDate(min)){
			return new Date($.ui.rangeSlider.prototype.min.apply(this, [min.valueOf()]));
		}

		return new Date($.ui.rangeSlider.prototype.min.apply(this));
	},

	max: function(max){
		if (this._isValidDate(max)){
			return new Date($.ui.rangeSlider.prototype.max.apply(this, [max.valueOf()]));
		}

		return new Date($.ui.rangeSlider.prototype.max.apply(this));
	},

	bounds: function(min, max){
		var result;

		if (this._isValidDate(min) && this._isValidDate(max)) {
			result = $.ui.rangeSlider.prototype.bounds.apply(this, [min.valueOf(), max.valueOf()]);
		} else {
			result = $.ui.rangeSlider.prototype.bounds.apply(this, this._toArray(arguments));
		}

		return {min: new Date(result.min), max: new Date(result.max)};
	},

	_isValidDate: function(value){
		return typeof value !== "undefined" && value instanceof Date;
	},

	_toArray: function(argsObject){
		return Array.prototype.slice.call(argsObject);
	}
});

},{"./jQRangeSlider":"jqrangeslider/jQRangeSlider","jquery":"jquery"}],"jqrangeslider/jQRangeSlider":[function(require,module,exports){
/**
 * jQRangeSlider
 * A javascript slider selector that supports dates
 *
 * Copyright (C) Guillaume Gautreau 2012
 * Dual licensed under the MIT or GPL Version 2 licenses.
 *
 */

var $ = require("jquery");
require("jquery-ui/core");
require("jquery-ui/widget");
require("jquery-ui/mouse");
require("jquery-mousewheel");
"use strict";

module.exports = $.widget("ui.rangeSlider", {
	options: {
		bounds: {min:0, max:100},
		defaultValues: {min:20, max:50},
		wheelMode: null,
		wheelSpeed: 4,
		arrows: true,
		valueLabels: "show",
		formatter: null,
		durationIn: 0,
		durationOut: 400,
		delayOut: 200,
		range: {min: false, max: false},
		step: false,
		scales: false,
		enabled: true,
		symmetricPositionning: false
	},

	_values: null,
	_valuesChanged: false,
	_initialized: false,

	// Created elements
	bar: null,
	leftHandle: null,
	rightHandle: null,
	innerBar: null,
	container: null,
	arrows: null,
	labels: null,
	changing: {min:false, max:false},
	changed: {min:false, max:false},
	ruler: null,

	_create: function(){
		this._setDefaultValues();

		this.labels = {left: null, right:null, leftDisplayed:true, rightDisplayed:true};
		this.arrows = {left:null, right:null};
		this.changing = {min:false, max:false};
		this.changed = {min:false, max:false};

		this._createElements();

		this._bindResize();

		setTimeout($.proxy(this.resize, this), 1);
		setTimeout($.proxy(this._initValues, this), 1);
	},

	_setDefaultValues: function(){
		this._values = {
			min: this.options.defaultValues.min,
			max: this.options.defaultValues.max
		};
	},

	_bindResize: function(){
		var that = this;

		this._resizeProxy = function(e){
			that.resize(e);
		};

		$(window).resize(this._resizeProxy);
	},

	_initWidth: function(){
		this.container.css("width", this.element.width() - this.container.outerWidth(true) + this.container.width());
		this.innerBar.css("width", this.container.width() - this.innerBar.outerWidth(true) + this.innerBar.width());
	},

	_initValues: function(){
		this._initialized = true;
		this.values(this._values.min, this._values.max);
	},

	_setOption: function(key, value) {
		this._setWheelOption(key, value);
		this._setArrowsOption(key, value);
		this._setLabelsOption(key, value);
		this._setLabelsDurations(key, value);
		this._setFormatterOption(key, value);
		this._setBoundsOption(key, value);
		this._setRangeOption(key, value);
		this._setStepOption(key, value);
		this._setScalesOption(key, value);
		this._setEnabledOption(key, value);
		this._setPositionningOption(key, value);
	},

	_validProperty: function(object, name, defaultValue){
		if (object === null || typeof object[name] === "undefined"){
			return defaultValue;
		}

		return object[name];
	},

	_setStepOption: function(key, value){
		if (key === "step"){
			this.options.step = value;
			this._leftHandle("option", "step", value);
			this._rightHandle("option", "step", value);
			this._changed(true);
		}
	},

	_setScalesOption: function(key, value){
		if (key === "scales"){
			if (value === false || value === null){
				this.options.scales = false;
				this._destroyRuler();
			}else if (value instanceof Array){
				this.options.scales = value;
				this._updateRuler();
			}
		}
	},

	_setRangeOption: function(key, value){
		if (key === "range"){
			this._bar("option", "range", value);
			this.options.range = this._bar("option", "range");
			this._changed(true);
		}
	},

	_setBoundsOption: function(key, value){
		if (key === "bounds" && typeof value.min !== "undefined" && typeof value.max !== "undefined"){
			this.bounds(value.min, value.max);
		}
	},

	_setWheelOption: function(key, value){
		if (key === "wheelMode" || key === "wheelSpeed"){
			this._bar("option", key, value);
			this.options[key] = this._bar("option", key);
		}
	},

	_setLabelsOption: function(key, value){
		if (key === "valueLabels"){
			if (value !== "hide" && value !== "show" && value !== "change"){
				return;
			}

			this.options.valueLabels = value;

			if (value !== "hide"){
				this._createLabels();
				this._leftLabel("update");
				this._rightLabel("update");
			}else{
				this._destroyLabels();
			}
		}
	},

	_setFormatterOption: function(key, value){
		if (key === "formatter" && value !== null && typeof value === "function"){
			if (this.options.valueLabels !== "hide"){
				this._leftLabel("option", "formatter", value);
				this.options.formatter = this._rightLabel("option", "formatter", value);
			}
		}
	},

	_setArrowsOption: function(key, value){
		if (key === "arrows" && (value === true || value === false) && value !== this.options.arrows){
			if (value === true){
				this.element
					.removeClass("bk-ui-rangeSlider-noArrow")
					.addClass("bk-ui-rangeSlider-withArrows");
				this.arrows.left.css("display", "block");
				this.arrows.right.css("display", "block");
				this.options.arrows = true;
			}else if (value === false){
				this.element
					.addClass("bk-ui-rangeSlider-noArrow")
					.removeClass("bk-ui-rangeSlider-withArrows");
				this.arrows.left.css("display", "none");
				this.arrows.right.css("display", "none");
				this.options.arrows = false;
			}

			this._initWidth();
		}
	},

	_setLabelsDurations: function(key, value){
		if (key === "durationIn" || key === "durationOut" || key === "delayOut"){
			if (parseInt(value, 10) !== value) return;

			if (this.labels.left !== null){
				this._leftLabel("option", key, value);
			}

			if (this.labels.right !== null){
				this._rightLabel("option", key, value);
			}

			this.options[key] = value;
		}
	},

	_setEnabledOption: function(key, value){
		if (key === "enabled"){
			this.toggle(value);
		}
	},

	_setPositionningOption: function(key, value){
		if (key === "symmetricPositionning"){
			this._rightHandle("option", key, value);
			this.options[key] = this._leftHandle("option", key, value);
		}
	},

	_createElements: function(){
		if (this.element.css("position") !== "absolute"){
			this.element.css("position", "relative");
		}

		this.element.addClass("bk-ui-rangeSlider");

		this.container = $("<div class='bk-ui-rangeSlider-container' />")
			.css("position", "absolute")
			.appendTo(this.element);

		this.innerBar = $("<div class='bk-ui-rangeSlider-innerBar' />")
			.css("position", "absolute")
			.css("top", 0)
			.css("left", 0);

		this._createHandles();
		this._createBar();
		this.container.prepend(this.innerBar);
		this._createArrows();

		if (this.options.valueLabels !== "hide"){
			this._createLabels();
		}else{
			this._destroyLabels();
		}

		this._updateRuler();

		if (!this.options.enabled) this._toggle(this.options.enabled);
	},

	_createHandle: function(options){
		return $("<div />")
			[this._handleType()](options)
			.bind("sliderDrag", $.proxy(this._changing, this))
			.bind("stop", $.proxy(this._changed, this));
	},

	_createHandles: function(){
		this.leftHandle = this._createHandle({
				isLeft: true,
				bounds: this.options.bounds,
				value: this._values.min,
				step: this.options.step,
				symmetricPositionning: this.options.symmetricPositionning
		}).appendTo(this.container);

		this.rightHandle = this._createHandle({
			isLeft: false,
			bounds: this.options.bounds,
			value: this._values.max,
			step: this.options.step,
			symmetricPositionning: this.options.symmetricPositionning
		}).appendTo(this.container);
	},

	_createBar: function(){
		this.bar = $("<div />")
			.prependTo(this.container)
			.bind("sliderDrag scroll zoom", $.proxy(this._changing, this))
			.bind("stop", $.proxy(this._changed, this));

		this._bar({
				leftHandle: this.leftHandle,
				rightHandle: this.rightHandle,
				values: {min: this._values.min, max: this._values.max},
				type: this._handleType(),
				range: this.options.range,
				wheelMode: this.options.wheelMode,
				wheelSpeed: this.options.wheelSpeed
			});

		this.options.range = this._bar("option", "range");
		this.options.wheelMode = this._bar("option", "wheelMode");
		this.options.wheelSpeed = this._bar("option", "wheelSpeed");
	},

	_createArrows: function(){
		this.arrows.left = this._createArrow("left");
		this.arrows.right = this._createArrow("right");

		if (!this.options.arrows){
			this.arrows.left.css("display", "none");
			this.arrows.right.css("display", "none");
			this.element.addClass("bk-ui-rangeSlider-noArrow");
		}else{
			this.element.addClass("bk-ui-rangeSlider-withArrows");
		}
	},

	_createArrow: function(whichOne){
		var arrow = $("<div class='bk-ui-rangeSlider-arrow' />")
			.append("<div class='bk-ui-rangeSlider-arrow-inner' />")
			.addClass("bk-ui-rangeSlider-" + whichOne + "Arrow")
			.css("position", "absolute")
			.css(whichOne, 0)
			.appendTo(this.element),
			target;

		if (whichOne === "right"){
			target = $.proxy(this._scrollRightClick, this);
		}else{
			target = $.proxy(this._scrollLeftClick, this);
		}

		arrow.bind("mousedown touchstart", target);

		return arrow;
	},

	_proxy: function(element, type, args){
		var array = Array.prototype.slice.call(args);

		if (element && element[type]){
			return element[type].apply(element, array);
		}

		return null;
	},

	_handleType: function(){
		return "rangeSliderHandle";
	},

	_barType: function(){
		return "rangeSliderBar";
	},

	_bar: function(){
		return this._proxy(this.bar, this._barType(), arguments);
	},

	_labelType: function(){
		return "rangeSliderLabel";
	},

	_leftLabel: function(){
		return this._proxy(this.labels.left, this._labelType(), arguments);
	},

	_rightLabel: function(){
		return this._proxy(this.labels.right, this._labelType(), arguments);
	},

	_leftHandle: function(){
		return this._proxy(this.leftHandle, this._handleType(), arguments);
	},

	_rightHandle: function(){
		return this._proxy(this.rightHandle, this._handleType(), arguments);
	},

	_getValue: function(position, handle){
		if (handle === this.rightHandle){
			position = position - handle.outerWidth();
		}

		return position * (this.options.bounds.max - this.options.bounds.min) / (this.container.innerWidth() - handle.outerWidth(true)) + this.options.bounds.min;
	},

	_trigger: function(eventName){
		var that = this;

		setTimeout(function(){
			that.element.trigger(eventName, {
					label: that.element,
					values: that.values()
				});
		}, 1);
	},

	_changing: function(){
		if(this._updateValues()){
			this._trigger("valuesChanging");
			this._valuesChanged = true;
		}
	},

	_deactivateLabels: function(){
		if (this.options.valueLabels === "change"){
			this._leftLabel("option", "show", "hide");
			this._rightLabel("option", "show", "hide");
		}
	},

	_reactivateLabels: function(){
		if (this.options.valueLabels === "change"){
			this._leftLabel("option", "show", "change");
			this._rightLabel("option", "show", "change");
		}
	},

	_changed: function(isAutomatic){
		if (isAutomatic === true){
			this._deactivateLabels();
		}

		if (this._updateValues() || this._valuesChanged){
			this._trigger("valuesChanged");

			if (isAutomatic !== true){
				this._trigger("userValuesChanged");
			}

			this._valuesChanged = false;
		}

		if (isAutomatic === true){
			this._reactivateLabels();
		}
	},

	_updateValues: function(){
		var left = this._leftHandle("value"),
			right = this._rightHandle("value"),
			min = this._min(left, right),
			max = this._max(left, right),
			changing = (min !== this._values.min || max !== this._values.max);

		this._values.min = this._min(left, right);
		this._values.max = this._max(left, right);

		return changing;
	},

	_min: function(value1, value2){
		return Math.min(value1, value2);
	},

	_max: function(value1, value2){
		return Math.max(value1, value2);
	},

	/*
	 * Value labels
	 */
	_createLabel: function(label, handle){
		var params;

		if (label === null){
			params = this._getLabelConstructorParameters(label, handle);
			label = $("<div />")
				.appendTo(this.element)
				[this._labelType()](params);
		}else{
			params = this._getLabelRefreshParameters(label, handle);

			label[this._labelType()](params);
		}

		return label;
	},

	_getLabelConstructorParameters: function(label, handle){
		return {
			handle: handle,
			handleType: this._handleType(),
			formatter: this._getFormatter(),
			show: this.options.valueLabels,
			durationIn: this.options.durationIn,
			durationOut: this.options.durationOut,
			delayOut: this.options.delayOut
		};
	},

	_getLabelRefreshParameters: function(){
		return {
			formatter: this._getFormatter(),
			show: this.options.valueLabels,
			durationIn: this.options.durationIn,
			durationOut: this.options.durationOut,
			delayOut: this.options.delayOut
		};
	},

	_getFormatter: function(){
		if (this.options.formatter === false || this.options.formatter === null){
			return this._defaultFormatter;
		}

		return this.options.formatter;
	},

	_defaultFormatter: function(value){
		return Math.round(value);
	},

	_destroyLabel: function(label){
		if (label !== null){
			label[this._labelType()]("destroy");
			label.remove();
			label = null;
		}

		return label;
	},

	_createLabels: function(){
		this.labels.left = this._createLabel(this.labels.left, this.leftHandle);
		this.labels.right = this._createLabel(this.labels.right, this.rightHandle);

		this._leftLabel("pair", this.labels.right);
	},

	_destroyLabels: function(){
		this.labels.left = this._destroyLabel(this.labels.left);
		this.labels.right = this._destroyLabel(this.labels.right);
	},

	/*
	 * Scrolling
	 */
	_stepRatio: function(){
		return this._leftHandle("stepRatio");
	},

	_scrollRightClick: function(e){
		if (!this.options.enabled) return false;

		e.preventDefault();
		this._bar("startScroll");
		this._bindStopScroll();

		this._continueScrolling("scrollRight", 4 * this._stepRatio(), 1);
	},

	_continueScrolling: function(action, timeout, quantity, timesBeforeSpeedingUp){
		if (!this.options.enabled) return false;

		this._bar(action, quantity);
		timesBeforeSpeedingUp = timesBeforeSpeedingUp || 5;
		timesBeforeSpeedingUp--;

		var that = this,
			minTimeout = 16,
			maxQuantity = Math.max(1, 4 / this._stepRatio());

		this._scrollTimeout = setTimeout(function(){
			if (timesBeforeSpeedingUp === 0){
				if (timeout > minTimeout){
					timeout = Math.max(minTimeout, timeout / 1.5);
				} else {
					quantity = Math.min(maxQuantity, quantity * 2);
				}

				timesBeforeSpeedingUp = 5;
			}

			that._continueScrolling(action, timeout, quantity, timesBeforeSpeedingUp);
		}, timeout);
	},

	_scrollLeftClick: function(e){
		if (!this.options.enabled) return false;

		e.preventDefault();

		this._bar("startScroll");
		this._bindStopScroll();

		this._continueScrolling("scrollLeft", 4 * this._stepRatio(), 1);
	},

	_bindStopScroll: function(){
		var that = this;
		this._stopScrollHandle = function(e){
			e.preventDefault();
			that._stopScroll();
		};

		$(document).bind("mouseup touchend", this._stopScrollHandle);
	},

	_stopScroll: function(){
		$(document).unbind("mouseup touchend", this._stopScrollHandle);
		this._stopScrollHandle = null;
		this._bar("stopScroll");
		clearTimeout(this._scrollTimeout);
	},

	/*
	 * Ruler
	 */
	_createRuler: function(){
		this.ruler = $("<div class='bk-ui-rangeSlider-ruler' />").appendTo(this.innerBar);
	},

	_setRulerParameters: function(){
		this.ruler.ruler({
			min: this.options.bounds.min,
			max: this.options.bounds.max,
			scales: this.options.scales
		});
	},

	_destroyRuler: function(){
		if (this.ruler !== null && $.fn.ruler){
			this.ruler.ruler("destroy");
			this.ruler.remove();
			this.ruler = null;
		}
	},

	_updateRuler: function(){
		this._destroyRuler();

		if (this.options.scales === false || !$.fn.ruler){
			return;
		}

		this._createRuler();
		this._setRulerParameters();
	},

	/*
	 * Public methods
	 */
	values: function(min, max){
		var val;

		if (typeof min !== "undefined" && typeof max !== "undefined"){
			if (!this._initialized){
				this._values.min = min;
				this._values.max = max;
				return this._values;
			}

			this._deactivateLabels();
			val = this._bar("values", min, max);
			this._changed(true);
			this._reactivateLabels();
		}else{
			val = this._bar("values", min, max);
		}

		return val;
	},

	min: function(min){
		this._values.min = this.values(min, this._values.max).min;

		return this._values.min;
	},

	max: function(max){
		this._values.max = this.values(this._values.min, max).max;

		return this._values.max;
	},

	bounds: function(min, max){
		if (this._isValidValue(min) && this._isValidValue(max) && min < max){

			this._setBounds(min, max);
			this._updateRuler();
			this._changed(true);
		}

		return this.options.bounds;
	},

	_isValidValue: function(value){
		return typeof value !== "undefined" && parseFloat(value) === value;
	},

	_setBounds: function(min, max){
		this.options.bounds = {min: min, max: max};
		this._leftHandle("option", "bounds", this.options.bounds);
		this._rightHandle("option", "bounds", this.options.bounds);
		this._bar("option", "bounds", this.options.bounds);
	},

	zoomIn: function(quantity){
		this._bar("zoomIn", quantity)
	},

	zoomOut: function(quantity){
		this._bar("zoomOut", quantity);
	},

	scrollLeft: function(quantity){
		this._bar("startScroll");
		this._bar("scrollLeft", quantity);
		this._bar("stopScroll");
	},

	scrollRight: function(quantity){
		this._bar("startScroll");
		this._bar("scrollRight", quantity);
		this._bar("stopScroll");
	},

	/**
	 * Resize
	 */
	resize: function(){
		this._initWidth();
		this._leftHandle("update");
		this._rightHandle("update");
		this._bar("update");
	},

	/*
	 * Enable / disable
	 */
	enable: function(){
		this.toggle(true);
	},

	disable: function(){
		this.toggle(false);
	},

	toggle: function(enabled){
		if (enabled === undefined) enabled = !this.options.enabled;

		if (this.options.enabled !== enabled){
			this._toggle(enabled);
		}
	},

	_toggle: function(enabled){
		this.options.enabled = enabled;
		this.element.toggleClass("bk-ui-rangeSlider-disabled", !enabled);

		var action = enabled ? "enable" : "disable";

		this._bar(action);
		this._leftHandle(action);
		this._rightHandle(action);
		this._leftLabel(action);
		this._rightLabel(action);
	},

	/*
	 * Destroy
	 */
	destroy: function(){
		this.element.removeClass("bk-ui-rangeSlider-withArrows bk-ui-rangeSlider-noArrow bk-ui-rangeSlider-disabled");

		this._destroyWidgets();
		this._destroyElements();

		this.element.removeClass("bk-ui-rangeSlider");
		this.options = null;

		$(window).unbind("resize", this._resizeProxy);
		this._resizeProxy = null;
		this._bindResize = null;

		$.Widget.prototype.destroy.apply(this, arguments);
	},

	_destroyWidget: function(name){
		this["_" + name]("destroy");
		this[name].remove();
		this[name] = null;
	},

	_destroyWidgets: function(){
		this._destroyWidget("bar");
		this._destroyWidget("leftHandle");
		this._destroyWidget("rightHandle");

		this._destroyRuler();
		this._destroyLabels();
	},

	_destroyElements: function(){
		this.container.remove();
		this.container = null;

		this.innerBar.remove();
		this.innerBar = null;

		this.arrows.left.remove();
		this.arrows.right.remove();
		this.arrows = null;
	}
});

},{"jquery":"jquery","jquery-mousewheel":"jquery-mousewheel","jquery-ui/core":"jquery-ui/core","jquery-ui/mouse":"jquery-ui/mouse","jquery-ui/widget":"jquery-ui/widget"}],"jquery_event_drag":[function(require,module,exports){
/*!
 * jquery.event.drag - v 2.2
 * Copyright (c) 2010 Three Dub Media - http://threedubmedia.com
 * Open Source MIT License - http://threedubmedia.com/code/license
 */
// Created: 2008-06-04
// Updated: 2012-05-21
// REQUIRES: jquery 1.7.x

var $ = require("jquery");

// add the jquery instance method
$.fn.drag = function( str, arg, opts ){
	// figure out the event type
	var type = typeof str == "string" ? str : "",
	// figure out the event handler...
	fn = $.isFunction( str ) ? str : $.isFunction( arg ) ? arg : null;
	// fix the event type
	if ( type.indexOf("drag") !== 0 )
		type = "drag"+ type;
	// were options passed
	opts = ( str == fn ? arg : opts ) || {};
	// trigger or bind event handler
	return fn ? this.bind( type, opts, fn ) : this.trigger( type );
};

// local refs (increase compression)
var $event = $.event,
$special = $event.special,
// configure the drag special event
drag = $special.drag = {

	// these are the default settings
	defaults: {
		which: 1, // mouse button pressed to start drag sequence
		distance: 0, // distance dragged before dragstart
		not: ':input', // selector to suppress dragging on target elements
		handle: null, // selector to match handle target elements
		relative: false, // true to use "position", false to use "offset"
		drop: true, // false to suppress drop events, true or selector to allow
		click: false // false to suppress click events after dragend (no proxy)
	},

	// the key name for stored drag data
	datakey: "dragdata",

	// prevent bubbling for better performance
	noBubble: true,

	// count bound related events
	add: function( obj ){
		// read the interaction data
		var data = $.data( this, drag.datakey ),
		// read any passed options
		opts = obj.data || {};
		// count another realted event
		data.related += 1;
		// extend data options bound with this event
		// don't iterate "opts" in case it is a node
		$.each( drag.defaults, function( key, def ){
			if ( opts[ key ] !== undefined )
				data[ key ] = opts[ key ];
		});
	},

	// forget unbound related events
	remove: function(){
		$.data( this, drag.datakey ).related -= 1;
	},

	// configure interaction, capture settings
	setup: function(){
		// check for related events
		if ( $.data( this, drag.datakey ) )
			return;
		// initialize the drag data with copied defaults
		var data = $.extend({ related:0 }, drag.defaults );
		// store the interaction data
		$.data( this, drag.datakey, data );
		// bind the mousedown event, which starts drag interactions
		$event.add( this, "touchstart mousedown", drag.init, data );
		// prevent image dragging in IE...
		if ( this.attachEvent )
			this.attachEvent("ondragstart", drag.dontstart );
	},

	// destroy configured interaction
	teardown: function(){
		var data = $.data( this, drag.datakey ) || {};
		// check for related events
		if ( data.related )
			return;
		// remove the stored data
		$.removeData( this, drag.datakey );
		// remove the mousedown event
		$event.remove( this, "touchstart mousedown", drag.init );
		// enable text selection
		drag.textselect( true );
		// un-prevent image dragging in IE...
		if ( this.detachEvent )
			this.detachEvent("ondragstart", drag.dontstart );
	},

	// initialize the interaction
	init: function( event ){
		// sorry, only one touch at a time
		if ( drag.touched )
			return;
		// the drag/drop interaction data
		var dd = event.data, results;
		// check the which directive
		if ( event.which != 0 && dd.which > 0 && event.which != dd.which )
			return;
		// check for suppressed selector
		if ( $( event.target ).is( dd.not ) )
			return;
		// check for handle selector
		if ( dd.handle && !$( event.target ).closest( dd.handle, event.currentTarget ).length )
			return;

		drag.touched = event.type == 'touchstart' ? this : null;
		dd.propagates = 1;
		dd.mousedown = this;
		dd.interactions = [ drag.interaction( this, dd ) ];
		dd.target = event.target;
		dd.pageX = event.pageX;
		dd.pageY = event.pageY;
		dd.dragging = null;
		// handle draginit event...
		results = drag.hijack( event, "draginit", dd );
		// early cancel
		if ( !dd.propagates )
			return;
		// flatten the result set
		results = drag.flatten( results );
		// insert new interaction elements
		if ( results && results.length ){
			dd.interactions = [];
			$.each( results, function(){
				dd.interactions.push( drag.interaction( this, dd ) );
			});
		}
		// remember how many interactions are propagating
		dd.propagates = dd.interactions.length;
		// locate and init the drop targets
		if ( dd.drop !== false && $special.drop )
			$special.drop.handler( event, dd );
		// disable text selection
		drag.textselect( false );
		// bind additional events...
		if ( drag.touched )
			$event.add( drag.touched, "touchmove touchend", drag.handler, dd );
		else
			$event.add( document, "mousemove mouseup", drag.handler, dd );
		// helps prevent text selection or scrolling
		if ( !drag.touched || dd.live )
			return false;
	},

	// returns an interaction object
	interaction: function( elem, dd ){
		var offset = $( elem )[ dd.relative ? "position" : "offset" ]() || { top:0, left:0 };
		return {
			drag: elem,
			callback: new drag.callback(),
			droppable: [],
			offset: offset
		};
	},

	// handle drag-releatd DOM events
	handler: function( event ){
		// read the data before hijacking anything
		var dd = event.data;
		// handle various events
		switch ( event.type ){
			// mousemove, check distance, start dragging
			case !dd.dragging && 'touchmove':
				event.preventDefault();
			case !dd.dragging && 'mousemove':
				//  drag tolerance, x≤ + y≤ = distance≤
				if ( Math.pow(  event.pageX-dd.pageX, 2 ) + Math.pow(  event.pageY-dd.pageY, 2 ) < Math.pow( dd.distance, 2 ) )
					break; // distance tolerance not reached
				event.target = dd.target; // force target from "mousedown" event (fix distance issue)
				drag.hijack( event, "dragstart", dd ); // trigger "dragstart"
				if ( dd.propagates ) // "dragstart" not rejected
					dd.dragging = true; // activate interaction
			// mousemove, dragging
			case 'touchmove':
				event.preventDefault();
			case 'mousemove':
				if ( dd.dragging ){
					// trigger "drag"
					drag.hijack( event, "drag", dd );
					if ( dd.propagates ){
						// manage drop events
						if ( dd.drop !== false && $special.drop )
							$special.drop.handler( event, dd ); // "dropstart", "dropend"
						break; // "drag" not rejected, stop
					}
					event.type = "mouseup"; // helps "drop" handler behave
				}
			// mouseup, stop dragging
			case 'touchend':
			case 'mouseup':
			default:
				if ( drag.touched )
					$event.remove( drag.touched, "touchmove touchend", drag.handler ); // remove touch events
				else
					$event.remove( document, "mousemove mouseup", drag.handler ); // remove page events
				if ( dd.dragging ){
					if ( dd.drop !== false && $special.drop )
						$special.drop.handler( event, dd ); // "drop"
					drag.hijack( event, "dragend", dd ); // trigger "dragend"
				}
				drag.textselect( true ); // enable text selection
				// if suppressing click events...
				if ( dd.click === false && dd.dragging )
					$.data( dd.mousedown, "suppress.click", new Date().getTime() + 5 );
				dd.dragging = drag.touched = false; // deactivate element
				break;
		}
	},

	// re-use event object for custom events
	hijack: function( event, type, dd, x, elem ){
		// not configured
		if ( !dd )
			return;
		// remember the original event and type
		var orig = { event:event.originalEvent, type:event.type },
		// is the event drag related or drog related?
		mode = type.indexOf("drop") ? "drag" : "drop",
		// iteration vars
		result, i = x || 0, ia, $elems, callback,
		len = !isNaN( x ) ? x : dd.interactions.length;
		// modify the event type
		event.type = type;
		// remove the original event
		event.originalEvent = null;
		// initialize the results
		dd.results = [];
		// handle each interacted element
		do if ( ia = dd.interactions[ i ] ){
			// validate the interaction
			if ( type !== "dragend" && ia.cancelled )
				continue;
			// set the dragdrop properties on the event object
			callback = drag.properties( event, dd, ia );
			// prepare for more results
			ia.results = [];
			// handle each element
			$( elem || ia[ mode ] || dd.droppable ).each(function( p, subject ){
				// identify drag or drop targets individually
				callback.target = subject;
				// force propagtion of the custom event
				event.isPropagationStopped = function(){ return false; };
				// handle the event
				result = subject ? $event.dispatch.call( subject, event, callback ) : null;
				// stop the drag interaction for this element
				if ( result === false ){
					if ( mode == "drag" ){
						ia.cancelled = true;
						dd.propagates -= 1;
					}
					if ( type == "drop" ){
						ia[ mode ][p] = null;
					}
				}
				// assign any dropinit elements
				else if ( type == "dropinit" )
					ia.droppable.push( drag.element( result ) || subject );
				// accept a returned proxy element
				if ( type == "dragstart" )
					ia.proxy = $( drag.element( result ) || ia.drag )[0];
				// remember this result
				ia.results.push( result );
				// forget the event result, for recycling
				delete event.result;
				// break on cancelled handler
				if ( type !== "dropinit" )
					return result;
			});
			// flatten the results
			dd.results[ i ] = drag.flatten( ia.results );
			// accept a set of valid drop targets
			if ( type == "dropinit" )
				ia.droppable = drag.flatten( ia.droppable );
			// locate drop targets
			if ( type == "dragstart" && !ia.cancelled )
				callback.update();
		}
		while ( ++i < len )
		// restore the original event & type
		event.type = orig.type;
		event.originalEvent = orig.event;
		// return all handler results
		return drag.flatten( dd.results );
	},

	// extend the callback object with drag/drop properties...
	properties: function( event, dd, ia ){
		var obj = ia.callback;
		// elements
		obj.drag = ia.drag;
		obj.proxy = ia.proxy || ia.drag;
		// starting mouse position
		obj.startX = dd.pageX;
		obj.startY = dd.pageY;
		// current distance dragged
		obj.deltaX = event.pageX - dd.pageX;
		obj.deltaY = event.pageY - dd.pageY;
		// original element position
		obj.originalX = ia.offset.left;
		obj.originalY = ia.offset.top;
		// adjusted element position
		obj.offsetX = obj.originalX + obj.deltaX;
		obj.offsetY = obj.originalY + obj.deltaY;
		// assign the drop targets information
		obj.drop = drag.flatten( ( ia.drop || [] ).slice() );
		obj.available = drag.flatten( ( ia.droppable || [] ).slice() );
		return obj;
	},

	// determine is the argument is an element or jquery instance
	element: function( arg ){
		if ( arg && ( arg.jquery || arg.nodeType == 1 ) )
			return arg;
	},

	// flatten nested jquery objects and arrays into a single dimension array
	flatten: function( arr ){
		return $.map( arr, function( member ){
			return member && member.jquery ? $.makeArray( member ) :
				member && member.length ? drag.flatten( member ) : member;
		});
	},

	// toggles text selection attributes ON (true) or OFF (false)
	textselect: function( bool ){
		$( document )[ bool ? "unbind" : "bind" ]("selectstart", drag.dontstart )
			.css("MozUserSelect", bool ? "" : "none" );
		// .attr("unselectable", bool ? "off" : "on" )
		document.unselectable = bool ? "off" : "on";
	},

	// suppress "selectstart" and "ondragstart" events
	dontstart: function(){
		return false;
	},

	// a callback instance contructor
	callback: function(){}

};

// callback methods
drag.callback.prototype = {
	update: function(){
		if ( $special.drop && this.available.length )
			$.each( this.available, function( i ){
				$special.drop.locate( this, i );
			});
	}
};

// patch $.event.$dispatch to allow suppressing clicks
var $dispatch = $event.dispatch;
$event.dispatch = function( event ){
	if ( $.data( this, "suppress."+ event.type ) - new Date().getTime() > 0 ){
		$.removeData( this, "suppress."+ event.type );
		return;
	}
	return $dispatch.apply( this, arguments );
};

// event fix hooks for touch events...
var touchHooks =
$event.fixHooks.touchstart =
$event.fixHooks.touchmove =
$event.fixHooks.touchend =
$event.fixHooks.touchcancel = {
	props: "clientX clientY pageX pageY screenX screenY".split( " " ),
	filter: function( event, orig ) {
		if ( orig ){
			var touched = ( orig.touches && orig.touches[0] )
				|| ( orig.changedTouches && orig.changedTouches[0] )
				|| null;
			// iOS webkit: touchstart, touchmove, touchend
			if ( touched )
				$.each( touchHooks.props, function( i, prop ){
					event[ prop ] = touched[ prop ];
				});
		}
		return event;
	}
};

// share the same special event configuration with related events...
$special.draginit = $special.dragstart = $special.dragend = drag;

},{"jquery":"jquery"}],"jquery_event_drop":[function(require,module,exports){
/*!
 * jquery.event.drop - v 2.2
 * Copyright (c) 2010 Three Dub Media - http://threedubmedia.com
 * Open Source MIT License - http://threedubmedia.com/code/license
 */
// Created: 2008-06-04
// Updated: 2012-05-21
// REQUIRES: jquery 1.7.x, event.drag 2.2

var $ = require("jquery");
var $1 = require("jquery_event_drag");

// Events: drop, dropstart, dropend

// add the jquery instance method
$.fn.drop = function( str, arg, opts ){
	// figure out the event type
	var type = typeof str == "string" ? str : "",
	// figure out the event handler...
	fn = $.isFunction( str ) ? str : $.isFunction( arg ) ? arg : null;
	// fix the event type
	if ( type.indexOf("drop") !== 0 )
		type = "drop"+ type;
	// were options passed
	opts = ( str == fn ? arg : opts ) || {};
	// trigger or bind event handler
	return fn ? this.bind( type, opts, fn ) : this.trigger( type );
};

// DROP MANAGEMENT UTILITY
// returns filtered drop target elements, caches their positions
$.drop = function( opts ){
	opts = opts || {};
	// safely set new options...
	drop.multi = opts.multi === true ? Infinity :
		opts.multi === false ? 1 : !isNaN( opts.multi ) ? opts.multi : drop.multi;
	drop.delay = opts.delay || drop.delay;
	drop.tolerance = $.isFunction( opts.tolerance ) ? opts.tolerance :
		opts.tolerance === null ? null : drop.tolerance;
	drop.mode = opts.mode || drop.mode || 'intersect';
};

// local refs (increase compression)
var $event = $.event,
$special = $event.special,
// configure the drop special event
drop = $.event.special.drop = {

	// these are the default settings
	multi: 1, // allow multiple drop winners per dragged element
	delay: 20, // async timeout delay
	mode: 'overlap', // drop tolerance mode

	// internal cache
	targets: [],

	// the key name for stored drop data
	datakey: "dropdata",

	// prevent bubbling for better performance
	noBubble: true,

	// count bound related events
	add: function( obj ){
		// read the interaction data
		var data = $.data( this, drop.datakey );
		// count another realted event
		data.related += 1;
	},

	// forget unbound related events
	remove: function(){
		$.data( this, drop.datakey ).related -= 1;
	},

	// configure the interactions
	setup: function(){
		// check for related events
		if ( $.data( this, drop.datakey ) )
			return;
		// initialize the drop element data
		var data = {
			related: 0,
			active: [],
			anyactive: 0,
			winner: 0,
			location: {}
		};
		// store the drop data on the element
		$.data( this, drop.datakey, data );
		// store the drop target in internal cache
		drop.targets.push( this );
	},

	// destroy the configure interaction
	teardown: function(){
		var data = $.data( this, drop.datakey ) || {};
		// check for related events
		if ( data.related )
			return;
		// remove the stored data
		$.removeData( this, drop.datakey );
		// reference the targeted element
		var element = this;
		// remove from the internal cache
		drop.targets = $.grep( drop.targets, function( target ){
			return ( target !== element );
		});
	},

	// shared event handler
	handler: function( event, dd ){
		// local vars
		var results, $targets;
		// make sure the right data is available
		if ( !dd )
			return;
		// handle various events
		switch ( event.type ){
			// draginit, from $.event.special.drag
			case 'mousedown': // DROPINIT >>
			case 'touchstart': // DROPINIT >>
				// collect and assign the drop targets
				$targets =  $( drop.targets );
				if ( typeof dd.drop == "string" )
					$targets = $targets.filter( dd.drop );
				// reset drop data winner properties
				$targets.each(function(){
					var data = $.data( this, drop.datakey );
					data.active = [];
					data.anyactive = 0;
					data.winner = 0;
				});
				// set available target elements
				dd.droppable = $targets;
				// activate drop targets for the initial element being dragged
				$special.drag.hijack( event, "dropinit", dd );
				break;
			// drag, from $.event.special.drag
			case 'mousemove': // TOLERATE >>
			case 'touchmove': // TOLERATE >>
				drop.event = event; // store the mousemove event
				if ( !drop.timer )
					// monitor drop targets
					drop.tolerate( dd );
				break;
			// dragend, from $.event.special.drag
			case 'mouseup': // DROP >> DROPEND >>
			case 'touchend': // DROP >> DROPEND >>
				drop.timer = clearTimeout( drop.timer ); // delete timer
				if ( dd.propagates ){
					$special.drag.hijack( event, "drop", dd );
					$special.drag.hijack( event, "dropend", dd );
				}
				break;

		}
	},

	// returns the location positions of an element
	locate: function( elem, index ){
		var data = $.data( elem, drop.datakey ),
		$elem = $( elem ),
		posi = $elem.offset() || {},
		height = $elem.outerHeight(),
		width = $elem.outerWidth(),
		location = {
			elem: elem,
			width: width,
			height: height,
			top: posi.top,
			left: posi.left,
			right: posi.left + width,
			bottom: posi.top + height
		};
		// drag elements might not have dropdata
		if ( data ){
			data.location = location;
			data.index = index;
			data.elem = elem;
		}
		return location;
	},

	// test the location positions of an element against another OR an X,Y coord
	contains: function( target, test ){ // target { location } contains test [x,y] or { location }
		return ( ( test[0] || test.left ) >= target.left && ( test[0] || test.right ) <= target.right
			&& ( test[1] || test.top ) >= target.top && ( test[1] || test.bottom ) <= target.bottom );
	},

	// stored tolerance modes
	modes: { // fn scope: "$.event.special.drop" object
		// target with mouse wins, else target with most overlap wins
		'intersect': function( event, proxy, target ){
			return this.contains( target, [ event.pageX, event.pageY ] ) ? // check cursor
				1e9 : this.modes.overlap.apply( this, arguments ); // check overlap
		},
		// target with most overlap wins
		'overlap': function( event, proxy, target ){
			// calculate the area of overlap...
			return Math.max( 0, Math.min( target.bottom, proxy.bottom ) - Math.max( target.top, proxy.top ) )
				* Math.max( 0, Math.min( target.right, proxy.right ) - Math.max( target.left, proxy.left ) );
		},
		// proxy is completely contained within target bounds
		'fit': function( event, proxy, target ){
			return this.contains( target, proxy ) ? 1 : 0;
		},
		// center of the proxy is contained within target bounds
		'middle': function( event, proxy, target ){
			return this.contains( target, [ proxy.left + proxy.width * .5, proxy.top + proxy.height * .5 ] ) ? 1 : 0;
		}
	},

	// sort drop target cache by by winner (dsc), then index (asc)
	sort: function( a, b ){
		return ( b.winner - a.winner ) || ( a.index - b.index );
	},

	// async, recursive tolerance execution
	tolerate: function( dd ){
		// declare local refs
		var i, drp, drg, data, arr, len, elem,
		// interaction iteration variables
		x = 0, ia, end = dd.interactions.length,
		// determine the mouse coords
		xy = [ drop.event.pageX, drop.event.pageY ],
		// custom or stored tolerance fn
		tolerance = drop.tolerance || drop.modes[ drop.mode ];
		// go through each passed interaction...
		do if ( ia = dd.interactions[x] ){
			// check valid interaction
			if ( !ia )
				return;
			// initialize or clear the drop data
			ia.drop = [];
			// holds the drop elements
			arr = [];
			len = ia.droppable.length;
			// determine the proxy location, if needed
			if ( tolerance )
				drg = drop.locate( ia.proxy );
			// reset the loop
			i = 0;
			// loop each stored drop target
			do if ( elem = ia.droppable[i] ){
				data = $.data( elem, drop.datakey );
				drp = data.location;
				if ( !drp ) continue;
				// find a winner: tolerance function is defined, call it
				data.winner = tolerance ? tolerance.call( drop, drop.event, drg, drp )
					// mouse position is always the fallback
					: drop.contains( drp, xy ) ? 1 : 0;
				arr.push( data );
			} while ( ++i < len ); // loop
			// sort the drop targets
			arr.sort( drop.sort );
			// reset the loop
			i = 0;
			// loop through all of the targets again
			do if ( data = arr[ i ] ){
				// winners...
				if ( data.winner && ia.drop.length < drop.multi ){
					// new winner... dropstart
					if ( !data.active[x] && !data.anyactive ){
						// check to make sure that this is not prevented
						if ( $special.drag.hijack( drop.event, "dropstart", dd, x, data.elem )[0] !== false ){
							data.active[x] = 1;
							data.anyactive += 1;
						}
						// if false, it is not a winner
						else
							data.winner = 0;
					}
					// if it is still a winner
					if ( data.winner )
						ia.drop.push( data.elem );
				}
				// losers...
				else if ( data.active[x] && data.anyactive == 1 ){
					// former winner... dropend
					$special.drag.hijack( drop.event, "dropend", dd, x, data.elem );
					data.active[x] = 0;
					data.anyactive -= 1;
				}
			} while ( ++i < len ); // loop
		} while ( ++x < end ) // loop
		// check if the mouse is still moving or is idle
		if ( drop.last && xy[0] == drop.last.pageX && xy[1] == drop.last.pageY )
			delete drop.timer; // idle, don't recurse
		else  // recurse
			drop.timer = setTimeout(function(){
				drop.tolerate( dd );
			}, drop.delay );
		// remember event, to compare idleness
		drop.last = drop.event;
	}

};

// share the same special event configuration with related events...
$special.dropinit = $special.dropstart = $special.dropend = drop;

},{"jquery":"jquery","jquery_event_drag":"jquery_event_drag"}],"slick_grid/plugins/slick.checkboxselectcolumn":[function(require,module,exports){
var $ = require("jquery");
var Slick = require("../slick.core");

function CheckboxSelectColumn(options) {
  var _grid;
  var _self = this;
  var _handler = new Slick.EventHandler();
  var _selectedRowsLookup = {};
  var _defaults = {
    columnId: "_checkbox_selector",
    cssClass: null,
    toolTip: "Select/Deselect All",
    width: 30
  };

  var _options = $.extend(true, {}, _defaults, options);

  function init(grid) {
    _grid = grid;
    _handler
      .subscribe(_grid.onSelectedRowsChanged, handleSelectedRowsChanged)
      .subscribe(_grid.onClick, handleClick)
      .subscribe(_grid.onHeaderClick, handleHeaderClick)
      .subscribe(_grid.onKeyDown, handleKeyDown);
  }

  function destroy() {
    _handler.unsubscribeAll();
  }

  function handleSelectedRowsChanged(e, args) {
    var selectedRows = _grid.getSelectedRows();
    var lookup = {}, row, i;
    for (i = 0; i < selectedRows.length; i++) {
      row = selectedRows[i];
      lookup[row] = true;
      if (lookup[row] !== _selectedRowsLookup[row]) {
        _grid.invalidateRow(row);
        delete _selectedRowsLookup[row];
      }
    }
    for (i in _selectedRowsLookup) {
      _grid.invalidateRow(i);
    }
    _selectedRowsLookup = lookup;
    _grid.render();

    if (selectedRows.length && selectedRows.length == _grid.getDataLength()) {
      _grid.updateColumnHeader(_options.columnId, "<input type='checkbox' checked='checked'>", _options.toolTip);
    } else {
      _grid.updateColumnHeader(_options.columnId, "<input type='checkbox'>", _options.toolTip);
    }
  }

  function handleKeyDown(e, args) {
    if (e.which == 32) {
      if (_grid.getColumns()[args.cell].id === _options.columnId) {
        // if editing, try to commit
        if (!_grid.getEditorLock().isActive() || _grid.getEditorLock().commitCurrentEdit()) {
          toggleRowSelection(args.row);
        }
        e.preventDefault();
        e.stopImmediatePropagation();
      }
    }
  }

  function handleClick(e, args) {
    // clicking on a row select checkbox
    if (_grid.getColumns()[args.cell].id === _options.columnId && $(e.target).is(":checkbox")) {
      // if editing, try to commit
      if (_grid.getEditorLock().isActive() && !_grid.getEditorLock().commitCurrentEdit()) {
        e.preventDefault();
        e.stopImmediatePropagation();
        return;
      }

      toggleRowSelection(args.row);
      e.stopPropagation();
      e.stopImmediatePropagation();
    }
  }

  function toggleRowSelection(row) {
    if (_selectedRowsLookup[row]) {
      _grid.setSelectedRows($.grep(_grid.getSelectedRows(), function (n) {
        return n != row
      }));
    } else {
      _grid.setSelectedRows(_grid.getSelectedRows().concat(row));
    }
  }

  function handleHeaderClick(e, args) {
    if (args.column.id == _options.columnId && $(e.target).is(":checkbox")) {
      // if editing, try to commit
      if (_grid.getEditorLock().isActive() && !_grid.getEditorLock().commitCurrentEdit()) {
        e.preventDefault();
        e.stopImmediatePropagation();
        return;
      }

      if ($(e.target).is(":checked")) {
        var rows = [];
        for (var i = 0; i < _grid.getDataLength(); i++) {
          rows.push(i);
        }
        _grid.setSelectedRows(rows);
      } else {
        _grid.setSelectedRows([]);
      }
      e.stopPropagation();
      e.stopImmediatePropagation();
    }
  }

  function getColumnDefinition() {
    return {
      id: _options.columnId,
      name: "<input type='checkbox'>",
      toolTip: _options.toolTip,
      field: "sel",
      width: _options.width,
      resizable: false,
      sortable: false,
      cssClass: _options.cssClass,
      formatter: checkboxSelectionFormatter
    };
  }

  function checkboxSelectionFormatter(row, cell, value, columnDef, dataContext) {
    if (dataContext) {
      return _selectedRowsLookup[row]
          ? "<input type='checkbox' checked='checked'>"
          : "<input type='checkbox'>";
    }
    return null;
  }

  $.extend(this, {
    "init": init,
    "destroy": destroy,

    "getColumnDefinition": getColumnDefinition
  });
}

module.exports = CheckboxSelectColumn;

},{"../slick.core":"slick_grid/slick.core","jquery":"jquery"}],"slick_grid/plugins/slick.rowselectionmodel":[function(require,module,exports){
var $ = require("jquery");
var Slick = require("../slick.core");

function RowSelectionModel(options) {
  var _grid;
  var _ranges = [];
  var _self = this;
  var _handler = new Slick.EventHandler();
  var _inHandler;
  var _options;
  var _defaults = {
    selectActiveRow: true
  };

  function init(grid) {
    _options = $.extend(true, {}, _defaults, options);
    _grid = grid;
    _handler.subscribe(_grid.onActiveCellChanged,
        wrapHandler(handleActiveCellChange));
    _handler.subscribe(_grid.onKeyDown,
        wrapHandler(handleKeyDown));
    _handler.subscribe(_grid.onClick,
        wrapHandler(handleClick));
  }

  function destroy() {
    _handler.unsubscribeAll();
  }

  function wrapHandler(handler) {
    return function () {
      if (!_inHandler) {
        _inHandler = true;
        handler.apply(this, arguments);
        _inHandler = false;
      }
    };
  }

  function rangesToRows(ranges) {
    var rows = [];
    for (var i = 0; i < ranges.length; i++) {
      for (var j = ranges[i].fromRow; j <= ranges[i].toRow; j++) {
        rows.push(j);
      }
    }
    return rows;
  }

  function rowsToRanges(rows) {
    var ranges = [];
    var lastCell = _grid.getColumns().length - 1;
    for (var i = 0; i < rows.length; i++) {
      ranges.push(new Slick.Range(rows[i], 0, rows[i], lastCell));
    }
    return ranges;
  }

  function getRowsRange(from, to) {
    var i, rows = [];
    for (i = from; i <= to; i++) {
      rows.push(i);
    }
    for (i = to; i < from; i++) {
      rows.push(i);
    }
    return rows;
  }

  function getSelectedRows() {
    return rangesToRows(_ranges);
  }

  function setSelectedRows(rows) {
    setSelectedRanges(rowsToRanges(rows));
  }

  function setSelectedRanges(ranges) {
    _ranges = ranges;
    _self.onSelectedRangesChanged.notify(_ranges);
  }

  function getSelectedRanges() {
    return _ranges;
  }

  function handleActiveCellChange(e, data) {
    if (_options.selectActiveRow && data.row != null) {
      setSelectedRanges([new Slick.Range(data.row, 0, data.row, _grid.getColumns().length - 1)]);
    }
  }

  function handleKeyDown(e) {
    var activeRow = _grid.getActiveCell();
    if (activeRow && e.shiftKey && !e.ctrlKey && !e.altKey && !e.metaKey && (e.which == 38 || e.which == 40)) {
      var selectedRows = getSelectedRows();
      selectedRows.sort(function (x, y) {
        return x - y
      });

      if (!selectedRows.length) {
        selectedRows = [activeRow.row];
      }

      var top = selectedRows[0];
      var bottom = selectedRows[selectedRows.length - 1];
      var active;

      if (e.which == 40) {
        active = activeRow.row < bottom || top == bottom ? ++bottom : ++top;
      } else {
        active = activeRow.row < bottom ? --bottom : --top;
      }

      if (active >= 0 && active < _grid.getDataLength()) {
        _grid.scrollRowIntoView(active);
        _ranges = rowsToRanges(getRowsRange(top, bottom));
        setSelectedRanges(_ranges);
      }

      e.preventDefault();
      e.stopPropagation();
    }
  }

  function handleClick(e) {
    var cell = _grid.getCellFromEvent(e);
    if (!cell || !_grid.canCellBeActive(cell.row, cell.cell)) {
      return false;
    }

    if (!_grid.getOptions().multiSelect || (
        !e.ctrlKey && !e.shiftKey && !e.metaKey)) {
      return false;
    }

    var selection = rangesToRows(_ranges);
    var idx = $.inArray(cell.row, selection);

    if (idx === -1 && (e.ctrlKey || e.metaKey)) {
      selection.push(cell.row);
      _grid.setActiveCell(cell.row, cell.cell);
    } else if (idx !== -1 && (e.ctrlKey || e.metaKey)) {
      selection = $.grep(selection, function (o, i) {
        return (o !== cell.row);
      });
      _grid.setActiveCell(cell.row, cell.cell);
    } else if (selection.length && e.shiftKey) {
      var last = selection.pop();
      var from = Math.min(cell.row, last);
      var to = Math.max(cell.row, last);
      selection = [];
      for (var i = from; i <= to; i++) {
        if (i !== last) {
          selection.push(i);
        }
      }
      selection.push(last);
      _grid.setActiveCell(cell.row, cell.cell);
    }

    _ranges = rowsToRanges(selection);
    setSelectedRanges(_ranges);
    e.stopImmediatePropagation();

    return true;
  }

  $.extend(this, {
    "getSelectedRows": getSelectedRows,
    "setSelectedRows": setSelectedRows,

    "getSelectedRanges": getSelectedRanges,
    "setSelectedRanges": setSelectedRanges,

    "init": init,
    "destroy": destroy,

    "onSelectedRangesChanged": new Slick.Event()
  });
}

module.exports = RowSelectionModel;

},{"../slick.core":"slick_grid/slick.core","jquery":"jquery"}],"slick_grid/slick.core":[function(require,module,exports){
/***
 * Contains core SlickGrid classes.
 * @module Core
 * @namespace Slick
 */

var $ = require("jquery");

// register namespace
var Slick = {
  Event: Event,
  EventData: EventData,
  EventHandler: EventHandler,
  Range: Range,
  NonDataRow: NonDataItem,
  Group: Group,
  GroupTotals: GroupTotals,
  EditorLock: EditorLock,

    /***
     * A global singleton editor lock.
     * @class GlobalEditorLock
     * @static
     * @constructor
     */
  GlobalEditorLock: new EditorLock()
};

/***
 * An event object for passing data to event handlers and letting them control propagation.
 * <p>This is pretty much identical to how W3C and jQuery implement events.</p>
 * @class EventData
 * @constructor
 */
function EventData() {
  var isPropagationStopped = false;
  var isImmediatePropagationStopped = false;

  /***
   * Stops event from propagating up the DOM tree.
   * @method stopPropagation
   */
  this.stopPropagation = function () {
    isPropagationStopped = true;
  };

  /***
   * Returns whether stopPropagation was called on this event object.
   * @method isPropagationStopped
   * @return {Boolean}
   */
  this.isPropagationStopped = function () {
    return isPropagationStopped;
  };

  /***
   * Prevents the rest of the handlers from being executed.
   * @method stopImmediatePropagation
   */
  this.stopImmediatePropagation = function () {
    isImmediatePropagationStopped = true;
  };

  /***
   * Returns whether stopImmediatePropagation was called on this event object.\
   * @method isImmediatePropagationStopped
   * @return {Boolean}
   */
  this.isImmediatePropagationStopped = function () {
    return isImmediatePropagationStopped;
  }
}

/***
 * A simple publisher-subscriber implementation.
 * @class Event
 * @constructor
 */
function Event() {
  var handlers = [];

  /***
   * Adds an event handler to be called when the event is fired.
   * <p>Event handler will receive two arguments - an <code>EventData</code> and the <code>data</code>
   * object the event was fired with.<p>
   * @method subscribe
   * @param fn {Function} Event handler.
   */
  this.subscribe = function (fn) {
    handlers.push(fn);
  };

  /***
   * Removes an event handler added with <code>subscribe(fn)</code>.
   * @method unsubscribe
   * @param fn {Function} Event handler to be removed.
   */
  this.unsubscribe = function (fn) {
    for (var i = handlers.length - 1; i >= 0; i--) {
      if (handlers[i] === fn) {
        handlers.splice(i, 1);
      }
    }
  };

  /***
   * Fires an event notifying all subscribers.
   * @method notify
   * @param args {Object} Additional data object to be passed to all handlers.
   * @param e {EventData}
   *      Optional.
   *      An <code>EventData</code> object to be passed to all handlers.
   *      For DOM events, an existing W3C/jQuery event object can be passed in.
   * @param scope {Object}
   *      Optional.
   *      The scope ("this") within which the handler will be executed.
   *      If not specified, the scope will be set to the <code>Event</code> instance.
   */
  this.notify = function (args, e, scope) {
    e = e || new EventData();
    scope = scope || this;

    var returnValue;
    for (var i = 0; i < handlers.length && !(e.isPropagationStopped() || e.isImmediatePropagationStopped()); i++) {
      returnValue = handlers[i].call(scope, e, args);
    }

    return returnValue;
  };
}

function EventHandler() {
  var handlers = [];

  this.subscribe = function (event, handler) {
    handlers.push({
      event: event,
      handler: handler
    });
    event.subscribe(handler);

    return this;  // allow chaining
  };

  this.unsubscribe = function (event, handler) {
    var i = handlers.length;
    while (i--) {
      if (handlers[i].event === event &&
          handlers[i].handler === handler) {
        handlers.splice(i, 1);
        event.unsubscribe(handler);
        return;
      }
    }

    return this;  // allow chaining
  };

  this.unsubscribeAll = function () {
    var i = handlers.length;
    while (i--) {
      handlers[i].event.unsubscribe(handlers[i].handler);
    }
    handlers = [];

    return this;  // allow chaining
  }
}

/***
 * A structure containing a range of cells.
 * @class Range
 * @constructor
 * @param fromRow {Integer} Starting row.
 * @param fromCell {Integer} Starting cell.
 * @param toRow {Integer} Optional. Ending row. Defaults to <code>fromRow</code>.
 * @param toCell {Integer} Optional. Ending cell. Defaults to <code>fromCell</code>.
 */
function Range(fromRow, fromCell, toRow, toCell) {
  if (toRow === undefined && toCell === undefined) {
    toRow = fromRow;
    toCell = fromCell;
  }

  /***
   * @property fromRow
   * @type {Integer}
   */
  this.fromRow = Math.min(fromRow, toRow);

  /***
   * @property fromCell
   * @type {Integer}
   */
  this.fromCell = Math.min(fromCell, toCell);

  /***
   * @property toRow
   * @type {Integer}
   */
  this.toRow = Math.max(fromRow, toRow);

  /***
   * @property toCell
   * @type {Integer}
   */
  this.toCell = Math.max(fromCell, toCell);

  /***
   * Returns whether a range represents a single row.
   * @method isSingleRow
   * @return {Boolean}
   */
  this.isSingleRow = function () {
    return this.fromRow == this.toRow;
  };

  /***
   * Returns whether a range represents a single cell.
   * @method isSingleCell
   * @return {Boolean}
   */
  this.isSingleCell = function () {
    return this.fromRow == this.toRow && this.fromCell == this.toCell;
  };

  /***
   * Returns whether a range contains a given cell.
   * @method contains
   * @param row {Integer}
   * @param cell {Integer}
   * @return {Boolean}
   */
  this.contains = function (row, cell) {
    return row >= this.fromRow && row <= this.toRow &&
        cell >= this.fromCell && cell <= this.toCell;
  };

  /***
   * Returns a readable representation of a range.
   * @method toString
   * @return {String}
   */
  this.toString = function () {
    if (this.isSingleCell()) {
      return "(" + this.fromRow + ":" + this.fromCell + ")";
    }
    else {
      return "(" + this.fromRow + ":" + this.fromCell + " - " + this.toRow + ":" + this.toCell + ")";
    }
  }
}


/***
 * A base class that all special / non-data rows (like Group and GroupTotals) derive from.
 * @class NonDataItem
 * @constructor
 */
function NonDataItem() {
  this.__nonDataRow = true;
}


/***
 * Information about a group of rows.
 * @class Group
 * @extends Slick.NonDataItem
 * @constructor
 */
function Group() {
  this.__group = true;

  /**
   * Grouping level, starting with 0.
   * @property level
   * @type {Number}
   */
  this.level = 0;

  /***
   * Number of rows in the group.
   * @property count
   * @type {Integer}
   */
  this.count = 0;

  /***
   * Grouping value.
   * @property value
   * @type {Object}
   */
  this.value = null;

  /***
   * Formatted display value of the group.
   * @property title
   * @type {String}
   */
  this.title = null;

  /***
   * Whether a group is collapsed.
   * @property collapsed
   * @type {Boolean}
   */
  this.collapsed = false;

  /***
   * GroupTotals, if any.
   * @property totals
   * @type {GroupTotals}
   */
  this.totals = null;

  /**
   * Rows that are part of the group.
   * @property rows
   * @type {Array}
   */
  this.rows = [];

  /**
   * Sub-groups that are part of the group.
   * @property groups
   * @type {Array}
   */
  this.groups = null;

  /**
   * A unique key used to identify the group.  This key can be used in calls to DataView
   * collapseGroup() or expandGroup().
   * @property groupingKey
   * @type {Object}
   */
  this.groupingKey = null;
}

Group.prototype = new NonDataItem();

/***
 * Compares two Group instances.
 * @method equals
 * @return {Boolean}
 * @param group {Group} Group instance to compare to.
 */
Group.prototype.equals = function (group) {
  return this.value === group.value &&
      this.count === group.count &&
      this.collapsed === group.collapsed &&
      this.title === group.title;
};

/***
 * Information about group totals.
 * An instance of GroupTotals will be created for each totals row and passed to the aggregators
 * so that they can store arbitrary data in it.  That data can later be accessed by group totals
 * formatters during the display.
 * @class GroupTotals
 * @extends Slick.NonDataItem
 * @constructor
 */
function GroupTotals() {
  this.__groupTotals = true;

  /***
   * Parent Group.
   * @param group
   * @type {Group}
   */
  this.group = null;

  /***
   * Whether the totals have been fully initialized / calculated.
   * Will be set to false for lazy-calculated group totals.
   * @param initialized
   * @type {Boolean}
   */
  this.initialized = false;
}

GroupTotals.prototype = new NonDataItem();

/***
 * A locking helper to track the active edit controller and ensure that only a single controller
 * can be active at a time.  This prevents a whole class of state and validation synchronization
 * issues.  An edit controller (such as SlickGrid) can query if an active edit is in progress
 * and attempt a commit or cancel before proceeding.
 * @class EditorLock
 * @constructor
 */
function EditorLock() {
  var activeEditController = null;

  /***
   * Returns true if a specified edit controller is active (has the edit lock).
   * If the parameter is not specified, returns true if any edit controller is active.
   * @method isActive
   * @param editController {EditController}
   * @return {Boolean}
   */
  this.isActive = function (editController) {
    return (editController ? activeEditController === editController : activeEditController !== null);
  };

  /***
   * Sets the specified edit controller as the active edit controller (acquire edit lock).
   * If another edit controller is already active, and exception will be thrown.
   * @method activate
   * @param editController {EditController} edit controller acquiring the lock
   */
  this.activate = function (editController) {
    if (editController === activeEditController) { // already activated?
      return;
    }
    if (activeEditController !== null) {
      throw "SlickGrid.EditorLock.activate: an editController is still active, can't activate another editController";
    }
    if (!editController.commitCurrentEdit) {
      throw "SlickGrid.EditorLock.activate: editController must implement .commitCurrentEdit()";
    }
    if (!editController.cancelCurrentEdit) {
      throw "SlickGrid.EditorLock.activate: editController must implement .cancelCurrentEdit()";
    }
    activeEditController = editController;
  };

  /***
   * Unsets the specified edit controller as the active edit controller (release edit lock).
   * If the specified edit controller is not the active one, an exception will be thrown.
   * @method deactivate
   * @param editController {EditController} edit controller releasing the lock
   */
  this.deactivate = function (editController) {
    if (activeEditController !== editController) {
      throw "SlickGrid.EditorLock.deactivate: specified editController is not the currently active one";
    }
    activeEditController = null;
  };

  /***
   * Attempts to commit the current edit by calling "commitCurrentEdit" method on the active edit
   * controller and returns whether the commit attempt was successful (commit may fail due to validation
   * errors, etc.).  Edit controller's "commitCurrentEdit" must return true if the commit has succeeded
   * and false otherwise.  If no edit controller is active, returns true.
   * @method commitCurrentEdit
   * @return {Boolean}
   */
  this.commitCurrentEdit = function () {
    return (activeEditController ? activeEditController.commitCurrentEdit() : true);
  };

  /***
   * Attempts to cancel the current edit by calling "cancelCurrentEdit" method on the active edit
   * controller and returns whether the edit was successfully cancelled.  If no edit controller is
   * active, returns true.
   * @method cancelCurrentEdit
   * @return {Boolean}
   */
  this.cancelCurrentEdit = function cancelCurrentEdit() {
    return (activeEditController ? activeEditController.cancelCurrentEdit() : true);
  };
}

module.exports = Slick;

},{"jquery":"jquery"}],"slick_grid/slick.grid":[function(require,module,exports){
/**
 * @license
 * (c) 2009-2013 Michael Leibman
 * michael{dot}leibman{at}gmail{dot}com
 * http://github.com/mleibman/slickgrid
 *
 * Distributed under MIT license.
 * All rights reserved.
 *
 * SlickGrid v2.2
 *
 * NOTES:
 *     Cell/row DOM manipulations are done directly bypassing jQuery's DOM manipulation methods.
 *     This increases the speed dramatically, but can only be done safely because there are no event handlers
 *     or data associated with any cell/row DOM nodes.  Cell editors must make sure they implement .destroy()
 *     and do proper cleanup.
 */

var $ = require("jquery");
var $1 = require("jquery_event_drag");
var $2 = require("jquery_event_drop");
var Slick = require("./slick.core");


// shared across all grids on the page
var scrollbarDimensions;
var maxSupportedCssHeight;  // browser's breaking point

//////////////////////////////////////////////////////////////////////////////////////////////
// SlickGrid class implementation (available as Slick.Grid)

/**
 * Creates a new instance of the grid.
 * @class SlickGrid
 * @constructor
 * @param {Node}              container   Container node to create the grid in.
 * @param {Array,Object}      data        An array of objects for databinding.
 * @param {Array}             columns     An array of column definitions.
 * @param {Object}            options     Grid options.
 **/
function SlickGrid(container, data, columns, options) {
  // settings
  var defaults = {
    explicitInitialization: false,
    rowHeight: 25,
    defaultColumnWidth: 80,
    enableAddRow: false,
    leaveSpaceForNewRows: false,
    editable: false,
    autoEdit: true,
    enableCellNavigation: true,
    enableColumnReorder: true,
    asyncEditorLoading: false,
    asyncEditorLoadDelay: 100,
    forceFitColumns: false,
    enableAsyncPostRender: false,
    asyncPostRenderDelay: 50,
    autoHeight: false,
    editorLock: Slick.GlobalEditorLock,
    showHeaderRow: false,
    headerRowHeight: 25,
    showTopPanel: false,
    topPanelHeight: 25,
    formatterFactory: null,
    editorFactory: null,
    cellFlashingCssClass: "flashing",
    selectedCellCssClass: "selected",
    multiSelect: true,
    enableTextSelectionOnCells: false,
    dataItemColumnValueExtractor: null,
    fullWidthRows: false,
    multiColumnSort: false,
    defaultFormatter: defaultFormatter,
    forceSyncScrolling: false,
    addNewRowCssClass: "new-row"
  };

  var columnDefaults = {
    name: "",
    resizable: true,
    sortable: false,
    minWidth: 30,
    rerenderOnResize: false,
    headerCssClass: null,
    defaultSortAsc: true,
    focusable: true,
    selectable: true
  };

  // scroller
  var th;   // virtual height
  var h;    // real scrollable height
  var ph;   // page height
  var n;    // number of pages
  var cj;   // "jumpiness" coefficient

  var page = 0;       // current page
  var offset = 0;     // current page offset
  var vScrollDir = 1;

  // private
  var initialized = false;
  var $container;
  var uid = "slickgrid_" + Math.round(1000000 * Math.random());
  var self = this;
  var $focusSink, $focusSink2;
  var $headerScroller;
  var $headers;
  var $headerRow, $headerRowScroller, $headerRowSpacer;
  var $topPanelScroller;
  var $topPanel;
  var $viewport;
  var $canvas;
  var $style;
  var $boundAncestors;
  var stylesheet, columnCssRulesL, columnCssRulesR;
  var viewportH, viewportW;
  var canvasWidth;
  var viewportHasHScroll, viewportHasVScroll;
  var headerColumnWidthDiff = 0, headerColumnHeightDiff = 0, // border+padding
      cellWidthDiff = 0, cellHeightDiff = 0;
  var absoluteColumnMinWidth;

  var tabbingDirection = 1;
  var activePosX;
  var activeRow, activeCell;
  var activeCellNode = null;
  var currentEditor = null;
  var serializedEditorValue;
  var editController;

  var rowsCache = {};
  var renderedRows = 0;
  var numVisibleRows;
  var prevScrollTop = 0;
  var scrollTop = 0;
  var lastRenderedScrollTop = 0;
  var lastRenderedScrollLeft = 0;
  var prevScrollLeft = 0;
  var scrollLeft = 0;

  var selectionModel;
  var selectedRows = [];

  var plugins = [];
  var cellCssClasses = {};

  var columnsById = {};
  var sortColumns = [];
  var columnPosLeft = [];
  var columnPosRight = [];


  // async call handles
  var h_editorLoader = null;
  var h_render = null;
  var h_postrender = null;
  var postProcessedRows = {};
  var postProcessToRow = null;
  var postProcessFromRow = null;

  // perf counters
  var counter_rows_rendered = 0;
  var counter_rows_removed = 0;

  // These two variables work around a bug with inertial scrolling in Webkit/Blink on Mac.
  // See http://crbug.com/312427.
  var rowNodeFromLastMouseWheelEvent;  // this node must not be deleted while inertial scrolling
  var zombieRowNodeFromLastMouseWheelEvent;  // node that was hidden instead of getting deleted


  //////////////////////////////////////////////////////////////////////////////////////////////
  // Initialization

  function init() {
    $container = $(container);
    if ($container.length < 1) {
      throw new Error("SlickGrid requires a valid container, " + container + " does not exist in the DOM.");
    }

    // calculate these only once and share between grid instances
    maxSupportedCssHeight = maxSupportedCssHeight || getMaxSupportedCssHeight();
    scrollbarDimensions = scrollbarDimensions || measureScrollbar();

    options = $.extend({}, defaults, options);
    validateAndEnforceOptions();
    columnDefaults.width = options.defaultColumnWidth;

    columnsById = {};
    for (var i = 0; i < columns.length; i++) {
      var m = columns[i] = $.extend({}, columnDefaults, columns[i]);
      columnsById[m.id] = i;
      if (m.minWidth && m.width < m.minWidth) {
        m.width = m.minWidth;
      }
      if (m.maxWidth && m.width > m.maxWidth) {
        m.width = m.maxWidth;
      }
    }

    // validate loaded JavaScript modules against requested options
    if (options.enableColumnReorder && !$.fn.sortable) {
      throw new Error("SlickGrid's 'enableColumnReorder = true' option requires jquery-ui.sortable module to be loaded");
    }

    editController = {
      "commitCurrentEdit": commitCurrentEdit,
      "cancelCurrentEdit": cancelCurrentEdit
    };

    $container
        .empty()
        .css("overflow", "hidden")
        .css("outline", 0)
        .addClass(uid)
        .addClass("bk-ui-widget");

    // set up a positioning container if needed
    if (!/relative|absolute|fixed/.test($container.css("position"))) {
      $container.css("position", "relative");
    }

    $focusSink = $("<div tabIndex='0' hideFocus style='position:fixed;width:0;height:0;top:0;left:0;outline:0;'></div>").appendTo($container);

    $headerScroller = $("<div class='bk-slick-header bk-ui-state-default' style='overflow:hidden;position:relative;' />").appendTo($container);
    $headers = $("<div class='bk-slick-header-columns' style='left:-1000px' />").appendTo($headerScroller);
    $headers.width(getHeadersWidth());

    $headerRowScroller = $("<div class='bk-slick-headerrow bk-ui-state-default' style='overflow:hidden;position:relative;' />").appendTo($container);
    $headerRow = $("<div class='bk-slick-headerrow-columns' />").appendTo($headerRowScroller);
    $headerRowSpacer = $("<div style='display:block;height:1px;position:absolute;top:0;left:0;'></div>")
        .css("width", getCanvasWidth() + scrollbarDimensions.width + "px")
        .appendTo($headerRowScroller);

    $topPanelScroller = $("<div class='bk-slick-top-panel-scroller bk-ui-state-default' style='overflow:hidden;position:relative;' />").appendTo($container);
    $topPanel = $("<div class='bk-slick-top-panel' style='width:10000px' />").appendTo($topPanelScroller);

    if (!options.showTopPanel) {
      $topPanelScroller.hide();
    }

    if (!options.showHeaderRow) {
      $headerRowScroller.hide();
    }

    $viewport = $("<div class='bk-slick-viewport' style='width:100%;overflow:auto;outline:0;position:relative;;'>").appendTo($container);
    $viewport.css("overflow-y", options.autoHeight ? "hidden" : "auto");

    $canvas = $("<div class='grid-canvas' />").appendTo($viewport);

    $focusSink2 = $focusSink.clone().appendTo($container);

    if (!options.explicitInitialization) {
      finishInitialization();
    }
  }

  function finishInitialization() {
    if (!initialized) {
      initialized = true;

      viewportW = parseFloat($.css($container[0], "width", true));

      // header columns and cells may have different padding/border skewing width calculations (box-sizing, hello?)
      // calculate the diff so we can set consistent sizes
      measureCellPaddingAndBorder();

      // for usability reasons, all text selection in SlickGrid is disabled
      // with the exception of input and textarea elements (selection must
      // be enabled there so that editors work as expected); note that
      // selection in grid cells (grid body) is already unavailable in
      // all browsers except IE
      disableSelection($headers); // disable all text selection in header (including input and textarea)

      if (!options.enableTextSelectionOnCells) {
        // disable text selection in grid cells except in input and textarea elements
        // (this is IE-specific, because selectstart event will only fire in IE)
        $viewport.bind("selectstart.ui", function (event) {
          return $(event.target).is("input,textarea");
        });
      }

      updateColumnCaches();
      createColumnHeaders();
      setupColumnSort();
      createCssRules();
      resizeCanvas();
      bindAncestorScrollEvents();

      $container
          .bind("resize.bk-slickgrid", resizeCanvas);
      $viewport
          //.bind("click", handleClick)
          .bind("scroll", handleScroll);
      $headerScroller
          .bind("contextmenu", handleHeaderContextMenu)
          .bind("click", handleHeaderClick)
          .delegate(".bk-slick-header-column", "mouseenter", handleHeaderMouseEnter)
          .delegate(".bk-slick-header-column", "mouseleave", handleHeaderMouseLeave);
      $headerRowScroller
          .bind("scroll", handleHeaderRowScroll);
      $focusSink.add($focusSink2)
          .bind("keydown", handleKeyDown);
      $canvas
          .bind("keydown", handleKeyDown)
          .bind("click", handleClick)
          .bind("dblclick", handleDblClick)
          .bind("contextmenu", handleContextMenu)
          .bind("draginit", handleDragInit)
          .bind("dragstart", {distance: 3}, handleDragStart)
          .bind("drag", handleDrag)
          .bind("dragend", handleDragEnd)
          .delegate(".bk-slick-cell", "mouseenter", handleMouseEnter)
          .delegate(".bk-slick-cell", "mouseleave", handleMouseLeave);

      // Work around http://crbug.com/312427.
      if (navigator.userAgent.toLowerCase().match(/webkit/) &&
          navigator.userAgent.toLowerCase().match(/macintosh/)) {
        $canvas.bind("mousewheel", handleMouseWheel);
      }
    }
  }

  function registerPlugin(plugin) {
    plugins.unshift(plugin);
    plugin.init(self);
  }

  function unregisterPlugin(plugin) {
    for (var i = plugins.length; i >= 0; i--) {
      if (plugins[i] === plugin) {
        if (plugins[i].destroy) {
          plugins[i].destroy();
        }
        plugins.splice(i, 1);
        break;
      }
    }
  }

  function setSelectionModel(model) {
    if (selectionModel) {
      selectionModel.onSelectedRangesChanged.unsubscribe(handleSelectedRangesChanged);
      if (selectionModel.destroy) {
        selectionModel.destroy();
      }
    }

    selectionModel = model;
    if (selectionModel) {
      selectionModel.init(self);
      selectionModel.onSelectedRangesChanged.subscribe(handleSelectedRangesChanged);
    }
  }

  function getSelectionModel() {
    return selectionModel;
  }

  function getCanvasNode() {
    return $canvas[0];
  }

  function measureScrollbar() {
    var $c = $("<div style='position:absolute; top:-10000px; left:-10000px; width:100px; height:100px; overflow:scroll;'></div>").appendTo("body");
    var dim = {
      width: $c.width() - $c[0].clientWidth,
      height: $c.height() - $c[0].clientHeight
    };
    $c.remove();
    return dim;
  }

  function getHeadersWidth() {
    var headersWidth = 0;
    for (var i = 0, ii = columns.length; i < ii; i++) {
      var width = columns[i].width;
      headersWidth += width;
    }
    headersWidth += scrollbarDimensions.width;
    return Math.max(headersWidth, viewportW) + 1000;
  }

  function getCanvasWidth() {
    var availableWidth = viewportHasVScroll ? viewportW - scrollbarDimensions.width : viewportW;
    var rowWidth = 0;
    var i = columns.length;
    while (i--) {
      rowWidth += columns[i].width;
    }
    return options.fullWidthRows ? Math.max(rowWidth, availableWidth) : rowWidth;
  }

  function updateCanvasWidth(forceColumnWidthsUpdate) {
    var oldCanvasWidth = canvasWidth;
    canvasWidth = getCanvasWidth();

    if (canvasWidth != oldCanvasWidth) {
      $canvas.width(canvasWidth);
      $headerRow.width(canvasWidth);
      $headers.width(getHeadersWidth());
      viewportHasHScroll = (canvasWidth > viewportW - scrollbarDimensions.width);
    }

    $headerRowSpacer.width(canvasWidth + (viewportHasVScroll ? scrollbarDimensions.width : 0));

    if (canvasWidth != oldCanvasWidth || forceColumnWidthsUpdate) {
      applyColumnWidths();
    }
  }

  function disableSelection($target) {
    if ($target && $target.jquery) {
      $target
          .attr("unselectable", "on")
          .css("MozUserSelect", "none")
          .bind("selectstart.ui", function () {
            return false;
          }); // from jquery:ui.core.js 1.7.2
    }
  }

  function getMaxSupportedCssHeight() {
    var supportedHeight = 1000000;
    // FF reports the height back but still renders blank after ~6M px
    var testUpTo = navigator.userAgent.toLowerCase().match(/firefox/) ? 6000000 : 1000000000;
    var div = $("<div style='display:none' />").appendTo(document.body);

    while (true) {
      var test = supportedHeight * 2;
      div.css("height", test);
      if (test > testUpTo || div.height() !== test) {
        break;
      } else {
        supportedHeight = test;
      }
    }

    div.remove();
    return supportedHeight;
  }

  // TODO:  this is static.  need to handle page mutation.
  function bindAncestorScrollEvents() {
    var elem = $canvas[0];
    while ((elem = elem.parentNode) != document.body && elem != null) {
      // bind to scroll containers only
      if (elem == $viewport[0] || elem.scrollWidth != elem.clientWidth || elem.scrollHeight != elem.clientHeight) {
        var $elem = $(elem);
        if (!$boundAncestors) {
          $boundAncestors = $elem;
        } else {
          $boundAncestors = $boundAncestors.add($elem);
        }
        $elem.bind("scroll." + uid, handleActiveCellPositionChange);
      }
    }
  }

  function unbindAncestorScrollEvents() {
    if (!$boundAncestors) {
      return;
    }
    $boundAncestors.unbind("scroll." + uid);
    $boundAncestors = null;
  }

  function updateColumnHeader(columnId, title, toolTip) {
    if (!initialized) { return; }
    var idx = getColumnIndex(columnId);
    if (idx == null) {
      return;
    }

    var columnDef = columns[idx];
    var $header = $headers.children().eq(idx);
    if ($header) {
      if (title !== undefined) {
        columns[idx].name = title;
      }
      if (toolTip !== undefined) {
        columns[idx].toolTip = toolTip;
      }

      trigger(self.onBeforeHeaderCellDestroy, {
        "node": $header[0],
        "column": columnDef
      });

      $header
          .attr("title", toolTip || "")
          .children().eq(0).html(title);

      trigger(self.onHeaderCellRendered, {
        "node": $header[0],
        "column": columnDef
      });
    }
  }

  function getHeaderRow() {
    return $headerRow[0];
  }

  function getHeaderRowColumn(columnId) {
    var idx = getColumnIndex(columnId);
    var $header = $headerRow.children().eq(idx);
    return $header && $header[0];
  }

  function createColumnHeaders() {
    function onMouseEnter() {
      $(this).addClass("bk-ui-state-hover");
    }

    function onMouseLeave() {
      $(this).removeClass("bk-ui-state-hover");
    }

    $headers.find(".bk-slick-header-column")
      .each(function() {
        var columnDef = $(this).data("column");
        if (columnDef) {
          trigger(self.onBeforeHeaderCellDestroy, {
            "node": this,
            "column": columnDef
          });
        }
      });
    $headers.empty();
    $headers.width(getHeadersWidth());

    $headerRow.find(".bk-slick-headerrow-column")
      .each(function() {
        var columnDef = $(this).data("column");
        if (columnDef) {
          trigger(self.onBeforeHeaderRowCellDestroy, {
            "node": this,
            "column": columnDef
          });
        }
      });
    $headerRow.empty();

    for (var i = 0; i < columns.length; i++) {
      var m = columns[i];

      var header = $("<div class='bk-ui-state-default bk-slick-header-column' />")
          .html("<span class='bk-slick-column-name'>" + m.name + "</span>")
          .width(m.width - headerColumnWidthDiff)
          .attr("id", "" + uid + m.id)
          .attr("title", m.toolTip || "")
          .data("column", m)
          .addClass(m.headerCssClass || "")
          .appendTo($headers);

      if (options.enableColumnReorder || m.sortable) {
        header
          .on('mouseenter', onMouseEnter)
          .on('mouseleave', onMouseLeave);
      }

      if (m.sortable) {
        header.addClass("bk-slick-header-sortable");
        header.append("<span class='bk-slick-sort-indicator' />");
      }

      trigger(self.onHeaderCellRendered, {
        "node": header[0],
        "column": m
      });

      if (options.showHeaderRow) {
        var headerRowCell = $("<div class='bk-ui-state-default bk-slick-headerrow-column l" + i + " r" + i + "'></div>")
            .data("column", m)
            .appendTo($headerRow);

        trigger(self.onHeaderRowCellRendered, {
          "node": headerRowCell[0],
          "column": m
        });
      }
    }

    setSortColumns(sortColumns);
    setupColumnResize();
    if (options.enableColumnReorder) {
      setupColumnReorder();
    }
  }

  function setupColumnSort() {
    $headers.click(function (e) {
      // temporary workaround for a bug in jQuery 1.7.1 (http://bugs.jquery.com/ticket/11328)
      e.metaKey = e.metaKey || e.ctrlKey;

      if ($(e.target).hasClass("bk-slick-resizable-handle")) {
        return;
      }

      var $col = $(e.target).closest(".bk-slick-header-column");
      if (!$col.length) {
        return;
      }

      var column = $col.data("column");
      if (column.sortable) {
        if (!getEditorLock().commitCurrentEdit()) {
          return;
        }

        var sortOpts = null;
        var i = 0;
        for (; i < sortColumns.length; i++) {
          if (sortColumns[i].columnId == column.id) {
            sortOpts = sortColumns[i];
            sortOpts.sortAsc = !sortOpts.sortAsc;
            break;
          }
        }

        if (e.metaKey && options.multiColumnSort) {
          if (sortOpts) {
            sortColumns.splice(i, 1);
          }
        }
        else {
          if ((!e.shiftKey && !e.metaKey) || !options.multiColumnSort) {
            sortColumns = [];
          }

          if (!sortOpts) {
            sortOpts = { columnId: column.id, sortAsc: column.defaultSortAsc };
            sortColumns.push(sortOpts);
          } else if (sortColumns.length == 0) {
            sortColumns.push(sortOpts);
          }
        }

        setSortColumns(sortColumns);

        if (!options.multiColumnSort) {
          trigger(self.onSort, {
            multiColumnSort: false,
            sortCol: column,
            sortAsc: sortOpts.sortAsc}, e);
        } else {
          trigger(self.onSort, {
            multiColumnSort: true,
            sortCols: $.map(sortColumns, function(col) {
              return {sortCol: columns[getColumnIndex(col.columnId)], sortAsc: col.sortAsc };
            })}, e);
        }
      }
    });
  }

  function setupColumnReorder() {
    $headers.filter(":ui-sortable").sortable("destroy");
    $headers.sortable({
      containment: "parent",
      distance: 3,
      axis: "x",
      cursor: "default",
      tolerance: "intersection",
      helper: "clone",
      placeholder: "bk-slick-sortable-placeholder bk-ui-state-default bk-slick-header-column",
      start: function (e, ui) {
        ui.placeholder.width(ui.helper.outerWidth() - headerColumnWidthDiff);
        $(ui.helper).addClass("bk-slick-header-column-active");
      },
      beforeStop: function (e, ui) {
        $(ui.helper).removeClass("bk-slick-header-column-active");
      },
      stop: function (e) {
        if (!getEditorLock().commitCurrentEdit()) {
          $(this).sortable("cancel");
          return;
        }

        var reorderedIds = $headers.sortable("toArray");
        var reorderedColumns = [];
        for (var i = 0; i < reorderedIds.length; i++) {
          reorderedColumns.push(columns[getColumnIndex(reorderedIds[i].replace(uid, ""))]);
        }
        setColumns(reorderedColumns);

        trigger(self.onColumnsReordered, {});
        e.stopPropagation();
        setupColumnResize();
      }
    });
  }

  function setupColumnResize() {
    var $col, j, c, pageX, columnElements, minPageX, maxPageX, firstResizable, lastResizable;
    columnElements = $headers.children();
    columnElements.find(".bk-slick-resizable-handle").remove();
    columnElements.each(function (i, e) {
      if (columns[i].resizable) {
        if (firstResizable === undefined) {
          firstResizable = i;
        }
        lastResizable = i;
      }
    });
    if (firstResizable === undefined) {
      return;
    }
    columnElements.each(function (i, e) {
      if (i < firstResizable || (options.forceFitColumns && i >= lastResizable)) {
        return;
      }
      $col = $(e);
      $("<div class='bk-slick-resizable-handle' />")
          .appendTo(e)
          .bind("dragstart", function (e, dd) {
            if (!getEditorLock().commitCurrentEdit()) {
              return false;
            }
            pageX = e.pageX;
            $(this).parent().addClass("bk-slick-header-column-active");
            var shrinkLeewayOnRight = null, stretchLeewayOnRight = null;
            // lock each column's width option to current width
            columnElements.each(function (i, e) {
              columns[i].previousWidth = $(e).outerWidth();
            });
            if (options.forceFitColumns) {
              shrinkLeewayOnRight = 0;
              stretchLeewayOnRight = 0;
              // colums on right affect maxPageX/minPageX
              for (j = i + 1; j < columnElements.length; j++) {
                c = columns[j];
                if (c.resizable) {
                  if (stretchLeewayOnRight !== null) {
                    if (c.maxWidth) {
                      stretchLeewayOnRight += c.maxWidth - c.previousWidth;
                    } else {
                      stretchLeewayOnRight = null;
                    }
                  }
                  shrinkLeewayOnRight += c.previousWidth - Math.max(c.minWidth || 0, absoluteColumnMinWidth);
                }
              }
            }
            var shrinkLeewayOnLeft = 0, stretchLeewayOnLeft = 0;
            for (j = 0; j <= i; j++) {
              // columns on left only affect minPageX
              c = columns[j];
              if (c.resizable) {
                if (stretchLeewayOnLeft !== null) {
                  if (c.maxWidth) {
                    stretchLeewayOnLeft += c.maxWidth - c.previousWidth;
                  } else {
                    stretchLeewayOnLeft = null;
                  }
                }
                shrinkLeewayOnLeft += c.previousWidth - Math.max(c.minWidth || 0, absoluteColumnMinWidth);
              }
            }
            if (shrinkLeewayOnRight === null) {
              shrinkLeewayOnRight = 100000;
            }
            if (shrinkLeewayOnLeft === null) {
              shrinkLeewayOnLeft = 100000;
            }
            if (stretchLeewayOnRight === null) {
              stretchLeewayOnRight = 100000;
            }
            if (stretchLeewayOnLeft === null) {
              stretchLeewayOnLeft = 100000;
            }
            maxPageX = pageX + Math.min(shrinkLeewayOnRight, stretchLeewayOnLeft);
            minPageX = pageX - Math.min(shrinkLeewayOnLeft, stretchLeewayOnRight);
          })
          .bind("drag", function (e, dd) {
            var actualMinWidth, d = Math.min(maxPageX, Math.max(minPageX, e.pageX)) - pageX, x;
            if (d < 0) { // shrink column
              x = d;
              for (j = i; j >= 0; j--) {
                c = columns[j];
                if (c.resizable) {
                  actualMinWidth = Math.max(c.minWidth || 0, absoluteColumnMinWidth);
                  if (x && c.previousWidth + x < actualMinWidth) {
                    x += c.previousWidth - actualMinWidth;
                    c.width = actualMinWidth;
                  } else {
                    c.width = c.previousWidth + x;
                    x = 0;
                  }
                }
              }

              if (options.forceFitColumns) {
                x = -d;
                for (j = i + 1; j < columnElements.length; j++) {
                  c = columns[j];
                  if (c.resizable) {
                    if (x && c.maxWidth && (c.maxWidth - c.previousWidth < x)) {
                      x -= c.maxWidth - c.previousWidth;
                      c.width = c.maxWidth;
                    } else {
                      c.width = c.previousWidth + x;
                      x = 0;
                    }
                  }
                }
              }
            } else { // stretch column
              x = d;
              for (j = i; j >= 0; j--) {
                c = columns[j];
                if (c.resizable) {
                  if (x && c.maxWidth && (c.maxWidth - c.previousWidth < x)) {
                    x -= c.maxWidth - c.previousWidth;
                    c.width = c.maxWidth;
                  } else {
                    c.width = c.previousWidth + x;
                    x = 0;
                  }
                }
              }

              if (options.forceFitColumns) {
                x = -d;
                for (j = i + 1; j < columnElements.length; j++) {
                  c = columns[j];
                  if (c.resizable) {
                    actualMinWidth = Math.max(c.minWidth || 0, absoluteColumnMinWidth);
                    if (x && c.previousWidth + x < actualMinWidth) {
                      x += c.previousWidth - actualMinWidth;
                      c.width = actualMinWidth;
                    } else {
                      c.width = c.previousWidth + x;
                      x = 0;
                    }
                  }
                }
              }
            }
            applyColumnHeaderWidths();
            if (options.syncColumnCellResize) {
              applyColumnWidths();
            }
          })
          .bind("dragend", function (e, dd) {
            var newWidth;
            $(this).parent().removeClass("bk-slick-header-column-active");
            for (j = 0; j < columnElements.length; j++) {
              c = columns[j];
              newWidth = $(columnElements[j]).outerWidth();

              if (c.previousWidth !== newWidth && c.rerenderOnResize) {
                invalidateAllRows();
              }
            }
            updateCanvasWidth(true);
            render();
            trigger(self.onColumnsResized, {});
          });
    });
  }

  function getVBoxDelta($el) {
    var p = ["borderTopWidth", "borderBottomWidth", "paddingTop", "paddingBottom"];
    var delta = 0;
    $.each(p, function (n, val) {
      delta += parseFloat($el.css(val)) || 0;
    });
    return delta;
  }

  function measureCellPaddingAndBorder() {
    var el;
    var h = ["borderLeftWidth", "borderRightWidth", "paddingLeft", "paddingRight"];
    var v = ["borderTopWidth", "borderBottomWidth", "paddingTop", "paddingBottom"];

    el = $("<div class='bk-ui-state-default bk-slick-header-column' style='visibility:hidden'>-</div>").appendTo($headers);
    headerColumnWidthDiff = headerColumnHeightDiff = 0;
    if (el.css("box-sizing") != "border-box" && el.css("-moz-box-sizing") != "border-box" && el.css("-webkit-box-sizing") != "border-box") {
      $.each(h, function (n, val) {
        headerColumnWidthDiff += parseFloat(el.css(val)) || 0;
      });
      $.each(v, function (n, val) {
        headerColumnHeightDiff += parseFloat(el.css(val)) || 0;
      });
    }
    el.remove();

    var r = $("<div class='bk-slick-row' />").appendTo($canvas);
    el = $("<div class='bk-slick-cell' id='' style='visibility:hidden'>-</div>").appendTo(r);
    cellWidthDiff = cellHeightDiff = 0;
    if (el.css("box-sizing") != "border-box" && el.css("-moz-box-sizing") != "border-box" && el.css("-webkit-box-sizing") != "border-box") {
      $.each(h, function (n, val) {
        cellWidthDiff += parseFloat(el.css(val)) || 0;
      });
      $.each(v, function (n, val) {
        cellHeightDiff += parseFloat(el.css(val)) || 0;
      });
    }
    r.remove();

    absoluteColumnMinWidth = Math.max(headerColumnWidthDiff, cellWidthDiff);
  }

  function createCssRules() {
    $style = $("<style type='text/css' rel='stylesheet' />").appendTo($("head"));
    var rowHeight = (options.rowHeight - cellHeightDiff);
    var rules = [
      "." + uid + " .bk-slick-header-column { left: 1000px; }",
      "." + uid + " .bk-slick-top-panel { height:" + options.topPanelHeight + "px; }",
      "." + uid + " .bk-slick-headerrow-columns { height:" + options.headerRowHeight + "px; }",
      "." + uid + " .bk-slick-cell { height:" + rowHeight + "px; }",
      "." + uid + " .bk-slick-row { height:" + options.rowHeight + "px; }"
    ];

    for (var i = 0; i < columns.length; i++) {
      rules.push("." + uid + " .l" + i + " { }");
      rules.push("." + uid + " .r" + i + " { }");
    }

    if ($style[0].styleSheet) { // IE
      $style[0].styleSheet.cssText = rules.join(" ");
    } else {
      $style[0].appendChild(document.createTextNode(rules.join(" ")));
    }
  }

  function getColumnCssRules(idx) {
    if (!stylesheet) {
      var sheets = document.styleSheets;
      for (var i = 0; i < sheets.length; i++) {
        if ((sheets[i].ownerNode || sheets[i].owningElement) == $style[0]) {
          stylesheet = sheets[i];
          break;
        }
      }

      if (!stylesheet) {
        throw new Error("Cannot find stylesheet.");
      }

      // find and cache column CSS rules
      columnCssRulesL = [];
      columnCssRulesR = [];
      var cssRules = (stylesheet.cssRules || stylesheet.rules);
      var matches, columnIdx;
      for (var i = 0; i < cssRules.length; i++) {
        var selector = cssRules[i].selectorText;
        if (matches = /\.l\d+/.exec(selector)) {
          columnIdx = parseInt(matches[0].substr(2, matches[0].length - 2), 10);
          columnCssRulesL[columnIdx] = cssRules[i];
        } else if (matches = /\.r\d+/.exec(selector)) {
          columnIdx = parseInt(matches[0].substr(2, matches[0].length - 2), 10);
          columnCssRulesR[columnIdx] = cssRules[i];
        }
      }
    }

    return {
      "left": columnCssRulesL[idx],
      "right": columnCssRulesR[idx]
    };
  }

  function removeCssRules() {
    $style.remove();
    stylesheet = null;
  }

  function destroy() {
    getEditorLock().cancelCurrentEdit();

    trigger(self.onBeforeDestroy, {});

    var i = plugins.length;
    while(i--) {
      unregisterPlugin(plugins[i]);
    }

    if (options.enableColumnReorder) {
        $headers.filter(":ui-sortable").sortable("destroy");
    }

    unbindAncestorScrollEvents();
    $container.unbind(".bk-slickgrid");
    removeCssRules();

    $canvas.unbind("draginit dragstart dragend drag");
    $container.empty().removeClass(uid);
  }


  //////////////////////////////////////////////////////////////////////////////////////////////
  // General

  function trigger(evt, args, e) {
    e = e || new Slick.EventData();
    args = args || {};
    args.grid = self;
    return evt.notify(args, e, self);
  }

  function getEditorLock() {
    return options.editorLock;
  }

  function getEditController() {
    return editController;
  }

  function getColumnIndex(id) {
    return columnsById[id];
  }

  function autosizeColumns() {
    var i, c,
        widths = [],
        shrinkLeeway = 0,
        total = 0,
        prevTotal,
        availWidth = viewportHasVScroll ? viewportW - scrollbarDimensions.width : viewportW;

    for (i = 0; i < columns.length; i++) {
      c = columns[i];
      widths.push(c.width);
      total += c.width;
      if (c.resizable) {
        shrinkLeeway += c.width - Math.max(c.minWidth, absoluteColumnMinWidth);
      }
    }

    // shrink
    prevTotal = total;
    while (total > availWidth && shrinkLeeway) {
      var shrinkProportion = (total - availWidth) / shrinkLeeway;
      for (i = 0; i < columns.length && total > availWidth; i++) {
        c = columns[i];
        var width = widths[i];
        if (!c.resizable || width <= c.minWidth || width <= absoluteColumnMinWidth) {
          continue;
        }
        var absMinWidth = Math.max(c.minWidth, absoluteColumnMinWidth);
        var shrinkSize = Math.floor(shrinkProportion * (width - absMinWidth)) || 1;
        shrinkSize = Math.min(shrinkSize, width - absMinWidth);
        total -= shrinkSize;
        shrinkLeeway -= shrinkSize;
        widths[i] -= shrinkSize;
      }
      if (prevTotal <= total) {  // avoid infinite loop
        break;
      }
      prevTotal = total;
    }

    // grow
    prevTotal = total;
    while (total < availWidth) {
      var growProportion = availWidth / total;
      for (i = 0; i < columns.length && total < availWidth; i++) {
        c = columns[i];
        var currentWidth = widths[i];
        var growSize;

        if (!c.resizable || c.maxWidth <= currentWidth) {
          growSize = 0;
        } else {
          growSize = Math.min(Math.floor(growProportion * currentWidth) - currentWidth, (c.maxWidth - currentWidth) || 1000000) || 1;
        }
        total += growSize;
        widths[i] += growSize;
      }
      if (prevTotal >= total) {  // avoid infinite loop
        break;
      }
      prevTotal = total;
    }

    var reRender = false;
    for (i = 0; i < columns.length; i++) {
      if (columns[i].rerenderOnResize && columns[i].width != widths[i]) {
        reRender = true;
      }
      columns[i].width = widths[i];
    }

    applyColumnHeaderWidths();
    updateCanvasWidth(true);
    if (reRender) {
      invalidateAllRows();
      render();
    }
  }

  function applyColumnHeaderWidths() {
    if (!initialized) { return; }
    var h;
    for (var i = 0, headers = $headers.children(), ii = headers.length; i < ii; i++) {
      h = $(headers[i]);
      if (h.width() !== columns[i].width - headerColumnWidthDiff) {
        h.width(columns[i].width - headerColumnWidthDiff);
      }
    }

    updateColumnCaches();
  }

  function applyColumnWidths() {
    var x = 0, w, rule;
    for (var i = 0; i < columns.length; i++) {
      w = columns[i].width;

      rule = getColumnCssRules(i);
      rule.left.style.left = x + "px";
      rule.right.style.right = (canvasWidth - x - w) + "px";

      x += columns[i].width;
    }
  }

  function setSortColumn(columnId, ascending) {
    setSortColumns([{ columnId: columnId, sortAsc: ascending}]);
  }

  function setSortColumns(cols) {
    sortColumns = cols;

    var headerColumnEls = $headers.children();
    headerColumnEls
        .removeClass("bk-slick-header-column-sorted")
        .find(".bk-slick-sort-indicator")
            .removeClass("bk-slick-sort-indicator-asc bk-slick-sort-indicator-desc");

    $.each(sortColumns, function(i, col) {
      if (col.sortAsc == null) {
        col.sortAsc = true;
      }
      var columnIndex = getColumnIndex(col.columnId);
      if (columnIndex != null) {
        headerColumnEls.eq(columnIndex)
            .addClass("bk-slick-header-column-sorted")
            .find(".bk-slick-sort-indicator")
                .addClass(col.sortAsc ? "bk-slick-sort-indicator-asc" : "bk-slick-sort-indicator-desc");
      }
    });
  }

  function getSortColumns() {
    return sortColumns;
  }

  function handleSelectedRangesChanged(e, ranges) {
    selectedRows = [];
    var hash = {};
    for (var i = 0; i < ranges.length; i++) {
      for (var j = ranges[i].fromRow; j <= ranges[i].toRow; j++) {
        if (!hash[j]) {  // prevent duplicates
          selectedRows.push(j);
          hash[j] = {};
        }
        for (var k = ranges[i].fromCell; k <= ranges[i].toCell; k++) {
          if (canCellBeSelected(j, k)) {
            hash[j][columns[k].id] = options.selectedCellCssClass;
          }
        }
      }
    }

    setCellCssStyles(options.selectedCellCssClass, hash);

    trigger(self.onSelectedRowsChanged, {rows: getSelectedRows()}, e);
  }

  function getColumns() {
    return columns;
  }

  function updateColumnCaches() {
    // Pre-calculate cell boundaries.
    columnPosLeft = [];
    columnPosRight = [];
    var x = 0;
    for (var i = 0, ii = columns.length; i < ii; i++) {
      columnPosLeft[i] = x;
      columnPosRight[i] = x + columns[i].width;
      x += columns[i].width;
    }
  }

  function setColumns(columnDefinitions) {
    columns = columnDefinitions;

    columnsById = {};
    for (var i = 0; i < columns.length; i++) {
      var m = columns[i] = $.extend({}, columnDefaults, columns[i]);
      columnsById[m.id] = i;
      if (m.minWidth && m.width < m.minWidth) {
        m.width = m.minWidth;
      }
      if (m.maxWidth && m.width > m.maxWidth) {
        m.width = m.maxWidth;
      }
    }

    updateColumnCaches();

    if (initialized) {
      invalidateAllRows();
      createColumnHeaders();
      removeCssRules();
      createCssRules();
      resizeCanvas();
      applyColumnWidths();
      handleScroll();
    }
  }

  function getOptions() {
    return options;
  }

  function setOptions(args) {
    if (!getEditorLock().commitCurrentEdit()) {
      return;
    }

    makeActiveCellNormal();

    if (options.enableAddRow !== args.enableAddRow) {
      invalidateRow(getDataLength());
    }

    options = $.extend(options, args);
    validateAndEnforceOptions();

    $viewport.css("overflow-y", options.autoHeight ? "hidden" : "auto");
    render();
  }

  function validateAndEnforceOptions() {
    if (options.autoHeight) {
      options.leaveSpaceForNewRows = false;
    }
  }

  function setData(newData, scrollToTop) {
    data = newData;
    invalidateAllRows();
    updateRowCount();
    if (scrollToTop) {
      scrollTo(0);
    }
  }

  function getData() {
    return data;
  }

  function getDataLength() {
    if (data.getLength) {
      return data.getLength();
    } else {
      return data.length;
    }
  }

  function getDataLengthIncludingAddNew() {
    return getDataLength() + (options.enableAddRow ? 1 : 0);
  }

  function getDataItem(i) {
    if (data.getItem) {
      return data.getItem(i);
    } else {
      return data[i];
    }
  }

  function getTopPanel() {
    return $topPanel[0];
  }

  function setTopPanelVisibility(visible) {
    if (options.showTopPanel != visible) {
      options.showTopPanel = visible;
      if (visible) {
        $topPanelScroller.slideDown("fast", resizeCanvas);
      } else {
        $topPanelScroller.slideUp("fast", resizeCanvas);
      }
    }
  }

  function setHeaderRowVisibility(visible) {
    if (options.showHeaderRow != visible) {
      options.showHeaderRow = visible;
      if (visible) {
        $headerRowScroller.slideDown("fast", resizeCanvas);
      } else {
        $headerRowScroller.slideUp("fast", resizeCanvas);
      }
    }
  }

  function getContainerNode() {
    return $container.get(0);
  }

  //////////////////////////////////////////////////////////////////////////////////////////////
  // Rendering / Scrolling

  function getRowTop(row) {
    return options.rowHeight * row - offset;
  }

  function getRowFromPosition(y) {
    return Math.floor((y + offset) / options.rowHeight);
  }

  function scrollTo(y) {
    y = Math.max(y, 0);
    y = Math.min(y, th - viewportH + (viewportHasHScroll ? scrollbarDimensions.height : 0));

    var oldOffset = offset;

    page = Math.min(n - 1, Math.floor(y / ph));
    offset = Math.round(page * cj);
    var newScrollTop = y - offset;

    if (offset != oldOffset) {
      var range = getVisibleRange(newScrollTop);
      cleanupRows(range);
      updateRowPositions();
    }

    if (prevScrollTop != newScrollTop) {
      vScrollDir = (prevScrollTop + oldOffset < newScrollTop + offset) ? 1 : -1;
      $viewport[0].scrollTop = (lastRenderedScrollTop = scrollTop = prevScrollTop = newScrollTop);

      trigger(self.onViewportChanged, {});
    }
  }

  function defaultFormatter(row, cell, value, columnDef, dataContext) {
    if (value == null) {
      return "";
    } else {
      return (value + "").replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;");
    }
  }

  function getFormatter(row, column) {
    var rowMetadata = data.getItemMetadata && data.getItemMetadata(row);

    // look up by id, then index
    var columnOverrides = rowMetadata &&
        rowMetadata.columns &&
        (rowMetadata.columns[column.id] || rowMetadata.columns[getColumnIndex(column.id)]);

    var formatter =
        (columnOverrides && columnOverrides.formatter) ||
        (rowMetadata && rowMetadata.formatter) ||
        column.formatter ||
        (options.formatterFactory && options.formatterFactory.getFormatter(column)) ||
        options.defaultFormatter;

    if (formatter.format !== undefined) {
      var model = formatter;
      var format = function foo(row, cell, value, columnDef, dataContext) {
        return model.format(row, cell, value, columnDef, dataContext);
      }
      formatter = format
    }

    return formatter;
  }

  function getEditor(row, cell) {
    var editor;
    var column = columns[cell];
    var rowMetadata = data.getItemMetadata && data.getItemMetadata(row);
    var columnMetadata = rowMetadata && rowMetadata.columns;

    if (columnMetadata && columnMetadata[column.id] && columnMetadata[column.id].editor !== undefined) {
      editor = columnMetadata[column.id].editor;
    } else if (columnMetadata && columnMetadata[cell] && columnMetadata[cell].editor !== undefined) {
      editor = columnMetadata[cell].editor;
    } else {
      editor = column.editor || (options.editorFactory && options.editorFactory.getEditor(column));
    }

    if (editor.default_view !== undefined) {
      editor = editor.default_view;
    }

    return editor;
  }

  function getDataItemValueForColumn(item, columnDef) {
    if (options.dataItemColumnValueExtractor) {
      return options.dataItemColumnValueExtractor(item, columnDef);
    }
    return item[columnDef.field];
  }

  function appendRowHtml(stringArray, row, range, dataLength) {
    var d = getDataItem(row);
    var dataLoading = row < dataLength && !d;
    var rowCss = "bk-slick-row" +
        (dataLoading ? " loading" : "") +
        (row === activeRow ? " active" : "") +
        (row % 2 == 1 ? " odd" : " even");

    if (!d) {
      rowCss += " " + options.addNewRowCssClass;
    }

    var metadata = data.getItemMetadata && data.getItemMetadata(row);

    if (metadata && metadata.cssClasses) {
      rowCss += " " + metadata.cssClasses;
    }

    stringArray.push("<div class='bk-ui-widget-content " + rowCss + "' style='top:" + getRowTop(row) + "px'>");

    var colspan, m;
    for (var i = 0, ii = columns.length; i < ii; i++) {
      m = columns[i];
      colspan = 1;
      if (metadata && metadata.columns) {
        var columnData = metadata.columns[m.id] || metadata.columns[i];
        colspan = (columnData && columnData.colspan) || 1;
        if (colspan === "*") {
          colspan = ii - i;
        }
      }

      // Do not render cells outside of the viewport.
      if (columnPosRight[Math.min(ii - 1, i + colspan - 1)] > range.leftPx) {
        if (columnPosLeft[i] > range.rightPx) {
          // All columns to the right are outside the range.
          break;
        }

        appendCellHtml(stringArray, row, i, colspan, d);
      }

      if (colspan > 1) {
        i += (colspan - 1);
      }
    }

    stringArray.push("</div>");
  }

  function appendCellHtml(stringArray, row, cell, colspan, item) {
    var m = columns[cell];
    var cellCss = "bk-slick-cell l" + cell + " r" + Math.min(columns.length - 1, cell + colspan - 1) +
        (m.cssClass ? " " + m.cssClass : "");
    if (row === activeRow && cell === activeCell) {
      cellCss += (" active");
    }

    // TODO:  merge them together in the setter
    for (var key in cellCssClasses) {
      if (cellCssClasses[key][row] && cellCssClasses[key][row][m.id]) {
        cellCss += (" " + cellCssClasses[key][row][m.id]);
      }
    }

    stringArray.push("<div class='" + cellCss + "'>");

    // if there is a corresponding row (if not, this is the Add New row or this data hasn't been loaded yet)
    if (item) {
      var value = getDataItemValueForColumn(item, m);
      stringArray.push(getFormatter(row, m)(row, cell, value, m, item));
    }

    stringArray.push("</div>");

    rowsCache[row].cellRenderQueue.push(cell);
    rowsCache[row].cellColSpans[cell] = colspan;
  }


  function cleanupRows(rangeToKeep) {
    for (var i in rowsCache) {
      if (((i = parseInt(i, 10)) !== activeRow) && (i < rangeToKeep.top || i > rangeToKeep.bottom)) {
        removeRowFromCache(i);
      }
    }
  }

  function invalidate() {
    updateRowCount();
    invalidateAllRows();
    render();
  }

  function invalidateAllRows() {
    if (currentEditor) {
      makeActiveCellNormal();
    }
    for (var row in rowsCache) {
      removeRowFromCache(row);
    }
  }

  function removeRowFromCache(row) {
    var cacheEntry = rowsCache[row];
    if (!cacheEntry) {
      return;
    }

    if (rowNodeFromLastMouseWheelEvent == cacheEntry.rowNode) {
      cacheEntry.rowNode.style.display = 'none';
      zombieRowNodeFromLastMouseWheelEvent = rowNodeFromLastMouseWheelEvent;
    } else {
      $canvas[0].removeChild(cacheEntry.rowNode);
    }

    delete rowsCache[row];
    delete postProcessedRows[row];
    renderedRows--;
    counter_rows_removed++;
  }

  function invalidateRows(rows) {
    var i, rl;
    if (!rows || !rows.length) {
      return;
    }
    vScrollDir = 0;
    for (i = 0, rl = rows.length; i < rl; i++) {
      if (currentEditor && activeRow === rows[i]) {
        makeActiveCellNormal();
      }
      if (rowsCache[rows[i]]) {
        removeRowFromCache(rows[i]);
      }
    }
  }

  function invalidateRow(row) {
    invalidateRows([row]);
  }

  function updateCell(row, cell) {
    var cellNode = getCellNode(row, cell);
    if (!cellNode) {
      return;
    }

    var m = columns[cell], d = getDataItem(row);
    if (currentEditor && activeRow === row && activeCell === cell) {
      currentEditor.loadValue(d);
    } else {
      cellNode.innerHTML = d ? getFormatter(row, m)(row, cell, getDataItemValueForColumn(d, m), m, d) : "";
      invalidatePostProcessingResults(row);
    }
  }

  function updateRow(row) {
    var cacheEntry = rowsCache[row];
    if (!cacheEntry) {
      return;
    }

    ensureCellNodesInRowsCache(row);

    var d = getDataItem(row);

    for (var columnIdx in cacheEntry.cellNodesByColumnIdx) {
      if (!cacheEntry.cellNodesByColumnIdx.hasOwnProperty(columnIdx)) {
        continue;
      }

      columnIdx = columnIdx | 0;
      var m = columns[columnIdx],
          node = cacheEntry.cellNodesByColumnIdx[columnIdx];

      if (row === activeRow && columnIdx === activeCell && currentEditor) {
        currentEditor.loadValue(d);
      } else if (d) {
        node.innerHTML = getFormatter(row, m)(row, columnIdx, getDataItemValueForColumn(d, m), m, d);
      } else {
        node.innerHTML = "";
      }
    }

    invalidatePostProcessingResults(row);
  }

  function getViewportHeight() {
    return parseFloat($.css($container[0], "height", true)) -
        parseFloat($.css($container[0], "paddingTop", true)) -
        parseFloat($.css($container[0], "paddingBottom", true)) -
        parseFloat($.css($headerScroller[0], "height")) - getVBoxDelta($headerScroller) -
        (options.showTopPanel ? options.topPanelHeight + getVBoxDelta($topPanelScroller) : 0) -
        (options.showHeaderRow ? options.headerRowHeight + getVBoxDelta($headerRowScroller) : 0);
  }

  function resizeCanvas() {
    if (!initialized) { return; }
    if (options.autoHeight) {
      viewportH = options.rowHeight * getDataLengthIncludingAddNew();
    } else {
      viewportH = getViewportHeight();
    }

    numVisibleRows = Math.ceil(viewportH / options.rowHeight);
    viewportW = parseFloat($.css($container[0], "width", true));
    if (!options.autoHeight) {
      $viewport.height(viewportH);
    }

    if (options.forceFitColumns) {
      autosizeColumns();
    }

    updateRowCount();
    handleScroll();
    // Since the width has changed, force the render() to reevaluate virtually rendered cells.
    lastRenderedScrollLeft = -1;
    render();
  }

  function updateRowCount() {
    if (!initialized) { return; }

    var dataLengthIncludingAddNew = getDataLengthIncludingAddNew();
    var numberOfRows = dataLengthIncludingAddNew +
        (options.leaveSpaceForNewRows ? numVisibleRows - 1 : 0);

    var oldViewportHasVScroll = viewportHasVScroll;
    // with autoHeight, we do not need to accommodate the vertical scroll bar
    viewportHasVScroll = !options.autoHeight && (numberOfRows * options.rowHeight > viewportH);

    makeActiveCellNormal();

    // remove the rows that are now outside of the data range
    // this helps avoid redundant calls to .removeRow() when the size of the data decreased by thousands of rows
    var l = dataLengthIncludingAddNew - 1;
    for (var i in rowsCache) {
      if (i >= l) {
        removeRowFromCache(i);
      }
    }

    if (activeCellNode && activeRow > l) {
      resetActiveCell();
    }

    var oldH = h;
    th = Math.max(options.rowHeight * numberOfRows, viewportH - scrollbarDimensions.height);
    if (th < maxSupportedCssHeight) {
      // just one page
      h = ph = th;
      n = 1;
      cj = 0;
    } else {
      // break into pages
      h = maxSupportedCssHeight;
      ph = h / 100;
      n = Math.floor(th / ph);
      cj = (th - h) / (n - 1);
    }

    if (h !== oldH) {
      $canvas.css("height", h);
      scrollTop = $viewport[0].scrollTop;
    }

    var oldScrollTopInRange = (scrollTop + offset <= th - viewportH);

    if (th == 0 || scrollTop == 0) {
      page = offset = 0;
    } else if (oldScrollTopInRange) {
      // maintain virtual position
      scrollTo(scrollTop + offset);
    } else {
      // scroll to bottom
      scrollTo(th - viewportH);
    }

    if (h != oldH && options.autoHeight) {
      resizeCanvas();
    }

    if (options.forceFitColumns && oldViewportHasVScroll != viewportHasVScroll) {
      autosizeColumns();
    }
    updateCanvasWidth(false);
  }

  function getVisibleRange(viewportTop, viewportLeft) {
    if (viewportTop == null) {
      viewportTop = scrollTop;
    }
    if (viewportLeft == null) {
      viewportLeft = scrollLeft;
    }

    return {
      top: getRowFromPosition(viewportTop),
      bottom: getRowFromPosition(viewportTop + viewportH) + 1,
      leftPx: viewportLeft,
      rightPx: viewportLeft + viewportW
    };
  }

  function getRenderedRange(viewportTop, viewportLeft) {
    var range = getVisibleRange(viewportTop, viewportLeft);
    var buffer = Math.round(viewportH / options.rowHeight);
    var minBuffer = 3;

    if (vScrollDir == -1) {
      range.top -= buffer;
      range.bottom += minBuffer;
    } else if (vScrollDir == 1) {
      range.top -= minBuffer;
      range.bottom += buffer;
    } else {
      range.top -= minBuffer;
      range.bottom += minBuffer;
    }

    range.top = Math.max(0, range.top);
    range.bottom = Math.min(getDataLengthIncludingAddNew() - 1, range.bottom);

    range.leftPx -= viewportW;
    range.rightPx += viewportW;

    range.leftPx = Math.max(0, range.leftPx);
    range.rightPx = Math.min(canvasWidth, range.rightPx);

    return range;
  }

  function ensureCellNodesInRowsCache(row) {
    var cacheEntry = rowsCache[row];
    if (cacheEntry) {
      if (cacheEntry.cellRenderQueue.length) {
        var lastChild = cacheEntry.rowNode.lastChild;
        while (cacheEntry.cellRenderQueue.length) {
          var columnIdx = cacheEntry.cellRenderQueue.pop();
          cacheEntry.cellNodesByColumnIdx[columnIdx] = lastChild;
          lastChild = lastChild.previousSibling;
        }
      }
    }
  }

  function cleanUpCells(range, row) {
    var totalCellsRemoved = 0;
    var cacheEntry = rowsCache[row];

    // Remove cells outside the range.
    var cellsToRemove = [];
    for (var i in cacheEntry.cellNodesByColumnIdx) {
      // I really hate it when people mess with Array.prototype.
      if (!cacheEntry.cellNodesByColumnIdx.hasOwnProperty(i)) {
        continue;
      }

      // This is a string, so it needs to be cast back to a number.
      i = i | 0;

      var colspan = cacheEntry.cellColSpans[i];
      if (columnPosLeft[i] > range.rightPx ||
        columnPosRight[Math.min(columns.length - 1, i + colspan - 1)] < range.leftPx) {
        if (!(row == activeRow && i == activeCell)) {
          cellsToRemove.push(i);
        }
      }
    }

    var cellToRemove;
    while ((cellToRemove = cellsToRemove.pop()) != null) {
      cacheEntry.rowNode.removeChild(cacheEntry.cellNodesByColumnIdx[cellToRemove]);
      delete cacheEntry.cellColSpans[cellToRemove];
      delete cacheEntry.cellNodesByColumnIdx[cellToRemove];
      if (postProcessedRows[row]) {
        delete postProcessedRows[row][cellToRemove];
      }
      totalCellsRemoved++;
    }
  }

  function cleanUpAndRenderCells(range) {
    var cacheEntry;
    var stringArray = [];
    var processedRows = [];
    var cellsAdded;
    var totalCellsAdded = 0;
    var colspan;

    for (var row = range.top, btm = range.bottom; row <= btm; row++) {
      cacheEntry = rowsCache[row];
      if (!cacheEntry) {
        continue;
      }

      // cellRenderQueue populated in renderRows() needs to be cleared first
      ensureCellNodesInRowsCache(row);

      cleanUpCells(range, row);

      // Render missing cells.
      cellsAdded = 0;

      var metadata = data.getItemMetadata && data.getItemMetadata(row);
      metadata = metadata && metadata.columns;

      var d = getDataItem(row);

      // TODO:  shorten this loop (index? heuristics? binary search?)
      for (var i = 0, ii = columns.length; i < ii; i++) {
        // Cells to the right are outside the range.
        if (columnPosLeft[i] > range.rightPx) {
          break;
        }

        // Already rendered.
        if ((colspan = cacheEntry.cellColSpans[i]) != null) {
          i += (colspan > 1 ? colspan - 1 : 0);
          continue;
        }

        colspan = 1;
        if (metadata) {
          var columnData = metadata[columns[i].id] || metadata[i];
          colspan = (columnData && columnData.colspan) || 1;
          if (colspan === "*") {
            colspan = ii - i;
          }
        }

        if (columnPosRight[Math.min(ii - 1, i + colspan - 1)] > range.leftPx) {
          appendCellHtml(stringArray, row, i, colspan, d);
          cellsAdded++;
        }

        i += (colspan > 1 ? colspan - 1 : 0);
      }

      if (cellsAdded) {
        totalCellsAdded += cellsAdded;
        processedRows.push(row);
      }
    }

    if (!stringArray.length) {
      return;
    }

    var x = document.createElement("div");
    x.innerHTML = stringArray.join("");

    var processedRow;
    var node;
    while ((processedRow = processedRows.pop()) != null) {
      cacheEntry = rowsCache[processedRow];
      var columnIdx;
      while ((columnIdx = cacheEntry.cellRenderQueue.pop()) != null) {
        node = x.lastChild;
        cacheEntry.rowNode.appendChild(node);
        cacheEntry.cellNodesByColumnIdx[columnIdx] = node;
      }
    }
  }

  function renderRows(range) {
    var parentNode = $canvas[0],
        stringArray = [],
        rows = [],
        needToReselectCell = false,
        dataLength = getDataLength();

    for (var i = range.top, ii = range.bottom; i <= ii; i++) {
      if (rowsCache[i]) {
        continue;
      }
      renderedRows++;
      rows.push(i);

      // Create an entry right away so that appendRowHtml() can
      // start populatating it.
      rowsCache[i] = {
        "rowNode": null,

        // ColSpans of rendered cells (by column idx).
        // Can also be used for checking whether a cell has been rendered.
        "cellColSpans": [],

        // Cell nodes (by column idx).  Lazy-populated by ensureCellNodesInRowsCache().
        "cellNodesByColumnIdx": [],

        // Column indices of cell nodes that have been rendered, but not yet indexed in
        // cellNodesByColumnIdx.  These are in the same order as cell nodes added at the
        // end of the row.
        "cellRenderQueue": []
      };

      appendRowHtml(stringArray, i, range, dataLength);
      if (activeCellNode && activeRow === i) {
        needToReselectCell = true;
      }
      counter_rows_rendered++;
    }

    if (!rows.length) { return; }

    var x = document.createElement("div");
    x.innerHTML = stringArray.join("");

    for (var i = 0, ii = rows.length; i < ii; i++) {
      rowsCache[rows[i]].rowNode = parentNode.appendChild(x.firstChild);
    }

    if (needToReselectCell) {
      activeCellNode = getCellNode(activeRow, activeCell);
    }
  }

  function startPostProcessing() {
    if (!options.enableAsyncPostRender) {
      return;
    }
    clearTimeout(h_postrender);
    h_postrender = setTimeout(asyncPostProcessRows, options.asyncPostRenderDelay);
  }

  function invalidatePostProcessingResults(row) {
    delete postProcessedRows[row];
    postProcessFromRow = Math.min(postProcessFromRow, row);
    postProcessToRow = Math.max(postProcessToRow, row);
    startPostProcessing();
  }

  function updateRowPositions() {
    for (var row in rowsCache) {
      rowsCache[row].rowNode.style.top = getRowTop(row) + "px";
    }
  }

  function render() {
    if (!initialized) { return; }
    var visible = getVisibleRange();
    var rendered = getRenderedRange();

    // remove rows no longer in the viewport
    cleanupRows(rendered);

    // add new rows & missing cells in existing rows
    if (lastRenderedScrollLeft != scrollLeft) {
      cleanUpAndRenderCells(rendered);
    }

    // render missing rows
    renderRows(rendered);

    postProcessFromRow = visible.top;
    postProcessToRow = Math.min(getDataLengthIncludingAddNew() - 1, visible.bottom);
    startPostProcessing();

    lastRenderedScrollTop = scrollTop;
    lastRenderedScrollLeft = scrollLeft;
    h_render = null;
  }

  function handleHeaderRowScroll() {
    var scrollLeft = $headerRowScroller[0].scrollLeft;
    if (scrollLeft != $viewport[0].scrollLeft) {
      $viewport[0].scrollLeft = scrollLeft;
    }
  }

  function handleScroll() {
    scrollTop = $viewport[0].scrollTop;
    scrollLeft = $viewport[0].scrollLeft;
    var vScrollDist = Math.abs(scrollTop - prevScrollTop);
    var hScrollDist = Math.abs(scrollLeft - prevScrollLeft);

    if (hScrollDist) {
      prevScrollLeft = scrollLeft;
      $headerScroller[0].scrollLeft = scrollLeft;
      $topPanelScroller[0].scrollLeft = scrollLeft;
      $headerRowScroller[0].scrollLeft = scrollLeft;
    }

    if (vScrollDist) {
      vScrollDir = prevScrollTop < scrollTop ? 1 : -1;
      prevScrollTop = scrollTop;

      // switch virtual pages if needed
      if (vScrollDist < viewportH) {
        scrollTo(scrollTop + offset);
      } else {
        var oldOffset = offset;
        if (h == viewportH) {
          page = 0;
        } else {
          page = Math.min(n - 1, Math.floor(scrollTop * ((th - viewportH) / (h - viewportH)) * (1 / ph)));
        }
        offset = Math.round(page * cj);
        if (oldOffset != offset) {
          invalidateAllRows();
        }
      }
    }

    if (hScrollDist || vScrollDist) {
      if (h_render) {
        clearTimeout(h_render);
      }

      if (Math.abs(lastRenderedScrollTop - scrollTop) > 20 ||
          Math.abs(lastRenderedScrollLeft - scrollLeft) > 20) {
        if (options.forceSyncScrolling || (
            Math.abs(lastRenderedScrollTop - scrollTop) < viewportH &&
            Math.abs(lastRenderedScrollLeft - scrollLeft) < viewportW)) {
          render();
        } else {
          h_render = setTimeout(render, 50);
        }

        trigger(self.onViewportChanged, {});
      }
    }

    trigger(self.onScroll, {scrollLeft: scrollLeft, scrollTop: scrollTop});
  }

  function asyncPostProcessRows() {
    var dataLength = getDataLength();
    while (postProcessFromRow <= postProcessToRow) {
      var row = (vScrollDir >= 0) ? postProcessFromRow++ : postProcessToRow--;
      var cacheEntry = rowsCache[row];
      if (!cacheEntry || row >= dataLength) {
        continue;
      }

      if (!postProcessedRows[row]) {
        postProcessedRows[row] = {};
      }

      ensureCellNodesInRowsCache(row);
      for (var columnIdx in cacheEntry.cellNodesByColumnIdx) {
        if (!cacheEntry.cellNodesByColumnIdx.hasOwnProperty(columnIdx)) {
          continue;
        }

        columnIdx = columnIdx | 0;

        var m = columns[columnIdx];
        if (m.asyncPostRender && !postProcessedRows[row][columnIdx]) {
          var node = cacheEntry.cellNodesByColumnIdx[columnIdx];
          if (node) {
            m.asyncPostRender(node, row, getDataItem(row), m);
          }
          postProcessedRows[row][columnIdx] = true;
        }
      }

      h_postrender = setTimeout(asyncPostProcessRows, options.asyncPostRenderDelay);
      return;
    }
  }

  function updateCellCssStylesOnRenderedRows(addedHash, removedHash) {
    var node, columnId, addedRowHash, removedRowHash;
    for (var row in rowsCache) {
      removedRowHash = removedHash && removedHash[row];
      addedRowHash = addedHash && addedHash[row];

      if (removedRowHash) {
        for (columnId in removedRowHash) {
          if (!addedRowHash || removedRowHash[columnId] != addedRowHash[columnId]) {
            node = getCellNode(row, getColumnIndex(columnId));
            if (node) {
              $(node).removeClass(removedRowHash[columnId]);
            }
          }
        }
      }

      if (addedRowHash) {
        for (columnId in addedRowHash) {
          if (!removedRowHash || removedRowHash[columnId] != addedRowHash[columnId]) {
            node = getCellNode(row, getColumnIndex(columnId));
            if (node) {
              $(node).addClass(addedRowHash[columnId]);
            }
          }
        }
      }
    }
  }

  function addCellCssStyles(key, hash) {
    if (cellCssClasses[key]) {
      throw "addCellCssStyles: cell CSS hash with key '" + key + "' already exists.";
    }

    cellCssClasses[key] = hash;
    updateCellCssStylesOnRenderedRows(hash, null);

    trigger(self.onCellCssStylesChanged, { "key": key, "hash": hash });
  }

  function removeCellCssStyles(key) {
    if (!cellCssClasses[key]) {
      return;
    }

    updateCellCssStylesOnRenderedRows(null, cellCssClasses[key]);
    delete cellCssClasses[key];

    trigger(self.onCellCssStylesChanged, { "key": key, "hash": null });
  }

  function setCellCssStyles(key, hash) {
    var prevHash = cellCssClasses[key];

    cellCssClasses[key] = hash;
    updateCellCssStylesOnRenderedRows(hash, prevHash);

    trigger(self.onCellCssStylesChanged, { "key": key, "hash": hash });
  }

  function getCellCssStyles(key) {
    return cellCssClasses[key];
  }

  function flashCell(row, cell, speed) {
    speed = speed || 100;
    if (rowsCache[row]) {
      var $cell = $(getCellNode(row, cell));

      var toggleCellClass = function foo(times) {
        if (!times) {
          return;
        }
        setTimeout(function () {
              $cell.queue(function () {
                $cell.toggleClass(options.cellFlashingCssClass).dequeue();
                toggleCellClass(times - 1);
              });
            },
            speed);
      }

      toggleCellClass(4);
    }
  }

  //////////////////////////////////////////////////////////////////////////////////////////////
  // Interactivity

  function handleMouseWheel(e) {
    var rowNode = $(e.target).closest(".bk-slick-row")[0];
    if (rowNode != rowNodeFromLastMouseWheelEvent) {
      if (zombieRowNodeFromLastMouseWheelEvent && zombieRowNodeFromLastMouseWheelEvent != rowNode) {
        $canvas[0].removeChild(zombieRowNodeFromLastMouseWheelEvent);
        zombieRowNodeFromLastMouseWheelEvent = null;
      }
      rowNodeFromLastMouseWheelEvent = rowNode;
    }
  }

  function handleDragInit(e, dd) {
    var cell = getCellFromEvent(e);
    if (!cell || !cellExists(cell.row, cell.cell)) {
      return false;
    }

    var retval = trigger(self.onDragInit, dd, e);
    if (e.isImmediatePropagationStopped()) {
      return retval;
    }

    // if nobody claims to be handling drag'n'drop by stopping immediate propagation,
    // cancel out of it
    return false;
  }

  function handleDragStart(e, dd) {
    var cell = getCellFromEvent(e);
    if (!cell || !cellExists(cell.row, cell.cell)) {
      return false;
    }

    var retval = trigger(self.onDragStart, dd, e);
    if (e.isImmediatePropagationStopped()) {
      return retval;
    }

    return false;
  }

  function handleDrag(e, dd) {
    return trigger(self.onDrag, dd, e);
  }

  function handleDragEnd(e, dd) {
    trigger(self.onDragEnd, dd, e);
  }

  function handleKeyDown(e) {
    trigger(self.onKeyDown, {row: activeRow, cell: activeCell}, e);
    var handled = e.isImmediatePropagationStopped();

    if (!handled) {
      if (!e.shiftKey && !e.altKey && !e.ctrlKey) {
        if (e.which == 27) {
          if (!getEditorLock().isActive()) {
            return; // no editing mode to cancel, allow bubbling and default processing (exit without cancelling the event)
          }
          cancelEditAndSetFocus();
        } else if (e.which == 34) {
          navigatePageDown();
          handled = true;
        } else if (e.which == 33) {
          navigatePageUp();
          handled = true;
        } else if (e.which == 37) {
          handled = navigateLeft();
        } else if (e.which == 39) {
          handled = navigateRight();
        } else if (e.which == 38) {
          handled = navigateUp();
        } else if (e.which == 40) {
          handled = navigateDown();
        } else if (e.which == 9) {
          handled = navigateNext();
        } else if (e.which == 13) {
          if (options.editable) {
            if (currentEditor) {
              // adding new row
              if (activeRow === getDataLength()) {
                navigateDown();
              } else {
                commitEditAndSetFocus();
              }
            } else {
              if (getEditorLock().commitCurrentEdit()) {
                makeActiveCellEditable();
              }
            }
          }
          handled = true;
        }
      } else if (e.which == 9 && e.shiftKey && !e.ctrlKey && !e.altKey) {
        handled = navigatePrev();
      }
    }

    if (handled) {
      // the event has been handled so don't let parent element (bubbling/propagation) or browser (default) handle it
      e.stopPropagation();
      e.preventDefault();
      try {
        e.originalEvent.keyCode = 0; // prevent default behaviour for special keys in IE browsers (F3, F5, etc.)
      }
      // ignore exceptions - setting the original event's keycode throws access denied exception for "Ctrl"
      // (hitting control key only, nothing else), "Shift" (maybe others)
      catch (error) {
      }
    }
  }

  function handleClick(e) {
    if (!currentEditor) {
      // if this click resulted in some cell child node getting focus,
      // don't steal it back - keyboard events will still bubble up
      // IE9+ seems to default DIVs to tabIndex=0 instead of -1, so check for cell clicks directly.
      if (e.target != document.activeElement || $(e.target).hasClass("bk-slick-cell")) {
        setFocus();
      }
    }

    var cell = getCellFromEvent(e);
    if (!cell || (currentEditor !== null && activeRow == cell.row && activeCell == cell.cell)) {
      return;
    }

    trigger(self.onClick, {row: cell.row, cell: cell.cell}, e);
    if (e.isImmediatePropagationStopped()) {
      return;
    }

    if ((activeCell != cell.cell || activeRow != cell.row) && canCellBeActive(cell.row, cell.cell)) {
      if (!getEditorLock().isActive() || getEditorLock().commitCurrentEdit()) {
        scrollRowIntoView(cell.row, false);
        setActiveCellInternal(getCellNode(cell.row, cell.cell));
      }
    }
  }

  function handleContextMenu(e) {
    var $cell = $(e.target).closest(".bk-slick-cell", $canvas);
    if ($cell.length === 0) {
      return;
    }

    // are we editing this cell?
    if (activeCellNode === $cell[0] && currentEditor !== null) {
      return;
    }

    trigger(self.onContextMenu, {}, e);
  }

  function handleDblClick(e) {
    var cell = getCellFromEvent(e);
    if (!cell || (currentEditor !== null && activeRow == cell.row && activeCell == cell.cell)) {
      return;
    }

    trigger(self.onDblClick, {row: cell.row, cell: cell.cell}, e);
    if (e.isImmediatePropagationStopped()) {
      return;
    }

    if (options.editable) {
      gotoCell(cell.row, cell.cell, true);
    }
  }

  function handleHeaderMouseEnter(e) {
    trigger(self.onHeaderMouseEnter, {
      "column": $(this).data("column")
    }, e);
  }

  function handleHeaderMouseLeave(e) {
    trigger(self.onHeaderMouseLeave, {
      "column": $(this).data("column")
    }, e);
  }

  function handleHeaderContextMenu(e) {
    var $header = $(e.target).closest(".bk-slick-header-column", ".bk-slick-header-columns");
    var column = $header && $header.data("column");
    trigger(self.onHeaderContextMenu, {column: column}, e);
  }

  function handleHeaderClick(e) {
    var $header = $(e.target).closest(".bk-slick-header-column", ".bk-slick-header-columns");
    var column = $header && $header.data("column");
    if (column) {
      trigger(self.onHeaderClick, {column: column}, e);
    }
  }

  function handleMouseEnter(e) {
    trigger(self.onMouseEnter, {}, e);
  }

  function handleMouseLeave(e) {
    trigger(self.onMouseLeave, {}, e);
  }

  function cellExists(row, cell) {
    return !(row < 0 || row >= getDataLength() || cell < 0 || cell >= columns.length);
  }

  function getCellFromPoint(x, y) {
    var row = getRowFromPosition(y);
    var cell = 0;

    var w = 0;
    for (var i = 0; i < columns.length && w < x; i++) {
      w += columns[i].width;
      cell++;
    }

    if (cell < 0) {
      cell = 0;
    }

    return {row: row, cell: cell - 1};
  }

  function getCellFromNode(cellNode) {
    // read column number from .l<columnNumber> CSS class
    var cls = /l\d+/.exec(cellNode.className);
    if (!cls) {
      throw "getCellFromNode: cannot get cell - " + cellNode.className;
    }
    return parseInt(cls[0].substr(1, cls[0].length - 1), 10);
  }

  function getRowFromNode(rowNode) {
    for (var row in rowsCache) {
      if (rowsCache[row].rowNode === rowNode) {
        return row | 0;
      }
    }

    return null;
  }

  function getCellFromEvent(e) {
    var $cell = $(e.target).closest(".bk-slick-cell", $canvas);
    if (!$cell.length) {
      return null;
    }

    var row = getRowFromNode($cell[0].parentNode);
    var cell = getCellFromNode($cell[0]);

    if (row == null || cell == null) {
      return null;
    } else {
      return {
        "row": row,
        "cell": cell
      };
    }
  }

  function getCellNodeBox(row, cell) {
    if (!cellExists(row, cell)) {
      return null;
    }

    var y1 = getRowTop(row);
    var y2 = y1 + options.rowHeight - 1;
    var x1 = 0;
    for (var i = 0; i < cell; i++) {
      x1 += columns[i].width;
    }
    var x2 = x1 + columns[cell].width;

    return {
      top: y1,
      left: x1,
      bottom: y2,
      right: x2
    };
  }

  //////////////////////////////////////////////////////////////////////////////////////////////
  // Cell switching

  function resetActiveCell() {
    setActiveCellInternal(null, false);
  }

  function setFocus() {
    if (tabbingDirection == -1) {
      $focusSink[0].focus();
    } else {
      $focusSink2[0].focus();
    }
  }

  function scrollCellIntoView(row, cell, doPaging) {
    scrollRowIntoView(row, doPaging);

    var colspan = getColspan(row, cell);
    var left = columnPosLeft[cell],
      right = columnPosRight[cell + (colspan > 1 ? colspan - 1 : 0)],
      scrollRight = scrollLeft + viewportW;

    if (left < scrollLeft) {
      $viewport.scrollLeft(left);
      handleScroll();
      render();
    } else if (right > scrollRight) {
      $viewport.scrollLeft(Math.min(left, right - $viewport[0].clientWidth));
      handleScroll();
      render();
    }
  }

  function setActiveCellInternal(newCell, opt_editMode) {
    if (activeCellNode !== null) {
      makeActiveCellNormal();
      $(activeCellNode).removeClass("active");
      if (rowsCache[activeRow]) {
        $(rowsCache[activeRow].rowNode).removeClass("active");
      }
    }

    var activeCellChanged = (activeCellNode !== newCell);
    activeCellNode = newCell;

    if (activeCellNode != null) {
      activeRow = getRowFromNode(activeCellNode.parentNode);
      activeCell = activePosX = getCellFromNode(activeCellNode);

      if (opt_editMode == null) {
        opt_editMode = (activeRow == getDataLength()) || options.autoEdit;
      }

      $(activeCellNode).addClass("active");
      $(rowsCache[activeRow].rowNode).addClass("active");

      if (options.editable && opt_editMode && isCellPotentiallyEditable(activeRow, activeCell)) {
        clearTimeout(h_editorLoader);

        if (options.asyncEditorLoading) {
          h_editorLoader = setTimeout(function () {
            makeActiveCellEditable();
          }, options.asyncEditorLoadDelay);
        } else {
          makeActiveCellEditable();
        }
      }
    } else {
      activeRow = activeCell = null;
    }

    if (activeCellChanged) {
      trigger(self.onActiveCellChanged, getActiveCell());
    }
  }

  function clearTextSelection() {
    if (document.selection && document.selection.empty) {
      try {
        //IE fails here if selected element is not in dom
        document.selection.empty();
      } catch (e) { }
    } else if (window.getSelection) {
      var sel = window.getSelection();
      if (sel && sel.removeAllRanges) {
        sel.removeAllRanges();
      }
    }
  }

  function isCellPotentiallyEditable(row, cell) {
    var dataLength = getDataLength();
    // is the data for this row loaded?
    if (row < dataLength && !getDataItem(row)) {
      return false;
    }

    // are we in the Add New row?  can we create new from this cell?
    if (columns[cell].cannotTriggerInsert && row >= dataLength) {
      return false;
    }

    // does this cell have an editor?
    if (!getEditor(row, cell)) {
      return false;
    }

    return true;
  }

  function makeActiveCellNormal() {
    if (!currentEditor) {
      return;
    }
    trigger(self.onBeforeCellEditorDestroy, {editor: currentEditor});
    currentEditor.destroy();
    currentEditor = null;

    if (activeCellNode) {
      var d = getDataItem(activeRow);
      $(activeCellNode).removeClass("editable invalid");
      if (d) {
        var column = columns[activeCell];
        var formatter = getFormatter(activeRow, column);
        activeCellNode.innerHTML = formatter(activeRow, activeCell, getDataItemValueForColumn(d, column), column, d);
        invalidatePostProcessingResults(activeRow);
      }
    }

    // if there previously was text selected on a page (such as selected text in the edit cell just removed),
    // IE can't set focus to anything else correctly
    if (navigator.userAgent.toLowerCase().match(/msie/)) {
      clearTextSelection();
    }

    getEditorLock().deactivate(editController);
  }

  function makeActiveCellEditable(editor) {
    if (!activeCellNode) {
      return;
    }
    if (!options.editable) {
      throw "Grid : makeActiveCellEditable : should never get called when options.editable is false";
    }

    // cancel pending async call if there is one
    clearTimeout(h_editorLoader);

    if (!isCellPotentiallyEditable(activeRow, activeCell)) {
      return;
    }

    var columnDef = columns[activeCell];
    var item = getDataItem(activeRow);

    if (trigger(self.onBeforeEditCell, {row: activeRow, cell: activeCell, item: item, column: columnDef}) === false) {
      setFocus();
      return;
    }

    getEditorLock().activate(editController);
    $(activeCellNode).addClass("editable");

    // don't clear the cell if a custom editor is passed through
    if (!editor) {
      activeCellNode.innerHTML = "";
    }

    currentEditor = new (editor || getEditor(activeRow, activeCell))({
      grid: self,
      gridPosition: absBox($container[0]),
      position: absBox(activeCellNode),
      container: activeCellNode,
      column: columnDef,
      item: item || {},
      commitChanges: commitEditAndSetFocus,
      cancelChanges: cancelEditAndSetFocus
    });

    if (item) {
      currentEditor.loadValue(item);
    }

    serializedEditorValue = currentEditor.serializeValue();

    if (currentEditor.position) {
      handleActiveCellPositionChange();
    }
  }

  function commitEditAndSetFocus() {
    // if the commit fails, it would do so due to a validation error
    // if so, do not steal the focus from the editor
    if (getEditorLock().commitCurrentEdit()) {
      setFocus();
      if (options.autoEdit) {
        navigateDown();
      }
    }
  }

  function cancelEditAndSetFocus() {
    if (getEditorLock().cancelCurrentEdit()) {
      setFocus();
    }
  }

  function absBox(elem) {
    var box = {
      top: elem.offsetTop,
      left: elem.offsetLeft,
      bottom: 0,
      right: 0,
      width: $(elem).outerWidth(),
      height: $(elem).outerHeight(),
      visible: true};
    box.bottom = box.top + box.height;
    box.right = box.left + box.width;

    // walk up the tree
    var offsetParent = elem.offsetParent;
    while ((elem = elem.parentNode) != document.body) {
      if (box.visible && elem.scrollHeight != elem.offsetHeight && $(elem).css("overflowY") != "visible") {
        box.visible = box.bottom > elem.scrollTop && box.top < elem.scrollTop + elem.clientHeight;
      }

      if (box.visible && elem.scrollWidth != elem.offsetWidth && $(elem).css("overflowX") != "visible") {
        box.visible = box.right > elem.scrollLeft && box.left < elem.scrollLeft + elem.clientWidth;
      }

      box.left -= elem.scrollLeft;
      box.top -= elem.scrollTop;

      if (elem === offsetParent) {
        box.left += elem.offsetLeft;
        box.top += elem.offsetTop;
        offsetParent = elem.offsetParent;
      }

      box.bottom = box.top + box.height;
      box.right = box.left + box.width;
    }

    return box;
  }

  function getActiveCellPosition() {
    return absBox(activeCellNode);
  }

  function getGridPosition() {
    return absBox($container[0])
  }

  function handleActiveCellPositionChange() {
    if (!activeCellNode) {
      return;
    }

    trigger(self.onActiveCellPositionChanged, {});

    if (currentEditor) {
      var cellBox = getActiveCellPosition();
      if (currentEditor.show && currentEditor.hide) {
        if (!cellBox.visible) {
          currentEditor.hide();
        } else {
          currentEditor.show();
        }
      }

      if (currentEditor.position) {
        currentEditor.position(cellBox);
      }
    }
  }

  function getCellEditor() {
    return currentEditor;
  }

  function getActiveCell() {
    if (!activeCellNode) {
      return null;
    } else {
      return {row: activeRow, cell: activeCell};
    }
  }

  function getActiveCellNode() {
    return activeCellNode;
  }

  function scrollRowIntoView(row, doPaging) {
    var rowAtTop = row * options.rowHeight;
    var rowAtBottom = (row + 1) * options.rowHeight - viewportH + (viewportHasHScroll ? scrollbarDimensions.height : 0);

    // need to page down?
    if ((row + 1) * options.rowHeight > scrollTop + viewportH + offset) {
      scrollTo(doPaging ? rowAtTop : rowAtBottom);
      render();
    }
    // or page up?
    else if (row * options.rowHeight < scrollTop + offset) {
      scrollTo(doPaging ? rowAtBottom : rowAtTop);
      render();
    }
  }

  function scrollRowToTop(row) {
    scrollTo(row * options.rowHeight);
    render();
  }

  function scrollPage(dir) {
    var deltaRows = dir * numVisibleRows;
    scrollTo((getRowFromPosition(scrollTop) + deltaRows) * options.rowHeight);
    render();

    if (options.enableCellNavigation && activeRow != null) {
      var row = activeRow + deltaRows;
      var dataLengthIncludingAddNew = getDataLengthIncludingAddNew();
      if (row >= dataLengthIncludingAddNew) {
        row = dataLengthIncludingAddNew - 1;
      }
      if (row < 0) {
        row = 0;
      }

      var cell = 0, prevCell = null;
      var prevActivePosX = activePosX;
      while (cell <= activePosX) {
        if (canCellBeActive(row, cell)) {
          prevCell = cell;
        }
        cell += getColspan(row, cell);
      }

      if (prevCell !== null) {
        setActiveCellInternal(getCellNode(row, prevCell));
        activePosX = prevActivePosX;
      } else {
        resetActiveCell();
      }
    }
  }

  function navigatePageDown() {
    scrollPage(1);
  }

  function navigatePageUp() {
    scrollPage(-1);
  }

  function getColspan(row, cell) {
    var metadata = data.getItemMetadata && data.getItemMetadata(row);
    if (!metadata || !metadata.columns) {
      return 1;
    }

    var columnData = metadata.columns[columns[cell].id] || metadata.columns[cell];
    var colspan = (columnData && columnData.colspan);
    if (colspan === "*") {
      colspan = columns.length - cell;
    } else {
      colspan = colspan || 1;
    }

    return colspan;
  }

  function findFirstFocusableCell(row) {
    var cell = 0;
    while (cell < columns.length) {
      if (canCellBeActive(row, cell)) {
        return cell;
      }
      cell += getColspan(row, cell);
    }
    return null;
  }

  function findLastFocusableCell(row) {
    var cell = 0;
    var lastFocusableCell = null;
    while (cell < columns.length) {
      if (canCellBeActive(row, cell)) {
        lastFocusableCell = cell;
      }
      cell += getColspan(row, cell);
    }
    return lastFocusableCell;
  }

  function gotoRight(row, cell, posX) {
    if (cell >= columns.length) {
      return null;
    }

    do {
      cell += getColspan(row, cell);
    }
    while (cell < columns.length && !canCellBeActive(row, cell));

    if (cell < columns.length) {
      return {
        "row": row,
        "cell": cell,
        "posX": cell
      };
    }
    return null;
  }

  function gotoLeft(row, cell, posX) {
    if (cell <= 0) {
      return null;
    }

    var firstFocusableCell = findFirstFocusableCell(row);
    if (firstFocusableCell === null || firstFocusableCell >= cell) {
      return null;
    }

    var prev = {
      "row": row,
      "cell": firstFocusableCell,
      "posX": firstFocusableCell
    };
    var pos;
    while (true) {
      pos = gotoRight(prev.row, prev.cell, prev.posX);
      if (!pos) {
        return null;
      }
      if (pos.cell >= cell) {
        return prev;
      }
      prev = pos;
    }
  }

  function gotoDown(row, cell, posX) {
    var prevCell;
    var dataLengthIncludingAddNew = getDataLengthIncludingAddNew();
    while (true) {
      if (++row >= dataLengthIncludingAddNew) {
        return null;
      }

      prevCell = cell = 0;
      while (cell <= posX) {
        prevCell = cell;
        cell += getColspan(row, cell);
      }

      if (canCellBeActive(row, prevCell)) {
        return {
          "row": row,
          "cell": prevCell,
          "posX": posX
        };
      }
    }
  }

  function gotoUp(row, cell, posX) {
    var prevCell;
    while (true) {
      if (--row < 0) {
        return null;
      }

      prevCell = cell = 0;
      while (cell <= posX) {
        prevCell = cell;
        cell += getColspan(row, cell);
      }

      if (canCellBeActive(row, prevCell)) {
        return {
          "row": row,
          "cell": prevCell,
          "posX": posX
        };
      }
    }
  }

  function gotoNext(row, cell, posX) {
    if (row == null && cell == null) {
      row = cell = posX = 0;
      if (canCellBeActive(row, cell)) {
        return {
          "row": row,
          "cell": cell,
          "posX": cell
        };
      }
    }

    var pos = gotoRight(row, cell, posX);
    if (pos) {
      return pos;
    }

    var firstFocusableCell = null;
    var dataLengthIncludingAddNew = getDataLengthIncludingAddNew();
    while (++row < dataLengthIncludingAddNew) {
      firstFocusableCell = findFirstFocusableCell(row);
      if (firstFocusableCell !== null) {
        return {
          "row": row,
          "cell": firstFocusableCell,
          "posX": firstFocusableCell
        };
      }
    }
    return null;
  }

  function gotoPrev(row, cell, posX) {
    if (row == null && cell == null) {
      row = getDataLengthIncludingAddNew() - 1;
      cell = posX = columns.length - 1;
      if (canCellBeActive(row, cell)) {
        return {
          "row": row,
          "cell": cell,
          "posX": cell
        };
      }
    }

    var pos;
    var lastSelectableCell;
    while (!pos) {
      pos = gotoLeft(row, cell, posX);
      if (pos) {
        break;
      }
      if (--row < 0) {
        return null;
      }

      cell = 0;
      lastSelectableCell = findLastFocusableCell(row);
      if (lastSelectableCell !== null) {
        pos = {
          "row": row,
          "cell": lastSelectableCell,
          "posX": lastSelectableCell
        };
      }
    }
    return pos;
  }

  function navigateRight() {
    return navigate("right");
  }

  function navigateLeft() {
    return navigate("left");
  }

  function navigateDown() {
    return navigate("down");
  }

  function navigateUp() {
    return navigate("up");
  }

  function navigateNext() {
    return navigate("next");
  }

  function navigatePrev() {
    return navigate("prev");
  }

  /**
   * @param {string} dir Navigation direction.
   * @return {boolean} Whether navigation resulted in a change of active cell.
   */
  function navigate(dir) {
    if (!options.enableCellNavigation) {
      return false;
    }

    if (!activeCellNode && dir != "prev" && dir != "next") {
      return false;
    }

    if (!getEditorLock().commitCurrentEdit()) {
      return true;
    }
    setFocus();

    var tabbingDirections = {
      "up": -1,
      "down": 1,
      "left": -1,
      "right": 1,
      "prev": -1,
      "next": 1
    };
    tabbingDirection = tabbingDirections[dir];

    var stepFunctions = {
      "up": gotoUp,
      "down": gotoDown,
      "left": gotoLeft,
      "right": gotoRight,
      "prev": gotoPrev,
      "next": gotoNext
    };
    var stepFn = stepFunctions[dir];
    var pos = stepFn(activeRow, activeCell, activePosX);
    if (pos) {
      var isAddNewRow = (pos.row == getDataLength());
      scrollCellIntoView(pos.row, pos.cell, !isAddNewRow);
      setActiveCellInternal(getCellNode(pos.row, pos.cell));
      activePosX = pos.posX;
      return true;
    } else {
      setActiveCellInternal(getCellNode(activeRow, activeCell));
      return false;
    }
  }

  function getCellNode(row, cell) {
    if (rowsCache[row]) {
      ensureCellNodesInRowsCache(row);
      return rowsCache[row].cellNodesByColumnIdx[cell];
    }
    return null;
  }

  function setActiveCell(row, cell) {
    if (!initialized) { return; }
    if (row > getDataLength() || row < 0 || cell >= columns.length || cell < 0) {
      return;
    }

    if (!options.enableCellNavigation) {
      return;
    }

    scrollCellIntoView(row, cell, false);
    setActiveCellInternal(getCellNode(row, cell), false);
  }

  function canCellBeActive(row, cell) {
    if (!options.enableCellNavigation || row >= getDataLengthIncludingAddNew() ||
        row < 0 || cell >= columns.length || cell < 0) {
      return false;
    }

    var rowMetadata = data.getItemMetadata && data.getItemMetadata(row);
    if (rowMetadata && typeof rowMetadata.focusable === "boolean") {
      return rowMetadata.focusable;
    }

    var columnMetadata = rowMetadata && rowMetadata.columns;
    if (columnMetadata && columnMetadata[columns[cell].id] && typeof columnMetadata[columns[cell].id].focusable === "boolean") {
      return columnMetadata[columns[cell].id].focusable;
    }
    if (columnMetadata && columnMetadata[cell] && typeof columnMetadata[cell].focusable === "boolean") {
      return columnMetadata[cell].focusable;
    }

    return columns[cell].focusable;
  }

  function canCellBeSelected(row, cell) {
    if (row >= getDataLength() || row < 0 || cell >= columns.length || cell < 0) {
      return false;
    }

    var rowMetadata = data.getItemMetadata && data.getItemMetadata(row);
    if (rowMetadata && typeof rowMetadata.selectable === "boolean") {
      return rowMetadata.selectable;
    }

    var columnMetadata = rowMetadata && rowMetadata.columns && (rowMetadata.columns[columns[cell].id] || rowMetadata.columns[cell]);
    if (columnMetadata && typeof columnMetadata.selectable === "boolean") {
      return columnMetadata.selectable;
    }

    return columns[cell].selectable;
  }

  function gotoCell(row, cell, forceEdit) {
    if (!initialized) { return; }
    if (!canCellBeActive(row, cell)) {
      return;
    }

    if (!getEditorLock().commitCurrentEdit()) {
      return;
    }

    scrollCellIntoView(row, cell, false);

    var newCell = getCellNode(row, cell);

    // if selecting the 'add new' row, start editing right away
    setActiveCellInternal(newCell, forceEdit || (row === getDataLength()) || options.autoEdit);

    // if no editor was created, set the focus back on the grid
    if (!currentEditor) {
      setFocus();
    }
  }


  //////////////////////////////////////////////////////////////////////////////////////////////
  // IEditor implementation for the editor lock

  function commitCurrentEdit() {
    var item = getDataItem(activeRow);
    var column = columns[activeCell];

    if (currentEditor) {
      if (currentEditor.isValueChanged()) {
        var validationResults = currentEditor.validate();

        if (validationResults.valid) {
          if (activeRow < getDataLength()) {
            var editCommand = {
              row: activeRow,
              cell: activeCell,
              editor: currentEditor,
              serializedValue: currentEditor.serializeValue(),
              prevSerializedValue: serializedEditorValue,
              execute: function () {
                this.editor.applyValue(item, this.serializedValue);
                updateRow(this.row);
                trigger(self.onCellChange, {
                  row: activeRow,
                  cell: activeCell,
                  item: item
                });
              },
              undo: function () {
                this.editor.applyValue(item, this.prevSerializedValue);
                updateRow(this.row);
                trigger(self.onCellChange, {
                  row: activeRow,
                  cell: activeCell,
                  item: item
                });
              }
            };

            if (options.editCommandHandler) {
              makeActiveCellNormal();
              options.editCommandHandler(item, column, editCommand);
            } else {
              editCommand.execute();
              makeActiveCellNormal();
            }

          } else {
            var newItem = {};
            currentEditor.applyValue(newItem, currentEditor.serializeValue());
            makeActiveCellNormal();
            trigger(self.onAddNewRow, {item: newItem, column: column});
          }

          // check whether the lock has been re-acquired by event handlers
          return !getEditorLock().isActive();
        } else {
          // Re-add the CSS class to trigger transitions, if any.
          $(activeCellNode).removeClass("invalid");
          $(activeCellNode).width();  // force layout
          $(activeCellNode).addClass("invalid");

          trigger(self.onValidationError, {
            editor: currentEditor,
            cellNode: activeCellNode,
            validationResults: validationResults,
            row: activeRow,
            cell: activeCell,
            column: column
          });

          currentEditor.focus();
          return false;
        }
      }

      makeActiveCellNormal();
    }
    return true;
  }

  function cancelCurrentEdit() {
    makeActiveCellNormal();
    return true;
  }

  function rowsToRanges(rows) {
    var ranges = [];
    var lastCell = columns.length - 1;
    for (var i = 0; i < rows.length; i++) {
      ranges.push(new Slick.Range(rows[i], 0, rows[i], lastCell));
    }
    return ranges;
  }

  function getSelectedRows() {
    if (!selectionModel) {
      throw "Selection model is not set";
    }
    return selectedRows;
  }

  function setSelectedRows(rows) {
    if (!selectionModel) {
      throw "Selection model is not set";
    }
    selectionModel.setSelectedRanges(rowsToRanges(rows));
  }


  //////////////////////////////////////////////////////////////////////////////////////////////
  // Debug

  this.debug = function () {
    var s = "";

    s += ("\n" + "counter_rows_rendered:  " + counter_rows_rendered);
    s += ("\n" + "counter_rows_removed:  " + counter_rows_removed);
    s += ("\n" + "renderedRows:  " + renderedRows);
    s += ("\n" + "numVisibleRows:  " + numVisibleRows);
    s += ("\n" + "maxSupportedCssHeight:  " + maxSupportedCssHeight);
    s += ("\n" + "n(umber of pages):  " + n);
    s += ("\n" + "(current) page:  " + page);
    s += ("\n" + "page height (ph):  " + ph);
    s += ("\n" + "vScrollDir:  " + vScrollDir);

    alert(s);
  };

  // a debug helper to be able to access private members
  this.eval = function (expr) {
    return eval(expr);
  };

  //////////////////////////////////////////////////////////////////////////////////////////////
  // Public API

  $.extend(this, {
    "slickGridVersion": "2.1",

    // Events
    "onScroll": new Slick.Event(),
    "onSort": new Slick.Event(),
    "onHeaderMouseEnter": new Slick.Event(),
    "onHeaderMouseLeave": new Slick.Event(),
    "onHeaderContextMenu": new Slick.Event(),
    "onHeaderClick": new Slick.Event(),
    "onHeaderCellRendered": new Slick.Event(),
    "onBeforeHeaderCellDestroy": new Slick.Event(),
    "onHeaderRowCellRendered": new Slick.Event(),
    "onBeforeHeaderRowCellDestroy": new Slick.Event(),
    "onMouseEnter": new Slick.Event(),
    "onMouseLeave": new Slick.Event(),
    "onClick": new Slick.Event(),
    "onDblClick": new Slick.Event(),
    "onContextMenu": new Slick.Event(),
    "onKeyDown": new Slick.Event(),
    "onAddNewRow": new Slick.Event(),
    "onValidationError": new Slick.Event(),
    "onViewportChanged": new Slick.Event(),
    "onColumnsReordered": new Slick.Event(),
    "onColumnsResized": new Slick.Event(),
    "onCellChange": new Slick.Event(),
    "onBeforeEditCell": new Slick.Event(),
    "onBeforeCellEditorDestroy": new Slick.Event(),
    "onBeforeDestroy": new Slick.Event(),
    "onActiveCellChanged": new Slick.Event(),
    "onActiveCellPositionChanged": new Slick.Event(),
    "onDragInit": new Slick.Event(),
    "onDragStart": new Slick.Event(),
    "onDrag": new Slick.Event(),
    "onDragEnd": new Slick.Event(),
    "onSelectedRowsChanged": new Slick.Event(),
    "onCellCssStylesChanged": new Slick.Event(),

    // Methods
    "registerPlugin": registerPlugin,
    "unregisterPlugin": unregisterPlugin,
    "getColumns": getColumns,
    "setColumns": setColumns,
    "getColumnIndex": getColumnIndex,
    "updateColumnHeader": updateColumnHeader,
    "setSortColumn": setSortColumn,
    "setSortColumns": setSortColumns,
    "getSortColumns": getSortColumns,
    "autosizeColumns": autosizeColumns,
    "getOptions": getOptions,
    "setOptions": setOptions,
    "getData": getData,
    "getDataLength": getDataLength,
    "getDataItem": getDataItem,
    "setData": setData,
    "getSelectionModel": getSelectionModel,
    "setSelectionModel": setSelectionModel,
    "getSelectedRows": getSelectedRows,
    "setSelectedRows": setSelectedRows,
    "getContainerNode": getContainerNode,

    "render": render,
    "invalidate": invalidate,
    "invalidateRow": invalidateRow,
    "invalidateRows": invalidateRows,
    "invalidateAllRows": invalidateAllRows,
    "updateCell": updateCell,
    "updateRow": updateRow,
    "getViewport": getVisibleRange,
    "getRenderedRange": getRenderedRange,
    "resizeCanvas": resizeCanvas,
    "updateRowCount": updateRowCount,
    "scrollRowIntoView": scrollRowIntoView,
    "scrollRowToTop": scrollRowToTop,
    "scrollCellIntoView": scrollCellIntoView,
    "getCanvasNode": getCanvasNode,
    "focus": setFocus,

    "getCellFromPoint": getCellFromPoint,
    "getCellFromEvent": getCellFromEvent,
    "getActiveCell": getActiveCell,
    "setActiveCell": setActiveCell,
    "getActiveCellNode": getActiveCellNode,
    "getActiveCellPosition": getActiveCellPosition,
    "resetActiveCell": resetActiveCell,
    "editActiveCell": makeActiveCellEditable,
    "getCellEditor": getCellEditor,
    "getCellNode": getCellNode,
    "getCellNodeBox": getCellNodeBox,
    "canCellBeSelected": canCellBeSelected,
    "canCellBeActive": canCellBeActive,
    "navigatePrev": navigatePrev,
    "navigateNext": navigateNext,
    "navigateUp": navigateUp,
    "navigateDown": navigateDown,
    "navigateLeft": navigateLeft,
    "navigateRight": navigateRight,
    "navigatePageUp": navigatePageUp,
    "navigatePageDown": navigatePageDown,
    "gotoCell": gotoCell,
    "getTopPanel": getTopPanel,
    "setTopPanelVisibility": setTopPanelVisibility,
    "setHeaderRowVisibility": setHeaderRowVisibility,
    "getHeaderRow": getHeaderRow,
    "getHeaderRowColumn": getHeaderRowColumn,
    "getGridPosition": getGridPosition,
    "flashCell": flashCell,
    "addCellCssStyles": addCellCssStyles,
    "setCellCssStyles": setCellCssStyles,
    "removeCellCssStyles": removeCellCssStyles,
    "getCellCssStyles": getCellCssStyles,

    "init": finishInitialization,
    "destroy": destroy,

    // IEditor implementation
    "getEditorLock": getEditorLock,
    "getEditController": getEditController
  });

  init();
}

module.exports = SlickGrid;

},{"./slick.core":"slick_grid/slick.core","jquery":"jquery","jquery_event_drag":"jquery_event_drag","jquery_event_drop":"jquery_event_drop"}]},{},["models/widgets/main"])

 })()/*
Copyright (c) 2012, Continuum Analytics, Inc.
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

Neither the name of Continuum Analytics nor the names of any contributors
may be used to endorse or promote products derived from this software 
without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
THE POSSIBILITY OF SUCH DAMAGE.
*/
//# sourceMappingURL=data:application/json;charset:utf-8;base64,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