/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import net.sf.mpxj.common.MPPTaskField;
import net.sf.mpxj.mpp.ChartPattern;
import net.sf.mpxj.mpp.ColorType;
import net.sf.mpxj.mpp.GanttBarMiddleShape;
import net.sf.mpxj.mpp.GanttBarShowForTasks;
import net.sf.mpxj.mpp.GanttBarStartEndShape;
import net.sf.mpxj.mpp.GanttBarStartEndType;
import net.sf.mpxj.mpp.GanttBarStyle;
import net.sf.mpxj.mpp.GanttBarStyleException;
import net.sf.mpxj.mpp.GanttBarStyleFactory;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;

public final class GanttBarStyleFactoryCommon
implements GanttBarStyleFactory {
    private static final Integer DEFAULT_PROPERTIES = 574619686;
    private static final Integer EXCEPTION_PROPERTIES = 574619661;

    public GanttBarStyle[] processDefaultStyles(Props props) {
        GanttBarStyle[] ganttBarStyleArray = null;
        byte[] byArray = props.getByteArray(DEFAULT_PROPERTIES);
        if (byArray != null) {
            ganttBarStyleArray = new GanttBarStyle[byArray[812]];
            int n = 840;
            int n2 = n + ganttBarStyleArray.length * 58;
            for (int i = 0; i < ganttBarStyleArray.length; ++i) {
                GanttBarStyle ganttBarStyle;
                String string = MPPUtility.getUnicodeString(byArray, n2);
                n2 += (string.length() + 1) * 2;
                ganttBarStyleArray[i] = ganttBarStyle = new GanttBarStyle();
                ganttBarStyle.setName(string);
                ganttBarStyle.setMiddleShape(GanttBarMiddleShape.getInstance(byArray[n]));
                ganttBarStyle.setMiddlePattern(ChartPattern.getInstance(byArray[n + 1]));
                ganttBarStyle.setMiddleColor(ColorType.getInstance(byArray[n + 2]).getColor());
                ganttBarStyle.setStartShape(GanttBarStartEndShape.getInstance(byArray[n + 4] % 21));
                ganttBarStyle.setStartType(GanttBarStartEndType.getInstance(byArray[n + 4] / 21));
                ganttBarStyle.setStartColor(ColorType.getInstance(byArray[n + 5]).getColor());
                ganttBarStyle.setEndShape(GanttBarStartEndShape.getInstance(byArray[n + 6] % 21));
                ganttBarStyle.setEndType(GanttBarStartEndType.getInstance(byArray[n + 6] / 21));
                ganttBarStyle.setEndColor(ColorType.getInstance(byArray[n + 7]).getColor());
                ganttBarStyle.setFromField(MPPTaskField.getInstance(MPPUtility.getShort(byArray, n + 8)));
                ganttBarStyle.setToField(MPPTaskField.getInstance(MPPUtility.getShort(byArray, n + 12)));
                this.extractFlags(ganttBarStyle, GanttBarShowForTasks.NORMAL, MPPUtility.getLong6(byArray, n + 16));
                this.extractFlags(ganttBarStyle, GanttBarShowForTasks.NOT_NORMAL, MPPUtility.getLong6(byArray, n + 24));
                ganttBarStyle.setRow(byArray[n + 32] + 1);
                ganttBarStyle.setLeftText(MPPTaskField.getInstance(MPPUtility.getShort(byArray, n + 34)));
                ganttBarStyle.setRightText(MPPTaskField.getInstance(MPPUtility.getShort(byArray, n + 38)));
                ganttBarStyle.setTopText(MPPTaskField.getInstance(MPPUtility.getShort(byArray, n + 42)));
                ganttBarStyle.setBottomText(MPPTaskField.getInstance(MPPUtility.getShort(byArray, n + 46)));
                ganttBarStyle.setInsideText(MPPTaskField.getInstance(MPPUtility.getShort(byArray, n + 50)));
                n += 58;
            }
        }
        return ganttBarStyleArray;
    }

    public GanttBarStyleException[] processExceptionStyles(Props props) {
        GanttBarStyleException[] ganttBarStyleExceptionArray = null;
        byte[] byArray = props.getByteArray(EXCEPTION_PROPERTIES);
        if (byArray != null) {
            ganttBarStyleExceptionArray = new GanttBarStyleException[byArray.length / 38];
            int n = 0;
            for (int i = 0; i < ganttBarStyleExceptionArray.length; ++i) {
                GanttBarStyleException ganttBarStyleException;
                ganttBarStyleExceptionArray[i] = ganttBarStyleException = new GanttBarStyleException();
                ganttBarStyleException.setTaskUniqueID(MPPUtility.getInt(byArray, n));
                ganttBarStyleException.setBarStyleIndex(MPPUtility.getShort(byArray, n + 4) - 1);
                ganttBarStyleException.setStartShape(GanttBarStartEndShape.getInstance(byArray[n + 9] % 21));
                ganttBarStyleException.setStartType(GanttBarStartEndType.getInstance(byArray[n + 9] / 21));
                ganttBarStyleException.setStartColor(ColorType.getInstance(byArray[n + 10]).getColor());
                ganttBarStyleException.setMiddleShape(GanttBarMiddleShape.getInstance(byArray[n + 6]));
                ganttBarStyleException.setMiddlePattern(ChartPattern.getInstance(byArray[n + 7]));
                ganttBarStyleException.setMiddleColor(ColorType.getInstance(byArray[n + 8]).getColor());
                ganttBarStyleException.setEndShape(GanttBarStartEndShape.getInstance(byArray[n + 11] % 21));
                ganttBarStyleException.setEndType(GanttBarStartEndType.getInstance(byArray[n + 11] / 21));
                ganttBarStyleException.setEndColor(ColorType.getInstance(byArray[n + 12]).getColor());
                ganttBarStyleException.setLeftText(MPPTaskField.getInstance(MPPUtility.getShort(byArray, n + 16)));
                ganttBarStyleException.setRightText(MPPTaskField.getInstance(MPPUtility.getShort(byArray, n + 20)));
                ganttBarStyleException.setTopText(MPPTaskField.getInstance(MPPUtility.getShort(byArray, n + 24)));
                ganttBarStyleException.setBottomText(MPPTaskField.getInstance(MPPUtility.getShort(byArray, n + 28)));
                ganttBarStyleException.setInsideText(MPPTaskField.getInstance(MPPUtility.getShort(byArray, n + 32)));
                n += 38;
            }
        }
        return ganttBarStyleExceptionArray;
    }

    private void extractFlags(GanttBarStyle ganttBarStyle, GanttBarShowForTasks ganttBarShowForTasks, long l) {
        long l2 = 1L;
        for (int i = 0; i < 48; ++i) {
            if ((l & l2) != 0L) {
                GanttBarShowForTasks ganttBarShowForTasks2 = GanttBarShowForTasks.getInstance(ganttBarShowForTasks.getValue() + i);
                ganttBarStyle.addShowForTasks(ganttBarShowForTasks2);
            }
            l2 <<= 1;
        }
    }
}

