/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.graph;

import com.projity.dialog.DependencyDialog;
import com.projity.graphic.configuration.GraphicConfiguration;
import com.projity.pm.graphic.IconManager;
import com.projity.pm.graphic.graph.Graph;
import com.projity.pm.graphic.graph.GraphPopupMenu;
import com.projity.pm.graphic.graph.GraphUI;
import com.projity.pm.graphic.graph.GraphZone;
import com.projity.pm.graphic.model.cache.GraphicDependency;
import com.projity.pm.graphic.model.cache.GraphicNode;
import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public abstract class GraphInteractor
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
Serializable {
    protected static final int NOTHING_SELECTED = 0;
    protected static final int LINK_CREATION = 1;
    protected static final int LINK_SELECTION = 2;
    protected static final int BAR_MOVE = 3;
    protected GraphUI ui;
    protected int state;
    protected Object selected = null;
    protected GraphZone selectedZone = null;
    protected boolean selection;
    protected double x0;
    protected double y0;
    protected GraphicConfiguration config;
    protected GraphPopupMenu popup = null;
    protected DependencyDialog dependencyPropertiesDialog;
    protected Cursor defaultCursor;
    protected Cursor progressCursor;
    protected Cursor linkCursor;
    protected Cursor splitCursor;
    protected double lastShadowX = -1.0;
    protected double lastShadowY = -1.0;
    protected GraphicNode sourceNode = null;
    protected GraphicNode destinationNode = null;
    protected double lastLinkShadowX = -1.0;
    protected double lastLinkShadowY = -1.0;
    protected double x0link;
    protected double y0link;
    protected int beforeLinkState = 0;

    public GraphInteractor(GraphUI graphUI) {
        this.ui = graphUI;
        this.config = GraphicConfiguration.getInstance();
        this.state = 0;
        this.selection = true;
        this.init();
    }

    protected void init() {
        this.ui.getGraph().addMouseListener(this);
        this.ui.getGraph().addMouseMotionListener(this);
        this.ui.getGraph().addMouseWheelListener(this);
        this.defaultCursor = this.getGraph().getCursor();
    }

    protected void reset() {
        this.lastShadowX = -1.0;
        this.lastShadowY = -1.0;
        this.lastLinkShadowX = -1.0;
        this.lastLinkShadowY = -1.0;
        this.sourceNode = null;
        this.destinationNode = null;
        this.selection = true;
    }

    protected boolean selectedIsNonSummaryNode() {
        return this.selected instanceof GraphicNode && !((GraphicNode)this.selected).isSummary();
    }

    public Graph getGraph() {
        return this.ui.getGraph();
    }

    public void showDependencyPropertiesDialog(GraphicDependency graphicDependency) {
        if (this.dependencyPropertiesDialog == null) {
            Frame frame = JOptionPane.getFrameForComponent(this.getGraph());
            this.dependencyPropertiesDialog = new DependencyDialog(frame, graphicDependency.getDependency());
        }
        boolean bl = DependencyDialog.doDialog(this.dependencyPropertiesDialog, graphicDependency.getDependency());
    }

    protected Cursor getProgressCursor() {
        if (this.progressCursor == null) {
            try {
                this.progressCursor = Toolkit.getDefaultToolkit().createCustomCursor(IconManager.getImage("gantt.progress.cursor"), new Point(15, 5), "ProgressCursor");
            }
            catch (Exception exception) {
                this.progressCursor = new Cursor(12);
            }
        }
        return this.progressCursor;
    }

    protected Cursor getLinkCursor() {
        if (this.linkCursor == null) {
            try {
                this.linkCursor = Toolkit.getDefaultToolkit().createCustomCursor(IconManager.getImage("gantt.link.cursor"), new Point(7, 3), "linkCursor");
            }
            catch (Exception exception) {
                this.linkCursor = new Cursor(12);
            }
        }
        return this.linkCursor;
    }

    protected Cursor getSplitCursor() {
        if (this.splitCursor == null) {
            try {
                this.splitCursor = Toolkit.getDefaultToolkit().createCustomCursor(IconManager.getImage("gantt.split.cursor"), new Point(10, 4), "splitCursor");
            }
            catch (Exception exception) {
                this.splitCursor = new Cursor(12);
            }
        }
        return this.splitCursor;
    }

    public Cursor selectCursor() {
        Cursor cursor = this.defaultCursor;
        switch (this.state) {
            case 3: {
                cursor = new Cursor(13);
                break;
            }
            case 1: {
                cursor = this.getLinkCursor();
                break;
            }
            case 2: {
                cursor = new Cursor(1);
            }
        }
        this.getGraph().setCursor(cursor);
        return cursor;
    }

    protected void findState(double d, double d2) {
        this.state = 0;
        if (this.selected == null) {
            return;
        }
        if (this.selected instanceof GraphicNode) {
            this.computeNodeSelection(d, d2);
        } else if (this.selected instanceof GraphicDependency) {
            this.state = 2;
        }
    }

    protected Graphics2D initGraphics() {
        Graph graph = this.getGraph();
        Graphics2D graphics2D = (Graphics2D)graph.getGraphics();
        graphics2D.setColor(graph.getForeground());
        graphics2D.setXORMode(graph.getBackground().darker());
        return graphics2D;
    }

    protected void drawBarShadow(double d, double d2, boolean bl) {
        if (d == -1.0) {
            return;
        }
        Graphics2D graphics2D = this.initGraphics();
        Shape shape = this.getBarShadowBounds(d, d2);
        if (shape == null) {
            return;
        }
        graphics2D.setStroke(new BasicStroke(3.0f));
        graphics2D.draw(shape);
        if (bl) {
            this.lastShadowX = this.lastShadowX == -1.0 ? d : -1.0;
            this.lastShadowY = this.lastShadowY == -1.0 ? d2 : -1.0;
        }
    }

    protected void drawLinkSelectionBarShadow(GraphicNode graphicNode) {
        if (graphicNode == null) {
            return;
        }
        Graphics2D graphics2D = this.initGraphics();
        Rectangle2D rectangle2D = this.getLinkSelectionShadowBounds(graphicNode);
        if (rectangle2D == null) {
            return;
        }
        graphics2D.setStroke(new BasicStroke(3.0f));
        graphics2D.draw(rectangle2D);
    }

    private void drawLinkShadow(double d, double d2, boolean bl) {
        if (d == -1.0 || d2 == -1.0) {
            return;
        }
        Graphics2D graphics2D = this.initGraphics();
        Line2D.Double double_ = new Line2D.Double(this.x0link, this.y0link, d, d2);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.draw(double_);
        if (bl) {
            this.lastLinkShadowX = this.lastLinkShadowX == -1.0 ? d : -1.0;
            this.lastLinkShadowY = this.lastLinkShadowY == -1.0 ? d2 : -1.0;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.isReadOnly()) {
            return;
        }
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            if (this.popup != null) {
                this.popup.show(this.getGraph(), mouseEvent.getX(), mouseEvent.getY());
            }
        } else {
            if (this.selected == null) {
                return;
            }
            if (this.isMove()) {
                this.selection = false;
                this.x0 = mouseEvent.getX();
                this.y0 = mouseEvent.getY();
                this.drawBarShadow(this.x0, this.y0, true);
            } else if (this.isDirectAction()) {
                this.executeAction(mouseEvent.getX(), mouseEvent.getY());
                this.state = 0;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.isReadOnly()) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (this.selected == null || this.state == 0) {
            return;
        }
        if (this.isRepaintOnRelease()) {
            this.getGraph().repaint();
        }
        double d = mouseEvent.getX();
        double d2 = mouseEvent.getY();
        this.executeAction(d, d2);
        this.reset();
        this.findState(d, d2);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void scrollToVisible(int n, int n2) {
        int n3 = 100;
        this.getGraph().scrollRectToVisible(new Rectangle(n - n3, n2 - n3, n3 * 2, n3 * 2));
    }

    protected boolean allowLinkSelectionToMove() {
        return false;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Object object;
        if (this.isReadOnly()) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (this.selected instanceof GraphicNode) {
            object = (GraphicNode)this.selected;
            boolean bl = this.switchOnLinkCreation(mouseEvent.getX(), mouseEvent.getY());
            if (this.state != 1 && bl) {
                this.drawBarShadow(this.lastShadowX, this.lastLinkShadowY, true);
                this.beforeLinkState = this.state;
                this.state = 1;
                this.selectCursor();
                this.sourceNode = (GraphicNode)this.selected;
                this.drawLinkSelectionBarShadow(this.sourceNode);
                this.setLinkOrigin();
            } else if (this.state == 1 && !bl && this.allowLinkSelectionToMove()) {
                this.drawLinkShadow(this.lastLinkShadowX, this.lastLinkShadowY, true);
                this.drawBarShadow(this.lastShadowX, this.lastLinkShadowY, true);
                this.state = this.beforeLinkState;
                this.selectCursor();
                this.sourceNode = null;
            }
        }
        if (this.state == 1) {
            object = this.ui.getNodeAt(mouseEvent.getX(), mouseEvent.getY());
            GraphicNode graphicNode = object == null ? null : (GraphicNode)((GraphZone)object).getObject();
            this.drawLinkSelectionBarShadow(this.destinationNode);
            this.drawLinkShadow(this.lastLinkShadowX, this.lastLinkShadowY, true);
            this.scrollToVisible(mouseEvent.getX(), mouseEvent.getY());
            this.drawLinkShadow(mouseEvent.getX(), mouseEvent.getY(), true);
            if (graphicNode != null && graphicNode.isLinkable() && this.sourceNode != graphicNode) {
                this.destinationNode = graphicNode;
                this.drawLinkSelectionBarShadow(this.destinationNode);
            } else {
                this.destinationNode = null;
            }
        } else if (this.isMove()) {
            this.drawBarShadow(this.lastShadowX, this.lastShadowY, true);
            this.scrollToVisible(mouseEvent.getX(), mouseEvent.getY());
            this.drawBarShadow(mouseEvent.getX(), mouseEvent.getY(), true);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.isReadOnly()) {
            return;
        }
        this.select(mouseEvent.getX(), mouseEvent.getY());
    }

    public boolean isReadOnly() {
        return this.getGraph().getModel().isReadOnly();
    }

    protected abstract void computeNodeSelection(double var1, double var3);

    protected abstract Shape getBarShadowBounds(double var1, double var3);

    protected abstract Rectangle2D getLinkSelectionShadowBounds(GraphicNode var1);

    protected abstract void setLinkOrigin();

    protected abstract boolean switchOnLinkCreation(double var1, double var3);

    public abstract boolean executeAction(double var1, double var3);

    protected void select(int n, int n2) {
        if (this.selection) {
            this.selectedZone = this.ui.getObjectAt(n, n2);
            if (this.selectedZone != null) {
                this.selected = this.selectedZone.getObject();
            }
            if (this.selected == null) {
                this.state = 0;
            } else {
                this.findState(n, n2);
            }
            this.selectCursor();
        }
    }

    protected boolean isMove() {
        return this.state == 3;
    }

    protected boolean isDirectAction() {
        return this.state == 2;
    }

    protected boolean isRepaintOnRelease() {
        return this.state == 3 || this.state == 1;
    }
}

