/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jruby;

import java.nio.ByteBuffer;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"MessagePack::ExtensionValue"})
public class ExtensionValue
extends RubyObject {
    private final Encoding binaryEncoding;
    private RubyFixnum type;
    private RubyString payload;

    public ExtensionValue(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
        this.binaryEncoding = ruby.getEncodingService().getAscii8bitEncoding();
    }

    public static ExtensionValue newExtensionValue(Ruby ruby, int n, byte[] byArray) {
        ExtensionValue extensionValue = new ExtensionValue(ruby, ruby.getModule("MessagePack").getClass("ExtensionValue"));
        ByteList byteList = new ByteList(byArray, ruby.getEncodingService().getAscii8bitEncoding());
        extensionValue.initialize(ruby.getCurrentContext(), (IRubyObject)ruby.newFixnum(n), (IRubyObject)ruby.newString(byteList));
        return extensionValue;
    }

    @JRubyMethod(name={"initialize"}, required=2, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.type = (RubyFixnum)iRubyObject;
        this.payload = (RubyString)iRubyObject2;
        return this;
    }

    @JRubyMethod(name={"to_msgpack"})
    public IRubyObject toMsgpack() {
        boolean bl;
        ByteList byteList = this.payload.getByteList();
        int n = byteList.length();
        int n2 = 0;
        boolean bl2 = bl = n == 1 || n == 2 || n == 4 || n == 8 || n == 16;
        n2 = bl ? 2 + n : (n < 256 ? 3 + n : (n < 65536 ? 4 + n : 6 + n));
        byte[] byArray = new byte[n2];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (n == 1) {
            byteBuffer.put((byte)-44);
            byteBuffer.put((byte)this.type.getLongValue());
            byteBuffer.put((byte)byteList.get(0));
        } else if (n == 2) {
            byteBuffer.put((byte)-43);
            byteBuffer.put((byte)this.type.getLongValue());
            byteBuffer.put(byteList.unsafeBytes(), byteList.begin(), 2);
        } else if (n == 4) {
            byteBuffer.put((byte)-42);
            byteBuffer.put((byte)this.type.getLongValue());
            byteBuffer.put(byteList.unsafeBytes(), byteList.begin(), 4);
        } else if (n == 8) {
            byteBuffer.put((byte)-41);
            byteBuffer.put((byte)this.type.getLongValue());
            byteBuffer.put(byteList.unsafeBytes(), byteList.begin(), 8);
        } else if (n == 16) {
            byteBuffer.put((byte)-40);
            byteBuffer.put((byte)this.type.getLongValue());
            byteBuffer.put(byteList.unsafeBytes(), byteList.begin(), 16);
        } else if (n < 256) {
            byteBuffer.put((byte)-57);
            byteBuffer.put((byte)n);
            byteBuffer.put((byte)this.type.getLongValue());
            byteBuffer.put(byteList.unsafeBytes(), byteList.begin(), n);
        } else if (n < 65536) {
            byteBuffer.put((byte)-56);
            byteBuffer.putShort((short)n);
            byteBuffer.put((byte)this.type.getLongValue());
            byteBuffer.put(byteList.unsafeBytes(), byteList.begin(), n);
        } else {
            byteBuffer.put((byte)-55);
            byteBuffer.putInt(n);
            byteBuffer.put((byte)this.type.getLongValue());
            byteBuffer.put(byteList.unsafeBytes(), byteList.begin(), n);
        }
        return this.getRuntime().newString(new ByteList(byArray, this.binaryEncoding, false));
    }

    @JRubyMethod(name={"to_s", "inspect"})
    public IRubyObject to_s() {
        IRubyObject iRubyObject = this.payload.callMethod(this.getRuntime().getCurrentContext(), "inspect");
        return this.getRuntime().newString(String.format("#<MessagePack::ExtensionValue @type=%d, @payload=%s>", this.type.getLongValue(), iRubyObject));
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        long l = (long)this.payload.hashCode() & this.type.getLongValue() << 56;
        return RubyFixnum.newFixnum((Ruby)this.getRuntime(), (long)l);
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject eql_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof ExtensionValue) {
            ExtensionValue extensionValue = (ExtensionValue)iRubyObject;
            return this.getRuntime().newBoolean(this.type.callMethod(threadContext, "eql?", (IRubyObject)extensionValue.type).isTrue() && this.payload.callMethod(threadContext, "eql?", (IRubyObject)extensionValue.payload).isTrue());
        }
        return this.getRuntime().getFalse();
    }

    public static class ExtensionValueAllocator
    implements ObjectAllocator {
        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new ExtensionValue(ruby, rubyClass);
        }
    }
}

