/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import org.jruby.ast.AssignableNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.Node;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;

public class BlockStaticScope
extends StaticScope {
    private static final long serialVersionUID = -3882063260379968149L;
    private boolean isArgumentScope = false;

    protected BlockStaticScope(StaticScope parentScope) {
        super(parentScope, new String[0]);
    }

    protected BlockStaticScope(StaticScope parentScope, String[] names2) {
        super(parentScope, names2);
    }

    @Override
    public StaticScope getLocalScope() {
        return this.enclosingScope.getLocalScope();
    }

    @Override
    public int isDefined(String name2, int depth) {
        int slot = this.exists(name2);
        if (slot >= 0) {
            return depth << 16 | slot;
        }
        return this.enclosingScope.isDefined(name2, depth + 1);
    }

    @Override
    public boolean isArgumentScope() {
        return this.isArgumentScope;
    }

    @Override
    public void makeArgumentScope() {
        this.isArgumentScope = true;
    }

    @Override
    public boolean isBlockScope() {
        return true;
    }

    @Override
    public String[] getAllNamesInScope() {
        String[] variables = this.enclosingScope.getAllNamesInScope();
        String[] ourVariables = this.getVariables();
        int newSize = variables.length + ourVariables.length;
        String[] names2 = new String[newSize];
        System.arraycopy(variables, 0, names2, 0, variables.length);
        System.arraycopy(ourVariables, 0, names2, variables.length, ourVariables.length);
        return names2;
    }

    @Override
    protected AssignableNode assign(ISourcePosition position, String name2, Node value2, StaticScope topScope, int depth) {
        int slot = this.exists(name2);
        if (slot >= 0) {
            return new DAsgnNode(position, name2, depth << 16 | slot, value2);
        }
        return this.enclosingScope.assign(position, name2, value2, topScope, depth + 1);
    }

    public AssignableNode addAssign(ISourcePosition position, String name2, Node value2) {
        int slot = this.addVariable(name2);
        return new DAsgnNode(position, name2, slot, value2);
    }

    @Override
    public Node declare(ISourcePosition position, String name2, int depth) {
        int slot = this.exists(name2);
        if (slot >= 0) {
            return new DVarNode(position, depth << 16 | slot, name2);
        }
        return this.enclosingScope.declare(position, name2, depth + 1);
    }

    @Override
    public String toString() {
        return "BlockScope: " + super.toString() + "\n" + this.getEnclosingScope();
    }

    @Override
    public StaticScope.Type getType() {
        return StaticScope.Type.BLOCK;
    }
}

