/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.ClassData;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.org.objectweb.asm.commons.Method;
import org.jruby.runtime.CallType;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;
import org.jruby.runtime.callsite.NormalCachingCallSite;
import org.jruby.runtime.callsite.RefinedCachingCallSite;
import org.jruby.runtime.callsite.VariableCachingCallSite;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.RegexpOptions;

public abstract class IRBytecodeAdapter {
    public static final int MAX_ARGUMENTS = 250;
    public SkinnyMethodAdapter adapter;
    private int variableCount = 0;
    private Map<Integer, Type> variableTypes = new HashMap<Integer, Type>();
    private Map<Integer, String> variableNames = new HashMap<Integer, String>();
    protected final com.headius.invokebinder.Signature signature;
    private final ClassData classData;
    public int ipc = 0;

    public IRBytecodeAdapter(SkinnyMethodAdapter adapter, com.headius.invokebinder.Signature signature, ClassData classData) {
        this.adapter = adapter;
        this.signature = signature;
        this.classData = classData;
    }

    public static void cacheCallSite(SkinnyMethodAdapter method, String className, String siteName, String rubyName, CallType callType, boolean isPotentiallyRefined) {
        String signature;
        Class siteClass;
        method.getClassVisitor().visitField(10, siteName, CodegenUtils.ci(CachingCallSite.class), null, null).visitEnd();
        method.getstatic(className, siteName, CodegenUtils.ci(CachingCallSite.class));
        method.dup();
        Label doCall = new Label();
        method.ifnonnull(doCall);
        method.pop();
        method.ldc(rubyName);
        if (isPotentiallyRefined) {
            siteClass = RefinedCachingCallSite.class;
            signature = CodegenUtils.sig(siteClass, String.class, String.class);
            method.ldc(callType.name());
        } else {
            switch (callType) {
                case NORMAL: {
                    siteClass = NormalCachingCallSite.class;
                    break;
                }
                case FUNCTIONAL: {
                    siteClass = FunctionalCachingCallSite.class;
                    break;
                }
                case VARIABLE: {
                    siteClass = VariableCachingCallSite.class;
                    break;
                }
                default: {
                    throw new RuntimeException("BUG: Unexpected call type " + (Object)((Object)callType) + " in JVM6 invoke logic");
                }
            }
            signature = CodegenUtils.sig(siteClass, String.class);
        }
        method.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "new" + siteClass.getSimpleName(), signature);
        method.dup();
        method.putstatic(className, siteName, CodegenUtils.ci(CachingCallSite.class));
        method.label(doCall);
    }

    public String getUniqueSiteName(String name2) {
        return "invokeOther" + this.getClassData().callSiteCount.getAndIncrement() + ":" + JavaNameMangler.mangleMethodName(name2);
    }

    public ClassData getClassData() {
        return this.classData;
    }

    public void startMethod() {
        this.adapter.start();
    }

    public void endMethod() {
        this.adapter.end(new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : IRBytecodeAdapter.this.variableTypes.entrySet()) {
                    int i2 = (Integer)entry.getKey();
                    String name2 = (String)IRBytecodeAdapter.this.variableNames.get(i2);
                    IRBytecodeAdapter.this.adapter.local(i2, name2, (Type)entry.getValue());
                }
            }
        });
    }

    public void loadLocal(int i2) {
        this.adapter.aload(i2);
    }

    public void loadContext() {
        this.adapter.aload(this.signature.argOffset("context"));
    }

    public void loadSelfBlock() {
        this.adapter.aload(this.signature.argOffset("selfBlock"));
    }

    public void loadStaticScope() {
        this.adapter.aload(this.signature.argOffset("scope"));
    }

    public void loadSelf() {
        this.adapter.aload(this.signature.argOffset("self"));
    }

    public void loadArgs() {
        this.adapter.aload(this.signature.argOffset("args"));
    }

    public void loadBlock() {
        this.adapter.aload(this.signature.argOffset("blockArg"));
    }

    public void loadFrameClass() {
        this.adapter.aload(this.signature.argCount() - 2);
    }

    public void loadFrameName() {
        this.adapter.aload(this.signature.argCount() - 1);
    }

    public void loadSuperName() {
        this.adapter.aload(5);
    }

    public void loadBlockType() {
        if (this.signature.argOffset("type") == -1) {
            this.adapter.aconst_null();
        } else {
            this.adapter.aload(this.signature.argOffset("type"));
        }
    }

    public void storeSelf() {
        this.adapter.astore(this.signature.argOffset("self"));
    }

    public void storeArgs() {
        this.adapter.astore(this.signature.argOffset("args"));
    }

    public void storeLocal(int i2) {
        this.adapter.astore(i2);
    }

    public void invokeVirtual(Type type2, Method method) {
        this.adapter.invokevirtual(type2.getInternalName(), method.getName(), method.getDescriptor());
    }

    public void invokeStatic(Type type2, Method method) {
        this.adapter.invokestatic(type2.getInternalName(), method.getName(), method.getDescriptor());
    }

    public void invokeHelper(String name2, String sig) {
        this.adapter.invokestatic(CodegenUtils.p(Helpers.class), name2, sig);
    }

    public void invokeHelper(String name2, Class ... x) {
        this.adapter.invokestatic(CodegenUtils.p(Helpers.class), name2, CodegenUtils.sig(x));
    }

    public void invokeIRHelper(String name2, String sig) {
        this.adapter.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), name2, sig);
    }

    public void goTo(Label label2) {
        this.adapter.go_to(label2);
    }

    public void isTrue() {
        this.adapter.invokeinterface(CodegenUtils.p(IRubyObject.class), "isTrue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
    }

    public void isNil() {
        this.adapter.invokeinterface(CodegenUtils.p(IRubyObject.class), "isNil", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
    }

    public void bfalse(Label label2) {
        this.adapter.iffalse(label2);
    }

    public void btrue(Label label2) {
        this.adapter.iftrue(label2);
    }

    public void poll() {
        this.loadContext();
        this.adapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "pollThreadEvents", CodegenUtils.sig(Void.TYPE, new Class[0]));
    }

    public void pushObjectClass() {
        this.loadRuntime();
        this.adapter.invokevirtual(CodegenUtils.p(Ruby.class), "getObject", CodegenUtils.sig(RubyClass.class, new Class[0]));
    }

    public void pushUndefined() {
        this.adapter.getstatic(CodegenUtils.p(UndefinedValue.class), "UNDEFINED", CodegenUtils.ci(UndefinedValue.class));
    }

    public void pushHandle(Handle handle) {
        this.adapter.getMethodVisitor().visitLdcInsn(handle);
    }

    public void mark(Label label2) {
        this.adapter.label(label2);
    }

    public void returnValue() {
        this.adapter.areturn();
    }

    public int newLocal(String name2, Type type2) {
        int index2 = this.variableCount++;
        if (type2 == Type.DOUBLE_TYPE || type2 == Type.LONG_TYPE) {
            ++this.variableCount;
        }
        this.variableTypes.put(index2, type2);
        this.variableNames.put(index2, name2);
        return index2;
    }

    public Label newLabel() {
        return new Label();
    }

    public abstract void pushFixnum(long var1);

    public abstract void pushFloat(double var1);

    public abstract void pushString(ByteList var1, int var2);

    public abstract void pushFrozenString(ByteList var1, int var2, String var3, int var4);

    public abstract void pushByteList(ByteList var1);

    public abstract void pushRegexp(ByteList var1, int var2);

    public abstract void pushDRegexp(Runnable var1, RegexpOptions var2, int var3);

    public abstract void pushSymbol(String var1, Encoding var2);

    public abstract void pushSymbolProc(String var1, Encoding var2);

    public abstract void loadRuntime();

    public abstract void pushEncoding(Encoding var1);

    public abstract void invokeOther(String var1, int var2, String var3, int var4, boolean var5, boolean var6);

    public abstract void invokeArrayDeref(String var1, int var2);

    public abstract void invokeOtherOneFixnum(String var1, int var2, String var3, long var4, CallType var6);

    public abstract void invokeOtherOneFloat(String var1, int var2, String var3, double var4, CallType var6);

    public abstract void invokeSelf(String var1, int var2, String var3, int var4, boolean var5, CallType var6, boolean var7);

    public abstract void invokeInstanceSuper(String var1, int var2, String var3, int var4, boolean var5, boolean[] var6);

    public abstract void invokeClassSuper(String var1, int var2, String var3, int var4, boolean var5, boolean[] var6);

    public abstract void invokeUnresolvedSuper(String var1, int var2, String var3, int var4, boolean var5, boolean[] var6);

    public abstract void invokeZSuper(String var1, int var2, String var3, int var4, boolean var5, boolean[] var6);

    public abstract void searchConst(String var1, boolean var2);

    public abstract void searchModuleForConst(String var1, boolean var2);

    public abstract void inheritanceSearchConst(String var1, boolean var2);

    public abstract void lexicalSearchConst(String var1);

    public abstract void pushNil();

    public abstract void pushBoolean(boolean var1);

    public abstract void pushBignum(BigInteger var1);

    public abstract void putField(String var1);

    public abstract void getField(String var1);

    public abstract void array(int var1);

    public abstract void hash(int var1);

    public abstract void kwargsHash(int var1);

    public abstract void checkpoint();

    public abstract void getGlobalVariable(String var1, String var2, int var3);

    public abstract void setGlobalVariable(String var1, String var2, int var3);

    public abstract void yield(boolean var1);

    public abstract void yieldSpecific();

    public abstract void yieldValues(int var1);

    public abstract void prepareBlock(Handle var1, Signature var2, String var3);
}

