/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.SlowLogLevel;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.search.internal.SearchContext;

public final class SearchSlowLog
implements SearchOperationListener {
    private long queryWarnThreshold;
    private long queryInfoThreshold;
    private long queryDebugThreshold;
    private long queryTraceThreshold;
    private long fetchWarnThreshold;
    private long fetchInfoThreshold;
    private long fetchDebugThreshold;
    private long fetchTraceThreshold;
    private SlowLogLevel level;
    private final Logger queryLogger;
    private final Logger fetchLogger;
    private static final String INDEX_SEARCH_SLOWLOG_PREFIX = "index.search.slowlog";
    public static final Setting<TimeValue> INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_WARN_SETTING = Setting.timeSetting("index.search.slowlog.threshold.query.warn", TimeValue.timeValueNanos(-1L), TimeValue.timeValueMillis(-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_INFO_SETTING = Setting.timeSetting("index.search.slowlog.threshold.query.info", TimeValue.timeValueNanos(-1L), TimeValue.timeValueMillis(-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_DEBUG_SETTING = Setting.timeSetting("index.search.slowlog.threshold.query.debug", TimeValue.timeValueNanos(-1L), TimeValue.timeValueMillis(-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_TRACE_SETTING = Setting.timeSetting("index.search.slowlog.threshold.query.trace", TimeValue.timeValueNanos(-1L), TimeValue.timeValueMillis(-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_WARN_SETTING = Setting.timeSetting("index.search.slowlog.threshold.fetch.warn", TimeValue.timeValueNanos(-1L), TimeValue.timeValueMillis(-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_INFO_SETTING = Setting.timeSetting("index.search.slowlog.threshold.fetch.info", TimeValue.timeValueNanos(-1L), TimeValue.timeValueMillis(-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_DEBUG_SETTING = Setting.timeSetting("index.search.slowlog.threshold.fetch.debug", TimeValue.timeValueNanos(-1L), TimeValue.timeValueMillis(-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_TRACE_SETTING = Setting.timeSetting("index.search.slowlog.threshold.fetch.trace", TimeValue.timeValueNanos(-1L), TimeValue.timeValueMillis(-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<SlowLogLevel> INDEX_SEARCH_SLOWLOG_LEVEL = new Setting<SlowLogLevel>("index.search.slowlog.level", SlowLogLevel.TRACE.name(), SlowLogLevel::parse, Setting.Property.Dynamic, Setting.Property.IndexScope);
    private static final ToXContent.Params FORMAT_PARAMS = new ToXContent.MapParams(Collections.singletonMap("pretty", "false"));

    public SearchSlowLog(IndexSettings indexSettings) {
        this.queryLogger = Loggers.getLogger("index.search.slowlog.query", indexSettings.getSettings(), new String[0]);
        this.fetchLogger = Loggers.getLogger("index.search.slowlog.fetch", indexSettings.getSettings(), new String[0]);
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_WARN_SETTING, this::setQueryWarnThreshold);
        this.queryWarnThreshold = indexSettings.getValue(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_WARN_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_INFO_SETTING, this::setQueryInfoThreshold);
        this.queryInfoThreshold = indexSettings.getValue(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_INFO_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_DEBUG_SETTING, this::setQueryDebugThreshold);
        this.queryDebugThreshold = indexSettings.getValue(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_DEBUG_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_TRACE_SETTING, this::setQueryTraceThreshold);
        this.queryTraceThreshold = indexSettings.getValue(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_TRACE_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_WARN_SETTING, this::setFetchWarnThreshold);
        this.fetchWarnThreshold = indexSettings.getValue(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_WARN_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_INFO_SETTING, this::setFetchInfoThreshold);
        this.fetchInfoThreshold = indexSettings.getValue(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_INFO_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_DEBUG_SETTING, this::setFetchDebugThreshold);
        this.fetchDebugThreshold = indexSettings.getValue(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_DEBUG_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_TRACE_SETTING, this::setFetchTraceThreshold);
        this.fetchTraceThreshold = indexSettings.getValue(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_TRACE_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_LEVEL, this::setLevel);
        this.setLevel(indexSettings.getValue(INDEX_SEARCH_SLOWLOG_LEVEL));
    }

    private void setLevel(SlowLogLevel level) {
        this.level = level;
        Loggers.setLevel(this.queryLogger, level.name());
        Loggers.setLevel(this.fetchLogger, level.name());
    }

    @Override
    public void onQueryPhase(SearchContext context, long tookInNanos) {
        if (this.queryWarnThreshold >= 0L && tookInNanos > this.queryWarnThreshold) {
            this.queryLogger.warn("{}", (Object)new SlowLogSearchContextPrinter(context, tookInNanos));
        } else if (this.queryInfoThreshold >= 0L && tookInNanos > this.queryInfoThreshold) {
            this.queryLogger.info("{}", (Object)new SlowLogSearchContextPrinter(context, tookInNanos));
        } else if (this.queryDebugThreshold >= 0L && tookInNanos > this.queryDebugThreshold) {
            this.queryLogger.debug("{}", (Object)new SlowLogSearchContextPrinter(context, tookInNanos));
        } else if (this.queryTraceThreshold >= 0L && tookInNanos > this.queryTraceThreshold) {
            this.queryLogger.trace("{}", (Object)new SlowLogSearchContextPrinter(context, tookInNanos));
        }
    }

    @Override
    public void onFetchPhase(SearchContext context, long tookInNanos) {
        if (this.fetchWarnThreshold >= 0L && tookInNanos > this.fetchWarnThreshold) {
            this.fetchLogger.warn("{}", (Object)new SlowLogSearchContextPrinter(context, tookInNanos));
        } else if (this.fetchInfoThreshold >= 0L && tookInNanos > this.fetchInfoThreshold) {
            this.fetchLogger.info("{}", (Object)new SlowLogSearchContextPrinter(context, tookInNanos));
        } else if (this.fetchDebugThreshold >= 0L && tookInNanos > this.fetchDebugThreshold) {
            this.fetchLogger.debug("{}", (Object)new SlowLogSearchContextPrinter(context, tookInNanos));
        } else if (this.fetchTraceThreshold >= 0L && tookInNanos > this.fetchTraceThreshold) {
            this.fetchLogger.trace("{}", (Object)new SlowLogSearchContextPrinter(context, tookInNanos));
        }
    }

    private void setQueryWarnThreshold(TimeValue warnThreshold) {
        this.queryWarnThreshold = warnThreshold.nanos();
    }

    private void setQueryInfoThreshold(TimeValue infoThreshold) {
        this.queryInfoThreshold = infoThreshold.nanos();
    }

    private void setQueryDebugThreshold(TimeValue debugThreshold) {
        this.queryDebugThreshold = debugThreshold.nanos();
    }

    private void setQueryTraceThreshold(TimeValue traceThreshold) {
        this.queryTraceThreshold = traceThreshold.nanos();
    }

    private void setFetchWarnThreshold(TimeValue warnThreshold) {
        this.fetchWarnThreshold = warnThreshold.nanos();
    }

    private void setFetchInfoThreshold(TimeValue infoThreshold) {
        this.fetchInfoThreshold = infoThreshold.nanos();
    }

    private void setFetchDebugThreshold(TimeValue debugThreshold) {
        this.fetchDebugThreshold = debugThreshold.nanos();
    }

    private void setFetchTraceThreshold(TimeValue traceThreshold) {
        this.fetchTraceThreshold = traceThreshold.nanos();
    }

    long getQueryWarnThreshold() {
        return this.queryWarnThreshold;
    }

    long getQueryInfoThreshold() {
        return this.queryInfoThreshold;
    }

    long getQueryDebugThreshold() {
        return this.queryDebugThreshold;
    }

    long getQueryTraceThreshold() {
        return this.queryTraceThreshold;
    }

    long getFetchWarnThreshold() {
        return this.fetchWarnThreshold;
    }

    long getFetchInfoThreshold() {
        return this.fetchInfoThreshold;
    }

    long getFetchDebugThreshold() {
        return this.fetchDebugThreshold;
    }

    long getFetchTraceThreshold() {
        return this.fetchTraceThreshold;
    }

    SlowLogLevel getLevel() {
        return this.level;
    }

    static final class SlowLogSearchContextPrinter {
        private final SearchContext context;
        private final long tookInNanos;

        public SlowLogSearchContextPrinter(SearchContext context, long tookInNanos) {
            this.context = context;
            this.tookInNanos = tookInNanos;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.context.indexShard().shardId()).append(" ");
            sb.append("took[").append(TimeValue.timeValueNanos(this.tookInNanos)).append("], took_millis[").append(TimeUnit.NANOSECONDS.toMillis(this.tookInNanos)).append("], ");
            if (this.context.getQueryShardContext().getTypes() == null) {
                sb.append("types[], ");
            } else {
                sb.append("types[");
                Strings.arrayToDelimitedString(this.context.getQueryShardContext().getTypes(), ",", sb);
                sb.append("], ");
            }
            if (this.context.groupStats() == null) {
                sb.append("stats[], ");
            } else {
                sb.append("stats[");
                Strings.collectionToDelimitedString(this.context.groupStats(), ",", "", "", sb);
                sb.append("], ");
            }
            sb.append("search_type[").append((Object)this.context.searchType()).append("], total_shards[").append(this.context.numberOfShards()).append("], ");
            if (this.context.request().source() != null) {
                sb.append("source[").append(this.context.request().source().toString(FORMAT_PARAMS)).append("], ");
            } else {
                sb.append("source[], ");
            }
            return sb.toString();
        }
    }
}

