/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.filter.FilteringGeneratorDelegate;
import com.fasterxml.jackson.core.filter.TokenFilter;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.JsonGeneratorDelegate;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentGenerator;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContentParser;
import org.elasticsearch.common.xcontent.support.filtering.FilterPathBasedFilter;

public class JsonXContentGenerator
implements XContentGenerator {
    protected final JsonGenerator generator;
    private final GeneratorBase base;
    private final FilteringGeneratorDelegate filter;
    private final OutputStream os;
    private boolean writeLineFeedAtEnd;
    private static final SerializedString LF = new SerializedString("\n");
    private static final DefaultPrettyPrinter.Indenter INDENTER = new DefaultIndenter("  ", LF.getValue());
    private boolean prettyPrint = false;

    public JsonXContentGenerator(JsonGenerator jsonGenerator, OutputStream os) {
        this(jsonGenerator, os, Collections.emptySet(), Collections.emptySet());
    }

    public JsonXContentGenerator(JsonGenerator jsonGenerator, OutputStream os, Set<String> includes, Set<String> excludes) {
        boolean hasIncludes;
        boolean hasExcludes;
        Objects.requireNonNull(includes, "Including filters must not be null");
        Objects.requireNonNull(excludes, "Excluding filters must not be null");
        this.os = os;
        this.base = jsonGenerator instanceof GeneratorBase ? (GeneratorBase)jsonGenerator : null;
        JsonGenerator generator = jsonGenerator;
        boolean bl = hasExcludes = !excludes.isEmpty();
        if (hasExcludes) {
            generator = new FilteringGeneratorDelegate(generator, (TokenFilter)new FilterPathBasedFilter(excludes, false), true, true);
        }
        boolean bl2 = hasIncludes = !includes.isEmpty();
        if (hasIncludes) {
            generator = new FilteringGeneratorDelegate(generator, (TokenFilter)new FilterPathBasedFilter(includes, true), true, true);
        }
        this.filter = hasExcludes || hasIncludes ? (FilteringGeneratorDelegate)generator : null;
        this.generator = generator;
    }

    @Override
    public XContentType contentType() {
        return XContentType.JSON;
    }

    @Override
    public final void usePrettyPrint() {
        this.generator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter().withObjectIndenter(INDENTER).withArrayIndenter(INDENTER));
        this.prettyPrint = true;
    }

    @Override
    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    @Override
    public void usePrintLineFeedAtEnd() {
        this.writeLineFeedAtEnd = true;
    }

    private boolean isFiltered() {
        return this.filter != null;
    }

    private JsonGenerator getLowLevelGenerator() {
        if (this.isFiltered()) {
            JsonGenerator delegate = this.filter.getDelegate();
            if (delegate instanceof JsonGeneratorDelegate) {
                delegate = ((JsonGeneratorDelegate)delegate).getDelegate();
                assert (!(delegate instanceof JsonGeneratorDelegate));
            }
            return delegate;
        }
        return this.generator;
    }

    private boolean inRoot() {
        JsonStreamContext context = this.generator.getOutputContext();
        return context != null && context.inRoot() && context.getCurrentName() == null;
    }

    @Override
    public void writeStartObject() throws IOException {
        if (this.inRoot()) {
            this.getLowLevelGenerator().writeStartObject();
            return;
        }
        this.generator.writeStartObject();
    }

    @Override
    public void writeEndObject() throws IOException {
        if (this.inRoot()) {
            this.getLowLevelGenerator().writeEndObject();
            return;
        }
        this.generator.writeEndObject();
    }

    @Override
    public void writeStartArray() throws IOException {
        this.generator.writeStartArray();
    }

    @Override
    public void writeEndArray() throws IOException {
        this.generator.writeEndArray();
    }

    @Override
    public void writeFieldName(String name) throws IOException {
        this.generator.writeFieldName(name);
    }

    @Override
    public void writeNull() throws IOException {
        this.generator.writeNull();
    }

    @Override
    public void writeNullField(String name) throws IOException {
        this.generator.writeNullField(name);
    }

    @Override
    public void writeBooleanField(String name, boolean value) throws IOException {
        this.generator.writeBooleanField(name, value);
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        this.generator.writeBoolean(value);
    }

    @Override
    public void writeNumberField(String name, double value) throws IOException {
        this.generator.writeNumberField(name, value);
    }

    @Override
    public void writeNumber(double value) throws IOException {
        this.generator.writeNumber(value);
    }

    @Override
    public void writeNumberField(String name, float value) throws IOException {
        this.generator.writeNumberField(name, value);
    }

    @Override
    public void writeNumber(float value) throws IOException {
        this.generator.writeNumber(value);
    }

    @Override
    public void writeNumberField(String name, int value) throws IOException {
        this.generator.writeNumberField(name, value);
    }

    @Override
    public void writeNumber(int value) throws IOException {
        this.generator.writeNumber(value);
    }

    @Override
    public void writeNumberField(String name, long value) throws IOException {
        this.generator.writeNumberField(name, value);
    }

    @Override
    public void writeNumber(long value) throws IOException {
        this.generator.writeNumber(value);
    }

    @Override
    public void writeNumber(short value) throws IOException {
        this.generator.writeNumber(value);
    }

    @Override
    public void writeStringField(String name, String value) throws IOException {
        this.generator.writeStringField(name, value);
    }

    @Override
    public void writeString(String value) throws IOException {
        this.generator.writeString(value);
    }

    @Override
    public void writeString(char[] value, int offset, int len) throws IOException {
        this.generator.writeString(value, offset, len);
    }

    @Override
    public void writeUTF8String(byte[] value, int offset, int length) throws IOException {
        this.generator.writeUTF8String(value, offset, length);
    }

    @Override
    public void writeBinaryField(String name, byte[] value) throws IOException {
        this.generator.writeBinaryField(name, value);
    }

    @Override
    public void writeBinary(byte[] value) throws IOException {
        this.generator.writeBinary(value);
    }

    @Override
    public void writeBinary(byte[] value, int offset, int len) throws IOException {
        this.generator.writeBinary(value, offset, len);
    }

    private void writeStartRaw(String name) throws IOException {
        this.writeFieldName(name);
        this.generator.writeRaw(':');
    }

    public void writeEndRaw() {
        assert (this.base != null) : "JsonGenerator should be of instance GeneratorBase but was: " + this.generator.getClass();
        if (this.base != null) {
            JsonStreamContext context = this.base.getOutputContext();
            assert (context instanceof JsonWriteContext) : "Expected an instance of JsonWriteContext but was: " + context.getClass();
            ((JsonWriteContext)context).writeValue();
        }
    }

    @Override
    public void writeRawField(String name, InputStream content) throws IOException {
        XContentType contentType;
        if (!content.markSupported()) {
            content = new BufferedInputStream(content);
        }
        if ((contentType = XContentFactory.xContentType(content)) == null) {
            throw new IllegalArgumentException("Can't write raw bytes whose xcontent-type can't be guessed");
        }
        if (!this.mayWriteRawData(contentType)) {
            try (XContentParser parser = XContentFactory.xContent(contentType).createParser(NamedXContentRegistry.EMPTY, content);){
                parser.nextToken();
                this.writeFieldName(name);
                this.copyCurrentStructure(parser);
            }
        } else {
            this.writeStartRaw(name);
            this.flush();
            Streams.copy(content, this.os);
            this.writeEndRaw();
        }
    }

    @Override
    public final void writeRawField(String name, BytesReference content) throws IOException {
        XContentType contentType = XContentFactory.xContentType(content);
        if (contentType == null) {
            throw new IllegalArgumentException("Can't write raw bytes whose xcontent-type can't be guessed");
        }
        if (!this.mayWriteRawData(contentType)) {
            this.writeFieldName(name);
            this.copyRawValue(content, contentType.xContent());
        } else {
            this.writeStartRaw(name);
            this.flush();
            content.writeTo(this.os);
            this.writeEndRaw();
        }
    }

    @Override
    public final void writeRawValue(BytesReference content) throws IOException {
        XContentType contentType = XContentFactory.xContentType(content);
        if (contentType == null) {
            throw new IllegalArgumentException("Can't write raw bytes whose xcontent-type can't be guessed");
        }
        if (!this.mayWriteRawData(contentType)) {
            this.copyRawValue(content, contentType.xContent());
        } else {
            if (this.generator.getOutputContext().getCurrentName() != null) {
                this.generator.writeRaw(':');
            }
            this.flush();
            content.writeTo(this.os);
            this.writeEndRaw();
        }
    }

    private boolean mayWriteRawData(XContentType contentType) {
        return this.supportsRawWrites() && !this.isFiltered() && contentType == this.contentType() && !this.prettyPrint;
    }

    protected boolean supportsRawWrites() {
        return true;
    }

    protected void copyRawValue(BytesReference content, XContent xContent) throws IOException {
        try (StreamInput input = content.streamInput();
             XContentParser parser = xContent.createParser(NamedXContentRegistry.EMPTY, input);){
            this.copyCurrentStructure(parser);
        }
    }

    @Override
    public void copyCurrentStructure(XContentParser parser) throws IOException {
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        if (parser instanceof JsonXContentParser) {
            this.generator.copyCurrentStructure(((JsonXContentParser)parser).parser);
        } else {
            XContentHelper.copyCurrentStructure(this, parser);
        }
    }

    @Override
    public void flush() throws IOException {
        this.generator.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.generator.isClosed()) {
            return;
        }
        JsonStreamContext context = this.generator.getOutputContext();
        if (context != null && !context.inRoot()) {
            throw new IOException("Unclosed object or array found");
        }
        if (this.writeLineFeedAtEnd) {
            this.flush();
            this.getLowLevelGenerator().writeRaw((SerializableString)LF);
        }
        this.generator.close();
    }

    @Override
    public boolean isClosed() {
        return this.generator.isClosed();
    }
}

