"""Generated message classes for serviceregistry version v1alpha.

Manages service endpoints in Service Registry and provides integration with
DNS for service discovery and name resolution.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from googlecloudsdk.third_party.apitools.base.protorpclite import messages as _messages


package = 'serviceregistry'


class Endpoint(_messages.Message):
  """Next available tag: 13

  Fields:
    addresses: User-provided addresses and ports of the service represented by
      an endpoint.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional user-provided description of the endpoint.
    dnsIntegration: The DNS configuration for this endpoint. This must be a
      list of fully-qualified URLs to Compute Engine networks.
    fingerprint: Supply the fingerprint value for update requests. The
      fingerprint value is generated by the server and ensures optimistic
      concurrency (so that only one update can be performed at a time). The
      fingerprint changes after each update.
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    name: A user-provided name of the endpoint, which must be unique within
      the project. The name must comply with RFC1035. Specifically, the name
      must be 1-63 characters long and match the regular expression
      [a-z]([-a-z0-9]*[a-z0-9])? which means the first character must be a
      lowercase letter, and all following characters must be a dash, lowercase
      letter, or digit, except the last character, which cannot be a dash.
    selfLink: [Output Only] Self link for the endpoint.
    state: [Output Only] The current state of the endpoint, as determined by
      the system.
  """

  addresses = _messages.MessageField('EndpointAddress', 1, repeated=True)
  creationTimestamp = _messages.StringField(2)
  description = _messages.StringField(3)
  dnsIntegration = _messages.MessageField('EndpointDnsIntegration', 4)
  fingerprint = _messages.BytesField(5)
  id = _messages.IntegerField(6, variant=_messages.Variant.UINT64)
  name = _messages.StringField(7)
  selfLink = _messages.StringField(8)
  state = _messages.StringField(9)


class EndpointAddress(_messages.Message):
  """Information about a single address and the corresponding ports for an
  endpoint.

  Fields:
    address: A list of addresses of the service represented by an endpoint.
      Each address can be an IPv4 or IPv6 address, or a hostname.
    ports: A list of ports to be used with this address.
  """

  address = _messages.StringField(1)
  ports = _messages.MessageField('EndpointPort', 2, repeated=True)


class EndpointDnsIntegration(_messages.Message):
  """A EndpointDnsIntegration object.

  Fields:
    enableExternal: True if a cloud.goog DNS entry should be created to expose
      this endpoint externally.
    externalDnsName: [Output Only] Externally visible fully qualified domain
      name for the endpoint.
    internalDnsName: [Output Only] Fully qualified domain name for the
      endpoint; used when addressing the endpoint from within Compute Networks
      specified in the networks field.
    networks: A list of Google Compute Engine networks for which the name of
      this endpoint is resolvable through DNS.
  """

  enableExternal = _messages.BooleanField(1)
  externalDnsName = _messages.StringField(2)
  internalDnsName = _messages.StringField(3)
  networks = _messages.StringField(4, repeated=True)


class EndpointPort(_messages.Message):
  """Information about a single port used by an endpoint.

  Fields:
    name: The name of the port. This is optional if only one port is defined
      for the endpoint.
    portNumber: The port number of the endpoint.
    protocol: An optional user-supplied protocol for this port. Must be one of
      the following protocol strings: tcp, udp, icmp, esp, ah, or sctp. The
      default is tcp.
  """

  name = _messages.StringField(1)
  portNumber = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  protocol = _messages.StringField(3)


class EndpointsListResponse(_messages.Message):
  """A response containing a partial list of Endpoints and a page token used
  to build the next request if the request has been truncated. Next available
  tag: 6

  Fields:
    endpoints: The endpoints contained in this response.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
  """

  endpoints = _messages.MessageField('Endpoint', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class Operation(_messages.Message):
  """An Operation resource, used to manage asynchronous API requests.

  Messages:
    ErrorValue: [Output Only] If errors are generated during processing of the
      operation, this field will be populated.
    WarningsValueListEntry: A WarningsValueListEntry object.

  Fields:
    clientOperationId: [Output Only] Reserved for future use.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: [Output Only] A textual description of the operation, which
      is set when the operation is created.
    endTime: [Output Only] The time that this operation was completed. This
      value is in RFC3339 text format.
    error: [Output Only] If errors are generated during processing of the
      operation, this field will be populated.
    httpErrorMessage: [Output Only] If the operation fails, this field
      contains the HTTP error message that was returned, such as NOT FOUND.
    httpErrorStatusCode: [Output Only] If the operation fails, this field
      contains the HTTP error status code that was returned. For example, a
      404 means the resource was not found.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    insertTime: [Output Only] The time that this operation was requested. This
      value is in RFC3339 text format.
    kind: [Output Only] Type of the resource. Always compute#operation for
      Operation resources.
    name: [Output Only] Name of the resource.
    operationType: [Output Only] The type of operation, such as insert,
      update, or delete, and so on.
    progress: [Output Only] An optional progress indicator that ranges from 0
      to 100. There is no requirement that this be linear or support any
      granularity of operations. This should not be used to guess when the
      operation will be complete. This number should monotonically increase as
      the operation progresses.
    region: [Output Only] The URL of the region where the operation resides.
      Only available when performing regional operations.
    selfLink: [Output Only] Server-defined URL for the resource.
    startTime: [Output Only] The time that this operation was started by the
      server. This value is in RFC3339 text format.
    status: [Output Only] The status of the operation, which can be one of the
      following: PENDING, RUNNING, or DONE.
    statusMessage: [Output Only] An optional textual description of the
      current status of the operation.
    targetId: [Output Only] The unique target ID, which identifies a specific
      incarnation of the target resource.
    targetLink: [Output Only] The URL of the resource that the operation
      modifies.
    user: [Output Only] User who requested the operation, for example:
      user@example.com.
    warnings: [Output Only] If warning messages are generated during
      processing of the operation, this field will be populated.
    zone: [Output Only] The URL of the zone where the operation resides. Only
      available when performing per-zone operations.
  """

  class ErrorValue(_messages.Message):
    """[Output Only] If errors are generated during processing of the
    operation, this field will be populated.

    Messages:
      ErrorsValueListEntry: A ErrorsValueListEntry object.

    Fields:
      errors: [Output Only] The array of errors encountered while processing
        this operation.
    """

    class ErrorsValueListEntry(_messages.Message):
      """A ErrorsValueListEntry object.

      Fields:
        code: [Output Only] The error type identifier for this error.
        location: [Output Only] Indicates the field in the request that caused
          the error. This property is optional.
        message: [Output Only] An optional, human-readable error message.
      """

      code = _messages.StringField(1)
      location = _messages.StringField(2)
      message = _messages.StringField(3)

    errors = _messages.MessageField('ErrorsValueListEntry', 1, repeated=True)

  class WarningsValueListEntry(_messages.Message):
    """A WarningsValueListEntry object.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.StringField(1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  clientOperationId = _messages.StringField(1)
  creationTimestamp = _messages.StringField(2)
  description = _messages.StringField(3)
  endTime = _messages.StringField(4)
  error = _messages.MessageField('ErrorValue', 5)
  httpErrorMessage = _messages.StringField(6)
  httpErrorStatusCode = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  id = _messages.IntegerField(8, variant=_messages.Variant.UINT64)
  insertTime = _messages.StringField(9)
  kind = _messages.StringField(10, default=u'serviceregistry#operation')
  name = _messages.StringField(11)
  operationType = _messages.StringField(12)
  progress = _messages.IntegerField(13, variant=_messages.Variant.INT32)
  region = _messages.StringField(14)
  selfLink = _messages.StringField(15)
  startTime = _messages.StringField(16)
  status = _messages.StringField(17)
  statusMessage = _messages.StringField(18)
  targetId = _messages.IntegerField(19, variant=_messages.Variant.UINT64)
  targetLink = _messages.StringField(20)
  user = _messages.StringField(21)
  warnings = _messages.MessageField('WarningsValueListEntry', 22, repeated=True)
  zone = _messages.StringField(23)


class OperationsListResponse(_messages.Message):
  """A response containing a partial list of operations and a page token used
  to build the next request if the request has been truncated.

  Fields:
    nextPageToken: [Output Only] A token used to continue a truncated list
      request.
    operations: [Output Only] Operations contained in this list response.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ServiceregistryEndpointsDeleteRequest(_messages.Message):
  """A ServiceregistryEndpointsDeleteRequest object.

  Fields:
    endpoint: The name of the endpoint for this request.
    project: The project ID for this request.
  """

  endpoint = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ServiceregistryEndpointsGetRequest(_messages.Message):
  """A ServiceregistryEndpointsGetRequest object.

  Fields:
    endpoint: The name of the endpoint for this request.
    project: The project ID for this request.
  """

  endpoint = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ServiceregistryEndpointsInsertRequest(_messages.Message):
  """A ServiceregistryEndpointsInsertRequest object.

  Fields:
    endpoint: A Endpoint resource to be passed as the request body.
    project: The project ID for this request.
  """

  endpoint = _messages.MessageField('Endpoint', 1)
  project = _messages.StringField(2, required=True)


class ServiceregistryEndpointsListRequest(_messages.Message):
  """A ServiceregistryEndpointsListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: The project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  pageToken = _messages.StringField(3)
  project = _messages.StringField(4, required=True)


class ServiceregistryEndpointsPatchRequest(_messages.Message):
  """A ServiceregistryEndpointsPatchRequest object.

  Fields:
    endpoint: The name of the endpoint for this request.
    endpointResource: A Endpoint resource to be passed as the request body.
    project: The project ID for this request.
  """

  endpoint = _messages.StringField(1, required=True)
  endpointResource = _messages.MessageField('Endpoint', 2)
  project = _messages.StringField(3, required=True)


class ServiceregistryEndpointsUpdateRequest(_messages.Message):
  """A ServiceregistryEndpointsUpdateRequest object.

  Fields:
    endpoint: The name of the endpoint for this request.
    endpointResource: A Endpoint resource to be passed as the request body.
    project: The project ID for this request.
  """

  endpoint = _messages.StringField(1, required=True)
  endpointResource = _messages.MessageField('Endpoint', 2)
  project = _messages.StringField(3, required=True)


class ServiceregistryOperationsGetRequest(_messages.Message):
  """A ServiceregistryOperationsGetRequest object.

  Fields:
    operation: The name of the operation for this request.
    project: The project ID for this request.
  """

  operation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ServiceregistryOperationsListRequest(_messages.Message):
  """A ServiceregistryOperationsListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: The project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  pageToken = _messages.StringField(3)
  project = _messages.StringField(4, required=True)


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    AltValueValuesEnum: Data format for the response.

  Fields:
    alt: Data format for the response.
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters. Overrides userIp if both are provided.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    userIp: IP address of the site where the request originates. Use this if
      you want to enforce per-user limits.
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for the response.

    Values:
      json: Responses with Content-Type of application/json
    """
    json = 0

  alt = _messages.EnumField('AltValueValuesEnum', 1, default=u'json')
  fields = _messages.StringField(2)
  key = _messages.StringField(3)
  oauth_token = _messages.StringField(4)
  prettyPrint = _messages.BooleanField(5, default=True)
  quotaUser = _messages.StringField(6)
  trace = _messages.StringField(7)
  userIp = _messages.StringField(8)


