<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_deflate - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_deflate</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_deflate.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_deflate.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_deflate.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_deflate.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Comprime le contenu avant de le servir au
client</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>deflate_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_deflate.c</td></tr></table>
<h3>Sommaire</h3>

    <p>Le module <code class="module"><a href="../mod/mod_deflate.html">mod_deflate</a></code> implmente le filtre de
    sortie <code>DEFLATE</code> qui permet de comprimer la sortie de
    votre serveur avant de l'envoyer au client sur le rseau.</p>
</div>
<div id="quickview"><h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#supportedencodings">Codages supports</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#recommended">Exemples de configurations</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#enable">Activation de la compression</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxies">Prise en compte des serveurs mandataires</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#precompressed">Servir du contenu prcompress</a></li>
</ul><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#deflatebuffersize">DeflateBufferSize</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#deflatecompressionlevel">DeflateCompressionLevel</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#deflatefilternote">DeflateFilterNote</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#deflateinflatelimitrequestbody">DeflateInflateLimitRequestBody</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#deflateinflateratioburst">DeflateInflateRatioBurst</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#deflateinflateratiolimit">DeflateInflateRatioLimit</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#deflatememlevel">DeflateMemLevel</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#deflatewindowsize">DeflateWindowSize</a></li>
</ul>
<h3>Traitement des bugs</h3><ul class="seealso"><li><a href="https://www.apache.org/dist/httpd/CHANGES_2.4">Journal des modifications de httpd</a></li><li><a href="https://bz.apache.org/bugzilla/buglist.cgi?bug_status=__open__&amp;list_id=144532&amp;product=Apache%20httpd-2&amp;query_format=specific&amp;order=changeddate%20DESC%2Cpriority%2Cbug_severity&amp;component=mod_deflate">Problmes connus</a></li><li><a href="https://bz.apache.org/bugzilla/enter_bug.cgi?product=Apache%20httpd-2&amp;component=mod_deflate">Signaler un bug</a></li></ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><a href="../filter.html">Les filtres</a></li>
<li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="supportedencodings" id="supportedencodings">Codages supports</a></h2>
  <p>Le seul codage support est <code>gzip</code> afin d'assurer une complte
  compatibilit avec les anciens navigateurs. Le codage <code>deflate</code>
  n'est donc pas support ; voir  ce sujet la <a href="http://www.gzip.org/zlib/zlib_faq.html#faq38">documentation de zlib</a>
  pour une explication dtaille.
  </p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="recommended" id="recommended">Exemples de configurations</a></h2>
    <div class="warning"><h3>Compression et TLS</h3>
        <p>Certaines applications web sont vulnrables aux attaques
	visant le vol d'information lorsqu'une connexion TLS transmet
	des donnes compresses par deflate. Pour plus de dtails,
	tudiez les attaques de la famille "BREACH".</p>
    </div>
    <p>Voici une configuration simple qui comprime les contenus  base
    de texte courants.</p>

    <div class="example"><h3>Ne comprime que certains types de documents</h3><pre class="prettyprint lang-config">AddOutputFilterByType DEFLATE text/html text/plain text/xml text/css text/javascript application/javascript</pre>
</div>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="enable" id="enable">Activation de la compression</a></h2>

    <div class="warning"><h3>Compression et TLS</h3>
        <p>Certaines applications web sont vulnrables aux attaques pour
	vol d'information lorsque la connexion TLS transmet des donnes
	compresses par deflate. Pour plus d'informations, voir en
	dtails la famille d'attaques de type "BREACH".</p>
    </div>

    <h3><a name="output" id="output">Compression de la sortie</a></h3>
      <p>La compression est implmente par le <a href="../filter.html">filtre</a> <code>DEFLATE</code>. La
      directive suivante active la compression des documents dans le
      conteneur o elle est place :</p>

      <pre class="prettyprint lang-config">SetOutputFilter DEFLATE
SetEnvIfNoCase Request_URI "\.(?:gif|jpe?g|png)$" no-gzip</pre>


      <p>Si vous voulez limiter la compression  certains types MIME
      particuliers, vous pouvez utiliser la directive <code class="directive"><a href="../mod/mod_filter.html#addoutputfilterbytype">AddOutputFilterByType</a></code>. Voici un exemple
      o la compression n'est active que pour les fichiers html de la
      documentation d'Apache :</p>

      <pre class="prettyprint lang-config">&lt;Directory "/your-server-root/manual"&gt;
    AddOutputFilterByType DEFLATE text/html
&lt;/Directory&gt;</pre>


      <div class="note"><h3>Note</h3>
        Le filtre <code>DEFLATE</code> est toujours insr aprs les
	filtres RESOURCE comme PHP ou SSI. Il n'affecte jamais les
	sous-requtes internes.
      </div>
      <div class="note"><h3>Note</h3>
        La variable d'environnement <code>force-gzip</code>, dfinie 
	l'aide de la directive <code class="directive"><a href="../mod/mod_env.html#setenv">SetEnv</a></code>, permet d'ignorer la
	configuration de votre navigateur quant aux codages accepts, et
	d'envoyer sans condition une sortie comprime.
      </div>

    
    <h3><a name="inflate" id="inflate">Dcompression de la sortie</a></h3>
      <p>Le module <code class="module"><a href="../mod/mod_deflate.html">mod_deflate</a></code> fournit aussi un filtre
      permettant de dcomprimer un corps de rponse comprim par gzip.
      Pour activer cette fonctionnalit, vous devez insrer le filtre
      <code>INFLATE</code> dans la chane de filtrage en sortie via la
      directive <code class="directive"><a href="../mod/core.html#setoutputfilter">SetOutputFilter</a></code> ou
      <code class="directive"><a href="../mod/mod_mime.html#addoutputfilter">AddOutputFilter</a></code>, comme
      dans l'exemple suivant :</p>

      <pre class="prettyprint lang-config">&lt;Location "/dav-area"&gt;
    ProxyPass "http://example.com/"
    SetOutputFilter INFLATE
&lt;/Location&gt;</pre>


      <p>Dans cet exemple, les sorties comprimes par gzip en
      provenance de example.com seront dcomprimes afin de pouvoir
      tre ventuellement traites par d'autres filtres.
      </p>

    
    <h3><a name="input" id="input">Dcompression de l'entre</a></h3>
      <p>Le module <code class="module"><a href="../mod/mod_deflate.html">mod_deflate</a></code> fournit galement un filtre
      permettant de dcomprimer un corps de requte comprim par gzip.
      Pour activer cette fonctionnalit, vous devez insrer le filtre
      <code>DEFLATE</code> dans la chane de filtrage en entre via la
      directive <code class="directive"><a href="../mod/core.html#setinputfilter">SetInputFilter</a></code> ou
      <code class="directive"><a href="../mod/mod_mime.html#addinputfilter">AddInputFilter</a></code>, comme
      dans l'exemple suivant :</p>

      <pre class="prettyprint lang-config">&lt;Location "/dav-area"&gt;
    SetInputFilter DEFLATE
&lt;/Location&gt;</pre>


      <p>Dsormais, si une requte contient un en-tte
      <code>Content-Encoding: gzip</code>, son corps sera
      automatiquement dcomprim. Peu de navigateurs sont actuellement
      en mesure de comprimer les corps de requtes. Cependant,
      certaines applications spcialises supportent les requtes
      comprimes, comme par exemple certains clients <a href="http://www.webdav.org">WebDAV</a>.</p>

      <div class="warning"><h3>Note  propos de l'en-tte
      <code>Content-Length</code></h3>
        <p>Si vous valuez vous-mme la taille du corps de requte,
	<em>ne faites pas confiance  l'en-tte
	<code>Content-Length</code>!</em> L'en-tte
	Content-Length indique la longueur des donnes en provenance du
	client, et <em>non</em> la quantit d'octets que reprsente le
	flux de donnes dcompress.</p>
      </div>
    
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="proxies" id="proxies">Prise en compte des serveurs mandataires</a></h2>

    <p>Le module <code class="module"><a href="../mod/mod_deflate.html">mod_deflate</a></code> envoie un en-tte de
    rponse HTTP <code>Vary: Accept-Encoding</code> pour avertir les
    mandataires qu'une rponse enregistre dans le cache ne doit tre
    envoye qu'aux clients qui ont envoy l'en-tte de requte
    <code>Accept-Encoding</code> appropri. Ceci permet d'viter l'envoi
    d'un contenu comprim  un client qui ne sera pas en mesure
    de l'interprter.</p>

    <p>Si vous avez dfini des exclusions spcifiques dpendant, par
    exemple, de l'en-tte <code>User-Agent</code>, vous devez
    ajouter manuellement des donnes  l'en-tte <code>Vary</code> afin
    d'informer les mandataires des restrictions supplmentaires. Par
    exemple, dans la configuration classique o l'addition du filtre
    <code>DEFLATE</code> dpend du contenu de l'en-tte
    <code>User-Agent</code>, vous devez spcifier :</p>

    <pre class="prettyprint lang-config">Header append Vary User-Agent</pre>


    <p>Si votre dcision de comprimer le contenu dpend d'autres
    informations que celles contenues dans les en-ttes de la requte
    (par exemple la version HTTP), vous devez attribuer  l'en-tte
    <code>Vary</code> la valeur <code>*</code>, ce qui permet d'empcher
    les mandataires compatibles de tout mettre en cache.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">Header set Vary *</pre>
</div>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="precompressed" id="precompressed">Servir du contenu prcompress</a></h2>

    <p>Comme <code class="module"><a href="../mod/mod_deflate.html">mod_deflate</a></code> recompresse le contenu demand 
    chaque requte, il est possible de gagner en performances en
    prcompressant ce contenu, et en forant mod_deflate  servir ce
    contenu prcompress sans avoir  le recompresser  chaque requte.
    Pour ce faire, utilisez une configuration du style :</p>

    <pre class="prettyprint lang-config">&lt;IfModule mod_headers.c&gt;
    # Servir des fichiers CSS compresss avec gzip, s'ils existent, et
    # si le client accepte gzip.
    RewriteCond "%{HTTP:Accept-encoding}" "gzip"
    RewriteCond "%{REQUEST_FILENAME}\.gz" "-s"
    RewriteRule "^(.*)\.css"              "$1\.css\.gz" [QSA]

    # Servir des fichiers JS compresss avec gzip, s'ils existent, et
    # si le client accepte gzip.
    RewriteCond "%{HTTP:Accept-encoding}" "gzip"
    RewriteCond "%{REQUEST_FILENAME}\.gz" "-s"
    RewriteRule "^(.*)\.js"               "$1\.js\.gz" [QSA]


    # Servir des types de contenus corrects, et empcher mod_deflate
    # d'effectuer un double gzip.
    RewriteRule "\.css\.gz$" "-" [T=text/css,E=no-gzip:1]
    RewriteRule "\.js\.gz$"  "-" [T=text/javascript,E=no-gzip:1]


    &lt;FilesMatch "(\.js\.gz|\.css\.gz)$"&gt;
      # Servir le type de codage correct.
      Header append Content-Encoding gzip

      # Force les mandataires  mettre en cache sparment les fichiers
      # css/js gzipps &amp; non gzipps.
      Header append Vary Accept-Encoding
    &lt;/FilesMatch&gt;
&lt;/IfModule&gt;</pre>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="deflatebuffersize" id="deflatebuffersize">Directive</a> <a name="DeflateBufferSize" id="DeflateBufferSize">DeflateBufferSize</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Taille du fragment que zlib devra comprimer en une seule
fois</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DeflateBufferSize <var>valeur</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>DeflateBufferSize 8096</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_deflate</td></tr>
</table>
    <p>La directive <code class="directive">DeflateBufferSize</code> permet de
    spcifier la taille en octets du fragment que zlib devra comprimer
    en une seule fois. Si la taille de la rponse compresse est suprieure 
    celle spcifie par cette directive, httpd passera  un mode d'encodage
    fragment (l'en-tte HTTP <code>Transfer-Encoding</code> prend la valeur
    <code>Chunked</code>), ceci ayant comme effet de bord de ne dfinir aucun
    en-tte HTTP <code>Content-Length</code>. Il est important de connatre ce
    comportement, particulirement lorsque httpd travaille derrire des
    mandataires inverses avec mise en cache, ou lorsque httpd est configur pour
    utiliser <code class="module"><a href="../mod/mod_cache.html">mod_cache</a></code> et <code class="module"><a href="../mod/mod_cache_disk.html">mod_cache_disk</a></code> car
    les rponses HTTP sans en-tte <code>Content-Length</code> peuvent ne pas
    tre mises en cache.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="deflatecompressionlevel" id="deflatecompressionlevel">Directive</a> <a name="DeflateCompressionLevel" id="DeflateCompressionLevel">DeflateCompressionLevel</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Le niveau de compression que nous appliquons  la
sortie</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DeflateCompressionLevel <var>valeur</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>La valeur par dfaut de zlib</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_deflate</td></tr>
</table>
    <p>La directive <code class="directive">DeflateCompressionLevel</code>
    permet de spcifier le niveau de compression  utiliser ; plus
    grande est la valeur, meilleure sera la compression, mais plus grand
    sera aussi le temps CPU ncessaire pour effectuer le
    traitement.</p>
    <p>La valeur doit tre comprise entre 1 (compression minimale) et 9
    (compression maximale).</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="deflatefilternote" id="deflatefilternote">Directive</a> <a name="DeflateFilterNote" id="DeflateFilterNote">DeflateFilterNote</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Enregistre le taux de compression sous la forme d'une note
 des fins de journalisation</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DeflateFilterNote [<var>type</var>] <var>nom de la note</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_deflate</td></tr>
</table>
    <p>La directive <code class="directive">DeflateFilterNote</code> permet de
    spcifier qu'une note  propos du taux de compression doit tre
    attache  la requte. Le nom de la note est pass sous la forme
    d'un argument de la directive. Vous pouvez utiliser cette note  des
    fins statistiques en enregistrant sa valeur dans votre <a href="../logs.html#accesslog">journal des accs</a>.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">      DeflateFilterNote ratio
    
      LogFormat '"%r" %b (%{ratio}n) "%{User-agent}i"' deflate
      CustomLog "logs/deflate_log" deflate</pre>
</div>

    <p>Pour extraire des informations plus prcises de vos journaux,
    vous pouvez utiliser l'argument <var>type</var> pour spcifier le
    type de donnes de la note enregistre dans le journal.
    <var>type</var> peut prendre une des valeurs suivantes :</p>

    <dl>
      <dt><code>Input</code></dt>
      <dd>Enregistre dans la note la taille en octets du flux en entre
      du filtre.</dd>

      <dt><code>Output</code></dt>
      <dd>Enregistre dans la note la taille en octets du flux en sortie
      du filtre.</dd>

      <dt><code>Ratio</code></dt>
      <dd>Enregistre le taux de compression (<code>sortie/entre *
      100</code>) dans la note. Il s'agit de la valeur par dfaut si
      l'argument <var>type</var> est omis.</dd>
    </dl>

    <p>Vous pouvez donc configurer votre journalisation de la manire
    suivante :</p>

    <div class="example"><h3>Journalisation dtaille</h3><pre class="prettyprint lang-config">DeflateFilterNote Input instream
DeflateFilterNote Output outstream
DeflateFilterNote Ratio ratio

LogFormat '"%r" %{outstream}n/%{instream}n (%{ratio}n%%)' deflate
CustomLog "logs/deflate_log" deflate</pre>
</div>

<h3>Voir aussi</h3>
<ul>
<li><code class="module"><a href="../mod/mod_log_config.html">mod_log_config</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="deflateinflatelimitrequestbody" id="deflateinflatelimitrequestbody">Directive</a> <a name="DeflateInflateLimitRequestBody" id="DeflateInflateLimitRequestBody">DeflateInflateLimitRequestBody</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Taille maximale des corps de requte dcompresss</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DeflateInflateLimitRequestBody<var>value</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Aucune limite, mais LimitRequestBody s'applique aprs la
compression</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_deflate</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.10 du serveur HTTP
Apache</td></tr>
</table>
    <p>La directive
    <code class="directive">DeflateInflateLimitRequestBody</code> permet de
    spcifier la taille maximale d'un corps de requte dcompress. Si
    elle n'est pas dfinie, c'est la valeur de la directive <code class="directive"><a href="../mod/core.html#limitrequestbody">LimitRequestBody</a></code> qui s'applique au corps
    de requte dcompress.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="deflateinflateratioburst" id="deflateinflateratioburst">Directive</a> <a name="DeflateInflateRatioBurst" id="DeflateInflateRatioBurst">DeflateInflateRatioBurst</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre maximal de fois que le ratio de dcompression d'un
corps de requte peut tre dpass</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DeflateInflateRatioBurst <var>value</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>3</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_deflate</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.10 du serveur HTTP
Apache</td></tr>
</table>
    <p>La directive <code class="directive">DeflateInflateRatioBurst</code>
    permet de spcifier le nombre maximal de fois que la valeur de la
    directive <code class="directive">DeflateInflateRatioLimit</code> peut tre
    dpass avant l'arrt du traitement de la requte.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="deflateinflateratiolimit" id="deflateinflateratiolimit">Directive</a> <a name="DeflateInflateRatioLimit" id="DeflateInflateRatioLimit">DeflateInflateRatioLimit</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Ratio de dcompression maximum pour les corps de requtes</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DeflateInflateRatioLimit <var>value</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>200</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_deflate</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.10 du serveur HTTP
Apache</td></tr>
</table>
    <p>La directive <code class="directive">DeflateInflateRatioLimit</code>
    permet de dfinir le ratio maximum entre la taille d'un corps de
    requte compress et sa taille dcompresse. Ce ratio est vrifi au
    fur et  mesure de
    l'arrive du corps de requte, et s'il est dpass plus de
    <code class="directive">DeflateInflateRatioBurst</code> fois, le traitement
    de la requte est interrompu.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="deflatememlevel" id="deflatememlevel">Directive</a> <a name="DeflateMemLevel" id="DeflateMemLevel">DeflateMemLevel</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>La quantit de mmoire utilisable par zlib pour la
compression</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DeflateMemLevel <var>valeur</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>DeflateMemLevel 9</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_deflate</td></tr>
</table>
    <p>La directive <code class="directive">DeflateMemLevel</code> permet de
    spcifier la quantit de mmoire utilisable par zlib pour la
    compression (une valeur comprise entre 1 et 9).</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="deflatewindowsize" id="deflatewindowsize">Directive</a> <a name="DeflateWindowSize" id="DeflateWindowSize">DeflateWindowSize</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Taille de la fentre de compression zlib</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DeflateWindowSize <var>valeur</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>DeflateWindowSize 15</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_deflate</td></tr>
</table>
    <p>La directive <code class="directive">DeflateWindowSize</code> permet de
    spcifier la fentre de compression zlib (une valeur comprise entre
    1 et 15). En gnral, plus grande sera la taille de la fentre, plus
    grand sera le taux de compression auquel on pourra s'attendre.</p>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_deflate.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_deflate.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_deflate.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_deflate.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_deflate.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2016 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>