/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ui.validator;

import java.util.Arrays;
import java.util.List;
import org.python.pydev.refactoring.ast.adapters.AbstractNodeAdapter;
import org.python.pydev.refactoring.ast.adapters.AbstractScopeNode;
import org.python.pydev.refactoring.ast.adapters.FunctionDefAdapter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameValidator {
    private final String[] keywords = new String[]{"and", "assert", "break", "class", "continue", "def", "del", "elif", "else", "except", "exec", "finally", "for", "from", "global", "if", "import", "in", "is", "lambda", "not", "or", "pass", "print", "raise", "return", "try", "while", "yield"};
    private final String nameRegExp = "[a-zA-Z_][a-zA-Z_0-9]*";
    private AbstractScopeNode<?> scopeNode;
    private List<String> keywordList;

    public NameValidator(AbstractScopeNode<?> scope) {
        this.scopeNode = scope;
        this.keywordList = Arrays.asList(this.keywords);
    }

    public void validateUniqueVariable(String name) throws Throwable {
        if (this.scopeNode.alreadyUsedName(name)) {
            throw new Exception(new StringBuffer("Variable name '").append(name).append("' is already used").toString());
        }
    }

    public void validateVariableName(String name) throws Throwable {
        if (!name.matches("[a-zA-Z_][a-zA-Z_0-9]*")) {
            throw new Exception(new StringBuffer("'").append(name).append("' is not a valid variable name").toString());
        }
        this.validateNotKeyword(name);
    }

    private void validateNotKeyword(String name) throws Exception {
        if (this.keywordList.contains(name)) {
            throw new Exception(new StringBuffer("'").append(name).append("' is a reserved word").toString());
        }
    }

    public void validateMethodName(String name) throws Throwable {
        if (!name.matches("[a-zA-Z_][a-zA-Z_0-9]*")) {
            throw new Exception(new StringBuffer("'").append(name).append("' is not a valid function name").toString());
        }
        this.validateNotKeyword(name);
    }

    public void validateUniqueFunction(String name) throws Exception {
        AbstractNodeAdapter parentAdapter = this.scopeNode.getParent();
        if (parentAdapter != null) {
            for (FunctionDefAdapter function : ((AbstractScopeNode)parentAdapter).getFunctions()) {
                if (function.getName().compareTo(name) != 0) continue;
                throw new Exception(new StringBuffer("Function name '").append(name).append("' is already used").toString());
            }
        }
    }
}

