/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.sync;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.TeamStatus;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.core.variants.ResourceVariantByteStore;
import org.eclipse.team.core.variants.SessionResourceVariantByteStore;
import org.tigris.subversion.subclipse.core.IResourceStateChangeListener;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.client.StatusAndInfoCommand;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.RemoteResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.sync.SVNRevisionComparator;
import org.tigris.subversion.subclipse.core.sync.SVNStatusSyncInfo;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public class SVNWorkspaceSubscriber
extends Subscriber
implements IResourceStateChangeListener {
    private static SVNWorkspaceSubscriber instance;
    private static final byte[] DUMMY_SYNC_BYTES;
    protected SVNRevisionComparator comparator = new SVNRevisionComparator();
    protected ResourceVariantByteStore remoteSyncStateStore = new SessionResourceVariantByteStore();

    static {
        DUMMY_SYNC_BYTES = new byte[]{-1, -2, -3, -4};
    }

    public static synchronized SVNWorkspaceSubscriber getInstance() {
        if (instance == null) {
            instance = new SVNWorkspaceSubscriber();
        }
        return instance;
    }

    private SVNWorkspaceSubscriber() {
        SVNProviderPlugin.addResourceStateChangeListener(this);
    }

    public IResourceVariantComparator getResourceComparator() {
        return this.comparator;
    }

    public String getName() {
        return "SVNStatusSubscriber";
    }

    public IResource[] roots() {
        ArrayList<IProject> result = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            RepositoryProvider provider;
            IProject project = projects[i];
            if (project.isAccessible() && (provider = RepositoryProvider.getProvider((IProject)project, (String)"org.tigris.subversion.subclipse.core.svnnature")) != null) {
                result.add(project);
            }
            ++i;
        }
        return result.toArray(new IProject[result.size()]);
    }

    public boolean isSupervised(IResource resource) throws TeamException {
        block7: {
            block6: {
                try {
                    if (!resource.isTeamPrivateMember() && !SVNWorkspaceRoot.isLinkedResource(resource)) break block6;
                    return false;
                }
                catch (TeamException e) {
                    if (e.getStatus().getCode() == 368) {
                        return false;
                    }
                    throw e;
                }
            }
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resource.getProject(), (String)SVNProviderPlugin.getTypeId());
            if (provider != null) break block7;
            return false;
        }
        ISVNLocalResource svnThing = SVNWorkspaceRoot.getSVNResourceFor(resource);
        if (svnThing.isIgnored()) {
            return this.remoteSyncStateStore.getBytes(resource) != null || this.remoteSyncStateStore.members(resource) != null && this.remoteSyncStateStore.members(resource).length > 0;
        }
        return true;
    }

    public IResource[] members(IResource resource) throws TeamException {
        if (resource.getType() == 1 || !this.isSupervised(resource)) {
            return new IResource[0];
        }
        try {
            HashSet<IResource> allMembers;
            block5: {
                allMembers = new HashSet<IResource>();
                try {
                    allMembers.addAll(Arrays.asList(((IContainer)resource).members(true)));
                }
                catch (CoreException e) {
                    if (e.getStatus().getCode() == 368) break block5;
                    throw e;
                }
            }
            allMembers.addAll(Arrays.asList(this.remoteSyncStateStore.members(resource)));
            return allMembers.toArray(new IResource[allMembers.size()]);
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
    }

    public SyncInfo getSyncInfo(IResource resource) throws TeamException {
        if (resource == null) {
            return null;
        }
        if (!this.isSupervised(resource)) {
            return null;
        }
        LocalResourceStatus localStatus = SVNProviderPlugin.getPlugin().getStatusCacheManager().getStatus(resource);
        RemoteResourceStatus remoteStatusInfo = null;
        byte[] remoteBytes = this.remoteSyncStateStore.getBytes(resource);
        if (remoteBytes != null && remoteBytes != DUMMY_SYNC_BYTES) {
            remoteStatusInfo = RemoteResourceStatus.fromBytes(remoteBytes);
        }
        SVNStatusSyncInfo syncInfo = new SVNStatusSyncInfo(resource, localStatus, remoteStatusInfo, this.comparator);
        syncInfo.init();
        return syncInfo;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refresh(IResource[] resources, int depth, IProgressMonitor monitor) throws TeamException {
        monitor = Policy.monitorFor(monitor);
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        try {
            monitor.beginTask("", 1000 * resources.length);
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                SVNTeamProvider teamProvider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)resource.getProject(), (String)SVNProviderPlugin.getTypeId());
                if (teamProvider != null) {
                    monitor.subTask(resource.getName());
                    IStatus status = this.refresh(resource, depth, monitor);
                    if (!status.isOK()) {
                        errors.add(status);
                    }
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        monitor.done();
        if (!errors.isEmpty()) {
            int numSuccess = resources.length - errors.size();
            throw new TeamException((IStatus)new MultiStatus("org.tigris.subversion.subclipse.core", 0, errors.toArray(new IStatus[errors.size()]), Policy.bind("SVNWorkspaceSubscriber.errorWhileSynchronizing.1", new Object[]{this.getName(), Integer.toString(numSuccess), Integer.toString(resources.length)}), null));
        }
    }

    private IStatus refresh(IResource resource, int depth, IProgressMonitor monitor) {
        try {
            monitor.worked(100);
            monitor.setTaskName(Policy.bind("SVNWorkspaceSubscriber.retrievingSynchronizationData"));
            IResource[] changedResources = this.findChanges(resource, depth, Policy.infiniteSubMonitorFor(monitor, 400));
            this.fireTeamResourceChange((ISubscriberChangeEvent[])SubscriberChangeEvent.asSyncChangedDeltas((Subscriber)this, (IResource[])changedResources));
            monitor.worked(400);
            return Status.OK_STATUS;
        }
        catch (TeamException e) {
            return new TeamStatus(4, "org.tigris.subversion.subclipse.core", 0, Policy.bind("SVNWorkspaceSubscriber.errorWhileSynchronizing.2", resource.getFullPath().toString(), e.getMessage()), (Throwable)e, resource);
        }
    }

    private IResource[] findChanges(IResource resource, int depth, IProgressMonitor monitor) throws TeamException {
        IResource[] iResourceArray;
        try {
            monitor.beginTask("", 100);
            this.remoteSyncStateStore.flushBytes(resource, depth);
            boolean descend = depth == 2;
            boolean showOutOfDate = SVNProviderPlugin.getPlugin().getPluginPreferences().getBoolean("show_out_of_date_folders");
            StatusAndInfoCommand cmd = new StatusAndInfoCommand(SVNWorkspaceRoot.getSVNResourceFor(resource), descend, showOutOfDate, true);
            cmd.run(monitor);
            monitor.worked(70);
            RemoteResourceStatus[] statuses = cmd.getRemoteResourceStatuses();
            ArrayList<IResource> result = new ArrayList<IResource>(statuses.length);
            int i = 0;
            while (i < statuses.length) {
                RemoteResourceStatus status = statuses[i];
                IResource changedResource = status.getResource();
                if (changedResource != null && (this.isSupervised(changedResource) || status.getTextStatus() != SVNStatusKind.NONE)) {
                    result.add(changedResource);
                    this.remoteSyncStateStore.setBytes(changedResource, statuses[i].getBytes());
                    this.registerChangedResourceParent(changedResource);
                }
                ++i;
            }
            monitor.worked(30);
            iResourceArray = result.toArray(new IResource[result.size()]);
            Object var12_14 = null;
        }
        catch (SVNException e) {
            try {
                throw new TeamException("Error getting status for resource " + resource + " " + e.getMessage(), (Throwable)((Object)e));
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                monitor.done();
                throw throwable;
            }
        }
        monitor.done();
        return iResourceArray;
    }

    private void registerChangedResourceParent(IResource changedResource) throws TeamException {
        IContainer parent = changedResource.getParent();
        if (parent == null) {
            return;
        }
        if (this.remoteSyncStateStore.getBytes((IResource)parent) == null) {
            this.remoteSyncStateStore.setBytes((IResource)parent, DUMMY_SYNC_BYTES);
            this.registerChangedResourceParent((IResource)parent);
        }
    }

    public void resourceSyncInfoChanged(IResource[] changedResources) {
        this.internalResourceChanged(changedResources);
    }

    public void resourceModified(IResource[] changedResources) {
        this.internalResourceChanged(changedResources);
    }

    private void internalResourceChanged(IResource[] changedResources) {
        this.fireTeamResourceChange((ISubscriberChangeEvent[])SubscriberChangeEvent.asSyncChangedDeltas((Subscriber)this, (IResource[])changedResources));
    }

    public void projectConfigured(IProject project) {
        SubscriberChangeEvent delta = new SubscriberChangeEvent((Subscriber)this, 2, (IResource)project);
        this.fireTeamResourceChange((ISubscriberChangeEvent[])new SubscriberChangeEvent[]{delta});
    }

    public void projectDeconfigured(IProject project) {
        SubscriberChangeEvent delta = new SubscriberChangeEvent((Subscriber)this, 4, (IResource)project);
        this.fireTeamResourceChange((ISubscriberChangeEvent[])new SubscriberChangeEvent[]{delta});
    }

    public void updateRemote(IResource[] resources) throws TeamException {
        int i = 0;
        while (i < resources.length) {
            this.remoteSyncStateStore.flushBytes(resources[i], 2);
            ++i;
        }
    }
}

