/*
 * Decompiled with CFR 0.152.
 */
package tr.view.contexts.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import org.jdesktop.swingx.util.WindowUtils;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import tr.model.Data;
import tr.model.context.Context;
import tr.util.Observable;
import tr.view.contexts.dialog.ContextDialogPanel;

public class ContextDialog
extends JDialog {
    private Mode mode;
    private Data data;
    private ContextDialogPanel contextPanel;
    private Context context;
    private JButton okButton;
    private JButton cancelButton;

    public ContextDialog(Data data) {
        super(WindowManager.getDefault().getMainWindow(), true);
        this.data = data;
        this.construct();
    }

    private void construct() {
        this.setDefaultCloseOperation(2);
        ActionListener cancelListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ContextDialog.this.cancel();
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane rootPane = this.getRootPane();
        rootPane.registerKeyboardAction(cancelListener, stroke, 2);
        this.contextPanel = new ContextDialogPanel();
        this.contextPanel.setPreferredSize(new Dimension(700, 100));
        this.cancelButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ContextDialog.this.cancel();
            }
        });
        this.okButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"ok"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ContextDialog.this.ok();
            }
        });
        JPanel buttons = new JPanel(new FlowLayout(2, 2, 2));
        buttons.setPreferredSize(new Dimension(0, 36));
        buttons.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 36));
        buttons.add(new JLabel("   "));
        buttons.add(this.cancelButton);
        buttons.add(this.okButton);
        this.add((Component)this.contextPanel, "Center");
        this.add((Component)buttons, "South");
        this.pack();
        this.setLocation(WindowUtils.getPointForCentering((Window)this));
    }

    private void setMode(Mode mode) {
        this.mode = mode;
        if (mode == Mode.CREATE) {
            this.setTitle(NbBundle.getMessage(this.getClass(), (String)"create"));
            this.okButton.setText(NbBundle.getMessage(this.getClass(), (String)"add"));
        } else {
            this.setTitle(NbBundle.getMessage(this.getClass(), (String)"modify"));
            this.okButton.setText(NbBundle.getMessage(this.getClass(), (String)"ok"));
        }
    }

    private boolean isValid(Context context) {
        return context.getName().trim().length() != 0;
    }

    private void ok() {
        this.context.setName(this.contextPanel.getContextName());
        this.context.setDescription(this.contextPanel.getDescription());
        if (!this.isValid(this.context)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (this.mode == Mode.MODIFY) {
            this.setVisible(false);
            this.dispose();
        } else {
            this.data.getContextManager().add((Observable)this.context);
            this.context = new Context(this.data.getNextID());
            this.contextPanel.setContextName(this.context.getName());
            this.contextPanel.setDescription(this.context.getDescription());
            this.contextPanel.focus();
        }
    }

    private void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    private void showDialog() {
        this.getRootPane().setDefaultButton(this.okButton);
        this.setVisible(true);
    }

    public void showCreateDialog() {
        this.context = new Context(this.data.getNextID());
        this.contextPanel.setContextName(this.context.getName());
        this.contextPanel.setDescription(this.context.getDescription());
        this.setMode(Mode.CREATE);
        this.showDialog();
    }

    public void showModifyDialog(Context context) {
        if (context == null) {
            return;
        }
        this.context = context;
        this.contextPanel.setContextName(context.getName());
        this.contextPanel.setDescription(context.getDescription());
        this.setMode(Mode.MODIFY);
        this.showDialog();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        CREATE,
        MODIFY;

    }
}

