/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.modules.autoupdate.ui.actions.AutoupdateCheckScheduler;
import org.netbeans.modules.autoupdate.ui.wizards.LazyOperationDescriptionStep;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LazyInstallUnitWizardIterator
implements WizardDescriptor.Iterator<WizardDescriptor> {
    private int index;
    private List<WizardDescriptor.Panel<WizardDescriptor>> panels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
    private Collection<LazyUnit> installModel;
    private OperationWizardModel.OperationType doOperation;
    private boolean forceReload;

    public LazyInstallUnitWizardIterator(Collection<LazyUnit> collection, OperationWizardModel.OperationType operationType, boolean bl) {
        this.installModel = collection;
        this.doOperation = operationType;
        this.forceReload = bl;
        this.createPanels();
        this.index = 0;
    }

    private void createPanels() {
        assert (this.panels != null && this.panels.isEmpty()) : "Panels are still empty";
        this.panels.add(new LazyOperationDescriptionStep(this.installModel, this.doOperation, this.forceReload));
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        assert (this.panels != null);
        return this.panels.get(this.index);
    }

    public String name() {
        return NbBundle.getMessage(LazyInstallUnitWizardIterator.class, (String)"InstallUnitWizard_Title");
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void nextPanel() {
    }

    public void previousPanel() {
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LazyUnit {
        private String codeName;
        private String displayName;
        private String oldVersion;
        private String newVersion;
        private String notification;
        private static final String DELIMETER = "|";

        private LazyUnit(String string, String string2, String string3, String string4, String string5) {
            this.codeName = string;
            this.displayName = string2;
            this.oldVersion = string3;
            this.newVersion = string4;
            this.notification = string5;
        }

        public static void storeUpdateElements(OperationWizardModel.OperationType operationType, Collection<UpdateElement> collection) {
            Preferences preferences = LazyUnit.getPreferences(operationType);
            try {
                if (preferences.keys().length > 0) {
                    preferences.clear();
                }
            }
            catch (BackingStoreException backingStoreException) {
                Logger.getLogger(LazyInstallUnitWizardIterator.class.getName()).log(Level.WARNING, backingStoreException.getLocalizedMessage(), backingStoreException);
            }
            if (collection == null) {
                return;
            }
            for (UpdateElement updateElement : collection) {
                preferences.put(updateElement.getCodeName(), LazyUnit.toString(updateElement));
            }
        }

        public static void storeLazyUnits(OperationWizardModel.OperationType operationType, Collection<LazyUnit> collection) {
            Preferences preferences = LazyUnit.getPreferences(operationType);
            try {
                if (preferences.keys().length > 0) {
                    preferences.clear();
                }
            }
            catch (BackingStoreException backingStoreException) {
                Logger.getLogger(LazyInstallUnitWizardIterator.class.getName()).log(Level.WARNING, backingStoreException.getLocalizedMessage(), backingStoreException);
            }
            if (collection == null) {
                return;
            }
            for (LazyUnit lazyUnit : collection) {
                preferences.put(lazyUnit.getCodeName(), lazyUnit.toString());
            }
        }

        public static Collection<LazyUnit> loadLazyUnits(OperationWizardModel.OperationType operationType) {
            Preferences preferences = LazyUnit.getPreferences(operationType);
            HashSet<LazyUnit> hashSet = new HashSet<LazyUnit>();
            try {
                for (String string : preferences.keys()) {
                    hashSet.add(LazyUnit.parseLazyUnit(preferences.get(string, null)));
                }
            }
            catch (BackingStoreException backingStoreException) {
                Logger.getLogger(LazyInstallUnitWizardIterator.class.getName()).log(Level.WARNING, backingStoreException.getLocalizedMessage(), backingStoreException);
                return null;
            }
            return hashSet;
        }

        public String getCodeName() {
            return this.codeName;
        }

        public String getDisplayName() {
            return this.displayName == null ? this.codeName : this.displayName;
        }

        public String getOldVersion() {
            return this.oldVersion == null ? "" : this.oldVersion.trim();
        }

        public String getNewVersion() {
            return this.newVersion == null ? "" : this.newVersion.trim();
        }

        public String getNotification() {
            return this.notification == null ? "" : this.notification.trim();
        }

        public String toString() {
            return this.codeName + DELIMETER + (this.displayName == null ? this.codeName : this.displayName) + DELIMETER + (this.oldVersion == null ? " " : this.oldVersion) + DELIMETER + (this.newVersion == null ? " " : this.newVersion) + DELIMETER + (this.notification == null ? " " : this.notification);
        }

        public static String toString(UpdateElement updateElement) {
            return updateElement.getCodeName() + DELIMETER + (updateElement.getDisplayName() == null ? updateElement.getCodeName() : updateElement.getDisplayName()) + DELIMETER + (updateElement.getUpdateUnit().getInstalled() == null ? " " : updateElement.getUpdateUnit().getInstalled().getSpecificationVersion()) + DELIMETER + (updateElement.getSpecificationVersion() == null ? " " : updateElement.getSpecificationVersion()) + DELIMETER + (updateElement.getNotification() == null ? " " : updateElement.getNotification());
        }

        private static LazyUnit parseLazyUnit(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMETER);
            assert (5 == stringTokenizer.countTokens()) : "5 tokens for " + string;
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            String string6 = stringTokenizer.nextToken();
            return new LazyUnit(string2, string3, string4, string5, string6);
        }

        private static Preferences getPreferences(OperationWizardModel.OperationType operationType) {
            return NbPreferences.forModule(AutoupdateCheckScheduler.class).node(operationType.toString());
        }
    }
}

