/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.beans;

import ca.odell.glazedlists.ObservableElementList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanEventListConnector<E>
implements ObservableElementList.Connector<E> {
    private Method addListenerMethod = null;
    private Method removeListenerMethod = null;
    private ObservableElementList<E> list = null;
    protected PropertyChangeListener propertyChangeListener = this.createPropertyChangeListener();
    private Object[] reflectionParameters = new Object[]{this.propertyChangeListener};

    public JavaBeanEventListConnector(Class<E> beanClass) {
        Method[] methods = beanClass.getMethods();
        for (int m = 0; m < methods.length; ++m) {
            if (methods[m].getParameterTypes().length != 1 || methods[m].getParameterTypes()[0] != PropertyChangeListener.class) continue;
            if (methods[m].getName().startsWith("add")) {
                this.addListenerMethod = methods[m];
            }
            if (!methods[m].getName().startsWith("remove")) continue;
            this.removeListenerMethod = methods[m];
        }
        if (this.addListenerMethod == null || this.removeListenerMethod == null) {
            throw new IllegalArgumentException("Couldn't find listener methods for " + beanClass.getName());
        }
    }

    public JavaBeanEventListConnector(Class<E> beanClass, String addListenerMethodName, String removeListenerMethodName) {
        try {
            this.addListenerMethod = beanClass.getMethod(addListenerMethodName, PropertyChangeListener.class);
            this.removeListenerMethod = beanClass.getMethod(removeListenerMethodName, PropertyChangeListener.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Failed to find method " + e.getMessage() + " in " + beanClass);
        }
    }

    @Override
    public EventListener installListener(E element) {
        try {
            this.addListenerMethod.invoke(element, this.reflectionParameters);
            return this.propertyChangeListener;
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(ite.getCause());
        }
    }

    @Override
    public void uninstallListener(E element, EventListener listener) {
        try {
            this.removeListenerMethod.invoke(element, this.reflectionParameters);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public void setObservableElementList(ObservableElementList<E> list) {
        this.list = list;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            JavaBeanEventListConnector.this.list.elementChanged(event.getSource());
        }
    }
}

