var searchIndex = {};
searchIndex["rustc_unicode"] = {"doc":"# The Unicode Library","items":[[0,"char","rustc_unicode","A character type.",null,null],[17,"MAX","rustc_unicode::char","The highest valid code point a `char` can have.",null,null],[5,"from_u32","","Converts a `u32` to a `char`.",null,{"inputs":[{"name":"u32"}],"output":{"name":"option"}}],[5,"from_u32_unchecked","","Converts a `u32` to a `char`, ignoring validity.",null,{"inputs":[{"name":"u32"}],"output":{"name":"char"}}],[5,"from_digit","","Converts a digit in the given radix to a `char`.",null,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"option"}}],[11,"next","core::char","",0,{"inputs":[{"name":"escapeunicode"}],"output":{"name":"option"}}],[11,"size_hint","","",0,null],[11,"clone","","",0,{"inputs":[{"name":"escapeunicode"}],"output":{"name":"escapeunicode"}}],[11,"fmt","","",0,{"inputs":[{"name":"escapeunicode"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"EscapeUnicode","rustc_unicode::char","Returns an iterator that yields the hexadecimal Unicode escape of a\ncharacter, as `char`s.",null,null],[11,"next","core::char","",1,{"inputs":[{"name":"escapedefault"}],"output":{"name":"option"}}],[11,"size_hint","","",1,null],[11,"count","","",1,{"inputs":[{"name":"escapedefault"}],"output":{"name":"usize"}}],[11,"nth","","",1,{"inputs":[{"name":"escapedefault"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",1,{"inputs":[{"name":"escapedefault"}],"output":{"name":"option"}}],[11,"clone","","",1,{"inputs":[{"name":"escapedefault"}],"output":{"name":"escapedefault"}}],[11,"fmt","","",1,{"inputs":[{"name":"escapedefault"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"EscapeDefault","rustc_unicode::char","An iterator that yields the literal escape code of a `char`.",null,null],[11,"next","core::char","",2,{"inputs":[{"name":"encodeutf8"}],"output":{"name":"option"}}],[11,"size_hint","","",2,null],[11,"as_slice","","Returns the remaining bytes of this iterator as a slice.",2,null],[11,"fmt","","",2,{"inputs":[{"name":"encodeutf8"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"EncodeUtf8","rustc_unicode::char","An iterator over `u8` entries represending the UTF-8 encoding of a `char`\nvalue.",null,null],[11,"next","core::char","",3,{"inputs":[{"name":"encodeutf16"}],"output":{"name":"option"}}],[11,"size_hint","","",3,null],[11,"as_slice","","Returns the remaining bytes of this iterator as a slice.",3,null],[11,"fmt","","",3,{"inputs":[{"name":"encodeutf16"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"EncodeUtf16","rustc_unicode::char","An iterator over `u16` entries represending the UTF-16 encoding of a `char`\nvalue.",null,null],[3,"ToLowercase","","Returns an iterator that yields the lowercase equivalent of a `char`.",null,null],[3,"ToUppercase","","Returns an iterator that yields the uppercase equivalent of a `char`.",null,null],[3,"DecodeUtf16","","An iterator that decodes UTF-16 encoded code points from an iterator of `u16`s.",null,null],[3,"DecodeUtf16Error","","An iterator that decodes UTF-16 encoded code points from an iterator of `u16`s.",null,null],[5,"decode_utf16","","Create an iterator over the UTF-16 encoded code points in `iter`,\nreturning unpaired surrogates as `Err`s.",null,{"inputs":[{"name":"i"}],"output":{"name":"decodeutf16"}}],[17,"UNICODE_VERSION","","The version of [Unicode](http://www.unicode.org/)\nthat the unicode parts of `CharExt` and `UnicodeStrPrelude` traits are based on.",null,null],[17,"REPLACEMENT_CHARACTER","","`U+FFFD REPLACEMENT CHARACTER` (�) is used in Unicode to represent a\ndecoding error.",null,null],[11,"next","","",4,{"inputs":[{"name":"tolowercase"}],"output":{"name":"option"}}],[11,"next","","",5,{"inputs":[{"name":"touppercase"}],"output":{"name":"option"}}],[11,"clone","","",6,{"inputs":[{"name":"decodeutf16"}],"output":{"name":"decodeutf16"}}],[11,"eq","","",7,{"inputs":[{"name":"decodeutf16error"},{"name":"decodeutf16error"}],"output":{"name":"bool"}}],[11,"ne","","",7,{"inputs":[{"name":"decodeutf16error"},{"name":"decodeutf16error"}],"output":{"name":"bool"}}],[11,"clone","","",7,{"inputs":[{"name":"decodeutf16error"}],"output":{"name":"decodeutf16error"}}],[11,"fmt","","",7,{"inputs":[{"name":"decodeutf16error"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",6,{"inputs":[{"name":"decodeutf16"}],"output":{"name":"option"}}],[11,"size_hint","","",6,null],[11,"unpaired_surrogate","","Returns the unpaired surrogate which caused this error.",7,{"inputs":[{"name":"decodeutf16error"}],"output":{"name":"u16"}}],[11,"fmt","","",7,{"inputs":[{"name":"decodeutf16error"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"str","rustc_unicode","",null,null],[3,"SplitWhitespace","rustc_unicode::str","An iterator over the non-whitespace substrings of a string,\nseparated by any amount of whitespace.",null,null],[3,"Utf16Encoder","","Iterator adaptor for encoding `char`s to UTF-16.",null,null],[5,"utf8_char_width","","Given a first byte, determine how many bytes are in this UTF-8 character",null,{"inputs":[{"name":"u8"}],"output":{"name":"usize"}}],[5,"is_utf16","","Determines if a vector of `u16` contains valid UTF-16",null,null],[8,"UnicodeStr","","Methods for Unicode string slices",null,null],[10,"split_whitespace","","",8,{"inputs":[{"name":"unicodestr"}],"output":{"name":"splitwhitespace"}}],[10,"is_whitespace","","",8,{"inputs":[{"name":"unicodestr"}],"output":{"name":"bool"}}],[10,"is_alphanumeric","","",8,{"inputs":[{"name":"unicodestr"}],"output":{"name":"bool"}}],[10,"trim","","",8,{"inputs":[{"name":"unicodestr"}],"output":{"name":"str"}}],[10,"trim_left","","",8,{"inputs":[{"name":"unicodestr"}],"output":{"name":"str"}}],[10,"trim_right","","",8,{"inputs":[{"name":"unicodestr"}],"output":{"name":"str"}}],[0,"derived_property","rustc_unicode","",null,null],[5,"Cased","rustc_unicode::derived_property","",null,{"inputs":[{"name":"char"}],"output":{"name":"bool"}}],[5,"Case_Ignorable","","",null,{"inputs":[{"name":"char"}],"output":{"name":"bool"}}],[0,"property","rustc_unicode","",null,null],[5,"Pattern_White_Space","rustc_unicode::property","",null,{"inputs":[{"name":"char"}],"output":{"name":"bool"}}],[11,"clone","rustc_unicode::str","",9,{"inputs":[{"name":"utf16encoder"}],"output":{"name":"utf16encoder"}}],[11,"new","","Create a UTF-16 encoder from any `char` iterator.",9,{"inputs":[{"name":"i"}],"output":{"name":"utf16encoder"}}],[11,"next","","",9,{"inputs":[{"name":"utf16encoder"}],"output":{"name":"option"}}],[11,"size_hint","","",9,null],[11,"next","","",10,{"inputs":[{"name":"splitwhitespace"}],"output":{"name":"option"}}],[11,"next_back","","",10,{"inputs":[{"name":"splitwhitespace"}],"output":{"name":"option"}}]],"paths":[[3,"EscapeUnicode"],[3,"EscapeDefault"],[3,"EncodeUtf8"],[3,"EncodeUtf16"],[3,"ToLowercase"],[3,"ToUppercase"],[3,"DecodeUtf16"],[3,"DecodeUtf16Error"],[8,"UnicodeStr"],[3,"Utf16Encoder"],[3,"SplitWhitespace"]]};
searchIndex["libc"] = {"doc":"Crate docs","items":[[3,"utimbuf","libc","",null,null],[12,"actime","","",0,null],[12,"modtime","","",0,null],[3,"timeval","","",null,null],[12,"tv_sec","","",1,null],[12,"tv_usec","","",1,null],[3,"timespec","","",null,null],[12,"tv_sec","","",2,null],[12,"tv_nsec","","",2,null],[3,"rlimit","","",null,null],[12,"rlim_cur","","",3,null],[12,"rlim_max","","",3,null],[3,"rusage","","",null,null],[12,"ru_utime","","",4,null],[12,"ru_stime","","",4,null],[12,"ru_maxrss","","",4,null],[12,"ru_ixrss","","",4,null],[12,"ru_idrss","","",4,null],[12,"ru_isrss","","",4,null],[12,"ru_minflt","","",4,null],[12,"ru_majflt","","",4,null],[12,"ru_nswap","","",4,null],[12,"ru_inblock","","",4,null],[12,"ru_oublock","","",4,null],[12,"ru_msgsnd","","",4,null],[12,"ru_msgrcv","","",4,null],[12,"ru_nsignals","","",4,null],[12,"ru_nvcsw","","",4,null],[12,"ru_nivcsw","","",4,null],[3,"in_addr","","",null,null],[12,"s_addr","","",5,null],[3,"in6_addr","","",null,null],[12,"s6_addr","","",6,null],[3,"ip_mreq","","",null,null],[12,"imr_multiaddr","","",7,null],[12,"imr_interface","","",7,null],[3,"ipv6_mreq","","",null,null],[12,"ipv6mr_multiaddr","","",8,null],[12,"ipv6mr_interface","","",8,null],[3,"hostent","","",null,null],[12,"h_name","","",9,null],[12,"h_aliases","","",9,null],[12,"h_addrtype","","",9,null],[12,"h_length","","",9,null],[12,"h_addr_list","","",9,null],[3,"iovec","","",null,null],[12,"iov_base","","",10,null],[12,"iov_len","","",10,null],[3,"pollfd","","",null,null],[12,"fd","","",11,null],[12,"events","","",11,null],[12,"revents","","",11,null],[3,"winsize","","",null,null],[12,"ws_row","","",12,null],[12,"ws_col","","",12,null],[12,"ws_xpixel","","",12,null],[12,"ws_ypixel","","",12,null],[3,"sockaddr","","",null,null],[12,"sa_len","","",13,null],[12,"sa_family","","",13,null],[12,"sa_data","","",13,null],[3,"sockaddr_in6","","",null,null],[12,"sin6_len","","",14,null],[12,"sin6_family","","",14,null],[12,"sin6_port","","",14,null],[12,"sin6_flowinfo","","",14,null],[12,"sin6_addr","","",14,null],[12,"sin6_scope_id","","",14,null],[3,"sockaddr_un","","",null,null],[12,"sun_len","","",15,null],[12,"sun_family","","",15,null],[12,"sun_path","","",15,null],[3,"passwd","","",null,null],[12,"pw_name","","",16,null],[12,"pw_passwd","","",16,null],[12,"pw_uid","","",16,null],[12,"pw_gid","","",16,null],[12,"pw_change","","",16,null],[12,"pw_class","","",16,null],[12,"pw_gecos","","",16,null],[12,"pw_dir","","",16,null],[12,"pw_shell","","",16,null],[12,"pw_expire","","",16,null],[3,"ifaddrs","","",null,null],[12,"ifa_next","","",17,null],[12,"ifa_name","","",17,null],[12,"ifa_flags","","",17,null],[12,"ifa_addr","","",17,null],[12,"ifa_netmask","","",17,null],[12,"ifa_dstaddr","","",17,null],[12,"ifa_data","","",17,null],[3,"fd_set","","",null,null],[3,"tm","","",null,null],[12,"tm_sec","","",18,null],[12,"tm_min","","",18,null],[12,"tm_hour","","",18,null],[12,"tm_mday","","",18,null],[12,"tm_mon","","",18,null],[12,"tm_year","","",18,null],[12,"tm_wday","","",18,null],[12,"tm_yday","","",18,null],[12,"tm_isdst","","",18,null],[12,"tm_gmtoff","","",18,null],[12,"tm_zone","","",18,null],[3,"utsname","","",null,null],[12,"sysname","","",19,null],[12,"nodename","","",19,null],[12,"release","","",19,null],[12,"version","","",19,null],[12,"machine","","",19,null],[3,"msghdr","","",null,null],[12,"msg_name","","",20,null],[12,"msg_namelen","","",20,null],[12,"msg_iov","","",20,null],[12,"msg_iovlen","","",20,null],[12,"msg_control","","",20,null],[12,"msg_controllen","","",20,null],[12,"msg_flags","","",20,null],[3,"fsid_t","","",null,null],[3,"sigaction","","",null,null],[12,"sa_sigaction","","",21,null],[12,"sa_mask","","",21,null],[12,"sa_flags","","",21,null],[3,"stack_t","","",null,null],[12,"ss_sp","","",22,null],[12,"ss_size","","",22,null],[12,"ss_flags","","",22,null],[3,"sockaddr_in","","",null,null],[12,"sin_len","","",23,null],[12,"sin_family","","",23,null],[12,"sin_port","","",23,null],[12,"sin_addr","","",23,null],[12,"sin_zero","","",23,null],[3,"termios","","",null,null],[12,"c_iflag","","",24,null],[12,"c_oflag","","",24,null],[12,"c_cflag","","",24,null],[12,"c_lflag","","",24,null],[12,"c_cc","","",24,null],[12,"c_ispeed","","",24,null],[12,"c_ospeed","","",24,null],[3,"flock","","",null,null],[12,"l_start","","",25,null],[12,"l_len","","",25,null],[12,"l_pid","","",25,null],[12,"l_type","","",25,null],[12,"l_whence","","",25,null],[3,"dirent","","",null,null],[12,"d_fileno","","",26,null],[12,"d_off","","",26,null],[12,"d_reclen","","",26,null],[12,"d_type","","",26,null],[12,"d_namlen","","",26,null],[12,"d_name","","",26,null],[3,"glob_t","","",null,null],[12,"gl_pathc","","",27,null],[12,"gl_offs","","",27,null],[12,"gl_pathv","","",27,null],[3,"stat","","",null,null],[12,"st_mode","","",28,null],[12,"st_dev","","",28,null],[12,"st_ino","","",28,null],[12,"st_nlink","","",28,null],[12,"st_uid","","",28,null],[12,"st_gid","","",28,null],[12,"st_rdev","","",28,null],[12,"st_atime","","",28,null],[12,"st_atime_nsec","","",28,null],[12,"st_mtime","","",28,null],[12,"st_mtime_nsec","","",28,null],[12,"st_ctime","","",28,null],[12,"st_ctime_nsec","","",28,null],[12,"st_size","","",28,null],[12,"st_blocks","","",28,null],[12,"st_blksize","","",28,null],[12,"st_flags","","",28,null],[12,"st_gen","","",28,null],[12,"st_birthtime","","",28,null],[12,"st_birthtime_nsec","","",28,null],[3,"statvfs","","",null,null],[12,"f_bsize","","",29,null],[12,"f_frsize","","",29,null],[12,"f_blocks","","",29,null],[12,"f_bfree","","",29,null],[12,"f_bavail","","",29,null],[12,"f_files","","",29,null],[12,"f_ffree","","",29,null],[12,"f_favail","","",29,null],[12,"f_fsid","","",29,null],[12,"f_flag","","",29,null],[12,"f_namemax","","",29,null],[3,"addrinfo","","",null,null],[12,"ai_flags","","",30,null],[12,"ai_family","","",30,null],[12,"ai_socktype","","",30,null],[12,"ai_protocol","","",30,null],[12,"ai_addrlen","","",30,null],[12,"ai_addr","","",30,null],[12,"ai_canonname","","",30,null],[12,"ai_next","","",30,null],[3,"sockaddr_storage","","",null,null],[12,"ss_len","","",31,null],[12,"ss_family","","",31,null],[3,"siginfo_t","","",null,null],[12,"si_signo","","",32,null],[12,"si_code","","",32,null],[12,"si_errno","","",32,null],[12,"si_addr","","",32,null],[3,"Dl_info","","",null,null],[12,"dli_fname","","",33,null],[12,"dli_fbase","","",33,null],[12,"dli_sname","","",33,null],[12,"dli_saddr","","",33,null],[3,"lconv","","",null,null],[12,"decimal_point","","",34,null],[12,"thousands_sep","","",34,null],[12,"grouping","","",34,null],[12,"int_curr_symbol","","",34,null],[12,"currency_symbol","","",34,null],[12,"mon_decimal_point","","",34,null],[12,"mon_thousands_sep","","",34,null],[12,"mon_grouping","","",34,null],[12,"positive_sign","","",34,null],[12,"negative_sign","","",34,null],[12,"int_frac_digits","","",34,null],[12,"frac_digits","","",34,null],[12,"p_cs_precedes","","",34,null],[12,"p_sep_by_space","","",34,null],[12,"n_cs_precedes","","",34,null],[12,"n_sep_by_space","","",34,null],[12,"p_sign_posn","","",34,null],[12,"n_sign_posn","","",34,null],[12,"int_p_cs_precedes","","",34,null],[12,"int_p_sep_by_space","","",34,null],[12,"int_n_cs_precedes","","",34,null],[12,"int_n_sep_by_space","","",34,null],[12,"int_p_sign_posn","","",34,null],[12,"int_n_sign_posn","","",34,null],[4,"c_void","","",null,null],[4,"FILE","","",null,null],[4,"fpos_t","","",null,null],[4,"DIR","","",null,null],[4,"timezone","","",null,null],[5,"FD_CLR","","",null,null],[5,"FD_ISSET","","",null,null],[5,"FD_SET","","",null,null],[5,"FD_ZERO","","",null,null],[5,"WIFEXITED","","",null,{"inputs":[{"name":"c_int"}],"output":{"name":"bool"}}],[5,"WEXITSTATUS","","",null,{"inputs":[{"name":"c_int"}],"output":{"name":"c_int"}}],[5,"WTERMSIG","","",null,{"inputs":[{"name":"c_int"}],"output":{"name":"c_int"}}],[5,"isalnum","","",null,null],[5,"isalpha","","",null,null],[5,"iscntrl","","",null,null],[5,"isdigit","","",null,null],[5,"isgraph","","",null,null],[5,"islower","","",null,null],[5,"isprint","","",null,null],[5,"ispunct","","",null,null],[5,"isspace","","",null,null],[5,"isupper","","",null,null],[5,"isxdigit","","",null,null],[5,"tolower","","",null,null],[5,"toupper","","",null,null],[5,"fopen","","",null,null],[5,"freopen","","",null,null],[5,"fflush","","",null,null],[5,"fclose","","",null,null],[5,"remove","","",null,null],[5,"rename","","",null,null],[5,"tmpfile","","",null,null],[5,"setvbuf","","",null,null],[5,"setbuf","","",null,null],[5,"fgetc","","",null,null],[5,"fgets","","",null,null],[5,"fputc","","",null,null],[5,"fputs","","",null,null],[5,"puts","","",null,null],[5,"ungetc","","",null,null],[5,"fread","","",null,null],[5,"fwrite","","",null,null],[5,"fseek","","",null,null],[5,"ftell","","",null,null],[5,"rewind","","",null,null],[5,"fgetpos","","",null,null],[5,"fsetpos","","",null,null],[5,"feof","","",null,null],[5,"ferror","","",null,null],[5,"perror","","",null,null],[5,"atoi","","",null,null],[5,"strtod","","",null,null],[5,"strtol","","",null,null],[5,"strtoul","","",null,null],[5,"calloc","","",null,null],[5,"malloc","","",null,null],[5,"realloc","","",null,null],[5,"free","","",null,null],[5,"abort","","",null,null],[5,"exit","","",null,null],[5,"_exit","","",null,null],[5,"atexit","","",null,null],[5,"system","","",null,null],[5,"getenv","","",null,null],[5,"strcpy","","",null,null],[5,"strncpy","","",null,null],[5,"strcat","","",null,null],[5,"strncat","","",null,null],[5,"strcmp","","",null,null],[5,"strncmp","","",null,null],[5,"strcoll","","",null,null],[5,"strchr","","",null,null],[5,"strrchr","","",null,null],[5,"strspn","","",null,null],[5,"strcspn","","",null,null],[5,"strpbrk","","",null,null],[5,"strstr","","",null,null],[5,"strlen","","",null,null],[5,"strerror","","",null,null],[5,"strtok","","",null,null],[5,"strxfrm","","",null,null],[5,"wcslen","","",null,null],[5,"memcmp","","",null,null],[5,"memchr","","",null,null],[5,"abs","","",null,null],[5,"atof","","",null,null],[5,"labs","","",null,null],[5,"rand","","",null,null],[5,"srand","","",null,null],[5,"socket","","",null,null],[5,"connect","","",null,null],[5,"bind","","",null,null],[5,"listen","","",null,null],[5,"accept","","",null,null],[5,"getpeername","","",null,null],[5,"getsockname","","",null,null],[5,"setsockopt","","",null,null],[5,"socketpair","","",null,null],[5,"sendto","","",null,null],[5,"shutdown","","",null,null],[5,"chmod","","",null,null],[5,"fchmod","","",null,null],[5,"fstat","","",null,null],[5,"mkdir","","",null,null],[5,"stat","","",null,null],[5,"popen","","",null,null],[5,"pclose","","",null,null],[5,"fdopen","","",null,null],[5,"fileno","","",null,null],[5,"open","","",null,null],[5,"creat","","",null,null],[5,"fcntl","","",null,null],[5,"opendir","","",null,null],[5,"readdir_r","","",null,null],[5,"closedir","","",null,null],[5,"rewinddir","","",null,null],[5,"access","","",null,null],[5,"alarm","","",null,null],[5,"chdir","","",null,null],[5,"chown","","",null,null],[5,"close","","",null,null],[5,"dup","","",null,null],[5,"dup2","","",null,null],[5,"execv","","",null,null],[5,"execve","","",null,null],[5,"execvp","","",null,null],[5,"fork","","",null,null],[5,"fpathconf","","",null,null],[5,"getcwd","","",null,null],[5,"getegid","","",null,null],[5,"geteuid","","",null,null],[5,"getgid","","",null,null],[5,"getgroups","","",null,null],[5,"getlogin","","",null,null],[5,"getopt","","",null,null],[5,"getpgrp","","",null,null],[5,"getpid","","",null,null],[5,"getppid","","",null,null],[5,"getuid","","",null,null],[5,"isatty","","",null,null],[5,"link","","",null,null],[5,"lseek","","",null,null],[5,"pathconf","","",null,null],[5,"pause","","",null,null],[5,"pipe","","",null,null],[5,"posix_memalign","","",null,null],[5,"read","","",null,null],[5,"rmdir","","",null,null],[5,"setgid","","",null,null],[5,"setpgid","","",null,null],[5,"setsid","","",null,null],[5,"setuid","","",null,null],[5,"sleep","","",null,null],[5,"nanosleep","","",null,null],[5,"tcgetpgrp","","",null,null],[5,"ttyname","","",null,null],[5,"unlink","","",null,null],[5,"wait","","",null,null],[5,"waitpid","","",null,null],[5,"write","","",null,null],[5,"pread","","",null,null],[5,"pwrite","","",null,null],[5,"umask","","",null,null],[5,"utime","","",null,null],[5,"kill","","",null,null],[5,"mlock","","",null,null],[5,"munlock","","",null,null],[5,"mlockall","","",null,null],[5,"munlockall","","",null,null],[5,"mmap","","",null,null],[5,"munmap","","",null,null],[5,"if_nametoindex","","",null,null],[5,"if_indextoname","","",null,null],[5,"lstat","","",null,null],[5,"fsync","","",null,null],[5,"setenv","","",null,null],[5,"unsetenv","","",null,null],[5,"symlink","","",null,null],[5,"ftruncate","","",null,null],[5,"signal","","",null,null],[5,"getrlimit","","",null,null],[5,"setrlimit","","",null,null],[5,"getrusage","","",null,null],[5,"getdtablesize","","",null,null],[5,"realpath","","",null,null],[5,"flock","","",null,null],[5,"gettimeofday","","",null,null],[5,"pthread_self","","",null,null],[5,"pthread_create","","",null,null],[5,"pthread_join","","",null,null],[5,"pthread_attr_init","","",null,null],[5,"pthread_attr_destroy","","",null,null],[5,"pthread_attr_setstacksize","","",null,null],[5,"pthread_attr_setdetachstate","","",null,null],[5,"pthread_detach","","",null,null],[5,"sched_yield","","",null,null],[5,"pthread_key_create","","",null,null],[5,"pthread_key_delete","","",null,null],[5,"pthread_getspecific","","",null,null],[5,"pthread_setspecific","","",null,null],[5,"pthread_mutex_init","","",null,null],[5,"pthread_mutex_destroy","","",null,null],[5,"pthread_mutex_lock","","",null,null],[5,"pthread_mutex_trylock","","",null,null],[5,"pthread_mutex_unlock","","",null,null],[5,"pthread_mutexattr_init","","",null,null],[5,"pthread_mutexattr_destroy","","",null,null],[5,"pthread_mutexattr_settype","","",null,null],[5,"pthread_cond_wait","","",null,null],[5,"pthread_cond_timedwait","","",null,null],[5,"pthread_cond_signal","","",null,null],[5,"pthread_cond_broadcast","","",null,null],[5,"pthread_cond_destroy","","",null,null],[5,"pthread_rwlock_destroy","","",null,null],[5,"pthread_rwlock_rdlock","","",null,null],[5,"pthread_rwlock_tryrdlock","","",null,null],[5,"pthread_rwlock_wrlock","","",null,null],[5,"pthread_rwlock_trywrlock","","",null,null],[5,"pthread_rwlock_unlock","","",null,null],[5,"pthread_sigmask","","",null,null],[5,"pthread_kill","","",null,null],[5,"strerror_r","","",null,null],[5,"getsockopt","","",null,null],[5,"raise","","",null,null],[5,"sigaction","","",null,null],[5,"sigaltstack","","",null,null],[5,"sigwait","","",null,null],[5,"utimes","","",null,null],[5,"dlopen","","",null,null],[5,"dlerror","","",null,null],[5,"dlsym","","",null,null],[5,"dlclose","","",null,null],[5,"dladdr","","",null,null],[5,"getaddrinfo","","",null,null],[5,"freeaddrinfo","","",null,null],[5,"gai_strerror","","",null,null],[5,"gmtime_r","","",null,null],[5,"localtime_r","","",null,null],[5,"mktime","","",null,null],[5,"mknod","","",null,null],[5,"writev","","",null,null],[5,"readv","","",null,null],[5,"uname","","",null,null],[5,"daemon","","",null,null],[5,"gethostname","","",null,null],[5,"chroot","","",null,null],[5,"usleep","","",null,null],[5,"send","","",null,null],[5,"recv","","",null,null],[5,"putenv","","",null,null],[5,"sendmsg","","",null,null],[5,"recvmsg","","",null,null],[5,"poll","","",null,null],[5,"select","","",null,null],[5,"setlocale","","",null,null],[5,"localeconv","","",null,null],[5,"getifaddrs","","",null,null],[5,"freeifaddrs","","",null,null],[5,"glob","","",null,null],[5,"globfree","","",null,null],[5,"posix_madvise","","",null,null],[5,"shm_unlink","","",null,null],[5,"seekdir","","",null,null],[5,"telldir","","",null,null],[5,"getsid","","",null,null],[5,"madvise","","",null,null],[5,"readlink","","",null,null],[5,"msync","","",null,null],[5,"sysconf","","",null,null],[5,"recvfrom","","",null,null],[5,"mkfifo","","",null,null],[5,"sigemptyset","","",null,null],[5,"sigaddset","","",null,null],[5,"sigfillset","","",null,null],[5,"sigdelset","","",null,null],[5,"sigismember","","",null,null],[5,"pselect","","",null,null],[5,"fseeko","","",null,null],[5,"ftello","","",null,null],[5,"timegm","","",null,null],[5,"statvfs","","",null,null],[5,"fstatvfs","","",null,null],[5,"tcdrain","","",null,null],[5,"cfgetispeed","","",null,null],[5,"cfgetospeed","","",null,null],[5,"cfsetispeed","","",null,null],[5,"cfsetospeed","","",null,null],[5,"tcgetattr","","",null,null],[5,"tcsetattr","","",null,null],[5,"tcflow","","",null,null],[5,"tcflush","","",null,null],[5,"tcsendbreak","","",null,null],[5,"mkstemp","","",null,null],[5,"mkstemps","","",null,null],[5,"mkdtemp","","",null,null],[5,"futimes","","",null,null],[5,"setgroups","","",null,null],[5,"ioctl","","",null,null],[5,"kqueue","","",null,null],[5,"unmount","","",null,null],[5,"syscall","","",null,null],[5,"getpwuid_r","","",null,null],[5,"mincore","","",null,null],[5,"clock_getres","","",null,null],[5,"clock_gettime","","",null,null],[5,"__errno","","",null,null],[5,"shm_open","","",null,null],[5,"memrchr","","",null,null],[5,"mkostemp","","",null,null],[5,"mkostemps","","",null,null],[5,"futimens","","",null,null],[5,"fdatasync","","",null,null],[5,"openpty","","",null,null],[5,"forkpty","","",null,null],[5,"getnameinfo","","",null,null],[5,"mprotect","","",null,null],[5,"pthread_main_np","","",null,null],[5,"pthread_set_name_np","","",null,null],[5,"pthread_stackseg_np","","",null,null],[5,"sysctl","","",null,null],[5,"getentropy","","",null,null],[6,"int8_t","","",null,null],[6,"int16_t","","",null,null],[6,"int32_t","","",null,null],[6,"int64_t","","",null,null],[6,"uint8_t","","",null,null],[6,"uint16_t","","",null,null],[6,"uint32_t","","",null,null],[6,"uint64_t","","",null,null],[6,"c_schar","","",null,null],[6,"c_uchar","","",null,null],[6,"c_short","","",null,null],[6,"c_ushort","","",null,null],[6,"c_int","","",null,null],[6,"c_uint","","",null,null],[6,"c_float","","",null,null],[6,"c_double","","",null,null],[6,"c_longlong","","",null,null],[6,"c_ulonglong","","",null,null],[6,"intmax_t","","",null,null],[6,"uintmax_t","","",null,null],[6,"size_t","","",null,null],[6,"ptrdiff_t","","",null,null],[6,"intptr_t","","",null,null],[6,"uintptr_t","","",null,null],[6,"ssize_t","","",null,null],[6,"pid_t","","",null,null],[6,"uid_t","","",null,null],[6,"gid_t","","",null,null],[6,"in_addr_t","","",null,null],[6,"in_port_t","","",null,null],[6,"sighandler_t","","",null,null],[6,"cc_t","","",null,null],[6,"c_char","","",null,null],[6,"wchar_t","","",null,null],[6,"off_t","","",null,null],[6,"useconds_t","","",null,null],[6,"blkcnt_t","","",null,null],[6,"socklen_t","","",null,null],[6,"sa_family_t","","",null,null],[6,"pthread_t","","",null,null],[6,"nfds_t","","",null,null],[6,"c_long","","",null,null],[6,"c_ulong","","",null,null],[6,"time_t","","",null,null],[6,"mode_t","","",null,null],[6,"nlink_t","","",null,null],[6,"ino_t","","",null,null],[6,"pthread_key_t","","",null,null],[6,"rlim_t","","",null,null],[6,"speed_t","","",null,null],[6,"tcflag_t","","",null,null],[6,"clockid_t","","",null,null],[6,"clock_t","","",null,null],[6,"suseconds_t","","",null,null],[6,"dev_t","","",null,null],[6,"sigset_t","","",null,null],[6,"blksize_t","","",null,null],[6,"fsblkcnt_t","","",null,null],[6,"fsfilcnt_t","","",null,null],[6,"pthread_attr_t","","",null,null],[6,"pthread_mutex_t","","",null,null],[6,"pthread_mutexattr_t","","",null,null],[6,"pthread_cond_t","","",null,null],[6,"pthread_rwlock_t","","",null,null],[17,"SIG_DFL","","",null,null],[17,"SIG_IGN","","",null,null],[17,"SIG_ERR","","",null,null],[17,"DT_FIFO","","",null,null],[17,"DT_CHR","","",null,null],[17,"DT_DIR","","",null,null],[17,"DT_BLK","","",null,null],[17,"DT_REG","","",null,null],[17,"DT_LNK","","",null,null],[17,"DT_SOCK","","",null,null],[17,"FD_CLOEXEC","","",null,null],[17,"USRQUOTA","","",null,null],[17,"GRPQUOTA","","",null,null],[17,"SIGIOT","","",null,null],[17,"S_ISUID","","",null,null],[17,"S_ISGID","","",null,null],[17,"S_ISVTX","","",null,null],[17,"POLLIN","","",null,null],[17,"POLLPRI","","",null,null],[17,"POLLOUT","","",null,null],[17,"POLLERR","","",null,null],[17,"POLLHUP","","",null,null],[17,"POLLNVAL","","",null,null],[17,"IF_NAMESIZE","","",null,null],[17,"RTLD_LAZY","","",null,null],[17,"LC_ALL","","",null,null],[17,"LC_COLLATE","","",null,null],[17,"LC_CTYPE","","",null,null],[17,"LC_MONETARY","","",null,null],[17,"LC_NUMERIC","","",null,null],[17,"LC_TIME","","",null,null],[17,"LC_MESSAGES","","",null,null],[17,"FIOCLEX","","",null,null],[17,"FIONBIO","","",null,null],[17,"PATH_MAX","","",null,null],[17,"SA_ONSTACK","","",null,null],[17,"SA_SIGINFO","","",null,null],[17,"SA_RESTART","","",null,null],[17,"SA_RESETHAND","","",null,null],[17,"SA_NOCLDSTOP","","",null,null],[17,"SA_NODEFER","","",null,null],[17,"SA_NOCLDWAIT","","",null,null],[17,"SS_ONSTACK","","",null,null],[17,"SS_DISABLE","","",null,null],[17,"SIGCHLD","","",null,null],[17,"SIGBUS","","",null,null],[17,"SIGUSR1","","",null,null],[17,"SIGUSR2","","",null,null],[17,"SIGCONT","","",null,null],[17,"SIGSTOP","","",null,null],[17,"SIGTSTP","","",null,null],[17,"SIGURG","","",null,null],[17,"SIGIO","","",null,null],[17,"SIGSYS","","",null,null],[17,"SIGTTIN","","",null,null],[17,"SIGTTOU","","",null,null],[17,"SIGXCPU","","",null,null],[17,"SIGXFSZ","","",null,null],[17,"SIGVTALRM","","",null,null],[17,"SIGPROF","","",null,null],[17,"SIGWINCH","","",null,null],[17,"SIG_SETMASK","","",null,null],[17,"SIG_BLOCK","","",null,null],[17,"SIG_UNBLOCK","","",null,null],[17,"IPV6_MULTICAST_LOOP","","",null,null],[17,"IPV6_V6ONLY","","",null,null],[17,"ST_RDONLY","","",null,null],[17,"CTL_HW","","",null,null],[17,"HW_NCPU","","",null,null],[17,"EV_ADD","","",null,null],[17,"EV_CLEAR","","",null,null],[17,"EV_DELETE","","",null,null],[17,"EV_DISABLE","","",null,null],[17,"EV_ENABLE","","",null,null],[17,"EV_EOF","","",null,null],[17,"EV_ERROR","","",null,null],[17,"EV_FLAG1","","",null,null],[17,"EV_ONESHOT","","",null,null],[17,"EV_SYSFLAGS","","",null,null],[17,"NOTE_ATTRIB","","",null,null],[17,"NOTE_CHILD","","",null,null],[17,"NOTE_DELETE","","",null,null],[17,"NOTE_EXEC","","",null,null],[17,"NOTE_EXIT","","",null,null],[17,"NOTE_EXTEND","","",null,null],[17,"NOTE_FORK","","",null,null],[17,"NOTE_LINK","","",null,null],[17,"NOTE_LOWAT","","",null,null],[17,"NOTE_PDATAMASK","","",null,null],[17,"NOTE_RENAME","","",null,null],[17,"NOTE_REVOKE","","",null,null],[17,"NOTE_TRACK","","",null,null],[17,"NOTE_TRACKERR","","",null,null],[17,"NOTE_WRITE","","",null,null],[17,"NCCS","","",null,null],[17,"O_ASYNC","","",null,null],[17,"O_FSYNC","","",null,null],[17,"O_NDELAY","","",null,null],[17,"O_NOFOLLOW","","",null,null],[17,"F_GETOWN","","",null,null],[17,"F_SETOWN","","",null,null],[17,"MNT_FORCE","","",null,null],[17,"Q_SYNC","","",null,null],[17,"Q_QUOTAON","","",null,null],[17,"Q_QUOTAOFF","","",null,null],[17,"TCIOFF","","",null,null],[17,"TCION","","",null,null],[17,"TCOOFF","","",null,null],[17,"TCOON","","",null,null],[17,"TCIFLUSH","","",null,null],[17,"TCOFLUSH","","",null,null],[17,"TCIOFLUSH","","",null,null],[17,"TCSANOW","","",null,null],[17,"TCSADRAIN","","",null,null],[17,"TCSAFLUSH","","",null,null],[17,"VEOF","","",null,null],[17,"VEOL","","",null,null],[17,"VEOL2","","",null,null],[17,"VERASE","","",null,null],[17,"VWERASE","","",null,null],[17,"VKILL","","",null,null],[17,"VREPRINT","","",null,null],[17,"VINTR","","",null,null],[17,"VQUIT","","",null,null],[17,"VSUSP","","",null,null],[17,"VSTART","","",null,null],[17,"VSTOP","","",null,null],[17,"VLNEXT","","",null,null],[17,"VDISCARD","","",null,null],[17,"VMIN","","",null,null],[17,"VTIME","","",null,null],[17,"IGNBRK","","",null,null],[17,"BRKINT","","",null,null],[17,"IGNPAR","","",null,null],[17,"PARMRK","","",null,null],[17,"INPCK","","",null,null],[17,"ISTRIP","","",null,null],[17,"INLCR","","",null,null],[17,"IGNCR","","",null,null],[17,"ICRNL","","",null,null],[17,"IXON","","",null,null],[17,"IXOFF","","",null,null],[17,"IXANY","","",null,null],[17,"IMAXBEL","","",null,null],[17,"OPOST","","",null,null],[17,"ONLCR","","",null,null],[17,"CSIZE","","",null,null],[17,"CS5","","",null,null],[17,"CS6","","",null,null],[17,"CS7","","",null,null],[17,"CS8","","",null,null],[17,"CSTOPB","","",null,null],[17,"CREAD","","",null,null],[17,"PARENB","","",null,null],[17,"PARODD","","",null,null],[17,"HUPCL","","",null,null],[17,"CLOCAL","","",null,null],[17,"ECHOKE","","",null,null],[17,"ECHOE","","",null,null],[17,"ECHOK","","",null,null],[17,"ECHO","","",null,null],[17,"ECHONL","","",null,null],[17,"ECHOPRT","","",null,null],[17,"ECHOCTL","","",null,null],[17,"ISIG","","",null,null],[17,"ICANON","","",null,null],[17,"IEXTEN","","",null,null],[17,"EXTPROC","","",null,null],[17,"TOSTOP","","",null,null],[17,"FLUSHO","","",null,null],[17,"PENDIN","","",null,null],[17,"NOFLSH","","",null,null],[17,"WNOHANG","","",null,null],[17,"RTLD_NOW","","",null,null],[17,"RTLD_DEFAULT","","",null,null],[17,"EXIT_FAILURE","","",null,null],[17,"EXIT_SUCCESS","","",null,null],[17,"RAND_MAX","","",null,null],[17,"EOF","","",null,null],[17,"SEEK_SET","","",null,null],[17,"SEEK_CUR","","",null,null],[17,"SEEK_END","","",null,null],[17,"_IOFBF","","",null,null],[17,"_IONBF","","",null,null],[17,"_IOLBF","","",null,null],[17,"BUFSIZ","","",null,null],[17,"FOPEN_MAX","","",null,null],[17,"FILENAME_MAX","","",null,null],[17,"L_tmpnam","","",null,null],[17,"O_RDONLY","","",null,null],[17,"O_WRONLY","","",null,null],[17,"O_RDWR","","",null,null],[17,"O_ACCMODE","","",null,null],[17,"O_APPEND","","",null,null],[17,"O_CREAT","","",null,null],[17,"O_EXCL","","",null,null],[17,"O_NOCTTY","","",null,null],[17,"O_TRUNC","","",null,null],[17,"O_SYNC","","",null,null],[17,"S_IFIFO","","",null,null],[17,"S_IFCHR","","",null,null],[17,"S_IFBLK","","",null,null],[17,"S_IFDIR","","",null,null],[17,"S_IFREG","","",null,null],[17,"S_IFLNK","","",null,null],[17,"S_IFSOCK","","",null,null],[17,"S_IFMT","","",null,null],[17,"S_IEXEC","","",null,null],[17,"S_IWRITE","","",null,null],[17,"S_IREAD","","",null,null],[17,"S_IRWXU","","",null,null],[17,"S_IXUSR","","",null,null],[17,"S_IWUSR","","",null,null],[17,"S_IRUSR","","",null,null],[17,"S_IRWXG","","",null,null],[17,"S_IXGRP","","",null,null],[17,"S_IWGRP","","",null,null],[17,"S_IRGRP","","",null,null],[17,"S_IRWXO","","",null,null],[17,"S_IXOTH","","",null,null],[17,"S_IWOTH","","",null,null],[17,"S_IROTH","","",null,null],[17,"F_OK","","",null,null],[17,"R_OK","","",null,null],[17,"W_OK","","",null,null],[17,"X_OK","","",null,null],[17,"STDIN_FILENO","","",null,null],[17,"STDOUT_FILENO","","",null,null],[17,"STDERR_FILENO","","",null,null],[17,"F_LOCK","","",null,null],[17,"F_TEST","","",null,null],[17,"F_TLOCK","","",null,null],[17,"F_ULOCK","","",null,null],[17,"F_GETLK","","",null,null],[17,"F_SETLK","","",null,null],[17,"F_SETLKW","","",null,null],[17,"SIGHUP","","",null,null],[17,"SIGINT","","",null,null],[17,"SIGQUIT","","",null,null],[17,"SIGILL","","",null,null],[17,"SIGABRT","","",null,null],[17,"SIGFPE","","",null,null],[17,"SIGKILL","","",null,null],[17,"SIGSEGV","","",null,null],[17,"SIGPIPE","","",null,null],[17,"SIGALRM","","",null,null],[17,"SIGTERM","","",null,null],[17,"SIGSTKSZ","","",null,null],[17,"PROT_NONE","","",null,null],[17,"PROT_READ","","",null,null],[17,"PROT_WRITE","","",null,null],[17,"PROT_EXEC","","",null,null],[17,"MAP_FILE","","",null,null],[17,"MAP_SHARED","","",null,null],[17,"MAP_PRIVATE","","",null,null],[17,"MAP_FIXED","","",null,null],[17,"MAP_ANON","","",null,null],[17,"MAP_FAILED","","",null,null],[17,"MCL_CURRENT","","",null,null],[17,"MCL_FUTURE","","",null,null],[17,"MS_ASYNC","","",null,null],[17,"EPERM","","",null,null],[17,"ENOENT","","",null,null],[17,"ESRCH","","",null,null],[17,"EINTR","","",null,null],[17,"EIO","","",null,null],[17,"ENXIO","","",null,null],[17,"E2BIG","","",null,null],[17,"ENOEXEC","","",null,null],[17,"EBADF","","",null,null],[17,"ECHILD","","",null,null],[17,"EDEADLK","","",null,null],[17,"ENOMEM","","",null,null],[17,"EACCES","","",null,null],[17,"EFAULT","","",null,null],[17,"ENOTBLK","","",null,null],[17,"EBUSY","","",null,null],[17,"EEXIST","","",null,null],[17,"EXDEV","","",null,null],[17,"ENODEV","","",null,null],[17,"ENOTDIR","","",null,null],[17,"EISDIR","","",null,null],[17,"EINVAL","","",null,null],[17,"ENFILE","","",null,null],[17,"EMFILE","","",null,null],[17,"ENOTTY","","",null,null],[17,"ETXTBSY","","",null,null],[17,"EFBIG","","",null,null],[17,"ENOSPC","","",null,null],[17,"ESPIPE","","",null,null],[17,"EROFS","","",null,null],[17,"EMLINK","","",null,null],[17,"EPIPE","","",null,null],[17,"EDOM","","",null,null],[17,"ERANGE","","",null,null],[17,"EAGAIN","","",null,null],[17,"EWOULDBLOCK","","",null,null],[17,"EINPROGRESS","","",null,null],[17,"EALREADY","","",null,null],[17,"ENOTSOCK","","",null,null],[17,"EDESTADDRREQ","","",null,null],[17,"EMSGSIZE","","",null,null],[17,"EPROTOTYPE","","",null,null],[17,"ENOPROTOOPT","","",null,null],[17,"EPROTONOSUPPORT","","",null,null],[17,"ESOCKTNOSUPPORT","","",null,null],[17,"EOPNOTSUPP","","",null,null],[17,"EPFNOSUPPORT","","",null,null],[17,"EAFNOSUPPORT","","",null,null],[17,"EADDRINUSE","","",null,null],[17,"EADDRNOTAVAIL","","",null,null],[17,"ENETDOWN","","",null,null],[17,"ENETUNREACH","","",null,null],[17,"ENETRESET","","",null,null],[17,"ECONNABORTED","","",null,null],[17,"ECONNRESET","","",null,null],[17,"ENOBUFS","","",null,null],[17,"EISCONN","","",null,null],[17,"ENOTCONN","","",null,null],[17,"ESHUTDOWN","","",null,null],[17,"ETOOMANYREFS","","",null,null],[17,"ETIMEDOUT","","",null,null],[17,"ECONNREFUSED","","",null,null],[17,"ELOOP","","",null,null],[17,"ENAMETOOLONG","","",null,null],[17,"EHOSTDOWN","","",null,null],[17,"EHOSTUNREACH","","",null,null],[17,"ENOTEMPTY","","",null,null],[17,"EPROCLIM","","",null,null],[17,"EUSERS","","",null,null],[17,"EDQUOT","","",null,null],[17,"ESTALE","","",null,null],[17,"EREMOTE","","",null,null],[17,"EBADRPC","","",null,null],[17,"ERPCMISMATCH","","",null,null],[17,"EPROGUNAVAIL","","",null,null],[17,"EPROGMISMATCH","","",null,null],[17,"EPROCUNAVAIL","","",null,null],[17,"ENOLCK","","",null,null],[17,"ENOSYS","","",null,null],[17,"EFTYPE","","",null,null],[17,"EAUTH","","",null,null],[17,"ENEEDAUTH","","",null,null],[17,"F_DUPFD","","",null,null],[17,"F_GETFD","","",null,null],[17,"F_SETFD","","",null,null],[17,"F_GETFL","","",null,null],[17,"F_SETFL","","",null,null],[17,"SIGTRAP","","",null,null],[17,"GLOB_APPEND","","",null,null],[17,"GLOB_DOOFFS","","",null,null],[17,"GLOB_ERR","","",null,null],[17,"GLOB_MARK","","",null,null],[17,"GLOB_NOCHECK","","",null,null],[17,"GLOB_NOSORT","","",null,null],[17,"GLOB_NOESCAPE","","",null,null],[17,"GLOB_NOSPACE","","",null,null],[17,"GLOB_ABORTED","","",null,null],[17,"GLOB_NOMATCH","","",null,null],[17,"GLOB_NOSYS","","",null,null],[17,"POSIX_MADV_NORMAL","","",null,null],[17,"POSIX_MADV_RANDOM","","",null,null],[17,"POSIX_MADV_SEQUENTIAL","","",null,null],[17,"POSIX_MADV_WILLNEED","","",null,null],[17,"POSIX_MADV_DONTNEED","","",null,null],[17,"_SC_XOPEN_SHM","","",null,null],[17,"PTHREAD_CREATE_JOINABLE","","",null,null],[17,"PTHREAD_CREATE_DETACHED","","",null,null],[17,"CLOCK_REALTIME","","",null,null],[17,"CLOCK_MONOTONIC","","",null,null],[17,"RLIMIT_CPU","","",null,null],[17,"RLIMIT_FSIZE","","",null,null],[17,"RLIMIT_DATA","","",null,null],[17,"RLIMIT_STACK","","",null,null],[17,"RLIMIT_CORE","","",null,null],[17,"RLIMIT_RSS","","",null,null],[17,"RLIMIT_MEMLOCK","","",null,null],[17,"RLIMIT_NPROC","","",null,null],[17,"RLIMIT_NOFILE","","",null,null],[17,"RLIM_INFINITY","","",null,null],[17,"RLIM_SAVED_MAX","","",null,null],[17,"RLIM_SAVED_CUR","","",null,null],[17,"RUSAGE_SELF","","",null,null],[17,"RUSAGE_CHILDREN","","",null,null],[17,"MADV_NORMAL","","",null,null],[17,"MADV_RANDOM","","",null,null],[17,"MADV_SEQUENTIAL","","",null,null],[17,"MADV_WILLNEED","","",null,null],[17,"MADV_DONTNEED","","",null,null],[17,"MADV_FREE","","",null,null],[17,"AF_UNIX","","",null,null],[17,"AF_INET","","",null,null],[17,"AF_INET6","","",null,null],[17,"SOCK_STREAM","","",null,null],[17,"SOCK_DGRAM","","",null,null],[17,"SOCK_RAW","","",null,null],[17,"IPPROTO_TCP","","",null,null],[17,"IPPROTO_IP","","",null,null],[17,"IPPROTO_IPV6","","",null,null],[17,"IP_MULTICAST_TTL","","",null,null],[17,"IP_MULTICAST_LOOP","","",null,null],[17,"IP_TTL","","",null,null],[17,"IP_HDRINCL","","",null,null],[17,"IP_ADD_MEMBERSHIP","","",null,null],[17,"IP_DROP_MEMBERSHIP","","",null,null],[17,"TCP_NODELAY","","",null,null],[17,"SOL_SOCKET","","",null,null],[17,"SO_DEBUG","","",null,null],[17,"SO_ACCEPTCONN","","",null,null],[17,"SO_REUSEADDR","","",null,null],[17,"SO_KEEPALIVE","","",null,null],[17,"SO_DONTROUTE","","",null,null],[17,"SO_BROADCAST","","",null,null],[17,"SO_USELOOPBACK","","",null,null],[17,"SO_LINGER","","",null,null],[17,"SO_OOBINLINE","","",null,null],[17,"SO_REUSEPORT","","",null,null],[17,"SO_SNDBUF","","",null,null],[17,"SO_RCVBUF","","",null,null],[17,"SO_SNDLOWAT","","",null,null],[17,"SO_RCVLOWAT","","",null,null],[17,"SO_ERROR","","",null,null],[17,"SO_TYPE","","",null,null],[17,"IFF_LOOPBACK","","",null,null],[17,"SHUT_RD","","",null,null],[17,"SHUT_WR","","",null,null],[17,"SHUT_RDWR","","",null,null],[17,"LOCK_SH","","",null,null],[17,"LOCK_EX","","",null,null],[17,"LOCK_NB","","",null,null],[17,"LOCK_UN","","",null,null],[17,"O_NONBLOCK","","",null,null],[17,"CTL_KERN","","",null,null],[17,"IPPROTO_RAW","","",null,null],[17,"_SC_ARG_MAX","","",null,null],[17,"_SC_CHILD_MAX","","",null,null],[17,"_SC_NGROUPS_MAX","","",null,null],[17,"_SC_OPEN_MAX","","",null,null],[17,"_SC_JOB_CONTROL","","",null,null],[17,"_SC_SAVED_IDS","","",null,null],[17,"_SC_VERSION","","",null,null],[17,"_SC_BC_BASE_MAX","","",null,null],[17,"_SC_BC_DIM_MAX","","",null,null],[17,"_SC_BC_SCALE_MAX","","",null,null],[17,"_SC_BC_STRING_MAX","","",null,null],[17,"_SC_COLL_WEIGHTS_MAX","","",null,null],[17,"_SC_EXPR_NEST_MAX","","",null,null],[17,"_SC_LINE_MAX","","",null,null],[17,"_SC_RE_DUP_MAX","","",null,null],[17,"_SC_2_VERSION","","",null,null],[17,"_SC_2_C_BIND","","",null,null],[17,"_SC_2_C_DEV","","",null,null],[17,"_SC_2_CHAR_TERM","","",null,null],[17,"_SC_2_FORT_DEV","","",null,null],[17,"_SC_2_FORT_RUN","","",null,null],[17,"_SC_2_LOCALEDEF","","",null,null],[17,"_SC_2_SW_DEV","","",null,null],[17,"_SC_2_UPE","","",null,null],[17,"_SC_STREAM_MAX","","",null,null],[17,"_SC_TZNAME_MAX","","",null,null],[17,"_SC_PAGESIZE","","",null,null],[17,"_SC_PAGE_SIZE","","",null,null],[17,"_SC_FSYNC","","",null,null],[17,"KERN_PROC_ARGV","","",null,null],[17,"KERN_PROC_NARGV","","",null,null],[17,"KERN_PROC_ENV","","",null,null],[17,"KERN_PROC_NENV","","",null,null],[17,"Q_GETQUOTA","","",null,null],[17,"Q_SETQUOTA","","",null,null],[17,"RTLD_GLOBAL","","",null,null],[17,"O_CLOEXEC","","",null,null],[17,"MS_SYNC","","",null,null],[17,"MS_INVALIDATE","","",null,null],[17,"PTHREAD_STACK_MIN","","",null,null],[17,"ENOATTR","","",null,null],[17,"EILSEQ","","",null,null],[17,"EOVERFLOW","","",null,null],[17,"ECANCELED","","",null,null],[17,"EIDRM","","",null,null],[17,"ENOMSG","","",null,null],[17,"ENOTSUP","","",null,null],[17,"ELAST","","",null,null],[17,"F_DUPFD_CLOEXEC","","",null,null],[17,"RLIM_NLIMITS","","",null,null],[17,"SO_SNDTIMEO","","",null,null],[17,"SO_RCVTIMEO","","",null,null],[17,"IPV6_JOIN_GROUP","","",null,null],[17,"IPV6_LEAVE_GROUP","","",null,null],[17,"KERN_PROC","","",null,null],[17,"O_DSYNC","","",null,null],[17,"MAP_RENAME","","",null,null],[17,"MAP_NORESERVE","","",null,null],[17,"MAP_HASSEMAPHORE","","",null,null],[17,"EIPSEC","","",null,null],[17,"ENOMEDIUM","","",null,null],[17,"EMEDIUMTYPE","","",null,null],[17,"RUSAGE_THREAD","","",null,null],[17,"MAP_COPY","","",null,null],[17,"MAP_NOEXTEND","","",null,null],[17,"_SC_CLK_TCK","","",null,null],[17,"_SC_IOV_MAX","","",null,null],[17,"_SC_GETGR_R_SIZE_MAX","","",null,null],[17,"_SC_GETPW_R_SIZE_MAX","","",null,null],[17,"_SC_LOGIN_NAME_MAX","","",null,null],[17,"_SC_MQ_PRIO_MAX","","",null,null],[17,"_SC_NPROCESSORS_ONLN","","",null,null],[17,"_SC_THREADS","","",null,null],[17,"_SC_THREAD_ATTR_STACKADDR","","",null,null],[17,"_SC_THREAD_ATTR_STACKSIZE","","",null,null],[17,"_SC_THREAD_DESTRUCTOR_ITERATIONS","","",null,null],[17,"_SC_THREAD_KEYS_MAX","","",null,null],[17,"_SC_THREAD_PRIO_INHERIT","","",null,null],[17,"_SC_THREAD_PRIO_PROTECT","","",null,null],[17,"_SC_THREAD_PRIORITY_SCHEDULING","","",null,null],[17,"_SC_THREAD_PROCESS_SHARED","","",null,null],[17,"_SC_THREAD_SAFE_FUNCTIONS","","",null,null],[17,"_SC_THREAD_STACK_MIN","","",null,null],[17,"_SC_THREAD_THREADS_MAX","","",null,null],[17,"_SC_TTY_NAME_MAX","","",null,null],[17,"_SC_ATEXIT_MAX","","",null,null],[17,"_SC_AIO_LISTIO_MAX","","",null,null],[17,"_SC_AIO_MAX","","",null,null],[17,"_SC_ASYNCHRONOUS_IO","","",null,null],[17,"_SC_MAPPED_FILES","","",null,null],[17,"_SC_MEMLOCK","","",null,null],[17,"_SC_MEMLOCK_RANGE","","",null,null],[17,"_SC_MEMORY_PROTECTION","","",null,null],[17,"_SC_MESSAGE_PASSING","","",null,null],[17,"_SC_MQ_OPEN_MAX","","",null,null],[17,"_SC_PRIORITY_SCHEDULING","","",null,null],[17,"_SC_SEMAPHORES","","",null,null],[17,"_SC_SHARED_MEMORY_OBJECTS","","",null,null],[17,"_SC_SYNCHRONIZED_IO","","",null,null],[17,"_SC_TIMERS","","",null,null],[17,"_SC_XOPEN_CRYPT","","",null,null],[17,"_SC_XOPEN_ENH_I18N","","",null,null],[17,"_SC_XOPEN_LEGACY","","",null,null],[17,"_SC_XOPEN_REALTIME","","",null,null],[17,"_SC_XOPEN_REALTIME_THREADS","","",null,null],[17,"_SC_XOPEN_UNIX","","",null,null],[17,"_SC_XOPEN_VERSION","","",null,null],[17,"_SC_SEM_NSEMS_MAX","","",null,null],[17,"_SC_SEM_VALUE_MAX","","",null,null],[17,"_SC_AIO_PRIO_DELTA_MAX","","",null,null],[17,"_SC_DELAYTIMER_MAX","","",null,null],[17,"_SC_PRIORITIZED_IO","","",null,null],[17,"_SC_REALTIME_SIGNALS","","",null,null],[17,"_SC_RTSIG_MAX","","",null,null],[17,"_SC_SIGQUEUE_MAX","","",null,null],[17,"_SC_TIMER_MAX","","",null,null],[17,"FD_SETSIZE","","",null,null],[17,"ST_NOSUID","","",null,null],[17,"PTHREAD_MUTEX_INITIALIZER","","",null,null],[17,"PTHREAD_COND_INITIALIZER","","",null,null],[17,"PTHREAD_RWLOCK_INITIALIZER","","",null,null],[17,"PTHREAD_MUTEX_RECURSIVE","","",null,null],[17,"KERN_PROC_ARGS","","",null,null],[17,"TMP_MAX","","",null,null],[17,"NI_MAXHOST","","",null,null],[17,"RTLD_LOCAL","","",null,null]],"paths":[[3,"utimbuf"],[3,"timeval"],[3,"timespec"],[3,"rlimit"],[3,"rusage"],[3,"in_addr"],[3,"in6_addr"],[3,"ip_mreq"],[3,"ipv6_mreq"],[3,"hostent"],[3,"iovec"],[3,"pollfd"],[3,"winsize"],[3,"sockaddr"],[3,"sockaddr_in6"],[3,"sockaddr_un"],[3,"passwd"],[3,"ifaddrs"],[3,"tm"],[3,"utsname"],[3,"msghdr"],[3,"sigaction"],[3,"stack_t"],[3,"sockaddr_in"],[3,"termios"],[3,"flock"],[3,"dirent"],[3,"glob_t"],[3,"stat"],[3,"statvfs"],[3,"addrinfo"],[3,"sockaddr_storage"],[3,"siginfo_t"],[3,"Dl_info"],[3,"lconv"]]};
searchIndex["core"] = {"doc":"# The Rust Core Library","items":[[0,"isize","core","The pointer-sized signed integer type.",null,null],[17,"MIN","core::isize","",null,null],[17,"MAX","","",null,null],[0,"i8","core","The 8-bit signed integer type.",null,null],[17,"MIN","core::i8","",null,null],[17,"MAX","","",null,null],[0,"i16","core","The 16-bit signed integer type.",null,null],[17,"MIN","core::i16","",null,null],[17,"MAX","","",null,null],[0,"i32","core","The 32-bit signed integer type.",null,null],[17,"MIN","core::i32","",null,null],[17,"MAX","","",null,null],[0,"i64","core","The 64-bit signed integer type.",null,null],[17,"MIN","core::i64","",null,null],[17,"MAX","","",null,null],[0,"usize","core","The pointer-sized unsigned integer type.",null,null],[17,"MIN","core::usize","",null,null],[17,"MAX","","",null,null],[0,"u8","core","The 8-bit unsigned integer type.",null,null],[17,"MIN","core::u8","",null,null],[17,"MAX","","",null,null],[0,"u16","core","The 16-bit unsigned integer type.",null,null],[17,"MIN","core::u16","",null,null],[17,"MAX","","",null,null],[0,"u32","core","The 32-bit unsigned integer type.",null,null],[17,"MIN","core::u32","",null,null],[17,"MAX","","",null,null],[0,"u64","core","The 64-bit unsigned integer type.",null,null],[17,"MIN","core::u64","",null,null],[17,"MAX","","",null,null],[0,"f32","core","Operations and constants for 32-bits floats (`f32` type)",null,null],[0,"consts","core::f32","Basic mathematical constants.",null,null],[17,"PI","core::f32::consts","Archimedes&#39; constant",null,null],[17,"FRAC_PI_2","","pi/2.0",null,null],[17,"FRAC_PI_3","","pi/3.0",null,null],[17,"FRAC_PI_4","","pi/4.0",null,null],[17,"FRAC_PI_6","","pi/6.0",null,null],[17,"FRAC_PI_8","","pi/8.0",null,null],[17,"FRAC_1_PI","","1.0/pi",null,null],[17,"FRAC_2_PI","","2.0/pi",null,null],[17,"FRAC_2_SQRT_PI","","2.0/sqrt(pi)",null,null],[17,"SQRT_2","","sqrt(2.0)",null,null],[17,"FRAC_1_SQRT_2","","1.0/sqrt(2.0)",null,null],[17,"E","","Euler&#39;s number",null,null],[17,"LOG2_E","","log2(e)",null,null],[17,"LOG10_E","","log10(e)",null,null],[17,"LN_2","","ln(2.0)",null,null],[17,"LN_10","","ln(10.0)",null,null],[17,"RADIX","core::f32","",null,null],[17,"MANTISSA_DIGITS","","",null,null],[17,"DIGITS","","",null,null],[17,"EPSILON","","",null,null],[17,"MIN","","Smallest finite f32 value",null,null],[17,"MIN_POSITIVE","","Smallest positive, normalized f32 value",null,null],[17,"MAX","","Largest finite f32 value",null,null],[17,"MIN_EXP","","",null,null],[17,"MAX_EXP","","",null,null],[17,"MIN_10_EXP","","",null,null],[17,"MAX_10_EXP","","",null,null],[17,"NAN","","",null,null],[17,"INFINITY","","",null,null],[17,"NEG_INFINITY","","",null,null],[0,"f64","core","Operations and constants for 64-bits floats (`f64` type)",null,null],[0,"consts","core::f64","Basic mathematical constants.",null,null],[17,"PI","core::f64::consts","Archimedes&#39; constant",null,null],[17,"FRAC_PI_2","","pi/2.0",null,null],[17,"FRAC_PI_3","","pi/3.0",null,null],[17,"FRAC_PI_4","","pi/4.0",null,null],[17,"FRAC_PI_6","","pi/6.0",null,null],[17,"FRAC_PI_8","","pi/8.0",null,null],[17,"FRAC_1_PI","","1.0/pi",null,null],[17,"FRAC_2_PI","","2.0/pi",null,null],[17,"FRAC_2_SQRT_PI","","2.0/sqrt(pi)",null,null],[17,"SQRT_2","","sqrt(2.0)",null,null],[17,"FRAC_1_SQRT_2","","1.0/sqrt(2.0)",null,null],[17,"E","","Euler&#39;s number",null,null],[17,"LOG2_E","","log2(e)",null,null],[17,"LOG10_E","","log10(e)",null,null],[17,"LN_2","","ln(2.0)",null,null],[17,"LN_10","","ln(10.0)",null,null],[17,"RADIX","core::f64","",null,null],[17,"MANTISSA_DIGITS","","",null,null],[17,"DIGITS","","",null,null],[17,"EPSILON","","",null,null],[17,"MIN","","Smallest finite f64 value",null,null],[17,"MIN_POSITIVE","","Smallest positive, normalized f64 value",null,null],[17,"MAX","","Largest finite f64 value",null,null],[17,"MIN_EXP","","",null,null],[17,"MAX_EXP","","",null,null],[17,"MIN_10_EXP","","",null,null],[17,"MAX_10_EXP","","",null,null],[17,"NAN","","",null,null],[17,"INFINITY","","",null,null],[17,"NEG_INFINITY","","",null,null],[0,"num","core","Numeric traits and functions for the built-in numeric types.",null,null],[3,"Wrapping","core::num","Provides intentionally-wrapped arithmetic on `T`.",null,null],[12,"0","","",0,null],[3,"ParseIntError","","An error which can be returned when parsing an integer.",null,null],[3,"ParseFloatError","","An error which can be returned when parsing a float.",null,null],[4,"FpCategory","","A classification of floating point numbers.",null,null],[13,"Nan","","&quot;Not a Number&quot;, often obtained by dividing by zero",1,null],[13,"Infinite","","Positive or negative infinity",1,null],[13,"Zero","","Positive or negative zero",1,null],[13,"Subnormal","","De-normalized floating point representation (less precise than `Normal`)",1,null],[13,"Normal","","A regular floating point number",1,null],[11,"shl","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":null}],[11,"add","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"add","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"add","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"add","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"add","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"add","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"add","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"add","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"add","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"add","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand_assign","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":null}],[11,"eq","","",2,{"inputs":[{"name":"parsefloaterror"},{"name":"parsefloaterror"}],"output":{"name":"bool"}}],[11,"ne","","",2,{"inputs":[{"name":"parsefloaterror"},{"name":"parsefloaterror"}],"output":{"name":"bool"}}],[11,"clone","","",2,{"inputs":[{"name":"parsefloaterror"}],"output":{"name":"parsefloaterror"}}],[11,"fmt","","",2,{"inputs":[{"name":"parsefloaterror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"__description","","",2,{"inputs":[{"name":"parsefloaterror"}],"output":{"name":"str"}}],[11,"fmt","","",2,{"inputs":[{"name":"parsefloaterror"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Zero","","Types that have a &quot;zero&quot; value.",null,null],[10,"zero","","The &quot;zero&quot; (usually, additive identity) for this type.",3,{"inputs":[],"output":{"name":"self"}}],[8,"One","","Types that have a &quot;one&quot; value.",null,null],[10,"one","","The &quot;one&quot; (usually, multiplicative identity) for this type.",4,{"inputs":[],"output":{"name":"self"}}],[11,"default","","",0,{"inputs":[],"output":{"name":"wrapping"}}],[11,"fmt","","",0,{"inputs":[{"name":"wrapping"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",0,{"inputs":[{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"cmp","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"option"}}],[11,"lt","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"le","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"gt","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"ge","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"eq","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"ne","","",0,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"fmt","","",1,{"inputs":[{"name":"fpcategory"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",1,{"inputs":[{"name":"fpcategory"},{"name":"fpcategory"}],"output":{"name":"bool"}}],[11,"clone","","",1,{"inputs":[{"name":"fpcategory"}],"output":{"name":"fpcategory"}}],[11,"eq","","",5,{"inputs":[{"name":"parseinterror"},{"name":"parseinterror"}],"output":{"name":"bool"}}],[11,"ne","","",5,{"inputs":[{"name":"parseinterror"},{"name":"parseinterror"}],"output":{"name":"bool"}}],[11,"clone","","",5,{"inputs":[{"name":"parseinterror"}],"output":{"name":"parseinterror"}}],[11,"fmt","","",5,{"inputs":[{"name":"parseinterror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",5,{"inputs":[{"name":"parseinterror"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"prelude","core","The libcore prelude",null,null],[0,"v1","core::prelude","The core prelude",null,null],[0,"intrinsics","core","rustc compiler intrinsics.",null,null],[5,"atomic_cxchg","core::intrinsics","",null,null],[5,"atomic_cxchg_acq","","",null,null],[5,"atomic_cxchg_rel","","",null,null],[5,"atomic_cxchg_acqrel","","",null,null],[5,"atomic_cxchg_relaxed","","",null,null],[5,"atomic_cxchg_failrelaxed","","",null,null],[5,"atomic_cxchg_failacq","","",null,null],[5,"atomic_cxchg_acq_failrelaxed","","",null,null],[5,"atomic_cxchg_acqrel_failrelaxed","","",null,null],[5,"atomic_cxchgweak","","",null,null],[5,"atomic_cxchgweak_acq","","",null,null],[5,"atomic_cxchgweak_rel","","",null,null],[5,"atomic_cxchgweak_acqrel","","",null,null],[5,"atomic_cxchgweak_relaxed","","",null,null],[5,"atomic_cxchgweak_failrelaxed","","",null,null],[5,"atomic_cxchgweak_failacq","","",null,null],[5,"atomic_cxchgweak_acq_failrelaxed","","",null,null],[5,"atomic_cxchgweak_acqrel_failrelaxed","","",null,null],[5,"atomic_load","","",null,null],[5,"atomic_load_acq","","",null,null],[5,"atomic_load_relaxed","","",null,null],[5,"atomic_load_unordered","","",null,null],[5,"atomic_store","","",null,null],[5,"atomic_store_rel","","",null,null],[5,"atomic_store_relaxed","","",null,null],[5,"atomic_store_unordered","","",null,null],[5,"atomic_xchg","","",null,null],[5,"atomic_xchg_acq","","",null,null],[5,"atomic_xchg_rel","","",null,null],[5,"atomic_xchg_acqrel","","",null,null],[5,"atomic_xchg_relaxed","","",null,null],[5,"atomic_xadd","","",null,null],[5,"atomic_xadd_acq","","",null,null],[5,"atomic_xadd_rel","","",null,null],[5,"atomic_xadd_acqrel","","",null,null],[5,"atomic_xadd_relaxed","","",null,null],[5,"atomic_xsub","","",null,null],[5,"atomic_xsub_acq","","",null,null],[5,"atomic_xsub_rel","","",null,null],[5,"atomic_xsub_acqrel","","",null,null],[5,"atomic_xsub_relaxed","","",null,null],[5,"atomic_and","","",null,null],[5,"atomic_and_acq","","",null,null],[5,"atomic_and_rel","","",null,null],[5,"atomic_and_acqrel","","",null,null],[5,"atomic_and_relaxed","","",null,null],[5,"atomic_nand","","",null,null],[5,"atomic_nand_acq","","",null,null],[5,"atomic_nand_rel","","",null,null],[5,"atomic_nand_acqrel","","",null,null],[5,"atomic_nand_relaxed","","",null,null],[5,"atomic_or","","",null,null],[5,"atomic_or_acq","","",null,null],[5,"atomic_or_rel","","",null,null],[5,"atomic_or_acqrel","","",null,null],[5,"atomic_or_relaxed","","",null,null],[5,"atomic_xor","","",null,null],[5,"atomic_xor_acq","","",null,null],[5,"atomic_xor_rel","","",null,null],[5,"atomic_xor_acqrel","","",null,null],[5,"atomic_xor_relaxed","","",null,null],[5,"atomic_max","","",null,null],[5,"atomic_max_acq","","",null,null],[5,"atomic_max_rel","","",null,null],[5,"atomic_max_acqrel","","",null,null],[5,"atomic_max_relaxed","","",null,null],[5,"atomic_min","","",null,null],[5,"atomic_min_acq","","",null,null],[5,"atomic_min_rel","","",null,null],[5,"atomic_min_acqrel","","",null,null],[5,"atomic_min_relaxed","","",null,null],[5,"atomic_umin","","",null,null],[5,"atomic_umin_acq","","",null,null],[5,"atomic_umin_rel","","",null,null],[5,"atomic_umin_acqrel","","",null,null],[5,"atomic_umin_relaxed","","",null,null],[5,"atomic_umax","","",null,null],[5,"atomic_umax_acq","","",null,null],[5,"atomic_umax_rel","","",null,null],[5,"atomic_umax_acqrel","","",null,null],[5,"atomic_umax_relaxed","","",null,null],[5,"atomic_fence","","",null,null],[5,"atomic_fence_acq","","",null,null],[5,"atomic_fence_rel","","",null,null],[5,"atomic_fence_acqrel","","",null,null],[5,"atomic_singlethreadfence","","A compiler-only memory barrier.",null,null],[5,"atomic_singlethreadfence_acq","","",null,null],[5,"atomic_singlethreadfence_rel","","",null,null],[5,"atomic_singlethreadfence_acqrel","","",null,null],[5,"abort","","Aborts the execution of the process.",null,null],[5,"unreachable","","Tells LLVM that this point in the code is not reachable,\nenabling further optimizations.",null,null],[5,"assume","","Informs the optimizer that a condition is always true.\nIf the condition is false, the behavior is undefined.",null,null],[5,"breakpoint","","Executes a breakpoint trap, for inspection by a debugger.",null,null],[5,"size_of","","The size of a type in bytes.",null,null],[5,"move_val_init","","Moves a value to an uninitialized memory location.",null,null],[5,"min_align_of","","",null,null],[5,"pref_align_of","","",null,null],[5,"size_of_val","","",null,null],[5,"min_align_of_val","","",null,null],[5,"drop_in_place","","Executes the destructor (if any) of the pointed-to value.",null,null],[5,"type_name","","Gets a static string slice containing the name of a type.",null,null],[5,"type_id","","Gets an identifier which is globally unique to the specified type. This\nfunction will return the same value for a type regardless of whichever\ncrate it is invoked in.",null,null],[5,"init_dropped","","Creates a value initialized to so that its drop flag,\nif any, says that it has been dropped.",null,null],[5,"init","","Creates a value initialized to zero.",null,null],[5,"uninit","","Creates an uninitialized value.",null,null],[5,"forget","","Moves a value out of scope without running drop glue.",null,null],[5,"transmute","","Unsafely transforms a value of one type into a value of another type.",null,null],[5,"return_address","","Gives the address for the return value of the enclosing function.",null,null],[5,"needs_drop","","Returns `true` if the actual type given as `T` requires drop\nglue; returns `false` if the actual type provided for `T`\nimplements `Copy`.",null,null],[5,"offset","","Calculates the offset from a pointer.",null,null],[5,"arith_offset","","Calculates the offset from a pointer, potentially wrapping.",null,null],[5,"copy_nonoverlapping","","Copies `count * size_of&lt;T&gt;` bytes from `src` to `dst`. The source\nand destination may *not* overlap.",null,null],[5,"copy","","Copies `count * size_of&lt;T&gt;` bytes from `src` to `dst`. The source\nand destination may overlap.",null,null],[5,"write_bytes","","Invokes memset on the specified pointer, setting `count * size_of::&lt;T&gt;()`\nbytes of memory starting at `dst` to `val`.",null,null],[5,"volatile_copy_nonoverlapping_memory","","Equivalent to the appropriate `llvm.memcpy.p0i8.0i8.*` intrinsic, with\na size of `count` * `size_of::&lt;T&gt;()` and an alignment of\n`min_align_of::&lt;T&gt;()`",null,null],[5,"volatile_copy_memory","","Equivalent to the appropriate `llvm.memmove.p0i8.0i8.*` intrinsic, with\na size of `count` * `size_of::&lt;T&gt;()` and an alignment of\n`min_align_of::&lt;T&gt;()`",null,null],[5,"volatile_set_memory","","Equivalent to the appropriate `llvm.memset.p0i8.*` intrinsic, with a\nsize of `count` * `size_of::&lt;T&gt;()` and an alignment of\n`min_align_of::&lt;T&gt;()`.",null,null],[5,"volatile_load","","Perform a volatile load from the `src` pointer.",null,null],[5,"volatile_store","","Perform a volatile store to the `dst` pointer.",null,null],[5,"sqrtf32","","Returns the square root of an `f32`",null,null],[5,"sqrtf64","","Returns the square root of an `f64`",null,null],[5,"powif32","","Raises an `f32` to an integer power.",null,null],[5,"powif64","","Raises an `f64` to an integer power.",null,null],[5,"sinf32","","Returns the sine of an `f32`.",null,null],[5,"sinf64","","Returns the sine of an `f64`.",null,null],[5,"cosf32","","Returns the cosine of an `f32`.",null,null],[5,"cosf64","","Returns the cosine of an `f64`.",null,null],[5,"powf32","","Raises an `f32` to an `f32` power.",null,null],[5,"powf64","","Raises an `f64` to an `f64` power.",null,null],[5,"expf32","","Returns the exponential of an `f32`.",null,null],[5,"expf64","","Returns the exponential of an `f64`.",null,null],[5,"exp2f32","","Returns 2 raised to the power of an `f32`.",null,null],[5,"exp2f64","","Returns 2 raised to the power of an `f64`.",null,null],[5,"logf32","","Returns the natural logarithm of an `f32`.",null,null],[5,"logf64","","Returns the natural logarithm of an `f64`.",null,null],[5,"log10f32","","Returns the base 10 logarithm of an `f32`.",null,null],[5,"log10f64","","Returns the base 10 logarithm of an `f64`.",null,null],[5,"log2f32","","Returns the base 2 logarithm of an `f32`.",null,null],[5,"log2f64","","Returns the base 2 logarithm of an `f64`.",null,null],[5,"fmaf32","","Returns `a * b + c` for `f32` values.",null,null],[5,"fmaf64","","Returns `a * b + c` for `f64` values.",null,null],[5,"fabsf32","","Returns the absolute value of an `f32`.",null,null],[5,"fabsf64","","Returns the absolute value of an `f64`.",null,null],[5,"copysignf32","","Copies the sign from `y` to `x` for `f32` values.",null,null],[5,"copysignf64","","Copies the sign from `y` to `x` for `f64` values.",null,null],[5,"floorf32","","Returns the largest integer less than or equal to an `f32`.",null,null],[5,"floorf64","","Returns the largest integer less than or equal to an `f64`.",null,null],[5,"ceilf32","","Returns the smallest integer greater than or equal to an `f32`.",null,null],[5,"ceilf64","","Returns the smallest integer greater than or equal to an `f64`.",null,null],[5,"truncf32","","Returns the integer part of an `f32`.",null,null],[5,"truncf64","","Returns the integer part of an `f64`.",null,null],[5,"rintf32","","Returns the nearest integer to an `f32`. May raise an inexact floating-point exception\nif the argument is not an integer.",null,null],[5,"rintf64","","Returns the nearest integer to an `f64`. May raise an inexact floating-point exception\nif the argument is not an integer.",null,null],[5,"nearbyintf32","","Returns the nearest integer to an `f32`.",null,null],[5,"nearbyintf64","","Returns the nearest integer to an `f64`.",null,null],[5,"roundf32","","Returns the nearest integer to an `f32`. Rounds half-way cases away from zero.",null,null],[5,"roundf64","","Returns the nearest integer to an `f64`. Rounds half-way cases away from zero.",null,null],[5,"fadd_fast","","Float addition that allows optimizations based on algebraic rules.\nMay assume inputs are finite.",null,null],[5,"fsub_fast","","Float subtraction that allows optimizations based on algebraic rules.\nMay assume inputs are finite.",null,null],[5,"fmul_fast","","Float multiplication that allows optimizations based on algebraic rules.\nMay assume inputs are finite.",null,null],[5,"fdiv_fast","","Float division that allows optimizations based on algebraic rules.\nMay assume inputs are finite.",null,null],[5,"frem_fast","","Float remainder that allows optimizations based on algebraic rules.\nMay assume inputs are finite.",null,null],[5,"ctpop","","Returns the number of bits set in an integer type `T`",null,null],[5,"ctlz","","Returns the number of leading bits unset in an integer type `T`",null,null],[5,"cttz","","Returns the number of trailing bits unset in an integer type `T`",null,null],[5,"bswap","","Reverses the bytes in an integer type `T`.",null,null],[5,"add_with_overflow","","Performs checked integer addition.",null,null],[5,"sub_with_overflow","","Performs checked integer subtraction",null,null],[5,"mul_with_overflow","","Performs checked integer multiplication",null,null],[5,"unchecked_div","","Performs an unchecked division, resulting in undefined behavior\nwhere y = 0 or x = `T::min_value()` and y = -1",null,null],[5,"unchecked_rem","","Returns the remainder of an unchecked division, resulting in\nundefined behavior where y = 0 or x = `T::min_value()` and y = -1",null,null],[5,"overflowing_add","","Returns (a + b) mod 2^N, where N is the width of T in bits.",null,null],[5,"overflowing_sub","","Returns (a - b) mod 2^N, where N is the width of T in bits.",null,null],[5,"overflowing_mul","","Returns (a * b) mod 2^N, where N is the width of T in bits.",null,null],[5,"discriminant_value","","Returns the value of the discriminant for the variant in &#39;v&#39;,\ncast to a `u64`; if `T` has no discriminant, returns 0.",null,null],[5,"try","","Rust&#39;s &quot;try catch&quot; construct which invokes the function pointer `f` with\nthe data pointer `data`.",null,null],[0,"mem","core","Basic functions for dealing with memory.",null,null],[5,"forget","core::mem","Leaks a value into the void, consuming ownership and never running its\ndestructor.",null,{"inputs":[{"name":"t"}],"output":null}],[5,"size_of","","Returns the size of a type in bytes.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"size_of_val","","Returns the size of the given value in bytes.",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"min_align_of","","Returns the ABI-required minimum alignment of a type",null,{"inputs":[],"output":{"name":"usize"}}],[5,"min_align_of_val","","Returns the ABI-required minimum alignment of the type of the value that `val` points to",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"align_of","","Returns the alignment in memory for a type.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"align_of_val","","Returns the ABI-required minimum alignment of the type of the value that `val` points to",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"zeroed","","Creates a value initialized to zero.",null,{"inputs":[],"output":{"name":"t"}}],[5,"dropped","","Creates a value initialized to an unspecified series of bytes.",null,{"inputs":[],"output":{"name":"t"}}],[5,"uninitialized","","Bypasses Rust&#39;s normal memory-initialization checks by pretending to\nproduce a value of type T, while doing nothing at all.",null,{"inputs":[],"output":{"name":"t"}}],[5,"swap","","Swap the values at two mutable locations of the same type, without deinitializing or copying\neither one.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":null}],[5,"replace","","Replaces the value at a mutable location with a new one, returning the old value, without\ndeinitializing or copying either one.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"drop","","Disposes of a value.",null,{"inputs":[{"name":"t"}],"output":null}],[5,"transmute_copy","","Interprets `src` as `&amp;U`, and then reads `src` without moving the contained\nvalue.",null,{"inputs":[{"name":"t"}],"output":{"name":"u"}}],[17,"POST_DROP_U8","","",null,null],[17,"POST_DROP_U32","","",null,null],[17,"POST_DROP_U64","","",null,null],[17,"POST_DROP_USIZE","","",null,null],[0,"nonzero","core","Exposes the NonZero lang item which provides optimization hints.",null,null],[3,"NonZero","core::nonzero","A wrapper type for raw pointers and integers that will never be\nNULL or 0 that might allow certain optimizations.",null,null],[8,"Zeroable","","Unsafe trait to indicate what types are usable with the NonZero struct",null,null],[11,"hash","","",6,null],[11,"fmt","","",6,{"inputs":[{"name":"nonzero"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"partial_cmp","","",6,{"inputs":[{"name":"nonzero"},{"name":"nonzero"}],"output":{"name":"option"}}],[11,"lt","","",6,{"inputs":[{"name":"nonzero"},{"name":"nonzero"}],"output":{"name":"bool"}}],[11,"le","","",6,{"inputs":[{"name":"nonzero"},{"name":"nonzero"}],"output":{"name":"bool"}}],[11,"gt","","",6,{"inputs":[{"name":"nonzero"},{"name":"nonzero"}],"output":{"name":"bool"}}],[11,"ge","","",6,{"inputs":[{"name":"nonzero"},{"name":"nonzero"}],"output":{"name":"bool"}}],[11,"cmp","","",6,{"inputs":[{"name":"nonzero"},{"name":"nonzero"}],"output":{"name":"ordering"}}],[11,"eq","","",6,{"inputs":[{"name":"nonzero"},{"name":"nonzero"}],"output":{"name":"bool"}}],[11,"ne","","",6,{"inputs":[{"name":"nonzero"},{"name":"nonzero"}],"output":{"name":"bool"}}],[11,"clone","","",6,{"inputs":[{"name":"nonzero"}],"output":{"name":"nonzero"}}],[11,"new","","Creates an instance of NonZero with the provided value.\nYou must indeed ensure that the value is actually &quot;non-zero&quot;.",6,{"inputs":[{"name":"t"}],"output":{"name":"nonzero"}}],[11,"deref","","",6,{"inputs":[{"name":"nonzero"}],"output":{"name":"t"}}],[0,"ptr","core","Raw, unsafe pointers, `*const T`, and `*mut T`.",null,null],[3,"Unique","core::ptr","A wrapper around a raw non-null `*mut T` that indicates that the possessor\nof this wrapper owns the referent. This in turn implies that the\n`Unique&lt;T&gt;` is `Send`/`Sync` if `T` is `Send`/`Sync`, unlike a raw\n`*mut T` (which conveys no particular ownership semantics).  It\nalso implies that the referent of the pointer should not be\nmodified without a unique path to the `Unique` reference. Useful\nfor building abstractions like `Vec&lt;T&gt;` or `Box&lt;T&gt;`, which\ninternally use raw pointers to manage the memory that they own.",null,null],[3,"Shared","","A wrapper around a raw non-null `*mut T` that indicates that the possessor\nof this wrapper has shared ownership of the referent. Useful for\nbuilding abstractions like `Rc&lt;T&gt;` or `Arc&lt;T&gt;`, which internally\nuse raw pointers to manage the memory that they own.",null,null],[5,"null","","Creates a null raw pointer.",null,null],[5,"null_mut","","Creates a null mutable raw pointer.",null,null],[5,"swap","","Swaps the values at two mutable locations of the same type, without\ndeinitializing either. They may overlap, unlike `mem::swap` which is\notherwise equivalent.",null,null],[5,"replace","","Replaces the value at `dest` with `src`, returning the old\nvalue, without dropping either.",null,null],[5,"read","","Reads the value from `src` without moving it. This leaves the\nmemory in `src` unchanged.",null,null],[5,"read_and_drop","","",null,null],[5,"write","","Overwrites a memory location with the given value without reading or\ndropping the old value.",null,null],[5,"read_volatile","","Performs a volatile read of the value from `src` without moving it. This\nleaves the memory in `src` unchanged.",null,null],[5,"write_volatile","","Performs a volatile write of a memory location with the given value without\nreading or dropping the old value.",null,null],[11,"new","","Creates a new `Unique`.",7,null],[11,"get","","Dereferences the content.",7,{"inputs":[{"name":"unique"}],"output":{"name":"t"}}],[11,"get_mut","","Mutably dereferences the content.",7,{"inputs":[{"name":"unique"}],"output":{"name":"t"}}],[11,"deref","","",7,null],[11,"fmt","","",7,{"inputs":[{"name":"unique"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new `Shared`.",8,null],[11,"clone","","",8,{"inputs":[{"name":"shared"}],"output":{"name":"self"}}],[11,"deref","","",8,null],[11,"fmt","","",8,{"inputs":[{"name":"shared"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"marker","core","Primitive traits and marker types representing basic &#39;kinds&#39; of types.",null,null],[3,"PhantomData","core::marker","`PhantomData&lt;T&gt;` allows you to describe that a type acts as if it stores a value of type `T`,\neven though it does not. This allows you to inform the compiler about certain safety properties\nof your code.",null,null],[8,"Send","","Types that can be transferred across thread boundaries.",null,null],[8,"Sized","","Types with a constant size known at compile-time.",null,null],[8,"Unsize","","Types that can be &quot;unsized&quot; to a dynamically sized type.",null,null],[8,"Copy","","Types that can be copied by simply copying bits (i.e. `memcpy`).",null,null],[8,"Sync","","Types that can be safely shared between threads when aliased.",null,null],[8,"Reflect","","Types that can be reflected over.",null,null],[11,"hash","","",9,{"inputs":[{"name":"phantomdata"},{"name":"h"}],"output":null}],[11,"eq","","",9,{"inputs":[{"name":"phantomdata"},{"name":"phantomdata"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",9,{"inputs":[{"name":"phantomdata"},{"name":"phantomdata"}],"output":{"name":"option"}}],[11,"cmp","","",9,{"inputs":[{"name":"phantomdata"},{"name":"phantomdata"}],"output":{"name":"ordering"}}],[11,"clone","","",9,{"inputs":[{"name":"phantomdata"}],"output":{"name":"phantomdata"}}],[11,"default","","",9,{"inputs":[],"output":{"name":"phantomdata"}}],[0,"ops","core","Overloadable operators.",null,null],[3,"RangeFull","core::ops","An unbounded range. Use `..` (two dots) for its shorthand.",null,null],[3,"Range","","A (half-open) range which is bounded at both ends: { x | start &lt;= x &lt; end }.\nUse `start..end` (two dots) for its shorthand.",null,null],[12,"start","","The lower bound of the range (inclusive).",10,null],[12,"end","","The upper bound of the range (exclusive).",10,null],[3,"RangeFrom","","A range which is only bounded below: { x | start &lt;= x }.\nUse `start..` for its shorthand.",null,null],[12,"start","","The lower bound of the range (inclusive).",11,null],[3,"RangeTo","","A range which is only bounded above: { x | x &lt; end }.\nUse `..end` (two dots) for its shorthand.",null,null],[12,"end","","The upper bound of the range (exclusive).",12,null],[3,"RangeToInclusive","","An inclusive range which is only bounded above: { x | x &lt;= end }.\nUse `...end` (three dots) for its shorthand.",null,null],[12,"end","","The upper bound of the range (inclusive)",13,null],[4,"RangeInclusive","","An inclusive range which is bounded at both ends: { x | start &lt;= x &lt;= end }.\nUse `start...end` (three dots) for its shorthand.",null,null],[13,"Empty","","Empty range (iteration has finished)",14,null],[12,"at","core::ops::RangeInclusive","The point at which iteration finished",14,null],[13,"NonEmpty","core::ops","Non-empty range (iteration will yield value(s))",14,null],[12,"start","core::ops::RangeInclusive","The lower bound of the range (inclusive).",14,null],[12,"end","","The upper bound of the range (inclusive).",14,null],[8,"Drop","core::ops","The `Drop` trait is used to run some code when a value goes out of scope.\nThis is sometimes called a &#39;destructor&#39;.",null,null],[10,"drop","","A method called when the value goes out of scope.",15,{"inputs":[{"name":"drop"}],"output":null}],[8,"Add","","The `Add` trait is used to specify the functionality of `+`.",null,null],[16,"Output","","The resulting type after applying the `+` operator",16,null],[10,"add","","The method for the `+` operator",16,{"inputs":[{"name":"add"},{"name":"rhs"}],"output":{"name":"output"}}],[8,"Sub","","The `Sub` trait is used to specify the functionality of `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator",17,null],[10,"sub","","The method for the `-` operator",17,{"inputs":[{"name":"sub"},{"name":"rhs"}],"output":{"name":"output"}}],[8,"Mul","","The `Mul` trait is used to specify the functionality of `*`.",null,null],[16,"Output","","The resulting type after applying the `*` operator",18,null],[10,"mul","","The method for the `*` operator",18,{"inputs":[{"name":"mul"},{"name":"rhs"}],"output":{"name":"output"}}],[8,"Div","","The `Div` trait is used to specify the functionality of `/`.",null,null],[16,"Output","","The resulting type after applying the `/` operator",19,null],[10,"div","","The method for the `/` operator",19,{"inputs":[{"name":"div"},{"name":"rhs"}],"output":{"name":"output"}}],[8,"Rem","","The `Rem` trait is used to specify the functionality of `%`.",null,null],[16,"Output","","The resulting type after applying the `%` operator",20,null],[10,"rem","","The method for the `%` operator",20,{"inputs":[{"name":"rem"},{"name":"rhs"}],"output":{"name":"output"}}],[8,"Neg","","The `Neg` trait is used to specify the functionality of unary `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator",21,null],[10,"neg","","The method for the unary `-` operator",21,{"inputs":[{"name":"neg"}],"output":{"name":"output"}}],[8,"Not","","The `Not` trait is used to specify the functionality of unary `!`.",null,null],[16,"Output","","The resulting type after applying the `!` operator",22,null],[10,"not","","The method for the unary `!` operator",22,{"inputs":[{"name":"not"}],"output":{"name":"output"}}],[8,"BitAnd","","The `BitAnd` trait is used to specify the functionality of `&amp;`.",null,null],[16,"Output","","The resulting type after applying the `&amp;` operator",23,null],[10,"bitand","","The method for the `&amp;` operator",23,{"inputs":[{"name":"bitand"},{"name":"rhs"}],"output":{"name":"output"}}],[8,"BitOr","","The `BitOr` trait is used to specify the functionality of `|`.",null,null],[16,"Output","","The resulting type after applying the `|` operator",24,null],[10,"bitor","","The method for the `|` operator",24,{"inputs":[{"name":"bitor"},{"name":"rhs"}],"output":{"name":"output"}}],[8,"BitXor","","The `BitXor` trait is used to specify the functionality of `^`.",null,null],[16,"Output","","The resulting type after applying the `^` operator",25,null],[10,"bitxor","","The method for the `^` operator",25,{"inputs":[{"name":"bitxor"},{"name":"rhs"}],"output":{"name":"output"}}],[8,"Shl","","The `Shl` trait is used to specify the functionality of `&lt;&lt;`.",null,null],[16,"Output","","The resulting type after applying the `&lt;&lt;` operator",26,null],[10,"shl","","The method for the `&lt;&lt;` operator",26,{"inputs":[{"name":"shl"},{"name":"rhs"}],"output":{"name":"output"}}],[8,"Shr","","The `Shr` trait is used to specify the functionality of `&gt;&gt;`.",null,null],[16,"Output","","The resulting type after applying the `&gt;&gt;` operator",27,null],[10,"shr","","The method for the `&gt;&gt;` operator",27,{"inputs":[{"name":"shr"},{"name":"rhs"}],"output":{"name":"output"}}],[8,"AddAssign","","The `AddAssign` trait is used to specify the functionality of `+=`.",null,null],[10,"add_assign","","The method for the `+=` operator",28,{"inputs":[{"name":"addassign"},{"name":"rhs"}],"output":null}],[8,"SubAssign","","The `SubAssign` trait is used to specify the functionality of `-=`.",null,null],[10,"sub_assign","","The method for the `-=` operator",29,{"inputs":[{"name":"subassign"},{"name":"rhs"}],"output":null}],[8,"MulAssign","","The `MulAssign` trait is used to specify the functionality of `*=`.",null,null],[10,"mul_assign","","The method for the `*=` operator",30,{"inputs":[{"name":"mulassign"},{"name":"rhs"}],"output":null}],[8,"DivAssign","","The `DivAssign` trait is used to specify the functionality of `/=`.",null,null],[10,"div_assign","","The method for the `/=` operator",31,{"inputs":[{"name":"divassign"},{"name":"rhs"}],"output":null}],[8,"RemAssign","","The `RemAssign` trait is used to specify the functionality of `%=`.",null,null],[10,"rem_assign","","The method for the `%=` operator",32,{"inputs":[{"name":"remassign"},{"name":"rhs"}],"output":null}],[8,"BitAndAssign","","The `BitAndAssign` trait is used to specify the functionality of `&amp;=`.",null,null],[10,"bitand_assign","","The method for the `&amp;` operator",33,{"inputs":[{"name":"bitandassign"},{"name":"rhs"}],"output":null}],[8,"BitOrAssign","","The `BitOrAssign` trait is used to specify the functionality of `|=`.",null,null],[10,"bitor_assign","","The method for the `|=` operator",34,{"inputs":[{"name":"bitorassign"},{"name":"rhs"}],"output":null}],[8,"BitXorAssign","","The `BitXorAssign` trait is used to specify the functionality of `^=`.",null,null],[10,"bitxor_assign","","The method for the `^=` operator",35,{"inputs":[{"name":"bitxorassign"},{"name":"rhs"}],"output":null}],[8,"ShlAssign","","The `ShlAssign` trait is used to specify the functionality of `&lt;&lt;=`.",null,null],[10,"shl_assign","","The method for the `&lt;&lt;=` operator",36,{"inputs":[{"name":"shlassign"},{"name":"rhs"}],"output":null}],[8,"ShrAssign","","The `ShrAssign` trait is used to specify the functionality of `&gt;&gt;=`.",null,null],[10,"shr_assign","","The method for the `&gt;&gt;=` operator",37,{"inputs":[{"name":"shrassign"},{"name":"rhs"}],"output":null}],[8,"Index","","The `Index` trait is used to specify the functionality of indexing operations\nlike `arr[idx]` when used in an immutable context.",null,null],[16,"Output","","The returned type after indexing",38,null],[10,"index","","The method for the indexing (`Foo[Bar]`) operation",38,{"inputs":[{"name":"index"},{"name":"idx"}],"output":{"name":"output"}}],[8,"IndexMut","","The `IndexMut` trait is used to specify the functionality of indexing\noperations like `arr[idx]`, when used in a mutable context.",null,null],[10,"index_mut","","The method for the indexing (`Foo[Bar]`) operation",39,{"inputs":[{"name":"indexmut"},{"name":"idx"}],"output":{"name":"output"}}],[8,"Deref","","The `Deref` trait is used to specify the functionality of dereferencing\noperations, like `*v`.",null,null],[16,"Target","","The resulting type after dereferencing",40,null],[10,"deref","","The method called to dereference a value",40,{"inputs":[{"name":"deref"}],"output":{"name":"target"}}],[8,"DerefMut","","The `DerefMut` trait is used to specify the functionality of dereferencing\nmutably like `*v = 1;`",null,null],[10,"deref_mut","","The method called to mutably dereference a value",41,{"inputs":[{"name":"derefmut"}],"output":{"name":"target"}}],[8,"Fn","","A version of the call operator that takes an immutable receiver.",null,null],[10,"call","","This is called when the call operator is used.",42,{"inputs":[{"name":"fn"},{"name":"args"}],"output":{"name":"output"}}],[8,"FnMut","","A version of the call operator that takes a mutable receiver.",null,null],[10,"call_mut","","This is called when the call operator is used.",43,{"inputs":[{"name":"fnmut"},{"name":"args"}],"output":{"name":"output"}}],[8,"FnOnce","","A version of the call operator that takes a by-value receiver.",null,null],[16,"Output","","The returned type after the call operator is used.",44,null],[10,"call_once","","This is called when the call operator is used.",44,{"inputs":[{"name":"fnonce"},{"name":"args"}],"output":{"name":"output"}}],[8,"CoerceUnsized","","Trait that indicates that this is a pointer or a wrapper for one,\nwhere unsizing can be performed on the pointee.",null,null],[8,"Place","","Both `in (PLACE) EXPR` and `box EXPR` desugar into expressions\nthat allocate an intermediate &quot;place&quot; that holds uninitialized\nstate.  The desugaring evaluates EXPR, and writes the result at\nthe address returned by the `pointer` method of this trait.",null,null],[10,"pointer","","Returns the address where the input value will be written.\nNote that the data at this address is generally uninitialized,\nand thus one should use `ptr::write` for initializing it.",45,null],[8,"Placer","","Interface to implementations of  `in (PLACE) EXPR`.",null,null],[16,"Place","","`Place` is the intermedate agent guarding the\nuninitialized state for `Data`.",46,null],[10,"make_place","","Creates a fresh place from `self`.",46,{"inputs":[{"name":"placer"}],"output":{"name":"place"}}],[8,"InPlace","","Specialization of `Place` trait supporting `in (PLACE) EXPR`.",null,null],[16,"Owner","","`Owner` is the type of the end value of `in (PLACE) EXPR`",47,null],[10,"finalize","","Converts self into the final value, shifting\ndeallocation/cleanup responsibilities (if any remain), over to\nthe returned instance of `Owner` and forgetting self.",47,{"inputs":[{"name":"inplace"}],"output":{"name":"owner"}}],[8,"Boxed","","Core trait for the `box EXPR` form.",null,null],[16,"Data","","The kind of data that is stored in this kind of box.",48,null],[16,"Place","","The place that will negotiate the storage of the data.",48,null],[10,"finalize","","Converts filled place into final owning value, shifting\ndeallocation/cleanup responsibilities (if any remain), over to\nreturned instance of `Self` and forgetting `filled`.",48,{"inputs":[{"name":"place"}],"output":{"name":"self"}}],[8,"BoxPlace","","Specialization of `Place` trait supporting `box EXPR`.",null,null],[10,"make_place","","Creates a globally fresh place.",49,{"inputs":[],"output":{"name":"self"}}],[11,"eq","","",50,{"inputs":[{"name":"rangefull"},{"name":"rangefull"}],"output":{"name":"bool"}}],[11,"clone","","",50,{"inputs":[{"name":"rangefull"}],"output":{"name":"rangefull"}}],[11,"fmt","","",50,{"inputs":[{"name":"rangefull"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",10,{"inputs":[{"name":"range"},{"name":"range"}],"output":{"name":"bool"}}],[11,"ne","","",10,{"inputs":[{"name":"range"},{"name":"range"}],"output":{"name":"bool"}}],[11,"clone","","",10,{"inputs":[{"name":"range"}],"output":{"name":"range"}}],[11,"fmt","","",10,{"inputs":[{"name":"range"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"contains","","# Examples",10,{"inputs":[{"name":"range"},{"name":"idx"}],"output":{"name":"bool"}}],[11,"eq","","",11,{"inputs":[{"name":"rangefrom"},{"name":"rangefrom"}],"output":{"name":"bool"}}],[11,"ne","","",11,{"inputs":[{"name":"rangefrom"},{"name":"rangefrom"}],"output":{"name":"bool"}}],[11,"clone","","",11,{"inputs":[{"name":"rangefrom"}],"output":{"name":"rangefrom"}}],[11,"fmt","","",11,{"inputs":[{"name":"rangefrom"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"contains","","# Examples",11,{"inputs":[{"name":"rangefrom"},{"name":"idx"}],"output":{"name":"bool"}}],[11,"eq","","",12,{"inputs":[{"name":"rangeto"},{"name":"rangeto"}],"output":{"name":"bool"}}],[11,"ne","","",12,{"inputs":[{"name":"rangeto"},{"name":"rangeto"}],"output":{"name":"bool"}}],[11,"clone","","",12,{"inputs":[{"name":"rangeto"}],"output":{"name":"rangeto"}}],[11,"fmt","","",12,{"inputs":[{"name":"rangeto"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"contains","","# Examples",12,{"inputs":[{"name":"rangeto"},{"name":"idx"}],"output":{"name":"bool"}}],[11,"eq","","",14,{"inputs":[{"name":"rangeinclusive"},{"name":"rangeinclusive"}],"output":{"name":"bool"}}],[11,"ne","","",14,{"inputs":[{"name":"rangeinclusive"},{"name":"rangeinclusive"}],"output":{"name":"bool"}}],[11,"clone","","",14,{"inputs":[{"name":"rangeinclusive"}],"output":{"name":"rangeinclusive"}}],[11,"fmt","","",14,{"inputs":[{"name":"rangeinclusive"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",14,{"inputs":[{"name":"range"}],"output":{"name":"rangeinclusive"}}],[11,"contains","","# Examples",14,{"inputs":[{"name":"rangeinclusive"},{"name":"idx"}],"output":{"name":"bool"}}],[11,"eq","","",13,{"inputs":[{"name":"rangetoinclusive"},{"name":"rangetoinclusive"}],"output":{"name":"bool"}}],[11,"ne","","",13,{"inputs":[{"name":"rangetoinclusive"},{"name":"rangetoinclusive"}],"output":{"name":"bool"}}],[11,"clone","","",13,{"inputs":[{"name":"rangetoinclusive"}],"output":{"name":"rangetoinclusive"}}],[11,"fmt","","",13,{"inputs":[{"name":"rangetoinclusive"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"contains","","# Examples",13,{"inputs":[{"name":"rangetoinclusive"},{"name":"idx"}],"output":{"name":"bool"}}],[0,"cmp","core","Functionality for ordering and comparison.",null,null],[4,"Ordering","core::cmp","An `Ordering` is the result of a comparison between two values.",null,null],[13,"Less","","An ordering where a compared value is less [than another].",51,null],[13,"Equal","","An ordering where a compared value is equal [to another].",51,null],[13,"Greater","","An ordering where a compared value is greater [than another].",51,null],[5,"min","","Compare and return the minimum of two values.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"max","","Compare and return the maximum of two values.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[8,"PartialEq","","Trait for equality comparisons which are [partial equivalence\nrelations](http://en.wikipedia.org/wiki/Partial_equivalence_relation).",null,null],[10,"eq","","This method tests for `self` and `other` values to be equal, and is used\nby `==`.",52,{"inputs":[{"name":"partialeq"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"ne","","This method tests for `!=`.",52,{"inputs":[{"name":"partialeq"},{"name":"rhs"}],"output":{"name":"bool"}}],[8,"Eq","","Trait for equality comparisons which are [equivalence relations](\nhttps://en.wikipedia.org/wiki/Equivalence_relation).",null,null],[8,"Ord","","Trait for types that form a [total order](https://en.wikipedia.org/wiki/Total_order).",null,null],[10,"cmp","","This method returns an `Ordering` between `self` and `other`.",53,{"inputs":[{"name":"ord"},{"name":"self"}],"output":{"name":"ordering"}}],[8,"PartialOrd","","Trait for values that can be compared for a sort-order.",null,null],[10,"partial_cmp","","This method returns an ordering between `self` and `other` values if one exists.",54,{"inputs":[{"name":"partialord"},{"name":"rhs"}],"output":{"name":"option"}}],[11,"lt","","This method tests less than (for `self` and `other`) and is used by the `&lt;` operator.",54,{"inputs":[{"name":"partialord"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"le","","This method tests less than or equal to (for `self` and `other`) and is used by the `&lt;=`\noperator.",54,{"inputs":[{"name":"partialord"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"gt","","This method tests greater than (for `self` and `other`) and is used by the `&gt;` operator.",54,{"inputs":[{"name":"partialord"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"ge","","This method tests greater than or equal to (for `self` and `other`) and is used by the `&gt;=`\noperator.",54,{"inputs":[{"name":"partialord"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"fmt","","",51,{"inputs":[{"name":"ordering"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",51,{"inputs":[{"name":"ordering"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"clone","","",51,{"inputs":[{"name":"ordering"}],"output":{"name":"ordering"}}],[11,"reverse","","Reverse the `Ordering`.",51,{"inputs":[{"name":"ordering"}],"output":{"name":"ordering"}}],[11,"cmp","","",51,{"inputs":[{"name":"ordering"},{"name":"ordering"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",51,{"inputs":[{"name":"ordering"},{"name":"ordering"}],"output":{"name":"option"}}],[0,"clone","core","The `Clone` trait for types that cannot be &#39;implicitly copied&#39;.",null,null],[8,"Clone","core::clone","A common trait for cloning an object.",null,null],[10,"clone","","Returns a copy of the value.",55,{"inputs":[{"name":"clone"}],"output":{"name":"self"}}],[11,"clone_from","","Performs copy-assignment from `source`.",55,{"inputs":[{"name":"clone"},{"name":"self"}],"output":null}],[0,"default","core","The `Default` trait for types which may have meaningful default values.",null,null],[8,"Default","core::default","A trait for giving a type a useful default value.",null,null],[10,"default","","Returns the &quot;default value&quot; for a type.",56,{"inputs":[],"output":{"name":"self"}}],[0,"convert","core","Traits for conversions between types.",null,null],[8,"AsRef","core::convert","A cheap, reference-to-reference conversion.",null,null],[10,"as_ref","","Performs the conversion.",57,{"inputs":[{"name":"asref"}],"output":{"name":"t"}}],[8,"AsMut","","A cheap, mutable reference-to-mutable reference conversion.",null,null],[10,"as_mut","","Performs the conversion.",58,{"inputs":[{"name":"asmut"}],"output":{"name":"t"}}],[8,"Into","","A conversion that consumes `self`, which may or may not be expensive.",null,null],[10,"into","","Performs the conversion.",59,{"inputs":[{"name":"into"}],"output":{"name":"t"}}],[8,"From","","Construct `Self` via a conversion.",null,null],[10,"from","","Performs the conversion.",60,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[0,"borrow","core","A module for working with borrowed data.",null,null],[8,"Borrow","core::borrow","A trait for borrowing data.",null,null],[10,"borrow","","Immutably borrows from an owned value.",61,{"inputs":[{"name":"borrow"}],"output":{"name":"borrowed"}}],[8,"BorrowMut","","A trait for mutably borrowing data.",null,null],[10,"borrow_mut","","Mutably borrows from an owned value.",62,{"inputs":[{"name":"borrowmut"}],"output":{"name":"borrowed"}}],[0,"any","core","This module implements the `Any` trait, which enables dynamic typing\nof any `&#39;static` type through runtime reflection.",null,null],[3,"TypeId","core::any","A `TypeId` represents a globally unique identifier for a type.",null,null],[8,"Any","","A type to emulate dynamic typing.",null,null],[10,"get_type_id","","Gets the `TypeId` of `self`.",63,{"inputs":[{"name":"any"}],"output":{"name":"typeid"}}],[11,"fmt","core","",63,{"inputs":[{"name":"any"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",63,{"inputs":[{"name":"any"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is","","Returns true if the boxed type is the same as `T`",63,{"inputs":[{"name":"any"}],"output":{"name":"bool"}}],[11,"downcast_ref","","Returns some reference to the boxed value if it is of type `T`, or\n`None` if it isn&#39;t.",63,{"inputs":[{"name":"any"}],"output":{"name":"option"}}],[11,"downcast_mut","","Returns some mutable reference to the boxed value if it is of type `T`, or\n`None` if it isn&#39;t.",63,{"inputs":[{"name":"any"}],"output":{"name":"option"}}],[11,"is","","Forwards to the method defined on the type `Any`.",63,{"inputs":[{"name":"any"}],"output":{"name":"bool"}}],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",63,{"inputs":[{"name":"any"}],"output":{"name":"option"}}],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",63,{"inputs":[{"name":"any"}],"output":{"name":"option"}}],[11,"hash","core::any","",64,null],[11,"fmt","","",64,{"inputs":[{"name":"typeid"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",64,{"inputs":[{"name":"typeid"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"ne","","",64,{"inputs":[{"name":"typeid"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"clone","","",64,{"inputs":[{"name":"typeid"}],"output":{"name":"typeid"}}],[11,"of","","Returns the `TypeId` of the type this generic function has been\ninstantiated with",64,{"inputs":[],"output":{"name":"typeid"}}],[0,"array","core","Implementations of things like `Eq` for fixed-length arrays\nup to a certain length. Eventually we should able to generalize\nto all lengths.",null,null],[8,"FixedSizeArray","core::array","Utility trait implemented only on arrays of fixed size",null,null],[10,"as_slice","","Converts the array to immutable slice",65,null],[10,"as_mut_slice","","Converts the array to mutable slice",65,null],[0,"sync","core","Synchronization primitives",null,null],[0,"atomic","core::sync","Atomic types",null,null],[3,"AtomicBool","core::sync::atomic","A boolean type which can be safely shared between threads.",null,null],[3,"AtomicIsize","","A signed integer type which can be safely shared between threads.",null,null],[3,"AtomicUsize","","An unsigned integer type which can be safely shared between threads.",null,null],[3,"AtomicPtr","","A raw pointer type which can be safely shared between threads.",null,null],[4,"Ordering","","Atomic memory orderings",null,null],[13,"Relaxed","","No ordering constraints, only atomic operations. Corresponds to LLVM&#39;s\n`Monotonic` ordering.",66,null],[13,"Release","","When coupled with a store, all previous writes become visible\nto another thread that performs a load with `Acquire` ordering\non the same value.",66,null],[13,"Acquire","","When coupled with a load, all subsequent loads will see data\nwritten before a store with `Release` ordering on the same value\nin another thread.",66,null],[13,"AcqRel","","When coupled with a load, uses `Acquire` ordering, and with a store\n`Release` ordering.",66,null],[13,"SeqCst","","Like `AcqRel` with the additional guarantee that all threads see all\nsequentially consistent operations in the same order.",66,null],[5,"fence","","An atomic fence.",null,{"inputs":[{"name":"ordering"}],"output":null}],[17,"ATOMIC_BOOL_INIT","","An `AtomicBool` initialized to `false`.",null,null],[17,"ATOMIC_ISIZE_INIT","","An `AtomicIsize` initialized to `0`.",null,null],[17,"ATOMIC_USIZE_INIT","","An `AtomicUsize` initialized to `0`.",null,null],[11,"default","","",67,{"inputs":[],"output":{"name":"self"}}],[11,"default","","",68,{"inputs":[],"output":{"name":"self"}}],[11,"default","","",69,{"inputs":[],"output":{"name":"self"}}],[11,"default","","",70,{"inputs":[],"output":{"name":"atomicptr"}}],[11,"fmt","","",66,{"inputs":[{"name":"ordering"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",66,{"inputs":[{"name":"ordering"}],"output":{"name":"ordering"}}],[11,"new","","Creates a new `AtomicBool`.",67,{"inputs":[{"name":"bool"}],"output":{"name":"atomicbool"}}],[11,"load","","Loads a value from the bool.",67,{"inputs":[{"name":"atomicbool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"store","","Stores a value into the bool.",67,{"inputs":[{"name":"atomicbool"},{"name":"bool"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the bool, returning the old value.",67,{"inputs":[{"name":"atomicbool"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"compare_and_swap","","Stores a value into the `bool` if the current value is the same as the `current` value.",67,{"inputs":[{"name":"atomicbool"},{"name":"bool"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"compare_exchange","","Stores a value into the `bool` if the current value is the same as the `current` value.",67,{"inputs":[{"name":"atomicbool"},{"name":"bool"},{"name":"bool"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the `bool` if the current value is the same as the `current` value.",67,{"inputs":[{"name":"atomicbool"},{"name":"bool"},{"name":"bool"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_and","","Logical &quot;and&quot; with a boolean value.",67,{"inputs":[{"name":"atomicbool"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"fetch_nand","","Logical &quot;nand&quot; with a boolean value.",67,{"inputs":[{"name":"atomicbool"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"fetch_or","","Logical &quot;or&quot; with a boolean value.",67,{"inputs":[{"name":"atomicbool"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"fetch_xor","","Logical &quot;xor&quot; with a boolean value.",67,{"inputs":[{"name":"atomicbool"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"new","","Creates a new `AtomicIsize`.",68,{"inputs":[{"name":"isize"}],"output":{"name":"atomicisize"}}],[11,"load","","Loads a value from the isize.",68,{"inputs":[{"name":"atomicisize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"store","","Stores a value into the isize.",68,{"inputs":[{"name":"atomicisize"},{"name":"isize"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the isize, returning the old value.",68,{"inputs":[{"name":"atomicisize"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"compare_and_swap","","Stores a value into the `isize` if the current value is the same as the `current` value.",68,{"inputs":[{"name":"atomicisize"},{"name":"isize"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"compare_exchange","","Stores a value into the `isize` if the current value is the same as the `current` value.",68,{"inputs":[{"name":"atomicisize"},{"name":"isize"},{"name":"isize"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the `isize` if the current value is the same as the `current` value.",68,{"inputs":[{"name":"atomicisize"},{"name":"isize"},{"name":"isize"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_add","","Add an isize to the current value, returning the previous value.",68,{"inputs":[{"name":"atomicisize"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"fetch_sub","","Subtract an isize from the current value, returning the previous value.",68,{"inputs":[{"name":"atomicisize"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"fetch_and","","Bitwise and with the current isize, returning the previous value.",68,{"inputs":[{"name":"atomicisize"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"fetch_or","","Bitwise or with the current isize, returning the previous value.",68,{"inputs":[{"name":"atomicisize"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"fetch_xor","","Bitwise xor with the current isize, returning the previous value.",68,{"inputs":[{"name":"atomicisize"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"new","","Creates a new `AtomicUsize`.",69,{"inputs":[{"name":"usize"}],"output":{"name":"atomicusize"}}],[11,"load","","Loads a value from the usize.",69,{"inputs":[{"name":"atomicusize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"store","","Stores a value into the usize.",69,{"inputs":[{"name":"atomicusize"},{"name":"usize"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the usize, returning the old value.",69,{"inputs":[{"name":"atomicusize"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"compare_and_swap","","Stores a value into the `usize` if the current value is the same as the `current` value.",69,{"inputs":[{"name":"atomicusize"},{"name":"usize"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"compare_exchange","","Stores a value into the `usize` if the current value is the same as the `current` value.",69,{"inputs":[{"name":"atomicusize"},{"name":"usize"},{"name":"usize"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the `usize` if the current value is the same as the `current` value.",69,{"inputs":[{"name":"atomicusize"},{"name":"usize"},{"name":"usize"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_add","","Add to the current usize, returning the previous value.",69,{"inputs":[{"name":"atomicusize"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fetch_sub","","Subtract from the current usize, returning the previous value.",69,{"inputs":[{"name":"atomicusize"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fetch_and","","Bitwise and with the current usize, returning the previous value.",69,{"inputs":[{"name":"atomicusize"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fetch_or","","Bitwise or with the current usize, returning the previous value.",69,{"inputs":[{"name":"atomicusize"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fetch_xor","","Bitwise xor with the current usize, returning the previous value.",69,{"inputs":[{"name":"atomicusize"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"new","","Creates a new `AtomicPtr`.",70,null],[11,"load","","Loads a value from the pointer.",70,null],[11,"store","","Stores a value into the pointer.",70,null],[11,"swap","","Stores a value into the pointer, returning the old value.",70,null],[11,"compare_and_swap","","Stores a value into the pointer if the current value is the same as the `current` value.",70,null],[11,"compare_exchange","","Stores a value into the pointer if the current value is the same as the `current` value.",70,null],[11,"compare_exchange_weak","","Stores a value into the pointer if the current value is the same as the `current` value.",70,null],[11,"fmt","","",69,{"inputs":[{"name":"atomicusize"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",68,{"inputs":[{"name":"atomicisize"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",67,{"inputs":[{"name":"atomicbool"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",70,{"inputs":[{"name":"atomicptr"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"cell","core","Shareable mutable containers.",null,null],[3,"Cell","core::cell","A mutable memory location that admits only `Copy` data.",null,null],[3,"RefCell","","A mutable memory location with dynamically checked borrow rules",null,null],[3,"Ref","","Wraps a borrowed reference to a value in a `RefCell` box.\nA wrapper type for an immutably borrowed value from a `RefCell&lt;T&gt;`.",null,null],[3,"RefMut","","A wrapper type for a mutably borrowed value from a `RefCell&lt;T&gt;`.",null,null],[3,"UnsafeCell","","The core primitive for interior mutability in Rust.",null,null],[4,"BorrowState","","An enumeration of values returned from the `state` method on a `RefCell&lt;T&gt;`.",null,null],[13,"Reading","","The cell is currently being read, there is at least one active `borrow`.",71,null],[13,"Writing","","The cell is currently being written to, there is an active `borrow_mut`.",71,null],[13,"Unused","","There are no outstanding borrows on this cell.",71,null],[11,"new","","Creates a new `Cell` containing the given value.",72,{"inputs":[{"name":"t"}],"output":{"name":"cell"}}],[11,"get","","Returns a copy of the contained value.",72,{"inputs":[{"name":"cell"}],"output":{"name":"t"}}],[11,"set","","Sets the contained value.",72,{"inputs":[{"name":"cell"},{"name":"t"}],"output":null}],[11,"as_unsafe_cell","","Returns a reference to the underlying `UnsafeCell`.",72,{"inputs":[{"name":"cell"}],"output":{"name":"unsafecell"}}],[11,"clone","","",72,{"inputs":[{"name":"cell"}],"output":{"name":"cell"}}],[11,"default","","",72,{"inputs":[],"output":{"name":"cell"}}],[11,"eq","","",72,{"inputs":[{"name":"cell"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"fmt","","",71,{"inputs":[{"name":"borrowstate"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",71,{"inputs":[{"name":"borrowstate"},{"name":"borrowstate"}],"output":{"name":"bool"}}],[11,"clone","","",71,{"inputs":[{"name":"borrowstate"}],"output":{"name":"borrowstate"}}],[11,"new","","Creates a new `RefCell` containing `value`.",73,{"inputs":[{"name":"t"}],"output":{"name":"refcell"}}],[11,"into_inner","","Consumes the `RefCell`, returning the wrapped value.",73,{"inputs":[{"name":"refcell"}],"output":{"name":"t"}}],[11,"borrow_state","","Query the current state of this `RefCell`",73,{"inputs":[{"name":"refcell"}],"output":{"name":"borrowstate"}}],[11,"borrow","","Immutably borrows the wrapped value.",73,{"inputs":[{"name":"refcell"}],"output":{"name":"ref"}}],[11,"borrow_mut","","Mutably borrows the wrapped value.",73,{"inputs":[{"name":"refcell"}],"output":{"name":"refmut"}}],[11,"as_unsafe_cell","","Returns a reference to the underlying `UnsafeCell`.",73,{"inputs":[{"name":"refcell"}],"output":{"name":"unsafecell"}}],[11,"clone","","",73,{"inputs":[{"name":"refcell"}],"output":{"name":"refcell"}}],[11,"default","","",73,{"inputs":[],"output":{"name":"refcell"}}],[11,"eq","","",73,{"inputs":[{"name":"refcell"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"deref","","",74,{"inputs":[{"name":"ref"}],"output":{"name":"t"}}],[11,"clone","","Copies a `Ref`.",74,{"inputs":[{"name":"ref"}],"output":{"name":"ref"}}],[11,"map","","Make a new `Ref` for a component of the borrowed data.",74,{"inputs":[{"name":"ref"},{"name":"f"}],"output":{"name":"ref"}}],[11,"filter_map","","Make a new `Ref` for an optional component of the borrowed data, e.g. an\nenum variant.",74,{"inputs":[{"name":"ref"},{"name":"f"}],"output":{"name":"option"}}],[11,"map","","Make a new `RefMut` for a component of the borrowed data, e.g. an enum\nvariant.",75,{"inputs":[{"name":"refmut"},{"name":"f"}],"output":{"name":"refmut"}}],[11,"filter_map","","Make a new `RefMut` for an optional component of the borrowed data, e.g.\nan enum variant.",75,{"inputs":[{"name":"refmut"},{"name":"f"}],"output":{"name":"option"}}],[11,"deref","","",75,{"inputs":[{"name":"refmut"}],"output":{"name":"t"}}],[11,"deref_mut","","",75,{"inputs":[{"name":"refmut"}],"output":{"name":"t"}}],[11,"new","","Constructs a new instance of `UnsafeCell` which will wrap the specified\nvalue.",76,{"inputs":[{"name":"t"}],"output":{"name":"unsafecell"}}],[11,"into_inner","","Unwraps the value.",76,{"inputs":[{"name":"unsafecell"}],"output":{"name":"t"}}],[11,"get","","Gets a mutable pointer to the wrapped value.",76,null],[0,"char","core","Character manipulation.",null,null],[3,"EscapeUnicode","core::char","Returns an iterator that yields the hexadecimal Unicode escape of a\ncharacter, as `char`s.",null,null],[3,"EscapeDefault","","An iterator that yields the literal escape code of a `char`.",null,null],[3,"EncodeUtf8","","An iterator over `u8` entries represending the UTF-8 encoding of a `char`\nvalue.",null,null],[3,"EncodeUtf16","","An iterator over `u16` entries represending the UTF-16 encoding of a `char`\nvalue.",null,null],[5,"from_u32","","Converts a `u32` to a `char`.",null,{"inputs":[{"name":"u32"}],"output":{"name":"option"}}],[5,"from_u32_unchecked","","Converts a `u32` to a `char`, ignoring validity.",null,{"inputs":[{"name":"u32"}],"output":{"name":"char"}}],[5,"from_digit","","Converts a digit in the given radix to a `char`.",null,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"option"}}],[17,"MAX","","The highest valid code point a `char` can have.",null,null],[11,"fmt","","",77,{"inputs":[{"name":"escapeunicode"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",77,{"inputs":[{"name":"escapeunicode"}],"output":{"name":"escapeunicode"}}],[11,"next","","",77,{"inputs":[{"name":"escapeunicode"}],"output":{"name":"option"}}],[11,"size_hint","","",77,null],[11,"fmt","","",78,{"inputs":[{"name":"escapedefault"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",78,{"inputs":[{"name":"escapedefault"}],"output":{"name":"escapedefault"}}],[11,"next","","",78,{"inputs":[{"name":"escapedefault"}],"output":{"name":"option"}}],[11,"size_hint","","",78,null],[11,"count","","",78,{"inputs":[{"name":"escapedefault"}],"output":{"name":"usize"}}],[11,"nth","","",78,{"inputs":[{"name":"escapedefault"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",78,{"inputs":[{"name":"escapedefault"}],"output":{"name":"option"}}],[11,"fmt","","",79,{"inputs":[{"name":"encodeutf8"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_slice","","Returns the remaining bytes of this iterator as a slice.",79,null],[11,"next","","",79,{"inputs":[{"name":"encodeutf8"}],"output":{"name":"option"}}],[11,"size_hint","","",79,null],[11,"fmt","","",80,{"inputs":[{"name":"encodeutf16"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_slice","","Returns the remaining bytes of this iterator as a slice.",80,null],[11,"next","","",80,{"inputs":[{"name":"encodeutf16"}],"output":{"name":"option"}}],[11,"size_hint","","",80,null],[0,"panicking","core","Panic support for libcore",null,null],[5,"panic","core::panicking","",null,null],[5,"panic_fmt","","",null,null],[0,"iter","core","Composable external iteration.",null,null],[3,"Rev","core::iter","An double-ended iterator with the direction inverted.",null,null],[3,"Cloned","","An iterator that clones the elements of an underlying iterator.",null,null],[3,"Cycle","","An iterator that repeats endlessly.",null,null],[3,"Chain","","An iterator that strings two iterators together.",null,null],[3,"Zip","","An iterator that iterates two other iterators simultaneously.",null,null],[3,"Map","","An iterator that maps the values of `iter` with `f`.",null,null],[3,"Filter","","An iterator that filters the elements of `iter` with `predicate`.",null,null],[3,"FilterMap","","An iterator that uses `f` to both filter and map elements from `iter`.",null,null],[3,"Enumerate","","An iterator that yields the current count and the element during iteration.",null,null],[3,"Peekable","","An iterator with a `peek()` that returns an optional reference to the next\nelement.",null,null],[3,"SkipWhile","","An iterator that rejects elements while `predicate` is true.",null,null],[3,"TakeWhile","","An iterator that only accepts elements while `predicate` is true.",null,null],[3,"Skip","","An iterator that skips over `n` elements of `iter`.",null,null],[3,"Take","","An iterator that only iterates over the first `n` iterations of `iter`.",null,null],[3,"Scan","","An iterator to maintain state while iterating another iterator.",null,null],[3,"FlatMap","","An iterator that maps each element to an iterator, and yields the elements\nof the produced iterators.",null,null],[3,"Fuse","","An iterator that yields `None` forever after the underlying iterator\nyields `None` once.",null,null],[3,"Inspect","","An iterator that calls a function with a reference to each element before\nyielding it.",null,null],[3,"StepBy","","An adapter for stepping range iterators by a custom amount.",null,null],[3,"Repeat","","An iterator that repeats an element endlessly.",null,null],[3,"Empty","","An iterator that yields nothing.",null,null],[3,"Once","","An iterator that yields an element exactly once.",null,null],[5,"repeat","","Creates a new iterator that endlessly repeats a single element.",null,{"inputs":[{"name":"t"}],"output":{"name":"repeat"}}],[5,"empty","","Creates an iterator that yields nothing.",null,{"inputs":[],"output":{"name":"empty"}}],[5,"once","","Creates an iterator that yields an element exactly once.",null,{"inputs":[{"name":"t"}],"output":{"name":"once"}}],[8,"Iterator","","An interface for dealing with iterators.",null,null],[16,"Item","","The type of the elements being iterated over.",81,null],[10,"next","","Advances the iterator and returns the next value.",81,{"inputs":[{"name":"iterator"}],"output":{"name":"option"}}],[11,"size_hint","","Returns the bounds on the remaining length of the iterator.",81,null],[11,"count","","Consumes the iterator, counting the number of iterations and returning it.",81,{"inputs":[{"name":"iterator"}],"output":{"name":"usize"}}],[11,"last","","Consumes the iterator, returning the last element.",81,{"inputs":[{"name":"iterator"}],"output":{"name":"option"}}],[11,"nth","","Consumes the `n` first elements of the iterator, then returns the\n`next()` one.",81,{"inputs":[{"name":"iterator"},{"name":"usize"}],"output":{"name":"option"}}],[11,"chain","","Takes two iterators and creates a new iterator over both in sequence.",81,{"inputs":[{"name":"iterator"},{"name":"u"}],"output":{"name":"chain"}}],[11,"zip","","&#39;Zips up&#39; two iterators into a single iterator of pairs.",81,{"inputs":[{"name":"iterator"},{"name":"u"}],"output":{"name":"zip"}}],[11,"map","","Takes a closure and creates an iterator which calls that closure on each\nelement.",81,{"inputs":[{"name":"iterator"},{"name":"f"}],"output":{"name":"map"}}],[11,"filter","","Creates an iterator which uses a closure to determine if an element\nshould be yielded.",81,{"inputs":[{"name":"iterator"},{"name":"p"}],"output":{"name":"filter"}}],[11,"filter_map","","Creates an iterator that both filters and maps.",81,{"inputs":[{"name":"iterator"},{"name":"f"}],"output":{"name":"filtermap"}}],[11,"enumerate","","Creates an iterator which gives the current iteration count as well as\nthe next value.",81,{"inputs":[{"name":"iterator"}],"output":{"name":"enumerate"}}],[11,"peekable","","Creates an iterator which can look at the `next()` element without\nconsuming it.",81,{"inputs":[{"name":"iterator"}],"output":{"name":"peekable"}}],[11,"skip_while","","Creates an iterator that [`skip()`]s elements based on a predicate.",81,{"inputs":[{"name":"iterator"},{"name":"p"}],"output":{"name":"skipwhile"}}],[11,"take_while","","Creates an iterator that yields elements based on a predicate.",81,{"inputs":[{"name":"iterator"},{"name":"p"}],"output":{"name":"takewhile"}}],[11,"skip","","Creates an iterator that skips the first `n` elements.",81,{"inputs":[{"name":"iterator"},{"name":"usize"}],"output":{"name":"skip"}}],[11,"take","","Creates an iterator that yields its first `n` elements.",81,{"inputs":[{"name":"iterator"},{"name":"usize"}],"output":{"name":"take"}}],[11,"scan","","An iterator adaptor similar to [`fold()`] that holds internal state and\nproduces a new iterator.",81,{"inputs":[{"name":"iterator"},{"name":"st"},{"name":"f"}],"output":{"name":"scan"}}],[11,"flat_map","","Creates an iterator that works like map, but flattens nested structure.",81,{"inputs":[{"name":"iterator"},{"name":"f"}],"output":{"name":"flatmap"}}],[11,"fuse","","Creates an iterator which ends after the first `None`.",81,{"inputs":[{"name":"iterator"}],"output":{"name":"fuse"}}],[11,"inspect","","Do something with each element of an iterator, passing the value on.",81,{"inputs":[{"name":"iterator"},{"name":"f"}],"output":{"name":"inspect"}}],[11,"by_ref","","Borrows an iterator, rather than consuming it.",81,{"inputs":[{"name":"iterator"}],"output":{"name":"self"}}],[11,"collect","","Transforms an iterator into a collection.",81,{"inputs":[{"name":"iterator"}],"output":{"name":"b"}}],[11,"partition","","Consumes an iterator, creating two collections from it.",81,null],[11,"fold","","An iterator adaptor that applies a function, producing a single, final value.",81,{"inputs":[{"name":"iterator"},{"name":"b"},{"name":"f"}],"output":{"name":"b"}}],[11,"all","","Tests if every element of the iterator matches a predicate.",81,{"inputs":[{"name":"iterator"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","Tests if any element of the iterator matches a predicate.",81,{"inputs":[{"name":"iterator"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","Searches for an element of an iterator that satisfies a predicate.",81,{"inputs":[{"name":"iterator"},{"name":"p"}],"output":{"name":"option"}}],[11,"position","","Searches for an element in an iterator, returning its index.",81,{"inputs":[{"name":"iterator"},{"name":"p"}],"output":{"name":"option"}}],[11,"rposition","","Searches for an element in an iterator from the right, returning its\nindex.",81,{"inputs":[{"name":"iterator"},{"name":"p"}],"output":{"name":"option"}}],[11,"max","","Returns the maximum element of an iterator.",81,{"inputs":[{"name":"iterator"}],"output":{"name":"option"}}],[11,"min","","Returns the minimum element of an iterator.",81,{"inputs":[{"name":"iterator"}],"output":{"name":"option"}}],[11,"max_by_key","","Returns the element that gives the maximum value from the\nspecified function.",81,{"inputs":[{"name":"iterator"},{"name":"f"}],"output":{"name":"option"}}],[11,"min_by_key","","Returns the element that gives the minimum value from the\nspecified function.",81,{"inputs":[{"name":"iterator"},{"name":"f"}],"output":{"name":"option"}}],[11,"rev","","Reverses an iterator&#39;s direction.",81,{"inputs":[{"name":"iterator"}],"output":{"name":"rev"}}],[11,"unzip","","Converts an iterator of pairs into a pair of containers.",81,null],[11,"cloned","","Creates an iterator which `clone()`s all of its elements.",81,{"inputs":[{"name":"iterator"}],"output":{"name":"cloned"}}],[11,"cycle","","Repeats an iterator endlessly.",81,{"inputs":[{"name":"iterator"}],"output":{"name":"cycle"}}],[11,"sum","","Sums the elements of an iterator.",81,{"inputs":[{"name":"iterator"}],"output":{"name":"s"}}],[11,"product","","Iterates over the entire iterator, multiplying all the elements",81,{"inputs":[{"name":"iterator"}],"output":{"name":"p"}}],[11,"cmp","","Lexicographically compares the elements of this `Iterator` with those\nof another.",81,{"inputs":[{"name":"iterator"},{"name":"i"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","Lexicographically compares the elements of this `Iterator` with those\nof another.",81,{"inputs":[{"name":"iterator"},{"name":"i"}],"output":{"name":"option"}}],[11,"eq","","Determines if the elements of this `Iterator` are equal to those of\nanother.",81,{"inputs":[{"name":"iterator"},{"name":"i"}],"output":{"name":"bool"}}],[11,"ne","","Determines if the elements of this `Iterator` are unequal to those of\nanother.",81,{"inputs":[{"name":"iterator"},{"name":"i"}],"output":{"name":"bool"}}],[11,"lt","","Determines if the elements of this `Iterator` are lexicographically\nless than those of another.",81,{"inputs":[{"name":"iterator"},{"name":"i"}],"output":{"name":"bool"}}],[11,"le","","Determines if the elements of this `Iterator` are lexicographically\nless or equal to those of another.",81,{"inputs":[{"name":"iterator"},{"name":"i"}],"output":{"name":"bool"}}],[11,"gt","","Determines if the elements of this `Iterator` are lexicographically\ngreater than those of another.",81,{"inputs":[{"name":"iterator"},{"name":"i"}],"output":{"name":"bool"}}],[11,"ge","","Determines if the elements of this `Iterator` are lexicographically\ngreater than or equal to those of another.",81,{"inputs":[{"name":"iterator"},{"name":"i"}],"output":{"name":"bool"}}],[8,"FromIterator","","Conversion from an `Iterator`.",null,null],[10,"from_iter","","Creates a value from an iterator.",82,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[8,"IntoIterator","","Conversion into an `Iterator`.",null,null],[16,"Item","","The type of the elements being iterated over.",83,null],[16,"IntoIter","","Which kind of iterator are we turning this into?",83,null],[10,"into_iter","","Creates an iterator from a value.",83,{"inputs":[{"name":"intoiterator"}],"output":{"name":"intoiter"}}],[8,"Extend","","Extend a collection with the contents of an iterator.",null,null],[10,"extend","","Extends a collection with the contents of an iterator.",84,{"inputs":[{"name":"extend"},{"name":"t"}],"output":null}],[8,"DoubleEndedIterator","","An iterator able to yield elements from both ends.",null,null],[10,"next_back","","An iterator able to yield elements from both ends.",85,{"inputs":[{"name":"doubleendediterator"}],"output":{"name":"option"}}],[8,"ExactSizeIterator","","An iterator that knows its exact length.",null,null],[11,"len","","Returns the exact number of times the iterator will iterate.",86,{"inputs":[{"name":"exactsizeiterator"}],"output":{"name":"usize"}}],[8,"Step","","Objects that can be stepped over in both directions.",null,null],[10,"step","","Steps `self` if possible.",87,{"inputs":[{"name":"step"},{"name":"self"}],"output":{"name":"option"}}],[10,"steps_between","","Returns the number of steps between two step objects. The count is\ninclusive of `start` and exclusive of `end`.",87,{"inputs":[{"name":"self"},{"name":"self"},{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",88,{"inputs":[{"name":"rev"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",88,{"inputs":[{"name":"rev"}],"output":{"name":"rev"}}],[11,"next","","",88,{"inputs":[{"name":"rev"}],"output":{"name":"option"}}],[11,"size_hint","","",88,null],[11,"next_back","","",88,{"inputs":[{"name":"rev"}],"output":{"name":"option"}}],[11,"fmt","","",89,{"inputs":[{"name":"cloned"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",89,{"inputs":[{"name":"cloned"}],"output":{"name":"cloned"}}],[11,"next","","",89,{"inputs":[{"name":"cloned"}],"output":{"name":"option"}}],[11,"size_hint","","",89,null],[11,"next_back","","",89,{"inputs":[{"name":"cloned"}],"output":{"name":"option"}}],[11,"fmt","","",90,{"inputs":[{"name":"cycle"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",90,{"inputs":[{"name":"cycle"}],"output":{"name":"cycle"}}],[11,"next","","",90,{"inputs":[{"name":"cycle"}],"output":{"name":"option"}}],[11,"size_hint","","",90,null],[11,"fmt","","",91,{"inputs":[{"name":"chain"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",91,{"inputs":[{"name":"chain"}],"output":{"name":"chain"}}],[11,"next","","",91,{"inputs":[{"name":"chain"}],"output":{"name":"option"}}],[11,"count","","",91,{"inputs":[{"name":"chain"}],"output":{"name":"usize"}}],[11,"nth","","",91,{"inputs":[{"name":"chain"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",91,{"inputs":[{"name":"chain"}],"output":{"name":"option"}}],[11,"size_hint","","",91,null],[11,"next_back","","",91,{"inputs":[{"name":"chain"}],"output":{"name":"option"}}],[11,"fmt","","",92,{"inputs":[{"name":"zip"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",92,{"inputs":[{"name":"zip"}],"output":{"name":"zip"}}],[11,"next","","",92,{"inputs":[{"name":"zip"}],"output":{"name":"option"}}],[11,"size_hint","","",92,null],[11,"next_back","","",92,{"inputs":[{"name":"zip"}],"output":{"name":"option"}}],[11,"clone","","",93,{"inputs":[{"name":"map"}],"output":{"name":"map"}}],[11,"fmt","","",93,{"inputs":[{"name":"map"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",93,{"inputs":[{"name":"map"}],"output":{"name":"option"}}],[11,"size_hint","","",93,null],[11,"next_back","","",93,{"inputs":[{"name":"map"}],"output":{"name":"option"}}],[11,"clone","","",94,{"inputs":[{"name":"filter"}],"output":{"name":"filter"}}],[11,"fmt","","",94,{"inputs":[{"name":"filter"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",94,{"inputs":[{"name":"filter"}],"output":{"name":"option"}}],[11,"size_hint","","",94,null],[11,"next_back","","",94,{"inputs":[{"name":"filter"}],"output":{"name":"option"}}],[11,"clone","","",95,{"inputs":[{"name":"filtermap"}],"output":{"name":"filtermap"}}],[11,"fmt","","",95,{"inputs":[{"name":"filtermap"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",95,{"inputs":[{"name":"filtermap"}],"output":{"name":"option"}}],[11,"size_hint","","",95,null],[11,"next_back","","",95,{"inputs":[{"name":"filtermap"}],"output":{"name":"option"}}],[11,"fmt","","",96,{"inputs":[{"name":"enumerate"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",96,{"inputs":[{"name":"enumerate"}],"output":{"name":"enumerate"}}],[11,"next","","# Overflow Behavior",96,{"inputs":[{"name":"enumerate"}],"output":{"name":"option"}}],[11,"size_hint","","",96,null],[11,"nth","","",96,{"inputs":[{"name":"enumerate"},{"name":"usize"}],"output":{"name":"option"}}],[11,"count","","",96,{"inputs":[{"name":"enumerate"}],"output":{"name":"usize"}}],[11,"next_back","","",96,{"inputs":[{"name":"enumerate"}],"output":{"name":"option"}}],[11,"fmt","","",97,{"inputs":[{"name":"peekable"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",97,{"inputs":[{"name":"peekable"}],"output":{"name":"peekable"}}],[11,"next","","",97,{"inputs":[{"name":"peekable"}],"output":{"name":"option"}}],[11,"count","","",97,{"inputs":[{"name":"peekable"}],"output":{"name":"usize"}}],[11,"nth","","",97,{"inputs":[{"name":"peekable"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",97,{"inputs":[{"name":"peekable"}],"output":{"name":"option"}}],[11,"size_hint","","",97,null],[11,"peek","","Returns a reference to the next() value without advancing the iterator.",97,{"inputs":[{"name":"peekable"}],"output":{"name":"option"}}],[11,"is_empty","","Checks if the iterator has finished iterating.",97,{"inputs":[{"name":"peekable"}],"output":{"name":"bool"}}],[11,"clone","","",98,{"inputs":[{"name":"skipwhile"}],"output":{"name":"skipwhile"}}],[11,"fmt","","",98,{"inputs":[{"name":"skipwhile"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",98,{"inputs":[{"name":"skipwhile"}],"output":{"name":"option"}}],[11,"size_hint","","",98,null],[11,"clone","","",99,{"inputs":[{"name":"takewhile"}],"output":{"name":"takewhile"}}],[11,"fmt","","",99,{"inputs":[{"name":"takewhile"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",99,{"inputs":[{"name":"takewhile"}],"output":{"name":"option"}}],[11,"size_hint","","",99,null],[11,"fmt","","",100,{"inputs":[{"name":"skip"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",100,{"inputs":[{"name":"skip"}],"output":{"name":"skip"}}],[11,"next","","",100,{"inputs":[{"name":"skip"}],"output":{"name":"option"}}],[11,"nth","","",100,{"inputs":[{"name":"skip"},{"name":"usize"}],"output":{"name":"option"}}],[11,"count","","",100,{"inputs":[{"name":"skip"}],"output":{"name":"usize"}}],[11,"last","","",100,{"inputs":[{"name":"skip"}],"output":{"name":"option"}}],[11,"size_hint","","",100,null],[11,"next_back","","",100,{"inputs":[{"name":"skip"}],"output":{"name":"option"}}],[11,"fmt","","",101,{"inputs":[{"name":"take"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",101,{"inputs":[{"name":"take"}],"output":{"name":"take"}}],[11,"next","","",101,{"inputs":[{"name":"take"}],"output":{"name":"option"}}],[11,"nth","","",101,{"inputs":[{"name":"take"},{"name":"usize"}],"output":{"name":"option"}}],[11,"size_hint","","",101,null],[11,"clone","","",102,{"inputs":[{"name":"scan"}],"output":{"name":"scan"}}],[11,"fmt","","",102,{"inputs":[{"name":"scan"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",102,{"inputs":[{"name":"scan"}],"output":{"name":"option"}}],[11,"size_hint","","",102,null],[11,"clone","","",103,{"inputs":[{"name":"flatmap"}],"output":{"name":"flatmap"}}],[11,"fmt","","",103,{"inputs":[{"name":"flatmap"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",103,{"inputs":[{"name":"flatmap"}],"output":{"name":"option"}}],[11,"size_hint","","",103,null],[11,"next_back","","",103,{"inputs":[{"name":"flatmap"}],"output":{"name":"option"}}],[11,"fmt","","",104,{"inputs":[{"name":"fuse"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",104,{"inputs":[{"name":"fuse"}],"output":{"name":"fuse"}}],[11,"next","","",104,{"inputs":[{"name":"fuse"}],"output":{"name":"option"}}],[11,"nth","","",104,{"inputs":[{"name":"fuse"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",104,{"inputs":[{"name":"fuse"}],"output":{"name":"option"}}],[11,"count","","",104,{"inputs":[{"name":"fuse"}],"output":{"name":"usize"}}],[11,"size_hint","","",104,null],[11,"next_back","","",104,{"inputs":[{"name":"fuse"}],"output":{"name":"option"}}],[11,"clone","","",105,{"inputs":[{"name":"inspect"}],"output":{"name":"inspect"}}],[11,"fmt","","",105,{"inputs":[{"name":"inspect"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",105,{"inputs":[{"name":"inspect"}],"output":{"name":"option"}}],[11,"size_hint","","",105,null],[11,"next_back","","",105,{"inputs":[{"name":"inspect"}],"output":{"name":"option"}}],[11,"fmt","","",106,{"inputs":[{"name":"stepby"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",106,{"inputs":[{"name":"stepby"}],"output":{"name":"stepby"}}],[11,"step_by","core::ops","Creates an iterator starting at the same point, but stepping by\nthe given amount at each iteration.",11,{"inputs":[{"name":"rangefrom"},{"name":"a"}],"output":{"name":"stepby"}}],[11,"step_by","","Creates an iterator with the same range, but stepping by the\ngiven amount at each iteration.",10,{"inputs":[{"name":"range"},{"name":"a"}],"output":{"name":"stepby"}}],[11,"step_by","","Creates an iterator with the same range, but stepping by the\ngiven amount at each iteration.",14,{"inputs":[{"name":"rangeinclusive"},{"name":"a"}],"output":{"name":"stepby"}}],[11,"next","core::iter","",106,{"inputs":[{"name":"stepby"}],"output":{"name":"option"}}],[11,"size_hint","","",106,null],[11,"next","","",106,{"inputs":[{"name":"stepby"}],"output":{"name":"option"}}],[11,"size_hint","","",106,null],[11,"next","","",106,{"inputs":[{"name":"stepby"}],"output":{"name":"option"}}],[11,"size_hint","","",106,null],[11,"next","core::ops","",10,{"inputs":[{"name":"range"}],"output":{"name":"option"}}],[11,"size_hint","","",10,null],[11,"next_back","","",10,{"inputs":[{"name":"range"}],"output":{"name":"option"}}],[11,"next","","",11,{"inputs":[{"name":"rangefrom"}],"output":{"name":"option"}}],[11,"next","","",14,{"inputs":[{"name":"rangeinclusive"}],"output":{"name":"option"}}],[11,"size_hint","","",14,null],[11,"next_back","","",14,{"inputs":[{"name":"rangeinclusive"}],"output":{"name":"option"}}],[11,"fmt","core::iter","",107,{"inputs":[{"name":"repeat"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",107,{"inputs":[{"name":"repeat"}],"output":{"name":"repeat"}}],[11,"next","","",107,{"inputs":[{"name":"repeat"}],"output":{"name":"option"}}],[11,"size_hint","","",107,null],[11,"next_back","","",107,{"inputs":[{"name":"repeat"}],"output":{"name":"option"}}],[11,"fmt","","",108,{"inputs":[{"name":"empty"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",108,{"inputs":[{"name":"empty"}],"output":{"name":"option"}}],[11,"size_hint","","",108,null],[11,"next_back","","",108,{"inputs":[{"name":"empty"}],"output":{"name":"option"}}],[11,"len","","",108,{"inputs":[{"name":"empty"}],"output":{"name":"usize"}}],[11,"clone","","",108,{"inputs":[{"name":"empty"}],"output":{"name":"empty"}}],[11,"default","","",108,{"inputs":[],"output":{"name":"empty"}}],[11,"fmt","","",109,{"inputs":[{"name":"once"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",109,{"inputs":[{"name":"once"}],"output":{"name":"once"}}],[11,"next","","",109,{"inputs":[{"name":"once"}],"output":{"name":"option"}}],[11,"size_hint","","",109,null],[11,"next_back","","",109,{"inputs":[{"name":"once"}],"output":{"name":"option"}}],[11,"len","","",109,{"inputs":[{"name":"once"}],"output":{"name":"usize"}}],[0,"option","core","Optional values.",null,null],[3,"Iter","core::option","An iterator over a reference of the contained item in an Option.",null,null],[3,"IterMut","","An iterator over a mutable reference of the contained item in an Option.",null,null],[3,"IntoIter","","An iterator over the item contained inside an Option.",null,null],[4,"Option","","The `Option` type. See [the module level documentation](index.html) for more.",null,null],[13,"None","","No value",110,null],[13,"Some","","Some value `T`",110,null],[11,"hash","","",110,null],[11,"fmt","","",110,{"inputs":[{"name":"option"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"cmp","","",110,{"inputs":[{"name":"option"},{"name":"option"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",110,{"inputs":[{"name":"option"},{"name":"option"}],"output":{"name":"option"}}],[11,"lt","","",110,{"inputs":[{"name":"option"},{"name":"option"}],"output":{"name":"bool"}}],[11,"le","","",110,{"inputs":[{"name":"option"},{"name":"option"}],"output":{"name":"bool"}}],[11,"gt","","",110,{"inputs":[{"name":"option"},{"name":"option"}],"output":{"name":"bool"}}],[11,"ge","","",110,{"inputs":[{"name":"option"},{"name":"option"}],"output":{"name":"bool"}}],[11,"eq","","",110,{"inputs":[{"name":"option"},{"name":"option"}],"output":{"name":"bool"}}],[11,"ne","","",110,{"inputs":[{"name":"option"},{"name":"option"}],"output":{"name":"bool"}}],[11,"clone","","",110,{"inputs":[{"name":"option"}],"output":{"name":"option"}}],[11,"is_some","","Returns `true` if the option is a `Some` value",110,{"inputs":[{"name":"option"}],"output":{"name":"bool"}}],[11,"is_none","","Returns `true` if the option is a `None` value",110,{"inputs":[{"name":"option"}],"output":{"name":"bool"}}],[11,"as_ref","","Converts from `Option&lt;T&gt;` to `Option&lt;&amp;T&gt;`",110,{"inputs":[{"name":"option"}],"output":{"name":"option"}}],[11,"as_mut","","Converts from `Option&lt;T&gt;` to `Option&lt;&amp;mut T&gt;`",110,{"inputs":[{"name":"option"}],"output":{"name":"option"}}],[11,"expect","","Unwraps an option, yielding the content of a `Some`.",110,{"inputs":[{"name":"option"},{"name":"str"}],"output":{"name":"t"}}],[11,"unwrap","","Moves the value `v` out of the `Option&lt;T&gt;` if it is `Some(v)`.",110,{"inputs":[{"name":"option"}],"output":{"name":"t"}}],[11,"unwrap_or","","Returns the contained value or a default.",110,{"inputs":[{"name":"option"},{"name":"t"}],"output":{"name":"t"}}],[11,"unwrap_or_else","","Returns the contained value or computes it from a closure.",110,{"inputs":[{"name":"option"},{"name":"f"}],"output":{"name":"t"}}],[11,"map","","Maps an `Option&lt;T&gt;` to `Option&lt;U&gt;` by applying a function to a contained value",110,{"inputs":[{"name":"option"},{"name":"f"}],"output":{"name":"option"}}],[11,"map_or","","Applies a function to the contained value (if any),\nor returns a `default` (if not).",110,{"inputs":[{"name":"option"},{"name":"u"},{"name":"f"}],"output":{"name":"u"}}],[11,"map_or_else","","Applies a function to the contained value (if any),\nor computes a `default` (if not).",110,{"inputs":[{"name":"option"},{"name":"d"},{"name":"f"}],"output":{"name":"u"}}],[11,"ok_or","","Transforms the `Option&lt;T&gt;` into a `Result&lt;T, E&gt;`, mapping `Some(v)` to\n`Ok(v)` and `None` to `Err(err)`.",110,{"inputs":[{"name":"option"},{"name":"e"}],"output":{"name":"result"}}],[11,"ok_or_else","","Transforms the `Option&lt;T&gt;` into a `Result&lt;T, E&gt;`, mapping `Some(v)` to\n`Ok(v)` and `None` to `Err(err())`.",110,{"inputs":[{"name":"option"},{"name":"f"}],"output":{"name":"result"}}],[11,"iter","","Returns an iterator over the possibly contained value.",110,{"inputs":[{"name":"option"}],"output":{"name":"iter"}}],[11,"iter_mut","","Returns a mutable iterator over the possibly contained value.",110,{"inputs":[{"name":"option"}],"output":{"name":"itermut"}}],[11,"and","","Returns `None` if the option is `None`, otherwise returns `optb`.",110,{"inputs":[{"name":"option"},{"name":"option"}],"output":{"name":"option"}}],[11,"and_then","","Returns `None` if the option is `None`, otherwise calls `f` with the\nwrapped value and returns the result.",110,{"inputs":[{"name":"option"},{"name":"f"}],"output":{"name":"option"}}],[11,"or","","Returns the option if it contains a value, otherwise returns `optb`.",110,{"inputs":[{"name":"option"},{"name":"option"}],"output":{"name":"option"}}],[11,"or_else","","Returns the option if it contains a value, otherwise calls `f` and\nreturns the result.",110,{"inputs":[{"name":"option"},{"name":"f"}],"output":{"name":"option"}}],[11,"take","","Takes the value out of the option, leaving a `None` in its place.",110,{"inputs":[{"name":"option"}],"output":{"name":"option"}}],[11,"cloned","","Maps an `Option&lt;&amp;T&gt;` to an `Option&lt;T&gt;` by cloning the contents of the\noption.",110,{"inputs":[{"name":"option"}],"output":{"name":"option"}}],[11,"unwrap_or_default","","Returns the contained value or a default",110,{"inputs":[{"name":"option"}],"output":{"name":"t"}}],[11,"default","","",110,{"inputs":[],"output":{"name":"option"}}],[11,"into_iter","","Returns a consuming iterator over the possibly contained value.",110,{"inputs":[{"name":"option"}],"output":{"name":"intoiter"}}],[11,"fmt","","",111,{"inputs":[{"name":"iter"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",111,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"size_hint","","",111,null],[11,"next_back","","",111,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"clone","","",111,{"inputs":[{"name":"iter"}],"output":{"name":"iter"}}],[11,"fmt","","",112,{"inputs":[{"name":"itermut"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",112,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"size_hint","","",112,null],[11,"next_back","","",112,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"fmt","","",113,{"inputs":[{"name":"intoiter"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",113,{"inputs":[{"name":"intoiter"}],"output":{"name":"intoiter"}}],[11,"next","","",113,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"size_hint","","",113,null],[11,"next_back","","",113,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"from_iter","","Takes each element in the `Iterator`: if it is `None`, no further\nelements are taken, and the `None` is returned. Should no `None` occur, a\ncontainer with the values of each `Option` is returned.",110,{"inputs":[{"name":"i"}],"output":{"name":"option"}}],[0,"raw","core","Contains struct definitions for the layout of compiler built-in types.",null,null],[3,"Slice","core::raw","The representation of a slice like `&amp;[T]`.",null,null],[12,"data","","",114,null],[12,"len","","",114,null],[3,"TraitObject","","The representation of a trait object like `&amp;SomeTrait`.",null,null],[12,"data","","",115,null],[12,"vtable","","",115,null],[8,"Repr","","This trait is meant to map equivalences between raw structs and their\ncorresponding rust values.",null,null],[11,"repr","","This function &quot;unwraps&quot; a rust value (without consuming it) into its raw\nstruct representation. This can be used to read/write different values\nfor the struct. This is a safe method because by default it does not\nenable write-access to the fields of the return value in safe code.",116,{"inputs":[{"name":"repr"}],"output":{"name":"t"}}],[11,"clone","","",114,{"inputs":[{"name":"slice"}],"output":{"name":"slice"}}],[11,"clone","","",115,{"inputs":[{"name":"traitobject"}],"output":{"name":"traitobject"}}],[0,"result","core","Error handling with the `Result` type.",null,null],[3,"Iter","core::result","An iterator over a reference to the `Ok` variant of a `Result`.",null,null],[3,"IterMut","","An iterator over a mutable reference to the `Ok` variant of a `Result`.",null,null],[3,"IntoIter","","An iterator over the value in a `Ok` variant of a `Result`.",null,null],[4,"Result","","`Result` is a type that represents either success (`Ok`) or failure (`Err`).",null,null],[13,"Ok","","Contains the success value",117,null],[13,"Err","","Contains the error value",117,null],[11,"hash","","",117,null],[11,"fmt","","",117,{"inputs":[{"name":"result"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"cmp","","",117,{"inputs":[{"name":"result"},{"name":"result"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",117,{"inputs":[{"name":"result"},{"name":"result"}],"output":{"name":"option"}}],[11,"lt","","",117,{"inputs":[{"name":"result"},{"name":"result"}],"output":{"name":"bool"}}],[11,"le","","",117,{"inputs":[{"name":"result"},{"name":"result"}],"output":{"name":"bool"}}],[11,"gt","","",117,{"inputs":[{"name":"result"},{"name":"result"}],"output":{"name":"bool"}}],[11,"ge","","",117,{"inputs":[{"name":"result"},{"name":"result"}],"output":{"name":"bool"}}],[11,"eq","","",117,{"inputs":[{"name":"result"},{"name":"result"}],"output":{"name":"bool"}}],[11,"ne","","",117,{"inputs":[{"name":"result"},{"name":"result"}],"output":{"name":"bool"}}],[11,"clone","","",117,{"inputs":[{"name":"result"}],"output":{"name":"result"}}],[11,"is_ok","","Returns true if the result is `Ok`",117,{"inputs":[{"name":"result"}],"output":{"name":"bool"}}],[11,"is_err","","Returns true if the result is `Err`",117,{"inputs":[{"name":"result"}],"output":{"name":"bool"}}],[11,"ok","","Converts from `Result&lt;T, E&gt;` to `Option&lt;T&gt;`",117,{"inputs":[{"name":"result"}],"output":{"name":"option"}}],[11,"err","","Converts from `Result&lt;T, E&gt;` to `Option&lt;E&gt;`",117,{"inputs":[{"name":"result"}],"output":{"name":"option"}}],[11,"as_ref","","Converts from `Result&lt;T, E&gt;` to `Result&lt;&amp;T, &amp;E&gt;`",117,{"inputs":[{"name":"result"}],"output":{"name":"result"}}],[11,"as_mut","","Converts from `Result&lt;T, E&gt;` to `Result&lt;&amp;mut T, &amp;mut E&gt;`",117,{"inputs":[{"name":"result"}],"output":{"name":"result"}}],[11,"map","","Maps a `Result&lt;T, E&gt;` to `Result&lt;U, E&gt;` by applying a function to a\ncontained `Ok` value, leaving an `Err` value untouched.",117,{"inputs":[{"name":"result"},{"name":"f"}],"output":{"name":"result"}}],[11,"map_err","","Maps a `Result&lt;T, E&gt;` to `Result&lt;T, F&gt;` by applying a function to a\ncontained `Err` value, leaving an `Ok` value untouched.",117,{"inputs":[{"name":"result"},{"name":"o"}],"output":{"name":"result"}}],[11,"iter","","Returns an iterator over the possibly contained value.",117,{"inputs":[{"name":"result"}],"output":{"name":"iter"}}],[11,"iter_mut","","Returns a mutable iterator over the possibly contained value.",117,{"inputs":[{"name":"result"}],"output":{"name":"itermut"}}],[11,"and","","Returns `res` if the result is `Ok`, otherwise returns the `Err` value of `self`.",117,{"inputs":[{"name":"result"},{"name":"result"}],"output":{"name":"result"}}],[11,"and_then","","Calls `op` if the result is `Ok`, otherwise returns the `Err` value of `self`.",117,{"inputs":[{"name":"result"},{"name":"f"}],"output":{"name":"result"}}],[11,"or","","Returns `res` if the result is `Err`, otherwise returns the `Ok` value of `self`.",117,{"inputs":[{"name":"result"},{"name":"result"}],"output":{"name":"result"}}],[11,"or_else","","Calls `op` if the result is `Err`, otherwise returns the `Ok` value of `self`.",117,{"inputs":[{"name":"result"},{"name":"o"}],"output":{"name":"result"}}],[11,"unwrap_or","","Unwraps a result, yielding the content of an `Ok`.\nElse it returns `optb`.",117,{"inputs":[{"name":"result"},{"name":"t"}],"output":{"name":"t"}}],[11,"unwrap_or_else","","Unwraps a result, yielding the content of an `Ok`.\nIf the value is an `Err` then it calls `op` with its value.",117,{"inputs":[{"name":"result"},{"name":"f"}],"output":{"name":"t"}}],[11,"unwrap","","Unwraps a result, yielding the content of an `Ok`.",117,{"inputs":[{"name":"result"}],"output":{"name":"t"}}],[11,"expect","","Unwraps a result, yielding the content of an `Ok`.",117,{"inputs":[{"name":"result"},{"name":"str"}],"output":{"name":"t"}}],[11,"unwrap_err","","Unwraps a result, yielding the content of an `Err`.",117,{"inputs":[{"name":"result"}],"output":{"name":"e"}}],[11,"into_iter","","Returns a consuming iterator over the possibly contained value.",117,{"inputs":[{"name":"result"}],"output":{"name":"intoiter"}}],[11,"fmt","","",118,{"inputs":[{"name":"iter"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",118,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"size_hint","","",118,null],[11,"next_back","","",118,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"clone","","",118,{"inputs":[{"name":"iter"}],"output":{"name":"iter"}}],[11,"fmt","","",119,{"inputs":[{"name":"itermut"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",119,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"size_hint","","",119,null],[11,"next_back","","",119,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"fmt","","",120,{"inputs":[{"name":"intoiter"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",120,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"size_hint","","",120,null],[11,"next_back","","",120,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"from_iter","","Takes each element in the `Iterator`: if it is an `Err`, no further\nelements are taken, and the `Err` is returned. Should no `Err` occur, a\ncontainer with the values of each `Result` is returned.",117,{"inputs":[{"name":"i"}],"output":{"name":"result"}}],[0,"slice","core","Slice management and manipulation",null,null],[3,"Iter","core::slice","Immutable slice iterator",null,null],[3,"IterMut","","Mutable slice iterator.",null,null],[3,"Split","","An iterator over subslices separated by elements that match a predicate\nfunction.",null,null],[3,"SplitMut","","An iterator over the subslices of the vector which are separated\nby elements that match `pred`.",null,null],[3,"SplitN","","An iterator over subslices separated by elements that match a predicate\nfunction, limited to a given number of splits.",null,null],[3,"RSplitN","","An iterator over subslices separated by elements that match a\npredicate function, limited to a given number of splits, starting\nfrom the end of the slice.",null,null],[3,"SplitNMut","","An iterator over subslices separated by elements that match a predicate\nfunction, limited to a given number of splits.",null,null],[3,"RSplitNMut","","An iterator over subslices separated by elements that match a\npredicate function, limited to a given number of splits, starting\nfrom the end of the slice.",null,null],[3,"Windows","","An iterator over overlapping subslices of length `size`.",null,null],[3,"Chunks","","An iterator over a slice in (non-overlapping) chunks (`size` elements at a\ntime).",null,null],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`size`\nelements at a time). When the slice len is not evenly divided by the chunk\nsize, the last slice of the iteration will be the remainder.",null,null],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",null,null],[5,"from_raw_parts_mut","","Performs the same functionality as `from_raw_parts`, except that a mutable\nslice is returned.",null,null],[8,"SliceExt","","Extension methods for slices.",null,null],[16,"Item","","",121,null],[10,"split_at","","",121,null],[10,"iter","","",121,{"inputs":[{"name":"sliceext"}],"output":{"name":"iter"}}],[10,"split","","",121,{"inputs":[{"name":"sliceext"},{"name":"p"}],"output":{"name":"split"}}],[10,"splitn","","",121,{"inputs":[{"name":"sliceext"},{"name":"usize"},{"name":"p"}],"output":{"name":"splitn"}}],[10,"rsplitn","","",121,{"inputs":[{"name":"sliceext"},{"name":"usize"},{"name":"p"}],"output":{"name":"rsplitn"}}],[10,"windows","","",121,{"inputs":[{"name":"sliceext"},{"name":"usize"}],"output":{"name":"windows"}}],[10,"chunks","","",121,{"inputs":[{"name":"sliceext"},{"name":"usize"}],"output":{"name":"chunks"}}],[10,"get","","",121,{"inputs":[{"name":"sliceext"},{"name":"usize"}],"output":{"name":"option"}}],[10,"first","","",121,{"inputs":[{"name":"sliceext"}],"output":{"name":"option"}}],[10,"split_first","","",121,{"inputs":[{"name":"sliceext"}],"output":{"name":"option"}}],[10,"split_last","","",121,{"inputs":[{"name":"sliceext"}],"output":{"name":"option"}}],[10,"last","","",121,{"inputs":[{"name":"sliceext"}],"output":{"name":"option"}}],[10,"get_unchecked","","",121,{"inputs":[{"name":"sliceext"},{"name":"usize"}],"output":{"name":"item"}}],[10,"as_ptr","","",121,null],[10,"binary_search","","",121,{"inputs":[{"name":"sliceext"},{"name":"item"}],"output":{"name":"result"}}],[10,"binary_search_by","","",121,{"inputs":[{"name":"sliceext"},{"name":"f"}],"output":{"name":"result"}}],[10,"len","","",121,{"inputs":[{"name":"sliceext"}],"output":{"name":"usize"}}],[11,"is_empty","","",121,{"inputs":[{"name":"sliceext"}],"output":{"name":"bool"}}],[10,"get_mut","","",121,{"inputs":[{"name":"sliceext"},{"name":"usize"}],"output":{"name":"option"}}],[10,"iter_mut","","",121,{"inputs":[{"name":"sliceext"}],"output":{"name":"itermut"}}],[10,"first_mut","","",121,{"inputs":[{"name":"sliceext"}],"output":{"name":"option"}}],[10,"split_first_mut","","",121,{"inputs":[{"name":"sliceext"}],"output":{"name":"option"}}],[10,"split_last_mut","","",121,{"inputs":[{"name":"sliceext"}],"output":{"name":"option"}}],[10,"last_mut","","",121,{"inputs":[{"name":"sliceext"}],"output":{"name":"option"}}],[10,"split_mut","","",121,{"inputs":[{"name":"sliceext"},{"name":"p"}],"output":{"name":"splitmut"}}],[10,"splitn_mut","","",121,{"inputs":[{"name":"sliceext"},{"name":"usize"},{"name":"p"}],"output":{"name":"splitnmut"}}],[10,"rsplitn_mut","","",121,{"inputs":[{"name":"sliceext"},{"name":"usize"},{"name":"p"}],"output":{"name":"rsplitnmut"}}],[10,"chunks_mut","","",121,{"inputs":[{"name":"sliceext"},{"name":"usize"}],"output":{"name":"chunksmut"}}],[10,"swap","","",121,{"inputs":[{"name":"sliceext"},{"name":"usize"},{"name":"usize"}],"output":null}],[10,"split_at_mut","","",121,null],[10,"reverse","","",121,{"inputs":[{"name":"sliceext"}],"output":null}],[10,"get_unchecked_mut","","",121,{"inputs":[{"name":"sliceext"},{"name":"usize"}],"output":{"name":"item"}}],[10,"as_mut_ptr","","",121,null],[10,"contains","","",121,{"inputs":[{"name":"sliceext"},{"name":"item"}],"output":{"name":"bool"}}],[10,"starts_with","","",121,null],[10,"ends_with","","",121,null],[10,"clone_from_slice","","",121,null],[10,"copy_from_slice","","",121,null],[11,"fmt","","",122,{"inputs":[{"name":"iter"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_slice","","View the underlying data as a subslice of the original data.",122,null],[11,"next","","",122,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"size_hint","","",122,null],[11,"count","","",122,{"inputs":[{"name":"iter"}],"output":{"name":"usize"}}],[11,"nth","","",122,{"inputs":[{"name":"iter"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",122,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"next_back","","",122,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"clone","","",122,{"inputs":[{"name":"iter"}],"output":{"name":"iter"}}],[11,"fmt","","",123,{"inputs":[{"name":"itermut"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"into_slice","","View the underlying data as a subslice of the original data.",123,null],[11,"next","","",123,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"size_hint","","",123,null],[11,"count","","",123,{"inputs":[{"name":"itermut"}],"output":{"name":"usize"}}],[11,"nth","","",123,{"inputs":[{"name":"itermut"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",123,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"next_back","","",123,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"fmt","","",124,{"inputs":[{"name":"split"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",124,{"inputs":[{"name":"split"}],"output":{"name":"split"}}],[11,"next","","",124,{"inputs":[{"name":"split"}],"output":{"name":"option"}}],[11,"size_hint","","",124,null],[11,"next_back","","",124,{"inputs":[{"name":"split"}],"output":{"name":"option"}}],[11,"fmt","","",125,{"inputs":[{"name":"splitmut"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",125,{"inputs":[{"name":"splitmut"}],"output":{"name":"option"}}],[11,"size_hint","","",125,null],[11,"next_back","","",125,{"inputs":[{"name":"splitmut"}],"output":{"name":"option"}}],[11,"fmt","","",126,{"inputs":[{"name":"splitn"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",127,{"inputs":[{"name":"rsplitn"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",128,{"inputs":[{"name":"splitnmut"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",129,{"inputs":[{"name":"rsplitnmut"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",126,{"inputs":[{"name":"splitn"}],"output":{"name":"option"}}],[11,"size_hint","","",126,null],[11,"next","","",127,{"inputs":[{"name":"rsplitn"}],"output":{"name":"option"}}],[11,"size_hint","","",127,null],[11,"next","","",128,{"inputs":[{"name":"splitnmut"}],"output":{"name":"option"}}],[11,"size_hint","","",128,null],[11,"next","","",129,{"inputs":[{"name":"rsplitnmut"}],"output":{"name":"option"}}],[11,"size_hint","","",129,null],[11,"fmt","","",130,{"inputs":[{"name":"windows"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",130,{"inputs":[{"name":"windows"}],"output":{"name":"windows"}}],[11,"next","","",130,{"inputs":[{"name":"windows"}],"output":{"name":"option"}}],[11,"size_hint","","",130,null],[11,"count","","",130,{"inputs":[{"name":"windows"}],"output":{"name":"usize"}}],[11,"nth","","",130,{"inputs":[{"name":"windows"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",130,{"inputs":[{"name":"windows"}],"output":{"name":"option"}}],[11,"next_back","","",130,{"inputs":[{"name":"windows"}],"output":{"name":"option"}}],[11,"fmt","","",131,{"inputs":[{"name":"chunks"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",131,{"inputs":[{"name":"chunks"}],"output":{"name":"chunks"}}],[11,"next","","",131,{"inputs":[{"name":"chunks"}],"output":{"name":"option"}}],[11,"size_hint","","",131,null],[11,"count","","",131,{"inputs":[{"name":"chunks"}],"output":{"name":"usize"}}],[11,"nth","","",131,{"inputs":[{"name":"chunks"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",131,{"inputs":[{"name":"chunks"}],"output":{"name":"option"}}],[11,"next_back","","",131,{"inputs":[{"name":"chunks"}],"output":{"name":"option"}}],[11,"fmt","","",132,{"inputs":[{"name":"chunksmut"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",132,{"inputs":[{"name":"chunksmut"}],"output":{"name":"option"}}],[11,"size_hint","","",132,null],[11,"count","","",132,{"inputs":[{"name":"chunksmut"}],"output":{"name":"usize"}}],[11,"nth","","",132,{"inputs":[{"name":"chunksmut"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",132,{"inputs":[{"name":"chunksmut"}],"output":{"name":"option"}}],[11,"next_back","","",132,{"inputs":[{"name":"chunksmut"}],"output":{"name":"option"}}],[0,"str","core","String manipulation",null,null],[3,"ParseBoolError","core::str","An error returned when parsing a `bool` from a string fails.",null,null],[3,"Utf8Error","","Errors which can occur when attempting to interpret a sequence of `u8`\nas a string.",null,null],[3,"Chars","","Iterator for the char (representing *Unicode Scalar Values*) of a string",null,null],[3,"CharIndices","","Iterator for a string&#39;s characters and their byte offsets.",null,null],[3,"Bytes","","External iterator for a string&#39;s bytes.\nUse with the `std::iter` module.",null,null],[3,"Split","","Created with the method [`split()`].",null,null],[3,"RSplit","","Created with the method [`rsplit()`].",null,null],[3,"SplitTerminator","","Created with the method [`split_terminator()`].",null,null],[3,"RSplitTerminator","","Created with the method [`rsplit_terminator()`].",null,null],[3,"SplitN","","Created with the method [`splitn()`].",null,null],[3,"RSplitN","","Created with the method [`rsplitn()`].",null,null],[3,"MatchIndices","","Created with the method [`match_indices()`].",null,null],[3,"RMatchIndices","","Created with the method [`rmatch_indices()`].",null,null],[3,"Matches","","Created with the method [`matches()`].",null,null],[3,"RMatches","","Created with the method [`rmatches()`].",null,null],[3,"Lines","","Created with the method [`lines()`].",null,null],[3,"LinesAny","","Created with the method [`lines_any()`].",null,null],[3,"CharRange","","Struct that contains a `char` and the index of the first byte of\nthe next `char` in a string.  This can be used as a data structure\nfor iterating over the UTF-8 bytes of a string.",null,null],[12,"ch","","Current `char`",133,null],[12,"next","","Index of the first byte of the next `char`",133,null],[5,"from_utf8","","Converts a slice of bytes to a string slice.",null,null],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without checking\nthat the string contains valid UTF-8.",null,null],[5,"next_code_point","","Reads the next code point out of a byte iterator (assuming a\nUTF-8-like encoding).",null,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[0,"pattern","","The string Pattern API.",null,null],[3,"CharSearcher","core::str::pattern","Associated type for `&lt;char as Pattern&lt;&#39;a&gt;&gt;::Searcher`.",null,null],[3,"CharSliceSearcher","","Associated type for `&lt;&amp;[char] as Pattern&lt;&#39;a&gt;&gt;::Searcher`.",null,null],[3,"CharPredicateSearcher","","Associated type for `&lt;F as Pattern&lt;&#39;a&gt;&gt;::Searcher`.",null,null],[3,"StrSearcher","","Associated type for `&lt;&amp;str as Pattern&lt;&#39;a&gt;&gt;::Searcher`.",null,null],[4,"SearchStep","","Result of calling `Searcher::next()` or `ReverseSearcher::next_back()`.",null,null],[13,"Match","","Expresses that a match of the pattern has been found at\n`haystack[a..b]`.",134,null],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a possible match\nof the pattern.",134,null],[13,"Done","","Expresses that every byte of the haystack has been visted, ending\nthe iteration.",134,null],[8,"Pattern","","A string pattern.",null,null],[16,"Searcher","","Associated searcher for this pattern",135,null],[10,"into_searcher","","Constructs the associated searcher from\n`self` and the `haystack` to search in.",135,{"inputs":[{"name":"pattern"},{"name":"str"}],"output":{"name":"searcher"}}],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",135,{"inputs":[{"name":"pattern"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",135,{"inputs":[{"name":"pattern"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",135,{"inputs":[{"name":"pattern"},{"name":"str"}],"output":{"name":"bool"}}],[8,"Searcher","","A searcher for a string pattern.",null,null],[10,"haystack","","Getter for the underlaying string to be searched in",136,{"inputs":[{"name":"searcher"}],"output":{"name":"str"}}],[10,"next","","Performs the next search step starting from the front.",136,{"inputs":[{"name":"searcher"}],"output":{"name":"searchstep"}}],[11,"next_match","","Find the next `Match` result. See `next()`",136,{"inputs":[{"name":"searcher"}],"output":{"name":"option"}}],[11,"next_reject","","Find the next `Reject` result. See `next()`",136,{"inputs":[{"name":"searcher"}],"output":{"name":"option"}}],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",null,null],[10,"next_back","","Performs the next search step starting from the back.",137,{"inputs":[{"name":"reversesearcher"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","Find the next `Match` result. See `next_back()`",137,{"inputs":[{"name":"reversesearcher"}],"output":{"name":"option"}}],[11,"next_reject_back","","Find the next `Reject` result. See `next_back()`",137,{"inputs":[{"name":"reversesearcher"}],"output":{"name":"option"}}],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher`\ncan be used for a `DoubleEndedIterator` implementation.",null,null],[11,"fmt","","",134,{"inputs":[{"name":"searchstep"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",134,{"inputs":[{"name":"searchstep"},{"name":"searchstep"}],"output":{"name":"bool"}}],[11,"ne","","",134,{"inputs":[{"name":"searchstep"},{"name":"searchstep"}],"output":{"name":"bool"}}],[11,"clone","","",134,{"inputs":[{"name":"searchstep"}],"output":{"name":"searchstep"}}],[11,"fmt","","",138,{"inputs":[{"name":"charsearcher"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",138,{"inputs":[{"name":"charsearcher"}],"output":{"name":"charsearcher"}}],[11,"haystack","","",138,{"inputs":[{"name":"charsearcher"}],"output":{"name":"str"}}],[11,"next","","",138,{"inputs":[{"name":"charsearcher"}],"output":{"name":"searchstep"}}],[11,"next_match","","",138,{"inputs":[{"name":"charsearcher"}],"output":{"name":"option"}}],[11,"next_reject","","",138,{"inputs":[{"name":"charsearcher"}],"output":{"name":"option"}}],[11,"next_back","","",138,{"inputs":[{"name":"charsearcher"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",138,{"inputs":[{"name":"charsearcher"}],"output":{"name":"option"}}],[11,"next_reject_back","","",138,{"inputs":[{"name":"charsearcher"}],"output":{"name":"option"}}],[11,"fmt","","",139,{"inputs":[{"name":"charslicesearcher"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",139,{"inputs":[{"name":"charslicesearcher"}],"output":{"name":"charslicesearcher"}}],[11,"haystack","","",139,{"inputs":[{"name":"charslicesearcher"}],"output":{"name":"str"}}],[11,"next","","",139,{"inputs":[{"name":"charslicesearcher"}],"output":{"name":"searchstep"}}],[11,"next_match","","",139,{"inputs":[{"name":"charslicesearcher"}],"output":{"name":"option"}}],[11,"next_reject","","",139,{"inputs":[{"name":"charslicesearcher"}],"output":{"name":"option"}}],[11,"next_back","","",139,{"inputs":[{"name":"charslicesearcher"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",139,{"inputs":[{"name":"charslicesearcher"}],"output":{"name":"option"}}],[11,"next_reject_back","","",139,{"inputs":[{"name":"charslicesearcher"}],"output":{"name":"option"}}],[11,"clone","","",140,{"inputs":[{"name":"charpredicatesearcher"}],"output":{"name":"charpredicatesearcher"}}],[11,"fmt","","",140,{"inputs":[{"name":"charpredicatesearcher"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"haystack","","",140,{"inputs":[{"name":"charpredicatesearcher"}],"output":{"name":"str"}}],[11,"next","","",140,{"inputs":[{"name":"charpredicatesearcher"}],"output":{"name":"searchstep"}}],[11,"next_match","","",140,{"inputs":[{"name":"charpredicatesearcher"}],"output":{"name":"option"}}],[11,"next_reject","","",140,{"inputs":[{"name":"charpredicatesearcher"}],"output":{"name":"option"}}],[11,"next_back","","",140,{"inputs":[{"name":"charpredicatesearcher"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",140,{"inputs":[{"name":"charpredicatesearcher"}],"output":{"name":"option"}}],[11,"next_reject_back","","",140,{"inputs":[{"name":"charpredicatesearcher"}],"output":{"name":"option"}}],[11,"fmt","","",141,{"inputs":[{"name":"strsearcher"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",141,{"inputs":[{"name":"strsearcher"}],"output":{"name":"strsearcher"}}],[11,"haystack","","",141,{"inputs":[{"name":"strsearcher"}],"output":{"name":"str"}}],[11,"next","","",141,{"inputs":[{"name":"strsearcher"}],"output":{"name":"searchstep"}}],[11,"next_match","","",141,{"inputs":[{"name":"strsearcher"}],"output":{"name":"option"}}],[11,"next_back","","",141,{"inputs":[{"name":"strsearcher"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",141,{"inputs":[{"name":"strsearcher"}],"output":{"name":"option"}}],[8,"FromStr","core::str","A trait to abstract the idea of creating a new instance of a type from a\nstring.",null,null],[16,"Err","","The associated error which can be returned from parsing.",142,null],[10,"from_str","","Parses a string `s` to return a value of this type.",142,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"eq","","",143,{"inputs":[{"name":"parseboolerror"},{"name":"parseboolerror"}],"output":{"name":"bool"}}],[11,"ne","","",143,{"inputs":[{"name":"parseboolerror"},{"name":"parseboolerror"}],"output":{"name":"bool"}}],[11,"clone","","",143,{"inputs":[{"name":"parseboolerror"}],"output":{"name":"parseboolerror"}}],[11,"fmt","","",143,{"inputs":[{"name":"parseboolerror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",143,{"inputs":[{"name":"parseboolerror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",144,{"inputs":[{"name":"utf8error"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",144,{"inputs":[{"name":"utf8error"}],"output":{"name":"utf8error"}}],[11,"eq","","",144,{"inputs":[{"name":"utf8error"},{"name":"utf8error"}],"output":{"name":"bool"}}],[11,"ne","","",144,{"inputs":[{"name":"utf8error"},{"name":"utf8error"}],"output":{"name":"bool"}}],[11,"valid_up_to","","Returns the index in the given string up to which valid UTF-8 was\nverified.",144,{"inputs":[{"name":"utf8error"}],"output":{"name":"usize"}}],[11,"fmt","","",144,{"inputs":[{"name":"utf8error"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",145,{"inputs":[{"name":"chars"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",145,{"inputs":[{"name":"chars"}],"output":{"name":"chars"}}],[11,"next","","",145,{"inputs":[{"name":"chars"}],"output":{"name":"option"}}],[11,"size_hint","","",145,null],[11,"next_back","","",145,{"inputs":[{"name":"chars"}],"output":{"name":"option"}}],[11,"as_str","","View the underlying data as a subslice of the original data.",145,{"inputs":[{"name":"chars"}],"output":{"name":"str"}}],[11,"fmt","","",146,{"inputs":[{"name":"charindices"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",146,{"inputs":[{"name":"charindices"}],"output":{"name":"charindices"}}],[11,"next","","",146,{"inputs":[{"name":"charindices"}],"output":{"name":"option"}}],[11,"size_hint","","",146,null],[11,"next_back","","",146,{"inputs":[{"name":"charindices"}],"output":{"name":"option"}}],[11,"as_str","","View the underlying data as a subslice of the original data.",146,{"inputs":[{"name":"charindices"}],"output":{"name":"str"}}],[11,"fmt","","",147,{"inputs":[{"name":"bytes"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",147,{"inputs":[{"name":"bytes"}],"output":{"name":"bytes"}}],[11,"next","","",147,{"inputs":[{"name":"bytes"}],"output":{"name":"option"}}],[11,"size_hint","","",147,null],[11,"count","","",147,{"inputs":[{"name":"bytes"}],"output":{"name":"usize"}}],[11,"last","","",147,{"inputs":[{"name":"bytes"}],"output":{"name":"option"}}],[11,"nth","","",147,{"inputs":[{"name":"bytes"},{"name":"usize"}],"output":{"name":"option"}}],[11,"next_back","","",147,{"inputs":[{"name":"bytes"}],"output":{"name":"option"}}],[11,"len","","",147,{"inputs":[{"name":"bytes"}],"output":{"name":"usize"}}],[11,"fmt","","",148,{"inputs":[{"name":"split"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",148,{"inputs":[{"name":"split"}],"output":{"name":"option"}}],[11,"clone","","",148,{"inputs":[{"name":"split"}],"output":{"name":"self"}}],[11,"fmt","","",149,{"inputs":[{"name":"rsplit"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",149,{"inputs":[{"name":"rsplit"}],"output":{"name":"option"}}],[11,"clone","","",149,{"inputs":[{"name":"rsplit"}],"output":{"name":"self"}}],[11,"next_back","","",148,{"inputs":[{"name":"split"}],"output":{"name":"option"}}],[11,"next_back","","",149,{"inputs":[{"name":"rsplit"}],"output":{"name":"option"}}],[11,"fmt","","",150,{"inputs":[{"name":"splitterminator"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",150,{"inputs":[{"name":"splitterminator"}],"output":{"name":"option"}}],[11,"clone","","",150,{"inputs":[{"name":"splitterminator"}],"output":{"name":"self"}}],[11,"fmt","","",151,{"inputs":[{"name":"rsplitterminator"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",151,{"inputs":[{"name":"rsplitterminator"}],"output":{"name":"option"}}],[11,"clone","","",151,{"inputs":[{"name":"rsplitterminator"}],"output":{"name":"self"}}],[11,"next_back","","",150,{"inputs":[{"name":"splitterminator"}],"output":{"name":"option"}}],[11,"next_back","","",151,{"inputs":[{"name":"rsplitterminator"}],"output":{"name":"option"}}],[11,"fmt","","",152,{"inputs":[{"name":"splitn"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",152,{"inputs":[{"name":"splitn"}],"output":{"name":"option"}}],[11,"clone","","",152,{"inputs":[{"name":"splitn"}],"output":{"name":"self"}}],[11,"fmt","","",153,{"inputs":[{"name":"rsplitn"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",153,{"inputs":[{"name":"rsplitn"}],"output":{"name":"option"}}],[11,"clone","","",153,{"inputs":[{"name":"rsplitn"}],"output":{"name":"self"}}],[11,"fmt","","",154,{"inputs":[{"name":"matchindices"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",154,{"inputs":[{"name":"matchindices"}],"output":{"name":"option"}}],[11,"clone","","",154,{"inputs":[{"name":"matchindices"}],"output":{"name":"self"}}],[11,"fmt","","",155,{"inputs":[{"name":"rmatchindices"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",155,{"inputs":[{"name":"rmatchindices"}],"output":{"name":"option"}}],[11,"clone","","",155,{"inputs":[{"name":"rmatchindices"}],"output":{"name":"self"}}],[11,"next_back","","",154,{"inputs":[{"name":"matchindices"}],"output":{"name":"option"}}],[11,"next_back","","",155,{"inputs":[{"name":"rmatchindices"}],"output":{"name":"option"}}],[11,"fmt","","",156,{"inputs":[{"name":"matches"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",156,{"inputs":[{"name":"matches"}],"output":{"name":"option"}}],[11,"clone","","",156,{"inputs":[{"name":"matches"}],"output":{"name":"self"}}],[11,"fmt","","",157,{"inputs":[{"name":"rmatches"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",157,{"inputs":[{"name":"rmatches"}],"output":{"name":"option"}}],[11,"clone","","",157,{"inputs":[{"name":"rmatches"}],"output":{"name":"self"}}],[11,"next_back","","",156,{"inputs":[{"name":"matches"}],"output":{"name":"option"}}],[11,"next_back","","",157,{"inputs":[{"name":"rmatches"}],"output":{"name":"option"}}],[11,"fmt","","",158,{"inputs":[{"name":"lines"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",158,{"inputs":[{"name":"lines"}],"output":{"name":"lines"}}],[11,"next","","",158,{"inputs":[{"name":"lines"}],"output":{"name":"option"}}],[11,"size_hint","","",158,null],[11,"next_back","","",158,{"inputs":[{"name":"lines"}],"output":{"name":"option"}}],[11,"fmt","","",159,{"inputs":[{"name":"linesany"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",159,{"inputs":[{"name":"linesany"}],"output":{"name":"linesany"}}],[11,"next","","",159,{"inputs":[{"name":"linesany"}],"output":{"name":"option"}}],[11,"size_hint","","",159,null],[11,"next_back","","",159,{"inputs":[{"name":"linesany"}],"output":{"name":"option"}}],[11,"fmt","","",133,{"inputs":[{"name":"charrange"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",133,{"inputs":[{"name":"charrange"}],"output":{"name":"charrange"}}],[0,"hash","core","Generic hashing support.",null,null],[3,"SipHasher","core::hash","An implementation of SipHash 2-4.",null,null],[3,"BuildHasherDefault","","A structure which implements `BuildHasher` for all `Hasher` types which also\nimplement `Default`.",null,null],[11,"fmt","","",160,{"inputs":[{"name":"siphasher"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new `SipHasher` with the two initial keys set to 0.",160,{"inputs":[],"output":{"name":"siphasher"}}],[11,"new_with_keys","","Creates a `SipHasher` that is keyed off the provided keys.",160,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"siphasher"}}],[11,"write","","",160,null],[11,"finish","","",160,{"inputs":[{"name":"siphasher"}],"output":{"name":"u64"}}],[11,"clone","","",160,{"inputs":[{"name":"siphasher"}],"output":{"name":"siphasher"}}],[11,"default","","",160,{"inputs":[],"output":{"name":"siphasher"}}],[8,"Hash","","A hashable type.",null,null],[10,"hash","","Feeds this value into the state given, updating the hasher as necessary.",161,{"inputs":[{"name":"hash"},{"name":"h"}],"output":null}],[11,"hash_slice","","Feeds a slice of this type into the state provided.",161,null],[8,"Hasher","","A trait which represents the ability to hash an arbitrary stream of bytes.",null,null],[10,"finish","","Completes a round of hashing, producing the output hash generated.",162,{"inputs":[{"name":"hasher"}],"output":{"name":"u64"}}],[10,"write","","Writes some data into this `Hasher`",162,null],[11,"write_u8","","Write a single `u8` into this hasher",162,{"inputs":[{"name":"hasher"},{"name":"u8"}],"output":null}],[11,"write_u16","","Write a single `u16` into this hasher.",162,{"inputs":[{"name":"hasher"},{"name":"u16"}],"output":null}],[11,"write_u32","","Write a single `u32` into this hasher.",162,{"inputs":[{"name":"hasher"},{"name":"u32"}],"output":null}],[11,"write_u64","","Write a single `u64` into this hasher.",162,{"inputs":[{"name":"hasher"},{"name":"u64"}],"output":null}],[11,"write_usize","","Write a single `usize` into this hasher.",162,{"inputs":[{"name":"hasher"},{"name":"usize"}],"output":null}],[11,"write_i8","","Write a single `i8` into this hasher.",162,{"inputs":[{"name":"hasher"},{"name":"i8"}],"output":null}],[11,"write_i16","","Write a single `i16` into this hasher.",162,{"inputs":[{"name":"hasher"},{"name":"i16"}],"output":null}],[11,"write_i32","","Write a single `i32` into this hasher.",162,{"inputs":[{"name":"hasher"},{"name":"i32"}],"output":null}],[11,"write_i64","","Write a single `i64` into this hasher.",162,{"inputs":[{"name":"hasher"},{"name":"i64"}],"output":null}],[11,"write_isize","","Write a single `isize` into this hasher.",162,{"inputs":[{"name":"hasher"},{"name":"isize"}],"output":null}],[8,"BuildHasher","","A `BuildHasher` is typically used as a factory for instances of `Hasher`\nwhich a `HashMap` can then use to hash keys independently.",null,null],[16,"Hasher","","Type of the hasher that will be created.",163,null],[10,"build_hasher","","Creates a new hasher.",163,{"inputs":[{"name":"buildhasher"}],"output":{"name":"hasher"}}],[11,"fmt","","",164,{"inputs":[{"name":"buildhasherdefault"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"build_hasher","","",164,{"inputs":[{"name":"buildhasherdefault"}],"output":{"name":"h"}}],[11,"clone","","",164,{"inputs":[{"name":"buildhasherdefault"}],"output":{"name":"buildhasherdefault"}}],[11,"default","","",164,{"inputs":[],"output":{"name":"buildhasherdefault"}}],[0,"fmt","core","Utilities for formatting and printing strings.",null,null],[3,"DebugStruct","core::fmt","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugTuple","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugSet","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugList","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugMap","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"Error","","The error type which is returned from formatting a message into a stream.",null,null],[3,"Formatter","","A struct to represent both where to emit formatting strings to and how they\nshould be formatted. A mutable version of this is passed to all formatting\ntraits.",null,null],[3,"Arguments","","This structure represents a safely precompiled version of a format string\nand its arguments. This cannot be generated at runtime because it cannot\nsafely be done so, so no constructors are given and the fields are private\nto prevent modification.",null,null],[4,"Alignment","","Possible alignments returned by `Formatter::align`",null,null],[13,"Left","","Indication that contents should be left-aligned.",165,null],[13,"Right","","Indication that contents should be right-aligned.",165,null],[13,"Center","","Indication that contents should be center-aligned.",165,null],[13,"Unknown","","No alignment was requested.",165,null],[5,"write","","The `write` function takes an output stream, a precompiled format string,\nand a list of arguments. The arguments will be formatted according to the\nspecified format string into the output stream provided.",null,{"inputs":[{"name":"write"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"field","","Adds a new field to the generated struct output.",166,{"inputs":[{"name":"debugstruct"},{"name":"str"},{"name":"debug"}],"output":{"name":"debugstruct"}}],[11,"finish","","Finishes output and returns any error encountered.",166,{"inputs":[{"name":"debugstruct"}],"output":{"name":"result"}}],[11,"field","","Adds a new field to the generated tuple struct output.",167,{"inputs":[{"name":"debugtuple"},{"name":"debug"}],"output":{"name":"debugtuple"}}],[11,"finish","","Finishes output and returns any error encountered.",167,{"inputs":[{"name":"debugtuple"}],"output":{"name":"result"}}],[11,"entry","","Adds a new entry to the set output.",168,{"inputs":[{"name":"debugset"},{"name":"debug"}],"output":{"name":"debugset"}}],[11,"entries","","Adds the contents of an iterator of entries to the set output.",168,{"inputs":[{"name":"debugset"},{"name":"i"}],"output":{"name":"debugset"}}],[11,"finish","","Finishes output and returns any error encountered.",168,{"inputs":[{"name":"debugset"}],"output":{"name":"result"}}],[11,"entry","","Adds a new entry to the list output.",169,{"inputs":[{"name":"debuglist"},{"name":"debug"}],"output":{"name":"debuglist"}}],[11,"entries","","Adds the contents of an iterator of entries to the list output.",169,{"inputs":[{"name":"debuglist"},{"name":"i"}],"output":{"name":"debuglist"}}],[11,"finish","","Finishes output and returns any error encountered.",169,{"inputs":[{"name":"debuglist"}],"output":{"name":"result"}}],[11,"entry","","Adds a new entry to the map output.",170,{"inputs":[{"name":"debugmap"},{"name":"debug"},{"name":"debug"}],"output":{"name":"debugmap"}}],[11,"entries","","Adds the contents of an iterator of entries to the map output.",170,{"inputs":[{"name":"debugmap"},{"name":"i"}],"output":{"name":"debugmap"}}],[11,"finish","","Finishes output and returns any error encountered.",170,{"inputs":[{"name":"debugmap"}],"output":{"name":"result"}}],[6,"Result","","The type returned by formatter methods.",null,null],[8,"Write","","A collection of methods that are required to format a message into a stream.",null,null],[10,"write_str","","Writes a slice of bytes into this writer, returning whether the write\nsucceeded.",171,{"inputs":[{"name":"write"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","Writes a `char` into this writer, returning whether the write succeeded.",171,{"inputs":[{"name":"write"},{"name":"char"}],"output":{"name":"result"}}],[11,"write_fmt","","Glue for usage of the `write!` macro with implementors of this trait.",171,{"inputs":[{"name":"write"},{"name":"arguments"}],"output":{"name":"result"}}],[8,"Debug","","Format trait for the `?` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",172,{"inputs":[{"name":"debug"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Display","","Format trait for an empty format, `{}`.",null,null],[10,"fmt","","Formats the value using the given formatter.",173,{"inputs":[{"name":"display"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Octal","","Format trait for the `o` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",174,{"inputs":[{"name":"octal"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Binary","","Format trait for the `b` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",175,{"inputs":[{"name":"binary"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"LowerHex","","Format trait for the `x` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",176,{"inputs":[{"name":"lowerhex"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"UpperHex","","Format trait for the `X` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",177,{"inputs":[{"name":"upperhex"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Pointer","","Format trait for the `p` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",178,{"inputs":[{"name":"pointer"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"LowerExp","","Format trait for the `e` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",179,{"inputs":[{"name":"lowerexp"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"UpperExp","","Format trait for the `E` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",180,{"inputs":[{"name":"upperexp"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",165,{"inputs":[{"name":"alignment"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",181,{"inputs":[{"name":"error"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",181,{"inputs":[{"name":"error"}],"output":{"name":"error"}}],[11,"clone","","",182,{"inputs":[{"name":"arguments"}],"output":{"name":"arguments"}}],[11,"fmt","","",182,{"inputs":[{"name":"arguments"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",182,{"inputs":[{"name":"arguments"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"pad_integral","","Performs the correct padding for an integer which has already been\nemitted into a str. The str should *not* contain the sign for the\ninteger, that will be added by this method.",183,{"inputs":[{"name":"formatter"},{"name":"bool"},{"name":"str"},{"name":"str"}],"output":{"name":"result"}}],[11,"pad","","This function takes a string slice and emits it to the internal buffer\nafter applying the relevant formatting flags specified. The flags\nrecognized for generic strings are:",183,{"inputs":[{"name":"formatter"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_str","","Writes some data to the underlying buffer contained within this\nformatter.",183,{"inputs":[{"name":"formatter"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_fmt","","Writes some formatted information into this instance",183,{"inputs":[{"name":"formatter"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"flags","","Flags for formatting (packed version of rt::Flag)",183,{"inputs":[{"name":"formatter"}],"output":{"name":"u32"}}],[11,"fill","","Character used as &#39;fill&#39; whenever there is alignment",183,{"inputs":[{"name":"formatter"}],"output":{"name":"char"}}],[11,"align","","Flag indicating what form of alignment was requested",183,{"inputs":[{"name":"formatter"}],"output":{"name":"alignment"}}],[11,"width","","Optionally specified integer width that the output should be",183,{"inputs":[{"name":"formatter"}],"output":{"name":"option"}}],[11,"precision","","Optionally specified precision for numeric types",183,{"inputs":[{"name":"formatter"}],"output":{"name":"option"}}],[11,"sign_plus","","Determines if the `+` flag was specified.",183,{"inputs":[{"name":"formatter"}],"output":{"name":"bool"}}],[11,"sign_minus","","Determines if the `-` flag was specified.",183,{"inputs":[{"name":"formatter"}],"output":{"name":"bool"}}],[11,"alternate","","Determines if the `#` flag was specified.",183,{"inputs":[{"name":"formatter"}],"output":{"name":"bool"}}],[11,"sign_aware_zero_pad","","Determines if the `0` flag was specified.",183,{"inputs":[{"name":"formatter"}],"output":{"name":"bool"}}],[11,"debug_struct","","Creates a `DebugStruct` builder designed to assist with creation of\n`fmt::Debug` implementations for structs.",183,{"inputs":[{"name":"formatter"},{"name":"str"}],"output":{"name":"debugstruct"}}],[11,"debug_tuple","","Creates a `DebugTuple` builder designed to assist with creation of\n`fmt::Debug` implementations for tuple structs.",183,{"inputs":[{"name":"formatter"},{"name":"str"}],"output":{"name":"debugtuple"}}],[11,"debug_list","","Creates a `DebugList` builder designed to assist with creation of\n`fmt::Debug` implementations for list-like structures.",183,{"inputs":[{"name":"formatter"}],"output":{"name":"debuglist"}}],[11,"debug_set","","Creates a `DebugSet` builder designed to assist with creation of\n`fmt::Debug` implementations for set-like structures.",183,{"inputs":[{"name":"formatter"}],"output":{"name":"debugset"}}],[11,"debug_map","","Creates a `DebugMap` builder designed to assist with creation of\n`fmt::Debug` implementations for map-like structures.",183,{"inputs":[{"name":"formatter"}],"output":{"name":"debugmap"}}],[11,"write_str","","",183,{"inputs":[{"name":"formatter"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","",183,{"inputs":[{"name":"formatter"},{"name":"char"}],"output":{"name":"result"}}],[11,"write_fmt","","",183,{"inputs":[{"name":"formatter"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"fmt","","",181,{"inputs":[{"name":"error"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","core::marker","",9,{"inputs":[{"name":"phantomdata"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","core::cell","",72,{"inputs":[{"name":"cell"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",73,{"inputs":[{"name":"refcell"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",74,{"inputs":[{"name":"ref"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",75,{"inputs":[{"name":"refmut"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",76,{"inputs":[{"name":"unsafecell"},{"name":"formatter"}],"output":{"name":"result"}}],[14,"panic!","core","Entry point of thread panic, for details, see std::macros",null,null],[14,"assert!","","Ensure that a boolean expression is `true` at runtime.",null,null],[14,"assert_eq!","","Asserts that two expressions are equal to each other.",null,null],[14,"debug_assert!","","Ensure that a boolean expression is `true` at runtime.",null,null],[14,"debug_assert_eq!","","Asserts that two expressions are equal to each other.",null,null],[14,"try!","","Helper macro for unwrapping `Result` values while returning early with an\nerror if the value of the expression is `Err`. Can only be used in\nfunctions that return `Result` because of the early return of `Err` that\nit provides.",null,null],[14,"write!","","Use the `format!` syntax to write data into a buffer.",null,null],[14,"writeln!","","Use the `format!` syntax to write data into a buffer, appending a newline.",null,null],[14,"unreachable!","","A utility macro for indicating unreachable code.",null,null],[14,"unimplemented!","","A standardized placeholder for marking unfinished code. It panics with the\nmessage `&quot;not yet implemented&quot;` when executed.",null,null]],"paths":[[3,"Wrapping"],[4,"FpCategory"],[3,"ParseFloatError"],[8,"Zero"],[8,"One"],[3,"ParseIntError"],[3,"NonZero"],[3,"Unique"],[3,"Shared"],[3,"PhantomData"],[3,"Range"],[3,"RangeFrom"],[3,"RangeTo"],[3,"RangeToInclusive"],[4,"RangeInclusive"],[8,"Drop"],[8,"Add"],[8,"Sub"],[8,"Mul"],[8,"Div"],[8,"Rem"],[8,"Neg"],[8,"Not"],[8,"BitAnd"],[8,"BitOr"],[8,"BitXor"],[8,"Shl"],[8,"Shr"],[8,"AddAssign"],[8,"SubAssign"],[8,"MulAssign"],[8,"DivAssign"],[8,"RemAssign"],[8,"BitAndAssign"],[8,"BitOrAssign"],[8,"BitXorAssign"],[8,"ShlAssign"],[8,"ShrAssign"],[8,"Index"],[8,"IndexMut"],[8,"Deref"],[8,"DerefMut"],[8,"Fn"],[8,"FnMut"],[8,"FnOnce"],[8,"Place"],[8,"Placer"],[8,"InPlace"],[8,"Boxed"],[8,"BoxPlace"],[3,"RangeFull"],[4,"Ordering"],[8,"PartialEq"],[8,"Ord"],[8,"PartialOrd"],[8,"Clone"],[8,"Default"],[8,"AsRef"],[8,"AsMut"],[8,"Into"],[8,"From"],[8,"Borrow"],[8,"BorrowMut"],[8,"Any"],[3,"TypeId"],[8,"FixedSizeArray"],[4,"Ordering"],[3,"AtomicBool"],[3,"AtomicIsize"],[3,"AtomicUsize"],[3,"AtomicPtr"],[4,"BorrowState"],[3,"Cell"],[3,"RefCell"],[3,"Ref"],[3,"RefMut"],[3,"UnsafeCell"],[3,"EscapeUnicode"],[3,"EscapeDefault"],[3,"EncodeUtf8"],[3,"EncodeUtf16"],[8,"Iterator"],[8,"FromIterator"],[8,"IntoIterator"],[8,"Extend"],[8,"DoubleEndedIterator"],[8,"ExactSizeIterator"],[8,"Step"],[3,"Rev"],[3,"Cloned"],[3,"Cycle"],[3,"Chain"],[3,"Zip"],[3,"Map"],[3,"Filter"],[3,"FilterMap"],[3,"Enumerate"],[3,"Peekable"],[3,"SkipWhile"],[3,"TakeWhile"],[3,"Skip"],[3,"Take"],[3,"Scan"],[3,"FlatMap"],[3,"Fuse"],[3,"Inspect"],[3,"StepBy"],[3,"Repeat"],[3,"Empty"],[3,"Once"],[4,"Option"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Slice"],[3,"TraitObject"],[8,"Repr"],[4,"Result"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[8,"SliceExt"],[3,"Iter"],[3,"IterMut"],[3,"Split"],[3,"SplitMut"],[3,"SplitN"],[3,"RSplitN"],[3,"SplitNMut"],[3,"RSplitNMut"],[3,"Windows"],[3,"Chunks"],[3,"ChunksMut"],[3,"CharRange"],[4,"SearchStep"],[8,"Pattern"],[8,"Searcher"],[8,"ReverseSearcher"],[3,"CharSearcher"],[3,"CharSliceSearcher"],[3,"CharPredicateSearcher"],[3,"StrSearcher"],[8,"FromStr"],[3,"ParseBoolError"],[3,"Utf8Error"],[3,"Chars"],[3,"CharIndices"],[3,"Bytes"],[3,"Split"],[3,"RSplit"],[3,"SplitTerminator"],[3,"RSplitTerminator"],[3,"SplitN"],[3,"RSplitN"],[3,"MatchIndices"],[3,"RMatchIndices"],[3,"Matches"],[3,"RMatches"],[3,"Lines"],[3,"LinesAny"],[3,"SipHasher"],[8,"Hash"],[8,"Hasher"],[8,"BuildHasher"],[3,"BuildHasherDefault"],[4,"Alignment"],[3,"DebugStruct"],[3,"DebugTuple"],[3,"DebugSet"],[3,"DebugList"],[3,"DebugMap"],[8,"Write"],[8,"Debug"],[8,"Display"],[8,"Octal"],[8,"Binary"],[8,"LowerHex"],[8,"UpperHex"],[8,"Pointer"],[8,"LowerExp"],[8,"UpperExp"],[3,"Error"],[3,"Arguments"],[3,"Formatter"]]};
searchIndex["collections"] = {"doc":"Collection types.","items":[[0,"boxed","collections","A pointer type for heap allocation.",null,null],[17,"HEAP","collections::boxed","A value that represents the heap. This is the default place that the `box`\nkeyword allocates into when no place is supplied.",null,null],[11,"make_place","alloc::boxed","",0,{"inputs":[{"name":"exchangeheapsingleton"}],"output":{"name":"intermediatebox"}}],[11,"clone","","",0,{"inputs":[{"name":"exchangeheapsingleton"}],"output":{"name":"exchangeheapsingleton"}}],[3,"ExchangeHeapSingleton","collections::boxed","This the singleton type used solely for `boxed::HEAP`.",null,null],[11,"as_mut","alloc::boxed","",1,{"inputs":[{"name":"box"}],"output":{"name":"t"}}],[11,"as_ref","","",1,{"inputs":[{"name":"box"}],"output":{"name":"t"}}],[11,"borrow_mut","","",1,{"inputs":[{"name":"box"}],"output":{"name":"t"}}],[11,"borrow","","",1,{"inputs":[{"name":"box"}],"output":{"name":"t"}}],[11,"clone","","",1,{"inputs":[{"name":"box"}],"output":{"name":"box"}}],[11,"call_once","","",1,{"inputs":[{"name":"box"},{"name":"a"}],"output":{"name":"r"}}],[11,"call_once","","",1,{"inputs":[{"name":"box"},{"name":"a"}],"output":{"name":"r"}}],[11,"next_back","","",1,{"inputs":[{"name":"box"}],"output":{"name":"option"}}],[11,"next","","",1,{"inputs":[{"name":"box"}],"output":{"name":"option"}}],[11,"size_hint","","",1,null],[11,"deref_mut","","",1,{"inputs":[{"name":"box"}],"output":{"name":"t"}}],[11,"deref","","",1,{"inputs":[{"name":"box"}],"output":{"name":"t"}}],[11,"fmt","","",1,{"inputs":[{"name":"box"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",1,{"inputs":[{"name":"box"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",1,{"inputs":[{"name":"box"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",1,{"inputs":[{"name":"box"}],"output":{"name":"result"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",1,{"inputs":[{"name":"box"}],"output":{"name":"result"}}],[11,"from","","",1,{"inputs":[{"name":"t"}],"output":{"name":"box"}}],[11,"hash","","",1,null],[11,"cmp","","",1,{"inputs":[{"name":"box"},{"name":"box"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",1,{"inputs":[{"name":"box"},{"name":"box"}],"output":{"name":"option"}}],[11,"lt","","",1,{"inputs":[{"name":"box"},{"name":"box"}],"output":{"name":"bool"}}],[11,"le","","",1,{"inputs":[{"name":"box"},{"name":"box"}],"output":{"name":"bool"}}],[11,"ge","","",1,{"inputs":[{"name":"box"},{"name":"box"}],"output":{"name":"bool"}}],[11,"gt","","",1,{"inputs":[{"name":"box"},{"name":"box"}],"output":{"name":"bool"}}],[11,"eq","","",1,{"inputs":[{"name":"box"},{"name":"box"}],"output":{"name":"bool"}}],[11,"ne","","",1,{"inputs":[{"name":"box"},{"name":"box"}],"output":{"name":"bool"}}],[11,"clone","","",1,{"inputs":[{"name":"box"}],"output":{"name":"box"}}],[11,"clone","","Returns a new box with a `clone()` of this box&#39;s contents.",1,{"inputs":[{"name":"box"}],"output":{"name":"box"}}],[11,"clone_from","","Copies `source`&#39;s contents into `self` without creating a new allocation.",1,null],[11,"default","","",1,{"inputs":[],"output":{"name":"box"}}],[11,"default","","",1,{"inputs":[],"output":{"name":"box"}}],[11,"from_raw","","Constructs a box from a raw pointer.",1,null],[11,"into_raw","","Consumes the `Box`, returning the wrapped raw pointer.",1,null],[11,"new","","Allocates memory on the heap and then places `x` into it.",1,{"inputs":[{"name":"t"}],"output":{"name":"box"}}],[11,"finalize","","",1,{"inputs":[{"name":"intermediatebox"}],"output":{"name":"box"}}],[3,"Box","collections::boxed","A pointer type for heap allocation.",null,null],[11,"drop","alloc::boxed","",2,null],[11,"finalize","","",2,{"inputs":[{"name":"intermediatebox"}],"output":{"name":"box"}}],[11,"make_place","","",2,{"inputs":[],"output":{"name":"intermediatebox"}}],[11,"pointer","","",2,null],[3,"IntermediateBox","collections::boxed","`IntermediateBox` represents uninitialized backing storage for `Box`.",null,null],[8,"FnBox","","`FnBox` is a version of the `FnOnce` intended for use with boxed\nclosure objects. The idea is that where one would normally store a\n`Box&lt;FnOnce()&gt;` in a data structure, you should use\n`Box&lt;FnBox()&gt;`. The two traits behave essentially the same, except\nthat a `FnBox` closure can only be called if it is boxed. (Note\nthat `FnBox` may be deprecated in the future if `Box&lt;FnOnce()&gt;`\nclosures become directly usable.)",null,null],[16,"Output","","",3,null],[10,"call_box","","",3,null],[4,"Bound","collections","An endpoint of a range of keys.",null,null],[13,"Included","","An inclusive bound.",4,null],[13,"Excluded","","An exclusive bound.",4,null],[13,"Unbounded","","An infinite endpoint. Indicates that there is no bound in this direction.",4,null],[0,"binary_heap","","A priority queue implemented with a binary heap.",null,null],[3,"BinaryHeap","collections::binary_heap","A priority queue implemented with a binary heap.",null,null],[3,"Iter","","`BinaryHeap` iterator.",null,null],[3,"IntoIter","","An iterator that moves out of a `BinaryHeap`.",null,null],[3,"Drain","","An iterator that drains a `BinaryHeap`.",null,null],[11,"clone","","",5,{"inputs":[{"name":"binaryheap"}],"output":{"name":"self"}}],[11,"clone_from","","",5,{"inputs":[{"name":"binaryheap"},{"name":"self"}],"output":null}],[11,"default","","",5,{"inputs":[],"output":{"name":"binaryheap"}}],[11,"fmt","","",5,{"inputs":[{"name":"binaryheap"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates an empty `BinaryHeap` as a max-heap.",5,{"inputs":[],"output":{"name":"binaryheap"}}],[11,"with_capacity","","Creates an empty `BinaryHeap` with a specific capacity.\nThis preallocates enough memory for `capacity` elements,\nso that the `BinaryHeap` does not have to be reallocated\nuntil it contains at least that many values.",5,{"inputs":[{"name":"usize"}],"output":{"name":"binaryheap"}}],[11,"iter","","Returns an iterator visiting all values in the underlying vector, in\narbitrary order.",5,{"inputs":[{"name":"binaryheap"}],"output":{"name":"iter"}}],[11,"peek","","Returns the greatest item in the binary heap, or `None` if it is empty.",5,{"inputs":[{"name":"binaryheap"}],"output":{"name":"option"}}],[11,"capacity","","Returns the number of elements the binary heap can hold without reallocating.",5,{"inputs":[{"name":"binaryheap"}],"output":{"name":"usize"}}],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the\ngiven `BinaryHeap`. Does nothing if the capacity is already sufficient.",5,{"inputs":[{"name":"binaryheap"},{"name":"usize"}],"output":null}],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the\n`BinaryHeap`. The collection may reserve more space to avoid frequent reallocations.",5,{"inputs":[{"name":"binaryheap"},{"name":"usize"}],"output":null}],[11,"shrink_to_fit","","Discards as much additional capacity as possible.",5,{"inputs":[{"name":"binaryheap"}],"output":null}],[11,"pop","","Removes the greatest item from the binary heap and returns it, or `None` if it\nis empty.",5,{"inputs":[{"name":"binaryheap"}],"output":{"name":"option"}}],[11,"push","","Pushes an item onto the binary heap.",5,{"inputs":[{"name":"binaryheap"},{"name":"t"}],"output":null}],[11,"push_pop","","Pushes an item onto the binary heap, then pops the greatest item off the queue in\nan optimized fashion.",5,{"inputs":[{"name":"binaryheap"},{"name":"t"}],"output":{"name":"t"}}],[11,"replace","","Pops the greatest item off the binary heap, then pushes an item onto the queue in\nan optimized fashion. The push is done regardless of whether the binary heap\nwas empty.",5,{"inputs":[{"name":"binaryheap"},{"name":"t"}],"output":{"name":"option"}}],[11,"into_vec","","Consumes the `BinaryHeap` and returns the underlying vector\nin arbitrary order.",5,{"inputs":[{"name":"binaryheap"}],"output":{"name":"vec"}}],[11,"into_sorted_vec","","Consumes the `BinaryHeap` and returns a vector in sorted\n(ascending) order.",5,{"inputs":[{"name":"binaryheap"}],"output":{"name":"vec"}}],[11,"len","","Returns the length of the binary heap.",5,{"inputs":[{"name":"binaryheap"}],"output":{"name":"usize"}}],[11,"is_empty","","Checks if the binary heap is empty.",5,{"inputs":[{"name":"binaryheap"}],"output":{"name":"bool"}}],[11,"drain","","Clears the binary heap, returning an iterator over the removed elements.",5,{"inputs":[{"name":"binaryheap"}],"output":{"name":"drain"}}],[11,"clear","","Drops all items from the binary heap.",5,{"inputs":[{"name":"binaryheap"}],"output":null}],[11,"clone","","",6,{"inputs":[{"name":"iter"}],"output":{"name":"iter"}}],[11,"next","","",6,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"size_hint","","",6,null],[11,"next_back","","",6,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"next","","",7,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"size_hint","","",7,null],[11,"next_back","","",7,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"next","","",8,{"inputs":[{"name":"drain"}],"output":{"name":"option"}}],[11,"size_hint","","",8,null],[11,"next_back","","",8,{"inputs":[{"name":"drain"}],"output":{"name":"option"}}],[11,"from","","",5,{"inputs":[{"name":"vec"}],"output":{"name":"binaryheap"}}],[11,"from_iter","","",5,{"inputs":[{"name":"i"}],"output":{"name":"binaryheap"}}],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each value out of\nthe binary heap in arbitrary order. The binary heap cannot be used\nafter calling this.",5,{"inputs":[{"name":"binaryheap"}],"output":{"name":"intoiter"}}],[11,"extend","","",5,{"inputs":[{"name":"binaryheap"},{"name":"i"}],"output":null}],[11,"extend","","",5,{"inputs":[{"name":"binaryheap"},{"name":"i"}],"output":null}],[0,"borrow","collections","A module for working with borrowed data.",null,null],[8,"Borrow","collections::borrow","A trait for borrowing data.",null,null],[10,"borrow","","Immutably borrows from an owned value.",9,{"inputs":[{"name":"borrow"}],"output":{"name":"borrowed"}}],[8,"BorrowMut","","A trait for mutably borrowing data.",null,null],[10,"borrow_mut","","Mutably borrows from an owned value.",10,{"inputs":[{"name":"borrowmut"}],"output":{"name":"borrowed"}}],[4,"Cow","","A clone-on-write smart pointer.",null,null],[13,"Borrowed","","Borrowed data.",11,null],[13,"Owned","","Owned data.",11,null],[8,"ToOwned","","A generalization of `Clone` to borrowed data.",null,null],[16,"Owned","","",12,null],[10,"to_owned","","Creates owned data from borrowed data, usually by cloning.",12,{"inputs":[{"name":"toowned"}],"output":{"name":"owned"}}],[11,"borrow","","",11,{"inputs":[{"name":"cow"}],"output":{"name":"b"}}],[11,"clone","","",11,{"inputs":[{"name":"cow"}],"output":{"name":"cow"}}],[11,"to_mut","","Acquires a mutable reference to the owned form of the data.",11,null],[11,"into_owned","","Extracts the owned data.",11,null],[11,"deref","","",11,{"inputs":[{"name":"cow"}],"output":{"name":"b"}}],[11,"cmp","","",11,{"inputs":[{"name":"cow"},{"name":"cow"}],"output":{"name":"ordering"}}],[11,"eq","","",11,{"inputs":[{"name":"cow"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",11,{"inputs":[{"name":"cow"},{"name":"cow"}],"output":{"name":"option"}}],[11,"fmt","","",11,{"inputs":[{"name":"cow"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",11,{"inputs":[{"name":"cow"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",11,{"inputs":[{"name":"cow"},{"name":"h"}],"output":null}],[11,"as_ref","","",11,{"inputs":[{"name":"cow"}],"output":{"name":"t"}}],[0,"enum_set","collections","A structure for holding a set of enum variants.",null,null],[3,"EnumSet","collections::enum_set","A specialized set implementation to use enum types.",null,null],[3,"Iter","","An iterator over an EnumSet",null,null],[8,"CLike","","An interface for casting C-like enum to usize and back.\nA typically implementation is as below.",null,null],[10,"to_usize","","Converts a C-like enum to a `usize`.",13,{"inputs":[{"name":"clike"}],"output":{"name":"usize"}}],[10,"from_usize","","Converts a `usize` to a C-like enum.",13,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"hash","","",14,null],[11,"cmp","","",14,{"inputs":[{"name":"enumset"},{"name":"enumset"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",14,{"inputs":[{"name":"enumset"},{"name":"enumset"}],"output":{"name":"option"}}],[11,"lt","","",14,{"inputs":[{"name":"enumset"},{"name":"enumset"}],"output":{"name":"bool"}}],[11,"le","","",14,{"inputs":[{"name":"enumset"},{"name":"enumset"}],"output":{"name":"bool"}}],[11,"gt","","",14,{"inputs":[{"name":"enumset"},{"name":"enumset"}],"output":{"name":"bool"}}],[11,"ge","","",14,{"inputs":[{"name":"enumset"},{"name":"enumset"}],"output":{"name":"bool"}}],[11,"eq","","",14,{"inputs":[{"name":"enumset"},{"name":"enumset"}],"output":{"name":"bool"}}],[11,"ne","","",14,{"inputs":[{"name":"enumset"},{"name":"enumset"}],"output":{"name":"bool"}}],[11,"clone","","",14,{"inputs":[{"name":"enumset"}],"output":{"name":"enumset"}}],[11,"fmt","","",14,{"inputs":[{"name":"enumset"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Returns an empty `EnumSet`.",14,{"inputs":[],"output":{"name":"enumset"}}],[11,"len","","Returns the number of elements in the given `EnumSet`.",14,{"inputs":[{"name":"enumset"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns true if the `EnumSet` is empty.",14,{"inputs":[{"name":"enumset"}],"output":{"name":"bool"}}],[11,"clear","","",14,{"inputs":[{"name":"enumset"}],"output":null}],[11,"is_disjoint","","Returns `false` if the `EnumSet` contains any enum of the given `EnumSet`.",14,{"inputs":[{"name":"enumset"},{"name":"enumset"}],"output":{"name":"bool"}}],[11,"is_superset","","Returns `true` if a given `EnumSet` is included in this `EnumSet`.",14,{"inputs":[{"name":"enumset"},{"name":"enumset"}],"output":{"name":"bool"}}],[11,"is_subset","","Returns `true` if this `EnumSet` is included in the given `EnumSet`.",14,{"inputs":[{"name":"enumset"},{"name":"enumset"}],"output":{"name":"bool"}}],[11,"union","","Returns the union of both `EnumSets`.",14,{"inputs":[{"name":"enumset"},{"name":"enumset"}],"output":{"name":"enumset"}}],[11,"intersection","","Returns the intersection of both `EnumSets`.",14,{"inputs":[{"name":"enumset"},{"name":"enumset"}],"output":{"name":"enumset"}}],[11,"insert","","Adds an enum to the `EnumSet`, and returns `true` if it wasn&#39;t there before",14,{"inputs":[{"name":"enumset"},{"name":"e"}],"output":{"name":"bool"}}],[11,"remove","","Removes an enum from the EnumSet",14,{"inputs":[{"name":"enumset"},{"name":"e"}],"output":{"name":"bool"}}],[11,"contains","","Returns `true` if an `EnumSet` contains a given enum.",14,{"inputs":[{"name":"enumset"},{"name":"e"}],"output":{"name":"bool"}}],[11,"iter","","Returns an iterator over an `EnumSet`.",14,{"inputs":[{"name":"enumset"}],"output":{"name":"iter"}}],[11,"sub","","",14,{"inputs":[{"name":"enumset"},{"name":"enumset"}],"output":{"name":"enumset"}}],[11,"bitor","","",14,{"inputs":[{"name":"enumset"},{"name":"enumset"}],"output":{"name":"enumset"}}],[11,"bitand","","",14,{"inputs":[{"name":"enumset"},{"name":"enumset"}],"output":{"name":"enumset"}}],[11,"bitxor","","",14,{"inputs":[{"name":"enumset"},{"name":"enumset"}],"output":{"name":"enumset"}}],[11,"clone","","",15,{"inputs":[{"name":"iter"}],"output":{"name":"iter"}}],[11,"next","","",15,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"size_hint","","",15,null],[11,"from_iter","","",14,{"inputs":[{"name":"i"}],"output":{"name":"enumset"}}],[11,"extend","","",14,{"inputs":[{"name":"enumset"},{"name":"i"}],"output":null}],[11,"extend","","",14,{"inputs":[{"name":"enumset"},{"name":"i"}],"output":null}],[0,"fmt","collections","Utilities for formatting and printing strings",null,null],[11,"write_str","core::fmt","",16,{"inputs":[{"name":"formatter"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","",16,{"inputs":[{"name":"formatter"},{"name":"char"}],"output":{"name":"result"}}],[11,"write_fmt","","",16,{"inputs":[{"name":"formatter"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"pad_integral","","Performs the correct padding for an integer which has already been\nemitted into a str. The str should *not* contain the sign for the\ninteger, that will be added by this method.",16,{"inputs":[{"name":"formatter"},{"name":"bool"},{"name":"str"},{"name":"str"}],"output":{"name":"result"}}],[11,"pad","","This function takes a string slice and emits it to the internal buffer\nafter applying the relevant formatting flags specified. The flags\nrecognized for generic strings are:",16,{"inputs":[{"name":"formatter"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_str","","Writes some data to the underlying buffer contained within this\nformatter.",16,{"inputs":[{"name":"formatter"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_fmt","","Writes some formatted information into this instance",16,{"inputs":[{"name":"formatter"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"flags","","Flags for formatting (packed version of rt::Flag)",16,{"inputs":[{"name":"formatter"}],"output":{"name":"u32"}}],[11,"fill","","Character used as &#39;fill&#39; whenever there is alignment",16,{"inputs":[{"name":"formatter"}],"output":{"name":"char"}}],[11,"align","","Flag indicating what form of alignment was requested",16,{"inputs":[{"name":"formatter"}],"output":{"name":"alignment"}}],[11,"width","","Optionally specified integer width that the output should be",16,{"inputs":[{"name":"formatter"}],"output":{"name":"option"}}],[11,"precision","","Optionally specified precision for numeric types",16,{"inputs":[{"name":"formatter"}],"output":{"name":"option"}}],[11,"sign_plus","","Determines if the `+` flag was specified.",16,{"inputs":[{"name":"formatter"}],"output":{"name":"bool"}}],[11,"sign_minus","","Determines if the `-` flag was specified.",16,{"inputs":[{"name":"formatter"}],"output":{"name":"bool"}}],[11,"alternate","","Determines if the `#` flag was specified.",16,{"inputs":[{"name":"formatter"}],"output":{"name":"bool"}}],[11,"sign_aware_zero_pad","","Determines if the `0` flag was specified.",16,{"inputs":[{"name":"formatter"}],"output":{"name":"bool"}}],[11,"debug_struct","","Creates a `DebugStruct` builder designed to assist with creation of\n`fmt::Debug` implementations for structs.",16,{"inputs":[{"name":"formatter"},{"name":"str"}],"output":{"name":"debugstruct"}}],[11,"debug_tuple","","Creates a `DebugTuple` builder designed to assist with creation of\n`fmt::Debug` implementations for tuple structs.",16,{"inputs":[{"name":"formatter"},{"name":"str"}],"output":{"name":"debugtuple"}}],[11,"debug_list","","Creates a `DebugList` builder designed to assist with creation of\n`fmt::Debug` implementations for list-like structures.",16,{"inputs":[{"name":"formatter"}],"output":{"name":"debuglist"}}],[11,"debug_set","","Creates a `DebugSet` builder designed to assist with creation of\n`fmt::Debug` implementations for set-like structures.",16,{"inputs":[{"name":"formatter"}],"output":{"name":"debugset"}}],[11,"debug_map","","Creates a `DebugMap` builder designed to assist with creation of\n`fmt::Debug` implementations for map-like structures.",16,{"inputs":[{"name":"formatter"}],"output":{"name":"debugmap"}}],[3,"Formatter","collections::fmt","A struct to represent both where to emit formatting strings to and how they\nshould be formatted. A mutable version of this is passed to all formatting\ntraits.",null,null],[6,"Result","","",null,null],[8,"Write","","A collection of methods that are required to format a message into a stream.",null,null],[10,"write_str","","Writes a slice of bytes into this writer, returning whether the write\nsucceeded.",17,{"inputs":[{"name":"write"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","Writes a `char` into this writer, returning whether the write succeeded.",17,{"inputs":[{"name":"write"},{"name":"char"}],"output":{"name":"result"}}],[11,"write_fmt","","Glue for usage of the `write!` macro with implementors of this trait.",17,{"inputs":[{"name":"write"},{"name":"arguments"}],"output":{"name":"result"}}],[8,"Octal","","Format trait for the `o` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",18,{"inputs":[{"name":"octal"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Binary","","Format trait for the `b` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",19,{"inputs":[{"name":"binary"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Display","","Format trait for an empty format, `{}`.",null,null],[10,"fmt","","Formats the value using the given formatter.",20,{"inputs":[{"name":"display"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Debug","","Format trait for the `?` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",21,{"inputs":[{"name":"debug"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"LowerHex","","Format trait for the `x` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",22,{"inputs":[{"name":"lowerhex"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"UpperHex","","Format trait for the `X` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",23,{"inputs":[{"name":"upperhex"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Pointer","","Format trait for the `p` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",24,{"inputs":[{"name":"pointer"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"LowerExp","","Format trait for the `e` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",25,{"inputs":[{"name":"lowerexp"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"UpperExp","","Format trait for the `E` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",26,{"inputs":[{"name":"upperexp"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","core::fmt","",27,{"inputs":[{"name":"error"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",27,{"inputs":[{"name":"error"}],"output":{"name":"error"}}],[11,"fmt","","",27,{"inputs":[{"name":"error"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Error","collections::fmt","The error type which is returned from formatting a message into a stream.",null,null],[11,"fmt","core::fmt","",28,{"inputs":[{"name":"arguments"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",28,{"inputs":[{"name":"arguments"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",28,{"inputs":[{"name":"arguments"}],"output":{"name":"arguments"}}],[3,"Arguments","collections::fmt","This structure represents a safely precompiled version of a format string\nand its arguments. This cannot be generated at runtime because it cannot\nsafely be done so, so no constructors are given and the fields are private\nto prevent modification.",null,null],[5,"write","","The `write` function takes an output stream, a precompiled format string,\nand a list of arguments. The arguments will be formatted according to the\nspecified format string into the output stream provided.",null,{"inputs":[{"name":"write"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"entry","core::fmt::builders","Adds a new entry to the list output.",29,{"inputs":[{"name":"debuglist"},{"name":"debug"}],"output":{"name":"debuglist"}}],[11,"entries","","Adds the contents of an iterator of entries to the list output.",29,{"inputs":[{"name":"debuglist"},{"name":"i"}],"output":{"name":"debuglist"}}],[11,"finish","","Finishes output and returns any error encountered.",29,{"inputs":[{"name":"debuglist"}],"output":{"name":"result"}}],[3,"DebugList","collections::fmt","A struct to help with `fmt::Debug` implementations.",null,null],[11,"entry","core::fmt::builders","Adds a new entry to the map output.",30,{"inputs":[{"name":"debugmap"},{"name":"debug"},{"name":"debug"}],"output":{"name":"debugmap"}}],[11,"entries","","Adds the contents of an iterator of entries to the map output.",30,{"inputs":[{"name":"debugmap"},{"name":"i"}],"output":{"name":"debugmap"}}],[11,"finish","","Finishes output and returns any error encountered.",30,{"inputs":[{"name":"debugmap"}],"output":{"name":"result"}}],[3,"DebugMap","collections::fmt","A struct to help with `fmt::Debug` implementations.",null,null],[11,"entry","core::fmt::builders","Adds a new entry to the set output.",31,{"inputs":[{"name":"debugset"},{"name":"debug"}],"output":{"name":"debugset"}}],[11,"entries","","Adds the contents of an iterator of entries to the set output.",31,{"inputs":[{"name":"debugset"},{"name":"i"}],"output":{"name":"debugset"}}],[11,"finish","","Finishes output and returns any error encountered.",31,{"inputs":[{"name":"debugset"}],"output":{"name":"result"}}],[3,"DebugSet","collections::fmt","A struct to help with `fmt::Debug` implementations.",null,null],[11,"field","core::fmt::builders","Adds a new field to the generated struct output.",32,{"inputs":[{"name":"debugstruct"},{"name":"str"},{"name":"debug"}],"output":{"name":"debugstruct"}}],[11,"finish","","Finishes output and returns any error encountered.",32,{"inputs":[{"name":"debugstruct"}],"output":{"name":"result"}}],[3,"DebugStruct","collections::fmt","A struct to help with `fmt::Debug` implementations.",null,null],[11,"field","core::fmt::builders","Adds a new field to the generated tuple struct output.",33,{"inputs":[{"name":"debugtuple"},{"name":"debug"}],"output":{"name":"debugtuple"}}],[11,"finish","","Finishes output and returns any error encountered.",33,{"inputs":[{"name":"debugtuple"}],"output":{"name":"result"}}],[3,"DebugTuple","collections::fmt","A struct to help with `fmt::Debug` implementations.",null,null],[5,"format","","The format function takes a precompiled format string and a list of\narguments, to return the resulting formatted string.",null,{"inputs":[{"name":"arguments"}],"output":{"name":"string"}}],[0,"linked_list","collections","A doubly-linked list with owned nodes.",null,null],[3,"LinkedList","collections::linked_list","A doubly-linked list.",null,null],[3,"Iter","","An iterator over references to the items of a `LinkedList`.",null,null],[3,"IterMut","","An iterator over mutable references to the items of a `LinkedList`.",null,null],[3,"IntoIter","","An iterator over the items of a `LinkedList`.",null,null],[3,"FrontPlace","","A place for insertion at the front of a `LinkedList`.",null,null],[3,"BackPlace","","A place for insertion at the back of a `LinkedList`.",null,null],[11,"clone","","",34,{"inputs":[{"name":"iter"}],"output":{"name":"iter"}}],[11,"clone","","",35,{"inputs":[{"name":"intoiter"}],"output":{"name":"intoiter"}}],[11,"default","","",36,{"inputs":[],"output":{"name":"linkedlist"}}],[11,"new","","Creates an empty `LinkedList`.",36,{"inputs":[],"output":{"name":"linkedlist"}}],[11,"append","","Moves all elements from `other` to the end of the list.",36,{"inputs":[{"name":"linkedlist"},{"name":"linkedlist"}],"output":null}],[11,"iter","","Provides a forward iterator.",36,{"inputs":[{"name":"linkedlist"}],"output":{"name":"iter"}}],[11,"iter_mut","","Provides a forward iterator with mutable references.",36,{"inputs":[{"name":"linkedlist"}],"output":{"name":"itermut"}}],[11,"is_empty","","Returns `true` if the `LinkedList` is empty.",36,{"inputs":[{"name":"linkedlist"}],"output":{"name":"bool"}}],[11,"len","","Returns the length of the `LinkedList`.",36,{"inputs":[{"name":"linkedlist"}],"output":{"name":"usize"}}],[11,"clear","","Removes all elements from the `LinkedList`.",36,{"inputs":[{"name":"linkedlist"}],"output":null}],[11,"front","","Provides a reference to the front element, or `None` if the list is\nempty.",36,{"inputs":[{"name":"linkedlist"}],"output":{"name":"option"}}],[11,"front_mut","","Provides a mutable reference to the front element, or `None` if the list\nis empty.",36,{"inputs":[{"name":"linkedlist"}],"output":{"name":"option"}}],[11,"back","","Provides a reference to the back element, or `None` if the list is\nempty.",36,{"inputs":[{"name":"linkedlist"}],"output":{"name":"option"}}],[11,"back_mut","","Provides a mutable reference to the back element, or `None` if the list\nis empty.",36,{"inputs":[{"name":"linkedlist"}],"output":{"name":"option"}}],[11,"push_front","","Adds an element first in the list.",36,{"inputs":[{"name":"linkedlist"},{"name":"t"}],"output":null}],[11,"pop_front","","Removes the first element and returns it, or `None` if the list is\nempty.",36,{"inputs":[{"name":"linkedlist"}],"output":{"name":"option"}}],[11,"push_back","","Appends an element to the back of a list",36,{"inputs":[{"name":"linkedlist"},{"name":"t"}],"output":null}],[11,"pop_back","","Removes the last element from a list and returns it, or `None` if\nit is empty.",36,{"inputs":[{"name":"linkedlist"}],"output":{"name":"option"}}],[11,"split_off","","Splits the list into two at the given index. Returns everything after the given index,\nincluding the index.",36,{"inputs":[{"name":"linkedlist"},{"name":"usize"}],"output":{"name":"linkedlist"}}],[11,"front_place","","Returns a place for insertion at the front of the list.",36,{"inputs":[{"name":"linkedlist"}],"output":{"name":"frontplace"}}],[11,"back_place","","Returns a place for insertion at the back of the list.",36,{"inputs":[{"name":"linkedlist"}],"output":{"name":"backplace"}}],[11,"drop","","",36,{"inputs":[{"name":"linkedlist"}],"output":null}],[11,"next","","",34,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"size_hint","","",34,null],[11,"next_back","","",34,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"next","","",37,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"size_hint","","",37,null],[11,"next_back","","",37,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"insert_next","","Inserts `elt` just after the element most recently returned by `.next()`.\nThe inserted element does not appear in the iteration.",37,{"inputs":[{"name":"itermut"},{"name":"a"}],"output":null}],[11,"peek_next","","Provides a reference to the next element, without changing the iterator.",37,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"next","","",35,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"size_hint","","",35,null],[11,"next_back","","",35,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"from_iter","","",36,{"inputs":[{"name":"t"}],"output":{"name":"linkedlist"}}],[11,"into_iter","","Consumes the list into an iterator yielding elements by value.",36,{"inputs":[{"name":"linkedlist"}],"output":{"name":"intoiter"}}],[11,"extend","","",36,{"inputs":[{"name":"linkedlist"},{"name":"t"}],"output":null}],[11,"extend","","",36,{"inputs":[{"name":"linkedlist"},{"name":"i"}],"output":null}],[11,"eq","","",36,{"inputs":[{"name":"linkedlist"},{"name":"linkedlist"}],"output":{"name":"bool"}}],[11,"ne","","",36,{"inputs":[{"name":"linkedlist"},{"name":"linkedlist"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",36,{"inputs":[{"name":"linkedlist"},{"name":"linkedlist"}],"output":{"name":"option"}}],[11,"cmp","","",36,{"inputs":[{"name":"linkedlist"},{"name":"linkedlist"}],"output":{"name":"ordering"}}],[11,"clone","","",36,{"inputs":[{"name":"linkedlist"}],"output":{"name":"linkedlist"}}],[11,"fmt","","",36,{"inputs":[{"name":"linkedlist"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",36,{"inputs":[{"name":"linkedlist"},{"name":"h"}],"output":null}],[11,"make_place","","",38,{"inputs":[{"name":"frontplace"}],"output":{"name":"self"}}],[11,"pointer","","",38,null],[11,"finalize","","",38,{"inputs":[{"name":"frontplace"}],"output":null}],[11,"make_place","","",39,{"inputs":[{"name":"backplace"}],"output":{"name":"self"}}],[11,"pointer","","",39,null],[11,"finalize","","",39,{"inputs":[{"name":"backplace"}],"output":null}],[0,"range","collections","Range syntax.",null,null],[8,"RangeArgument","collections::range","**RangeArgument** is implemented by Rust&#39;s built-in range types, produced\nby range syntax like `..`, `a..`, `..b` or `c..d`.",null,null],[11,"start","","Start index (inclusive)",40,{"inputs":[{"name":"rangeargument"}],"output":{"name":"option"}}],[11,"end","","End index (exclusive)",40,{"inputs":[{"name":"rangeargument"}],"output":{"name":"option"}}],[11,"start","core::ops","",41,{"inputs":[{"name":"rangefrom"}],"output":{"name":"option"}}],[11,"end","","",42,{"inputs":[{"name":"rangeto"}],"output":{"name":"option"}}],[11,"start","","",43,{"inputs":[{"name":"range"}],"output":{"name":"option"}}],[11,"end","","",43,{"inputs":[{"name":"range"}],"output":{"name":"option"}}],[0,"slice","collections","A dynamically-sized view into a contiguous sequence, `[T]`.",null,null],[11,"next_back","core::slice","",44,{"inputs":[{"name":"chunks"}],"output":{"name":"option"}}],[11,"next","","",44,{"inputs":[{"name":"chunks"}],"output":{"name":"option"}}],[11,"size_hint","","",44,null],[11,"count","","",44,{"inputs":[{"name":"chunks"}],"output":{"name":"usize"}}],[11,"nth","","",44,{"inputs":[{"name":"chunks"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",44,{"inputs":[{"name":"chunks"}],"output":{"name":"option"}}],[11,"clone","","",44,{"inputs":[{"name":"chunks"}],"output":{"name":"chunks"}}],[11,"fmt","","",44,{"inputs":[{"name":"chunks"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Chunks","collections::slice","An iterator over a slice in (non-overlapping) chunks (`size` elements at a\ntime).",null,null],[11,"next_back","core::slice","",45,{"inputs":[{"name":"windows"}],"output":{"name":"option"}}],[11,"next","","",45,{"inputs":[{"name":"windows"}],"output":{"name":"option"}}],[11,"size_hint","","",45,null],[11,"count","","",45,{"inputs":[{"name":"windows"}],"output":{"name":"usize"}}],[11,"nth","","",45,{"inputs":[{"name":"windows"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",45,{"inputs":[{"name":"windows"}],"output":{"name":"option"}}],[11,"clone","","",45,{"inputs":[{"name":"windows"}],"output":{"name":"windows"}}],[11,"fmt","","",45,{"inputs":[{"name":"windows"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Windows","collections::slice","An iterator over overlapping subslices of length `size`.",null,null],[11,"clone","core::slice","",46,{"inputs":[{"name":"iter"}],"output":{"name":"iter"}}],[11,"next_back","","",46,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"next","","",46,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"size_hint","","",46,null],[11,"count","","",46,{"inputs":[{"name":"iter"}],"output":{"name":"usize"}}],[11,"nth","","",46,{"inputs":[{"name":"iter"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",46,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"as_slice","","View the underlying data as a subslice of the original data.",46,null],[11,"fmt","","",46,{"inputs":[{"name":"iter"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Iter","collections::slice","Immutable slice iterator",null,null],[11,"next_back","core::slice","",47,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"next","","",47,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"size_hint","","",47,null],[11,"count","","",47,{"inputs":[{"name":"itermut"}],"output":{"name":"usize"}}],[11,"nth","","",47,{"inputs":[{"name":"itermut"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",47,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"into_slice","","View the underlying data as a subslice of the original data.",47,null],[11,"fmt","","",47,{"inputs":[{"name":"itermut"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"IterMut","collections::slice","Mutable slice iterator.",null,null],[11,"next_back","core::slice","",48,{"inputs":[{"name":"splitmut"}],"output":{"name":"option"}}],[11,"next","","",48,{"inputs":[{"name":"splitmut"}],"output":{"name":"option"}}],[11,"size_hint","","",48,null],[11,"fmt","","",48,{"inputs":[{"name":"splitmut"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"SplitMut","collections::slice","An iterator over the subslices of the vector which are separated\nby elements that match `pred`.",null,null],[11,"next_back","core::slice","",49,{"inputs":[{"name":"chunksmut"}],"output":{"name":"option"}}],[11,"next","","",49,{"inputs":[{"name":"chunksmut"}],"output":{"name":"option"}}],[11,"size_hint","","",49,null],[11,"count","","",49,{"inputs":[{"name":"chunksmut"}],"output":{"name":"usize"}}],[11,"nth","","",49,{"inputs":[{"name":"chunksmut"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",49,{"inputs":[{"name":"chunksmut"}],"output":{"name":"option"}}],[11,"fmt","","",49,{"inputs":[{"name":"chunksmut"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"ChunksMut","collections::slice","An iterator over a slice in (non-overlapping) mutable chunks (`size`\nelements at a time). When the slice len is not evenly divided by the chunk\nsize, the last slice of the iteration will be the remainder.",null,null],[11,"next_back","core::slice","",50,{"inputs":[{"name":"split"}],"output":{"name":"option"}}],[11,"next","","",50,{"inputs":[{"name":"split"}],"output":{"name":"option"}}],[11,"size_hint","","",50,null],[11,"clone","","",50,{"inputs":[{"name":"split"}],"output":{"name":"split"}}],[11,"fmt","","",50,{"inputs":[{"name":"split"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Split","collections::slice","An iterator over subslices separated by elements that match a predicate\nfunction.",null,null],[11,"next","core::slice","",51,{"inputs":[{"name":"splitn"}],"output":{"name":"option"}}],[11,"size_hint","","",51,null],[11,"fmt","","",51,{"inputs":[{"name":"splitn"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"SplitN","collections::slice","An iterator over subslices separated by elements that match a predicate\nfunction, limited to a given number of splits.",null,null],[11,"next","core::slice","",52,{"inputs":[{"name":"rsplitn"}],"output":{"name":"option"}}],[11,"size_hint","","",52,null],[11,"fmt","","",52,{"inputs":[{"name":"rsplitn"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"RSplitN","collections::slice","An iterator over subslices separated by elements that match a\npredicate function, limited to a given number of splits, starting\nfrom the end of the slice.",null,null],[11,"next","core::slice","",53,{"inputs":[{"name":"splitnmut"}],"output":{"name":"option"}}],[11,"size_hint","","",53,null],[11,"fmt","","",53,{"inputs":[{"name":"splitnmut"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"SplitNMut","collections::slice","An iterator over subslices separated by elements that match a predicate\nfunction, limited to a given number of splits.",null,null],[11,"next","core::slice","",54,{"inputs":[{"name":"rsplitnmut"}],"output":{"name":"option"}}],[11,"size_hint","","",54,null],[11,"fmt","","",54,{"inputs":[{"name":"rsplitnmut"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"RSplitNMut","collections::slice","An iterator over subslices separated by elements that match a\npredicate function, limited to a given number of splits, starting\nfrom the end of the slice.",null,null],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",null,null],[5,"from_raw_parts_mut","","Performs the same functionality as `from_raw_parts`, except that a mutable\nslice is returned.",null,null],[8,"SliceConcatExt","","An extension trait for concatenating slices",null,null],[16,"Output","","The resulting type after concatenation",55,null],[10,"concat","","Flattens a slice of `T` into a single value `Self::Output`.",55,{"inputs":[{"name":"sliceconcatext"}],"output":{"name":"output"}}],[10,"join","","Flattens a slice of `T` into a single value `Self::Output`, placing a\ngiven separator between each.",55,{"inputs":[{"name":"sliceconcatext"},{"name":"t"}],"output":{"name":"output"}}],[10,"connect","","",55,{"inputs":[{"name":"sliceconcatext"},{"name":"t"}],"output":{"name":"output"}}],[0,"str","collections","Unicode string slices.",null,null],[8,"FromStr","collections::str","A trait to abstract the idea of creating a new instance of a type from a\nstring.",null,null],[16,"Err","","The associated error which can be returned from parsing.",56,null],[10,"from_str","","Parses a string `s` to return a value of this type.",56,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"fmt","core::str","",57,{"inputs":[{"name":"utf8error"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"valid_up_to","","Returns the index in the given string up to which valid UTF-8 was\nverified.",57,{"inputs":[{"name":"utf8error"}],"output":{"name":"usize"}}],[11,"fmt","","",57,{"inputs":[{"name":"utf8error"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",57,{"inputs":[{"name":"utf8error"},{"name":"utf8error"}],"output":{"name":"bool"}}],[11,"ne","","",57,{"inputs":[{"name":"utf8error"},{"name":"utf8error"}],"output":{"name":"bool"}}],[11,"clone","","",57,{"inputs":[{"name":"utf8error"}],"output":{"name":"utf8error"}}],[3,"Utf8Error","collections::str","Errors which can occur when attempting to interpret a sequence of `u8`\nas a string.",null,null],[11,"next_back","core::str","",58,{"inputs":[{"name":"lines"}],"output":{"name":"option"}}],[11,"next","","",58,{"inputs":[{"name":"lines"}],"output":{"name":"option"}}],[11,"size_hint","","",58,null],[11,"clone","","",58,{"inputs":[{"name":"lines"}],"output":{"name":"lines"}}],[11,"fmt","","",58,{"inputs":[{"name":"lines"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Lines","collections::str","Created with the method [`lines()`].",null,null],[11,"next_back","core::str","",59,{"inputs":[{"name":"linesany"}],"output":{"name":"option"}}],[11,"next","","",59,{"inputs":[{"name":"linesany"}],"output":{"name":"option"}}],[11,"size_hint","","",59,null],[11,"clone","","",59,{"inputs":[{"name":"linesany"}],"output":{"name":"linesany"}}],[11,"fmt","","",59,{"inputs":[{"name":"linesany"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"LinesAny","collections::str","Created with the method [`lines_any()`].",null,null],[11,"clone","core::str","",60,{"inputs":[{"name":"charrange"}],"output":{"name":"charrange"}}],[11,"fmt","","",60,{"inputs":[{"name":"charrange"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"CharRange","collections::str","Struct that contains a `char` and the index of the first byte of\nthe next `char` in a string.  This can be used as a data structure\nfor iterating over the UTF-8 bytes of a string.",null,null],[12,"ch","","Current `char`",60,null],[12,"next","","Index of the first byte of the next `char`",60,null],[11,"next_back","core::str","",61,{"inputs":[{"name":"split"}],"output":{"name":"option"}}],[11,"clone","","",61,{"inputs":[{"name":"split"}],"output":{"name":"split"}}],[11,"next","","",61,{"inputs":[{"name":"split"}],"output":{"name":"option"}}],[11,"fmt","","",61,{"inputs":[{"name":"split"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Split","collections::str","Created with the method [`split()`].",null,null],[11,"next_back","core::str","",62,{"inputs":[{"name":"rsplit"}],"output":{"name":"option"}}],[11,"clone","","",62,{"inputs":[{"name":"rsplit"}],"output":{"name":"rsplit"}}],[11,"next","","",62,{"inputs":[{"name":"rsplit"}],"output":{"name":"option"}}],[11,"fmt","","",62,{"inputs":[{"name":"rsplit"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"RSplit","collections::str","Created with the method [`rsplit()`].",null,null],[11,"clone","core::str","",63,{"inputs":[{"name":"splitn"}],"output":{"name":"splitn"}}],[11,"next","","",63,{"inputs":[{"name":"splitn"}],"output":{"name":"option"}}],[11,"fmt","","",63,{"inputs":[{"name":"splitn"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"SplitN","collections::str","Created with the method [`splitn()`].",null,null],[11,"clone","core::str","",64,{"inputs":[{"name":"rsplitn"}],"output":{"name":"rsplitn"}}],[11,"next","","",64,{"inputs":[{"name":"rsplitn"}],"output":{"name":"option"}}],[11,"fmt","","",64,{"inputs":[{"name":"rsplitn"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"RSplitN","collections::str","Created with the method [`rsplitn()`].",null,null],[11,"next_back","core::str","",65,{"inputs":[{"name":"splitterminator"}],"output":{"name":"option"}}],[11,"clone","","",65,{"inputs":[{"name":"splitterminator"}],"output":{"name":"splitterminator"}}],[11,"next","","",65,{"inputs":[{"name":"splitterminator"}],"output":{"name":"option"}}],[11,"fmt","","",65,{"inputs":[{"name":"splitterminator"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"SplitTerminator","collections::str","Created with the method [`split_terminator()`].",null,null],[11,"next_back","core::str","",66,{"inputs":[{"name":"rsplitterminator"}],"output":{"name":"option"}}],[11,"clone","","",66,{"inputs":[{"name":"rsplitterminator"}],"output":{"name":"rsplitterminator"}}],[11,"next","","",66,{"inputs":[{"name":"rsplitterminator"}],"output":{"name":"option"}}],[11,"fmt","","",66,{"inputs":[{"name":"rsplitterminator"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"RSplitTerminator","collections::str","Created with the method [`rsplit_terminator()`].",null,null],[11,"next_back","core::str","",67,{"inputs":[{"name":"matches"}],"output":{"name":"option"}}],[11,"clone","","",67,{"inputs":[{"name":"matches"}],"output":{"name":"matches"}}],[11,"next","","",67,{"inputs":[{"name":"matches"}],"output":{"name":"option"}}],[11,"fmt","","",67,{"inputs":[{"name":"matches"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Matches","collections::str","Created with the method [`matches()`].",null,null],[11,"next_back","core::str","",68,{"inputs":[{"name":"rmatches"}],"output":{"name":"option"}}],[11,"clone","","",68,{"inputs":[{"name":"rmatches"}],"output":{"name":"rmatches"}}],[11,"next","","",68,{"inputs":[{"name":"rmatches"}],"output":{"name":"option"}}],[11,"fmt","","",68,{"inputs":[{"name":"rmatches"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"RMatches","collections::str","Created with the method [`rmatches()`].",null,null],[11,"next_back","core::str","",69,{"inputs":[{"name":"matchindices"}],"output":{"name":"option"}}],[11,"clone","","",69,{"inputs":[{"name":"matchindices"}],"output":{"name":"matchindices"}}],[11,"next","","",69,{"inputs":[{"name":"matchindices"}],"output":{"name":"option"}}],[11,"fmt","","",69,{"inputs":[{"name":"matchindices"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"MatchIndices","collections::str","Created with the method [`match_indices()`].",null,null],[11,"next_back","core::str","",70,{"inputs":[{"name":"rmatchindices"}],"output":{"name":"option"}}],[11,"clone","","",70,{"inputs":[{"name":"rmatchindices"}],"output":{"name":"rmatchindices"}}],[11,"next","","",70,{"inputs":[{"name":"rmatchindices"}],"output":{"name":"option"}}],[11,"fmt","","",70,{"inputs":[{"name":"rmatchindices"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"RMatchIndices","collections::str","Created with the method [`rmatch_indices()`].",null,null],[5,"from_utf8","","Converts a slice of bytes to a string slice.",null,null],[11,"as_str","core::str","View the underlying data as a subslice of the original data.",71,{"inputs":[{"name":"chars"}],"output":{"name":"str"}}],[11,"next_back","","",71,{"inputs":[{"name":"chars"}],"output":{"name":"option"}}],[11,"next","","",71,{"inputs":[{"name":"chars"}],"output":{"name":"option"}}],[11,"size_hint","","",71,null],[11,"clone","","",71,{"inputs":[{"name":"chars"}],"output":{"name":"chars"}}],[11,"fmt","","",71,{"inputs":[{"name":"chars"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Chars","collections::str","Iterator for the char (representing *Unicode Scalar Values*) of a string",null,null],[11,"as_str","core::str","View the underlying data as a subslice of the original data.",72,{"inputs":[{"name":"charindices"}],"output":{"name":"str"}}],[11,"next_back","","",72,{"inputs":[{"name":"charindices"}],"output":{"name":"option"}}],[11,"next","","",72,{"inputs":[{"name":"charindices"}],"output":{"name":"option"}}],[11,"size_hint","","",72,null],[11,"clone","","",72,{"inputs":[{"name":"charindices"}],"output":{"name":"charindices"}}],[11,"fmt","","",72,{"inputs":[{"name":"charindices"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"CharIndices","collections::str","Iterator for a string&#39;s characters and their byte offsets.",null,null],[11,"len","core::str","",73,{"inputs":[{"name":"bytes"}],"output":{"name":"usize"}}],[11,"next_back","","",73,{"inputs":[{"name":"bytes"}],"output":{"name":"option"}}],[11,"next","","",73,{"inputs":[{"name":"bytes"}],"output":{"name":"option"}}],[11,"size_hint","","",73,null],[11,"count","","",73,{"inputs":[{"name":"bytes"}],"output":{"name":"usize"}}],[11,"last","","",73,{"inputs":[{"name":"bytes"}],"output":{"name":"option"}}],[11,"nth","","",73,{"inputs":[{"name":"bytes"},{"name":"usize"}],"output":{"name":"option"}}],[11,"clone","","",73,{"inputs":[{"name":"bytes"}],"output":{"name":"bytes"}}],[11,"fmt","","",73,{"inputs":[{"name":"bytes"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Bytes","collections::str","External iterator for a string&#39;s bytes.\nUse with the `std::iter` module.",null,null],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without checking\nthat the string contains valid UTF-8.",null,null],[11,"clone","core::str","",74,{"inputs":[{"name":"parseboolerror"}],"output":{"name":"parseboolerror"}}],[11,"eq","","",74,{"inputs":[{"name":"parseboolerror"},{"name":"parseboolerror"}],"output":{"name":"bool"}}],[11,"ne","","",74,{"inputs":[{"name":"parseboolerror"},{"name":"parseboolerror"}],"output":{"name":"bool"}}],[11,"fmt","","",74,{"inputs":[{"name":"parseboolerror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",74,{"inputs":[{"name":"parseboolerror"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"ParseBoolError","collections::str","An error returned when parsing a `bool` from a string fails.",null,null],[11,"next_back","rustc_unicode::u_str","",75,{"inputs":[{"name":"splitwhitespace"}],"output":{"name":"option"}}],[11,"next","","",75,{"inputs":[{"name":"splitwhitespace"}],"output":{"name":"option"}}],[3,"SplitWhitespace","collections::str","An iterator over the non-whitespace substrings of a string,\nseparated by any amount of whitespace.",null,null],[0,"pattern","","The string Pattern API.",null,null],[8,"Pattern","collections::str::pattern","A string pattern.",null,null],[16,"Searcher","","Associated searcher for this pattern",76,null],[10,"into_searcher","","Constructs the associated searcher from\n`self` and the `haystack` to search in.",76,null],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",76,{"inputs":[{"name":"pattern"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",76,{"inputs":[{"name":"pattern"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",76,{"inputs":[{"name":"pattern"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","core::str::pattern","",77,{"inputs":[{"name":"searchstep"},{"name":"searchstep"}],"output":{"name":"bool"}}],[11,"ne","","",77,{"inputs":[{"name":"searchstep"},{"name":"searchstep"}],"output":{"name":"bool"}}],[11,"fmt","","",77,{"inputs":[{"name":"searchstep"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",77,{"inputs":[{"name":"searchstep"}],"output":{"name":"searchstep"}}],[4,"SearchStep","collections::str::pattern","Result of calling `Searcher::next()` or `ReverseSearcher::next_back()`.",null,null],[13,"Match","","Expresses that a match of the pattern has been found at\n`haystack[a..b]`.",77,null],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a possible match\nof the pattern.",77,null],[13,"Done","","Expresses that every byte of the haystack has been visted, ending\nthe iteration.",77,null],[8,"Searcher","","A searcher for a string pattern.",null,null],[10,"haystack","","Getter for the underlaying string to be searched in",78,{"inputs":[{"name":"searcher"}],"output":{"name":"str"}}],[10,"next","","Performs the next search step starting from the front.",78,{"inputs":[{"name":"searcher"}],"output":{"name":"searchstep"}}],[11,"next_match","","Find the next `Match` result. See `next()`",78,{"inputs":[{"name":"searcher"}],"output":{"name":"option"}}],[11,"next_reject","","Find the next `Reject` result. See `next()`",78,{"inputs":[{"name":"searcher"}],"output":{"name":"option"}}],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",null,null],[10,"next_back","","Performs the next search step starting from the back.",79,{"inputs":[{"name":"reversesearcher"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","Find the next `Match` result. See `next_back()`",79,{"inputs":[{"name":"reversesearcher"}],"output":{"name":"option"}}],[11,"next_reject_back","","Find the next `Reject` result. See `next_back()`",79,{"inputs":[{"name":"reversesearcher"}],"output":{"name":"option"}}],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher`\ncan be used for a `DoubleEndedIterator` implementation.",null,null],[11,"next_back","core::str::pattern","",80,{"inputs":[{"name":"charsearcher"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",80,{"inputs":[{"name":"charsearcher"}],"output":{"name":"option"}}],[11,"next_reject_back","","",80,{"inputs":[{"name":"charsearcher"}],"output":{"name":"option"}}],[11,"haystack","","",80,{"inputs":[{"name":"charsearcher"}],"output":{"name":"str"}}],[11,"next","","",80,{"inputs":[{"name":"charsearcher"}],"output":{"name":"searchstep"}}],[11,"next_match","","",80,{"inputs":[{"name":"charsearcher"}],"output":{"name":"option"}}],[11,"next_reject","","",80,{"inputs":[{"name":"charsearcher"}],"output":{"name":"option"}}],[11,"clone","","",80,{"inputs":[{"name":"charsearcher"}],"output":{"name":"charsearcher"}}],[11,"fmt","","",80,{"inputs":[{"name":"charsearcher"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"CharSearcher","collections::str::pattern","Associated type for `&lt;char as Pattern&lt;&#39;a&gt;&gt;::Searcher`.",null,null],[11,"clone","core::str::pattern","",81,{"inputs":[{"name":"charslicesearcher"}],"output":{"name":"charslicesearcher"}}],[11,"next_back","","",81,{"inputs":[{"name":"charslicesearcher"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",81,{"inputs":[{"name":"charslicesearcher"}],"output":{"name":"option"}}],[11,"next_reject_back","","",81,{"inputs":[{"name":"charslicesearcher"}],"output":{"name":"option"}}],[11,"fmt","","",81,{"inputs":[{"name":"charslicesearcher"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"haystack","","",81,{"inputs":[{"name":"charslicesearcher"}],"output":{"name":"str"}}],[11,"next","","",81,{"inputs":[{"name":"charslicesearcher"}],"output":{"name":"searchstep"}}],[11,"next_match","","",81,{"inputs":[{"name":"charslicesearcher"}],"output":{"name":"option"}}],[11,"next_reject","","",81,{"inputs":[{"name":"charslicesearcher"}],"output":{"name":"option"}}],[3,"CharSliceSearcher","collections::str::pattern","Associated type for `&lt;&amp;[char] as Pattern&lt;&#39;a&gt;&gt;::Searcher`.",null,null],[11,"next_back","core::str::pattern","",82,{"inputs":[{"name":"charpredicatesearcher"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",82,{"inputs":[{"name":"charpredicatesearcher"}],"output":{"name":"option"}}],[11,"next_reject_back","","",82,{"inputs":[{"name":"charpredicatesearcher"}],"output":{"name":"option"}}],[11,"haystack","","",82,{"inputs":[{"name":"charpredicatesearcher"}],"output":{"name":"str"}}],[11,"next","","",82,{"inputs":[{"name":"charpredicatesearcher"}],"output":{"name":"searchstep"}}],[11,"next_match","","",82,{"inputs":[{"name":"charpredicatesearcher"}],"output":{"name":"option"}}],[11,"next_reject","","",82,{"inputs":[{"name":"charpredicatesearcher"}],"output":{"name":"option"}}],[11,"fmt","","",82,{"inputs":[{"name":"charpredicatesearcher"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",82,{"inputs":[{"name":"charpredicatesearcher"}],"output":{"name":"charpredicatesearcher"}}],[3,"CharPredicateSearcher","collections::str::pattern","Associated type for `&lt;F as Pattern&lt;&#39;a&gt;&gt;::Searcher`.",null,null],[11,"haystack","core::str::pattern","",83,{"inputs":[{"name":"strsearcher"}],"output":{"name":"str"}}],[11,"next","","",83,{"inputs":[{"name":"strsearcher"}],"output":{"name":"searchstep"}}],[11,"next_match","","",83,{"inputs":[{"name":"strsearcher"}],"output":{"name":"option"}}],[11,"next_back","","",83,{"inputs":[{"name":"strsearcher"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",83,{"inputs":[{"name":"strsearcher"}],"output":{"name":"option"}}],[11,"clone","","",83,{"inputs":[{"name":"strsearcher"}],"output":{"name":"strsearcher"}}],[11,"fmt","","",83,{"inputs":[{"name":"strsearcher"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"StrSearcher","collections::str::pattern","Associated type for `&lt;&amp;str as Pattern&lt;&#39;a&gt;&gt;::Searcher`.",null,null],[3,"EncodeUtf16","collections::str","External iterator for a string&#39;s UTF-16 code units.",null,null],[6,"Utf16Units","","Deprecated, renamed to EncodeUtf16",null,null],[11,"clone","","",84,{"inputs":[{"name":"encodeutf16"}],"output":{"name":"encodeutf16"}}],[11,"next","","",84,{"inputs":[{"name":"encodeutf16"}],"output":{"name":"option"}}],[11,"size_hint","","",84,null],[0,"string","collections","A UTF-8 encoded, growable string.",null,null],[3,"String","collections::string","A UTF-8 encoded, growable string.",null,null],[3,"FromUtf8Error","","A possible error value when converting a `String` from a UTF-8 byte vector.",null,null],[3,"FromUtf16Error","","A possible error value when converting a `String` from a UTF-16 byte slice.",null,null],[3,"Drain","","A draining iterator for `String`.",null,null],[4,"ParseError","","An error when parsing a `String`.",null,null],[8,"ToString","","A trait for converting a value to a `String`.",null,null],[10,"to_string","","Converts the given value to a `String`.",85,{"inputs":[{"name":"tostring"}],"output":{"name":"string"}}],[11,"cmp","","",86,{"inputs":[{"name":"string"},{"name":"string"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",86,{"inputs":[{"name":"string"},{"name":"string"}],"output":{"name":"option"}}],[11,"lt","","",86,{"inputs":[{"name":"string"},{"name":"string"}],"output":{"name":"bool"}}],[11,"le","","",86,{"inputs":[{"name":"string"},{"name":"string"}],"output":{"name":"bool"}}],[11,"gt","","",86,{"inputs":[{"name":"string"},{"name":"string"}],"output":{"name":"bool"}}],[11,"ge","","",86,{"inputs":[{"name":"string"},{"name":"string"}],"output":{"name":"bool"}}],[11,"fmt","","",87,{"inputs":[{"name":"fromutf8error"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",88,{"inputs":[{"name":"fromutf16error"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new empty `String`.",86,{"inputs":[],"output":{"name":"string"}}],[11,"with_capacity","","Creates a new empty `String` with a particular capacity.",86,{"inputs":[{"name":"usize"}],"output":{"name":"string"}}],[11,"from_utf8","","Converts a vector of bytes to a `String`.",86,{"inputs":[{"name":"vec"}],"output":{"name":"result"}}],[11,"from_utf8_lossy","","Converts a slice of bytes to a string, including invalid characters.",86,null],[11,"from_utf16","","Decode a UTF-16 encoded vector `v` into a `String`, returning `Err`\nif `v` contains any invalid data.",86,null],[11,"from_utf16_lossy","","Decode a UTF-16 encoded vector `v` into a string, replacing\ninvalid data with the replacement character (U+FFFD).",86,null],[11,"from_raw_parts","","Creates a new `String` from a length, capacity, and pointer.",86,null],[11,"from_utf8_unchecked","","Converts a vector of bytes to a `String` without checking that the\nstring contains valid UTF-8.",86,{"inputs":[{"name":"vec"}],"output":{"name":"string"}}],[11,"into_bytes","","Converts a `String` into a byte vector.",86,{"inputs":[{"name":"string"}],"output":{"name":"vec"}}],[11,"as_str","","Extracts a string slice containing the entire string.",86,{"inputs":[{"name":"string"}],"output":{"name":"str"}}],[11,"as_mut_str","","Extracts a string slice containing the entire string.",86,{"inputs":[{"name":"string"}],"output":{"name":"str"}}],[11,"push_str","","Appends a given string slice onto the end of this `String`.",86,{"inputs":[{"name":"string"},{"name":"str"}],"output":null}],[11,"capacity","","Returns this `String`&#39;s capacity, in bytes.",86,{"inputs":[{"name":"string"}],"output":{"name":"usize"}}],[11,"reserve","","Ensures that this `String`&#39;s capacity is at least `additional` bytes\nlarger than its length.",86,{"inputs":[{"name":"string"},{"name":"usize"}],"output":null}],[11,"reserve_exact","","Ensures that this `String`&#39;s capacity is `additional` bytes\nlarger than its length.",86,{"inputs":[{"name":"string"},{"name":"usize"}],"output":null}],[11,"shrink_to_fit","","Shrinks the capacity of this `String` to match its length.",86,{"inputs":[{"name":"string"}],"output":null}],[11,"push","","Appends the given `char` to the end of this `String`.",86,{"inputs":[{"name":"string"},{"name":"char"}],"output":null}],[11,"as_bytes","","Returns a byte slice of this `String`&#39;s contents.",86,null],[11,"truncate","","Shortens this `String` to the specified length.",86,{"inputs":[{"name":"string"},{"name":"usize"}],"output":null}],[11,"pop","","Removes the last character from the string buffer and returns it.",86,{"inputs":[{"name":"string"}],"output":{"name":"option"}}],[11,"remove","","Removes a `char` from this `String` at a byte position and returns it.",86,{"inputs":[{"name":"string"},{"name":"usize"}],"output":{"name":"char"}}],[11,"insert","","Inserts a character into this `String` at a byte position.",86,{"inputs":[{"name":"string"},{"name":"usize"},{"name":"char"}],"output":null}],[11,"as_mut_vec","","Returns a mutable reference to the contents of this `String`.",86,{"inputs":[{"name":"string"}],"output":{"name":"vec"}}],[11,"len","","Returns the length of this `String`, in bytes.",86,{"inputs":[{"name":"string"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns `true` if this `String` has a length of zero.",86,{"inputs":[{"name":"string"}],"output":{"name":"bool"}}],[11,"clear","","Truncates this `String`, removing all contents.",86,{"inputs":[{"name":"string"}],"output":null}],[11,"drain","","Create a draining iterator that removes the specified range in the string\nand yields the removed chars.",86,{"inputs":[{"name":"string"},{"name":"r"}],"output":{"name":"drain"}}],[11,"into_boxed_str","","Converts this `String` into a `Box&lt;str&gt;`.",86,{"inputs":[{"name":"string"}],"output":{"name":"box"}}],[11,"into_bytes","","Returns the bytes that were attempted to convert to a `String`.",87,{"inputs":[{"name":"fromutf8error"}],"output":{"name":"vec"}}],[11,"utf8_error","","Fetch a `Utf8Error` to get more details about the conversion failure.",87,{"inputs":[{"name":"fromutf8error"}],"output":{"name":"utf8error"}}],[11,"fmt","","",87,{"inputs":[{"name":"fromutf8error"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",88,{"inputs":[{"name":"fromutf16error"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",86,{"inputs":[{"name":"string"}],"output":{"name":"self"}}],[11,"clone_from","","",86,{"inputs":[{"name":"string"},{"name":"self"}],"output":null}],[11,"from_iter","","",86,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","","",86,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","","",86,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"extend","","",86,{"inputs":[{"name":"string"},{"name":"i"}],"output":null}],[11,"extend","","",86,{"inputs":[{"name":"string"},{"name":"i"}],"output":null}],[11,"extend","","",86,{"inputs":[{"name":"string"},{"name":"i"}],"output":null}],[11,"extend","","",86,{"inputs":[{"name":"string"},{"name":"i"}],"output":null}],[11,"eq","","",86,{"inputs":[{"name":"string"},{"name":"string"}],"output":{"name":"bool"}}],[11,"ne","","",86,{"inputs":[{"name":"string"},{"name":"string"}],"output":{"name":"bool"}}],[11,"eq","","",86,{"inputs":[{"name":"string"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",86,{"inputs":[{"name":"string"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","","",86,{"inputs":[{"name":"string"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",86,{"inputs":[{"name":"string"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","collections::borrow","",11,{"inputs":[{"name":"cow"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",11,{"inputs":[{"name":"cow"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","","",11,{"inputs":[{"name":"cow"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",11,{"inputs":[{"name":"cow"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","","",11,{"inputs":[{"name":"cow"},{"name":"string"}],"output":{"name":"bool"}}],[11,"ne","","",11,{"inputs":[{"name":"cow"},{"name":"string"}],"output":{"name":"bool"}}],[11,"eq","collections::string","",86,{"inputs":[{"name":"string"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"ne","","",86,{"inputs":[{"name":"string"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"default","","",86,{"inputs":[],"output":{"name":"string"}}],[11,"fmt","","",86,{"inputs":[{"name":"string"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",86,{"inputs":[{"name":"string"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",86,{"inputs":[{"name":"string"},{"name":"h"}],"output":null}],[11,"add","","",86,{"inputs":[{"name":"string"},{"name":"str"}],"output":{"name":"string"}}],[11,"index","","",86,{"inputs":[{"name":"string"},{"name":"range"}],"output":{"name":"str"}}],[11,"index","","",86,{"inputs":[{"name":"string"},{"name":"rangeto"}],"output":{"name":"str"}}],[11,"index","","",86,{"inputs":[{"name":"string"},{"name":"rangefrom"}],"output":{"name":"str"}}],[11,"index","","",86,{"inputs":[{"name":"string"},{"name":"rangefull"}],"output":{"name":"str"}}],[11,"index","","",86,{"inputs":[{"name":"string"},{"name":"rangeinclusive"}],"output":{"name":"str"}}],[11,"index","","",86,{"inputs":[{"name":"string"},{"name":"rangetoinclusive"}],"output":{"name":"str"}}],[11,"index_mut","","",86,{"inputs":[{"name":"string"},{"name":"range"}],"output":{"name":"str"}}],[11,"index_mut","","",86,{"inputs":[{"name":"string"},{"name":"rangeto"}],"output":{"name":"str"}}],[11,"index_mut","","",86,{"inputs":[{"name":"string"},{"name":"rangefrom"}],"output":{"name":"str"}}],[11,"index_mut","","",86,{"inputs":[{"name":"string"},{"name":"rangefull"}],"output":{"name":"str"}}],[11,"index_mut","","",86,{"inputs":[{"name":"string"},{"name":"rangeinclusive"}],"output":{"name":"str"}}],[11,"index_mut","","",86,{"inputs":[{"name":"string"},{"name":"rangetoinclusive"}],"output":{"name":"str"}}],[11,"deref","","",86,{"inputs":[{"name":"string"}],"output":{"name":"str"}}],[11,"deref_mut","","",86,{"inputs":[{"name":"string"}],"output":{"name":"str"}}],[11,"from_str","","",86,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"clone","","",89,{"inputs":[{"name":"parseerror"}],"output":{"name":"parseerror"}}],[11,"fmt","","",89,{"inputs":[{"name":"parseerror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",89,{"inputs":[{"name":"parseerror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",89,{"inputs":[{"name":"parseerror"},{"name":"parseerror"}],"output":{"name":"bool"}}],[11,"as_ref","","",86,{"inputs":[{"name":"string"}],"output":{"name":"str"}}],[11,"as_ref","","",86,null],[11,"from","","",86,{"inputs":[{"name":"str"}],"output":{"name":"string"}}],[11,"from","collections::borrow","",11,{"inputs":[{"name":"str"}],"output":{"name":"cow"}}],[11,"from","","",11,{"inputs":[{"name":"string"}],"output":{"name":"cow"}}],[11,"into","collections::string","",86,{"inputs":[{"name":"string"}],"output":{"name":"vec"}}],[11,"write_str","","",86,{"inputs":[{"name":"string"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","",86,{"inputs":[{"name":"string"},{"name":"char"}],"output":{"name":"result"}}],[11,"drop","","",90,{"inputs":[{"name":"drain"}],"output":null}],[11,"next","","",90,{"inputs":[{"name":"drain"}],"output":{"name":"option"}}],[11,"size_hint","","",90,null],[11,"next_back","","",90,{"inputs":[{"name":"drain"}],"output":{"name":"option"}}],[0,"vec","collections","A contiguous growable array type with heap-allocated contents, written\n`Vec&lt;T&gt;` but pronounced &#39;vector.&#39;",null,null],[3,"Vec","collections::vec","A contiguous growable array type, written `Vec&lt;T&gt;` but pronounced &#39;vector.&#39;",null,null],[3,"IntoIter","","An iterator that moves out of a vector.",null,null],[3,"Drain","","A draining iterator for `Vec&lt;T&gt;`.",null,null],[11,"new","","Constructs a new, empty `Vec&lt;T&gt;`.",91,{"inputs":[],"output":{"name":"vec"}}],[11,"with_capacity","","Constructs a new, empty `Vec&lt;T&gt;` with the specified capacity.",91,{"inputs":[{"name":"usize"}],"output":{"name":"vec"}}],[11,"from_raw_parts","","Creates a `Vec&lt;T&gt;` directly from the raw components of another vector.",91,null],[11,"capacity","","Returns the number of elements the vector can hold without\nreallocating.",91,{"inputs":[{"name":"vec"}],"output":{"name":"usize"}}],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted\nin the given `Vec&lt;T&gt;`. The collection may reserve more space to avoid\nfrequent reallocations.",91,{"inputs":[{"name":"vec"},{"name":"usize"}],"output":null}],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to\nbe inserted in the given `Vec&lt;T&gt;`. Does nothing if the capacity is already\nsufficient.",91,{"inputs":[{"name":"vec"},{"name":"usize"}],"output":null}],[11,"shrink_to_fit","","Shrinks the capacity of the vector as much as possible.",91,{"inputs":[{"name":"vec"}],"output":null}],[11,"into_boxed_slice","","Converts the vector into Box&lt;[T]&gt;.",91,{"inputs":[{"name":"vec"}],"output":{"name":"box"}}],[11,"truncate","","Shorten a vector to be `len` elements long, dropping excess elements.",91,{"inputs":[{"name":"vec"},{"name":"usize"}],"output":null}],[11,"as_slice","","Extracts a slice containing the entire vector.",91,null],[11,"as_mut_slice","","Extracts a mutable slice of the entire vector.",91,null],[11,"set_len","","Sets the length of a vector.",91,{"inputs":[{"name":"vec"},{"name":"usize"}],"output":null}],[11,"swap_remove","","Removes an element from anywhere in the vector and return it, replacing\nit with the last element.",91,{"inputs":[{"name":"vec"},{"name":"usize"}],"output":{"name":"t"}}],[11,"insert","","Inserts an element at position `index` within the vector, shifting all\nelements after it to the right.",91,{"inputs":[{"name":"vec"},{"name":"usize"},{"name":"t"}],"output":null}],[11,"remove","","Removes and returns the element at position `index` within the vector,\nshifting all elements after it to the left.",91,{"inputs":[{"name":"vec"},{"name":"usize"}],"output":{"name":"t"}}],[11,"retain","","Retains only the elements specified by the predicate.",91,{"inputs":[{"name":"vec"},{"name":"f"}],"output":null}],[11,"push","","Appends an element to the back of a collection.",91,{"inputs":[{"name":"vec"},{"name":"t"}],"output":null}],[11,"pop","","Removes the last element from a vector and returns it, or `None` if it\nis empty.",91,{"inputs":[{"name":"vec"}],"output":{"name":"option"}}],[11,"append","","Moves all the elements of `other` into `Self`, leaving `other` empty.",91,{"inputs":[{"name":"vec"},{"name":"self"}],"output":null}],[11,"drain","","Create a draining iterator that removes the specified range in the vector\nand yields the removed items.",91,{"inputs":[{"name":"vec"},{"name":"r"}],"output":{"name":"drain"}}],[11,"clear","","Clears the vector, removing all values.",91,{"inputs":[{"name":"vec"}],"output":null}],[11,"len","","Returns the number of elements in the vector.",91,{"inputs":[{"name":"vec"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns `true` if the vector contains no elements.",91,{"inputs":[{"name":"vec"}],"output":{"name":"bool"}}],[11,"split_off","","Splits the collection into two at the given index.",91,{"inputs":[{"name":"vec"},{"name":"usize"}],"output":{"name":"self"}}],[11,"resize","","Resizes the `Vec` in-place so that `len()` is equal to `new_len`.",91,{"inputs":[{"name":"vec"},{"name":"usize"},{"name":"t"}],"output":null}],[11,"extend_from_slice","","Appends all elements in a slice to the `Vec`.",91,null],[11,"dedup","","Removes consecutive repeated elements in the vector.",91,{"inputs":[{"name":"vec"}],"output":null}],[11,"clone","","",91,{"inputs":[{"name":"vec"}],"output":{"name":"vec"}}],[11,"clone_from","","",91,{"inputs":[{"name":"vec"},{"name":"vec"}],"output":null}],[11,"hash","","",91,{"inputs":[{"name":"vec"},{"name":"h"}],"output":null}],[11,"index","","",91,{"inputs":[{"name":"vec"},{"name":"usize"}],"output":{"name":"t"}}],[11,"index_mut","","",91,{"inputs":[{"name":"vec"},{"name":"usize"}],"output":{"name":"t"}}],[11,"index","","",91,null],[11,"index","","",91,null],[11,"index","","",91,null],[11,"index","","",91,null],[11,"index","","",91,null],[11,"index","","",91,null],[11,"index_mut","","",91,null],[11,"index_mut","","",91,null],[11,"index_mut","","",91,null],[11,"index_mut","","",91,null],[11,"index_mut","","",91,null],[11,"index_mut","","",91,null],[11,"deref","","",91,null],[11,"deref_mut","","",91,null],[11,"from_iter","","",91,{"inputs":[{"name":"i"}],"output":{"name":"vec"}}],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each value out of\nthe vector (from start to end). The vector cannot be used after calling\nthis.",91,{"inputs":[{"name":"vec"}],"output":{"name":"intoiter"}}],[11,"extend","","",91,{"inputs":[{"name":"vec"},{"name":"i"}],"output":null}],[11,"extend","","",91,{"inputs":[{"name":"vec"},{"name":"i"}],"output":null}],[11,"eq","","",91,{"inputs":[{"name":"vec"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"ne","","",91,{"inputs":[{"name":"vec"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","collections::borrow","",11,null],[11,"ne","","",11,null],[11,"eq","","",11,null],[11,"ne","","",11,null],[11,"eq","","",11,{"inputs":[{"name":"cow"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"ne","","",11,{"inputs":[{"name":"cow"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"eq","collections::vec","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"eq","","",91,null],[11,"ne","","",91,null],[11,"partial_cmp","","",91,{"inputs":[{"name":"vec"},{"name":"vec"}],"output":{"name":"option"}}],[11,"cmp","","",91,{"inputs":[{"name":"vec"},{"name":"vec"}],"output":{"name":"ordering"}}],[11,"drop","","",91,{"inputs":[{"name":"vec"}],"output":null}],[11,"default","","",91,{"inputs":[],"output":{"name":"vec"}}],[11,"fmt","","",91,{"inputs":[{"name":"vec"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_ref","","",91,{"inputs":[{"name":"vec"}],"output":{"name":"vec"}}],[11,"as_mut","","",91,{"inputs":[{"name":"vec"}],"output":{"name":"vec"}}],[11,"as_ref","","",91,null],[11,"as_mut","","",91,null],[11,"from","","",91,null],[11,"from","","",91,{"inputs":[{"name":"str"}],"output":{"name":"vec"}}],[11,"from","collections::borrow","",11,null],[11,"from","","",11,{"inputs":[{"name":"vec"}],"output":{"name":"cow"}}],[11,"from_iter","","",11,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"next","collections::vec","",92,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"size_hint","","",92,null],[11,"count","","",92,{"inputs":[{"name":"intoiter"}],"output":{"name":"usize"}}],[11,"next_back","","",92,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"clone","","",92,{"inputs":[{"name":"intoiter"}],"output":{"name":"intoiter"}}],[11,"drop","","",92,{"inputs":[{"name":"intoiter"}],"output":null}],[11,"next","","",93,{"inputs":[{"name":"drain"}],"output":{"name":"option"}}],[11,"size_hint","","",93,null],[11,"next_back","","",93,{"inputs":[{"name":"drain"}],"output":{"name":"option"}}],[11,"drop","","",93,{"inputs":[{"name":"drain"}],"output":null}],[0,"vec_deque","collections","VecDeque is a double-ended queue, which is implemented with the help of a\ngrowing ring buffer.",null,null],[3,"VecDeque","collections::vec_deque","`VecDeque` is a growable ring buffer, which can be used as a double-ended\nqueue efficiently.",null,null],[3,"Iter","","`VecDeque` iterator.",null,null],[3,"IterMut","","`VecDeque` mutable iterator.",null,null],[3,"IntoIter","","A by-value VecDeque iterator",null,null],[3,"Drain","","A draining VecDeque iterator",null,null],[11,"clone","","",94,{"inputs":[{"name":"vecdeque"}],"output":{"name":"vecdeque"}}],[11,"drop","","",94,{"inputs":[{"name":"vecdeque"}],"output":null}],[11,"default","","",94,{"inputs":[],"output":{"name":"vecdeque"}}],[11,"new","","Creates an empty `VecDeque`.",94,{"inputs":[],"output":{"name":"vecdeque"}}],[11,"with_capacity","","Creates an empty `VecDeque` with space for at least `n` elements.",94,{"inputs":[{"name":"usize"}],"output":{"name":"vecdeque"}}],[11,"get","","Retrieves an element in the `VecDeque` by index.",94,{"inputs":[{"name":"vecdeque"},{"name":"usize"}],"output":{"name":"option"}}],[11,"get_mut","","Retrieves an element in the `VecDeque` mutably by index.",94,{"inputs":[{"name":"vecdeque"},{"name":"usize"}],"output":{"name":"option"}}],[11,"swap","","Swaps elements at indices `i` and `j`.",94,{"inputs":[{"name":"vecdeque"},{"name":"usize"},{"name":"usize"}],"output":null}],[11,"capacity","","Returns the number of elements the `VecDeque` can hold without\nreallocating.",94,{"inputs":[{"name":"vecdeque"}],"output":{"name":"usize"}}],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the\ngiven `VecDeque`. Does nothing if the capacity is already sufficient.",94,{"inputs":[{"name":"vecdeque"},{"name":"usize"}],"output":null}],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the given\n`VecDeque`. The collection may reserve more space to avoid frequent reallocations.",94,{"inputs":[{"name":"vecdeque"},{"name":"usize"}],"output":null}],[11,"shrink_to_fit","","Shrinks the capacity of the `VecDeque` as much as possible.",94,{"inputs":[{"name":"vecdeque"}],"output":null}],[11,"truncate","","Shortens a `VecDeque`, dropping excess elements from the back.",94,{"inputs":[{"name":"vecdeque"},{"name":"usize"}],"output":null}],[11,"iter","","Returns a front-to-back iterator.",94,{"inputs":[{"name":"vecdeque"}],"output":{"name":"iter"}}],[11,"iter_mut","","Returns a front-to-back iterator that returns mutable references.",94,{"inputs":[{"name":"vecdeque"}],"output":{"name":"itermut"}}],[11,"as_slices","","Returns a pair of slices which contain, in order, the contents of the\n`VecDeque`.",94,null],[11,"as_mut_slices","","Returns a pair of slices which contain, in order, the contents of the\n`VecDeque`.",94,null],[11,"len","","Returns the number of elements in the `VecDeque`.",94,{"inputs":[{"name":"vecdeque"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns true if the buffer contains no elements",94,{"inputs":[{"name":"vecdeque"}],"output":{"name":"bool"}}],[11,"drain","","Create a draining iterator that removes the specified range in the\n`VecDeque` and yields the removed items.",94,{"inputs":[{"name":"vecdeque"},{"name":"r"}],"output":{"name":"drain"}}],[11,"clear","","Clears the buffer, removing all values.",94,{"inputs":[{"name":"vecdeque"}],"output":null}],[11,"front","","Provides a reference to the front element, or `None` if the sequence is\nempty.",94,{"inputs":[{"name":"vecdeque"}],"output":{"name":"option"}}],[11,"front_mut","","Provides a mutable reference to the front element, or `None` if the\nsequence is empty.",94,{"inputs":[{"name":"vecdeque"}],"output":{"name":"option"}}],[11,"back","","Provides a reference to the back element, or `None` if the sequence is\nempty.",94,{"inputs":[{"name":"vecdeque"}],"output":{"name":"option"}}],[11,"back_mut","","Provides a mutable reference to the back element, or `None` if the\nsequence is empty.",94,{"inputs":[{"name":"vecdeque"}],"output":{"name":"option"}}],[11,"pop_front","","Removes the first element and returns it, or `None` if the sequence is\nempty.",94,{"inputs":[{"name":"vecdeque"}],"output":{"name":"option"}}],[11,"push_front","","Inserts an element first in the sequence.",94,{"inputs":[{"name":"vecdeque"},{"name":"t"}],"output":null}],[11,"push_back","","Appends an element to the back of a buffer",94,{"inputs":[{"name":"vecdeque"},{"name":"t"}],"output":null}],[11,"pop_back","","Removes the last element from a buffer and returns it, or `None` if\nit is empty.",94,{"inputs":[{"name":"vecdeque"}],"output":{"name":"option"}}],[11,"swap_remove_back","","Removes an element from anywhere in the `VecDeque` and returns it, replacing it with the\nlast element.",94,{"inputs":[{"name":"vecdeque"},{"name":"usize"}],"output":{"name":"option"}}],[11,"swap_remove_front","","Removes an element from anywhere in the `VecDeque` and returns it,\nreplacing it with the first element.",94,{"inputs":[{"name":"vecdeque"},{"name":"usize"}],"output":{"name":"option"}}],[11,"insert","","Inserts an element at `index` within the `VecDeque`. Whichever\nend is closer to the insertion point will be moved to make room,\nand all the affected elements will be moved to new positions.",94,{"inputs":[{"name":"vecdeque"},{"name":"usize"},{"name":"t"}],"output":null}],[11,"remove","","Removes and returns the element at `index` from the `VecDeque`.\nWhichever end is closer to the removal point will be moved to make\nroom, and all the affected elements will be moved to new positions.\nReturns `None` if `index` is out of bounds.",94,{"inputs":[{"name":"vecdeque"},{"name":"usize"}],"output":{"name":"option"}}],[11,"split_off","","Splits the collection into two at the given index.",94,{"inputs":[{"name":"vecdeque"},{"name":"usize"}],"output":{"name":"self"}}],[11,"append","","Moves all the elements of `other` into `Self`, leaving `other` empty.",94,{"inputs":[{"name":"vecdeque"},{"name":"self"}],"output":null}],[11,"retain","","Retains only the elements specified by the predicate.",94,{"inputs":[{"name":"vecdeque"},{"name":"f"}],"output":null}],[11,"resize","","Modifies the `VecDeque` in-place so that `len()` is equal to new_len,\neither by removing excess elements or by appending copies of a value to the back.",94,{"inputs":[{"name":"vecdeque"},{"name":"usize"},{"name":"t"}],"output":null}],[11,"clone","","",95,{"inputs":[{"name":"iter"}],"output":{"name":"iter"}}],[11,"next","","",95,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"size_hint","","",95,null],[11,"next_back","","",95,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"next","","",96,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"size_hint","","",96,null],[11,"next_back","","",96,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"clone","","",97,{"inputs":[{"name":"intoiter"}],"output":{"name":"intoiter"}}],[11,"next","","",97,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"size_hint","","",97,null],[11,"next_back","","",97,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"drop","","",98,{"inputs":[{"name":"drain"}],"output":null}],[11,"next","","",98,{"inputs":[{"name":"drain"}],"output":{"name":"option"}}],[11,"size_hint","","",98,null],[11,"next_back","","",98,{"inputs":[{"name":"drain"}],"output":{"name":"option"}}],[11,"eq","","",94,{"inputs":[{"name":"vecdeque"},{"name":"vecdeque"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",94,{"inputs":[{"name":"vecdeque"},{"name":"vecdeque"}],"output":{"name":"option"}}],[11,"cmp","","",94,{"inputs":[{"name":"vecdeque"},{"name":"vecdeque"}],"output":{"name":"ordering"}}],[11,"hash","","",94,{"inputs":[{"name":"vecdeque"},{"name":"h"}],"output":null}],[11,"index","","",94,{"inputs":[{"name":"vecdeque"},{"name":"usize"}],"output":{"name":"a"}}],[11,"index_mut","","",94,{"inputs":[{"name":"vecdeque"},{"name":"usize"}],"output":{"name":"a"}}],[11,"from_iter","","",94,{"inputs":[{"name":"t"}],"output":{"name":"vecdeque"}}],[11,"into_iter","","Consumes the list into a front-to-back iterator yielding elements by\nvalue.",94,{"inputs":[{"name":"vecdeque"}],"output":{"name":"intoiter"}}],[11,"extend","","",94,{"inputs":[{"name":"vecdeque"},{"name":"t"}],"output":null}],[11,"extend","","",94,{"inputs":[{"name":"vecdeque"},{"name":"i"}],"output":null}],[11,"fmt","","",94,{"inputs":[{"name":"vecdeque"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"btree_map","collections","",null,null],[3,"BTreeMap","collections::btree_map","A map based on a B-Tree.",null,null],[3,"Iter","","An iterator over a BTreeMap&#39;s entries.",null,null],[3,"IterMut","","A mutable iterator over a BTreeMap&#39;s entries.",null,null],[3,"IntoIter","","An owning iterator over a BTreeMap&#39;s entries.",null,null],[3,"Keys","","An iterator over a BTreeMap&#39;s keys.",null,null],[3,"Values","","An iterator over a BTreeMap&#39;s values.",null,null],[3,"ValuesMut","","A mutable iterator over a BTreeMap&#39;s values.",null,null],[3,"Range","","An iterator over a sub-range of BTreeMap&#39;s entries.",null,null],[3,"RangeMut","","A mutable iterator over a sub-range of BTreeMap&#39;s entries.",null,null],[3,"VacantEntry","","A vacant Entry.",null,null],[3,"OccupiedEntry","","An occupied Entry.",null,null],[4,"Entry","","A view into a single entry in a map, which may either be vacant or occupied.",null,null],[13,"Vacant","","A vacant Entry",99,null],[13,"Occupied","","An occupied Entry",99,null],[0,"btree_set","collections","",null,null],[3,"BTreeSet","collections::btree_set","A set based on a B-Tree.",null,null],[3,"Iter","","An iterator over a BTreeSet&#39;s items.",null,null],[3,"IntoIter","","An owning iterator over a BTreeSet&#39;s items.",null,null],[3,"Range","","An iterator over a sub-range of BTreeSet&#39;s items.",null,null],[3,"Difference","","A lazy iterator producing elements in the set difference (in-order).",null,null],[3,"SymmetricDifference","","A lazy iterator producing elements in the set symmetric difference (in-order).",null,null],[3,"Intersection","","A lazy iterator producing elements in the set intersection (in-order).",null,null],[3,"Union","","A lazy iterator producing elements in the set union (in-order).",null,null],[11,"fmt","core::ops","",100,{"inputs":[{"name":"rangefull"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",100,{"inputs":[{"name":"rangefull"}],"output":{"name":"rangefull"}}],[11,"eq","","",100,{"inputs":[{"name":"rangefull"},{"name":"rangefull"}],"output":{"name":"bool"}}],[11,"contains","","# Examples",43,{"inputs":[{"name":"range"},{"name":"idx"}],"output":{"name":"bool"}}],[11,"fmt","","",43,{"inputs":[{"name":"range"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",43,{"inputs":[{"name":"range"}],"output":{"name":"range"}}],[11,"eq","","",43,{"inputs":[{"name":"range"},{"name":"range"}],"output":{"name":"bool"}}],[11,"ne","","",43,{"inputs":[{"name":"range"},{"name":"range"}],"output":{"name":"bool"}}],[11,"next_back","","",43,{"inputs":[{"name":"range"}],"output":{"name":"option"}}],[11,"next","","",43,{"inputs":[{"name":"range"}],"output":{"name":"option"}}],[11,"size_hint","","",43,null],[11,"step_by","","Creates an iterator with the same range, but stepping by the\ngiven amount at each iteration.",43,{"inputs":[{"name":"range"},{"name":"a"}],"output":{"name":"stepby"}}],[11,"contains","","# Examples",41,{"inputs":[{"name":"rangefrom"},{"name":"idx"}],"output":{"name":"bool"}}],[11,"fmt","","",41,{"inputs":[{"name":"rangefrom"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",41,{"inputs":[{"name":"rangefrom"}],"output":{"name":"rangefrom"}}],[11,"eq","","",41,{"inputs":[{"name":"rangefrom"},{"name":"rangefrom"}],"output":{"name":"bool"}}],[11,"ne","","",41,{"inputs":[{"name":"rangefrom"},{"name":"rangefrom"}],"output":{"name":"bool"}}],[11,"next","","",41,{"inputs":[{"name":"rangefrom"}],"output":{"name":"option"}}],[11,"step_by","","Creates an iterator starting at the same point, but stepping by\nthe given amount at each iteration.",41,{"inputs":[{"name":"rangefrom"},{"name":"a"}],"output":{"name":"stepby"}}],[11,"contains","","# Examples",42,{"inputs":[{"name":"rangeto"},{"name":"idx"}],"output":{"name":"bool"}}],[11,"fmt","","",42,{"inputs":[{"name":"rangeto"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",42,{"inputs":[{"name":"rangeto"}],"output":{"name":"rangeto"}}],[11,"eq","","",42,{"inputs":[{"name":"rangeto"},{"name":"rangeto"}],"output":{"name":"bool"}}],[11,"ne","","",42,{"inputs":[{"name":"rangeto"},{"name":"rangeto"}],"output":{"name":"bool"}}],[11,"eq","","",101,{"inputs":[{"name":"rangeinclusive"},{"name":"rangeinclusive"}],"output":{"name":"bool"}}],[11,"ne","","",101,{"inputs":[{"name":"rangeinclusive"},{"name":"rangeinclusive"}],"output":{"name":"bool"}}],[11,"contains","","# Examples",101,{"inputs":[{"name":"rangeinclusive"},{"name":"idx"}],"output":{"name":"bool"}}],[11,"from","","",101,{"inputs":[{"name":"range"}],"output":{"name":"rangeinclusive"}}],[11,"fmt","","",101,{"inputs":[{"name":"rangeinclusive"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next_back","","",101,{"inputs":[{"name":"rangeinclusive"}],"output":{"name":"option"}}],[11,"next","","",101,{"inputs":[{"name":"rangeinclusive"}],"output":{"name":"option"}}],[11,"size_hint","","",101,null],[11,"step_by","","Creates an iterator with the same range, but stepping by the\ngiven amount at each iteration.",101,{"inputs":[{"name":"rangeinclusive"},{"name":"a"}],"output":{"name":"stepby"}}],[11,"clone","","",101,{"inputs":[{"name":"rangeinclusive"}],"output":{"name":"rangeinclusive"}}],[11,"eq","","",102,{"inputs":[{"name":"rangetoinclusive"},{"name":"rangetoinclusive"}],"output":{"name":"bool"}}],[11,"ne","","",102,{"inputs":[{"name":"rangetoinclusive"},{"name":"rangetoinclusive"}],"output":{"name":"bool"}}],[11,"contains","","# Examples",102,{"inputs":[{"name":"rangetoinclusive"},{"name":"idx"}],"output":{"name":"bool"}}],[11,"fmt","","",102,{"inputs":[{"name":"rangetoinclusive"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",102,{"inputs":[{"name":"rangetoinclusive"}],"output":{"name":"rangetoinclusive"}}],[11,"eq","collections","",4,{"inputs":[{"name":"bound"},{"name":"bound"}],"output":{"name":"bool"}}],[11,"ne","","",4,{"inputs":[{"name":"bound"},{"name":"bound"}],"output":{"name":"bool"}}],[11,"hash","","",4,null],[11,"fmt","","",4,{"inputs":[{"name":"bound"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",4,{"inputs":[{"name":"bound"}],"output":{"name":"bound"}}],[14,"vec!","","Creates a `Vec` containing the arguments.",null,null],[14,"format!","","Use the syntax described in `std::fmt` to create a value of type `String`.\nSee `std::fmt` for more information.",null,null],[11,"from","collections::vec","",91,{"inputs":[{"name":"binaryheap"}],"output":{"name":"vec"}}],[11,"drop","collections::btree_map","",103,{"inputs":[{"name":"btreemap"}],"output":null}],[11,"clone","","",103,{"inputs":[{"name":"btreemap"}],"output":{"name":"btreemap"}}],[11,"new","","Makes a new empty BTreeMap with a reasonable choice for B.",103,{"inputs":[],"output":{"name":"btreemap"}}],[11,"clear","","Clears the map, removing all values.",103,{"inputs":[{"name":"btreemap"}],"output":null}],[11,"get","","Returns a reference to the value corresponding to the key.",103,{"inputs":[{"name":"btreemap"},{"name":"q"}],"output":{"name":"option"}}],[11,"contains_key","","Returns true if the map contains a value for the specified key.",103,{"inputs":[{"name":"btreemap"},{"name":"q"}],"output":{"name":"bool"}}],[11,"get_mut","","Returns a mutable reference to the value corresponding to the key.",103,{"inputs":[{"name":"btreemap"},{"name":"q"}],"output":{"name":"option"}}],[11,"insert","","Inserts a key-value pair into the map.",103,{"inputs":[{"name":"btreemap"},{"name":"k"},{"name":"v"}],"output":{"name":"option"}}],[11,"remove","","Removes a key from the map, returning the value at the key if the key\nwas previously in the map.",103,{"inputs":[{"name":"btreemap"},{"name":"q"}],"output":{"name":"option"}}],[11,"range","","Constructs a double-ended iterator over a sub-range of elements in the map, starting\nat min, and ending at max. If min is `Unbounded`, then it will be treated as &quot;negative\ninfinity&quot;, and if max is `Unbounded`, then it will be treated as &quot;positive infinity&quot;.\nThus range(Unbounded, Unbounded) will yield the whole collection.",103,{"inputs":[{"name":"btreemap"},{"name":"bound"},{"name":"bound"}],"output":{"name":"range"}}],[11,"range_mut","","Constructs a mutable double-ended iterator over a sub-range of elements in the map, starting\nat min, and ending at max. If min is `Unbounded`, then it will be treated as &quot;negative\ninfinity&quot;, and if max is `Unbounded`, then it will be treated as &quot;positive infinity&quot;.\nThus range(Unbounded, Unbounded) will yield the whole collection.",103,{"inputs":[{"name":"btreemap"},{"name":"bound"},{"name":"bound"}],"output":{"name":"rangemut"}}],[11,"entry","","Gets the given key&#39;s corresponding entry in the map for in-place manipulation.",103,{"inputs":[{"name":"btreemap"},{"name":"k"}],"output":{"name":"entry"}}],[11,"next","","",104,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"size_hint","","",104,null],[11,"next_back","","",104,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"len","","",104,{"inputs":[{"name":"iter"}],"output":{"name":"usize"}}],[11,"clone","","",104,{"inputs":[{"name":"iter"}],"output":{"name":"iter"}}],[11,"next","","",105,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"size_hint","","",105,null],[11,"next_back","","",105,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"len","","",105,{"inputs":[{"name":"itermut"}],"output":{"name":"usize"}}],[11,"into_iter","","",103,{"inputs":[{"name":"btreemap"}],"output":{"name":"intoiter"}}],[11,"drop","","",106,{"inputs":[{"name":"intoiter"}],"output":null}],[11,"next","","",106,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"size_hint","","",106,null],[11,"next_back","","",106,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"len","","",106,{"inputs":[{"name":"intoiter"}],"output":{"name":"usize"}}],[11,"next","","",107,{"inputs":[{"name":"keys"}],"output":{"name":"option"}}],[11,"size_hint","","",107,null],[11,"next_back","","",107,{"inputs":[{"name":"keys"}],"output":{"name":"option"}}],[11,"len","","",107,{"inputs":[{"name":"keys"}],"output":{"name":"usize"}}],[11,"clone","","",107,{"inputs":[{"name":"keys"}],"output":{"name":"keys"}}],[11,"next","","",108,{"inputs":[{"name":"values"}],"output":{"name":"option"}}],[11,"size_hint","","",108,null],[11,"next_back","","",108,{"inputs":[{"name":"values"}],"output":{"name":"option"}}],[11,"len","","",108,{"inputs":[{"name":"values"}],"output":{"name":"usize"}}],[11,"clone","","",108,{"inputs":[{"name":"values"}],"output":{"name":"values"}}],[11,"next","","",109,{"inputs":[{"name":"range"}],"output":{"name":"option"}}],[11,"next","","",110,{"inputs":[{"name":"valuesmut"}],"output":{"name":"option"}}],[11,"size_hint","","",110,null],[11,"next_back","","",110,{"inputs":[{"name":"valuesmut"}],"output":{"name":"option"}}],[11,"len","","",110,{"inputs":[{"name":"valuesmut"}],"output":{"name":"usize"}}],[11,"next_back","","",109,{"inputs":[{"name":"range"}],"output":{"name":"option"}}],[11,"clone","","",109,{"inputs":[{"name":"range"}],"output":{"name":"range"}}],[11,"next","","",111,{"inputs":[{"name":"rangemut"}],"output":{"name":"option"}}],[11,"next_back","","",111,{"inputs":[{"name":"rangemut"}],"output":{"name":"option"}}],[11,"from_iter","","",103,{"inputs":[{"name":"t"}],"output":{"name":"btreemap"}}],[11,"extend","","",103,{"inputs":[{"name":"btreemap"},{"name":"t"}],"output":null}],[11,"extend","","",103,{"inputs":[{"name":"btreemap"},{"name":"i"}],"output":null}],[11,"hash","","",103,{"inputs":[{"name":"btreemap"},{"name":"h"}],"output":null}],[11,"default","","",103,{"inputs":[],"output":{"name":"btreemap"}}],[11,"eq","","",103,{"inputs":[{"name":"btreemap"},{"name":"btreemap"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",103,{"inputs":[{"name":"btreemap"},{"name":"btreemap"}],"output":{"name":"option"}}],[11,"cmp","","",103,{"inputs":[{"name":"btreemap"},{"name":"btreemap"}],"output":{"name":"ordering"}}],[11,"fmt","","",103,{"inputs":[{"name":"btreemap"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"index","","",103,{"inputs":[{"name":"btreemap"},{"name":"q"}],"output":{"name":"v"}}],[11,"iter","","Gets an iterator over the entries of the map, sorted by key.",103,{"inputs":[{"name":"btreemap"}],"output":{"name":"iter"}}],[11,"iter_mut","","Gets a mutable iterator over the entries of the map, sorted by key.",103,{"inputs":[{"name":"btreemap"}],"output":{"name":"itermut"}}],[11,"keys","","Gets an iterator over the keys of the map, in sorted order.",103,{"inputs":[{"name":"btreemap"}],"output":{"name":"keys"}}],[11,"values","","Gets an iterator over the values of the map, in order by key.",103,{"inputs":[{"name":"btreemap"}],"output":{"name":"values"}}],[11,"values_mut","","Gets a mutable iterator over the values of the map, in order by key.",103,{"inputs":[{"name":"btreemap"}],"output":{"name":"valuesmut"}}],[11,"len","","Returns the number of elements in the map.",103,{"inputs":[{"name":"btreemap"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns true if the map contains no elements.",103,{"inputs":[{"name":"btreemap"}],"output":{"name":"bool"}}],[11,"or_insert","","Ensures a value is in the entry by inserting the default if empty, and returns\na mutable reference to the value in the entry.",99,{"inputs":[{"name":"entry"},{"name":"v"}],"output":{"name":"v"}}],[11,"or_insert_with","","Ensures a value is in the entry by inserting the result of the default function if empty,\nand returns a mutable reference to the value in the entry.",99,{"inputs":[{"name":"entry"},{"name":"f"}],"output":{"name":"v"}}],[11,"key","","Gets a reference to the key that would be used when inserting a value\nthrough the VacantEntry.",112,{"inputs":[{"name":"vacantentry"}],"output":{"name":"k"}}],[11,"insert","","Sets the value of the entry with the VacantEntry&#39;s key,\nand returns a mutable reference to it.",112,{"inputs":[{"name":"vacantentry"},{"name":"v"}],"output":{"name":"v"}}],[11,"key","","Gets a reference to the key in the entry.",113,{"inputs":[{"name":"occupiedentry"}],"output":{"name":"k"}}],[11,"get","","Gets a reference to the value in the entry.",113,{"inputs":[{"name":"occupiedentry"}],"output":{"name":"v"}}],[11,"get_mut","","Gets a mutable reference to the value in the entry.",113,{"inputs":[{"name":"occupiedentry"}],"output":{"name":"v"}}],[11,"into_mut","","Converts the entry into a mutable reference to its value.",113,{"inputs":[{"name":"occupiedentry"}],"output":{"name":"v"}}],[11,"insert","","Sets the value of the entry with the OccupiedEntry&#39;s key,\nand returns the entry&#39;s old value.",113,{"inputs":[{"name":"occupiedentry"},{"name":"v"}],"output":{"name":"v"}}],[11,"remove","","Takes the value of the entry out of the map, and returns it.",113,{"inputs":[{"name":"occupiedentry"}],"output":{"name":"v"}}],[11,"partial_cmp","collections::btree_set","",114,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"option"}}],[11,"lt","","",114,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"le","","",114,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"gt","","",114,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"ge","","",114,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"cmp","","",114,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"ordering"}}],[11,"eq","","",114,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"ne","","",114,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"hash","","",114,null],[11,"clone","","",114,{"inputs":[{"name":"btreeset"}],"output":{"name":"btreeset"}}],[11,"new","","Makes a new BTreeSet with a reasonable choice of B.",114,{"inputs":[],"output":{"name":"btreeset"}}],[11,"iter","","Gets an iterator over the BTreeSet&#39;s contents.",114,{"inputs":[{"name":"btreeset"}],"output":{"name":"iter"}}],[11,"range","","Constructs a double-ended iterator over a sub-range of elements in the set, starting\nat min, and ending at max. If min is `Unbounded`, then it will be treated as &quot;negative\ninfinity&quot;, and if max is `Unbounded`, then it will be treated as &quot;positive infinity&quot;.\nThus range(Unbounded, Unbounded) will yield the whole collection.",114,{"inputs":[{"name":"btreeset"},{"name":"bound"},{"name":"bound"}],"output":{"name":"range"}}],[11,"difference","","Visits the values representing the difference, in ascending order.",114,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"difference"}}],[11,"symmetric_difference","","Visits the values representing the symmetric difference, in ascending order.",114,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"symmetricdifference"}}],[11,"intersection","","Visits the values representing the intersection, in ascending order.",114,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"intersection"}}],[11,"union","","Visits the values representing the union, in ascending order.",114,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"union"}}],[11,"len","","Returns the number of elements in the set.",114,{"inputs":[{"name":"btreeset"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns true if the set contains no elements.",114,{"inputs":[{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"clear","","Clears the set, removing all values.",114,{"inputs":[{"name":"btreeset"}],"output":null}],[11,"contains","","Returns `true` if the set contains a value.",114,{"inputs":[{"name":"btreeset"},{"name":"q"}],"output":{"name":"bool"}}],[11,"get","","Returns a reference to the value in the set, if any, that is equal to the given value.",114,{"inputs":[{"name":"btreeset"},{"name":"q"}],"output":{"name":"option"}}],[11,"is_disjoint","","Returns `true` if the set has no elements in common with `other`.\nThis is equivalent to checking for an empty intersection.",114,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"is_subset","","Returns `true` if the set is a subset of another.",114,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"is_superset","","Returns `true` if the set is a superset of another.",114,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"insert","","Adds a value to the set.",114,{"inputs":[{"name":"btreeset"},{"name":"t"}],"output":{"name":"bool"}}],[11,"replace","","Adds a value to the set, replacing the existing value, if any, that is equal to the given\none. Returns the replaced value.",114,{"inputs":[{"name":"btreeset"},{"name":"t"}],"output":{"name":"option"}}],[11,"remove","","Removes a value from the set. Returns `true` if the value was\npresent in the set.",114,{"inputs":[{"name":"btreeset"},{"name":"q"}],"output":{"name":"bool"}}],[11,"take","","Removes and returns the value in the set, if any, that is equal to the given one.",114,{"inputs":[{"name":"btreeset"},{"name":"q"}],"output":{"name":"option"}}],[11,"from_iter","","",114,{"inputs":[{"name":"i"}],"output":{"name":"btreeset"}}],[11,"into_iter","","Gets an iterator for moving out the BtreeSet&#39;s contents.",114,{"inputs":[{"name":"btreeset"}],"output":{"name":"intoiter"}}],[11,"extend","","",114,{"inputs":[{"name":"btreeset"},{"name":"iter"}],"output":null}],[11,"extend","","",114,{"inputs":[{"name":"btreeset"},{"name":"i"}],"output":null}],[11,"default","","",114,{"inputs":[],"output":{"name":"btreeset"}}],[11,"fmt","","",114,{"inputs":[{"name":"btreeset"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",115,{"inputs":[{"name":"iter"}],"output":{"name":"iter"}}],[11,"next","","",115,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"size_hint","","",115,null],[11,"next_back","","",115,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"len","","",115,{"inputs":[{"name":"iter"}],"output":{"name":"usize"}}],[11,"next","","",116,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"size_hint","","",116,null],[11,"next_back","","",116,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"len","","",116,{"inputs":[{"name":"intoiter"}],"output":{"name":"usize"}}],[11,"clone","","",117,{"inputs":[{"name":"range"}],"output":{"name":"range"}}],[11,"next","","",117,{"inputs":[{"name":"range"}],"output":{"name":"option"}}],[11,"next_back","","",117,{"inputs":[{"name":"range"}],"output":{"name":"option"}}],[11,"clone","","",118,{"inputs":[{"name":"difference"}],"output":{"name":"difference"}}],[11,"next","","",118,{"inputs":[{"name":"difference"}],"output":{"name":"option"}}],[11,"size_hint","","",118,null],[11,"clone","","",119,{"inputs":[{"name":"symmetricdifference"}],"output":{"name":"symmetricdifference"}}],[11,"next","","",119,{"inputs":[{"name":"symmetricdifference"}],"output":{"name":"option"}}],[11,"size_hint","","",119,null],[11,"clone","","",120,{"inputs":[{"name":"intersection"}],"output":{"name":"intersection"}}],[11,"next","","",120,{"inputs":[{"name":"intersection"}],"output":{"name":"option"}}],[11,"size_hint","","",120,null],[11,"clone","","",121,{"inputs":[{"name":"union"}],"output":{"name":"union"}}],[11,"next","","",121,{"inputs":[{"name":"union"}],"output":{"name":"option"}}],[11,"size_hint","","",121,null],[11,"borrow","collections::vec","",91,null],[11,"borrow_mut","","",91,null],[11,"borrow","collections::string","",86,{"inputs":[{"name":"string"}],"output":{"name":"str"}}]],"paths":[[3,"ExchangeHeapSingleton"],[3,"Box"],[3,"IntermediateBox"],[8,"FnBox"],[4,"Bound"],[3,"BinaryHeap"],[3,"Iter"],[3,"IntoIter"],[3,"Drain"],[8,"Borrow"],[8,"BorrowMut"],[4,"Cow"],[8,"ToOwned"],[8,"CLike"],[3,"EnumSet"],[3,"Iter"],[3,"Formatter"],[8,"Write"],[8,"Octal"],[8,"Binary"],[8,"Display"],[8,"Debug"],[8,"LowerHex"],[8,"UpperHex"],[8,"Pointer"],[8,"LowerExp"],[8,"UpperExp"],[3,"Error"],[3,"Arguments"],[3,"DebugList"],[3,"DebugMap"],[3,"DebugSet"],[3,"DebugStruct"],[3,"DebugTuple"],[3,"Iter"],[3,"IntoIter"],[3,"LinkedList"],[3,"IterMut"],[3,"FrontPlace"],[3,"BackPlace"],[8,"RangeArgument"],[3,"RangeFrom"],[3,"RangeTo"],[3,"Range"],[3,"Chunks"],[3,"Windows"],[3,"Iter"],[3,"IterMut"],[3,"SplitMut"],[3,"ChunksMut"],[3,"Split"],[3,"SplitN"],[3,"RSplitN"],[3,"SplitNMut"],[3,"RSplitNMut"],[8,"SliceConcatExt"],[8,"FromStr"],[3,"Utf8Error"],[3,"Lines"],[3,"LinesAny"],[3,"CharRange"],[3,"Split"],[3,"RSplit"],[3,"SplitN"],[3,"RSplitN"],[3,"SplitTerminator"],[3,"RSplitTerminator"],[3,"Matches"],[3,"RMatches"],[3,"MatchIndices"],[3,"RMatchIndices"],[3,"Chars"],[3,"CharIndices"],[3,"Bytes"],[3,"ParseBoolError"],[3,"SplitWhitespace"],[8,"Pattern"],[4,"SearchStep"],[8,"Searcher"],[8,"ReverseSearcher"],[3,"CharSearcher"],[3,"CharSliceSearcher"],[3,"CharPredicateSearcher"],[3,"StrSearcher"],[3,"EncodeUtf16"],[8,"ToString"],[3,"String"],[3,"FromUtf8Error"],[3,"FromUtf16Error"],[4,"ParseError"],[3,"Drain"],[3,"Vec"],[3,"IntoIter"],[3,"Drain"],[3,"VecDeque"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Drain"],[4,"Entry"],[3,"RangeFull"],[4,"RangeInclusive"],[3,"RangeToInclusive"],[3,"BTreeMap"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Keys"],[3,"Values"],[3,"Range"],[3,"ValuesMut"],[3,"RangeMut"],[3,"VacantEntry"],[3,"OccupiedEntry"],[3,"BTreeSet"],[3,"Iter"],[3,"IntoIter"],[3,"Range"],[3,"Difference"],[3,"SymmetricDifference"],[3,"Intersection"],[3,"Union"]]};
searchIndex["alloc"] = {"doc":"# The Rust core allocation library","items":[[0,"heap","alloc","",null,null],[5,"allocate","alloc::heap","Return a pointer to `size` bytes of memory aligned to `align`.",null,null],[5,"reallocate","","Resize the allocation referenced by `ptr` to `size` bytes.",null,null],[5,"reallocate_inplace","","Resize the allocation referenced by `ptr` to `size` bytes.",null,null],[5,"deallocate","","Deallocates the memory referenced by `ptr`.",null,null],[5,"usable_size","","Returns the usable size of an allocation created with the specified the\n`size` and `align`.",null,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"usize"}}],[17,"EMPTY","","An arbitrary non-null address to represent zero-size allocations.",null,null],[0,"boxed","alloc","A pointer type for heap allocation.",null,null],[3,"ExchangeHeapSingleton","alloc::boxed","This the singleton type used solely for `boxed::HEAP`.",null,null],[3,"Box","","A pointer type for heap allocation.",null,null],[3,"IntermediateBox","","`IntermediateBox` represents uninitialized backing storage for `Box`.",null,null],[17,"HEAP","","A value that represents the heap. This is the default place that the `box`\nkeyword allocates into when no place is supplied.",null,null],[8,"FnBox","","`FnBox` is a version of the `FnOnce` intended for use with boxed\nclosure objects. The idea is that where one would normally store a\n`Box&lt;FnOnce()&gt;` in a data structure, you should use\n`Box&lt;FnBox()&gt;`. The two traits behave essentially the same, except\nthat a `FnBox` closure can only be called if it is boxed. (Note\nthat `FnBox` may be deprecated in the future if `Box&lt;FnOnce()&gt;`\nclosures become directly usable.)",null,null],[16,"Output","","",0,null],[10,"call_box","","",0,{"inputs":[{"name":"fnbox"},{"name":"a"}],"output":{"name":"output"}}],[11,"clone","","",1,{"inputs":[{"name":"exchangeheapsingleton"}],"output":{"name":"exchangeheapsingleton"}}],[11,"pointer","","",2,null],[11,"make_place","","",2,{"inputs":[],"output":{"name":"intermediatebox"}}],[11,"finalize","","",2,{"inputs":[{"name":"intermediatebox"}],"output":{"name":"box"}}],[11,"finalize","","",3,{"inputs":[{"name":"intermediatebox"}],"output":{"name":"box"}}],[11,"make_place","","",1,{"inputs":[{"name":"exchangeheapsingleton"}],"output":{"name":"intermediatebox"}}],[11,"drop","","",2,{"inputs":[{"name":"intermediatebox"}],"output":null}],[11,"new","","Allocates memory on the heap and then places `x` into it.",3,{"inputs":[{"name":"t"}],"output":{"name":"box"}}],[11,"from_raw","","Constructs a box from a raw pointer.",3,null],[11,"into_raw","","Consumes the `Box`, returning the wrapped raw pointer.",3,null],[11,"default","","",3,{"inputs":[],"output":{"name":"box"}}],[11,"default","","",3,{"inputs":[],"output":{"name":"box"}}],[11,"clone","","Returns a new box with a `clone()` of this box&#39;s contents.",3,{"inputs":[{"name":"box"}],"output":{"name":"box"}}],[11,"clone_from","","Copies `source`&#39;s contents into `self` without creating a new allocation.",3,{"inputs":[{"name":"box"},{"name":"box"}],"output":null}],[11,"clone","","",3,{"inputs":[{"name":"box"}],"output":{"name":"self"}}],[11,"eq","","",3,{"inputs":[{"name":"box"},{"name":"box"}],"output":{"name":"bool"}}],[11,"ne","","",3,{"inputs":[{"name":"box"},{"name":"box"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",3,{"inputs":[{"name":"box"},{"name":"box"}],"output":{"name":"option"}}],[11,"lt","","",3,{"inputs":[{"name":"box"},{"name":"box"}],"output":{"name":"bool"}}],[11,"le","","",3,{"inputs":[{"name":"box"},{"name":"box"}],"output":{"name":"bool"}}],[11,"ge","","",3,{"inputs":[{"name":"box"},{"name":"box"}],"output":{"name":"bool"}}],[11,"gt","","",3,{"inputs":[{"name":"box"},{"name":"box"}],"output":{"name":"bool"}}],[11,"cmp","","",3,{"inputs":[{"name":"box"},{"name":"box"}],"output":{"name":"ordering"}}],[11,"hash","","",3,{"inputs":[{"name":"box"},{"name":"h"}],"output":null}],[11,"from","","",3,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",3,{"inputs":[{"name":"box"}],"output":{"name":"result"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",3,{"inputs":[{"name":"box"}],"output":{"name":"result"}}],[11,"fmt","","",3,{"inputs":[{"name":"box"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",3,{"inputs":[{"name":"box"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",3,{"inputs":[{"name":"box"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"deref","","",3,{"inputs":[{"name":"box"}],"output":{"name":"t"}}],[11,"deref_mut","","",3,{"inputs":[{"name":"box"}],"output":{"name":"t"}}],[11,"next","","",3,{"inputs":[{"name":"box"}],"output":{"name":"option"}}],[11,"size_hint","","",3,null],[11,"next_back","","",3,{"inputs":[{"name":"box"}],"output":{"name":"option"}}],[11,"call_once","","",3,{"inputs":[{"name":"box"},{"name":"a"}],"output":{"name":"r"}}],[11,"call_once","","",3,{"inputs":[{"name":"box"},{"name":"a"}],"output":{"name":"r"}}],[11,"clone","","",3,{"inputs":[{"name":"box"}],"output":{"name":"self"}}],[11,"borrow","","",3,{"inputs":[{"name":"box"}],"output":{"name":"t"}}],[11,"borrow_mut","","",3,{"inputs":[{"name":"box"}],"output":{"name":"t"}}],[11,"as_ref","","",3,{"inputs":[{"name":"box"}],"output":{"name":"t"}}],[11,"as_mut","","",3,{"inputs":[{"name":"box"}],"output":{"name":"t"}}],[0,"arc","alloc","Threadsafe reference-counted boxes (the `Arc&lt;T&gt;` type).",null,null],[3,"Arc","alloc::arc","An atomically reference counted wrapper for shared state.",null,null],[3,"Weak","","A weak pointer to an `Arc`.",null,null],[11,"fmt","","",4,{"inputs":[{"name":"weak"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Constructs a new `Arc&lt;T&gt;`.",5,{"inputs":[{"name":"t"}],"output":{"name":"arc"}}],[11,"try_unwrap","","Unwraps the contained value if the `Arc&lt;T&gt;` has exactly one strong reference.",5,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"downgrade","","Downgrades the `Arc&lt;T&gt;` to a `Weak&lt;T&gt;` reference.",5,{"inputs":[{"name":"self"}],"output":{"name":"weak"}}],[11,"weak_count","","Get the number of weak references to this value.",5,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"strong_count","","Get the number of strong references to this value.",5,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clone","","Makes a clone of the `Arc&lt;T&gt;`.",5,{"inputs":[{"name":"arc"}],"output":{"name":"arc"}}],[11,"deref","","",5,{"inputs":[{"name":"arc"}],"output":{"name":"t"}}],[11,"make_mut","","Make a mutable reference into the given `Arc&lt;T&gt;`.\nIf the `Arc&lt;T&gt;` has more than one strong reference, or any weak\nreferences, the inner data is cloned.",5,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"get_mut","","Returns a mutable reference to the contained value if the `Arc&lt;T&gt;` has\none strong reference and no weak references.",5,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"drop","","Drops the `Arc&lt;T&gt;`.",5,{"inputs":[{"name":"arc"}],"output":null}],[11,"upgrade","","Upgrades a weak reference to a strong reference.",4,{"inputs":[{"name":"weak"}],"output":{"name":"option"}}],[11,"clone","","Makes a clone of the `Weak&lt;T&gt;`.",4,{"inputs":[{"name":"weak"}],"output":{"name":"weak"}}],[11,"drop","","Drops the `Weak&lt;T&gt;`.",4,{"inputs":[{"name":"weak"}],"output":null}],[11,"eq","","Equality for two `Arc&lt;T&gt;`s.",5,{"inputs":[{"name":"arc"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"ne","","Inequality for two `Arc&lt;T&gt;`s.",5,{"inputs":[{"name":"arc"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"partial_cmp","","Partial comparison for two `Arc&lt;T&gt;`s.",5,{"inputs":[{"name":"arc"},{"name":"arc"}],"output":{"name":"option"}}],[11,"lt","","Less-than comparison for two `Arc&lt;T&gt;`s.",5,{"inputs":[{"name":"arc"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"le","","&#39;Less-than or equal to&#39; comparison for two `Arc&lt;T&gt;`s.",5,{"inputs":[{"name":"arc"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"gt","","Greater-than comparison for two `Arc&lt;T&gt;`s.",5,{"inputs":[{"name":"arc"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"ge","","&#39;Greater-than or equal to&#39; comparison for two `Arc&lt;T&gt;`s.",5,{"inputs":[{"name":"arc"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"cmp","","",5,{"inputs":[{"name":"arc"},{"name":"arc"}],"output":{"name":"ordering"}}],[11,"fmt","","",5,{"inputs":[{"name":"arc"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",5,{"inputs":[{"name":"arc"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",5,{"inputs":[{"name":"arc"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","",5,{"inputs":[],"output":{"name":"arc"}}],[11,"hash","","",5,{"inputs":[{"name":"arc"},{"name":"h"}],"output":null}],[11,"from","","",5,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"new","","Constructs a new `Weak&lt;T&gt;` without an accompanying instance of T.",4,{"inputs":[],"output":{"name":"weak"}}],[11,"borrow","","",5,{"inputs":[{"name":"arc"}],"output":{"name":"t"}}],[11,"as_ref","","",5,{"inputs":[{"name":"arc"}],"output":{"name":"t"}}],[0,"rc","alloc","Thread-local reference-counted boxes (the `Rc&lt;T&gt;` type).",null,null],[3,"Rc","alloc::rc","A reference-counted pointer type over an immutable value.",null,null],[3,"Weak","","A weak version of `Rc&lt;T&gt;`.",null,null],[11,"new","","Constructs a new `Rc&lt;T&gt;`.",6,{"inputs":[{"name":"t"}],"output":{"name":"rc"}}],[11,"try_unwrap","","Unwraps the contained value if the `Rc&lt;T&gt;` has exactly one strong reference.",6,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"would_unwrap","","Checks if `Rc::try_unwrap` would return `Ok`.",6,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"downgrade","","Downgrades the `Rc&lt;T&gt;` to a `Weak&lt;T&gt;` reference.",6,{"inputs":[{"name":"self"}],"output":{"name":"weak"}}],[11,"weak_count","","Get the number of weak references to this value.",6,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"strong_count","","Get the number of strong references to this value.",6,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_unique","","Returns true if there are no other `Rc` or `Weak&lt;T&gt;` values that share\nthe same inner value.",6,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"get_mut","","Returns a mutable reference to the contained value if the `Rc&lt;T&gt;` has\none strong reference and no weak references.",6,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"make_mut","","Make a mutable reference into the given `Rc&lt;T&gt;` by cloning the inner\ndata if the `Rc&lt;T&gt;` doesn&#39;t have one strong reference and no weak\nreferences.",6,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref","","",6,{"inputs":[{"name":"rc"}],"output":{"name":"t"}}],[11,"drop","","Drops the `Rc&lt;T&gt;`.",6,{"inputs":[{"name":"rc"}],"output":null}],[11,"clone","","Makes a clone of the `Rc&lt;T&gt;`.",6,{"inputs":[{"name":"rc"}],"output":{"name":"rc"}}],[11,"default","","Creates a new `Rc&lt;T&gt;`, with the `Default` value for `T`.",6,{"inputs":[],"output":{"name":"rc"}}],[11,"eq","","Equality for two `Rc&lt;T&gt;`s.",6,{"inputs":[{"name":"rc"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"ne","","Inequality for two `Rc&lt;T&gt;`s.",6,{"inputs":[{"name":"rc"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"partial_cmp","","Partial comparison for two `Rc&lt;T&gt;`s.",6,{"inputs":[{"name":"rc"},{"name":"rc"}],"output":{"name":"option"}}],[11,"lt","","Less-than comparison for two `Rc&lt;T&gt;`s.",6,{"inputs":[{"name":"rc"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"le","","&#39;Less-than or equal to&#39; comparison for two `Rc&lt;T&gt;`s.",6,{"inputs":[{"name":"rc"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"gt","","Greater-than comparison for two `Rc&lt;T&gt;`s.",6,{"inputs":[{"name":"rc"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"ge","","&#39;Greater-than or equal to&#39; comparison for two `Rc&lt;T&gt;`s.",6,{"inputs":[{"name":"rc"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"cmp","","Comparison for two `Rc&lt;T&gt;`s.",6,{"inputs":[{"name":"rc"},{"name":"rc"}],"output":{"name":"ordering"}}],[11,"hash","","",6,{"inputs":[{"name":"rc"},{"name":"h"}],"output":null}],[11,"fmt","","",6,{"inputs":[{"name":"rc"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",6,{"inputs":[{"name":"rc"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",6,{"inputs":[{"name":"rc"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",6,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"upgrade","","Upgrades a weak reference to a strong reference.",7,{"inputs":[{"name":"weak"}],"output":{"name":"option"}}],[11,"drop","","Drops the `Weak&lt;T&gt;`.",7,{"inputs":[{"name":"weak"}],"output":null}],[11,"clone","","Makes a clone of the `Weak&lt;T&gt;`.",7,{"inputs":[{"name":"weak"}],"output":{"name":"weak"}}],[11,"fmt","","",7,{"inputs":[{"name":"weak"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Constructs a new `Weak&lt;T&gt;` without an accompanying instance of T.",7,{"inputs":[],"output":{"name":"weak"}}],[11,"borrow","","",6,{"inputs":[{"name":"rc"}],"output":{"name":"t"}}],[11,"as_ref","","",6,{"inputs":[{"name":"rc"}],"output":{"name":"t"}}],[0,"raw_vec","alloc","",null,null],[3,"RawVec","alloc::raw_vec","A low-level utility for more ergonomically allocating, reallocating, and deallocating a\na buffer of memory on the heap without having to worry about all the corner cases\ninvolved. This type is excellent for building your own data structures like Vec and VecDeque.\nIn particular:",null,null],[11,"new","","Creates the biggest possible RawVec without allocating. If T has positive\nsize, then this makes a RawVec with capacity 0. If T has 0 size, then it\nit makes a RawVec with capacity `usize::MAX`. Useful for implementing\ndelayed allocation.",8,{"inputs":[],"output":{"name":"self"}}],[11,"with_capacity","","Creates a RawVec with exactly the capacity and alignment requirements\nfor a `[T; cap]`. This is equivalent to calling RawVec::new when `cap` is 0\nor T is zero-sized. Note that if `T` is zero-sized this means you will *not*\nget a RawVec with the requested capacity!",8,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"from_raw_parts","","Reconstitutes a RawVec from a pointer and capacity.",8,null],[11,"from_box","","Converts a `Box&lt;[T]&gt;` into a `RawVec&lt;T&gt;`.",8,{"inputs":[{"name":"box"}],"output":{"name":"self"}}],[11,"ptr","","Gets a raw pointer to the start of the allocation. Note that this is\nheap::EMPTY if `cap = 0` or T is zero-sized. In the former case, you must\nbe careful.",8,null],[11,"cap","","Gets the capacity of the allocation.",8,{"inputs":[{"name":"rawvec"}],"output":{"name":"usize"}}],[11,"double","","Doubles the size of the type&#39;s backing allocation. This is common enough\nto want to do that it&#39;s easiest to just have a dedicated method. Slightly\nmore efficient logic can be provided for this than the general case.",8,{"inputs":[{"name":"rawvec"}],"output":null}],[11,"double_in_place","","Attempts to double the size of the type&#39;s backing allocation in place. This is common\nenough to want to do that it&#39;s easiest to just have a dedicated method. Slightly\nmore efficient logic can be provided for this than the general case.",8,{"inputs":[{"name":"rawvec"}],"output":{"name":"bool"}}],[11,"reserve_exact","","Ensures that the buffer contains at least enough space to hold\n`used_cap + needed_extra_cap` elements. If it doesn&#39;t already,\nwill reallocate the minimum possible amount of memory necessary.\nGenerally this will be exactly the amount of memory necessary,\nbut in principle the allocator is free to give back more than\nwe asked for.",8,{"inputs":[{"name":"rawvec"},{"name":"usize"},{"name":"usize"}],"output":null}],[11,"reserve","","Ensures that the buffer contains at least enough space to hold\n`used_cap + needed_extra_cap` elements. If it doesn&#39;t already have\nenough capacity, will reallocate enough space plus comfortable slack\nspace to get amortized `O(1)` behavior. Will limit this behavior\nif it would needlessly cause itself to panic.",8,{"inputs":[{"name":"rawvec"},{"name":"usize"},{"name":"usize"}],"output":null}],[11,"reserve_in_place","","Attempts to ensure that the buffer contains at least enough space to hold\n`used_cap + needed_extra_cap` elements. If it doesn&#39;t already have\nenough capacity, will reallocate in place enough space plus comfortable slack\nspace to get amortized `O(1)` behaviour. Will limit this behaviour\nif it would needlessly cause itself to panic.",8,{"inputs":[{"name":"rawvec"},{"name":"usize"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"shrink_to_fit","","Shrinks the allocation down to the specified amount. If the given amount\nis 0, actually completely deallocates.",8,{"inputs":[{"name":"rawvec"},{"name":"usize"}],"output":null}],[11,"into_box","","Converts the entire buffer into `Box&lt;[T]&gt;`.",8,{"inputs":[{"name":"rawvec"}],"output":{"name":"box"}}],[11,"unsafe_no_drop_flag_needs_drop","","This is a stupid name in the hopes that someone will find this in the\nnot too distant future and remove it with the rest of\n#[unsafe_no_drop_flag]",8,{"inputs":[{"name":"rawvec"}],"output":{"name":"bool"}}],[11,"drop","","Frees the memory owned by the RawVec *without* trying to Drop its contents.",8,{"inputs":[{"name":"rawvec"}],"output":null}],[0,"oom","alloc","",null,null],[5,"oom","alloc::oom","Common out-of-memory routine",null,{"inputs":[],"output":null}],[5,"set_oom_handler","","Set a custom handler for out-of-memory conditions",null,null]],"paths":[[8,"FnBox"],[3,"ExchangeHeapSingleton"],[3,"IntermediateBox"],[3,"Box"],[3,"Weak"],[3,"Arc"],[3,"Rc"],[3,"Weak"],[3,"RawVec"]]};
searchIndex["std"] = {"doc":"# The Rust Standard Library","items":[[0,"any","std","This module implements the `Any` trait, which enables dynamic typing\nof any `&#39;static` type through runtime reflection.",null,null],[8,"Any","std::any","A type to emulate dynamic typing.",null,null],[10,"get_type_id","","Gets the `TypeId` of `self`.",0,{"inputs":[{"name":"any"}],"output":{"name":"typeid"}}],[11,"of","core::any","Returns the `TypeId` of the type this generic function has been\ninstantiated with",1,{"inputs":[],"output":{"name":"typeid"}}],[11,"clone","","",1,{"inputs":[{"name":"typeid"}],"output":{"name":"typeid"}}],[11,"eq","","",1,{"inputs":[{"name":"typeid"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"ne","","",1,{"inputs":[{"name":"typeid"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"fmt","","",1,{"inputs":[{"name":"typeid"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",1,null],[3,"TypeId","std::any","A `TypeId` represents a globally unique identifier for a type.",null,null],[0,"cell","std","Shareable mutable containers.",null,null],[11,"eq","core::cell","",2,{"inputs":[{"name":"cell"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"default","","",2,{"inputs":[],"output":{"name":"cell"}}],[11,"clone","","",2,{"inputs":[{"name":"cell"}],"output":{"name":"cell"}}],[11,"new","","Creates a new `Cell` containing the given value.",2,{"inputs":[{"name":"t"}],"output":{"name":"cell"}}],[11,"get","","Returns a copy of the contained value.",2,{"inputs":[{"name":"cell"}],"output":{"name":"t"}}],[11,"set","","Sets the contained value.",2,null],[11,"as_unsafe_cell","","Returns a reference to the underlying `UnsafeCell`.",2,{"inputs":[{"name":"cell"}],"output":{"name":"unsafecell"}}],[11,"fmt","","",2,{"inputs":[{"name":"cell"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Cell","std::cell","A mutable memory location that admits only `Copy` data.",null,null],[11,"eq","core::cell","",3,{"inputs":[{"name":"refcell"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"default","","",3,{"inputs":[],"output":{"name":"refcell"}}],[11,"clone","","",3,{"inputs":[{"name":"refcell"}],"output":{"name":"refcell"}}],[11,"borrow_state","","Query the current state of this `RefCell`",3,{"inputs":[{"name":"refcell"}],"output":{"name":"borrowstate"}}],[11,"borrow","","Immutably borrows the wrapped value.",3,{"inputs":[{"name":"refcell"}],"output":{"name":"ref"}}],[11,"borrow_mut","","Mutably borrows the wrapped value.",3,{"inputs":[{"name":"refcell"}],"output":{"name":"refmut"}}],[11,"as_unsafe_cell","","Returns a reference to the underlying `UnsafeCell`.",3,{"inputs":[{"name":"refcell"}],"output":{"name":"unsafecell"}}],[11,"new","","Creates a new `RefCell` containing `value`.",3,{"inputs":[{"name":"t"}],"output":{"name":"refcell"}}],[11,"into_inner","","Consumes the `RefCell`, returning the wrapped value.",3,{"inputs":[{"name":"refcell"}],"output":{"name":"t"}}],[11,"fmt","","",3,{"inputs":[{"name":"refcell"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"RefCell","std::cell","A mutable memory location with dynamically checked borrow rules",null,null],[11,"clone","core::cell","",4,{"inputs":[{"name":"borrowstate"}],"output":{"name":"borrowstate"}}],[11,"eq","","",4,{"inputs":[{"name":"borrowstate"},{"name":"borrowstate"}],"output":{"name":"bool"}}],[11,"fmt","","",4,{"inputs":[{"name":"borrowstate"},{"name":"formatter"}],"output":{"name":"result"}}],[4,"BorrowState","std::cell","An enumeration of values returned from the `state` method on a `RefCell&lt;T&gt;`.",null,null],[13,"Reading","","The cell is currently being read, there is at least one active `borrow`.",4,null],[13,"Writing","","The cell is currently being written to, there is an active `borrow_mut`.",4,null],[13,"Unused","","There are no outstanding borrows on this cell.",4,null],[11,"clone","core::cell","Copies a `Ref`.",5,{"inputs":[{"name":"ref"}],"output":{"name":"ref"}}],[11,"map","","Make a new `Ref` for a component of the borrowed data.",5,{"inputs":[{"name":"ref"},{"name":"f"}],"output":{"name":"ref"}}],[11,"filter_map","","Make a new `Ref` for an optional component of the borrowed data, e.g. an\nenum variant.",5,{"inputs":[{"name":"ref"},{"name":"f"}],"output":{"name":"option"}}],[11,"deref","","",5,{"inputs":[{"name":"ref"}],"output":{"name":"t"}}],[11,"fmt","","",5,{"inputs":[{"name":"ref"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Ref","std::cell","Wraps a borrowed reference to a value in a `RefCell` box.\nA wrapper type for an immutably borrowed value from a `RefCell&lt;T&gt;`.",null,null],[11,"deref_mut","core::cell","",6,{"inputs":[{"name":"refmut"}],"output":{"name":"t"}}],[11,"deref","","",6,{"inputs":[{"name":"refmut"}],"output":{"name":"t"}}],[11,"map","","Make a new `RefMut` for a component of the borrowed data, e.g. an enum\nvariant.",6,{"inputs":[{"name":"refmut"},{"name":"f"}],"output":{"name":"refmut"}}],[11,"filter_map","","Make a new `RefMut` for an optional component of the borrowed data, e.g.\nan enum variant.",6,{"inputs":[{"name":"refmut"},{"name":"f"}],"output":{"name":"option"}}],[11,"fmt","","",6,{"inputs":[{"name":"refmut"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"RefMut","std::cell","A wrapper type for a mutably borrowed value from a `RefCell&lt;T&gt;`.",null,null],[11,"get","core::cell","Gets a mutable pointer to the wrapped value.",7,null],[11,"new","","Constructs a new instance of `UnsafeCell` which will wrap the specified\nvalue.",7,{"inputs":[{"name":"t"}],"output":{"name":"unsafecell"}}],[11,"into_inner","","Unwraps the value.",7,{"inputs":[{"name":"unsafecell"}],"output":{"name":"t"}}],[11,"fmt","","",7,{"inputs":[{"name":"unsafecell"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"UnsafeCell","std::cell","The core primitive for interior mutability in Rust.",null,null],[0,"clone","std","The `Clone` trait for types that cannot be &#39;implicitly copied&#39;.",null,null],[8,"Clone","std::clone","A common trait for cloning an object.",null,null],[10,"clone","","Returns a copy of the value.",8,{"inputs":[{"name":"clone"}],"output":{"name":"self"}}],[11,"clone_from","","Performs copy-assignment from `source`.",8,null],[0,"cmp","std","Functionality for ordering and comparison.",null,null],[8,"PartialEq","std::cmp","Trait for equality comparisons which are [partial equivalence\nrelations](http://en.wikipedia.org/wiki/Partial_equivalence_relation).",null,null],[10,"eq","","This method tests for `self` and `other` values to be equal, and is used\nby `==`.",9,{"inputs":[{"name":"partialeq"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"ne","","This method tests for `!=`.",9,{"inputs":[{"name":"partialeq"},{"name":"rhs"}],"output":{"name":"bool"}}],[8,"Eq","","Trait for equality comparisons which are [equivalence relations](\nhttps://en.wikipedia.org/wiki/Equivalence_relation).",null,null],[11,"partial_cmp","core::cmp","",10,{"inputs":[{"name":"ordering"},{"name":"ordering"}],"output":{"name":"option"}}],[11,"cmp","","",10,{"inputs":[{"name":"ordering"},{"name":"ordering"}],"output":{"name":"ordering"}}],[11,"reverse","","Reverse the `Ordering`.",10,{"inputs":[{"name":"ordering"}],"output":{"name":"ordering"}}],[11,"clone","","",10,{"inputs":[{"name":"ordering"}],"output":{"name":"ordering"}}],[11,"eq","","",10,{"inputs":[{"name":"ordering"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"fmt","","",10,{"inputs":[{"name":"ordering"},{"name":"formatter"}],"output":{"name":"result"}}],[4,"Ordering","std::cmp","An `Ordering` is the result of a comparison between two values.",null,null],[13,"Less","","An ordering where a compared value is less [than another].",10,null],[13,"Equal","","An ordering where a compared value is equal [to another].",10,null],[13,"Greater","","An ordering where a compared value is greater [than another].",10,null],[8,"Ord","","Trait for types that form a [total order](https://en.wikipedia.org/wiki/Total_order).",null,null],[10,"cmp","","This method returns an `Ordering` between `self` and `other`.",11,{"inputs":[{"name":"ord"},{"name":"self"}],"output":{"name":"ordering"}}],[8,"PartialOrd","","Trait for values that can be compared for a sort-order.",null,null],[10,"partial_cmp","","This method returns an ordering between `self` and `other` values if one exists.",12,{"inputs":[{"name":"partialord"},{"name":"rhs"}],"output":{"name":"option"}}],[11,"lt","","This method tests less than (for `self` and `other`) and is used by the `&lt;` operator.",12,{"inputs":[{"name":"partialord"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"le","","This method tests less than or equal to (for `self` and `other`) and is used by the `&lt;=`\noperator.",12,{"inputs":[{"name":"partialord"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"gt","","This method tests greater than (for `self` and `other`) and is used by the `&gt;` operator.",12,{"inputs":[{"name":"partialord"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"ge","","This method tests greater than or equal to (for `self` and `other`) and is used by the `&gt;=`\noperator.",12,{"inputs":[{"name":"partialord"},{"name":"rhs"}],"output":{"name":"bool"}}],[5,"min","","Compare and return the minimum of two values.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"max","","Compare and return the maximum of two values.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[0,"convert","std","Traits for conversions between types.",null,null],[8,"AsRef","std::convert","A cheap, reference-to-reference conversion.",null,null],[10,"as_ref","","Performs the conversion.",13,{"inputs":[{"name":"asref"}],"output":{"name":"t"}}],[8,"AsMut","","A cheap, mutable reference-to-mutable reference conversion.",null,null],[10,"as_mut","","Performs the conversion.",14,{"inputs":[{"name":"asmut"}],"output":{"name":"t"}}],[8,"Into","","A conversion that consumes `self`, which may or may not be expensive.",null,null],[10,"into","","Performs the conversion.",15,{"inputs":[{"name":"into"}],"output":{"name":"t"}}],[8,"From","","Construct `Self` via a conversion.",null,null],[10,"from","","Performs the conversion.",16,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[0,"default","std","The `Default` trait for types which may have meaningful default values.",null,null],[8,"Default","std::default","A trait for giving a type a useful default value.",null,null],[10,"default","","Returns the &quot;default value&quot; for a type.",17,{"inputs":[],"output":{"name":"self"}}],[0,"hash","std","Generic hashing support.",null,null],[8,"Hash","std::hash","A hashable type.",null,null],[10,"hash","","Feeds this value into the state given, updating the hasher as necessary.",18,null],[11,"hash_slice","","Feeds a slice of this type into the state provided.",18,null],[8,"Hasher","","A trait which represents the ability to hash an arbitrary stream of bytes.",null,null],[10,"finish","","Completes a round of hashing, producing the output hash generated.",19,{"inputs":[{"name":"hasher"}],"output":{"name":"u64"}}],[10,"write","","Writes some data into this `Hasher`",19,null],[11,"write_u8","","Write a single `u8` into this hasher",19,null],[11,"write_u16","","Write a single `u16` into this hasher.",19,null],[11,"write_u32","","Write a single `u32` into this hasher.",19,null],[11,"write_u64","","Write a single `u64` into this hasher.",19,null],[11,"write_usize","","Write a single `usize` into this hasher.",19,null],[11,"write_i8","","Write a single `i8` into this hasher.",19,null],[11,"write_i16","","Write a single `i16` into this hasher.",19,null],[11,"write_i32","","Write a single `i32` into this hasher.",19,null],[11,"write_i64","","Write a single `i64` into this hasher.",19,null],[11,"write_isize","","Write a single `isize` into this hasher.",19,null],[8,"BuildHasher","","A `BuildHasher` is typically used as a factory for instances of `Hasher`\nwhich a `HashMap` can then use to hash keys independently.",null,null],[16,"Hasher","","Type of the hasher that will be created.",20,null],[10,"build_hasher","","Creates a new hasher.",20,null],[11,"default","core::hash","",21,{"inputs":[],"output":{"name":"buildhasherdefault"}}],[11,"clone","","",21,{"inputs":[{"name":"buildhasherdefault"}],"output":{"name":"buildhasherdefault"}}],[11,"build_hasher","","",21,{"inputs":[{"name":"buildhasherdefault"}],"output":{"name":"h"}}],[11,"fmt","","",21,{"inputs":[{"name":"buildhasherdefault"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"BuildHasherDefault","std::hash","A structure which implements `BuildHasher` for all `Hasher` types which also\nimplement `Default`.",null,null],[11,"default","core::hash::sip","",22,{"inputs":[],"output":{"name":"siphasher"}}],[11,"clone","","",22,{"inputs":[{"name":"siphasher"}],"output":{"name":"siphasher"}}],[11,"write","","",22,null],[11,"finish","","",22,{"inputs":[{"name":"siphasher"}],"output":{"name":"u64"}}],[11,"new","","Creates a new `SipHasher` with the two initial keys set to 0.",22,{"inputs":[],"output":{"name":"siphasher"}}],[11,"new_with_keys","","Creates a `SipHasher` that is keyed off the provided keys.",22,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"siphasher"}}],[11,"fmt","","",22,{"inputs":[{"name":"siphasher"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"SipHasher","std::hash","An implementation of SipHash 2-4.",null,null],[0,"intrinsics","std","rustc compiler intrinsics.",null,null],[5,"atomic_cxchg","std::intrinsics","",null,null],[5,"atomic_cxchg_acq","","",null,null],[5,"atomic_cxchg_rel","","",null,null],[5,"atomic_cxchg_acqrel","","",null,null],[5,"atomic_cxchg_relaxed","","",null,null],[5,"atomic_cxchg_failrelaxed","","",null,null],[5,"atomic_cxchg_failacq","","",null,null],[5,"atomic_cxchg_acq_failrelaxed","","",null,null],[5,"atomic_cxchg_acqrel_failrelaxed","","",null,null],[5,"atomic_cxchgweak","","",null,null],[5,"atomic_cxchgweak_acq","","",null,null],[5,"atomic_cxchgweak_rel","","",null,null],[5,"atomic_cxchgweak_acqrel","","",null,null],[5,"atomic_cxchgweak_relaxed","","",null,null],[5,"atomic_cxchgweak_failrelaxed","","",null,null],[5,"atomic_cxchgweak_failacq","","",null,null],[5,"atomic_cxchgweak_acq_failrelaxed","","",null,null],[5,"atomic_cxchgweak_acqrel_failrelaxed","","",null,null],[5,"atomic_load","","",null,null],[5,"atomic_load_acq","","",null,null],[5,"atomic_load_relaxed","","",null,null],[5,"atomic_load_unordered","","",null,null],[5,"atomic_store","","",null,null],[5,"atomic_store_rel","","",null,null],[5,"atomic_store_relaxed","","",null,null],[5,"atomic_store_unordered","","",null,null],[5,"atomic_xchg","","",null,null],[5,"atomic_xchg_acq","","",null,null],[5,"atomic_xchg_rel","","",null,null],[5,"atomic_xchg_acqrel","","",null,null],[5,"atomic_xchg_relaxed","","",null,null],[5,"atomic_xadd","","",null,null],[5,"atomic_xadd_acq","","",null,null],[5,"atomic_xadd_rel","","",null,null],[5,"atomic_xadd_acqrel","","",null,null],[5,"atomic_xadd_relaxed","","",null,null],[5,"atomic_xsub","","",null,null],[5,"atomic_xsub_acq","","",null,null],[5,"atomic_xsub_rel","","",null,null],[5,"atomic_xsub_acqrel","","",null,null],[5,"atomic_xsub_relaxed","","",null,null],[5,"atomic_and","","",null,null],[5,"atomic_and_acq","","",null,null],[5,"atomic_and_rel","","",null,null],[5,"atomic_and_acqrel","","",null,null],[5,"atomic_and_relaxed","","",null,null],[5,"atomic_nand","","",null,null],[5,"atomic_nand_acq","","",null,null],[5,"atomic_nand_rel","","",null,null],[5,"atomic_nand_acqrel","","",null,null],[5,"atomic_nand_relaxed","","",null,null],[5,"atomic_or","","",null,null],[5,"atomic_or_acq","","",null,null],[5,"atomic_or_rel","","",null,null],[5,"atomic_or_acqrel","","",null,null],[5,"atomic_or_relaxed","","",null,null],[5,"atomic_xor","","",null,null],[5,"atomic_xor_acq","","",null,null],[5,"atomic_xor_rel","","",null,null],[5,"atomic_xor_acqrel","","",null,null],[5,"atomic_xor_relaxed","","",null,null],[5,"atomic_max","","",null,null],[5,"atomic_max_acq","","",null,null],[5,"atomic_max_rel","","",null,null],[5,"atomic_max_acqrel","","",null,null],[5,"atomic_max_relaxed","","",null,null],[5,"atomic_min","","",null,null],[5,"atomic_min_acq","","",null,null],[5,"atomic_min_rel","","",null,null],[5,"atomic_min_acqrel","","",null,null],[5,"atomic_min_relaxed","","",null,null],[5,"atomic_umin","","",null,null],[5,"atomic_umin_acq","","",null,null],[5,"atomic_umin_rel","","",null,null],[5,"atomic_umin_acqrel","","",null,null],[5,"atomic_umin_relaxed","","",null,null],[5,"atomic_umax","","",null,null],[5,"atomic_umax_acq","","",null,null],[5,"atomic_umax_rel","","",null,null],[5,"atomic_umax_acqrel","","",null,null],[5,"atomic_umax_relaxed","","",null,null],[5,"atomic_fence","","",null,null],[5,"atomic_fence_acq","","",null,null],[5,"atomic_fence_rel","","",null,null],[5,"atomic_fence_acqrel","","",null,null],[5,"atomic_singlethreadfence","","A compiler-only memory barrier.",null,null],[5,"atomic_singlethreadfence_acq","","",null,null],[5,"atomic_singlethreadfence_rel","","",null,null],[5,"atomic_singlethreadfence_acqrel","","",null,null],[5,"abort","","Aborts the execution of the process.",null,null],[5,"unreachable","","Tells LLVM that this point in the code is not reachable,\nenabling further optimizations.",null,null],[5,"assume","","Informs the optimizer that a condition is always true.\nIf the condition is false, the behavior is undefined.",null,null],[5,"breakpoint","","Executes a breakpoint trap, for inspection by a debugger.",null,null],[5,"size_of","","The size of a type in bytes.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"move_val_init","","Moves a value to an uninitialized memory location.",null,null],[5,"min_align_of","","",null,{"inputs":[],"output":{"name":"usize"}}],[5,"pref_align_of","","",null,{"inputs":[],"output":{"name":"usize"}}],[5,"size_of_val","","",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"min_align_of_val","","",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"drop_in_place","","Executes the destructor (if any) of the pointed-to value.",null,null],[5,"type_name","","Gets a static string slice containing the name of a type.",null,{"inputs":[],"output":{"name":"str"}}],[5,"type_id","","Gets an identifier which is globally unique to the specified type. This\nfunction will return the same value for a type regardless of whichever\ncrate it is invoked in.",null,{"inputs":[],"output":{"name":"u64"}}],[5,"init_dropped","","Creates a value initialized to so that its drop flag,\nif any, says that it has been dropped.",null,{"inputs":[],"output":{"name":"t"}}],[5,"init","","Creates a value initialized to zero.",null,{"inputs":[],"output":{"name":"t"}}],[5,"uninit","","Creates an uninitialized value.",null,{"inputs":[],"output":{"name":"t"}}],[5,"forget","","Moves a value out of scope without running drop glue.",null,null],[5,"transmute","","Unsafely transforms a value of one type into a value of another type.",null,{"inputs":[{"name":"t"}],"output":{"name":"u"}}],[5,"return_address","","Gives the address for the return value of the enclosing function.",null,null],[5,"needs_drop","","Returns `true` if the actual type given as `T` requires drop\nglue; returns `false` if the actual type provided for `T`\nimplements `Copy`.",null,{"inputs":[],"output":{"name":"bool"}}],[5,"offset","","Calculates the offset from a pointer.",null,null],[5,"arith_offset","","Calculates the offset from a pointer, potentially wrapping.",null,null],[5,"copy_nonoverlapping","","Copies `count * size_of&lt;T&gt;` bytes from `src` to `dst`. The source\nand destination may *not* overlap.",null,null],[5,"copy","","Copies `count * size_of&lt;T&gt;` bytes from `src` to `dst`. The source\nand destination may overlap.",null,null],[5,"write_bytes","","Invokes memset on the specified pointer, setting `count * size_of::&lt;T&gt;()`\nbytes of memory starting at `dst` to `val`.",null,null],[5,"volatile_copy_nonoverlapping_memory","","Equivalent to the appropriate `llvm.memcpy.p0i8.0i8.*` intrinsic, with\na size of `count` * `size_of::&lt;T&gt;()` and an alignment of\n`min_align_of::&lt;T&gt;()`",null,null],[5,"volatile_copy_memory","","Equivalent to the appropriate `llvm.memmove.p0i8.0i8.*` intrinsic, with\na size of `count` * `size_of::&lt;T&gt;()` and an alignment of\n`min_align_of::&lt;T&gt;()`",null,null],[5,"volatile_set_memory","","Equivalent to the appropriate `llvm.memset.p0i8.*` intrinsic, with a\nsize of `count` * `size_of::&lt;T&gt;()` and an alignment of\n`min_align_of::&lt;T&gt;()`.",null,null],[5,"volatile_load","","Perform a volatile load from the `src` pointer.",null,null],[5,"volatile_store","","Perform a volatile store to the `dst` pointer.",null,null],[5,"sqrtf32","","Returns the square root of an `f32`",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"sqrtf64","","Returns the square root of an `f64`",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"powif32","","Raises an `f32` to an integer power.",null,{"inputs":[{"name":"f32"},{"name":"i32"}],"output":{"name":"f32"}}],[5,"powif64","","Raises an `f64` to an integer power.",null,{"inputs":[{"name":"f64"},{"name":"i32"}],"output":{"name":"f64"}}],[5,"sinf32","","Returns the sine of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"sinf64","","Returns the sine of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"cosf32","","Returns the cosine of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"cosf64","","Returns the cosine of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"powf32","","Raises an `f32` to an `f32` power.",null,{"inputs":[{"name":"f32"},{"name":"f32"}],"output":{"name":"f32"}}],[5,"powf64","","Raises an `f64` to an `f64` power.",null,{"inputs":[{"name":"f64"},{"name":"f64"}],"output":{"name":"f64"}}],[5,"expf32","","Returns the exponential of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"expf64","","Returns the exponential of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"exp2f32","","Returns 2 raised to the power of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"exp2f64","","Returns 2 raised to the power of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"logf32","","Returns the natural logarithm of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"logf64","","Returns the natural logarithm of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"log10f32","","Returns the base 10 logarithm of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"log10f64","","Returns the base 10 logarithm of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"log2f32","","Returns the base 2 logarithm of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"log2f64","","Returns the base 2 logarithm of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"fmaf32","","Returns `a * b + c` for `f32` values.",null,{"inputs":[{"name":"f32"},{"name":"f32"},{"name":"f32"}],"output":{"name":"f32"}}],[5,"fmaf64","","Returns `a * b + c` for `f64` values.",null,{"inputs":[{"name":"f64"},{"name":"f64"},{"name":"f64"}],"output":{"name":"f64"}}],[5,"fabsf32","","Returns the absolute value of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"fabsf64","","Returns the absolute value of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"copysignf32","","Copies the sign from `y` to `x` for `f32` values.",null,{"inputs":[{"name":"f32"},{"name":"f32"}],"output":{"name":"f32"}}],[5,"copysignf64","","Copies the sign from `y` to `x` for `f64` values.",null,{"inputs":[{"name":"f64"},{"name":"f64"}],"output":{"name":"f64"}}],[5,"floorf32","","Returns the largest integer less than or equal to an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"floorf64","","Returns the largest integer less than or equal to an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"ceilf32","","Returns the smallest integer greater than or equal to an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"ceilf64","","Returns the smallest integer greater than or equal to an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"truncf32","","Returns the integer part of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"truncf64","","Returns the integer part of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"rintf32","","Returns the nearest integer to an `f32`. May raise an inexact floating-point exception\nif the argument is not an integer.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"rintf64","","Returns the nearest integer to an `f64`. May raise an inexact floating-point exception\nif the argument is not an integer.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"nearbyintf32","","Returns the nearest integer to an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"nearbyintf64","","Returns the nearest integer to an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"roundf32","","Returns the nearest integer to an `f32`. Rounds half-way cases away from zero.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"roundf64","","Returns the nearest integer to an `f64`. Rounds half-way cases away from zero.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"fadd_fast","","Float addition that allows optimizations based on algebraic rules.\nMay assume inputs are finite.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"fsub_fast","","Float subtraction that allows optimizations based on algebraic rules.\nMay assume inputs are finite.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"fmul_fast","","Float multiplication that allows optimizations based on algebraic rules.\nMay assume inputs are finite.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"fdiv_fast","","Float division that allows optimizations based on algebraic rules.\nMay assume inputs are finite.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"frem_fast","","Float remainder that allows optimizations based on algebraic rules.\nMay assume inputs are finite.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"ctpop","","Returns the number of bits set in an integer type `T`",null,{"inputs":[{"name":"t"}],"output":{"name":"t"}}],[5,"ctlz","","Returns the number of leading bits unset in an integer type `T`",null,{"inputs":[{"name":"t"}],"output":{"name":"t"}}],[5,"cttz","","Returns the number of trailing bits unset in an integer type `T`",null,{"inputs":[{"name":"t"}],"output":{"name":"t"}}],[5,"bswap","","Reverses the bytes in an integer type `T`.",null,{"inputs":[{"name":"t"}],"output":{"name":"t"}}],[5,"add_with_overflow","","Performs checked integer addition.",null,null],[5,"sub_with_overflow","","Performs checked integer subtraction",null,null],[5,"mul_with_overflow","","Performs checked integer multiplication",null,null],[5,"unchecked_div","","Performs an unchecked division, resulting in undefined behavior\nwhere y = 0 or x = `T::min_value()` and y = -1",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"unchecked_rem","","Returns the remainder of an unchecked division, resulting in\nundefined behavior where y = 0 or x = `T::min_value()` and y = -1",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"overflowing_add","","Returns (a + b) mod 2^N, where N is the width of T in bits.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"overflowing_sub","","Returns (a - b) mod 2^N, where N is the width of T in bits.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"overflowing_mul","","Returns (a * b) mod 2^N, where N is the width of T in bits.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"discriminant_value","","Returns the value of the discriminant for the variant in &#39;v&#39;,\ncast to a `u64`; if `T` has no discriminant, returns 0.",null,{"inputs":[{"name":"t"}],"output":{"name":"u64"}}],[5,"try","","Rust&#39;s &quot;try catch&quot; construct which invokes the function pointer `f` with\nthe data pointer `data`.",null,null],[0,"iter","std","Composable external iteration.",null,null],[8,"Iterator","std::iter","An interface for dealing with iterators.",null,null],[16,"Item","","The type of the elements being iterated over.",23,null],[10,"next","","Advances the iterator and returns the next value.",23,{"inputs":[{"name":"iterator"}],"output":{"name":"option"}}],[11,"size_hint","","Returns the bounds on the remaining length of the iterator.",23,null],[11,"count","","Consumes the iterator, counting the number of iterations and returning it.",23,{"inputs":[{"name":"iterator"}],"output":{"name":"usize"}}],[11,"last","","Consumes the iterator, returning the last element.",23,{"inputs":[{"name":"iterator"}],"output":{"name":"option"}}],[11,"nth","","Consumes the `n` first elements of the iterator, then returns the\n`next()` one.",23,{"inputs":[{"name":"iterator"},{"name":"usize"}],"output":{"name":"option"}}],[11,"chain","","Takes two iterators and creates a new iterator over both in sequence.",23,{"inputs":[{"name":"iterator"},{"name":"u"}],"output":{"name":"chain"}}],[11,"zip","","&#39;Zips up&#39; two iterators into a single iterator of pairs.",23,{"inputs":[{"name":"iterator"},{"name":"u"}],"output":{"name":"zip"}}],[11,"map","","Takes a closure and creates an iterator which calls that closure on each\nelement.",23,{"inputs":[{"name":"iterator"},{"name":"f"}],"output":{"name":"map"}}],[11,"filter","","Creates an iterator which uses a closure to determine if an element\nshould be yielded.",23,{"inputs":[{"name":"iterator"},{"name":"p"}],"output":{"name":"filter"}}],[11,"filter_map","","Creates an iterator that both filters and maps.",23,{"inputs":[{"name":"iterator"},{"name":"f"}],"output":{"name":"filtermap"}}],[11,"enumerate","","Creates an iterator which gives the current iteration count as well as\nthe next value.",23,{"inputs":[{"name":"iterator"}],"output":{"name":"enumerate"}}],[11,"peekable","","Creates an iterator which can look at the `next()` element without\nconsuming it.",23,{"inputs":[{"name":"iterator"}],"output":{"name":"peekable"}}],[11,"skip_while","","Creates an iterator that [`skip()`]s elements based on a predicate.",23,{"inputs":[{"name":"iterator"},{"name":"p"}],"output":{"name":"skipwhile"}}],[11,"take_while","","Creates an iterator that yields elements based on a predicate.",23,{"inputs":[{"name":"iterator"},{"name":"p"}],"output":{"name":"takewhile"}}],[11,"skip","","Creates an iterator that skips the first `n` elements.",23,{"inputs":[{"name":"iterator"},{"name":"usize"}],"output":{"name":"skip"}}],[11,"take","","Creates an iterator that yields its first `n` elements.",23,{"inputs":[{"name":"iterator"},{"name":"usize"}],"output":{"name":"take"}}],[11,"scan","","An iterator adaptor similar to [`fold()`] that holds internal state and\nproduces a new iterator.",23,{"inputs":[{"name":"iterator"},{"name":"st"},{"name":"f"}],"output":{"name":"scan"}}],[11,"flat_map","","Creates an iterator that works like map, but flattens nested structure.",23,{"inputs":[{"name":"iterator"},{"name":"f"}],"output":{"name":"flatmap"}}],[11,"fuse","","Creates an iterator which ends after the first `None`.",23,{"inputs":[{"name":"iterator"}],"output":{"name":"fuse"}}],[11,"inspect","","Do something with each element of an iterator, passing the value on.",23,{"inputs":[{"name":"iterator"},{"name":"f"}],"output":{"name":"inspect"}}],[11,"by_ref","","Borrows an iterator, rather than consuming it.",23,{"inputs":[{"name":"iterator"}],"output":{"name":"self"}}],[11,"collect","","Transforms an iterator into a collection.",23,{"inputs":[{"name":"iterator"}],"output":{"name":"b"}}],[11,"partition","","Consumes an iterator, creating two collections from it.",23,null],[11,"fold","","An iterator adaptor that applies a function, producing a single, final value.",23,{"inputs":[{"name":"iterator"},{"name":"b"},{"name":"f"}],"output":{"name":"b"}}],[11,"all","","Tests if every element of the iterator matches a predicate.",23,{"inputs":[{"name":"iterator"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","Tests if any element of the iterator matches a predicate.",23,{"inputs":[{"name":"iterator"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","Searches for an element of an iterator that satisfies a predicate.",23,{"inputs":[{"name":"iterator"},{"name":"p"}],"output":{"name":"option"}}],[11,"position","","Searches for an element in an iterator, returning its index.",23,{"inputs":[{"name":"iterator"},{"name":"p"}],"output":{"name":"option"}}],[11,"rposition","","Searches for an element in an iterator from the right, returning its\nindex.",23,{"inputs":[{"name":"iterator"},{"name":"p"}],"output":{"name":"option"}}],[11,"max","","Returns the maximum element of an iterator.",23,{"inputs":[{"name":"iterator"}],"output":{"name":"option"}}],[11,"min","","Returns the minimum element of an iterator.",23,{"inputs":[{"name":"iterator"}],"output":{"name":"option"}}],[11,"max_by_key","","Returns the element that gives the maximum value from the\nspecified function.",23,{"inputs":[{"name":"iterator"},{"name":"f"}],"output":{"name":"option"}}],[11,"min_by_key","","Returns the element that gives the minimum value from the\nspecified function.",23,{"inputs":[{"name":"iterator"},{"name":"f"}],"output":{"name":"option"}}],[11,"rev","","Reverses an iterator&#39;s direction.",23,{"inputs":[{"name":"iterator"}],"output":{"name":"rev"}}],[11,"unzip","","Converts an iterator of pairs into a pair of containers.",23,null],[11,"cloned","","Creates an iterator which `clone()`s all of its elements.",23,{"inputs":[{"name":"iterator"}],"output":{"name":"cloned"}}],[11,"cycle","","Repeats an iterator endlessly.",23,{"inputs":[{"name":"iterator"}],"output":{"name":"cycle"}}],[11,"sum","","Sums the elements of an iterator.",23,{"inputs":[{"name":"iterator"}],"output":{"name":"s"}}],[11,"product","","Iterates over the entire iterator, multiplying all the elements",23,{"inputs":[{"name":"iterator"}],"output":{"name":"p"}}],[11,"cmp","","Lexicographically compares the elements of this `Iterator` with those\nof another.",23,{"inputs":[{"name":"iterator"},{"name":"i"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","Lexicographically compares the elements of this `Iterator` with those\nof another.",23,{"inputs":[{"name":"iterator"},{"name":"i"}],"output":{"name":"option"}}],[11,"eq","","Determines if the elements of this `Iterator` are equal to those of\nanother.",23,{"inputs":[{"name":"iterator"},{"name":"i"}],"output":{"name":"bool"}}],[11,"ne","","Determines if the elements of this `Iterator` are unequal to those of\nanother.",23,{"inputs":[{"name":"iterator"},{"name":"i"}],"output":{"name":"bool"}}],[11,"lt","","Determines if the elements of this `Iterator` are lexicographically\nless than those of another.",23,{"inputs":[{"name":"iterator"},{"name":"i"}],"output":{"name":"bool"}}],[11,"le","","Determines if the elements of this `Iterator` are lexicographically\nless or equal to those of another.",23,{"inputs":[{"name":"iterator"},{"name":"i"}],"output":{"name":"bool"}}],[11,"gt","","Determines if the elements of this `Iterator` are lexicographically\ngreater than those of another.",23,{"inputs":[{"name":"iterator"},{"name":"i"}],"output":{"name":"bool"}}],[11,"ge","","Determines if the elements of this `Iterator` are lexicographically\ngreater than or equal to those of another.",23,{"inputs":[{"name":"iterator"},{"name":"i"}],"output":{"name":"bool"}}],[8,"FromIterator","","Conversion from an `Iterator`.",null,null],[10,"from_iter","","Creates a value from an iterator.",24,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[8,"IntoIterator","","Conversion into an `Iterator`.",null,null],[16,"Item","","The type of the elements being iterated over.",25,null],[16,"IntoIter","","Which kind of iterator are we turning this into?",25,null],[10,"into_iter","","Creates an iterator from a value.",25,null],[8,"Extend","","Extend a collection with the contents of an iterator.",null,null],[10,"extend","","Extends a collection with the contents of an iterator.",26,null],[8,"DoubleEndedIterator","","An iterator able to yield elements from both ends.",null,null],[10,"next_back","","An iterator able to yield elements from both ends.",27,{"inputs":[{"name":"doubleendediterator"}],"output":{"name":"option"}}],[8,"ExactSizeIterator","","An iterator that knows its exact length.",null,null],[11,"len","","Returns the exact number of times the iterator will iterate.",28,{"inputs":[{"name":"exactsizeiterator"}],"output":{"name":"usize"}}],[11,"next_back","core::iter","",29,{"inputs":[{"name":"rev"}],"output":{"name":"option"}}],[11,"next","","",29,{"inputs":[{"name":"rev"}],"output":{"name":"option"}}],[11,"size_hint","","",29,null],[11,"clone","","",29,{"inputs":[{"name":"rev"}],"output":{"name":"rev"}}],[11,"fmt","","",29,{"inputs":[{"name":"rev"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Rev","std::iter","An double-ended iterator with the direction inverted.",null,null],[11,"next_back","core::iter","",30,{"inputs":[{"name":"cloned"}],"output":{"name":"option"}}],[11,"next","","",30,{"inputs":[{"name":"cloned"}],"output":{"name":"option"}}],[11,"size_hint","","",30,null],[11,"clone","","",30,{"inputs":[{"name":"cloned"}],"output":{"name":"cloned"}}],[11,"fmt","","",30,{"inputs":[{"name":"cloned"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Cloned","std::iter","An iterator that clones the elements of an underlying iterator.",null,null],[11,"next","core::iter","",31,{"inputs":[{"name":"cycle"}],"output":{"name":"option"}}],[11,"size_hint","","",31,null],[11,"clone","","",31,{"inputs":[{"name":"cycle"}],"output":{"name":"cycle"}}],[11,"fmt","","",31,{"inputs":[{"name":"cycle"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Cycle","std::iter","An iterator that repeats endlessly.",null,null],[11,"next_back","core::iter","",32,{"inputs":[{"name":"chain"}],"output":{"name":"option"}}],[11,"next","","",32,{"inputs":[{"name":"chain"}],"output":{"name":"option"}}],[11,"count","","",32,{"inputs":[{"name":"chain"}],"output":{"name":"usize"}}],[11,"nth","","",32,{"inputs":[{"name":"chain"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",32,{"inputs":[{"name":"chain"}],"output":{"name":"option"}}],[11,"size_hint","","",32,null],[11,"clone","","",32,{"inputs":[{"name":"chain"}],"output":{"name":"chain"}}],[11,"fmt","","",32,{"inputs":[{"name":"chain"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Chain","std::iter","An iterator that strings two iterators together.",null,null],[11,"next_back","core::iter","",33,{"inputs":[{"name":"zip"}],"output":{"name":"option"}}],[11,"next","","",33,{"inputs":[{"name":"zip"}],"output":{"name":"option"}}],[11,"size_hint","","",33,null],[11,"clone","","",33,{"inputs":[{"name":"zip"}],"output":{"name":"zip"}}],[11,"fmt","","",33,{"inputs":[{"name":"zip"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Zip","std::iter","An iterator that iterates two other iterators simultaneously.",null,null],[11,"next_back","core::iter","",34,{"inputs":[{"name":"map"}],"output":{"name":"option"}}],[11,"next","","",34,{"inputs":[{"name":"map"}],"output":{"name":"option"}}],[11,"size_hint","","",34,null],[11,"fmt","","",34,{"inputs":[{"name":"map"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",34,{"inputs":[{"name":"map"}],"output":{"name":"map"}}],[3,"Map","std::iter","An iterator that maps the values of `iter` with `f`.",null,null],[11,"next_back","core::iter","",35,{"inputs":[{"name":"filter"}],"output":{"name":"option"}}],[11,"next","","",35,{"inputs":[{"name":"filter"}],"output":{"name":"option"}}],[11,"size_hint","","",35,null],[11,"fmt","","",35,{"inputs":[{"name":"filter"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",35,{"inputs":[{"name":"filter"}],"output":{"name":"filter"}}],[3,"Filter","std::iter","An iterator that filters the elements of `iter` with `predicate`.",null,null],[11,"next_back","core::iter","",36,{"inputs":[{"name":"filtermap"}],"output":{"name":"option"}}],[11,"next","","",36,{"inputs":[{"name":"filtermap"}],"output":{"name":"option"}}],[11,"size_hint","","",36,null],[11,"fmt","","",36,{"inputs":[{"name":"filtermap"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",36,{"inputs":[{"name":"filtermap"}],"output":{"name":"filtermap"}}],[3,"FilterMap","std::iter","An iterator that uses `f` to both filter and map elements from `iter`.",null,null],[11,"next_back","core::iter","",37,{"inputs":[{"name":"enumerate"}],"output":{"name":"option"}}],[11,"next","","# Overflow Behavior",37,{"inputs":[{"name":"enumerate"}],"output":{"name":"option"}}],[11,"size_hint","","",37,null],[11,"nth","","",37,{"inputs":[{"name":"enumerate"},{"name":"usize"}],"output":{"name":"option"}}],[11,"count","","",37,{"inputs":[{"name":"enumerate"}],"output":{"name":"usize"}}],[11,"clone","","",37,{"inputs":[{"name":"enumerate"}],"output":{"name":"enumerate"}}],[11,"fmt","","",37,{"inputs":[{"name":"enumerate"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Enumerate","std::iter","An iterator that yields the current count and the element during iteration.",null,null],[11,"peek","core::iter","Returns a reference to the next() value without advancing the iterator.",38,{"inputs":[{"name":"peekable"}],"output":{"name":"option"}}],[11,"is_empty","","Checks if the iterator has finished iterating.",38,{"inputs":[{"name":"peekable"}],"output":{"name":"bool"}}],[11,"next","","",38,{"inputs":[{"name":"peekable"}],"output":{"name":"option"}}],[11,"count","","",38,{"inputs":[{"name":"peekable"}],"output":{"name":"usize"}}],[11,"nth","","",38,{"inputs":[{"name":"peekable"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",38,{"inputs":[{"name":"peekable"}],"output":{"name":"option"}}],[11,"size_hint","","",38,null],[11,"clone","","",38,{"inputs":[{"name":"peekable"}],"output":{"name":"peekable"}}],[11,"fmt","","",38,{"inputs":[{"name":"peekable"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Peekable","std::iter","An iterator with a `peek()` that returns an optional reference to the next\nelement.",null,null],[11,"next","core::iter","",39,{"inputs":[{"name":"skipwhile"}],"output":{"name":"option"}}],[11,"size_hint","","",39,null],[11,"fmt","","",39,{"inputs":[{"name":"skipwhile"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",39,{"inputs":[{"name":"skipwhile"}],"output":{"name":"skipwhile"}}],[3,"SkipWhile","std::iter","An iterator that rejects elements while `predicate` is true.",null,null],[11,"next","core::iter","",40,{"inputs":[{"name":"takewhile"}],"output":{"name":"option"}}],[11,"size_hint","","",40,null],[11,"fmt","","",40,{"inputs":[{"name":"takewhile"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",40,{"inputs":[{"name":"takewhile"}],"output":{"name":"takewhile"}}],[3,"TakeWhile","std::iter","An iterator that only accepts elements while `predicate` is true.",null,null],[11,"next_back","core::iter","",41,{"inputs":[{"name":"skip"}],"output":{"name":"option"}}],[11,"next","","",41,{"inputs":[{"name":"skip"}],"output":{"name":"option"}}],[11,"nth","","",41,{"inputs":[{"name":"skip"},{"name":"usize"}],"output":{"name":"option"}}],[11,"count","","",41,{"inputs":[{"name":"skip"}],"output":{"name":"usize"}}],[11,"last","","",41,{"inputs":[{"name":"skip"}],"output":{"name":"option"}}],[11,"size_hint","","",41,null],[11,"clone","","",41,{"inputs":[{"name":"skip"}],"output":{"name":"skip"}}],[11,"fmt","","",41,{"inputs":[{"name":"skip"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Skip","std::iter","An iterator that skips over `n` elements of `iter`.",null,null],[11,"next","core::iter","",42,{"inputs":[{"name":"take"}],"output":{"name":"option"}}],[11,"nth","","",42,{"inputs":[{"name":"take"},{"name":"usize"}],"output":{"name":"option"}}],[11,"size_hint","","",42,null],[11,"clone","","",42,{"inputs":[{"name":"take"}],"output":{"name":"take"}}],[11,"fmt","","",42,{"inputs":[{"name":"take"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Take","std::iter","An iterator that only iterates over the first `n` iterations of `iter`.",null,null],[11,"next","core::iter","",43,{"inputs":[{"name":"scan"}],"output":{"name":"option"}}],[11,"size_hint","","",43,null],[11,"fmt","","",43,{"inputs":[{"name":"scan"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",43,{"inputs":[{"name":"scan"}],"output":{"name":"scan"}}],[3,"Scan","std::iter","An iterator to maintain state while iterating another iterator.",null,null],[11,"next_back","core::iter","",44,{"inputs":[{"name":"flatmap"}],"output":{"name":"option"}}],[11,"next","","",44,{"inputs":[{"name":"flatmap"}],"output":{"name":"option"}}],[11,"size_hint","","",44,null],[11,"fmt","","",44,{"inputs":[{"name":"flatmap"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",44,{"inputs":[{"name":"flatmap"}],"output":{"name":"flatmap"}}],[3,"FlatMap","std::iter","An iterator that maps each element to an iterator, and yields the elements\nof the produced iterators.",null,null],[11,"next_back","core::iter","",45,{"inputs":[{"name":"fuse"}],"output":{"name":"option"}}],[11,"next","","",45,{"inputs":[{"name":"fuse"}],"output":{"name":"option"}}],[11,"nth","","",45,{"inputs":[{"name":"fuse"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",45,{"inputs":[{"name":"fuse"}],"output":{"name":"option"}}],[11,"count","","",45,{"inputs":[{"name":"fuse"}],"output":{"name":"usize"}}],[11,"size_hint","","",45,null],[11,"clone","","",45,{"inputs":[{"name":"fuse"}],"output":{"name":"fuse"}}],[11,"fmt","","",45,{"inputs":[{"name":"fuse"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Fuse","std::iter","An iterator that yields `None` forever after the underlying iterator\nyields `None` once.",null,null],[11,"next_back","core::iter","",46,{"inputs":[{"name":"inspect"}],"output":{"name":"option"}}],[11,"next","","",46,{"inputs":[{"name":"inspect"}],"output":{"name":"option"}}],[11,"size_hint","","",46,null],[11,"fmt","","",46,{"inputs":[{"name":"inspect"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",46,{"inputs":[{"name":"inspect"}],"output":{"name":"inspect"}}],[3,"Inspect","std::iter","An iterator that calls a function with a reference to each element before\nyielding it.",null,null],[8,"Step","","Objects that can be stepped over in both directions.",null,null],[10,"step","","Steps `self` if possible.",47,{"inputs":[{"name":"step"},{"name":"self"}],"output":{"name":"option"}}],[10,"steps_between","","Returns the number of steps between two step objects. The count is\ninclusive of `start` and exclusive of `end`.",47,{"inputs":[{"name":"self"},{"name":"self"},{"name":"self"}],"output":{"name":"option"}}],[11,"next","core::iter","",48,{"inputs":[{"name":"stepby"}],"output":{"name":"option"}}],[11,"size_hint","","",48,null],[11,"next","","",48,{"inputs":[{"name":"stepby"}],"output":{"name":"option"}}],[11,"size_hint","","",48,null],[11,"next","","",48,{"inputs":[{"name":"stepby"}],"output":{"name":"option"}}],[11,"size_hint","","",48,null],[11,"clone","","",48,{"inputs":[{"name":"stepby"}],"output":{"name":"stepby"}}],[11,"fmt","","",48,{"inputs":[{"name":"stepby"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"StepBy","std::iter","An adapter for stepping range iterators by a custom amount.",null,null],[11,"next_back","core::iter","",49,{"inputs":[{"name":"repeat"}],"output":{"name":"option"}}],[11,"next","","",49,{"inputs":[{"name":"repeat"}],"output":{"name":"option"}}],[11,"size_hint","","",49,null],[11,"clone","","",49,{"inputs":[{"name":"repeat"}],"output":{"name":"repeat"}}],[11,"fmt","","",49,{"inputs":[{"name":"repeat"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Repeat","std::iter","An iterator that repeats an element endlessly.",null,null],[5,"repeat","","Creates a new iterator that endlessly repeats a single element.",null,{"inputs":[{"name":"t"}],"output":{"name":"repeat"}}],[11,"default","core::iter","",50,{"inputs":[],"output":{"name":"empty"}}],[11,"clone","","",50,{"inputs":[{"name":"empty"}],"output":{"name":"empty"}}],[11,"len","","",50,{"inputs":[{"name":"empty"}],"output":{"name":"usize"}}],[11,"next_back","","",50,{"inputs":[{"name":"empty"}],"output":{"name":"option"}}],[11,"next","","",50,{"inputs":[{"name":"empty"}],"output":{"name":"option"}}],[11,"size_hint","","",50,null],[11,"fmt","","",50,{"inputs":[{"name":"empty"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Empty","std::iter","An iterator that yields nothing.",null,null],[5,"empty","","Creates an iterator that yields nothing.",null,{"inputs":[],"output":{"name":"empty"}}],[11,"len","core::iter","",51,{"inputs":[{"name":"once"}],"output":{"name":"usize"}}],[11,"next_back","","",51,{"inputs":[{"name":"once"}],"output":{"name":"option"}}],[11,"next","","",51,{"inputs":[{"name":"once"}],"output":{"name":"option"}}],[11,"size_hint","","",51,null],[11,"clone","","",51,{"inputs":[{"name":"once"}],"output":{"name":"once"}}],[11,"fmt","","",51,{"inputs":[{"name":"once"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Once","std::iter","An iterator that yields an element exactly once.",null,null],[5,"once","","Creates an iterator that yields an element exactly once.",null,{"inputs":[{"name":"t"}],"output":{"name":"once"}}],[0,"marker","std","Primitive traits and marker types representing basic &#39;kinds&#39; of types.",null,null],[8,"Send","std::marker","Types that can be transferred across thread boundaries.",null,null],[8,"Sized","","Types with a constant size known at compile-time.",null,null],[8,"Unsize","","Types that can be &quot;unsized&quot; to a dynamically sized type.",null,null],[8,"Copy","","Types that can be copied by simply copying bits (i.e. `memcpy`).",null,null],[8,"Sync","","Types that can be safely shared between threads when aliased.",null,null],[11,"fmt","core::marker","",52,{"inputs":[{"name":"phantomdata"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","",52,{"inputs":[],"output":{"name":"phantomdata"}}],[11,"clone","","",52,{"inputs":[{"name":"phantomdata"}],"output":{"name":"phantomdata"}}],[11,"cmp","","",52,{"inputs":[{"name":"phantomdata"},{"name":"phantomdata"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",52,{"inputs":[{"name":"phantomdata"},{"name":"phantomdata"}],"output":{"name":"option"}}],[11,"eq","","",52,{"inputs":[{"name":"phantomdata"},{"name":"phantomdata"}],"output":{"name":"bool"}}],[11,"hash","","",52,null],[3,"PhantomData","std::marker","`PhantomData&lt;T&gt;` allows you to describe that a type acts as if it stores a value of type `T`,\neven though it does not. This allows you to inform the compiler about certain safety properties\nof your code.",null,null],[8,"Reflect","","Types that can be reflected over.",null,null],[0,"mem","std","Basic functions for dealing with memory.",null,null],[5,"forget","std::mem","Leaks a value into the void, consuming ownership and never running its\ndestructor.",null,null],[5,"size_of","","Returns the size of a type in bytes.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"size_of_val","","Returns the size of the given value in bytes.",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"min_align_of","","Returns the ABI-required minimum alignment of a type",null,{"inputs":[],"output":{"name":"usize"}}],[5,"min_align_of_val","","Returns the ABI-required minimum alignment of the type of the value that `val` points to",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"align_of","","Returns the alignment in memory for a type.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"align_of_val","","Returns the ABI-required minimum alignment of the type of the value that `val` points to",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"zeroed","","Creates a value initialized to zero.",null,{"inputs":[],"output":{"name":"t"}}],[5,"dropped","","Creates a value initialized to an unspecified series of bytes.",null,{"inputs":[],"output":{"name":"t"}}],[5,"uninitialized","","Bypasses Rust&#39;s normal memory-initialization checks by pretending to\nproduce a value of type T, while doing nothing at all.",null,{"inputs":[],"output":{"name":"t"}}],[5,"swap","","Swap the values at two mutable locations of the same type, without deinitializing or copying\neither one.",null,null],[5,"replace","","Replaces the value at a mutable location with a new one, returning the old value, without\ndeinitializing or copying either one.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"drop","","Disposes of a value.",null,null],[17,"POST_DROP_U8","","",null,null],[17,"POST_DROP_U32","","",null,null],[17,"POST_DROP_U64","","",null,null],[17,"POST_DROP_USIZE","","",null,null],[5,"transmute_copy","","Interprets `src` as `&amp;U`, and then reads `src` without moving the contained\nvalue.",null,{"inputs":[{"name":"t"}],"output":{"name":"u"}}],[5,"transmute","","Unsafely transforms a value of one type into a value of another type.",null,{"inputs":[{"name":"t"}],"output":{"name":"u"}}],[0,"ops","std","Overloadable operators.",null,null],[8,"Drop","std::ops","The `Drop` trait is used to run some code when a value goes out of scope.\nThis is sometimes called a &#39;destructor&#39;.",null,null],[10,"drop","","A method called when the value goes out of scope.",53,null],[8,"Add","","The `Add` trait is used to specify the functionality of `+`.",null,null],[16,"Output","","The resulting type after applying the `+` operator",54,null],[10,"add","","The method for the `+` operator",54,null],[8,"Sub","","The `Sub` trait is used to specify the functionality of `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator",55,null],[10,"sub","","The method for the `-` operator",55,null],[8,"Mul","","The `Mul` trait is used to specify the functionality of `*`.",null,null],[16,"Output","","The resulting type after applying the `*` operator",56,null],[10,"mul","","The method for the `*` operator",56,null],[8,"Div","","The `Div` trait is used to specify the functionality of `/`.",null,null],[16,"Output","","The resulting type after applying the `/` operator",57,null],[10,"div","","The method for the `/` operator",57,null],[8,"Rem","","The `Rem` trait is used to specify the functionality of `%`.",null,null],[16,"Output","","The resulting type after applying the `%` operator",58,null],[10,"rem","","The method for the `%` operator",58,null],[8,"Neg","","The `Neg` trait is used to specify the functionality of unary `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator",59,null],[10,"neg","","The method for the unary `-` operator",59,null],[8,"Not","","The `Not` trait is used to specify the functionality of unary `!`.",null,null],[16,"Output","","The resulting type after applying the `!` operator",60,null],[10,"not","","The method for the unary `!` operator",60,null],[8,"BitAnd","","The `BitAnd` trait is used to specify the functionality of `&amp;`.",null,null],[16,"Output","","The resulting type after applying the `&amp;` operator",61,null],[10,"bitand","","The method for the `&amp;` operator",61,null],[8,"BitOr","","The `BitOr` trait is used to specify the functionality of `|`.",null,null],[16,"Output","","The resulting type after applying the `|` operator",62,null],[10,"bitor","","The method for the `|` operator",62,null],[8,"BitXor","","The `BitXor` trait is used to specify the functionality of `^`.",null,null],[16,"Output","","The resulting type after applying the `^` operator",63,null],[10,"bitxor","","The method for the `^` operator",63,null],[8,"Shl","","The `Shl` trait is used to specify the functionality of `&lt;&lt;`.",null,null],[16,"Output","","The resulting type after applying the `&lt;&lt;` operator",64,null],[10,"shl","","The method for the `&lt;&lt;` operator",64,null],[8,"Shr","","The `Shr` trait is used to specify the functionality of `&gt;&gt;`.",null,null],[16,"Output","","The resulting type after applying the `&gt;&gt;` operator",65,null],[10,"shr","","The method for the `&gt;&gt;` operator",65,null],[8,"AddAssign","","The `AddAssign` trait is used to specify the functionality of `+=`.",null,null],[10,"add_assign","","The method for the `+=` operator",66,null],[8,"SubAssign","","The `SubAssign` trait is used to specify the functionality of `-=`.",null,null],[10,"sub_assign","","The method for the `-=` operator",67,null],[8,"MulAssign","","The `MulAssign` trait is used to specify the functionality of `*=`.",null,null],[10,"mul_assign","","The method for the `*=` operator",68,null],[8,"DivAssign","","The `DivAssign` trait is used to specify the functionality of `/=`.",null,null],[10,"div_assign","","The method for the `/=` operator",69,null],[8,"RemAssign","","The `RemAssign` trait is used to specify the functionality of `%=`.",null,null],[10,"rem_assign","","The method for the `%=` operator",70,null],[8,"BitAndAssign","","The `BitAndAssign` trait is used to specify the functionality of `&amp;=`.",null,null],[10,"bitand_assign","","The method for the `&amp;` operator",71,null],[8,"BitOrAssign","","The `BitOrAssign` trait is used to specify the functionality of `|=`.",null,null],[10,"bitor_assign","","The method for the `|=` operator",72,null],[8,"BitXorAssign","","The `BitXorAssign` trait is used to specify the functionality of `^=`.",null,null],[10,"bitxor_assign","","The method for the `^=` operator",73,null],[8,"ShlAssign","","The `ShlAssign` trait is used to specify the functionality of `&lt;&lt;=`.",null,null],[10,"shl_assign","","The method for the `&lt;&lt;=` operator",74,null],[8,"ShrAssign","","The `ShrAssign` trait is used to specify the functionality of `&gt;&gt;=`.",null,null],[10,"shr_assign","","The method for the `&gt;&gt;=` operator",75,null],[8,"Index","","The `Index` trait is used to specify the functionality of indexing operations\nlike `arr[idx]` when used in an immutable context.",null,null],[16,"Output","","The returned type after indexing",76,null],[10,"index","","The method for the indexing (`Foo[Bar]`) operation",76,null],[8,"IndexMut","","The `IndexMut` trait is used to specify the functionality of indexing\noperations like `arr[idx]`, when used in a mutable context.",null,null],[10,"index_mut","","The method for the indexing (`Foo[Bar]`) operation",77,null],[11,"fmt","core::ops","",78,{"inputs":[{"name":"rangefull"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",78,{"inputs":[{"name":"rangefull"}],"output":{"name":"rangefull"}}],[11,"eq","","",78,{"inputs":[{"name":"rangefull"},{"name":"rangefull"}],"output":{"name":"bool"}}],[3,"RangeFull","std::ops","An unbounded range. Use `..` (two dots) for its shorthand.",null,null],[11,"contains","core::ops","# Examples",79,{"inputs":[{"name":"range"},{"name":"idx"}],"output":{"name":"bool"}}],[11,"fmt","","",79,{"inputs":[{"name":"range"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",79,{"inputs":[{"name":"range"}],"output":{"name":"range"}}],[11,"eq","","",79,{"inputs":[{"name":"range"},{"name":"range"}],"output":{"name":"bool"}}],[11,"ne","","",79,{"inputs":[{"name":"range"},{"name":"range"}],"output":{"name":"bool"}}],[11,"next_back","","",79,{"inputs":[{"name":"range"}],"output":{"name":"option"}}],[11,"next","","",79,{"inputs":[{"name":"range"}],"output":{"name":"option"}}],[11,"size_hint","","",79,null],[11,"step_by","","Creates an iterator with the same range, but stepping by the\ngiven amount at each iteration.",79,{"inputs":[{"name":"range"},{"name":"a"}],"output":{"name":"stepby"}}],[3,"Range","std::ops","A (half-open) range which is bounded at both ends: { x | start &lt;= x &lt; end }.\nUse `start..end` (two dots) for its shorthand.",null,null],[12,"start","","The lower bound of the range (inclusive).",79,null],[12,"end","","The upper bound of the range (exclusive).",79,null],[11,"clone","core::ops","",80,{"inputs":[{"name":"rangefrom"}],"output":{"name":"rangefrom"}}],[11,"eq","","",80,{"inputs":[{"name":"rangefrom"},{"name":"rangefrom"}],"output":{"name":"bool"}}],[11,"ne","","",80,{"inputs":[{"name":"rangefrom"},{"name":"rangefrom"}],"output":{"name":"bool"}}],[11,"next","","",80,{"inputs":[{"name":"rangefrom"}],"output":{"name":"option"}}],[11,"contains","","# Examples",80,{"inputs":[{"name":"rangefrom"},{"name":"idx"}],"output":{"name":"bool"}}],[11,"fmt","","",80,{"inputs":[{"name":"rangefrom"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"step_by","","Creates an iterator starting at the same point, but stepping by\nthe given amount at each iteration.",80,{"inputs":[{"name":"rangefrom"},{"name":"a"}],"output":{"name":"stepby"}}],[3,"RangeFrom","std::ops","A range which is only bounded below: { x | start &lt;= x }.\nUse `start..` for its shorthand.",null,null],[12,"start","","The lower bound of the range (inclusive).",80,null],[11,"contains","core::ops","# Examples",81,{"inputs":[{"name":"rangeto"},{"name":"idx"}],"output":{"name":"bool"}}],[11,"fmt","","",81,{"inputs":[{"name":"rangeto"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",81,{"inputs":[{"name":"rangeto"}],"output":{"name":"rangeto"}}],[11,"eq","","",81,{"inputs":[{"name":"rangeto"},{"name":"rangeto"}],"output":{"name":"bool"}}],[11,"ne","","",81,{"inputs":[{"name":"rangeto"},{"name":"rangeto"}],"output":{"name":"bool"}}],[3,"RangeTo","std::ops","A range which is only bounded above: { x | x &lt; end }.\nUse `..end` (two dots) for its shorthand.",null,null],[12,"end","","The upper bound of the range (exclusive).",81,null],[11,"next_back","core::ops","",82,{"inputs":[{"name":"rangeinclusive"}],"output":{"name":"option"}}],[11,"next","","",82,{"inputs":[{"name":"rangeinclusive"}],"output":{"name":"option"}}],[11,"size_hint","","",82,null],[11,"clone","","",82,{"inputs":[{"name":"rangeinclusive"}],"output":{"name":"rangeinclusive"}}],[11,"eq","","",82,{"inputs":[{"name":"rangeinclusive"},{"name":"rangeinclusive"}],"output":{"name":"bool"}}],[11,"ne","","",82,{"inputs":[{"name":"rangeinclusive"},{"name":"rangeinclusive"}],"output":{"name":"bool"}}],[11,"contains","","# Examples",82,{"inputs":[{"name":"rangeinclusive"},{"name":"idx"}],"output":{"name":"bool"}}],[11,"step_by","","Creates an iterator with the same range, but stepping by the\ngiven amount at each iteration.",82,{"inputs":[{"name":"rangeinclusive"},{"name":"a"}],"output":{"name":"stepby"}}],[11,"from","","",82,{"inputs":[{"name":"range"}],"output":{"name":"rangeinclusive"}}],[11,"fmt","","",82,{"inputs":[{"name":"rangeinclusive"},{"name":"formatter"}],"output":{"name":"result"}}],[4,"RangeInclusive","std::ops","An inclusive range which is bounded at both ends: { x | start &lt;= x &lt;= end }.\nUse `start...end` (three dots) for its shorthand.",null,null],[13,"Empty","","Empty range (iteration has finished)",82,null],[12,"at","std::ops::RangeInclusive","",82,null],[13,"NonEmpty","std::ops","Non-empty range (iteration will yield value(s))",82,null],[12,"start","std::ops::RangeInclusive","",82,null],[12,"end","","",82,null],[11,"contains","core::ops","# Examples",83,{"inputs":[{"name":"rangetoinclusive"},{"name":"idx"}],"output":{"name":"bool"}}],[11,"fmt","","",83,{"inputs":[{"name":"rangetoinclusive"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",83,{"inputs":[{"name":"rangetoinclusive"}],"output":{"name":"rangetoinclusive"}}],[11,"eq","","",83,{"inputs":[{"name":"rangetoinclusive"},{"name":"rangetoinclusive"}],"output":{"name":"bool"}}],[11,"ne","","",83,{"inputs":[{"name":"rangetoinclusive"},{"name":"rangetoinclusive"}],"output":{"name":"bool"}}],[3,"RangeToInclusive","std::ops","An inclusive range which is only bounded above: { x | x &lt;= end }.\nUse `...end` (three dots) for its shorthand.",null,null],[12,"end","","The upper bound of the range (inclusive)",83,null],[8,"Deref","","The `Deref` trait is used to specify the functionality of dereferencing\noperations, like `*v`.",null,null],[16,"Target","","The resulting type after dereferencing",84,null],[10,"deref","","The method called to dereference a value",84,null],[8,"DerefMut","","The `DerefMut` trait is used to specify the functionality of dereferencing\nmutably like `*v = 1;`",null,null],[10,"deref_mut","","The method called to mutably dereference a value",85,null],[8,"Fn","","A version of the call operator that takes an immutable receiver.",null,null],[10,"call","","This is called when the call operator is used.",86,null],[8,"FnMut","","A version of the call operator that takes a mutable receiver.",null,null],[10,"call_mut","","This is called when the call operator is used.",87,null],[8,"FnOnce","","A version of the call operator that takes a by-value receiver.",null,null],[16,"Output","","The returned type after the call operator is used.",88,null],[10,"call_once","","This is called when the call operator is used.",88,null],[8,"CoerceUnsized","","Trait that indicates that this is a pointer or a wrapper for one,\nwhere unsizing can be performed on the pointee.",null,null],[8,"Place","","Both `in (PLACE) EXPR` and `box EXPR` desugar into expressions\nthat allocate an intermediate &quot;place&quot; that holds uninitialized\nstate.  The desugaring evaluates EXPR, and writes the result at\nthe address returned by the `pointer` method of this trait.",null,null],[10,"pointer","","Returns the address where the input value will be written.\nNote that the data at this address is generally uninitialized,\nand thus one should use `ptr::write` for initializing it.",89,null],[8,"Placer","","Interface to implementations of  `in (PLACE) EXPR`.",null,null],[16,"Place","","`Place` is the intermedate agent guarding the\nuninitialized state for `Data`.",90,null],[10,"make_place","","Creates a fresh place from `self`.",90,null],[8,"InPlace","","Specialization of `Place` trait supporting `in (PLACE) EXPR`.",null,null],[16,"Owner","","`Owner` is the type of the end value of `in (PLACE) EXPR`",91,null],[10,"finalize","","Converts self into the final value, shifting\ndeallocation/cleanup responsibilities (if any remain), over to\nthe returned instance of `Owner` and forgetting self.",91,null],[8,"Boxed","","Core trait for the `box EXPR` form.",null,null],[16,"Data","","The kind of data that is stored in this kind of box.",92,null],[16,"Place","","The place that will negotiate the storage of the data.",92,null],[10,"finalize","","Converts filled place into final owning value, shifting\ndeallocation/cleanup responsibilities (if any remain), over to\nreturned instance of `Self` and forgetting `filled`.",92,null],[8,"BoxPlace","","Specialization of `Place` trait supporting `box EXPR`.",null,null],[10,"make_place","","Creates a globally fresh place.",93,{"inputs":[],"output":{"name":"self"}}],[0,"ptr","std","Raw, unsafe pointers, `*const T`, and `*mut T`.",null,null],[5,"null","std::ptr","Creates a null raw pointer.",null,null],[5,"null_mut","","Creates a null mutable raw pointer.",null,null],[5,"swap","","Swaps the values at two mutable locations of the same type, without\ndeinitializing either. They may overlap, unlike `mem::swap` which is\notherwise equivalent.",null,null],[5,"replace","","Replaces the value at `dest` with `src`, returning the old\nvalue, without dropping either.",null,null],[5,"read","","Reads the value from `src` without moving it. This leaves the\nmemory in `src` unchanged.",null,null],[5,"read_and_drop","","",null,null],[5,"write","","Overwrites a memory location with the given value without reading or\ndropping the old value.",null,null],[5,"read_volatile","","Performs a volatile read of the value from `src` without moving it. This\nleaves the memory in `src` unchanged.",null,null],[5,"write_volatile","","Performs a volatile write of a memory location with the given value without\nreading or dropping the old value.",null,null],[11,"fmt","core::ptr","",94,{"inputs":[{"name":"unique"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"deref","","",94,null],[11,"new","","Creates a new `Unique`.",94,null],[11,"get","","Dereferences the content.",94,{"inputs":[{"name":"unique"}],"output":{"name":"t"}}],[11,"get_mut","","Mutably dereferences the content.",94,{"inputs":[{"name":"unique"}],"output":{"name":"t"}}],[3,"Unique","std::ptr","A wrapper around a raw non-null `*mut T` that indicates that the possessor\nof this wrapper owns the referent. This in turn implies that the\n`Unique&lt;T&gt;` is `Send`/`Sync` if `T` is `Send`/`Sync`, unlike a raw\n`*mut T` (which conveys no particular ownership semantics).  It\nalso implies that the referent of the pointer should not be\nmodified without a unique path to the `Unique` reference. Useful\nfor building abstractions like `Vec&lt;T&gt;` or `Box&lt;T&gt;`, which\ninternally use raw pointers to manage the memory that they own.",null,null],[11,"fmt","core::ptr","",95,{"inputs":[{"name":"shared"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"deref","","",95,null],[11,"clone","","",95,{"inputs":[{"name":"shared"}],"output":{"name":"shared"}}],[11,"new","","Creates a new `Shared`.",95,null],[3,"Shared","std::ptr","A wrapper around a raw non-null `*mut T` that indicates that the possessor\nof this wrapper has shared ownership of the referent. Useful for\nbuilding abstractions like `Rc&lt;T&gt;` or `Arc&lt;T&gt;`, which internally\nuse raw pointers to manage the memory that they own.",null,null],[5,"write_bytes","","Invokes memset on the specified pointer, setting `count * size_of::&lt;T&gt;()`\nbytes of memory starting at `dst` to `val`.",null,null],[5,"drop_in_place","","Executes the destructor (if any) of the pointed-to value.",null,null],[5,"copy_nonoverlapping","","Copies `count * size_of&lt;T&gt;` bytes from `src` to `dst`. The source\nand destination may *not* overlap.",null,null],[5,"copy","","Copies `count * size_of&lt;T&gt;` bytes from `src` to `dst`. The source\nand destination may overlap.",null,null],[0,"raw","std","Contains struct definitions for the layout of compiler built-in types.",null,null],[11,"clone","core::raw","",96,{"inputs":[{"name":"slice"}],"output":{"name":"slice"}}],[3,"Slice","std::raw","The representation of a slice like `&amp;[T]`.",null,null],[12,"data","","",96,null],[12,"len","","",96,null],[11,"clone","core::raw","",97,{"inputs":[{"name":"traitobject"}],"output":{"name":"traitobject"}}],[3,"TraitObject","std::raw","The representation of a trait object like `&amp;SomeTrait`.",null,null],[12,"data","","",97,null],[12,"vtable","","",97,null],[8,"Repr","","This trait is meant to map equivalences between raw structs and their\ncorresponding rust values.",null,null],[11,"repr","","This function &quot;unwraps&quot; a rust value (without consuming it) into its raw\nstruct representation. This can be used to read/write different values\nfor the struct. This is a safe method because by default it does not\nenable write-access to the fields of the return value in safe code.",98,{"inputs":[{"name":"repr"}],"output":{"name":"t"}}],[0,"result","std","Error handling with the `Result` type.",null,null],[11,"eq","core::result","",99,{"inputs":[{"name":"result"},{"name":"result"}],"output":{"name":"bool"}}],[11,"ne","","",99,{"inputs":[{"name":"result"},{"name":"result"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",99,{"inputs":[{"name":"result"},{"name":"result"}],"output":{"name":"option"}}],[11,"lt","","",99,{"inputs":[{"name":"result"},{"name":"result"}],"output":{"name":"bool"}}],[11,"le","","",99,{"inputs":[{"name":"result"},{"name":"result"}],"output":{"name":"bool"}}],[11,"gt","","",99,{"inputs":[{"name":"result"},{"name":"result"}],"output":{"name":"bool"}}],[11,"ge","","",99,{"inputs":[{"name":"result"},{"name":"result"}],"output":{"name":"bool"}}],[11,"cmp","","",99,{"inputs":[{"name":"result"},{"name":"result"}],"output":{"name":"ordering"}}],[11,"into_iter","","Returns a consuming iterator over the possibly contained value.",99,{"inputs":[{"name":"result"}],"output":{"name":"intoiter"}}],[11,"fmt","","",99,{"inputs":[{"name":"result"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"unwrap_err","","Unwraps a result, yielding the content of an `Err`.",99,{"inputs":[{"name":"result"}],"output":{"name":"e"}}],[11,"hash","","",99,null],[11,"unwrap","","Unwraps a result, yielding the content of an `Ok`.",99,{"inputs":[{"name":"result"}],"output":{"name":"t"}}],[11,"expect","","Unwraps a result, yielding the content of an `Ok`.",99,{"inputs":[{"name":"result"},{"name":"str"}],"output":{"name":"t"}}],[11,"is_ok","","Returns true if the result is `Ok`",99,{"inputs":[{"name":"result"}],"output":{"name":"bool"}}],[11,"is_err","","Returns true if the result is `Err`",99,{"inputs":[{"name":"result"}],"output":{"name":"bool"}}],[11,"ok","","Converts from `Result&lt;T, E&gt;` to `Option&lt;T&gt;`",99,{"inputs":[{"name":"result"}],"output":{"name":"option"}}],[11,"err","","Converts from `Result&lt;T, E&gt;` to `Option&lt;E&gt;`",99,{"inputs":[{"name":"result"}],"output":{"name":"option"}}],[11,"as_ref","","Converts from `Result&lt;T, E&gt;` to `Result&lt;&amp;T, &amp;E&gt;`",99,{"inputs":[{"name":"result"}],"output":{"name":"result"}}],[11,"as_mut","","Converts from `Result&lt;T, E&gt;` to `Result&lt;&amp;mut T, &amp;mut E&gt;`",99,{"inputs":[{"name":"result"}],"output":{"name":"result"}}],[11,"map","","Maps a `Result&lt;T, E&gt;` to `Result&lt;U, E&gt;` by applying a function to a\ncontained `Ok` value, leaving an `Err` value untouched.",99,{"inputs":[{"name":"result"},{"name":"f"}],"output":{"name":"result"}}],[11,"map_err","","Maps a `Result&lt;T, E&gt;` to `Result&lt;T, F&gt;` by applying a function to a\ncontained `Err` value, leaving an `Ok` value untouched.",99,{"inputs":[{"name":"result"},{"name":"o"}],"output":{"name":"result"}}],[11,"iter","","Returns an iterator over the possibly contained value.",99,{"inputs":[{"name":"result"}],"output":{"name":"iter"}}],[11,"iter_mut","","Returns a mutable iterator over the possibly contained value.",99,{"inputs":[{"name":"result"}],"output":{"name":"itermut"}}],[11,"and","","Returns `res` if the result is `Ok`, otherwise returns the `Err` value of `self`.",99,{"inputs":[{"name":"result"},{"name":"result"}],"output":{"name":"result"}}],[11,"and_then","","Calls `op` if the result is `Ok`, otherwise returns the `Err` value of `self`.",99,{"inputs":[{"name":"result"},{"name":"f"}],"output":{"name":"result"}}],[11,"or","","Returns `res` if the result is `Err`, otherwise returns the `Ok` value of `self`.",99,{"inputs":[{"name":"result"},{"name":"result"}],"output":{"name":"result"}}],[11,"or_else","","Calls `op` if the result is `Err`, otherwise returns the `Ok` value of `self`.",99,{"inputs":[{"name":"result"},{"name":"o"}],"output":{"name":"result"}}],[11,"unwrap_or","","Unwraps a result, yielding the content of an `Ok`.\nElse it returns `optb`.",99,{"inputs":[{"name":"result"},{"name":"t"}],"output":{"name":"t"}}],[11,"unwrap_or_else","","Unwraps a result, yielding the content of an `Ok`.\nIf the value is an `Err` then it calls `op` with its value.",99,{"inputs":[{"name":"result"},{"name":"f"}],"output":{"name":"t"}}],[11,"clone","","",99,{"inputs":[{"name":"result"}],"output":{"name":"result"}}],[11,"from_iter","","Takes each element in the `Iterator`: if it is an `Err`, no further\nelements are taken, and the `Err` is returned. Should no `Err` occur, a\ncontainer with the values of each `Result` is returned.",99,{"inputs":[{"name":"i"}],"output":{"name":"result"}}],[4,"Result","std::result","`Result` is a type that represents either success (`Ok`) or failure (`Err`).",null,null],[13,"Ok","","Contains the success value",99,null],[13,"Err","","Contains the error value",99,null],[11,"clone","core::result","",100,{"inputs":[{"name":"iter"}],"output":{"name":"iter"}}],[11,"next_back","","",100,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"next","","",100,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"size_hint","","",100,null],[11,"fmt","","",100,{"inputs":[{"name":"iter"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Iter","std::result","An iterator over a reference to the `Ok` variant of a `Result`.",null,null],[11,"next_back","core::result","",101,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"next","","",101,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"size_hint","","",101,null],[11,"fmt","","",101,{"inputs":[{"name":"itermut"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"IterMut","std::result","An iterator over a mutable reference to the `Ok` variant of a `Result`.",null,null],[11,"next_back","core::result","",102,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"next","","",102,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"size_hint","","",102,null],[11,"fmt","","",102,{"inputs":[{"name":"intoiter"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"IntoIter","std::result","An iterator over the value in a `Ok` variant of a `Result`.",null,null],[0,"option","std","Optional values.",null,null],[11,"hash","core::option","",103,null],[11,"partial_cmp","","",103,{"inputs":[{"name":"option"},{"name":"option"}],"output":{"name":"option"}}],[11,"lt","","",103,{"inputs":[{"name":"option"},{"name":"option"}],"output":{"name":"bool"}}],[11,"le","","",103,{"inputs":[{"name":"option"},{"name":"option"}],"output":{"name":"bool"}}],[11,"gt","","",103,{"inputs":[{"name":"option"},{"name":"option"}],"output":{"name":"bool"}}],[11,"ge","","",103,{"inputs":[{"name":"option"},{"name":"option"}],"output":{"name":"bool"}}],[11,"cmp","","",103,{"inputs":[{"name":"option"},{"name":"option"}],"output":{"name":"ordering"}}],[11,"fmt","","",103,{"inputs":[{"name":"option"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"cloned","","Maps an `Option&lt;&amp;T&gt;` to an `Option&lt;T&gt;` by cloning the contents of the\noption.",103,{"inputs":[{"name":"option"}],"output":{"name":"option"}}],[11,"is_some","","Returns `true` if the option is a `Some` value",103,{"inputs":[{"name":"option"}],"output":{"name":"bool"}}],[11,"is_none","","Returns `true` if the option is a `None` value",103,{"inputs":[{"name":"option"}],"output":{"name":"bool"}}],[11,"as_ref","","Converts from `Option&lt;T&gt;` to `Option&lt;&amp;T&gt;`",103,{"inputs":[{"name":"option"}],"output":{"name":"option"}}],[11,"as_mut","","Converts from `Option&lt;T&gt;` to `Option&lt;&amp;mut T&gt;`",103,{"inputs":[{"name":"option"}],"output":{"name":"option"}}],[11,"expect","","Unwraps an option, yielding the content of a `Some`.",103,{"inputs":[{"name":"option"},{"name":"str"}],"output":{"name":"t"}}],[11,"unwrap","","Moves the value `v` out of the `Option&lt;T&gt;` if it is `Some(v)`.",103,{"inputs":[{"name":"option"}],"output":{"name":"t"}}],[11,"unwrap_or","","Returns the contained value or a default.",103,{"inputs":[{"name":"option"},{"name":"t"}],"output":{"name":"t"}}],[11,"unwrap_or_else","","Returns the contained value or computes it from a closure.",103,{"inputs":[{"name":"option"},{"name":"f"}],"output":{"name":"t"}}],[11,"map","","Maps an `Option&lt;T&gt;` to `Option&lt;U&gt;` by applying a function to a contained value",103,{"inputs":[{"name":"option"},{"name":"f"}],"output":{"name":"option"}}],[11,"map_or","","Applies a function to the contained value (if any),\nor returns a `default` (if not).",103,{"inputs":[{"name":"option"},{"name":"u"},{"name":"f"}],"output":{"name":"u"}}],[11,"map_or_else","","Applies a function to the contained value (if any),\nor computes a `default` (if not).",103,{"inputs":[{"name":"option"},{"name":"d"},{"name":"f"}],"output":{"name":"u"}}],[11,"ok_or","","Transforms the `Option&lt;T&gt;` into a `Result&lt;T, E&gt;`, mapping `Some(v)` to\n`Ok(v)` and `None` to `Err(err)`.",103,{"inputs":[{"name":"option"},{"name":"e"}],"output":{"name":"result"}}],[11,"ok_or_else","","Transforms the `Option&lt;T&gt;` into a `Result&lt;T, E&gt;`, mapping `Some(v)` to\n`Ok(v)` and `None` to `Err(err())`.",103,{"inputs":[{"name":"option"},{"name":"f"}],"output":{"name":"result"}}],[11,"iter","","Returns an iterator over the possibly contained value.",103,{"inputs":[{"name":"option"}],"output":{"name":"iter"}}],[11,"iter_mut","","Returns a mutable iterator over the possibly contained value.",103,{"inputs":[{"name":"option"}],"output":{"name":"itermut"}}],[11,"and","","Returns `None` if the option is `None`, otherwise returns `optb`.",103,{"inputs":[{"name":"option"},{"name":"option"}],"output":{"name":"option"}}],[11,"and_then","","Returns `None` if the option is `None`, otherwise calls `f` with the\nwrapped value and returns the result.",103,{"inputs":[{"name":"option"},{"name":"f"}],"output":{"name":"option"}}],[11,"or","","Returns the option if it contains a value, otherwise returns `optb`.",103,{"inputs":[{"name":"option"},{"name":"option"}],"output":{"name":"option"}}],[11,"or_else","","Returns the option if it contains a value, otherwise calls `f` and\nreturns the result.",103,{"inputs":[{"name":"option"},{"name":"f"}],"output":{"name":"option"}}],[11,"take","","Takes the value out of the option, leaving a `None` in its place.",103,{"inputs":[{"name":"option"}],"output":{"name":"option"}}],[11,"clone","","",103,{"inputs":[{"name":"option"}],"output":{"name":"option"}}],[11,"eq","","",103,{"inputs":[{"name":"option"},{"name":"option"}],"output":{"name":"bool"}}],[11,"ne","","",103,{"inputs":[{"name":"option"},{"name":"option"}],"output":{"name":"bool"}}],[11,"into_iter","","Returns a consuming iterator over the possibly contained value.",103,{"inputs":[{"name":"option"}],"output":{"name":"intoiter"}}],[11,"default","","",103,{"inputs":[],"output":{"name":"option"}}],[11,"unwrap_or_default","","Returns the contained value or a default",103,{"inputs":[{"name":"option"}],"output":{"name":"t"}}],[11,"from_iter","","Takes each element in the `Iterator`: if it is `None`, no further\nelements are taken, and the `None` is returned. Should no `None` occur, a\ncontainer with the values of each `Option` is returned.",103,{"inputs":[{"name":"i"}],"output":{"name":"option"}}],[4,"Option","std::option","The `Option` type. See [the module level documentation](index.html) for more.",null,null],[13,"None","","No value",103,null],[13,"Some","","Some value `T`",103,null],[11,"next_back","core::option","",104,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"next","","",104,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"size_hint","","",104,null],[11,"fmt","","",104,{"inputs":[{"name":"iter"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",104,{"inputs":[{"name":"iter"}],"output":{"name":"iter"}}],[3,"Iter","std::option","An iterator over a reference of the contained item in an Option.",null,null],[11,"next_back","core::option","",105,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"next","","",105,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"size_hint","","",105,null],[11,"fmt","","",105,{"inputs":[{"name":"itermut"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"IterMut","std::option","An iterator over a mutable reference of the contained item in an Option.",null,null],[11,"next_back","core::option","",106,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"next","","",106,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"size_hint","","",106,null],[11,"clone","","",106,{"inputs":[{"name":"intoiter"}],"output":{"name":"intoiter"}}],[11,"fmt","","",106,{"inputs":[{"name":"intoiter"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"IntoIter","std::option","An iterator over the item contained inside an Option.",null,null],[0,"boxed","std","A pointer type for heap allocation.",null,null],[17,"HEAP","std::boxed","A value that represents the heap. This is the default place that the `box`\nkeyword allocates into when no place is supplied.",null,null],[11,"make_place","alloc::boxed","",107,{"inputs":[{"name":"exchangeheapsingleton"}],"output":{"name":"intermediatebox"}}],[11,"clone","","",107,{"inputs":[{"name":"exchangeheapsingleton"}],"output":{"name":"exchangeheapsingleton"}}],[3,"ExchangeHeapSingleton","std::boxed","This the singleton type used solely for `boxed::HEAP`.",null,null],[11,"as_mut","alloc::boxed","",108,{"inputs":[{"name":"box"}],"output":{"name":"t"}}],[11,"as_ref","","",108,{"inputs":[{"name":"box"}],"output":{"name":"t"}}],[11,"borrow_mut","","",108,{"inputs":[{"name":"box"}],"output":{"name":"t"}}],[11,"borrow","","",108,{"inputs":[{"name":"box"}],"output":{"name":"t"}}],[11,"clone","","",108,{"inputs":[{"name":"box"}],"output":{"name":"box"}}],[11,"call_once","","",108,{"inputs":[{"name":"box"},{"name":"a"}],"output":{"name":"r"}}],[11,"call_once","","",108,{"inputs":[{"name":"box"},{"name":"a"}],"output":{"name":"r"}}],[11,"next_back","","",108,{"inputs":[{"name":"box"}],"output":{"name":"option"}}],[11,"next","","",108,{"inputs":[{"name":"box"}],"output":{"name":"option"}}],[11,"size_hint","","",108,null],[11,"deref_mut","","",108,{"inputs":[{"name":"box"}],"output":{"name":"t"}}],[11,"deref","","",108,{"inputs":[{"name":"box"}],"output":{"name":"t"}}],[11,"fmt","","",108,{"inputs":[{"name":"box"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",108,{"inputs":[{"name":"box"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",108,{"inputs":[{"name":"box"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",108,{"inputs":[{"name":"box"}],"output":{"name":"result"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",108,{"inputs":[{"name":"box"}],"output":{"name":"result"}}],[11,"from","","",108,{"inputs":[{"name":"t"}],"output":{"name":"box"}}],[11,"hash","","",108,null],[11,"cmp","","",108,{"inputs":[{"name":"box"},{"name":"box"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",108,{"inputs":[{"name":"box"},{"name":"box"}],"output":{"name":"option"}}],[11,"lt","","",108,{"inputs":[{"name":"box"},{"name":"box"}],"output":{"name":"bool"}}],[11,"le","","",108,{"inputs":[{"name":"box"},{"name":"box"}],"output":{"name":"bool"}}],[11,"ge","","",108,{"inputs":[{"name":"box"},{"name":"box"}],"output":{"name":"bool"}}],[11,"gt","","",108,{"inputs":[{"name":"box"},{"name":"box"}],"output":{"name":"bool"}}],[11,"eq","","",108,{"inputs":[{"name":"box"},{"name":"box"}],"output":{"name":"bool"}}],[11,"ne","","",108,{"inputs":[{"name":"box"},{"name":"box"}],"output":{"name":"bool"}}],[11,"clone","","",108,{"inputs":[{"name":"box"}],"output":{"name":"box"}}],[11,"clone","","Returns a new box with a `clone()` of this box&#39;s contents.",108,{"inputs":[{"name":"box"}],"output":{"name":"box"}}],[11,"clone_from","","Copies `source`&#39;s contents into `self` without creating a new allocation.",108,null],[11,"default","","",108,{"inputs":[],"output":{"name":"box"}}],[11,"default","","",108,{"inputs":[],"output":{"name":"box"}}],[11,"from_raw","","Constructs a box from a raw pointer.",108,null],[11,"into_raw","","Consumes the `Box`, returning the wrapped raw pointer.",108,null],[11,"new","","Allocates memory on the heap and then places `x` into it.",108,{"inputs":[{"name":"t"}],"output":{"name":"box"}}],[11,"finalize","","",108,{"inputs":[{"name":"intermediatebox"}],"output":{"name":"box"}}],[3,"Box","std::boxed","A pointer type for heap allocation.",null,null],[11,"drop","alloc::boxed","",109,null],[11,"finalize","","",109,{"inputs":[{"name":"intermediatebox"}],"output":{"name":"box"}}],[11,"make_place","","",109,{"inputs":[],"output":{"name":"intermediatebox"}}],[11,"pointer","","",109,null],[3,"IntermediateBox","std::boxed","`IntermediateBox` represents uninitialized backing storage for `Box`.",null,null],[8,"FnBox","","`FnBox` is a version of the `FnOnce` intended for use with boxed\nclosure objects. The idea is that where one would normally store a\n`Box&lt;FnOnce()&gt;` in a data structure, you should use\n`Box&lt;FnBox()&gt;`. The two traits behave essentially the same, except\nthat a `FnBox` closure can only be called if it is boxed. (Note\nthat `FnBox` may be deprecated in the future if `Box&lt;FnOnce()&gt;`\nclosures become directly usable.)",null,null],[16,"Output","","",110,null],[10,"call_box","","",110,null],[0,"rc","std","Thread-local reference-counted boxes (the `Rc&lt;T&gt;` type).",null,null],[11,"as_ref","alloc::rc","",111,{"inputs":[{"name":"rc"}],"output":{"name":"t"}}],[11,"borrow","","",111,{"inputs":[{"name":"rc"}],"output":{"name":"t"}}],[11,"from","","",111,{"inputs":[{"name":"t"}],"output":{"name":"rc"}}],[11,"fmt","","",111,{"inputs":[{"name":"rc"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",111,{"inputs":[{"name":"rc"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",111,{"inputs":[{"name":"rc"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",111,null],[11,"cmp","","Comparison for two `Rc&lt;T&gt;`s.",111,{"inputs":[{"name":"rc"},{"name":"rc"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","Partial comparison for two `Rc&lt;T&gt;`s.",111,{"inputs":[{"name":"rc"},{"name":"rc"}],"output":{"name":"option"}}],[11,"lt","","Less-than comparison for two `Rc&lt;T&gt;`s.",111,{"inputs":[{"name":"rc"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"le","","&#39;Less-than or equal to&#39; comparison for two `Rc&lt;T&gt;`s.",111,{"inputs":[{"name":"rc"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"gt","","Greater-than comparison for two `Rc&lt;T&gt;`s.",111,{"inputs":[{"name":"rc"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"ge","","&#39;Greater-than or equal to&#39; comparison for two `Rc&lt;T&gt;`s.",111,{"inputs":[{"name":"rc"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"eq","","Equality for two `Rc&lt;T&gt;`s.",111,{"inputs":[{"name":"rc"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"ne","","Inequality for two `Rc&lt;T&gt;`s.",111,{"inputs":[{"name":"rc"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"default","","Creates a new `Rc&lt;T&gt;`, with the `Default` value for `T`.",111,{"inputs":[],"output":{"name":"rc"}}],[11,"clone","","Makes a clone of the `Rc&lt;T&gt;`.",111,{"inputs":[{"name":"rc"}],"output":{"name":"rc"}}],[11,"drop","","Drops the `Rc&lt;T&gt;`.",111,null],[11,"deref","","",111,{"inputs":[{"name":"rc"}],"output":{"name":"t"}}],[11,"make_mut","","Make a mutable reference into the given `Rc&lt;T&gt;` by cloning the inner\ndata if the `Rc&lt;T&gt;` doesn&#39;t have one strong reference and no weak\nreferences.",111,{"inputs":[{"name":"rc"}],"output":{"name":"t"}}],[11,"downgrade","","Downgrades the `Rc&lt;T&gt;` to a `Weak&lt;T&gt;` reference.",111,{"inputs":[{"name":"rc"}],"output":{"name":"weak"}}],[11,"weak_count","","Get the number of weak references to this value.",111,{"inputs":[{"name":"rc"}],"output":{"name":"usize"}}],[11,"strong_count","","Get the number of strong references to this value.",111,{"inputs":[{"name":"rc"}],"output":{"name":"usize"}}],[11,"is_unique","","Returns true if there are no other `Rc` or `Weak&lt;T&gt;` values that share\nthe same inner value.",111,{"inputs":[{"name":"rc"}],"output":{"name":"bool"}}],[11,"get_mut","","Returns a mutable reference to the contained value if the `Rc&lt;T&gt;` has\none strong reference and no weak references.",111,{"inputs":[{"name":"rc"}],"output":{"name":"option"}}],[11,"new","","Constructs a new `Rc&lt;T&gt;`.",111,{"inputs":[{"name":"t"}],"output":{"name":"rc"}}],[11,"try_unwrap","","Unwraps the contained value if the `Rc&lt;T&gt;` has exactly one strong reference.",111,{"inputs":[{"name":"rc"}],"output":{"name":"result"}}],[11,"would_unwrap","","Checks if `Rc::try_unwrap` would return `Ok`.",111,{"inputs":[{"name":"rc"}],"output":{"name":"bool"}}],[3,"Rc","std::rc","A reference-counted pointer type over an immutable value.",null,null],[11,"new","alloc::rc","Constructs a new `Weak&lt;T&gt;` without an accompanying instance of T.",112,{"inputs":[],"output":{"name":"weak"}}],[11,"fmt","","",112,{"inputs":[{"name":"weak"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","Makes a clone of the `Weak&lt;T&gt;`.",112,{"inputs":[{"name":"weak"}],"output":{"name":"weak"}}],[11,"drop","","Drops the `Weak&lt;T&gt;`.",112,null],[11,"upgrade","","Upgrades a weak reference to a strong reference.",112,{"inputs":[{"name":"weak"}],"output":{"name":"option"}}],[3,"Weak","std::rc","A weak version of `Rc&lt;T&gt;`.",null,null],[0,"borrow","std","A module for working with borrowed data.",null,null],[8,"ToOwned","std::borrow","A generalization of `Clone` to borrowed data.",null,null],[16,"Owned","","",113,null],[10,"to_owned","","Creates owned data from borrowed data, usually by cloning.",113,null],[11,"to_mut","collections::borrow","Acquires a mutable reference to the owned form of the data.",114,null],[11,"into_owned","","Extracts the owned data.",114,null],[11,"from_iter","","",114,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"from","","",114,{"inputs":[{"name":"vec"}],"output":{"name":"cow"}}],[11,"from","","",114,null],[11,"eq","","",114,{"inputs":[{"name":"cow"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"ne","","",114,{"inputs":[{"name":"cow"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"eq","","",114,null],[11,"ne","","",114,null],[11,"eq","","",114,null],[11,"ne","","",114,null],[11,"from","","",114,{"inputs":[{"name":"string"}],"output":{"name":"cow"}}],[11,"from","","",114,{"inputs":[{"name":"str"}],"output":{"name":"cow"}}],[11,"eq","","",114,{"inputs":[{"name":"cow"},{"name":"string"}],"output":{"name":"bool"}}],[11,"ne","","",114,{"inputs":[{"name":"cow"},{"name":"string"}],"output":{"name":"bool"}}],[11,"eq","","",114,{"inputs":[{"name":"cow"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",114,{"inputs":[{"name":"cow"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","","",114,{"inputs":[{"name":"cow"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",114,{"inputs":[{"name":"cow"},{"name":"str"}],"output":{"name":"bool"}}],[11,"as_ref","","",114,{"inputs":[{"name":"cow"}],"output":{"name":"t"}}],[11,"hash","","",114,null],[11,"fmt","","",114,{"inputs":[{"name":"cow"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",114,{"inputs":[{"name":"cow"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"partial_cmp","","",114,{"inputs":[{"name":"cow"},{"name":"cow"}],"output":{"name":"option"}}],[11,"eq","","",114,{"inputs":[{"name":"cow"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"cmp","","",114,{"inputs":[{"name":"cow"},{"name":"cow"}],"output":{"name":"ordering"}}],[11,"deref","","",114,{"inputs":[{"name":"cow"}],"output":{"name":"b"}}],[11,"clone","","",114,{"inputs":[{"name":"cow"}],"output":{"name":"cow"}}],[11,"borrow","","",114,{"inputs":[{"name":"cow"}],"output":{"name":"b"}}],[4,"Cow","std::borrow","A clone-on-write smart pointer.",null,null],[13,"Borrowed","","Borrowed data.",114,null],[13,"Owned","","Owned data.",114,null],[8,"Borrow","","A trait for borrowing data.",null,null],[10,"borrow","","Immutably borrows from an owned value.",115,{"inputs":[{"name":"borrow"}],"output":{"name":"borrowed"}}],[8,"BorrowMut","","A trait for mutably borrowing data.",null,null],[10,"borrow_mut","","Mutably borrows from an owned value.",116,{"inputs":[{"name":"borrowmut"}],"output":{"name":"borrowed"}}],[0,"fmt","std","Utilities for formatting and printing strings",null,null],[5,"format","std::fmt","The format function takes a precompiled format string and a list of\narguments, to return the resulting formatted string.",null,{"inputs":[{"name":"arguments"}],"output":{"name":"string"}}],[8,"UpperExp","","Format trait for the `E` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",117,{"inputs":[{"name":"upperexp"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"UpperHex","","Format trait for the `X` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",118,{"inputs":[{"name":"upperhex"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","core::fmt","",119,{"inputs":[{"name":"error"}],"output":{"name":"error"}}],[11,"fmt","","",119,{"inputs":[{"name":"error"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",119,{"inputs":[{"name":"error"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Error","std::fmt","The error type which is returned from formatting a message into a stream.",null,null],[5,"write","","The `write` function takes an output stream, a precompiled format string,\nand a list of arguments. The arguments will be formatted according to the\nspecified format string into the output stream provided.",null,{"inputs":[{"name":"write"},{"name":"arguments"}],"output":{"name":"result"}}],[8,"Write","","A collection of methods that are required to format a message into a stream.",null,null],[10,"write_str","","Writes a slice of bytes into this writer, returning whether the write\nsucceeded.",120,{"inputs":[{"name":"write"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","Writes a `char` into this writer, returning whether the write succeeded.",120,{"inputs":[{"name":"write"},{"name":"char"}],"output":{"name":"result"}}],[11,"write_fmt","","Glue for usage of the `write!` macro with implementors of this trait.",120,{"inputs":[{"name":"write"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"entry","core::fmt::builders","Adds a new entry to the map output.",121,{"inputs":[{"name":"debugmap"},{"name":"debug"},{"name":"debug"}],"output":{"name":"debugmap"}}],[11,"entries","","Adds the contents of an iterator of entries to the map output.",121,{"inputs":[{"name":"debugmap"},{"name":"i"}],"output":{"name":"debugmap"}}],[11,"finish","","Finishes output and returns any error encountered.",121,{"inputs":[{"name":"debugmap"}],"output":{"name":"result"}}],[3,"DebugMap","std::fmt","A struct to help with `fmt::Debug` implementations.",null,null],[11,"field","core::fmt::builders","Adds a new field to the generated struct output.",122,{"inputs":[{"name":"debugstruct"},{"name":"str"},{"name":"debug"}],"output":{"name":"debugstruct"}}],[11,"finish","","Finishes output and returns any error encountered.",122,{"inputs":[{"name":"debugstruct"}],"output":{"name":"result"}}],[3,"DebugStruct","std::fmt","A struct to help with `fmt::Debug` implementations.",null,null],[11,"field","core::fmt::builders","Adds a new field to the generated tuple struct output.",123,{"inputs":[{"name":"debugtuple"},{"name":"debug"}],"output":{"name":"debugtuple"}}],[11,"finish","","Finishes output and returns any error encountered.",123,{"inputs":[{"name":"debugtuple"}],"output":{"name":"result"}}],[3,"DebugTuple","std::fmt","A struct to help with `fmt::Debug` implementations.",null,null],[11,"entry","core::fmt::builders","Adds a new entry to the list output.",124,{"inputs":[{"name":"debuglist"},{"name":"debug"}],"output":{"name":"debuglist"}}],[11,"entries","","Adds the contents of an iterator of entries to the list output.",124,{"inputs":[{"name":"debuglist"},{"name":"i"}],"output":{"name":"debuglist"}}],[11,"finish","","Finishes output and returns any error encountered.",124,{"inputs":[{"name":"debuglist"}],"output":{"name":"result"}}],[3,"DebugList","std::fmt","A struct to help with `fmt::Debug` implementations.",null,null],[8,"Display","","Format trait for an empty format, `{}`.",null,null],[10,"fmt","","Formats the value using the given formatter.",125,{"inputs":[{"name":"display"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Binary","","Format trait for the `b` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",126,{"inputs":[{"name":"binary"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Debug","","Format trait for the `?` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",127,{"inputs":[{"name":"debug"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"entry","core::fmt::builders","Adds a new entry to the set output.",128,{"inputs":[{"name":"debugset"},{"name":"debug"}],"output":{"name":"debugset"}}],[11,"entries","","Adds the contents of an iterator of entries to the set output.",128,{"inputs":[{"name":"debugset"},{"name":"i"}],"output":{"name":"debugset"}}],[11,"finish","","Finishes output and returns any error encountered.",128,{"inputs":[{"name":"debugset"}],"output":{"name":"result"}}],[3,"DebugSet","std::fmt","A struct to help with `fmt::Debug` implementations.",null,null],[6,"Result","","",null,null],[8,"Pointer","","Format trait for the `p` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",129,{"inputs":[{"name":"pointer"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"LowerExp","","Format trait for the `e` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",130,{"inputs":[{"name":"lowerexp"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"LowerHex","","Format trait for the `x` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",131,{"inputs":[{"name":"lowerhex"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Octal","","Format trait for the `o` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",132,{"inputs":[{"name":"octal"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","core::fmt","",133,{"inputs":[{"name":"arguments"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",133,{"inputs":[{"name":"arguments"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",133,{"inputs":[{"name":"arguments"}],"output":{"name":"arguments"}}],[3,"Arguments","std::fmt","This structure represents a safely precompiled version of a format string\nand its arguments. This cannot be generated at runtime because it cannot\nsafely be done so, so no constructors are given and the fields are private\nto prevent modification.",null,null],[11,"pad_integral","core::fmt","Performs the correct padding for an integer which has already been\nemitted into a str. The str should *not* contain the sign for the\ninteger, that will be added by this method.",134,{"inputs":[{"name":"formatter"},{"name":"bool"},{"name":"str"},{"name":"str"}],"output":{"name":"result"}}],[11,"pad","","This function takes a string slice and emits it to the internal buffer\nafter applying the relevant formatting flags specified. The flags\nrecognized for generic strings are:",134,{"inputs":[{"name":"formatter"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_str","","Writes some data to the underlying buffer contained within this\nformatter.",134,{"inputs":[{"name":"formatter"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_fmt","","Writes some formatted information into this instance",134,{"inputs":[{"name":"formatter"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"flags","","Flags for formatting (packed version of rt::Flag)",134,{"inputs":[{"name":"formatter"}],"output":{"name":"u32"}}],[11,"fill","","Character used as &#39;fill&#39; whenever there is alignment",134,{"inputs":[{"name":"formatter"}],"output":{"name":"char"}}],[11,"align","","Flag indicating what form of alignment was requested",134,{"inputs":[{"name":"formatter"}],"output":{"name":"alignment"}}],[11,"width","","Optionally specified integer width that the output should be",134,{"inputs":[{"name":"formatter"}],"output":{"name":"option"}}],[11,"precision","","Optionally specified precision for numeric types",134,{"inputs":[{"name":"formatter"}],"output":{"name":"option"}}],[11,"sign_plus","","Determines if the `+` flag was specified.",134,{"inputs":[{"name":"formatter"}],"output":{"name":"bool"}}],[11,"sign_minus","","Determines if the `-` flag was specified.",134,{"inputs":[{"name":"formatter"}],"output":{"name":"bool"}}],[11,"alternate","","Determines if the `#` flag was specified.",134,{"inputs":[{"name":"formatter"}],"output":{"name":"bool"}}],[11,"sign_aware_zero_pad","","Determines if the `0` flag was specified.",134,{"inputs":[{"name":"formatter"}],"output":{"name":"bool"}}],[11,"debug_struct","","Creates a `DebugStruct` builder designed to assist with creation of\n`fmt::Debug` implementations for structs.",134,{"inputs":[{"name":"formatter"},{"name":"str"}],"output":{"name":"debugstruct"}}],[11,"debug_tuple","","Creates a `DebugTuple` builder designed to assist with creation of\n`fmt::Debug` implementations for tuple structs.",134,{"inputs":[{"name":"formatter"},{"name":"str"}],"output":{"name":"debugtuple"}}],[11,"debug_list","","Creates a `DebugList` builder designed to assist with creation of\n`fmt::Debug` implementations for list-like structures.",134,{"inputs":[{"name":"formatter"}],"output":{"name":"debuglist"}}],[11,"debug_set","","Creates a `DebugSet` builder designed to assist with creation of\n`fmt::Debug` implementations for set-like structures.",134,{"inputs":[{"name":"formatter"}],"output":{"name":"debugset"}}],[11,"debug_map","","Creates a `DebugMap` builder designed to assist with creation of\n`fmt::Debug` implementations for map-like structures.",134,{"inputs":[{"name":"formatter"}],"output":{"name":"debugmap"}}],[11,"write_str","","",134,{"inputs":[{"name":"formatter"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","",134,{"inputs":[{"name":"formatter"},{"name":"char"}],"output":{"name":"result"}}],[11,"write_fmt","","",134,{"inputs":[{"name":"formatter"},{"name":"arguments"}],"output":{"name":"result"}}],[3,"Formatter","std::fmt","A struct to represent both where to emit formatting strings to and how they\nshould be formatted. A mutable version of this is passed to all formatting\ntraits.",null,null],[0,"slice","std","A dynamically-sized view into a contiguous sequence, `[T]`.",null,null],[8,"SliceConcatExt","std::slice","An extension trait for concatenating slices",null,null],[16,"Output","","The resulting type after concatenation",135,null],[10,"concat","","Flattens a slice of `T` into a single value `Self::Output`.",135,null],[10,"join","","Flattens a slice of `T` into a single value `Self::Output`, placing a\ngiven separator between each.",135,null],[10,"connect","","",135,null],[11,"clone","core::slice","",136,{"inputs":[{"name":"split"}],"output":{"name":"split"}}],[11,"fmt","","",136,{"inputs":[{"name":"split"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next_back","","",136,{"inputs":[{"name":"split"}],"output":{"name":"option"}}],[11,"next","","",136,{"inputs":[{"name":"split"}],"output":{"name":"option"}}],[11,"size_hint","","",136,null],[3,"Split","std::slice","An iterator over subslices separated by elements that match a predicate\nfunction.",null,null],[11,"fmt","core::slice","",137,{"inputs":[{"name":"splitn"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",137,{"inputs":[{"name":"splitn"}],"output":{"name":"option"}}],[11,"size_hint","","",137,null],[3,"SplitN","std::slice","An iterator over subslices separated by elements that match a predicate\nfunction, limited to a given number of splits.",null,null],[11,"fmt","core::slice","",138,{"inputs":[{"name":"iter"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next_back","","",138,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"next","","",138,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"size_hint","","",138,null],[11,"count","","",138,{"inputs":[{"name":"iter"}],"output":{"name":"usize"}}],[11,"nth","","",138,{"inputs":[{"name":"iter"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",138,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"as_slice","","View the underlying data as a subslice of the original data.",138,null],[11,"clone","","",138,{"inputs":[{"name":"iter"}],"output":{"name":"iter"}}],[3,"Iter","std::slice","Immutable slice iterator",null,null],[11,"fmt","core::slice","",139,{"inputs":[{"name":"rsplitnmut"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",139,{"inputs":[{"name":"rsplitnmut"}],"output":{"name":"option"}}],[11,"size_hint","","",139,null],[3,"RSplitNMut","std::slice","An iterator over subslices separated by elements that match a\npredicate function, limited to a given number of splits, starting\nfrom the end of the slice.",null,null],[11,"fmt","core::slice","",140,{"inputs":[{"name":"chunks"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next_back","","",140,{"inputs":[{"name":"chunks"}],"output":{"name":"option"}}],[11,"next","","",140,{"inputs":[{"name":"chunks"}],"output":{"name":"option"}}],[11,"size_hint","","",140,null],[11,"count","","",140,{"inputs":[{"name":"chunks"}],"output":{"name":"usize"}}],[11,"nth","","",140,{"inputs":[{"name":"chunks"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",140,{"inputs":[{"name":"chunks"}],"output":{"name":"option"}}],[11,"clone","","",140,{"inputs":[{"name":"chunks"}],"output":{"name":"chunks"}}],[3,"Chunks","std::slice","An iterator over a slice in (non-overlapping) chunks (`size` elements at a\ntime).",null,null],[11,"fmt","core::slice","",141,{"inputs":[{"name":"itermut"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next_back","","",141,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"next","","",141,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"size_hint","","",141,null],[11,"count","","",141,{"inputs":[{"name":"itermut"}],"output":{"name":"usize"}}],[11,"nth","","",141,{"inputs":[{"name":"itermut"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",141,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"into_slice","","View the underlying data as a subslice of the original data.",141,null],[3,"IterMut","std::slice","Mutable slice iterator.",null,null],[11,"fmt","core::slice","",142,{"inputs":[{"name":"rsplitn"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",142,{"inputs":[{"name":"rsplitn"}],"output":{"name":"option"}}],[11,"size_hint","","",142,null],[3,"RSplitN","std::slice","An iterator over subslices separated by elements that match a\npredicate function, limited to a given number of splits, starting\nfrom the end of the slice.",null,null],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",null,null],[11,"fmt","core::slice","",143,{"inputs":[{"name":"splitnmut"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",143,{"inputs":[{"name":"splitnmut"}],"output":{"name":"option"}}],[11,"size_hint","","",143,null],[3,"SplitNMut","std::slice","An iterator over subslices separated by elements that match a predicate\nfunction, limited to a given number of splits.",null,null],[11,"next","core::slice","",144,{"inputs":[{"name":"windows"}],"output":{"name":"option"}}],[11,"size_hint","","",144,null],[11,"count","","",144,{"inputs":[{"name":"windows"}],"output":{"name":"usize"}}],[11,"nth","","",144,{"inputs":[{"name":"windows"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",144,{"inputs":[{"name":"windows"}],"output":{"name":"option"}}],[11,"clone","","",144,{"inputs":[{"name":"windows"}],"output":{"name":"windows"}}],[11,"fmt","","",144,{"inputs":[{"name":"windows"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next_back","","",144,{"inputs":[{"name":"windows"}],"output":{"name":"option"}}],[3,"Windows","std::slice","An iterator over overlapping subslices of length `size`.",null,null],[5,"from_raw_parts_mut","","Performs the same functionality as `from_raw_parts`, except that a mutable\nslice is returned.",null,null],[11,"next","core::slice","",145,{"inputs":[{"name":"splitmut"}],"output":{"name":"option"}}],[11,"size_hint","","",145,null],[11,"fmt","","",145,{"inputs":[{"name":"splitmut"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next_back","","",145,{"inputs":[{"name":"splitmut"}],"output":{"name":"option"}}],[3,"SplitMut","std::slice","An iterator over the subslices of the vector which are separated\nby elements that match `pred`.",null,null],[11,"next_back","core::slice","",146,{"inputs":[{"name":"chunksmut"}],"output":{"name":"option"}}],[11,"next","","",146,{"inputs":[{"name":"chunksmut"}],"output":{"name":"option"}}],[11,"size_hint","","",146,null],[11,"count","","",146,{"inputs":[{"name":"chunksmut"}],"output":{"name":"usize"}}],[11,"nth","","",146,{"inputs":[{"name":"chunksmut"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",146,{"inputs":[{"name":"chunksmut"}],"output":{"name":"option"}}],[11,"fmt","","",146,{"inputs":[{"name":"chunksmut"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"ChunksMut","std::slice","An iterator over a slice in (non-overlapping) mutable chunks (`size`\nelements at a time). When the slice len is not evenly divided by the chunk\nsize, the last slice of the iteration will be the remainder.",null,null],[0,"str","std","Unicode string slices.",null,null],[6,"Utf16Units","std::str","",null,null],[11,"next","collections::str","",147,{"inputs":[{"name":"encodeutf16"}],"output":{"name":"option"}}],[11,"size_hint","","",147,null],[11,"clone","","",147,{"inputs":[{"name":"encodeutf16"}],"output":{"name":"encodeutf16"}}],[3,"EncodeUtf16","std::str","External iterator for a string&#39;s UTF-16 code units.",null,null],[11,"clone","core::str","",148,{"inputs":[{"name":"charrange"}],"output":{"name":"charrange"}}],[11,"fmt","","",148,{"inputs":[{"name":"charrange"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"CharRange","std::str","Struct that contains a `char` and the index of the first byte of\nthe next `char` in a string.  This can be used as a data structure\nfor iterating over the UTF-8 bytes of a string.",null,null],[12,"ch","","Current `char`",148,null],[12,"next","","Index of the first byte of the next `char`",148,null],[11,"next_back","core::str","",149,{"inputs":[{"name":"matchindices"}],"output":{"name":"option"}}],[11,"clone","","",149,{"inputs":[{"name":"matchindices"}],"output":{"name":"matchindices"}}],[11,"next","","",149,{"inputs":[{"name":"matchindices"}],"output":{"name":"option"}}],[11,"fmt","","",149,{"inputs":[{"name":"matchindices"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"MatchIndices","std::str","Created with the method [`match_indices()`].",null,null],[11,"next_back","core::str","",150,{"inputs":[{"name":"rsplitterminator"}],"output":{"name":"option"}}],[11,"clone","","",150,{"inputs":[{"name":"rsplitterminator"}],"output":{"name":"rsplitterminator"}}],[11,"next","","",150,{"inputs":[{"name":"rsplitterminator"}],"output":{"name":"option"}}],[11,"fmt","","",150,{"inputs":[{"name":"rsplitterminator"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"RSplitTerminator","std::str","Created with the method [`rsplit_terminator()`].",null,null],[11,"next_back","rustc_unicode::u_str","",151,{"inputs":[{"name":"splitwhitespace"}],"output":{"name":"option"}}],[11,"next","","",151,{"inputs":[{"name":"splitwhitespace"}],"output":{"name":"option"}}],[3,"SplitWhitespace","std::str","An iterator over the non-whitespace substrings of a string,\nseparated by any amount of whitespace.",null,null],[11,"as_str","core::str","View the underlying data as a subslice of the original data.",152,{"inputs":[{"name":"charindices"}],"output":{"name":"str"}}],[11,"next_back","","",152,{"inputs":[{"name":"charindices"}],"output":{"name":"option"}}],[11,"next","","",152,{"inputs":[{"name":"charindices"}],"output":{"name":"option"}}],[11,"size_hint","","",152,null],[11,"clone","","",152,{"inputs":[{"name":"charindices"}],"output":{"name":"charindices"}}],[11,"fmt","","",152,{"inputs":[{"name":"charindices"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"CharIndices","std::str","Iterator for a string&#39;s characters and their byte offsets.",null,null],[11,"next_back","core::str","",153,{"inputs":[{"name":"split"}],"output":{"name":"option"}}],[11,"clone","","",153,{"inputs":[{"name":"split"}],"output":{"name":"split"}}],[11,"next","","",153,{"inputs":[{"name":"split"}],"output":{"name":"option"}}],[11,"fmt","","",153,{"inputs":[{"name":"split"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Split","std::str","Created with the method [`split()`].",null,null],[8,"FromStr","","A trait to abstract the idea of creating a new instance of a type from a\nstring.",null,null],[16,"Err","","The associated error which can be returned from parsing.",154,null],[10,"from_str","","Parses a string `s` to return a value of this type.",154,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"next_back","core::str","",155,{"inputs":[{"name":"linesany"}],"output":{"name":"option"}}],[11,"next","","",155,{"inputs":[{"name":"linesany"}],"output":{"name":"option"}}],[11,"size_hint","","",155,null],[11,"clone","","",155,{"inputs":[{"name":"linesany"}],"output":{"name":"linesany"}}],[11,"fmt","","",155,{"inputs":[{"name":"linesany"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"LinesAny","std::str","Created with the method [`lines_any()`].",null,null],[5,"from_utf8","","Converts a slice of bytes to a string slice.",null,null],[11,"next_back","core::str","",156,{"inputs":[{"name":"lines"}],"output":{"name":"option"}}],[11,"next","","",156,{"inputs":[{"name":"lines"}],"output":{"name":"option"}}],[11,"size_hint","","",156,null],[11,"clone","","",156,{"inputs":[{"name":"lines"}],"output":{"name":"lines"}}],[11,"fmt","","",156,{"inputs":[{"name":"lines"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Lines","std::str","Created with the method [`lines()`].",null,null],[11,"as_str","core::str","View the underlying data as a subslice of the original data.",157,{"inputs":[{"name":"chars"}],"output":{"name":"str"}}],[11,"next_back","","",157,{"inputs":[{"name":"chars"}],"output":{"name":"option"}}],[11,"next","","",157,{"inputs":[{"name":"chars"}],"output":{"name":"option"}}],[11,"size_hint","","",157,null],[11,"clone","","",157,{"inputs":[{"name":"chars"}],"output":{"name":"chars"}}],[11,"fmt","","",157,{"inputs":[{"name":"chars"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Chars","std::str","Iterator for the char (representing *Unicode Scalar Values*) of a string",null,null],[11,"next_back","core::str","",158,{"inputs":[{"name":"rmatches"}],"output":{"name":"option"}}],[11,"clone","","",158,{"inputs":[{"name":"rmatches"}],"output":{"name":"rmatches"}}],[11,"next","","",158,{"inputs":[{"name":"rmatches"}],"output":{"name":"option"}}],[11,"fmt","","",158,{"inputs":[{"name":"rmatches"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"RMatches","std::str","Created with the method [`rmatches()`].",null,null],[11,"clone","core::str","",159,{"inputs":[{"name":"rsplitn"}],"output":{"name":"rsplitn"}}],[11,"next","","",159,{"inputs":[{"name":"rsplitn"}],"output":{"name":"option"}}],[11,"fmt","","",159,{"inputs":[{"name":"rsplitn"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"RSplitN","std::str","Created with the method [`rsplitn()`].",null,null],[0,"pattern","","The string Pattern API.",null,null],[8,"Pattern","std::str::pattern","A string pattern.",null,null],[16,"Searcher","","Associated searcher for this pattern",160,null],[10,"into_searcher","","Constructs the associated searcher from\n`self` and the `haystack` to search in.",160,null],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",160,{"inputs":[{"name":"pattern"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",160,{"inputs":[{"name":"pattern"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",160,{"inputs":[{"name":"pattern"},{"name":"str"}],"output":{"name":"bool"}}],[11,"clone","core::str::pattern","",161,{"inputs":[{"name":"searchstep"}],"output":{"name":"searchstep"}}],[11,"eq","","",161,{"inputs":[{"name":"searchstep"},{"name":"searchstep"}],"output":{"name":"bool"}}],[11,"ne","","",161,{"inputs":[{"name":"searchstep"},{"name":"searchstep"}],"output":{"name":"bool"}}],[11,"fmt","","",161,{"inputs":[{"name":"searchstep"},{"name":"formatter"}],"output":{"name":"result"}}],[4,"SearchStep","std::str::pattern","Result of calling `Searcher::next()` or `ReverseSearcher::next_back()`.",null,null],[13,"Match","","Expresses that a match of the pattern has been found at\n`haystack[a..b]`.",161,null],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a possible match\nof the pattern.",161,null],[13,"Done","","Expresses that every byte of the haystack has been visted, ending\nthe iteration.",161,null],[8,"Searcher","","A searcher for a string pattern.",null,null],[10,"haystack","","Getter for the underlaying string to be searched in",162,{"inputs":[{"name":"searcher"}],"output":{"name":"str"}}],[10,"next","","Performs the next search step starting from the front.",162,{"inputs":[{"name":"searcher"}],"output":{"name":"searchstep"}}],[11,"next_match","","Find the next `Match` result. See `next()`",162,{"inputs":[{"name":"searcher"}],"output":{"name":"option"}}],[11,"next_reject","","Find the next `Reject` result. See `next()`",162,{"inputs":[{"name":"searcher"}],"output":{"name":"option"}}],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",null,null],[10,"next_back","","Performs the next search step starting from the back.",163,{"inputs":[{"name":"reversesearcher"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","Find the next `Match` result. See `next_back()`",163,{"inputs":[{"name":"reversesearcher"}],"output":{"name":"option"}}],[11,"next_reject_back","","Find the next `Reject` result. See `next_back()`",163,{"inputs":[{"name":"reversesearcher"}],"output":{"name":"option"}}],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher`\ncan be used for a `DoubleEndedIterator` implementation.",null,null],[11,"clone","core::str::pattern","",164,{"inputs":[{"name":"charsearcher"}],"output":{"name":"charsearcher"}}],[11,"fmt","","",164,{"inputs":[{"name":"charsearcher"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"haystack","","",164,{"inputs":[{"name":"charsearcher"}],"output":{"name":"str"}}],[11,"next","","",164,{"inputs":[{"name":"charsearcher"}],"output":{"name":"searchstep"}}],[11,"next_match","","",164,{"inputs":[{"name":"charsearcher"}],"output":{"name":"option"}}],[11,"next_reject","","",164,{"inputs":[{"name":"charsearcher"}],"output":{"name":"option"}}],[11,"next_back","","",164,{"inputs":[{"name":"charsearcher"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",164,{"inputs":[{"name":"charsearcher"}],"output":{"name":"option"}}],[11,"next_reject_back","","",164,{"inputs":[{"name":"charsearcher"}],"output":{"name":"option"}}],[3,"CharSearcher","std::str::pattern","Associated type for `&lt;char as Pattern&lt;&#39;a&gt;&gt;::Searcher`.",null,null],[11,"clone","core::str::pattern","",165,{"inputs":[{"name":"charslicesearcher"}],"output":{"name":"charslicesearcher"}}],[11,"next_back","","",165,{"inputs":[{"name":"charslicesearcher"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",165,{"inputs":[{"name":"charslicesearcher"}],"output":{"name":"option"}}],[11,"next_reject_back","","",165,{"inputs":[{"name":"charslicesearcher"}],"output":{"name":"option"}}],[11,"haystack","","",165,{"inputs":[{"name":"charslicesearcher"}],"output":{"name":"str"}}],[11,"next","","",165,{"inputs":[{"name":"charslicesearcher"}],"output":{"name":"searchstep"}}],[11,"next_match","","",165,{"inputs":[{"name":"charslicesearcher"}],"output":{"name":"option"}}],[11,"next_reject","","",165,{"inputs":[{"name":"charslicesearcher"}],"output":{"name":"option"}}],[11,"fmt","","",165,{"inputs":[{"name":"charslicesearcher"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"CharSliceSearcher","std::str::pattern","Associated type for `&lt;&amp;[char] as Pattern&lt;&#39;a&gt;&gt;::Searcher`.",null,null],[11,"next_back","core::str::pattern","",166,{"inputs":[{"name":"charpredicatesearcher"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",166,{"inputs":[{"name":"charpredicatesearcher"}],"output":{"name":"option"}}],[11,"next_reject_back","","",166,{"inputs":[{"name":"charpredicatesearcher"}],"output":{"name":"option"}}],[11,"haystack","","",166,{"inputs":[{"name":"charpredicatesearcher"}],"output":{"name":"str"}}],[11,"next","","",166,{"inputs":[{"name":"charpredicatesearcher"}],"output":{"name":"searchstep"}}],[11,"next_match","","",166,{"inputs":[{"name":"charpredicatesearcher"}],"output":{"name":"option"}}],[11,"next_reject","","",166,{"inputs":[{"name":"charpredicatesearcher"}],"output":{"name":"option"}}],[11,"fmt","","",166,{"inputs":[{"name":"charpredicatesearcher"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",166,{"inputs":[{"name":"charpredicatesearcher"}],"output":{"name":"charpredicatesearcher"}}],[3,"CharPredicateSearcher","std::str::pattern","Associated type for `&lt;F as Pattern&lt;&#39;a&gt;&gt;::Searcher`.",null,null],[11,"clone","core::str::pattern","",167,{"inputs":[{"name":"strsearcher"}],"output":{"name":"strsearcher"}}],[11,"fmt","","",167,{"inputs":[{"name":"strsearcher"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next_back","","",167,{"inputs":[{"name":"strsearcher"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",167,{"inputs":[{"name":"strsearcher"}],"output":{"name":"option"}}],[11,"haystack","","",167,{"inputs":[{"name":"strsearcher"}],"output":{"name":"str"}}],[11,"next","","",167,{"inputs":[{"name":"strsearcher"}],"output":{"name":"searchstep"}}],[11,"next_match","","",167,{"inputs":[{"name":"strsearcher"}],"output":{"name":"option"}}],[3,"StrSearcher","std::str::pattern","Associated type for `&lt;&amp;str as Pattern&lt;&#39;a&gt;&gt;::Searcher`.",null,null],[11,"clone","core::str","",168,{"inputs":[{"name":"splitn"}],"output":{"name":"splitn"}}],[11,"next","","",168,{"inputs":[{"name":"splitn"}],"output":{"name":"option"}}],[11,"fmt","","",168,{"inputs":[{"name":"splitn"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"SplitN","std::str","Created with the method [`splitn()`].",null,null],[11,"len","core::str","",169,{"inputs":[{"name":"bytes"}],"output":{"name":"usize"}}],[11,"next_back","","",169,{"inputs":[{"name":"bytes"}],"output":{"name":"option"}}],[11,"next","","",169,{"inputs":[{"name":"bytes"}],"output":{"name":"option"}}],[11,"size_hint","","",169,null],[11,"count","","",169,{"inputs":[{"name":"bytes"}],"output":{"name":"usize"}}],[11,"last","","",169,{"inputs":[{"name":"bytes"}],"output":{"name":"option"}}],[11,"nth","","",169,{"inputs":[{"name":"bytes"},{"name":"usize"}],"output":{"name":"option"}}],[11,"clone","","",169,{"inputs":[{"name":"bytes"}],"output":{"name":"bytes"}}],[11,"fmt","","",169,{"inputs":[{"name":"bytes"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Bytes","std::str","External iterator for a string&#39;s bytes.\nUse with the `std::iter` module.",null,null],[11,"next_back","core::str","",170,{"inputs":[{"name":"matches"}],"output":{"name":"option"}}],[11,"clone","","",170,{"inputs":[{"name":"matches"}],"output":{"name":"matches"}}],[11,"next","","",170,{"inputs":[{"name":"matches"}],"output":{"name":"option"}}],[11,"fmt","","",170,{"inputs":[{"name":"matches"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Matches","std::str","Created with the method [`matches()`].",null,null],[11,"next_back","core::str","",171,{"inputs":[{"name":"rsplit"}],"output":{"name":"option"}}],[11,"clone","","",171,{"inputs":[{"name":"rsplit"}],"output":{"name":"rsplit"}}],[11,"next","","",171,{"inputs":[{"name":"rsplit"}],"output":{"name":"option"}}],[11,"fmt","","",171,{"inputs":[{"name":"rsplit"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"RSplit","std::str","Created with the method [`rsplit()`].",null,null],[11,"fmt","core::str","",172,{"inputs":[{"name":"parseboolerror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",172,{"inputs":[{"name":"parseboolerror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",172,{"inputs":[{"name":"parseboolerror"}],"output":{"name":"parseboolerror"}}],[11,"eq","","",172,{"inputs":[{"name":"parseboolerror"},{"name":"parseboolerror"}],"output":{"name":"bool"}}],[11,"ne","","",172,{"inputs":[{"name":"parseboolerror"},{"name":"parseboolerror"}],"output":{"name":"bool"}}],[3,"ParseBoolError","std::str","An error returned when parsing a `bool` from a string fails.",null,null],[11,"next_back","core::str","",173,{"inputs":[{"name":"splitterminator"}],"output":{"name":"option"}}],[11,"clone","","",173,{"inputs":[{"name":"splitterminator"}],"output":{"name":"splitterminator"}}],[11,"next","","",173,{"inputs":[{"name":"splitterminator"}],"output":{"name":"option"}}],[11,"fmt","","",173,{"inputs":[{"name":"splitterminator"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"SplitTerminator","std::str","Created with the method [`split_terminator()`].",null,null],[11,"next_back","core::str","",174,{"inputs":[{"name":"rmatchindices"}],"output":{"name":"option"}}],[11,"clone","","",174,{"inputs":[{"name":"rmatchindices"}],"output":{"name":"rmatchindices"}}],[11,"next","","",174,{"inputs":[{"name":"rmatchindices"}],"output":{"name":"option"}}],[11,"fmt","","",174,{"inputs":[{"name":"rmatchindices"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"RMatchIndices","std::str","Created with the method [`rmatch_indices()`].",null,null],[11,"fmt","core::str","",175,{"inputs":[{"name":"utf8error"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"valid_up_to","","Returns the index in the given string up to which valid UTF-8 was\nverified.",175,{"inputs":[{"name":"utf8error"}],"output":{"name":"usize"}}],[11,"eq","","",175,{"inputs":[{"name":"utf8error"},{"name":"utf8error"}],"output":{"name":"bool"}}],[11,"ne","","",175,{"inputs":[{"name":"utf8error"},{"name":"utf8error"}],"output":{"name":"bool"}}],[11,"clone","","",175,{"inputs":[{"name":"utf8error"}],"output":{"name":"utf8error"}}],[11,"fmt","","",175,{"inputs":[{"name":"utf8error"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Utf8Error","std::str","Errors which can occur when attempting to interpret a sequence of `u8`\nas a string.",null,null],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without checking\nthat the string contains valid UTF-8.",null,null],[0,"string","std","A UTF-8 encoded, growable string.",null,null],[11,"write_str","collections::string","",176,{"inputs":[{"name":"string"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","",176,{"inputs":[{"name":"string"},{"name":"char"}],"output":{"name":"result"}}],[11,"into","","",176,{"inputs":[{"name":"string"}],"output":{"name":"vec"}}],[11,"from","","",176,{"inputs":[{"name":"str"}],"output":{"name":"string"}}],[11,"as_ref","","",176,null],[11,"as_ref","","",176,{"inputs":[{"name":"string"}],"output":{"name":"str"}}],[11,"from_str","","",176,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"deref_mut","","",176,{"inputs":[{"name":"string"}],"output":{"name":"str"}}],[11,"deref","","",176,{"inputs":[{"name":"string"}],"output":{"name":"str"}}],[11,"index_mut","","",176,{"inputs":[{"name":"string"},{"name":"rangetoinclusive"}],"output":{"name":"str"}}],[11,"index_mut","","",176,{"inputs":[{"name":"string"},{"name":"rangeinclusive"}],"output":{"name":"str"}}],[11,"index_mut","","",176,{"inputs":[{"name":"string"},{"name":"rangefull"}],"output":{"name":"str"}}],[11,"index_mut","","",176,{"inputs":[{"name":"string"},{"name":"rangefrom"}],"output":{"name":"str"}}],[11,"index_mut","","",176,{"inputs":[{"name":"string"},{"name":"rangeto"}],"output":{"name":"str"}}],[11,"index_mut","","",176,{"inputs":[{"name":"string"},{"name":"range"}],"output":{"name":"str"}}],[11,"index","","",176,{"inputs":[{"name":"string"},{"name":"rangetoinclusive"}],"output":{"name":"str"}}],[11,"index","","",176,{"inputs":[{"name":"string"},{"name":"rangeinclusive"}],"output":{"name":"str"}}],[11,"index","","",176,{"inputs":[{"name":"string"},{"name":"rangefull"}],"output":{"name":"str"}}],[11,"index","","",176,{"inputs":[{"name":"string"},{"name":"rangefrom"}],"output":{"name":"str"}}],[11,"index","","",176,{"inputs":[{"name":"string"},{"name":"rangeto"}],"output":{"name":"str"}}],[11,"index","","",176,{"inputs":[{"name":"string"},{"name":"range"}],"output":{"name":"str"}}],[11,"add","","",176,{"inputs":[{"name":"string"},{"name":"str"}],"output":{"name":"string"}}],[11,"hash","","",176,null],[11,"fmt","","",176,{"inputs":[{"name":"string"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",176,{"inputs":[{"name":"string"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","",176,{"inputs":[],"output":{"name":"string"}}],[11,"eq","","",176,{"inputs":[{"name":"string"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"ne","","",176,{"inputs":[{"name":"string"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"eq","","",176,{"inputs":[{"name":"string"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",176,{"inputs":[{"name":"string"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","","",176,{"inputs":[{"name":"string"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",176,{"inputs":[{"name":"string"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","","",176,{"inputs":[{"name":"string"},{"name":"string"}],"output":{"name":"bool"}}],[11,"ne","","",176,{"inputs":[{"name":"string"},{"name":"string"}],"output":{"name":"bool"}}],[11,"extend","","",176,null],[11,"extend","","",176,null],[11,"extend","","",176,null],[11,"extend","","",176,null],[11,"from_iter","","",176,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","","",176,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","","",176,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"clone","","",176,{"inputs":[{"name":"string"}],"output":{"name":"string"}}],[11,"clone_from","","",176,null],[11,"new","","Creates a new empty `String`.",176,{"inputs":[],"output":{"name":"string"}}],[11,"with_capacity","","Creates a new empty `String` with a particular capacity.",176,{"inputs":[{"name":"usize"}],"output":{"name":"string"}}],[11,"from_utf8","","Converts a vector of bytes to a `String`.",176,{"inputs":[{"name":"vec"}],"output":{"name":"result"}}],[11,"from_utf8_lossy","","Converts a slice of bytes to a string, including invalid characters.",176,null],[11,"from_utf16","","Decode a UTF-16 encoded vector `v` into a `String`, returning `Err`\nif `v` contains any invalid data.",176,null],[11,"from_utf16_lossy","","Decode a UTF-16 encoded vector `v` into a string, replacing\ninvalid data with the replacement character (U+FFFD).",176,null],[11,"from_raw_parts","","Creates a new `String` from a length, capacity, and pointer.",176,null],[11,"from_utf8_unchecked","","Converts a vector of bytes to a `String` without checking that the\nstring contains valid UTF-8.",176,{"inputs":[{"name":"vec"}],"output":{"name":"string"}}],[11,"into_bytes","","Converts a `String` into a byte vector.",176,{"inputs":[{"name":"string"}],"output":{"name":"vec"}}],[11,"as_str","","Extracts a string slice containing the entire string.",176,{"inputs":[{"name":"string"}],"output":{"name":"str"}}],[11,"as_mut_str","","Extracts a string slice containing the entire string.",176,{"inputs":[{"name":"string"}],"output":{"name":"str"}}],[11,"push_str","","Appends a given string slice onto the end of this `String`.",176,null],[11,"capacity","","Returns this `String`&#39;s capacity, in bytes.",176,{"inputs":[{"name":"string"}],"output":{"name":"usize"}}],[11,"reserve","","Ensures that this `String`&#39;s capacity is at least `additional` bytes\nlarger than its length.",176,null],[11,"reserve_exact","","Ensures that this `String`&#39;s capacity is `additional` bytes\nlarger than its length.",176,null],[11,"shrink_to_fit","","Shrinks the capacity of this `String` to match its length.",176,null],[11,"push","","Appends the given `char` to the end of this `String`.",176,null],[11,"as_bytes","","Returns a byte slice of this `String`&#39;s contents.",176,null],[11,"truncate","","Shortens this `String` to the specified length.",176,null],[11,"pop","","Removes the last character from the string buffer and returns it.",176,{"inputs":[{"name":"string"}],"output":{"name":"option"}}],[11,"remove","","Removes a `char` from this `String` at a byte position and returns it.",176,{"inputs":[{"name":"string"},{"name":"usize"}],"output":{"name":"char"}}],[11,"insert","","Inserts a character into this `String` at a byte position.",176,null],[11,"as_mut_vec","","Returns a mutable reference to the contents of this `String`.",176,{"inputs":[{"name":"string"}],"output":{"name":"vec"}}],[11,"len","","Returns the length of this `String`, in bytes.",176,{"inputs":[{"name":"string"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns `true` if this `String` has a length of zero.",176,{"inputs":[{"name":"string"}],"output":{"name":"bool"}}],[11,"clear","","Truncates this `String`, removing all contents.",176,null],[11,"drain","","Create a draining iterator that removes the specified range in the string\nand yields the removed chars.",176,{"inputs":[{"name":"string"},{"name":"r"}],"output":{"name":"drain"}}],[11,"into_boxed_str","","Converts this `String` into a `Box&lt;str&gt;`.",176,{"inputs":[{"name":"string"}],"output":{"name":"box"}}],[11,"partial_cmp","","",176,{"inputs":[{"name":"string"},{"name":"string"}],"output":{"name":"option"}}],[11,"lt","","",176,{"inputs":[{"name":"string"},{"name":"string"}],"output":{"name":"bool"}}],[11,"le","","",176,{"inputs":[{"name":"string"},{"name":"string"}],"output":{"name":"bool"}}],[11,"gt","","",176,{"inputs":[{"name":"string"},{"name":"string"}],"output":{"name":"bool"}}],[11,"ge","","",176,{"inputs":[{"name":"string"},{"name":"string"}],"output":{"name":"bool"}}],[11,"cmp","","",176,{"inputs":[{"name":"string"},{"name":"string"}],"output":{"name":"ordering"}}],[11,"borrow","","",176,{"inputs":[{"name":"string"}],"output":{"name":"str"}}],[3,"String","std::string","A UTF-8 encoded, growable string.",null,null],[11,"fmt","collections::string","",177,{"inputs":[{"name":"fromutf8error"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"into_bytes","","Returns the bytes that were attempted to convert to a `String`.",177,{"inputs":[{"name":"fromutf8error"}],"output":{"name":"vec"}}],[11,"utf8_error","","Fetch a `Utf8Error` to get more details about the conversion failure.",177,{"inputs":[{"name":"fromutf8error"}],"output":{"name":"utf8error"}}],[11,"fmt","","",177,{"inputs":[{"name":"fromutf8error"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"FromUtf8Error","std::string","A possible error value when converting a `String` from a UTF-8 byte vector.",null,null],[11,"fmt","collections::string","",178,{"inputs":[{"name":"fromutf16error"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",178,{"inputs":[{"name":"fromutf16error"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"FromUtf16Error","std::string","A possible error value when converting a `String` from a UTF-16 byte slice.",null,null],[11,"eq","collections::string","",179,{"inputs":[{"name":"parseerror"},{"name":"parseerror"}],"output":{"name":"bool"}}],[11,"fmt","","",179,{"inputs":[{"name":"parseerror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",179,{"inputs":[{"name":"parseerror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",179,{"inputs":[{"name":"parseerror"}],"output":{"name":"parseerror"}}],[4,"ParseError","std::string","An error when parsing a `String`.",null,null],[8,"ToString","","A trait for converting a value to a `String`.",null,null],[10,"to_string","","Converts the given value to a `String`.",180,{"inputs":[{"name":"tostring"}],"output":{"name":"string"}}],[11,"next_back","collections::string","",181,{"inputs":[{"name":"drain"}],"output":{"name":"option"}}],[11,"next","","",181,{"inputs":[{"name":"drain"}],"output":{"name":"option"}}],[11,"size_hint","","",181,null],[11,"drop","","",181,null],[3,"Drain","std::string","A draining iterator for `String`.",null,null],[0,"vec","std","A contiguous growable array type with heap-allocated contents, written\n`Vec&lt;T&gt;` but pronounced &#39;vector.&#39;",null,null],[11,"eq","collections::vec","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,{"inputs":[{"name":"vec"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"ne","","",182,{"inputs":[{"name":"vec"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"extend","","",182,null],[11,"extend","","",182,null],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each value out of\nthe vector (from start to end). The vector cannot be used after calling\nthis.",182,{"inputs":[{"name":"vec"}],"output":{"name":"intoiter"}}],[11,"from_iter","","",182,{"inputs":[{"name":"i"}],"output":{"name":"vec"}}],[11,"deref_mut","","",182,null],[11,"deref","","",182,null],[11,"index_mut","","",182,null],[11,"index_mut","","",182,null],[11,"index_mut","","",182,null],[11,"index_mut","","",182,null],[11,"index_mut","","",182,null],[11,"index_mut","","",182,null],[11,"index","","",182,null],[11,"index","","",182,null],[11,"index","","",182,null],[11,"index","","",182,null],[11,"index","","",182,null],[11,"index","","",182,null],[11,"index_mut","","",182,{"inputs":[{"name":"vec"},{"name":"usize"}],"output":{"name":"t"}}],[11,"index","","",182,{"inputs":[{"name":"vec"},{"name":"usize"}],"output":{"name":"t"}}],[11,"hash","","",182,null],[11,"clone","","",182,{"inputs":[{"name":"vec"}],"output":{"name":"vec"}}],[11,"clone_from","","",182,null],[11,"dedup","","Removes consecutive repeated elements in the vector.",182,null],[11,"resize","","Resizes the `Vec` in-place so that `len()` is equal to `new_len`.",182,null],[11,"extend_from_slice","","Appends all elements in a slice to the `Vec`.",182,null],[11,"new","","Constructs a new, empty `Vec&lt;T&gt;`.",182,{"inputs":[],"output":{"name":"vec"}}],[11,"with_capacity","","Constructs a new, empty `Vec&lt;T&gt;` with the specified capacity.",182,{"inputs":[{"name":"usize"}],"output":{"name":"vec"}}],[11,"from_raw_parts","","Creates a `Vec&lt;T&gt;` directly from the raw components of another vector.",182,null],[11,"capacity","","Returns the number of elements the vector can hold without\nreallocating.",182,{"inputs":[{"name":"vec"}],"output":{"name":"usize"}}],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted\nin the given `Vec&lt;T&gt;`. The collection may reserve more space to avoid\nfrequent reallocations.",182,null],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to\nbe inserted in the given `Vec&lt;T&gt;`. Does nothing if the capacity is already\nsufficient.",182,null],[11,"shrink_to_fit","","Shrinks the capacity of the vector as much as possible.",182,null],[11,"into_boxed_slice","","Converts the vector into Box&lt;[T]&gt;.",182,{"inputs":[{"name":"vec"}],"output":{"name":"box"}}],[11,"truncate","","Shorten a vector to be `len` elements long, dropping excess elements.",182,null],[11,"as_slice","","Extracts a slice containing the entire vector.",182,null],[11,"as_mut_slice","","Extracts a mutable slice of the entire vector.",182,null],[11,"set_len","","Sets the length of a vector.",182,null],[11,"swap_remove","","Removes an element from anywhere in the vector and return it, replacing\nit with the last element.",182,{"inputs":[{"name":"vec"},{"name":"usize"}],"output":{"name":"t"}}],[11,"insert","","Inserts an element at position `index` within the vector, shifting all\nelements after it to the right.",182,null],[11,"remove","","Removes and returns the element at position `index` within the vector,\nshifting all elements after it to the left.",182,{"inputs":[{"name":"vec"},{"name":"usize"}],"output":{"name":"t"}}],[11,"retain","","Retains only the elements specified by the predicate.",182,null],[11,"push","","Appends an element to the back of a collection.",182,null],[11,"pop","","Removes the last element from a vector and returns it, or `None` if it\nis empty.",182,{"inputs":[{"name":"vec"}],"output":{"name":"option"}}],[11,"append","","Moves all the elements of `other` into `Self`, leaving `other` empty.",182,null],[11,"drain","","Create a draining iterator that removes the specified range in the vector\nand yields the removed items.",182,{"inputs":[{"name":"vec"},{"name":"r"}],"output":{"name":"drain"}}],[11,"clear","","Clears the vector, removing all values.",182,null],[11,"len","","Returns the number of elements in the vector.",182,{"inputs":[{"name":"vec"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns `true` if the vector contains no elements.",182,{"inputs":[{"name":"vec"}],"output":{"name":"bool"}}],[11,"split_off","","Splits the collection into two at the given index.",182,{"inputs":[{"name":"vec"},{"name":"usize"}],"output":{"name":"vec"}}],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"from","","",182,{"inputs":[{"name":"str"}],"output":{"name":"vec"}}],[11,"from","","",182,null],[11,"as_mut","","",182,null],[11,"as_ref","","",182,null],[11,"as_mut","","",182,{"inputs":[{"name":"vec"}],"output":{"name":"vec"}}],[11,"as_ref","","",182,{"inputs":[{"name":"vec"}],"output":{"name":"vec"}}],[11,"fmt","","",182,{"inputs":[{"name":"vec"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","",182,{"inputs":[],"output":{"name":"vec"}}],[11,"drop","","",182,null],[11,"cmp","","",182,{"inputs":[{"name":"vec"},{"name":"vec"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",182,{"inputs":[{"name":"vec"},{"name":"vec"}],"output":{"name":"option"}}],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"eq","","",182,null],[11,"ne","","",182,null],[11,"borrow_mut","","",182,null],[11,"borrow","","",182,null],[11,"from","","",182,{"inputs":[{"name":"binaryheap"}],"output":{"name":"vec"}}],[3,"Vec","std::vec","A contiguous growable array type, written `Vec&lt;T&gt;` but pronounced &#39;vector.&#39;",null,null],[11,"next_back","collections::vec","",183,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"next","","",183,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"size_hint","","",183,null],[11,"count","","",183,{"inputs":[{"name":"intoiter"}],"output":{"name":"usize"}}],[11,"drop","","",183,null],[11,"clone","","",183,{"inputs":[{"name":"intoiter"}],"output":{"name":"intoiter"}}],[3,"IntoIter","std::vec","An iterator that moves out of a vector.",null,null],[11,"drop","collections::vec","",184,null],[11,"next_back","","",184,{"inputs":[{"name":"drain"}],"output":{"name":"option"}}],[11,"next","","",184,{"inputs":[{"name":"drain"}],"output":{"name":"option"}}],[11,"size_hint","","",184,null],[3,"Drain","std::vec","A draining iterator for `Vec&lt;T&gt;`.",null,null],[0,"char","std","A character type.",null,null],[11,"next","rustc_unicode::char","",185,{"inputs":[{"name":"tolowercase"}],"output":{"name":"option"}}],[3,"ToLowercase","std::char","Returns an iterator that yields the lowercase equivalent of a `char`.",null,null],[11,"next","rustc_unicode::char","",186,{"inputs":[{"name":"touppercase"}],"output":{"name":"option"}}],[3,"ToUppercase","std::char","Returns an iterator that yields the uppercase equivalent of a `char`.",null,null],[11,"clone","rustc_unicode::char","",187,{"inputs":[{"name":"decodeutf16"}],"output":{"name":"decodeutf16"}}],[11,"next","","",187,{"inputs":[{"name":"decodeutf16"}],"output":{"name":"option"}}],[11,"size_hint","","",187,null],[3,"DecodeUtf16","std::char","An iterator that decodes UTF-16 encoded code points from an iterator of `u16`s.",null,null],[11,"fmt","rustc_unicode::char","",188,{"inputs":[{"name":"decodeutf16error"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",188,{"inputs":[{"name":"decodeutf16error"}],"output":{"name":"decodeutf16error"}}],[11,"unpaired_surrogate","","Returns the unpaired surrogate which caused this error.",188,{"inputs":[{"name":"decodeutf16error"}],"output":{"name":"u16"}}],[11,"eq","","",188,{"inputs":[{"name":"decodeutf16error"},{"name":"decodeutf16error"}],"output":{"name":"bool"}}],[11,"ne","","",188,{"inputs":[{"name":"decodeutf16error"},{"name":"decodeutf16error"}],"output":{"name":"bool"}}],[11,"fmt","","",188,{"inputs":[{"name":"decodeutf16error"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"DecodeUtf16Error","std::char","An iterator that decodes UTF-16 encoded code points from an iterator of `u16`s.",null,null],[5,"decode_utf16","","Create an iterator over the UTF-16 encoded code points in `iter`,\nreturning unpaired surrogates as `Err`s.",null,{"inputs":[{"name":"i"}],"output":{"name":"decodeutf16"}}],[17,"REPLACEMENT_CHARACTER","","`U+FFFD REPLACEMENT CHARACTER` (�) is used in Unicode to represent a\ndecoding error.",null,null],[17,"MAX","","The highest valid code point a `char` can have.",null,null],[17,"UNICODE_VERSION","","The version of [Unicode](http://www.unicode.org/)\nthat the unicode parts of `CharExt` and `UnicodeStrPrelude` traits are based on.",null,null],[5,"from_u32","","Converts a `u32` to a `char`.",null,{"inputs":[{"name":"u32"}],"output":{"name":"option"}}],[11,"next","core::char","",189,{"inputs":[{"name":"encodeutf8"}],"output":{"name":"option"}}],[11,"size_hint","","",189,null],[11,"as_slice","","Returns the remaining bytes of this iterator as a slice.",189,null],[11,"fmt","","",189,{"inputs":[{"name":"encodeutf8"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"EncodeUtf8","std::char","An iterator over `u8` entries represending the UTF-8 encoding of a `char`\nvalue.",null,null],[11,"as_slice","core::char","Returns the remaining bytes of this iterator as a slice.",190,null],[11,"fmt","","",190,{"inputs":[{"name":"encodeutf16"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",190,{"inputs":[{"name":"encodeutf16"}],"output":{"name":"option"}}],[11,"size_hint","","",190,null],[3,"EncodeUtf16","std::char","An iterator over `u16` entries represending the UTF-16 encoding of a `char`\nvalue.",null,null],[5,"from_u32_unchecked","","Converts a `u32` to a `char`, ignoring validity.",null,{"inputs":[{"name":"u32"}],"output":{"name":"char"}}],[5,"from_digit","","Converts a digit in the given radix to a `char`.",null,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"option"}}],[11,"next","core::char","",191,{"inputs":[{"name":"escapeunicode"}],"output":{"name":"option"}}],[11,"size_hint","","",191,null],[11,"clone","","",191,{"inputs":[{"name":"escapeunicode"}],"output":{"name":"escapeunicode"}}],[11,"fmt","","",191,{"inputs":[{"name":"escapeunicode"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"EscapeUnicode","std::char","Returns an iterator that yields the hexadecimal Unicode escape of a\ncharacter, as `char`s.",null,null],[11,"clone","core::char","",192,{"inputs":[{"name":"escapedefault"}],"output":{"name":"escapedefault"}}],[11,"fmt","","",192,{"inputs":[{"name":"escapedefault"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",192,{"inputs":[{"name":"escapedefault"}],"output":{"name":"option"}}],[11,"size_hint","","",192,null],[11,"count","","",192,{"inputs":[{"name":"escapedefault"}],"output":{"name":"usize"}}],[11,"nth","","",192,{"inputs":[{"name":"escapedefault"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",192,{"inputs":[{"name":"escapedefault"}],"output":{"name":"option"}}],[3,"EscapeDefault","std::char","An iterator that yields the literal escape code of a `char`.",null,null],[0,"isize","std","The pointer-sized signed integer type.",null,null],[17,"MIN","std::isize","",null,null],[17,"MAX","","",null,null],[0,"i8","std","The 8-bit signed integer type.",null,null],[17,"MIN","std::i8","",null,null],[17,"MAX","","",null,null],[0,"i16","std","The 16-bit signed integer type.",null,null],[17,"MIN","std::i16","",null,null],[17,"MAX","","",null,null],[0,"i32","std","The 32-bit signed integer type.",null,null],[17,"MIN","std::i32","",null,null],[17,"MAX","","",null,null],[0,"i64","std","The 64-bit signed integer type.",null,null],[17,"MIN","std::i64","",null,null],[17,"MAX","","",null,null],[0,"usize","std","The pointer-sized unsigned integer type.",null,null],[17,"MIN","std::usize","",null,null],[17,"MAX","","",null,null],[0,"u8","std","The 8-bit unsigned integer type.",null,null],[17,"MIN","std::u8","",null,null],[17,"MAX","","",null,null],[0,"u16","std","The 16-bit unsigned integer type.",null,null],[17,"MIN","std::u16","",null,null],[17,"MAX","","",null,null],[0,"u32","std","The 32-bit unsigned integer type.",null,null],[17,"MIN","std::u32","",null,null],[17,"MAX","","",null,null],[0,"u64","std","The 64-bit unsigned integer type.",null,null],[17,"MIN","std::u64","",null,null],[17,"MAX","","",null,null],[0,"error","std","Traits for working with Errors.",null,null],[8,"Error","std::error","Base functionality for all errors in Rust.",null,null],[10,"description","","A short description of the error.",193,{"inputs":[{"name":"error"}],"output":{"name":"str"}}],[11,"cause","","The lower-level cause of this error, if any.",193,{"inputs":[{"name":"error"}],"output":{"name":"option"}}],[11,"from","std::boxed","",108,{"inputs":[{"name":"e"}],"output":{"name":"box"}}],[11,"from","","",108,{"inputs":[{"name":"e"}],"output":{"name":"box"}}],[11,"from","","",108,{"inputs":[{"name":"string"}],"output":{"name":"box"}}],[11,"from","","",108,{"inputs":[{"name":"string"}],"output":{"name":"box"}}],[11,"from","","",108,{"inputs":[{"name":"str"}],"output":{"name":"box"}}],[11,"from","","",108,{"inputs":[{"name":"str"}],"output":{"name":"box"}}],[11,"description","std::str","",172,{"inputs":[{"name":"parseboolerror"}],"output":{"name":"str"}}],[11,"description","","",175,{"inputs":[{"name":"utf8error"}],"output":{"name":"str"}}],[11,"description","core::num","",194,{"inputs":[{"name":"parseinterror"}],"output":{"name":"str"}}],[11,"description","core::num::dec2flt","",195,{"inputs":[{"name":"parsefloaterror"}],"output":{"name":"str"}}],[11,"description","std::string","",177,{"inputs":[{"name":"fromutf8error"}],"output":{"name":"str"}}],[11,"description","","",178,{"inputs":[{"name":"fromutf16error"}],"output":{"name":"str"}}],[11,"description","","",179,{"inputs":[{"name":"parseerror"}],"output":{"name":"str"}}],[11,"description","std::char","",188,{"inputs":[{"name":"decodeutf16error"}],"output":{"name":"str"}}],[11,"description","std::boxed","",108,{"inputs":[{"name":"box"}],"output":{"name":"str"}}],[11,"cause","","",108,{"inputs":[{"name":"box"}],"output":{"name":"option"}}],[11,"is","std","Returns true if the boxed type is the same as `T`",193,{"inputs":[{"name":"error"}],"output":{"name":"bool"}}],[11,"downcast_ref","","Returns some reference to the boxed value if it is of type `T`, or\n`None` if it isn&#39;t.",193,{"inputs":[{"name":"error"}],"output":{"name":"option"}}],[11,"downcast_mut","","Returns some mutable reference to the boxed value if it is of type `T`, or\n`None` if it isn&#39;t.",193,{"inputs":[{"name":"error"}],"output":{"name":"option"}}],[11,"is","","Forwards to the method defined on the type `Any`.",193,{"inputs":[{"name":"error"}],"output":{"name":"bool"}}],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",193,{"inputs":[{"name":"error"}],"output":{"name":"option"}}],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",193,{"inputs":[{"name":"error"}],"output":{"name":"option"}}],[11,"is","","Forwards to the method defined on the type `Any`.",193,{"inputs":[{"name":"error"}],"output":{"name":"bool"}}],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",193,{"inputs":[{"name":"error"}],"output":{"name":"option"}}],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",193,{"inputs":[{"name":"error"}],"output":{"name":"option"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",193,{"inputs":[{"name":"error"}],"output":{"name":"result"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",193,{"inputs":[{"name":"error"}],"output":{"name":"result"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",193,{"inputs":[{"name":"error"}],"output":{"name":"result"}}],[0,"prelude","","The Rust Prelude.",null,null],[0,"v1","std::prelude","The first version of the prelude of The Rust Standard Library.",null,null],[0,"f32","std","The 32-bit floating point type.",null,null],[17,"RADIX","std::f32","",null,null],[17,"MANTISSA_DIGITS","","",null,null],[17,"DIGITS","","",null,null],[17,"EPSILON","","",null,null],[17,"MIN_EXP","","",null,null],[17,"MAX_EXP","","",null,null],[17,"MIN_10_EXP","","",null,null],[17,"MAX_10_EXP","","",null,null],[17,"NAN","","",null,null],[17,"INFINITY","","",null,null],[17,"NEG_INFINITY","","",null,null],[17,"MIN","","Smallest finite f32 value",null,null],[17,"MIN_POSITIVE","","Smallest positive, normalized f32 value",null,null],[17,"MAX","","Largest finite f32 value",null,null],[0,"consts","","Basic mathematical constants.",null,null],[17,"PI","std::f32::consts","Archimedes&#39; constant",null,null],[17,"FRAC_PI_2","","pi/2.0",null,null],[17,"FRAC_PI_3","","pi/3.0",null,null],[17,"FRAC_PI_4","","pi/4.0",null,null],[17,"FRAC_PI_6","","pi/6.0",null,null],[17,"FRAC_PI_8","","pi/8.0",null,null],[17,"FRAC_1_PI","","1.0/pi",null,null],[17,"FRAC_2_PI","","2.0/pi",null,null],[17,"FRAC_2_SQRT_PI","","2.0/sqrt(pi)",null,null],[17,"SQRT_2","","sqrt(2.0)",null,null],[17,"FRAC_1_SQRT_2","","1.0/sqrt(2.0)",null,null],[17,"E","","Euler&#39;s number",null,null],[17,"LOG2_E","","log2(e)",null,null],[17,"LOG10_E","","log10(e)",null,null],[17,"LN_2","","ln(2.0)",null,null],[17,"LN_10","","ln(10.0)",null,null],[0,"f64","std","The 64-bit floating point type.",null,null],[17,"RADIX","std::f64","",null,null],[17,"MANTISSA_DIGITS","","",null,null],[17,"DIGITS","","",null,null],[17,"EPSILON","","",null,null],[17,"MIN_EXP","","",null,null],[17,"MAX_EXP","","",null,null],[17,"MIN_10_EXP","","",null,null],[17,"MAX_10_EXP","","",null,null],[17,"NAN","","",null,null],[17,"INFINITY","","",null,null],[17,"NEG_INFINITY","","",null,null],[17,"MIN","","Smallest finite f64 value",null,null],[17,"MIN_POSITIVE","","Smallest positive, normalized f64 value",null,null],[17,"MAX","","Largest finite f64 value",null,null],[0,"consts","","Basic mathematical constants.",null,null],[17,"PI","std::f64::consts","Archimedes&#39; constant",null,null],[17,"FRAC_PI_2","","pi/2.0",null,null],[17,"FRAC_PI_3","","pi/3.0",null,null],[17,"FRAC_PI_4","","pi/4.0",null,null],[17,"FRAC_PI_6","","pi/6.0",null,null],[17,"FRAC_PI_8","","pi/8.0",null,null],[17,"FRAC_1_PI","","1.0/pi",null,null],[17,"FRAC_2_PI","","2.0/pi",null,null],[17,"FRAC_2_SQRT_PI","","2.0/sqrt(pi)",null,null],[17,"SQRT_2","","sqrt(2.0)",null,null],[17,"FRAC_1_SQRT_2","","1.0/sqrt(2.0)",null,null],[17,"E","","Euler&#39;s number",null,null],[17,"LOG2_E","","log2(e)",null,null],[17,"LOG10_E","","log10(e)",null,null],[17,"LN_2","","ln(2.0)",null,null],[17,"LN_10","","ln(10.0)",null,null],[0,"ascii","std","Operations on ASCII strings and characters.",null,null],[3,"EscapeDefault","std::ascii","An iterator over the escaped version of a byte, constructed via\n`std::ascii::escape_default`.",null,null],[5,"escape_default","","Returns an iterator that produces an escaped version of a `u8`.",null,{"inputs":[{"name":"u8"}],"output":{"name":"escapedefault"}}],[8,"AsciiExt","","Extension methods for ASCII-subset only operations on string slices.",null,null],[16,"Owned","","Container type for copied ASCII characters.",196,null],[10,"is_ascii","","Checks if the value is within the ASCII range.",196,{"inputs":[{"name":"asciiext"}],"output":{"name":"bool"}}],[10,"to_ascii_uppercase","","Makes a copy of the string in ASCII upper case.",196,{"inputs":[{"name":"asciiext"}],"output":{"name":"owned"}}],[10,"to_ascii_lowercase","","Makes a copy of the string in ASCII lower case.",196,{"inputs":[{"name":"asciiext"}],"output":{"name":"owned"}}],[10,"eq_ignore_ascii_case","","Checks that two strings are an ASCII case-insensitive match.",196,{"inputs":[{"name":"asciiext"},{"name":"self"}],"output":{"name":"bool"}}],[10,"make_ascii_uppercase","","Converts this type to its ASCII upper case equivalent in-place.",196,{"inputs":[{"name":"asciiext"}],"output":null}],[10,"make_ascii_lowercase","","Converts this type to its ASCII lower case equivalent in-place.",196,{"inputs":[{"name":"asciiext"}],"output":null}],[11,"next","","",197,{"inputs":[{"name":"escapedefault"}],"output":{"name":"option"}}],[11,"size_hint","","",197,null],[11,"next_back","","",197,{"inputs":[{"name":"escapedefault"}],"output":{"name":"option"}}],[0,"num","std","Additional functionality for numerics.",null,null],[8,"Zero","std::num","Types that have a &quot;zero&quot; value.",null,null],[10,"zero","","The &quot;zero&quot; (usually, additive identity) for this type.",198,{"inputs":[],"output":{"name":"self"}}],[8,"One","","Types that have a &quot;one&quot; value.",null,null],[10,"one","","The &quot;one&quot; (usually, multiplicative identity) for this type.",199,{"inputs":[],"output":{"name":"self"}}],[11,"clone","core::num","",200,{"inputs":[{"name":"fpcategory"}],"output":{"name":"fpcategory"}}],[11,"eq","","",200,{"inputs":[{"name":"fpcategory"},{"name":"fpcategory"}],"output":{"name":"bool"}}],[11,"fmt","","",200,{"inputs":[{"name":"fpcategory"},{"name":"formatter"}],"output":{"name":"result"}}],[4,"FpCategory","std::num","A classification of floating point numbers.",null,null],[13,"Nan","","&quot;Not a Number&quot;, often obtained by dividing by zero",200,null],[13,"Infinite","","Positive or negative infinity",200,null],[13,"Zero","","Positive or negative zero",200,null],[13,"Subnormal","","De-normalized floating point representation (less precise than `Normal`)",200,null],[13,"Normal","","A regular floating point number",200,null],[11,"fmt","core::num","",194,{"inputs":[{"name":"parseinterror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",194,{"inputs":[{"name":"parseinterror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",194,{"inputs":[{"name":"parseinterror"}],"output":{"name":"parseinterror"}}],[11,"eq","","",194,{"inputs":[{"name":"parseinterror"},{"name":"parseinterror"}],"output":{"name":"bool"}}],[11,"ne","","",194,{"inputs":[{"name":"parseinterror"},{"name":"parseinterror"}],"output":{"name":"bool"}}],[3,"ParseIntError","std::num","An error which can be returned when parsing an integer.",null,null],[3,"ParseFloatError","","An error which can be returned when parsing a float.",null,null],[11,"bitand_assign","core::num","",201,null],[11,"bitand","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor_assign","","",201,null],[11,"bitor","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor_assign","","",201,null],[11,"bitxor","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"not","","",201,{"inputs":[{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem_assign","","",201,null],[11,"rem","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div_assign","","",201,null],[11,"div","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul_assign","","",201,null],[11,"mul","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub_assign","","",201,null],[11,"sub","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add_assign","","",201,null],[11,"add","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand_assign","","",201,null],[11,"bitand","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor_assign","","",201,null],[11,"bitor","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor_assign","","",201,null],[11,"bitxor","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"not","","",201,{"inputs":[{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem_assign","","",201,null],[11,"rem","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div_assign","","",201,null],[11,"div","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul_assign","","",201,null],[11,"mul","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub_assign","","",201,null],[11,"sub","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add_assign","","",201,null],[11,"add","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand_assign","","",201,null],[11,"bitand","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor_assign","","",201,null],[11,"bitor","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor_assign","","",201,null],[11,"bitxor","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"not","","",201,{"inputs":[{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem_assign","","",201,null],[11,"rem","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div_assign","","",201,null],[11,"div","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul_assign","","",201,null],[11,"mul","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub_assign","","",201,null],[11,"sub","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add_assign","","",201,null],[11,"add","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand_assign","","",201,null],[11,"bitand","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor_assign","","",201,null],[11,"bitor","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor_assign","","",201,null],[11,"bitxor","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"not","","",201,{"inputs":[{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem_assign","","",201,null],[11,"rem","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div_assign","","",201,null],[11,"div","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul_assign","","",201,null],[11,"mul","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub_assign","","",201,null],[11,"sub","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add_assign","","",201,null],[11,"add","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand_assign","","",201,null],[11,"bitand","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor_assign","","",201,null],[11,"bitor","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor_assign","","",201,null],[11,"bitxor","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"not","","",201,{"inputs":[{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem_assign","","",201,null],[11,"rem","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div_assign","","",201,null],[11,"div","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul_assign","","",201,null],[11,"mul","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub_assign","","",201,null],[11,"sub","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add_assign","","",201,null],[11,"add","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand_assign","","",201,null],[11,"bitand","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor_assign","","",201,null],[11,"bitor","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor_assign","","",201,null],[11,"bitxor","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"not","","",201,{"inputs":[{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem_assign","","",201,null],[11,"rem","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div_assign","","",201,null],[11,"div","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul_assign","","",201,null],[11,"mul","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub_assign","","",201,null],[11,"sub","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add_assign","","",201,null],[11,"add","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand_assign","","",201,null],[11,"bitand","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor_assign","","",201,null],[11,"bitor","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor_assign","","",201,null],[11,"bitxor","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"not","","",201,{"inputs":[{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem_assign","","",201,null],[11,"rem","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div_assign","","",201,null],[11,"div","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul_assign","","",201,null],[11,"mul","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub_assign","","",201,null],[11,"sub","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add_assign","","",201,null],[11,"add","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand_assign","","",201,null],[11,"bitand","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor_assign","","",201,null],[11,"bitor","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor_assign","","",201,null],[11,"bitxor","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"not","","",201,{"inputs":[{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem_assign","","",201,null],[11,"rem","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div_assign","","",201,null],[11,"div","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul_assign","","",201,null],[11,"mul","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub_assign","","",201,null],[11,"sub","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add_assign","","",201,null],[11,"add","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand_assign","","",201,null],[11,"bitand","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor_assign","","",201,null],[11,"bitor","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor_assign","","",201,null],[11,"bitxor","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"not","","",201,{"inputs":[{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem_assign","","",201,null],[11,"rem","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div_assign","","",201,null],[11,"div","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul_assign","","",201,null],[11,"mul","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub_assign","","",201,null],[11,"sub","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add_assign","","",201,null],[11,"add","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand_assign","","",201,null],[11,"bitand","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor_assign","","",201,null],[11,"bitor","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor_assign","","",201,null],[11,"bitxor","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"not","","",201,{"inputs":[{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem_assign","","",201,null],[11,"rem","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div_assign","","",201,null],[11,"div","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul_assign","","",201,null],[11,"mul","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub_assign","","",201,null],[11,"sub","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add_assign","","",201,null],[11,"add","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",201,null],[11,"shr","","",201,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",201,null],[11,"shl","","",201,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",201,null],[11,"shr","","",201,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",201,null],[11,"shl","","",201,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",201,null],[11,"shr","","",201,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",201,null],[11,"shl","","",201,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",201,null],[11,"shr","","",201,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",201,null],[11,"shl","","",201,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",201,null],[11,"shr","","",201,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",201,null],[11,"shl","","",201,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",201,null],[11,"shr","","",201,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",201,null],[11,"shl","","",201,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",201,null],[11,"shr","","",201,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",201,null],[11,"shl","","",201,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",201,null],[11,"shr","","",201,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",201,null],[11,"shl","","",201,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",201,null],[11,"shr","","",201,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",201,null],[11,"shl","","",201,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",201,null],[11,"shr","","",201,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",201,null],[11,"shl","","",201,{"inputs":[{"name":"wrapping"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"eq","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"ne","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"option"}}],[11,"lt","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"le","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"gt","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"ge","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"cmp","","",201,{"inputs":[{"name":"wrapping"},{"name":"wrapping"}],"output":{"name":"ordering"}}],[11,"clone","","",201,{"inputs":[{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"fmt","","",201,{"inputs":[{"name":"wrapping"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","",201,{"inputs":[],"output":{"name":"wrapping"}}],[3,"Wrapping","std::num","Provides intentionally-wrapped arithmetic on `T`.",null,null],[12,"0","","",201,null],[0,"thread","std","Native threads.",null,null],[3,"LocalKey","std::thread","A thread local storage key which owns its contents.",null,null],[3,"ScopedKey","","Type representing a thread local storage key corresponding to a reference\nto the type parameter `T`.",null,null],[3,"__OsLocalKeyInner","","",null,null],[3,"__ScopedKeyInner","","",null,null],[12,"inner","","",202,null],[12,"marker","","",202,null],[3,"Builder","","Thread configuration. Provides detailed control over the properties\nand behavior of new threads.",null,null],[3,"Thread","","A handle to a thread.",null,null],[3,"JoinHandle","","An owned permission to join on a thread (block on its termination).",null,null],[4,"LocalKeyState","","Indicator of the state of a thread local storage key.",null,null],[13,"Uninitialized","","All keys are in this state whenever a thread starts. Keys will\ntransition to the `Valid` state once the first call to `with` happens\nand the initialization expression succeeds.",203,null],[13,"Valid","","Once a key has been accessed successfully, it will enter the `Valid`\nstate. Keys in the `Valid` state will remain so until the thread exits,\nat which point the destructor will be run and the key will enter the\n`Destroyed` state.",203,null],[13,"Destroyed","","When a thread exits, the destructors for keys will be run (if\nnecessary). While a destructor is running, and possibly after a\ndestructor has run, a key is in the `Destroyed` state.",203,null],[5,"spawn","","Spawns a new thread, returning a `JoinHandle` for it.",null,{"inputs":[{"name":"f"}],"output":{"name":"joinhandle"}}],[5,"current","","Gets a handle to the thread that invokes it.",null,{"inputs":[],"output":{"name":"thread"}}],[5,"yield_now","","Cooperatively gives up a timeslice to the OS scheduler.",null,{"inputs":[],"output":null}],[5,"panicking","","Determines whether the current thread is unwinding because of panic.",null,{"inputs":[],"output":{"name":"bool"}}],[5,"sleep_ms","","Puts the current thread to sleep for the specified amount of time.",null,{"inputs":[{"name":"u32"}],"output":null}],[5,"sleep","","Puts the current thread to sleep for the specified amount of time.",null,{"inputs":[{"name":"duration"}],"output":null}],[5,"park","","Blocks unless or until the current thread&#39;s token is made available.",null,{"inputs":[],"output":null}],[5,"park_timeout_ms","","Blocks unless or until the current thread&#39;s token is made available or\nthe specified duration has been reached (may wake spuriously).",null,{"inputs":[{"name":"u32"}],"output":null}],[5,"park_timeout","","Blocks unless or until the current thread&#39;s token is made available or\nthe specified duration has been reached (may wake spuriously).",null,{"inputs":[{"name":"duration"}],"output":null}],[11,"new","","",204,{"inputs":[],"output":{"name":"key"}}],[11,"get","","",204,{"inputs":[{"name":"__oslocalkeyinner"}],"output":{"name":"option"}}],[11,"clone","","",203,{"inputs":[{"name":"localkeystate"}],"output":{"name":"localkeystate"}}],[11,"eq","","",203,{"inputs":[{"name":"localkeystate"},{"name":"localkeystate"}],"output":{"name":"bool"}}],[11,"with","","Acquires a reference to the value in this TLS key.",205,{"inputs":[{"name":"localkey"},{"name":"f"}],"output":{"name":"r"}}],[11,"state","","Query the current state of this key.",205,{"inputs":[{"name":"localkey"}],"output":{"name":"localkeystate"}}],[11,"new","","",202,{"inputs":[],"output":{"name":"keyinner"}}],[11,"set","","",202,null],[11,"get","","",202,null],[11,"set","","Inserts a value into this scoped thread local storage slot for a\nduration of a closure.",206,{"inputs":[{"name":"scopedkey"},{"name":"t"},{"name":"f"}],"output":{"name":"r"}}],[11,"with","","Gets a value out of this scoped variable.",206,{"inputs":[{"name":"scopedkey"},{"name":"f"}],"output":{"name":"r"}}],[11,"is_set","","Test whether this TLS key has been `set` for the current thread.",206,{"inputs":[{"name":"scopedkey"}],"output":{"name":"bool"}}],[6,"Result","","Indicates the manner in which a thread exited.",null,null],[11,"new","","Generates the base configuration for spawning a thread, from which\nconfiguration methods can be chained.",207,{"inputs":[],"output":{"name":"builder"}}],[11,"name","","Names the thread-to-be. Currently the name is used for identification\nonly in panic messages.",207,{"inputs":[{"name":"builder"},{"name":"string"}],"output":{"name":"builder"}}],[11,"stack_size","","Sets the size of the stack for the new thread.",207,{"inputs":[{"name":"builder"},{"name":"usize"}],"output":{"name":"builder"}}],[11,"spawn","","Spawns a new thread, and returns a join handle for it.",207,{"inputs":[{"name":"builder"},{"name":"f"}],"output":{"name":"result"}}],[11,"clone","","",208,{"inputs":[{"name":"thread"}],"output":{"name":"thread"}}],[11,"unpark","","Atomically makes the handle&#39;s token available if it is not already.",208,{"inputs":[{"name":"thread"}],"output":null}],[11,"name","","Gets the thread&#39;s name.",208,{"inputs":[{"name":"thread"}],"output":{"name":"option"}}],[11,"fmt","","",208,{"inputs":[{"name":"thread"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"thread","","Extracts a handle to the underlying thread",209,{"inputs":[{"name":"joinhandle"}],"output":{"name":"thread"}}],[11,"join","","Waits for the associated thread to finish.",209,{"inputs":[{"name":"joinhandle"}],"output":{"name":"result"}}],[0,"collections","std","Collection types.",null,null],[11,"hash","collections","",210,null],[11,"eq","","",210,{"inputs":[{"name":"bound"},{"name":"bound"}],"output":{"name":"bool"}}],[11,"ne","","",210,{"inputs":[{"name":"bound"},{"name":"bound"}],"output":{"name":"bool"}}],[11,"clone","","",210,{"inputs":[{"name":"bound"}],"output":{"name":"bound"}}],[11,"fmt","","",210,{"inputs":[{"name":"bound"},{"name":"formatter"}],"output":{"name":"result"}}],[4,"Bound","std::collections","An endpoint of a range of keys.",null,null],[13,"Included","","An inclusive bound.",210,null],[13,"Excluded","","An exclusive bound.",210,null],[13,"Unbounded","","An infinite endpoint. Indicates that there is no bound in this direction.",210,null],[11,"extend","collections::binary_heap","",211,null],[11,"extend","","",211,null],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each value out of\nthe binary heap in arbitrary order. The binary heap cannot be used\nafter calling this.",211,{"inputs":[{"name":"binaryheap"}],"output":{"name":"intoiter"}}],[11,"from_iter","","",211,{"inputs":[{"name":"i"}],"output":{"name":"binaryheap"}}],[11,"from","","",211,{"inputs":[{"name":"vec"}],"output":{"name":"binaryheap"}}],[11,"new","","Creates an empty `BinaryHeap` as a max-heap.",211,{"inputs":[],"output":{"name":"binaryheap"}}],[11,"with_capacity","","Creates an empty `BinaryHeap` with a specific capacity.\nThis preallocates enough memory for `capacity` elements,\nso that the `BinaryHeap` does not have to be reallocated\nuntil it contains at least that many values.",211,{"inputs":[{"name":"usize"}],"output":{"name":"binaryheap"}}],[11,"iter","","Returns an iterator visiting all values in the underlying vector, in\narbitrary order.",211,{"inputs":[{"name":"binaryheap"}],"output":{"name":"iter"}}],[11,"peek","","Returns the greatest item in the binary heap, or `None` if it is empty.",211,{"inputs":[{"name":"binaryheap"}],"output":{"name":"option"}}],[11,"capacity","","Returns the number of elements the binary heap can hold without reallocating.",211,{"inputs":[{"name":"binaryheap"}],"output":{"name":"usize"}}],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the\ngiven `BinaryHeap`. Does nothing if the capacity is already sufficient.",211,null],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the\n`BinaryHeap`. The collection may reserve more space to avoid frequent reallocations.",211,null],[11,"shrink_to_fit","","Discards as much additional capacity as possible.",211,null],[11,"pop","","Removes the greatest item from the binary heap and returns it, or `None` if it\nis empty.",211,{"inputs":[{"name":"binaryheap"}],"output":{"name":"option"}}],[11,"push","","Pushes an item onto the binary heap.",211,null],[11,"push_pop","","Pushes an item onto the binary heap, then pops the greatest item off the queue in\nan optimized fashion.",211,{"inputs":[{"name":"binaryheap"},{"name":"t"}],"output":{"name":"t"}}],[11,"replace","","Pops the greatest item off the binary heap, then pushes an item onto the queue in\nan optimized fashion. The push is done regardless of whether the binary heap\nwas empty.",211,{"inputs":[{"name":"binaryheap"},{"name":"t"}],"output":{"name":"option"}}],[11,"into_vec","","Consumes the `BinaryHeap` and returns the underlying vector\nin arbitrary order.",211,{"inputs":[{"name":"binaryheap"}],"output":{"name":"vec"}}],[11,"into_sorted_vec","","Consumes the `BinaryHeap` and returns a vector in sorted\n(ascending) order.",211,{"inputs":[{"name":"binaryheap"}],"output":{"name":"vec"}}],[11,"len","","Returns the length of the binary heap.",211,{"inputs":[{"name":"binaryheap"}],"output":{"name":"usize"}}],[11,"is_empty","","Checks if the binary heap is empty.",211,{"inputs":[{"name":"binaryheap"}],"output":{"name":"bool"}}],[11,"drain","","Clears the binary heap, returning an iterator over the removed elements.",211,{"inputs":[{"name":"binaryheap"}],"output":{"name":"drain"}}],[11,"clear","","Drops all items from the binary heap.",211,null],[11,"fmt","","",211,{"inputs":[{"name":"binaryheap"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","",211,{"inputs":[],"output":{"name":"binaryheap"}}],[11,"clone","","",211,{"inputs":[{"name":"binaryheap"}],"output":{"name":"binaryheap"}}],[11,"clone_from","","",211,null],[3,"BinaryHeap","std::collections","A priority queue implemented with a binary heap.",null,null],[11,"iter","collections::btree::map","Gets an iterator over the entries of the map, sorted by key.",212,{"inputs":[{"name":"btreemap"}],"output":{"name":"iter"}}],[11,"iter_mut","","Gets a mutable iterator over the entries of the map, sorted by key.",212,{"inputs":[{"name":"btreemap"}],"output":{"name":"itermut"}}],[11,"keys","","Gets an iterator over the keys of the map, in sorted order.",212,{"inputs":[{"name":"btreemap"}],"output":{"name":"keys"}}],[11,"values","","Gets an iterator over the values of the map, in order by key.",212,{"inputs":[{"name":"btreemap"}],"output":{"name":"values"}}],[11,"values_mut","","Gets a mutable iterator over the values of the map, in order by key.",212,{"inputs":[{"name":"btreemap"}],"output":{"name":"valuesmut"}}],[11,"len","","Returns the number of elements in the map.",212,{"inputs":[{"name":"btreemap"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns true if the map contains no elements.",212,{"inputs":[{"name":"btreemap"}],"output":{"name":"bool"}}],[11,"index","","",212,{"inputs":[{"name":"btreemap"},{"name":"q"}],"output":{"name":"v"}}],[11,"fmt","","",212,{"inputs":[{"name":"btreemap"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"cmp","","",212,{"inputs":[{"name":"btreemap"},{"name":"btreemap"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",212,{"inputs":[{"name":"btreemap"},{"name":"btreemap"}],"output":{"name":"option"}}],[11,"eq","","",212,{"inputs":[{"name":"btreemap"},{"name":"btreemap"}],"output":{"name":"bool"}}],[11,"default","","",212,{"inputs":[],"output":{"name":"btreemap"}}],[11,"hash","","",212,null],[11,"extend","","",212,null],[11,"extend","","",212,null],[11,"from_iter","","",212,{"inputs":[{"name":"t"}],"output":{"name":"btreemap"}}],[11,"into_iter","","",212,{"inputs":[{"name":"btreemap"}],"output":{"name":"intoiter"}}],[11,"new","","Makes a new empty BTreeMap with a reasonable choice for B.",212,{"inputs":[],"output":{"name":"btreemap"}}],[11,"clear","","Clears the map, removing all values.",212,null],[11,"get","","Returns a reference to the value corresponding to the key.",212,{"inputs":[{"name":"btreemap"},{"name":"q"}],"output":{"name":"option"}}],[11,"contains_key","","Returns true if the map contains a value for the specified key.",212,{"inputs":[{"name":"btreemap"},{"name":"q"}],"output":{"name":"bool"}}],[11,"get_mut","","Returns a mutable reference to the value corresponding to the key.",212,{"inputs":[{"name":"btreemap"},{"name":"q"}],"output":{"name":"option"}}],[11,"insert","","Inserts a key-value pair into the map.",212,{"inputs":[{"name":"btreemap"},{"name":"k"},{"name":"v"}],"output":{"name":"option"}}],[11,"remove","","Removes a key from the map, returning the value at the key if the key\nwas previously in the map.",212,{"inputs":[{"name":"btreemap"},{"name":"q"}],"output":{"name":"option"}}],[11,"range","","Constructs a double-ended iterator over a sub-range of elements in the map, starting\nat min, and ending at max. If min is `Unbounded`, then it will be treated as &quot;negative\ninfinity&quot;, and if max is `Unbounded`, then it will be treated as &quot;positive infinity&quot;.\nThus range(Unbounded, Unbounded) will yield the whole collection.",212,{"inputs":[{"name":"btreemap"},{"name":"bound"},{"name":"bound"}],"output":{"name":"range"}}],[11,"range_mut","","Constructs a mutable double-ended iterator over a sub-range of elements in the map, starting\nat min, and ending at max. If min is `Unbounded`, then it will be treated as &quot;negative\ninfinity&quot;, and if max is `Unbounded`, then it will be treated as &quot;positive infinity&quot;.\nThus range(Unbounded, Unbounded) will yield the whole collection.",212,{"inputs":[{"name":"btreemap"},{"name":"bound"},{"name":"bound"}],"output":{"name":"rangemut"}}],[11,"entry","","Gets the given key&#39;s corresponding entry in the map for in-place manipulation.",212,{"inputs":[{"name":"btreemap"},{"name":"k"}],"output":{"name":"entry"}}],[11,"clone","","",212,{"inputs":[{"name":"btreemap"}],"output":{"name":"btreemap"}}],[11,"drop","","",212,null],[3,"BTreeMap","std::collections","A map based on a B-Tree.",null,null],[11,"fmt","collections::btree::set","",213,{"inputs":[{"name":"btreeset"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","",213,{"inputs":[],"output":{"name":"btreeset"}}],[11,"extend","","",213,null],[11,"extend","","",213,null],[11,"into_iter","","Gets an iterator for moving out the BtreeSet&#39;s contents.",213,{"inputs":[{"name":"btreeset"}],"output":{"name":"intoiter"}}],[11,"from_iter","","",213,{"inputs":[{"name":"i"}],"output":{"name":"btreeset"}}],[11,"difference","","Visits the values representing the difference, in ascending order.",213,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"difference"}}],[11,"symmetric_difference","","Visits the values representing the symmetric difference, in ascending order.",213,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"symmetricdifference"}}],[11,"intersection","","Visits the values representing the intersection, in ascending order.",213,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"intersection"}}],[11,"union","","Visits the values representing the union, in ascending order.",213,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"union"}}],[11,"len","","Returns the number of elements in the set.",213,{"inputs":[{"name":"btreeset"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns true if the set contains no elements.",213,{"inputs":[{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"clear","","Clears the set, removing all values.",213,null],[11,"contains","","Returns `true` if the set contains a value.",213,{"inputs":[{"name":"btreeset"},{"name":"q"}],"output":{"name":"bool"}}],[11,"get","","Returns a reference to the value in the set, if any, that is equal to the given value.",213,{"inputs":[{"name":"btreeset"},{"name":"q"}],"output":{"name":"option"}}],[11,"is_disjoint","","Returns `true` if the set has no elements in common with `other`.\nThis is equivalent to checking for an empty intersection.",213,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"is_subset","","Returns `true` if the set is a subset of another.",213,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"is_superset","","Returns `true` if the set is a superset of another.",213,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"insert","","Adds a value to the set.",213,{"inputs":[{"name":"btreeset"},{"name":"t"}],"output":{"name":"bool"}}],[11,"replace","","Adds a value to the set, replacing the existing value, if any, that is equal to the given\none. Returns the replaced value.",213,{"inputs":[{"name":"btreeset"},{"name":"t"}],"output":{"name":"option"}}],[11,"remove","","Removes a value from the set. Returns `true` if the value was\npresent in the set.",213,{"inputs":[{"name":"btreeset"},{"name":"q"}],"output":{"name":"bool"}}],[11,"take","","Removes and returns the value in the set, if any, that is equal to the given one.",213,{"inputs":[{"name":"btreeset"},{"name":"q"}],"output":{"name":"option"}}],[11,"range","","Constructs a double-ended iterator over a sub-range of elements in the set, starting\nat min, and ending at max. If min is `Unbounded`, then it will be treated as &quot;negative\ninfinity&quot;, and if max is `Unbounded`, then it will be treated as &quot;positive infinity&quot;.\nThus range(Unbounded, Unbounded) will yield the whole collection.",213,{"inputs":[{"name":"btreeset"},{"name":"bound"},{"name":"bound"}],"output":{"name":"range"}}],[11,"iter","","Gets an iterator over the BTreeSet&#39;s contents.",213,{"inputs":[{"name":"btreeset"}],"output":{"name":"iter"}}],[11,"new","","Makes a new BTreeSet with a reasonable choice of B.",213,{"inputs":[],"output":{"name":"btreeset"}}],[11,"clone","","",213,{"inputs":[{"name":"btreeset"}],"output":{"name":"btreeset"}}],[11,"hash","","",213,null],[11,"eq","","",213,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"ne","","",213,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"cmp","","",213,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",213,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"option"}}],[11,"lt","","",213,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"le","","",213,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"gt","","",213,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"ge","","",213,{"inputs":[{"name":"btreeset"},{"name":"btreeset"}],"output":{"name":"bool"}}],[3,"BTreeSet","std::collections","A set based on a B-Tree.",null,null],[11,"clone","collections::linked_list","",214,{"inputs":[{"name":"linkedlist"}],"output":{"name":"linkedlist"}}],[11,"cmp","","",214,{"inputs":[{"name":"linkedlist"},{"name":"linkedlist"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",214,{"inputs":[{"name":"linkedlist"},{"name":"linkedlist"}],"output":{"name":"option"}}],[11,"eq","","",214,{"inputs":[{"name":"linkedlist"},{"name":"linkedlist"}],"output":{"name":"bool"}}],[11,"ne","","",214,{"inputs":[{"name":"linkedlist"},{"name":"linkedlist"}],"output":{"name":"bool"}}],[11,"extend","","",214,null],[11,"extend","","",214,null],[11,"into_iter","","Consumes the list into an iterator yielding elements by value.",214,{"inputs":[{"name":"linkedlist"}],"output":{"name":"intoiter"}}],[11,"from_iter","","",214,{"inputs":[{"name":"t"}],"output":{"name":"linkedlist"}}],[11,"drop","","",214,null],[11,"new","","Creates an empty `LinkedList`.",214,{"inputs":[],"output":{"name":"linkedlist"}}],[11,"append","","Moves all elements from `other` to the end of the list.",214,null],[11,"iter","","Provides a forward iterator.",214,{"inputs":[{"name":"linkedlist"}],"output":{"name":"iter"}}],[11,"iter_mut","","Provides a forward iterator with mutable references.",214,{"inputs":[{"name":"linkedlist"}],"output":{"name":"itermut"}}],[11,"is_empty","","Returns `true` if the `LinkedList` is empty.",214,{"inputs":[{"name":"linkedlist"}],"output":{"name":"bool"}}],[11,"len","","Returns the length of the `LinkedList`.",214,{"inputs":[{"name":"linkedlist"}],"output":{"name":"usize"}}],[11,"clear","","Removes all elements from the `LinkedList`.",214,null],[11,"front","","Provides a reference to the front element, or `None` if the list is\nempty.",214,{"inputs":[{"name":"linkedlist"}],"output":{"name":"option"}}],[11,"front_mut","","Provides a mutable reference to the front element, or `None` if the list\nis empty.",214,{"inputs":[{"name":"linkedlist"}],"output":{"name":"option"}}],[11,"back","","Provides a reference to the back element, or `None` if the list is\nempty.",214,{"inputs":[{"name":"linkedlist"}],"output":{"name":"option"}}],[11,"back_mut","","Provides a mutable reference to the back element, or `None` if the list\nis empty.",214,{"inputs":[{"name":"linkedlist"}],"output":{"name":"option"}}],[11,"push_front","","Adds an element first in the list.",214,null],[11,"pop_front","","Removes the first element and returns it, or `None` if the list is\nempty.",214,{"inputs":[{"name":"linkedlist"}],"output":{"name":"option"}}],[11,"push_back","","Appends an element to the back of a list",214,null],[11,"pop_back","","Removes the last element from a list and returns it, or `None` if\nit is empty.",214,{"inputs":[{"name":"linkedlist"}],"output":{"name":"option"}}],[11,"split_off","","Splits the list into two at the given index. Returns everything after the given index,\nincluding the index.",214,{"inputs":[{"name":"linkedlist"},{"name":"usize"}],"output":{"name":"linkedlist"}}],[11,"front_place","","Returns a place for insertion at the front of the list.",214,{"inputs":[{"name":"linkedlist"}],"output":{"name":"frontplace"}}],[11,"back_place","","Returns a place for insertion at the back of the list.",214,{"inputs":[{"name":"linkedlist"}],"output":{"name":"backplace"}}],[11,"default","","",214,{"inputs":[],"output":{"name":"linkedlist"}}],[11,"hash","","",214,null],[11,"fmt","","",214,{"inputs":[{"name":"linkedlist"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"LinkedList","std::collections","A doubly-linked list.",null,null],[11,"hash","collections::vec_deque","",215,null],[11,"resize","","Modifies the `VecDeque` in-place so that `len()` is equal to new_len,\neither by removing excess elements or by appending copies of a value to the back.",215,null],[11,"default","","",215,{"inputs":[],"output":{"name":"vecdeque"}}],[11,"drop","","",215,null],[11,"clone","","",215,{"inputs":[{"name":"vecdeque"}],"output":{"name":"vecdeque"}}],[11,"fmt","","",215,{"inputs":[{"name":"vecdeque"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"into_iter","","Consumes the list into a front-to-back iterator yielding elements by\nvalue.",215,{"inputs":[{"name":"vecdeque"}],"output":{"name":"intoiter"}}],[11,"cmp","","",215,{"inputs":[{"name":"vecdeque"},{"name":"vecdeque"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",215,{"inputs":[{"name":"vecdeque"},{"name":"vecdeque"}],"output":{"name":"option"}}],[11,"from_iter","","",215,{"inputs":[{"name":"t"}],"output":{"name":"vecdeque"}}],[11,"eq","","",215,{"inputs":[{"name":"vecdeque"},{"name":"vecdeque"}],"output":{"name":"bool"}}],[11,"extend","","",215,null],[11,"new","","Creates an empty `VecDeque`.",215,{"inputs":[],"output":{"name":"vecdeque"}}],[11,"with_capacity","","Creates an empty `VecDeque` with space for at least `n` elements.",215,{"inputs":[{"name":"usize"}],"output":{"name":"vecdeque"}}],[11,"get","","Retrieves an element in the `VecDeque` by index.",215,{"inputs":[{"name":"vecdeque"},{"name":"usize"}],"output":{"name":"option"}}],[11,"get_mut","","Retrieves an element in the `VecDeque` mutably by index.",215,{"inputs":[{"name":"vecdeque"},{"name":"usize"}],"output":{"name":"option"}}],[11,"swap","","Swaps elements at indices `i` and `j`.",215,null],[11,"capacity","","Returns the number of elements the `VecDeque` can hold without\nreallocating.",215,{"inputs":[{"name":"vecdeque"}],"output":{"name":"usize"}}],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the\ngiven `VecDeque`. Does nothing if the capacity is already sufficient.",215,null],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the given\n`VecDeque`. The collection may reserve more space to avoid frequent reallocations.",215,null],[11,"shrink_to_fit","","Shrinks the capacity of the `VecDeque` as much as possible.",215,null],[11,"truncate","","Shortens a `VecDeque`, dropping excess elements from the back.",215,null],[11,"iter","","Returns a front-to-back iterator.",215,{"inputs":[{"name":"vecdeque"}],"output":{"name":"iter"}}],[11,"iter_mut","","Returns a front-to-back iterator that returns mutable references.",215,{"inputs":[{"name":"vecdeque"}],"output":{"name":"itermut"}}],[11,"as_slices","","Returns a pair of slices which contain, in order, the contents of the\n`VecDeque`.",215,null],[11,"as_mut_slices","","Returns a pair of slices which contain, in order, the contents of the\n`VecDeque`.",215,null],[11,"len","","Returns the number of elements in the `VecDeque`.",215,{"inputs":[{"name":"vecdeque"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns true if the buffer contains no elements",215,{"inputs":[{"name":"vecdeque"}],"output":{"name":"bool"}}],[11,"drain","","Create a draining iterator that removes the specified range in the\n`VecDeque` and yields the removed items.",215,{"inputs":[{"name":"vecdeque"},{"name":"r"}],"output":{"name":"drain"}}],[11,"clear","","Clears the buffer, removing all values.",215,null],[11,"front","","Provides a reference to the front element, or `None` if the sequence is\nempty.",215,{"inputs":[{"name":"vecdeque"}],"output":{"name":"option"}}],[11,"front_mut","","Provides a mutable reference to the front element, or `None` if the\nsequence is empty.",215,{"inputs":[{"name":"vecdeque"}],"output":{"name":"option"}}],[11,"back","","Provides a reference to the back element, or `None` if the sequence is\nempty.",215,{"inputs":[{"name":"vecdeque"}],"output":{"name":"option"}}],[11,"back_mut","","Provides a mutable reference to the back element, or `None` if the\nsequence is empty.",215,{"inputs":[{"name":"vecdeque"}],"output":{"name":"option"}}],[11,"pop_front","","Removes the first element and returns it, or `None` if the sequence is\nempty.",215,{"inputs":[{"name":"vecdeque"}],"output":{"name":"option"}}],[11,"push_front","","Inserts an element first in the sequence.",215,null],[11,"push_back","","Appends an element to the back of a buffer",215,null],[11,"pop_back","","Removes the last element from a buffer and returns it, or `None` if\nit is empty.",215,{"inputs":[{"name":"vecdeque"}],"output":{"name":"option"}}],[11,"swap_remove_back","","Removes an element from anywhere in the `VecDeque` and returns it, replacing it with the\nlast element.",215,{"inputs":[{"name":"vecdeque"},{"name":"usize"}],"output":{"name":"option"}}],[11,"swap_remove_front","","Removes an element from anywhere in the `VecDeque` and returns it,\nreplacing it with the first element.",215,{"inputs":[{"name":"vecdeque"},{"name":"usize"}],"output":{"name":"option"}}],[11,"insert","","Inserts an element at `index` within the `VecDeque`. Whichever\nend is closer to the insertion point will be moved to make room,\nand all the affected elements will be moved to new positions.",215,null],[11,"remove","","Removes and returns the element at `index` from the `VecDeque`.\nWhichever end is closer to the removal point will be moved to make\nroom, and all the affected elements will be moved to new positions.\nReturns `None` if `index` is out of bounds.",215,{"inputs":[{"name":"vecdeque"},{"name":"usize"}],"output":{"name":"option"}}],[11,"split_off","","Splits the collection into two at the given index.",215,{"inputs":[{"name":"vecdeque"},{"name":"usize"}],"output":{"name":"vecdeque"}}],[11,"append","","Moves all the elements of `other` into `Self`, leaving `other` empty.",215,null],[11,"retain","","Retains only the elements specified by the predicate.",215,null],[11,"index_mut","","",215,{"inputs":[{"name":"vecdeque"},{"name":"usize"}],"output":{"name":"a"}}],[11,"index","","",215,{"inputs":[{"name":"vecdeque"},{"name":"usize"}],"output":{"name":"a"}}],[11,"extend","","",215,null],[3,"VecDeque","std::collections","`VecDeque` is a growable ring buffer, which can be used as a double-ended\nqueue efficiently.",null,null],[0,"binary_heap","","A priority queue implemented with a binary heap.",null,null],[3,"BinaryHeap","std::collections::binary_heap","A priority queue implemented with a binary heap.",null,null],[11,"next_back","collections::binary_heap","",216,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"next","","",216,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"size_hint","","",216,null],[11,"clone","","",216,{"inputs":[{"name":"iter"}],"output":{"name":"iter"}}],[3,"Iter","std::collections::binary_heap","`BinaryHeap` iterator.",null,null],[11,"next_back","collections::binary_heap","",217,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"next","","",217,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"size_hint","","",217,null],[3,"IntoIter","std::collections::binary_heap","An iterator that moves out of a `BinaryHeap`.",null,null],[11,"next_back","collections::binary_heap","",218,{"inputs":[{"name":"drain"}],"output":{"name":"option"}}],[11,"next","","",218,{"inputs":[{"name":"drain"}],"output":{"name":"option"}}],[11,"size_hint","","",218,null],[3,"Drain","std::collections::binary_heap","An iterator that drains a `BinaryHeap`.",null,null],[0,"btree_map","std::collections","",null,null],[11,"key","collections::btree::map","Gets a reference to the key in the entry.",219,{"inputs":[{"name":"occupiedentry"}],"output":{"name":"k"}}],[11,"get","","Gets a reference to the value in the entry.",219,{"inputs":[{"name":"occupiedentry"}],"output":{"name":"v"}}],[11,"get_mut","","Gets a mutable reference to the value in the entry.",219,{"inputs":[{"name":"occupiedentry"}],"output":{"name":"v"}}],[11,"into_mut","","Converts the entry into a mutable reference to its value.",219,{"inputs":[{"name":"occupiedentry"}],"output":{"name":"v"}}],[11,"insert","","Sets the value of the entry with the OccupiedEntry&#39;s key,\nand returns the entry&#39;s old value.",219,{"inputs":[{"name":"occupiedentry"},{"name":"v"}],"output":{"name":"v"}}],[11,"remove","","Takes the value of the entry out of the map, and returns it.",219,{"inputs":[{"name":"occupiedentry"}],"output":{"name":"v"}}],[3,"OccupiedEntry","std::collections::btree_map","An occupied Entry.",null,null],[11,"len","collections::btree::map","",220,{"inputs":[{"name":"valuesmut"}],"output":{"name":"usize"}}],[11,"next_back","","",220,{"inputs":[{"name":"valuesmut"}],"output":{"name":"option"}}],[11,"next","","",220,{"inputs":[{"name":"valuesmut"}],"output":{"name":"option"}}],[11,"size_hint","","",220,null],[3,"ValuesMut","std::collections::btree_map","A mutable iterator over a BTreeMap&#39;s values.",null,null],[11,"clone","collections::btree::map","",221,{"inputs":[{"name":"values"}],"output":{"name":"values"}}],[11,"len","","",221,{"inputs":[{"name":"values"}],"output":{"name":"usize"}}],[11,"next_back","","",221,{"inputs":[{"name":"values"}],"output":{"name":"option"}}],[11,"next","","",221,{"inputs":[{"name":"values"}],"output":{"name":"option"}}],[11,"size_hint","","",221,null],[3,"Values","std::collections::btree_map","An iterator over a BTreeMap&#39;s values.",null,null],[11,"clone","collections::btree::map","",222,{"inputs":[{"name":"iter"}],"output":{"name":"iter"}}],[11,"len","","",222,{"inputs":[{"name":"iter"}],"output":{"name":"usize"}}],[11,"next_back","","",222,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"next","","",222,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"size_hint","","",222,null],[3,"Iter","std::collections::btree_map","An iterator over a BTreeMap&#39;s entries.",null,null],[3,"BTreeMap","","A map based on a B-Tree.",null,null],[11,"or_insert","collections::btree::map","Ensures a value is in the entry by inserting the default if empty, and returns\na mutable reference to the value in the entry.",223,{"inputs":[{"name":"entry"},{"name":"v"}],"output":{"name":"v"}}],[11,"or_insert_with","","Ensures a value is in the entry by inserting the result of the default function if empty,\nand returns a mutable reference to the value in the entry.",223,{"inputs":[{"name":"entry"},{"name":"f"}],"output":{"name":"v"}}],[4,"Entry","std::collections::btree_map","A view into a single entry in a map, which may either be vacant or occupied.",null,null],[13,"Vacant","","A vacant Entry",223,null],[13,"Occupied","","An occupied Entry",223,null],[11,"next_back","collections::btree::map","",224,{"inputs":[{"name":"rangemut"}],"output":{"name":"option"}}],[11,"next","","",224,{"inputs":[{"name":"rangemut"}],"output":{"name":"option"}}],[3,"RangeMut","std::collections::btree_map","A mutable iterator over a sub-range of BTreeMap&#39;s entries.",null,null],[11,"clone","collections::btree::map","",225,{"inputs":[{"name":"keys"}],"output":{"name":"keys"}}],[11,"len","","",225,{"inputs":[{"name":"keys"}],"output":{"name":"usize"}}],[11,"next_back","","",225,{"inputs":[{"name":"keys"}],"output":{"name":"option"}}],[11,"next","","",225,{"inputs":[{"name":"keys"}],"output":{"name":"option"}}],[11,"size_hint","","",225,null],[3,"Keys","std::collections::btree_map","An iterator over a BTreeMap&#39;s keys.",null,null],[11,"len","collections::btree::map","",226,{"inputs":[{"name":"itermut"}],"output":{"name":"usize"}}],[11,"next_back","","",226,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"next","","",226,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"size_hint","","",226,null],[3,"IterMut","std::collections::btree_map","A mutable iterator over a BTreeMap&#39;s entries.",null,null],[11,"clone","collections::btree::map","",227,{"inputs":[{"name":"range"}],"output":{"name":"range"}}],[11,"next_back","","",227,{"inputs":[{"name":"range"}],"output":{"name":"option"}}],[11,"next","","",227,{"inputs":[{"name":"range"}],"output":{"name":"option"}}],[3,"Range","std::collections::btree_map","An iterator over a sub-range of BTreeMap&#39;s entries.",null,null],[11,"key","collections::btree::map","Gets a reference to the key that would be used when inserting a value\nthrough the VacantEntry.",228,{"inputs":[{"name":"vacantentry"}],"output":{"name":"k"}}],[11,"insert","","Sets the value of the entry with the VacantEntry&#39;s key,\nand returns a mutable reference to it.",228,{"inputs":[{"name":"vacantentry"},{"name":"v"}],"output":{"name":"v"}}],[3,"VacantEntry","std::collections::btree_map","A vacant Entry.",null,null],[11,"len","collections::btree::map","",229,{"inputs":[{"name":"intoiter"}],"output":{"name":"usize"}}],[11,"next_back","","",229,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"next","","",229,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"size_hint","","",229,null],[11,"drop","","",229,null],[3,"IntoIter","std::collections::btree_map","An owning iterator over a BTreeMap&#39;s entries.",null,null],[0,"btree_set","std::collections","",null,null],[11,"clone","collections::btree::set","",230,{"inputs":[{"name":"range"}],"output":{"name":"range"}}],[11,"next_back","","",230,{"inputs":[{"name":"range"}],"output":{"name":"option"}}],[11,"next","","",230,{"inputs":[{"name":"range"}],"output":{"name":"option"}}],[3,"Range","std::collections::btree_set","An iterator over a sub-range of BTreeSet&#39;s items.",null,null],[11,"next","collections::btree::set","",231,{"inputs":[{"name":"intersection"}],"output":{"name":"option"}}],[11,"size_hint","","",231,null],[11,"clone","","",231,{"inputs":[{"name":"intersection"}],"output":{"name":"intersection"}}],[3,"Intersection","std::collections::btree_set","A lazy iterator producing elements in the set intersection (in-order).",null,null],[11,"next_back","collections::btree::set","",232,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"next","","",232,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"size_hint","","",232,null],[11,"clone","","",232,{"inputs":[{"name":"iter"}],"output":{"name":"iter"}}],[11,"len","","",232,{"inputs":[{"name":"iter"}],"output":{"name":"usize"}}],[3,"Iter","std::collections::btree_set","An iterator over a BTreeSet&#39;s items.",null,null],[11,"next","collections::btree::set","",233,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"size_hint","","",233,null],[11,"len","","",233,{"inputs":[{"name":"intoiter"}],"output":{"name":"usize"}}],[11,"next_back","","",233,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[3,"IntoIter","std::collections::btree_set","An owning iterator over a BTreeSet&#39;s items.",null,null],[11,"next","collections::btree::set","",234,{"inputs":[{"name":"union"}],"output":{"name":"option"}}],[11,"size_hint","","",234,null],[11,"clone","","",234,{"inputs":[{"name":"union"}],"output":{"name":"union"}}],[3,"Union","std::collections::btree_set","A lazy iterator producing elements in the set union (in-order).",null,null],[11,"clone","collections::btree::set","",235,{"inputs":[{"name":"symmetricdifference"}],"output":{"name":"symmetricdifference"}}],[11,"next","","",235,{"inputs":[{"name":"symmetricdifference"}],"output":{"name":"option"}}],[11,"size_hint","","",235,null],[3,"SymmetricDifference","std::collections::btree_set","A lazy iterator producing elements in the set symmetric difference (in-order).",null,null],[11,"next","collections::btree::set","",236,{"inputs":[{"name":"difference"}],"output":{"name":"option"}}],[11,"size_hint","","",236,null],[11,"clone","","",236,{"inputs":[{"name":"difference"}],"output":{"name":"difference"}}],[3,"Difference","std::collections::btree_set","A lazy iterator producing elements in the set difference (in-order).",null,null],[3,"BTreeSet","","A set based on a B-Tree.",null,null],[0,"linked_list","std::collections","A doubly-linked list with owned nodes.",null,null],[3,"LinkedList","std::collections::linked_list","A doubly-linked list.",null,null],[11,"next_back","collections::linked_list","",237,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"next","","",237,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"size_hint","","",237,null],[11,"clone","","",237,{"inputs":[{"name":"iter"}],"output":{"name":"iter"}}],[3,"Iter","std::collections::linked_list","An iterator over references to the items of a `LinkedList`.",null,null],[11,"insert_next","collections::linked_list","Inserts `elt` just after the element most recently returned by `.next()`.\nThe inserted element does not appear in the iteration.",238,null],[11,"peek_next","","Provides a reference to the next element, without changing the iterator.",238,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"next_back","","",238,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"next","","",238,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"size_hint","","",238,null],[3,"IterMut","std::collections::linked_list","An iterator over mutable references to the items of a `LinkedList`.",null,null],[11,"next","collections::linked_list","",239,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"size_hint","","",239,null],[11,"next_back","","",239,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"clone","","",239,{"inputs":[{"name":"intoiter"}],"output":{"name":"intoiter"}}],[3,"IntoIter","std::collections::linked_list","An iterator over the items of a `LinkedList`.",null,null],[11,"finalize","collections::linked_list","",240,null],[11,"pointer","","",240,null],[11,"make_place","","",240,{"inputs":[{"name":"frontplace"}],"output":{"name":"frontplace"}}],[3,"FrontPlace","std::collections::linked_list","A place for insertion at the front of a `LinkedList`.",null,null],[11,"pointer","collections::linked_list","",241,null],[11,"make_place","","",241,{"inputs":[{"name":"backplace"}],"output":{"name":"backplace"}}],[11,"finalize","","",241,null],[3,"BackPlace","std::collections::linked_list","A place for insertion at the back of a `LinkedList`.",null,null],[0,"vec_deque","std::collections","VecDeque is a double-ended queue, which is implemented with the help of a\ngrowing ring buffer.",null,null],[3,"VecDeque","std::collections::vec_deque","`VecDeque` is a growable ring buffer, which can be used as a double-ended\nqueue efficiently.",null,null],[11,"next","collections::vec_deque","",242,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"size_hint","","",242,null],[11,"next_back","","",242,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"clone","","",242,{"inputs":[{"name":"iter"}],"output":{"name":"iter"}}],[3,"Iter","std::collections::vec_deque","`VecDeque` iterator.",null,null],[11,"next_back","collections::vec_deque","",243,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"next","","",243,{"inputs":[{"name":"itermut"}],"output":{"name":"option"}}],[11,"size_hint","","",243,null],[3,"IterMut","std::collections::vec_deque","`VecDeque` mutable iterator.",null,null],[11,"next_back","collections::vec_deque","",244,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"next","","",244,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"size_hint","","",244,null],[11,"clone","","",244,{"inputs":[{"name":"intoiter"}],"output":{"name":"intoiter"}}],[3,"IntoIter","std::collections::vec_deque","A by-value VecDeque iterator",null,null],[11,"next_back","collections::vec_deque","",245,{"inputs":[{"name":"drain"}],"output":{"name":"option"}}],[11,"drop","","",245,null],[11,"next","","",245,{"inputs":[{"name":"drain"}],"output":{"name":"option"}}],[11,"size_hint","","",245,null],[3,"Drain","std::collections::vec_deque","A draining VecDeque iterator",null,null],[3,"HashMap","std::collections","A hash map implementation which uses linear probing with Robin\nHood bucket stealing.",null,null],[3,"HashSet","","An implementation of a hash set using the underlying representation of a\nHashMap where the value is ().",null,null],[11,"clone","","",246,{"inputs":[{"name":"hashmap"}],"output":{"name":"hashmap"}}],[11,"new","","Creates an empty HashMap.",246,{"inputs":[],"output":{"name":"hashmap"}}],[11,"with_capacity","","Creates an empty hash map with the given initial capacity.",246,{"inputs":[{"name":"usize"}],"output":{"name":"hashmap"}}],[11,"with_hasher","","Creates an empty hashmap which will use the given hash builder to hash\nkeys.",246,{"inputs":[{"name":"s"}],"output":{"name":"hashmap"}}],[11,"with_capacity_and_hasher","","Creates an empty HashMap with space for at least `capacity`\nelements, using `hasher` to hash the keys.",246,{"inputs":[{"name":"usize"},{"name":"s"}],"output":{"name":"hashmap"}}],[11,"hasher","","Returns a reference to the map&#39;s hasher.",246,{"inputs":[{"name":"hashmap"}],"output":{"name":"s"}}],[11,"capacity","","Returns the number of elements the map can hold without reallocating.",246,{"inputs":[{"name":"hashmap"}],"output":{"name":"usize"}}],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted\nin the `HashMap`. The collection may reserve more space to avoid\nfrequent reallocations.",246,{"inputs":[{"name":"hashmap"},{"name":"usize"}],"output":null}],[11,"shrink_to_fit","","Shrinks the capacity of the map as much as possible. It will drop\ndown as much as possible while maintaining the internal rules\nand possibly leaving some space in accordance with the resize policy.",246,{"inputs":[{"name":"hashmap"}],"output":null}],[11,"keys","","An iterator visiting all keys in arbitrary order.\nIterator element type is `&amp;&#39;a K`.",246,{"inputs":[{"name":"hashmap"}],"output":{"name":"keys"}}],[11,"values","","An iterator visiting all values in arbitrary order.\nIterator element type is `&amp;&#39;a V`.",246,{"inputs":[{"name":"hashmap"}],"output":{"name":"values"}}],[11,"values_mut","","An iterator visiting all values mutably in arbitrary order.\nIterator element type is `&amp;&#39;a mut V`.",246,{"inputs":[{"name":"hashmap"}],"output":{"name":"valuesmut"}}],[11,"iter","","An iterator visiting all key-value pairs in arbitrary order.\nIterator element type is `(&amp;&#39;a K, &amp;&#39;a V)`.",246,{"inputs":[{"name":"hashmap"}],"output":{"name":"iter"}}],[11,"iter_mut","","An iterator visiting all key-value pairs in arbitrary order,\nwith mutable references to the values.\nIterator element type is `(&amp;&#39;a K, &amp;&#39;a mut V)`.",246,{"inputs":[{"name":"hashmap"}],"output":{"name":"itermut"}}],[11,"entry","","Gets the given key&#39;s corresponding entry in the map for in-place manipulation.",246,{"inputs":[{"name":"hashmap"},{"name":"k"}],"output":{"name":"entry"}}],[11,"len","","Returns the number of elements in the map.",246,{"inputs":[{"name":"hashmap"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns true if the map contains no elements.",246,{"inputs":[{"name":"hashmap"}],"output":{"name":"bool"}}],[11,"drain","","Clears the map, returning all key-value pairs as an iterator. Keeps the\nallocated memory for reuse.",246,{"inputs":[{"name":"hashmap"}],"output":{"name":"drain"}}],[11,"clear","","Clears the map, removing all key-value pairs. Keeps the allocated memory\nfor reuse.",246,{"inputs":[{"name":"hashmap"}],"output":null}],[11,"get","","Returns a reference to the value corresponding to the key.",246,{"inputs":[{"name":"hashmap"},{"name":"q"}],"output":{"name":"option"}}],[11,"contains_key","","Returns true if the map contains a value for the specified key.",246,{"inputs":[{"name":"hashmap"},{"name":"q"}],"output":{"name":"bool"}}],[11,"get_mut","","Returns a mutable reference to the value corresponding to the key.",246,{"inputs":[{"name":"hashmap"},{"name":"q"}],"output":{"name":"option"}}],[11,"insert","","Inserts a key-value pair into the map.",246,{"inputs":[{"name":"hashmap"},{"name":"k"},{"name":"v"}],"output":{"name":"option"}}],[11,"remove","","Removes a key from the map, returning the value at the key if the key\nwas previously in the map.",246,{"inputs":[{"name":"hashmap"},{"name":"q"}],"output":{"name":"option"}}],[11,"eq","","",246,{"inputs":[{"name":"hashmap"},{"name":"hashmap"}],"output":{"name":"bool"}}],[11,"fmt","","",246,{"inputs":[{"name":"hashmap"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","",246,{"inputs":[],"output":{"name":"hashmap"}}],[11,"index","","",246,{"inputs":[{"name":"hashmap"},{"name":"q"}],"output":{"name":"v"}}],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each key-value\npair out of the map in arbitrary order. The map cannot be used after\ncalling this.",246,{"inputs":[{"name":"hashmap"}],"output":{"name":"intoiter"}}],[11,"from_iter","","",246,{"inputs":[{"name":"t"}],"output":{"name":"hashmap"}}],[11,"extend","","",246,{"inputs":[{"name":"hashmap"},{"name":"t"}],"output":null}],[11,"extend","","",246,{"inputs":[{"name":"hashmap"},{"name":"t"}],"output":null}],[11,"clone","","",247,{"inputs":[{"name":"hashset"}],"output":{"name":"hashset"}}],[11,"new","","Creates an empty HashSet.",247,{"inputs":[],"output":{"name":"hashset"}}],[11,"with_capacity","","Creates an empty HashSet with space for at least `n` elements in\nthe hash table.",247,{"inputs":[{"name":"usize"}],"output":{"name":"hashset"}}],[11,"with_hasher","","Creates a new empty hash set which will use the given hasher to hash\nkeys.",247,{"inputs":[{"name":"s"}],"output":{"name":"hashset"}}],[11,"with_capacity_and_hasher","","Creates an empty HashSet with space for at least `capacity`\nelements in the hash table, using `hasher` to hash the keys.",247,{"inputs":[{"name":"usize"},{"name":"s"}],"output":{"name":"hashset"}}],[11,"hasher","","Returns a reference to the set&#39;s hasher.",247,{"inputs":[{"name":"hashset"}],"output":{"name":"s"}}],[11,"capacity","","Returns the number of elements the set can hold without reallocating.",247,{"inputs":[{"name":"hashset"}],"output":{"name":"usize"}}],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted\nin the `HashSet`. The collection may reserve more space to avoid\nfrequent reallocations.",247,{"inputs":[{"name":"hashset"},{"name":"usize"}],"output":null}],[11,"shrink_to_fit","","Shrinks the capacity of the set as much as possible. It will drop\ndown as much as possible while maintaining the internal rules\nand possibly leaving some space in accordance with the resize policy.",247,{"inputs":[{"name":"hashset"}],"output":null}],[11,"iter","","An iterator visiting all elements in arbitrary order.\nIterator element type is &amp;&#39;a T.",247,{"inputs":[{"name":"hashset"}],"output":{"name":"iter"}}],[11,"difference","","Visit the values representing the difference.",247,{"inputs":[{"name":"hashset"},{"name":"hashset"}],"output":{"name":"difference"}}],[11,"symmetric_difference","","Visit the values representing the symmetric difference.",247,{"inputs":[{"name":"hashset"},{"name":"hashset"}],"output":{"name":"symmetricdifference"}}],[11,"intersection","","Visit the values representing the intersection.",247,{"inputs":[{"name":"hashset"},{"name":"hashset"}],"output":{"name":"intersection"}}],[11,"union","","Visit the values representing the union.",247,{"inputs":[{"name":"hashset"},{"name":"hashset"}],"output":{"name":"union"}}],[11,"len","","Returns the number of elements in the set.",247,{"inputs":[{"name":"hashset"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns true if the set contains no elements.",247,{"inputs":[{"name":"hashset"}],"output":{"name":"bool"}}],[11,"drain","","Clears the set, returning all elements in an iterator.",247,{"inputs":[{"name":"hashset"}],"output":{"name":"drain"}}],[11,"clear","","Clears the set, removing all values.",247,{"inputs":[{"name":"hashset"}],"output":null}],[11,"contains","","Returns `true` if the set contains a value.",247,{"inputs":[{"name":"hashset"},{"name":"q"}],"output":{"name":"bool"}}],[11,"get","","Returns a reference to the value in the set, if any, that is equal to the given value.",247,{"inputs":[{"name":"hashset"},{"name":"q"}],"output":{"name":"option"}}],[11,"is_disjoint","","Returns `true` if the set has no elements in common with `other`.\nThis is equivalent to checking for an empty intersection.",247,{"inputs":[{"name":"hashset"},{"name":"hashset"}],"output":{"name":"bool"}}],[11,"is_subset","","Returns `true` if the set is a subset of another.",247,{"inputs":[{"name":"hashset"},{"name":"hashset"}],"output":{"name":"bool"}}],[11,"is_superset","","Returns `true` if the set is a superset of another.",247,{"inputs":[{"name":"hashset"},{"name":"hashset"}],"output":{"name":"bool"}}],[11,"insert","","Adds a value to the set.",247,{"inputs":[{"name":"hashset"},{"name":"t"}],"output":{"name":"bool"}}],[11,"replace","","Adds a value to the set, replacing the existing value, if any, that is equal to the given\none. Returns the replaced value.",247,{"inputs":[{"name":"hashset"},{"name":"t"}],"output":{"name":"option"}}],[11,"remove","","Removes a value from the set. Returns `true` if the value was\npresent in the set.",247,{"inputs":[{"name":"hashset"},{"name":"q"}],"output":{"name":"bool"}}],[11,"take","","Removes and returns the value in the set, if any, that is equal to the given one.",247,{"inputs":[{"name":"hashset"},{"name":"q"}],"output":{"name":"option"}}],[11,"eq","","",247,{"inputs":[{"name":"hashset"},{"name":"hashset"}],"output":{"name":"bool"}}],[11,"fmt","","",247,{"inputs":[{"name":"hashset"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from_iter","","",247,{"inputs":[{"name":"i"}],"output":{"name":"hashset"}}],[11,"extend","","",247,{"inputs":[{"name":"hashset"},{"name":"i"}],"output":null}],[11,"extend","","",247,{"inputs":[{"name":"hashset"},{"name":"i"}],"output":null}],[11,"default","","",247,{"inputs":[],"output":{"name":"hashset"}}],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each value out\nof the set in arbitrary order. The set cannot be used after calling\nthis.",247,{"inputs":[{"name":"hashset"}],"output":{"name":"intoiter"}}],[0,"hash_map","","A hashmap",null,null],[3,"HashMap","std::collections::hash_map","A hash map implementation which uses linear probing with Robin\nHood bucket stealing.",null,null],[3,"Iter","","HashMap iterator.",null,null],[3,"IterMut","","HashMap mutable values iterator.",null,null],[3,"IntoIter","","HashMap move iterator.",null,null],[3,"Keys","","HashMap keys iterator.",null,null],[3,"Values","","HashMap values iterator.",null,null],[3,"Drain","","HashMap drain iterator.",null,null],[3,"ValuesMut","","Mutable HashMap values iterator.",null,null],[3,"OccupiedEntry","","A view into a single occupied location in a HashMap.",null,null],[3,"VacantEntry","","A view into a single empty location in a HashMap.",null,null],[3,"RandomState","","`RandomState` is the default state for `HashMap` types.",null,null],[4,"Entry","","A view into a single location in a map, which may be vacant or occupied.",null,null],[13,"Occupied","","An occupied Entry.",248,null],[13,"Vacant","","A vacant Entry.",248,null],[0,"hash_set","std::collections","A hashset",null,null],[3,"HashSet","std::collections::hash_set","An implementation of a hash set using the underlying representation of a\nHashMap where the value is ().",null,null],[3,"Iter","","HashSet iterator",null,null],[3,"IntoIter","","HashSet move iterator",null,null],[3,"Drain","","HashSet drain iterator",null,null],[3,"Intersection","","Intersection iterator",null,null],[3,"Difference","","Difference iterator",null,null],[3,"SymmetricDifference","","Symmetric difference iterator.",null,null],[3,"Union","","Set union iterator.",null,null],[0,"env","std","Inspection and manipulation of the process&#39;s environment.",null,null],[3,"Vars","std::env","An iterator over a snapshot of the environment variables of this process.",null,null],[3,"VarsOs","","An iterator over a snapshot of the environment variables of this process.",null,null],[3,"SplitPaths","","An iterator over `PathBuf` instances for parsing an environment variable\naccording to platform-specific conventions.",null,null],[3,"JoinPathsError","","Error type returned from `std::env::join_paths` when paths fail to be\njoined.",null,null],[3,"Args","","An iterator over the arguments of a process, yielding a `String` value\nfor each argument.",null,null],[3,"ArgsOs","","An iterator over the arguments of a process, yielding an `OsString` value\nfor each argument.",null,null],[4,"VarError","","Possible errors from the `env::var` method.",null,null],[13,"NotPresent","","The specified environment variable was not present in the current\nprocess&#39;s environment.",249,null],[13,"NotUnicode","","The specified environment variable was found, but it did not contain\nvalid unicode data. The found data is returned as a payload of this\nvariant.",249,null],[5,"current_dir","","Returns the current working directory as a `PathBuf`.",null,{"inputs":[],"output":{"name":"result"}}],[5,"set_current_dir","","Changes the current working directory to the specified path, returning\nwhether the change was completed successfully or not.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"vars","","Returns an iterator of (variable, value) pairs of strings, for all the\nenvironment variables of the current process.",null,{"inputs":[],"output":{"name":"vars"}}],[5,"vars_os","","Returns an iterator of (variable, value) pairs of OS strings, for all the\nenvironment variables of the current process.",null,{"inputs":[],"output":{"name":"varsos"}}],[5,"var","","Fetches the environment variable `key` from the current process.",null,{"inputs":[{"name":"k"}],"output":{"name":"result"}}],[5,"var_os","","Fetches the environment variable `key` from the current process, returning\n`None` if the variable isn&#39;t set.",null,{"inputs":[{"name":"k"}],"output":{"name":"option"}}],[5,"set_var","","Sets the environment variable `k` to the value `v` for the currently running\nprocess.",null,{"inputs":[{"name":"k"},{"name":"v"}],"output":null}],[5,"remove_var","","Removes an environment variable from the environment of the currently running process.",null,{"inputs":[{"name":"k"}],"output":null}],[5,"split_paths","","Parses input according to platform conventions for the `PATH`\nenvironment variable.",null,{"inputs":[{"name":"t"}],"output":{"name":"splitpaths"}}],[5,"join_paths","","Joins a collection of `Path`s appropriately for the `PATH`\nenvironment variable.",null,{"inputs":[{"name":"i"}],"output":{"name":"result"}}],[5,"home_dir","","Returns the path of the current user&#39;s home directory if known.",null,{"inputs":[],"output":{"name":"option"}}],[5,"temp_dir","","Returns the path of a temporary directory.",null,{"inputs":[],"output":{"name":"pathbuf"}}],[5,"current_exe","","Returns the full filesystem path of the current running executable.",null,{"inputs":[],"output":{"name":"result"}}],[5,"args","","Returns the arguments which this program was started with (normally passed\nvia the command line).",null,{"inputs":[],"output":{"name":"args"}}],[5,"args_os","","Returns the arguments which this program was started with (normally passed\nvia the command line).",null,{"inputs":[],"output":{"name":"argsos"}}],[0,"consts","","Constants associated with the current target",null,null],[17,"ARCH","std::env::consts","A string describing the architecture of the CPU that is currently\nin use.",null,null],[17,"FAMILY","","The family of the operating system. Example value is `unix`.",null,null],[17,"OS","","A string describing the specific operating system in use.\nExample value is `linux`.",null,null],[17,"DLL_PREFIX","","Specifies the filename prefix used for shared libraries on this\nplatform. Example value is `lib`.",null,null],[17,"DLL_SUFFIX","","Specifies the filename suffix used for shared libraries on this\nplatform. Example value is `.so`.",null,null],[17,"DLL_EXTENSION","","Specifies the file extension used for shared libraries on this\nplatform that goes after the dot. Example value is `so`.",null,null],[17,"EXE_SUFFIX","","Specifies the filename suffix used for executable binaries on this\nplatform. Example value is `.exe`.",null,null],[17,"EXE_EXTENSION","","Specifies the file extension, if any, used for executable binaries\non this platform. Example value is `exe`.",null,null],[11,"next","std::env","",250,{"inputs":[{"name":"vars"}],"output":{"name":"option"}}],[11,"size_hint","","",250,null],[11,"next","","",251,{"inputs":[{"name":"varsos"}],"output":{"name":"option"}}],[11,"size_hint","","",251,null],[11,"clone","","",249,{"inputs":[{"name":"varerror"}],"output":{"name":"varerror"}}],[11,"eq","","",249,{"inputs":[{"name":"varerror"},{"name":"varerror"}],"output":{"name":"bool"}}],[11,"ne","","",249,{"inputs":[{"name":"varerror"},{"name":"varerror"}],"output":{"name":"bool"}}],[11,"fmt","","",249,{"inputs":[{"name":"varerror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",249,{"inputs":[{"name":"varerror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",249,{"inputs":[{"name":"varerror"}],"output":{"name":"str"}}],[11,"next","","",252,{"inputs":[{"name":"splitpaths"}],"output":{"name":"option"}}],[11,"size_hint","","",252,null],[11,"fmt","","",253,{"inputs":[{"name":"joinpathserror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",253,{"inputs":[{"name":"joinpathserror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",253,{"inputs":[{"name":"joinpathserror"}],"output":{"name":"str"}}],[11,"next","","",254,{"inputs":[{"name":"args"}],"output":{"name":"option"}}],[11,"size_hint","","",254,null],[11,"len","","",254,{"inputs":[{"name":"args"}],"output":{"name":"usize"}}],[11,"next","","",255,{"inputs":[{"name":"argsos"}],"output":{"name":"option"}}],[11,"size_hint","","",255,null],[11,"len","","",255,{"inputs":[{"name":"argsos"}],"output":{"name":"usize"}}],[0,"ffi","std","Utilities related to FFI bindings.",null,null],[3,"CString","std::ffi","A type representing an owned C-compatible string",null,null],[3,"CStr","","Representation of a borrowed C string.",null,null],[3,"NulError","","An error returned from `CString::new` to indicate that a nul byte was found\nin the vector provided.",null,null],[3,"IntoStringError","","An error returned from `CString::into_string` to indicate that a UTF-8 error\nwas encountered during the conversion.",null,null],[3,"OsString","","A type that can represent owned, mutable platform-native strings, but is\ncheaply inter-convertible with Rust strings.",null,null],[3,"OsStr","","Slices into OS strings (see `OsString`).",null,null],[11,"clone","","",256,{"inputs":[{"name":"cstring"}],"output":{"name":"cstring"}}],[11,"hash","","",256,null],[11,"cmp","","",256,{"inputs":[{"name":"cstring"},{"name":"cstring"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",256,{"inputs":[{"name":"cstring"},{"name":"cstring"}],"output":{"name":"option"}}],[11,"lt","","",256,{"inputs":[{"name":"cstring"},{"name":"cstring"}],"output":{"name":"bool"}}],[11,"le","","",256,{"inputs":[{"name":"cstring"},{"name":"cstring"}],"output":{"name":"bool"}}],[11,"gt","","",256,{"inputs":[{"name":"cstring"},{"name":"cstring"}],"output":{"name":"bool"}}],[11,"ge","","",256,{"inputs":[{"name":"cstring"},{"name":"cstring"}],"output":{"name":"bool"}}],[11,"eq","","",256,{"inputs":[{"name":"cstring"},{"name":"cstring"}],"output":{"name":"bool"}}],[11,"ne","","",256,{"inputs":[{"name":"cstring"},{"name":"cstring"}],"output":{"name":"bool"}}],[11,"hash","","",257,null],[11,"fmt","","",258,{"inputs":[{"name":"nulerror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",258,{"inputs":[{"name":"nulerror"},{"name":"nulerror"}],"output":{"name":"bool"}}],[11,"ne","","",258,{"inputs":[{"name":"nulerror"},{"name":"nulerror"}],"output":{"name":"bool"}}],[11,"clone","","",258,{"inputs":[{"name":"nulerror"}],"output":{"name":"nulerror"}}],[11,"fmt","","",259,{"inputs":[{"name":"intostringerror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",259,{"inputs":[{"name":"intostringerror"},{"name":"intostringerror"}],"output":{"name":"bool"}}],[11,"ne","","",259,{"inputs":[{"name":"intostringerror"},{"name":"intostringerror"}],"output":{"name":"bool"}}],[11,"clone","","",259,{"inputs":[{"name":"intostringerror"}],"output":{"name":"intostringerror"}}],[11,"new","","Creates a new C-compatible string from a container of bytes.",256,{"inputs":[{"name":"t"}],"output":{"name":"result"}}],[11,"from_vec_unchecked","","Creates a C-compatible string from a byte vector without checking for\ninterior 0 bytes.",256,{"inputs":[{"name":"vec"}],"output":{"name":"cstring"}}],[11,"from_raw","","Retakes ownership of a `CString` that was transferred to C.",256,null],[11,"into_raw","","Transfers ownership of the string to a C caller.",256,null],[11,"into_string","","Converts the `CString` into a `String` if it contains valid Unicode data.",256,{"inputs":[{"name":"cstring"}],"output":{"name":"result"}}],[11,"into_bytes","","Returns the underlying byte buffer.",256,{"inputs":[{"name":"cstring"}],"output":{"name":"vec"}}],[11,"into_bytes_with_nul","","Equivalent to the `into_bytes` function except that the returned vector\nincludes the trailing nul byte.",256,{"inputs":[{"name":"cstring"}],"output":{"name":"vec"}}],[11,"as_bytes","","Returns the contents of this `CString` as a slice of bytes.",256,null],[11,"as_bytes_with_nul","","Equivalent to the `as_bytes` function except that the returned slice\nincludes the trailing nul byte.",256,null],[11,"deref","","",256,{"inputs":[{"name":"cstring"}],"output":{"name":"cstr"}}],[11,"fmt","","",256,{"inputs":[{"name":"cstring"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","std::vec","",182,{"inputs":[{"name":"cstring"}],"output":{"name":"vec"}}],[11,"fmt","std::ffi","",257,{"inputs":[{"name":"cstr"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"borrow","","",256,{"inputs":[{"name":"cstring"}],"output":{"name":"cstr"}}],[11,"nul_position","","Returns the position of the nul byte in the slice that was provided to\n`CString::new`.",258,{"inputs":[{"name":"nulerror"}],"output":{"name":"usize"}}],[11,"into_vec","","Consumes this error, returning the underlying vector of bytes which\ngenerated the error in the first place.",258,{"inputs":[{"name":"nulerror"}],"output":{"name":"vec"}}],[11,"description","","",258,{"inputs":[{"name":"nulerror"}],"output":{"name":"str"}}],[11,"fmt","","",258,{"inputs":[{"name":"nulerror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"into_cstring","","Consumes this error, returning original `CString` which generated the\nerror.",259,{"inputs":[{"name":"intostringerror"}],"output":{"name":"cstring"}}],[11,"utf8_error","","Access the underlying UTF-8 error that was the cause of this error.",259,{"inputs":[{"name":"intostringerror"}],"output":{"name":"utf8error"}}],[11,"description","","",259,{"inputs":[{"name":"intostringerror"}],"output":{"name":"str"}}],[11,"cause","","",259,{"inputs":[{"name":"intostringerror"}],"output":{"name":"option"}}],[11,"fmt","","",259,{"inputs":[{"name":"intostringerror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from_ptr","","Casts a raw C string to a safe C string wrapper.",257,null],[11,"from_bytes_with_nul","","Creates a C string wrapper from a byte slice.",257,null],[11,"from_bytes_with_nul_unchecked","","Unsafely creates a C string wrapper from a byte slice.",257,null],[11,"as_ptr","","Returns the inner pointer to this C string.",257,null],[11,"to_bytes","","Converts this C string to a byte slice.",257,null],[11,"to_bytes_with_nul","","Converts this C string to a byte slice containing the trailing 0 byte.",257,null],[11,"to_str","","Yields a `&amp;str` slice if the `CStr` contains valid UTF-8.",257,{"inputs":[{"name":"cstr"}],"output":{"name":"result"}}],[11,"to_string_lossy","","Converts a `CStr` into a `Cow&lt;str&gt;`.",257,{"inputs":[{"name":"cstr"}],"output":{"name":"cow"}}],[11,"eq","","",257,{"inputs":[{"name":"cstr"},{"name":"cstr"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",257,{"inputs":[{"name":"cstr"},{"name":"cstr"}],"output":{"name":"option"}}],[11,"cmp","","",257,{"inputs":[{"name":"cstr"},{"name":"cstr"}],"output":{"name":"ordering"}}],[11,"to_owned","","",257,{"inputs":[{"name":"cstr"}],"output":{"name":"cstring"}}],[11,"from","","",256,{"inputs":[{"name":"cstr"}],"output":{"name":"cstring"}}],[11,"index","","",256,{"inputs":[{"name":"cstring"},{"name":"rangefull"}],"output":{"name":"cstr"}}],[11,"as_ref","","",257,{"inputs":[{"name":"cstr"}],"output":{"name":"cstr"}}],[11,"as_ref","","",256,{"inputs":[{"name":"cstring"}],"output":{"name":"cstr"}}],[11,"clone","","",260,{"inputs":[{"name":"osstring"}],"output":{"name":"osstring"}}],[11,"new","","Constructs a new empty `OsString`.",260,{"inputs":[],"output":{"name":"osstring"}}],[11,"as_os_str","","Converts to an `OsStr` slice.",260,{"inputs":[{"name":"osstring"}],"output":{"name":"osstr"}}],[11,"into_string","","Converts the `OsString` into a `String` if it contains valid Unicode data.",260,{"inputs":[{"name":"osstring"}],"output":{"name":"result"}}],[11,"push","","Extends the string with the given `&amp;OsStr` slice.",260,{"inputs":[{"name":"osstring"},{"name":"t"}],"output":null}],[11,"with_capacity","","Creates a new `OsString` with the given capacity.",260,{"inputs":[{"name":"usize"}],"output":{"name":"osstring"}}],[11,"clear","","Truncates the `OsString` to zero length.",260,{"inputs":[{"name":"osstring"}],"output":null}],[11,"capacity","","Returns the capacity this `OsString` can hold without reallocating.",260,{"inputs":[{"name":"osstring"}],"output":{"name":"usize"}}],[11,"reserve","","Reserves capacity for at least `additional` more capacity to be inserted\nin the given `OsString`.",260,{"inputs":[{"name":"osstring"},{"name":"usize"}],"output":null}],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more capacity to\nbe inserted in the given `OsString`. Does nothing if the capacity is\nalready sufficient.",260,{"inputs":[{"name":"osstring"},{"name":"usize"}],"output":null}],[11,"from","","",260,{"inputs":[{"name":"string"}],"output":{"name":"osstring"}}],[11,"from","","",260,{"inputs":[{"name":"t"}],"output":{"name":"osstring"}}],[11,"index","","",260,{"inputs":[{"name":"osstring"},{"name":"rangefull"}],"output":{"name":"osstr"}}],[11,"deref","","",260,{"inputs":[{"name":"osstring"}],"output":{"name":"osstr"}}],[11,"default","","",260,{"inputs":[],"output":{"name":"osstring"}}],[11,"fmt","","",260,{"inputs":[{"name":"osstring"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",260,{"inputs":[{"name":"osstring"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"eq","","",260,{"inputs":[{"name":"osstring"},{"name":"str"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",260,{"inputs":[{"name":"osstring"},{"name":"osstring"}],"output":{"name":"option"}}],[11,"lt","","",260,{"inputs":[{"name":"osstring"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"le","","",260,{"inputs":[{"name":"osstring"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"gt","","",260,{"inputs":[{"name":"osstring"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"ge","","",260,{"inputs":[{"name":"osstring"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",260,{"inputs":[{"name":"osstring"},{"name":"str"}],"output":{"name":"option"}}],[11,"cmp","","",260,{"inputs":[{"name":"osstring"},{"name":"osstring"}],"output":{"name":"ordering"}}],[11,"hash","","",260,{"inputs":[{"name":"osstring"},{"name":"h"}],"output":null}],[11,"new","","Coerces into an `OsStr` slice.",261,{"inputs":[{"name":"s"}],"output":{"name":"osstr"}}],[11,"to_str","","Yields a `&amp;str` slice if the `OsStr` is valid Unicode.",261,{"inputs":[{"name":"osstr"}],"output":{"name":"option"}}],[11,"to_string_lossy","","Converts an `OsStr` to a `Cow&lt;str&gt;`.",261,{"inputs":[{"name":"osstr"}],"output":{"name":"cow"}}],[11,"to_os_string","","Copies the slice into an owned `OsString`.",261,{"inputs":[{"name":"osstr"}],"output":{"name":"osstring"}}],[11,"is_empty","","Checks whether the `OsStr` is empty.",261,{"inputs":[{"name":"osstr"}],"output":{"name":"bool"}}],[11,"len","","Returns the length of this `OsStr`.",261,{"inputs":[{"name":"osstr"}],"output":{"name":"usize"}}],[11,"eq","","",261,{"inputs":[{"name":"osstr"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"eq","","",261,{"inputs":[{"name":"osstr"},{"name":"str"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",261,{"inputs":[{"name":"osstr"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"lt","","",261,{"inputs":[{"name":"osstr"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"le","","",261,{"inputs":[{"name":"osstr"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"gt","","",261,{"inputs":[{"name":"osstr"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"ge","","",261,{"inputs":[{"name":"osstr"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",261,{"inputs":[{"name":"osstr"},{"name":"str"}],"output":{"name":"option"}}],[11,"cmp","","",261,{"inputs":[{"name":"osstr"},{"name":"osstr"}],"output":{"name":"ordering"}}],[11,"eq","","",260,{"inputs":[{"name":"osstring"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"eq","","",261,{"inputs":[{"name":"osstr"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",260,{"inputs":[{"name":"osstring"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"partial_cmp","","",261,{"inputs":[{"name":"osstr"},{"name":"osstring"}],"output":{"name":"option"}}],[11,"eq","","",260,{"inputs":[{"name":"osstring"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",260,{"inputs":[{"name":"osstring"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"eq","std::borrow","",114,{"inputs":[{"name":"cow"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"eq","std::ffi","",261,{"inputs":[{"name":"osstr"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::borrow","",114,{"inputs":[{"name":"cow"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"partial_cmp","std::ffi","",261,{"inputs":[{"name":"osstr"},{"name":"cow"}],"output":{"name":"option"}}],[11,"eq","std::borrow","",114,{"inputs":[{"name":"cow"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",114,{"inputs":[{"name":"cow"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"eq","","",114,{"inputs":[{"name":"cow"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"eq","std::ffi","",260,{"inputs":[{"name":"osstring"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::borrow","",114,{"inputs":[{"name":"cow"},{"name":"osstring"}],"output":{"name":"option"}}],[11,"partial_cmp","std::ffi","",260,{"inputs":[{"name":"osstring"},{"name":"cow"}],"output":{"name":"option"}}],[11,"hash","","",261,{"inputs":[{"name":"osstr"},{"name":"h"}],"output":null}],[11,"fmt","","",261,{"inputs":[{"name":"osstr"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"borrow","","",260,{"inputs":[{"name":"osstring"}],"output":{"name":"osstr"}}],[11,"to_owned","","",261,{"inputs":[{"name":"osstr"}],"output":{"name":"osstring"}}],[11,"as_ref","","",261,{"inputs":[{"name":"osstr"}],"output":{"name":"osstr"}}],[11,"as_ref","","",260,{"inputs":[{"name":"osstring"}],"output":{"name":"osstr"}}],[11,"as_ref","std::string","",176,{"inputs":[{"name":"string"}],"output":{"name":"osstr"}}],[0,"fs","std","Filesystem manipulation operations.",null,null],[3,"File","std::fs","A reference to an open file on the filesystem.",null,null],[3,"Metadata","","Metadata information about a file.",null,null],[3,"ReadDir","","Iterator over the entries in a directory.",null,null],[3,"DirEntry","","Entries returned by the `ReadDir` iterator.",null,null],[3,"OpenOptions","","Options and flags which can be used to configure how a file is opened.",null,null],[3,"Permissions","","Representation of the various permissions on a file.",null,null],[3,"FileType","","An structure representing a type of file with accessors for each file type.",null,null],[3,"DirBuilder","","A builder used to create directories in various manners.",null,null],[5,"remove_file","","Removes a file from the filesystem.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"metadata","","Given a path, query the file system to get information about a file,\ndirectory, etc.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"symlink_metadata","","Query the metadata about a file without following symlinks.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"rename","","Rename a file or directory to a new name.",null,{"inputs":[{"name":"p"},{"name":"q"}],"output":{"name":"result"}}],[5,"copy","","Copies the contents of one file to another. This function will also\ncopy the permission bits of the original file to the destination file.",null,{"inputs":[{"name":"p"},{"name":"q"}],"output":{"name":"result"}}],[5,"hard_link","","Creates a new hard link on the filesystem.",null,{"inputs":[{"name":"p"},{"name":"q"}],"output":{"name":"result"}}],[5,"soft_link","","Creates a new symbolic link on the filesystem.",null,{"inputs":[{"name":"p"},{"name":"q"}],"output":{"name":"result"}}],[5,"read_link","","Reads a symbolic link, returning the file that the link points to.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"canonicalize","","Returns the canonical form of a path with all intermediate components\nnormalized and symbolic links resolved.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"create_dir","","Creates a new, empty directory at the provided path",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"create_dir_all","","Recursively create a directory and all of its parent components if they\nare missing.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"remove_dir","","Removes an existing, empty directory.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"remove_dir_all","","Removes a directory at this path, after removing all its contents. Use\ncarefully!",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"read_dir","","Returns an iterator over the entries within a directory.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"set_permissions","","Changes the permissions found on a file or a directory.",null,{"inputs":[{"name":"p"},{"name":"permissions"}],"output":{"name":"result"}}],[11,"clone","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"metadata"}}],[11,"clone","","",263,{"inputs":[{"name":"openoptions"}],"output":{"name":"openoptions"}}],[11,"fmt","","",264,{"inputs":[{"name":"permissions"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",264,{"inputs":[{"name":"permissions"},{"name":"permissions"}],"output":{"name":"bool"}}],[11,"ne","","",264,{"inputs":[{"name":"permissions"},{"name":"permissions"}],"output":{"name":"bool"}}],[11,"clone","","",264,{"inputs":[{"name":"permissions"}],"output":{"name":"permissions"}}],[11,"hash","","",265,null],[11,"eq","","",265,{"inputs":[{"name":"filetype"},{"name":"filetype"}],"output":{"name":"bool"}}],[11,"ne","","",265,{"inputs":[{"name":"filetype"},{"name":"filetype"}],"output":{"name":"bool"}}],[11,"clone","","",265,{"inputs":[{"name":"filetype"}],"output":{"name":"filetype"}}],[11,"open","","Attempts to open a file in read-only mode.",266,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[11,"create","","Opens a file in write-only mode.",266,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[11,"sync_all","","Attempts to sync all OS-internal metadata to disk.",266,{"inputs":[{"name":"file"}],"output":{"name":"result"}}],[11,"sync_data","","This function is similar to `sync_all`, except that it may not\nsynchronize file metadata to the filesystem.",266,{"inputs":[{"name":"file"}],"output":{"name":"result"}}],[11,"set_len","","Truncates or extends the underlying file, updating the size of\nthis file to become `size`.",266,{"inputs":[{"name":"file"},{"name":"u64"}],"output":{"name":"result"}}],[11,"metadata","","Queries metadata about the underlying file.",266,{"inputs":[{"name":"file"}],"output":{"name":"result"}}],[11,"try_clone","","Creates a new independently owned handle to the underlying file.",266,{"inputs":[{"name":"file"}],"output":{"name":"result"}}],[11,"fmt","","",266,{"inputs":[{"name":"file"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"read","","",266,null],[11,"read_to_end","","",266,{"inputs":[{"name":"file"},{"name":"vec"}],"output":{"name":"result"}}],[11,"write","","",266,null],[11,"flush","","",266,{"inputs":[{"name":"file"}],"output":{"name":"result"}}],[11,"seek","","",266,{"inputs":[{"name":"file"},{"name":"seekfrom"}],"output":{"name":"result"}}],[11,"new","","Creates a blank new set of options ready for configuration.",263,{"inputs":[],"output":{"name":"openoptions"}}],[11,"read","","Sets the option for read access.",263,{"inputs":[{"name":"openoptions"},{"name":"bool"}],"output":{"name":"openoptions"}}],[11,"write","","Sets the option for write access.",263,{"inputs":[{"name":"openoptions"},{"name":"bool"}],"output":{"name":"openoptions"}}],[11,"append","","Sets the option for the append mode.",263,{"inputs":[{"name":"openoptions"},{"name":"bool"}],"output":{"name":"openoptions"}}],[11,"truncate","","Sets the option for truncating a previous file.",263,{"inputs":[{"name":"openoptions"},{"name":"bool"}],"output":{"name":"openoptions"}}],[11,"create","","Sets the option for creating a new file.",263,{"inputs":[{"name":"openoptions"},{"name":"bool"}],"output":{"name":"openoptions"}}],[11,"create_new","","Sets the option to always create a new file.",263,{"inputs":[{"name":"openoptions"},{"name":"bool"}],"output":{"name":"openoptions"}}],[11,"open","","Opens a file at `path` with the options specified by `self`.",263,{"inputs":[{"name":"openoptions"},{"name":"p"}],"output":{"name":"result"}}],[11,"file_type","","Returns the file type for this metadata.",262,{"inputs":[{"name":"metadata"}],"output":{"name":"filetype"}}],[11,"is_dir","","Returns whether this metadata is for a directory.",262,{"inputs":[{"name":"metadata"}],"output":{"name":"bool"}}],[11,"is_file","","Returns whether this metadata is for a regular file.",262,{"inputs":[{"name":"metadata"}],"output":{"name":"bool"}}],[11,"len","","Returns the size of the file, in bytes, this metadata is for.",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u64"}}],[11,"permissions","","Returns the permissions of the file this metadata is for.",262,{"inputs":[{"name":"metadata"}],"output":{"name":"permissions"}}],[11,"modified","","Returns the last modification time listed in this metadata.",262,{"inputs":[{"name":"metadata"}],"output":{"name":"result"}}],[11,"accessed","","Returns the last access time of this metadata.",262,{"inputs":[{"name":"metadata"}],"output":{"name":"result"}}],[11,"created","","Returns the creation time listed in the this metadata.",262,{"inputs":[{"name":"metadata"}],"output":{"name":"result"}}],[11,"readonly","","Returns whether these permissions describe a readonly file.",264,{"inputs":[{"name":"permissions"}],"output":{"name":"bool"}}],[11,"set_readonly","","Modifies the readonly flag for this set of permissions.",264,{"inputs":[{"name":"permissions"},{"name":"bool"}],"output":null}],[11,"is_dir","","Test whether this file type represents a directory.",265,{"inputs":[{"name":"filetype"}],"output":{"name":"bool"}}],[11,"is_file","","Test whether this file type represents a regular file.",265,{"inputs":[{"name":"filetype"}],"output":{"name":"bool"}}],[11,"is_symlink","","Test whether this file type represents a symbolic link.",265,{"inputs":[{"name":"filetype"}],"output":{"name":"bool"}}],[11,"next","","",267,{"inputs":[{"name":"readdir"}],"output":{"name":"option"}}],[11,"path","","Returns the full path to the file that this entry represents.",268,{"inputs":[{"name":"direntry"}],"output":{"name":"pathbuf"}}],[11,"metadata","","Return the metadata for the file that this entry points at.",268,{"inputs":[{"name":"direntry"}],"output":{"name":"result"}}],[11,"file_type","","Return the file type for the file that this entry points at.",268,{"inputs":[{"name":"direntry"}],"output":{"name":"result"}}],[11,"file_name","","Returns the bare file name of this directory entry without any other\nleading path component.",268,{"inputs":[{"name":"direntry"}],"output":{"name":"osstring"}}],[11,"new","","Creates a new set of options with default mode/security settings for all\nplatforms and also non-recursive.",269,{"inputs":[],"output":{"name":"dirbuilder"}}],[11,"recursive","","Indicate that directories create should be created recursively, creating\nall parent directories if they do not exist with the same security and\npermissions settings.",269,{"inputs":[{"name":"dirbuilder"},{"name":"bool"}],"output":{"name":"self"}}],[11,"create","","Create the specified directory with the options configured in this\nbuilder.",269,{"inputs":[{"name":"dirbuilder"},{"name":"p"}],"output":{"name":"result"}}],[0,"io","std","Traits, helpers, and type definitions for core I/O functionality.",null,null],[3,"BufReader","std::io","The `BufReader` struct adds buffering to any reader.",null,null],[3,"BufWriter","","Wraps a writer and buffers its output.",null,null],[3,"LineWriter","","Wraps a writer and buffers output to it, flushing whenever a newline\n(`0x0a`, `&#39;\\n&#39;`) is detected.",null,null],[3,"IntoInnerError","","An error returned by `into_inner` which combines an error that\nhappened while writing out the buffer, and the buffered writer object\nwhich may be used to recover from the condition.",null,null],[3,"Cursor","","A `Cursor` wraps another type and provides it with a\n[`Seek`](trait.Seek.html) implementation.",null,null],[3,"Error","","The error type for I/O operations of the `Read`, `Write`, `Seek`, and\nassociated traits.",null,null],[3,"Sink","","A writer which will move data into the void.",null,null],[3,"Empty","","A reader which is always at EOF.",null,null],[3,"Repeat","","A reader which yields one byte over and over and over and over and over and...",null,null],[3,"Stdin","","A handle to the standard input stream of a process.",null,null],[3,"Stdout","","A handle to the global standard output stream of the current process.",null,null],[3,"Stderr","","A handle to the standard error stream of a process.",null,null],[3,"StdoutLock","","A locked reference to the `Stdout` handle.",null,null],[3,"StderrLock","","A locked reference to the `Stderr` handle.",null,null],[3,"StdinLock","","A locked reference to the `Stdin` handle.",null,null],[3,"Chain","","Adaptor to chain together two readers.",null,null],[3,"Take","","Reader adaptor which limits the bytes read from an underlying reader.",null,null],[3,"Bytes","","An iterator over `u8` values of a reader.",null,null],[3,"Chars","","An iterator over the `char`s of a reader.",null,null],[3,"Split","","An iterator over the contents of an instance of `BufRead` split on a\nparticular byte.",null,null],[3,"Lines","","An iterator over the lines of an instance of `BufRead`.",null,null],[4,"ErrorKind","","A list specifying general categories of I/O error.",null,null],[13,"NotFound","","An entity was not found, often a file.",270,null],[13,"PermissionDenied","","The operation lacked the necessary privileges to complete.",270,null],[13,"ConnectionRefused","","The connection was refused by the remote server.",270,null],[13,"ConnectionReset","","The connection was reset by the remote server.",270,null],[13,"ConnectionAborted","","The connection was aborted (terminated) by the remote server.",270,null],[13,"NotConnected","","The network operation failed because it was not connected yet.",270,null],[13,"AddrInUse","","A socket address could not be bound because the address is already in\nuse elsewhere.",270,null],[13,"AddrNotAvailable","","A nonexistent interface was requested or the requested address was not\nlocal.",270,null],[13,"BrokenPipe","","The operation failed because a pipe was closed.",270,null],[13,"AlreadyExists","","An entity already exists, often a file.",270,null],[13,"WouldBlock","","The operation needs to block to complete, but the blocking operation was\nrequested to not occur.",270,null],[13,"InvalidInput","","A parameter was incorrect.",270,null],[13,"InvalidData","","Data not valid for the operation were encountered.",270,null],[13,"TimedOut","","The I/O operation&#39;s timeout expired, causing it to be canceled.",270,null],[13,"WriteZero","","An error returned when an operation could not be completed because a\ncall to `write` returned `Ok(0)`.",270,null],[13,"Interrupted","","This operation was interrupted.",270,null],[13,"Other","","Any I/O error not part of this list.",270,null],[13,"UnexpectedEof","","An error returned when an operation could not be completed because an\n&quot;end of file&quot; was reached prematurely.",270,null],[4,"SeekFrom","","Enumeration of possible methods to seek within an I/O object.",null,null],[13,"Start","","Set the offset to the provided number of bytes.",271,null],[13,"End","","Set the offset to the size of this object plus the specified number of\nbytes.",271,null],[13,"Current","","Set the offset to the current position plus the specified number of\nbytes.",271,null],[4,"CharsError","","An enumeration of possible errors that can be generated from the `Chars`\nadapter.",null,null],[13,"NotUtf8","","Variant representing that the underlying stream was read successfully\nbut it did not contain valid utf8 data.",272,null],[13,"Other","","Variant representing that an I/O error occurred.",272,null],[5,"copy","","Copies the entire contents of a reader into a writer.",null,{"inputs":[{"name":"r"},{"name":"w"}],"output":{"name":"result"}}],[5,"sink","","Creates an instance of a writer which will successfully consume all data.",null,{"inputs":[],"output":{"name":"sink"}}],[5,"empty","","Constructs a new handle to an empty reader.",null,{"inputs":[],"output":{"name":"empty"}}],[5,"repeat","","Creates an instance of a reader that infinitely repeats one byte.",null,{"inputs":[{"name":"u8"}],"output":{"name":"repeat"}}],[5,"stdin","","Constructs a new handle to the standard input of the current process.",null,{"inputs":[],"output":{"name":"stdin"}}],[5,"stdout","","Constructs a new handle to the standard output of the current process.",null,{"inputs":[],"output":{"name":"stdout"}}],[5,"stderr","","Constructs a new handle to the standard error of the current process.",null,{"inputs":[],"output":{"name":"stderr"}}],[0,"prelude","","The I/O Prelude",null,null],[11,"new","","Creates a new `BufReader` with a default buffer capacity.",273,{"inputs":[{"name":"r"}],"output":{"name":"bufreader"}}],[11,"with_capacity","","Creates a new `BufReader` with the specified buffer capacity.",273,{"inputs":[{"name":"usize"},{"name":"r"}],"output":{"name":"bufreader"}}],[11,"get_ref","","Gets a reference to the underlying reader.",273,{"inputs":[{"name":"bufreader"}],"output":{"name":"r"}}],[11,"get_mut","","Gets a mutable reference to the underlying reader.",273,{"inputs":[{"name":"bufreader"}],"output":{"name":"r"}}],[11,"into_inner","","Unwraps this `BufReader`, returning the underlying reader.",273,{"inputs":[{"name":"bufreader"}],"output":{"name":"r"}}],[11,"read","","",273,null],[11,"fill_buf","","",273,{"inputs":[{"name":"bufreader"}],"output":{"name":"result"}}],[11,"consume","","",273,{"inputs":[{"name":"bufreader"},{"name":"usize"}],"output":null}],[11,"fmt","","",273,{"inputs":[{"name":"bufreader"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"seek","","Seek to an offset, in bytes, in the underlying reader.",273,{"inputs":[{"name":"bufreader"},{"name":"seekfrom"}],"output":{"name":"result"}}],[11,"fmt","","",274,{"inputs":[{"name":"intoinnererror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new `BufWriter` with a default buffer capacity.",275,{"inputs":[{"name":"w"}],"output":{"name":"bufwriter"}}],[11,"with_capacity","","Creates a new `BufWriter` with the specified buffer capacity.",275,{"inputs":[{"name":"usize"},{"name":"w"}],"output":{"name":"bufwriter"}}],[11,"get_ref","","Gets a reference to the underlying writer.",275,{"inputs":[{"name":"bufwriter"}],"output":{"name":"w"}}],[11,"get_mut","","Gets a mutable reference to the underlying writer.",275,{"inputs":[{"name":"bufwriter"}],"output":{"name":"w"}}],[11,"into_inner","","Unwraps this `BufWriter`, returning the underlying writer.",275,{"inputs":[{"name":"bufwriter"}],"output":{"name":"result"}}],[11,"write","","",275,null],[11,"flush","","",275,{"inputs":[{"name":"bufwriter"}],"output":{"name":"result"}}],[11,"fmt","","",275,{"inputs":[{"name":"bufwriter"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"seek","","Seek to the offset, in bytes, in the underlying writer.",275,{"inputs":[{"name":"bufwriter"},{"name":"seekfrom"}],"output":{"name":"result"}}],[11,"drop","","",275,{"inputs":[{"name":"bufwriter"}],"output":null}],[11,"error","","Returns the error which caused the call to `into_inner()` to fail.",274,{"inputs":[{"name":"intoinnererror"}],"output":{"name":"error"}}],[11,"into_inner","","Returns the buffered writer instance which generated the error.",274,{"inputs":[{"name":"intoinnererror"}],"output":{"name":"w"}}],[11,"from","","",276,{"inputs":[{"name":"intoinnererror"}],"output":{"name":"error"}}],[11,"description","","",274,{"inputs":[{"name":"intoinnererror"}],"output":{"name":"str"}}],[11,"fmt","","",274,{"inputs":[{"name":"intoinnererror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new `LineWriter`.",277,{"inputs":[{"name":"w"}],"output":{"name":"linewriter"}}],[11,"with_capacity","","Creates a new `LineWriter` with a specified capacity for the internal\nbuffer.",277,{"inputs":[{"name":"usize"},{"name":"w"}],"output":{"name":"linewriter"}}],[11,"get_ref","","Gets a reference to the underlying writer.",277,{"inputs":[{"name":"linewriter"}],"output":{"name":"w"}}],[11,"get_mut","","Gets a mutable reference to the underlying writer.",277,{"inputs":[{"name":"linewriter"}],"output":{"name":"w"}}],[11,"into_inner","","Unwraps this `LineWriter`, returning the underlying writer.",277,{"inputs":[{"name":"linewriter"}],"output":{"name":"result"}}],[11,"write","","",277,null],[11,"flush","","",277,{"inputs":[{"name":"linewriter"}],"output":{"name":"result"}}],[11,"fmt","","",277,{"inputs":[{"name":"linewriter"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",278,{"inputs":[{"name":"cursor"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",278,{"inputs":[{"name":"cursor"}],"output":{"name":"cursor"}}],[11,"new","","Creates a new cursor wrapping the provided underlying I/O object.",278,{"inputs":[{"name":"t"}],"output":{"name":"cursor"}}],[11,"into_inner","","Consumes this cursor, returning the underlying value.",278,{"inputs":[{"name":"cursor"}],"output":{"name":"t"}}],[11,"get_ref","","Gets a reference to the underlying value in this cursor.",278,{"inputs":[{"name":"cursor"}],"output":{"name":"t"}}],[11,"get_mut","","Gets a mutable reference to the underlying value in this cursor.",278,{"inputs":[{"name":"cursor"}],"output":{"name":"t"}}],[11,"position","","Returns the current position of this cursor.",278,{"inputs":[{"name":"cursor"}],"output":{"name":"u64"}}],[11,"set_position","","Sets the position of this cursor.",278,{"inputs":[{"name":"cursor"},{"name":"u64"}],"output":null}],[11,"seek","","",278,{"inputs":[{"name":"cursor"},{"name":"seekfrom"}],"output":{"name":"result"}}],[11,"read","","",278,null],[11,"fill_buf","","",278,{"inputs":[{"name":"cursor"}],"output":{"name":"result"}}],[11,"consume","","",278,{"inputs":[{"name":"cursor"},{"name":"usize"}],"output":null}],[11,"write","","",278,null],[11,"flush","","",278,{"inputs":[{"name":"cursor"}],"output":{"name":"result"}}],[11,"write","","",278,null],[11,"flush","","",278,{"inputs":[{"name":"cursor"}],"output":{"name":"result"}}],[11,"write","","",278,null],[11,"flush","","",278,{"inputs":[{"name":"cursor"}],"output":{"name":"result"}}],[11,"fmt","","",276,{"inputs":[{"name":"error"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",270,{"inputs":[{"name":"errorkind"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",270,{"inputs":[{"name":"errorkind"}],"output":{"name":"errorkind"}}],[11,"eq","","",270,{"inputs":[{"name":"errorkind"},{"name":"errorkind"}],"output":{"name":"bool"}}],[11,"new","","Creates a new I/O error from a known kind of error as well as an\narbitrary error payload.",276,{"inputs":[{"name":"errorkind"},{"name":"e"}],"output":{"name":"error"}}],[11,"last_os_error","","Returns an error representing the last OS error which occurred.",276,{"inputs":[],"output":{"name":"error"}}],[11,"from_raw_os_error","","Creates a new instance of an `Error` from a particular OS error code.",276,{"inputs":[{"name":"i32"}],"output":{"name":"error"}}],[11,"raw_os_error","","Returns the OS error that this error represents (if any).",276,{"inputs":[{"name":"error"}],"output":{"name":"option"}}],[11,"get_ref","","Returns a reference to the inner error wrapped by this error (if any).",276,{"inputs":[{"name":"error"}],"output":{"name":"option"}}],[11,"get_mut","","Returns a mutable reference to the inner error wrapped by this error\n(if any).",276,{"inputs":[{"name":"error"}],"output":{"name":"option"}}],[11,"into_inner","","Consumes the `Error`, returning its inner error (if any).",276,{"inputs":[{"name":"error"}],"output":{"name":"option"}}],[11,"kind","","Returns the corresponding `ErrorKind` for this error.",276,{"inputs":[{"name":"error"}],"output":{"name":"errorkind"}}],[11,"fmt","","",276,{"inputs":[{"name":"error"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",276,{"inputs":[{"name":"error"}],"output":{"name":"str"}}],[11,"cause","","",276,{"inputs":[{"name":"error"}],"output":{"name":"option"}}],[11,"read","std::boxed","",108,null],[11,"read_to_end","","",108,{"inputs":[{"name":"box"},{"name":"vec"}],"output":{"name":"result"}}],[11,"read_to_string","","",108,{"inputs":[{"name":"box"},{"name":"string"}],"output":{"name":"result"}}],[11,"read_exact","","",108,null],[11,"write","","",108,null],[11,"flush","","",108,{"inputs":[{"name":"box"}],"output":{"name":"result"}}],[11,"write_all","","",108,null],[11,"write_fmt","","",108,{"inputs":[{"name":"box"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"seek","","",108,{"inputs":[{"name":"box"},{"name":"seekfrom"}],"output":{"name":"result"}}],[11,"fill_buf","","",108,{"inputs":[{"name":"box"}],"output":{"name":"result"}}],[11,"consume","","",108,{"inputs":[{"name":"box"},{"name":"usize"}],"output":null}],[11,"read_until","","",108,{"inputs":[{"name":"box"},{"name":"u8"},{"name":"vec"}],"output":{"name":"result"}}],[11,"read_line","","",108,{"inputs":[{"name":"box"},{"name":"string"}],"output":{"name":"result"}}],[11,"write","std::vec","",182,null],[11,"write_all","","",182,null],[11,"flush","","",182,{"inputs":[{"name":"vec"}],"output":{"name":"result"}}],[11,"read","std::io","",279,null],[11,"fill_buf","","",279,{"inputs":[{"name":"empty"}],"output":{"name":"result"}}],[11,"consume","","",279,{"inputs":[{"name":"empty"},{"name":"usize"}],"output":null}],[11,"read","","",280,null],[11,"write","","",281,null],[11,"flush","","",281,{"inputs":[{"name":"sink"}],"output":{"name":"result"}}],[11,"lock","","Locks this handle to the standard input stream, returning a readable\nguard.",282,{"inputs":[{"name":"stdin"}],"output":{"name":"stdinlock"}}],[11,"read_line","","Locks this handle and reads a line of input into the specified buffer.",282,{"inputs":[{"name":"stdin"},{"name":"string"}],"output":{"name":"result"}}],[11,"read","","",282,null],[11,"read_to_end","","",282,{"inputs":[{"name":"stdin"},{"name":"vec"}],"output":{"name":"result"}}],[11,"read_to_string","","",282,{"inputs":[{"name":"stdin"},{"name":"string"}],"output":{"name":"result"}}],[11,"read_exact","","",282,null],[11,"read","","",283,null],[11,"read_to_end","","",283,{"inputs":[{"name":"stdinlock"},{"name":"vec"}],"output":{"name":"result"}}],[11,"fill_buf","","",283,{"inputs":[{"name":"stdinlock"}],"output":{"name":"result"}}],[11,"consume","","",283,{"inputs":[{"name":"stdinlock"},{"name":"usize"}],"output":null}],[11,"lock","","Locks this handle to the standard output stream, returning a writable\nguard.",284,{"inputs":[{"name":"stdout"}],"output":{"name":"stdoutlock"}}],[11,"write","","",284,null],[11,"flush","","",284,{"inputs":[{"name":"stdout"}],"output":{"name":"result"}}],[11,"write_all","","",284,null],[11,"write_fmt","","",284,{"inputs":[{"name":"stdout"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"write","","",285,null],[11,"flush","","",285,{"inputs":[{"name":"stdoutlock"}],"output":{"name":"result"}}],[11,"lock","","Locks this handle to the standard error stream, returning a writable\nguard.",286,{"inputs":[{"name":"stderr"}],"output":{"name":"stderrlock"}}],[11,"write","","",286,null],[11,"flush","","",286,{"inputs":[{"name":"stderr"}],"output":{"name":"result"}}],[11,"write_all","","",286,null],[11,"write_fmt","","",286,{"inputs":[{"name":"stderr"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"write","","",287,null],[11,"flush","","",287,{"inputs":[{"name":"stderrlock"}],"output":{"name":"result"}}],[6,"Result","","A specialized [`Result`](../result/enum.Result.html) type for I/O\noperations.",null,null],[8,"Read","","The `Read` trait allows for reading bytes from a source.",null,null],[10,"read","","Pull some bytes from this source into the specified buffer, returning\nhow many bytes were read.",288,null],[11,"read_to_end","","Read all bytes until EOF in this source, placing them into `buf`.",288,{"inputs":[{"name":"read"},{"name":"vec"}],"output":{"name":"result"}}],[11,"read_to_string","","Read all bytes until EOF in this source, placing them into `buf`.",288,{"inputs":[{"name":"read"},{"name":"string"}],"output":{"name":"result"}}],[11,"read_exact","","Read the exact number of bytes required to fill `buf`.",288,null],[11,"by_ref","","Creates a &quot;by reference&quot; adaptor for this instance of `Read`.",288,{"inputs":[{"name":"read"}],"output":{"name":"self"}}],[11,"bytes","","Transforms this `Read` instance to an `Iterator` over its bytes.",288,{"inputs":[{"name":"read"}],"output":{"name":"bytes"}}],[11,"chars","","Transforms this `Read` instance to an `Iterator` over `char`s.",288,{"inputs":[{"name":"read"}],"output":{"name":"chars"}}],[11,"chain","","Creates an adaptor which will chain this stream with another.",288,{"inputs":[{"name":"read"},{"name":"r"}],"output":{"name":"chain"}}],[11,"take","","Creates an adaptor which will read at most `limit` bytes from it.",288,{"inputs":[{"name":"read"},{"name":"u64"}],"output":{"name":"take"}}],[8,"Write","","A trait for objects which are byte-oriented sinks.",null,null],[10,"write","","Write a buffer into this object, returning how many bytes were written.",289,null],[10,"flush","","Flush this output stream, ensuring that all intermediately buffered\ncontents reach their destination.",289,{"inputs":[{"name":"write"}],"output":{"name":"result"}}],[11,"write_all","","Attempts to write an entire buffer into this write.",289,null],[11,"write_fmt","","Writes a formatted string into this writer, returning any error\nencountered.",289,{"inputs":[{"name":"write"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"by_ref","","Creates a &quot;by reference&quot; adaptor for this instance of `Write`.",289,{"inputs":[{"name":"write"}],"output":{"name":"self"}}],[8,"Seek","","The `Seek` trait provides a cursor which can be moved within a stream of\nbytes.",null,null],[10,"seek","","Seek to an offset, in bytes, in a stream.",290,{"inputs":[{"name":"seek"},{"name":"seekfrom"}],"output":{"name":"result"}}],[8,"BufRead","","A `BufRead` is a type of `Read`er which has an internal buffer, allowing it\nto perform extra ways of reading.",null,null],[10,"fill_buf","","Fills the internal buffer of this object, returning the buffer contents.",291,{"inputs":[{"name":"bufread"}],"output":{"name":"result"}}],[10,"consume","","Tells this buffer that `amt` bytes have been consumed from the buffer,\nso they should no longer be returned in calls to `read`.",291,{"inputs":[{"name":"bufread"},{"name":"usize"}],"output":null}],[11,"read_until","","Read all bytes into `buf` until the delimiter `byte` is reached.",291,{"inputs":[{"name":"bufread"},{"name":"u8"},{"name":"vec"}],"output":{"name":"result"}}],[11,"read_line","","Read all bytes until a newline (the 0xA byte) is reached, and append\nthem to the provided buffer.",291,{"inputs":[{"name":"bufread"},{"name":"string"}],"output":{"name":"result"}}],[11,"split","","Returns an iterator over the contents of this reader split on the byte\n`byte`.",291,{"inputs":[{"name":"bufread"},{"name":"u8"}],"output":{"name":"split"}}],[11,"lines","","Returns an iterator over the lines of this reader.",291,{"inputs":[{"name":"bufread"}],"output":{"name":"lines"}}],[11,"fmt","","",271,{"inputs":[{"name":"seekfrom"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",271,{"inputs":[{"name":"seekfrom"}],"output":{"name":"seekfrom"}}],[11,"eq","","",271,{"inputs":[{"name":"seekfrom"},{"name":"seekfrom"}],"output":{"name":"bool"}}],[11,"ne","","",271,{"inputs":[{"name":"seekfrom"},{"name":"seekfrom"}],"output":{"name":"bool"}}],[11,"read","","",292,null],[11,"fill_buf","","",292,{"inputs":[{"name":"chain"}],"output":{"name":"result"}}],[11,"consume","","",292,{"inputs":[{"name":"chain"},{"name":"usize"}],"output":null}],[11,"limit","","Returns the number of bytes that can be read before this instance will\nreturn EOF.",293,{"inputs":[{"name":"take"}],"output":{"name":"u64"}}],[11,"read","","",293,null],[11,"fill_buf","","",293,{"inputs":[{"name":"take"}],"output":{"name":"result"}}],[11,"consume","","",293,{"inputs":[{"name":"take"},{"name":"usize"}],"output":null}],[11,"next","","",294,{"inputs":[{"name":"bytes"}],"output":{"name":"option"}}],[11,"fmt","","",272,{"inputs":[{"name":"charserror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",295,{"inputs":[{"name":"chars"}],"output":{"name":"option"}}],[11,"description","","",272,{"inputs":[{"name":"charserror"}],"output":{"name":"str"}}],[11,"cause","","",272,{"inputs":[{"name":"charserror"}],"output":{"name":"option"}}],[11,"fmt","","",272,{"inputs":[{"name":"charserror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",296,{"inputs":[{"name":"split"}],"output":{"name":"option"}}],[11,"next","","",297,{"inputs":[{"name":"lines"}],"output":{"name":"option"}}],[0,"net","std","Networking primitives for TCP/UDP communication.",null,null],[3,"Ipv4Addr","std::net","Representation of an IPv4 address.",null,null],[3,"Ipv6Addr","","Representation of an IPv6 address.",null,null],[3,"SocketAddrV4","","An IPv4 socket address which is a (ip, port) combination.",null,null],[3,"SocketAddrV6","","An IPv6 socket address.",null,null],[3,"TcpStream","","A structure which represents a TCP stream between a local socket and a\nremote socket.",null,null],[3,"TcpListener","","A structure representing a socket server.",null,null],[3,"Incoming","","An infinite iterator over the connections from a `TcpListener`.",null,null],[3,"UdpSocket","","A User Datagram Protocol socket.",null,null],[3,"AddrParseError","","An error returned when parsing an IP address or a socket address.",null,null],[3,"LookupHost","","An iterator over `SocketAddr` values returned from a host lookup operation.",null,null],[4,"IpAddr","","An IP address, either an IPv4 or IPv6 address.",null,null],[13,"V4","","Representation of an IPv4 address.",298,null],[13,"V6","","Representation of an IPv6 address.",298,null],[4,"Ipv6MulticastScope","","",null,null],[13,"InterfaceLocal","","",299,null],[13,"LinkLocal","","",299,null],[13,"RealmLocal","","",299,null],[13,"AdminLocal","","",299,null],[13,"SiteLocal","","",299,null],[13,"OrganizationLocal","","",299,null],[13,"Global","","",299,null],[4,"SocketAddr","","Representation of a socket address for networking applications.",null,null],[13,"V4","","An IPv4 socket address which is a (ip, port) combination.",300,null],[13,"V6","","An IPv6 socket address",300,null],[4,"Shutdown","","Possible values which can be passed to the `shutdown` method of `TcpStream`.",null,null],[13,"Read","","Indicates that the reading portion of this stream/socket should be shut\ndown. All currently blocked and future reads will return `Ok(0)`.",301,null],[13,"Write","","Indicates that the writing portion of this stream/socket should be shut\ndown. All currently blocked and future writes will return an error.",301,null],[13,"Both","","Shut down both the reading and writing portions of this stream.",301,null],[5,"lookup_host","","Resolve the host specified by `host` as a number of `SocketAddr` instances.",null,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"cmp","","",298,{"inputs":[{"name":"ipaddr"},{"name":"ipaddr"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",298,{"inputs":[{"name":"ipaddr"},{"name":"ipaddr"}],"output":{"name":"option"}}],[11,"lt","","",298,{"inputs":[{"name":"ipaddr"},{"name":"ipaddr"}],"output":{"name":"bool"}}],[11,"le","","",298,{"inputs":[{"name":"ipaddr"},{"name":"ipaddr"}],"output":{"name":"bool"}}],[11,"gt","","",298,{"inputs":[{"name":"ipaddr"},{"name":"ipaddr"}],"output":{"name":"bool"}}],[11,"ge","","",298,{"inputs":[{"name":"ipaddr"},{"name":"ipaddr"}],"output":{"name":"bool"}}],[11,"hash","","",298,null],[11,"fmt","","",298,{"inputs":[{"name":"ipaddr"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",298,{"inputs":[{"name":"ipaddr"},{"name":"ipaddr"}],"output":{"name":"bool"}}],[11,"ne","","",298,{"inputs":[{"name":"ipaddr"},{"name":"ipaddr"}],"output":{"name":"bool"}}],[11,"clone","","",298,{"inputs":[{"name":"ipaddr"}],"output":{"name":"ipaddr"}}],[11,"fmt","","",299,{"inputs":[{"name":"ipv6multicastscope"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",299,null],[11,"clone","","",299,{"inputs":[{"name":"ipv6multicastscope"}],"output":{"name":"ipv6multicastscope"}}],[11,"eq","","",299,{"inputs":[{"name":"ipv6multicastscope"},{"name":"ipv6multicastscope"}],"output":{"name":"bool"}}],[11,"new","","Creates a new IPv4 address from four eight-bit octets.",302,{"inputs":[{"name":"u8"},{"name":"u8"},{"name":"u8"},{"name":"u8"}],"output":{"name":"ipv4addr"}}],[11,"octets","","Returns the four eight-bit integers that make up this address.",302,null],[11,"is_unspecified","","Returns true for the special &#39;unspecified&#39; address 0.0.0.0.",302,{"inputs":[{"name":"ipv4addr"}],"output":{"name":"bool"}}],[11,"is_loopback","","Returns true if this is a loopback address (127.0.0.0/8).",302,{"inputs":[{"name":"ipv4addr"}],"output":{"name":"bool"}}],[11,"is_private","","Returns true if this is a private address.",302,{"inputs":[{"name":"ipv4addr"}],"output":{"name":"bool"}}],[11,"is_link_local","","Returns true if the address is link-local (169.254.0.0/16).",302,{"inputs":[{"name":"ipv4addr"}],"output":{"name":"bool"}}],[11,"is_global","","Returns true if the address appears to be globally routable.\nSee [iana-ipv4-special-registry][ipv4-sr].\n[ipv4-sr]: http://goo.gl/RaZ7lg",302,{"inputs":[{"name":"ipv4addr"}],"output":{"name":"bool"}}],[11,"is_multicast","","Returns true if this is a multicast address.",302,{"inputs":[{"name":"ipv4addr"}],"output":{"name":"bool"}}],[11,"is_broadcast","","Returns true if this is a broadcast address.",302,{"inputs":[{"name":"ipv4addr"}],"output":{"name":"bool"}}],[11,"is_documentation","","Returns true if this address is in a range designated for documentation.",302,{"inputs":[{"name":"ipv4addr"}],"output":{"name":"bool"}}],[11,"to_ipv6_compatible","","Converts this address to an IPv4-compatible IPv6 address.",302,{"inputs":[{"name":"ipv4addr"}],"output":{"name":"ipv6addr"}}],[11,"to_ipv6_mapped","","Converts this address to an IPv4-mapped IPv6 address.",302,{"inputs":[{"name":"ipv4addr"}],"output":{"name":"ipv6addr"}}],[11,"fmt","","",298,{"inputs":[{"name":"ipaddr"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",302,{"inputs":[{"name":"ipv4addr"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",302,{"inputs":[{"name":"ipv4addr"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",302,{"inputs":[{"name":"ipv4addr"}],"output":{"name":"ipv4addr"}}],[11,"eq","","",302,{"inputs":[{"name":"ipv4addr"},{"name":"ipv4addr"}],"output":{"name":"bool"}}],[11,"hash","","",302,{"inputs":[{"name":"ipv4addr"},{"name":"h"}],"output":null}],[11,"partial_cmp","","",302,{"inputs":[{"name":"ipv4addr"},{"name":"ipv4addr"}],"output":{"name":"option"}}],[11,"cmp","","",302,{"inputs":[{"name":"ipv4addr"},{"name":"ipv4addr"}],"output":{"name":"ordering"}}],[11,"from","","",302,{"inputs":[{"name":"u32"}],"output":{"name":"ipv4addr"}}],[11,"from","","",302,null],[11,"new","","Creates a new IPv6 address from eight 16-bit segments.",303,{"inputs":[{"name":"u16"},{"name":"u16"},{"name":"u16"},{"name":"u16"},{"name":"u16"},{"name":"u16"},{"name":"u16"},{"name":"u16"}],"output":{"name":"ipv6addr"}}],[11,"segments","","Returns the eight 16-bit segments that make up this address.",303,null],[11,"is_unspecified","","Returns true for the special &#39;unspecified&#39; address ::.",303,{"inputs":[{"name":"ipv6addr"}],"output":{"name":"bool"}}],[11,"is_loopback","","Returns true if this is a loopback address (::1).",303,{"inputs":[{"name":"ipv6addr"}],"output":{"name":"bool"}}],[11,"is_global","","Returns true if the address appears to be globally routable.",303,{"inputs":[{"name":"ipv6addr"}],"output":{"name":"bool"}}],[11,"is_unique_local","","Returns true if this is a unique local address (IPv6).",303,{"inputs":[{"name":"ipv6addr"}],"output":{"name":"bool"}}],[11,"is_unicast_link_local","","Returns true if the address is unicast and link-local (fe80::/10).",303,{"inputs":[{"name":"ipv6addr"}],"output":{"name":"bool"}}],[11,"is_unicast_site_local","","Returns true if this is a deprecated unicast site-local address (IPv6\nfec0::/10).",303,{"inputs":[{"name":"ipv6addr"}],"output":{"name":"bool"}}],[11,"is_documentation","","Returns true if this is an address reserved for documentation\nThis is defined to be 2001:db8::/32 in RFC RFC 3849",303,{"inputs":[{"name":"ipv6addr"}],"output":{"name":"bool"}}],[11,"is_unicast_global","","Returns true if the address is a globally routable unicast address.",303,{"inputs":[{"name":"ipv6addr"}],"output":{"name":"bool"}}],[11,"multicast_scope","","Returns the address&#39;s multicast scope if the address is multicast.",303,{"inputs":[{"name":"ipv6addr"}],"output":{"name":"option"}}],[11,"is_multicast","","Returns true if this is a multicast address.",303,{"inputs":[{"name":"ipv6addr"}],"output":{"name":"bool"}}],[11,"to_ipv4","","Converts this address to an IPv4 address. Returns None if this address is\nneither IPv4-compatible or IPv4-mapped.",303,{"inputs":[{"name":"ipv6addr"}],"output":{"name":"option"}}],[11,"octets","","Returns the sixteen eight-bit integers the IPv6 address consists of.",303,null],[11,"fmt","","",303,{"inputs":[{"name":"ipv6addr"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",303,{"inputs":[{"name":"ipv6addr"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",303,{"inputs":[{"name":"ipv6addr"}],"output":{"name":"ipv6addr"}}],[11,"eq","","",303,{"inputs":[{"name":"ipv6addr"},{"name":"ipv6addr"}],"output":{"name":"bool"}}],[11,"hash","","",303,{"inputs":[{"name":"ipv6addr"},{"name":"h"}],"output":null}],[11,"partial_cmp","","",303,{"inputs":[{"name":"ipv6addr"},{"name":"ipv6addr"}],"output":{"name":"option"}}],[11,"cmp","","",303,{"inputs":[{"name":"ipv6addr"},{"name":"ipv6addr"}],"output":{"name":"ordering"}}],[11,"from","","",303,null],[11,"fmt","","",300,{"inputs":[{"name":"socketaddr"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",300,null],[11,"eq","","",300,{"inputs":[{"name":"socketaddr"},{"name":"socketaddr"}],"output":{"name":"bool"}}],[11,"ne","","",300,{"inputs":[{"name":"socketaddr"},{"name":"socketaddr"}],"output":{"name":"bool"}}],[11,"clone","","",300,{"inputs":[{"name":"socketaddr"}],"output":{"name":"socketaddr"}}],[11,"new","","Creates a new socket address from the (ip, port) pair.",300,{"inputs":[{"name":"ipaddr"},{"name":"u16"}],"output":{"name":"socketaddr"}}],[11,"ip","","Returns the IP address associated with this socket address.",300,{"inputs":[{"name":"socketaddr"}],"output":{"name":"ipaddr"}}],[11,"set_ip","","Change the IP address associated with this socket address.",300,{"inputs":[{"name":"socketaddr"},{"name":"ipaddr"}],"output":null}],[11,"port","","Returns the port number associated with this socket address.",300,{"inputs":[{"name":"socketaddr"}],"output":{"name":"u16"}}],[11,"set_port","","Change the port number associated with this socket address.",300,{"inputs":[{"name":"socketaddr"},{"name":"u16"}],"output":null}],[11,"new","","Creates a new socket address from the (ip, port) pair.",304,{"inputs":[{"name":"ipv4addr"},{"name":"u16"}],"output":{"name":"socketaddrv4"}}],[11,"ip","","Returns the IP address associated with this socket address.",304,{"inputs":[{"name":"socketaddrv4"}],"output":{"name":"ipv4addr"}}],[11,"set_ip","","Change the IP address associated with this socket address.",304,{"inputs":[{"name":"socketaddrv4"},{"name":"ipv4addr"}],"output":null}],[11,"port","","Returns the port number associated with this socket address.",304,{"inputs":[{"name":"socketaddrv4"}],"output":{"name":"u16"}}],[11,"set_port","","Change the port number associated with this socket address.",304,{"inputs":[{"name":"socketaddrv4"},{"name":"u16"}],"output":null}],[11,"new","","Creates a new socket address from the ip/port/flowinfo/scope_id\ncomponents.",305,{"inputs":[{"name":"ipv6addr"},{"name":"u16"},{"name":"u32"},{"name":"u32"}],"output":{"name":"socketaddrv6"}}],[11,"ip","","Returns the IP address associated with this socket address.",305,{"inputs":[{"name":"socketaddrv6"}],"output":{"name":"ipv6addr"}}],[11,"set_ip","","Change the IP address associated with this socket address.",305,{"inputs":[{"name":"socketaddrv6"},{"name":"ipv6addr"}],"output":null}],[11,"port","","Returns the port number associated with this socket address.",305,{"inputs":[{"name":"socketaddrv6"}],"output":{"name":"u16"}}],[11,"set_port","","Change the port number associated with this socket address.",305,{"inputs":[{"name":"socketaddrv6"},{"name":"u16"}],"output":null}],[11,"flowinfo","","Returns the flow information associated with this address,\ncorresponding to the `sin6_flowinfo` field in C.",305,{"inputs":[{"name":"socketaddrv6"}],"output":{"name":"u32"}}],[11,"set_flowinfo","","Change the flow information associated with this socket address.",305,{"inputs":[{"name":"socketaddrv6"},{"name":"u32"}],"output":null}],[11,"scope_id","","Returns the scope ID associated with this address,\ncorresponding to the `sin6_scope_id` field in C.",305,{"inputs":[{"name":"socketaddrv6"}],"output":{"name":"u32"}}],[11,"set_scope_id","","Change the scope ID associated with this socket address.",305,{"inputs":[{"name":"socketaddrv6"},{"name":"u32"}],"output":null}],[11,"fmt","","",300,{"inputs":[{"name":"socketaddr"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",304,{"inputs":[{"name":"socketaddrv4"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",304,{"inputs":[{"name":"socketaddrv4"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",305,{"inputs":[{"name":"socketaddrv6"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",305,{"inputs":[{"name":"socketaddrv6"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",304,{"inputs":[{"name":"socketaddrv4"}],"output":{"name":"socketaddrv4"}}],[11,"clone","","",305,{"inputs":[{"name":"socketaddrv6"}],"output":{"name":"socketaddrv6"}}],[11,"eq","","",304,{"inputs":[{"name":"socketaddrv4"},{"name":"socketaddrv4"}],"output":{"name":"bool"}}],[11,"eq","","",305,{"inputs":[{"name":"socketaddrv6"},{"name":"socketaddrv6"}],"output":{"name":"bool"}}],[11,"hash","","",304,{"inputs":[{"name":"socketaddrv4"},{"name":"h"}],"output":null}],[11,"hash","","",305,{"inputs":[{"name":"socketaddrv6"},{"name":"h"}],"output":null}],[11,"to_socket_addrs","","",300,{"inputs":[{"name":"socketaddr"}],"output":{"name":"result"}}],[11,"to_socket_addrs","","",304,{"inputs":[{"name":"socketaddrv4"}],"output":{"name":"result"}}],[11,"to_socket_addrs","","",305,{"inputs":[{"name":"socketaddrv6"}],"output":{"name":"result"}}],[11,"connect","","Opens a TCP connection to a remote host.",306,{"inputs":[{"name":"a"}],"output":{"name":"result"}}],[11,"peer_addr","","Returns the socket address of the remote peer of this TCP connection.",306,{"inputs":[{"name":"tcpstream"}],"output":{"name":"result"}}],[11,"local_addr","","Returns the socket address of the local half of this TCP connection.",306,{"inputs":[{"name":"tcpstream"}],"output":{"name":"result"}}],[11,"shutdown","","Shuts down the read, write, or both halves of this connection.",306,{"inputs":[{"name":"tcpstream"},{"name":"shutdown"}],"output":{"name":"result"}}],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",306,{"inputs":[{"name":"tcpstream"}],"output":{"name":"result"}}],[11,"set_read_timeout","","Sets the read timeout to the timeout specified.",306,{"inputs":[{"name":"tcpstream"},{"name":"option"}],"output":{"name":"result"}}],[11,"set_write_timeout","","Sets the write timeout to the timeout specified.",306,{"inputs":[{"name":"tcpstream"},{"name":"option"}],"output":{"name":"result"}}],[11,"read_timeout","","Returns the read timeout of this socket.",306,{"inputs":[{"name":"tcpstream"}],"output":{"name":"result"}}],[11,"write_timeout","","Returns the write timeout of this socket.",306,{"inputs":[{"name":"tcpstream"}],"output":{"name":"result"}}],[11,"set_nodelay","","Sets the value of the `TCP_NODELAY` option on this socket.",306,{"inputs":[{"name":"tcpstream"},{"name":"bool"}],"output":{"name":"result"}}],[11,"nodelay","","Gets the value of the `TCP_NODELAY` option on this socket.",306,{"inputs":[{"name":"tcpstream"}],"output":{"name":"result"}}],[11,"set_ttl","","Sets the value for the `IP_TTL` option on this socket.",306,{"inputs":[{"name":"tcpstream"},{"name":"u32"}],"output":{"name":"result"}}],[11,"ttl","","Gets the value of the `IP_TTL` option for this socket.",306,{"inputs":[{"name":"tcpstream"}],"output":{"name":"result"}}],[11,"take_error","","Get the value of the `SO_ERROR` option on this socket.",306,{"inputs":[{"name":"tcpstream"}],"output":{"name":"result"}}],[11,"set_nonblocking","","Moves this TCP stream into or out of nonblocking mode.",306,{"inputs":[{"name":"tcpstream"},{"name":"bool"}],"output":{"name":"result"}}],[11,"read","","",306,null],[11,"read_to_end","","",306,{"inputs":[{"name":"tcpstream"},{"name":"vec"}],"output":{"name":"result"}}],[11,"write","","",306,null],[11,"flush","","",306,{"inputs":[{"name":"tcpstream"}],"output":{"name":"result"}}],[11,"fmt","","",306,{"inputs":[{"name":"tcpstream"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"bind","","Creates a new `TcpListener` which will be bound to the specified\naddress.",307,{"inputs":[{"name":"a"}],"output":{"name":"result"}}],[11,"local_addr","","Returns the local socket address of this listener.",307,{"inputs":[{"name":"tcplistener"}],"output":{"name":"result"}}],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",307,{"inputs":[{"name":"tcplistener"}],"output":{"name":"result"}}],[11,"accept","","Accept a new incoming connection from this listener.",307,{"inputs":[{"name":"tcplistener"}],"output":{"name":"result"}}],[11,"incoming","","Returns an iterator over the connections being received on this\nlistener.",307,{"inputs":[{"name":"tcplistener"}],"output":{"name":"incoming"}}],[11,"set_ttl","","Sets the value for the `IP_TTL` option on this socket.",307,{"inputs":[{"name":"tcplistener"},{"name":"u32"}],"output":{"name":"result"}}],[11,"ttl","","Gets the value of the `IP_TTL` option for this socket.",307,{"inputs":[{"name":"tcplistener"}],"output":{"name":"result"}}],[11,"set_only_v6","","Sets the value for the `IPV6_V6ONLY` option on this socket.",307,{"inputs":[{"name":"tcplistener"},{"name":"bool"}],"output":{"name":"result"}}],[11,"only_v6","","Gets the value of the `IPV6_V6ONLY` option for this socket.",307,{"inputs":[{"name":"tcplistener"}],"output":{"name":"result"}}],[11,"take_error","","Get the value of the `SO_ERROR` option on this socket.",307,{"inputs":[{"name":"tcplistener"}],"output":{"name":"result"}}],[11,"set_nonblocking","","Moves this TCP stream into or out of nonblocking mode.",307,{"inputs":[{"name":"tcplistener"},{"name":"bool"}],"output":{"name":"result"}}],[11,"next","","",308,{"inputs":[{"name":"incoming"}],"output":{"name":"option"}}],[11,"fmt","","",307,{"inputs":[{"name":"tcplistener"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"bind","","Creates a UDP socket from the given address.",309,{"inputs":[{"name":"a"}],"output":{"name":"result"}}],[11,"recv_from","","Receives data from the socket. On success, returns the number of bytes\nread and the address from whence the data came.",309,null],[11,"send_to","","Sends data on the socket to the given address. On success, returns the\nnumber of bytes written.",309,null],[11,"local_addr","","Returns the socket address that this socket was created from.",309,{"inputs":[{"name":"udpsocket"}],"output":{"name":"result"}}],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",309,{"inputs":[{"name":"udpsocket"}],"output":{"name":"result"}}],[11,"set_read_timeout","","Sets the read timeout to the timeout specified.",309,{"inputs":[{"name":"udpsocket"},{"name":"option"}],"output":{"name":"result"}}],[11,"set_write_timeout","","Sets the write timeout to the timeout specified.",309,{"inputs":[{"name":"udpsocket"},{"name":"option"}],"output":{"name":"result"}}],[11,"read_timeout","","Returns the read timeout of this socket.",309,{"inputs":[{"name":"udpsocket"}],"output":{"name":"result"}}],[11,"write_timeout","","Returns the write timeout of this socket.",309,{"inputs":[{"name":"udpsocket"}],"output":{"name":"result"}}],[11,"set_broadcast","","Sets the value of the `SO_BROADCAST` option for this socket.",309,{"inputs":[{"name":"udpsocket"},{"name":"bool"}],"output":{"name":"result"}}],[11,"broadcast","","Gets the value of the `SO_BROADCAST` option for this socket.",309,{"inputs":[{"name":"udpsocket"}],"output":{"name":"result"}}],[11,"set_multicast_loop_v4","","Sets the value of the `IP_MULTICAST_LOOP` option for this socket.",309,{"inputs":[{"name":"udpsocket"},{"name":"bool"}],"output":{"name":"result"}}],[11,"multicast_loop_v4","","Gets the value of the `IP_MULTICAST_LOOP` option for this socket.",309,{"inputs":[{"name":"udpsocket"}],"output":{"name":"result"}}],[11,"set_multicast_ttl_v4","","Sets the value of the `IP_MULTICAST_TTL` option for this socket.",309,{"inputs":[{"name":"udpsocket"},{"name":"u32"}],"output":{"name":"result"}}],[11,"multicast_ttl_v4","","Gets the value of the `IP_MULTICAST_TTL` option for this socket.",309,{"inputs":[{"name":"udpsocket"}],"output":{"name":"result"}}],[11,"set_multicast_loop_v6","","Sets the value of the `IPV6_MULTICAST_LOOP` option for this socket.",309,{"inputs":[{"name":"udpsocket"},{"name":"bool"}],"output":{"name":"result"}}],[11,"multicast_loop_v6","","Gets the value of the `IPV6_MULTICAST_LOOP` option for this socket.",309,{"inputs":[{"name":"udpsocket"}],"output":{"name":"result"}}],[11,"set_ttl","","Sets the value for the `IP_TTL` option on this socket.",309,{"inputs":[{"name":"udpsocket"},{"name":"u32"}],"output":{"name":"result"}}],[11,"ttl","","Gets the value of the `IP_TTL` option for this socket.",309,{"inputs":[{"name":"udpsocket"}],"output":{"name":"result"}}],[11,"join_multicast_v4","","Executes an operation of the `IP_ADD_MEMBERSHIP` type.",309,{"inputs":[{"name":"udpsocket"},{"name":"ipv4addr"},{"name":"ipv4addr"}],"output":{"name":"result"}}],[11,"join_multicast_v6","","Executes an operation of the `IPV6_ADD_MEMBERSHIP` type.",309,{"inputs":[{"name":"udpsocket"},{"name":"ipv6addr"},{"name":"u32"}],"output":{"name":"result"}}],[11,"leave_multicast_v4","","Executes an operation of the `IP_DROP_MEMBERSHIP` type.",309,{"inputs":[{"name":"udpsocket"},{"name":"ipv4addr"},{"name":"ipv4addr"}],"output":{"name":"result"}}],[11,"leave_multicast_v6","","Executes an operation of the `IPV6_DROP_MEMBERSHIP` type.",309,{"inputs":[{"name":"udpsocket"},{"name":"ipv6addr"},{"name":"u32"}],"output":{"name":"result"}}],[11,"take_error","","Get the value of the `SO_ERROR` option on this socket.",309,{"inputs":[{"name":"udpsocket"}],"output":{"name":"result"}}],[11,"connect","","Connects this UDP socket to a remote address, allowing the `send` and\n`recv` syscalls to be used to send data and also applies filters to only\nreceive data from the specified address.",309,{"inputs":[{"name":"udpsocket"},{"name":"a"}],"output":{"name":"result"}}],[11,"send","","Sends data on the socket to the remote address to which it is connected.",309,null],[11,"recv","","Receives data on the socket from the remote address to which it is\nconnected.",309,null],[11,"set_nonblocking","","Moves this TCP stream into or out of nonblocking mode.",309,{"inputs":[{"name":"udpsocket"},{"name":"bool"}],"output":{"name":"result"}}],[11,"fmt","","",309,{"inputs":[{"name":"udpsocket"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from_str","","",298,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",302,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",303,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",304,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",305,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",300,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"eq","","",310,{"inputs":[{"name":"addrparseerror"},{"name":"addrparseerror"}],"output":{"name":"bool"}}],[11,"ne","","",310,{"inputs":[{"name":"addrparseerror"},{"name":"addrparseerror"}],"output":{"name":"bool"}}],[11,"clone","","",310,{"inputs":[{"name":"addrparseerror"}],"output":{"name":"addrparseerror"}}],[11,"fmt","","",310,{"inputs":[{"name":"addrparseerror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",310,{"inputs":[{"name":"addrparseerror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",310,{"inputs":[{"name":"addrparseerror"}],"output":{"name":"str"}}],[8,"ToSocketAddrs","","A trait for objects which can be converted or resolved to one or more\n`SocketAddr` values.",null,null],[16,"Iter","","Returned iterator over socket addresses which this type may correspond\nto.",311,null],[10,"to_socket_addrs","","Converts this object to an iterator of resolved `SocketAddr`s.",311,{"inputs":[{"name":"tosocketaddrs"}],"output":{"name":"result"}}],[11,"fmt","","",301,{"inputs":[{"name":"shutdown"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",301,{"inputs":[{"name":"shutdown"},{"name":"shutdown"}],"output":{"name":"bool"}}],[11,"clone","","",301,{"inputs":[{"name":"shutdown"}],"output":{"name":"shutdown"}}],[11,"next","","",312,{"inputs":[{"name":"lookuphost"}],"output":{"name":"option"}}],[0,"os","std","OS-specific functionality.",null,null],[0,"unix","std::os","Experimental extensions to `std` for Unix platforms.",null,null],[0,"io","std::os::unix","Unix-specific extensions to general I/O primitives",null,null],[6,"RawFd","std::os::unix::io","Raw file descriptors.",null,null],[8,"AsRawFd","","A trait to extract the raw unix file descriptor from an underlying\nobject.",null,null],[10,"as_raw_fd","","Extracts the raw file descriptor.",313,{"inputs":[{"name":"asrawfd"}],"output":{"name":"rawfd"}}],[8,"FromRawFd","","A trait to express the ability to construct an object from a raw file\ndescriptor.",null,null],[10,"from_raw_fd","","Constructs a new instances of `Self` from the given raw file\ndescriptor.",314,{"inputs":[{"name":"rawfd"}],"output":{"name":"self"}}],[8,"IntoRawFd","","A trait to express the ability to consume an object and acquire ownership of\nits raw file descriptor.",null,null],[10,"into_raw_fd","","Consumes this object, returning the raw underlying file descriptor.",315,{"inputs":[{"name":"intorawfd"}],"output":{"name":"rawfd"}}],[11,"as_raw_fd","std::fs","",266,{"inputs":[{"name":"file"}],"output":{"name":"rawfd"}}],[11,"from_raw_fd","","",266,{"inputs":[{"name":"rawfd"}],"output":{"name":"file"}}],[11,"into_raw_fd","","",266,{"inputs":[{"name":"file"}],"output":{"name":"rawfd"}}],[11,"as_raw_fd","std::net","",306,{"inputs":[{"name":"tcpstream"}],"output":{"name":"rawfd"}}],[11,"as_raw_fd","","",307,{"inputs":[{"name":"tcplistener"}],"output":{"name":"rawfd"}}],[11,"as_raw_fd","","",309,{"inputs":[{"name":"udpsocket"}],"output":{"name":"rawfd"}}],[11,"from_raw_fd","","",306,{"inputs":[{"name":"rawfd"}],"output":{"name":"tcpstream"}}],[11,"from_raw_fd","","",307,{"inputs":[{"name":"rawfd"}],"output":{"name":"tcplistener"}}],[11,"from_raw_fd","","",309,{"inputs":[{"name":"rawfd"}],"output":{"name":"udpsocket"}}],[11,"into_raw_fd","","",306,{"inputs":[{"name":"tcpstream"}],"output":{"name":"rawfd"}}],[11,"into_raw_fd","","",307,{"inputs":[{"name":"tcplistener"}],"output":{"name":"rawfd"}}],[11,"into_raw_fd","","",309,{"inputs":[{"name":"udpsocket"}],"output":{"name":"rawfd"}}],[0,"ffi","std::os::unix","Unix-specific extension to the primitives in the `std::ffi` module",null,null],[8,"OsStringExt","std::os::unix::ffi","Unix-specific extensions to `OsString`.",null,null],[10,"from_vec","","Creates an `OsString` from a byte vector.",316,{"inputs":[{"name":"vec"}],"output":{"name":"self"}}],[10,"into_vec","","Yields the underlying byte vector of this `OsString`.",316,{"inputs":[{"name":"osstringext"}],"output":{"name":"vec"}}],[8,"OsStrExt","","Unix-specific extensions to `OsStr`.",null,null],[10,"from_bytes","","",317,null],[10,"as_bytes","","Gets the underlying byte view of the `OsStr` slice.",317,null],[11,"from_vec","std::ffi","",260,{"inputs":[{"name":"vec"}],"output":{"name":"osstring"}}],[11,"into_vec","","",260,{"inputs":[{"name":"osstring"}],"output":{"name":"vec"}}],[11,"from_bytes","","",261,null],[11,"as_bytes","","",261,null],[0,"fs","std::os::unix","Unix-specific extensions to primitives in the `std::fs` module.",null,null],[5,"symlink","std::os::unix::fs","Creates a new symbolic link on the filesystem.",null,{"inputs":[{"name":"p"},{"name":"q"}],"output":{"name":"result"}}],[8,"PermissionsExt","","Unix-specific extensions to `Permissions`",null,null],[10,"mode","","Returns the underlying raw `mode_t` bits that are the standard Unix\npermissions for this file.",318,{"inputs":[{"name":"permissionsext"}],"output":{"name":"u32"}}],[10,"set_mode","","Sets the underlying raw bits for this set of permissions.",318,{"inputs":[{"name":"permissionsext"},{"name":"u32"}],"output":null}],[10,"from_mode","","Creates a new instance of `Permissions` from the given set of Unix\npermission bits.",318,{"inputs":[{"name":"u32"}],"output":{"name":"self"}}],[8,"OpenOptionsExt","","Unix-specific extensions to `OpenOptions`",null,null],[10,"mode","","Sets the mode bits that a new file will be created with.",319,{"inputs":[{"name":"openoptionsext"},{"name":"u32"}],"output":{"name":"self"}}],[10,"custom_flags","","Pass custom flags to the `flags` agument of `open`.",319,{"inputs":[{"name":"openoptionsext"},{"name":"i32"}],"output":{"name":"self"}}],[8,"MetadataExt","","",null,null],[10,"dev","","",320,{"inputs":[{"name":"metadataext"}],"output":{"name":"u64"}}],[10,"ino","","",320,{"inputs":[{"name":"metadataext"}],"output":{"name":"u64"}}],[10,"mode","","",320,{"inputs":[{"name":"metadataext"}],"output":{"name":"u32"}}],[10,"nlink","","",320,{"inputs":[{"name":"metadataext"}],"output":{"name":"u64"}}],[10,"uid","","",320,{"inputs":[{"name":"metadataext"}],"output":{"name":"u32"}}],[10,"gid","","",320,{"inputs":[{"name":"metadataext"}],"output":{"name":"u32"}}],[10,"rdev","","",320,{"inputs":[{"name":"metadataext"}],"output":{"name":"u64"}}],[10,"size","","",320,{"inputs":[{"name":"metadataext"}],"output":{"name":"u64"}}],[10,"atime","","",320,{"inputs":[{"name":"metadataext"}],"output":{"name":"i64"}}],[10,"atime_nsec","","",320,{"inputs":[{"name":"metadataext"}],"output":{"name":"i64"}}],[10,"mtime","","",320,{"inputs":[{"name":"metadataext"}],"output":{"name":"i64"}}],[10,"mtime_nsec","","",320,{"inputs":[{"name":"metadataext"}],"output":{"name":"i64"}}],[10,"ctime","","",320,{"inputs":[{"name":"metadataext"}],"output":{"name":"i64"}}],[10,"ctime_nsec","","",320,{"inputs":[{"name":"metadataext"}],"output":{"name":"i64"}}],[10,"blksize","","",320,{"inputs":[{"name":"metadataext"}],"output":{"name":"u64"}}],[10,"blocks","","",320,{"inputs":[{"name":"metadataext"}],"output":{"name":"u64"}}],[8,"FileTypeExt","","Add special unix types (block/char device, fifo and socket)",null,null],[10,"is_block_device","","Returns whether this file type is a block device.",321,{"inputs":[{"name":"filetypeext"}],"output":{"name":"bool"}}],[10,"is_char_device","","Returns whether this file type is a char device.",321,{"inputs":[{"name":"filetypeext"}],"output":{"name":"bool"}}],[10,"is_fifo","","Returns whether this file type is a fifo.",321,{"inputs":[{"name":"filetypeext"}],"output":{"name":"bool"}}],[10,"is_socket","","Returns whether this file type is a socket.",321,{"inputs":[{"name":"filetypeext"}],"output":{"name":"bool"}}],[8,"DirEntryExt","","Unix-specific extension methods for `fs::DirEntry`",null,null],[10,"ino","","Returns the underlying `d_ino` field in the contained `dirent`\nstructure.",322,{"inputs":[{"name":"direntryext"}],"output":{"name":"u64"}}],[8,"DirBuilderExt","","An extension trait for `fs::DirBuilder` for unix-specific options.",null,null],[10,"mode","","Sets the mode to create new directories with. This option defaults to\n0o777.",323,{"inputs":[{"name":"dirbuilderext"},{"name":"u32"}],"output":{"name":"self"}}],[11,"mode","std::fs","",264,{"inputs":[{"name":"permissions"}],"output":{"name":"u32"}}],[11,"set_mode","","",264,{"inputs":[{"name":"permissions"},{"name":"u32"}],"output":null}],[11,"from_mode","","",264,{"inputs":[{"name":"u32"}],"output":{"name":"permissions"}}],[11,"mode","","",263,{"inputs":[{"name":"openoptions"},{"name":"u32"}],"output":{"name":"openoptions"}}],[11,"custom_flags","","",263,{"inputs":[{"name":"openoptions"},{"name":"i32"}],"output":{"name":"openoptions"}}],[11,"dev","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u64"}}],[11,"ino","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u64"}}],[11,"mode","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u32"}}],[11,"nlink","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u64"}}],[11,"uid","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u32"}}],[11,"gid","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u32"}}],[11,"rdev","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u64"}}],[11,"size","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u64"}}],[11,"atime","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"i64"}}],[11,"atime_nsec","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"i64"}}],[11,"mtime","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"i64"}}],[11,"mtime_nsec","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"i64"}}],[11,"ctime","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"i64"}}],[11,"ctime_nsec","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"i64"}}],[11,"blksize","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u64"}}],[11,"blocks","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u64"}}],[11,"is_block_device","","",265,{"inputs":[{"name":"filetype"}],"output":{"name":"bool"}}],[11,"is_char_device","","",265,{"inputs":[{"name":"filetype"}],"output":{"name":"bool"}}],[11,"is_fifo","","",265,{"inputs":[{"name":"filetype"}],"output":{"name":"bool"}}],[11,"is_socket","","",265,{"inputs":[{"name":"filetype"}],"output":{"name":"bool"}}],[11,"ino","","",268,{"inputs":[{"name":"direntry"}],"output":{"name":"u64"}}],[11,"mode","","",269,{"inputs":[{"name":"dirbuilder"},{"name":"u32"}],"output":{"name":"dirbuilder"}}],[0,"process","std::os::unix","Unix-specific extensions to primitives in the `std::process` module.",null,null],[8,"CommandExt","std::os::unix::process","Unix-specific extensions to the `std::process::Command` builder",null,null],[10,"uid","","Sets the child process&#39;s user id. This translates to a\n`setuid` call in the child process. Failure in the `setuid`\ncall will cause the spawn to fail.",324,{"inputs":[{"name":"commandext"},{"name":"u32"}],"output":{"name":"command"}}],[10,"gid","","Similar to `uid`, but sets the group id of the child process. This has\nthe same semantics as the `uid` field.",324,{"inputs":[{"name":"commandext"},{"name":"u32"}],"output":{"name":"command"}}],[10,"session_leader","","Create a new session (cf. `setsid(2)`) for the child process. This means\nthat the child is the leader of a new process group. The parent process\nremains the child reaper of the new process.",324,{"inputs":[{"name":"commandext"},{"name":"bool"}],"output":{"name":"command"}}],[10,"before_exec","","Schedules a closure to be run just before the `exec` function is\ninvoked.",324,{"inputs":[{"name":"commandext"},{"name":"f"}],"output":{"name":"command"}}],[10,"exec","","Performs all the required setup by this `Command`, followed by calling\nthe `execvp` syscall.",324,{"inputs":[{"name":"commandext"}],"output":{"name":"error"}}],[8,"ExitStatusExt","","Unix-specific extensions to `std::process::ExitStatus`",null,null],[10,"signal","","If the process was terminated by a signal, returns that signal.",325,{"inputs":[{"name":"exitstatusext"}],"output":{"name":"option"}}],[0,"raw","std::os::unix","Unix-specific primitives available on all unix platforms",null,null],[6,"uid_t","std::os::unix::raw","",null,null],[6,"gid_t","","",null,null],[6,"pid_t","","",null,null],[6,"pthread_t","","",null,null],[6,"dev_t","","",null,null],[6,"ino_t","","",null,null],[6,"mode_t","","",null,null],[6,"nlink_t","","",null,null],[6,"off_t","","",null,null],[6,"blksize_t","","",null,null],[6,"blkcnt_t","","",null,null],[6,"time_t","","",null,null],[0,"thread","std::os::unix","Unix-specific extensions to primitives in the `std::thread` module.",null,null],[6,"RawPthread","std::os::unix::thread","",null,null],[8,"JoinHandleExt","","Unix-specific extensions to `std::thread::JoinHandle`",null,null],[10,"as_pthread_t","","Extracts the raw pthread_t without taking ownership",326,{"inputs":[{"name":"joinhandleext"}],"output":{"name":"rawpthread"}}],[10,"into_pthread_t","","Consumes the thread, returning the raw pthread_t",326,{"inputs":[{"name":"joinhandleext"}],"output":{"name":"rawpthread"}}],[11,"as_pthread_t","std::thread","",209,{"inputs":[{"name":"joinhandle"}],"output":{"name":"rawpthread"}}],[11,"into_pthread_t","","",209,{"inputs":[{"name":"joinhandle"}],"output":{"name":"rawpthread"}}],[0,"net","std::os::unix","Unix-specific networking functionality",null,null],[3,"SocketAddr","std::os::unix::net","An address associated with a Unix socket.",null,null],[3,"UnixStream","","A Unix stream socket.",null,null],[3,"UnixListener","","A structure representing a Unix domain socket server.",null,null],[3,"Incoming","","An iterator over incoming connections to a `UnixListener`.",null,null],[3,"UnixDatagram","","A Unix datagram socket.",null,null],[11,"clone","","",327,{"inputs":[{"name":"socketaddr"}],"output":{"name":"socketaddr"}}],[11,"is_unnamed","","Returns true iff the address is unnamed.",327,{"inputs":[{"name":"socketaddr"}],"output":{"name":"bool"}}],[11,"as_pathname","","Returns the contents of this address if it is a `pathname` address.",327,{"inputs":[{"name":"socketaddr"}],"output":{"name":"option"}}],[11,"fmt","","",327,{"inputs":[{"name":"socketaddr"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",328,{"inputs":[{"name":"unixstream"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"connect","","Connects to the socket named by `path`.",328,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[11,"pair","","Creates an unnamed pair of connected sockets.",328,{"inputs":[],"output":{"name":"result"}}],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",328,{"inputs":[{"name":"unixstream"}],"output":{"name":"result"}}],[11,"local_addr","","Returns the socket address of the local half of this connection.",328,{"inputs":[{"name":"unixstream"}],"output":{"name":"result"}}],[11,"peer_addr","","Returns the socket address of the remote half of this connection.",328,{"inputs":[{"name":"unixstream"}],"output":{"name":"result"}}],[11,"set_read_timeout","","Sets the read timeout for the socket.",328,{"inputs":[{"name":"unixstream"},{"name":"option"}],"output":{"name":"result"}}],[11,"set_write_timeout","","Sets the write timeout for the socket.",328,{"inputs":[{"name":"unixstream"},{"name":"option"}],"output":{"name":"result"}}],[11,"read_timeout","","Returns the read timeout of this socket.",328,{"inputs":[{"name":"unixstream"}],"output":{"name":"result"}}],[11,"write_timeout","","Returns the write timeout of this socket.",328,{"inputs":[{"name":"unixstream"}],"output":{"name":"result"}}],[11,"set_nonblocking","","Moves the socket into or out of nonblocking mode.",328,{"inputs":[{"name":"unixstream"},{"name":"bool"}],"output":{"name":"result"}}],[11,"take_error","","Returns the value of the `SO_ERROR` option.",328,{"inputs":[{"name":"unixstream"}],"output":{"name":"result"}}],[11,"shutdown","","Shuts down the read, write, or both halves of this connection.",328,{"inputs":[{"name":"unixstream"},{"name":"shutdown"}],"output":{"name":"result"}}],[11,"read","","",328,null],[11,"read_to_end","","",328,{"inputs":[{"name":"unixstream"},{"name":"vec"}],"output":{"name":"result"}}],[11,"write","","",328,null],[11,"flush","","",328,{"inputs":[{"name":"unixstream"}],"output":{"name":"result"}}],[11,"as_raw_fd","","",328,{"inputs":[{"name":"unixstream"}],"output":{"name":"rawfd"}}],[11,"from_raw_fd","","",328,{"inputs":[{"name":"rawfd"}],"output":{"name":"unixstream"}}],[11,"into_raw_fd","","",328,{"inputs":[{"name":"unixstream"}],"output":{"name":"rawfd"}}],[11,"fmt","","",329,{"inputs":[{"name":"unixlistener"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"bind","","Creates a new `UnixListener` bound to the specified socket.",329,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[11,"accept","","Accepts a new incoming connection to this listener.",329,{"inputs":[{"name":"unixlistener"}],"output":{"name":"result"}}],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",329,{"inputs":[{"name":"unixlistener"}],"output":{"name":"result"}}],[11,"local_addr","","Returns the local socket address of this listener.",329,{"inputs":[{"name":"unixlistener"}],"output":{"name":"result"}}],[11,"set_nonblocking","","Moves the socket into or out of nonblocking mode.",329,{"inputs":[{"name":"unixlistener"},{"name":"bool"}],"output":{"name":"result"}}],[11,"take_error","","Returns the value of the `SO_ERROR` option.",329,{"inputs":[{"name":"unixlistener"}],"output":{"name":"result"}}],[11,"incoming","","Returns an iterator over incoming connections.",329,{"inputs":[{"name":"unixlistener"}],"output":{"name":"incoming"}}],[11,"as_raw_fd","","",329,{"inputs":[{"name":"unixlistener"}],"output":{"name":"rawfd"}}],[11,"from_raw_fd","","",329,{"inputs":[{"name":"rawfd"}],"output":{"name":"unixlistener"}}],[11,"into_raw_fd","","",329,{"inputs":[{"name":"unixlistener"}],"output":{"name":"rawfd"}}],[11,"fmt","","",330,{"inputs":[{"name":"incoming"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",330,{"inputs":[{"name":"incoming"}],"output":{"name":"option"}}],[11,"size_hint","","",330,null],[11,"fmt","","",331,{"inputs":[{"name":"unixdatagram"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"bind","","Creates a Unix datagram socket bound to the given path.",331,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[11,"unbound","","Creates a Unix Datagram socket which is not bound to any address.",331,{"inputs":[],"output":{"name":"result"}}],[11,"pair","","Create an unnamed pair of connected sockets.",331,{"inputs":[],"output":{"name":"result"}}],[11,"connect","","Connects the socket to the specified address.",331,{"inputs":[{"name":"unixdatagram"},{"name":"p"}],"output":{"name":"result"}}],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",331,{"inputs":[{"name":"unixdatagram"}],"output":{"name":"result"}}],[11,"local_addr","","Returns the address of this socket.",331,{"inputs":[{"name":"unixdatagram"}],"output":{"name":"result"}}],[11,"peer_addr","","Returns the address of this socket&#39;s peer.",331,{"inputs":[{"name":"unixdatagram"}],"output":{"name":"result"}}],[11,"recv_from","","Receives data from the socket.",331,null],[11,"recv","","Receives data from the socket.",331,null],[11,"send_to","","Sends data on the socket to the specified address.",331,null],[11,"send","","Sends data on the socket to the socket&#39;s peer.",331,null],[11,"set_read_timeout","","Sets the read timeout for the socket.",331,{"inputs":[{"name":"unixdatagram"},{"name":"option"}],"output":{"name":"result"}}],[11,"set_write_timeout","","Sets the write timeout for the socket.",331,{"inputs":[{"name":"unixdatagram"},{"name":"option"}],"output":{"name":"result"}}],[11,"read_timeout","","Returns the read timeout of this socket.",331,{"inputs":[{"name":"unixdatagram"}],"output":{"name":"result"}}],[11,"write_timeout","","Returns the write timeout of this socket.",331,{"inputs":[{"name":"unixdatagram"}],"output":{"name":"result"}}],[11,"set_nonblocking","","Moves the socket into or out of nonblocking mode.",331,{"inputs":[{"name":"unixdatagram"},{"name":"bool"}],"output":{"name":"result"}}],[11,"take_error","","Returns the value of the `SO_ERROR` option.",331,{"inputs":[{"name":"unixdatagram"}],"output":{"name":"result"}}],[11,"shutdown","","Shut down the read, write, or both halves of this connection.",331,{"inputs":[{"name":"unixdatagram"},{"name":"shutdown"}],"output":{"name":"result"}}],[11,"as_raw_fd","","",331,{"inputs":[{"name":"unixdatagram"}],"output":{"name":"rawfd"}}],[11,"from_raw_fd","","",331,{"inputs":[{"name":"rawfd"}],"output":{"name":"unixdatagram"}}],[11,"into_raw_fd","","",331,{"inputs":[{"name":"unixdatagram"}],"output":{"name":"rawfd"}}],[0,"prelude","std::os::unix","A prelude for conveniently writing platform-specific code.",null,null],[0,"openbsd","std::os","OpenBSD-specific definitions",null,null],[0,"raw","std::os::openbsd","OpenBSD-specific raw type definitions",null,null],[3,"stat","std::os::openbsd::raw","",null,null],[12,"st_mode","","",332,null],[12,"st_dev","","",332,null],[12,"st_ino","","",332,null],[12,"st_nlink","","",332,null],[12,"st_uid","","",332,null],[12,"st_gid","","",332,null],[12,"st_rdev","","",332,null],[12,"st_atime","","",332,null],[12,"st_atime_nsec","","",332,null],[12,"st_mtime","","",332,null],[12,"st_mtime_nsec","","",332,null],[12,"st_ctime","","",332,null],[12,"st_ctime_nsec","","",332,null],[12,"st_size","","",332,null],[12,"st_blocks","","",332,null],[12,"st_blksize","","",332,null],[12,"st_flags","","",332,null],[12,"st_gen","","",332,null],[12,"st_birthtime","","",332,null],[12,"st_birthtime_nsec","","",332,null],[6,"blkcnt_t","","",null,null],[6,"blksize_t","","",null,null],[6,"dev_t","","",null,null],[6,"fflags_t","","",null,null],[6,"ino_t","","",null,null],[6,"mode_t","","",null,null],[6,"nlink_t","","",null,null],[6,"off_t","","",null,null],[6,"time_t","","",null,null],[6,"pthread_t","","",null,null],[11,"clone","","",332,{"inputs":[{"name":"stat"}],"output":{"name":"stat"}}],[0,"fs","std::os::openbsd","",null,null],[8,"MetadataExt","std::os::openbsd::fs","OS-specific extension methods for `fs::Metadata`",null,null],[10,"as_raw_stat","","Gain a reference to the underlying `stat` structure which contains\nthe raw information returned by the OS.",333,{"inputs":[{"name":"metadataext"}],"output":{"name":"stat"}}],[10,"st_dev","","",333,{"inputs":[{"name":"metadataext"}],"output":{"name":"u64"}}],[10,"st_ino","","",333,{"inputs":[{"name":"metadataext"}],"output":{"name":"u64"}}],[10,"st_mode","","",333,{"inputs":[{"name":"metadataext"}],"output":{"name":"u32"}}],[10,"st_nlink","","",333,{"inputs":[{"name":"metadataext"}],"output":{"name":"u64"}}],[10,"st_uid","","",333,{"inputs":[{"name":"metadataext"}],"output":{"name":"u32"}}],[10,"st_gid","","",333,{"inputs":[{"name":"metadataext"}],"output":{"name":"u32"}}],[10,"st_rdev","","",333,{"inputs":[{"name":"metadataext"}],"output":{"name":"u64"}}],[10,"st_size","","",333,{"inputs":[{"name":"metadataext"}],"output":{"name":"u64"}}],[10,"st_atime","","",333,{"inputs":[{"name":"metadataext"}],"output":{"name":"i64"}}],[10,"st_atime_nsec","","",333,{"inputs":[{"name":"metadataext"}],"output":{"name":"i64"}}],[10,"st_mtime","","",333,{"inputs":[{"name":"metadataext"}],"output":{"name":"i64"}}],[10,"st_mtime_nsec","","",333,{"inputs":[{"name":"metadataext"}],"output":{"name":"i64"}}],[10,"st_ctime","","",333,{"inputs":[{"name":"metadataext"}],"output":{"name":"i64"}}],[10,"st_ctime_nsec","","",333,{"inputs":[{"name":"metadataext"}],"output":{"name":"i64"}}],[10,"st_birthtime","","",333,{"inputs":[{"name":"metadataext"}],"output":{"name":"i64"}}],[10,"st_birthtime_nsec","","",333,{"inputs":[{"name":"metadataext"}],"output":{"name":"i64"}}],[10,"st_blksize","","",333,{"inputs":[{"name":"metadataext"}],"output":{"name":"u64"}}],[10,"st_blocks","","",333,{"inputs":[{"name":"metadataext"}],"output":{"name":"u64"}}],[10,"st_flags","","",333,{"inputs":[{"name":"metadataext"}],"output":{"name":"u32"}}],[10,"st_gen","","",333,{"inputs":[{"name":"metadataext"}],"output":{"name":"u32"}}],[11,"as_raw_stat","std::fs","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"stat"}}],[11,"st_dev","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u64"}}],[11,"st_ino","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u64"}}],[11,"st_mode","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u32"}}],[11,"st_nlink","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u64"}}],[11,"st_uid","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u32"}}],[11,"st_gid","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u32"}}],[11,"st_rdev","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u64"}}],[11,"st_size","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u64"}}],[11,"st_atime","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"i64"}}],[11,"st_atime_nsec","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"i64"}}],[11,"st_mtime","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"i64"}}],[11,"st_mtime_nsec","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"i64"}}],[11,"st_ctime","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"i64"}}],[11,"st_ctime_nsec","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"i64"}}],[11,"st_birthtime","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"i64"}}],[11,"st_birthtime_nsec","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"i64"}}],[11,"st_blksize","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u64"}}],[11,"st_blocks","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u64"}}],[11,"st_gen","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u32"}}],[11,"st_flags","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u32"}}],[0,"raw","std::os","Raw OS-specific types for the current platform/architecture",null,null],[4,"c_void","std::os::raw","Type used to construct void pointers for use with C.",null,null],[6,"c_char","","",null,null],[6,"c_schar","","",null,null],[6,"c_uchar","","",null,null],[6,"c_short","","",null,null],[6,"c_ushort","","",null,null],[6,"c_int","","",null,null],[6,"c_uint","","",null,null],[6,"c_long","","",null,null],[6,"c_ulong","","",null,null],[6,"c_longlong","","",null,null],[6,"c_ulonglong","","",null,null],[6,"c_float","","",null,null],[6,"c_double","","",null,null],[0,"panic","std","Panic support in the standard library",null,null],[3,"PanicInfo","std::panic","A struct providing information about a panic.",null,null],[3,"Location","","A struct containing information about the location of a panic.",null,null],[3,"AssertUnwindSafe","","A simple wrapper around a type to assert that it is panic safe.",null,null],[12,"0","","",334,null],[3,"AssertRecoverSafe","","Deprecated, renamed to `AssertUnwindSafe`",null,null],[12,"0","","",335,null],[5,"take_hook","","Unregisters the current panic hook, returning it.",null,{"inputs":[],"output":{"name":"box"}}],[5,"set_hook","","Registers a custom panic hook, replacing any that was previously registered.",null,{"inputs":[{"name":"box"}],"output":null}],[5,"set_handler","","",null,{"inputs":[{"name":"f"}],"output":null}],[5,"take_handler","","",null,{"inputs":[],"output":{"name":"box"}}],[5,"catch_unwind","","Invokes a closure, capturing the cause of an unwinding panic if one occurs.",null,{"inputs":[{"name":"f"}],"output":{"name":"result"}}],[5,"recover","","Deprecated, renamed to `catch_unwind`",null,{"inputs":[{"name":"f"}],"output":{"name":"result"}}],[5,"resume_unwind","","Triggers a panic without invoking the panic handler.",null,{"inputs":[{"name":"box"}],"output":null}],[5,"propagate","","Deprecated, use resume_unwind instead",null,{"inputs":[{"name":"box"}],"output":null}],[8,"UnwindSafe","","A marker trait which represents &quot;panic safe&quot; types in Rust.",null,null],[8,"RecoverSafe","","Deprecated, renamed to UnwindSafe",null,null],[8,"RefUnwindSafe","","A marker trait representing types where a shared reference is considered\nrecover safe.",null,null],[11,"deref","","",334,{"inputs":[{"name":"assertunwindsafe"}],"output":{"name":"t"}}],[11,"deref_mut","","",334,{"inputs":[{"name":"assertunwindsafe"}],"output":{"name":"t"}}],[11,"call_once","","",334,null],[11,"new","","Creates a new `AssertRecoverSafe` wrapper around the provided type.",335,{"inputs":[{"name":"t"}],"output":{"name":"assertrecoversafe"}}],[11,"into_inner","","Consumes the `AssertRecoverSafe`, returning the wrapped value.",335,{"inputs":[{"name":"assertrecoversafe"}],"output":{"name":"t"}}],[11,"deref","","",335,{"inputs":[{"name":"assertrecoversafe"}],"output":{"name":"t"}}],[11,"deref_mut","","",335,{"inputs":[{"name":"assertrecoversafe"}],"output":{"name":"t"}}],[11,"call_once","","",335,null],[0,"path","std","Cross-platform path manipulation.",null,null],[3,"PrefixComponent","std::path","A Windows path prefix, e.g. `C:` or `\\server\\share`.",null,null],[3,"Components","","The core iterator giving the components of a path.",null,null],[3,"Iter","","An iterator over the components of a path, as `OsStr` slices.",null,null],[3,"PathBuf","","An owned, mutable path (akin to `String`).",null,null],[3,"Path","","A slice of a path (akin to `str`).",null,null],[3,"StripPrefixError","","An error returned from the `Path::strip_prefix` method indicating that the\nprefix was not found in `self`.",null,null],[3,"Display","","Helper struct for safely printing paths with `format!()` and `{}`",null,null],[4,"Prefix","","Path prefixes (Windows only).",null,null],[13,"Verbatim","","Prefix `\\\\?\\`, together with the given component immediately following it.",336,null],[13,"VerbatimUNC","","Prefix `\\\\?\\UNC\\`, with the &quot;server&quot; and &quot;share&quot; components following it.",336,null],[13,"VerbatimDisk","","Prefix like `\\\\?\\C:\\`, for the given drive letter",336,null],[13,"DeviceNS","","Prefix `\\\\.\\`, together with the given component immediately following it.",336,null],[13,"UNC","","Prefix `\\\\server\\share`, with the given &quot;server&quot; and &quot;share&quot; components.",336,null],[13,"Disk","","Prefix `C:` for the given disk drive.",336,null],[4,"Component","","A single component of a path.",null,null],[13,"Prefix","","A Windows path prefix, e.g. `C:` or `\\server\\share`.",337,null],[13,"RootDir","","The root directory component, appears after any prefix and before anything else",337,null],[13,"CurDir","","A reference to the current directory, i.e. `.`",337,null],[13,"ParentDir","","A reference to the parent directory, i.e. `..`",337,null],[13,"Normal","","A normal component, i.e. `a` and `b` in `a/b`",337,null],[5,"is_separator","","Determines whether the character is one of the permitted path\nseparators for the current platform.",null,{"inputs":[{"name":"char"}],"output":{"name":"bool"}}],[17,"MAIN_SEPARATOR","","The primary separator for the current platform",null,null],[11,"eq","","",336,{"inputs":[{"name":"prefix"},{"name":"prefix"}],"output":{"name":"bool"}}],[11,"ne","","",336,{"inputs":[{"name":"prefix"},{"name":"prefix"}],"output":{"name":"bool"}}],[11,"cmp","","",336,{"inputs":[{"name":"prefix"},{"name":"prefix"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",336,{"inputs":[{"name":"prefix"},{"name":"prefix"}],"output":{"name":"option"}}],[11,"lt","","",336,{"inputs":[{"name":"prefix"},{"name":"prefix"}],"output":{"name":"bool"}}],[11,"le","","",336,{"inputs":[{"name":"prefix"},{"name":"prefix"}],"output":{"name":"bool"}}],[11,"gt","","",336,{"inputs":[{"name":"prefix"},{"name":"prefix"}],"output":{"name":"bool"}}],[11,"ge","","",336,{"inputs":[{"name":"prefix"},{"name":"prefix"}],"output":{"name":"bool"}}],[11,"hash","","",336,null],[11,"fmt","","",336,{"inputs":[{"name":"prefix"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",336,{"inputs":[{"name":"prefix"}],"output":{"name":"prefix"}}],[11,"is_verbatim","","Determines if the prefix is verbatim, i.e. begins with `\\\\?\\`.",336,{"inputs":[{"name":"prefix"}],"output":{"name":"bool"}}],[11,"fmt","","",338,{"inputs":[{"name":"prefixcomponent"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",338,{"inputs":[{"name":"prefixcomponent"}],"output":{"name":"prefixcomponent"}}],[11,"kind","","The parsed prefix data.",338,{"inputs":[{"name":"prefixcomponent"}],"output":{"name":"prefix"}}],[11,"as_os_str","","The raw `OsStr` slice for this prefix.",338,{"inputs":[{"name":"prefixcomponent"}],"output":{"name":"osstr"}}],[11,"eq","","",338,{"inputs":[{"name":"prefixcomponent"},{"name":"prefixcomponent"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",338,{"inputs":[{"name":"prefixcomponent"},{"name":"prefixcomponent"}],"output":{"name":"option"}}],[11,"cmp","","",338,{"inputs":[{"name":"prefixcomponent"},{"name":"prefixcomponent"}],"output":{"name":"ordering"}}],[11,"hash","","",338,{"inputs":[{"name":"prefixcomponent"},{"name":"h"}],"output":null}],[11,"fmt","","",337,{"inputs":[{"name":"component"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",337,null],[11,"cmp","","",337,{"inputs":[{"name":"component"},{"name":"component"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",337,{"inputs":[{"name":"component"},{"name":"component"}],"output":{"name":"option"}}],[11,"lt","","",337,{"inputs":[{"name":"component"},{"name":"component"}],"output":{"name":"bool"}}],[11,"le","","",337,{"inputs":[{"name":"component"},{"name":"component"}],"output":{"name":"bool"}}],[11,"gt","","",337,{"inputs":[{"name":"component"},{"name":"component"}],"output":{"name":"bool"}}],[11,"ge","","",337,{"inputs":[{"name":"component"},{"name":"component"}],"output":{"name":"bool"}}],[11,"eq","","",337,{"inputs":[{"name":"component"},{"name":"component"}],"output":{"name":"bool"}}],[11,"ne","","",337,{"inputs":[{"name":"component"},{"name":"component"}],"output":{"name":"bool"}}],[11,"clone","","",337,{"inputs":[{"name":"component"}],"output":{"name":"component"}}],[11,"as_os_str","","Extracts the underlying `OsStr` slice",337,{"inputs":[{"name":"component"}],"output":{"name":"osstr"}}],[11,"as_ref","","",337,{"inputs":[{"name":"component"}],"output":{"name":"osstr"}}],[11,"clone","","",339,{"inputs":[{"name":"components"}],"output":{"name":"components"}}],[11,"clone","","",340,{"inputs":[{"name":"iter"}],"output":{"name":"iter"}}],[11,"as_path","","Extracts a slice corresponding to the portion of the path remaining for iteration.",339,{"inputs":[{"name":"components"}],"output":{"name":"path"}}],[11,"as_ref","","",339,{"inputs":[{"name":"components"}],"output":{"name":"path"}}],[11,"as_ref","","",339,{"inputs":[{"name":"components"}],"output":{"name":"osstr"}}],[11,"as_path","","Extracts a slice corresponding to the portion of the path remaining for iteration.",340,{"inputs":[{"name":"iter"}],"output":{"name":"path"}}],[11,"as_ref","","",340,{"inputs":[{"name":"iter"}],"output":{"name":"path"}}],[11,"as_ref","","",340,{"inputs":[{"name":"iter"}],"output":{"name":"osstr"}}],[11,"next","","",340,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"next_back","","",340,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"next","","",339,{"inputs":[{"name":"components"}],"output":{"name":"option"}}],[11,"next_back","","",339,{"inputs":[{"name":"components"}],"output":{"name":"option"}}],[11,"eq","","",339,{"inputs":[{"name":"components"},{"name":"components"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",339,{"inputs":[{"name":"components"},{"name":"components"}],"output":{"name":"option"}}],[11,"cmp","","",339,{"inputs":[{"name":"components"},{"name":"components"}],"output":{"name":"ordering"}}],[11,"clone","","",341,{"inputs":[{"name":"pathbuf"}],"output":{"name":"pathbuf"}}],[11,"new","","Allocates an empty `PathBuf`.",341,{"inputs":[],"output":{"name":"pathbuf"}}],[11,"as_path","","Coerces to a `Path` slice.",341,{"inputs":[{"name":"pathbuf"}],"output":{"name":"path"}}],[11,"push","","Extends `self` with `path`.",341,{"inputs":[{"name":"pathbuf"},{"name":"p"}],"output":null}],[11,"pop","","Truncate `self` to `self.parent()`.",341,{"inputs":[{"name":"pathbuf"}],"output":{"name":"bool"}}],[11,"set_file_name","","Updates `self.file_name()` to `file_name`.",341,{"inputs":[{"name":"pathbuf"},{"name":"s"}],"output":null}],[11,"set_extension","","Updates `self.extension()` to `extension`.",341,{"inputs":[{"name":"pathbuf"},{"name":"s"}],"output":{"name":"bool"}}],[11,"into_os_string","","Consumes the `PathBuf`, yielding its internal `OsString` storage.",341,{"inputs":[{"name":"pathbuf"}],"output":{"name":"osstring"}}],[11,"from","","",341,{"inputs":[{"name":"t"}],"output":{"name":"pathbuf"}}],[11,"from","","",341,{"inputs":[{"name":"osstring"}],"output":{"name":"pathbuf"}}],[11,"from","","",341,{"inputs":[{"name":"string"}],"output":{"name":"pathbuf"}}],[11,"from_iter","","",341,{"inputs":[{"name":"i"}],"output":{"name":"pathbuf"}}],[11,"extend","","",341,{"inputs":[{"name":"pathbuf"},{"name":"i"}],"output":null}],[11,"fmt","","",341,{"inputs":[{"name":"pathbuf"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"deref","","",341,{"inputs":[{"name":"pathbuf"}],"output":{"name":"path"}}],[11,"borrow","","",341,{"inputs":[{"name":"pathbuf"}],"output":{"name":"path"}}],[11,"from","std::borrow","",114,{"inputs":[{"name":"path"}],"output":{"name":"cow"}}],[11,"from","","",114,{"inputs":[{"name":"pathbuf"}],"output":{"name":"cow"}}],[11,"to_owned","std::path","",342,{"inputs":[{"name":"path"}],"output":{"name":"pathbuf"}}],[11,"eq","","",341,{"inputs":[{"name":"pathbuf"},{"name":"pathbuf"}],"output":{"name":"bool"}}],[11,"hash","","",341,{"inputs":[{"name":"pathbuf"},{"name":"h"}],"output":null}],[11,"partial_cmp","","",341,{"inputs":[{"name":"pathbuf"},{"name":"pathbuf"}],"output":{"name":"option"}}],[11,"cmp","","",341,{"inputs":[{"name":"pathbuf"},{"name":"pathbuf"}],"output":{"name":"ordering"}}],[11,"as_ref","","",341,{"inputs":[{"name":"pathbuf"}],"output":{"name":"osstr"}}],[11,"into","","",341,{"inputs":[{"name":"pathbuf"}],"output":{"name":"osstring"}}],[11,"eq","","",343,{"inputs":[{"name":"stripprefixerror"},{"name":"stripprefixerror"}],"output":{"name":"bool"}}],[11,"ne","","",343,{"inputs":[{"name":"stripprefixerror"},{"name":"stripprefixerror"}],"output":{"name":"bool"}}],[11,"clone","","",343,{"inputs":[{"name":"stripprefixerror"}],"output":{"name":"stripprefixerror"}}],[11,"fmt","","",343,{"inputs":[{"name":"stripprefixerror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Directly wrap a string slice as a `Path` slice.",342,{"inputs":[{"name":"s"}],"output":{"name":"path"}}],[11,"as_os_str","","Yields the underlying `OsStr` slice.",342,{"inputs":[{"name":"path"}],"output":{"name":"osstr"}}],[11,"to_str","","Yields a `&amp;str` slice if the `Path` is valid unicode.",342,{"inputs":[{"name":"path"}],"output":{"name":"option"}}],[11,"to_string_lossy","","Converts a `Path` to a `Cow&lt;str&gt;`.",342,{"inputs":[{"name":"path"}],"output":{"name":"cow"}}],[11,"to_path_buf","","Converts a `Path` to an owned `PathBuf`.",342,{"inputs":[{"name":"path"}],"output":{"name":"pathbuf"}}],[11,"is_absolute","","A path is *absolute* if it is independent of the current directory.",342,{"inputs":[{"name":"path"}],"output":{"name":"bool"}}],[11,"is_relative","","A path is *relative* if it is not absolute.",342,{"inputs":[{"name":"path"}],"output":{"name":"bool"}}],[11,"has_root","","A path has a root if the body of the path begins with the directory separator.",342,{"inputs":[{"name":"path"}],"output":{"name":"bool"}}],[11,"parent","","The path without its final component, if any.",342,{"inputs":[{"name":"path"}],"output":{"name":"option"}}],[11,"file_name","","The final component of the path, if it is a normal file.",342,{"inputs":[{"name":"path"}],"output":{"name":"option"}}],[11,"strip_prefix","","Returns a path that, when joined onto `base`, yields `self`.",342,{"inputs":[{"name":"path"},{"name":"p"}],"output":{"name":"result"}}],[11,"starts_with","","Determines whether `base` is a prefix of `self`.",342,{"inputs":[{"name":"path"},{"name":"p"}],"output":{"name":"bool"}}],[11,"ends_with","","Determines whether `child` is a suffix of `self`.",342,{"inputs":[{"name":"path"},{"name":"p"}],"output":{"name":"bool"}}],[11,"file_stem","","Extracts the stem (non-extension) portion of `self.file_name()`.",342,{"inputs":[{"name":"path"}],"output":{"name":"option"}}],[11,"extension","","Extracts the extension of `self.file_name()`, if possible.",342,{"inputs":[{"name":"path"}],"output":{"name":"option"}}],[11,"join","","Creates an owned `PathBuf` with `path` adjoined to `self`.",342,{"inputs":[{"name":"path"},{"name":"p"}],"output":{"name":"pathbuf"}}],[11,"with_file_name","","Creates an owned `PathBuf` like `self` but with the given file name.",342,{"inputs":[{"name":"path"},{"name":"s"}],"output":{"name":"pathbuf"}}],[11,"with_extension","","Creates an owned `PathBuf` like `self` but with the given extension.",342,{"inputs":[{"name":"path"},{"name":"s"}],"output":{"name":"pathbuf"}}],[11,"components","","Produce an iterator over the components of the path.",342,{"inputs":[{"name":"path"}],"output":{"name":"components"}}],[11,"iter","","Produce an iterator over the path&#39;s components viewed as `OsStr` slices.",342,{"inputs":[{"name":"path"}],"output":{"name":"iter"}}],[11,"display","","Returns an object that implements `Display` for safely printing paths\nthat may contain non-Unicode data.",342,{"inputs":[{"name":"path"}],"output":{"name":"display"}}],[11,"metadata","","Query the file system to get information about a file, directory, etc.",342,{"inputs":[{"name":"path"}],"output":{"name":"result"}}],[11,"symlink_metadata","","Query the metadata about a file without following symlinks.",342,{"inputs":[{"name":"path"}],"output":{"name":"result"}}],[11,"canonicalize","","Returns the canonical form of the path with all intermediate components\nnormalized and symbolic links resolved.",342,{"inputs":[{"name":"path"}],"output":{"name":"result"}}],[11,"read_link","","Reads a symbolic link, returning the file that the link points to.",342,{"inputs":[{"name":"path"}],"output":{"name":"result"}}],[11,"read_dir","","Returns an iterator over the entries within a directory.",342,{"inputs":[{"name":"path"}],"output":{"name":"result"}}],[11,"exists","","Returns whether the path points at an existing entity.",342,{"inputs":[{"name":"path"}],"output":{"name":"bool"}}],[11,"is_file","","Returns whether the path is pointing at a regular file.",342,{"inputs":[{"name":"path"}],"output":{"name":"bool"}}],[11,"is_dir","","Returns whether the path is pointing at a directory.",342,{"inputs":[{"name":"path"}],"output":{"name":"bool"}}],[11,"as_ref","","",342,{"inputs":[{"name":"path"}],"output":{"name":"osstr"}}],[11,"fmt","","",342,{"inputs":[{"name":"path"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",344,{"inputs":[{"name":"display"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",344,{"inputs":[{"name":"display"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",342,{"inputs":[{"name":"path"},{"name":"path"}],"output":{"name":"bool"}}],[11,"hash","","",342,{"inputs":[{"name":"path"},{"name":"h"}],"output":null}],[11,"partial_cmp","","",342,{"inputs":[{"name":"path"},{"name":"path"}],"output":{"name":"option"}}],[11,"cmp","","",342,{"inputs":[{"name":"path"},{"name":"path"}],"output":{"name":"ordering"}}],[11,"as_ref","","",342,{"inputs":[{"name":"path"}],"output":{"name":"path"}}],[11,"as_ref","std::ffi","",261,{"inputs":[{"name":"osstr"}],"output":{"name":"path"}}],[11,"as_ref","std::borrow","",114,{"inputs":[{"name":"cow"}],"output":{"name":"path"}}],[11,"as_ref","std::ffi","",260,{"inputs":[{"name":"osstring"}],"output":{"name":"path"}}],[11,"as_ref","std::string","",176,{"inputs":[{"name":"string"}],"output":{"name":"path"}}],[11,"as_ref","std::path","",341,{"inputs":[{"name":"pathbuf"}],"output":{"name":"path"}}],[11,"eq","","",341,{"inputs":[{"name":"pathbuf"},{"name":"path"}],"output":{"name":"bool"}}],[11,"eq","","",342,{"inputs":[{"name":"path"},{"name":"pathbuf"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",341,{"inputs":[{"name":"pathbuf"},{"name":"path"}],"output":{"name":"option"}}],[11,"partial_cmp","","",342,{"inputs":[{"name":"path"},{"name":"pathbuf"}],"output":{"name":"option"}}],[11,"eq","","",341,{"inputs":[{"name":"pathbuf"},{"name":"path"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",341,{"inputs":[{"name":"pathbuf"},{"name":"path"}],"output":{"name":"option"}}],[11,"eq","std::borrow","",114,{"inputs":[{"name":"cow"},{"name":"path"}],"output":{"name":"bool"}}],[11,"eq","std::path","",342,{"inputs":[{"name":"path"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::borrow","",114,{"inputs":[{"name":"cow"},{"name":"path"}],"output":{"name":"option"}}],[11,"partial_cmp","std::path","",342,{"inputs":[{"name":"path"},{"name":"cow"}],"output":{"name":"option"}}],[11,"eq","std::borrow","",114,{"inputs":[{"name":"cow"},{"name":"path"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",114,{"inputs":[{"name":"cow"},{"name":"path"}],"output":{"name":"option"}}],[11,"eq","","",114,{"inputs":[{"name":"cow"},{"name":"pathbuf"}],"output":{"name":"bool"}}],[11,"eq","std::path","",341,{"inputs":[{"name":"pathbuf"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::borrow","",114,{"inputs":[{"name":"cow"},{"name":"pathbuf"}],"output":{"name":"option"}}],[11,"partial_cmp","std::path","",341,{"inputs":[{"name":"pathbuf"},{"name":"cow"}],"output":{"name":"option"}}],[11,"eq","","",341,{"inputs":[{"name":"pathbuf"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"eq","std::ffi","",261,{"inputs":[{"name":"osstr"},{"name":"pathbuf"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::path","",341,{"inputs":[{"name":"pathbuf"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"partial_cmp","std::ffi","",261,{"inputs":[{"name":"osstr"},{"name":"pathbuf"}],"output":{"name":"option"}}],[11,"eq","std::path","",341,{"inputs":[{"name":"pathbuf"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",341,{"inputs":[{"name":"pathbuf"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"eq","","",341,{"inputs":[{"name":"pathbuf"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"eq","std::borrow","",114,{"inputs":[{"name":"cow"},{"name":"pathbuf"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::path","",341,{"inputs":[{"name":"pathbuf"},{"name":"cow"}],"output":{"name":"option"}}],[11,"partial_cmp","std::borrow","",114,{"inputs":[{"name":"cow"},{"name":"pathbuf"}],"output":{"name":"option"}}],[11,"eq","std::path","",341,{"inputs":[{"name":"pathbuf"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"eq","std::ffi","",260,{"inputs":[{"name":"osstring"},{"name":"pathbuf"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::path","",341,{"inputs":[{"name":"pathbuf"},{"name":"osstring"}],"output":{"name":"option"}}],[11,"partial_cmp","std::ffi","",260,{"inputs":[{"name":"osstring"},{"name":"pathbuf"}],"output":{"name":"option"}}],[11,"eq","std::path","",342,{"inputs":[{"name":"path"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"eq","std::ffi","",261,{"inputs":[{"name":"osstr"},{"name":"path"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::path","",342,{"inputs":[{"name":"path"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"partial_cmp","std::ffi","",261,{"inputs":[{"name":"osstr"},{"name":"path"}],"output":{"name":"option"}}],[11,"eq","std::path","",342,{"inputs":[{"name":"path"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",342,{"inputs":[{"name":"path"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"eq","","",342,{"inputs":[{"name":"path"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"eq","std::borrow","",114,{"inputs":[{"name":"cow"},{"name":"path"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::path","",342,{"inputs":[{"name":"path"},{"name":"cow"}],"output":{"name":"option"}}],[11,"partial_cmp","std::borrow","",114,{"inputs":[{"name":"cow"},{"name":"path"}],"output":{"name":"option"}}],[11,"eq","std::path","",342,{"inputs":[{"name":"path"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"eq","std::ffi","",260,{"inputs":[{"name":"osstring"},{"name":"path"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::path","",342,{"inputs":[{"name":"path"},{"name":"osstring"}],"output":{"name":"option"}}],[11,"partial_cmp","std::ffi","",260,{"inputs":[{"name":"osstring"},{"name":"path"}],"output":{"name":"option"}}],[11,"eq","","",261,{"inputs":[{"name":"osstr"},{"name":"path"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",261,{"inputs":[{"name":"osstr"},{"name":"path"}],"output":{"name":"option"}}],[11,"eq","std::borrow","",114,{"inputs":[{"name":"cow"},{"name":"path"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",114,{"inputs":[{"name":"cow"},{"name":"path"}],"output":{"name":"option"}}],[11,"eq","std::ffi","",260,{"inputs":[{"name":"osstring"},{"name":"path"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",260,{"inputs":[{"name":"osstring"},{"name":"path"}],"output":{"name":"option"}}],[11,"eq","std::borrow","",114,{"inputs":[{"name":"cow"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"eq","std::ffi","",261,{"inputs":[{"name":"osstr"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::borrow","",114,{"inputs":[{"name":"cow"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"partial_cmp","std::ffi","",261,{"inputs":[{"name":"osstr"},{"name":"cow"}],"output":{"name":"option"}}],[11,"eq","std::borrow","",114,{"inputs":[{"name":"cow"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",114,{"inputs":[{"name":"cow"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"eq","","",114,{"inputs":[{"name":"cow"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"eq","std::ffi","",260,{"inputs":[{"name":"osstring"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::borrow","",114,{"inputs":[{"name":"cow"},{"name":"osstring"}],"output":{"name":"option"}}],[11,"partial_cmp","std::ffi","",260,{"inputs":[{"name":"osstring"},{"name":"cow"}],"output":{"name":"option"}}],[11,"fmt","std::path","",343,{"inputs":[{"name":"stripprefixerror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",343,{"inputs":[{"name":"stripprefixerror"}],"output":{"name":"str"}}],[0,"process","std","Working with processes.",null,null],[3,"Child","std::process","Representation of a running or exited child process.",null,null],[12,"stdin","","The handle for writing to the child&#39;s stdin, if it has been captured",345,null],[12,"stdout","","The handle for reading from the child&#39;s stdout, if it has been captured",345,null],[12,"stderr","","The handle for reading from the child&#39;s stderr, if it has been captured",345,null],[3,"ChildStdin","","A handle to a child process&#39;s stdin",null,null],[3,"ChildStdout","","A handle to a child process&#39;s stdout",null,null],[3,"ChildStderr","","A handle to a child process&#39;s stderr",null,null],[3,"Command","","The `Command` type acts as a process builder, providing fine-grained control\nover how a new process should be spawned. A default configuration can be\ngenerated using `Command::new(program)`, where `program` gives a path to the\nprogram to be executed. Additional builder methods allow the configuration\nto be changed (for example, by adding arguments) prior to spawning:",null,null],[3,"Output","","The output of a finished process.",null,null],[12,"status","","The status (exit code) of the process.",346,null],[12,"stdout","","The data that the process wrote to stdout.",346,null],[12,"stderr","","The data that the process wrote to stderr.",346,null],[3,"Stdio","","Describes what to do with a standard I/O stream for a child process.",null,null],[3,"ExitStatus","","Describes the result of a process after it has terminated.",null,null],[5,"exit","","Terminates the current process with the specified exit code.",null,{"inputs":[{"name":"i32"}],"output":null}],[11,"write","","",347,null],[11,"flush","","",347,{"inputs":[{"name":"childstdin"}],"output":{"name":"result"}}],[11,"read","","",348,null],[11,"read_to_end","","",348,{"inputs":[{"name":"childstdout"},{"name":"vec"}],"output":{"name":"result"}}],[11,"read","","",349,null],[11,"read_to_end","","",349,{"inputs":[{"name":"childstderr"},{"name":"vec"}],"output":{"name":"result"}}],[11,"new","","Constructs a new `Command` for launching the program at\npath `program`, with the following default configuration:",350,{"inputs":[{"name":"s"}],"output":{"name":"command"}}],[11,"arg","","Add an argument to pass to the program.",350,{"inputs":[{"name":"command"},{"name":"s"}],"output":{"name":"command"}}],[11,"args","","Add multiple arguments to pass to the program.",350,null],[11,"env","","Inserts or updates an environment variable mapping.",350,{"inputs":[{"name":"command"},{"name":"k"},{"name":"v"}],"output":{"name":"command"}}],[11,"env_remove","","Removes an environment variable mapping.",350,{"inputs":[{"name":"command"},{"name":"k"}],"output":{"name":"command"}}],[11,"env_clear","","Clears the entire environment map for the child process.",350,{"inputs":[{"name":"command"}],"output":{"name":"command"}}],[11,"current_dir","","Sets the working directory for the child process.",350,{"inputs":[{"name":"command"},{"name":"p"}],"output":{"name":"command"}}],[11,"stdin","","Configuration for the child process&#39;s stdin handle (file descriptor 0).",350,{"inputs":[{"name":"command"},{"name":"stdio"}],"output":{"name":"command"}}],[11,"stdout","","Configuration for the child process&#39;s stdout handle (file descriptor 1).",350,{"inputs":[{"name":"command"},{"name":"stdio"}],"output":{"name":"command"}}],[11,"stderr","","Configuration for the child process&#39;s stderr handle (file descriptor 2).",350,{"inputs":[{"name":"command"},{"name":"stdio"}],"output":{"name":"command"}}],[11,"spawn","","Executes the command as a child process, returning a handle to it.",350,{"inputs":[{"name":"command"}],"output":{"name":"result"}}],[11,"output","","Executes the command as a child process, waiting for it to finish and\ncollecting all of its output.",350,{"inputs":[{"name":"command"}],"output":{"name":"result"}}],[11,"status","","Executes a command as a child process, waiting for it to finish and\ncollecting its exit status.",350,{"inputs":[{"name":"command"}],"output":{"name":"result"}}],[11,"fmt","","Format the program and arguments of a Command for display. Any\nnon-utf8 data is lossily converted using the utf8 replacement\ncharacter.",350,{"inputs":[{"name":"command"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",346,{"inputs":[{"name":"output"}],"output":{"name":"output"}}],[11,"eq","","",346,{"inputs":[{"name":"output"},{"name":"output"}],"output":{"name":"bool"}}],[11,"ne","","",346,{"inputs":[{"name":"output"},{"name":"output"}],"output":{"name":"bool"}}],[11,"fmt","","",346,{"inputs":[{"name":"output"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"piped","","A new pipe should be arranged to connect the parent and child processes.",351,{"inputs":[],"output":{"name":"stdio"}}],[11,"inherit","","The child inherits from the corresponding parent descriptor.",351,{"inputs":[],"output":{"name":"stdio"}}],[11,"null","","This stream will be ignored. This is the equivalent of attaching the\nstream to `/dev/null`",351,{"inputs":[],"output":{"name":"stdio"}}],[11,"fmt","","",352,{"inputs":[{"name":"exitstatus"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",352,{"inputs":[{"name":"exitstatus"}],"output":{"name":"exitstatus"}}],[11,"eq","","",352,{"inputs":[{"name":"exitstatus"},{"name":"exitstatus"}],"output":{"name":"bool"}}],[11,"ne","","",352,{"inputs":[{"name":"exitstatus"},{"name":"exitstatus"}],"output":{"name":"bool"}}],[11,"success","","Was termination successful? Signal termination not considered a success,\nand success is defined as a zero exit status.",352,{"inputs":[{"name":"exitstatus"}],"output":{"name":"bool"}}],[11,"code","","Returns the exit code of the process, if any.",352,{"inputs":[{"name":"exitstatus"}],"output":{"name":"option"}}],[11,"fmt","","",352,{"inputs":[{"name":"exitstatus"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"kill","","Forces the child to exit. This is equivalent to sending a\nSIGKILL on unix platforms.",345,{"inputs":[{"name":"child"}],"output":{"name":"result"}}],[11,"id","","Returns the OS-assigned process identifier associated with this child.",345,{"inputs":[{"name":"child"}],"output":{"name":"u32"}}],[11,"wait","","Waits for the child to exit completely, returning the status that it\nexited with. This function will continue to have the same return value\nafter it has been called at least once.",345,{"inputs":[{"name":"child"}],"output":{"name":"result"}}],[11,"wait_with_output","","Simultaneously waits for the child to exit and collect all remaining\noutput on the stdout/stderr handles, returning an `Output`\ninstance.",345,{"inputs":[{"name":"child"}],"output":{"name":"result"}}],[0,"sync","std","Useful synchronization primitives.",null,null],[11,"fmt","alloc::arc","",353,{"inputs":[{"name":"arc"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",353,{"inputs":[{"name":"arc"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",353,{"inputs":[{"name":"arc"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"cmp","","",353,{"inputs":[{"name":"arc"},{"name":"arc"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","Partial comparison for two `Arc&lt;T&gt;`s.",353,{"inputs":[{"name":"arc"},{"name":"arc"}],"output":{"name":"option"}}],[11,"lt","","Less-than comparison for two `Arc&lt;T&gt;`s.",353,{"inputs":[{"name":"arc"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"le","","&#39;Less-than or equal to&#39; comparison for two `Arc&lt;T&gt;`s.",353,{"inputs":[{"name":"arc"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"gt","","Greater-than comparison for two `Arc&lt;T&gt;`s.",353,{"inputs":[{"name":"arc"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"ge","","&#39;Greater-than or equal to&#39; comparison for two `Arc&lt;T&gt;`s.",353,{"inputs":[{"name":"arc"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"eq","","Equality for two `Arc&lt;T&gt;`s.",353,{"inputs":[{"name":"arc"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"ne","","Inequality for two `Arc&lt;T&gt;`s.",353,{"inputs":[{"name":"arc"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"drop","","Drops the `Arc&lt;T&gt;`.",353,null],[11,"get_mut","","Returns a mutable reference to the contained value if the `Arc&lt;T&gt;` has\none strong reference and no weak references.",353,{"inputs":[{"name":"arc"}],"output":{"name":"option"}}],[11,"make_mut","","Make a mutable reference into the given `Arc&lt;T&gt;`.\nIf the `Arc&lt;T&gt;` has more than one strong reference, or any weak\nreferences, the inner data is cloned.",353,{"inputs":[{"name":"arc"}],"output":{"name":"t"}}],[11,"deref","","",353,{"inputs":[{"name":"arc"}],"output":{"name":"t"}}],[11,"clone","","Makes a clone of the `Arc&lt;T&gt;`.",353,{"inputs":[{"name":"arc"}],"output":{"name":"arc"}}],[11,"downgrade","","Downgrades the `Arc&lt;T&gt;` to a `Weak&lt;T&gt;` reference.",353,{"inputs":[{"name":"arc"}],"output":{"name":"weak"}}],[11,"weak_count","","Get the number of weak references to this value.",353,{"inputs":[{"name":"arc"}],"output":{"name":"usize"}}],[11,"strong_count","","Get the number of strong references to this value.",353,{"inputs":[{"name":"arc"}],"output":{"name":"usize"}}],[11,"new","","Constructs a new `Arc&lt;T&gt;`.",353,{"inputs":[{"name":"t"}],"output":{"name":"arc"}}],[11,"try_unwrap","","Unwraps the contained value if the `Arc&lt;T&gt;` has exactly one strong reference.",353,{"inputs":[{"name":"arc"}],"output":{"name":"result"}}],[11,"as_ref","","",353,{"inputs":[{"name":"arc"}],"output":{"name":"t"}}],[11,"borrow","","",353,{"inputs":[{"name":"arc"}],"output":{"name":"t"}}],[11,"from","","",353,{"inputs":[{"name":"t"}],"output":{"name":"arc"}}],[11,"hash","","",353,null],[11,"default","","",353,{"inputs":[],"output":{"name":"arc"}}],[3,"Arc","std::sync","An atomically reference counted wrapper for shared state.",null,null],[11,"fmt","alloc::arc","",354,{"inputs":[{"name":"weak"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Constructs a new `Weak&lt;T&gt;` without an accompanying instance of T.",354,{"inputs":[],"output":{"name":"weak"}}],[11,"drop","","Drops the `Weak&lt;T&gt;`.",354,null],[11,"clone","","Makes a clone of the `Weak&lt;T&gt;`.",354,{"inputs":[{"name":"weak"}],"output":{"name":"weak"}}],[11,"upgrade","","Upgrades a weak reference to a strong reference.",354,{"inputs":[{"name":"weak"}],"output":{"name":"option"}}],[3,"Weak","std::sync","A weak pointer to an `Arc`.",null,null],[0,"atomic","","Atomic types",null,null],[11,"new","core::sync::atomic","Creates a new `AtomicBool`.",355,{"inputs":[{"name":"bool"}],"output":{"name":"atomicbool"}}],[11,"load","","Loads a value from the bool.",355,{"inputs":[{"name":"atomicbool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"store","","Stores a value into the bool.",355,null],[11,"swap","","Stores a value into the bool, returning the old value.",355,{"inputs":[{"name":"atomicbool"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"compare_and_swap","","Stores a value into the `bool` if the current value is the same as the `current` value.",355,{"inputs":[{"name":"atomicbool"},{"name":"bool"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"compare_exchange","","Stores a value into the `bool` if the current value is the same as the `current` value.",355,{"inputs":[{"name":"atomicbool"},{"name":"bool"},{"name":"bool"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the `bool` if the current value is the same as the `current` value.",355,{"inputs":[{"name":"atomicbool"},{"name":"bool"},{"name":"bool"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_and","","Logical &quot;and&quot; with a boolean value.",355,{"inputs":[{"name":"atomicbool"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"fetch_nand","","Logical &quot;nand&quot; with a boolean value.",355,{"inputs":[{"name":"atomicbool"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"fetch_or","","Logical &quot;or&quot; with a boolean value.",355,{"inputs":[{"name":"atomicbool"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"fetch_xor","","Logical &quot;xor&quot; with a boolean value.",355,{"inputs":[{"name":"atomicbool"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"default","","",355,{"inputs":[],"output":{"name":"atomicbool"}}],[11,"fmt","","",355,{"inputs":[{"name":"atomicbool"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"AtomicBool","std::sync::atomic","A boolean type which can be safely shared between threads.",null,null],[11,"new","core::sync::atomic","Creates a new `AtomicIsize`.",356,{"inputs":[{"name":"isize"}],"output":{"name":"atomicisize"}}],[11,"load","","Loads a value from the isize.",356,{"inputs":[{"name":"atomicisize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"store","","Stores a value into the isize.",356,null],[11,"swap","","Stores a value into the isize, returning the old value.",356,{"inputs":[{"name":"atomicisize"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"compare_and_swap","","Stores a value into the `isize` if the current value is the same as the `current` value.",356,{"inputs":[{"name":"atomicisize"},{"name":"isize"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"compare_exchange","","Stores a value into the `isize` if the current value is the same as the `current` value.",356,{"inputs":[{"name":"atomicisize"},{"name":"isize"},{"name":"isize"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the `isize` if the current value is the same as the `current` value.",356,{"inputs":[{"name":"atomicisize"},{"name":"isize"},{"name":"isize"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_add","","Add an isize to the current value, returning the previous value.",356,{"inputs":[{"name":"atomicisize"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"fetch_sub","","Subtract an isize from the current value, returning the previous value.",356,{"inputs":[{"name":"atomicisize"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"fetch_and","","Bitwise and with the current isize, returning the previous value.",356,{"inputs":[{"name":"atomicisize"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"fetch_or","","Bitwise or with the current isize, returning the previous value.",356,{"inputs":[{"name":"atomicisize"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"fetch_xor","","Bitwise xor with the current isize, returning the previous value.",356,{"inputs":[{"name":"atomicisize"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"default","","",356,{"inputs":[],"output":{"name":"atomicisize"}}],[11,"fmt","","",356,{"inputs":[{"name":"atomicisize"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"AtomicIsize","std::sync::atomic","A signed integer type which can be safely shared between threads.",null,null],[11,"fmt","core::sync::atomic","",357,{"inputs":[{"name":"atomicusize"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","",357,{"inputs":[],"output":{"name":"atomicusize"}}],[11,"new","","Creates a new `AtomicUsize`.",357,{"inputs":[{"name":"usize"}],"output":{"name":"atomicusize"}}],[11,"load","","Loads a value from the usize.",357,{"inputs":[{"name":"atomicusize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"store","","Stores a value into the usize.",357,null],[11,"swap","","Stores a value into the usize, returning the old value.",357,{"inputs":[{"name":"atomicusize"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"compare_and_swap","","Stores a value into the `usize` if the current value is the same as the `current` value.",357,{"inputs":[{"name":"atomicusize"},{"name":"usize"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"compare_exchange","","Stores a value into the `usize` if the current value is the same as the `current` value.",357,{"inputs":[{"name":"atomicusize"},{"name":"usize"},{"name":"usize"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the `usize` if the current value is the same as the `current` value.",357,{"inputs":[{"name":"atomicusize"},{"name":"usize"},{"name":"usize"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_add","","Add to the current usize, returning the previous value.",357,{"inputs":[{"name":"atomicusize"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fetch_sub","","Subtract from the current usize, returning the previous value.",357,{"inputs":[{"name":"atomicusize"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fetch_and","","Bitwise and with the current usize, returning the previous value.",357,{"inputs":[{"name":"atomicusize"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fetch_or","","Bitwise or with the current usize, returning the previous value.",357,{"inputs":[{"name":"atomicusize"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fetch_xor","","Bitwise xor with the current usize, returning the previous value.",357,{"inputs":[{"name":"atomicusize"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[3,"AtomicUsize","std::sync::atomic","An unsigned integer type which can be safely shared between threads.",null,null],[11,"fmt","core::sync::atomic","",358,{"inputs":[{"name":"atomicptr"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new `AtomicPtr`.",358,null],[11,"load","","Loads a value from the pointer.",358,null],[11,"store","","Stores a value into the pointer.",358,null],[11,"swap","","Stores a value into the pointer, returning the old value.",358,null],[11,"compare_and_swap","","Stores a value into the pointer if the current value is the same as the `current` value.",358,null],[11,"compare_exchange","","Stores a value into the pointer if the current value is the same as the `current` value.",358,null],[11,"compare_exchange_weak","","Stores a value into the pointer if the current value is the same as the `current` value.",358,null],[11,"default","","",358,{"inputs":[],"output":{"name":"atomicptr"}}],[3,"AtomicPtr","std::sync::atomic","A raw pointer type which can be safely shared between threads.",null,null],[11,"fmt","core::sync::atomic","",359,{"inputs":[{"name":"ordering"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",359,{"inputs":[{"name":"ordering"}],"output":{"name":"ordering"}}],[4,"Ordering","std::sync::atomic","Atomic memory orderings",null,null],[13,"Relaxed","","No ordering constraints, only atomic operations. Corresponds to LLVM&#39;s\n`Monotonic` ordering.",359,null],[13,"Release","","When coupled with a store, all previous writes become visible\nto another thread that performs a load with `Acquire` ordering\non the same value.",359,null],[13,"Acquire","","When coupled with a load, all subsequent loads will see data\nwritten before a store with `Release` ordering on the same value\nin another thread.",359,null],[13,"AcqRel","","When coupled with a load, uses `Acquire` ordering, and with a store\n`Release` ordering.",359,null],[13,"SeqCst","","Like `AcqRel` with the additional guarantee that all threads see all\nsequentially consistent operations in the same order.",359,null],[17,"ATOMIC_BOOL_INIT","","An `AtomicBool` initialized to `false`.",null,null],[17,"ATOMIC_ISIZE_INIT","","An `AtomicIsize` initialized to `0`.",null,null],[17,"ATOMIC_USIZE_INIT","","An `AtomicUsize` initialized to `0`.",null,null],[5,"fence","","An atomic fence.",null,null],[3,"Barrier","std::sync","A barrier enables multiple threads to synchronize the beginning\nof some computation.",null,null],[3,"BarrierWaitResult","","A result returned from wait.",null,null],[3,"Condvar","","A Condition Variable",null,null],[3,"StaticCondvar","","Statically allocated condition variables.",null,null],[3,"WaitTimeoutResult","","A type indicating whether a timed wait on a condition variable returned\ndue to a time out or not.",null,null],[3,"Mutex","","A mutual exclusion primitive useful for protecting shared data",null,null],[3,"MutexGuard","","An RAII implementation of a &quot;scoped lock&quot; of a mutex. When this structure is\ndropped (falls out of scope), the lock will be unlocked.",null,null],[3,"StaticMutex","","The static mutex type is provided to allow for static allocation of mutexes.",null,null],[3,"Once","","A synchronization primitive which can be used to run a one-time global\ninitialization. Useful for one-time initialization for FFI or related\nfunctionality. This type can only be constructed with the `ONCE_INIT`\nvalue.",null,null],[3,"PoisonError","","A type of error which can be returned whenever a lock is acquired.",null,null],[3,"RwLockReadGuard","","RAII structure used to release the shared read access of a lock when\ndropped.",null,null],[3,"RwLockWriteGuard","","RAII structure used to release the exclusive write access of a lock when\ndropped.",null,null],[3,"RwLock","","A reader-writer lock",null,null],[3,"StaticRwLock","","Structure representing a statically allocated RwLock.",null,null],[4,"TryLockError","","An enumeration of possible errors which can occur while calling the\n`try_lock` method.",null,null],[13,"Poisoned","","The lock could not be acquired because another thread failed while holding\nthe lock.",360,null],[13,"WouldBlock","","The lock could not be acquired at this time because the operation would\notherwise block.",360,null],[0,"mpsc","","Multi-producer, single-consumer FIFO queue communication primitives.",null,null],[3,"Select","std::sync::mpsc","The &quot;receiver set&quot; of the select interface. This structure is used to manage\na set of receivers which are being selected over.",null,null],[3,"Handle","","A handle to a receiver which is currently a member of a `Select` set of\nreceivers.  This handle is used to keep the receiver in the set as well as\ninteract with the underlying receiver.",null,null],[3,"Receiver","","The receiving-half of Rust&#39;s channel type. This half can only be owned by\none thread",null,null],[3,"Iter","","An iterator over messages on a receiver, this iterator will block\nwhenever `next` is called, waiting for a new message, and `None` will be\nreturned when the corresponding channel has hung up.",null,null],[3,"IntoIter","","An owning iterator over messages on a receiver, this iterator will block\nwhenever `next` is called, waiting for a new message, and `None` will be\nreturned when the corresponding channel has hung up.",null,null],[3,"Sender","","The sending-half of Rust&#39;s asynchronous channel type. This half can only be\nowned by one thread, but it can be cloned to send to other threads.",null,null],[3,"SyncSender","","The sending-half of Rust&#39;s synchronous channel type. This half can only be\nowned by one thread, but it can be cloned to send to other threads.",null,null],[3,"SendError","","An error returned from the `send` function on channels.",null,null],[12,"0","","",361,null],[3,"RecvError","","An error returned from the `recv` function on a `Receiver`.",null,null],[4,"TryRecvError","","This enumeration is the list of the possible reasons that `try_recv` could\nnot return data when called.",null,null],[13,"Empty","","This channel is currently empty, but the sender(s) have not yet\ndisconnected, so data may yet become available.",362,null],[13,"Disconnected","","This channel&#39;s sending half has become disconnected, and there will\nnever be any more data received on this channel",362,null],[4,"TrySendError","","This enumeration is the list of the possible error outcomes for the\n`SyncSender::try_send` method.",null,null],[13,"Full","","The data could not be sent on the channel because it would require that\nthe callee block to send the data.",363,null],[13,"Disconnected","","This channel&#39;s receiving half has disconnected, so the data could not be\nsent. The data is returned back to the callee in this case.",363,null],[5,"channel","","Creates a new asynchronous channel, returning the sender/receiver halves.",null,null],[5,"sync_channel","","Creates a new synchronous, bounded channel.",null,null],[11,"new","","Creates a new selection structure. This set is initially empty.",364,{"inputs":[],"output":{"name":"select"}}],[11,"handle","","Creates a new handle into this receiver set for a new receiver. Note\nthat this does *not* add the receiver to the receiver set, for that you\nmust call the `add` method on the handle itself.",364,{"inputs":[{"name":"select"},{"name":"receiver"}],"output":{"name":"handle"}}],[11,"wait","","Waits for an event on this receiver set. The returned value is *not* an\nindex, but rather an id. This id can be queried against any active\n`Handle` structures (each one has an `id` method). The handle with\nthe matching `id` will have some sort of event available on it. The\nevent could either be that data is available or the corresponding\nchannel has been closed.",364,{"inputs":[{"name":"select"}],"output":{"name":"usize"}}],[11,"id","","Retrieves the id of this handle.",365,{"inputs":[{"name":"handle"}],"output":{"name":"usize"}}],[11,"recv","","Blocks to receive a value on the underlying receiver, returning `Some` on\nsuccess or `None` if the channel disconnects. This function has the same\nsemantics as `Receiver.recv`",365,{"inputs":[{"name":"handle"}],"output":{"name":"result"}}],[11,"add","","Adds this handle to the receiver set that the handle was created from. This\nmethod can be called multiple times, but it has no effect if `add` was\ncalled previously.",365,{"inputs":[{"name":"handle"}],"output":null}],[11,"remove","","Removes this handle from the `Select` set. This method is unsafe because\nit has no guarantee that the `Handle` was not moved since `add` was\ncalled.",365,{"inputs":[{"name":"handle"}],"output":null}],[11,"drop","","",364,{"inputs":[{"name":"select"}],"output":null}],[11,"drop","","",365,{"inputs":[{"name":"handle"}],"output":null}],[11,"fmt","","",364,{"inputs":[{"name":"select"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",365,{"inputs":[{"name":"handle"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",361,{"inputs":[{"name":"senderror"}],"output":{"name":"senderror"}}],[11,"eq","","",361,{"inputs":[{"name":"senderror"},{"name":"senderror"}],"output":{"name":"bool"}}],[11,"ne","","",361,{"inputs":[{"name":"senderror"},{"name":"senderror"}],"output":{"name":"bool"}}],[11,"fmt","","",366,{"inputs":[{"name":"recverror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",366,{"inputs":[{"name":"recverror"}],"output":{"name":"recverror"}}],[11,"eq","","",366,{"inputs":[{"name":"recverror"},{"name":"recverror"}],"output":{"name":"bool"}}],[11,"fmt","","",362,{"inputs":[{"name":"tryrecverror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",362,{"inputs":[{"name":"tryrecverror"}],"output":{"name":"tryrecverror"}}],[11,"eq","","",362,{"inputs":[{"name":"tryrecverror"},{"name":"tryrecverror"}],"output":{"name":"bool"}}],[11,"clone","","",363,{"inputs":[{"name":"trysenderror"}],"output":{"name":"trysenderror"}}],[11,"eq","","",363,{"inputs":[{"name":"trysenderror"},{"name":"trysenderror"}],"output":{"name":"bool"}}],[11,"ne","","",363,{"inputs":[{"name":"trysenderror"},{"name":"trysenderror"}],"output":{"name":"bool"}}],[11,"send","","Attempts to send a value on this channel, returning it back if it could\nnot be sent.",367,{"inputs":[{"name":"sender"},{"name":"t"}],"output":{"name":"result"}}],[11,"clone","","",367,{"inputs":[{"name":"sender"}],"output":{"name":"sender"}}],[11,"drop","","",367,{"inputs":[{"name":"sender"}],"output":null}],[11,"fmt","","",367,{"inputs":[{"name":"sender"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"send","","Sends a value on this synchronous channel.",368,{"inputs":[{"name":"syncsender"},{"name":"t"}],"output":{"name":"result"}}],[11,"try_send","","Attempts to send a value on this channel without blocking.",368,{"inputs":[{"name":"syncsender"},{"name":"t"}],"output":{"name":"result"}}],[11,"clone","","",368,{"inputs":[{"name":"syncsender"}],"output":{"name":"syncsender"}}],[11,"drop","","",368,{"inputs":[{"name":"syncsender"}],"output":null}],[11,"fmt","","",368,{"inputs":[{"name":"syncsender"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"try_recv","","Attempts to return a pending value on this receiver without blocking",369,{"inputs":[{"name":"receiver"}],"output":{"name":"result"}}],[11,"recv","","Attempts to wait for a value on this receiver, returning an error if the\ncorresponding channel has hung up.",369,{"inputs":[{"name":"receiver"}],"output":{"name":"result"}}],[11,"iter","","Returns an iterator that will block waiting for messages, but never\n`panic!`. It will return `None` when the channel has hung up.",369,{"inputs":[{"name":"receiver"}],"output":{"name":"iter"}}],[11,"next","","",370,{"inputs":[{"name":"iter"}],"output":{"name":"option"}}],[11,"next","","",371,{"inputs":[{"name":"intoiter"}],"output":{"name":"option"}}],[11,"into_iter","","",369,{"inputs":[{"name":"receiver"}],"output":{"name":"intoiter"}}],[11,"drop","","",369,{"inputs":[{"name":"receiver"}],"output":null}],[11,"fmt","","",369,{"inputs":[{"name":"receiver"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",361,{"inputs":[{"name":"senderror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",361,{"inputs":[{"name":"senderror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",361,{"inputs":[{"name":"senderror"}],"output":{"name":"str"}}],[11,"cause","","",361,{"inputs":[{"name":"senderror"}],"output":{"name":"option"}}],[11,"fmt","","",363,{"inputs":[{"name":"trysenderror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",363,{"inputs":[{"name":"trysenderror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",363,{"inputs":[{"name":"trysenderror"}],"output":{"name":"str"}}],[11,"cause","","",363,{"inputs":[{"name":"trysenderror"}],"output":{"name":"option"}}],[11,"fmt","","",366,{"inputs":[{"name":"recverror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",366,{"inputs":[{"name":"recverror"}],"output":{"name":"str"}}],[11,"cause","","",366,{"inputs":[{"name":"recverror"}],"output":{"name":"option"}}],[11,"fmt","","",362,{"inputs":[{"name":"tryrecverror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",362,{"inputs":[{"name":"tryrecverror"}],"output":{"name":"str"}}],[11,"cause","","",362,{"inputs":[{"name":"tryrecverror"}],"output":{"name":"option"}}],[11,"new","std::sync","Creates a new barrier that can block a given number of threads.",372,{"inputs":[{"name":"usize"}],"output":{"name":"barrier"}}],[11,"wait","","Blocks the current thread until all threads has rendezvoused here.",372,{"inputs":[{"name":"barrier"}],"output":{"name":"barrierwaitresult"}}],[11,"is_leader","","Returns whether this thread from `wait` is the &quot;leader thread&quot;.",373,{"inputs":[{"name":"barrierwaitresult"}],"output":{"name":"bool"}}],[11,"clone","","",374,{"inputs":[{"name":"waittimeoutresult"}],"output":{"name":"waittimeoutresult"}}],[11,"eq","","",374,{"inputs":[{"name":"waittimeoutresult"},{"name":"waittimeoutresult"}],"output":{"name":"bool"}}],[11,"ne","","",374,{"inputs":[{"name":"waittimeoutresult"},{"name":"waittimeoutresult"}],"output":{"name":"bool"}}],[11,"fmt","","",374,{"inputs":[{"name":"waittimeoutresult"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"timed_out","","Returns whether the wait was known to have timed out.",374,{"inputs":[{"name":"waittimeoutresult"}],"output":{"name":"bool"}}],[11,"new","","Creates a new condition variable which is ready to be waited on and\nnotified.",375,{"inputs":[],"output":{"name":"condvar"}}],[11,"wait","","Blocks the current thread until this condition variable receives a\nnotification.",375,{"inputs":[{"name":"condvar"},{"name":"mutexguard"}],"output":{"name":"lockresult"}}],[11,"wait_timeout_ms","","Waits on this condition variable for a notification, timing out after a\nspecified duration.",375,{"inputs":[{"name":"condvar"},{"name":"mutexguard"},{"name":"u32"}],"output":{"name":"lockresult"}}],[11,"wait_timeout","","Waits on this condition variable for a notification, timing out after a\nspecified duration.",375,{"inputs":[{"name":"condvar"},{"name":"mutexguard"},{"name":"duration"}],"output":{"name":"lockresult"}}],[11,"notify_one","","Wakes up one blocked thread on this condvar.",375,{"inputs":[{"name":"condvar"}],"output":null}],[11,"notify_all","","Wakes up all blocked threads on this condvar.",375,{"inputs":[{"name":"condvar"}],"output":null}],[11,"drop","","",375,{"inputs":[{"name":"condvar"}],"output":null}],[11,"new","","Creates a new condition variable",376,{"inputs":[],"output":{"name":"staticcondvar"}}],[11,"wait","","Blocks the current thread until this condition variable receives a\nnotification.",376,{"inputs":[{"name":"staticcondvar"},{"name":"mutexguard"}],"output":{"name":"lockresult"}}],[11,"wait_timeout","","Waits on this condition variable for a notification, timing out after a\nspecified duration.",376,{"inputs":[{"name":"staticcondvar"},{"name":"mutexguard"},{"name":"duration"}],"output":{"name":"lockresult"}}],[11,"wait_timeout_with","","Waits on this condition variable for a notification, timing out after a\nspecified duration.",376,{"inputs":[{"name":"staticcondvar"},{"name":"mutexguard"},{"name":"duration"},{"name":"f"}],"output":{"name":"lockresult"}}],[11,"notify_one","","Wakes up one blocked thread on this condvar.",376,{"inputs":[{"name":"staticcondvar"}],"output":null}],[11,"notify_all","","Wakes up all blocked threads on this condvar.",376,{"inputs":[{"name":"staticcondvar"}],"output":null}],[11,"destroy","","Deallocates all resources associated with this static condvar.",376,{"inputs":[{"name":"staticcondvar"}],"output":null}],[11,"new","","Creates a new mutex in an unlocked state ready for use.",377,{"inputs":[{"name":"t"}],"output":{"name":"mutex"}}],[11,"lock","","Acquires a mutex, blocking the current thread until it is able to do so.",377,{"inputs":[{"name":"mutex"}],"output":{"name":"lockresult"}}],[11,"try_lock","","Attempts to acquire this lock.",377,{"inputs":[{"name":"mutex"}],"output":{"name":"trylockresult"}}],[11,"is_poisoned","","Determines whether the lock is poisoned.",377,{"inputs":[{"name":"mutex"}],"output":{"name":"bool"}}],[11,"into_inner","","Consumes this mutex, returning the underlying data.",377,{"inputs":[{"name":"mutex"}],"output":{"name":"lockresult"}}],[11,"get_mut","","Returns a mutable reference to the underlying data.",377,{"inputs":[{"name":"mutex"}],"output":{"name":"lockresult"}}],[11,"drop","","",377,{"inputs":[{"name":"mutex"}],"output":null}],[11,"fmt","","",377,{"inputs":[{"name":"mutex"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new mutex in an unlocked state ready for use.",378,{"inputs":[],"output":{"name":"staticmutex"}}],[11,"lock","","Acquires this lock, see `Mutex::lock`",378,{"inputs":[{"name":"staticmutex"}],"output":{"name":"lockresult"}}],[11,"try_lock","","Attempts to grab this lock, see `Mutex::try_lock`",378,{"inputs":[{"name":"staticmutex"}],"output":{"name":"trylockresult"}}],[11,"destroy","","Deallocates resources associated with this static mutex.",378,{"inputs":[{"name":"staticmutex"}],"output":null}],[11,"deref","","",379,{"inputs":[{"name":"mutexguard"}],"output":{"name":"t"}}],[11,"deref_mut","","",379,{"inputs":[{"name":"mutexguard"}],"output":{"name":"t"}}],[11,"drop","","",379,{"inputs":[{"name":"mutexguard"}],"output":null}],[11,"new","","Creates a new `Once` value.",380,{"inputs":[],"output":{"name":"once"}}],[11,"call_once","","Performs an initialization routine once and only once. The given closure\nwill be executed if this is the first time `call_once` has been called,\nand otherwise the routine will *not* be invoked.",380,{"inputs":[{"name":"once"},{"name":"f"}],"output":null}],[11,"call_once_force","","Performs the same function as `call_once` except ignores poisoning.",380,{"inputs":[{"name":"once"},{"name":"f"}],"output":null}],[11,"new","","Creates a new instance of an `RwLock&lt;T&gt;` which is unlocked.",381,{"inputs":[{"name":"t"}],"output":{"name":"rwlock"}}],[11,"read","","Locks this rwlock with shared read access, blocking the current thread\nuntil it can be acquired.",381,{"inputs":[{"name":"rwlock"}],"output":{"name":"lockresult"}}],[11,"try_read","","Attempts to acquire this rwlock with shared read access.",381,{"inputs":[{"name":"rwlock"}],"output":{"name":"trylockresult"}}],[11,"write","","Locks this rwlock with exclusive write access, blocking the current\nthread until it can be acquired.",381,{"inputs":[{"name":"rwlock"}],"output":{"name":"lockresult"}}],[11,"try_write","","Attempts to lock this rwlock with exclusive write access.",381,{"inputs":[{"name":"rwlock"}],"output":{"name":"trylockresult"}}],[11,"is_poisoned","","Determines whether the lock is poisoned.",381,{"inputs":[{"name":"rwlock"}],"output":{"name":"bool"}}],[11,"into_inner","","Consumes this `RwLock`, returning the underlying data.",381,{"inputs":[{"name":"rwlock"}],"output":{"name":"lockresult"}}],[11,"get_mut","","Returns a mutable reference to the underlying data.",381,{"inputs":[{"name":"rwlock"}],"output":{"name":"lockresult"}}],[11,"drop","","",381,{"inputs":[{"name":"rwlock"}],"output":null}],[11,"fmt","","",381,{"inputs":[{"name":"rwlock"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new rwlock.",382,{"inputs":[],"output":{"name":"staticrwlock"}}],[11,"read","","Locks this rwlock with shared read access, blocking the current thread\nuntil it can be acquired.",382,{"inputs":[{"name":"staticrwlock"}],"output":{"name":"lockresult"}}],[11,"try_read","","Attempts to acquire this lock with shared read access.",382,{"inputs":[{"name":"staticrwlock"}],"output":{"name":"trylockresult"}}],[11,"write","","Locks this rwlock with exclusive write access, blocking the current\nthread until it can be acquired.",382,{"inputs":[{"name":"staticrwlock"}],"output":{"name":"lockresult"}}],[11,"try_write","","Attempts to lock this rwlock with exclusive write access.",382,{"inputs":[{"name":"staticrwlock"}],"output":{"name":"trylockresult"}}],[11,"destroy","","Deallocates all resources associated with this static lock.",382,{"inputs":[{"name":"staticrwlock"}],"output":null}],[11,"map","","Transform this guard to hold a sub-borrow of the original data.",383,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"rwlockreadguard"}}],[11,"map","","Transform this guard to hold a sub-borrow of the original data.",384,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"rwlockwriteguard"}}],[11,"deref","","",383,{"inputs":[{"name":"rwlockreadguard"}],"output":{"name":"t"}}],[11,"deref","","",384,{"inputs":[{"name":"rwlockwriteguard"}],"output":{"name":"t"}}],[11,"deref_mut","","",384,{"inputs":[{"name":"rwlockwriteguard"}],"output":{"name":"t"}}],[11,"drop","","",383,{"inputs":[{"name":"rwlockreadguard"}],"output":null}],[11,"drop","","",384,{"inputs":[{"name":"rwlockwriteguard"}],"output":null}],[6,"TryLockResult","","A type alias for the result of a nonblocking locking method.",null,null],[6,"LockResult","","A type alias for the result of a lock method which can be poisoned.",null,null],[17,"CONDVAR_INIT","","Constant initializer for a statically allocated condition variable.",null,null],[17,"MUTEX_INIT","","Static initialization of a mutex. This constant can be used to initialize\nother mutex constants.",null,null],[17,"ONCE_INIT","","Initialization value for static `Once` values.",null,null],[17,"RW_LOCK_INIT","","Constant initialization for a statically-initialized rwlock.",null,null],[0,"time","std","Temporal quantification.",null,null],[3,"Duration","std::time","A duration type to represent a span of time, typically used for system\ntimeouts.",null,null],[3,"Instant","","A measurement of a monotonically increasing clock.\n Opaque and useful only with `Duration`.",null,null],[3,"SystemTime","","A measurement of the system clock, useful for talking to\nexternal entities like the file system or other processes.",null,null],[3,"SystemTimeError","","An error returned from the `duration_since` method on `SystemTime`,\nused to learn about why how far in the opposite direction a timestamp lies.",null,null],[11,"hash","","",385,null],[11,"fmt","","",385,{"inputs":[{"name":"duration"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"cmp","","",385,{"inputs":[{"name":"duration"},{"name":"duration"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",385,{"inputs":[{"name":"duration"},{"name":"duration"}],"output":{"name":"option"}}],[11,"lt","","",385,{"inputs":[{"name":"duration"},{"name":"duration"}],"output":{"name":"bool"}}],[11,"le","","",385,{"inputs":[{"name":"duration"},{"name":"duration"}],"output":{"name":"bool"}}],[11,"gt","","",385,{"inputs":[{"name":"duration"},{"name":"duration"}],"output":{"name":"bool"}}],[11,"ge","","",385,{"inputs":[{"name":"duration"},{"name":"duration"}],"output":{"name":"bool"}}],[11,"eq","","",385,{"inputs":[{"name":"duration"},{"name":"duration"}],"output":{"name":"bool"}}],[11,"ne","","",385,{"inputs":[{"name":"duration"},{"name":"duration"}],"output":{"name":"bool"}}],[11,"clone","","",385,{"inputs":[{"name":"duration"}],"output":{"name":"duration"}}],[11,"new","","Creates a new `Duration` from the specified number of seconds and\nadditional nanosecond precision.",385,{"inputs":[{"name":"u64"},{"name":"u32"}],"output":{"name":"duration"}}],[11,"from_secs","","Creates a new `Duration` from the specified number of seconds.",385,{"inputs":[{"name":"u64"}],"output":{"name":"duration"}}],[11,"from_millis","","Creates a new `Duration` from the specified number of milliseconds.",385,{"inputs":[{"name":"u64"}],"output":{"name":"duration"}}],[11,"as_secs","","Returns the number of whole seconds represented by this duration.",385,{"inputs":[{"name":"duration"}],"output":{"name":"u64"}}],[11,"subsec_nanos","","Returns the nanosecond precision represented by this duration.",385,{"inputs":[{"name":"duration"}],"output":{"name":"u32"}}],[11,"add","","",385,{"inputs":[{"name":"duration"},{"name":"duration"}],"output":{"name":"duration"}}],[11,"add_assign","","",385,{"inputs":[{"name":"duration"},{"name":"duration"}],"output":null}],[11,"sub","","",385,{"inputs":[{"name":"duration"},{"name":"duration"}],"output":{"name":"duration"}}],[11,"sub_assign","","",385,{"inputs":[{"name":"duration"},{"name":"duration"}],"output":null}],[11,"mul","","",385,{"inputs":[{"name":"duration"},{"name":"u32"}],"output":{"name":"duration"}}],[11,"mul_assign","","",385,{"inputs":[{"name":"duration"},{"name":"u32"}],"output":null}],[11,"div","","",385,{"inputs":[{"name":"duration"},{"name":"u32"}],"output":{"name":"duration"}}],[11,"div_assign","","",385,{"inputs":[{"name":"duration"},{"name":"u32"}],"output":null}],[17,"UNIX_EPOCH","","An anchor in time which can be used to create new `SystemTime` instances or\nlearn about where in time a `SystemTime` lies.",null,null],[11,"cmp","","",386,{"inputs":[{"name":"instant"},{"name":"instant"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",386,{"inputs":[{"name":"instant"},{"name":"instant"}],"output":{"name":"option"}}],[11,"lt","","",386,{"inputs":[{"name":"instant"},{"name":"instant"}],"output":{"name":"bool"}}],[11,"le","","",386,{"inputs":[{"name":"instant"},{"name":"instant"}],"output":{"name":"bool"}}],[11,"gt","","",386,{"inputs":[{"name":"instant"},{"name":"instant"}],"output":{"name":"bool"}}],[11,"ge","","",386,{"inputs":[{"name":"instant"},{"name":"instant"}],"output":{"name":"bool"}}],[11,"eq","","",386,{"inputs":[{"name":"instant"},{"name":"instant"}],"output":{"name":"bool"}}],[11,"ne","","",386,{"inputs":[{"name":"instant"},{"name":"instant"}],"output":{"name":"bool"}}],[11,"clone","","",386,{"inputs":[{"name":"instant"}],"output":{"name":"instant"}}],[11,"cmp","","",387,{"inputs":[{"name":"systemtime"},{"name":"systemtime"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",387,{"inputs":[{"name":"systemtime"},{"name":"systemtime"}],"output":{"name":"option"}}],[11,"lt","","",387,{"inputs":[{"name":"systemtime"},{"name":"systemtime"}],"output":{"name":"bool"}}],[11,"le","","",387,{"inputs":[{"name":"systemtime"},{"name":"systemtime"}],"output":{"name":"bool"}}],[11,"gt","","",387,{"inputs":[{"name":"systemtime"},{"name":"systemtime"}],"output":{"name":"bool"}}],[11,"ge","","",387,{"inputs":[{"name":"systemtime"},{"name":"systemtime"}],"output":{"name":"bool"}}],[11,"eq","","",387,{"inputs":[{"name":"systemtime"},{"name":"systemtime"}],"output":{"name":"bool"}}],[11,"ne","","",387,{"inputs":[{"name":"systemtime"},{"name":"systemtime"}],"output":{"name":"bool"}}],[11,"clone","","",387,{"inputs":[{"name":"systemtime"}],"output":{"name":"systemtime"}}],[11,"fmt","","",388,{"inputs":[{"name":"systemtimeerror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",388,{"inputs":[{"name":"systemtimeerror"}],"output":{"name":"systemtimeerror"}}],[11,"now","","Returns an instant corresponding to &quot;now&quot;.",386,{"inputs":[],"output":{"name":"instant"}}],[11,"duration_since","","Returns the amount of time elapsed from another instant to this one.",386,{"inputs":[{"name":"instant"},{"name":"instant"}],"output":{"name":"duration"}}],[11,"duration_from_earlier","","Deprecated, renamed to `duration_since`",386,{"inputs":[{"name":"instant"},{"name":"instant"}],"output":{"name":"duration"}}],[11,"elapsed","","Returns the amount of time elapsed since this instant was created.",386,{"inputs":[{"name":"instant"}],"output":{"name":"duration"}}],[11,"add","","",386,{"inputs":[{"name":"instant"},{"name":"duration"}],"output":{"name":"instant"}}],[11,"add_assign","","",386,{"inputs":[{"name":"instant"},{"name":"duration"}],"output":null}],[11,"sub","","",386,{"inputs":[{"name":"instant"},{"name":"duration"}],"output":{"name":"instant"}}],[11,"sub_assign","","",386,{"inputs":[{"name":"instant"},{"name":"duration"}],"output":null}],[11,"sub","","",386,{"inputs":[{"name":"instant"},{"name":"instant"}],"output":{"name":"duration"}}],[11,"fmt","","",386,{"inputs":[{"name":"instant"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"now","","Returns the system time corresponding to &quot;now&quot;.",387,{"inputs":[],"output":{"name":"systemtime"}}],[11,"duration_since","","Returns the amount of time elapsed from an earlier point in time.",387,{"inputs":[{"name":"systemtime"},{"name":"systemtime"}],"output":{"name":"result"}}],[11,"duration_from_earlier","","Deprecated, renamed to `duration_since`",387,{"inputs":[{"name":"systemtime"},{"name":"systemtime"}],"output":{"name":"result"}}],[11,"elapsed","","Returns the amount of time elapsed since this system time was created.",387,{"inputs":[{"name":"systemtime"}],"output":{"name":"result"}}],[11,"add","","",387,{"inputs":[{"name":"systemtime"},{"name":"duration"}],"output":{"name":"systemtime"}}],[11,"add_assign","","",387,{"inputs":[{"name":"systemtime"},{"name":"duration"}],"output":null}],[11,"sub","","",387,{"inputs":[{"name":"systemtime"},{"name":"duration"}],"output":{"name":"systemtime"}}],[11,"sub_assign","","",387,{"inputs":[{"name":"systemtime"},{"name":"duration"}],"output":null}],[11,"fmt","","",387,{"inputs":[{"name":"systemtime"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"duration","","Returns the positive duration which represents how far forward the\nsecond system time was from the first.",388,{"inputs":[{"name":"systemtimeerror"}],"output":{"name":"duration"}}],[11,"description","","",388,{"inputs":[{"name":"systemtimeerror"}],"output":{"name":"str"}}],[11,"fmt","","",388,{"inputs":[{"name":"systemtimeerror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::sync","",389,{"inputs":[{"name":"poisonerror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",389,{"inputs":[{"name":"poisonerror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",389,{"inputs":[{"name":"poisonerror"}],"output":{"name":"str"}}],[11,"new","","Creates a `PoisonError`.",389,{"inputs":[{"name":"t"}],"output":{"name":"poisonerror"}}],[11,"into_inner","","Consumes this error indicating that a lock is poisoned, returning the\nunderlying guard to allow access regardless.",389,{"inputs":[{"name":"poisonerror"}],"output":{"name":"t"}}],[11,"get_ref","","Reaches into this error indicating that a lock is poisoned, returning a\nreference to the underlying guard to allow access regardless.",389,{"inputs":[{"name":"poisonerror"}],"output":{"name":"t"}}],[11,"get_mut","","Reaches into this error indicating that a lock is poisoned, returning a\nmutable reference to the underlying guard to allow access regardless.",389,{"inputs":[{"name":"poisonerror"}],"output":{"name":"t"}}],[11,"from","","",360,{"inputs":[{"name":"poisonerror"}],"output":{"name":"trylockerror"}}],[11,"fmt","","",360,{"inputs":[{"name":"trylockerror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",360,{"inputs":[{"name":"trylockerror"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",360,{"inputs":[{"name":"trylockerror"}],"output":{"name":"str"}}],[11,"cause","","",360,{"inputs":[{"name":"trylockerror"}],"output":{"name":"option"}}],[11,"as_raw_fd","std::fs","",266,{"inputs":[{"name":"file"}],"output":{"name":"rawfd"}}],[11,"from_raw_fd","","",266,{"inputs":[{"name":"rawfd"}],"output":{"name":"file"}}],[11,"into_raw_fd","","",266,{"inputs":[{"name":"file"}],"output":{"name":"rawfd"}}],[11,"as_raw_fd","std::net","",306,{"inputs":[{"name":"tcpstream"}],"output":{"name":"rawfd"}}],[11,"as_raw_fd","","",307,{"inputs":[{"name":"tcplistener"}],"output":{"name":"rawfd"}}],[11,"as_raw_fd","","",309,{"inputs":[{"name":"udpsocket"}],"output":{"name":"rawfd"}}],[11,"from_raw_fd","","",306,{"inputs":[{"name":"rawfd"}],"output":{"name":"tcpstream"}}],[11,"from_raw_fd","","",307,{"inputs":[{"name":"rawfd"}],"output":{"name":"tcplistener"}}],[11,"from_raw_fd","","",309,{"inputs":[{"name":"rawfd"}],"output":{"name":"udpsocket"}}],[11,"into_raw_fd","","",306,{"inputs":[{"name":"tcpstream"}],"output":{"name":"rawfd"}}],[11,"into_raw_fd","","",307,{"inputs":[{"name":"tcplistener"}],"output":{"name":"rawfd"}}],[11,"into_raw_fd","","",309,{"inputs":[{"name":"udpsocket"}],"output":{"name":"rawfd"}}],[11,"from_vec","std::ffi","",260,{"inputs":[{"name":"vec"}],"output":{"name":"osstring"}}],[11,"into_vec","","",260,{"inputs":[{"name":"osstring"}],"output":{"name":"vec"}}],[11,"from_bytes","","",261,null],[11,"as_bytes","","",261,null],[11,"mode","std::fs","",264,{"inputs":[{"name":"permissions"}],"output":{"name":"u32"}}],[11,"set_mode","","",264,{"inputs":[{"name":"permissions"},{"name":"u32"}],"output":null}],[11,"from_mode","","",264,{"inputs":[{"name":"u32"}],"output":{"name":"permissions"}}],[11,"mode","","",263,{"inputs":[{"name":"openoptions"},{"name":"u32"}],"output":{"name":"openoptions"}}],[11,"custom_flags","","",263,{"inputs":[{"name":"openoptions"},{"name":"i32"}],"output":{"name":"openoptions"}}],[11,"dev","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u64"}}],[11,"ino","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u64"}}],[11,"mode","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u32"}}],[11,"nlink","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u64"}}],[11,"uid","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u32"}}],[11,"gid","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u32"}}],[11,"rdev","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u64"}}],[11,"size","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u64"}}],[11,"atime","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"i64"}}],[11,"atime_nsec","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"i64"}}],[11,"mtime","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"i64"}}],[11,"mtime_nsec","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"i64"}}],[11,"ctime","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"i64"}}],[11,"ctime_nsec","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"i64"}}],[11,"blksize","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u64"}}],[11,"blocks","","",262,{"inputs":[{"name":"metadata"}],"output":{"name":"u64"}}],[11,"is_block_device","","",265,{"inputs":[{"name":"filetype"}],"output":{"name":"bool"}}],[11,"is_char_device","","",265,{"inputs":[{"name":"filetype"}],"output":{"name":"bool"}}],[11,"is_fifo","","",265,{"inputs":[{"name":"filetype"}],"output":{"name":"bool"}}],[11,"is_socket","","",265,{"inputs":[{"name":"filetype"}],"output":{"name":"bool"}}],[11,"ino","","",268,{"inputs":[{"name":"direntry"}],"output":{"name":"u64"}}],[11,"mode","","",269,{"inputs":[{"name":"dirbuilder"},{"name":"u32"}],"output":{"name":"dirbuilder"}}],[11,"uid","std::process","",350,{"inputs":[{"name":"command"},{"name":"u32"}],"output":{"name":"command"}}],[11,"gid","","",350,{"inputs":[{"name":"command"},{"name":"u32"}],"output":{"name":"command"}}],[11,"session_leader","","",350,{"inputs":[{"name":"command"},{"name":"bool"}],"output":{"name":"command"}}],[11,"before_exec","","",350,{"inputs":[{"name":"command"},{"name":"f"}],"output":{"name":"command"}}],[11,"exec","","",350,{"inputs":[{"name":"command"}],"output":{"name":"error"}}],[11,"signal","","",352,{"inputs":[{"name":"exitstatus"}],"output":{"name":"option"}}],[11,"from_raw_fd","","",351,{"inputs":[{"name":"rawfd"}],"output":{"name":"stdio"}}],[11,"as_raw_fd","","",347,{"inputs":[{"name":"childstdin"}],"output":{"name":"rawfd"}}],[11,"as_raw_fd","","",348,{"inputs":[{"name":"childstdout"}],"output":{"name":"rawfd"}}],[11,"as_raw_fd","","",349,{"inputs":[{"name":"childstderr"}],"output":{"name":"rawfd"}}],[11,"into_raw_fd","","",347,{"inputs":[{"name":"childstdin"}],"output":{"name":"rawfd"}}],[11,"into_raw_fd","","",348,{"inputs":[{"name":"childstdout"}],"output":{"name":"rawfd"}}],[11,"into_raw_fd","","",349,{"inputs":[{"name":"childstderr"}],"output":{"name":"rawfd"}}],[11,"as_pthread_t","std::thread","",209,{"inputs":[{"name":"joinhandle"}],"output":{"name":"rawpthread"}}],[11,"into_pthread_t","","",209,{"inputs":[{"name":"joinhandle"}],"output":{"name":"rawpthread"}}],[11,"clone","std::os::unix::net","",327,{"inputs":[{"name":"socketaddr"}],"output":{"name":"socketaddr"}}],[11,"is_unnamed","","Returns true iff the address is unnamed.",327,{"inputs":[{"name":"socketaddr"}],"output":{"name":"bool"}}],[11,"as_pathname","","Returns the contents of this address if it is a `pathname` address.",327,{"inputs":[{"name":"socketaddr"}],"output":{"name":"option"}}],[11,"fmt","","",327,{"inputs":[{"name":"socketaddr"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",328,{"inputs":[{"name":"unixstream"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"connect","","Connects to the socket named by `path`.",328,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[11,"pair","","Creates an unnamed pair of connected sockets.",328,{"inputs":[],"output":{"name":"result"}}],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",328,{"inputs":[{"name":"unixstream"}],"output":{"name":"result"}}],[11,"local_addr","","Returns the socket address of the local half of this connection.",328,{"inputs":[{"name":"unixstream"}],"output":{"name":"result"}}],[11,"peer_addr","","Returns the socket address of the remote half of this connection.",328,{"inputs":[{"name":"unixstream"}],"output":{"name":"result"}}],[11,"set_read_timeout","","Sets the read timeout for the socket.",328,{"inputs":[{"name":"unixstream"},{"name":"option"}],"output":{"name":"result"}}],[11,"set_write_timeout","","Sets the write timeout for the socket.",328,{"inputs":[{"name":"unixstream"},{"name":"option"}],"output":{"name":"result"}}],[11,"read_timeout","","Returns the read timeout of this socket.",328,{"inputs":[{"name":"unixstream"}],"output":{"name":"result"}}],[11,"write_timeout","","Returns the write timeout of this socket.",328,{"inputs":[{"name":"unixstream"}],"output":{"name":"result"}}],[11,"set_nonblocking","","Moves the socket into or out of nonblocking mode.",328,{"inputs":[{"name":"unixstream"},{"name":"bool"}],"output":{"name":"result"}}],[11,"take_error","","Returns the value of the `SO_ERROR` option.",328,{"inputs":[{"name":"unixstream"}],"output":{"name":"result"}}],[11,"shutdown","","Shuts down the read, write, or both halves of this connection.",328,{"inputs":[{"name":"unixstream"},{"name":"shutdown"}],"output":{"name":"result"}}],[11,"read","","",328,null],[11,"read_to_end","","",328,{"inputs":[{"name":"unixstream"},{"name":"vec"}],"output":{"name":"result"}}],[11,"write","","",328,null],[11,"flush","","",328,{"inputs":[{"name":"unixstream"}],"output":{"name":"result"}}],[11,"as_raw_fd","","",328,{"inputs":[{"name":"unixstream"}],"output":{"name":"rawfd"}}],[11,"from_raw_fd","","",328,{"inputs":[{"name":"rawfd"}],"output":{"name":"unixstream"}}],[11,"into_raw_fd","","",328,{"inputs":[{"name":"unixstream"}],"output":{"name":"rawfd"}}],[11,"fmt","","",329,{"inputs":[{"name":"unixlistener"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"bind","","Creates a new `UnixListener` bound to the specified socket.",329,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[11,"accept","","Accepts a new incoming connection to this listener.",329,{"inputs":[{"name":"unixlistener"}],"output":{"name":"result"}}],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",329,{"inputs":[{"name":"unixlistener"}],"output":{"name":"result"}}],[11,"local_addr","","Returns the local socket address of this listener.",329,{"inputs":[{"name":"unixlistener"}],"output":{"name":"result"}}],[11,"set_nonblocking","","Moves the socket into or out of nonblocking mode.",329,{"inputs":[{"name":"unixlistener"},{"name":"bool"}],"output":{"name":"result"}}],[11,"take_error","","Returns the value of the `SO_ERROR` option.",329,{"inputs":[{"name":"unixlistener"}],"output":{"name":"result"}}],[11,"incoming","","Returns an iterator over incoming connections.",329,{"inputs":[{"name":"unixlistener"}],"output":{"name":"incoming"}}],[11,"as_raw_fd","","",329,{"inputs":[{"name":"unixlistener"}],"output":{"name":"rawfd"}}],[11,"from_raw_fd","","",329,{"inputs":[{"name":"rawfd"}],"output":{"name":"unixlistener"}}],[11,"into_raw_fd","","",329,{"inputs":[{"name":"unixlistener"}],"output":{"name":"rawfd"}}],[11,"fmt","","",330,{"inputs":[{"name":"incoming"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",330,{"inputs":[{"name":"incoming"}],"output":{"name":"option"}}],[11,"size_hint","","",330,null],[11,"fmt","","",331,{"inputs":[{"name":"unixdatagram"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"bind","","Creates a Unix datagram socket bound to the given path.",331,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[11,"unbound","","Creates a Unix Datagram socket which is not bound to any address.",331,{"inputs":[],"output":{"name":"result"}}],[11,"pair","","Create an unnamed pair of connected sockets.",331,{"inputs":[],"output":{"name":"result"}}],[11,"connect","","Connects the socket to the specified address.",331,{"inputs":[{"name":"unixdatagram"},{"name":"p"}],"output":{"name":"result"}}],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",331,{"inputs":[{"name":"unixdatagram"}],"output":{"name":"result"}}],[11,"local_addr","","Returns the address of this socket.",331,{"inputs":[{"name":"unixdatagram"}],"output":{"name":"result"}}],[11,"peer_addr","","Returns the address of this socket&#39;s peer.",331,{"inputs":[{"name":"unixdatagram"}],"output":{"name":"result"}}],[11,"recv_from","","Receives data from the socket.",331,null],[11,"recv","","Receives data from the socket.",331,null],[11,"send_to","","Sends data on the socket to the specified address.",331,null],[11,"send","","Sends data on the socket to the socket&#39;s peer.",331,null],[11,"set_read_timeout","","Sets the read timeout for the socket.",331,{"inputs":[{"name":"unixdatagram"},{"name":"option"}],"output":{"name":"result"}}],[11,"set_write_timeout","","Sets the write timeout for the socket.",331,{"inputs":[{"name":"unixdatagram"},{"name":"option"}],"output":{"name":"result"}}],[11,"read_timeout","","Returns the read timeout of this socket.",331,{"inputs":[{"name":"unixdatagram"}],"output":{"name":"result"}}],[11,"write_timeout","","Returns the write timeout of this socket.",331,{"inputs":[{"name":"unixdatagram"}],"output":{"name":"result"}}],[11,"set_nonblocking","","Moves the socket into or out of nonblocking mode.",331,{"inputs":[{"name":"unixdatagram"},{"name":"bool"}],"output":{"name":"result"}}],[11,"take_error","","Returns the value of the `SO_ERROR` option.",331,{"inputs":[{"name":"unixdatagram"}],"output":{"name":"result"}}],[11,"shutdown","","Shut down the read, write, or both halves of this connection.",331,{"inputs":[{"name":"unixdatagram"},{"name":"shutdown"}],"output":{"name":"result"}}],[11,"as_raw_fd","","",331,{"inputs":[{"name":"unixdatagram"}],"output":{"name":"rawfd"}}],[11,"from_raw_fd","","",331,{"inputs":[{"name":"rawfd"}],"output":{"name":"unixdatagram"}}],[11,"into_raw_fd","","",331,{"inputs":[{"name":"unixdatagram"}],"output":{"name":"rawfd"}}],[11,"payload","std::panic","Returns the payload associated with the panic.",390,{"inputs":[{"name":"panicinfo"}],"output":{"name":"any"}}],[11,"location","","Returns information about the location from which the panic originated,\nif available.",390,{"inputs":[{"name":"panicinfo"}],"output":{"name":"option"}}],[11,"file","","Returns the name of the source file from which the panic originated.",391,{"inputs":[{"name":"location"}],"output":{"name":"str"}}],[11,"line","","Returns the line number from which the panic originated.",391,{"inputs":[{"name":"location"}],"output":{"name":"u32"}}],[11,"next_u64","std::rand","Return the next random u64.",392,{"inputs":[{"name":"rng"}],"output":{"name":"u64"}}],[11,"next_f32","","Return the next random f32 selected from the half-open\ninterval `[0, 1)`.",392,{"inputs":[{"name":"rng"}],"output":{"name":"f32"}}],[11,"next_f64","","Return the next random f64 selected from the half-open\ninterval `[0, 1)`.",392,{"inputs":[{"name":"rng"}],"output":{"name":"f64"}}],[11,"fill_bytes","","Fill `dest` with random data.",392,null],[11,"gen","","Return a random value of a `Rand` type.",392,{"inputs":[{"name":"rng"}],"output":{"name":"t"}}],[11,"gen_iter","","Return an iterator that will yield an infinite number of randomly\ngenerated items.",392,{"inputs":[{"name":"rng"}],"output":{"name":"generator"}}],[11,"gen_range","","Generate a random value in the range [`low`, `high`).",392,{"inputs":[{"name":"rng"},{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[11,"gen_weighted_bool","","Return a bool with a 1 in n chance of true",392,{"inputs":[{"name":"rng"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"gen_ascii_chars","","Return an iterator of random characters from the set A-Z,a-z,0-9.",392,{"inputs":[{"name":"rng"}],"output":{"name":"asciigenerator"}}],[11,"choose","","Return a random element from `values`.",392,null],[11,"shuffle","","Shuffle a mutable slice in place.",392,null],[11,"new_unseeded","rand","Creates a new XorShiftRng instance which is not seeded.",393,{"inputs":[],"output":{"name":"xorshiftrng"}}],[11,"reseed","","Reseed an XorShiftRng. This will panic if `seed` is entirely 0.",393,null],[11,"from_seed","","Create a new XorShiftRng. This will panic if `seed` is entirely 0.",393,null],[11,"next_u32","","",393,{"inputs":[{"name":"xorshiftrng"}],"output":{"name":"u32"}}],[11,"clone","","",393,{"inputs":[{"name":"xorshiftrng"}],"output":{"name":"xorshiftrng"}}],[11,"reseed","rand::isaac","",394,null],[11,"from_seed","","Create an ISAAC random number generator with a seed. This can\nbe any length, although the maximum number of elements used is\n256 and any more will be silently ignored. A generator\nconstructed with a given seed will generate the same sequence\nof values as all other generators constructed with that seed.",394,null],[11,"next_u32","","",394,{"inputs":[{"name":"isaacrng"}],"output":{"name":"u32"}}],[11,"clone","","",394,{"inputs":[{"name":"isaacrng"}],"output":{"name":"isaacrng"}}],[11,"new_unseeded","","Create an ISAAC random number generator using the default\nfixed seed.",394,{"inputs":[],"output":{"name":"isaacrng"}}],[11,"reseed","","",395,null],[11,"from_seed","","Create an ISAAC random number generator with a seed. This can\nbe any length, although the maximum number of elements used is\n256 and any more will be silently ignored. A generator\nconstructed with a given seed will generate the same sequence\nof values as all other generators constructed with that seed.",395,null],[11,"next_u32","","",395,{"inputs":[{"name":"isaac64rng"}],"output":{"name":"u32"}}],[11,"next_u64","","",395,{"inputs":[{"name":"isaac64rng"}],"output":{"name":"u64"}}],[11,"clone","","",395,{"inputs":[{"name":"isaac64rng"}],"output":{"name":"isaac64rng"}}],[11,"new_unseeded","","Create a 64-bit ISAAC random number generator using the\ndefault fixed seed.",395,{"inputs":[],"output":{"name":"isaac64rng"}}],[11,"reseed","rand::reseeding","",396,null],[11,"from_seed","","Create a new `ReseedingRng` from the given reseeder and\nseed. This uses a default value for `generation_threshold`.",396,null],[11,"next_u32","","",396,{"inputs":[{"name":"reseedingrng"}],"output":{"name":"u32"}}],[11,"next_u64","","",396,{"inputs":[{"name":"reseedingrng"}],"output":{"name":"u64"}}],[11,"fill_bytes","","",396,null],[11,"new","","Create a new `ReseedingRng` with the given parameters.",396,{"inputs":[{"name":"r"},{"name":"usize"},{"name":"rsdr"}],"output":{"name":"reseedingrng"}}],[11,"reseed_if_necessary","","Reseed the internal RNG if the number of bytes that have been\ngenerated exceed the threshold.",396,null],[11,"clone","","",397,{"inputs":[{"name":"reseedwithdefault"}],"output":{"name":"reseedwithdefault"}}],[11,"default","","",397,{"inputs":[],"output":{"name":"reseedwithdefault"}}],[11,"reseed","","",397,null],[11,"next_u64","std::__rand","Return the next random u64.",392,{"inputs":[{"name":"rng"}],"output":{"name":"u64"}}],[11,"next_f32","","Return the next random f32 selected from the half-open\ninterval `[0, 1)`.",392,{"inputs":[{"name":"rng"}],"output":{"name":"f32"}}],[11,"next_f64","","Return the next random f64 selected from the half-open\ninterval `[0, 1)`.",392,{"inputs":[{"name":"rng"}],"output":{"name":"f64"}}],[11,"fill_bytes","","Fill `dest` with random data.",392,null],[11,"gen","","Return a random value of a `Rand` type.",392,{"inputs":[{"name":"rng"}],"output":{"name":"t"}}],[11,"gen_iter","","Return an iterator that will yield an infinite number of randomly\ngenerated items.",392,{"inputs":[{"name":"rng"}],"output":{"name":"generator"}}],[11,"gen_range","","Generate a random value in the range [`low`, `high`).",392,{"inputs":[{"name":"rng"},{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[11,"gen_weighted_bool","","Return a bool with a 1 in n chance of true",392,{"inputs":[{"name":"rng"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"gen_ascii_chars","","Return an iterator of random characters from the set A-Z,a-z,0-9.",392,{"inputs":[{"name":"rng"}],"output":{"name":"asciigenerator"}}],[11,"choose","","Return a random element from `values`.",392,null],[11,"shuffle","","Shuffle a mutable slice in place.",392,null],[14,"assert!","std","Ensure that a boolean expression is `true` at runtime.",null,null],[14,"assert_eq!","","Asserts that two expressions are equal to each other.",null,null],[14,"debug_assert!","","Ensure that a boolean expression is `true` at runtime.",null,null],[14,"debug_assert_eq!","","Asserts that two expressions are equal to each other.",null,null],[14,"try!","","Helper macro for unwrapping `Result` values while returning early with an\nerror if the value of the expression is `Err`. Can only be used in\nfunctions that return `Result` because of the early return of `Err` that\nit provides.",null,null],[14,"write!","","Use the `format!` syntax to write data into a buffer.",null,null],[14,"writeln!","","Use the `format!` syntax to write data into a buffer, appending a newline.",null,null],[14,"unreachable!","","A utility macro for indicating unreachable code.",null,null],[14,"unimplemented!","","A standardized placeholder for marking unfinished code. It panics with the\nmessage `&quot;not yet implemented&quot;` when executed.",null,null],[14,"vec!","","Creates a `Vec` containing the arguments.",null,null],[14,"format!","","Use the syntax described in `std::fmt` to create a value of type `String`.\nSee `std::fmt` for more information.",null,null],[14,"panic!","","The entry point for panic of Rust threads.",null,null],[14,"print!","","Macro for printing to the standard output.",null,null],[14,"println!","","Macro for printing to the standard output, with a newline.",null,null],[14,"select!","","A macro to select an event from a number of receivers.",null,null],[14,"format_args!","","The core macro for formatted string creation &amp; output.",null,null],[14,"env!","","Inspect an environment variable at compile time.",null,null],[14,"option_env!","","Optionally inspect an environment variable at compile time.",null,null],[14,"concat_idents!","","Concatenate identifiers into one identifier.",null,null],[14,"concat!","","Concatenates literals into a static string slice.",null,null],[14,"line!","","A macro which expands to the line number on which it was invoked.",null,null],[14,"column!","","A macro which expands to the column number on which it was invoked.",null,null],[14,"file!","","A macro which expands to the file name from which it was invoked.",null,null],[14,"stringify!","","A macro which stringifies its argument.",null,null],[14,"include_str!","","Includes a utf8-encoded file as a string.",null,null],[14,"include_bytes!","","Includes a file as a reference to a byte array.",null,null],[14,"module_path!","","Expands to a string that represents the current module path.",null,null],[14,"cfg!","","Boolean evaluation of configuration flags.",null,null],[14,"include!","","Parse the current given file as an expression.",null,null],[14,"thread_local!","","Declare a new thread local storage key of type `std::thread::LocalKey`.",null,null],[14,"scoped_thread_local!","","Declare a new scoped thread local storage key.",null,null],[15,"bool","","The boolean type.",null,null],[15,"char","","A character type.",null,null],[15,"pointer","","Raw, unsafe pointers, `*const T`, and `*mut T`.",null,null],[15,"array","","A fixed-size array, denoted `[T; N]`, for the element type, `T`, and the\nnon-negative compile time constant size, `N`.",null,null],[15,"slice","","A dynamically-sized view into a contiguous sequence, `[T]`.",null,null],[15,"str","","String slices.",null,null],[15,"tuple","","A finite heterogeneous sequence, `(T, U, ..)`.",null,null],[15,"f32","","The 32-bit floating point type.",null,null],[15,"f64","","The 64-bit floating point type.",null,null],[15,"i8","","The 8-bit signed integer type.",null,null],[15,"i16","","The 16-bit signed integer type.",null,null],[15,"i32","","The 32-bit signed integer type.",null,null],[15,"i64","","The 64-bit signed integer type.",null,null],[15,"u8","","The 8-bit unsigned integer type.",null,null],[15,"u16","","The 16-bit unsigned integer type.",null,null],[15,"u32","","The 32-bit unsigned integer type.",null,null],[15,"u64","","The 64-bit unsigned integer type.",null,null],[15,"isize","","The pointer-sized signed integer type.",null,null],[15,"usize","","The pointer-sized unsigned integer type.",null,null],[11,"default","","",398,null],[11,"cmp","","",398,null],[11,"partial_cmp","","",398,null],[11,"lt","","",398,null],[11,"le","","",398,null],[11,"ge","","",398,null],[11,"gt","","",398,null],[11,"eq","","",398,null],[11,"ne","","",398,null],[11,"clone","","",398,null],[11,"default","","",398,null],[11,"cmp","","",398,null],[11,"partial_cmp","","",398,null],[11,"lt","","",398,null],[11,"le","","",398,null],[11,"ge","","",398,null],[11,"gt","","",398,null],[11,"eq","","",398,null],[11,"ne","","",398,null],[11,"clone","","",398,null],[11,"default","","",398,null],[11,"cmp","","",398,null],[11,"partial_cmp","","",398,null],[11,"lt","","",398,null],[11,"le","","",398,null],[11,"ge","","",398,null],[11,"gt","","",398,null],[11,"eq","","",398,null],[11,"ne","","",398,null],[11,"clone","","",398,null],[11,"default","","",398,null],[11,"cmp","","",398,null],[11,"partial_cmp","","",398,null],[11,"lt","","",398,null],[11,"le","","",398,null],[11,"ge","","",398,null],[11,"gt","","",398,null],[11,"eq","","",398,null],[11,"ne","","",398,null],[11,"clone","","",398,null],[11,"default","","",398,null],[11,"cmp","","",398,null],[11,"partial_cmp","","",398,null],[11,"lt","","",398,null],[11,"le","","",398,null],[11,"ge","","",398,null],[11,"gt","","",398,null],[11,"eq","","",398,null],[11,"ne","","",398,null],[11,"clone","","",398,null],[11,"default","","",398,null],[11,"cmp","","",398,null],[11,"partial_cmp","","",398,null],[11,"lt","","",398,null],[11,"le","","",398,null],[11,"ge","","",398,null],[11,"gt","","",398,null],[11,"eq","","",398,null],[11,"ne","","",398,null],[11,"clone","","",398,null],[11,"default","","",398,null],[11,"cmp","","",398,null],[11,"partial_cmp","","",398,null],[11,"lt","","",398,null],[11,"le","","",398,null],[11,"ge","","",398,null],[11,"gt","","",398,null],[11,"eq","","",398,null],[11,"ne","","",398,null],[11,"clone","","",398,null],[11,"default","","",398,null],[11,"cmp","","",398,null],[11,"partial_cmp","","",398,null],[11,"lt","","",398,null],[11,"le","","",398,null],[11,"ge","","",398,null],[11,"gt","","",398,null],[11,"eq","","",398,null],[11,"ne","","",398,null],[11,"clone","","",398,null],[11,"default","","",398,null],[11,"cmp","","",398,null],[11,"partial_cmp","","",398,null],[11,"lt","","",398,null],[11,"le","","",398,null],[11,"ge","","",398,null],[11,"gt","","",398,null],[11,"eq","","",398,null],[11,"ne","","",398,null],[11,"clone","","",398,null],[11,"default","","",398,null],[11,"cmp","","",398,null],[11,"partial_cmp","","",398,null],[11,"lt","","",398,null],[11,"le","","",398,null],[11,"ge","","",398,null],[11,"gt","","",398,null],[11,"eq","","",398,null],[11,"ne","","",398,null],[11,"clone","","",398,null],[11,"default","","",398,null],[11,"cmp","","",398,null],[11,"partial_cmp","","",398,null],[11,"lt","","",398,null],[11,"le","","",398,null],[11,"ge","","",398,null],[11,"gt","","",398,null],[11,"eq","","",398,null],[11,"ne","","",398,null],[11,"clone","","",398,null],[11,"default","","",398,null],[11,"cmp","","",398,null],[11,"partial_cmp","","",398,null],[11,"lt","","",398,null],[11,"le","","",398,null],[11,"ge","","",398,null],[11,"gt","","",398,null],[11,"eq","","",398,null],[11,"ne","","",398,null],[11,"clone","","",398,null],[11,"fmt","","",398,{"inputs":[{"name":"tuple"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",399,{"inputs":[{"name":"slice"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",398,{"inputs":[{"name":"tuple"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",398,{"inputs":[{"name":"tuple"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",398,{"inputs":[{"name":"tuple"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",398,{"inputs":[{"name":"tuple"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",398,{"inputs":[{"name":"tuple"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",398,{"inputs":[{"name":"tuple"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",398,{"inputs":[{"name":"tuple"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",398,{"inputs":[{"name":"tuple"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",398,{"inputs":[{"name":"tuple"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",398,{"inputs":[{"name":"tuple"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",398,{"inputs":[{"name":"tuple"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",398,{"inputs":[{"name":"tuple"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",400,{"inputs":[{"name":"pointer"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",400,{"inputs":[{"name":"pointer"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",401,{"inputs":[{"name":"f64"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",401,{"inputs":[{"name":"f64"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",401,{"inputs":[{"name":"f64"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",401,{"inputs":[{"name":"f64"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",402,{"inputs":[{"name":"f32"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",402,{"inputs":[{"name":"f32"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",402,{"inputs":[{"name":"f32"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",402,{"inputs":[{"name":"f32"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",400,{"inputs":[{"name":"pointer"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",400,{"inputs":[{"name":"pointer"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",403,{"inputs":[{"name":"char"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",403,{"inputs":[{"name":"char"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",404,{"inputs":[{"name":"str"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",404,{"inputs":[{"name":"str"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",405,{"inputs":[{"name":"bool"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",405,{"inputs":[{"name":"bool"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",406,{"inputs":[{"name":"usize"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",407,{"inputs":[{"name":"isize"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",408,{"inputs":[{"name":"u64"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",409,{"inputs":[{"name":"i64"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",410,{"inputs":[{"name":"u32"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",411,{"inputs":[{"name":"i32"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",412,{"inputs":[{"name":"u16"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",413,{"inputs":[{"name":"i16"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",414,{"inputs":[{"name":"u8"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",415,{"inputs":[{"name":"i8"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",408,{"inputs":[{"name":"u64"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",408,{"inputs":[{"name":"u64"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",408,{"inputs":[{"name":"u64"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",408,{"inputs":[{"name":"u64"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",408,{"inputs":[{"name":"u64"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",409,{"inputs":[{"name":"i64"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",409,{"inputs":[{"name":"i64"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",409,{"inputs":[{"name":"i64"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",409,{"inputs":[{"name":"i64"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",409,{"inputs":[{"name":"i64"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",410,{"inputs":[{"name":"u32"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",410,{"inputs":[{"name":"u32"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",410,{"inputs":[{"name":"u32"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",410,{"inputs":[{"name":"u32"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",410,{"inputs":[{"name":"u32"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",411,{"inputs":[{"name":"i32"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",411,{"inputs":[{"name":"i32"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",411,{"inputs":[{"name":"i32"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",411,{"inputs":[{"name":"i32"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",411,{"inputs":[{"name":"i32"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",412,{"inputs":[{"name":"u16"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",412,{"inputs":[{"name":"u16"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",412,{"inputs":[{"name":"u16"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",412,{"inputs":[{"name":"u16"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",412,{"inputs":[{"name":"u16"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",413,{"inputs":[{"name":"i16"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",413,{"inputs":[{"name":"i16"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",413,{"inputs":[{"name":"i16"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",413,{"inputs":[{"name":"i16"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",413,{"inputs":[{"name":"i16"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",414,{"inputs":[{"name":"u8"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",414,{"inputs":[{"name":"u8"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",414,{"inputs":[{"name":"u8"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",414,{"inputs":[{"name":"u8"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",414,{"inputs":[{"name":"u8"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",415,{"inputs":[{"name":"i8"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",415,{"inputs":[{"name":"i8"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",415,{"inputs":[{"name":"i8"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",415,{"inputs":[{"name":"i8"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",415,{"inputs":[{"name":"i8"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",406,{"inputs":[{"name":"usize"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",406,{"inputs":[{"name":"usize"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",406,{"inputs":[{"name":"usize"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",406,{"inputs":[{"name":"usize"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",406,{"inputs":[{"name":"usize"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",407,{"inputs":[{"name":"isize"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",407,{"inputs":[{"name":"isize"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",407,{"inputs":[{"name":"isize"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",407,{"inputs":[{"name":"isize"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",407,{"inputs":[{"name":"isize"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",400,null],[11,"hash","","",400,null],[11,"hash","","",399,null],[11,"hash","","",398,null],[11,"hash","","",398,null],[11,"hash","","",398,null],[11,"hash","","",398,null],[11,"hash","","",398,null],[11,"hash","","",398,null],[11,"hash","","",398,null],[11,"hash","","",398,null],[11,"hash","","",398,null],[11,"hash","","",398,null],[11,"hash","","",398,null],[11,"hash","","",398,null],[11,"hash","","",398,null],[11,"hash","","",404,null],[11,"hash","","",403,null],[11,"hash","","",405,null],[11,"hash","","",407,null],[11,"hash_slice","","",407,null],[11,"hash","","",409,null],[11,"hash_slice","","",409,null],[11,"hash","","",411,null],[11,"hash_slice","","",411,null],[11,"hash","","",413,null],[11,"hash_slice","","",413,null],[11,"hash","","",415,null],[11,"hash_slice","","",415,null],[11,"hash","","",406,null],[11,"hash_slice","","",406,null],[11,"hash","","",408,null],[11,"hash_slice","","",408,null],[11,"hash","","",410,null],[11,"hash_slice","","",410,null],[11,"hash","","",412,null],[11,"hash_slice","","",412,null],[11,"hash","","",414,null],[11,"hash_slice","","",414,null],[11,"default","","",404,{"inputs":[],"output":{"name":"str"}}],[11,"as_ref","","",404,null],[11,"index_mut","","",404,{"inputs":[{"name":"str"},{"name":"rangetoinclusive"}],"output":{"name":"str"}}],[11,"index_mut","","",404,{"inputs":[{"name":"str"},{"name":"rangeinclusive"}],"output":{"name":"str"}}],[11,"index","","",404,{"inputs":[{"name":"str"},{"name":"rangetoinclusive"}],"output":{"name":"str"}}],[11,"index","","",404,{"inputs":[{"name":"str"},{"name":"rangeinclusive"}],"output":{"name":"str"}}],[11,"index_mut","","",404,{"inputs":[{"name":"str"},{"name":"rangefull"}],"output":{"name":"str"}}],[11,"index","","",404,{"inputs":[{"name":"str"},{"name":"rangefull"}],"output":{"name":"str"}}],[11,"index_mut","","",404,{"inputs":[{"name":"str"},{"name":"rangefrom"}],"output":{"name":"str"}}],[11,"index","","",404,{"inputs":[{"name":"str"},{"name":"rangefrom"}],"output":{"name":"str"}}],[11,"index_mut","","",404,{"inputs":[{"name":"str"},{"name":"rangeto"}],"output":{"name":"str"}}],[11,"index","","",404,{"inputs":[{"name":"str"},{"name":"rangeto"}],"output":{"name":"str"}}],[11,"index_mut","","",404,{"inputs":[{"name":"str"},{"name":"range"}],"output":{"name":"str"}}],[11,"index","","",404,{"inputs":[{"name":"str"},{"name":"range"}],"output":{"name":"str"}}],[11,"partial_cmp","","",404,{"inputs":[{"name":"str"},{"name":"str"}],"output":{"name":"option"}}],[11,"eq","","",404,{"inputs":[{"name":"str"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",404,{"inputs":[{"name":"str"},{"name":"str"}],"output":{"name":"bool"}}],[11,"cmp","","",404,{"inputs":[{"name":"str"},{"name":"str"}],"output":{"name":"ordering"}}],[11,"from_str","","Parse a `bool` from a string.",405,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"into_searcher","","",404,{"inputs":[{"name":"str"},{"name":"str"}],"output":{"name":"strsearcher"}}],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",404,{"inputs":[{"name":"str"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",404,{"inputs":[{"name":"str"},{"name":"str"}],"output":{"name":"bool"}}],[11,"into_searcher","","",399,{"inputs":[{"name":"slice"},{"name":"str"}],"output":{"name":"charslicesearcher"}}],[11,"is_contained_in","","",399,{"inputs":[{"name":"slice"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_prefix_of","","",399,{"inputs":[{"name":"slice"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_suffix_of","","",399,{"inputs":[{"name":"slice"},{"name":"str"}],"output":{"name":"bool"}}],[11,"into_searcher","","",403,{"inputs":[{"name":"char"},{"name":"str"}],"output":{"name":"charsearcher"}}],[11,"is_contained_in","","",403,{"inputs":[{"name":"char"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_prefix_of","","",403,{"inputs":[{"name":"char"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_suffix_of","","",403,{"inputs":[{"name":"char"},{"name":"str"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",399,null],[11,"cmp","","",399,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"into_iter","","",399,{"inputs":[{"name":"slice"}],"output":{"name":"itermut"}}],[11,"into_iter","","",399,{"inputs":[{"name":"slice"}],"output":{"name":"iter"}}],[11,"default","","",399,null],[11,"default","","",399,null],[11,"index_mut","","",399,null],[11,"index_mut","","",399,null],[11,"index_mut","","",399,null],[11,"index_mut","","",399,null],[11,"index_mut","","",399,null],[11,"index_mut","","",399,null],[11,"index","","",399,null],[11,"index","","",399,null],[11,"index","","",399,null],[11,"index","","",399,null],[11,"index","","",399,null],[11,"index","","",399,null],[11,"index_mut","","",399,{"inputs":[{"name":"slice"},{"name":"usize"}],"output":{"name":"t"}}],[11,"index","","",399,{"inputs":[{"name":"slice"},{"name":"usize"}],"output":{"name":"t"}}],[11,"split_at","","",399,null],[11,"iter","","",399,{"inputs":[{"name":"slice"}],"output":{"name":"iter"}}],[11,"split","","",399,{"inputs":[{"name":"slice"},{"name":"p"}],"output":{"name":"split"}}],[11,"splitn","","",399,{"inputs":[{"name":"slice"},{"name":"usize"},{"name":"p"}],"output":{"name":"splitn"}}],[11,"rsplitn","","",399,{"inputs":[{"name":"slice"},{"name":"usize"},{"name":"p"}],"output":{"name":"rsplitn"}}],[11,"windows","","",399,{"inputs":[{"name":"slice"},{"name":"usize"}],"output":{"name":"windows"}}],[11,"chunks","","",399,{"inputs":[{"name":"slice"},{"name":"usize"}],"output":{"name":"chunks"}}],[11,"get","","",399,{"inputs":[{"name":"slice"},{"name":"usize"}],"output":{"name":"option"}}],[11,"first","","",399,{"inputs":[{"name":"slice"}],"output":{"name":"option"}}],[11,"split_first","","",399,{"inputs":[{"name":"slice"}],"output":{"name":"option"}}],[11,"split_last","","",399,{"inputs":[{"name":"slice"}],"output":{"name":"option"}}],[11,"last","","",399,{"inputs":[{"name":"slice"}],"output":{"name":"option"}}],[11,"get_unchecked","","",399,{"inputs":[{"name":"slice"},{"name":"usize"}],"output":{"name":"t"}}],[11,"as_ptr","","",399,null],[11,"binary_search_by","","",399,{"inputs":[{"name":"slice"},{"name":"f"}],"output":{"name":"result"}}],[11,"len","","",399,{"inputs":[{"name":"slice"}],"output":{"name":"usize"}}],[11,"get_mut","","",399,{"inputs":[{"name":"slice"},{"name":"usize"}],"output":{"name":"option"}}],[11,"split_at_mut","","",399,null],[11,"iter_mut","","",399,{"inputs":[{"name":"slice"}],"output":{"name":"itermut"}}],[11,"last_mut","","",399,{"inputs":[{"name":"slice"}],"output":{"name":"option"}}],[11,"first_mut","","",399,{"inputs":[{"name":"slice"}],"output":{"name":"option"}}],[11,"split_first_mut","","",399,{"inputs":[{"name":"slice"}],"output":{"name":"option"}}],[11,"split_last_mut","","",399,{"inputs":[{"name":"slice"}],"output":{"name":"option"}}],[11,"split_mut","","",399,{"inputs":[{"name":"slice"},{"name":"p"}],"output":{"name":"splitmut"}}],[11,"splitn_mut","","",399,{"inputs":[{"name":"slice"},{"name":"usize"},{"name":"p"}],"output":{"name":"splitnmut"}}],[11,"rsplitn_mut","","",399,{"inputs":[{"name":"slice"},{"name":"usize"},{"name":"p"}],"output":{"name":"rsplitnmut"}}],[11,"chunks_mut","","",399,{"inputs":[{"name":"slice"},{"name":"usize"}],"output":{"name":"chunksmut"}}],[11,"swap","","",399,null],[11,"reverse","","",399,null],[11,"get_unchecked_mut","","",399,{"inputs":[{"name":"slice"},{"name":"usize"}],"output":{"name":"t"}}],[11,"as_mut_ptr","","",399,null],[11,"contains","","",399,{"inputs":[{"name":"slice"},{"name":"t"}],"output":{"name":"bool"}}],[11,"starts_with","","",399,null],[11,"ends_with","","",399,null],[11,"binary_search","","",399,{"inputs":[{"name":"slice"},{"name":"t"}],"output":{"name":"result"}}],[11,"clone_from_slice","","",399,null],[11,"copy_from_slice","","",399,null],[11,"step","","",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"option"}}],[11,"steps_between","","",409,{"inputs":[{"name":"i64"},{"name":"i64"},{"name":"i64"}],"output":{"name":"option"}}],[11,"step","","",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"option"}}],[11,"steps_between","","",408,{"inputs":[{"name":"u64"},{"name":"u64"},{"name":"u64"}],"output":{"name":"option"}}],[11,"step","","",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"option"}}],[11,"steps_between","","",411,{"inputs":[{"name":"i32"},{"name":"i32"},{"name":"i32"}],"output":{"name":"option"}}],[11,"step","","",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"option"}}],[11,"steps_between","","",413,{"inputs":[{"name":"i16"},{"name":"i16"},{"name":"i16"}],"output":{"name":"option"}}],[11,"step","","",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"option"}}],[11,"steps_between","","",415,{"inputs":[{"name":"i8"},{"name":"i8"},{"name":"i8"}],"output":{"name":"option"}}],[11,"step","","",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"option"}}],[11,"steps_between","","",407,{"inputs":[{"name":"isize"},{"name":"isize"},{"name":"isize"}],"output":{"name":"option"}}],[11,"step","","",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"option"}}],[11,"steps_between","","",410,{"inputs":[{"name":"u32"},{"name":"u32"},{"name":"u32"}],"output":{"name":"option"}}],[11,"step","","",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"option"}}],[11,"steps_between","","",412,{"inputs":[{"name":"u16"},{"name":"u16"},{"name":"u16"}],"output":{"name":"option"}}],[11,"step","","",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"option"}}],[11,"steps_between","","",414,{"inputs":[{"name":"u8"},{"name":"u8"},{"name":"u8"}],"output":{"name":"option"}}],[11,"step","","",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"option"}}],[11,"steps_between","","",406,{"inputs":[{"name":"usize"},{"name":"usize"},{"name":"usize"}],"output":{"name":"option"}}],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"default","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"cmp","","",416,null],[11,"partial_cmp","","",416,null],[11,"lt","","",416,null],[11,"le","","",416,null],[11,"ge","","",416,null],[11,"gt","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",399,null],[11,"ne","","",399,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"eq","","",416,null],[11,"ne","","",416,null],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"itermut"}}],[11,"into_iter","","",416,{"inputs":[{"name":"array"}],"output":{"name":"iter"}}],[11,"fmt","","",416,{"inputs":[{"name":"array"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",416,null],[11,"clone","","",416,null],[11,"borrow_mut","","",416,null],[11,"borrow","","",416,null],[11,"as_mut","","",416,null],[11,"as_ref","","",416,null],[11,"as_ref","","",404,{"inputs":[{"name":"str"}],"output":{"name":"str"}}],[11,"as_mut","","",399,null],[11,"as_ref","","",399,null],[11,"default","","",401,{"inputs":[],"output":{"name":"f64"}}],[11,"default","","",402,{"inputs":[],"output":{"name":"f32"}}],[11,"default","","",409,{"inputs":[],"output":{"name":"i64"}}],[11,"default","","",411,{"inputs":[],"output":{"name":"i32"}}],[11,"default","","",413,{"inputs":[],"output":{"name":"i16"}}],[11,"default","","",415,{"inputs":[],"output":{"name":"i8"}}],[11,"default","","",407,{"inputs":[],"output":{"name":"isize"}}],[11,"default","","",408,{"inputs":[],"output":{"name":"u64"}}],[11,"default","","",410,{"inputs":[],"output":{"name":"u32"}}],[11,"default","","",412,{"inputs":[],"output":{"name":"u16"}}],[11,"default","","",414,{"inputs":[],"output":{"name":"u8"}}],[11,"default","","",406,{"inputs":[],"output":{"name":"usize"}}],[11,"default","","",403,{"inputs":[],"output":{"name":"char"}}],[11,"default","","",405,{"inputs":[],"output":{"name":"bool"}}],[11,"default","","",398,null],[11,"clone","","Returns a deep copy of the value.",403,{"inputs":[{"name":"char"}],"output":{"name":"char"}}],[11,"clone","","Returns a deep copy of the value.",405,{"inputs":[{"name":"bool"}],"output":{"name":"bool"}}],[11,"clone","","Returns a deep copy of the value.",398,null],[11,"clone","","Returns a deep copy of the value.",401,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[11,"clone","","Returns a deep copy of the value.",402,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[11,"clone","","Returns a deep copy of the value.",408,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[11,"clone","","Returns a deep copy of the value.",410,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[11,"clone","","Returns a deep copy of the value.",412,{"inputs":[{"name":"u16"}],"output":{"name":"u16"}}],[11,"clone","","Returns a deep copy of the value.",414,{"inputs":[{"name":"u8"}],"output":{"name":"u8"}}],[11,"clone","","Returns a deep copy of the value.",406,{"inputs":[{"name":"usize"}],"output":{"name":"usize"}}],[11,"clone","","Returns a deep copy of the value.",409,{"inputs":[{"name":"i64"}],"output":{"name":"i64"}}],[11,"clone","","Returns a deep copy of the value.",411,{"inputs":[{"name":"i32"}],"output":{"name":"i32"}}],[11,"clone","","Returns a deep copy of the value.",413,{"inputs":[{"name":"i16"}],"output":{"name":"i16"}}],[11,"clone","","Returns a deep copy of the value.",415,{"inputs":[{"name":"i8"}],"output":{"name":"i8"}}],[11,"clone","","Returns a deep copy of the value.",407,{"inputs":[{"name":"isize"}],"output":{"name":"isize"}}],[11,"cmp","","",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"option"}}],[11,"lt","","",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"bool"}}],[11,"le","","",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"bool"}}],[11,"ge","","",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"bool"}}],[11,"gt","","",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"bool"}}],[11,"cmp","","",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"option"}}],[11,"lt","","",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"bool"}}],[11,"le","","",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"bool"}}],[11,"ge","","",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"bool"}}],[11,"gt","","",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"bool"}}],[11,"cmp","","",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"option"}}],[11,"lt","","",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"bool"}}],[11,"le","","",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"bool"}}],[11,"ge","","",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"bool"}}],[11,"gt","","",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"bool"}}],[11,"cmp","","",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"option"}}],[11,"lt","","",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"bool"}}],[11,"le","","",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"bool"}}],[11,"ge","","",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"bool"}}],[11,"gt","","",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"bool"}}],[11,"cmp","","",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"option"}}],[11,"lt","","",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"bool"}}],[11,"le","","",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"bool"}}],[11,"ge","","",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"bool"}}],[11,"gt","","",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"bool"}}],[11,"cmp","","",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"option"}}],[11,"lt","","",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"bool"}}],[11,"le","","",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"bool"}}],[11,"ge","","",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"bool"}}],[11,"gt","","",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"bool"}}],[11,"cmp","","",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"option"}}],[11,"lt","","",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"bool"}}],[11,"le","","",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"bool"}}],[11,"ge","","",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"bool"}}],[11,"gt","","",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"bool"}}],[11,"cmp","","",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"option"}}],[11,"lt","","",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"bool"}}],[11,"le","","",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"bool"}}],[11,"ge","","",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"bool"}}],[11,"gt","","",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"bool"}}],[11,"cmp","","",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"option"}}],[11,"lt","","",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"bool"}}],[11,"le","","",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"bool"}}],[11,"ge","","",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"bool"}}],[11,"gt","","",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"bool"}}],[11,"cmp","","",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"option"}}],[11,"lt","","",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"le","","",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"ge","","",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"gt","","",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"cmp","","",403,{"inputs":[{"name":"char"},{"name":"char"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",403,{"inputs":[{"name":"char"},{"name":"char"}],"output":{"name":"option"}}],[11,"lt","","",403,{"inputs":[{"name":"char"},{"name":"char"}],"output":{"name":"bool"}}],[11,"le","","",403,{"inputs":[{"name":"char"},{"name":"char"}],"output":{"name":"bool"}}],[11,"ge","","",403,{"inputs":[{"name":"char"},{"name":"char"}],"output":{"name":"bool"}}],[11,"gt","","",403,{"inputs":[{"name":"char"},{"name":"char"}],"output":{"name":"bool"}}],[11,"cmp","","",405,{"inputs":[{"name":"bool"},{"name":"bool"}],"output":{"name":"ordering"}}],[11,"cmp","","",398,null],[11,"partial_cmp","","",401,{"inputs":[{"name":"f64"},{"name":"f64"}],"output":{"name":"option"}}],[11,"lt","","",401,{"inputs":[{"name":"f64"},{"name":"f64"}],"output":{"name":"bool"}}],[11,"le","","",401,{"inputs":[{"name":"f64"},{"name":"f64"}],"output":{"name":"bool"}}],[11,"ge","","",401,{"inputs":[{"name":"f64"},{"name":"f64"}],"output":{"name":"bool"}}],[11,"gt","","",401,{"inputs":[{"name":"f64"},{"name":"f64"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",402,{"inputs":[{"name":"f32"},{"name":"f32"}],"output":{"name":"option"}}],[11,"lt","","",402,{"inputs":[{"name":"f32"},{"name":"f32"}],"output":{"name":"bool"}}],[11,"le","","",402,{"inputs":[{"name":"f32"},{"name":"f32"}],"output":{"name":"bool"}}],[11,"ge","","",402,{"inputs":[{"name":"f32"},{"name":"f32"}],"output":{"name":"bool"}}],[11,"gt","","",402,{"inputs":[{"name":"f32"},{"name":"f32"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",405,{"inputs":[{"name":"bool"},{"name":"bool"}],"output":{"name":"option"}}],[11,"partial_cmp","","",398,null],[11,"eq","","",401,{"inputs":[{"name":"f64"},{"name":"f64"}],"output":{"name":"bool"}}],[11,"ne","","",401,{"inputs":[{"name":"f64"},{"name":"f64"}],"output":{"name":"bool"}}],[11,"eq","","",402,{"inputs":[{"name":"f32"},{"name":"f32"}],"output":{"name":"bool"}}],[11,"ne","","",402,{"inputs":[{"name":"f32"},{"name":"f32"}],"output":{"name":"bool"}}],[11,"eq","","",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"bool"}}],[11,"ne","","",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"bool"}}],[11,"eq","","",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"bool"}}],[11,"ne","","",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"bool"}}],[11,"eq","","",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"bool"}}],[11,"ne","","",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"bool"}}],[11,"eq","","",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"bool"}}],[11,"ne","","",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"bool"}}],[11,"eq","","",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"bool"}}],[11,"ne","","",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"bool"}}],[11,"eq","","",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"bool"}}],[11,"ne","","",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"bool"}}],[11,"eq","","",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"bool"}}],[11,"ne","","",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"bool"}}],[11,"eq","","",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"bool"}}],[11,"ne","","",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"bool"}}],[11,"eq","","",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"bool"}}],[11,"ne","","",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"bool"}}],[11,"eq","","",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"ne","","",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"eq","","",403,{"inputs":[{"name":"char"},{"name":"char"}],"output":{"name":"bool"}}],[11,"ne","","",403,{"inputs":[{"name":"char"},{"name":"char"}],"output":{"name":"bool"}}],[11,"eq","","",405,{"inputs":[{"name":"bool"},{"name":"bool"}],"output":{"name":"bool"}}],[11,"ne","","",405,{"inputs":[{"name":"bool"},{"name":"bool"}],"output":{"name":"bool"}}],[11,"eq","","",398,null],[11,"ne","","",398,null],[11,"shr_assign","","",407,null],[11,"shr_assign","","",407,null],[11,"shr_assign","","",407,null],[11,"shr_assign","","",407,null],[11,"shr_assign","","",407,null],[11,"shr_assign","","",407,null],[11,"shr_assign","","",407,null],[11,"shr_assign","","",407,null],[11,"shr_assign","","",407,null],[11,"shr_assign","","",407,null],[11,"shr_assign","","",409,null],[11,"shr_assign","","",409,null],[11,"shr_assign","","",409,null],[11,"shr_assign","","",409,null],[11,"shr_assign","","",409,null],[11,"shr_assign","","",409,null],[11,"shr_assign","","",409,null],[11,"shr_assign","","",409,null],[11,"shr_assign","","",409,null],[11,"shr_assign","","",409,null],[11,"shr_assign","","",411,null],[11,"shr_assign","","",411,null],[11,"shr_assign","","",411,null],[11,"shr_assign","","",411,null],[11,"shr_assign","","",411,null],[11,"shr_assign","","",411,null],[11,"shr_assign","","",411,null],[11,"shr_assign","","",411,null],[11,"shr_assign","","",411,null],[11,"shr_assign","","",411,null],[11,"shr_assign","","",413,null],[11,"shr_assign","","",413,null],[11,"shr_assign","","",413,null],[11,"shr_assign","","",413,null],[11,"shr_assign","","",413,null],[11,"shr_assign","","",413,null],[11,"shr_assign","","",413,null],[11,"shr_assign","","",413,null],[11,"shr_assign","","",413,null],[11,"shr_assign","","",413,null],[11,"shr_assign","","",415,null],[11,"shr_assign","","",415,null],[11,"shr_assign","","",415,null],[11,"shr_assign","","",415,null],[11,"shr_assign","","",415,null],[11,"shr_assign","","",415,null],[11,"shr_assign","","",415,null],[11,"shr_assign","","",415,null],[11,"shr_assign","","",415,null],[11,"shr_assign","","",415,null],[11,"shr_assign","","",406,null],[11,"shr_assign","","",406,null],[11,"shr_assign","","",406,null],[11,"shr_assign","","",406,null],[11,"shr_assign","","",406,null],[11,"shr_assign","","",406,null],[11,"shr_assign","","",406,null],[11,"shr_assign","","",406,null],[11,"shr_assign","","",406,null],[11,"shr_assign","","",406,null],[11,"shr_assign","","",408,null],[11,"shr_assign","","",408,null],[11,"shr_assign","","",408,null],[11,"shr_assign","","",408,null],[11,"shr_assign","","",408,null],[11,"shr_assign","","",408,null],[11,"shr_assign","","",408,null],[11,"shr_assign","","",408,null],[11,"shr_assign","","",408,null],[11,"shr_assign","","",408,null],[11,"shr_assign","","",410,null],[11,"shr_assign","","",410,null],[11,"shr_assign","","",410,null],[11,"shr_assign","","",410,null],[11,"shr_assign","","",410,null],[11,"shr_assign","","",410,null],[11,"shr_assign","","",410,null],[11,"shr_assign","","",410,null],[11,"shr_assign","","",410,null],[11,"shr_assign","","",410,null],[11,"shr_assign","","",412,null],[11,"shr_assign","","",412,null],[11,"shr_assign","","",412,null],[11,"shr_assign","","",412,null],[11,"shr_assign","","",412,null],[11,"shr_assign","","",412,null],[11,"shr_assign","","",412,null],[11,"shr_assign","","",412,null],[11,"shr_assign","","",412,null],[11,"shr_assign","","",412,null],[11,"shr_assign","","",414,null],[11,"shr_assign","","",414,null],[11,"shr_assign","","",414,null],[11,"shr_assign","","",414,null],[11,"shr_assign","","",414,null],[11,"shr_assign","","",414,null],[11,"shr_assign","","",414,null],[11,"shr_assign","","",414,null],[11,"shr_assign","","",414,null],[11,"shr_assign","","",414,null],[11,"shl_assign","","",407,null],[11,"shl_assign","","",407,null],[11,"shl_assign","","",407,null],[11,"shl_assign","","",407,null],[11,"shl_assign","","",407,null],[11,"shl_assign","","",407,null],[11,"shl_assign","","",407,null],[11,"shl_assign","","",407,null],[11,"shl_assign","","",407,null],[11,"shl_assign","","",407,null],[11,"shl_assign","","",409,null],[11,"shl_assign","","",409,null],[11,"shl_assign","","",409,null],[11,"shl_assign","","",409,null],[11,"shl_assign","","",409,null],[11,"shl_assign","","",409,null],[11,"shl_assign","","",409,null],[11,"shl_assign","","",409,null],[11,"shl_assign","","",409,null],[11,"shl_assign","","",409,null],[11,"shl_assign","","",411,null],[11,"shl_assign","","",411,null],[11,"shl_assign","","",411,null],[11,"shl_assign","","",411,null],[11,"shl_assign","","",411,null],[11,"shl_assign","","",411,null],[11,"shl_assign","","",411,null],[11,"shl_assign","","",411,null],[11,"shl_assign","","",411,null],[11,"shl_assign","","",411,null],[11,"shl_assign","","",413,null],[11,"shl_assign","","",413,null],[11,"shl_assign","","",413,null],[11,"shl_assign","","",413,null],[11,"shl_assign","","",413,null],[11,"shl_assign","","",413,null],[11,"shl_assign","","",413,null],[11,"shl_assign","","",413,null],[11,"shl_assign","","",413,null],[11,"shl_assign","","",413,null],[11,"shl_assign","","",415,null],[11,"shl_assign","","",415,null],[11,"shl_assign","","",415,null],[11,"shl_assign","","",415,null],[11,"shl_assign","","",415,null],[11,"shl_assign","","",415,null],[11,"shl_assign","","",415,null],[11,"shl_assign","","",415,null],[11,"shl_assign","","",415,null],[11,"shl_assign","","",415,null],[11,"shl_assign","","",406,null],[11,"shl_assign","","",406,null],[11,"shl_assign","","",406,null],[11,"shl_assign","","",406,null],[11,"shl_assign","","",406,null],[11,"shl_assign","","",406,null],[11,"shl_assign","","",406,null],[11,"shl_assign","","",406,null],[11,"shl_assign","","",406,null],[11,"shl_assign","","",406,null],[11,"shl_assign","","",408,null],[11,"shl_assign","","",408,null],[11,"shl_assign","","",408,null],[11,"shl_assign","","",408,null],[11,"shl_assign","","",408,null],[11,"shl_assign","","",408,null],[11,"shl_assign","","",408,null],[11,"shl_assign","","",408,null],[11,"shl_assign","","",408,null],[11,"shl_assign","","",408,null],[11,"shl_assign","","",410,null],[11,"shl_assign","","",410,null],[11,"shl_assign","","",410,null],[11,"shl_assign","","",410,null],[11,"shl_assign","","",410,null],[11,"shl_assign","","",410,null],[11,"shl_assign","","",410,null],[11,"shl_assign","","",410,null],[11,"shl_assign","","",410,null],[11,"shl_assign","","",410,null],[11,"shl_assign","","",412,null],[11,"shl_assign","","",412,null],[11,"shl_assign","","",412,null],[11,"shl_assign","","",412,null],[11,"shl_assign","","",412,null],[11,"shl_assign","","",412,null],[11,"shl_assign","","",412,null],[11,"shl_assign","","",412,null],[11,"shl_assign","","",412,null],[11,"shl_assign","","",412,null],[11,"shl_assign","","",414,null],[11,"shl_assign","","",414,null],[11,"shl_assign","","",414,null],[11,"shl_assign","","",414,null],[11,"shl_assign","","",414,null],[11,"shl_assign","","",414,null],[11,"shl_assign","","",414,null],[11,"shl_assign","","",414,null],[11,"shl_assign","","",414,null],[11,"shl_assign","","",414,null],[11,"bitxor_assign","","",409,null],[11,"bitxor_assign","","",411,null],[11,"bitxor_assign","","",413,null],[11,"bitxor_assign","","",415,null],[11,"bitxor_assign","","",407,null],[11,"bitxor_assign","","",408,null],[11,"bitxor_assign","","",410,null],[11,"bitxor_assign","","",412,null],[11,"bitxor_assign","","",414,null],[11,"bitxor_assign","","",406,null],[11,"bitxor_assign","","",405,null],[11,"bitor_assign","","",409,null],[11,"bitor_assign","","",411,null],[11,"bitor_assign","","",413,null],[11,"bitor_assign","","",415,null],[11,"bitor_assign","","",407,null],[11,"bitor_assign","","",408,null],[11,"bitor_assign","","",410,null],[11,"bitor_assign","","",412,null],[11,"bitor_assign","","",414,null],[11,"bitor_assign","","",406,null],[11,"bitor_assign","","",405,null],[11,"bitand_assign","","",409,null],[11,"bitand_assign","","",411,null],[11,"bitand_assign","","",413,null],[11,"bitand_assign","","",415,null],[11,"bitand_assign","","",407,null],[11,"bitand_assign","","",408,null],[11,"bitand_assign","","",410,null],[11,"bitand_assign","","",412,null],[11,"bitand_assign","","",414,null],[11,"bitand_assign","","",406,null],[11,"bitand_assign","","",405,null],[11,"rem_assign","","",401,null],[11,"rem_assign","","",402,null],[11,"rem_assign","","",409,null],[11,"rem_assign","","",411,null],[11,"rem_assign","","",413,null],[11,"rem_assign","","",415,null],[11,"rem_assign","","",407,null],[11,"rem_assign","","",408,null],[11,"rem_assign","","",410,null],[11,"rem_assign","","",412,null],[11,"rem_assign","","",414,null],[11,"rem_assign","","",406,null],[11,"div_assign","","",401,null],[11,"div_assign","","",402,null],[11,"div_assign","","",409,null],[11,"div_assign","","",411,null],[11,"div_assign","","",413,null],[11,"div_assign","","",415,null],[11,"div_assign","","",407,null],[11,"div_assign","","",408,null],[11,"div_assign","","",410,null],[11,"div_assign","","",412,null],[11,"div_assign","","",414,null],[11,"div_assign","","",406,null],[11,"mul_assign","","",401,null],[11,"mul_assign","","",402,null],[11,"mul_assign","","",409,null],[11,"mul_assign","","",411,null],[11,"mul_assign","","",413,null],[11,"mul_assign","","",415,null],[11,"mul_assign","","",407,null],[11,"mul_assign","","",408,null],[11,"mul_assign","","",410,null],[11,"mul_assign","","",412,null],[11,"mul_assign","","",414,null],[11,"mul_assign","","",406,null],[11,"sub_assign","","",401,null],[11,"sub_assign","","",402,null],[11,"sub_assign","","",409,null],[11,"sub_assign","","",411,null],[11,"sub_assign","","",413,null],[11,"sub_assign","","",415,null],[11,"sub_assign","","",407,null],[11,"sub_assign","","",408,null],[11,"sub_assign","","",410,null],[11,"sub_assign","","",412,null],[11,"sub_assign","","",414,null],[11,"sub_assign","","",406,null],[11,"add_assign","","",401,null],[11,"add_assign","","",402,null],[11,"add_assign","","",409,null],[11,"add_assign","","",411,null],[11,"add_assign","","",413,null],[11,"add_assign","","",415,null],[11,"add_assign","","",407,null],[11,"add_assign","","",408,null],[11,"add_assign","","",410,null],[11,"add_assign","","",412,null],[11,"add_assign","","",414,null],[11,"add_assign","","",406,null],[11,"shr","","",407,null],[11,"shr","","",407,null],[11,"shr","","",407,null],[11,"shr","","",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"shr","","",407,null],[11,"shr","","",407,null],[11,"shr","","",407,null],[11,"shr","","",407,{"inputs":[{"name":"isize"},{"name":"i64"}],"output":{"name":"isize"}}],[11,"shr","","",407,null],[11,"shr","","",407,null],[11,"shr","","",407,null],[11,"shr","","",407,{"inputs":[{"name":"isize"},{"name":"i32"}],"output":{"name":"isize"}}],[11,"shr","","",407,null],[11,"shr","","",407,null],[11,"shr","","",407,null],[11,"shr","","",407,{"inputs":[{"name":"isize"},{"name":"i16"}],"output":{"name":"isize"}}],[11,"shr","","",407,null],[11,"shr","","",407,null],[11,"shr","","",407,null],[11,"shr","","",407,{"inputs":[{"name":"isize"},{"name":"i8"}],"output":{"name":"isize"}}],[11,"shr","","",407,null],[11,"shr","","",407,null],[11,"shr","","",407,null],[11,"shr","","",407,{"inputs":[{"name":"isize"},{"name":"usize"}],"output":{"name":"isize"}}],[11,"shr","","",407,null],[11,"shr","","",407,null],[11,"shr","","",407,null],[11,"shr","","",407,{"inputs":[{"name":"isize"},{"name":"u64"}],"output":{"name":"isize"}}],[11,"shr","","",407,null],[11,"shr","","",407,null],[11,"shr","","",407,null],[11,"shr","","",407,{"inputs":[{"name":"isize"},{"name":"u32"}],"output":{"name":"isize"}}],[11,"shr","","",407,null],[11,"shr","","",407,null],[11,"shr","","",407,null],[11,"shr","","",407,{"inputs":[{"name":"isize"},{"name":"u16"}],"output":{"name":"isize"}}],[11,"shr","","",407,null],[11,"shr","","",407,null],[11,"shr","","",407,null],[11,"shr","","",407,{"inputs":[{"name":"isize"},{"name":"u8"}],"output":{"name":"isize"}}],[11,"shr","","",409,null],[11,"shr","","",409,null],[11,"shr","","",409,null],[11,"shr","","",409,{"inputs":[{"name":"i64"},{"name":"isize"}],"output":{"name":"i64"}}],[11,"shr","","",409,null],[11,"shr","","",409,null],[11,"shr","","",409,null],[11,"shr","","",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"shr","","",409,null],[11,"shr","","",409,null],[11,"shr","","",409,null],[11,"shr","","",409,{"inputs":[{"name":"i64"},{"name":"i32"}],"output":{"name":"i64"}}],[11,"shr","","",409,null],[11,"shr","","",409,null],[11,"shr","","",409,null],[11,"shr","","",409,{"inputs":[{"name":"i64"},{"name":"i16"}],"output":{"name":"i64"}}],[11,"shr","","",409,null],[11,"shr","","",409,null],[11,"shr","","",409,null],[11,"shr","","",409,{"inputs":[{"name":"i64"},{"name":"i8"}],"output":{"name":"i64"}}],[11,"shr","","",409,null],[11,"shr","","",409,null],[11,"shr","","",409,null],[11,"shr","","",409,{"inputs":[{"name":"i64"},{"name":"usize"}],"output":{"name":"i64"}}],[11,"shr","","",409,null],[11,"shr","","",409,null],[11,"shr","","",409,null],[11,"shr","","",409,{"inputs":[{"name":"i64"},{"name":"u64"}],"output":{"name":"i64"}}],[11,"shr","","",409,null],[11,"shr","","",409,null],[11,"shr","","",409,null],[11,"shr","","",409,{"inputs":[{"name":"i64"},{"name":"u32"}],"output":{"name":"i64"}}],[11,"shr","","",409,null],[11,"shr","","",409,null],[11,"shr","","",409,null],[11,"shr","","",409,{"inputs":[{"name":"i64"},{"name":"u16"}],"output":{"name":"i64"}}],[11,"shr","","",409,null],[11,"shr","","",409,null],[11,"shr","","",409,null],[11,"shr","","",409,{"inputs":[{"name":"i64"},{"name":"u8"}],"output":{"name":"i64"}}],[11,"shr","","",411,null],[11,"shr","","",411,null],[11,"shr","","",411,null],[11,"shr","","",411,{"inputs":[{"name":"i32"},{"name":"isize"}],"output":{"name":"i32"}}],[11,"shr","","",411,null],[11,"shr","","",411,null],[11,"shr","","",411,null],[11,"shr","","",411,{"inputs":[{"name":"i32"},{"name":"i64"}],"output":{"name":"i32"}}],[11,"shr","","",411,null],[11,"shr","","",411,null],[11,"shr","","",411,null],[11,"shr","","",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"shr","","",411,null],[11,"shr","","",411,null],[11,"shr","","",411,null],[11,"shr","","",411,{"inputs":[{"name":"i32"},{"name":"i16"}],"output":{"name":"i32"}}],[11,"shr","","",411,null],[11,"shr","","",411,null],[11,"shr","","",411,null],[11,"shr","","",411,{"inputs":[{"name":"i32"},{"name":"i8"}],"output":{"name":"i32"}}],[11,"shr","","",411,null],[11,"shr","","",411,null],[11,"shr","","",411,null],[11,"shr","","",411,{"inputs":[{"name":"i32"},{"name":"usize"}],"output":{"name":"i32"}}],[11,"shr","","",411,null],[11,"shr","","",411,null],[11,"shr","","",411,null],[11,"shr","","",411,{"inputs":[{"name":"i32"},{"name":"u64"}],"output":{"name":"i32"}}],[11,"shr","","",411,null],[11,"shr","","",411,null],[11,"shr","","",411,null],[11,"shr","","",411,{"inputs":[{"name":"i32"},{"name":"u32"}],"output":{"name":"i32"}}],[11,"shr","","",411,null],[11,"shr","","",411,null],[11,"shr","","",411,null],[11,"shr","","",411,{"inputs":[{"name":"i32"},{"name":"u16"}],"output":{"name":"i32"}}],[11,"shr","","",411,null],[11,"shr","","",411,null],[11,"shr","","",411,null],[11,"shr","","",411,{"inputs":[{"name":"i32"},{"name":"u8"}],"output":{"name":"i32"}}],[11,"shr","","",413,null],[11,"shr","","",413,null],[11,"shr","","",413,null],[11,"shr","","",413,{"inputs":[{"name":"i16"},{"name":"isize"}],"output":{"name":"i16"}}],[11,"shr","","",413,null],[11,"shr","","",413,null],[11,"shr","","",413,null],[11,"shr","","",413,{"inputs":[{"name":"i16"},{"name":"i64"}],"output":{"name":"i16"}}],[11,"shr","","",413,null],[11,"shr","","",413,null],[11,"shr","","",413,null],[11,"shr","","",413,{"inputs":[{"name":"i16"},{"name":"i32"}],"output":{"name":"i16"}}],[11,"shr","","",413,null],[11,"shr","","",413,null],[11,"shr","","",413,null],[11,"shr","","",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"shr","","",413,null],[11,"shr","","",413,null],[11,"shr","","",413,null],[11,"shr","","",413,{"inputs":[{"name":"i16"},{"name":"i8"}],"output":{"name":"i16"}}],[11,"shr","","",413,null],[11,"shr","","",413,null],[11,"shr","","",413,null],[11,"shr","","",413,{"inputs":[{"name":"i16"},{"name":"usize"}],"output":{"name":"i16"}}],[11,"shr","","",413,null],[11,"shr","","",413,null],[11,"shr","","",413,null],[11,"shr","","",413,{"inputs":[{"name":"i16"},{"name":"u64"}],"output":{"name":"i16"}}],[11,"shr","","",413,null],[11,"shr","","",413,null],[11,"shr","","",413,null],[11,"shr","","",413,{"inputs":[{"name":"i16"},{"name":"u32"}],"output":{"name":"i16"}}],[11,"shr","","",413,null],[11,"shr","","",413,null],[11,"shr","","",413,null],[11,"shr","","",413,{"inputs":[{"name":"i16"},{"name":"u16"}],"output":{"name":"i16"}}],[11,"shr","","",413,null],[11,"shr","","",413,null],[11,"shr","","",413,null],[11,"shr","","",413,{"inputs":[{"name":"i16"},{"name":"u8"}],"output":{"name":"i16"}}],[11,"shr","","",415,null],[11,"shr","","",415,null],[11,"shr","","",415,null],[11,"shr","","",415,{"inputs":[{"name":"i8"},{"name":"isize"}],"output":{"name":"i8"}}],[11,"shr","","",415,null],[11,"shr","","",415,null],[11,"shr","","",415,null],[11,"shr","","",415,{"inputs":[{"name":"i8"},{"name":"i64"}],"output":{"name":"i8"}}],[11,"shr","","",415,null],[11,"shr","","",415,null],[11,"shr","","",415,null],[11,"shr","","",415,{"inputs":[{"name":"i8"},{"name":"i32"}],"output":{"name":"i8"}}],[11,"shr","","",415,null],[11,"shr","","",415,null],[11,"shr","","",415,null],[11,"shr","","",415,{"inputs":[{"name":"i8"},{"name":"i16"}],"output":{"name":"i8"}}],[11,"shr","","",415,null],[11,"shr","","",415,null],[11,"shr","","",415,null],[11,"shr","","",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"shr","","",415,null],[11,"shr","","",415,null],[11,"shr","","",415,null],[11,"shr","","",415,{"inputs":[{"name":"i8"},{"name":"usize"}],"output":{"name":"i8"}}],[11,"shr","","",415,null],[11,"shr","","",415,null],[11,"shr","","",415,null],[11,"shr","","",415,{"inputs":[{"name":"i8"},{"name":"u64"}],"output":{"name":"i8"}}],[11,"shr","","",415,null],[11,"shr","","",415,null],[11,"shr","","",415,null],[11,"shr","","",415,{"inputs":[{"name":"i8"},{"name":"u32"}],"output":{"name":"i8"}}],[11,"shr","","",415,null],[11,"shr","","",415,null],[11,"shr","","",415,null],[11,"shr","","",415,{"inputs":[{"name":"i8"},{"name":"u16"}],"output":{"name":"i8"}}],[11,"shr","","",415,null],[11,"shr","","",415,null],[11,"shr","","",415,null],[11,"shr","","",415,{"inputs":[{"name":"i8"},{"name":"u8"}],"output":{"name":"i8"}}],[11,"shr","","",406,null],[11,"shr","","",406,null],[11,"shr","","",406,null],[11,"shr","","",406,{"inputs":[{"name":"usize"},{"name":"isize"}],"output":{"name":"usize"}}],[11,"shr","","",406,null],[11,"shr","","",406,null],[11,"shr","","",406,null],[11,"shr","","",406,{"inputs":[{"name":"usize"},{"name":"i64"}],"output":{"name":"usize"}}],[11,"shr","","",406,null],[11,"shr","","",406,null],[11,"shr","","",406,null],[11,"shr","","",406,{"inputs":[{"name":"usize"},{"name":"i32"}],"output":{"name":"usize"}}],[11,"shr","","",406,null],[11,"shr","","",406,null],[11,"shr","","",406,null],[11,"shr","","",406,{"inputs":[{"name":"usize"},{"name":"i16"}],"output":{"name":"usize"}}],[11,"shr","","",406,null],[11,"shr","","",406,null],[11,"shr","","",406,null],[11,"shr","","",406,{"inputs":[{"name":"usize"},{"name":"i8"}],"output":{"name":"usize"}}],[11,"shr","","",406,null],[11,"shr","","",406,null],[11,"shr","","",406,null],[11,"shr","","",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"shr","","",406,null],[11,"shr","","",406,null],[11,"shr","","",406,null],[11,"shr","","",406,{"inputs":[{"name":"usize"},{"name":"u64"}],"output":{"name":"usize"}}],[11,"shr","","",406,null],[11,"shr","","",406,null],[11,"shr","","",406,null],[11,"shr","","",406,{"inputs":[{"name":"usize"},{"name":"u32"}],"output":{"name":"usize"}}],[11,"shr","","",406,null],[11,"shr","","",406,null],[11,"shr","","",406,null],[11,"shr","","",406,{"inputs":[{"name":"usize"},{"name":"u16"}],"output":{"name":"usize"}}],[11,"shr","","",406,null],[11,"shr","","",406,null],[11,"shr","","",406,null],[11,"shr","","",406,{"inputs":[{"name":"usize"},{"name":"u8"}],"output":{"name":"usize"}}],[11,"shr","","",408,null],[11,"shr","","",408,null],[11,"shr","","",408,null],[11,"shr","","",408,{"inputs":[{"name":"u64"},{"name":"isize"}],"output":{"name":"u64"}}],[11,"shr","","",408,null],[11,"shr","","",408,null],[11,"shr","","",408,null],[11,"shr","","",408,{"inputs":[{"name":"u64"},{"name":"i64"}],"output":{"name":"u64"}}],[11,"shr","","",408,null],[11,"shr","","",408,null],[11,"shr","","",408,null],[11,"shr","","",408,{"inputs":[{"name":"u64"},{"name":"i32"}],"output":{"name":"u64"}}],[11,"shr","","",408,null],[11,"shr","","",408,null],[11,"shr","","",408,null],[11,"shr","","",408,{"inputs":[{"name":"u64"},{"name":"i16"}],"output":{"name":"u64"}}],[11,"shr","","",408,null],[11,"shr","","",408,null],[11,"shr","","",408,null],[11,"shr","","",408,{"inputs":[{"name":"u64"},{"name":"i8"}],"output":{"name":"u64"}}],[11,"shr","","",408,null],[11,"shr","","",408,null],[11,"shr","","",408,null],[11,"shr","","",408,{"inputs":[{"name":"u64"},{"name":"usize"}],"output":{"name":"u64"}}],[11,"shr","","",408,null],[11,"shr","","",408,null],[11,"shr","","",408,null],[11,"shr","","",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"shr","","",408,null],[11,"shr","","",408,null],[11,"shr","","",408,null],[11,"shr","","",408,{"inputs":[{"name":"u64"},{"name":"u32"}],"output":{"name":"u64"}}],[11,"shr","","",408,null],[11,"shr","","",408,null],[11,"shr","","",408,null],[11,"shr","","",408,{"inputs":[{"name":"u64"},{"name":"u16"}],"output":{"name":"u64"}}],[11,"shr","","",408,null],[11,"shr","","",408,null],[11,"shr","","",408,null],[11,"shr","","",408,{"inputs":[{"name":"u64"},{"name":"u8"}],"output":{"name":"u64"}}],[11,"shr","","",410,null],[11,"shr","","",410,null],[11,"shr","","",410,null],[11,"shr","","",410,{"inputs":[{"name":"u32"},{"name":"isize"}],"output":{"name":"u32"}}],[11,"shr","","",410,null],[11,"shr","","",410,null],[11,"shr","","",410,null],[11,"shr","","",410,{"inputs":[{"name":"u32"},{"name":"i64"}],"output":{"name":"u32"}}],[11,"shr","","",410,null],[11,"shr","","",410,null],[11,"shr","","",410,null],[11,"shr","","",410,{"inputs":[{"name":"u32"},{"name":"i32"}],"output":{"name":"u32"}}],[11,"shr","","",410,null],[11,"shr","","",410,null],[11,"shr","","",410,null],[11,"shr","","",410,{"inputs":[{"name":"u32"},{"name":"i16"}],"output":{"name":"u32"}}],[11,"shr","","",410,null],[11,"shr","","",410,null],[11,"shr","","",410,null],[11,"shr","","",410,{"inputs":[{"name":"u32"},{"name":"i8"}],"output":{"name":"u32"}}],[11,"shr","","",410,null],[11,"shr","","",410,null],[11,"shr","","",410,null],[11,"shr","","",410,{"inputs":[{"name":"u32"},{"name":"usize"}],"output":{"name":"u32"}}],[11,"shr","","",410,null],[11,"shr","","",410,null],[11,"shr","","",410,null],[11,"shr","","",410,{"inputs":[{"name":"u32"},{"name":"u64"}],"output":{"name":"u32"}}],[11,"shr","","",410,null],[11,"shr","","",410,null],[11,"shr","","",410,null],[11,"shr","","",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"shr","","",410,null],[11,"shr","","",410,null],[11,"shr","","",410,null],[11,"shr","","",410,{"inputs":[{"name":"u32"},{"name":"u16"}],"output":{"name":"u32"}}],[11,"shr","","",410,null],[11,"shr","","",410,null],[11,"shr","","",410,null],[11,"shr","","",410,{"inputs":[{"name":"u32"},{"name":"u8"}],"output":{"name":"u32"}}],[11,"shr","","",412,null],[11,"shr","","",412,null],[11,"shr","","",412,null],[11,"shr","","",412,{"inputs":[{"name":"u16"},{"name":"isize"}],"output":{"name":"u16"}}],[11,"shr","","",412,null],[11,"shr","","",412,null],[11,"shr","","",412,null],[11,"shr","","",412,{"inputs":[{"name":"u16"},{"name":"i64"}],"output":{"name":"u16"}}],[11,"shr","","",412,null],[11,"shr","","",412,null],[11,"shr","","",412,null],[11,"shr","","",412,{"inputs":[{"name":"u16"},{"name":"i32"}],"output":{"name":"u16"}}],[11,"shr","","",412,null],[11,"shr","","",412,null],[11,"shr","","",412,null],[11,"shr","","",412,{"inputs":[{"name":"u16"},{"name":"i16"}],"output":{"name":"u16"}}],[11,"shr","","",412,null],[11,"shr","","",412,null],[11,"shr","","",412,null],[11,"shr","","",412,{"inputs":[{"name":"u16"},{"name":"i8"}],"output":{"name":"u16"}}],[11,"shr","","",412,null],[11,"shr","","",412,null],[11,"shr","","",412,null],[11,"shr","","",412,{"inputs":[{"name":"u16"},{"name":"usize"}],"output":{"name":"u16"}}],[11,"shr","","",412,null],[11,"shr","","",412,null],[11,"shr","","",412,null],[11,"shr","","",412,{"inputs":[{"name":"u16"},{"name":"u64"}],"output":{"name":"u16"}}],[11,"shr","","",412,null],[11,"shr","","",412,null],[11,"shr","","",412,null],[11,"shr","","",412,{"inputs":[{"name":"u16"},{"name":"u32"}],"output":{"name":"u16"}}],[11,"shr","","",412,null],[11,"shr","","",412,null],[11,"shr","","",412,null],[11,"shr","","",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"shr","","",412,null],[11,"shr","","",412,null],[11,"shr","","",412,null],[11,"shr","","",412,{"inputs":[{"name":"u16"},{"name":"u8"}],"output":{"name":"u16"}}],[11,"shr","","",414,null],[11,"shr","","",414,null],[11,"shr","","",414,null],[11,"shr","","",414,{"inputs":[{"name":"u8"},{"name":"isize"}],"output":{"name":"u8"}}],[11,"shr","","",414,null],[11,"shr","","",414,null],[11,"shr","","",414,null],[11,"shr","","",414,{"inputs":[{"name":"u8"},{"name":"i64"}],"output":{"name":"u8"}}],[11,"shr","","",414,null],[11,"shr","","",414,null],[11,"shr","","",414,null],[11,"shr","","",414,{"inputs":[{"name":"u8"},{"name":"i32"}],"output":{"name":"u8"}}],[11,"shr","","",414,null],[11,"shr","","",414,null],[11,"shr","","",414,null],[11,"shr","","",414,{"inputs":[{"name":"u8"},{"name":"i16"}],"output":{"name":"u8"}}],[11,"shr","","",414,null],[11,"shr","","",414,null],[11,"shr","","",414,null],[11,"shr","","",414,{"inputs":[{"name":"u8"},{"name":"i8"}],"output":{"name":"u8"}}],[11,"shr","","",414,null],[11,"shr","","",414,null],[11,"shr","","",414,null],[11,"shr","","",414,{"inputs":[{"name":"u8"},{"name":"usize"}],"output":{"name":"u8"}}],[11,"shr","","",414,null],[11,"shr","","",414,null],[11,"shr","","",414,null],[11,"shr","","",414,{"inputs":[{"name":"u8"},{"name":"u64"}],"output":{"name":"u8"}}],[11,"shr","","",414,null],[11,"shr","","",414,null],[11,"shr","","",414,null],[11,"shr","","",414,{"inputs":[{"name":"u8"},{"name":"u32"}],"output":{"name":"u8"}}],[11,"shr","","",414,null],[11,"shr","","",414,null],[11,"shr","","",414,null],[11,"shr","","",414,{"inputs":[{"name":"u8"},{"name":"u16"}],"output":{"name":"u8"}}],[11,"shr","","",414,null],[11,"shr","","",414,null],[11,"shr","","",414,null],[11,"shr","","",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"shl","","",407,null],[11,"shl","","",407,null],[11,"shl","","",407,null],[11,"shl","","",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"shl","","",407,null],[11,"shl","","",407,null],[11,"shl","","",407,null],[11,"shl","","",407,{"inputs":[{"name":"isize"},{"name":"i64"}],"output":{"name":"isize"}}],[11,"shl","","",407,null],[11,"shl","","",407,null],[11,"shl","","",407,null],[11,"shl","","",407,{"inputs":[{"name":"isize"},{"name":"i32"}],"output":{"name":"isize"}}],[11,"shl","","",407,null],[11,"shl","","",407,null],[11,"shl","","",407,null],[11,"shl","","",407,{"inputs":[{"name":"isize"},{"name":"i16"}],"output":{"name":"isize"}}],[11,"shl","","",407,null],[11,"shl","","",407,null],[11,"shl","","",407,null],[11,"shl","","",407,{"inputs":[{"name":"isize"},{"name":"i8"}],"output":{"name":"isize"}}],[11,"shl","","",407,null],[11,"shl","","",407,null],[11,"shl","","",407,null],[11,"shl","","",407,{"inputs":[{"name":"isize"},{"name":"usize"}],"output":{"name":"isize"}}],[11,"shl","","",407,null],[11,"shl","","",407,null],[11,"shl","","",407,null],[11,"shl","","",407,{"inputs":[{"name":"isize"},{"name":"u64"}],"output":{"name":"isize"}}],[11,"shl","","",407,null],[11,"shl","","",407,null],[11,"shl","","",407,null],[11,"shl","","",407,{"inputs":[{"name":"isize"},{"name":"u32"}],"output":{"name":"isize"}}],[11,"shl","","",407,null],[11,"shl","","",407,null],[11,"shl","","",407,null],[11,"shl","","",407,{"inputs":[{"name":"isize"},{"name":"u16"}],"output":{"name":"isize"}}],[11,"shl","","",407,null],[11,"shl","","",407,null],[11,"shl","","",407,null],[11,"shl","","",407,{"inputs":[{"name":"isize"},{"name":"u8"}],"output":{"name":"isize"}}],[11,"shl","","",409,null],[11,"shl","","",409,null],[11,"shl","","",409,null],[11,"shl","","",409,{"inputs":[{"name":"i64"},{"name":"isize"}],"output":{"name":"i64"}}],[11,"shl","","",409,null],[11,"shl","","",409,null],[11,"shl","","",409,null],[11,"shl","","",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"shl","","",409,null],[11,"shl","","",409,null],[11,"shl","","",409,null],[11,"shl","","",409,{"inputs":[{"name":"i64"},{"name":"i32"}],"output":{"name":"i64"}}],[11,"shl","","",409,null],[11,"shl","","",409,null],[11,"shl","","",409,null],[11,"shl","","",409,{"inputs":[{"name":"i64"},{"name":"i16"}],"output":{"name":"i64"}}],[11,"shl","","",409,null],[11,"shl","","",409,null],[11,"shl","","",409,null],[11,"shl","","",409,{"inputs":[{"name":"i64"},{"name":"i8"}],"output":{"name":"i64"}}],[11,"shl","","",409,null],[11,"shl","","",409,null],[11,"shl","","",409,null],[11,"shl","","",409,{"inputs":[{"name":"i64"},{"name":"usize"}],"output":{"name":"i64"}}],[11,"shl","","",409,null],[11,"shl","","",409,null],[11,"shl","","",409,null],[11,"shl","","",409,{"inputs":[{"name":"i64"},{"name":"u64"}],"output":{"name":"i64"}}],[11,"shl","","",409,null],[11,"shl","","",409,null],[11,"shl","","",409,null],[11,"shl","","",409,{"inputs":[{"name":"i64"},{"name":"u32"}],"output":{"name":"i64"}}],[11,"shl","","",409,null],[11,"shl","","",409,null],[11,"shl","","",409,null],[11,"shl","","",409,{"inputs":[{"name":"i64"},{"name":"u16"}],"output":{"name":"i64"}}],[11,"shl","","",409,null],[11,"shl","","",409,null],[11,"shl","","",409,null],[11,"shl","","",409,{"inputs":[{"name":"i64"},{"name":"u8"}],"output":{"name":"i64"}}],[11,"shl","","",411,null],[11,"shl","","",411,null],[11,"shl","","",411,null],[11,"shl","","",411,{"inputs":[{"name":"i32"},{"name":"isize"}],"output":{"name":"i32"}}],[11,"shl","","",411,null],[11,"shl","","",411,null],[11,"shl","","",411,null],[11,"shl","","",411,{"inputs":[{"name":"i32"},{"name":"i64"}],"output":{"name":"i32"}}],[11,"shl","","",411,null],[11,"shl","","",411,null],[11,"shl","","",411,null],[11,"shl","","",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"shl","","",411,null],[11,"shl","","",411,null],[11,"shl","","",411,null],[11,"shl","","",411,{"inputs":[{"name":"i32"},{"name":"i16"}],"output":{"name":"i32"}}],[11,"shl","","",411,null],[11,"shl","","",411,null],[11,"shl","","",411,null],[11,"shl","","",411,{"inputs":[{"name":"i32"},{"name":"i8"}],"output":{"name":"i32"}}],[11,"shl","","",411,null],[11,"shl","","",411,null],[11,"shl","","",411,null],[11,"shl","","",411,{"inputs":[{"name":"i32"},{"name":"usize"}],"output":{"name":"i32"}}],[11,"shl","","",411,null],[11,"shl","","",411,null],[11,"shl","","",411,null],[11,"shl","","",411,{"inputs":[{"name":"i32"},{"name":"u64"}],"output":{"name":"i32"}}],[11,"shl","","",411,null],[11,"shl","","",411,null],[11,"shl","","",411,null],[11,"shl","","",411,{"inputs":[{"name":"i32"},{"name":"u32"}],"output":{"name":"i32"}}],[11,"shl","","",411,null],[11,"shl","","",411,null],[11,"shl","","",411,null],[11,"shl","","",411,{"inputs":[{"name":"i32"},{"name":"u16"}],"output":{"name":"i32"}}],[11,"shl","","",411,null],[11,"shl","","",411,null],[11,"shl","","",411,null],[11,"shl","","",411,{"inputs":[{"name":"i32"},{"name":"u8"}],"output":{"name":"i32"}}],[11,"shl","","",413,null],[11,"shl","","",413,null],[11,"shl","","",413,null],[11,"shl","","",413,{"inputs":[{"name":"i16"},{"name":"isize"}],"output":{"name":"i16"}}],[11,"shl","","",413,null],[11,"shl","","",413,null],[11,"shl","","",413,null],[11,"shl","","",413,{"inputs":[{"name":"i16"},{"name":"i64"}],"output":{"name":"i16"}}],[11,"shl","","",413,null],[11,"shl","","",413,null],[11,"shl","","",413,null],[11,"shl","","",413,{"inputs":[{"name":"i16"},{"name":"i32"}],"output":{"name":"i16"}}],[11,"shl","","",413,null],[11,"shl","","",413,null],[11,"shl","","",413,null],[11,"shl","","",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"shl","","",413,null],[11,"shl","","",413,null],[11,"shl","","",413,null],[11,"shl","","",413,{"inputs":[{"name":"i16"},{"name":"i8"}],"output":{"name":"i16"}}],[11,"shl","","",413,null],[11,"shl","","",413,null],[11,"shl","","",413,null],[11,"shl","","",413,{"inputs":[{"name":"i16"},{"name":"usize"}],"output":{"name":"i16"}}],[11,"shl","","",413,null],[11,"shl","","",413,null],[11,"shl","","",413,null],[11,"shl","","",413,{"inputs":[{"name":"i16"},{"name":"u64"}],"output":{"name":"i16"}}],[11,"shl","","",413,null],[11,"shl","","",413,null],[11,"shl","","",413,null],[11,"shl","","",413,{"inputs":[{"name":"i16"},{"name":"u32"}],"output":{"name":"i16"}}],[11,"shl","","",413,null],[11,"shl","","",413,null],[11,"shl","","",413,null],[11,"shl","","",413,{"inputs":[{"name":"i16"},{"name":"u16"}],"output":{"name":"i16"}}],[11,"shl","","",413,null],[11,"shl","","",413,null],[11,"shl","","",413,null],[11,"shl","","",413,{"inputs":[{"name":"i16"},{"name":"u8"}],"output":{"name":"i16"}}],[11,"shl","","",415,null],[11,"shl","","",415,null],[11,"shl","","",415,null],[11,"shl","","",415,{"inputs":[{"name":"i8"},{"name":"isize"}],"output":{"name":"i8"}}],[11,"shl","","",415,null],[11,"shl","","",415,null],[11,"shl","","",415,null],[11,"shl","","",415,{"inputs":[{"name":"i8"},{"name":"i64"}],"output":{"name":"i8"}}],[11,"shl","","",415,null],[11,"shl","","",415,null],[11,"shl","","",415,null],[11,"shl","","",415,{"inputs":[{"name":"i8"},{"name":"i32"}],"output":{"name":"i8"}}],[11,"shl","","",415,null],[11,"shl","","",415,null],[11,"shl","","",415,null],[11,"shl","","",415,{"inputs":[{"name":"i8"},{"name":"i16"}],"output":{"name":"i8"}}],[11,"shl","","",415,null],[11,"shl","","",415,null],[11,"shl","","",415,null],[11,"shl","","",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"shl","","",415,null],[11,"shl","","",415,null],[11,"shl","","",415,null],[11,"shl","","",415,{"inputs":[{"name":"i8"},{"name":"usize"}],"output":{"name":"i8"}}],[11,"shl","","",415,null],[11,"shl","","",415,null],[11,"shl","","",415,null],[11,"shl","","",415,{"inputs":[{"name":"i8"},{"name":"u64"}],"output":{"name":"i8"}}],[11,"shl","","",415,null],[11,"shl","","",415,null],[11,"shl","","",415,null],[11,"shl","","",415,{"inputs":[{"name":"i8"},{"name":"u32"}],"output":{"name":"i8"}}],[11,"shl","","",415,null],[11,"shl","","",415,null],[11,"shl","","",415,null],[11,"shl","","",415,{"inputs":[{"name":"i8"},{"name":"u16"}],"output":{"name":"i8"}}],[11,"shl","","",415,null],[11,"shl","","",415,null],[11,"shl","","",415,null],[11,"shl","","",415,{"inputs":[{"name":"i8"},{"name":"u8"}],"output":{"name":"i8"}}],[11,"shl","","",406,null],[11,"shl","","",406,null],[11,"shl","","",406,null],[11,"shl","","",406,{"inputs":[{"name":"usize"},{"name":"isize"}],"output":{"name":"usize"}}],[11,"shl","","",406,null],[11,"shl","","",406,null],[11,"shl","","",406,null],[11,"shl","","",406,{"inputs":[{"name":"usize"},{"name":"i64"}],"output":{"name":"usize"}}],[11,"shl","","",406,null],[11,"shl","","",406,null],[11,"shl","","",406,null],[11,"shl","","",406,{"inputs":[{"name":"usize"},{"name":"i32"}],"output":{"name":"usize"}}],[11,"shl","","",406,null],[11,"shl","","",406,null],[11,"shl","","",406,null],[11,"shl","","",406,{"inputs":[{"name":"usize"},{"name":"i16"}],"output":{"name":"usize"}}],[11,"shl","","",406,null],[11,"shl","","",406,null],[11,"shl","","",406,null],[11,"shl","","",406,{"inputs":[{"name":"usize"},{"name":"i8"}],"output":{"name":"usize"}}],[11,"shl","","",406,null],[11,"shl","","",406,null],[11,"shl","","",406,null],[11,"shl","","",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"shl","","",406,null],[11,"shl","","",406,null],[11,"shl","","",406,null],[11,"shl","","",406,{"inputs":[{"name":"usize"},{"name":"u64"}],"output":{"name":"usize"}}],[11,"shl","","",406,null],[11,"shl","","",406,null],[11,"shl","","",406,null],[11,"shl","","",406,{"inputs":[{"name":"usize"},{"name":"u32"}],"output":{"name":"usize"}}],[11,"shl","","",406,null],[11,"shl","","",406,null],[11,"shl","","",406,null],[11,"shl","","",406,{"inputs":[{"name":"usize"},{"name":"u16"}],"output":{"name":"usize"}}],[11,"shl","","",406,null],[11,"shl","","",406,null],[11,"shl","","",406,null],[11,"shl","","",406,{"inputs":[{"name":"usize"},{"name":"u8"}],"output":{"name":"usize"}}],[11,"shl","","",408,null],[11,"shl","","",408,null],[11,"shl","","",408,null],[11,"shl","","",408,{"inputs":[{"name":"u64"},{"name":"isize"}],"output":{"name":"u64"}}],[11,"shl","","",408,null],[11,"shl","","",408,null],[11,"shl","","",408,null],[11,"shl","","",408,{"inputs":[{"name":"u64"},{"name":"i64"}],"output":{"name":"u64"}}],[11,"shl","","",408,null],[11,"shl","","",408,null],[11,"shl","","",408,null],[11,"shl","","",408,{"inputs":[{"name":"u64"},{"name":"i32"}],"output":{"name":"u64"}}],[11,"shl","","",408,null],[11,"shl","","",408,null],[11,"shl","","",408,null],[11,"shl","","",408,{"inputs":[{"name":"u64"},{"name":"i16"}],"output":{"name":"u64"}}],[11,"shl","","",408,null],[11,"shl","","",408,null],[11,"shl","","",408,null],[11,"shl","","",408,{"inputs":[{"name":"u64"},{"name":"i8"}],"output":{"name":"u64"}}],[11,"shl","","",408,null],[11,"shl","","",408,null],[11,"shl","","",408,null],[11,"shl","","",408,{"inputs":[{"name":"u64"},{"name":"usize"}],"output":{"name":"u64"}}],[11,"shl","","",408,null],[11,"shl","","",408,null],[11,"shl","","",408,null],[11,"shl","","",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"shl","","",408,null],[11,"shl","","",408,null],[11,"shl","","",408,null],[11,"shl","","",408,{"inputs":[{"name":"u64"},{"name":"u32"}],"output":{"name":"u64"}}],[11,"shl","","",408,null],[11,"shl","","",408,null],[11,"shl","","",408,null],[11,"shl","","",408,{"inputs":[{"name":"u64"},{"name":"u16"}],"output":{"name":"u64"}}],[11,"shl","","",408,null],[11,"shl","","",408,null],[11,"shl","","",408,null],[11,"shl","","",408,{"inputs":[{"name":"u64"},{"name":"u8"}],"output":{"name":"u64"}}],[11,"shl","","",410,null],[11,"shl","","",410,null],[11,"shl","","",410,null],[11,"shl","","",410,{"inputs":[{"name":"u32"},{"name":"isize"}],"output":{"name":"u32"}}],[11,"shl","","",410,null],[11,"shl","","",410,null],[11,"shl","","",410,null],[11,"shl","","",410,{"inputs":[{"name":"u32"},{"name":"i64"}],"output":{"name":"u32"}}],[11,"shl","","",410,null],[11,"shl","","",410,null],[11,"shl","","",410,null],[11,"shl","","",410,{"inputs":[{"name":"u32"},{"name":"i32"}],"output":{"name":"u32"}}],[11,"shl","","",410,null],[11,"shl","","",410,null],[11,"shl","","",410,null],[11,"shl","","",410,{"inputs":[{"name":"u32"},{"name":"i16"}],"output":{"name":"u32"}}],[11,"shl","","",410,null],[11,"shl","","",410,null],[11,"shl","","",410,null],[11,"shl","","",410,{"inputs":[{"name":"u32"},{"name":"i8"}],"output":{"name":"u32"}}],[11,"shl","","",410,null],[11,"shl","","",410,null],[11,"shl","","",410,null],[11,"shl","","",410,{"inputs":[{"name":"u32"},{"name":"usize"}],"output":{"name":"u32"}}],[11,"shl","","",410,null],[11,"shl","","",410,null],[11,"shl","","",410,null],[11,"shl","","",410,{"inputs":[{"name":"u32"},{"name":"u64"}],"output":{"name":"u32"}}],[11,"shl","","",410,null],[11,"shl","","",410,null],[11,"shl","","",410,null],[11,"shl","","",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"shl","","",410,null],[11,"shl","","",410,null],[11,"shl","","",410,null],[11,"shl","","",410,{"inputs":[{"name":"u32"},{"name":"u16"}],"output":{"name":"u32"}}],[11,"shl","","",410,null],[11,"shl","","",410,null],[11,"shl","","",410,null],[11,"shl","","",410,{"inputs":[{"name":"u32"},{"name":"u8"}],"output":{"name":"u32"}}],[11,"shl","","",412,null],[11,"shl","","",412,null],[11,"shl","","",412,null],[11,"shl","","",412,{"inputs":[{"name":"u16"},{"name":"isize"}],"output":{"name":"u16"}}],[11,"shl","","",412,null],[11,"shl","","",412,null],[11,"shl","","",412,null],[11,"shl","","",412,{"inputs":[{"name":"u16"},{"name":"i64"}],"output":{"name":"u16"}}],[11,"shl","","",412,null],[11,"shl","","",412,null],[11,"shl","","",412,null],[11,"shl","","",412,{"inputs":[{"name":"u16"},{"name":"i32"}],"output":{"name":"u16"}}],[11,"shl","","",412,null],[11,"shl","","",412,null],[11,"shl","","",412,null],[11,"shl","","",412,{"inputs":[{"name":"u16"},{"name":"i16"}],"output":{"name":"u16"}}],[11,"shl","","",412,null],[11,"shl","","",412,null],[11,"shl","","",412,null],[11,"shl","","",412,{"inputs":[{"name":"u16"},{"name":"i8"}],"output":{"name":"u16"}}],[11,"shl","","",412,null],[11,"shl","","",412,null],[11,"shl","","",412,null],[11,"shl","","",412,{"inputs":[{"name":"u16"},{"name":"usize"}],"output":{"name":"u16"}}],[11,"shl","","",412,null],[11,"shl","","",412,null],[11,"shl","","",412,null],[11,"shl","","",412,{"inputs":[{"name":"u16"},{"name":"u64"}],"output":{"name":"u16"}}],[11,"shl","","",412,null],[11,"shl","","",412,null],[11,"shl","","",412,null],[11,"shl","","",412,{"inputs":[{"name":"u16"},{"name":"u32"}],"output":{"name":"u16"}}],[11,"shl","","",412,null],[11,"shl","","",412,null],[11,"shl","","",412,null],[11,"shl","","",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"shl","","",412,null],[11,"shl","","",412,null],[11,"shl","","",412,null],[11,"shl","","",412,{"inputs":[{"name":"u16"},{"name":"u8"}],"output":{"name":"u16"}}],[11,"shl","","",414,null],[11,"shl","","",414,null],[11,"shl","","",414,null],[11,"shl","","",414,{"inputs":[{"name":"u8"},{"name":"isize"}],"output":{"name":"u8"}}],[11,"shl","","",414,null],[11,"shl","","",414,null],[11,"shl","","",414,null],[11,"shl","","",414,{"inputs":[{"name":"u8"},{"name":"i64"}],"output":{"name":"u8"}}],[11,"shl","","",414,null],[11,"shl","","",414,null],[11,"shl","","",414,null],[11,"shl","","",414,{"inputs":[{"name":"u8"},{"name":"i32"}],"output":{"name":"u8"}}],[11,"shl","","",414,null],[11,"shl","","",414,null],[11,"shl","","",414,null],[11,"shl","","",414,{"inputs":[{"name":"u8"},{"name":"i16"}],"output":{"name":"u8"}}],[11,"shl","","",414,null],[11,"shl","","",414,null],[11,"shl","","",414,null],[11,"shl","","",414,{"inputs":[{"name":"u8"},{"name":"i8"}],"output":{"name":"u8"}}],[11,"shl","","",414,null],[11,"shl","","",414,null],[11,"shl","","",414,null],[11,"shl","","",414,{"inputs":[{"name":"u8"},{"name":"usize"}],"output":{"name":"u8"}}],[11,"shl","","",414,null],[11,"shl","","",414,null],[11,"shl","","",414,null],[11,"shl","","",414,{"inputs":[{"name":"u8"},{"name":"u64"}],"output":{"name":"u8"}}],[11,"shl","","",414,null],[11,"shl","","",414,null],[11,"shl","","",414,null],[11,"shl","","",414,{"inputs":[{"name":"u8"},{"name":"u32"}],"output":{"name":"u8"}}],[11,"shl","","",414,null],[11,"shl","","",414,null],[11,"shl","","",414,null],[11,"shl","","",414,{"inputs":[{"name":"u8"},{"name":"u16"}],"output":{"name":"u8"}}],[11,"shl","","",414,null],[11,"shl","","",414,null],[11,"shl","","",414,null],[11,"shl","","",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"bitxor","","",409,null],[11,"bitxor","","",409,null],[11,"bitxor","","",409,null],[11,"bitxor","","",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"bitxor","","",411,null],[11,"bitxor","","",411,null],[11,"bitxor","","",411,null],[11,"bitxor","","",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"bitxor","","",413,null],[11,"bitxor","","",413,null],[11,"bitxor","","",413,null],[11,"bitxor","","",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"bitxor","","",415,null],[11,"bitxor","","",415,null],[11,"bitxor","","",415,null],[11,"bitxor","","",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"bitxor","","",407,null],[11,"bitxor","","",407,null],[11,"bitxor","","",407,null],[11,"bitxor","","",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"bitxor","","",408,null],[11,"bitxor","","",408,null],[11,"bitxor","","",408,null],[11,"bitxor","","",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"bitxor","","",410,null],[11,"bitxor","","",410,null],[11,"bitxor","","",410,null],[11,"bitxor","","",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"bitxor","","",412,null],[11,"bitxor","","",412,null],[11,"bitxor","","",412,null],[11,"bitxor","","",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"bitxor","","",414,null],[11,"bitxor","","",414,null],[11,"bitxor","","",414,null],[11,"bitxor","","",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"bitxor","","",406,null],[11,"bitxor","","",406,null],[11,"bitxor","","",406,null],[11,"bitxor","","",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"bitxor","","",405,null],[11,"bitxor","","",405,null],[11,"bitxor","","",405,null],[11,"bitxor","","",405,{"inputs":[{"name":"bool"},{"name":"bool"}],"output":{"name":"bool"}}],[11,"bitor","","",409,null],[11,"bitor","","",409,null],[11,"bitor","","",409,null],[11,"bitor","","",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"bitor","","",411,null],[11,"bitor","","",411,null],[11,"bitor","","",411,null],[11,"bitor","","",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"bitor","","",413,null],[11,"bitor","","",413,null],[11,"bitor","","",413,null],[11,"bitor","","",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"bitor","","",415,null],[11,"bitor","","",415,null],[11,"bitor","","",415,null],[11,"bitor","","",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"bitor","","",407,null],[11,"bitor","","",407,null],[11,"bitor","","",407,null],[11,"bitor","","",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"bitor","","",408,null],[11,"bitor","","",408,null],[11,"bitor","","",408,null],[11,"bitor","","",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"bitor","","",410,null],[11,"bitor","","",410,null],[11,"bitor","","",410,null],[11,"bitor","","",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"bitor","","",412,null],[11,"bitor","","",412,null],[11,"bitor","","",412,null],[11,"bitor","","",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"bitor","","",414,null],[11,"bitor","","",414,null],[11,"bitor","","",414,null],[11,"bitor","","",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"bitor","","",406,null],[11,"bitor","","",406,null],[11,"bitor","","",406,null],[11,"bitor","","",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"bitor","","",405,null],[11,"bitor","","",405,null],[11,"bitor","","",405,null],[11,"bitor","","",405,{"inputs":[{"name":"bool"},{"name":"bool"}],"output":{"name":"bool"}}],[11,"bitand","","",409,null],[11,"bitand","","",409,null],[11,"bitand","","",409,null],[11,"bitand","","",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"bitand","","",411,null],[11,"bitand","","",411,null],[11,"bitand","","",411,null],[11,"bitand","","",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"bitand","","",413,null],[11,"bitand","","",413,null],[11,"bitand","","",413,null],[11,"bitand","","",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"bitand","","",415,null],[11,"bitand","","",415,null],[11,"bitand","","",415,null],[11,"bitand","","",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"bitand","","",407,null],[11,"bitand","","",407,null],[11,"bitand","","",407,null],[11,"bitand","","",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"bitand","","",408,null],[11,"bitand","","",408,null],[11,"bitand","","",408,null],[11,"bitand","","",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"bitand","","",410,null],[11,"bitand","","",410,null],[11,"bitand","","",410,null],[11,"bitand","","",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"bitand","","",412,null],[11,"bitand","","",412,null],[11,"bitand","","",412,null],[11,"bitand","","",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"bitand","","",414,null],[11,"bitand","","",414,null],[11,"bitand","","",414,null],[11,"bitand","","",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"bitand","","",406,null],[11,"bitand","","",406,null],[11,"bitand","","",406,null],[11,"bitand","","",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"bitand","","",405,null],[11,"bitand","","",405,null],[11,"bitand","","",405,null],[11,"bitand","","",405,{"inputs":[{"name":"bool"},{"name":"bool"}],"output":{"name":"bool"}}],[11,"not","","",409,null],[11,"not","","",409,{"inputs":[{"name":"i64"}],"output":{"name":"i64"}}],[11,"not","","",411,null],[11,"not","","",411,{"inputs":[{"name":"i32"}],"output":{"name":"i32"}}],[11,"not","","",413,null],[11,"not","","",413,{"inputs":[{"name":"i16"}],"output":{"name":"i16"}}],[11,"not","","",415,null],[11,"not","","",415,{"inputs":[{"name":"i8"}],"output":{"name":"i8"}}],[11,"not","","",407,null],[11,"not","","",407,{"inputs":[{"name":"isize"}],"output":{"name":"isize"}}],[11,"not","","",408,null],[11,"not","","",408,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[11,"not","","",410,null],[11,"not","","",410,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[11,"not","","",412,null],[11,"not","","",412,{"inputs":[{"name":"u16"}],"output":{"name":"u16"}}],[11,"not","","",414,null],[11,"not","","",414,{"inputs":[{"name":"u8"}],"output":{"name":"u8"}}],[11,"not","","",406,null],[11,"not","","",406,{"inputs":[{"name":"usize"}],"output":{"name":"usize"}}],[11,"not","","",405,null],[11,"not","","",405,{"inputs":[{"name":"bool"}],"output":{"name":"bool"}}],[11,"neg","","",401,null],[11,"neg","","",401,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[11,"neg","","",402,null],[11,"neg","","",402,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[11,"neg","","",409,null],[11,"neg","","",409,{"inputs":[{"name":"i64"}],"output":{"name":"i64"}}],[11,"neg","","",411,null],[11,"neg","","",411,{"inputs":[{"name":"i32"}],"output":{"name":"i32"}}],[11,"neg","","",413,null],[11,"neg","","",413,{"inputs":[{"name":"i16"}],"output":{"name":"i16"}}],[11,"neg","","",415,null],[11,"neg","","",415,{"inputs":[{"name":"i8"}],"output":{"name":"i8"}}],[11,"neg","","",407,null],[11,"neg","","",407,{"inputs":[{"name":"isize"}],"output":{"name":"isize"}}],[11,"rem","","",401,null],[11,"rem","","",401,null],[11,"rem","","",401,null],[11,"rem","","",401,{"inputs":[{"name":"f64"},{"name":"f64"}],"output":{"name":"f64"}}],[11,"rem","","",402,null],[11,"rem","","",402,null],[11,"rem","","",402,null],[11,"rem","","",402,{"inputs":[{"name":"f32"},{"name":"f32"}],"output":{"name":"f32"}}],[11,"rem","","",409,null],[11,"rem","","",409,null],[11,"rem","","",409,null],[11,"rem","","",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"rem","","",411,null],[11,"rem","","",411,null],[11,"rem","","",411,null],[11,"rem","","",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"rem","","",413,null],[11,"rem","","",413,null],[11,"rem","","",413,null],[11,"rem","","",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"rem","","",415,null],[11,"rem","","",415,null],[11,"rem","","",415,null],[11,"rem","","",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"rem","","",407,null],[11,"rem","","",407,null],[11,"rem","","",407,null],[11,"rem","","",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"rem","","",408,null],[11,"rem","","",408,null],[11,"rem","","",408,null],[11,"rem","","",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"rem","","",410,null],[11,"rem","","",410,null],[11,"rem","","",410,null],[11,"rem","","",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"rem","","",412,null],[11,"rem","","",412,null],[11,"rem","","",412,null],[11,"rem","","",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"rem","","",414,null],[11,"rem","","",414,null],[11,"rem","","",414,null],[11,"rem","","",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"rem","","",406,null],[11,"rem","","",406,null],[11,"rem","","",406,null],[11,"rem","","",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"div","","",401,null],[11,"div","","",401,null],[11,"div","","",401,null],[11,"div","","",401,{"inputs":[{"name":"f64"},{"name":"f64"}],"output":{"name":"f64"}}],[11,"div","","",402,null],[11,"div","","",402,null],[11,"div","","",402,null],[11,"div","","",402,{"inputs":[{"name":"f32"},{"name":"f32"}],"output":{"name":"f32"}}],[11,"div","","",409,null],[11,"div","","",409,null],[11,"div","","",409,null],[11,"div","","",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"div","","",411,null],[11,"div","","",411,null],[11,"div","","",411,null],[11,"div","","",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"div","","",413,null],[11,"div","","",413,null],[11,"div","","",413,null],[11,"div","","",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"div","","",415,null],[11,"div","","",415,null],[11,"div","","",415,null],[11,"div","","",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"div","","",407,null],[11,"div","","",407,null],[11,"div","","",407,null],[11,"div","","",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"div","","",408,null],[11,"div","","",408,null],[11,"div","","",408,null],[11,"div","","",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"div","","",410,null],[11,"div","","",410,null],[11,"div","","",410,null],[11,"div","","",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"div","","",412,null],[11,"div","","",412,null],[11,"div","","",412,null],[11,"div","","",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"div","","",414,null],[11,"div","","",414,null],[11,"div","","",414,null],[11,"div","","",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"div","","",406,null],[11,"div","","",406,null],[11,"div","","",406,null],[11,"div","","",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"mul","","",401,null],[11,"mul","","",401,null],[11,"mul","","",401,null],[11,"mul","","",401,{"inputs":[{"name":"f64"},{"name":"f64"}],"output":{"name":"f64"}}],[11,"mul","","",402,null],[11,"mul","","",402,null],[11,"mul","","",402,null],[11,"mul","","",402,{"inputs":[{"name":"f32"},{"name":"f32"}],"output":{"name":"f32"}}],[11,"mul","","",409,null],[11,"mul","","",409,null],[11,"mul","","",409,null],[11,"mul","","",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"mul","","",411,null],[11,"mul","","",411,null],[11,"mul","","",411,null],[11,"mul","","",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"mul","","",413,null],[11,"mul","","",413,null],[11,"mul","","",413,null],[11,"mul","","",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"mul","","",415,null],[11,"mul","","",415,null],[11,"mul","","",415,null],[11,"mul","","",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"mul","","",407,null],[11,"mul","","",407,null],[11,"mul","","",407,null],[11,"mul","","",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"mul","","",408,null],[11,"mul","","",408,null],[11,"mul","","",408,null],[11,"mul","","",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"mul","","",410,null],[11,"mul","","",410,null],[11,"mul","","",410,null],[11,"mul","","",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"mul","","",412,null],[11,"mul","","",412,null],[11,"mul","","",412,null],[11,"mul","","",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"mul","","",414,null],[11,"mul","","",414,null],[11,"mul","","",414,null],[11,"mul","","",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"mul","","",406,null],[11,"mul","","",406,null],[11,"mul","","",406,null],[11,"mul","","",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"sub","","",401,null],[11,"sub","","",401,null],[11,"sub","","",401,null],[11,"sub","","",401,{"inputs":[{"name":"f64"},{"name":"f64"}],"output":{"name":"f64"}}],[11,"sub","","",402,null],[11,"sub","","",402,null],[11,"sub","","",402,null],[11,"sub","","",402,{"inputs":[{"name":"f32"},{"name":"f32"}],"output":{"name":"f32"}}],[11,"sub","","",409,null],[11,"sub","","",409,null],[11,"sub","","",409,null],[11,"sub","","",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"sub","","",411,null],[11,"sub","","",411,null],[11,"sub","","",411,null],[11,"sub","","",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"sub","","",413,null],[11,"sub","","",413,null],[11,"sub","","",413,null],[11,"sub","","",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"sub","","",415,null],[11,"sub","","",415,null],[11,"sub","","",415,null],[11,"sub","","",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"sub","","",407,null],[11,"sub","","",407,null],[11,"sub","","",407,null],[11,"sub","","",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"sub","","",408,null],[11,"sub","","",408,null],[11,"sub","","",408,null],[11,"sub","","",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"sub","","",410,null],[11,"sub","","",410,null],[11,"sub","","",410,null],[11,"sub","","",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"sub","","",412,null],[11,"sub","","",412,null],[11,"sub","","",412,null],[11,"sub","","",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"sub","","",414,null],[11,"sub","","",414,null],[11,"sub","","",414,null],[11,"sub","","",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"sub","","",406,null],[11,"sub","","",406,null],[11,"sub","","",406,null],[11,"sub","","",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"add","","",401,null],[11,"add","","",401,null],[11,"add","","",401,null],[11,"add","","",401,{"inputs":[{"name":"f64"},{"name":"f64"}],"output":{"name":"f64"}}],[11,"add","","",402,null],[11,"add","","",402,null],[11,"add","","",402,null],[11,"add","","",402,{"inputs":[{"name":"f32"},{"name":"f32"}],"output":{"name":"f32"}}],[11,"add","","",409,null],[11,"add","","",409,null],[11,"add","","",409,null],[11,"add","","",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"add","","",411,null],[11,"add","","",411,null],[11,"add","","",411,null],[11,"add","","",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"add","","",413,null],[11,"add","","",413,null],[11,"add","","",413,null],[11,"add","","",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"add","","",415,null],[11,"add","","",415,null],[11,"add","","",415,null],[11,"add","","",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"add","","",407,null],[11,"add","","",407,null],[11,"add","","",407,null],[11,"add","","",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"add","","",408,null],[11,"add","","",408,null],[11,"add","","",408,null],[11,"add","","",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"add","","",410,null],[11,"add","","",410,null],[11,"add","","",410,null],[11,"add","","",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"add","","",412,null],[11,"add","","",412,null],[11,"add","","",412,null],[11,"add","","",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"add","","",414,null],[11,"add","","",414,null],[11,"add","","",414,null],[11,"add","","",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"add","","",406,null],[11,"add","","",406,null],[11,"add","","",406,null],[11,"add","","",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"partial_cmp","","",400,null],[11,"lt","","",400,null],[11,"le","","",400,null],[11,"gt","","",400,null],[11,"ge","","",400,null],[11,"cmp","","",400,null],[11,"partial_cmp","","",400,null],[11,"lt","","",400,null],[11,"le","","",400,null],[11,"gt","","",400,null],[11,"ge","","",400,null],[11,"cmp","","",400,null],[11,"clone","","",400,null],[11,"clone","","",400,null],[11,"eq","","",400,null],[11,"eq","","",400,null],[11,"is_null","","Returns true if the pointer is null.",400,{"inputs":[{"name":"pointer"}],"output":{"name":"bool"}}],[11,"as_ref","","Returns `None` if the pointer is null, or else returns a reference to\nthe value wrapped in `Some`.",400,{"inputs":[{"name":"pointer"}],"output":{"name":"option"}}],[11,"offset","","Calculates the offset from a pointer. `count` is in units of T; e.g. a\n`count` of 3 represents a pointer offset of `3 * sizeof::&lt;T&gt;()` bytes.",400,null],[11,"as_mut","","Returns `None` if the pointer is null, or else returns a mutable\nreference to the value wrapped in `Some`.",400,{"inputs":[{"name":"pointer"}],"output":{"name":"option"}}],[11,"is_null","","Returns true if the pointer is null.",400,{"inputs":[{"name":"pointer"}],"output":{"name":"bool"}}],[11,"as_ref","","Returns `None` if the pointer is null, or else returns a reference to\nthe value wrapped in `Some`.",400,{"inputs":[{"name":"pointer"}],"output":{"name":"option"}}],[11,"offset","","Calculates the offset from a pointer. `count` is in units of T; e.g. a\n`count` of 3 represents a pointer offset of `3 * sizeof::&lt;T&gt;()` bytes.",400,null],[11,"from","","",401,{"inputs":[{"name":"f32"}],"output":{"name":"f64"}}],[11,"from","","",401,{"inputs":[{"name":"u32"}],"output":{"name":"f64"}}],[11,"from","","",401,{"inputs":[{"name":"u16"}],"output":{"name":"f64"}}],[11,"from","","",402,{"inputs":[{"name":"u16"}],"output":{"name":"f32"}}],[11,"from","","",401,{"inputs":[{"name":"u8"}],"output":{"name":"f64"}}],[11,"from","","",402,{"inputs":[{"name":"u8"}],"output":{"name":"f32"}}],[11,"from","","",401,{"inputs":[{"name":"i32"}],"output":{"name":"f64"}}],[11,"from","","",401,{"inputs":[{"name":"i16"}],"output":{"name":"f64"}}],[11,"from","","",402,{"inputs":[{"name":"i16"}],"output":{"name":"f32"}}],[11,"from","","",401,{"inputs":[{"name":"i8"}],"output":{"name":"f64"}}],[11,"from","","",402,{"inputs":[{"name":"i8"}],"output":{"name":"f32"}}],[11,"from","","",409,{"inputs":[{"name":"u32"}],"output":{"name":"i64"}}],[11,"from","","",409,{"inputs":[{"name":"u16"}],"output":{"name":"i64"}}],[11,"from","","",411,{"inputs":[{"name":"u16"}],"output":{"name":"i32"}}],[11,"from","","",409,{"inputs":[{"name":"u8"}],"output":{"name":"i64"}}],[11,"from","","",411,{"inputs":[{"name":"u8"}],"output":{"name":"i32"}}],[11,"from","","",413,{"inputs":[{"name":"u8"}],"output":{"name":"i16"}}],[11,"from","","",409,{"inputs":[{"name":"i32"}],"output":{"name":"i64"}}],[11,"from","","",409,{"inputs":[{"name":"i16"}],"output":{"name":"i64"}}],[11,"from","","",411,{"inputs":[{"name":"i16"}],"output":{"name":"i32"}}],[11,"from","","",407,{"inputs":[{"name":"i8"}],"output":{"name":"isize"}}],[11,"from","","",409,{"inputs":[{"name":"i8"}],"output":{"name":"i64"}}],[11,"from","","",411,{"inputs":[{"name":"i8"}],"output":{"name":"i32"}}],[11,"from","","",413,{"inputs":[{"name":"i8"}],"output":{"name":"i16"}}],[11,"from","","",408,{"inputs":[{"name":"u32"}],"output":{"name":"u64"}}],[11,"from","","",408,{"inputs":[{"name":"u16"}],"output":{"name":"u64"}}],[11,"from","","",410,{"inputs":[{"name":"u16"}],"output":{"name":"u32"}}],[11,"from","","",406,{"inputs":[{"name":"u8"}],"output":{"name":"usize"}}],[11,"from","","",408,{"inputs":[{"name":"u8"}],"output":{"name":"u64"}}],[11,"from","","",410,{"inputs":[{"name":"u8"}],"output":{"name":"u32"}}],[11,"from","","",412,{"inputs":[{"name":"u8"}],"output":{"name":"u16"}}],[11,"from_str","","",408,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",410,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",412,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",414,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",406,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",409,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",411,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",413,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",415,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",407,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",406,{"inputs":[],"output":{"name":"usize"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",406,{"inputs":[],"output":{"name":"usize"}}],[11,"from_str_radix","","Converts a string slice in a given base to an integer.",406,{"inputs":[{"name":"str"},{"name":"u32"}],"output":{"name":"result"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",406,{"inputs":[{"name":"usize"}],"output":{"name":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",406,{"inputs":[{"name":"usize"}],"output":{"name":"u32"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation\nof `self`.",406,{"inputs":[{"name":"usize"}],"output":{"name":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation\nof `self`.",406,{"inputs":[{"name":"usize"}],"output":{"name":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,\nwrapping the truncated bits to the end of the resulting integer.",406,{"inputs":[{"name":"usize"},{"name":"u32"}],"output":{"name":"usize"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,\nwrapping the truncated bits to the beginning of the resulting\ninteger.",406,{"inputs":[{"name":"usize"},{"name":"u32"}],"output":{"name":"usize"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",406,{"inputs":[{"name":"usize"}],"output":{"name":"usize"}}],[11,"from_be","","Converts an integer from big endian to the target&#39;s endianness.",406,{"inputs":[{"name":"usize"}],"output":{"name":"usize"}}],[11,"from_le","","Converts an integer from little endian to the target&#39;s endianness.",406,{"inputs":[{"name":"usize"}],"output":{"name":"usize"}}],[11,"to_be","","Converts `self` to big endian from the target&#39;s endianness.",406,{"inputs":[{"name":"usize"}],"output":{"name":"usize"}}],[11,"to_le","","Converts `self` to little endian from the target&#39;s endianness.",406,{"inputs":[{"name":"usize"}],"output":{"name":"usize"}}],[11,"checked_add","","Checked integer addition. Computes `self + other`, returning `None`\nif overflow occurred.",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"option"}}],[11,"checked_sub","","Checked integer subtraction. Computes `self - other`, returning\n`None` if underflow occurred.",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"option"}}],[11,"checked_mul","","Checked integer multiplication. Computes `self * other`, returning\n`None` if underflow or overflow occurred.",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"option"}}],[11,"checked_div","","Checked integer division. Computes `self / other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"option"}}],[11,"checked_rem","","Checked integer remainder. Computes `self % other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"option"}}],[11,"checked_neg","","Checked negation. Computes `-self`, returning `None` unless `self ==\n0`.",406,{"inputs":[{"name":"usize"}],"output":{"name":"option"}}],[11,"checked_shl","","Checked shift left. Computes `self &lt;&lt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",406,{"inputs":[{"name":"usize"},{"name":"u32"}],"output":{"name":"option"}}],[11,"checked_shr","","Checked shift right. Computes `self &gt;&gt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",406,{"inputs":[{"name":"usize"},{"name":"u32"}],"output":{"name":"option"}}],[11,"saturating_add","","Saturating integer addition. Computes `self + other`, saturating at\nthe numeric bounds instead of overflowing.",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"saturating_sub","","Saturating integer subtraction. Computes `self - other`, saturating\nat the numeric bounds instead of overflowing.",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"saturating_mul","","Saturating integer multiplication. Computes `self * other`,\nsaturating at the numeric bounds instead of overflowing.",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"wrapping_add","","Wrapping (modular) addition. Computes `self + other`,\nwrapping around at the boundary of the type.",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"wrapping_sub","","Wrapping (modular) subtraction. Computes `self - other`,\nwrapping around at the boundary of the type.",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"wrapping_mul","","Wrapping (modular) multiplication. Computes `self *\nother`, wrapping around at the boundary of the type.",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"wrapping_div","","Wrapping (modular) division. Computes `self / other`.\nWrapped division on unsigned types is just normal division.\nThere&#39;s no way wrapping could ever happen.\nThis function exists, so that all operations\nare accounted for in the wrapping operations.",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"wrapping_rem","","Wrapping (modular) remainder. Computes `self % other`.\nWrapped remainder calculation on unsigned types is\njust the regular remainder calculation.\nThere&#39;s no way wrapping could ever happen.\nThis function exists, so that all operations\nare accounted for in the wrapping operations.",406,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"wrapping_neg","","Wrapping (modular) negation. Computes `-self`,\nwrapping around at the boundary of the type.",406,{"inputs":[{"name":"usize"}],"output":{"name":"usize"}}],[11,"wrapping_shl","","Panic-free bitwise shift-left; yields `self &lt;&lt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",406,{"inputs":[{"name":"usize"},{"name":"u32"}],"output":{"name":"usize"}}],[11,"wrapping_shr","","Panic-free bitwise shift-right; yields `self &gt;&gt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",406,{"inputs":[{"name":"usize"},{"name":"u32"}],"output":{"name":"usize"}}],[11,"overflowing_add","","Calculates `self` + `rhs`",406,null],[11,"overflowing_sub","","Calculates `self` - `rhs`",406,null],[11,"overflowing_mul","","Calculates the multiplication of `self` and `rhs`.",406,null],[11,"overflowing_div","","Calculates the divisor when `self` is divided by `rhs`.",406,null],[11,"overflowing_rem","","Calculates the remainder when `self` is divided by `rhs`.",406,null],[11,"overflowing_neg","","Negates self in an overflowing fashion.",406,null],[11,"overflowing_shl","","Shifts self left by `rhs` bits.",406,null],[11,"overflowing_shr","","Shifts self right by `rhs` bits.",406,null],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",406,{"inputs":[{"name":"usize"},{"name":"u32"}],"output":{"name":"usize"}}],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",406,{"inputs":[{"name":"usize"}],"output":{"name":"bool"}}],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.\nUnspecified behavior on overflow.",406,{"inputs":[{"name":"usize"}],"output":{"name":"usize"}}],[11,"checked_next_power_of_two","","Returns the smallest power of two greater than or equal to `n`. If\nthe next power of two is greater than the type&#39;s maximum value,\n`None` is returned, otherwise the power of two is wrapped in `Some`.",406,{"inputs":[{"name":"usize"}],"output":{"name":"option"}}],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",408,{"inputs":[],"output":{"name":"u64"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",408,{"inputs":[],"output":{"name":"u64"}}],[11,"from_str_radix","","Converts a string slice in a given base to an integer.",408,{"inputs":[{"name":"str"},{"name":"u32"}],"output":{"name":"result"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",408,{"inputs":[{"name":"u64"}],"output":{"name":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",408,{"inputs":[{"name":"u64"}],"output":{"name":"u32"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation\nof `self`.",408,{"inputs":[{"name":"u64"}],"output":{"name":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation\nof `self`.",408,{"inputs":[{"name":"u64"}],"output":{"name":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,\nwrapping the truncated bits to the end of the resulting integer.",408,{"inputs":[{"name":"u64"},{"name":"u32"}],"output":{"name":"u64"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,\nwrapping the truncated bits to the beginning of the resulting\ninteger.",408,{"inputs":[{"name":"u64"},{"name":"u32"}],"output":{"name":"u64"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",408,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[11,"from_be","","Converts an integer from big endian to the target&#39;s endianness.",408,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[11,"from_le","","Converts an integer from little endian to the target&#39;s endianness.",408,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[11,"to_be","","Converts `self` to big endian from the target&#39;s endianness.",408,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[11,"to_le","","Converts `self` to little endian from the target&#39;s endianness.",408,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[11,"checked_add","","Checked integer addition. Computes `self + other`, returning `None`\nif overflow occurred.",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"option"}}],[11,"checked_sub","","Checked integer subtraction. Computes `self - other`, returning\n`None` if underflow occurred.",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"option"}}],[11,"checked_mul","","Checked integer multiplication. Computes `self * other`, returning\n`None` if underflow or overflow occurred.",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"option"}}],[11,"checked_div","","Checked integer division. Computes `self / other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"option"}}],[11,"checked_rem","","Checked integer remainder. Computes `self % other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"option"}}],[11,"checked_neg","","Checked negation. Computes `-self`, returning `None` unless `self ==\n0`.",408,{"inputs":[{"name":"u64"}],"output":{"name":"option"}}],[11,"checked_shl","","Checked shift left. Computes `self &lt;&lt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",408,{"inputs":[{"name":"u64"},{"name":"u32"}],"output":{"name":"option"}}],[11,"checked_shr","","Checked shift right. Computes `self &gt;&gt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",408,{"inputs":[{"name":"u64"},{"name":"u32"}],"output":{"name":"option"}}],[11,"saturating_add","","Saturating integer addition. Computes `self + other`, saturating at\nthe numeric bounds instead of overflowing.",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"saturating_sub","","Saturating integer subtraction. Computes `self - other`, saturating\nat the numeric bounds instead of overflowing.",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"saturating_mul","","Saturating integer multiplication. Computes `self * other`,\nsaturating at the numeric bounds instead of overflowing.",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"wrapping_add","","Wrapping (modular) addition. Computes `self + other`,\nwrapping around at the boundary of the type.",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"wrapping_sub","","Wrapping (modular) subtraction. Computes `self - other`,\nwrapping around at the boundary of the type.",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"wrapping_mul","","Wrapping (modular) multiplication. Computes `self *\nother`, wrapping around at the boundary of the type.",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"wrapping_div","","Wrapping (modular) division. Computes `self / other`.\nWrapped division on unsigned types is just normal division.\nThere&#39;s no way wrapping could ever happen.\nThis function exists, so that all operations\nare accounted for in the wrapping operations.",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"wrapping_rem","","Wrapping (modular) remainder. Computes `self % other`.\nWrapped remainder calculation on unsigned types is\njust the regular remainder calculation.\nThere&#39;s no way wrapping could ever happen.\nThis function exists, so that all operations\nare accounted for in the wrapping operations.",408,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"wrapping_neg","","Wrapping (modular) negation. Computes `-self`,\nwrapping around at the boundary of the type.",408,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[11,"wrapping_shl","","Panic-free bitwise shift-left; yields `self &lt;&lt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",408,{"inputs":[{"name":"u64"},{"name":"u32"}],"output":{"name":"u64"}}],[11,"wrapping_shr","","Panic-free bitwise shift-right; yields `self &gt;&gt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",408,{"inputs":[{"name":"u64"},{"name":"u32"}],"output":{"name":"u64"}}],[11,"overflowing_add","","Calculates `self` + `rhs`",408,null],[11,"overflowing_sub","","Calculates `self` - `rhs`",408,null],[11,"overflowing_mul","","Calculates the multiplication of `self` and `rhs`.",408,null],[11,"overflowing_div","","Calculates the divisor when `self` is divided by `rhs`.",408,null],[11,"overflowing_rem","","Calculates the remainder when `self` is divided by `rhs`.",408,null],[11,"overflowing_neg","","Negates self in an overflowing fashion.",408,null],[11,"overflowing_shl","","Shifts self left by `rhs` bits.",408,null],[11,"overflowing_shr","","Shifts self right by `rhs` bits.",408,null],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",408,{"inputs":[{"name":"u64"},{"name":"u32"}],"output":{"name":"u64"}}],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",408,{"inputs":[{"name":"u64"}],"output":{"name":"bool"}}],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.\nUnspecified behavior on overflow.",408,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[11,"checked_next_power_of_two","","Returns the smallest power of two greater than or equal to `n`. If\nthe next power of two is greater than the type&#39;s maximum value,\n`None` is returned, otherwise the power of two is wrapped in `Some`.",408,{"inputs":[{"name":"u64"}],"output":{"name":"option"}}],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",410,{"inputs":[],"output":{"name":"u32"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",410,{"inputs":[],"output":{"name":"u32"}}],[11,"from_str_radix","","Converts a string slice in a given base to an integer.",410,{"inputs":[{"name":"str"},{"name":"u32"}],"output":{"name":"result"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",410,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",410,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation\nof `self`.",410,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation\nof `self`.",410,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,\nwrapping the truncated bits to the end of the resulting integer.",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,\nwrapping the truncated bits to the beginning of the resulting\ninteger.",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",410,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[11,"from_be","","Converts an integer from big endian to the target&#39;s endianness.",410,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[11,"from_le","","Converts an integer from little endian to the target&#39;s endianness.",410,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[11,"to_be","","Converts `self` to big endian from the target&#39;s endianness.",410,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[11,"to_le","","Converts `self` to little endian from the target&#39;s endianness.",410,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[11,"checked_add","","Checked integer addition. Computes `self + other`, returning `None`\nif overflow occurred.",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"option"}}],[11,"checked_sub","","Checked integer subtraction. Computes `self - other`, returning\n`None` if underflow occurred.",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"option"}}],[11,"checked_mul","","Checked integer multiplication. Computes `self * other`, returning\n`None` if underflow or overflow occurred.",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"option"}}],[11,"checked_div","","Checked integer division. Computes `self / other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"option"}}],[11,"checked_rem","","Checked integer remainder. Computes `self % other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"option"}}],[11,"checked_neg","","Checked negation. Computes `-self`, returning `None` unless `self ==\n0`.",410,{"inputs":[{"name":"u32"}],"output":{"name":"option"}}],[11,"checked_shl","","Checked shift left. Computes `self &lt;&lt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"option"}}],[11,"checked_shr","","Checked shift right. Computes `self &gt;&gt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"option"}}],[11,"saturating_add","","Saturating integer addition. Computes `self + other`, saturating at\nthe numeric bounds instead of overflowing.",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"saturating_sub","","Saturating integer subtraction. Computes `self - other`, saturating\nat the numeric bounds instead of overflowing.",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"saturating_mul","","Saturating integer multiplication. Computes `self * other`,\nsaturating at the numeric bounds instead of overflowing.",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"wrapping_add","","Wrapping (modular) addition. Computes `self + other`,\nwrapping around at the boundary of the type.",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"wrapping_sub","","Wrapping (modular) subtraction. Computes `self - other`,\nwrapping around at the boundary of the type.",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"wrapping_mul","","Wrapping (modular) multiplication. Computes `self *\nother`, wrapping around at the boundary of the type.",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"wrapping_div","","Wrapping (modular) division. Computes `self / other`.\nWrapped division on unsigned types is just normal division.\nThere&#39;s no way wrapping could ever happen.\nThis function exists, so that all operations\nare accounted for in the wrapping operations.",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"wrapping_rem","","Wrapping (modular) remainder. Computes `self % other`.\nWrapped remainder calculation on unsigned types is\njust the regular remainder calculation.\nThere&#39;s no way wrapping could ever happen.\nThis function exists, so that all operations\nare accounted for in the wrapping operations.",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"wrapping_neg","","Wrapping (modular) negation. Computes `-self`,\nwrapping around at the boundary of the type.",410,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[11,"wrapping_shl","","Panic-free bitwise shift-left; yields `self &lt;&lt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"wrapping_shr","","Panic-free bitwise shift-right; yields `self &gt;&gt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"overflowing_add","","Calculates `self` + `rhs`",410,null],[11,"overflowing_sub","","Calculates `self` - `rhs`",410,null],[11,"overflowing_mul","","Calculates the multiplication of `self` and `rhs`.",410,null],[11,"overflowing_div","","Calculates the divisor when `self` is divided by `rhs`.",410,null],[11,"overflowing_rem","","Calculates the remainder when `self` is divided by `rhs`.",410,null],[11,"overflowing_neg","","Negates self in an overflowing fashion.",410,null],[11,"overflowing_shl","","Shifts self left by `rhs` bits.",410,null],[11,"overflowing_shr","","Shifts self right by `rhs` bits.",410,null],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",410,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",410,{"inputs":[{"name":"u32"}],"output":{"name":"bool"}}],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.\nUnspecified behavior on overflow.",410,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[11,"checked_next_power_of_two","","Returns the smallest power of two greater than or equal to `n`. If\nthe next power of two is greater than the type&#39;s maximum value,\n`None` is returned, otherwise the power of two is wrapped in `Some`.",410,{"inputs":[{"name":"u32"}],"output":{"name":"option"}}],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",412,{"inputs":[],"output":{"name":"u16"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",412,{"inputs":[],"output":{"name":"u16"}}],[11,"from_str_radix","","Converts a string slice in a given base to an integer.",412,{"inputs":[{"name":"str"},{"name":"u32"}],"output":{"name":"result"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",412,{"inputs":[{"name":"u16"}],"output":{"name":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",412,{"inputs":[{"name":"u16"}],"output":{"name":"u32"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation\nof `self`.",412,{"inputs":[{"name":"u16"}],"output":{"name":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation\nof `self`.",412,{"inputs":[{"name":"u16"}],"output":{"name":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,\nwrapping the truncated bits to the end of the resulting integer.",412,{"inputs":[{"name":"u16"},{"name":"u32"}],"output":{"name":"u16"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,\nwrapping the truncated bits to the beginning of the resulting\ninteger.",412,{"inputs":[{"name":"u16"},{"name":"u32"}],"output":{"name":"u16"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",412,{"inputs":[{"name":"u16"}],"output":{"name":"u16"}}],[11,"from_be","","Converts an integer from big endian to the target&#39;s endianness.",412,{"inputs":[{"name":"u16"}],"output":{"name":"u16"}}],[11,"from_le","","Converts an integer from little endian to the target&#39;s endianness.",412,{"inputs":[{"name":"u16"}],"output":{"name":"u16"}}],[11,"to_be","","Converts `self` to big endian from the target&#39;s endianness.",412,{"inputs":[{"name":"u16"}],"output":{"name":"u16"}}],[11,"to_le","","Converts `self` to little endian from the target&#39;s endianness.",412,{"inputs":[{"name":"u16"}],"output":{"name":"u16"}}],[11,"checked_add","","Checked integer addition. Computes `self + other`, returning `None`\nif overflow occurred.",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"option"}}],[11,"checked_sub","","Checked integer subtraction. Computes `self - other`, returning\n`None` if underflow occurred.",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"option"}}],[11,"checked_mul","","Checked integer multiplication. Computes `self * other`, returning\n`None` if underflow or overflow occurred.",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"option"}}],[11,"checked_div","","Checked integer division. Computes `self / other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"option"}}],[11,"checked_rem","","Checked integer remainder. Computes `self % other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"option"}}],[11,"checked_neg","","Checked negation. Computes `-self`, returning `None` unless `self ==\n0`.",412,{"inputs":[{"name":"u16"}],"output":{"name":"option"}}],[11,"checked_shl","","Checked shift left. Computes `self &lt;&lt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",412,{"inputs":[{"name":"u16"},{"name":"u32"}],"output":{"name":"option"}}],[11,"checked_shr","","Checked shift right. Computes `self &gt;&gt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",412,{"inputs":[{"name":"u16"},{"name":"u32"}],"output":{"name":"option"}}],[11,"saturating_add","","Saturating integer addition. Computes `self + other`, saturating at\nthe numeric bounds instead of overflowing.",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"saturating_sub","","Saturating integer subtraction. Computes `self - other`, saturating\nat the numeric bounds instead of overflowing.",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"saturating_mul","","Saturating integer multiplication. Computes `self * other`,\nsaturating at the numeric bounds instead of overflowing.",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"wrapping_add","","Wrapping (modular) addition. Computes `self + other`,\nwrapping around at the boundary of the type.",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"wrapping_sub","","Wrapping (modular) subtraction. Computes `self - other`,\nwrapping around at the boundary of the type.",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"wrapping_mul","","Wrapping (modular) multiplication. Computes `self *\nother`, wrapping around at the boundary of the type.",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"wrapping_div","","Wrapping (modular) division. Computes `self / other`.\nWrapped division on unsigned types is just normal division.\nThere&#39;s no way wrapping could ever happen.\nThis function exists, so that all operations\nare accounted for in the wrapping operations.",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"wrapping_rem","","Wrapping (modular) remainder. Computes `self % other`.\nWrapped remainder calculation on unsigned types is\njust the regular remainder calculation.\nThere&#39;s no way wrapping could ever happen.\nThis function exists, so that all operations\nare accounted for in the wrapping operations.",412,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"wrapping_neg","","Wrapping (modular) negation. Computes `-self`,\nwrapping around at the boundary of the type.",412,{"inputs":[{"name":"u16"}],"output":{"name":"u16"}}],[11,"wrapping_shl","","Panic-free bitwise shift-left; yields `self &lt;&lt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",412,{"inputs":[{"name":"u16"},{"name":"u32"}],"output":{"name":"u16"}}],[11,"wrapping_shr","","Panic-free bitwise shift-right; yields `self &gt;&gt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",412,{"inputs":[{"name":"u16"},{"name":"u32"}],"output":{"name":"u16"}}],[11,"overflowing_add","","Calculates `self` + `rhs`",412,null],[11,"overflowing_sub","","Calculates `self` - `rhs`",412,null],[11,"overflowing_mul","","Calculates the multiplication of `self` and `rhs`.",412,null],[11,"overflowing_div","","Calculates the divisor when `self` is divided by `rhs`.",412,null],[11,"overflowing_rem","","Calculates the remainder when `self` is divided by `rhs`.",412,null],[11,"overflowing_neg","","Negates self in an overflowing fashion.",412,null],[11,"overflowing_shl","","Shifts self left by `rhs` bits.",412,null],[11,"overflowing_shr","","Shifts self right by `rhs` bits.",412,null],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",412,{"inputs":[{"name":"u16"},{"name":"u32"}],"output":{"name":"u16"}}],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",412,{"inputs":[{"name":"u16"}],"output":{"name":"bool"}}],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.\nUnspecified behavior on overflow.",412,{"inputs":[{"name":"u16"}],"output":{"name":"u16"}}],[11,"checked_next_power_of_two","","Returns the smallest power of two greater than or equal to `n`. If\nthe next power of two is greater than the type&#39;s maximum value,\n`None` is returned, otherwise the power of two is wrapped in `Some`.",412,{"inputs":[{"name":"u16"}],"output":{"name":"option"}}],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",414,{"inputs":[],"output":{"name":"u8"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",414,{"inputs":[],"output":{"name":"u8"}}],[11,"from_str_radix","","Converts a string slice in a given base to an integer.",414,{"inputs":[{"name":"str"},{"name":"u32"}],"output":{"name":"result"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",414,{"inputs":[{"name":"u8"}],"output":{"name":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",414,{"inputs":[{"name":"u8"}],"output":{"name":"u32"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation\nof `self`.",414,{"inputs":[{"name":"u8"}],"output":{"name":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation\nof `self`.",414,{"inputs":[{"name":"u8"}],"output":{"name":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,\nwrapping the truncated bits to the end of the resulting integer.",414,{"inputs":[{"name":"u8"},{"name":"u32"}],"output":{"name":"u8"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,\nwrapping the truncated bits to the beginning of the resulting\ninteger.",414,{"inputs":[{"name":"u8"},{"name":"u32"}],"output":{"name":"u8"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",414,{"inputs":[{"name":"u8"}],"output":{"name":"u8"}}],[11,"from_be","","Converts an integer from big endian to the target&#39;s endianness.",414,{"inputs":[{"name":"u8"}],"output":{"name":"u8"}}],[11,"from_le","","Converts an integer from little endian to the target&#39;s endianness.",414,{"inputs":[{"name":"u8"}],"output":{"name":"u8"}}],[11,"to_be","","Converts `self` to big endian from the target&#39;s endianness.",414,{"inputs":[{"name":"u8"}],"output":{"name":"u8"}}],[11,"to_le","","Converts `self` to little endian from the target&#39;s endianness.",414,{"inputs":[{"name":"u8"}],"output":{"name":"u8"}}],[11,"checked_add","","Checked integer addition. Computes `self + other`, returning `None`\nif overflow occurred.",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"option"}}],[11,"checked_sub","","Checked integer subtraction. Computes `self - other`, returning\n`None` if underflow occurred.",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"option"}}],[11,"checked_mul","","Checked integer multiplication. Computes `self * other`, returning\n`None` if underflow or overflow occurred.",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"option"}}],[11,"checked_div","","Checked integer division. Computes `self / other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"option"}}],[11,"checked_rem","","Checked integer remainder. Computes `self % other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"option"}}],[11,"checked_neg","","Checked negation. Computes `-self`, returning `None` unless `self ==\n0`.",414,{"inputs":[{"name":"u8"}],"output":{"name":"option"}}],[11,"checked_shl","","Checked shift left. Computes `self &lt;&lt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",414,{"inputs":[{"name":"u8"},{"name":"u32"}],"output":{"name":"option"}}],[11,"checked_shr","","Checked shift right. Computes `self &gt;&gt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",414,{"inputs":[{"name":"u8"},{"name":"u32"}],"output":{"name":"option"}}],[11,"saturating_add","","Saturating integer addition. Computes `self + other`, saturating at\nthe numeric bounds instead of overflowing.",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"saturating_sub","","Saturating integer subtraction. Computes `self - other`, saturating\nat the numeric bounds instead of overflowing.",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"saturating_mul","","Saturating integer multiplication. Computes `self * other`,\nsaturating at the numeric bounds instead of overflowing.",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"wrapping_add","","Wrapping (modular) addition. Computes `self + other`,\nwrapping around at the boundary of the type.",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"wrapping_sub","","Wrapping (modular) subtraction. Computes `self - other`,\nwrapping around at the boundary of the type.",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"wrapping_mul","","Wrapping (modular) multiplication. Computes `self *\nother`, wrapping around at the boundary of the type.",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"wrapping_div","","Wrapping (modular) division. Computes `self / other`.\nWrapped division on unsigned types is just normal division.\nThere&#39;s no way wrapping could ever happen.\nThis function exists, so that all operations\nare accounted for in the wrapping operations.",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"wrapping_rem","","Wrapping (modular) remainder. Computes `self % other`.\nWrapped remainder calculation on unsigned types is\njust the regular remainder calculation.\nThere&#39;s no way wrapping could ever happen.\nThis function exists, so that all operations\nare accounted for in the wrapping operations.",414,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"wrapping_neg","","Wrapping (modular) negation. Computes `-self`,\nwrapping around at the boundary of the type.",414,{"inputs":[{"name":"u8"}],"output":{"name":"u8"}}],[11,"wrapping_shl","","Panic-free bitwise shift-left; yields `self &lt;&lt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",414,{"inputs":[{"name":"u8"},{"name":"u32"}],"output":{"name":"u8"}}],[11,"wrapping_shr","","Panic-free bitwise shift-right; yields `self &gt;&gt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",414,{"inputs":[{"name":"u8"},{"name":"u32"}],"output":{"name":"u8"}}],[11,"overflowing_add","","Calculates `self` + `rhs`",414,null],[11,"overflowing_sub","","Calculates `self` - `rhs`",414,null],[11,"overflowing_mul","","Calculates the multiplication of `self` and `rhs`.",414,null],[11,"overflowing_div","","Calculates the divisor when `self` is divided by `rhs`.",414,null],[11,"overflowing_rem","","Calculates the remainder when `self` is divided by `rhs`.",414,null],[11,"overflowing_neg","","Negates self in an overflowing fashion.",414,null],[11,"overflowing_shl","","Shifts self left by `rhs` bits.",414,null],[11,"overflowing_shr","","Shifts self right by `rhs` bits.",414,null],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",414,{"inputs":[{"name":"u8"},{"name":"u32"}],"output":{"name":"u8"}}],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",414,{"inputs":[{"name":"u8"}],"output":{"name":"bool"}}],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.\nUnspecified behavior on overflow.",414,{"inputs":[{"name":"u8"}],"output":{"name":"u8"}}],[11,"checked_next_power_of_two","","Returns the smallest power of two greater than or equal to `n`. If\nthe next power of two is greater than the type&#39;s maximum value,\n`None` is returned, otherwise the power of two is wrapped in `Some`.",414,{"inputs":[{"name":"u8"}],"output":{"name":"option"}}],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",407,{"inputs":[],"output":{"name":"isize"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",407,{"inputs":[],"output":{"name":"isize"}}],[11,"from_str_radix","","Converts a string slice in a given base to an integer.",407,{"inputs":[{"name":"str"},{"name":"u32"}],"output":{"name":"result"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",407,{"inputs":[{"name":"isize"}],"output":{"name":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",407,{"inputs":[{"name":"isize"}],"output":{"name":"u32"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation\nof `self`.",407,{"inputs":[{"name":"isize"}],"output":{"name":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation\nof `self`.",407,{"inputs":[{"name":"isize"}],"output":{"name":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,\nwrapping the truncated bits to the end of the resulting integer.",407,{"inputs":[{"name":"isize"},{"name":"u32"}],"output":{"name":"isize"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,\nwrapping the truncated bits to the beginning of the resulting\ninteger.",407,{"inputs":[{"name":"isize"},{"name":"u32"}],"output":{"name":"isize"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",407,{"inputs":[{"name":"isize"}],"output":{"name":"isize"}}],[11,"from_be","","Converts an integer from big endian to the target&#39;s endianness.",407,{"inputs":[{"name":"isize"}],"output":{"name":"isize"}}],[11,"from_le","","Converts an integer from little endian to the target&#39;s endianness.",407,{"inputs":[{"name":"isize"}],"output":{"name":"isize"}}],[11,"to_be","","Converts `self` to big endian from the target&#39;s endianness.",407,{"inputs":[{"name":"isize"}],"output":{"name":"isize"}}],[11,"to_le","","Converts `self` to little endian from the target&#39;s endianness.",407,{"inputs":[{"name":"isize"}],"output":{"name":"isize"}}],[11,"checked_add","","Checked integer addition. Computes `self + other`, returning `None`\nif overflow occurred.",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"option"}}],[11,"checked_sub","","Checked integer subtraction. Computes `self - other`, returning\n`None` if underflow occurred.",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"option"}}],[11,"checked_mul","","Checked integer multiplication. Computes `self * other`, returning\n`None` if underflow or overflow occurred.",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"option"}}],[11,"checked_div","","Checked integer division. Computes `self / other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"option"}}],[11,"checked_rem","","Checked integer remainder. Computes `self % other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"option"}}],[11,"checked_neg","","Checked negation. Computes `-self`, returning `None` if `self ==\nMIN`.",407,{"inputs":[{"name":"isize"}],"output":{"name":"option"}}],[11,"checked_shl","","Checked shift left. Computes `self &lt;&lt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",407,{"inputs":[{"name":"isize"},{"name":"u32"}],"output":{"name":"option"}}],[11,"checked_shr","","Checked shift right. Computes `self &gt;&gt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",407,{"inputs":[{"name":"isize"},{"name":"u32"}],"output":{"name":"option"}}],[11,"saturating_add","","Saturating integer addition. Computes `self + other`, saturating at\nthe numeric bounds instead of overflowing.",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"saturating_sub","","Saturating integer subtraction. Computes `self - other`, saturating\nat the numeric bounds instead of overflowing.",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"saturating_mul","","Saturating integer multiplication. Computes `self * other`,\nsaturating at the numeric bounds instead of overflowing.",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"wrapping_add","","Wrapping (modular) addition. Computes `self + other`,\nwrapping around at the boundary of the type.",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"wrapping_sub","","Wrapping (modular) subtraction. Computes `self - other`,\nwrapping around at the boundary of the type.",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"wrapping_mul","","Wrapping (modular) multiplication. Computes `self *\nother`, wrapping around at the boundary of the type.",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"wrapping_div","","Wrapping (modular) division. Computes `self / other`,\nwrapping around at the boundary of the type.",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"wrapping_rem","","Wrapping (modular) remainder. Computes `self % other`,\nwrapping around at the boundary of the type.",407,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"wrapping_neg","","Wrapping (modular) negation. Computes `-self`,\nwrapping around at the boundary of the type.",407,{"inputs":[{"name":"isize"}],"output":{"name":"isize"}}],[11,"wrapping_shl","","Panic-free bitwise shift-left; yields `self &lt;&lt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",407,{"inputs":[{"name":"isize"},{"name":"u32"}],"output":{"name":"isize"}}],[11,"wrapping_shr","","Panic-free bitwise shift-right; yields `self &gt;&gt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",407,{"inputs":[{"name":"isize"},{"name":"u32"}],"output":{"name":"isize"}}],[11,"overflowing_add","","Calculates `self` + `rhs`",407,null],[11,"overflowing_sub","","Calculates `self` - `rhs`",407,null],[11,"overflowing_mul","","Calculates the multiplication of `self` and `rhs`.",407,null],[11,"overflowing_div","","Calculates the divisor when `self` is divided by `rhs`.",407,null],[11,"overflowing_rem","","Calculates the remainder when `self` is divided by `rhs`.",407,null],[11,"overflowing_neg","","Negates self, overflowing if this is equal to the minimum value.",407,null],[11,"overflowing_shl","","Shifts self left by `rhs` bits.",407,null],[11,"overflowing_shr","","Shifts self right by `rhs` bits.",407,null],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",407,{"inputs":[{"name":"isize"},{"name":"u32"}],"output":{"name":"isize"}}],[11,"abs","","Computes the absolute value of `self`.",407,{"inputs":[{"name":"isize"}],"output":{"name":"isize"}}],[11,"signum","","Returns a number representing sign of `self`.",407,{"inputs":[{"name":"isize"}],"output":{"name":"isize"}}],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number\nis zero or negative.",407,{"inputs":[{"name":"isize"}],"output":{"name":"bool"}}],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number\nis zero or positive.",407,{"inputs":[{"name":"isize"}],"output":{"name":"bool"}}],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",409,{"inputs":[],"output":{"name":"i64"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",409,{"inputs":[],"output":{"name":"i64"}}],[11,"from_str_radix","","Converts a string slice in a given base to an integer.",409,{"inputs":[{"name":"str"},{"name":"u32"}],"output":{"name":"result"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",409,{"inputs":[{"name":"i64"}],"output":{"name":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",409,{"inputs":[{"name":"i64"}],"output":{"name":"u32"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation\nof `self`.",409,{"inputs":[{"name":"i64"}],"output":{"name":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation\nof `self`.",409,{"inputs":[{"name":"i64"}],"output":{"name":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,\nwrapping the truncated bits to the end of the resulting integer.",409,{"inputs":[{"name":"i64"},{"name":"u32"}],"output":{"name":"i64"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,\nwrapping the truncated bits to the beginning of the resulting\ninteger.",409,{"inputs":[{"name":"i64"},{"name":"u32"}],"output":{"name":"i64"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",409,{"inputs":[{"name":"i64"}],"output":{"name":"i64"}}],[11,"from_be","","Converts an integer from big endian to the target&#39;s endianness.",409,{"inputs":[{"name":"i64"}],"output":{"name":"i64"}}],[11,"from_le","","Converts an integer from little endian to the target&#39;s endianness.",409,{"inputs":[{"name":"i64"}],"output":{"name":"i64"}}],[11,"to_be","","Converts `self` to big endian from the target&#39;s endianness.",409,{"inputs":[{"name":"i64"}],"output":{"name":"i64"}}],[11,"to_le","","Converts `self` to little endian from the target&#39;s endianness.",409,{"inputs":[{"name":"i64"}],"output":{"name":"i64"}}],[11,"checked_add","","Checked integer addition. Computes `self + other`, returning `None`\nif overflow occurred.",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"option"}}],[11,"checked_sub","","Checked integer subtraction. Computes `self - other`, returning\n`None` if underflow occurred.",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"option"}}],[11,"checked_mul","","Checked integer multiplication. Computes `self * other`, returning\n`None` if underflow or overflow occurred.",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"option"}}],[11,"checked_div","","Checked integer division. Computes `self / other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"option"}}],[11,"checked_rem","","Checked integer remainder. Computes `self % other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"option"}}],[11,"checked_neg","","Checked negation. Computes `-self`, returning `None` if `self ==\nMIN`.",409,{"inputs":[{"name":"i64"}],"output":{"name":"option"}}],[11,"checked_shl","","Checked shift left. Computes `self &lt;&lt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",409,{"inputs":[{"name":"i64"},{"name":"u32"}],"output":{"name":"option"}}],[11,"checked_shr","","Checked shift right. Computes `self &gt;&gt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",409,{"inputs":[{"name":"i64"},{"name":"u32"}],"output":{"name":"option"}}],[11,"saturating_add","","Saturating integer addition. Computes `self + other`, saturating at\nthe numeric bounds instead of overflowing.",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"saturating_sub","","Saturating integer subtraction. Computes `self - other`, saturating\nat the numeric bounds instead of overflowing.",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"saturating_mul","","Saturating integer multiplication. Computes `self * other`,\nsaturating at the numeric bounds instead of overflowing.",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"wrapping_add","","Wrapping (modular) addition. Computes `self + other`,\nwrapping around at the boundary of the type.",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"wrapping_sub","","Wrapping (modular) subtraction. Computes `self - other`,\nwrapping around at the boundary of the type.",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"wrapping_mul","","Wrapping (modular) multiplication. Computes `self *\nother`, wrapping around at the boundary of the type.",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"wrapping_div","","Wrapping (modular) division. Computes `self / other`,\nwrapping around at the boundary of the type.",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"wrapping_rem","","Wrapping (modular) remainder. Computes `self % other`,\nwrapping around at the boundary of the type.",409,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"wrapping_neg","","Wrapping (modular) negation. Computes `-self`,\nwrapping around at the boundary of the type.",409,{"inputs":[{"name":"i64"}],"output":{"name":"i64"}}],[11,"wrapping_shl","","Panic-free bitwise shift-left; yields `self &lt;&lt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",409,{"inputs":[{"name":"i64"},{"name":"u32"}],"output":{"name":"i64"}}],[11,"wrapping_shr","","Panic-free bitwise shift-right; yields `self &gt;&gt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",409,{"inputs":[{"name":"i64"},{"name":"u32"}],"output":{"name":"i64"}}],[11,"overflowing_add","","Calculates `self` + `rhs`",409,null],[11,"overflowing_sub","","Calculates `self` - `rhs`",409,null],[11,"overflowing_mul","","Calculates the multiplication of `self` and `rhs`.",409,null],[11,"overflowing_div","","Calculates the divisor when `self` is divided by `rhs`.",409,null],[11,"overflowing_rem","","Calculates the remainder when `self` is divided by `rhs`.",409,null],[11,"overflowing_neg","","Negates self, overflowing if this is equal to the minimum value.",409,null],[11,"overflowing_shl","","Shifts self left by `rhs` bits.",409,null],[11,"overflowing_shr","","Shifts self right by `rhs` bits.",409,null],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",409,{"inputs":[{"name":"i64"},{"name":"u32"}],"output":{"name":"i64"}}],[11,"abs","","Computes the absolute value of `self`.",409,{"inputs":[{"name":"i64"}],"output":{"name":"i64"}}],[11,"signum","","Returns a number representing sign of `self`.",409,{"inputs":[{"name":"i64"}],"output":{"name":"i64"}}],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number\nis zero or negative.",409,{"inputs":[{"name":"i64"}],"output":{"name":"bool"}}],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number\nis zero or positive.",409,{"inputs":[{"name":"i64"}],"output":{"name":"bool"}}],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",411,{"inputs":[],"output":{"name":"i32"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",411,{"inputs":[],"output":{"name":"i32"}}],[11,"from_str_radix","","Converts a string slice in a given base to an integer.",411,{"inputs":[{"name":"str"},{"name":"u32"}],"output":{"name":"result"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",411,{"inputs":[{"name":"i32"}],"output":{"name":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",411,{"inputs":[{"name":"i32"}],"output":{"name":"u32"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation\nof `self`.",411,{"inputs":[{"name":"i32"}],"output":{"name":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation\nof `self`.",411,{"inputs":[{"name":"i32"}],"output":{"name":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,\nwrapping the truncated bits to the end of the resulting integer.",411,{"inputs":[{"name":"i32"},{"name":"u32"}],"output":{"name":"i32"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,\nwrapping the truncated bits to the beginning of the resulting\ninteger.",411,{"inputs":[{"name":"i32"},{"name":"u32"}],"output":{"name":"i32"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",411,{"inputs":[{"name":"i32"}],"output":{"name":"i32"}}],[11,"from_be","","Converts an integer from big endian to the target&#39;s endianness.",411,{"inputs":[{"name":"i32"}],"output":{"name":"i32"}}],[11,"from_le","","Converts an integer from little endian to the target&#39;s endianness.",411,{"inputs":[{"name":"i32"}],"output":{"name":"i32"}}],[11,"to_be","","Converts `self` to big endian from the target&#39;s endianness.",411,{"inputs":[{"name":"i32"}],"output":{"name":"i32"}}],[11,"to_le","","Converts `self` to little endian from the target&#39;s endianness.",411,{"inputs":[{"name":"i32"}],"output":{"name":"i32"}}],[11,"checked_add","","Checked integer addition. Computes `self + other`, returning `None`\nif overflow occurred.",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"option"}}],[11,"checked_sub","","Checked integer subtraction. Computes `self - other`, returning\n`None` if underflow occurred.",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"option"}}],[11,"checked_mul","","Checked integer multiplication. Computes `self * other`, returning\n`None` if underflow or overflow occurred.",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"option"}}],[11,"checked_div","","Checked integer division. Computes `self / other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"option"}}],[11,"checked_rem","","Checked integer remainder. Computes `self % other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"option"}}],[11,"checked_neg","","Checked negation. Computes `-self`, returning `None` if `self ==\nMIN`.",411,{"inputs":[{"name":"i32"}],"output":{"name":"option"}}],[11,"checked_shl","","Checked shift left. Computes `self &lt;&lt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",411,{"inputs":[{"name":"i32"},{"name":"u32"}],"output":{"name":"option"}}],[11,"checked_shr","","Checked shift right. Computes `self &gt;&gt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",411,{"inputs":[{"name":"i32"},{"name":"u32"}],"output":{"name":"option"}}],[11,"saturating_add","","Saturating integer addition. Computes `self + other`, saturating at\nthe numeric bounds instead of overflowing.",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"saturating_sub","","Saturating integer subtraction. Computes `self - other`, saturating\nat the numeric bounds instead of overflowing.",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"saturating_mul","","Saturating integer multiplication. Computes `self * other`,\nsaturating at the numeric bounds instead of overflowing.",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"wrapping_add","","Wrapping (modular) addition. Computes `self + other`,\nwrapping around at the boundary of the type.",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"wrapping_sub","","Wrapping (modular) subtraction. Computes `self - other`,\nwrapping around at the boundary of the type.",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"wrapping_mul","","Wrapping (modular) multiplication. Computes `self *\nother`, wrapping around at the boundary of the type.",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"wrapping_div","","Wrapping (modular) division. Computes `self / other`,\nwrapping around at the boundary of the type.",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"wrapping_rem","","Wrapping (modular) remainder. Computes `self % other`,\nwrapping around at the boundary of the type.",411,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"wrapping_neg","","Wrapping (modular) negation. Computes `-self`,\nwrapping around at the boundary of the type.",411,{"inputs":[{"name":"i32"}],"output":{"name":"i32"}}],[11,"wrapping_shl","","Panic-free bitwise shift-left; yields `self &lt;&lt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",411,{"inputs":[{"name":"i32"},{"name":"u32"}],"output":{"name":"i32"}}],[11,"wrapping_shr","","Panic-free bitwise shift-right; yields `self &gt;&gt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",411,{"inputs":[{"name":"i32"},{"name":"u32"}],"output":{"name":"i32"}}],[11,"overflowing_add","","Calculates `self` + `rhs`",411,null],[11,"overflowing_sub","","Calculates `self` - `rhs`",411,null],[11,"overflowing_mul","","Calculates the multiplication of `self` and `rhs`.",411,null],[11,"overflowing_div","","Calculates the divisor when `self` is divided by `rhs`.",411,null],[11,"overflowing_rem","","Calculates the remainder when `self` is divided by `rhs`.",411,null],[11,"overflowing_neg","","Negates self, overflowing if this is equal to the minimum value.",411,null],[11,"overflowing_shl","","Shifts self left by `rhs` bits.",411,null],[11,"overflowing_shr","","Shifts self right by `rhs` bits.",411,null],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",411,{"inputs":[{"name":"i32"},{"name":"u32"}],"output":{"name":"i32"}}],[11,"abs","","Computes the absolute value of `self`.",411,{"inputs":[{"name":"i32"}],"output":{"name":"i32"}}],[11,"signum","","Returns a number representing sign of `self`.",411,{"inputs":[{"name":"i32"}],"output":{"name":"i32"}}],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number\nis zero or negative.",411,{"inputs":[{"name":"i32"}],"output":{"name":"bool"}}],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number\nis zero or positive.",411,{"inputs":[{"name":"i32"}],"output":{"name":"bool"}}],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",413,{"inputs":[],"output":{"name":"i16"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",413,{"inputs":[],"output":{"name":"i16"}}],[11,"from_str_radix","","Converts a string slice in a given base to an integer.",413,{"inputs":[{"name":"str"},{"name":"u32"}],"output":{"name":"result"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",413,{"inputs":[{"name":"i16"}],"output":{"name":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",413,{"inputs":[{"name":"i16"}],"output":{"name":"u32"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation\nof `self`.",413,{"inputs":[{"name":"i16"}],"output":{"name":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation\nof `self`.",413,{"inputs":[{"name":"i16"}],"output":{"name":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,\nwrapping the truncated bits to the end of the resulting integer.",413,{"inputs":[{"name":"i16"},{"name":"u32"}],"output":{"name":"i16"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,\nwrapping the truncated bits to the beginning of the resulting\ninteger.",413,{"inputs":[{"name":"i16"},{"name":"u32"}],"output":{"name":"i16"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",413,{"inputs":[{"name":"i16"}],"output":{"name":"i16"}}],[11,"from_be","","Converts an integer from big endian to the target&#39;s endianness.",413,{"inputs":[{"name":"i16"}],"output":{"name":"i16"}}],[11,"from_le","","Converts an integer from little endian to the target&#39;s endianness.",413,{"inputs":[{"name":"i16"}],"output":{"name":"i16"}}],[11,"to_be","","Converts `self` to big endian from the target&#39;s endianness.",413,{"inputs":[{"name":"i16"}],"output":{"name":"i16"}}],[11,"to_le","","Converts `self` to little endian from the target&#39;s endianness.",413,{"inputs":[{"name":"i16"}],"output":{"name":"i16"}}],[11,"checked_add","","Checked integer addition. Computes `self + other`, returning `None`\nif overflow occurred.",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"option"}}],[11,"checked_sub","","Checked integer subtraction. Computes `self - other`, returning\n`None` if underflow occurred.",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"option"}}],[11,"checked_mul","","Checked integer multiplication. Computes `self * other`, returning\n`None` if underflow or overflow occurred.",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"option"}}],[11,"checked_div","","Checked integer division. Computes `self / other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"option"}}],[11,"checked_rem","","Checked integer remainder. Computes `self % other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"option"}}],[11,"checked_neg","","Checked negation. Computes `-self`, returning `None` if `self ==\nMIN`.",413,{"inputs":[{"name":"i16"}],"output":{"name":"option"}}],[11,"checked_shl","","Checked shift left. Computes `self &lt;&lt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",413,{"inputs":[{"name":"i16"},{"name":"u32"}],"output":{"name":"option"}}],[11,"checked_shr","","Checked shift right. Computes `self &gt;&gt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",413,{"inputs":[{"name":"i16"},{"name":"u32"}],"output":{"name":"option"}}],[11,"saturating_add","","Saturating integer addition. Computes `self + other`, saturating at\nthe numeric bounds instead of overflowing.",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"saturating_sub","","Saturating integer subtraction. Computes `self - other`, saturating\nat the numeric bounds instead of overflowing.",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"saturating_mul","","Saturating integer multiplication. Computes `self * other`,\nsaturating at the numeric bounds instead of overflowing.",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"wrapping_add","","Wrapping (modular) addition. Computes `self + other`,\nwrapping around at the boundary of the type.",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"wrapping_sub","","Wrapping (modular) subtraction. Computes `self - other`,\nwrapping around at the boundary of the type.",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"wrapping_mul","","Wrapping (modular) multiplication. Computes `self *\nother`, wrapping around at the boundary of the type.",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"wrapping_div","","Wrapping (modular) division. Computes `self / other`,\nwrapping around at the boundary of the type.",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"wrapping_rem","","Wrapping (modular) remainder. Computes `self % other`,\nwrapping around at the boundary of the type.",413,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"wrapping_neg","","Wrapping (modular) negation. Computes `-self`,\nwrapping around at the boundary of the type.",413,{"inputs":[{"name":"i16"}],"output":{"name":"i16"}}],[11,"wrapping_shl","","Panic-free bitwise shift-left; yields `self &lt;&lt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",413,{"inputs":[{"name":"i16"},{"name":"u32"}],"output":{"name":"i16"}}],[11,"wrapping_shr","","Panic-free bitwise shift-right; yields `self &gt;&gt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",413,{"inputs":[{"name":"i16"},{"name":"u32"}],"output":{"name":"i16"}}],[11,"overflowing_add","","Calculates `self` + `rhs`",413,null],[11,"overflowing_sub","","Calculates `self` - `rhs`",413,null],[11,"overflowing_mul","","Calculates the multiplication of `self` and `rhs`.",413,null],[11,"overflowing_div","","Calculates the divisor when `self` is divided by `rhs`.",413,null],[11,"overflowing_rem","","Calculates the remainder when `self` is divided by `rhs`.",413,null],[11,"overflowing_neg","","Negates self, overflowing if this is equal to the minimum value.",413,null],[11,"overflowing_shl","","Shifts self left by `rhs` bits.",413,null],[11,"overflowing_shr","","Shifts self right by `rhs` bits.",413,null],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",413,{"inputs":[{"name":"i16"},{"name":"u32"}],"output":{"name":"i16"}}],[11,"abs","","Computes the absolute value of `self`.",413,{"inputs":[{"name":"i16"}],"output":{"name":"i16"}}],[11,"signum","","Returns a number representing sign of `self`.",413,{"inputs":[{"name":"i16"}],"output":{"name":"i16"}}],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number\nis zero or negative.",413,{"inputs":[{"name":"i16"}],"output":{"name":"bool"}}],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number\nis zero or positive.",413,{"inputs":[{"name":"i16"}],"output":{"name":"bool"}}],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",415,{"inputs":[],"output":{"name":"i8"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",415,{"inputs":[],"output":{"name":"i8"}}],[11,"from_str_radix","","Converts a string slice in a given base to an integer.",415,{"inputs":[{"name":"str"},{"name":"u32"}],"output":{"name":"result"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",415,{"inputs":[{"name":"i8"}],"output":{"name":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",415,{"inputs":[{"name":"i8"}],"output":{"name":"u32"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation\nof `self`.",415,{"inputs":[{"name":"i8"}],"output":{"name":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation\nof `self`.",415,{"inputs":[{"name":"i8"}],"output":{"name":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,\nwrapping the truncated bits to the end of the resulting integer.",415,{"inputs":[{"name":"i8"},{"name":"u32"}],"output":{"name":"i8"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,\nwrapping the truncated bits to the beginning of the resulting\ninteger.",415,{"inputs":[{"name":"i8"},{"name":"u32"}],"output":{"name":"i8"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",415,{"inputs":[{"name":"i8"}],"output":{"name":"i8"}}],[11,"from_be","","Converts an integer from big endian to the target&#39;s endianness.",415,{"inputs":[{"name":"i8"}],"output":{"name":"i8"}}],[11,"from_le","","Converts an integer from little endian to the target&#39;s endianness.",415,{"inputs":[{"name":"i8"}],"output":{"name":"i8"}}],[11,"to_be","","Converts `self` to big endian from the target&#39;s endianness.",415,{"inputs":[{"name":"i8"}],"output":{"name":"i8"}}],[11,"to_le","","Converts `self` to little endian from the target&#39;s endianness.",415,{"inputs":[{"name":"i8"}],"output":{"name":"i8"}}],[11,"checked_add","","Checked integer addition. Computes `self + other`, returning `None`\nif overflow occurred.",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"option"}}],[11,"checked_sub","","Checked integer subtraction. Computes `self - other`, returning\n`None` if underflow occurred.",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"option"}}],[11,"checked_mul","","Checked integer multiplication. Computes `self * other`, returning\n`None` if underflow or overflow occurred.",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"option"}}],[11,"checked_div","","Checked integer division. Computes `self / other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"option"}}],[11,"checked_rem","","Checked integer remainder. Computes `self % other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"option"}}],[11,"checked_neg","","Checked negation. Computes `-self`, returning `None` if `self ==\nMIN`.",415,{"inputs":[{"name":"i8"}],"output":{"name":"option"}}],[11,"checked_shl","","Checked shift left. Computes `self &lt;&lt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",415,{"inputs":[{"name":"i8"},{"name":"u32"}],"output":{"name":"option"}}],[11,"checked_shr","","Checked shift right. Computes `self &gt;&gt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",415,{"inputs":[{"name":"i8"},{"name":"u32"}],"output":{"name":"option"}}],[11,"saturating_add","","Saturating integer addition. Computes `self + other`, saturating at\nthe numeric bounds instead of overflowing.",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"saturating_sub","","Saturating integer subtraction. Computes `self - other`, saturating\nat the numeric bounds instead of overflowing.",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"saturating_mul","","Saturating integer multiplication. Computes `self * other`,\nsaturating at the numeric bounds instead of overflowing.",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"wrapping_add","","Wrapping (modular) addition. Computes `self + other`,\nwrapping around at the boundary of the type.",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"wrapping_sub","","Wrapping (modular) subtraction. Computes `self - other`,\nwrapping around at the boundary of the type.",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"wrapping_mul","","Wrapping (modular) multiplication. Computes `self *\nother`, wrapping around at the boundary of the type.",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"wrapping_div","","Wrapping (modular) division. Computes `self / other`,\nwrapping around at the boundary of the type.",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"wrapping_rem","","Wrapping (modular) remainder. Computes `self % other`,\nwrapping around at the boundary of the type.",415,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"wrapping_neg","","Wrapping (modular) negation. Computes `-self`,\nwrapping around at the boundary of the type.",415,{"inputs":[{"name":"i8"}],"output":{"name":"i8"}}],[11,"wrapping_shl","","Panic-free bitwise shift-left; yields `self &lt;&lt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",415,{"inputs":[{"name":"i8"},{"name":"u32"}],"output":{"name":"i8"}}],[11,"wrapping_shr","","Panic-free bitwise shift-right; yields `self &gt;&gt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",415,{"inputs":[{"name":"i8"},{"name":"u32"}],"output":{"name":"i8"}}],[11,"overflowing_add","","Calculates `self` + `rhs`",415,null],[11,"overflowing_sub","","Calculates `self` - `rhs`",415,null],[11,"overflowing_mul","","Calculates the multiplication of `self` and `rhs`.",415,null],[11,"overflowing_div","","Calculates the divisor when `self` is divided by `rhs`.",415,null],[11,"overflowing_rem","","Calculates the remainder when `self` is divided by `rhs`.",415,null],[11,"overflowing_neg","","Negates self, overflowing if this is equal to the minimum value.",415,null],[11,"overflowing_shl","","Shifts self left by `rhs` bits.",415,null],[11,"overflowing_shr","","Shifts self right by `rhs` bits.",415,null],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",415,{"inputs":[{"name":"i8"},{"name":"u32"}],"output":{"name":"i8"}}],[11,"abs","","Computes the absolute value of `self`.",415,{"inputs":[{"name":"i8"}],"output":{"name":"i8"}}],[11,"signum","","Returns a number representing sign of `self`.",415,{"inputs":[{"name":"i8"}],"output":{"name":"i8"}}],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number\nis zero or negative.",415,{"inputs":[{"name":"i8"}],"output":{"name":"bool"}}],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number\nis zero or positive.",415,{"inputs":[{"name":"i8"}],"output":{"name":"bool"}}],[11,"one","","",401,{"inputs":[],"output":{"name":"f64"}}],[11,"zero","","",401,{"inputs":[],"output":{"name":"f64"}}],[11,"one","","",402,{"inputs":[],"output":{"name":"f32"}}],[11,"zero","","",402,{"inputs":[],"output":{"name":"f32"}}],[11,"one","","",407,{"inputs":[],"output":{"name":"isize"}}],[11,"zero","","",407,{"inputs":[],"output":{"name":"isize"}}],[11,"one","","",409,{"inputs":[],"output":{"name":"i64"}}],[11,"zero","","",409,{"inputs":[],"output":{"name":"i64"}}],[11,"one","","",411,{"inputs":[],"output":{"name":"i32"}}],[11,"zero","","",411,{"inputs":[],"output":{"name":"i32"}}],[11,"one","","",413,{"inputs":[],"output":{"name":"i16"}}],[11,"zero","","",413,{"inputs":[],"output":{"name":"i16"}}],[11,"one","","",415,{"inputs":[],"output":{"name":"i8"}}],[11,"zero","","",415,{"inputs":[],"output":{"name":"i8"}}],[11,"one","","",406,{"inputs":[],"output":{"name":"usize"}}],[11,"zero","","",406,{"inputs":[],"output":{"name":"usize"}}],[11,"one","","",408,{"inputs":[],"output":{"name":"u64"}}],[11,"zero","","",408,{"inputs":[],"output":{"name":"u64"}}],[11,"one","","",410,{"inputs":[],"output":{"name":"u32"}}],[11,"zero","","",410,{"inputs":[],"output":{"name":"u32"}}],[11,"one","","",412,{"inputs":[],"output":{"name":"u16"}}],[11,"zero","","",412,{"inputs":[],"output":{"name":"u16"}}],[11,"one","","",414,{"inputs":[],"output":{"name":"u8"}}],[11,"zero","","",414,{"inputs":[],"output":{"name":"u8"}}],[11,"to_string","","",404,{"inputs":[{"name":"str"}],"output":{"name":"string"}}],[11,"eq","","",404,{"inputs":[{"name":"str"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"ne","","",404,{"inputs":[{"name":"str"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"eq","","",404,{"inputs":[{"name":"str"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"ne","","",404,{"inputs":[{"name":"str"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"eq","","",404,{"inputs":[{"name":"str"},{"name":"string"}],"output":{"name":"bool"}}],[11,"ne","","",404,{"inputs":[{"name":"str"},{"name":"string"}],"output":{"name":"bool"}}],[11,"eq","","",404,{"inputs":[{"name":"str"},{"name":"string"}],"output":{"name":"bool"}}],[11,"ne","","",404,{"inputs":[{"name":"str"},{"name":"string"}],"output":{"name":"bool"}}],[11,"len","","Returns the length of `self`.",404,{"inputs":[{"name":"str"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns true if this slice has a length of zero bytes.",404,{"inputs":[{"name":"str"}],"output":{"name":"bool"}}],[11,"is_char_boundary","","Checks that `index`-th byte lies at the start and/or end of a\nUTF-8 code point sequence.",404,{"inputs":[{"name":"str"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"as_bytes","","Converts a string slice to a byte slice.",404,null],[11,"as_ptr","","Converts a string slice to a raw pointer.",404,null],[11,"slice_unchecked","","Creates a string slice from another string slice, bypassing safety\nchecks.",404,{"inputs":[{"name":"str"},{"name":"usize"},{"name":"usize"}],"output":{"name":"str"}}],[11,"slice_mut_unchecked","","Creates a string slice from another string slice, bypassing safety\nchecks.",404,{"inputs":[{"name":"str"},{"name":"usize"},{"name":"usize"}],"output":{"name":"str"}}],[11,"char_range_at","","Given a byte position, returns the next `char` and its index.",404,{"inputs":[{"name":"str"},{"name":"usize"}],"output":{"name":"charrange"}}],[11,"char_range_at_reverse","","Given a byte position, returns the previous `char` and its position.",404,{"inputs":[{"name":"str"},{"name":"usize"}],"output":{"name":"charrange"}}],[11,"char_at","","Given a byte position, returns the `char` at that position.",404,{"inputs":[{"name":"str"},{"name":"usize"}],"output":{"name":"char"}}],[11,"char_at_reverse","","Given a byte position, returns the `char` at that position, counting\nfrom the end.",404,{"inputs":[{"name":"str"},{"name":"usize"}],"output":{"name":"char"}}],[11,"slice_shift_char","","Retrieves the first `char` from a `&amp;str` and returns it.",404,{"inputs":[{"name":"str"}],"output":{"name":"option"}}],[11,"split_at","","Divide one string slice into two at an index.",404,null],[11,"split_at_mut","","Divide one mutable string slice into two at an index.",404,null],[11,"chars","","Returns an iterator over the `char`s of a string slice.",404,{"inputs":[{"name":"str"}],"output":{"name":"chars"}}],[11,"char_indices","","Returns an iterator over the [`char`]s of a string slice, and their\npositions.",404,{"inputs":[{"name":"str"}],"output":{"name":"charindices"}}],[11,"bytes","","An iterator over the bytes of a string slice.",404,{"inputs":[{"name":"str"}],"output":{"name":"bytes"}}],[11,"split_whitespace","","Split a string slice by whitespace.",404,{"inputs":[{"name":"str"}],"output":{"name":"splitwhitespace"}}],[11,"lines","","An iterator over the lines of a string, as string slices.",404,{"inputs":[{"name":"str"}],"output":{"name":"lines"}}],[11,"lines_any","","An iterator over the lines of a string.",404,{"inputs":[{"name":"str"}],"output":{"name":"linesany"}}],[11,"utf16_units","","Returns an iterator of `u16` over the string encoded as UTF-16.",404,{"inputs":[{"name":"str"}],"output":{"name":"encodeutf16"}}],[11,"encode_utf16","","Returns an iterator of `u16` over the string encoded as UTF-16.",404,{"inputs":[{"name":"str"}],"output":{"name":"encodeutf16"}}],[11,"contains","","Returns `true` if the given pattern matches a sub-slice of\nthis string slice.",404,{"inputs":[{"name":"str"},{"name":"p"}],"output":{"name":"bool"}}],[11,"starts_with","","Returns `true` if the given pattern matches a prefix of this\nstring slice.",404,{"inputs":[{"name":"str"},{"name":"p"}],"output":{"name":"bool"}}],[11,"ends_with","","Returns `true` if the given pattern matches a suffix of this\nstring slice.",404,{"inputs":[{"name":"str"},{"name":"p"}],"output":{"name":"bool"}}],[11,"find","","Returns the byte index of the first character of this string slice that\nmatches the pattern.",404,{"inputs":[{"name":"str"},{"name":"p"}],"output":{"name":"option"}}],[11,"rfind","","Returns the byte index of the last character of this string slice that\nmatches the pattern.",404,{"inputs":[{"name":"str"},{"name":"p"}],"output":{"name":"option"}}],[11,"split","","An iterator over substrings of this string slice, separated by\ncharacters matched by a pattern.",404,{"inputs":[{"name":"str"},{"name":"p"}],"output":{"name":"split"}}],[11,"rsplit","","An iterator over substrings of the given string slice, separated by\ncharacters matched by a pattern and yielded in reverse order.",404,{"inputs":[{"name":"str"},{"name":"p"}],"output":{"name":"rsplit"}}],[11,"split_terminator","","An iterator over substrings of the given string slice, separated by\ncharacters matched by a pattern.",404,{"inputs":[{"name":"str"},{"name":"p"}],"output":{"name":"splitterminator"}}],[11,"rsplit_terminator","","An iterator over substrings of `self`, separated by characters\nmatched by a pattern and yielded in reverse order.",404,{"inputs":[{"name":"str"},{"name":"p"}],"output":{"name":"rsplitterminator"}}],[11,"splitn","","An iterator over substrings of the given string slice, separated by a\npattern, restricted to returning at most `count` items.",404,{"inputs":[{"name":"str"},{"name":"usize"},{"name":"p"}],"output":{"name":"splitn"}}],[11,"rsplitn","","An iterator over substrings of this string slice, separated by a\npattern, starting from the end of the string, restricted to returning\nat most `count` items.",404,{"inputs":[{"name":"str"},{"name":"usize"},{"name":"p"}],"output":{"name":"rsplitn"}}],[11,"matches","","An iterator over the matches of a pattern within the given string\nslice.",404,{"inputs":[{"name":"str"},{"name":"p"}],"output":{"name":"matches"}}],[11,"rmatches","","An iterator over the matches of a pattern within this string slice,\nyielded in reverse order.",404,{"inputs":[{"name":"str"},{"name":"p"}],"output":{"name":"rmatches"}}],[11,"match_indices","","An iterator over the disjoint matches of a pattern within this string\nslice as well as the index that the match starts at.",404,{"inputs":[{"name":"str"},{"name":"p"}],"output":{"name":"matchindices"}}],[11,"rmatch_indices","","An iterator over the disjoint matches of a pattern within `self`,\nyielded in reverse order along with the index of the match.",404,{"inputs":[{"name":"str"},{"name":"p"}],"output":{"name":"rmatchindices"}}],[11,"trim","","Returns a string slice with leading and trailing whitespace removed.",404,{"inputs":[{"name":"str"}],"output":{"name":"str"}}],[11,"trim_left","","Returns a string slice with leading whitespace removed.",404,{"inputs":[{"name":"str"}],"output":{"name":"str"}}],[11,"trim_right","","Returns a string slice with trailing whitespace removed.",404,{"inputs":[{"name":"str"}],"output":{"name":"str"}}],[11,"trim_matches","","Returns a string slice with all prefixes and suffixes that match a\npattern repeatedly removed.",404,{"inputs":[{"name":"str"},{"name":"p"}],"output":{"name":"str"}}],[11,"trim_left_matches","","Returns a string slice with all prefixes that match a pattern\nrepeatedly removed.",404,{"inputs":[{"name":"str"},{"name":"p"}],"output":{"name":"str"}}],[11,"trim_right_matches","","Returns a string slice with all suffixes that match a pattern\nrepeatedly removed.",404,{"inputs":[{"name":"str"},{"name":"p"}],"output":{"name":"str"}}],[11,"parse","","Parses this string slice into another type.",404,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"replace","","Replaces all matches of a pattern with another string.",404,{"inputs":[{"name":"str"},{"name":"p"},{"name":"str"}],"output":{"name":"string"}}],[11,"to_lowercase","","Returns the lowercase equivalent of this string slice, as a new [`String`].",404,{"inputs":[{"name":"str"}],"output":{"name":"string"}}],[11,"to_uppercase","","Returns the uppercase equivalent of this string slice, as a new [`String`].",404,{"inputs":[{"name":"str"}],"output":{"name":"string"}}],[11,"escape_default","","Escapes each char in `s` with `char::escape_default`.",404,{"inputs":[{"name":"str"}],"output":{"name":"string"}}],[11,"escape_unicode","","Escapes each char in `s` with `char::escape_unicode`.",404,{"inputs":[{"name":"str"}],"output":{"name":"string"}}],[11,"into_string","","Converts a `Box&lt;str&gt;` into a [`String`] without copying or allocating.",404,{"inputs":[{"name":"str"}],"output":{"name":"string"}}],[11,"to_owned","","",404,{"inputs":[{"name":"str"}],"output":{"name":"string"}}],[11,"concat","","",399,{"inputs":[{"name":"slice"}],"output":{"name":"string"}}],[11,"join","","",399,{"inputs":[{"name":"slice"},{"name":"str"}],"output":{"name":"string"}}],[11,"connect","","",399,{"inputs":[{"name":"slice"},{"name":"str"}],"output":{"name":"string"}}],[11,"to_owned","","",399,{"inputs":[{"name":"slice"}],"output":{"name":"vec"}}],[11,"concat","","",399,{"inputs":[{"name":"slice"}],"output":{"name":"vec"}}],[11,"join","","",399,{"inputs":[{"name":"slice"},{"name":"t"}],"output":{"name":"vec"}}],[11,"connect","","",399,{"inputs":[{"name":"slice"},{"name":"t"}],"output":{"name":"vec"}}],[11,"len","","Returns the number of elements in the slice.",399,{"inputs":[{"name":"slice"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns true if the slice has a length of 0",399,{"inputs":[{"name":"slice"}],"output":{"name":"bool"}}],[11,"first","","Returns the first element of a slice, or `None` if it is empty.",399,{"inputs":[{"name":"slice"}],"output":{"name":"option"}}],[11,"first_mut","","Returns a mutable pointer to the first element of a slice, or `None` if it is empty",399,{"inputs":[{"name":"slice"}],"output":{"name":"option"}}],[11,"split_first","","Returns the first and all the rest of the elements of a slice.",399,{"inputs":[{"name":"slice"}],"output":{"name":"option"}}],[11,"split_first_mut","","Returns the first and all the rest of the elements of a slice.",399,{"inputs":[{"name":"slice"}],"output":{"name":"option"}}],[11,"split_last","","Returns the last and all the rest of the elements of a slice.",399,{"inputs":[{"name":"slice"}],"output":{"name":"option"}}],[11,"split_last_mut","","Returns the last and all the rest of the elements of a slice.",399,{"inputs":[{"name":"slice"}],"output":{"name":"option"}}],[11,"last","","Returns the last element of a slice, or `None` if it is empty.",399,{"inputs":[{"name":"slice"}],"output":{"name":"option"}}],[11,"last_mut","","Returns a mutable pointer to the last item in the slice.",399,{"inputs":[{"name":"slice"}],"output":{"name":"option"}}],[11,"get","","Returns the element of a slice at the given index, or `None` if the\nindex is out of bounds.",399,{"inputs":[{"name":"slice"},{"name":"usize"}],"output":{"name":"option"}}],[11,"get_mut","","Returns a mutable reference to the element at the given index,\nor `None` if the index is out of bounds",399,{"inputs":[{"name":"slice"},{"name":"usize"}],"output":{"name":"option"}}],[