/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ast.adapters.offsetstrategy;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.refactoring.ast.adapters.IASTNodeAdapter;
import org.python.pydev.refactoring.ast.adapters.offsetstrategy.IOffsetStrategy;
import org.python.pydev.refactoring.ast.visitors.NodeHelper;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOffsetStrategy
implements IOffsetStrategy {
    protected IDocument doc;
    protected IASTNodeAdapter<? extends SimpleNode> adapter;
    protected NodeHelper nodeHelper;

    protected abstract int getLine();

    public AbstractOffsetStrategy(IASTNodeAdapter<? extends SimpleNode> adapter, IDocument doc) {
        this.adapter = adapter;
        this.doc = doc;
        this.nodeHelper = new NodeHelper(TextUtilities.getDefaultLineDelimiter((IDocument)doc));
    }

    protected IRegion getRegion() throws BadLocationException {
        return this.doc.getLineInformation(this.getLine());
    }

    protected int getLineOffset() throws BadLocationException {
        return this.getRegion().getOffset();
    }

    protected int getLineIndendation() throws BadLocationException {
        return this.doc.getLineLength(this.getLine());
    }

    @Override
    public int getOffset() throws BadLocationException {
        return this.getLineOffset() + this.getLineIndendation();
    }
}

