/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.python.pydev.editor.IPyEditListener;
import org.python.pydev.editor.IPyEditListener3;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.plugin.PydevPlugin;

public class PyEditNotifier {
    private WeakReference<PyEdit> pyEdit;

    public PyEditNotifier(PyEdit edit) {
        this.pyEdit = new WeakReference<PyEdit>(edit);
    }

    public void notifyOnCreateActions(final PyEdit.MyResources resources) {
        final PyEdit edit = (PyEdit)((Object)this.pyEdit.get());
        if (edit == null) {
            return;
        }
        INotifierRunnable runnable = new INotifierRunnable(){

            public void run(IProgressMonitor monitor) {
                Iterator<IPyEditListener> iterator = edit.getAllListeners().iterator();
                while (iterator.hasNext()) {
                    IPyEditListener listener = iterator.next();
                    try {
                        if (monitor.isCanceled()) continue;
                        listener.onCreateActions(resources, edit, monitor);
                    }
                    catch (Exception e) {
                        PydevPlugin.log(e);
                    }
                }
            }
        };
        this.runIt(runnable);
    }

    public void notifyOnSave() {
        final PyEdit edit = (PyEdit)((Object)this.pyEdit.get());
        if (edit == null) {
            return;
        }
        INotifierRunnable runnable = new INotifierRunnable(){

            public void run(IProgressMonitor monitor) {
                Iterator<IPyEditListener> iterator = edit.getAllListeners().iterator();
                while (iterator.hasNext()) {
                    IPyEditListener listener = iterator.next();
                    try {
                        if (monitor.isCanceled()) continue;
                        listener.onSave(edit, monitor);
                    }
                    catch (Throwable e) {
                        PydevPlugin.log(e);
                    }
                }
            }
        };
        this.runIt(runnable);
    }

    private void runIt(final INotifierRunnable runnable) {
        Job job = new Job("PyEditNotifier"){

            protected IStatus run(IProgressMonitor monitor) {
                runnable.run(monitor);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.setSystem(true);
        job.schedule();
    }

    public void notifyOnDispose() {
        final PyEdit edit = (PyEdit)((Object)this.pyEdit.get());
        if (edit == null) {
            return;
        }
        INotifierRunnable runnable = new INotifierRunnable(){

            public void run(IProgressMonitor monitor) {
                Iterator<IPyEditListener> iterator = edit.getAllListeners().iterator();
                while (iterator.hasNext()) {
                    IPyEditListener listener = iterator.next();
                    try {
                        if (monitor.isCanceled()) continue;
                        listener.onDispose(edit, monitor);
                    }
                    catch (Throwable throwable) {}
                }
            }
        };
        this.runIt(runnable);
    }

    public void notifyOnSetDocument(final IDocument document) {
        final PyEdit edit = (PyEdit)((Object)this.pyEdit.get());
        if (edit == null) {
            return;
        }
        INotifierRunnable runnable = new INotifierRunnable(){

            public void run(IProgressMonitor monitor) {
                Iterator<IPyEditListener> iterator = edit.getAllListeners().iterator();
                while (iterator.hasNext()) {
                    IPyEditListener listener = iterator.next();
                    try {
                        if (monitor.isCanceled()) continue;
                        listener.onSetDocument(document, edit, monitor);
                    }
                    catch (Exception e) {
                        PydevPlugin.log(e);
                    }
                }
            }
        };
        this.runIt(runnable);
    }

    public void notifyInputChanged(final IEditorInput oldInput, final IEditorInput input) {
        final PyEdit edit = (PyEdit)((Object)this.pyEdit.get());
        if (edit == null) {
            return;
        }
        INotifierRunnable runnable = new INotifierRunnable(){

            public void run(IProgressMonitor monitor) {
                Iterator<IPyEditListener> iterator = edit.getAllListeners().iterator();
                while (iterator.hasNext()) {
                    IPyEditListener listener = iterator.next();
                    if (!(listener instanceof IPyEditListener3)) continue;
                    IPyEditListener3 pyEditListener3 = (IPyEditListener3)((Object)listener);
                    try {
                        if (monitor.isCanceled()) continue;
                        pyEditListener3.onInputChanged(edit, oldInput, input, monitor);
                    }
                    catch (Exception e) {
                        PydevPlugin.log(e);
                    }
                }
            }
        };
        this.runIt(runnable);
    }

    public static interface INotifierRunnable {
        public void run(IProgressMonitor var1);
    }
}

