/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.spelling.SpellingService;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.PyCodeScanner;
import org.python.pydev.editor.PyColoredScanner;
import org.python.pydev.editor.PyDoubleClickStrategy;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.PyReconciler;
import org.python.pydev.editor.autoedit.DefaultIndentPrefs;
import org.python.pydev.editor.autoedit.PyAutoIndentStrategy;
import org.python.pydev.editor.codecompletion.PyCodeCompletionPreferencesPage;
import org.python.pydev.editor.codecompletion.PyContentAssistant;
import org.python.pydev.editor.codecompletion.PythonCompletionProcessor;
import org.python.pydev.editor.codecompletion.PythonStringCompletionProcessor;
import org.python.pydev.editor.correctionassist.PyCorrectionAssistant;
import org.python.pydev.editor.correctionassist.PythonCorrectionProcessor;
import org.python.pydev.editor.hover.PyAnnotationHover;
import org.python.pydev.editor.hover.PyTextHover;
import org.python.pydev.editor.simpleassist.SimpleAssistProcessor;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.ui.ColorCache;

public class PyEditConfiguration
extends TextSourceViewerConfiguration {
    private ColorCache colorCache;
    private PyAutoIndentStrategy autoIndentStrategy;
    private String[] indentPrefixes = new String[]{"    ", "\t", ""};
    private PyEdit edit;
    private PresentationReconciler reconciler;
    private PyCodeScanner codeScanner;
    private PyColoredScanner commentScanner;
    private PyColoredScanner stringScanner;
    private PyColoredScanner backquotesScanner;
    public PyContentAssistant pyContentAssistant = new PyContentAssistant();

    public PyEditConfiguration(ColorCache colorManager, PyEdit edit, IPreferenceStore preferenceStore) {
        super(preferenceStore);
        this.colorCache = colorManager;
        this.setEdit(edit);
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("org.python.pydev.editor.PythonEditor", this.edit);
        return targets;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new PyAnnotationHover(sourceViewer);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new PyTextHover(sourceViewer, contentType);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__python_comment", "__python_singleline_string1", "__python_singleline_string2", "__python_multiline_string1", "__python_multiline_string2"};
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "__PYTHON_PARTITION_TYPE";
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{this.getPyAutoIndentStrategy()};
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null || !this.fPreferenceStore.getBoolean("spellingEnabled")) {
            return null;
        }
        SpellingService spellingService = EditorsUI.getSpellingService();
        if (spellingService.getActiveSpellingEngineDescriptor(this.fPreferenceStore) == null) {
            return null;
        }
        PyReconciler strategy = new PyReconciler(sourceViewer, spellingService);
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
        reconciler.setIsIncrementalReconciler(false);
        reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
        reconciler.setDelay(500);
        return reconciler;
    }

    public PyAutoIndentStrategy getPyAutoIndentStrategy() {
        if (this.autoIndentStrategy == null) {
            this.autoIndentStrategy = new PyAutoIndentStrategy();
        }
        return this.autoIndentStrategy;
    }

    public void resetIndentPrefixes() {
        boolean spacesFirst;
        Preferences prefs = PydevPlugin.getDefault().getPluginPreferences();
        int tabWidth = DefaultIndentPrefs.getStaticTabWidth();
        FastStringBuffer spaces = new FastStringBuffer(8);
        int i = 0;
        while (i < tabWidth) {
            spaces.append(" ");
            ++i;
        }
        boolean bl = spacesFirst = prefs.getBoolean("SUBSTITUTE_TABS") && !this.getPyAutoIndentStrategy().getIndentPrefs().getForceTabs();
        if (spacesFirst) {
            this.indentPrefixes[0] = spaces.toString();
            this.indentPrefixes[1] = "\t";
        } else {
            this.indentPrefixes[0] = "\t";
            this.indentPrefixes[1] = spaces.toString();
        }
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        this.resetIndentPrefixes();
        sourceViewer.setIndentPrefixes(this.indentPrefixes, contentType);
        return this.indentPrefixes;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (contentType.equals("__dftl_partition_content_type")) {
            return new PyDoubleClickStrategy();
        }
        return super.getDoubleClickStrategy(sourceViewer, contentType);
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return DefaultIndentPrefs.getStaticTabWidth();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        if (this.reconciler == null) {
            this.reconciler = new PresentationReconciler();
            this.reconciler.setDocumentPartitioning("__PYTHON_PARTITION_TYPE");
            IPreferenceStore preferences = PydevPrefs.getChainedPrefStore();
            this.commentScanner = new PyColoredScanner(this.colorCache, "COMMENT_COLOR", preferences.getInt("COMMENT_STYLE"));
            DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.commentScanner);
            this.reconciler.setDamager((IPresentationDamager)dr, "__python_comment");
            this.reconciler.setRepairer((IPresentationRepairer)dr, "__python_comment");
            this.backquotesScanner = new PyColoredScanner(this.colorCache, "BACKQUOTES_COLOR", preferences.getInt("BACKQUOTES_STYLE"));
            dr = new DefaultDamagerRepairer((ITokenScanner)this.backquotesScanner);
            this.reconciler.setDamager((IPresentationDamager)dr, "__python_backquotes");
            this.reconciler.setRepairer((IPresentationRepairer)dr, "__python_backquotes");
            this.stringScanner = new PyColoredScanner(this.colorCache, "STRING_COLOR", preferences.getInt("STRING_STYLE"));
            dr = new DefaultDamagerRepairer((ITokenScanner)this.stringScanner);
            this.reconciler.setDamager((IPresentationDamager)dr, "__python_singleline_string1");
            this.reconciler.setRepairer((IPresentationRepairer)dr, "__python_singleline_string1");
            this.reconciler.setDamager((IPresentationDamager)dr, "__python_singleline_string2");
            this.reconciler.setRepairer((IPresentationRepairer)dr, "__python_singleline_string2");
            this.reconciler.setDamager((IPresentationDamager)dr, "__python_multiline_string1");
            this.reconciler.setRepairer((IPresentationRepairer)dr, "__python_multiline_string1");
            this.reconciler.setDamager((IPresentationDamager)dr, "__python_multiline_string2");
            this.reconciler.setRepairer((IPresentationRepairer)dr, "__python_multiline_string2");
            this.codeScanner = new PyCodeScanner(this.colorCache);
            dr = new DefaultDamagerRepairer((ITokenScanner)this.codeScanner);
            this.reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
            this.reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        }
        return this.reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        SimpleAssistProcessor processor = new SimpleAssistProcessor(this.edit, new PythonCompletionProcessor(this.edit, this.pyContentAssistant), this.pyContentAssistant);
        PythonStringCompletionProcessor stringProcessor = new PythonStringCompletionProcessor(this.edit, this.pyContentAssistant);
        this.pyContentAssistant.setRestoreCompletionProposalSize(this.getSettings("pydev_completion_proposal_size"));
        this.pyContentAssistant.setContentAssistProcessor(stringProcessor, "__python_singleline_string1");
        this.pyContentAssistant.setContentAssistProcessor(stringProcessor, "__python_singleline_string2");
        this.pyContentAssistant.setContentAssistProcessor(stringProcessor, "__python_multiline_string1");
        this.pyContentAssistant.setContentAssistProcessor(stringProcessor, "__python_multiline_string2");
        this.pyContentAssistant.setContentAssistProcessor(stringProcessor, "__python_comment");
        this.pyContentAssistant.setContentAssistProcessor(processor, "__dftl_partition_content_type");
        this.pyContentAssistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        this.pyContentAssistant.enableAutoActivation(true);
        this.pyContentAssistant.setDocumentPartitioning("__PYTHON_PARTITION_TYPE");
        this.pyContentAssistant.setAutoActivationDelay(PyCodeCompletionPreferencesPage.getAutocompleteDelay());
        return this.pyContentAssistant;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        PyCorrectionAssistant assistant = new PyCorrectionAssistant();
        PythonCorrectionProcessor processor = new PythonCorrectionProcessor(this.getEdit());
        assistant.setQuickAssistProcessor(processor);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return assistant;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return PyContentAssistant.createInformationControlCreator(sourceViewer);
    }

    private IDialogSettings getSettings(String sectionName) {
        IDialogSettings settings = PydevPlugin.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = PydevPlugin.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }

    private void setEdit(PyEdit edit) {
        this.edit = edit;
    }

    private PyEdit getEdit() {
        return this.edit;
    }

    public void updateSyntaxColorAndStyle() {
        if (this.reconciler != null) {
            this.codeScanner.updateColors();
            IPreferenceStore preferences = PydevPrefs.getChainedPrefStore();
            this.commentScanner.setStyle(preferences.getInt("COMMENT_STYLE"));
            this.commentScanner.updateColorAndStyle();
            this.stringScanner.setStyle(preferences.getInt("STRING_STYLE"));
            this.stringScanner.updateColorAndStyle();
            this.backquotesScanner.setStyle(preferences.getInt("BACKQUOTES_STYLE"));
            this.backquotesScanner.updateColorAndStyle();
        }
    }
}

