/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectEntityWithUniqueID;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.asta.Row;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AstaReader {
    private ProjectFile m_project = new ProjectFile();
    private EventManager m_eventManager = this.m_project.getEventManager();
    private static final Double COMPLETE = 100.0;
    private static final Double INCOMPLETE = 0.0;
    private static final Duration ZERO_HOURS = Duration.getInstance(0, TimeUnit.HOURS);
    private static final RelationType[] RELATION_TYPES = new RelationType[]{RelationType.FINISH_START, RelationType.START_START, RelationType.FINISH_FINISH, RelationType.START_FINISH};

    public AstaReader() {
        ProjectConfig projectConfig = this.m_project.getProjectConfig();
        projectConfig.setAutoTaskUniqueID(false);
        projectConfig.setAutoResourceUniqueID(false);
        projectConfig.setAutoCalendarUniqueID(false);
        projectConfig.setAutoWBS(false);
    }

    public ProjectFile getProject() {
        return this.m_project;
    }

    public void processProjectProperties(Row row) {
        ProjectProperties projectProperties = this.m_project.getProjectProperties();
        projectProperties.setDuration(row.getDuration("DURATIONHOURS"));
        projectProperties.setStartDate(row.getDate("STARU"));
        projectProperties.setFinishDate(row.getDate("ENE"));
        projectProperties.setName(row.getString("SHORT_NAME"));
        projectProperties.setAuthor(row.getString("PROJECT_BY"));
        projectProperties.setLastSaved(row.getDate("LAST_EDITED_DATE"));
    }

    public void processResources(List<Row> list, List<Row> list2) {
        Resource resource;
        for (Row row : list) {
            resource = this.m_project.addResource();
            resource.setType(ResourceType.WORK);
            resource.setUniqueID(row.getInteger("PERMANENT_RESOURCEID"));
            resource.setEmailAddress(row.getString("EMAIL_ADDRESS"));
            resource.setName(row.getString("NASE"));
            resource.setResourceCalendar(this.deriveResourceCalendar(row.getInteger("CALENDAV")));
            resource.setMaxUnits(row.getDouble("AVAILABILITY") * 100.0);
            resource.setIsGeneric(row.getBoolean("CREATED_AS_FOLDER"));
            resource.setInitials(this.getInitials(resource.getName()));
        }
        for (Row row : list2) {
            resource = this.m_project.addResource();
            resource.setType(ResourceType.MATERIAL);
            resource.setUniqueID(row.getInteger("CONSUMABLE_RESOURCEID"));
            resource.setCostPerUse(row.getDouble("COST_PER_USEDEFAULTSAMOUNT"));
            resource.setPeakUnits(row.getDouble("AVAILABILITY") * 100.0);
            resource.setName(row.getString("NASE"));
            resource.setResourceCalendar(this.deriveResourceCalendar(row.getInteger("CALENDAV")));
            resource.setAvailableFrom(row.getDate("AVAILABLE_FROM"));
            resource.setAvailableTo(row.getDate("AVAILABLE_TO"));
            resource.setIsGeneric(row.getBoolean("CREATED_AS_FOLDER"));
            resource.setMaterialLabel(row.getString("MEASUREMENT"));
            resource.setInitials(this.getInitials(resource.getName()));
        }
    }

    private ProjectCalendar deriveResourceCalendar(Integer n) {
        ProjectCalendar projectCalendar = this.m_project.addDefaultDerivedCalendar();
        projectCalendar.setUniqueID(this.m_project.getProjectConfig().getNextCalendarUniqueID());
        projectCalendar.setParent(this.m_project.getCalendarByUniqueID(n));
        return projectCalendar;
    }

    public void processTasks(List<Row> list, List<Row> list2, List<Row> list3) {
        Object object;
        Comparable<Integer> comparable;
        Task task;
        for (Row row : list) {
            task = this.m_project.addTask();
            comparable = row.getInteger("CALENDAU");
            object = this.m_project.getCalendarByUniqueID((Integer)comparable);
            task.setUniqueID(row.getInteger("BARID"));
            task.setStart(row.getDate("STARV"));
            task.setFinish(row.getDate("ENF"));
            task.setName(row.getString("NAMH"));
            task.setWBS("-");
            task.setCalendar((ProjectCalendar)object);
            this.m_eventManager.fireTaskReadEvent(task);
        }
        this.m_project.getChildTasks().clear();
        for (Row row : list) {
            task = this.m_project.getTaskByUniqueID(row.getInteger("BARID"));
            comparable = this.m_project.getTaskByUniqueID(row.getInteger("BAR"));
            if (comparable == null) {
                this.m_project.getChildTasks().add(task);
                continue;
            }
            this.m_project.getChildTasks().remove(task);
            ((Task)comparable).getChildTasks().add(task);
            if (!((Task)comparable).getWBS().equals("-")) continue;
            object = row.getString("WBN_CODE");
            ((Task)comparable).setWBS((String)(object == null || ((String)object).length() == 0 ? "-" : object));
        }
        for (Row row : list2) {
            task = this.m_project.getTaskByUniqueID(row.getInteger("BAR"));
            comparable = task == null ? this.m_project.addTask() : task.addTask();
            ((Task)comparable).setUniqueID(row.getInteger("TASKID"));
            ((Task)comparable).setDuration(row.getDuration("GIVEN_DURATIONHOURS"));
            ((Task)comparable).setResume(row.getDate("RESUME"));
            ((Task)comparable).setActualDuration(row.getDuration("ACTUAL_DURATIONHOURS"));
            ((Task)comparable).setEarlyStart(row.getDate("EARLY_START_DATE"));
            ((Task)comparable).setLateStart(row.getDate("LATE_START_DATE"));
            ((Task)comparable).setBaselineWork(row.getDuration("EFFORT_BUDGET"));
            ((Task)comparable).setPercentageComplete(row.getDouble("OVERALL_PERCENV_COMPLETE"));
            ((Task)comparable).setName(row.getString("NARE"));
            ((Task)comparable).setWBS(row.getString("WBN_CODE"));
            ((Task)comparable).setCalendar(this.m_project.getCalendarByUniqueID(row.getInteger("CALENDAU")));
            ((Task)comparable).setStart(row.getDate("STARZ"));
            ((Task)comparable).setFinish(row.getDate("ENJ"));
            this.processConstraints(row, (Task)comparable);
            if (((Task)comparable).getPercentageComplete().intValue() != 0) {
                ((Task)comparable).setActualStart(((Task)comparable).getStart());
                if (((Task)comparable).getPercentageComplete().intValue() == 100) {
                    ((Task)comparable).setActualFinish(((Task)comparable).getFinish());
                    ((Task)comparable).setDuration(((Task)comparable).getActualDuration());
                }
            }
            this.m_eventManager.fireTaskReadEvent((Task)comparable);
        }
        for (Row row : list3) {
            task = this.m_project.getTaskByUniqueID(row.getInteger("BAR"));
            comparable = task == null ? this.m_project.addTask() : task.addTask();
            ((Task)comparable).setMilestone(true);
            ((Task)comparable).setUniqueID(row.getInteger("MILESTONEID"));
            ((Task)comparable).setStart(row.getDate("GIVEN_DATE_TIME"));
            ((Task)comparable).setFinish(row.getDate("GIVEN_DATE_TIME"));
            ((Task)comparable).setPercentageComplete(row.getBoolean("COMPLETED") ? COMPLETE : INCOMPLETE);
            ((Task)comparable).setEarlyStart(row.getDate("EARLY_START_DATE"));
            ((Task)comparable).setLateStart(row.getDate("LATE_START_DATE"));
            ((Task)comparable).setName(row.getString("NARE"));
            ((Task)comparable).setWBS(row.getString("WBN_CODE"));
            ((Task)comparable).setCalendar(this.m_project.getCalendarByUniqueID(row.getInteger("CALENDAU")));
            ((Task)comparable).setDuration(ZERO_HOURS);
        }
        this.deriveProjectCalendar();
        this.updateStructure();
    }

    private void updateStructure() {
        int n = 1;
        Integer n2 = 1;
        for (Task task : this.m_project.getChildTasks()) {
            n = this.updateStructure(n, task, n2);
        }
    }

    private int updateStructure(int n, Task task, Integer n2) {
        task.setID(n++);
        task.setOutlineLevel(n2);
        n2 = n2 + 1;
        for (Task task2 : task.getChildTasks()) {
            n = this.updateStructure(n, task2, n2);
        }
        return n;
    }

    public void processPredecessors(List<Row> list) {
        for (Row row : list) {
            Task task = this.m_project.getTaskByUniqueID(row.getInteger("START_TASK"));
            Task task2 = this.m_project.getTaskByUniqueID(row.getInteger("END_TASK"));
            if (task == null || task2 == null) continue;
            RelationType relationType = this.getRelationType(row.getInt("TYPI"));
            Duration duration = row.getDuration("START_LAG_TIMEHOURS");
            Duration duration2 = row.getDuration("END_LAG_TIMEHOURS");
            Duration duration3 = null;
            if (duration.getDuration() != 0.0) {
                duration3 = duration;
            } else if (duration2.getDuration() != 0.0) {
                duration3 = duration2;
            }
            task2.addPredecessor(task, relationType, duration3);
        }
    }

    public void processAssignments(List<Row> list) {
        for (Row row : list) {
            Task task = this.m_project.getTaskByUniqueID(row.getInteger("ALLOCATEE_TO"));
            Resource resource = this.m_project.getResourceByUniqueID(row.getInteger("PLAYER"));
            if (task == null || resource == null) continue;
            double d = row.getDouble("PERCENT_COMPLETE");
            Duration duration = row.getWork("EFFORW");
            double d2 = duration.getDuration() * d;
            double d3 = duration.getDuration() - d2;
            ResourceAssignment resourceAssignment = task.addResourceAssignment(resource);
            resourceAssignment.setUniqueID(row.getInteger("PERMANENT_SCHEDUL_ALLOCATIONID"));
            resourceAssignment.setStart(row.getDate("STARZ"));
            resourceAssignment.setFinish(row.getDate("ENJ"));
            resourceAssignment.setUnits(row.getDouble("GIVEN_ALLOCATION") * 100.0);
            resourceAssignment.setDelay(row.getDuration("DELAAHOURS"));
            resourceAssignment.setPercentageWorkComplete(d * 100.0);
            resourceAssignment.setWork(duration);
            resourceAssignment.setActualWork(Duration.getInstance(d2, duration.getUnits()));
            resourceAssignment.setRemainingWork(Duration.getInstance(d3, duration.getUnits()));
        }
    }

    private RelationType getRelationType(int n) {
        if (n < 0 || n > RELATION_TYPES.length) {
            n = 0;
        }
        return RELATION_TYPES[n];
    }

    private String getInitials(String string) {
        String string2 = null;
        if (string != null && string.length() != 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string.charAt(0));
            int n = 1;
            while ((n = string.indexOf(32, n)) != -1) {
                if (++n < string.length() && string.charAt(n) != ' ') {
                    stringBuilder.append(string.charAt(n));
                }
                ++n;
            }
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private void deriveProjectCalendar() {
        ProjectEntityWithUniqueID projectEntityWithUniqueID22;
        HashMap hashMap = new HashMap();
        for (ProjectEntityWithUniqueID projectEntityWithUniqueID22 : this.m_project.getAllTasks()) {
            void object;
            ProjectCalendar projectCalendar = projectEntityWithUniqueID22.getCalendar();
            Integer n = (Integer)hashMap.get(projectCalendar);
            if (n == null) {
                Integer n2 = 1;
            } else {
                Integer n3 = n + 1;
            }
            hashMap.put(projectCalendar, object);
        }
        int n = 0;
        projectEntityWithUniqueID22 = null;
        for (Map.Entry entry : hashMap.entrySet()) {
            if ((Integer)entry.getValue() <= n) continue;
            n = (Integer)entry.getValue();
            projectEntityWithUniqueID22 = (ProjectCalendar)entry.getKey();
        }
        if (projectEntityWithUniqueID22 != null) {
            this.m_project.setDefaultCalendar((ProjectCalendar)projectEntityWithUniqueID22);
            for (Task task : this.m_project.getAllTasks()) {
                if (task.getCalendar() != projectEntityWithUniqueID22) continue;
                task.setCalendar(null);
            }
        }
    }

    private void processConstraints(Row row, Task task) {
        ConstraintType constraintType = ConstraintType.AS_SOON_AS_POSSIBLE;
        Date date = null;
        switch (row.getInt("CONSTRAINU")) {
            case 0: {
                if (row.getInt("PLACEMENT") == 0) {
                    constraintType = ConstraintType.AS_SOON_AS_POSSIBLE;
                    break;
                }
                constraintType = ConstraintType.AS_LATE_AS_POSSIBLE;
                break;
            }
            case 1: {
                constraintType = ConstraintType.MUST_START_ON;
                date = row.getDate("START_CONSTRAINT_DATE");
                break;
            }
            case 2: {
                constraintType = ConstraintType.START_NO_LATER_THAN;
                date = row.getDate("START_CONSTRAINT_DATE");
                break;
            }
            case 3: {
                constraintType = ConstraintType.START_NO_EARLIER_THAN;
                date = row.getDate("START_CONSTRAINT_DATE");
                break;
            }
            case 4: {
                constraintType = ConstraintType.MUST_FINISH_ON;
                date = row.getDate("END_CONSTRAINT_DATE");
                break;
            }
            case 5: {
                constraintType = ConstraintType.FINISH_NO_LATER_THAN;
                date = row.getDate("END_CONSTRAINT_DATE");
                break;
            }
            case 6: {
                constraintType = ConstraintType.FINISH_NO_EARLIER_THAN;
                date = row.getDate("END_CONSTRAINT_DATE");
                break;
            }
            case 8: {
                task.setDeadline(row.getDate("END_CONSTRAINT_DATE"));
            }
        }
        task.setConstraintType(constraintType);
        task.setConstraintDate(date);
    }

    public Map<Integer, DayType> createExceptionTypeMap(List<Row> list) {
        HashMap<Integer, DayType> hashMap = new HashMap<Integer, DayType>();
        for (Row row : list) {
            DayType dayType;
            Integer n = row.getInteger("EXCEPTIONNID");
            switch (row.getInt("UNIQUE_BIT_FIELD")) {
                case 8: 
                case 32: 
                case 128: {
                    dayType = DayType.WORKING;
                    break;
                }
                default: {
                    dayType = DayType.NON_WORKING;
                }
            }
            hashMap.put(n, dayType);
        }
        return hashMap;
    }

    public Map<Integer, Row> createWorkPatternMap(List<Row> list) {
        HashMap<Integer, Row> hashMap = new HashMap<Integer, Row>();
        for (Row row : list) {
            hashMap.put(row.getInteger("WORK_PATTERNID"), row);
        }
        return hashMap;
    }

    public Map<Integer, List<Row>> createWorkPatternAssignmentMap(List<Row> list) {
        HashMap<Integer, List<Row>> hashMap = new HashMap<Integer, List<Row>>();
        for (Row row : list) {
            Integer n = row.getInteger("WORK_PATTERN_ASSIGNMENTID");
            LinkedList<Row> linkedList = (LinkedList<Row>)hashMap.get(n);
            if (linkedList == null) {
                linkedList = new LinkedList<Row>();
                hashMap.put(n, linkedList);
            }
            linkedList.add(row);
        }
        return hashMap;
    }

    public Map<Integer, List<Row>> createExceptionAssignmentMap(List<Row> list) {
        HashMap<Integer, List<Row>> hashMap = new HashMap<Integer, List<Row>>();
        for (Row row : list) {
            Integer n = row.getInteger("EXCEPTION_ASSIGNMENTID");
            LinkedList<Row> linkedList = (LinkedList<Row>)hashMap.get(n);
            if (linkedList == null) {
                linkedList = new LinkedList<Row>();
                hashMap.put(n, linkedList);
            }
            linkedList.add(row);
        }
        return hashMap;
    }

    public Map<Integer, List<Row>> createTimeEntryMap(List<Row> list) {
        HashMap<Integer, List<Row>> hashMap = new HashMap<Integer, List<Row>>();
        for (Row row : list) {
            Integer n = row.getInteger("TIME_ENTRYID");
            LinkedList<Row> linkedList = (LinkedList<Row>)hashMap.get(n);
            if (linkedList == null) {
                linkedList = new LinkedList<Row>();
                hashMap.put(n, linkedList);
            }
            linkedList.add(row);
        }
        return hashMap;
    }

    public void processCalendar(Row row, Map<Integer, Row> map, Map<Integer, List<Row>> map2, Map<Integer, List<Row>> map3, Map<Integer, List<Row>> map4, Map<Integer, DayType> map5) {
        Object object;
        Comparable<Integer> comparable;
        ProjectCalendar projectCalendar = this.m_project.addCalendar();
        Integer n = row.getInteger("DOMINANT_WORK_PATTERN");
        projectCalendar.setUniqueID(row.getInteger("CALENDARID"));
        this.processWorkPattern(projectCalendar, n, map, map4, map5);
        projectCalendar.setName(row.getString("NAMK"));
        List<Row> list = map2.get(projectCalendar.getUniqueID());
        if (list != null) {
            for (Row row2 : list) {
                comparable = row2.getInteger("WORK_PATTERN");
                if (comparable.equals(n)) continue;
                object = projectCalendar.addWorkWeek();
                ((ProjectCalendarWeek)object).setDateRange(new DateRange(row2.getDate("START_DATE"), row2.getDate("END_DATE")));
                this.processWorkPattern((ProjectCalendarWeek)object, row2.getInteger("WORK_PATTERN"), map, map4, map5);
            }
        }
        if ((list = map3.get(projectCalendar.getUniqueID())) != null) {
            for (Row row2 : list) {
                comparable = row2.getDate("STARU_DATE");
                object = row2.getDate("ENE_DATE");
                projectCalendar.addCalendarException((Date)comparable, (Date)object);
            }
        }
        this.m_eventManager.fireCalendarReadEvent(projectCalendar);
    }

    private void processWorkPattern(ProjectCalendarWeek projectCalendarWeek, Integer n, Map<Integer, Row> map, Map<Integer, List<Row>> map2, Map<Integer, DayType> map3) {
        projectCalendarWeek.setName(map.get(n).getString("NAMN"));
        List<Row> list = map2.get(n);
        long l = Long.MIN_VALUE;
        Day day = Day.SUNDAY;
        ProjectCalendarHours projectCalendarHours = projectCalendarWeek.addCalendarHours(day);
        Arrays.fill(projectCalendarWeek.getDays(), DayType.NON_WORKING);
        for (Row row : list) {
            Object object;
            Date date = row.getDate("START_TIME");
            Date date2 = row.getDate("END_TIME");
            if (date.getTime() > date2.getTime()) {
                object = Calendar.getInstance();
                ((Calendar)object).setTime(date2);
                ((Calendar)object).add(6, 1);
                date2 = ((Calendar)object).getTime();
            }
            if (date.getTime() < l) {
                day = day.getNextDay();
                projectCalendarHours = projectCalendarWeek.addCalendarHours(day);
            }
            if ((object = map3.get(row.getInteger("EXCEPTIOP"))) == DayType.WORKING) {
                projectCalendarHours.addRange(new DateRange(date, date2));
                projectCalendarWeek.setWorkingDay(day, DayType.WORKING);
            }
            l = date2.getTime();
        }
    }
}

