'use strict';

const common = require('../../common');
const binding = require('./build/Release/binding');
const assert = require('assert');

const skipMessage =
  '1..0 # Skipped: intensive toString tests due to memory confinements';
if (!common.enoughTestMem) {
  console.log(skipMessage);
  return;
}

// v8 fails silently if string length > v8::String::kMaxLength
// v8::String::kMaxLength defined in v8.h
const kStringMaxLength = process.binding('buffer').kStringMaxLength;

try {
  var buf = new Buffer(kStringMaxLength + 2);
} catch (e) {
  // If the exception is not due to memory confinement then rethrow it.
  if (e.message !== 'Invalid array buffer length') throw (e);
  console.log(skipMessage);
  return;
}

// Ensure we have enough memory available for future allocations to succeed.
if (!binding.ensureAllocation(2 * kStringMaxLength)) {
  console.log(skipMessage);
  return;
}

const maxString = buf.toString('utf16le');
assert.equal(maxString.length, (kStringMaxLength + 2) / 2);
