# Node Foundation TSC Meeting 2015-10-07

## Links

* **Audio Recording**: https://soundcloud.com/node-foundation/tsc-meeting-2015-10-07
* **GitHub Issue**: https://github.com/nodejs/node/issues/3126
* **Minutes Google Doc**: https://docs.google.com/document/d/1LIrTCdTUjKtb_GGecrJ3Es0rPOpVdpkV5kefJ_p5FGU
* _Previous Minutes Google Doc: <https://docs.google.com/document/d/1RkLAWTIrhD3BTB2rs9_FahWI0C7lt9F8xnQXaueJPIE>_

## Present

* Rod Vagg (TSC)
* Brian White (TSC)
* Steven Loomis (observer)
* Trevor Norris (TSC)
* Shigeki Ohtsu (TSC)
* Ben Noordhuis (TSC)
* Mikeal Rogers (observer)
* Michael Dawson (observer)
* Seth Thompson (observer)
* Jeremiah Senkpiel (TSC)

## Agenda

Extracted from **tsc-agenda** labelled issues and pull requests in the nodejs org prior to meeting.

### nodejs/node

* WG: Considering a new HTTP WG [#3214](https://github.com/nodejs/node/issues/3214)
* lib,test: deprecate _linklist [#3078](https://github.com/nodejs/node/pull/3078)
* Discussion: LTS & v5 release planning [#3000](https://github.com/nodejs/node/issues/3000)
* Compiling node v4.0.0 with OpenSSL 1.0.1 fails [#2783](https://github.com/nodejs/node/issues/2783)
* Inspecting Node.js with Chrome DevTools [#2546](https://github.com/nodejs/node/issues/2546)

### nodejs/TSC

* Umbrella Program [#2](https://github.com/nodejs/TSC/pull/2)

## Minutes

### Standup

* Rod Vagg: 4.1.2 release, security procedures surrounding that
* Brian White: Working on javascript dns resolver, regular PR + Issue work.
* Steven Loomis: Working on ICU 56 Release. TC 39 & emca spec work for Intl WG. Working on Intl build issues.
* Trevor Norris: Focused on fixing async_wrap, writing tests and preparing for it to become more official
* Shigeki Ohtsu: No works for node project, I spent all time to my internal works.
* Ben Noordhuis: Nothing to report—the usual
* Mikeal Rogers: Looking into stalled Wgs and seeing how to help out. Working on the umbrella program. Lots of conference things.
* Michael Dawson: Added a benchmarking machine to the CI, working on some tests issues. Working on PPC for the CI.
* Seth Thompson: Working on v8 4.7, scheduled soon
* Jeremiah Senkpiel: vacation, some issue catch-up

### Review of previous meeting

* Discussion: LTS & v5 release planning [#3000](https://github.com/nodejs/node/issues/3000)
* Inspecting Node.js with Chrome DevTools [#2546](https://github.com/nodejs/node/issues/2546)
* Umbrella Program [#2](https://github.com/nodejs/TSC/pull/2)
* renaming of “language groups” from iojs-\* to nodejs-\* [#2525](https://github.com/nodejs/node/issues/2525)


### WG: Considering a new HTTP WG [#3214](https://github.com/nodejs/node/issues/3214)

* Discussed the HTTP WG based on James’ comments @ https://github.com/nodejs/node/issues/3234#issuecomment-146293038
* Generally positive, only concerns are regarding decision making power—TSC may not want to hand that off as this is not quite like Streams (in that few people grok the code!) and there are philosophical questions to be resolved about HTTP that the TSC should be involved in.

### lib,test: deprecate _linklist [#3078](https://github.com/nodejs/node/pull/3078)

* Userland modules exist that could be used instead
* Ben suggested straight removal, Jeramiah raised the matter of process that we have committed to adding a warning before removal, so we could remove in v6 but probably shouldn’t in v5
* No disagreement with moving forward for deprecation

### Discussion: LTS & v5 release planning [#3000](https://github.com/nodejs/node/issues/3000)

* Recap of the latest LTS meeting [LTS#43](https://github.com/nodejs/LTS/issues/43)
* Aim to have LTS / v4.2.0 out tomorrow, backup date of Monday if we miss that. LTS starts then for v4.x, v5.x has to wait until V8 4.6 to be stable mid to late October.

### Compiling node v4.0.0 with OpenSSL 1.0.1 fails [#2783](https://github.com/nodejs/node/issues/2783)

* Shigeki, Ben: It would be quite hard to support 1.0.1 since we are using 1.0.2 APIs.

* Discussion on the possible difficulty of using 1.0.2 on varied Linux distros

* ubuntu wily (not released) seems to use 1.0.2 - work has been done to package.  1.0.2 is only in Wily - https://launchpad.net/ubuntu/+source/openssl/1.0.2d-0ubuntu1 - https://answers.launchpad.net/ubuntu/+source/openssl/+question/263725 - “My guess is that we will see openssl 1.0.2 from Ubuntu 15.10 onwards (or eventually only starting with 16.04)”

* Concern that allowing 1.0.1 would result in a substandard (insecure?) & untested binary.

* Some discussion about the fact that we don’t test building with shared / static dependencies

* feedback to issue: No appetite to do the work from the TSC, maybe someone could do it but we wouldn’t support.

### Inspecting Node.js with Chrome DevTools [#2546](https://github.com/nodejs/node/issues/2546)

_skipped discussion_

### Umbrella Program [#2](https://github.com/nodejs/TSC/pull/2)

_skipped discussion_

## Next Meeting

October 14th, 2015
