/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.SSLContext;
import org.jruby.ext.openssl.SSLSession;
import org.jruby.ext.openssl.SSLSocket;
import org.jruby.ext.openssl.Utils;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.SafePropertyAccessor;

public class SSL {
    public static final int VERIFY_NONE = 0;
    public static final int VERIFY_PEER = 1;
    public static final int VERIFY_FAIL_IF_NO_PEER_CERT = 2;
    public static final int VERIFY_CLIENT_ONCE = 4;
    public static final long OP_ALL = 4095L;
    public static final long OP_NO_TICKET = 16384L;
    public static final long OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION = 65536L;
    public static final long OP_SINGLE_ECDH_USE = 524288L;
    public static final long OP_SINGLE_DH_USE = 0x100000L;
    public static final long OP_EPHEMERAL_RSA = 0x200000L;
    public static final long OP_CIPHER_SERVER_PREFERENCE = 0x400000L;
    public static final long OP_TLS_ROLLBACK_BUG = 0x800000L;
    public static final long OP_NO_SSLv2 = 0x1000000L;
    public static final long OP_NO_SSLv3 = 0x2000000L;
    public static final long OP_NO_TLSv1 = 0x4000000L;
    public static final long OP_PKCS1_CHECK_1 = 0x8000000L;
    public static final long OP_PKCS1_CHECK_2 = 0x10000000L;
    public static final long OP_NETSCAPE_CA_DN_BUG = 0x20000000L;
    public static final long OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG = 0x40000000L;
    private static final String JSSE_TLS_ephemeralDHKeySize = "jdk.tls.ephemeralDHKeySize";
    private static final String JSSE_TLS_ephemeralDHKeySize_default = "matched";
    private static final String JSSE_TLS_disabledAlgorithms = "jdk.tls.disabledAlgorithms";
    private static final String JSSE_TLS_disabledAlgorithms_default = "SSLv3, DHE";
    private static final boolean waitErrorBacktrace;

    private static void configureJSSE() {
        if (OpenSSL.javaVersion8(true)) {
            try {
                if (System.getProperty(JSSE_TLS_ephemeralDHKeySize) == null) {
                    System.setProperty(JSSE_TLS_ephemeralDHKeySize, JSSE_TLS_ephemeralDHKeySize_default);
                }
            }
            catch (SecurityException ex) {
                OpenSSL.debug("setting jdk.tls.ephemeralDHKeySize failed: " + ex);
            }
        } else {
            try {
                if (System.getProperty(JSSE_TLS_disabledAlgorithms) == null) {
                    System.setProperty(JSSE_TLS_disabledAlgorithms, JSSE_TLS_disabledAlgorithms_default);
                }
            }
            catch (SecurityException se) {
                OpenSSL.debug("setting jdk.tls.disabledAlgorithms failed: " + se);
            }
        }
    }

    static RaiseException handleCouldNotGenerateDHKeyPairError(Ruby runtime, RuntimeException ex) {
        String message = ex.getMessage();
        if (OpenSSL.javaHotSpot() || OpenSSL.javaOpenJDK()) {
            if (OpenSSL.javaVersion8(false)) {
                message = message + " (try disabling DHE using -Djdk.tls.disabledAlgorithms as only keys of size 1024/2048 are supported in Java 8)";
            } else if (!OpenSSL.javaVersion8(true)) {
                message = message + " (try disabling DHE using -Djdk.tls.disabledAlgorithms as prior to Java 8 only keys of size < 1024 are supported)";
            }
        }
        return SSL.newSSLError(runtime, message, ex);
    }

    public static void createSSL(Ruby runtime, RubyModule OpenSSL2) {
        IRubyObject WaitWritable;
        RubyModule SSL2 = OpenSSL2.defineModuleUnder("SSL");
        RubyClass OpenSSLError = OpenSSL2.getClass("OpenSSLError");
        RubyClass SSLError = SSL2.defineClassUnder("SSLError", OpenSSLError, OpenSSLError.getAllocator());
        IRubyObject WaitReadable = runtime.getIO().getConstantAt("WaitReadable");
        if (WaitReadable != null) {
            SSL2.defineClassUnder("SSLErrorWaitReadable", SSLError, OpenSSLError.getAllocator()).include(new IRubyObject[]{WaitReadable});
        }
        if ((WaitWritable = runtime.getIO().getConstantAt("WaitWritable")) != null) {
            SSL2.defineClassUnder("SSLErrorWaitWritable", SSLError, OpenSSLError.getAllocator()).include(new IRubyObject[]{WaitWritable});
        }
        SSL2.setConstant("VERIFY_NONE", (IRubyObject)runtime.newFixnum(0));
        SSL2.setConstant("VERIFY_PEER", (IRubyObject)runtime.newFixnum(1));
        SSL2.setConstant("VERIFY_FAIL_IF_NO_PEER_CERT", (IRubyObject)runtime.newFixnum(2));
        SSL2.setConstant("VERIFY_CLIENT_ONCE", (IRubyObject)runtime.newFixnum(4));
        SSL2.setConstant("OP_ALL", (IRubyObject)runtime.newFixnum(4095L));
        SSL2.setConstant("OP_NO_TICKET", (IRubyObject)runtime.newFixnum(16384L));
        SSL2.setConstant("OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION", (IRubyObject)runtime.newFixnum(65536L));
        SSL2.setConstant("OP_SINGLE_ECDH_USE", (IRubyObject)runtime.newFixnum(524288L));
        SSL2.setConstant("OP_SINGLE_DH_USE", (IRubyObject)runtime.newFixnum(0x100000L));
        SSL2.setConstant("OP_EPHEMERAL_RSA", (IRubyObject)runtime.newFixnum(0x200000L));
        SSL2.setConstant("OP_CIPHER_SERVER_PREFERENCE", (IRubyObject)runtime.newFixnum(0x400000L));
        SSL2.setConstant("OP_TLS_ROLLBACK_BUG", (IRubyObject)runtime.newFixnum(0x800000L));
        SSL2.setConstant("OP_NO_SSLv2", (IRubyObject)runtime.newFixnum(0x1000000L));
        SSL2.setConstant("OP_NO_SSLv3", (IRubyObject)runtime.newFixnum(0x2000000L));
        SSL2.setConstant("OP_NO_TLSv1", (IRubyObject)runtime.newFixnum(0x4000000L));
        SSL2.setConstant("OP_PKCS1_CHECK_1", (IRubyObject)runtime.newFixnum(0x8000000L));
        SSL2.setConstant("OP_PKCS1_CHECK_2", (IRubyObject)runtime.newFixnum(0x10000000L));
        SSL2.setConstant("OP_NETSCAPE_CA_DN_BUG", (IRubyObject)runtime.newFixnum(0x20000000L));
        SSL2.setConstant("OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG", (IRubyObject)runtime.newFixnum(0x40000000L));
        SSLContext.createSSLContext(runtime, SSL2);
        SSLSocket.createSSLSocket(runtime, SSL2);
        SSLSession.createSession(runtime, SSL2);
        SSL.createSocketForwarder(SSL2);
        SSL.createNonblock(SSL2);
    }

    public static RaiseException newSSLError(Ruby runtime, Exception ex) {
        return Utils.newError(runtime, SSL._SSL(runtime).getClass("SSLError"), ex);
    }

    public static RaiseException newSSLError(Ruby runtime, String message) {
        return Utils.newError(runtime, SSL._SSL(runtime).getClass("SSLError"), message, false);
    }

    private static RaiseException newSSLError(Ruby runtime, String message, Exception ex) {
        return Utils.newError(runtime, SSL._SSL(runtime).getClass("SSLError"), message, ex);
    }

    public static RaiseException newSSLErrorWaitReadable(Ruby runtime, String message) {
        return SSL.newCustomSSLError(runtime, "SSLErrorWaitReadable", message);
    }

    public static RaiseException newSSLErrorWaitWritable(Ruby runtime, String message) {
        return SSL.newCustomSSLError(runtime, "SSLErrorWaitWritable", message);
    }

    private static RaiseException newCustomSSLError(Ruby runtime, String name2, String message) {
        RubyClass errorClass = SSL._SSL(runtime).getClass(name2);
        if (errorClass == null) {
            errorClass = SSL._SSL(runtime).getClass("SSLError");
        }
        if (waitErrorBacktrace) {
            return Utils.newError(runtime, errorClass, message, false);
        }
        return Utils.newErrorWithoutTrace(runtime, errorClass, message, false);
    }

    static RubyModule _SSL(Ruby runtime) {
        return (RubyModule)runtime.getModule("OpenSSL").getConstant("SSL");
    }

    private static RubyModule createSocketForwarder(RubyModule SSL2) {
        RubyModule SocketForwarder2 = SSL2.defineModuleUnder("SocketForwarder");
        SocketForwarder2.defineAnnotatedMethods(SocketForwarder.class);
        return SocketForwarder2;
    }

    private static RubyModule createNonblock(RubyModule SSL2) {
        RubyModule Nonblock2 = SSL2.defineModuleUnder("Nonblock");
        Nonblock2.defineAnnotatedMethods(Nonblock.class);
        return Nonblock2;
    }

    static {
        SSL.configureJSSE();
        waitErrorBacktrace = SafePropertyAccessor.getBoolean((String)"jruby.openssl.ssl.error_wait_nonblock.backtrace", (boolean)false);
    }

    @JRubyModule(name={"OpenSSL::SSL::Nonblock"})
    public static class Nonblock {
        @JRubyMethod(rest=true, frame=true)
        public static IRubyObject initialize(ThreadContext context2, IRubyObject self, IRubyObject[] args) {
            Ruby runtime = context2.runtime;
            IRubyObject flag = runtime.getFile().getConstant("NONBLOCK");
            IRubyObject Fcntl = runtime.getObject().getConstantAt("Fcntl");
            if (Fcntl instanceof RubyModule) {
                IRubyObject io2 = self.getInstanceVariables().getInstanceVariable("@io");
                RubyClass ioClass = self.getMetaClass();
                DynamicMethod fcntl2 = ioClass.searchMethod("fcntl");
                IRubyObject F_GETFL = ((RubyModule)Fcntl).getConstantAt("F_GETFL");
                if (F_GETFL != null) {
                    flag = Nonblock.or(context2, flag, fcntl2.call(context2, io2, (RubyModule)ioClass, "fcntl", F_GETFL));
                }
                IRubyObject F_SETFL = ((RubyModule)Fcntl).getConstant("F_SETFL");
                fcntl2.call(context2, io2, (RubyModule)ioClass, "fcntl", new IRubyObject[]{F_SETFL, flag});
            }
            return Utils.invokeSuper(context2, self, args, Block.NULL_BLOCK);
        }

        private static IRubyObject or(ThreadContext context2, IRubyObject flag, IRubyObject flags) {
            if (flag instanceof RubyFixnum && flags instanceof RubyFixnum) {
                long f = ((RubyFixnum)flag).getLongValue();
                long fs = ((RubyFixnum)flags).getLongValue();
                return RubyFixnum.newFixnum((Ruby)context2.runtime, (long)(f | fs));
            }
            return flag.callMethod(context2, "|", flags);
        }
    }

    @JRubyModule(name={"OpenSSL::SSL::SocketForwarder"})
    public static class SocketForwarder {
        @JRubyMethod
        public static IRubyObject addr(ThreadContext context2, IRubyObject self) {
            return SocketForwarder.to_io(context2, self).callMethod(context2, "addr");
        }

        @JRubyMethod
        public static IRubyObject peeraddr(ThreadContext context2, IRubyObject self) {
            return SocketForwarder.to_io(context2, self).callMethod(context2, "peeraddr");
        }

        @JRubyMethod(name={"closed?"})
        public static IRubyObject closed_p(ThreadContext context2, IRubyObject self) {
            return SocketForwarder.to_io(context2, self).callMethod(context2, "closed?");
        }

        @JRubyMethod
        public static IRubyObject getsockopt(ThreadContext context2, IRubyObject self, IRubyObject level, IRubyObject optname) {
            return SocketForwarder.to_io(context2, self).callMethod(context2, "getsockopt", new IRubyObject[]{level, optname});
        }

        @JRubyMethod
        public static IRubyObject setsockopt(ThreadContext context2, IRubyObject self, IRubyObject level, IRubyObject optname, IRubyObject optval) {
            return SocketForwarder.to_io(context2, self).callMethod(context2, "setsockopt", new IRubyObject[]{level, optname, optval});
        }

        @JRubyMethod(name={"do_not_reverse_lookup="})
        public static IRubyObject do_not_reverse_lookup_eq(ThreadContext context2, IRubyObject self, IRubyObject flag) {
            return SocketForwarder.to_io(context2, self).callMethod(context2, "do_not_reverse_lookup=", flag);
        }

        @JRubyMethod(rest=true)
        public static IRubyObject fcntl(ThreadContext context2, IRubyObject self, IRubyObject[] args) {
            return SocketForwarder.to_io(context2, self).callMethod(context2, "fcntl", args);
        }

        private static IRubyObject to_io(ThreadContext context2, IRubyObject self) {
            return self.callMethod(context2, "to_io");
        }
    }
}

