/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.text;

import com.sun.star.awt.Size;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyState;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.document.XDocumentPropertiesSupplier;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XLoadable;
import com.sun.star.frame.XModule;
import com.sun.star.frame.XStorable;
import com.sun.star.frame.XTerminateListener;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.XStyle;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.task.XStatusIndicator;
import com.sun.star.task.XStatusIndicatorFactory;
import com.sun.star.text.XSimpleText;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.XModifiable;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.document.OfficeDocument;
import com.sun.star.wizards.text.TextFieldHandler;
import com.sun.star.wizards.text.ViewHandler;

public class TextDocument {
    public XComponent xComponent;
    public XTextDocument xTextDocument;
    public XStatusIndicator xProgressBar;
    public XFrame xFrame;
    public XText xText;
    public XMultiServiceFactory xMSFDoc;
    public XMultiServiceFactory xMSF;
    public XWindowPeer xWindowPeer;

    public TextDocument(XMultiServiceFactory xMultiServiceFactory, String string, boolean bl, XTerminateListener xTerminateListener) {
        this.xMSF = xMultiServiceFactory;
        this.xFrame = OfficeDocument.createNewFrame(xMultiServiceFactory, xTerminateListener);
        this.xTextDocument = this.loadAsPreview(string, true);
        this.xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.xTextDocument);
        if (bl) {
            this.showStatusIndicator();
        }
        this.init();
    }

    public TextDocument(XMultiServiceFactory xMultiServiceFactory, ModuleIdentifier moduleIdentifier, boolean bl) {
        this.xMSF = xMultiServiceFactory;
        try {
            this.xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)xMultiServiceFactory.createInstance("com.sun.star.text.TextDocument"));
            XLoadable xLoadable = (XLoadable)UnoRuntime.queryInterface(XLoadable.class, (Object)this.xTextDocument);
            xLoadable.initNew();
            XModule xModule = (XModule)UnoRuntime.queryInterface(XModule.class, (Object)this.xTextDocument);
            xModule.setIdentifier(moduleIdentifier.getIdentifier());
            XDesktop xDesktop = Desktop.getDesktop(xMultiServiceFactory);
            XComponentLoader xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)xDesktop);
            PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue("Model", -1, (Object)this.xTextDocument, PropertyState.DIRECT_VALUE)};
            xComponentLoader.loadComponentFromURL("private:object", "_blank", 0, propertyValueArray);
            this.xFrame = this.xTextDocument.getCurrentController().getFrame();
            this.xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.xTextDocument);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            this.showStatusIndicator();
        }
        this.init();
    }

    public TextDocument(XMultiServiceFactory xMultiServiceFactory, XTextDocument xTextDocument, boolean bl) {
        XStatusIndicatorFactory xStatusIndicatorFactory;
        this.xMSF = xMultiServiceFactory;
        this.xFrame = xTextDocument.getCurrentController().getFrame();
        this.xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xTextDocument);
        this.xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)this.xComponent);
        if (bl) {
            xStatusIndicatorFactory = (XStatusIndicatorFactory)UnoRuntime.queryInterface(XStatusIndicatorFactory.class, (Object)this.xFrame);
            this.xProgressBar = xStatusIndicatorFactory.createStatusIndicator();
            this.xProgressBar.start(PropertyNames.EMPTY_STRING, 100);
            this.xProgressBar.setValue(5);
        }
        this.xWindowPeer = (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.xFrame.getComponentWindow());
        this.xMSFDoc = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDocument);
        UnoRuntime.queryInterface(XNumberFormatsSupplier.class, (Object)this.xTextDocument);
        xStatusIndicatorFactory = (XDocumentPropertiesSupplier)UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)this.xTextDocument);
        xStatusIndicatorFactory.getDocumentProperties();
        Helper.getUnoStructValue(this.xComponent, "CharLocale");
        this.xText = this.xTextDocument.getText();
    }

    private void init() {
        this.xWindowPeer = (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.xFrame.getComponentWindow());
        this.xMSFDoc = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDocument);
        UnoRuntime.queryInterface(XNumberFormatsSupplier.class, (Object)this.xTextDocument);
        XDocumentPropertiesSupplier xDocumentPropertiesSupplier = (XDocumentPropertiesSupplier)UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)this.xTextDocument);
        xDocumentPropertiesSupplier.getDocumentProperties();
        Helper.getUnoStructValue(this.xComponent, "CharLocale");
        UnoRuntime.queryInterface(XStorable.class, (Object)this.xTextDocument);
        this.xText = this.xTextDocument.getText();
    }

    private void showStatusIndicator() {
        XStatusIndicatorFactory xStatusIndicatorFactory = (XStatusIndicatorFactory)UnoRuntime.queryInterface(XStatusIndicatorFactory.class, (Object)this.xFrame);
        this.xProgressBar = xStatusIndicatorFactory.createStatusIndicator();
        this.xProgressBar.start(PropertyNames.EMPTY_STRING, 100);
        this.xProgressBar.setValue(5);
    }

    private XTextDocument loadAsPreview(String string, boolean bl) {
        Object object;
        PropertyValue[] propertyValueArray = new PropertyValue[3];
        propertyValueArray[0] = new PropertyValue();
        propertyValueArray[0].Name = PropertyNames.READ_ONLY;
        propertyValueArray[0].Value = Boolean.TRUE;
        propertyValueArray[1] = new PropertyValue();
        propertyValueArray[1].Name = "AsTemplate";
        propertyValueArray[1].Value = bl ? Boolean.TRUE : Boolean.FALSE;
        propertyValueArray[2] = new PropertyValue();
        propertyValueArray[2].Name = "Preview";
        propertyValueArray[2].Value = Boolean.TRUE;
        if (this.xTextDocument != null) {
            try {
                object = (XModifiable)UnoRuntime.queryInterface(XModifiable.class, (Object)this.xTextDocument);
                object.setModified(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace(System.err);
            }
        }
        object = OfficeDocument.load((XInterface)this.xFrame, string, "_self", propertyValueArray);
        this.xTextDocument = (XTextDocument)object;
        this.getPageSize();
        this.xMSFDoc = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDocument);
        ViewHandler viewHandler = new ViewHandler(this.xTextDocument);
        try {
            viewHandler.setViewSetting("ZoomType", (short)2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TextFieldHandler textFieldHandler = new TextFieldHandler(this.xMSF, this.xTextDocument);
        textFieldHandler.updateDocInfoFields();
        return this.xTextDocument;
    }

    private Size getPageSize() {
        try {
            XStyleFamiliesSupplier xStyleFamiliesSupplier = (XStyleFamiliesSupplier)UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)this.xTextDocument);
            XNameAccess xNameAccess = null;
            xNameAccess = xStyleFamiliesSupplier.getStyleFamilies();
            XNameContainer xNameContainer = null;
            xNameContainer = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)xNameAccess.getByName("PageStyles"));
            XStyle xStyle = (XStyle)UnoRuntime.queryInterface(XStyle.class, (Object)xNameContainer.getByName("First Page"));
            return (Size)Helper.getUnoPropertyValue(xStyle, "Size");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static XTextCursor createTextCursor(Object object) {
        XSimpleText xSimpleText = (XSimpleText)UnoRuntime.queryInterface(XSimpleText.class, (Object)object);
        return xSimpleText.createTextCursor();
    }

    public void unlockallControllers() {
        while (this.xTextDocument.hasControllersLocked()) {
            this.xTextDocument.unlockControllers();
        }
    }

    public static class ModuleIdentifier {
        private final String m_identifier;

        private final String getIdentifier() {
            return this.m_identifier;
        }

        public ModuleIdentifier(String string) {
            this.m_identifier = string;
        }
    }
}

