/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.language.arguments.ReadUserKeywordsHashNode;
import org.jruby.truffle.language.arguments.RubyArguments;

public class ReadRestArgumentNode
extends RubyNode {
    private final int startIndex;
    private final int indexFromCount;
    private final boolean keywordArguments;
    private final BranchProfile noArgumentsLeftProfile = BranchProfile.create();
    private final BranchProfile subsetOfArgumentsProfile = BranchProfile.create();
    @Node.Child
    private ReadUserKeywordsHashNode readUserKeywordsHashNode;
    @Node.Child
    private SnippetNode snippetNode = new SnippetNode();

    public ReadRestArgumentNode(RubyContext context, SourceSection sourceSection, int startIndex, int indexFromCount, boolean keywordArguments, int minimumForKWargs) {
        super(context, sourceSection);
        this.startIndex = startIndex;
        this.indexFromCount = indexFromCount;
        this.keywordArguments = keywordArguments;
        if (keywordArguments) {
            this.readUserKeywordsHashNode = new ReadUserKeywordsHashNode(minimumForKWargs);
        }
    }

    @Override
    public Object execute(VirtualFrame frame) {
        int resultLength;
        Object[] resultStore;
        Object[] arguments;
        Object lastArgument;
        int endIndex = RubyArguments.getArgumentsCount(frame) - this.indexFromCount;
        if (this.keywordArguments && RubyGuards.isRubyHash(lastArgument = RubyArguments.getArgument(frame, RubyArguments.getArgumentsCount(frame) - 1))) {
            --endIndex;
        }
        int length = endIndex - this.startIndex;
        if (this.startIndex == 0) {
            resultStore = arguments = RubyArguments.getArguments(frame);
            resultLength = length;
        } else if (this.startIndex >= endIndex) {
            this.noArgumentsLeftProfile.enter();
            resultStore = null;
            resultLength = 0;
        } else {
            this.subsetOfArgumentsProfile.enter();
            arguments = RubyArguments.getArguments(frame);
            resultStore = ArrayUtils.extractRange(arguments, this.startIndex, endIndex);
            resultLength = length;
        }
        DynamicObject rest = Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), resultStore, resultLength);
        if (this.keywordArguments) {
            CompilerDirectives.bailout("Ruby keyword arguments not optimized yet");
            Object kwargsHash = this.readUserKeywordsHashNode.execute(frame);
            if (kwargsHash == null) {
                kwargsHash = this.nil();
            }
            this.snippetNode.execute(frame, "Truffle.add_rejected_kwargs_to_rest(rest, kwargs)", "rest", rest, "kwargs", kwargsHash);
        }
        return rest;
    }
}

