/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.printf;

import com.oracle.truffle.api.object.DynamicObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.antlr.v4.runtime.Token;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.LiteralFormatNode;
import org.jruby.truffle.core.format.control.SequenceNode;
import org.jruby.truffle.core.format.convert.ToDoubleWithCoercionNodeGen;
import org.jruby.truffle.core.format.convert.ToIntegerNodeGen;
import org.jruby.truffle.core.format.convert.ToStringNodeGen;
import org.jruby.truffle.core.format.format.FormatFloatHumanReadableNodeGen;
import org.jruby.truffle.core.format.format.FormatFloatNodeGen;
import org.jruby.truffle.core.format.format.FormatIntegerNodeGen;
import org.jruby.truffle.core.format.printf.PrintfParser;
import org.jruby.truffle.core.format.printf.PrintfParserBaseListener;
import org.jruby.truffle.core.format.read.SourceNode;
import org.jruby.truffle.core.format.read.array.ReadHashValueNodeGen;
import org.jruby.truffle.core.format.read.array.ReadIntegerNodeGen;
import org.jruby.truffle.core.format.read.array.ReadStringNodeGen;
import org.jruby.truffle.core.format.read.array.ReadValueNodeGen;
import org.jruby.truffle.core.format.write.bytes.WriteByteNodeGen;
import org.jruby.truffle.core.format.write.bytes.WriteBytesNodeGen;
import org.jruby.truffle.core.format.write.bytes.WritePaddedBytesNodeGen;
import org.jruby.truffle.core.rope.CodeRange;

public class PrintfTreeBuilder
extends PrintfParserBaseListener {
    public static final int PADDING_FROM_ARGUMENT = -2;
    public static final int DEFAULT = -1;
    private final RubyContext context;
    private final byte[] source;
    private final List<FormatNode> sequence = new ArrayList<FormatNode>();
    private static final byte[] EMPTY_BYTES = new byte[0];

    public PrintfTreeBuilder(RubyContext context, byte[] source) {
        this.context = context;
        this.source = source;
    }

    @Override
    public void exitEscaped(PrintfParser.EscapedContext ctx) {
        this.sequence.add(WriteByteNodeGen.create(this.context, new LiteralFormatNode(this.context, (byte)37)));
    }

    @Override
    public void exitString(PrintfParser.StringContext ctx) {
        byte[] keyBytes = this.tokenAsBytes(ctx.CURLY_KEY().getSymbol(), 1);
        DynamicObject key = this.context.getSymbolTable().getSymbol(this.context.getRopeTable().getRope(keyBytes, (Encoding)USASCIIEncoding.INSTANCE, CodeRange.CR_7BIT));
        this.sequence.add(WriteBytesNodeGen.create(this.context, ToStringNodeGen.create(this.context, true, "to_s", false, EMPTY_BYTES, ReadHashValueNodeGen.create(this.context, key, new SourceNode()))));
    }

    @Override
    public void exitFormat(PrintfParser.FormatContext ctx) {
        FormatNode node;
        FormatNode valueNode;
        int width = ctx.width != null ? Integer.parseInt(ctx.width.getText()) : -1;
        boolean leftJustified = false;
        int spacePadding = -1;
        int zeroPadding = -1;
        for (int n = 0; n < ctx.flag().size(); ++n) {
            PrintfParser.FlagContext flag = ctx.flag(n);
            if (flag.MINUS() != null) {
                leftJustified = true;
                continue;
            }
            if (flag.SPACE() != null) {
                if (n + 1 < ctx.flag().size() && ctx.flag(n + 1).STAR() != null) {
                    spacePadding = -2;
                    continue;
                }
                spacePadding = width;
                continue;
            }
            if (flag.ZERO() != null) {
                if (n + 1 < ctx.flag().size() && ctx.flag(n + 1).STAR() != null) {
                    zeroPadding = -2;
                    continue;
                }
                zeroPadding = width;
                continue;
            }
            if (flag.STAR() != null) continue;
            throw new UnsupportedOperationException();
        }
        if (spacePadding == -1 && zeroPadding == -1) {
            spacePadding = width;
        }
        char type = ctx.TYPE().getSymbol().getText().charAt(0);
        if (ctx.ANGLE_KEY() == null) {
            valueNode = ReadValueNodeGen.create(this.context, new SourceNode());
        } else {
            byte[] keyBytes = this.tokenAsBytes(ctx.ANGLE_KEY().getSymbol(), 1);
            DynamicObject key = this.context.getSymbolTable().getSymbol(this.context.getRopeTable().getRope(keyBytes, (Encoding)USASCIIEncoding.INSTANCE, CodeRange.CR_7BIT));
            valueNode = ReadHashValueNodeGen.create(this.context, key, new SourceNode());
        }
        int precision = ctx.precision != null ? Integer.parseInt(ctx.precision.getText()) : -1;
        switch (type) {
            case 'p': 
            case 's': {
                String conversionMethodName = type == 's' ? "to_s" : "inspect";
                FormatNode conversionNode = ctx.ANGLE_KEY() == null ? ReadStringNodeGen.create(this.context, true, conversionMethodName, false, EMPTY_BYTES, new SourceNode()) : ToStringNodeGen.create(this.context, true, conversionMethodName, false, EMPTY_BYTES, valueNode);
                if (spacePadding == -1) {
                    node = WriteBytesNodeGen.create(this.context, conversionNode);
                    break;
                }
                node = WritePaddedBytesNodeGen.create(this.context, spacePadding, leftJustified, conversionNode);
                break;
            }
            case 'X': 
            case 'd': 
            case 'i': 
            case 'o': 
            case 'u': 
            case 'x': {
                char format;
                FormatNode spacePaddingNode = spacePadding == -2 ? ReadIntegerNodeGen.create(this.context, new SourceNode()) : new LiteralFormatNode(this.context, spacePadding);
                FormatNode zeroPaddingNode = zeroPadding == -2 ? ReadIntegerNodeGen.create(this.context, new SourceNode()) : (ctx.precision != null ? new LiteralFormatNode(this.context, Integer.parseInt(ctx.precision.getText())) : new LiteralFormatNode(this.context, zeroPadding));
                switch (type) {
                    case 'd': 
                    case 'i': 
                    case 'u': {
                        format = 'd';
                        break;
                    }
                    case 'o': {
                        format = 'o';
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        format = type;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                node = WriteBytesNodeGen.create(this.context, FormatIntegerNodeGen.create(this.context, format, spacePaddingNode, zeroPaddingNode, ToIntegerNodeGen.create(this.context, valueNode)));
                break;
            }
            case 'E': 
            case 'e': 
            case 'f': {
                node = WriteBytesNodeGen.create(this.context, FormatFloatNodeGen.create(this.context, spacePadding, zeroPadding, precision, type, ToDoubleWithCoercionNodeGen.create(this.context, valueNode)));
                break;
            }
            case 'G': 
            case 'g': {
                node = WriteBytesNodeGen.create(this.context, FormatFloatHumanReadableNodeGen.create(this.context, ToDoubleWithCoercionNodeGen.create(this.context, valueNode)));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.sequence.add(node);
    }

    @Override
    public void exitLiteral(PrintfParser.LiteralContext ctx) {
        byte[] text = this.tokenAsBytes(ctx.LITERAL().getSymbol());
        FormatNode node = text.length == 1 ? WriteByteNodeGen.create(this.context, new LiteralFormatNode(this.context, text[0])) : WriteBytesNodeGen.create(this.context, new LiteralFormatNode(this.context, text));
        this.sequence.add(node);
    }

    public FormatNode getNode() {
        return new SequenceNode(this.context, this.sequence.toArray(new FormatNode[this.sequence.size()]));
    }

    private byte[] tokenAsBytes(Token token) {
        return this.tokenAsBytes(token, 0);
    }

    private byte[] tokenAsBytes(Token token, int trim) {
        int from = token.getStartIndex() + trim;
        int to = from + token.getStopIndex() - token.getStartIndex() + 1 - 2 * trim;
        return Arrays.copyOfRange(this.source, from, to);
    }
}

