/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode.factory;

import java.util.List;
import java.util.Stack;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.ByteCodeConstants;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.process.analyzer.instruction.bytecode.factory.InstructionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiANewArrayFactory
extends InstructionFactory {
    @Override
    public int create(ClassFile classFile, Method method, List<Instruction> list, List<Instruction> listForAnalyze, Stack<Instruction> stack, byte[] code, int offset, int lineNumber, boolean[] jumps) {
        int opcode = code[offset] & 0xFF;
        int index = (code[offset + 1] & 0xFF) << 8 | code[offset + 2] & 0xFF;
        int count = code[offset + 3] & 0xFF;
        Instruction[] dimensions = new Instruction[count];
        int i = 0;
        while (i < count) {
            dimensions[i] = stack.pop();
            ++i;
        }
        MultiANewArray instruction = new MultiANewArray(opcode, offset, lineNumber, index, dimensions);
        stack.push(instruction);
        listForAnalyze.add(instruction);
        return ByteCodeConstants.NO_OF_OPERANDS[opcode];
    }
}

