/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.reconstructor;

import java.util.List;
import jd.core.model.instruction.bytecode.instruction.AALoad;
import jd.core.model.instruction.bytecode.instruction.AAStore;
import jd.core.model.instruction.bytecode.instruction.ALoad;
import jd.core.model.instruction.bytecode.instruction.AStore;
import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssignmentInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.DupLoad;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.GetStatic;
import jd.core.model.instruction.bytecode.instruction.ILoad;
import jd.core.model.instruction.bytecode.instruction.IStore;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.LoadInstruction;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.instruction.bytecode.instruction.attribute.ValuerefAttribute;
import jd.core.process.analyzer.classfile.visitor.CompareInstructionVisitor;
import jd.core.process.analyzer.classfile.visitor.ReplaceDupLoadVisitor;
import jd.core.process.analyzer.classfile.visitor.SearchDupLoadInstructionVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignmentInstructionReconstructor {
    public static void Reconstruct(List<Instruction> list) {
        int dupStoreIndex = 0;
        while (dupStoreIndex < list.size()) {
            block12: {
                int length;
                DupStore dupStore;
                block13: {
                    if (list.get((int)dupStoreIndex).opcode != 264) break block12;
                    dupStore = (DupStore)list.get(dupStoreIndex);
                    length = list.size();
                    if (dupStoreIndex + 1 >= length) break block13;
                    Instruction i = list.get(dupStoreIndex + 1);
                    if (i.opcode != 83 && i.opcode != 272) break block13;
                    i = ((ArrayStoreInstruction)i).arrayref;
                    if (i.opcode == 263 && ((DupLoad)i).dupStore == dupStore) break block12;
                }
                int xstorePutfieldPutstaticIndex = dupStoreIndex;
                while (++xstorePutfieldPutstaticIndex < length) {
                    ReplaceDupLoadVisitor visitor;
                    Instruction newInstruction;
                    Instruction xstorePutfieldPutstatic = list.get(xstorePutfieldPutstaticIndex);
                    DupLoad dupload1 = null;
                    switch (xstorePutfieldPutstatic.opcode) {
                        case 54: 
                        case 58: 
                        case 83: 
                        case 179: 
                        case 181: 
                        case 269: 
                        case 272: {
                            Instruction i = ((ValuerefAttribute)((Object)xstorePutfieldPutstatic)).getValueref();
                            if (i.opcode != 263 || ((DupLoad)i).dupStore != dupStore) break;
                            dupload1 = (DupLoad)i;
                            break;
                        }
                        case 55: 
                        case 56: 
                        case 57: {
                            new RuntimeException("Instruction inattendue").printStackTrace();
                        }
                    }
                    if (dupload1 == null) continue;
                    DupLoad dupload2 = null;
                    int dupload2Index = xstorePutfieldPutstaticIndex;
                    while (++dupload2Index < length) {
                        dupload2 = SearchDupLoadInstructionVisitor.visit(list.get(dupload2Index), dupStore);
                        if (dupload2 != null) break;
                    }
                    if (dupload2 == null) continue;
                    if (dupload1.lineNumber == dupload2.lineNumber) {
                        newInstruction = AssignmentInstructionReconstructor.CreateAssignmentInstruction(xstorePutfieldPutstatic, dupStore);
                        visitor = new ReplaceDupLoadVisitor(dupStore, newInstruction);
                        visitor.visit(list.get(dupload2Index));
                        int j = dupStoreIndex;
                        while (j-- > 0) {
                            if (list.get((int)j).opcode != 280) continue;
                            TernaryOpStore tos = (TernaryOpStore)list.get(j);
                            if (tos.ternaryOp2ndValueOffset != dupStore.offset) continue;
                            tos.ternaryOp2ndValueOffset = newInstruction.offset;
                            break;
                        }
                        list.remove(xstorePutfieldPutstaticIndex);
                        list.remove(dupStoreIndex);
                        --dupStoreIndex;
                        length -= 2;
                        continue;
                    }
                    newInstruction = AssignmentInstructionReconstructor.CreateInstruction(xstorePutfieldPutstatic);
                    if (newInstruction == null) continue;
                    visitor = new ReplaceDupLoadVisitor(dupStore, dupStore.objectref);
                    visitor.visit(xstorePutfieldPutstatic);
                    visitor.init(dupStore, newInstruction);
                    visitor.visit(list.get(dupload2Index));
                    list.remove(dupStoreIndex);
                    --dupStoreIndex;
                    --length;
                }
            }
            ++dupStoreIndex;
        }
    }

    private static Instruction CreateInstruction(Instruction xstorePutfieldPutstatic) {
        switch (xstorePutfieldPutstatic.opcode) {
            case 58: {
                return new ALoad(25, xstorePutfieldPutstatic.offset, xstorePutfieldPutstatic.lineNumber, ((AStore)xstorePutfieldPutstatic).index);
            }
            case 54: {
                return new ILoad(21, xstorePutfieldPutstatic.offset, xstorePutfieldPutstatic.lineNumber, ((IStore)xstorePutfieldPutstatic).index);
            }
            case 269: {
                return new LoadInstruction(268, xstorePutfieldPutstatic.offset, xstorePutfieldPutstatic.lineNumber, ((StoreInstruction)xstorePutfieldPutstatic).index, xstorePutfieldPutstatic.getReturnedSignature(null, null));
            }
            case 181: {
                return new GetField(180, xstorePutfieldPutstatic.offset, xstorePutfieldPutstatic.lineNumber, ((PutField)xstorePutfieldPutstatic).index, ((PutField)xstorePutfieldPutstatic).objectref);
            }
            case 179: {
                return new GetStatic(178, xstorePutfieldPutstatic.offset, xstorePutfieldPutstatic.lineNumber, ((PutStatic)xstorePutfieldPutstatic).index);
            }
            case 83: {
                return new AALoad(271, xstorePutfieldPutstatic.offset, xstorePutfieldPutstatic.lineNumber, ((AAStore)xstorePutfieldPutstatic).arrayref, ((AAStore)xstorePutfieldPutstatic).indexref);
            }
            case 272: {
                return new ArrayLoadInstruction(271, xstorePutfieldPutstatic.offset, xstorePutfieldPutstatic.lineNumber, ((ArrayStoreInstruction)xstorePutfieldPutstatic).arrayref, ((ArrayStoreInstruction)xstorePutfieldPutstatic).indexref, ((ArrayStoreInstruction)xstorePutfieldPutstatic).signature);
            }
        }
        return null;
    }

    private static Instruction CreateAssignmentInstruction(Instruction xstorePutfieldPutstatic, DupStore dupStore) {
        if (dupStore.objectref.opcode == 267) {
            Instruction value1 = ((BinaryOperatorInstruction)dupStore.objectref).value1;
            if (xstorePutfieldPutstatic.lineNumber == value1.lineNumber) {
                switch (xstorePutfieldPutstatic.opcode) {
                    case 58: {
                        if (value1.opcode != 25 || ((StoreInstruction)xstorePutfieldPutstatic).index != ((LoadInstruction)value1).index) break;
                        return AssignmentInstructionReconstructor.CreateBinaryOperatorAssignmentInstruction(xstorePutfieldPutstatic, dupStore);
                    }
                    case 54: {
                        if (value1.opcode != 21 || ((StoreInstruction)xstorePutfieldPutstatic).index != ((LoadInstruction)value1).index) break;
                        return AssignmentInstructionReconstructor.CreateBinaryOperatorAssignmentInstruction(xstorePutfieldPutstatic, dupStore);
                    }
                    case 269: {
                        if (value1.opcode != 268 || ((StoreInstruction)xstorePutfieldPutstatic).index != ((LoadInstruction)value1).index) break;
                        return AssignmentInstructionReconstructor.CreateBinaryOperatorAssignmentInstruction(xstorePutfieldPutstatic, dupStore);
                    }
                    case 181: {
                        CompareInstructionVisitor visitor;
                        if (value1.opcode != 180 || ((PutField)xstorePutfieldPutstatic).index != ((GetField)value1).index || !(visitor = new CompareInstructionVisitor()).visit(((PutField)xstorePutfieldPutstatic).objectref, ((GetField)value1).objectref)) break;
                        return AssignmentInstructionReconstructor.CreateBinaryOperatorAssignmentInstruction(xstorePutfieldPutstatic, dupStore);
                    }
                    case 179: {
                        if (value1.opcode != 180 || ((PutStatic)xstorePutfieldPutstatic).index != ((GetStatic)value1).index) break;
                        return AssignmentInstructionReconstructor.CreateBinaryOperatorAssignmentInstruction(xstorePutfieldPutstatic, dupStore);
                    }
                    case 83: {
                        if (value1.opcode != 50) break;
                        ArrayStoreInstruction aas = (ArrayStoreInstruction)xstorePutfieldPutstatic;
                        ArrayLoadInstruction aal = (ArrayLoadInstruction)value1;
                        CompareInstructionVisitor visitor = new CompareInstructionVisitor();
                        if (!visitor.visit(aas.arrayref, aal.arrayref) || !visitor.visit(aas.indexref, aal.indexref)) break;
                        return AssignmentInstructionReconstructor.CreateBinaryOperatorAssignmentInstruction(xstorePutfieldPutstatic, dupStore);
                    }
                    case 272: {
                        if (value1.opcode != 271) break;
                        ArrayStoreInstruction aas = (ArrayStoreInstruction)xstorePutfieldPutstatic;
                        ArrayLoadInstruction aal = (ArrayLoadInstruction)value1;
                        CompareInstructionVisitor visitor = new CompareInstructionVisitor();
                        if (!visitor.visit(aas.arrayref, aal.arrayref) || !visitor.visit(aas.indexref, aal.indexref)) break;
                        return AssignmentInstructionReconstructor.CreateBinaryOperatorAssignmentInstruction(xstorePutfieldPutstatic, dupStore);
                    }
                    case 55: 
                    case 56: 
                    case 57: {
                        new RuntimeException("Unexpected instruction").printStackTrace();
                    }
                }
            }
        }
        Instruction newInstruction = AssignmentInstructionReconstructor.CreateInstruction(xstorePutfieldPutstatic);
        return new AssignmentInstruction(265, xstorePutfieldPutstatic.offset, dupStore.lineNumber, 14, "=", newInstruction, dupStore.objectref);
    }

    private static AssignmentInstruction CreateBinaryOperatorAssignmentInstruction(Instruction xstorePutfieldPutstatic, DupStore dupstore) {
        BinaryOperatorInstruction boi = (BinaryOperatorInstruction)dupstore.objectref;
        String newOperator = String.valueOf(boi.operator) + "=";
        return new AssignmentInstruction(265, xstorePutfieldPutstatic.offset, dupstore.lineNumber, boi.getPriority(), newOperator, AssignmentInstructionReconstructor.CreateInstruction(xstorePutfieldPutstatic), boi.value2);
    }
}

