/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.vector;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.queries.function.FunctionRangeQuery;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.spatial.query.UnsupportedSpatialOperation;
import org.apache.lucene.spatial.vector.DistanceValueSource;

public class PointVectorStrategy
extends SpatialStrategy {
    public static final String SUFFIX_X = "__x";
    public static final String SUFFIX_Y = "__y";
    private final String fieldNameX;
    private final String fieldNameY;
    public int precisionStep = 8;

    public PointVectorStrategy(SpatialContext ctx, String fieldNamePrefix) {
        super(ctx, fieldNamePrefix);
        this.fieldNameX = fieldNamePrefix + SUFFIX_X;
        this.fieldNameY = fieldNamePrefix + SUFFIX_Y;
    }

    public void setPrecisionStep(int p) {
        this.precisionStep = p;
        if (this.precisionStep <= 0 || this.precisionStep >= 64) {
            this.precisionStep = Integer.MAX_VALUE;
        }
    }

    String getFieldNameX() {
        return this.fieldNameX;
    }

    String getFieldNameY() {
        return this.fieldNameY;
    }

    @Override
    public Field[] createIndexableFields(Shape shape) {
        if (shape instanceof Point) {
            return this.createIndexableFields((Point)shape);
        }
        throw new UnsupportedOperationException("Can only index Point, not " + shape);
    }

    public Field[] createIndexableFields(Point point) {
        FieldType doubleFieldType = new FieldType(DoubleField.TYPE_NOT_STORED);
        doubleFieldType.setNumericPrecisionStep(this.precisionStep);
        Field[] f = new Field[]{new DoubleField(this.fieldNameX, point.getX(), doubleFieldType), new DoubleField(this.fieldNameY, point.getY(), doubleFieldType)};
        return f;
    }

    @Override
    public ValueSource makeDistanceValueSource(Point queryPoint, double multiplier) {
        return new DistanceValueSource(this, queryPoint, multiplier);
    }

    public ConstantScoreQuery makeQuery(SpatialArgs args) {
        if (!SpatialOperation.is(args.getOperation(), SpatialOperation.Intersects, SpatialOperation.IsWithin)) {
            throw new UnsupportedSpatialOperation(args.getOperation());
        }
        Shape shape = args.getShape();
        if (shape instanceof Rectangle) {
            Rectangle bbox = (Rectangle)shape;
            return new ConstantScoreQuery(this.makeWithin(bbox));
        }
        if (shape instanceof Circle) {
            Circle circle = (Circle)shape;
            Rectangle bbox = circle.getBoundingBox();
            Query approxQuery = this.makeWithin(bbox);
            BooleanQuery.Builder bqBuilder = new BooleanQuery.Builder();
            FunctionRangeQuery vsRangeQuery = new FunctionRangeQuery(this.makeDistanceValueSource(circle.getCenter()), (Number)0.0, (Number)circle.getRadius(), true, true);
            bqBuilder.add(approxQuery, BooleanClause.Occur.FILTER);
            bqBuilder.add((Query)vsRangeQuery, BooleanClause.Occur.FILTER);
            return new ConstantScoreQuery((Query)bqBuilder.build());
        }
        throw new UnsupportedOperationException("Only Rectangles and Circles are currently supported, found [" + shape.getClass() + "]");
    }

    private Query makeWithin(Rectangle bbox) {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        BooleanClause.Occur MUST = BooleanClause.Occur.MUST;
        if (bbox.getCrossesDateLine()) {
            bq.add(this.rangeQuery(this.fieldNameX, null, bbox.getMaxX()), BooleanClause.Occur.SHOULD);
            bq.add(this.rangeQuery(this.fieldNameX, bbox.getMinX(), null), BooleanClause.Occur.SHOULD);
            bq.setMinimumNumberShouldMatch(1);
        } else {
            bq.add(this.rangeQuery(this.fieldNameX, bbox.getMinX(), bbox.getMaxX()), MUST);
        }
        bq.add(this.rangeQuery(this.fieldNameY, bbox.getMinY(), bbox.getMaxY()), MUST);
        return bq.build();
    }

    private NumericRangeQuery<Double> rangeQuery(String fieldName, Double min, Double max) {
        return NumericRangeQuery.newDoubleRange((String)fieldName, (int)this.precisionStep, (Double)min, (Double)max, (boolean)true, (boolean)true);
    }
}

