/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BaseGlobalOrdinalScorer;
import org.apache.lucene.search.join.GlobalOrdinalsWithScoreCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.ToStringUtils;

final class GlobalOrdinalsWithScoreQuery
extends Query {
    private final GlobalOrdinalsWithScoreCollector collector;
    private final String joinField;
    private final MultiDocValues.OrdinalMap globalOrds;
    private final Query toQuery;
    private final Query fromQuery;
    private final int min;
    private final int max;
    private final IndexReader indexReader;

    GlobalOrdinalsWithScoreQuery(GlobalOrdinalsWithScoreCollector collector, String joinField, MultiDocValues.OrdinalMap globalOrds, Query toQuery, Query fromQuery, int min, int max, IndexReader indexReader) {
        this.collector = collector;
        this.joinField = joinField;
        this.globalOrds = globalOrds;
        this.toQuery = toQuery;
        this.fromQuery = fromQuery;
        this.min = min;
        this.max = max;
        this.indexReader = indexReader;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new W(this, this.toQuery.createWeight(searcher, false));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GlobalOrdinalsWithScoreQuery that = (GlobalOrdinalsWithScoreQuery)((Object)o);
        if (this.min != that.min) {
            return false;
        }
        if (this.max != that.max) {
            return false;
        }
        if (!this.joinField.equals(that.joinField)) {
            return false;
        }
        if (!this.fromQuery.equals((Object)that.fromQuery)) {
            return false;
        }
        if (!this.toQuery.equals((Object)that.toQuery)) {
            return false;
        }
        return this.indexReader.equals((Object)that.indexReader);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.joinField.hashCode();
        result = 31 * result + this.toQuery.hashCode();
        result = 31 * result + this.fromQuery.hashCode();
        result = 31 * result + this.min;
        result = 31 * result + this.max;
        result = 31 * result + this.indexReader.hashCode();
        return result;
    }

    public String toString(String field) {
        return "GlobalOrdinalsQuery{joinField=" + this.joinField + "min=" + this.min + "max=" + this.max + "fromQuery=" + this.fromQuery + '}' + ToStringUtils.boost((float)this.getBoost());
    }

    static final class SegmentOrdinalScorer
    extends BaseGlobalOrdinalScorer {
        final GlobalOrdinalsWithScoreCollector collector;

        public SegmentOrdinalScorer(Weight weight, GlobalOrdinalsWithScoreCollector collector, SortedDocValues values, DocIdSetIterator approximation) {
            super(weight, values, approximation);
            this.collector = collector;
        }

        @Override
        protected TwoPhaseIterator createTwoPhaseIterator(DocIdSetIterator approximation) {
            return new TwoPhaseIterator(approximation){

                public boolean matches() throws IOException {
                    int segmentOrd = SegmentOrdinalScorer.this.values.getOrd(this.approximation.docID());
                    if (segmentOrd != -1 && SegmentOrdinalScorer.this.collector.match(segmentOrd)) {
                        SegmentOrdinalScorer.this.score = SegmentOrdinalScorer.this.collector.score(segmentOrd);
                        return true;
                    }
                    return false;
                }

                public float matchCost() {
                    return 100.0f;
                }
            };
        }
    }

    static final class OrdinalMapScorer
    extends BaseGlobalOrdinalScorer {
        final LongValues segmentOrdToGlobalOrdLookup;
        final GlobalOrdinalsWithScoreCollector collector;

        public OrdinalMapScorer(Weight weight, GlobalOrdinalsWithScoreCollector collector, SortedDocValues values, DocIdSetIterator approximation, LongValues segmentOrdToGlobalOrdLookup) {
            super(weight, values, approximation);
            this.segmentOrdToGlobalOrdLookup = segmentOrdToGlobalOrdLookup;
            this.collector = collector;
        }

        @Override
        protected TwoPhaseIterator createTwoPhaseIterator(DocIdSetIterator approximation) {
            return new TwoPhaseIterator(approximation){

                public boolean matches() throws IOException {
                    int globalOrd;
                    long segmentOrd = OrdinalMapScorer.this.values.getOrd(this.approximation.docID());
                    if (segmentOrd != -1L && OrdinalMapScorer.this.collector.match(globalOrd = (int)OrdinalMapScorer.this.segmentOrdToGlobalOrdLookup.get(segmentOrd))) {
                        OrdinalMapScorer.this.score = OrdinalMapScorer.this.collector.score(globalOrd);
                        return true;
                    }
                    return false;
                }

                public float matchCost() {
                    return 100.0f;
                }
            };
        }
    }

    final class W
    extends Weight {
        private final Weight approximationWeight;

        W(Query query, Weight approximationWeight) {
            super(query);
            this.approximationWeight = approximationWeight;
        }

        public void extractTerms(Set<Term> terms) {
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            int segmentOrd;
            SortedDocValues values = DocValues.getSorted((LeafReader)context.reader(), (String)GlobalOrdinalsWithScoreQuery.this.joinField);
            if (values != null && (segmentOrd = values.getOrd(doc)) != -1) {
                float score;
                if (GlobalOrdinalsWithScoreQuery.this.globalOrds != null) {
                    long globalOrd = GlobalOrdinalsWithScoreQuery.this.globalOrds.getGlobalOrds(context.ord).get(segmentOrd);
                    score = GlobalOrdinalsWithScoreQuery.this.collector.score((int)globalOrd);
                } else {
                    score = GlobalOrdinalsWithScoreQuery.this.collector.score(segmentOrd);
                }
                BytesRef joinValue = values.lookupOrd(segmentOrd);
                return Explanation.match((float)score, (String)("Score based on join value " + joinValue.utf8ToString()), (Explanation[])new Explanation[0]);
            }
            return Explanation.noMatch((String)"Not a match", (Explanation[])new Explanation[0]);
        }

        public float getValueForNormalization() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm, float boost) {
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            SortedDocValues values = DocValues.getSorted((LeafReader)context.reader(), (String)GlobalOrdinalsWithScoreQuery.this.joinField);
            if (values == null) {
                return null;
            }
            Scorer approximationScorer = this.approximationWeight.scorer(context);
            if (approximationScorer == null) {
                return null;
            }
            if (GlobalOrdinalsWithScoreQuery.this.globalOrds != null) {
                return new OrdinalMapScorer(this, GlobalOrdinalsWithScoreQuery.this.collector, values, approximationScorer.iterator(), GlobalOrdinalsWithScoreQuery.this.globalOrds.getGlobalOrds(context.ord));
            }
            return new SegmentOrdinalScorer(this, GlobalOrdinalsWithScoreQuery.this.collector, values, approximationScorer.iterator());
        }
    }
}

