/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;

public abstract class TransportChannelResponseHandler<T extends TransportResponse>
implements TransportResponseHandler<T> {
    private final ESLogger logger;
    private final TransportChannel channel;
    private final String extraInfoOnError;

    public static TransportChannelResponseHandler<TransportResponse.Empty> emptyResponseHandler(ESLogger logger, TransportChannel channel, String extraInfoOnError) {
        return new TransportChannelResponseHandler<TransportResponse.Empty>(logger, channel, extraInfoOnError){

            @Override
            public TransportResponse.Empty newInstance() {
                return TransportResponse.Empty.INSTANCE;
            }
        };
    }

    protected TransportChannelResponseHandler(ESLogger logger, TransportChannel channel, String extraInfoOnError) {
        this.logger = logger;
        this.channel = channel;
        this.extraInfoOnError = extraInfoOnError;
    }

    @Override
    public void handleResponse(T response) {
        try {
            this.channel.sendResponse((TransportResponse)response);
        }
        catch (IOException e) {
            this.handleException(new TransportException(e));
        }
    }

    @Override
    public void handleException(TransportException exp) {
        try {
            this.channel.sendResponse(exp);
        }
        catch (IOException e) {
            this.logger.debug("failed to send failure {}", e, this.extraInfoOnError == null ? "" : "(" + this.extraInfoOnError + ")");
        }
    }

    @Override
    public String executor() {
        return "same";
    }
}

