/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.ContextAndHeaderHolder;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.script.Template;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.internal.ShardSearchRequest;

public class ShardSearchLocalRequest
extends ContextAndHeaderHolder
implements ShardSearchRequest {
    private String index;
    private int shardId;
    private int numberOfShards;
    private SearchType searchType;
    private Scroll scroll;
    private String[] types = Strings.EMPTY_ARRAY;
    private String[] filteringAliases;
    private BytesReference source;
    private BytesReference extraSource;
    private BytesReference templateSource;
    private Template template;
    private Boolean requestCache;
    private long nowInMillis;
    private boolean profile;

    ShardSearchLocalRequest() {
    }

    ShardSearchLocalRequest(SearchRequest searchRequest, ShardRouting shardRouting, int numberOfShards, String[] filteringAliases, long nowInMillis) {
        this(shardRouting.shardId(), numberOfShards, searchRequest.searchType(), searchRequest.source(), searchRequest.types(), searchRequest.requestCache());
        this.extraSource = searchRequest.extraSource();
        this.templateSource = searchRequest.templateSource();
        this.template = searchRequest.template();
        this.scroll = searchRequest.scroll();
        this.filteringAliases = filteringAliases;
        this.nowInMillis = nowInMillis;
        this.copyContextAndHeadersFrom(searchRequest);
    }

    public ShardSearchLocalRequest(String[] types, long nowInMillis) {
        this.types = types;
        this.nowInMillis = nowInMillis;
    }

    public ShardSearchLocalRequest(String[] types, long nowInMillis, String[] filteringAliases) {
        this(types, nowInMillis);
        this.filteringAliases = filteringAliases;
    }

    public ShardSearchLocalRequest(ShardId shardId, int numberOfShards, SearchType searchType, BytesReference source, String[] types, Boolean requestCache) {
        this.index = shardId.getIndex();
        this.shardId = shardId.id();
        this.numberOfShards = numberOfShards;
        this.searchType = searchType;
        this.source = source;
        this.types = types;
        this.requestCache = requestCache;
    }

    @Override
    public String index() {
        return this.index;
    }

    @Override
    public int shardId() {
        return this.shardId;
    }

    @Override
    public String[] types() {
        return this.types;
    }

    @Override
    public BytesReference source() {
        return this.source;
    }

    @Override
    public void source(BytesReference source) {
        this.source = source;
    }

    @Override
    public BytesReference extraSource() {
        return this.extraSource;
    }

    @Override
    public int numberOfShards() {
        return this.numberOfShards;
    }

    @Override
    public SearchType searchType() {
        return this.searchType;
    }

    @Override
    public String[] filteringAliases() {
        return this.filteringAliases;
    }

    @Override
    public long nowInMillis() {
        return this.nowInMillis;
    }

    @Override
    public Template template() {
        return this.template;
    }

    @Override
    public BytesReference templateSource() {
        return this.templateSource;
    }

    @Override
    public Boolean requestCache() {
        return this.requestCache;
    }

    @Override
    public Scroll scroll() {
        return this.scroll;
    }

    @Override
    public void setProfile(boolean profile) {
        this.profile = profile;
    }

    @Override
    public boolean isProfile() {
        return this.profile;
    }

    protected void innerReadFrom(StreamInput in) throws IOException {
        this.index = in.readString();
        this.shardId = in.readVInt();
        this.searchType = SearchType.fromId(in.readByte());
        this.numberOfShards = in.readVInt();
        if (in.readBoolean()) {
            this.scroll = Scroll.readScroll(in);
        }
        this.source = in.readBytesReference();
        this.extraSource = in.readBytesReference();
        this.types = in.readStringArray();
        this.filteringAliases = in.readStringArray();
        this.nowInMillis = in.readVLong();
        this.templateSource = in.readBytesReference();
        if (in.readBoolean()) {
            this.template = Template.readTemplate(in);
        }
        this.requestCache = in.readOptionalBoolean();
    }

    protected void innerWriteTo(StreamOutput out, boolean asKey) throws IOException {
        out.writeString(this.index);
        out.writeVInt(this.shardId);
        out.writeByte(this.searchType.id());
        if (!asKey) {
            out.writeVInt(this.numberOfShards);
        }
        if (this.scroll == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.scroll.writeTo(out);
        }
        out.writeBytesReference(this.source);
        out.writeBytesReference(this.extraSource);
        out.writeStringArray(this.types);
        out.writeStringArrayNullable(this.filteringAliases);
        if (!asKey) {
            out.writeVLong(this.nowInMillis);
        }
        out.writeBytesReference(this.templateSource);
        boolean hasTemplate = this.template != null;
        out.writeBoolean(hasTemplate);
        if (hasTemplate) {
            this.template.writeTo(out);
        }
        out.writeOptionalBoolean(this.requestCache);
    }

    @Override
    public BytesReference cacheKey() throws IOException {
        BytesStreamOutput out = new BytesStreamOutput();
        this.innerWriteTo(out, true);
        return out.bytes().copyBytesArray();
    }
}

