/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.valuecount;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCount;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.aggregations.support.format.ValueFormatterStreams;

public class InternalValueCount
extends InternalNumericMetricsAggregation.SingleValue
implements ValueCount {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("value_count", "vcount");
    private static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalValueCount readResult(StreamInput in) throws IOException {
            InternalValueCount count = new InternalValueCount();
            count.readFrom(in);
            return count;
        }
    };
    private long value;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    InternalValueCount() {
    }

    public InternalValueCount(String name, long value, ValueFormatter formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.value = value;
        this.valueFormatter = formatter;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public double value() {
        return this.value;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        long valueCount = 0L;
        for (InternalAggregation aggregation : aggregations) {
            valueCount += ((InternalValueCount)aggregation).value;
        }
        return new InternalValueCount(this.name, valueCount, this.valueFormatter, this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    protected void doReadFrom(StreamInput in) throws IOException {
        this.valueFormatter = ValueFormatterStreams.readOptional(in);
        this.value = in.readVLong();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        ValueFormatterStreams.writeOptional(this.valueFormatter, out);
        out.writeVLong(this.value);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(InternalAggregation.CommonFields.VALUE, this.value);
        if (!(this.valueFormatter instanceof ValueFormatter.Raw)) {
            builder.field(InternalAggregation.CommonFields.VALUE_AS_STRING, this.valueFormatter.format(this.value));
        }
        return builder;
    }

    public String toString() {
        return "count[" + this.value + "]";
    }
}

