/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;

public interface IndicesLifecycle {
    public void addListener(Listener var1);

    public void removeListener(Listener var1);

    public static abstract class Listener {
        public void shardRoutingChanged(IndexShard indexShard, @Nullable ShardRouting oldRouting, ShardRouting newRouting) {
        }

        public void beforeIndexAddedToCluster(Index index, Settings indexSettings) {
        }

        public void beforeIndexCreated(Index index, Settings indexSettings) {
        }

        public void afterIndexCreated(IndexService indexService) {
        }

        public void beforeIndexShardCreated(ShardId shardId, Settings indexSettings) {
        }

        public void afterIndexShardCreated(IndexShard indexShard) {
        }

        public void afterIndexShardPostRecovery(IndexShard indexShard) {
        }

        public void beforeIndexShardPostRecovery(IndexShard indexShard) {
        }

        public void afterIndexShardStarted(IndexShard indexShard) {
        }

        public void beforeIndexClosed(IndexService indexService) {
        }

        public void afterIndexClosed(Index index, Settings indexSettings) {
        }

        public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        }

        public void afterIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        }

        public void beforeIndexShardDeleted(ShardId shardId, Settings indexSettings) {
        }

        public void afterIndexShardDeleted(ShardId shardId, Settings indexSettings) {
        }

        public void indexShardStateChanged(IndexShard indexShard, @Nullable IndexShardState previousState, IndexShardState currentState, @Nullable String reason) {
        }

        public void afterIndexDeleted(Index index, Settings indexSettings) {
        }

        public void beforeIndexDeleted(IndexService indexService) {
        }

        public void onShardInactive(IndexShard indexShard) {
        }
    }
}

