/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.store.IndexStore;

public class IndexStoreModule
extends AbstractModule {
    public static final String STORE_TYPE = "index.store.type";
    private final Settings settings;
    private final Map<String, Class<? extends IndexStore>> storeTypes = new HashMap<String, Class<? extends IndexStore>>();

    public IndexStoreModule(Settings settings) {
        this.settings = settings;
    }

    public void addIndexStore(String type, Class<? extends IndexStore> clazz) {
        this.storeTypes.put(type, clazz);
    }

    private static boolean isBuiltinType(String storeType) {
        for (Type type : Type.values()) {
            if (!type.match(storeType)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void configure() {
        String storeType = this.settings.get(STORE_TYPE);
        if (storeType == null || IndexStoreModule.isBuiltinType(storeType)) {
            this.bind(IndexStore.class).asEagerSingleton();
        } else {
            Class<? extends IndexStore> clazz = this.storeTypes.get(storeType);
            if (clazz == null) {
                throw new IllegalArgumentException("Unknown store type [" + storeType + "]");
            }
            this.bind(IndexStore.class).to(clazz).asEagerSingleton();
        }
    }

    public static enum Type {
        NIOFS,
        MMAPFS,
        SIMPLEFS,
        FS,
        DEFAULT;


        public String getSettingsKey() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public boolean match(String setting) {
            return this.getSettingsKey().equals(setting);
        }
    }
}

