/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.stats;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.search.stats.SearchSlowLog;
import org.elasticsearch.index.search.stats.SearchStats;
import org.elasticsearch.search.internal.SearchContext;

public final class ShardSearchStats {
    private final SearchSlowLog slowLogSearchService;
    private final StatsHolder totalStats = new StatsHolder();
    private final CounterMetric openContexts = new CounterMetric();
    private volatile Map<String, StatsHolder> groupsStats = ImmutableMap.of();

    public ShardSearchStats(Settings indexSettings) {
        this.slowLogSearchService = new SearchSlowLog(indexSettings);
    }

    public SearchStats stats(String ... groups) {
        HashMap<String, SearchStats.Stats> groupsSt;
        SearchStats.Stats total;
        block4: {
            total = this.totalStats.stats();
            groupsSt = null;
            if (groups == null || groups.length <= 0) break block4;
            groupsSt = new HashMap<String, SearchStats.Stats>(this.groupsStats.size());
            if (groups.length == 1 && groups[0].equals("_all")) {
                for (Map.Entry<String, StatsHolder> entry : this.groupsStats.entrySet()) {
                    groupsSt.put(entry.getKey(), entry.getValue().stats());
                }
            } else {
                for (Map.Entry<String, StatsHolder> entry : this.groupsStats.entrySet()) {
                    if (!Regex.simpleMatch(groups, entry.getKey())) continue;
                    groupsSt.put(entry.getKey(), entry.getValue().stats());
                }
            }
        }
        return new SearchStats(total, this.openContexts.count(), groupsSt);
    }

    public void onPreQueryPhase(SearchContext searchContext) {
        this.totalStats.queryCurrent.inc();
        if (searchContext.groupStats() != null) {
            for (int i = 0; i < searchContext.groupStats().size(); ++i) {
                this.groupStats((String)searchContext.groupStats().get((int)i)).queryCurrent.inc();
            }
        }
    }

    public void onFailedQueryPhase(SearchContext searchContext) {
        this.totalStats.queryCurrent.dec();
        if (searchContext.groupStats() != null) {
            for (int i = 0; i < searchContext.groupStats().size(); ++i) {
                this.groupStats((String)searchContext.groupStats().get((int)i)).queryCurrent.dec();
            }
        }
    }

    public void onQueryPhase(SearchContext searchContext, long tookInNanos) {
        this.totalStats.queryMetric.inc(tookInNanos);
        this.totalStats.queryCurrent.dec();
        if (searchContext.groupStats() != null) {
            for (int i = 0; i < searchContext.groupStats().size(); ++i) {
                StatsHolder statsHolder = this.groupStats(searchContext.groupStats().get(i));
                statsHolder.queryMetric.inc(tookInNanos);
                statsHolder.queryCurrent.dec();
            }
        }
        this.slowLogSearchService.onQueryPhase(searchContext, tookInNanos);
    }

    public void onPreFetchPhase(SearchContext searchContext) {
        this.totalStats.fetchCurrent.inc();
        if (searchContext.groupStats() != null) {
            for (int i = 0; i < searchContext.groupStats().size(); ++i) {
                this.groupStats((String)searchContext.groupStats().get((int)i)).fetchCurrent.inc();
            }
        }
    }

    public void onFailedFetchPhase(SearchContext searchContext) {
        this.totalStats.fetchCurrent.dec();
        if (searchContext.groupStats() != null) {
            for (int i = 0; i < searchContext.groupStats().size(); ++i) {
                this.groupStats((String)searchContext.groupStats().get((int)i)).fetchCurrent.dec();
            }
        }
    }

    public void onFetchPhase(SearchContext searchContext, long tookInNanos) {
        this.totalStats.fetchMetric.inc(tookInNanos);
        this.totalStats.fetchCurrent.dec();
        if (searchContext.groupStats() != null) {
            for (int i = 0; i < searchContext.groupStats().size(); ++i) {
                StatsHolder statsHolder = this.groupStats(searchContext.groupStats().get(i));
                statsHolder.fetchMetric.inc(tookInNanos);
                statsHolder.fetchCurrent.dec();
            }
        }
        this.slowLogSearchService.onFetchPhase(searchContext, tookInNanos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.totalStats.clear();
        ShardSearchStats shardSearchStats = this;
        synchronized (shardSearchStats) {
            if (!this.groupsStats.isEmpty()) {
                MapBuilder<String, StatsHolder> typesStatsBuilder = MapBuilder.newMapBuilder();
                for (Map.Entry<String, StatsHolder> typeStats : this.groupsStats.entrySet()) {
                    if (typeStats.getValue().totalCurrent() <= 0L) continue;
                    typeStats.getValue().clear();
                    typesStatsBuilder.put(typeStats.getKey(), typeStats.getValue());
                }
                this.groupsStats = typesStatsBuilder.immutableMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatsHolder groupStats(String group) {
        StatsHolder stats = this.groupsStats.get(group);
        if (stats == null) {
            ShardSearchStats shardSearchStats = this;
            synchronized (shardSearchStats) {
                stats = this.groupsStats.get(group);
                if (stats == null) {
                    stats = new StatsHolder();
                    this.groupsStats = MapBuilder.newMapBuilder(this.groupsStats).put(group, stats).immutableMap();
                }
            }
        }
        return stats;
    }

    public void onNewContext(SearchContext context) {
        this.openContexts.inc();
    }

    public void onFreeContext(SearchContext context) {
        this.openContexts.dec();
    }

    public void onNewScrollContext(SearchContext context) {
        this.totalStats.scrollCurrent.inc();
    }

    public void onFreeScrollContext(SearchContext context) {
        this.totalStats.scrollCurrent.dec();
        this.totalStats.scrollMetric.inc(System.nanoTime() - context.getOriginNanoTime());
    }

    public void onRefreshSettings(Settings settings) {
        this.slowLogSearchService.onRefreshSettings(settings);
    }

    static final class StatsHolder {
        public final MeanMetric queryMetric = new MeanMetric();
        public final MeanMetric fetchMetric = new MeanMetric();
        public final MeanMetric scrollMetric = new MeanMetric();
        public final CounterMetric queryCurrent = new CounterMetric();
        public final CounterMetric fetchCurrent = new CounterMetric();
        public final CounterMetric scrollCurrent = new CounterMetric();

        StatsHolder() {
        }

        public SearchStats.Stats stats() {
            return new SearchStats.Stats(this.queryMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.queryMetric.sum()), this.queryCurrent.count(), this.fetchMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.fetchMetric.sum()), this.fetchCurrent.count(), this.scrollMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.scrollMetric.sum()), this.scrollCurrent.count());
        }

        public long totalCurrent() {
            return this.queryCurrent.count() + this.fetchCurrent.count() + this.scrollCurrent.count();
        }

        public void clear() {
            this.queryMetric.clear();
            this.fetchMetric.clear();
            this.scrollMetric.clear();
        }
    }
}

