/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.percolator;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.indexing.IndexingOperationListener;
import org.elasticsearch.index.indexing.ShardIndexingService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentTypeListener;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.percolator.PercolatorException;
import org.elasticsearch.index.percolator.QueriesLoaderCollector;
import org.elasticsearch.index.percolator.stats.ShardPercolateService;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesLifecycle;

public class PercolatorQueriesRegistry
extends AbstractIndexShardComponent
implements Closeable {
    public final String MAP_UNMAPPED_FIELDS_AS_STRING = "index.percolator.map_unmapped_fields_as_string";
    private final IndexQueryParserService queryParserService;
    private final MapperService mapperService;
    private final IndicesLifecycle indicesLifecycle;
    private final IndexFieldDataService indexFieldDataService;
    private final ShardIndexingService indexingService;
    private final ShardPercolateService shardPercolateService;
    private final ConcurrentMap<BytesRef, Query> percolateQueries = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
    private final ShardLifecycleListener shardLifecycleListener = new ShardLifecycleListener();
    private final RealTimePercolatorOperationListener realTimePercolatorOperationListener = new RealTimePercolatorOperationListener();
    private final PercolateTypeListener percolateTypeListener = new PercolateTypeListener();
    private final AtomicBoolean realTimePercolatorEnabled = new AtomicBoolean(false);
    private boolean mapUnmappedFieldsAsString;

    public PercolatorQueriesRegistry(ShardId shardId, Settings indexSettings, IndexQueryParserService queryParserService, ShardIndexingService indexingService, IndicesLifecycle indicesLifecycle, MapperService mapperService, IndexFieldDataService indexFieldDataService, ShardPercolateService shardPercolateService) {
        super(shardId, indexSettings);
        this.queryParserService = queryParserService;
        this.mapperService = mapperService;
        this.indicesLifecycle = indicesLifecycle;
        this.indexingService = indexingService;
        this.indexFieldDataService = indexFieldDataService;
        this.shardPercolateService = shardPercolateService;
        this.mapUnmappedFieldsAsString = indexSettings.getAsBoolean("index.percolator.map_unmapped_fields_as_string", (Boolean)false);
        indicesLifecycle.addListener(this.shardLifecycleListener);
        mapperService.addTypeListener(this.percolateTypeListener);
    }

    public ConcurrentMap<BytesRef, Query> percolateQueries() {
        return this.percolateQueries;
    }

    @Override
    public void close() {
        this.mapperService.removeTypeListener(this.percolateTypeListener);
        this.indicesLifecycle.removeListener(this.shardLifecycleListener);
        this.indexingService.removeListener(this.realTimePercolatorOperationListener);
        this.clear();
    }

    public void clear() {
        this.percolateQueries.clear();
    }

    void enableRealTimePercolator() {
        if (this.realTimePercolatorEnabled.compareAndSet(false, true)) {
            this.indexingService.addListener(this.realTimePercolatorOperationListener);
        }
    }

    void disableRealTimePercolator() {
        if (this.realTimePercolatorEnabled.compareAndSet(true, false)) {
            this.indexingService.removeListener(this.realTimePercolatorOperationListener);
        }
    }

    public void addPercolateQuery(String idAsString, BytesReference source) {
        Query newquery = this.parsePercolatorDocument(idAsString, source);
        BytesRef id = new BytesRef((CharSequence)idAsString);
        Query previousQuery = this.percolateQueries.put(id, newquery);
        this.shardPercolateService.addedQuery(id, previousQuery, newquery);
    }

    public void removePercolateQuery(String idAsString) {
        BytesRef id = new BytesRef((CharSequence)idAsString);
        Query query = (Query)this.percolateQueries.remove(id);
        if (query != null) {
            this.shardPercolateService.removedQuery(id, query);
        }
    }

    /*
     * Exception decompiling
     */
    Query parsePercolatorDocument(String id, BytesReference source) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 25[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Query parseQuery(String type, XContentParser parser) {
        String[] previousTypes = null;
        if (type != null) {
            QueryParseContext.setTypesWithPrevious(new String[]{type});
        }
        QueryParseContext context = this.queryParserService.getParseContext();
        try {
            context.reset(parser);
            context.setAllowUnmappedFields(false);
            context.setMapUnmappedFieldAsString(this.mapUnmappedFieldsAsString);
            Query query = this.queryParserService.parseInnerQuery(context);
            return query;
        }
        catch (IOException e) {
            throw new QueryParsingException(context, "Failed to parse", e, new Object[0]);
        }
        finally {
            if (type != null) {
                QueryParseContext.setTypes(previousTypes);
            }
            context.reset(null);
        }
    }

    private class RealTimePercolatorOperationListener
    extends IndexingOperationListener {
        private RealTimePercolatorOperationListener() {
        }

        @Override
        public Engine.Create preCreate(Engine.Create create) {
            if (".percolator".equals(create.type())) {
                PercolatorQueriesRegistry.this.parsePercolatorDocument(create.id(), create.source());
            }
            return create;
        }

        @Override
        public void postCreateUnderLock(Engine.Create create) {
            if (".percolator".equals(create.type())) {
                PercolatorQueriesRegistry.this.addPercolateQuery(create.id(), create.source());
            }
        }

        @Override
        public Engine.Index preIndex(Engine.Index index) {
            if (".percolator".equals(index.type())) {
                PercolatorQueriesRegistry.this.parsePercolatorDocument(index.id(), index.source());
            }
            return index;
        }

        @Override
        public void postIndexUnderLock(Engine.Index index) {
            if (".percolator".equals(index.type())) {
                PercolatorQueriesRegistry.this.addPercolateQuery(index.id(), index.source());
            }
        }

        @Override
        public void postDeleteUnderLock(Engine.Delete delete) {
            if (".percolator".equals(delete.type())) {
                PercolatorQueriesRegistry.this.removePercolateQuery(delete.id());
            }
        }
    }

    private class ShardLifecycleListener
    extends IndicesLifecycle.Listener {
        private ShardLifecycleListener() {
        }

        @Override
        public void afterIndexShardCreated(IndexShard indexShard) {
            if (this.hasPercolatorType(indexShard)) {
                PercolatorQueriesRegistry.this.enableRealTimePercolator();
            }
        }

        @Override
        public void beforeIndexShardPostRecovery(IndexShard indexShard) {
            if (this.hasPercolatorType(indexShard)) {
                PercolatorQueriesRegistry.this.logger.trace("loading percolator queries for [{}]...", PercolatorQueriesRegistry.this.shardId);
                int loadedQueries = this.loadQueries(indexShard);
                PercolatorQueriesRegistry.this.logger.debug("done loading [{}] percolator queries for [{}]", loadedQueries, PercolatorQueriesRegistry.this.shardId);
            }
        }

        private boolean hasPercolatorType(IndexShard indexShard) {
            ShardId otherShardId = indexShard.shardId();
            return PercolatorQueriesRegistry.this.shardId.equals(otherShardId) && PercolatorQueriesRegistry.this.mapperService.hasMapping(".percolator");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int loadQueries(IndexShard shard) {
            shard.refresh("percolator_load_queries");
            try (Engine.Searcher searcher = shard.engine().acquireSearcher("percolator_load_queries");){
                TermQuery query = new TermQuery(new Term("_type", ".percolator"));
                QueriesLoaderCollector queryCollector = new QueriesLoaderCollector(PercolatorQueriesRegistry.this, PercolatorQueriesRegistry.this.logger, PercolatorQueriesRegistry.this.mapperService, PercolatorQueriesRegistry.this.indexFieldDataService);
                IndexSearcher indexSearcher = new IndexSearcher(searcher.reader());
                indexSearcher.setQueryCache(null);
                indexSearcher.search((Query)query, (Collector)queryCollector);
                Map<BytesRef, Query> queries = queryCollector.queries();
                for (Map.Entry<BytesRef, Query> entry : queries.entrySet()) {
                    Query previousQuery = PercolatorQueriesRegistry.this.percolateQueries.put(entry.getKey(), entry.getValue());
                    PercolatorQueriesRegistry.this.shardPercolateService.addedQuery(entry.getKey(), previousQuery, entry.getValue());
                }
                int n = queries.size();
                return n;
            }
            catch (Exception e) {
                throw new PercolatorException(PercolatorQueriesRegistry.this.shardId.index(), "failed to load queries from percolator index", e);
            }
        }
    }

    private class PercolateTypeListener
    implements DocumentTypeListener {
        private PercolateTypeListener() {
        }

        @Override
        public void beforeCreate(DocumentMapper mapper) {
            if (".percolator".equals(mapper.type())) {
                PercolatorQueriesRegistry.this.enableRealTimePercolator();
            }
        }
    }
}

