/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.Template;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class SearchRequest
extends ActionRequest<SearchRequest>
implements IndicesRequest.Replaceable {
    private SearchType searchType = SearchType.DEFAULT;
    private String[] indices;
    @Nullable
    private String routing;
    @Nullable
    private String preference;
    private BytesReference templateSource;
    private Template template;
    private BytesReference source;
    private BytesReference extraSource;
    private Boolean requestCache;
    private Scroll scroll;
    private String[] types = Strings.EMPTY_ARRAY;
    public static final IndicesOptions DEFAULT_INDICES_OPTIONS = IndicesOptions.strictExpandOpenAndForbidClosed();
    private IndicesOptions indicesOptions = DEFAULT_INDICES_OPTIONS;

    public SearchRequest() {
    }

    public SearchRequest(SearchRequest searchRequest, ActionRequest originalRequest) {
        super(originalRequest);
        this.searchType = searchRequest.searchType;
        this.indices = searchRequest.indices;
        this.routing = searchRequest.routing;
        this.preference = searchRequest.preference;
        this.templateSource = searchRequest.templateSource;
        this.template = searchRequest.template;
        this.source = searchRequest.source;
        this.extraSource = searchRequest.extraSource;
        this.requestCache = searchRequest.requestCache;
        this.scroll = searchRequest.scroll;
        this.types = searchRequest.types;
        this.indicesOptions = searchRequest.indicesOptions;
    }

    public SearchRequest(ActionRequest request) {
        super(request);
    }

    public SearchRequest(String ... indices) {
        this.indices(indices);
    }

    public SearchRequest(String[] indices, byte[] source) {
        this.indices(indices);
        this.source = new BytesArray(source);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        return validationException;
    }

    @Override
    public SearchRequest indices(String ... indices) {
        if (indices == null) {
            throw new IllegalArgumentException("indices must not be null");
        }
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] != null) continue;
            throw new IllegalArgumentException("indices[" + i + "] must not be null");
        }
        this.indices = indices;
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public SearchRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public String[] types() {
        return this.types;
    }

    public SearchRequest types(String ... types) {
        this.types = types;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public SearchRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public SearchRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString(routings);
        return this;
    }

    public SearchRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public SearchRequest searchType(SearchType searchType) {
        this.searchType = searchType;
        return this;
    }

    public SearchRequest searchType(String searchType) {
        return this.searchType(SearchType.fromString(searchType, ParseFieldMatcher.EMPTY));
    }

    public SearchRequest source(SearchSourceBuilder sourceBuilder) {
        this.source = sourceBuilder.buildAsBytes(Requests.CONTENT_TYPE);
        return this;
    }

    public SearchRequest source(String source) {
        this.source = new BytesArray(source);
        return this;
    }

    public SearchRequest source(Map source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(Requests.CONTENT_TYPE);
            builder.map(source);
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public SearchRequest source(XContentBuilder builder) {
        this.source = builder.bytes();
        return this;
    }

    public SearchRequest source(byte[] source) {
        return this.source(source, 0, source.length);
    }

    public SearchRequest source(byte[] source, int offset, int length) {
        return this.source(new BytesArray(source, offset, length));
    }

    public SearchRequest source(BytesReference source) {
        this.source = source;
        return this;
    }

    public BytesReference source() {
        return this.source;
    }

    public BytesReference templateSource() {
        return this.templateSource;
    }

    public SearchRequest extraSource(SearchSourceBuilder sourceBuilder) {
        if (sourceBuilder == null) {
            this.extraSource = null;
            return this;
        }
        this.extraSource = sourceBuilder.buildAsBytes(Requests.CONTENT_TYPE);
        return this;
    }

    public SearchRequest extraSource(Map extraSource) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(Requests.CONTENT_TYPE);
            builder.map(extraSource);
            return this.extraSource(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + extraSource + "]", e);
        }
    }

    public SearchRequest extraSource(XContentBuilder builder) {
        this.extraSource = builder.bytes();
        return this;
    }

    public SearchRequest extraSource(String source) {
        this.extraSource = new BytesArray(source);
        return this;
    }

    public SearchRequest extraSource(byte[] source) {
        return this.extraSource(source, 0, source.length);
    }

    public SearchRequest extraSource(byte[] source, int offset, int length) {
        return this.extraSource(new BytesArray(source, offset, length));
    }

    public SearchRequest extraSource(BytesReference source) {
        this.extraSource = source;
        return this;
    }

    public SearchRequest templateSource(BytesReference template) {
        this.templateSource = template;
        return this;
    }

    public SearchRequest templateSource(String template) {
        this.templateSource = new BytesArray(template);
        return this;
    }

    public void template(Template template) {
        this.template = template;
    }

    public Template template() {
        return this.template;
    }

    @Deprecated
    public void templateName(String templateName) {
        this.updateOrCreateScript(templateName, null, null, null);
    }

    @Deprecated
    public void templateType(ScriptService.ScriptType templateType) {
        this.updateOrCreateScript(null, templateType, null, null);
    }

    @Deprecated
    public void templateParams(Map<String, Object> params) {
        this.updateOrCreateScript(null, null, null, params);
    }

    @Deprecated
    public String templateName() {
        return this.template == null ? null : this.template.getScript();
    }

    @Deprecated
    public ScriptService.ScriptType templateType() {
        return this.template == null ? null : this.template.getType();
    }

    @Deprecated
    public Map<String, Object> templateParams() {
        return this.template == null ? null : this.template.getParams();
    }

    private void updateOrCreateScript(String templateContent, ScriptService.ScriptType type, String lang, Map<String, Object> params) {
        Template template = this.template();
        if (template == null) {
            template = new Template(templateContent == null ? "" : templateContent, type == null ? ScriptService.ScriptType.INLINE : type, lang, null, params);
        } else {
            String newTemplateContent = templateContent == null ? template.getScript() : templateContent;
            ScriptService.ScriptType newTemplateType = type == null ? template.getType() : type;
            String newTemplateLang = lang == null ? template.getLang() : lang;
            Map<String, Object> newTemplateParams = params == null ? template.getParams() : params;
            template = new Template(newTemplateContent, newTemplateType, "mustache", null, newTemplateParams);
        }
        this.template(template);
    }

    public BytesReference extraSource() {
        return this.extraSource;
    }

    public SearchType searchType() {
        return this.searchType;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    public Scroll scroll() {
        return this.scroll;
    }

    public SearchRequest scroll(Scroll scroll) {
        this.scroll = scroll;
        return this;
    }

    public SearchRequest scroll(TimeValue keepAlive) {
        return this.scroll(new Scroll(keepAlive));
    }

    public SearchRequest scroll(String keepAlive) {
        return this.scroll(new Scroll(TimeValue.parseTimeValue(keepAlive, null, this.getClass().getSimpleName() + ".Scroll.keepAlive")));
    }

    public SearchRequest requestCache(Boolean requestCache) {
        this.requestCache = requestCache;
        return this;
    }

    public Boolean requestCache() {
        return this.requestCache;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.searchType = SearchType.fromId(in.readByte());
        this.indices = new String[in.readVInt()];
        for (int i = 0; i < this.indices.length; ++i) {
            this.indices[i] = in.readString();
        }
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        if (in.readBoolean()) {
            this.scroll = Scroll.readScroll(in);
        }
        this.source = in.readBytesReference();
        this.extraSource = in.readBytesReference();
        this.types = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.templateSource = in.readBytesReference();
        if (in.readBoolean()) {
            this.template = Template.readTemplate(in);
        }
        this.requestCache = in.readOptionalBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.searchType.id());
        out.writeVInt(this.indices.length);
        for (String index : this.indices) {
            out.writeString(index);
        }
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        if (this.scroll == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.scroll.writeTo(out);
        }
        out.writeBytesReference(this.source);
        out.writeBytesReference(this.extraSource);
        out.writeStringArray(this.types);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeBytesReference(this.templateSource);
        boolean hasTemplate = this.template != null;
        out.writeBoolean(hasTemplate);
        if (hasTemplate) {
            this.template.writeTo(out);
        }
        out.writeOptionalBoolean(this.requestCache);
    }
}

