/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchTransportRequest;
import org.elasticsearch.threadpool.ThreadPool;

class SearchQueryAndFetchAsyncAction
extends AbstractSearchAsyncAction<QueryFetchSearchResult> {
    SearchQueryAndFetchAsyncAction(ESLogger logger, SearchServiceTransportAction searchService, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, SearchPhaseController searchPhaseController, ThreadPool threadPool, SearchRequest request, ActionListener<SearchResponse> listener) {
        super(logger, searchService, clusterService, indexNameExpressionResolver, searchPhaseController, threadPool, request, listener);
    }

    @Override
    protected String firstPhaseName() {
        return "query_fetch";
    }

    @Override
    protected void sendExecuteFirstPhase(DiscoveryNode node, ShardSearchTransportRequest request, ActionListener<QueryFetchSearchResult> listener) {
        this.searchService.sendExecuteFetch(node, request, listener);
    }

    @Override
    protected void moveToSecondPhase() throws Exception {
        this.threadPool.executor("search").execute(new ActionRunnable<SearchResponse>(this.listener){

            @Override
            public void doRun() throws IOException {
                boolean useScroll = SearchQueryAndFetchAsyncAction.this.request.scroll() != null;
                SearchQueryAndFetchAsyncAction.this.sortedShardList = SearchQueryAndFetchAsyncAction.this.searchPhaseController.sortDocs(useScroll, SearchQueryAndFetchAsyncAction.this.firstResults);
                InternalSearchResponse internalResponse = SearchQueryAndFetchAsyncAction.this.searchPhaseController.merge(SearchQueryAndFetchAsyncAction.this.sortedShardList, SearchQueryAndFetchAsyncAction.this.firstResults, SearchQueryAndFetchAsyncAction.this.firstResults, SearchQueryAndFetchAsyncAction.this.request);
                String scrollId = null;
                if (SearchQueryAndFetchAsyncAction.this.request.scroll() != null) {
                    scrollId = TransportSearchHelper.buildScrollId(SearchQueryAndFetchAsyncAction.this.request.searchType(), (AtomicArray<? extends SearchPhaseResult>)SearchQueryAndFetchAsyncAction.this.firstResults, null);
                }
                this.listener.onResponse(new SearchResponse(internalResponse, scrollId, SearchQueryAndFetchAsyncAction.this.expectedSuccessfulOps, SearchQueryAndFetchAsyncAction.this.successfulOps.get(), SearchQueryAndFetchAsyncAction.this.buildTookInMillis(), SearchQueryAndFetchAsyncAction.this.buildShardFailures()));
            }

            @Override
            public void onFailure(Throwable t) {
                ReduceSearchPhaseException failure = new ReduceSearchPhaseException("merge", "", t, SearchQueryAndFetchAsyncAction.this.buildShardFailures());
                if (SearchQueryAndFetchAsyncAction.this.logger.isDebugEnabled()) {
                    SearchQueryAndFetchAsyncAction.this.logger.debug("failed to reduce search", failure, new Object[0]);
                }
                super.onFailure(failure);
            }
        });
    }
}

