/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.percolate;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.TransportGetAction;
import org.elasticsearch.action.percolate.PercolateRequest;
import org.elasticsearch.action.percolate.PercolateResponse;
import org.elasticsearch.action.percolate.PercolateShardRequest;
import org.elasticsearch.action.percolate.PercolateShardResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.TransportBroadcastAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.percolator.PercolateException;
import org.elasticsearch.percolator.PercolatorService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPercolateAction
extends TransportBroadcastAction<PercolateRequest, PercolateResponse, PercolateShardRequest, PercolateShardResponse> {
    private final PercolatorService percolatorService;
    private final TransportGetAction getAction;

    @Inject
    public TransportPercolateAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, PercolatorService percolatorService, TransportGetAction getAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:data/read/percolate", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, PercolateRequest.class, PercolateShardRequest.class, "percolate");
        this.percolatorService = percolatorService;
        this.getAction = getAction;
    }

    @Override
    protected void doExecute(final Task task, final PercolateRequest request, final ActionListener<PercolateResponse> listener) {
        request.startTime = System.currentTimeMillis();
        if (request.getRequest() != null) {
            GetRequest getRequest = new GetRequest(request.getRequest(), request);
            this.getAction.execute(getRequest, new ActionListener<GetResponse>(){

                @Override
                public void onResponse(GetResponse getResponse) {
                    if (!getResponse.isExists()) {
                        this.onFailure(new DocumentMissingException(null, request.getRequest().type(), request.getRequest().id()));
                        return;
                    }
                    BytesReference docSource = getResponse.getSourceAsBytesRef();
                    TransportPercolateAction.super.doExecute(task, new PercolateRequest(request, docSource), listener);
                }

                @Override
                public void onFailure(Throwable e) {
                    listener.onFailure(e);
                }
            });
        } else {
            super.doExecute(task, request, listener);
        }
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, PercolateRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, PercolateRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.READ, concreteIndices);
    }

    @Override
    protected PercolateResponse newResponse(PercolateRequest request, AtomicReferenceArray shardsResponses, ClusterState clusterState) {
        return TransportPercolateAction.reduce(request, shardsResponses, this.percolatorService);
    }

    public static PercolateResponse reduce(PercolateRequest request, AtomicReferenceArray shardsResponses, PercolatorService percolatorService) {
        int successfulShards = 0;
        int failedShards = 0;
        ArrayList<PercolateShardResponse> shardResults = null;
        ArrayList<ShardOperationFailedException> shardFailures = null;
        byte percolatorTypeId = 0;
        for (int i = 0; i < shardsResponses.length(); ++i) {
            Object shardResponse = shardsResponses.get(i);
            if (shardResponse == null) continue;
            if (shardResponse instanceof BroadcastShardOperationFailedException) {
                ++failedShards;
                if (shardFailures == null) {
                    shardFailures = new ArrayList<ShardOperationFailedException>();
                }
                shardFailures.add(new DefaultShardOperationFailedException((BroadcastShardOperationFailedException)shardResponse));
                continue;
            }
            PercolateShardResponse percolateShardResponse = (PercolateShardResponse)shardResponse;
            ++successfulShards;
            if (percolateShardResponse.isEmpty()) continue;
            if (shardResults == null) {
                percolatorTypeId = percolateShardResponse.percolatorTypeId();
                shardResults = new ArrayList<PercolateShardResponse>();
            }
            shardResults.add(percolateShardResponse);
        }
        if (shardResults == null) {
            long tookInMillis = Math.max(1L, System.currentTimeMillis() - request.startTime);
            PercolateResponse.Match[] matches = request.onlyCount() ? null : PercolateResponse.EMPTY;
            return new PercolateResponse(shardsResponses.length(), successfulShards, failedShards, shardFailures, tookInMillis, matches);
        }
        PercolatorService.ReduceResult result = percolatorService.reduce(percolatorTypeId, shardResults, request);
        long tookInMillis = Math.max(1L, System.currentTimeMillis() - request.startTime);
        return new PercolateResponse(shardsResponses.length(), successfulShards, failedShards, shardFailures, result.matches(), result.count(), tookInMillis, result.reducedAggregations());
    }

    @Override
    protected PercolateShardRequest newShardRequest(int numShards, ShardRouting shard, PercolateRequest request) {
        return new PercolateShardRequest(shard.shardId(), numShards, request);
    }

    @Override
    protected PercolateShardResponse newShardResponse() {
        return new PercolateShardResponse();
    }

    @Override
    protected GroupShardsIterator shards(ClusterState clusterState, PercolateRequest request, String[] concreteIndices) {
        Map<String, Set<String>> routingMap = this.indexNameExpressionResolver.resolveSearchRouting(clusterState, request.routing(), request.indices());
        return this.clusterService.operationRouting().searchShards(clusterState, concreteIndices, routingMap, request.preference());
    }

    @Override
    protected PercolateShardResponse shardOperation(PercolateShardRequest request) {
        try {
            return this.percolatorService.percolate(request);
        }
        catch (Throwable e) {
            this.logger.trace("{} failed to percolate", e, request.shardId());
            throw new PercolateException(request.shardId(), "failed to percolate", e);
        }
    }
}

