/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.repositories.verify;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentHelper;

public class VerifyRepositoryResponse
extends ActionResponse
implements ToXContent {
    private DiscoveryNode[] nodes;
    private ClusterName clusterName;

    VerifyRepositoryResponse() {
    }

    public VerifyRepositoryResponse(ClusterName clusterName, DiscoveryNode[] nodes) {
        this.clusterName = clusterName;
        this.nodes = nodes;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.clusterName = ClusterName.readClusterName(in);
        this.nodes = new DiscoveryNode[in.readVInt()];
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i] = DiscoveryNode.readNode(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.clusterName.writeTo(out);
        out.writeVInt(this.nodes.length);
        for (DiscoveryNode node : this.nodes) {
            node.writeTo(out);
        }
    }

    public DiscoveryNode[] getNodes() {
        return this.nodes;
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.NODES);
        for (DiscoveryNode node : this.nodes) {
            builder.startObject(node.id(), XContentBuilder.FieldCaseConversion.NONE);
            builder.field(Fields.NAME, node.name(), XContentBuilder.FieldCaseConversion.NONE);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return XContentHelper.toString(this);
    }

    static final class Fields {
        static final XContentBuilderString NODES = new XContentBuilderString("nodes");
        static final XContentBuilderString NAME = new XContentBuilderString("name");

        Fields() {
        }
    }
}

