/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.osgi.service.prefs.BackingStoreException;

public class LineDelimiterEditor {
    private Button defaultButton;
    private Button otherButton;
    private Combo choiceCombo;
    private IProject project;

    public LineDelimiterEditor(Composite composite) {
        this(composite, null);
    }

    public LineDelimiterEditor(Composite composite, IProject project) {
        this.project = project;
        this.createControl(composite);
    }

    protected void createControl(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        GridData data = new GridData(768);
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setText(IDEWorkbenchMessages.IDEWorkspacePreference_fileLineDelimiter);
        group.setFont(font);
        SelectionAdapter buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget.equals(LineDelimiterEditor.this.defaultButton)) {
                    LineDelimiterEditor.this.updateState(true);
                } else {
                    LineDelimiterEditor.this.updateState(false);
                }
            }
        };
        this.defaultButton = new Button((Composite)group, 16);
        if (this.project == null) {
            this.defaultButton.setText(IDEWorkbenchMessages.IDEWorkspacePreference_defaultLineDelim);
        } else {
            this.defaultButton.setText(IDEWorkbenchMessages.IDEWorkspacePreference_defaultLineDelimProj);
        }
        data = new GridData();
        data.horizontalSpan = 2;
        this.defaultButton.setLayoutData((Object)data);
        this.defaultButton.addSelectionListener((SelectionListener)buttonListener);
        this.defaultButton.setFont(font);
        this.otherButton = new Button((Composite)group, 16);
        this.otherButton.setText(IDEWorkbenchMessages.IDEWorkspacePreference_otherLineDelim);
        this.otherButton.addSelectionListener((SelectionListener)buttonListener);
        this.otherButton.setFont(font);
        this.choiceCombo = new Combo((Composite)group, 8);
        data = new GridData();
        this.choiceCombo.setFont(font);
        this.choiceCombo.setLayoutData((Object)data);
        this.populateChoiceCombo(this.getChoices());
    }

    public void doLoad() {
        if (this.choiceCombo != null) {
            this.populateChoiceCombo(this.getChoices());
            String resourcePreference = this.getStoredValue();
            this.updateState(resourcePreference == null);
        }
    }

    public void loadDefault() {
        this.doLoad();
    }

    public String getStoredValue() {
        IScopeContext[] scopeContext = new IScopeContext[]{this.getScopeContext()};
        IEclipsePreferences node = scopeContext[0].getNode("org.eclipse.core.runtime");
        return node.get("line.separator", null);
    }

    private IScopeContext getScopeContext() {
        if (this.project != null) {
            return new ProjectScope(this.project);
        }
        return new InstanceScope();
    }

    protected String[] getChoices() {
        Set keys = Platform.knownPlatformLineSeparators().keySet();
        String[] keyArray = new String[keys.size()];
        keys.toArray(keyArray);
        return keyArray;
    }

    private void populateChoiceCombo(String[] items) {
        this.choiceCombo.setItems(items);
        if (this.getStoredValue() == null) {
            this.choiceCombo.setText("");
        } else {
            this.selectChoice();
        }
    }

    private void updateState(boolean useDefault) {
        if (useDefault) {
            this.defaultButton.setSelection(true);
            this.otherButton.setSelection(false);
            this.choiceCombo.setEnabled(false);
        } else {
            this.defaultButton.setSelection(false);
            this.otherButton.setSelection(true);
            this.choiceCombo.setEnabled(true);
            this.selectChoice();
        }
    }

    private void selectChoice() {
        String selection = null;
        Map knownValues = Platform.knownPlatformLineSeparators();
        Set keys = knownValues.keySet();
        String current = this.getStoredValue();
        if (current != null) {
            for (String element : keys) {
                if (!knownValues.get(element).equals(current)) continue;
                selection = element;
                break;
            }
        }
        String[] items = this.choiceCombo.getItems();
        int i = 0;
        while (i < items.length) {
            String item = items[i];
            if (item.equals(selection)) {
                this.choiceCombo.select(i);
                break;
            }
            ++i;
        }
    }

    public void store() {
        String val;
        if (this.defaultButton.getSelection() || this.choiceCombo.getText().equals("")) {
            val = null;
        } else {
            Map lineSeparators = Platform.knownPlatformLineSeparators();
            val = (String)lineSeparators.get(this.choiceCombo.getText());
        }
        IEclipsePreferences node = this.getScopeContext().getNode("org.eclipse.core.runtime");
        if (val == null) {
            node.remove("line.separator");
        } else {
            node.put("line.separator", val);
        }
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            IDEWorkbenchPlugin.log(e.getMessage(), e);
        }
    }
}

