/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

public class AddArchiveToBuildpathAction
extends Action
implements ISelectionChangedListener {
    private final IWorkbenchSite fSite;
    private IJavaProject fJavaProject;

    public AddArchiveToBuildpathAction(IWorkbenchSite site) {
        super(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddJarCP_label, JavaPluginImages.DESC_OBJS_EXTJAR);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddJarCP_tooltip);
        this.fSite = site;
    }

    public void run() {
        Shell shell = this.fSite.getShell() != null ? this.fSite.getShell() : JavaPlugin.getActiveWorkbenchShell();
        final IPath[] selected = BuildPathDialogAccess.chooseExternalJAREntries(shell);
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        List result = AddArchiveToBuildpathAction.this.addExternalJars(selected == null ? new IPath[]{} : selected, AddArchiveToBuildpathAction.this.fJavaProject, monitor);
                        if (result != null && result.size() > 0) {
                            AddArchiveToBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(result));
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)e.getCause());
            } else {
                JavaPlugin.log(e);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    protected List addExternalJars(IPath[] jarPaths, IJavaProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ArrayList<CPListElement> addedEntries = new ArrayList<CPListElement>();
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_AddToBuildpath, 4);
            if (jarPaths != null) {
                int i = 0;
                while (i < jarPaths.length) {
                    addedEntries.add(new CPListElement(project, 1, jarPaths[i], null));
                    ++i;
                }
                monitor.worked(1);
                List existingEntries = ClasspathModifier.getExistingEntries(project);
                ClasspathModifier.setNewEntry(existingEntries, addedEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ClasspathModifier.commitClassPath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>(addedEntries.size());
                int i2 = 0;
                while (i2 < addedEntries.size()) {
                    IClasspathEntry entry = ((CPListElement)addedEntries.get(i2)).getClasspathEntry();
                    IPackageFragmentRoot elem = project.findPackageFragmentRoot(entry.getPath());
                    if (elem != null) {
                        result.add(elem);
                    }
                    ++i2;
                }
                monitor.worked(1);
                ArrayList<IPackageFragmentRoot> arrayList = result;
                return arrayList;
            }
        }
        finally {
            monitor.done();
        }
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.setEnabled(this.canHandle((IStructuredSelection)selection));
        } else {
            this.setEnabled(this.canHandle((IStructuredSelection)StructuredSelection.EMPTY));
        }
    }

    private boolean canHandle(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        Object first = selection.getFirstElement();
        if (!(first instanceof IJavaProject)) {
            return false;
        }
        this.fJavaProject = (IJavaProject)first;
        return true;
    }

    private void showExceptionDialog(CoreException exception) {
        this.showError(exception, this.fSite.getShell(), NewWizardMessages.AddArchiveToBuildpathAction_ErrorTitle, exception.getMessage());
    }

    private void showError(CoreException e, Shell shell, String title, String message) {
        IStatus status = e.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)message, (String)title, (IStatus)status);
        } else {
            MessageDialog.openError((Shell)shell, (String)title, (String)message);
        }
    }

    private void selectAndReveal(final ISelection selection) {
        IWorkbenchPage page = this.fSite.getPage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IWorkbenchPart part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        for (IWorkbenchPart part : parts) {
            ISetSelectionTarget target = null;
            target = part instanceof ISetSelectionTarget ? (ISetSelectionTarget)part : (ISetSelectionTarget)part.getAdapter(ISetSelectionTarget.class);
            if (target == null) continue;
            final ISetSelectionTarget finalTarget = target;
            page.getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    finalTarget.selectReveal(selection);
                }
            });
        }
    }
}

