/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.model;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.model.CVSModelElement;
import org.eclipse.team.internal.ccvs.ui.model.RepositoryLocationSchedulingRule;
import org.eclipse.team.internal.ccvs.ui.operations.FetchMembersOperation;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class CVSTagElement
extends CVSModelElement
implements IDeferredWorkbenchAdapter {
    CVSTag tag;
    ICVSRepositoryLocation root;
    private static final String REPO_VIEW_LONG_FORAMT = "dd MMM yyyy HH:mm:ss";
    private static final String REPO_VIEW_SHORT_FORMAT = "dd MMM yyyy";
    private static final String TIME_ONLY_COLUMN_FORMAT = "HH:mm:ss";
    private static SimpleDateFormat localLongFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss", Locale.getDefault());
    private static SimpleDateFormat localShortFormat = new SimpleDateFormat("dd MMM yyyy", Locale.getDefault());
    private static SimpleDateFormat timeColumnFormat = new SimpleDateFormat("HH:mm:ss", Locale.getDefault());

    public static synchronized String toDisplayString(Date date) {
        String localTime = timeColumnFormat.format(date);
        timeColumnFormat.setTimeZone(TimeZone.getDefault());
        if (localTime.equals("00:00:00")) {
            return localShortFormat.format(date);
        }
        return localLongFormat.format(date);
    }

    public CVSTagElement(CVSTag tag, ICVSRepositoryLocation root) {
        this.tag = tag;
        this.root = root;
    }

    public ICVSRepositoryLocation getRoot() {
        return this.root;
    }

    public CVSTag getTag() {
        return this.tag;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CVSTagElement)) {
            return false;
        }
        CVSTagElement t = (CVSTagElement)o;
        if (!this.tag.equals((Object)t.tag)) {
            return false;
        }
        return this.root.equals(t.root);
    }

    public int hashCode() {
        return this.root.hashCode() ^ this.tag.hashCode();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        if (!(object instanceof CVSTagElement)) {
            return null;
        }
        if (this.tag.getType() == 1 || this.tag.getType() == 0) {
            return CVSUIPlugin.getPlugin().getImageDescriptor("obj16/tag.gif");
        }
        if (this.tag.getType() == 2) {
            return CVSUIPlugin.getPlugin().getImageDescriptor("obj16/prjversions_rep.gif");
        }
        return CVSUIPlugin.getPlugin().getImageDescriptor("obj16/date.gif");
    }

    public String getLabel(Object o) {
        Date date;
        if (!(o instanceof CVSTagElement)) {
            return null;
        }
        CVSTag aTag = ((CVSTagElement)o).tag;
        if (aTag.getType() == 3 && (date = this.tag.asDate()) != null) {
            return CVSTagElement.toDisplayString(date);
        }
        return aTag.getName();
    }

    public String toString() {
        return this.tag.getName();
    }

    public Object getParent(Object o) {
        if (!(o instanceof CVSTagElement)) {
            return null;
        }
        return ((CVSTagElement)o).root;
    }

    protected Object[] fetchChildren(Object o, IProgressMonitor monitor) throws TeamException {
        Object[] children = CVSUIPlugin.getPlugin().getRepositoryManager().getFoldersForTag(this.root, this.tag, monitor);
        if (this.getWorkingSet() != null) {
            children = CVSUIPlugin.getPlugin().getRepositoryManager().filterResources(this.getWorkingSet(), (ICVSRemoteResource[])children);
        }
        return children;
    }

    public void fetchDeferredChildren(Object o, IElementCollector collector, IProgressMonitor monitor) {
        if (this.tag.getType() == 0 || this.tag.getType() == 3) {
            try {
                try {
                    monitor = Policy.monitorFor(monitor);
                    RemoteFolder folder = new RemoteFolder(null, this.root, "", this.tag);
                    monitor.beginTask(NLS.bind((String)CVSUIMessages.RemoteFolderElement_fetchingRemoteChildren, (Object[])new String[]{this.root.toString()}), 100);
                    FetchMembersOperation operation = new FetchMembersOperation(null, (ICVSRemoteFolder)folder, collector);
                    operation.setFilter(new FetchMembersOperation.RemoteFolderFilter(){

                        public ICVSRemoteResource[] filter(ICVSRemoteResource[] folders) {
                            return CVSUIPlugin.getPlugin().getRepositoryManager().filterResources(CVSTagElement.this.getWorkingSet(), folders);
                        }
                    });
                    operation.run(Policy.subMonitorFor(monitor, 100));
                }
                catch (InvocationTargetException e) {
                    this.handle(collector, e);
                }
                catch (InterruptedException interruptedException) {}
            }
            finally {
                monitor.done();
            }
        } else {
            try {
                collector.add(this.fetchChildren(o, monitor), monitor);
            }
            catch (TeamException e) {
                this.handle(collector, e);
            }
        }
    }

    public ISchedulingRule getRule(Object element) {
        return new RepositoryLocationSchedulingRule(this.root);
    }

    public boolean isContainer() {
        return true;
    }
}

