/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.extensions.internal.templates;

import java.io.File;

import org.eclipse.wst.rdb.server.extensions.internal.util.Utility;

/**
 * @author groux
 */
public class SQLTemplate
{

	protected String objectClass;
	protected String vendorId;
	protected File file;
	protected String title;
	
	protected String ddl = null;
	
	public SQLTemplate(String objectClass, String vendorId, File file, String title)
	{
		this.objectClass = objectClass;
		this.vendorId = vendorId;		
		this.file = file;
		this.title = title;
	}
	
	public String getDdl()
	{
		if (ddl == null) {
			ddl = Utility.getSourceFromFile(file);
		}
		return ddl;
	}

	public String getTitle() {
		return title;
	}
}
