/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design.editparts;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.wst.wsdl.ui.internal.asd.design.DesignViewGraphicsConstants;
import org.eclipse.wst.wsdl.ui.internal.asd.design.directedit.LabelCellEditorLocator;
import org.eclipse.wst.wsdl.ui.internal.asd.design.directedit.LabelEditManager;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.BaseEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.INamedEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDLabelDirectEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDSelectionEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.asd.design.figures.HeadingFigure;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IService;

public class ServiceEditPart
extends BaseEditPart
implements INamedEditPart {
    IFigure contentPane;
    HeadingFigure headingFigure;
    private DirectEditManager manager;

    public void addFeedback() {
        LineBorder boxFigureLineBorder = (LineBorder)this.figure.getBorder();
        boxFigureLineBorder.setWidth(2);
        this.headingFigure.setSelected(true);
        this.figure.repaint();
    }

    public void removeFeedback() {
        LineBorder boxFigureLineBorder = (LineBorder)this.figure.getBorder();
        boxFigureLineBorder.setWidth(1);
        boxFigureLineBorder.setColor(ColorConstants.black);
        this.headingFigure.setSelected(false);
        this.figure.repaint();
    }

    protected IFigure createFigure() {
        Figure figure = new Figure();
        figure.setBorder((Border)new LineBorder(1));
        ToolbarLayout toolbarLayout = new ToolbarLayout(false);
        toolbarLayout.setStretchMinorAxis(true);
        figure.setLayoutManager((LayoutManager)toolbarLayout);
        this.headingFigure = new HeadingFigure();
        this.headingFigure.getLabel().setIcon(((IService)this.getModel()).getImage());
        figure.add((IFigure)this.headingFigure);
        this.contentPane = new Figure(){

            public void paint(Graphics graphics) {
                super.paint(graphics);
                boolean isFirst = false;
                Iterator i = this.getChildren().iterator();
                while (i.hasNext()) {
                    Figure figure = (Figure)i.next();
                    if (isFirst) {
                        isFirst = false;
                        continue;
                    }
                    Rectangle r = figure.getBounds();
                    graphics.drawLine(r.x, r.y + 1, r.x + r.width, r.y + 1);
                }
            }
        };
        ToolbarLayout toolbarLayout2 = new ToolbarLayout(false);
        toolbarLayout2.setStretchMinorAxis(true);
        this.contentPane.setLayoutManager((LayoutManager)toolbarLayout2);
        figure.add(this.contentPane);
        if (this.isReadOnly()) {
            this.headingFigure.getLabel().setForegroundColor(DesignViewGraphicsConstants.readOnlyLabelColor);
        } else {
            this.headingFigure.getLabel().setForegroundColor(ColorConstants.black);
        }
        return figure;
    }

    public IFigure getContentPane() {
        return this.contentPane;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ASDLabelDirectEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ASDSelectionEditPolicy());
    }

    public void performDirectEdit(Point cursorLocation) {
        if (cursorLocation == null || this.hitTest(this.headingFigure.getLabel(), cursorLocation) && !this.isReadOnly()) {
            this.manager = new LabelEditManager((GraphicalEditPart)this, new LabelCellEditorLocator(this, cursorLocation));
            this.manager.show();
        } else if ((this.hitTest(this.headingFigure.getLabel(), cursorLocation) || this.hitTestFigure(this.headingFigure, cursorLocation)) && this.isReadOnly()) {
            this.doOpenNewEditor();
        }
    }

    public void performRequest(Request req) {
        if (req.getType().equals("direct edit")) {
            this.performDirectEdit(null);
        }
    }

    public Label getLabelFigure() {
        return this.headingFigure.getLabel();
    }

    protected List getModelChildren() {
        IService service = (IService)this.getModel();
        return service.getEndPoints();
    }

    protected void refreshVisuals() {
        IService service = (IService)this.getModel();
        this.headingFigure.setIsReadOnly(service.isReadOnly());
        this.headingFigure.getLabel().setText(service.getName());
        super.refreshVisuals();
    }
}

