/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitoractions;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitoractions.JavaMofBeanVisitorAction;
import org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitoractions.JavaMofParameterVisitorAction;
import org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitors.JavaMofParameterVisitor;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.BeanModelElementsFactory;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.MethodElement;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.TypeFactory;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.ws.internal.datamodel.Element;

public class JavaMofMethodVisitorAction
extends JavaMofBeanVisitorAction {
    public String fUnsupportedParameterName;
    protected Vector fMethodsOmitted = new Vector();
    protected Vector fMethodsProcessed = new Vector();

    public JavaMofMethodVisitorAction(Element parentElement, String project, IEnvironment env) {
        super(parentElement, project, env);
    }

    public IStatus visit(Object imethod) {
        IStatus status = Status.OK_STATUS;
        Method method = (Method)imethod;
        if (this.methodCheck(method)) {
            if (!this.parameterCheck(method)) {
                status = StatusUtils.warningStatus((String)(String.valueOf(ConsumptionMessages.MSG_WARN_JTS_UNSUPPORTED_PARAMETERS_ARRAYS) + this.fUnsupportedParameterName));
                this.fMethodsOmitted.addElement(method.getMethodElementSignature());
                return status;
            }
            if (!this.nullConstructor(method)) {
                status = StatusUtils.warningStatus((String)(String.valueOf(ConsumptionMessages.MSG_WARN_JTS_UNSUPPORTED_PARAMETERS_INPUTS) + this.fUnsupportedParameterName));
                this.fMethodsOmitted.addElement(method.getMethodElementSignature());
                return status;
            }
            MethodElement methodElement = (MethodElement)BeanModelElementsFactory.getBeanModelElement(method, this.fParentElement);
            JavaMofParameterVisitorAction parameterVisitorAction = new JavaMofParameterVisitorAction((Element)methodElement, this.clientProject, this.env_);
            parameterVisitorAction.setStatusMonitor(this.getStatusMonitor());
            JavaMofParameterVisitor parameterVisitor = new JavaMofParameterVisitor(this.env_);
            status = parameterVisitor.run(method, parameterVisitorAction);
            if (status.getSeverity() != 0) {
                this.fMethodsOmitted.addElement(method.getMethodElementSignature());
                methodElement.setMethodOmmission(true);
            } else {
                this.fMethodsProcessed.addElement(method.getMethodElementSignature());
            }
        }
        return status;
    }

    public boolean wereMethodsProcessed() {
        return !this.fMethodsProcessed.isEmpty();
    }

    public boolean wereMethodsOmitted() {
        return !this.fMethodsOmitted.isEmpty();
    }

    public boolean methodCheck(Method method) {
        boolean ok = true;
        if (method.isConstructor()) {
            return false;
        }
        return ok;
    }

    public boolean parameterCheck(Method method) {
        boolean ok = true;
        JavaParameter[] javaParameter = method.listParametersWithoutReturn();
        int i = 0;
        while (i < javaParameter.length) {
            JavaParameter param = javaParameter[i];
            JavaHelpers javaHelper1 = param.getJavaType();
            if (TypeFactory.isUnSupportedType(javaHelper1)) {
                this.fUnsupportedParameterName = param.getName();
                return false;
            }
            ++i;
        }
        return ok;
    }

    public boolean nullConstructor(Method method) {
        boolean ok = true;
        JavaParameter[] javaParameter = method.listParametersWithoutReturn();
        int i = 0;
        while (i < javaParameter.length) {
            JavaParameter param = javaParameter[i];
            JavaHelpers javaHelper1 = param.getJavaType();
            if (javaHelper1 instanceof JavaClass) {
                JavaClass javaClass = (JavaClass)javaHelper1;
                if (TypeFactory.recognizedBean(javaClass.getJavaName())) {
                    return true;
                }
                Iterator m = javaClass.getMethods().iterator();
                while (m.hasNext()) {
                    Method method2 = (Method)m.next();
                    if (!javaClass.getName().equals(method2.getName())) continue;
                    JavaParameter[] javaParam = method2.listParametersWithoutReturn();
                    if (javaParam.length > 0) {
                        this.fUnsupportedParameterName = param.getName();
                        ok = false;
                        continue;
                    }
                    return true;
                }
            }
            ++i;
        }
        return ok;
    }
}

