/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.core.internal.langlexer;

import java.io.IOException;
import java.util.HashSet;
import org.eclipse.wst.javascript.core.internal.jsparser.lexer.LexerException;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TCommenttok;
import org.eclipse.wst.javascript.core.internal.jsparser.node.Token;
import org.eclipse.wst.javascript.core.internal.langlexer.IRawLexer;
import org.eclipse.wst.javascript.core.internal.langlexer.ITokenCache;

public class CachingLangLexer
implements IRawLexer {
    protected final IRawLexer sublexer;
    protected final ITokenCache cache;
    protected final boolean catchEOLs;
    protected final boolean catchJavaDocs;
    protected final HashSet keywords = new HashSet();

    public CachingLangLexer(ITokenCache cache, IRawLexer sublexer, boolean catchEOLs, boolean catchJavaDocs) {
        this.sublexer = sublexer;
        this.cache = cache;
        this.catchEOLs = catchEOLs;
        this.catchJavaDocs = catchJavaDocs;
        int i = 0;
        String[] keywords = cache.getKeyKeywordArray();
        while (i < keywords.length) {
            this.keywords.add(keywords[i++]);
        }
    }

    public Token getToken() throws IOException, LexerException {
        Token retval = this.sublexer.getToken();
        if (this.catchEOLs && retval.getContainsLineTerminator()) {
            this.cache.remove(retval);
            this.cache.add(retval);
        } else {
            String strTkThis = retval.toString();
            if (this.keywords.contains(strTkThis)) {
                this.cache.remove(retval);
                this.cache.add(retval);
            } else if (this.catchJavaDocs && retval instanceof TCommenttok && strTkThis.startsWith("/**")) {
                this.cache.remove(retval);
                this.cache.add(retval);
            }
        }
        return retval;
    }
}

