/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.internal.operations.PackageOperations;

public class ProfileOperations
extends PackageOperations {
    protected ProfileOperations() {
    }

    public static boolean validateMetaclassReferenceNotSpecialized(Profile profile, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        Iterator referencedMetaclasses = profile.getReferencedMetaclasses().iterator();
        block0: while (result && referencedMetaclasses.hasNext()) {
            Class referencedMetaclass = (Class)referencedMetaclasses.next();
            TreeIterator allContents = ProfileOperations.getAllContents((EObject)profile, (boolean)true, (boolean)false);
            while (allContents.hasNext()) {
                Object object = allContents.next();
                if (!(object instanceof Package) || !ProfileOperations.containsSpecializations((Package)object, referencedMetaclass)) continue;
                result = false;
                break;
            }
            if (!result) continue;
            Iterator allParents = referencedMetaclass.allParents().iterator();
            while (allParents.hasNext()) {
                if (!EcoreUtil.isAncestor((EObject)profile, (EObject)((Classifier)allParents.next()))) continue;
                result = false;
                continue block0;
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 128, UMLPlugin.INSTANCE.getString("_UI_Profile_MetaclassReferenceNotSpecialized_diagnostic", ProfileOperations.getMessageSubstitutions((Map)context, (Object)profile)), new Object[]{profile}));
        }
        return result;
    }

    public static boolean validateReferencesSameMetamodel(Profile profile, DiagnosticChain diagnostics, Map context) {
        UniqueEList.FastCompare metamodels = new UniqueEList.FastCompare((Collection)profile.getReferencedMetamodels());
        Iterator referencedMetaclasses = profile.getReferencedMetaclasses().iterator();
        while (referencedMetaclasses.hasNext()) {
            metamodels.add((Object)((Class)referencedMetaclasses.next()).getModel());
        }
        if (metamodels.size() != 1) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 129, UMLPlugin.INSTANCE.getString("_UI_Profile_ReferencesSameMetamodel_diagnostic", ProfileOperations.getMessageSubstitutions((Map)context, (Object)profile)), new Object[]{profile}));
            }
            return false;
        }
        return true;
    }

    public static EObject create(Profile profile, Classifier classifier) {
        ENamedElement definition = profile.getDefinition(classifier);
        if (definition instanceof EClass) {
            return EcoreUtil.create((EClass)((EClass)definition));
        }
        throw new IllegalArgumentException(String.valueOf(classifier));
    }

    public static ElementImport createMetaclassReference(Profile profile, Class metaclass) {
        if (metaclass == null || profile.getReferencedMetaclasses().contains((Object)metaclass)) {
            throw new IllegalArgumentException(String.valueOf(metaclass));
        }
        ElementImport metaclassReference = profile.createElementImport(metaclass, VisibilityKind.PUBLIC_LITERAL);
        profile.getMetaclassReferences().add((Object)metaclassReference);
        return metaclassReference;
    }

    public static PackageImport createMetamodelReference(Profile profile, Model metamodel) {
        if (metamodel == null || profile.getReferencedMetamodels().contains((Object)metamodel)) {
            throw new IllegalArgumentException(String.valueOf(metamodel));
        }
        PackageImport metamodelReference = profile.createPackageImport(metamodel, VisibilityKind.PUBLIC_LITERAL);
        profile.getMetamodelReferences().add((Object)metamodelReference);
        return metamodelReference;
    }

    public static Stereotype createOwnedStereotype(Profile profile, String name, boolean isAbstract) {
        Stereotype ownedStereotype = (Stereotype)profile.createOwnedType(name, UMLPackage.Literals.STEREOTYPE);
        ownedStereotype.setIsAbstract(isAbstract);
        return ownedStereotype;
    }

    public static boolean isDefined(Profile profile) {
        EAnnotation eAnnotation = profile.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML");
        return eAnnotation != null && eAnnotation.getContents().size() > 0;
    }

    public static EPackage define(Profile profile) {
        EPackage definition;
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ECORE_TAGGED_VALUES", "PROCESS");
        options.put("DUPLICATE_FEATURES", "PROCESS");
        options.put("DUPLICATE_FEATURE_INHERITANCE", "PROCESS");
        Collection ePackages = ProfileOperations.convertToEcore(profile, options);
        EPackage ePackage = definition = ePackages.size() == 1 ? (EPackage)ePackages.iterator().next() : null;
        if (definition != null) {
            ProfileOperations.getEAnnotation((EModelElement)profile, (String)"http://www.eclipse.org/uml2/2.0.0/UML", (boolean)true).getContents().add(0, (Object)definition);
        }
        return definition;
    }

    public static EPackage getDefinition(Profile profile) {
        EList contents;
        EAnnotation eAnnotation = profile.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML");
        if (eAnnotation != null && (contents = eAnnotation.getContents()).size() > 0) {
            return (EPackage)contents.get(0);
        }
        return null;
    }

    protected static ENamedElement getDefinition(Profile profile, NamedElement namedElement, EPackage profileDefinition) {
        if (namedElement instanceof Classifier) {
            if (profileDefinition != null) {
                Iterator eClassifiers = profileDefinition.getEClassifiers().iterator();
                while (eClassifiers.hasNext()) {
                    EClassifier eClassifier = (EClassifier)eClassifiers.next();
                    EAnnotation eAnnotation = eClassifier.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML");
                    if (eAnnotation == null || !eAnnotation.getReferences().contains((Object)namedElement)) continue;
                    return eClassifier;
                }
            }
            return null;
        }
        if (namedElement instanceof Property) {
            ENamedElement namespaceDefinition = ProfileOperations.getDefinition(profile, namedElement.getNamespace(), profileDefinition);
            return namespaceDefinition instanceof EClass ? ((EClass)namespaceDefinition).getEStructuralFeature(ProfileOperations.getValidJavaIdentifier((String)namedElement.getName())) : null;
        }
        if (namedElement instanceof EnumerationLiteral) {
            ENamedElement namespaceDefinition = ProfileOperations.getDefinition(profile, namedElement.getNamespace(), profileDefinition);
            return namespaceDefinition instanceof EEnum ? ((EEnum)namespaceDefinition).getEEnumLiteral(namedElement.getName()) : null;
        }
        if (namedElement instanceof Package) {
            return namedElement == profile ? profileDefinition : null;
        }
        return null;
    }

    public static ENamedElement getDefinition(Profile profile, NamedElement namedElement) {
        return ProfileOperations.getDefinition(profile, namedElement, profile.getDefinition());
    }

    public static EList getReferencedMetaclasses(Profile profile) {
        UniqueEList.FastCompare referencedMetaclasses = new UniqueEList.FastCompare();
        Iterator metaclassReferences = profile.getMetaclassReferences().iterator();
        while (metaclassReferences.hasNext()) {
            PackageableElement importedElement = ((ElementImport)metaclassReferences.next()).getImportedElement();
            if (importedElement == null) continue;
            referencedMetaclasses.add((Object)importedElement);
        }
        return ECollections.unmodifiableEList((EList)referencedMetaclasses);
    }

    public static EList getReferencedMetamodels(Profile profile) {
        UniqueEList.FastCompare referencedMetamodels = new UniqueEList.FastCompare();
        Iterator metamodelReferences = profile.getMetamodelReferences().iterator();
        while (metamodelReferences.hasNext()) {
            Package importedPackage = ((PackageImport)metamodelReferences.next()).getImportedPackage();
            if (importedPackage == null) continue;
            referencedMetamodels.add((Object)importedPackage);
        }
        return ECollections.unmodifiableEList((EList)referencedMetamodels);
    }

    protected static EList getOwnedExtensions(Profile profile, boolean requiredOnly, EList ownedExtensions) {
        Iterator extensions = EcoreUtil.getObjectsByType((Collection)profile.getPackagedElements(), (EClassifier)UMLPackage.Literals.EXTENSION).iterator();
        while (extensions.hasNext()) {
            Extension extension = (Extension)extensions.next();
            if (requiredOnly && !extension.isRequired()) continue;
            ownedExtensions.add((Object)extension);
        }
        return ownedExtensions;
    }

    public static EList getOwnedExtensions(Profile profile, boolean requiredOnly) {
        return ECollections.unmodifiableEList((EList)ProfileOperations.getOwnedExtensions(profile, requiredOnly, (EList)new UniqueEList.FastCompare()));
    }
}

