/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.IncompatibleTypes;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.generic.GenericObjectType;
import edu.umd.cs.findbugs.ba.generic.GenericUtilities;
import edu.umd.cs.findbugs.ba.type.TopType;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class FindUnrelatedTypesInGenericContainer
implements Detector {
    private BugReporter bugReporter;
    private static final boolean DEBUG = SystemProperties.getBoolean((String)"gc.debug");
    private Map<String, int[]> collectionsMap = new HashMap<String, int[]>();
    String[] collectionMembers = new String[]{"java.util.Collection", "java.util.AbstractCollection", "java.util.List", "java.util.AbstractList", "java.util.ArrayList", "java.util.LinkedList", "java.util.Set", "java.util.SortedSet", "java.util.LinkedHashSet", "java.util.HashSet", "java.util.TreeSet"};
    String[] mapMembers = new String[]{"java.util.Map", "java.util.AbstractMap", "java.util.SortedMap", "java.util.TreeMap", "java.util.HashMap", "java.util.LinkedHashMap", "java.util.concurrent.ConcurrentHashMap", "java.util.EnumMap", "java.util.Hashtable", "java.util.IdentityHashMap", "java.util.WeakHashMap"};
    String[] listMembers = new String[]{"java.util.List", "java.util.AbstractList", "java.util.ArrayList", "java.util.LinkedList"};

    public static String getCollectionsMapKey(String[] triplet) {
        return triplet[0] + "??" + triplet[1] + "???" + triplet[2];
    }

    private void addToCollectionsMap(String className, String methodName, String methodSignature, int[] argumentParameterIndex) {
        this.collectionsMap.put(FindUnrelatedTypesInGenericContainer.getCollectionsMapKey(new String[]{className, methodName, methodSignature}), argumentParameterIndex);
    }

    private void addToCollectionsMap(String[] classNames, String methodName, String methodSignature, int[] argumentParameterIndex) {
        String[] arr$ = classNames;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String className = arr$[i$];
            this.addToCollectionsMap(className, methodName, methodSignature, argumentParameterIndex);
        }
    }

    public FindUnrelatedTypesInGenericContainer(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        String basicSignature = "(Ljava/lang/Object;)Z";
        String collectionSignature = "(Ljava/util/Collection<*>;)Z";
        String indexSignature = "(Ljava/lang/Object;)I";
        this.addToCollectionsMap(this.collectionMembers, "contains", basicSignature, new int[]{0});
        this.addToCollectionsMap(this.collectionMembers, "remove", basicSignature, new int[]{0});
        this.addToCollectionsMap(this.listMembers, "indexOf", indexSignature, new int[]{0});
        this.addToCollectionsMap(this.listMembers, "lastIndexOf", indexSignature, new int[]{0});
        this.addToCollectionsMap(this.mapMembers, "containsKey", basicSignature, new int[]{0});
        this.addToCollectionsMap(this.mapMembers, "containsValue", basicSignature, new int[]{1});
        this.addToCollectionsMap(this.mapMembers, "get", basicSignature, new int[]{0});
        this.addToCollectionsMap(this.mapMembers, "remove", basicSignature, new int[]{0});
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        Method[] arr$ = methodList = javaClass.getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String msg;
            Method method = arr$[i$];
            if (method.getCode() == null) continue;
            try {
                this.analyzeMethod(classContext, method);
                continue;
            }
            catch (MethodUnprofitableException e) {
                continue;
            }
            catch (CFGBuilderException e) {
                msg = "Detector " + this.getClass().getName() + " caught exception while analyzing " + javaClass.getClassName() + "." + method.getName() + " : " + method.getSignature();
                this.bugReporter.logError(msg, (Throwable)e);
                continue;
            }
            catch (DataflowAnalysisException e) {
                msg = "Detector " + this.getClass().getName() + " caught exception while analyzing " + javaClass.getClassName() + "." + method.getName() + " : " + method.getSignature();
                this.bugReporter.logError(msg, (Throwable)e);
            }
        }
    }

    public boolean prescreen(ClassContext classContext, Method method) {
        BitSet bytecodeSet = classContext.getBytecodeSet(method);
        return bytecodeSet != null && (bytecodeSet.get(185) || bytecodeSet.get(182) || bytecodeSet.get(183) || bytecodeSet.get(184) || bytecodeSet.get(183));
    }

    private boolean isSynthetic(Method m) {
        Attribute[] attrs;
        Attribute[] arr$ = attrs = m.getAttributes();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Attribute attr = arr$[i$];
            if (!(attr instanceof Synthetic)) continue;
            return true;
        }
        return false;
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        if (this.isSynthetic(method) || !this.prescreen(classContext, method)) {
            return;
        }
        BugAccumulator accumulator = new BugAccumulator(this.bugReporter);
        CFG cfg = classContext.getCFG(method);
        TypeDataflow typeDataflow = classContext.getTypeDataflow(method);
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return;
        }
        String fullMethodName = methodGen.getClassName() + "." + methodGen.getName();
        String sourceFile = classContext.getJavaClass().getSourceFileName();
        if (DEBUG) {
            System.out.println("Checking " + fullMethodName);
        }
        Iterator iter = cfg.locationIterator();
        while (iter.hasNext()) {
            int numArguments;
            GenericObjectType operand;
            Type objectType;
            Type operandType;
            InvokeInstruction inv;
            String[] itriplet;
            String[] triplet;
            Location location = (Location)iter.next();
            InstructionHandle handle = location.getHandle();
            Instruction ins = handle.getInstruction();
            if (!(ins instanceof InvokeInstruction) || (triplet = this.getRelevantTriplet(itriplet = this.getInstructionTriplet(inv = (InvokeInstruction)ins, cpg))) == null) continue;
            int[] argumentParameterIndex = this.collectionsMap.get(FindUnrelatedTypesInGenericContainer.getCollectionsMapKey(triplet));
            TypeFrame frame = typeDataflow.getFactAtLocation(location);
            if (!frame.isValid() || (operandType = (Type)frame.getTopValue()).equals((Object)TopType.instance()) || !((objectType = (Type)frame.getInstance((Instruction)inv, cpg)) instanceof GenericObjectType) || !(operand = (GenericObjectType)objectType).hasParameters() || (numArguments = frame.getNumArguments(inv, cpg)) <= 0 || argumentParameterIndex.length != numArguments) continue;
            boolean match = true;
            IncompatibleTypes[] matches = new IncompatibleTypes[numArguments];
            for (int i = 0; i < numArguments; ++i) {
                matches[i] = IncompatibleTypes.SEEMS_OK;
            }
            SignatureParser sigParser = new SignatureParser(inv.getSignature(cpg));
            for (int ii = 0; ii < numArguments; ++ii) {
                if (argumentParameterIndex[ii] < 0 || argumentParameterIndex[ii] >= operand.getNumParameters()) continue;
                ReferenceType parmType = operand.getParameterAt(argumentParameterIndex[ii]);
                Type argType = (Type)frame.getArgument(inv, cpg, ii, sigParser);
                matches[ii] = this.compareTypes((Type)parmType, argType);
                if (matches[ii] == IncompatibleTypes.SEEMS_OK) continue;
                match = false;
            }
            if (match) continue;
            SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction((ClassContext)classContext, (MethodGen)methodGen, (String)sourceFile, (InstructionHandle)handle);
            for (int i = 0; i < numArguments; ++i) {
                if (matches[i] == IncompatibleTypes.SEEMS_OK) continue;
                ReferenceType parmType = operand.getParameterAt(argumentParameterIndex[i]);
                if (parmType instanceof GenericObjectType) {
                    parmType = ((GenericObjectType)parmType).getUpperBound();
                }
                Type argType = (Type)frame.getArgument(inv, cpg, i, sigParser);
                accumulator.accumulateBug(new BugInstance((Detector)this, "GC_UNRELATED_TYPES", matches[i].getPriority()).addClassAndMethod(methodGen, sourceFile).addFoundAndExpectedType(argType.getSignature(), parmType.getSignature()).addCalledMethod(methodGen, (InvokeInstruction)ins), sourceLineAnnotation);
            }
        }
        accumulator.reportAccumulatedBugs();
    }

    private String[] getInstructionTriplet(InvokeInstruction inv, ConstantPoolGen cpg) {
        ConstantCP ref = (ConstantCP)cpg.getConstant(inv.getIndex());
        String className = ref.getClass(cpg.getConstantPool());
        ConstantNameAndType refNT = (ConstantNameAndType)cpg.getConstant(ref.getNameAndTypeIndex());
        String methodName = refNT.getName(cpg.getConstantPool());
        String methodSignature = refNT.getSignature(cpg.getConstantPool());
        return new String[]{className, methodName, methodSignature};
    }

    @CheckForNull
    private String[] getRelevantTriplet(String[] instructionTriplet) {
        if (this.collectionsMap.containsKey(FindUnrelatedTypesInGenericContainer.getCollectionsMapKey(instructionTriplet))) {
            return instructionTriplet;
        }
        if (Arrays.asList(this.mapMembers).contains(instructionTriplet[0]) && ("get".equals(instructionTriplet[1]) || "remove".equals(instructionTriplet[1]))) {
            this.addToCollectionsMap(instructionTriplet[0], instructionTriplet[1], instructionTriplet[2], new int[]{0});
            return instructionTriplet;
        }
        return null;
    }

    private IncompatibleTypes compareTypes(Type parmType, Type argType) {
        String argString;
        String parmString = GenericUtilities.getString((Type)parmType);
        if (parmString.equals(argString = GenericUtilities.getString((Type)argType))) {
            return IncompatibleTypes.SEEMS_OK;
        }
        String objString = GenericUtilities.getString((Type)Type.OBJECT);
        if (parmString.equals(objString) || argString.equals(objString)) {
            return IncompatibleTypes.SEEMS_OK;
        }
        GenericUtilities.TypeCategory parmCat = GenericUtilities.getTypeCategory((Type)parmType);
        GenericUtilities.TypeCategory argCat = GenericUtilities.getTypeCategory((Type)argType);
        if (parmCat == GenericUtilities.TypeCategory.PLAIN_OBJECT_TYPE && argCat == GenericUtilities.TypeCategory.PLAIN_OBJECT_TYPE) {
            return IncompatibleTypes.getPriorityForAssumingCompatible((Type)parmType, (Type)argType);
        }
        if (parmCat == GenericUtilities.TypeCategory.WILDCARD_EXTENDS || parmCat == GenericUtilities.TypeCategory.WILDCARD_SUPER) {
            return this.compareTypes(((GenericObjectType)parmType).getExtension(), argType);
        }
        if (parmCat == GenericUtilities.TypeCategory.TYPE_VARIABLE || argCat == GenericUtilities.TypeCategory.TYPE_VARIABLE) {
            return IncompatibleTypes.SEEMS_OK;
        }
        if (parmCat == GenericUtilities.TypeCategory.ARRAY_TYPE && argCat == GenericUtilities.TypeCategory.ARRAY_TYPE) {
            ArrayType parmArray = (ArrayType)parmType;
            ArrayType argArray = (ArrayType)argType;
            if (parmArray.getDimensions() != argArray.getDimensions()) {
                return IncompatibleTypes.ARRAY_AND_NON_ARRAY;
            }
            return this.compareTypes(parmArray.getBasicType(), argArray.getBasicType());
        }
        if (parmCat == GenericUtilities.TypeCategory.ARRAY_TYPE ^ argCat == GenericUtilities.TypeCategory.ARRAY_TYPE) {
            return IncompatibleTypes.ARRAY_AND_NON_ARRAY;
        }
        if (parmCat == GenericUtilities.TypeCategory.PARAMETERS && argCat == GenericUtilities.TypeCategory.PARAMETERS) {
            GenericObjectType parmGeneric = (GenericObjectType)parmType;
            GenericObjectType argGeneric = (GenericObjectType)argType;
            return this.compareTypes((Type)parmGeneric.getObjectType(), (Type)argGeneric.getObjectType());
        }
        if (parmCat == GenericUtilities.TypeCategory.WILDCARD) {
            return IncompatibleTypes.SEEMS_OK;
        }
        if (parmType instanceof BasicType || argType instanceof BasicType) {
            throw new IllegalArgumentException("checking for compatibility of " + parmType + " with " + argType);
        }
        return IncompatibleTypes.SEEMS_OK;
    }

    private boolean compareTypesOld(Type parmType, Type argType) {
        GenericObjectType o;
        if (GenericUtilities.getString((Type)parmType).equals(GenericUtilities.getString((Type)argType))) {
            return true;
        }
        if (parmType instanceof GenericObjectType && (o = (GenericObjectType)parmType).getTypeCategory() == GenericUtilities.TypeCategory.WILDCARD_EXTENDS) {
            return this.compareTypesOld(o.getExtension(), argType);
        }
        if (parmType instanceof GenericObjectType && !((GenericObjectType)parmType).hasParameters()) {
            return true;
        }
        if (argType instanceof GenericObjectType && !((GenericObjectType)argType).hasParameters()) {
            return true;
        }
        if (parmType instanceof GenericObjectType && argType instanceof GenericObjectType) {
            return true;
        }
        if (!(parmType instanceof ReferenceType) || !(argType instanceof ReferenceType)) {
            return true;
        }
        if (!(parmType instanceof ObjectType) || !(argType instanceof ObjectType)) {
            return true;
        }
        try {
            return Repository.instanceOf((String)((ObjectType)argType).getClassName(), (String)((ObjectType)parmType).getClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
    }

    public void report() {
    }
}

